   do yr= 2001,2020,1
     print("Processing year "+yr)
     infils = systemfunc("ls ERA5_power_150m_"+yr+".nc")
     fin    = addfiles(infils,"r")
     power  = fin[:]->power
     time0  = fin[:]->time
     power@_FillValue = 2.e+20
     replace_ieeenan(power, power@_FillValue, 0)
     
     time   = tofloat(time0)
     time!0 = "time"
     time&time = time
   
     printVarSummary(time)
     copy_VarAtts(time0,time)
     
     mskfils = systemfunc("ls AT???_isopop_era5.nc")     
     outfils = str_sub_str(mskfils,"isopop_era5","power_150m_"+yr+"_era5")
     
     ;print(outfils)
     
     nfiles = dimsizes(mskfils)               
     do nf  = 0, nfiles - 1
       fwgts = addfile(mskfils(nf),"r")
       fmask = fwgts->fmask
       ;Wghts = fwgts->Wghts
       indices = str_sub_str(fmask@cut_ind,",",":")
       y1 = stringtointeger(str_get_field(indices,1,":"))
       y2 = stringtointeger(str_get_field(indices,2,":"))
       x1 = stringtointeger(str_get_field(indices,3,":"))
       x2 = stringtointeger(str_get_field(indices,4,":"))
       power_raw = power(:,y1:y2,x1:x2)
       ;power_wgt = power_raw

       power_raw =  power_raw * conform(power_raw,fmask,(/1,2/))
       ;power_wgt =  power_wgt * conform(power_wgt,Wghts,(/1,2/))
       
       power_raw_avg = dim_avg_n_Wrap(power_raw,(/1,2/))
       ;power_wgt_avg = dim_sum_n_Wrap(power_wgt,(/1,2/))
       
       ;printVarSummary(power_raw_avg)
       ;printVarSummary(power_wgt_avg)
       
       fout = addfile(outfils(nf),"c")
       filedimdef(fout,"time",-1,True)
       
       fout->time=time
       fout->power=power_raw_avg
       ;fout->power=power_wgt_avg
       delete([/fmask,indices,power_raw,power_raw_avg/])
       print("Done region "+mskfils(nf))
     end do
     delete([/power,time0,time/])
   end do
   
