   do yr= 1981,2020,1
     print("Processing year "+yr)
     infils = systemfunc("ls ERA5_power_150m_"+yr+".nc")
     fin    = addfiles(infils,"r")
     power  = fin[:]->power
     time0  = fin[:]->time
     power@_FillValue = 2.e+20
     replace_ieeenan(power, power@_FillValue, 0)
     
     time   = tofloat(time0)
     time!0 = "time"
     time&time = time
   
     printVarSummary(time)
     copy_VarAtts(time0,time)
     
     mskfils = systemfunc("ls MRGID_*_at_era5.nc")     
     outfils = str_sub_str(mskfils,"at_era5","power_150m_"+yr+"_era5")
     
     ;print(outfils)
     
     nfiles = dimsizes(mskfils)               
     do nf  = 0, nfiles - 1
       fmskfil = addfile(mskfils(nf),"r")
       fmask0  = fmskfil->fmasK
       fmask0  = where(.not.ismissing(fmask0),1.0,fmask0@_FillValue)
       nnonm   = num(.not.ismissing(fmask0))
       printMinMax(fmask0,True)
       print("Non missing values of fmask are "+nnonm)
       if (nnonm .ge. 1) then
         cutind  = ind_resolve(ind(.not.ismissing(ndtooned(fmask0))),dimsizes(fmask0))
         ymn     = min(cutind(:,0)) 
         ymx     = max(cutind(:,0)) 
         xmn     = min(cutind(:,1)) 
         xmx     = max(cutind(:,1)) 
         power_raw = power(:,ymn:ymx,xmn:xmx)
         fmask     = fmask0(ymn:ymx,xmn:xmx)
         power_raw = power_raw * conform(power_raw,fmask,(/1,2/))
         nnonm   = num(.not.ismissing(power_raw(0,:,:)))
         print("Non missing values of power are "+nnonm)
         power_raw_avg = dim_avg_n_Wrap(power_raw,(/1,2/))
         delete([/fmask,power_raw,cutind/])
       else
         if (mskfils(nf) .eq. "MRGID_48998_at_era5.nc") then
           power_raw_avg = power(:,{35.9},{-5.4})
           print("48998 I am here for "+mskfils(nf)+"  "+nnonm)
         else
           power_raw_avg = power(:,{42.9},{17.6})
           print("22491 I am here for "+mskfils(nf)+"  "+nnonm)
         end if
       end if 
           
       fout = addfile(outfils(nf),"c")
       filedimdef(fout,"time",-1,True)
       
       fout->time=time
       fout->power=power_raw_avg
       ;fout->power=power_wgt_avg
       delete(power_raw_avg)
       print("Done region "+mskfils(nf))
     end do
     delete([/power,time0,time/])
   end do
   
