#! /usr/bin/env python3
import xarray as xr
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import matplotlib.colors as mpl
import glob
import geopandas as gpd
from joblib import Parallel, delayed
import os

def read_csv2(fname):
    df = pd.read_csv(fname, index_col = 0)
    return df

def write_csv(df, fname, float_format = "%.2f"):
    create_dir(os.path.dirname(fname))
    df.to_csv(fname, float_format = "%.2f")

def create_dir(path):
    try:
        #if not os.path.isdir(path):
        os.makedirs(path)
    except Exception as ex:
        print(ex)
        
def aggregate_to_nuts0(fname, weights):
    print(fname)
    if "popweight" in fname:
        wgt = weights["pop_density_sum"]
    elif "mean" in fname:
        wgt = weights["n_pixel"]
    elif "potential-area" in fname:
        wgt = weights["land"]
        
        
    out_file = fname.replace("NUTS2", "NUTS0")
    
    df = read_csv2(fname)
    
    wgt = wgt.reindex(df.columns).fillna(1)
    countries = df.columns.str[:2]
    
    var_wgt = (df*wgt).groupby(countries, axis=1).sum()
    wgt_sum = wgt.groupby(countries).sum()
    
    df_agg = var_wgt/wgt_sum
    
    write_csv(df_agg, out_file)
    
    return 0



weights = read_csv2("../Weights_NUTS0_agg/NUTS2_weights.csv")


data_dict = {
             "Radiation":("/path/to/Data_Final/Radiation/NUTS2_Europe/*/*3.1.csv"),
            }

flist_all = []
for var in data_dict:
    flist = sorted(glob.glob(data_dict[var]))
    flist_all += flist

num_cores = 16
parallel_input = [(in_file, weights) for in_file in flist_all]
Parallel(n_jobs=num_cores, verbose=10)(delayed(aggregate_to_nuts0)(*args) for args in parallel_input)       













