---
title: '10. Rückblick und Ausblick'
taxonomy:
    category:
        - docs
---

Vor 30 Jahren war es für Privatmenschen, für gewöhnliche Verbraucher:innen nahezu unmöglich, gegen das Urheberrecht zu verstoßen. Bücher und Videokassetten mussten erworben werden. Fernsehsendungen durften aufgezeichnet, Videokassetten kopiert werden. Bücher konnten aus Bibliotheken geliehen und dort auch einzelne Seiten aus ihnen kopiert werden. Bibliothekstantieme und Geräteabgaben sorgten für einen Ausgleich der Interessen mit den Inhaber:innen von Urheberrechten, ohne dass sich die Privatmenschen im Alltag darum Gedanken machten.

Auch in der Wissenschaft stieß man kaum an die Grenzen dessen, was urheberrechtlich erlaubt war. Die heute so kompliziert anmutenden „Schrankenbestimmungen“ ermöglichten in Forschung und Lehre das damals technisch Mögliche auch rechtlich. Dort, wo es Interessengegensätze gab – wie zwischen Verlagen und Bibliotheken – wurden sie durch Regelungen gelöst, die den wissenschaftlichen Alltag nicht beeinträchtigt haben. Urheberrecht war ein Rechtsbereich, der nur wenige betraf, die beruflich mit Kulturproduktionen befasst waren – wie Schriftsteller:innen, Verleger:innen, Plattenlabels oder Filmproduzent:innen.

Mit dem, was unter dem schillernden Begriff der Digitalisierung umschrieben wird, wurde dies anders.

Für ein Urheberrecht, das Verwertungsmodelle ermöglicht, die auf der Kontrolle von Kopien aufbauten, waren die neuen Technologien, die auf Kopieren als notwendigen technischen Vorgang bei jedem Gebrauch aufbauten, eine große Herausforderung. Die Anpassungen des Rechts waren in erster Linie von dem Versuch geprägt, einer unkontrollierten Verbreitung von Inhalten entgegenzuwirken.

Die Wissenschaft dagegen hatte die neuen technischen Möglichkeiten früh als große Chance entdeckt, insbesondere die des Internets. In der [Berliner Erklärung von Oktober 2003](https://openaccess.mpg.de/Berliner-Erklaerung), die von allen wichtigen Wissenschaftsorganisationen unterzeichnet wurden, heißt es in den Vorbemerkungen (Preface):

> „Das Internet hat die praktischen und wirtschaftlichen Bedingungen für die Verbreitung von wissenschaftlichem Wissen und kulturellem Erbe grundlegend verändert. Mit dem Internet ist zum ersten Mal die Möglichkeit einer umfassenden und interaktiven Repräsentation des menschlichen Wissens, einschließlich des kulturellen Erbes, bei gleichzeitiger Gewährleistung eines weltweiten Zugangs gegeben.“

Die Digitalisierung führte zu großen gesellschaftlichen, politischen, wirtschaftlichen und letztendlich auch rechtlichen Veränderungen. Dies gilt auch für die audiovisuellen Medien. Die Produktions- und Distributionsbedingungen für Filme haben sich in den letzten 20 Jahren grundlegend geändert. Mit populären Internet-Plattformen wie [YouTube](https://www.youtube.com/) haben audiovisuelle Erzeugnisse von Privaten eine Öffentlichkeit bekommen, die sie zuvor nie hatten. Über Video-on-Demand-Plattformen ist heute eine früher unvorstellbare Bandbreite an Filmen verfügbar. Streaming-Plattformen wie [Netflix](https://www.netflix.com) haben sowohl Verwertungsmodelle als auch Rezeptionsgewohnheiten verändert. Nicht mehr der konkrete eigene Film, vielmehr der Zugang zu einer großen Auswahl von Filmen wird vermarktet. Die Auswirkungen dieser Veränderungen zu beschreiben und zu analysieren, wird ganze Generationen von Wissenschaftlern beschäftigen.

Das Recht, insbesondere das Urheberrecht, wird indes nur langsam an diese schnellen Veränderungen angepasst. Diese Anpassungen gehen mit erheblichen öffentlichen und politischen Auseinandersetzungen einher. Dadurch entsteht eine Ungleichzeitigkeit, und es kommt in einigen Bereichen auch zu einem Auseinanderfallen von Recht und Wirklichkeit. Ein Beispiel wären Mashups, die in Deutschland rechtlich lange unzulässig, aber doch geduldet waren. Erst die Einführung der neuen Regelung zu Pastiches legalisierte eine lange bestehende soziale Praxis, wobei die genau Reichweite des Rechts hier immer noch umstritten ist. Ein anderes Beispiel ist die Verwertung von älteren Filmen in neuen Nutzungsformen, die eine kaum mögliche nachträgliche Klärung der Rechte der Beteiligten erfordert, die aber durch die Filmwirtschaft gleichwohl vorgenommen wird. Gleiches gilt für verwaiste Werke. Hier hat Risikomanagement die Rechteklärung ersetzt. Bei einer rein juristischen Betrachtung ist dies unzulässig, jede Nutzung eines urheberrechtlich geschützten Werkes ohne die Einwilligung der Rechteinhaber:innen sogar strafbar, sofern nicht ausnahmsweise eine gesetzliche Bestimmung (Schranke) dies erlaubt.

So hat das Recht große Auswirkungen auf die Rezeption. Es hat Auswirkungen darauf, was von dem enormen Reichtum des audiovisuellen Erbes im kollektiven Gedächtnis verbleibt. Und es hat auch Auswirkungen darauf, was von jetzt entstehenden bewegten Bildern überhaupt von wem rezipiert wird. Das Recht in Hinblick auf audiovisuelle Materialien ist damit keine Angelegenheit, mit der sich ausschließlich Jurist:innen befassen sollten – auch film- und medienwissenschaftlich gilt es, dieses Thema zu beleuchten. Auch für Historiker:innen sind audiovisuelle Materialien wichtige Quellen. Und das Ringen um die rechtlichen Rahmenbedingungen von Filmen im Speziellen und des Urheberrechts im Allgemeinen hat längst über Expert:innenkreise hinaus Bedeutung gewonnen.

Die geltenden rechtlichen Rahmenbedingungen in der Wissenschaft wurden in dieser Untersuchung näher erläutert. Nach den Reformen durch das UrhWissG sowie der Umsetzung der DSM-Richtlinie ist vorerst nicht zu erwarten, dass es sehr bald weitere grundlegende Änderungen gibt. Allerdings ist möglich und auch wünschenswert, dass Evaluierungen der Änderungen dazu führen könnten, dass einzelne Details modifiziert werden, um unbeabsichtigte Effekte der Gesetzgebung zu korrigieren.

Ansonsten gilt weiterhin:

> „Tempora mutantur, nos et mutamur in illis. Die Zeiten ändern sich. Und wir uns in ihnen (Ovid). Das gilt. Auch für den Film. Auch für die Wissenschaft. Auch für das Recht. Doch die Geschwindigkeiten sind unterschiedlich.“

[format-annotation]
Um die Wissenschaft erweitertes Zitat aus Klimpel, Paul: Einleitung – Tempora Mutantur, in: Klimpel, Paul (Hg.): Bewegte Bilder – starres Recht? Das Filmerbe und seine rechtlichen Rahmenbedingungen, Berlin 2011, S. 6.
[/format-annotation]
