---
title: '6.11. Nicht verfügbare Werke* '
taxonomy:
    category:
        - docs
---

Eine weitere Möglichkeit für Kulturerbe-Einrichtungen, Filme online zugänglich zu machen, sind die Regelungen zu den „nicht verfügbaren Werken“. Damit sind alle Werke gemeint, die nicht über die „üblichen Vertriebswege“ erhältlich sind. Da sich in Archiven und Mediatheken auch viele Filme oder Filmfragmente befinden, die man nicht (mehr) kommerziell vertreiben werden, wird durch diese Neuregelung die weitgehende Onlinestellung dieser (urheberrechtlich geschützten) Bestände ermöglicht. Damit wird eine neue zentrale Norm für die Online-Aktivitäten von Kulturerbe-Einrichtungen gesetzt.

### 6.11.a Neuregelung in Deutschland

Grundlage für die Regelung in Deutschland, die die Kulturerbe-Einrichtungen die Online-Stellung von „nicht verfügbaren Werken“ erlaubt, ist die [DSM-Richtlinie](https://eur-lex.europa.eu/legal-content/DE/TXT/PDF/?uri=CELEX:32019L0790). Dort wurde festgelegt, dass Kulturerbe-Einrichtungen „vergriffene Werke“ (Out-of-Commerce Works) unter bestimmten Umständen online stellen dürfen. Dabei lag der Richtlinie ein sehr weites Verständnis von „vergriffenen Werken“ zugrunde. In Erwägungsgrund 30 der Richtlinie heißt es, die Regelung solle auch für solche Werke gelten, die „ursprünglich nicht für gewerbliche Zwecke gedacht waren oder niemals gewerblich genutzt wurden“. In Erwägungsgrund 37 werden beispielhaft „Plakate, Faltblätter, Schützengrabenzeitungen oder von Laien geschaffene audiovisuelle Werke, aber auch unveröffentlichte Werke oder sonstige Schutzgegenstände“ aufgeführt. Insofern ist die in der Richtlinie gebrauchte Bezeichnung „Out-of-Commerce Works“ unglücklich gewählt.

Der deutsche Gesetzgeber dagegen hat diesem sehr weiten Verständnis von „Out-of-Commerce Works“ Rechnung getragen, indem er diese Werke im Urheberrecht als „nicht verfügbare“ bezeichnet. Die bisher auch im rechtspolitischen Diskurs verwendete Bezeichnung der „vergriffenen Werke“ wurde fallen gelassen, obwohl dies eine wörtliche Übersetzung der Richtlinie gewesen wäre.

### 6.11.b Keine repräsentative Verwertungsgesellschaft für Filme

Die Regelung im Urheberrecht unterscheidet – wie bereits zuvor die Richtlinie – zwischen Werken, für die es eine repräsentative Verwertungsgesellschaft gibt und solchen, wo dies nicht der Fall ist.

Sofern repräsentative Verwertungsgesellschaften bestehen, müssen mit diesen Lizenzvereinbarungen über die Nutzung der nicht verfügbaren Werke geschlossen werden. Sowohl der europäische als auch der deutsche Gesetzgeber gingen davon aus, dass eine solche Lizenzierung durch Verwertungsgesellschaften der Normalfall seien. Allerdings hat man für den Fall, dass es keine repräsentative Verwertungsgesellschaft gibt, gleichwohl für Kulturerbe-Einrichtungen eine gesetzliche Erlaubnis geschaffen. Angesichts der zahlreichen Materialien insbesondere in Archiven, die nicht aus professioneller Kulturproduktion stammen (Akten, Berichte usw.) ist zumindest quantitativ zweifelhaft, ob die Materialien, für die es repräsentative Verwertungsgesellschaften gibt, tatsächlich die Mehrheit ausmachen.

Hinzu kommt, dass es auch für einige Werke aus professioneller Kulturproduktion keine repräsentativen Verwertungsgesellschaften gibt. Dies gilt insbesondere für Filme. Zwar ist es so, dass nahezu alle Verwertungsgesellschaften zumindest einige für die Filmproduktion notwendigen Bereiche vertreten. Was die Musik angeht, werden die Verfilmungsrechte zwar in der Regel durch die jeweiligen Plattenlabel oder Künstler und nicht durch die GEMA wahrgenommen. Doch in bestimmten Bereichen lizenziert die GEMA auf Musik für audiovisuelle Produktionen und lässt sich seit 2022 auch das [Verfilmungsrecht für User Generated Content](%20https://www.gema.de/de/musikurheber/online-services/herstellungsrecht-ugc-plattformen) übertragen. Die [GVL](https://gvl.de/) vertritt die ausübenden Künstler und mithin auch Schauspieler, Tänzer und Musiker, die bei einer Filmproduktion mitwirken. Die [VG Wort](https://www.vgwort.de/) hat eine Zuständigkeit für die vorbestehenden Werke, als ggf. den verfilmten Roman oder das Drehbuch, nimmt allerdings nur die sogenannten „kleinen Senderechte“ sowie die Einnahmen aus der Geräte- und Speichemedienvergütung sowie Wiedergabe in Hotels, Gaststätten und Krankenhäuser wahr, nicht aber das Verfilmungsrecht als solches. Die [VG Bild-Kunst](https://www.bildkunst.de/homepage) vertritt auch Regisseur:innen, die [Verwertungsgesellschaft für Film- und Fernsehproduzenten mbH](https://www.vff.org/startseite.html) (VFF) vertritt eben diese Produktionen. Mit der [VGF](https://www.vgf.de/) gibt es eine Verwertungsgesellschaft für Filmwerke, die [GWFF](https://www.gwff.de/) ist eine Verwertungsgesellschaft von Film und Fernsehrechten. Auch die [AGICOA](https://www.agicoa.de/) ist eine Verwertungsgesellschaft für Bewegtbild, bezogen auf Kabelsendungen. [Corint Media](https://www.corint-media.com/) vertritt ganz allgemein Medienproduktionen, [TWF](https://twf-gmbh.de/) speziell den Werbefilm und die [GÜFA](https://www.guefa.de/) erotische und pornografische Filme.

Allenfalls bei TWF und GÜFA ist eine Repräsentativität für das von ihr vertretene Segment denkbar, wobei sich zumindest die GÜFA nach eigenem Selbstverständnis unzuständig für nicht verfügbare Werke sieht (so die nicht veröffentlichte Antwort auf eine Anfrage der Autoren. Bei anderen Filmproduktionen indes gilt, dass es verschiedene, oft konkurrierende Verwertungsgesellschaften gibt. Von einer einzelnen, repräsentativen Verwertungsgesellschaft für den Film generell kann deshalb nicht ausgegangen werden.

### 6.11.c Registrieren und Frist zur Nutzung

Die Nutzung, also die Online-Stellung von Filmen ist erst zulässig, wenn das der Film sechs Monate vorher in einem beim Europäischen Amt für Geistiges Eigentum geführten Portal für vergriffene Werke registriert und öffentlich angezeigt wurde (Achtung, das Portal verwendet den Begriff der „vergriffenen Werke” als Übersetzung aus dem Englischen – es gibt aber keine inhaltliche Differenz zu den Werken, die im UrhG als „nicht verfügbar” bezeichnet werden). Damit soll sichergestellt werden, dass Rechteinhaber:innen bereits im Vorfeld der Online-Stellung eines Werkes durch eine Kulturerbe-Einrichtung widersprechen können. Denn keine Nutzung soll gegen den Willen der Rechteinhaber:innen erfolgen. Auch nach Online-Stellung können Rechteinhaber:innen noch jederzeit widersprechen und das auf dem Portal geführte Register enthält die notwendigen Informationen, damit dieser Widerspruch auch erfolgreich ist.

[figure caption="Screenshot des Portals für vergriffene Werke der EUIPO mit Filmaufnahmen zur Feier des 1. Mai 1933, die das Bundesarchiv dort registriert hat. Achtung! Die Datenbanken für vergriffene und für verwaiste Werke sind nicht miteinander verknüpft!"]
![](nicht%20verfuegbare%20werke.jpg)
[/figure]

Da es für den Film keine repräsentative Verwertungsgesellschaft gibt, erfolgt die Registrierung durch die Kulturerbe-Einrichtung direkt.

### 6.11.d Erstveröffentlichungen

Bei professionellen Filmproduktionen kommt es wohl nur extrem selten vor, dass Filme, die in Kulturerbe-Einrichtungen bewahrt werden, noch nicht veröffentlicht wurden. Anders sieht es hingegen bei Privataufnahmen aus, die ja unter Umständen auch von großem historischen Interesse sind. Hier stellt sich die Frage, ob die Erstveröffentlichung solchen Materials aus urheberpersönlichkeitsrechtlichen Gründen unzulässig ist. Unter Umständen kann in der freiwilligen Übergabe an ein öffentliches Archiv auch eine (konkludente) Zustimmung zur Veröffentlichung gesehen werden. Dies ist aber eine Frage des Einzelfalls und kann nicht generell angenommen werden.

Diskussionsbedürftig erscheint darüber hinaus zu sein, wie lange eine solche Rücksichtnahme auf die Persönlichkeitsrechte der Urheber geboten ist. Die Verordnung über ergänzende Bestimmungen zur Nutzung nicht verfügbarer Werke nach dem Urheberrechtsgesetz und dem Verwertungsgesellschaftengesetz ([NvWV](https://www.recht.bund.de/bgbl/1/2023/65/regelungstext.pdf?__blob=publicationFile)) enthält hierzu in § 3 Abs. 2 eine widerlegliche Vermutung, indem sie [§ 11 des Bundesarchivgesetz](https://www.gesetze-im-internet.de/barchg_2017/__11.html) (und damit auf eine Frist von 10 Jahre ab dem Tod) verweist, sofern nicht konkrete Anhaltspunkte dafür bestehen, dass der Urheber von einer Veröffentlichung des Werkes absehen wollten (§ 3 Abs. 3 der Verordnung).

### 6.11.e **Kooperationsprojekte, Plattformen**

Ein weiteres Problem bei der Regelung zu den nicht verfügbaren Werken ist, dass nur eine einzelne, isolierte „Kulturerbe-Einrichtung“ die nicht verfügbaren Werke „aus ihrem Bestand“ online stellen darf. Die Praxis von Digitalisierungsprojekten beim kulturellen Erbe weicht jedoch häufig von diesem gesetzgeberischen Idealbild ab. Denn oft digitalisieren nicht einzelne Einrichtungen isoliert ihre jeweiligen Bestände. Vielmehr schließen sich (gerade kleine) Einrichtungen zu Verbünden oder Portalen zusammen. Vielfach bauen sie auch eine gemeinsame Infrastruktur für die öffentliche Zugänglichmachung auf und organisieren Digitalisierungsvorhaben arbeitsteilig. Die Struktur solcher Zusammenschlüsse ist unterschiedlich, in einigen Fällen wird eine eigene juristische Person dafür geschaffen.

Auch ist es für eine Kooperation von Kulturerbe-Einrichtungen mit der [Deutschen Digitalen Bibliothek](https://www.deutsche-digitale-bibliothek.de/) (DDB) derzeit erforderlich, dass der DDB bestimmte Rechte ausdrücklich eingeräumt werden. Dies hat zur Folge, dass Filme, für die es keine repräsentative Verwertungsgesellschaft gibt, die etwas anderes lizenzieren könnte, zwar von einzelnen Einrichtungen online gestellt werden dürften, nicht aber in die DDB übernommen werden könnten.

[format-annotation]
*Dieses Kapitel beruht auf dem Text “[Urheberrechtsreform 2021, Neue Chancen für das kulturelle Erbe](https://opus4.kobv.de/opus4-zib/frontdoor/index/index/docId/8431), hrsg. von DigiS Forschung- und Kompetenzzentrum Digitalisierung und Digitales Deutsches Frauenarchiv, getragen vom Ida Dachverband e. V., Berlin, Oktober 2021, der aktualisiert, ergänzt und auf die spezifischen Aspekte audiovisueller Materialien zugeschnitten wurde.
[/format-annotation]
