---
title: '6.10. Verwaiste Werke'
taxonomy:
    category:
        - docs
media_order: verwaiste_werke.jpg
---

Filme werden in der Regel produziert, um kommerziell vermarktet zu werden. Allerdings kommt es bei Filmen – wie auch bei anderen Erzeugnissen der Kulturwirtschaft – häufig vor, dass sich nach einer bestimmten Zeit kein Markt mehr für eine kommerzielle Verwertung findet. Dies gilt nicht nur für das Kino, sondern auch für andere Formen der Auswertungskaskade wie Fernsehen, VoD und Streaming bzw. Video oder DVD. Die fehlende Möglichkeit kommerzieller Verwertung führt häufig auch dazu, dass Informationen über die Rechtesituation verloren gehen. Um jedoch auch Filme zugänglich machen zu können, die zwar einen kulturhistorischen Wert haben, bei dem die Rechteinhaber:innen aber unbekannt sind, wurde die Regelung zu verwaisten Werken geschaffen.

Als „verwaist“ werden veröffentlichte Werke bezeichnet, bei denen die Inhaber:innen der Urheberrechte nicht bekannt oder nicht auffindbar sind. Diese Situation kommt auch beim Film vor. Durch die zahlreichen Beteiligten ist insbesondere auch die Situation häufig, dass nur bestimmte, für die Nutzung des Films notwendigen Rechte nicht geklärt werden können. Ein Beispiel wäre, wenn die Rechte zahlreicher Beteiligter geklärt werden, aber einer der Beteiligten – etwa der Regisseur oder der Kameramann nicht auffindbar ist. Dann spricht man von „teilverwaisten Werken“. Die Folge davon ist zunächst, dass niemand eine Lizenz für die Nutzung solcher Werke erteilen kann.

Im deutschen Urheberrecht existiert seit 2014 eine Regelung, die bestimmte Nutzungen sogenannter „verwaister Werke“ erlaubt.<sup>1</sup> Nach dieser neuen, auf einer EU-Richtlinie aufbauenden Norm dürfen öffentlich zugängliche Bibliotheken, Bildungseinrichtungen, Museen, Archive sowie Einrichtungen im Bereich des Film- oder Tonerbes verwaiste Werke aus ihren Sammlungen vervielfältigen und online zugänglich machen, wenn sie:

1.  vor der Nutzung eine vergebliche sogenannte „sorgfältige Suche“ nach den Rechteinhaber:innen durchgeführt,
2.  diese Suche dokumentiert und
3.  das betroffene Werk dann als verwaist gemeldet haben ([§ 61 Urhg](https://www.gesetze-im-internet.de/urhg/__61.html)).

Die Anforderungen an eine sorgfältige Suche, wie sie im Rahmen dieser Bestimmung durchgeführt werden muss, sind hoch. Zunächst einmal darf die Recherche nicht einheitlich für Konvolute oder bestimmte Sammlungen ausgeführt werden, sondern dies muss für jedes Werk einzeln erfolgen [(§ 61a UrhG](https://www.gesetze-im-internet.de/urhg/__61a.html)). Dies bedeutet zum Beispiel, dass bei einer Zeitung für jeden einzelnen Artikel recherchiert werden muss. Es muss mindestens eine Liste von Quellen geprüft werden, die in der Anlage zur gesetzlichen Regelung aufgeführt sind.<sup>2</sup> Die Quellen, die jeweils einzusehen sind, sind je nach Medium verschieden.

Für Filmwerke sowie für Bildträger und Bild- und Tonträger, auf denen Filmwerke aufgenommen sind, und für Tonträger sind die folgend aufgeführten Quellen zu prüfen:

1.  die Depots amtlich hinterlegter Pflichtexemplare, insbesondere der Katalog der [Deutschen Nationalbibliothek](https://www.dnb.de);
2.  Informationen der Produzentenverbände;
3.  die Informationen der Filmförderungseinrichtungen des Bundes und der Länder;
4.  die Datenbanken von im Bereich des Film- oder Tonerbes tätigen Einrichtungen und nationalen Bibliotheken, insbesondere des [Kinematheksverbunds](https://kvb.deutsche-kinemathek.de/), des [Bundesarchivs](https://www.bundesarchiv.de), der [Stiftung Deutsche Kinemathek](https://www.deutsche-kinemathek.de/), des [DFF](https://www.dff.film/) – Deutsches Filminstitut & Filmmuseum (Datenbank und Katalog [www.filmportal.de](http://www.filmportal.de)), der [DEFA-Stiftung](https://www.defa-stiftung.de/) und der [Friedrich-Wilhelm-Murnau-Stiftung](https://www.murnau-stiftung.de/), sowie die Kataloge der [Staatsbibliothek zu Berlin](https://staatsbibliothek-berlin.de) und der [Bayerischen Staatsbibliothek](https://www.bsb-muenchen.de);
5.  Datenbanken mit einschlägigen Standards und Kennungen wie [ISAN](https://www.isan.org/) (International Standard Audiovisual Number) für audiovisuelles Material, [ISWC](https://www.iswc.org/) (International Standard Music Work Code) für Musikwerke und [ISRC](https://isrc.ifpi.org) (International Standard Recording Code) für Tonträger;
6.  die Datenbanken der entsprechenden Verwertungsgesellschaften (siehe auch [Kapitel 6.11.b](/6-gesetzliche-erlaubnisse/6-11#6-11-b-keine-repräsentative-verwertungsgesellschaft-für-filme)), insbesondere für Autoren, ausübende Künstler sowie Hersteller von Tonträgern und Filmwerken;
7.  die Aufführung der Mitwirkenden und andere Informationen auf der Verpackung des Werks oder in seinem Vor- oder Abspann;
8.  die Datenbanken anderer maßgeblicher Verbände, die eine bestimmte Kategorie von Rechtsinhaber:innen vertreten, wie die Verbände der Regisseur:innen, Drehbuchautor:innen, Filmkomponist:innen, Komponist:innen, Theaterverlage, Theater- und Opernvereinigungen.

Die Suche nach den Rechteinhaber:innen muss in dem Mitgliedsstaat der Europäischen Union durchgeführt werden, in dem das Werk zuerst veröffentlicht wurde. Bei Hinweisen zu relevanten Informationen in anderen Staaten müssen auch in diesen Staaten verfügbare Informationsquellen abgefragt werden ([§ 61a Abs. 1 UrhG](https://www.gesetze-im-internet.de/urhg/__61a.html)). Bei Filmwerken sowie bei Bildträgern und Bild- und Tonträgern, auf denen Filmwerke aufgenommen sind, ist die sorgfältige Suche in dem Mitgliedstaat der Europäischen Union durchzuführen, in dem der Hersteller seine Hauptniederlassung oder seinen gewöhnlichen Aufenthalt hat ([§ 61a Abs. 2 UrhG](https://www.gesetze-im-internet.de/urhg/__61a.html)).

Nach der Suche nach den Rechteinhaber:innen folgt ein Verfahren der Registrierung beim Deutschen Patent- und Markenamt. Dabei müssen sowohl das jeweilige Werk als auch die nutzende Institution, die Art der Nutzung sowie genaue Kontaktinformation angegeben werden. Das Deutsche Patent- und Markenamt gibt diese Informationen an das europäische Harmonisierungsamt für den Binnenmarkt weiter ([§ 61a Abs. 4 UrhG](https://www.gesetze-im-internet.de/urhg/__61a.html)).

Zu beachten ist, dass dieses Verfahren keine Gewähr dafür bietet, die digitalisierten Werke später unbegrenzt nutzen zu dürfen. Sollten später Rechteinhaber:innen auftauchen, können sie verlangen, die Nutzung unverzüglich zu unterlassen. Sie haben darüber hinaus einen Anspruch auf Zahlung einer angemessenen Vergütung ([§ 61b UrhG](https://www.gesetze-im-internet.de/urhg/__61b.html)).

Außerdem können nach der Regelung zu verwaisten Werken nur die Online-Nutzungen sowie die Vervielfältigung, nicht hingegen andere Nutzungen wie die Ausstellung oder öffentliche Vorführung gerechtfertigt werden. Filme beispielsweise dürfen zwar ins Internet oder in Netzwerke gestellt werden, aber nicht in Ausstellungen oder im Kino vorgeführt werden. Auch ein Screening in einer Vorlesung an der Universität wäre als öffentliche Vorführung unzulässig.

Die verwaisten Werke dürfen zudem nur zusammenhängend genutzt werden. Sind in den jeweiligen verwaisten Werken weitere abgegrenzte Werke enthalten, wie etwa Abbildungen in einem Buch, reicht der verwaiste Status des Buches nicht aus, um die Abbildungen separat zu nutzen. Dafür bedarf es anderer Erlaubnisse oder Schrankenregelungen, wie des Zitatrechts.

Schließlich sind die Vervielfältigung und die öffentliche Zugänglichmachung durch die Institutionen nur zulässig, wenn sie zur Erfüllung ihrer im Gemeinwohl liegenden Aufgaben handeln, insbesondere wenn sie Bestandsinhalte bewahren und restaurieren und den Zugang zu ihren Sammlungen eröffnen, sofern dies kulturellen und bildungspolitischen Zwecken dient. Die Institutionen dürfen aber für den Zugang zu den genutzten verwaisten Werken ein Entgelt verlangen, das die Kosten der Digitalisierung und der öffentlichen Zugänglichmachung deckt ([§ 61 Abs. 5 UrhG](https://www.gesetze-im-internet.de/urhg/__61.html)).

In der Praxis spielen die Regelungen zu verwaisten Werken nur eine geringe Rolle. Die relativ hohen Anforderungen an eine sorgfältige Suche und deren Dokumentation, verbunden mit dem Risiko, Werke bei Widerspruch der Rechteinhaber:innen nicht weiter nutzen zu können und ggf. sogar Vergütungen zu zahlen, wirken auf die meisten Kulturerbe-Einrichtungen abschreckend. Allerdings gibt es im Portal der EUIPO für verwaiste Werke auch eine Reihe von Filmwerken.

[figure caption="Im Portal für verwaiste Werke des EUIPO, des Europäischen Büros für Geistiges Eigentum, sind inzwischen auch eine Reihe von Filmwerken verzeichnet, auch aus Deutschland."]
![](verwaiste_werke.jpg)
[/figure]

[format-annotation]
<sup>1</sup> [Klimpel, Paul / Rack, Fabian / Weitzmann, John H.: Handreichung – Neue rechtliche Rahmenbedingungen für Digitalisierungsprojekte von Gedächtnisinstitutionen, Berlin 2017](https://www.digis-berlin.de/wissenswertes/recht13/), S. 22 ff.  
<sup>2</sup> [Urheberrechtsgesetz, Anlage (zu § 61a)](https://www.gesetze-im-internet.de/urhg/anlage__zu___61a_.html) Quellen einer sorgfältigen Suche, BGBl. I 2013, 3731–3732.
[/format-annotation]
