---
title: '6.8. Terminalnutzung'
taxonomy:
    category:
        - docs
---

### 6.8. Terminalnutzung

Ursprünglich zum Schutz von Beständen, die aus konservatorischen Gründen nicht (mehr) im Original genutzt werden konnten, wurde 2007 eine Bestimmung für Bibliotheken und Archive zur Wiedergabe ihrer Bestände an „elektronischen Leseplätzen“ geschaffen. Diese Bestimmung wurde 2017 durch das UrhWissG in [§ 60e Abs. 4](https://www.gesetze-im-internet.de/urhg/__60e.html) integriert, wobei im Zuge dieser Neustrukturierung auch der missverständliche Begriff des „Leseplatzes“ – der immer schon auch die Nutzung von audiovisuellen Medien umfasste, die ja nicht im engen Wortverständnis „gelesen“ werden – durch den passenderen Begriff „Terminal“ ersetzt.

Danach dürfen öffentlich zugängliche Bibliotheken, Museen und Archive, die keine kommerziellen Zwecke verfolgen, in ihren eigenen Räumen an eigens dafür eingerichteten Terminals veröffentlichte Werke aus ihrem Bestand zur Forschung und für private Studien öffentlich zugänglich machen.<sup>1</sup> Dies erfasst auch audiovisuelle Materialien. So können beispielsweise auch Filme an Terminals bereitgestellt werden.

Die Terminals müssen eigens dafür eingerichtet werden und sich in den Räumen der jeweiligen Einrichtung befinden. Dadurch soll sichergestellt werden, dass die Nutzung tatsächlich nur in den Bibliotheken, Museen und Archiven stattfindet. Die Nutzer:innen sollen nicht von außerhalb auf die Werke zugreifen können. Dies gilt auch für Zugriffe mittels eines VPN-Clients<sup>2</sup>, also einer gesicherten Verbindung.

Die Werke dürfen nur zur Forschung und für private Studien der Nutzer:innen an den Leseterminals zugänglich gemacht werden. Damit ist der Zweck, den die Leser:innen verfolgen, maßgeblich, nicht der Zweck der bereitstellenden Institution.<sup>3</sup> Allerdings wird sich dies in der Praxis kaum nachprüfen lassen, sodass der Zweckbestimmung im Gesetz keine nennenswerte Bedeutung zukommt.<sup>4</sup> Die Einrichtungen sollen aber vermeiden, dass die Nutzer:innen davon ausgehen, die Werke dürften auch zu anderen Zwecken genutzt werden, und sollen darauf gegebenenfalls in ihren Allgemeinen Geschäftsbedingungen hinweisen.<sup>5</sup>

Grundsätzlich dürfen dem Bereitstellen an Terminals keine vertraglichen Regelungen entgegenstehen, die ausschließlich die Zugänglichkeit an Terminals zum Gegenstand haben, [§ 60g Abs. 2 UrhG](https://www.gesetze-im-internet.de/urhg/__60g.html). Diese gesetzliche Erlaubnis zur Terminalnutzung kann daher auch nicht gegenüber technischen Schutzmaßnahmen durchgesetzt werden<sup>6</sup>, wie sie häufig mit kommerziellen Angeboten verbunden sind.

Die Einrichtungen sind auch berechtigt, die Werke selbst zu digitalisieren, bevor sie an Terminals zur Verfügung gestellt werden. Die Annexkompetenz in Hinblick auf die dafür notwendige Vervielfältigung ergibt sich aus [§ 60e Abs. 1 UrhG](https://www.gesetze-im-internet.de/urhg/__60e.html).<sup>7</sup>

Die Befugnis von Bibliotheksnutzer:innen, Kopien an Terminals zu machen, ist indes eingeschränkt. Bibliotheken dürfen ihnen pro Sitzung nur ermöglichen, bis zu „10 Prozent eines Werkes sowie von einzelnen Abbildungen, Beiträgen aus derselben Fachzeitschrift oder wissenschaftlichen Zeitschrift, sonstigen Werken geringen Umfangs und vergriffenen Werken zu nicht kommerziellen Zwecken“ zu vervielfältigen.

Die Terminalnutzung ist nach [§ 60h Abs. 1 S. 1 UrhG](https://www.gesetze-im-internet.de/urhg/__60h.html) vergütungspflichtig. Die Vergütung kann nur durch eine Verwertungsgesellschaft geltend gemacht werden, [§ 60h Abs. 4 UrhG](https://www.gesetze-im-internet.de/urhg/__60h.html). Allerdings ist die Vergütung keine Voraussetzung für die Zulässigkeit der Nutzung. Wenn entsprechende Ansprüche nicht geltend gemacht werden, entfällt damit nicht die Zulässigkeit der Nutzung.

Der zwischen der VG Wort und dem Deutschen Bibliotheksverband geschlossene [Gesamtvertrag über die Vergütung von Terminalnutzung](https://www.bibliotheksverband.de/sites/default/files/2021-06/Rahmenvertrag_60e_Abs_4_UrhG_Terminals_unterzeichnet.pdf) nach [§ 60e Abs. 4 UrhG](https://www.gesetze-im-internet.de/urhg/__60e.html) gilt nur für veröffentlichte Schriftwerke.

Bisher werden Vergütungen für die Nutzung anderer Medien in der Praxis nicht gefordert. Seitdem die Terminalnutzung 2007 durch § 52b UrhG a. F. unter der Bezeichnung „elektronischer Leseplatz“ im Gesetz ermöglicht wurde, wurden Vergütungen stets nur durch die VG Wort für veröffentlichte Schriftwerke (Bücher, Zeitschriften) geltend gemacht, wobei sich die Höhe der Vergütung am Verkaufspreis orientiert hat.<sup>8</sup> Ob dies in Zukunft geschieht, kann nicht prognostiziert werden.

[format-annotation]
<sup>1</sup> §§ 60e Abs. 4, der nach § 60f Abs. 1 UrhG auch für Archive gilt.  
<sup>2</sup> Dreier, in: Dreier, Thomas / Schulze, Gernot (Hg.): Urheberrechtsgesetz, 7. Aufl., 2022, UrhG § 60e Rn. 17.  
<sup>3</sup> Dreier, in: Dreier, Thomas / Schulze, Gernot (Hg.): Urheberrechtsgesetz, 7. Aufl., 2022, UrhG § 60e Rn. 17.  
<sup>4</sup> Dreier, in: Dreier, Thomas / Schulze, Gernot (Hg.): Urheberrechtsgesetz, 7. Aufl., 2022, UrhG § 60e Rn. 17.  
<sup>5</sup> [de la Durantaye, Katharina: Allgemeine Bildungs- und Wissenschaftsschranke, 2014](https://edoc.hu-berlin.de/handle/18452/19416), S. 114 m.w.N.  
<sup>6</sup> Dreier, in: Dreier, Thomas / Schulze, Gernot (Hg.): Urheberrechtsgesetz, 7. Aufl., 2022, UrhG § 60e Rn. 11.  
<sup>7</sup> Dreier, in: Dreier, Thomas / Schulze, Gernot (Hg.): Urheberrechtsgesetz, 7. Aufl., 2022, UrhG § 60e Rn. 17; die Zulässigkeit dieser Vervielfältigung ebenfalls bejahend BGH, Urt. v. 16.4.2015, Az. I ZR 69/11 – Elektronische Leseplätze II.  
<sup>8</sup> [https://www.bibliotheksverband.de/fileadmin/user_upload/DBV/vereinbarungen/2016-10-05_Rahmenvertrag_zur_Verguetung_von_Anspruechen_nach___52a_UrhG.pdf](https://www.bibliotheksverband.de/fileadmin/user_upload/DBV/vereinbarungen/2016-10-05_Rahmenvertrag_zur_Verguetung_von_Anspruechen_nach___52a_UrhG.pdf), [https://www.bibliotheksverband.de/fileadmin/user_upload/DBV/vereinbarungen/2012-01-30_Gesamtvertrag_Bibliothekstantieme_52b.pdf](https://www.bibliotheksverband.de/fileadmin/user_upload/DBV/vereinbarungen/2012-01-30_Gesamtvertrag_Bibliothekstantieme_52b.pdf), dort § 3.
[/format-annotation]
