---
title: '6.7. Archivierung'
taxonomy:
    category:
        - docs
---

Die gesetzlichen Befugnisse von Archiven sind an zwei Stellen des Urheberrechtsgesetzes geregelt: in [§ 53](https://www.gesetze-im-internet.de/urhg/__53.html) und [§ 60f UrhG](https://www.gesetze-im-internet.de/urhg/__60f.html). Beide Vorschriften haben unterschiedliche Voraussetzungen. Während [§ 60f UrhG](https://www.gesetze-im-internet.de/urhg/__60f.html) eine umfassende Bestimmung nur für nichtgewerbliche Archive ist, gilt [§ 53](https://www.gesetze-im-internet.de/urhg/__53.html) für alle Archive – auch kommerzielle –, erlaubt jedoch nur analoge Vervielfältigungen. Durch das UrhWissG wurde nicht nur [§ 60f UrhG](https://www.gesetze-im-internet.de/urhg/__60f.html) eingeführt, sondern auch [§ 53](https://www.gesetze-im-internet.de/urhg/__53.html) UrhG dahingehend geändert, dass er auch kommerzielle Archive erfasst. Besonders kompliziert erweist sich – auch vor dem Hintergrund von Gesetzesänderungen – die Beurteilung von Fernsehmitschnitten.

### 6.7.a Allgemeine Archivkopie, § 53 Abs. 2 Nr. 2 Urhg

[§ 53 Abs. 2 Nr. 2 UrhG](https://www.gesetze-im-internet.de/urhg/__53.html) erlaubt die „Archivkopie“. Bis zum Inkrafttreten des UrhWissG war diese Bestimmung die einzige gesetzliche Erlaubnis, auf die sich Archive berufen konnten.

Einzelne Vervielfältigungsstücke eines Werkes dürfen nach [§ 53 Abs. 2 Nr. 2 UrhG](https://www.gesetze-im-internet.de/urhg/__53.html) zur Aufnahme in ein eigenes Archiv hergestellt werden oder von Dritten hergestellt werden lassen, ohne dass die Zustimmung der Rechteinhaber:innen eingeholt werden muss, soweit die Vervielfältigung zu diesem Zweck geboten ist und als Vorlage für die Vervielfältigung ein eigenes Werkstück benutzt wird ([§ 53 Abs. 2 S. 1 Nr. 2 UrhG](https://www.gesetze-im-internet.de/urhg/__53.html)). Zulässig sollen nur solche Fälle sein, in denen es durch die Archivierung zu keiner zusätzlichen Verwertung kommt.<sup>1</sup>. Gestattet ist lediglich die Sammlung und Erschließung von Materialien für die Bestandssicherung oder die interne Nutzung.<sup>2</sup>

Archive sind Sammlungen, die nach sachlichen Gesichtspunkten vorgenommen wurden, oder Aufbewahrungen von Geistesgut jeglicher Art, beispielsweise Bücher, Zeitschriften, Zeitungen, Bilder, Schallplatten, Tonbänder oder Filme.<sup>3</sup> Die Vervielfältigungen müssen für ein „eigenes“ Archiv angefertigt werden. Dies umfasst nur persönliche oder betriebsinterne Archive, die von außenstehenden Dritten nicht benutzt werden können.<sup>4</sup> Öffentliche Mediatheken fallen nicht hierunter. Bei Mediatheken an Hochschulinstituten kommt es auf den Einzelfall an, ob solche Mediatheken allgemein zugänglich sind oder nicht. Sobald Institutsmediatheken für die Nutzung durch Dritte angelegt sind<sup>5</sup>, fallen sie nicht unter diese Norm.

Es müssen eigene, also im Eigentum des Archivbetreibers stehende Werkstücke als Vorlagen verwendet werden.<sup>6</sup> Gemietete oder entliehene Werkstücke dürfen demnach nicht vervielfältigt werden.<sup>7</sup>

Außerdem dürfen Kopien nur hergestellt werden, wenn sie auf Papier oder einem ähnlichen Träger mittels beliebiger fotomechanischer Verfahren oder ähnlicher Verfahren vorgenommen werden ([§ 53 Abs. 2 S. 2 Nr. 1 UrhG](https://www.gesetze-im-internet.de/urhg/__53.html)) und eine ausschließlich analoge Nutzung nach der Vervielfältigung stattfindet ([§ 53 Abs. 2 S. 2 Nr. 2 UrhG](https://www.gesetze-im-internet.de/urhg/__53.html)).

Die Aufnahme in das Archiv muss zudem durch den Archivierungszweck geboten sein. Dies ist ausschließlich dann der Fall, wenn die Vervielfältigung der Bestandssicherung oder der betriebsinternen Nutzung dient. Geboten sind Vervielfältigungen auch nur in erforderlichem Umfang, also nur einzelne Kopien und dies auch nur bei Bestandsgefährdung. Andere Archivzwecke sind nicht abgedeckt, insbesondere darf die Kopie nicht die Erweiterung des Bestandes bewirken.<sup>8</sup>

Die Aufnahme öffentlicher Vorträge, Aufführungen oder Vorführungen eines Werkes auf Bild- oder Tonträger, die Ausführung von Plänen und Entwürfen zu Werken der bildenden Künste und der Nachbau eines Werkes der Architektur sind nur mit Einwilligung der jeweiligen Rechteinhaber:innen zulässig ([§ 53 Abs. 7 UrhG](https://www.gesetze-im-internet.de/urhg/__53.html)). Musiknoten, ganze Bücher und Zeitschriften dürfen aber zu Archivzwecken kopiert werden.<sup>9</sup>

### 6.7.b Archive, Museen und Bildungseinrichtungen, § 60f Urhg

Gemäß [§ 60f Abs. 2 S. 1 i. V. m](https://www.gesetze-im-internet.de/urhg/__60f.html) & [60e Abs. 1 UrhG](https://www.gesetze-im-internet.de/urhg/__60e.html) dürfen Archive, die auch im öffentlichen Interesse tätig sind, ein Werk vervielfältigen oder vervielfältigen lassen, um es als Archivgut in ihre Bestände aufzunehmen. [§ 60f UrhG](https://www.gesetze-im-internet.de/urhg/__60f.html) verweist für Archive auf die für Bibliotheken geltenden Vorschriften. Nach [§ 60e UrhG](https://www.gesetze-im-internet.de/urhg/__60e.html) darf ein Werk vervielfältigt werden zum Zwecke der Zugänglichmachung, Indexierung, Katalogisierung, Erhaltung und Restaurierung. Diese Gründe sind recht weit gefasst und in einem Archiv nahezu immer einschlägig.

Der Vorschrift liegt ein weites Verständnis des Begriffs Archiv zugrunde. Dazu zählen neben dem Bundesarchiv und den Archiven der Länder auch alle Archive, die im öffentlichen Interesse tätig sind, genauso wie Redaktionsarchive, Archivbibliotheken wie die DNB und Institutsarchive.<sup>10</sup> Voraussetzung für die gesetzliche Erlaubnis nach [§ 60f UrhG](https://www.gesetze-im-internet.de/urhg/__60f.html) ist indes, dass das Archiv keine kommerziellen Interessen verfolgt.

[§ 60f UrhG](https://www.gesetze-im-internet.de/urhg/__60f.html) gilt ausdrücklich auch für die Aufnahme digitaler Artefakte. Um diese zu ermöglichen, wurde in [§ 60f Abs. 2 UrhG](https://www.gesetze-im-internet.de/urhg/__60f.html) festgelegt, dass zu diesem Zweck auch Kopien angefertigt werden dürfen. Dies ist bei digitalen Inhalten zwingend notwendig, da die Archivierung bei der Verwendung von Digitaltechnologie zwingend immer mit Vervielfältigungshandlungen verbunden ist.

[§ 60f UrhG](https://www.gesetze-im-internet.de/urhg/__60f.html) berechtigt nicht dazu, technische Schutzmaßnahmen zu überwinden – also Kopierschutz (Digital Rights Management) im Sinne von [§ 95a UrhG](https://www.gesetze-im-internet.de/urhg/__95a.html) zu umgehen. Allerdings haben Archive gegen die Rechtsinhaber:innen entweder einen Anspruch darauf, kopiergeschützte Werke entweder ohne Kopierschutz zu bekommen, oder darauf, die Mittel zur Überwindung des Kopierschutzes zu bekommen, [§ 95b UrhG](https://www.gesetze-im-internet.de/urhg/__95b.html).

### 6.7.c Mitschnitte von Fernsehsendungen

Kompliziert ist die Rechtslage im Hinblick auf die Archivierung der Mitschnitte von Fernsehsendungen. Für Privatleute ist das Mitschneiden von Fernsehsendungen nach [§ 53 UrhG](https://www.gesetze-im-internet.de/urhg/__53.html) als Privatkopie erlaubt. Es stellt sich jedoch die Frage, was für Mitschnitte von Fernsehsendungen im universitären Kontext gilt.

#### Eigene Fernsehmitschnitte

Es war lange gängige Praxis in universitären Kontext, Fernsehsendungen mitzuschneiden. Auch heute ist dies noch weit verbreitet, wenngleich die Online-Verfügbarkeit audiovisueller Inhalte in vielen Fällen das Bedürfnis nach solchen Mitschnitten hat geringer werden lassen. Es ist jedoch schon lange umstritten, ob ein solches Mitschneiden durch die Institutionen, beispielsweise durch Institutsbibliotheken bzw. Mediatheken, überhaupt zulässig ist.

#### Rechtslage vor März 2018

Vor dem Inkrafttreten des Gesetzes zur Anpassung des Urheberrechts an die Erfordernisse der Wissensgesellschaft (UrhWissG) im März 2018 ging die Mehrheit der Bibliotheken davon aus, dass das Mitschneiden ganzer Fernsehsendungen zulässig sei. Diese Auffassung war zwar umstritten<sup>11</sup>, wurde jedoch durch verschiedene Gutachten gestützt<sup>12</sup> und war handlungsbestimmend für den Alltag in Bibliotheken.

Nach alter Gesetzeslage galt eine Aufzeichnung nach § 53 Abs. 2 S. 1 Nr. 1 UrhG a. F. zum Zwecke des eigenen wissenschaftlichen Gebrauches als zulässig. Wissenschaftlichen Bibliotheken war es demnach erlaubt, zum Zwecke des wissenschaftlichen Betriebes selbständig und ohne Einräumung von Nutzungsrechten durch den Urheber Aufzeichnungen von Fernsehsendungen anzufertigen, zu sammeln und intern zu benutzen.<sup>13</sup>

Die bis zum 1. März 2018 geltende Vorschrift lautete:

> „*Zulässig ist, einzelne Vervielfältigungsstücke eines Werkes herzustellen oder herstellen zu lassen 1. zum eigenen wissenschaftlichen Gebrauch, wenn und soweit die Vervielfältigung zu diesem Zweck geboten ist und sie keinen gewerblichen Zwecken dient,* *[...]*“.

[format-annotation]
**§ 53 Abs. 2 S. 1 Nr. 1 UrhG a. F.**
[/format-annotation]

Argumentiert wurde, dass sich Bibliotheken als juristische Personen selbst auf den eigenen wissenschaftlichen Gebrauch berufen könnten. Denn § 53 Abs. 2 S. 1 UrhG a. F. ermöglichte es Bibliotheken aus ihrem eigenen Handlungsauftrag heraus, die forschenden Bibliotheksbesucher mit Wissen und Information zu versorgen, wozu auch das Aufzeichnen einer Fernsehsendung zähle.

Auch wenn diese weite Auslegung zum Teil umstritten war, war sie allgemein anerkannt. Dieser Streit ist mittlerweile unerheblich, denn die Regelung wurde ersatzlos gestrichen. Der § 53 Abs. 2 S. 1 Nr. 1 UrhG a. F. kann damit seit dem 1. März 2018 nicht mehr als Erlaubnis für die Aufzeichnung der Fernsehsendungen dienen.

#### Rechtslage heute

In [§ 60f Abs. 2 S. 1 UrhG](https://www.gesetze-im-internet.de/urhg/__60f.html) heißt es:

> „Archive, die auch im öffentlichen Interesse tätig sind, dürfen ein Werk vervielfältigen oder vervielfältigen lassen, um es als Archivgut in ihre Bestände aufzunehmen.“

Umstritten ist, ob nach dieser Norm audiovisuelle Archive auch eigenmächtig Fernsehsendungen speichern und archivieren. Denn der Wortlaut steht einer solchen Interpretation nicht entgegen. Eine solche gesetzliche Befugnis wäre auch im Einklang mit dem durch die InfoSoc-Richtlinie gesetzten europarechtlichen Rahmen, da dort Art. 5 Abs. 2 c) Ausnahmen im Hinblick auf das Vervielfältigungsrecht für Archive vorsieht.

Allerdings ist zweifelhaft, ob eine solche Auslegung dem gesetzgeberischen Willen entspricht. Durch [§ 60f Abs. 2 UrhG](https://www.gesetze-im-internet.de/urhg/__60f.html) sollte ermöglicht werden, dass auch digitale Objekte in Archive übernommen werden, bei denen es technisch zwingend zu einer Vervielfältigung kommt. Dabei hatte man insbesondere sogenannte E-Akten im Blick. Dies wird auch durch die Formulierung in [§ 60f Abs. 2 S. 2 UrhG](https://www.gesetze-im-internet.de/urhg/__60f.html) deutlich. Dort heißt es:

> „Die abgebende Stelle hat unverzüglich die bei ihr vorhandenen Vervielfältigungen zu löschen.“

Die gesetzgeberische Intention dahinter ist, sicherzustellen, dass es durch die Vervielfältigung im Rahmen der Aufnahme in ein Archiv zu keiner dauerhaften Bestandsvermehrung kommt. Zusätzliche Kopien im Archiv werden nur für einen Übergangszeitraum geduldet, da es eine gewisse Zeit braucht, bis die „abgebende Stelle“ ihre Fassung gelöscht hat. Zwar ist die Löschung nach [§ 60f Abs. 2 S. 2 UrhG](https://www.gesetze-im-internet.de/urhg/__60f.html) keine Voraussetzung für die rechtliche Zulässigkeit der Kopie nach Satz 1.<sup>14</sup> Gleichwohl wird deutlich, dass eine eigenmächtige Bestandsvermehrung aus allgemein zugänglichen Quellen nicht beabsichtigt wurde. Eine Pflicht der Fernsehsender, urheberrechtlich geschützte Inhalte zu löschen, weil sie eigenmächtig in ein öffentliches Archiv übernommen wurden, wäre zudem ersichtlich unsinnig.

Der Deutsche Bibliotheksverband geht davon aus, dass seit Inkrafttreten des Gesetzes zur Anpassung des Urheberrechts an die Erfordernisse der Wissensgesellschaft 2018 das Mitschneiden von Fernsehsendungen unzulässig ist.<sup>15</sup> Allerdings begreift er Mediatheken nicht als Archive und geht nicht auf [§ 60f UrhG](https://www.gesetze-im-internet.de/urhg/__60f.html) ein. Abschließend lässt sich festhalten, dass sich zwar argumentieren lässt, dass die eigenmächtige Herstellung von Fernsehmitschnitten durch Mediatheken nach [§ 60f Abs. 2 S. 2 UrhG](https://www.gesetze-im-internet.de/urhg/__60f.html) zulässig ist und ein solches Verständnis auch nicht dem Gesetzeswortlaut widerspricht, dass eine solche Auslegung aber umstritten ist und daher mit Risiken verbunden ist, solange dies nicht höchstrichterlich entschieden wurde.

#### Übernahme von Filmen aus Privatbesitz in Archive

Es kommt häufig vor, dass mit Nachlässen auch Kopien von audiovisuellen Inhalten, sei es auf Video oder auf DVD, in Mediatheken oder Archive gelangen. Es stellt sich die Frage, wie mit solchen Inhalten zu verfahren ist.

Zunächst einmal werden solche Medien in den Bestand eines Archivs aufgenommen. Das UrhG nutzt im Hinblick auf Archive vielfach den Begriff „Bestand“. Dieser Begriff ist weit zu verstehen. Auf welche Weise ein Werk in den Bestand gekommen ist, spielt keine Rolle. Auch Dauerleihgaben gehören zum Bestand.<sup>16</sup>

Der rechtliche Status von Archivbeständen ist nur in sehr seltenen Fällen tatsächlich geklärt. Das gilt für das Sacheigentum und zeigt sich an den erheblichen Anstrengungen, mit denen Provenienzforschung betrieben wird, um in den Beständen von Kulturerbe-Einrichtungen solche Zeugnisse zu identifizieren, die sich dort unrechtmäßig infolge nationalsozialistischer Zwangsmaßnahmen befinden. Aber auch urheberrechtlich ist der Status der meisten Archivalien unklar.

Gleichwohl ist der rechtliche Status für Archive und Mediatheken nicht gänzlich unbeachtlich. Denn öffentliche Vorführungen sind verboten, wenn es sich um rechtswidrig erstellte Kopien handelt, [§ 96 Abs. 1 UrhG](https://www.gesetze-im-internet.de/urhg/__96.html). Auch die öffentliche Vorführung von Privatkopien ist nicht erlaubt ([§ 53 Abs. 6 UrhG](https://www.gesetze-im-internet.de/urhg/__53.html)), wobei auch das Angebot an einem Terminal, das sich ohne Differenzierung an alle Nutzer:innen richtet, als öffentliche Vorführung bewertet wird.<sup>17</sup>

### 6.7.d Wertungswidersprüche

Die Regelung der Privatkopie in [§ 53 UrhG](https://www.gesetze-im-internet.de/urhg/__53.html) sowie der sehr viel eingeschränkteren Befugnissen in den §§ 60a ff. UrhG enthält Wertungswidersprüche, die nur aus der Entstehungsgeschichte der Normen zu erklären sind. Begreift man die gesetzlichen Erlaubnisse des Urheberrechts als Ausfluss der Sozialbindung des Eigentums, das im Allgemeininteresse eingeschränkt werden darf, so ist nicht schlüssig, dass die Befugnisse der Vervielfältigung zur privaten Nutzung, von der kein unmittelbarer gesellschaftlicher Mehrwert ausgeht, weitreichender sind als die für Wissenschaft und Forschung statuieren Befugnisse.

Letztlich entscheidend ist wohl, dass im Bereich der – ja weitgehend öffentlich finanzierten – Wissenschaft davon ausgegangen wird, dass die professionellen Institutionen wie Bibliotheken und Mediatheken sich die Werke als solche oder auch den Zugang zu Datenbanken kaufen sollen. Davon verspricht man sich höhere Erträge als vom Renumerationsmechanismus über die Geräteabgabe bei der Privatkopie.

[format-annotation]
<sup>1</sup> Loewenheim / Stieper, in: Schricker, Gerhard / Loewenheim, Ulrich (Hg.),: Urheberrecht, 6. Aufl., 2020, UrhG § 53 Rn. 38.  
<sup>2</sup> [de la Durantaye, Katharina: Allgemeine Bildungs- und Wissenschaftsschranke, 2014](https://edoc.hu-berlin.de/handle/18452/19416), S. 84.  
<sup>3</sup> Dreier, in: Dreier, Thomas / Schulze, Gernot (Hg.): Urheberrechtsgesetz, 7. Aufl., 2022, UrhG § 53 Rn. 26; [de la Durantaye, Katharina: Allgemeine Bildungs- und Wissenschaftsschranke, 2014](https://edoc.hu-berlin.de/handle/18452/19416), S. 84.  
<sup>4</sup> Dreier, in: Dreier, Thomas / Schulze, Gernot (Hg.): Urheberrechtsgesetz, 7. Aufl., 2022, UrhG § 53 Rn. 27.  
<sup>5</sup> Loewenheim / Stieper, in: Schricker, Gerhard / Loewenheim, Ulrich (Hg.),: Urheberrecht, 6. Aufl., 2020, UrhG § 53 Rn. 39.  
<sup>6</sup> Dreier, in: Dreier, Thomas / Schulze, Gernot (Hg.): Urheberrechtsgesetz, 7. Aufl., 2022, UrhG § 53 Rn. 27.  
<sup>7</sup> [de la Durantaye, Katharina: Allgemeine Bildungs- und Wissenschaftsschranke, 2014](https://edoc.hu-berlin.de/handle/18452/19416), S. 84.  
<sup>8</sup> Loewenheim / Stieper, in: Schricker, Gerhard / Loewenheim, Ulrich (Hg.),: Urheberrecht, 6. Aufl., 2020, UrhG § 53 Rn. 40.  
<sup>9</sup> § 53 Abs. 4 UrhG gilt für § 53 Abs. 2 S. 1 Nr. 2 UrhG nicht.  
<sup>10</sup> Dreier, in: Dreier, Thomas / Schulze, Gernot (Hg.): Urheberrechtsgesetz, 7. Aufl., 2022, UrhG § 60e Rn. 1, 4.  
<sup>11</sup> Kritisch insbesondere Peters, Klaus: Urheberrechtsfragen audiovisueller Medien in Bibliotheken, 2. Auflage 1989.  
<sup>12</sup> [Katzenberger, Paul: Urheberrechtliche Fragen bei der Aufzeichnung von Fernsehsendungen durch Universitätsbibliotheken, in: Bibliotheksdienst 18, Heft. 12, 1984](https://www.degruyter.com/document/doi/10.1515/bd.1984.18.12.1152/html); Sinogowitz, Bernhard / Rechtskommission des Deutsches Bibliotheksinstitut (Hg.): Wiedergabe und Benutzung audiovisueller Medien in Bibliotheken: Gutachten der Rechtskommission des Deutschen Bibliotheksinstituts (DBI), Berlin 1986; Müller, Harald: Urheberrechte zwischen Wissenschaft, Universität und Rundfunkanstalt, in: Wätjen, Hans-Joachim (Hg.): Zwischen Schreiben und Lesen : Perspektiven für Bibliotheken, Wissenschaft und Kultur. Festschrift zum 60. Geburtstag von Hermann Havekost, 1995, S. 357–376.  
<sup>13</sup> [Behnk, Rebecca: Fernsehaufzeichnungen in Bibliotheken – Rechtliche Probleme der Sammlung und Benutzung, Berlin 2015, S. 43](https://edoc.hu-berlin.de/bitstream/handle/18452/2792/398.pdf).  
<sup>14</sup> Vgl. Stieper, Malte, in: Schricker, Gerhard / Loewenheim, Ulrich (Hg.),: Urheberrecht, 6. Aufl., 2020, UrhG § 60f Archive, Museen und Bildungseinrichtungen Rn. 9.  
<sup>15</sup> Deutscher Bibliotheksverband e. V., Fernsehmitschnitte an Bibliotheken nach dem UrhWissG.  
<sup>16</sup> Jani, Ole, in: Wandtke, Artur-Axel / Bullinger, Winfried (Hg.): Praxiskommentar Urheberrecht, 6. Aufl., München 2022, UrhG § 60f Archive, Museen und Bildungseinrichtungen Rn. 45.  
<sup>17</sup> v. Ungern-Sternberg, in: Schricker, Gerhard / Loewenheim, Ulrich (Hg.),: Urheberrecht, 6. Aufl., 2020, UrhG § 15 Rn. 71.
[/format-annotation]
