---
title: '6.6. Text und Data Mining (§§ 60d und 44b UrhG)'
taxonomy:
    category:
        - docs
---

Im Rahmen wissenschaftlicher Nutzung von Werken sind schließlich die Nutzungserlaubnisse für Text und Data Mining zu nennen. Text und Data Mining (TDM) erfreut sich als Praxis auch in den Kulturwissenschaften in den letzten Jahren verstärkter Beliebtheit. Unter dem Begriff lassen sich unterschiedliche Nutzungsszenarien fassen.

Das Gesetz definiert TDM so: „Text und Data Mining ist die automatisierte Analyse von einzelnen oder mehreren digitalen oder digitalisierten Werken, um daraus Informationen insbesondere über Muster, Trends und Korrelationen zu gewinnen“ ([§ 44b Abs. 1 UrhG](https://www.gesetze-im-internet.de/urhg/__44b.html)).

Die Gewinnung von Mustern, Trends und Korrelationen kann zu Beginn eines längeren Zyklus der Beforschung von audiovisuellen Medien stehen. Nutzungsszenarien sind zum Beispiel, die Entwicklung von Sprache oder Bildkomposition im zeitgenössischen Film computergestützt auszuwerten und die Erkenntnisse später zu präsentieren. Zu diesen Zwecken dürfen automatisiert Transkriptionen erstellt oder Stills entnommen werden. Ein weiteres Szenario ist, Audio und Film als Input fürs Trainieren einer KI zu nutzen, mit der sich später neues Material erstellen lässt.<sup>1</sup>

TDM lässt sich verallgemeinernd in mehreren Stufen darstellen: Der Sammlung audiovisueller Inhalte, deren Aufbereitung (Strukturieren, Normalisieren usw.) und dem Erzeugen von „Korpora“ schließt sich die eigentliche Analyse an, in deren Rahmen ein Algorithmus die Muster, Korrelationen und Trends erkennt, oder, so das verwandte Szenario, KI-Modelle trainiert werden können. Es folgt die öffentliche Darstellung der Erkenntnisse in einer Publikation bzw. die Nutzung eines generierten Outputs. Später besteht häufig ein Interesse daran, die aufbereiteten Materialien/Korpora dauerhaft zu speichern und etwa für Reviewzwecke zugänglich zu machen, zumal in der Wissenschaft derlei Daten im Idealfall adäquat aufbewahrt sowie überprüfbar und nachnutzbar gemacht werden sollten.

In den vergangenen Jahren wurden mit den [§§ 44b](https://www.gesetze-im-internet.de/urhg/__44b.html), [60d UrhG](https://www.gesetze-im-internet.de/urhg/__60d.html) gesetzliche Bestimmungen eingeführt, die sich explizit mit Text und Data Mining befassen und den Umgang von urheberrechtlich geschütztem Material unter dieser Methode erlauben. [§§ 44b](https://www.gesetze-im-internet.de/urhg/__44b.html), [60d UrhG](https://www.gesetze-im-internet.de/urhg/__60d.html) zielen isoliert betrachtet allerdings nur auf den Anfang und das Ende der gerade beschriebenen Stufenfolge ab:

*   Zulässig ist einerseits das Anfertigen lokaler Kopien von urheberrechtlich geschützten Materialien zu TDM-Zwecken, sowie auch dessen Aufbereitung, um sie der eigentlichen Analyse zuzuführen. Die zu beforschenden Werke müssen „rechtmäßig zugänglich“ sein; es darf kein Kopierschutz umgangen werden. Für audiovisuelle Medien bedeutet das, dass beispielsweise ein Stream auf einer Filmplattform in Echtzeit per Bildschirmaufnahme mitgeschnitten werden darf, sofern hierbei keine technische Schutzmaßnahme umgangen werden muss; ein Download audiovisueller Inhalte von einer Bezahlplattform wird häufig nur unter Umgehung des Kopierschutzes möglich und damit wegen des Verbots der Umgehung technischer Schutzmaßnahmen ([§ 95a UrhG](https://www.gesetze-im-internet.de/urhg/__95.html)) unzulässig sein.<sup>2</sup>
*   Zulässig ist andererseits das Speichern und Aufbewahren der Korpora, allerdings nur in den Grenzen der [§§ 44b](https://www.gesetze-im-internet.de/urhg/__44b.html), [60d UrhG](https://www.gesetze-im-internet.de/urhg/__60d.html). So verlangt das Gesetz beim TDM zu kommerziellen Zwecken, dass die angefertigten Kopien gelöscht werden, sobald sie für das TDM nicht mehr erforderlich sind ([§ 44b Abs. 2 S. 2 UrhG](https://www.gesetze-im-internet.de/urhg/__44b.html)). Im Rahmen nicht-kommerzieller wissenschaftlicher Forschung wiederum dürfen die Kopien „mit angemessenen Sicherheitsvorkehrungen gegen unbefugte Benutzung“ aufbewahrt werden, solange dies für die wissenschaftliche Forschung oder deren Überprüfung erforderlich ist ([§ 60d Abs. 5 UrhG](https://www.gesetze-im-internet.de/urhg/__60d.html)) – also über das Beenden des TDM hinaus.<sup>3</sup> Für die „Erforderlichkeit“ kann man sich entlang von Kriterien wie einer erwartbaren Anschlussforschung oder Empfehlungen der Guten Wissenschaftlichen Praxis orientieren (zehn Jahre zur Überprüfung), sie kann aber unter Umständen auch dauerhaft sein.<sup>4</sup> Außerdem dürfen Individualforschende sowie die in [§ 60d Abs. 2 und 3 UrhG](https://www.gesetze-im-internet.de/urhg/__60d.html) genannten Wissenschafts- und Gedächtnisinstitutionen (hierunter Einrichtungen des Filmerbes) die Kopien/Korpora anderen Forschenden für die gemeinsame wissenschaftliche Forschung oder im Rahmen eines Peer Review zugänglich machen ([§ 60d Abs. 4 UrhG](https://www.gesetze-im-internet.de/urhg/__60d.html)).

Werden mit dem TDM kommerzielle Zwecke verfolgt, ist eine weitere Einschränkung zu beachten. Dann müssen gem. [§ 44b Abs. 3 UrhG](https://www.gesetze-im-internet.de/urhg/__44b.html) sogenannte Rechtevorbehalte eingehalten werden:

*   Wird TDM vertraglich durch Rechteinhaber:innen für eine nutzende Institution untersagt, so ist dieses Verbot im kommerziellen Kontext zu achten; dasselbe gilt bei frei verfügbaren Online-Quellen, bei denen maschinenlesbare Rechtevorbehalte angebracht werden. Es existieren auch bereits Plattformen, die Kunstschaffenden die Erklärung solcher Rechtevorbehalte erleichtern sollen. Deren Ziel ist es, dass Kunstschaffende und Rechteinhaber:innen ein Opt-Out setzen können, damit deren Schaffen nicht als KI-Trainingsmaterial dient. Die nicht-kommerzielle wissenschaftliche Forschung darf derlei Vorbehalte allerdings stets ignorieren.
*   In der öffentlichen Präsentation von Ergebnissen des TDM müssen Urheberrechte an den analysierten Materialien nur dann beachtet werden, wenn überhaupt noch Bestandteile urheberrechtlich geschützter Werke enthalten sind. Stets denkbar ist hier das Zitat (siehe [Kapitel 6.1.](/6-1-zitate)). Sollten also in einer Publikation Werke oder Werkteile wie etwa Filmstills eingefügt werden, so kann man sich hierfür die Zitierfreiheit zunutze machen. Die gewonnenen Erkenntnisse sind nach den Vorschriften des Urheberrechts stets gemeinfrei.

[format-annotation]
<sup>1</sup> Siehe zum Themenkomplex TDM statt vieler die umfassende Analyse bei [Kleinkopf, Felicitas Lea: Text- und Data-Mining – die Anforderungen digitaler Forschungsmethoden an ein innovations- und wissenschaftsfreundliches Urheberrecht](https://www.nomos-elibrary.de/10.5771/9783748935360/text-und-data-mining?page=1), Baden-Baden 2022.  
<sup>2</sup> Zu den Implikationen in den Kulturwissenschaften auch [Rack, Fabian / Boehm, Franziska / Pasdzierny, Matthias / Schmidt, Dörte, NFDI4Culture: Forschungsdaten in den Kulturwissenschaften](https://www.nomos-elibrary.de/10.5771/9783748910664-253/nfdi4culture-forschungsdaten-in-den-kulturwissenschaften?page=1), in: Schrör, Simon / Fischer, Georg / Beaucamp, Sophie / Hondros, Konstantin (Hg.): Tipping Points, Baden-Baden 2020, S. 271 f.  
<sup>3</sup> Dies gilt allerdings nicht für Individualforscher, sondern nur für die in § 60d Abs. 2 und 3 UrhG genannten Wissenschafts- und Kulturinstitutionen.  
<sup>4</sup> Dreier, in: Dreier, Thomas / Schulze, Gernot (Hg.): Urheberrechtsgesetz, 7. Aufl., 2022, UrhG § 60d Rn. 12 f. mwN.
[/format-annotation]
