---
title: '6.2. Privatkopie'
taxonomy:
    category:
        - docs
---

Auch die „Privatkopie“ ist eine im Alltag wichtige Erlaubnis, gerade auch in Hinblick auf audiovisuelle Medien. Lange war es weit verbreitet, dass im Fernsehen ausgestrahlte Filme und Sendungen in Privathaushalten auf Videokassetten aufgenommen wurden. Der technische Wandel hat zunächst dazu geführt, dass statt Videokassetten Festplattenrecorder bzw. gebrannte DVDs genutzt wurden. Inzwischen ist die Bedeutung dieser Form der Speicherung von Filmen im Privaten zwar stark zurückgegangen. Es gibt jedoch oft umfangreiche Sammlungen von privaten Kopien, die als Nachlässe oder Schenkungen ihren Weg in Archive und Mediatheken finden.

### 6.2.a Voraussetzungen

Die gesetzliche Grundlage, nach der Privatpersonen die Anfertigung von Kopien erlaubt ist, ist [§ 53 UrhG](https://www.gesetze-im-internet.de/urhg/__53.html). Danach dürfen Einzelpersonen zum Privatgebrauch einzelne Vervielfältigungen eines Werkes herstellen, sofern dies keinen Erwerbszwecken dient und keine offensichtlich rechtswidrige Vorlage verwendet wird ([§ 53 Abs. 1 S. 1 UrhG](https://www.gesetze-im-internet.de/urhg/__53.html)). Auf die Ausnahmeregelungen können sich nur Einzelpersonen berufen, nicht aber juristische Personen.<sup>1</sup> Es darf sich nur um Nutzungen im rein privaten Bereich handeln, ohne Bezug zu beruflichen oder erwerbswirtschaftlichen Zwecken.<sup>2</sup> Wissenschaftler:innen hingegen dürfen nicht unter Berufung auf diese Norm Vervielfältigungen anfertigen.

Das Recht zur Privatkopie ist insofern eingeschränkt, als keine „offensichtlich rechtswidrig hergestellte oder öffentlich zugänglich gemachte Vorlage“ vervielfältigt werden darf. Diese Einschränkung zielt insbesondere auf Angebote im Internet ab, die ohne entsprechende Rechtsgrundlage Filme und andere Werke zum Download anbieten.

Das Recht zur Privatkopie hat auch noch weitere Einschränkungen. Nach [§ 53 Abs. 4 UrhG](https://www.gesetze-im-internet.de/urhg/__53.html) ist weder die Vervielfältigung von urheberrechtlich geschützten „grafische[n] Aufzeichnungen von Werken der Musik“, also von Musiknoten, noch die Vervielfältigung von ganzen Büchern oder Zeitschriften erlaubt.

Für eine Privatkopie darf keine „technischen Schutzmaßnahmen” umgangen werden, also kein Kopierschutz überwunden werden, [§ 95a UrhG](https://www.gesetze-im-internet.de/urhg/__95a.html).

### 6.2.b Herstellung für Dritte und Mediatheken

Weiterhin kann die Herstellung einer Privatkopie auch durch Dritte vorgenommen werden. Dies gilt auch für Filme, dort jedoch nur, „sofern dies unentgeltlich geschieht“ ([§ 53 Abs. 1 Satz 2 UrhG.](https://www.gesetze-im-internet.de/urhg/__53.html)). Eine bloße Erstattung von Unkosten der Herstellung, insbesondere von Materialkosten, ist jedoch erlaubt und ändert nichts an der Bewertung als „unentgeltlich“.<sup>3</sup>

Allerdings gilt dies nicht für Bibliotheken, denn hier geht [§ 60e Abs. 5 UrhG](https://www.gesetze-im-internet.de/urhg/__60e.html) als spezielle Norm für den Kopienversand auf Bestellung vor. Diese Ausnahmeregelung gilt nur für Bibliotheken, nicht für Archive. [§ 60f UrhG](https://www.gesetze-im-internet.de/urhg/__60f.html), der die Geltung der Vorschriften für Bibliotheken grundsätzlich als auch für Archive anwendbar erklärt, gilt ausdrücklich nicht für [§ 60e Abs. 5 UrhG](https://www.gesetze-im-internet.de/urhg/__60e.html).

Damit stellt sich die Frage, was für „Mediatheken“ gilt, die organisatorisch oft innerhalb von Bibliotheken angesiedelt sind, oder für Einrichtungen, die sowohl Bibliothek als auch Archiv sind. Hier ist eine idealtypische Betrachtung anzustellen: Unter Bibliotheken werden Einrichtungen verstanden, die Bücher und andere Schriftwerke zur Nutzung anbieten. Bei Büchern und Zeitschriften kennt das Urheberrecht bei der Privatkopie Ausnahmen dahingehend, dass keine ganzen Bücher oder Zeitschriften kopiert werden dürfen ([§ 53 Abs. 4 Nr. 2 UrhG](https://www.gesetze-im-internet.de/urhg/__53.html)). Mit dieser Einschränkung korrespondiert auch die Einschränkung des Kopienversandes auf Bestellung in [§ 60e Abs. 5 UrhG](https://www.gesetze-im-internet.de/urhg/__60e.html), der diesen ebenfalls auf zehn Prozent eines Werkes oder einzelne Beiträge beschränkt. Und in der Gesetzesbegründung zum UrhWissG wird bei der Erläuterung des [§ 60e Abs. 5](https://www.gesetze-im-internet.de/urhg/__60e.html) auf die Gesamtverträge Bezug genommen, die es nur im Bereich der Bücher und Zeitschriften gibt, nicht aber für audiovisuelle Inhalte.

Auch wenn diese Frage noch nicht gerichtlich entschieden wurde, spricht die systematische Stellung wie auch Gesetzesbegründung des [§ 60e Abs. 5 UrhG](https://www.gesetze-im-internet.de/urhg/__60e.html) dafür, dass dieser für Bücher gilt und nicht für solche Bereiche, in denen audiovisuelle Medien gesammelt werden – auch wenn sie sich organisatorisch in einer Bibliothek befinden, wie dies häufig bei Mediatheken der Fall ist. Allerdings wird in der rechtswissenschaftlichen Literatur auch die Ansicht vertreten, die Vorschrift beziehe sich auf alle Werkarten.<sup>4</sup> In jedem Fall ist es dort, wo sich Mediatheken als Filmarchive auch organisatorisch und von ihrer Sammlungspolitik von Bibliotheken unterscheiden, zulässig, wenn dort Privatkopien für Nutzer:innen erstellt werden. Die Auswirkung dieser Erlaubnis dürfte jedoch gering sein. Im universitären Kontext ist sie schon allein deshalb nicht einschlägig, weil Forschende eben nicht private Zwecke verfolgen. Doch unabhängig davon sind auch Videokassetten als Medium kaum noch gebräuchlich. Bei DVDs hingegen ist es so, dass diese meist einen technischen Kopierschutz enthalten. Die Umgehung technischer Schutzmaßnahmen ist jedoch unzulässig, [§ 95a UrhG](https://www.gesetze-im-internet.de/urhg/__95a.html). Dies gilt auch für die Herstellung einer sonst zulässigen Privatkopie.

### 6.2.c Nutzung von Privatkopien

Die Erlaubnis zur Erstellung einer Privatkopie nach [§ 53 UrhG](https://www.gesetze-im-internet.de/urhg/__53.html) geht weiter als die Befugnisse nach [§ 60a UrhG](https://www.gesetze-im-internet.de/urhg/__60a.html) für Unterricht und Lehre und nach [§ 60c UrhG](https://www.gesetze-im-internet.de/urhg/__60c.html) für Forschung, die jeweils nur die Vervielfältigung von 15 bzw. 75 Prozent eines Werkes erlauben, vgl. Abschnitt 6.5. Angesichts des unterschiedlichen Umfangs stellt sich die Frage, wie beide Normen gegeneinander abzugrenzen sind.

Für die Frage, welche der Normen einschlägig ist, kommt es auf die Situation und Motivation zum Zeitpunkt der Vervielfältigung an. Um ein Beispiel zu nennen: Wenn ein Hochschullehrer mit seiner Frau abends einen romantischen Film schauen möchte und dafür „Vom Winde verweht“ aufnimmt, kann er sich auf [§ 53 UrhG](https://www.gesetze-im-internet.de/urhg/__53.html) berufen. Die Aufnahme ist als Privatkopie zulässig. Würde er den gleichen Film aber aufnehmen, um ihn in einem filmwissenschaftlichen Seminar über rassistische Stereotype zu verwenden, so würde sich die Zulässigkeit nach [§ 60a UrhG](https://www.gesetze-im-internet.de/urhg/__60a.html) richten und mithin nur ein Mitschneiden von 15 Prozent des Films zulässig sein.

Das Abstellen des Gesetzgebers auf die Motivation des Handelnden bei identischen Sachverhalten ist im Urheberrecht nichts Ungewöhnliches. Auch die Nutzung eines Terminals in Bibliotheken und Archiven ist Nutzer:innen nur für „wissenschaftliche Forschung und zu privaten Studien“ erlaubt ([§ 60e Abs. 5 UrhG](https://www.gesetze-im-internet.de/urhg/__60e.html), für Archive nach [§ 60f Abs. 3 UrhG](https://www.gesetze-im-internet.de/urhg/__60f.html) anwendbar), ohne dass klar ist, wie diese Motivlage überprüft werden kann.

Es stellt sich damit die Frage, ob und unter welchen Umständen auch ursprünglich rechtmäßig zur privaten Nutzung erstellte Kopien audiovisueller Inhalte im universitären Kontext genutzt werden dürfen.

Die Privatkopieregelung des [§ 53 UrhG](https://www.gesetze-im-internet.de/urhg/__53.html) enthält in Abs. 6 eine Einschränkung möglicher Nutzungen der nach dieser Vorschrift erstellten Kopie. Danach dürfen diese Kopien weder „verbreitet, noch zu öffentlichen Wiedergaben benutzt werden“. Diese Formulierung wird teilweise als ein umfassendes Verbot der nachträglichen Verwendung einer Kopie zu anderen Zwecken verstanden.<sup>5</sup> Von dem Wortlaut des Gesetzes ist eine solche Interpretation indes nicht gedeckt. Vielmehr werden, wenn die Kopie ursprünglich zur privaten Nutzung angefertigt wurde, lediglich zwei Nutzungsszenarien verboten, das öffentliche Wiedergeben und das Verbreiten. Diese konkreten Verbote korrespondieren mit [§ 96 UrhG](https://www.gesetze-im-internet.de/urhg/__96.html), der bei rechtswidrig erstellten Vervielfältigungsstücken ebenfalls die öffentliche Wiedergabe und die Verbreitung untersagt. Aus der präzisen Bezeichnung einzelner Anschlussnutzungen lässt sich im Umkehrschluss ableiten, dass alle anderen Nutzungen erlaubt bleiben.

#### Keine Verbreitung

Das Verbreitungsrecht ist in [§ 17 UrhG](https://www.gesetze-im-internet.de/urhg/__17.html) geregelt. Es ist das Recht, das Original oder Vervielfältigungsstücke des Werkes der Öffentlichkeit anzubieten oder in den Verkehr zu bringen. Alle Nutzungshandlungen im universitären Kontext, die als nicht öffentlich gelten (vgl. oben), sind mithin von dieser Vorschrift nicht erfasst.

Fraglich ist, ob das Verleihen durch Bibliotheken oder Mediatheken als Verbreitung im Sinne des [§ 17 UrhG](https://www.gesetze-im-internet.de/urhg/__17.html) zu verstehen ist. Bei der Verbreitung handelt es sich um einen europäischen Rechtsbegriff, dessen Reichweite sich aus Art. 4 Abs. 1 der InfoSoc-Richtlinie ergibt, weshalb der Bundesgerichtshof den Europäischen Gerichtshof durch einen Vorlagebeschluss um Konkretisierung bat. Der Europäische Gerichtshof hat daraufhin entschieden, dass eine Verbreitung nur vorliegt, wenn auch eine Eigentumsübertragung an dem Werkstück stattfindet.<sup>6</sup> Danach ist eine bloße Gebrauchsüberlassung, etwas durch Bibliotheken oder Mediatheken, gerade keine Verbreitung.

#### Keine öffentliche Verbreitung

Die zweite Nutzungseinschränkung für Privatkopien betrifft öffentliche Vorführungen. Diese sind nach [§ 53 Abs. 6 UrhG](https://www.gesetze-im-internet.de/urhg/__53.html) ebenfalls unzulässig. Solange es sich um Nutzungen in Seminaren und geschlossenen Gruppen handelt, liegt keine öffentliche Vorführung vor. Hingegen ist das Vorführen von Privatkopien in allgemein zugänglichen Vorlesungen und Vorträgen verboten.

[format-annotation]
<sup>1</sup> [BGH, 16.01.1997, I ZR 9/95 – CB – Infobank I](https://dejure.org/dienste/vernetzung/rechtsprechung?Gericht=BGH&Datum=16.01.1997&Aktenzeichen=I%20ZR%209/95).  
<sup>2</sup> Dreier, in: Dreier, Thomas / Schulze, Gernot (Hg.): Urheberrechtsgesetz, 7. Aufl., 2022, UrhG § 53 Rn. 10.  
<sup>3</sup> Loewenheim, Ulrich / Stieper, Malte, in: Schricker, Gerhard / Loewenheim, Ulrich (Hg.),: Urheberrecht, 6. Aufl., 2020, UrhG § 53 Rn. 32.  
<sup>4</sup> Vgl. zur Vorgängervorschrift: Jani, Ole in: Wandtke, Artur-Axel / Bullinger, Winfried (Hg.): Praxiskommentar Urheberrecht, 6. Aufl., München 2022, UrhG § 53a Rn. 15.  
<sup>5</sup> Dreier, in: Dreier, Thomas / Schulze, Gernot (Hg.): Urheberrechtsgesetz, 7. Aufl., 2022, UrhG § 53 Rn. 46.  
<sup>6</sup> [EuGH, Urteil vom 17. 4. 2008 – C-456/06 – Peek & Cloppenburg KG/Cassina SpA, Le-Corbusier-Möbel](https://curia.europa.eu/juris/liste.jsf?language=de&num=C-456/06).
[/format-annotation]
