---
title: '4.5. Urheberrechtliche Beurteilung des Streaming'
taxonomy:
    category:
        - docs
---

Für die Rezeption von Film und anderer audiovisueller Medien ist Streaming längst der Standardfall. Nicht nur ist der breite Markt an Bezahlmodellen von Anbietern wie Netflix oder Amazon Prime gewachsen, sondern es haben sich auch die frei zugänglichen Videoportale wie YouTube oder Vimeo als Distributionsform künstlerischer, politischer oder journalistischer Inhalte etabliert. Sie ermöglichen jeder Person, als Sender aufzutreten und Inhalte zu verbreiten.

Wer Streaming-Inhalte selbst öffentlich wiedergibt, benötigt dafür entsprechende Rechte. Wer also ohne entsprechende Rechte audiovisuelle Inhalte online stellt, begeht eine Urheberrechtsverletzung – das ist rechtlich unumstritten. Beim Betrachten ist die Rechtslage weniger klar. So ist das Betrachten illegaler Streams – etwa auf Seiten wie [kinox.to](http://kinox.to) – schon seit Längerem rechtlich umstritten.

Beim Streaming wird – anders als beim Herunterladen von Filmen oder beim Werkgenuss über Blu-ray oder DVD – ein audiovisueller Inhalt direkt online im Browser angeschaut. Streaming ähnelt insoweit aus Sicht der Rezipient:innen eher dem Fernsehen. Technisch gesehen handelt es sich beim Streaming um flüchtige Kopien: Es werden keine dauerhaften Vervielfältigungen auf dem Computer oder dem Endgerät angelegt, sondern die Kopien löschen sich wieder selbst.

Grundsätzlich ist der reine Werkgenuss als solcher urheberrechtlich unerheblich. Dies ist beim Fernsehen ebenso unstreitig wie beim Radiohören. Beim Streaming finden jedoch – wie immer bei Nutzung von Digitaltechnologie – Vervielfältigungen statt, da im Zwischenspeicher oder Arbeitsspeicher des Computers Kopien erzeugt werden.

Die urheberrechtliche Bewertung des Betrachtens illegaler Streams ist nicht endgültig geklärt. Im Allgemeinen hat der Europäische Gerichtshof in den letzten Jahren die Haftung für den Zugriff auf illegale Streams ausgeweitet. So hat er den Verkauf eines Mediaplayers mit einer speziellen Software, mit der sich gezielt auf illegale Inhalte zugreifen lässt, als Urheberrechtsverletzung eingestuft, weil es sich auch dabei um eine „öffentliche Wiedergabe“ handele, die der Erlaubnis der Rechteinhaber:innen bedarf.<sup>1</sup>

Auch wenn der Europäische Gerichtshof sich nicht unmittelbar mit dem privaten Konsum befasst hat, wird man möglicherweise davon ausgehen müssen, dass der strenge Haftungsmaßstab bei illegalen Streams durch den Verkauf entsprechender Zugangsgeräte auch auf das private Betrachten illegaler Streams anwendbar ist.<sup>2</sup> Sicher ist dies aber nicht. Anknüpfungspunkt der juristischen Diskussion ist, dass im Rahmen des Streamings nach [§ 44a UrhG](https://www.gesetze-im-internet.de/urhg/__44a.html) „flüchtige Kopien“ zwar unter bestimmten Umständen vom Vervielfältigungsrecht ausgenommen sind. Eben diese Vorschrift ist aber zumindest beim kommerziellen, professionellen Vertrieb von Abspielgeräten für illegale Streams nicht anwendbar, rechtfertigt derlei Kopien folglich nicht. Insbesondere fehlt es dabei an einer Voraussetzung des [§ 44a UrhG](https://www.gesetze-im-internet.de/urhg/__44a.html), nämlich, dass die Nutzungshandlung keine eigenständige wirtschaftliche Bedeutung hat. Ob sich diese Wertung auf jegliche private Nutzung von Streaming-Angeboten übertragen lässt, bleibt abzuwarten.

Diskutieren kann man beim nicht öffentlichen Betrachten illegaler Streams schließlich noch, ob die dabei angefertigten flüchtigen Kopien unter die gesetzlich erlaubte Privatkopie fallen ([§ 53 UrhG](https://www.gesetze-im-internet.de/urhg/__53.html)). Allerdings ist die Privatkopie ausgeschlossen, wenn die Vorlage „offensichtlich rechtswidrig“ ist. Bei Plattformen wie [kinox.to](http://kinox.to), die erkennbar illegal Filme bereithalten, wird man davon ausgehen müssen, dass die Vorlage offensichtlich rechtswidrig ist; die gesetzlichen Voraussetzungen der Privatkopie sind dann nicht erfüllt.

Im Ergebnis stellt also das Betrachten illegaler Streams wohl eine Urheberrechtsverletzung dar. Allerdings dürfte das Risiko der Rechtsverfolgung beim Betrachten auch illegaler Streams eher gering sein, zumal die Kreativindustrie bei der Durchsetzung ihrer Rechte primär die Plattformen im Fokus hat, die die illegalen Streams bereitstellen.

[details="Schwierigkeiten in der Rechtsdurchsetzung"]
Wegen Schwierigkeiten in der Rechtsdurchsetzung gegenüber Plattformen mit illegalen Streams gehen Rechteinhaber:innen auch den Weg über Internet-Zugangsanbieter:innen. Zu nennen ist hier etwa die „Clearingstelle Urheberrecht im Internet“ ([CUII](https://cuii.info/ueber-uns/)), ein Zusammenschluss zwischen Rechteinhaber:innen und Zugangsprovidern, der den Zugang zu „strukturell urheberrechtsverletzenden Webseiten“ unterbinden soll, wenn auch nicht ohne bedenkliche Gefahren überbordender Sperrung von legalen Inhalten im Netz.
[/details]

Es gibt noch einen weiteren Aspekt: Bei audiovisuellen Inhalten auf YouTube, bei denen fraglich ist, ob sie mit Erlaubnis der Rechteinhaber:innen hochgeladen wurden, kommt man zu einem anderen Ergebnis als bei Plattformen, die es gerade auf den illegalen Zugang zu Filmen etc. angelegt haben. So lässt sich hier mit guten Gründen argumentieren, dass Inhalte auf YouTube und vergleichbaren Plattformen gar nicht „offensichtlich“ rechtswidrig sein können. Denn dort springen in der Regel Erkennungs- und Filtersysteme an, die bereits den illegalen Upload verhindern. Hierzu sind Plattformen wie YouTube nach der Reform des EU-Urheberrechts im Jahr 2019 und der Einführung des „Gesetzes über die urheberrechtliche Verantwortlichkeit von Diensteanbietern für das Teilen von Online-Inhalten“ (kurz Urheberrechts-Diensteanbieter-Gesetz, noch kürzer [UrhDaG](https://www.gesetze-im-internet.de/urhdag/BJNR121500021.html)) auch gesetzlich verpflichtet – mit der Konsequenz: Filme, die auf YouTube abrufbar sind und über deren Rechteklärung man sich als Betrachter:in nicht sicher ist, sind nicht „offensichtlich“ illegal online. Für Plattformen wie [kinox.to](http://kinox.to) wird man diese Argumentation aber nicht vorbringen können.

Schließlich: Vom reinen Betrachten zu unterscheiden ist die dauerhafte lokale Speicherung oder Echtzeit-Aufzeichnung gestreamter Inhalte. Sie stellt in jedem Fall eine dauerhafte Vervielfältigung dar und berührt damit das Vervielfältigungsrecht aus [§ 16 UrhG](https://www.gesetze-im-internet.de/urhg/__16.html). Hierfür sind Forschende bei urheberrechtlich geschützten Inhalten auf eine Schrankenregelung wie beispielsweise der Vervielfältigung zu wissenschaftlichen Zwecken ([§ 60c UrhG](https://www.gesetze-im-internet.de/urhg/__60c.html)) angewiesen, die weiter unten im Gutachten dargestellt werden. Außerdem ist es unzulässig, eigenmächtig Kopierschutz von Streaming-Anbietern zu umgehen („wirksame technische Maßnahmen“ nach [§ 95a UrhG](https://www.gesetze-im-internet.de/urhg/__95a.html)).

[format-annotation]
<sup>1</sup> [EuGH GRUR 2017, 610 – Stichting Brein](https://curia.europa.eu/juris/document/document.jsf?text=&docid=191707&pageIndex=0&doclang=DE&mode=req&dir=&occ=first&part=1).  
<sup>2</sup> Stollwerck, Christoph, in: Götting, Horst-Peter / Lauber-Rönsberg, Anne / Rauer, Nils (Hg.): Urheberrecht, 37. Aufl., 2023, UrhG Europäisches Urheberrecht, Rn. 94.
[/format-annotation]
