---
title: '3.3. Urheberrecht vs. Copyright'
taxonomy:
    category:
        - docs
---

Im Gegensatz zum deutschen Urheberrecht, das Urheber:innen als „Schöpfer“ in den Mittelpunkt stellt, steht im anglo-amerikanischen Urheberrecht das Recht, ein Werk zu kopieren, im Vordergrund.

> „Ever since it was created, copyright was directed towards the protection of a reproduction of the work.“

[format-annotation]
Torremans, Paul: Holyoak and Torremans Intellectual Property Law, 9. Auflage, Oxford 2019, S. 173.
[/format-annotation]

Der Schutz des *copyright* ist grundsätzlich darauf ausgerichtet, einen ökonomischen Anreiz für das Erstellen von geistigen Gütern zu schaffen. Das anglo-amerikanische Urheberrecht ist von dem utilitaristischen Grundgedanken geprägt, dass die Zubilligung von Ausschließlichkeitsrechten der Herstellung neuer Werke förderlich ist und davon die Gesellschaft als Ganze profitiert.<sup>1</sup>

In der dem amerikanischen Copyright zugrundeliegenden Ergänzung der Verfassung der Vereinigten Staaten ist die Förderung der Wissenschaft ausdrücklich als Ziel benannt. Dort heißt es:

> *„To promote the Progress of Science and useful Arts, by securing for limited Times to Authors and Inventors the exclusive Right to their respective Writings and Discoveries*."

[format-annotation]
Art. 1 § 8 Cl. 8 US Constitution; siehe dazu auch [de la Durantaye, Katharina: Allgemeine Bildungs- und Wissenschaftsschranke, 2014](https://edoc.hu-berlin.de/handle/18452/19416), S. 163.
[/format-annotation]

In der US-amerikanischen Tradition wird demnach urheberrechtlicher Schutz von dieser Zielsetzung aus bewertet, was gerade im Spannungsfeld von Verwertungsrechten und den wissenschaftlichen Prinzipien des freien Austausches zu einer unterschiedlichen Sicht auf die Interessenlage führen kann.

Urheberpersönlichkeitsrechte existieren auch im britischen und US-amerikanischen Urheberrecht. Allerdings sind sie, anders als in der urheberrechtlichen Tradition Kontinentaleuropas, nicht untrennbar mit den Urheber:innen als „Schöpfer“ eines Werks verbunden, sondern verzichtbar.

Auch in Rechtsordnungen in der Copyright-Tradition existieren Ausnahmeregelungen, die bestimmte Nutzungen von geschützten Werken zustimmungsfrei ermöglichen. Im britischen Recht gibt es im Bereich des Wissenschaftsurheberrechts sektorspezifische Ausnahmeregelungen für Wissenschafts- und Bildungsinstitutionen sowie generellere Ausnahmeregelungen, die eine „faire“ Nutzung unter anderem zum Zweck der Forschung und für private Studien gestatten, allerdings unter sehr detaillierten Bedingungen.<sup>2</sup>

Im US-amerikanischen Recht ist die zentrale Ausnahmeregelung die sogenannte Fair-Use*-*Klausel*,* wonach unter anderem „faire“ Nutzungen für Unterricht, Wissenschaft und Forschung erlaubt sind.<sup>3</sup> Daneben gibt es wenige spezielle Ausnahmeregelungen für Bibliotheken und Archive.<sup>4</sup> Das Recht ist in Bezug auf die Fair-Use-Klausel sehr kasuistisch geprägt.<sup>5</sup>

Um die praktische Anwendung zu erleichtern und Rechtsunsicherheiten entgegenzuwirken, haben sich in den Vereinigten Staaten verschiedene Interessengruppen auf Richtlinien, sogenannte Guidelines verständigt, aus denen hervorgehen soll, wann eine Nutzung „fair“ ist.<sup>6</sup> Insgesamt ist es auf der Grundlage des Fair-Use-Prinzips unter Umständen leichter möglich, auf geänderte Bedingungen aufgrund von neuen technischen Entwicklungen zu reagieren als im deutschen und europäischen Recht mit seinen genau umschriebenen Ausnahmetatbeständen. Fair Use wird häufig als flexibler, dafür aber als weniger rechtssicher betrachtet.

Die britischen und US-amerikanischen Regelungen sind nicht auf das deutsche Recht übertragbar. Sie erklären jedoch, warum an US-amerikanischen Universitäten bestimmte Nutzungen audiovisueller Materialien möglich sind, während dies hier nicht ohne Weiteres der Fall ist.

[format-annotation]
<sup>1</sup> Garnett, Kevin / Davies, Gillian / Harbottle, Gwilym (Hg.): Copinger and Skone James on Copyright, Bd. 1, 16. Aufl., London 2011, Rn. 1–35, 2–05.  
<sup>2</sup> [de la Durantaye, Katharina: Allgemeine Bildungs- und Wissenschaftsschranke, 2014](https://edoc.hu-berlin.de/handle/18452/19416), S. 116 ff.  
<sup>3</sup> [de la Durantaye, Katharina: Allgemeine Bildungs- und Wissenschaftsschranke, 2014](https://edoc.hu-berlin.de/handle/18452/19416), S. 163 ff.  
<sup>4</sup> [de la Durantaye, Katharina: Allgemeine Bildungs- und Wissenschaftsschranke, 2014](https://edoc.hu-berlin.de/handle/18452/19416), S. 164.  
<sup>5</sup> [de la Durantaye, Katharina: Allgemeine Bildungs- und Wissenschaftsschranke, 2014](https://edoc.hu-berlin.de/handle/18452/19416), S. 164 ff.  
<sup>6</sup> [de la Durantaye, Katharina: Allgemeine Bildungs- und Wissenschaftsschranke, 2014](https://edoc.hu-berlin.de/handle/18452/19416), S. 169 ff.
[/format-annotation]
