---
title: '2.6. Leistungsschutz'
taxonomy:
    category:
        - docs
media_order: 2_6_1.jpg
---

Neben dem urheberrechtlichen Schutz können audiovisuelle Medien auch einem Leistungsschutz unterliegen. Ein Leistungsschutzrecht wird auch „verwandtes Schutzrecht“ genannt und entsteht im Gegensatz zum Urheberrechtsschutz, der die persönliche Schöpfung der Urheber:innen honoriert, für eine wirtschaftliche und organisatorische Leistung beispielsweise von Filmhersteller:innen ([§ 94](https://www.gesetze-im-internet.de/urhg/__94.html) und [§ 95 UrhG](https://www.gesetze-im-internet.de/urhg/__95.html)). Filmhersteller:innen sind in der Regel Produzent:innen oder Produktionsfirmen.

Leistungsschutzrechte entstehen auch an Bild- und Tonaufnahmen von urheberrechtlich geschützten Werken. Das kann sogar dann der Fall sein, wenn die Werke selbst keinen Urheberrechtsschutz mehr genießen, da sie gemeinfrei sind. Werden davon neue Aufzeichnungen oder Aufnahmen gemacht, sind diese wiederum leistungsschutzrechtlich geschützt.<sup>1</sup> Etwas anderes gilt nur, wenn es sich um werkgetreue fotografische Reproduktionen von visuellen Werken handelt; solche gelten als bloße Vervielfältigungen des Originals und die Gemeinfreiheit des Originals schlägt auf diese Aufnahme durch. Die Gemeinfreiheit auch von Reprofotografie, wenn das Original ein nicht (mehr) urheberrechtlich geschütztes Werk ist, wurde 2021 im Rahmen der Umsetzung der DSM-Richtlinie gesetzlich verankert ([§ 68 UrhG](https://www.gesetze-im-internet.de/urhg/__68.html)).

Im Einzelfall ist die Abgrenzung zwischen einem als Werk geschützten Film oder Foto und lediglich als Laufbild oder Lichtbild durch Leistungsschutzrechte geschützten Inhalten schwierig. Dies gilt insbesondere bei dokumentarischen Aufnahmen. In der Regel besteht zumindest ein Leistungsschutzrecht.

[image-formats]
![](2_6_1.jpg)
[/image-formats]

[format-annotation]
Das Landgericht Hamburg ([ZUM 2009, 165](https://upload.wikimedia.org/wikipedia/commons/b/b7/ZUM_2009-165_LG_Hamburg_308_O_114-08.pdf)) entschied 2009, dass das Foto „Sprung in die Freiheit eines DDR-Grenzsoldaten“ als Lichtbildwerk zu klassifizieren sei. Das 15. August 1961 von Peter Liebig aufgenommene Foto gehört seit 2011 zum deutschen UNESCO-Weltkulturerbe.
[/format-annotation]

[image-formats]
![](2_6_2.jpg)
[/image-formats]

[format-annotation]
Hingegen wurde die Aufnahme vom Abtransport des an der Berliner Mauer bei einem Fluchtversuch angeschossenen und tödlich verunglückten DDR-Bürgers Peter Fechter (picture-alliance/dpa) vom Kammergericht Berlin ([ZUM-RD 2012, 321, 325](https://dejure.org/dienste/vernetzung/rechtsprechung?Gericht=KG&Datum=28.03.2012&Aktenzeichen=24%20U%2081/11)) der Werkcharakter mit der Begründung abgesprochen, es sei eine aus vorgefundenem, nicht beeinflussten Geschehen, spontane und rein handwerklich möglichst naturgetreue Aufnahme.
[/format-annotation]

Leistungsschutz kommt grundsätzlich in Betracht für Fotograf:innen, wenn ein einfaches Bild kein urheberrechtliches Werk ist ([§ 72 UrhG](https://www.gesetze-im-internet.de/urhg/__72.html)), Sendeunternehmen ([§ 87 UrhG](https://www.gesetze-im-internet.de/urhg/__87.html)), Tonträgerhersteller:innen ([§ 85 UrhG](https://www.gesetze-im-internet.de/urhg/__85.html)), ausübende Künstler:innen wie beispielsweise Schauspieler:innen, Musiker:innen, Sänger:innen oder Tänzer:innen ([§ 73 UrhG](https://www.gesetze-im-internet.de/urhg/__73.html)), Presseverleger:innen ([§ 87f UrhG](https://www.gesetze-im-internet.de/urhg/__87f.html)), Verfasser:innen wissenschaftlicher Ausgaben ([§ 70 UrhG](https://www.gesetze-im-internet.de/urhg/__70.html)), Herausgeber:innen nachgelassener Werke ([§ 71 UrhG](https://www.gesetze-im-internet.de/urhg/__71.html)) sowie für Datenbankhersteller:innen (für Datenbankhersteller:innen gilt der *sui generis-*Schutz der [§§ 87b ff. UrhG](https://www.gesetze-im-internet.de/urhg/__87b.html)).

[format-annotation]
<sup>1</sup> Vgl. dazu auch [Klimpel, Paul: In Bewegung. Die Rechtsfibel für Digitalisierungsprojekte in Kulturerbe-Einrichtungen, hrsg. v. Digitales Deutsches Frauenarchiv, Berlin 2022](https://opus4.kobv.de/opus4-zib/frontdoor/index/index/docId/8648), S. 18 f.
[/format-annotation]
