---
title: '1. Audiovisuelle Materialien in Forschung und Lehre – ein juristisches Minenfeld?'
taxonomy:
    category:
        - docs
---

Der amerikanische Jurist Michael C. Donaldson schrieb zu Filmen:

> „Filme sind die Familienfotos unserer Kultur. Die Archive sind die Alben für diese fotografischen Schätze. Bewegte Bilder spiegeln die Kultur wider und beeinflussen gleichzeitig auch die öffentliche Wahrnehmung. Vielleicht hat keine andere Kunstform so effektiv die Entwicklung einer Gesellschaft erfasst und sich dabei auch selbst so grundlegend gewandelt. Von seiner Gründung im späten neunzehnten Jahrhundert bis in die vollständig globalisierte, zu ständig neuen Innovationen strebende Technik heute, stets hat der Film das kulturelle Milieu seiner Zeit reflektiert. Dadurch wurde der Film zu einer ganz eigenen Kulturtechnik, die eigenen Gesetzen folgt.“

[format-annotation]
Donaldson, Michael C.: Fair Use und Archivierung, in: Klimpel, Paul (Hg.): Bewegte Bilder – starres Recht?, Berlin 2011, S. 31.
[/format-annotation]

Audiovisuelle Materialien gehören zum Alltag in den Wissenschaften. Dies gilt insbesondere für die Film- und Medienwissenschaften, bei denen bewegte Bilder das Objekt der Betrachtung und Analyse sind. Besonders relevant sind sie auch für die Geschichtswissenschaften, da audiovisuelle Materialien wichtige Zeitzeugnisse sind. Doch auch darüber hinaus spielen sie in allen wissenschaftlichen Disziplinen heute eine wichtige Rolle.

Das auf die Kontrolle der Verbreitung und auf wirtschaftliche Verwertung ausgerichtete Urheberrecht steht in einem Spannungsverhältnis zu den wissenschaftlichen Prinzipien des offenen Austausches, der ungehinderten Nachprüfbarkeit von Quellen und des freien Zugangs.

Mit der Digitalisierung hat dieses Spannungsverhältnis noch einmal eine größere Relevanz bekommen. Dies gilt zum einen, weil in der digitalen Welt die meisten Nutzungen mit Kopien verbunden sind und dadurch einer urheberrechtlichen Bewertung unterliegen. Zum anderen stellt aus Sicht der traditionellen urheberrechtlichen Verwertungsmodelle die leichte Kopierbarkeit eine Bedrohung dar, während sie aus Sicht der Wissenschaft eine große Chance für Austausch und Nachprüfbarkeit eröffnet. Das in zahlreichen **Erklärungen** manifestierte Streben nach „Open Access“ manifestiert den Wunsch der Wissenschaft, die Prinzipien des offenen Austausches – die sehr viel älter sind als das Urheberrecht – auch in dessen Geltungsbereich und unter den geänderten Bedingungen der Digitalisierung zur Geltung zu bringen.

[details="Erklärungen zu Open Access"]
*   [Berliner Erklärung über den offenen Zugang zu wissenschaftlichem Wissen vom 22. Oktober 2003](https://openaccess.mpg.de/Berliner-Erklaerung), abgerufen am 16. März 2023
*   [Budapest Open Access Initiative](https://www.budapestopenaccessinitiative.org/read/), abgerufen am 16. März 2023
*   [Charter of ECHO](https://echo.mpiwg-berlin.mpg.de/policy/oa_basics/charter), abgerufen am 16. März 2023
*   [Bethesda Statement on Open Access Publishing](https://dash.harvard.edu/handle/1/4725199), abgerufen am 16. März 2023
[/details]

Zuletzt gehört der Film aus der Perspektive des Urheberrechts zu den komplexesten und schwierigsten Kulturerzeugnissen. Dies gilt gerade im Hinblick auf neuere Nutzungsformen, wie sie sich erst infolge der Digitalisierung entwickelt haben. Hier sind in den letzten Jahren über Jahrzehnte gewachsene Auswertungszyklen (nachfolgend erst Kino, dann Video und Fernsehauswertung) neuen Vermarktungsformen gewichen, insbesondere infolge des Erfolgs von Streaming-Plattformen. Hinzu kommt, dass es neben den professionellen Film- und Serienproduktionen eine große Bandbreite von privaten und semiprofessionellen Bewegtbildproduktionen gibt, die vornehmlich über soziale Medien veröffentlicht werden und damit anderen Prinzipien folgen als der traditionellen Verwertungslogik, deren Grundlage das Urheberrecht ist.

Das Spannungsverhältnis zwischen Wissenschaft und Urheberrecht, die Komplexität urheberrechtlicher Bewertungen von Filmen, die neuen Produktions- und Rezeptionsumstände und nicht zuletzt die gestiegene Bedeutung des Urheberrechts in der digitalen Welt haben dazu geführt, dass audiovisuelle Materialien in der Wissenschaft zwar zunehmend wichtiger werden, die Rahmenbedingungen für deren Nutzung jedoch als ein nur schwer zu überblickendes Dickicht erscheinen. Dieses Gutachten soll hier Abhilfe schaffen und für mehr rechtliche Klarheit beider Nutzung audiovisueller Materialien in Forschung und Lehre sorgen.
