!   
!    Outputting TAL-SH Fortran code generated with :
!      Codegen, a toolset to process tensor contraction DSLs (SIAL etc)
!      Andre Gomes (CNRS UMR8523, Lille) and Dmitry Lyakh (OCLF, Oak Ridge)
!   
subroutine generic_codegen_call(nocc,nvir, &
    H24, &
    S43, &
    H15, &
    S44, &
    H2, &
    H1, &
    H17, &
    H18, &
    H25, &
    H16, &
    S45, &
    H5, &
    H3, &
    H19, &
    H4, &
    H26, &
    Z52, &
    Z53, &
    Z54, &
    Z55)


    use talsh
    use tensor_algebra
    use, intrinsic:: ISO_C_BINDING


    implicit none


    complex(8), parameter :: ZERO=(0.D0,0.D0),ONE_HALF=(0.5D0,0.D0), &
                             MINUS_ONE=(-1.D0,0.D0),ONE=(1.0D0,0.D0), MINUS_ONE_HALF=(-0.5D0,0.D0), &
                             MINUS_ONE_QUARTER=(-0.25D0,0.D0), ONE_QUARTER=(0.25D0,0.D0), &
                             MINUS_ONE_EIGHT=(-0.125D0,0.D0)


    integer :: ierr


    integer, intent(in) :: nocc
    integer, intent(in) :: nvir
    type(talsh_tens_t), intent(inout) :: H24    !       OOVV
    type(talsh_tens_t), intent(inout) :: S43    !       VO
    type(talsh_tens_t), intent(inout) :: H15    !       OV
    type(talsh_tens_t), intent(inout) :: S44    !       VVOO
    type(talsh_tens_t), intent(inout) :: H2    !       VO
    type(talsh_tens_t), intent(inout) :: H1    !       VV
    type(talsh_tens_t), intent(inout) :: H17    !       VOVV
    type(talsh_tens_t), intent(inout) :: H18    !       VOOV
    type(talsh_tens_t), intent(inout) :: H25    !       OOOV
    type(talsh_tens_t), intent(inout) :: H16    !       OO
    type(talsh_tens_t), intent(inout) :: S45    !       VVVOOO
    type(talsh_tens_t), intent(inout) :: H5    !       VVOO
    type(talsh_tens_t), intent(inout) :: H3    !       VVVV
    type(talsh_tens_t), intent(inout) :: H19    !       VOOO
    type(talsh_tens_t), intent(inout) :: H4    !       VVOV
    type(talsh_tens_t), intent(inout) :: H26    !       OOOO
    type(talsh_tens_t), intent(inout) :: Z52    !       UnitTensor
    type(talsh_tens_t), intent(inout) :: Z53    !       VO
    type(talsh_tens_t), intent(inout) :: Z54    !       VVOO
    type(talsh_tens_t), intent(inout) :: Z55    !       VVVOOO
    type(talsh_tens_t) :: Z65_1    !       OV
    type(talsh_tens_t) :: Z64_1    !       OO
    type(talsh_tens_t) :: Z65_2    !       OV
    type(talsh_tens_t) :: Z62_1    !       VV
    type(talsh_tens_t) :: Z93_1    !       OOOV
    type(talsh_tens_t) :: Z71_1    !       VOOO
    type(talsh_tens_t) :: Z91_2    !       OOOO
    type(talsh_tens_t) :: Z110_3    !       OOOV
    type(talsh_tens_t) :: Z100_2    !       VOOV
    type(talsh_tens_t) :: Z110_2    !       OOOV
    type(talsh_tens_t) :: Z78_1    !       VVOV
    type(talsh_tens_t) :: Z66_1    !       OOOO
    type(talsh_tens_t) :: Z93_2    !       OOOV
    type(talsh_tens_t) :: Z100_1    !       VOOV
    type(talsh_tens_t) :: Z76_1    !       VVOOOO
    type(talsh_tens_t) :: Z98_2    !       VOOOOO
    type(talsh_tens_t) :: Z72_1    !       VOOOOO


    ierr=talsh_tensor_construct(Z65_1, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_1(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)*0.5
    ierr=talsh_tensor_contract("Z65_1(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_1,H24,S43,scale=(0.5d0,0.0d0))
!   original expression: Z52(|)+=S43(d1b|l1b)*Z65_1(l1b|d1b)
    ierr=talsh_tensor_contract("Z52()+=S43(d1,l1)*Z65_1(l1,d1)", &
        Z52,S43,Z65_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_1)
!   original expression: Z52(|)+=S43(d1b|l1b)*H15(l1b|d1b)
    ierr=talsh_tensor_contract("Z52()+=S43(d1,l1)*H15(l1,d1)", &
        Z52,S43,H15,scale=(1.0d0,0.0d0))
!   original expression: Z52(|)+=S44(d1bd2b|l1bl2b)*H24(l1bl2b|d1bd2b)
    ierr=talsh_tensor_contract("Z52()+=S44(d1,d2,l1,l2)*H24(l1,l2,d1,d2)", &
        Z52,S44,H24,scale=(0.25d0,0.0d0))
!   original expression: Z53(e1b|m1b)+=H2(e1b|m1b)
    ierr=talsh_tensor_add("Z53(e1,m1)+=H2(e1,m1)", &
        Z53,H2,scale=(1.0d0,0.0d0))
!   original expression: Z53(e1b|m1b)+=H1(e1b|d1b)*S43(d1b|m1b)
    ierr=talsh_tensor_contract("Z53(e1,m1)+=H1(e1,d1)*S43(d1,m1)", &
        Z53,H1,S43,scale=(1.0d0,0.0d0))
!   original expression: Z53(e1b|m1b)+=H17(e1b,l1b|d1bd2b)*S44(d1bd2b|m1b,l1b)
    ierr=talsh_tensor_contract("Z53(e1,m1)+=H17(e1,l1,d1,d2)*S44(d1,d2,m1,l1)", &
        Z53,H17,S44,scale=(0.5d0,0.0d0))
!   original expression: Z53(e1b|m1b)+=H18(e1b,l1b|m1b,d1b)*S43(d1b|l1b)
    ierr=talsh_tensor_contract("Z53(e1,m1)+=H18(e1,l1,m1,d1)*S43(d1,l1)", &
        Z53,H18,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=H25(l1b,l2b|m1b,d1b)*S43(d1b|l2b)*-1.
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=H25(l1,l2,m1,d1)*S43(d1,l2)", &
        Z64_1,H25,S43,scale=(-1.0d0,0.0d0))
!   original expression: Z53(e1b|m1b)+=S43(e1b|l1b)*Z64_1(l1b|m1b)
    ierr=talsh_tensor_contract("Z53(e1,m1)+=S43(e1,l1)*Z64_1(l1,m1)", &
        Z53,S43,Z64_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z53(e1b|m1b)+=S43(e1b|l1b)*Z64_1(l1b|m1b)
    ierr=talsh_tensor_contract("Z53(e1,m1)+=S43(e1,l1)*Z64_1(l1,m1)", &
        Z53,S43,Z64_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_2(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)*-1.
    ierr=talsh_tensor_contract("Z65_2(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_2,H24,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S43(d1b|m1b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S43(d1,m1)*Z65_2(l1,d1)", &
        Z64_1,S43,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
!   original expression: Z53(e1b|m1b)+=S43(e1b|l1b)*Z64_1(l1b|m1b)
    ierr=talsh_tensor_contract("Z53(e1,m1)+=S43(e1,l1)*Z64_1(l1,m1)", &
        Z53,S43,Z64_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S43(d1b|m1b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S43(d1,m1)*Z65_2(l1,d1)", &
        Z64_1,S43,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
!   original expression: Z53(e1b|m1b)+=S43(e1b|l1b)*Z64_1(l1b|m1b)
    ierr=talsh_tensor_contract("Z53(e1,m1)+=S43(e1,l1)*Z64_1(l1,m1)", &
        Z53,S43,Z64_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S43(d1b|m1b)*H15(l1b|d1b)*-1.
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S43(d1,m1)*H15(l1,d1)", &
        Z64_1,S43,H15,scale=(-1.0d0,0.0d0))
!   original expression: Z53(e1b|m1b)+=S43(e1b|l1b)*Z64_1(l1b|m1b)
    ierr=talsh_tensor_contract("Z53(e1,m1)+=S43(e1,l1)*Z64_1(l1,m1)", &
        Z53,S43,Z64_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S44(d1bd2b|m1b,l2b)*H24(l1b,l2b|d1bd2b)*-1.
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S44(d1,d2,m1,l2)*H24(l1,l2,d1,d2)", &
        Z64_1,S44,H24,scale=(-0.5d0,0.0d0))
!   original expression: Z53(e1b|m1b)+=S43(e1b|l1b)*Z64_1(l1b|m1b)
    ierr=talsh_tensor_contract("Z53(e1,m1)+=S43(e1,l1)*Z64_1(l1,m1)", &
        Z53,S43,Z64_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z53(e1b|m1b)+=S43(e1b|l1b)*Z64_1(l1b|m1b)
    ierr=talsh_tensor_contract("Z53(e1,m1)+=S43(e1,l1)*Z64_1(l1,m1)", &
        Z53,S43,Z64_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
!   original expression: Z53(e1b|m1b)+=S43(e1b|l1b)*H16(l1b|m1b)*-1.
    ierr=talsh_tensor_contract("Z53(e1,m1)+=S43(e1,l1)*H16(l1,m1)", &
        Z53,S43,H16,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
!   original expression: Z62_1(e1b|d1b)+=H17(e1b,l1b|d1b,d2b)*S43(d2b|l1b)
    ierr=talsh_tensor_contract("Z62_1(e1,d1)+=H17(e1,l1,d1,d2)*S43(d2,l1)", &
        Z62_1,H17,S43,scale=(1.0d0,0.0d0))
!   original expression: Z53(e1b|m1b)+=S43(d1b|m1b)*Z62_1(e1b|d1b)
    ierr=talsh_tensor_contract("Z53(e1,m1)+=S43(d1,m1)*Z62_1(e1,d1)", &
        Z53,S43,Z62_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
!   original expression: Z53(e1b|m1b)+=S43(d1b|m1b)*Z62_1(e1b|d1b)
    ierr=talsh_tensor_contract("Z53(e1,m1)+=S43(d1,m1)*Z62_1(e1,d1)", &
        Z53,S43,Z62_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z93_1, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z93_1(l1bl2b|m1b,d1b)+=H24(l1bl2b|d1b,d2b)*S43(d2b|m1b)
    ierr=talsh_tensor_contract("Z93_1(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z93_1,H24,S43,scale=(1.0d0,0.0d0))
!   original expression: Z53(e1b|m1b)+=S44(e1b,d1b|l1bl2b)*Z93_1(l1bl2b|m1b,d1b)
    ierr=talsh_tensor_contract("Z53(e1,m1)+=S44(e1,d1,l1,l2)*Z93_1(l1,l2,m1,d1)", &
        Z53,S44,Z93_1,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z93_1)
!   original expression: Z53(e1b|m1b)+=S44(e1b,d1b|l1bl2b)*H25(l1bl2b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z53(e1,m1)+=S44(e1,d1,l1,l2)*H25(l1,l2,m1,d1)", &
        Z53,S44,H25,scale=(-0.5d0,0.0d0))
    ierr=talsh_tensor_construct(Z65_1, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_1(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)
    ierr=talsh_tensor_contract("Z65_1(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_1,H24,S43,scale=(1.0d0,0.0d0))
!   original expression: Z53(e1b|m1b)+=S44(e1b,d1b|m1b,l1b)*Z65_1(l1b|d1b)
    ierr=talsh_tensor_contract("Z53(e1,m1)+=S44(e1,d1,m1,l1)*Z65_1(l1,d1)", &
        Z53,S44,Z65_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_1)
    ierr=talsh_tensor_construct(Z65_1, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z53(e1b|m1b)+=S44(e1b,d1b|m1b,l1b)*Z65_1(l1b|d1b)
    ierr=talsh_tensor_contract("Z53(e1,m1)+=S44(e1,d1,m1,l1)*Z65_1(l1,d1)", &
        Z53,S44,Z65_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_1)
!   original expression: Z53(e1b|m1b)+=S44(e1b,d1b|m1b,l1b)*H15(l1b|d1b)
    ierr=talsh_tensor_contract("Z53(e1,m1)+=S44(e1,d1,m1,l1)*H15(l1,d1)", &
        Z53,S44,H15,scale=(1.0d0,0.0d0))
!   original expression: Z53(e1b|m1b)+=S45(e1b,d1bd2b|m1b,l1bl2b)*H24(l1bl2b|d1bd2b)
    ierr=talsh_tensor_contract("Z53(e1,m1)+=S45(e1,d1,d2,m1,l1,l2)*H24(l1,l2,d1,d2)", &
        Z53,S45,H24,scale=(0.25d0,0.0d0))
    ierr=talsh_tensor_construct(Z65_1, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_1(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)
    ierr=talsh_tensor_contract("Z65_1(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_1,H24,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_1)
    ierr=talsh_tensor_construct(Z65_1, C8, (/nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z65_1)
!   original expression: Z54(e1be2b|m1bm2b)+=H5(e1be2b|m1bm2b)
    ierr=talsh_tensor_add("Z54(e1,e2,m1,m2)+=H5(e1,e2,m1,m2)", &
        Z54,H5,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=H3(e1be2b|d1bd2b)*S44(d1bd2b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=H3(e1,e2,d1,d2)*S44(d1,d2,m1,m2)", &
        Z54,H3,S44,scale=(0.5d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=H19(e1b,l1b|m1bm2b)*S43(e2b|l1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=H19(e1,l1,m1,m2)*S43(e2,l1)", &
        Z54,H19,S43,scale=(-1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=H19(e2b,l1b|m1bm2b)*S43(e1b|l1b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=H19(e2,l1,m1,m2)*S43(e1,l1)", &
        Z54,H19,S43,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=H4(e1be2b|m1b,d1b)*S43(d1b|m2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=H4(e1,e2,m1,d1)*S43(d1,m2)", &
        Z54,H4,S43,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=H4(e1be2b|m2b,d1b)*S43(d1b|m1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=H4(e1,e2,m2,d1)*S43(d1,m1)", &
        Z54,H4,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=H17(e1b,l1b|d1bd2b)*S44(d1bd2b|m1bm2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=H17(e1,l1,d1,d2)*S44(d1,d2,m1,m2)", &
        Z71_1,H17,S44,scale=(0.5d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e1b|l1b)*Z71_1(e2b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e1,l1)*Z71_1(e2,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e2b|l1b)*Z71_1(e1b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e2,l1)*Z71_1(e1,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=H26(l1b,l2b|m1bm2b)*S43(e1b|l2b)*0.5
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=H26(l1,l2,m1,m2)*S43(e1,l2)", &
        Z71_1,H26,S43,scale=(0.5d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e1b|l1b)*Z71_1(e2b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e1,l1)*Z71_1(e2,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e2b|l1b)*Z71_1(e1b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e2,l1)*Z71_1(e1,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=H18(e1b,l1b|m1b,d1b)*S43(d1b|m2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=H18(e1,l1,m1,d1)*S43(d1,m2)", &
        Z71_1,H18,S43,scale=(1.0d0,0.0d0))
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=H18(e1b,l1b|m2b,d1b)*S43(d1b|m1b)*-1.
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=H18(e1,l1,m2,d1)*S43(d1,m1)", &
        Z71_1,H18,S43,scale=(-1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e1b|l1b)*Z71_1(e2b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e1,l1)*Z71_1(e2,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e2b|l1b)*Z71_1(e1b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e2,l1)*Z71_1(e1,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z91_2, C8, (/nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z91_2(l1b,l2b|m1bm2b)+=H24(l1b,l2b|d1bd2b)*S44(d1bd2b|m1bm2b)*0.5
    ierr=talsh_tensor_contract("Z91_2(l1,l2,m1,m2)+=H24(l1,l2,d1,d2)*S44(d1,d2,m1,m2)", &
        Z91_2,H24,S44,scale=(0.25d0,0.0d0))
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S43(e1b|l2b)*Z91_2(l1b,l2b|m1bm2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S43(e1,l2)*Z91_2(l1,l2,m1,m2)", &
        Z71_1,S43,Z91_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z91_2)
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e1b|l1b)*Z71_1(e2b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e1,l1)*Z71_1(e2,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e2b|l1b)*Z71_1(e1b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e2,l1)*Z71_1(e1,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z91_2, C8, (/nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z91_2(l1b,l2b|m1bm2b)+=H25(l1b,l2b|m1b,d1b)*S43(d1b|m2b)*0.5
    ierr=talsh_tensor_contract("Z91_2(l1,l2,m1,m2)+=H25(l1,l2,m1,d1)*S43(d1,m2)", &
        Z91_2,H25,S43,scale=(0.5d0,0.0d0))
!   original expression: Z91_2(l1b,l2b|m1bm2b)+=H25(l1b,l2b|m2b,d1b)*S43(d1b|m1b)*-0.5
    ierr=talsh_tensor_contract("Z91_2(l1,l2,m1,m2)+=H25(l1,l2,m2,d1)*S43(d1,m1)", &
        Z91_2,H25,S43,scale=(-0.5d0,0.0d0))
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S43(e1b|l2b)*Z91_2(l1b,l2b|m1bm2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S43(e1,l2)*Z91_2(l1,l2,m1,m2)", &
        Z71_1,S43,Z91_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z91_2)
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e1b|l1b)*Z71_1(e2b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e1,l1)*Z71_1(e2,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e2b|l1b)*Z71_1(e1b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e2,l1)*Z71_1(e1,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z110_3, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z110_3(l1b,l2b|m1b,d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|m1b)*0.25
    ierr=talsh_tensor_contract("Z110_3(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z110_3,H24,S43,scale=(0.25d0,0.0d0))
    ierr=talsh_tensor_construct(Z91_2, C8, (/nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z91_2(l1b,l2b|m1bm2b)+=S43(d1b|m1b)*Z110_3(l1b,l2b|m2b,d1b)
    ierr=talsh_tensor_contract("Z91_2(l1,l2,m1,m2)+=S43(d1,m1)*Z110_3(l1,l2,m2,d1)", &
        Z91_2,S43,Z110_3,scale=(1.0d0,0.0d0))
!   original expression: Z91_2(l1b,l2b|m1bm2b)+=S43(d1b|m2b)*Z110_3(l1b,l2b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z91_2(l1,l2,m1,m2)+=S43(d1,m2)*Z110_3(l1,l2,m1,d1)", &
        Z91_2,S43,Z110_3,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z110_3)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S43(e1b|l2b)*Z91_2(l1b,l2b|m1bm2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S43(e1,l2)*Z91_2(l1,l2,m1,m2)", &
        Z71_1,S43,Z91_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z91_2)
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e1b|l1b)*Z71_1(e2b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e1,l1)*Z71_1(e2,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e2b|l1b)*Z71_1(e1b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e2,l1)*Z71_1(e1,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z100_2, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z100_2(e1b,l1b|m1b,d1b)+=H17(e1b,l1b|d1b,d2b)*S43(d2b|m1b)*0.5
    ierr=talsh_tensor_contract("Z100_2(e1,l1,m1,d1)+=H17(e1,l1,d1,d2)*S43(d2,m1)", &
        Z100_2,H17,S43,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S43(d1b|m1b)*Z100_2(e1b,l1b|m2b,d1b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S43(d1,m1)*Z100_2(e1,l1,m2,d1)", &
        Z71_1,S43,Z100_2,scale=(1.0d0,0.0d0))
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S43(d1b|m2b)*Z100_2(e1b,l1b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S43(d1,m2)*Z100_2(e1,l1,m1,d1)", &
        Z71_1,S43,Z100_2,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z100_2)
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e1b|l1b)*Z71_1(e2b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e1,l1)*Z71_1(e2,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e2b|l1b)*Z71_1(e1b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e2,l1)*Z71_1(e1,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_2(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)
    ierr=talsh_tensor_contract("Z65_2(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_2,H24,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m1bm2b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m1,m2)*Z65_2(l1,d1)", &
        Z71_1,S44,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e1b|l1b)*Z71_1(e2b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e1,l1)*Z71_1(e2,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e2b|l1b)*Z71_1(e1b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e2,l1)*Z71_1(e1,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m1bm2b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m1,m2)*Z65_2(l1,d1)", &
        Z71_1,S44,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e1b|l1b)*Z71_1(e2b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e1,l1)*Z71_1(e2,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e2b|l1b)*Z71_1(e1b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e2,l1)*Z71_1(e1,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m1bm2b)*H15(l1b|d1b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m1,m2)*H15(l1,d1)", &
        Z71_1,S44,H15,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e1b|l1b)*Z71_1(e2b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e1,l1)*Z71_1(e2,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e2b|l1b)*Z71_1(e1b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e2,l1)*Z71_1(e1,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z110_2, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z110_2(l1b,l2b|m1b,d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|m1b)*-1.
    ierr=talsh_tensor_contract("Z110_2(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z110_2,H24,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m1b,l2b)*Z110_2(l1b,l2b|m2b,d1b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m1,l2)*Z110_2(l1,l2,m2,d1)", &
        Z71_1,S44,Z110_2,scale=(1.0d0,0.0d0))
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m2b,l2b)*Z110_2(l1b,l2b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m2,l2)*Z110_2(l1,l2,m1,d1)", &
        Z71_1,S44,Z110_2,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z110_2)
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e1b|l1b)*Z71_1(e2b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e1,l1)*Z71_1(e2,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e2b|l1b)*Z71_1(e1b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e2,l1)*Z71_1(e1,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m1b,l2b)*H25(l1b,l2b|m2b,d1b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m1,l2)*H25(l1,l2,m2,d1)", &
        Z71_1,S44,H25,scale=(1.0d0,0.0d0))
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m2b,l2b)*H25(l1b,l2b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m2,l2)*H25(l1,l2,m1,d1)", &
        Z71_1,S44,H25,scale=(-1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e1b|l1b)*Z71_1(e2b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e1,l1)*Z71_1(e2,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e2b|l1b)*Z71_1(e1b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e2,l1)*Z71_1(e1,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e1b|l1b)*Z71_1(e2b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e1,l1)*Z71_1(e2,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e2b|l1b)*Z71_1(e1b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e2,l1)*Z71_1(e1,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e1b|l1b)*Z71_1(e2b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e1,l1)*Z71_1(e2,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e2b|l1b)*Z71_1(e1b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e2,l1)*Z71_1(e1,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S45(e1b,d1bd2b|m1bm2b,l2b)*H24(l1b,l2b|d1bd2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S45(e1,d1,d2,m1,m2,l2)*H24(l1,l2,d1,d2)", &
        Z71_1,S45,H24,scale=(0.5d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e1b|l1b)*Z71_1(e2b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e1,l1)*Z71_1(e2,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e2b|l1b)*Z71_1(e1b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e2,l1)*Z71_1(e1,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e1b|l1b)*Z71_1(e2b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e1,l1)*Z71_1(e2,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(e2b|l1b)*Z71_1(e1b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(e2,l1)*Z71_1(e1,l1,m1,m2)", &
        Z54,S43,Z71_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z78_1, C8, (/nvir,nvir,nocc,nvir/), init_val=ZERO)
!   original expression: Z78_1(e1be2b|m1b,d1b)+=H3(e1be2b|d1b,d2b)*S43(d2b|m1b)*0.5
    ierr=talsh_tensor_contract("Z78_1(e1,e2,m1,d1)+=H3(e1,e2,d1,d2)*S43(d2,m1)", &
        Z78_1,H3,S43,scale=(0.5d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(d1b|m1b)*Z78_1(e1be2b|m2b,d1b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(d1,m1)*Z78_1(e1,e2,m2,d1)", &
        Z54,S43,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S43(d1b|m2b)*Z78_1(e1be2b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S43(d1,m2)*Z78_1(e1,e2,m1,d1)", &
        Z54,S43,Z78_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z78_1)
    ierr=talsh_tensor_construct(Z66_1, C8, (/nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z66_1(l1bl2b|m1bm2b)+=H25(l1bl2b|m1b,d1b)*S43(d1b|m2b)
    ierr=talsh_tensor_contract("Z66_1(l1,l2,m1,m2)+=H25(l1,l2,m1,d1)*S43(d1,m2)", &
        Z66_1,H25,S43,scale=(1.0d0,0.0d0))
!   original expression: Z66_1(l1bl2b|m1bm2b)+=H25(l1bl2b|m2b,d1b)*S43(d1b|m1b)*-1.
    ierr=talsh_tensor_contract("Z66_1(l1,l2,m1,m2)+=H25(l1,l2,m2,d1)*S43(d1,m1)", &
        Z66_1,H25,S43,scale=(-1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|l1bl2b)*Z66_1(l1bl2b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,l1,l2)*Z66_1(l1,l2,m1,m2)", &
        Z54,S44,Z66_1,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z66_1)
    ierr=talsh_tensor_construct(Z93_2, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z93_2(l1bl2b|m1b,d1b)+=H24(l1bl2b|d1b,d2b)*S43(d2b|m1b)*0.5
    ierr=talsh_tensor_contract("Z93_2(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z93_2,H24,S43,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_construct(Z66_1, C8, (/nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z66_1(l1bl2b|m1bm2b)+=S43(d1b|m1b)*Z93_2(l1bl2b|m2b,d1b)
    ierr=talsh_tensor_contract("Z66_1(l1,l2,m1,m2)+=S43(d1,m1)*Z93_2(l1,l2,m2,d1)", &
        Z66_1,S43,Z93_2,scale=(1.0d0,0.0d0))
!   original expression: Z66_1(l1bl2b|m1bm2b)+=S43(d1b|m2b)*Z93_2(l1bl2b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z66_1(l1,l2,m1,m2)+=S43(d1,m2)*Z93_2(l1,l2,m1,d1)", &
        Z66_1,S43,Z93_2,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z93_2)
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|l1bl2b)*Z66_1(l1bl2b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,l1,l2)*Z66_1(l1,l2,m1,m2)", &
        Z54,S44,Z66_1,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z66_1)
    ierr=talsh_tensor_construct(Z66_1, C8, (/nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z66_1(l1bl2b|m1bm2b)+=S44(d1bd2b|m1bm2b)*H24(l1bl2b|d1bd2b)
    ierr=talsh_tensor_contract("Z66_1(l1,l2,m1,m2)+=S44(d1,d2,m1,m2)*H24(l1,l2,d1,d2)", &
        Z66_1,S44,H24,scale=(0.5d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|l1bl2b)*Z66_1(l1bl2b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,l1,l2)*Z66_1(l1,l2,m1,m2)", &
        Z54,S44,Z66_1,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z66_1)
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|l1bl2b)*H26(l1bl2b|m1bm2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,l1,l2)*H26(l1,l2,m1,m2)", &
        Z54,S44,H26,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
!   original expression: Z62_1(e1b|d1b)+=H17(e1b,l1b|d1b,d2b)*S43(d2b|l1b)
    ierr=talsh_tensor_contract("Z62_1(e1,d1)+=H17(e1,l1,d1,d2)*S43(d2,l1)", &
        Z62_1,H17,S43,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1b,d1b|m1bm2b)*Z62_1(e2b|d1b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,d1,m1,m2)*Z62_1(e2,d1)", &
        Z54,S44,Z62_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e2b,d1b|m1bm2b)*Z62_1(e1b|d1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e2,d1,m1,m2)*Z62_1(e1,d1)", &
        Z54,S44,Z62_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1b,d1b|m1bm2b)*Z62_1(e2b|d1b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,d1,m1,m2)*Z62_1(e2,d1)", &
        Z54,S44,Z62_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e2b,d1b|m1bm2b)*Z62_1(e1b|d1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e2,d1,m1,m2)*Z62_1(e1,d1)", &
        Z54,S44,Z62_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
!   original expression: Z62_1(e1b|d1b)+=S44(e1b,d2b|l1bl2b)*H24(l1bl2b|d1b,d2b)*-1.
    ierr=talsh_tensor_contract("Z62_1(e1,d1)+=S44(e1,d2,l1,l2)*H24(l1,l2,d1,d2)", &
        Z62_1,S44,H24,scale=(-0.5d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1b,d1b|m1bm2b)*Z62_1(e2b|d1b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,d1,m1,m2)*Z62_1(e2,d1)", &
        Z54,S44,Z62_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e2b,d1b|m1bm2b)*Z62_1(e1b|d1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e2,d1,m1,m2)*Z62_1(e1,d1)", &
        Z54,S44,Z62_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1b,d1b|m1bm2b)*Z62_1(e2b|d1b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,d1,m1,m2)*Z62_1(e2,d1)", &
        Z54,S44,Z62_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e2b,d1b|m1bm2b)*Z62_1(e1b|d1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e2,d1,m1,m2)*Z62_1(e1,d1)", &
        Z54,S44,Z62_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z62_1)
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1b,d1b|m1bm2b)*H1(e2b|d1b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,d1,m1,m2)*H1(e2,d1)", &
        Z54,S44,H1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e2b,d1b|m1bm2b)*H1(e1b|d1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e2,d1,m1,m2)*H1(e1,d1)", &
        Z54,S44,H1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=H25(l1b,l2b|m1b,d1b)*S43(d1b|l2b)*-1.
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=H25(l1,l2,m1,d1)*S43(d1,l2)", &
        Z64_1,H25,S43,scale=(-1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|m1b,l1b)*Z64_1(l1b|m2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,m1,l1)*Z64_1(l1,m2)", &
        Z54,S44,Z64_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|m2b,l1b)*Z64_1(l1b|m1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,m2,l1)*Z64_1(l1,m1)", &
        Z54,S44,Z64_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|m1b,l1b)*Z64_1(l1b|m2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,m1,l1)*Z64_1(l1,m2)", &
        Z54,S44,Z64_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|m2b,l1b)*Z64_1(l1b|m1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,m2,l1)*Z64_1(l1,m1)", &
        Z54,S44,Z64_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_2(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)*-1.
    ierr=talsh_tensor_contract("Z65_2(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_2,H24,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S43(d1b|m1b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S43(d1,m1)*Z65_2(l1,d1)", &
        Z64_1,S43,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|m1b,l1b)*Z64_1(l1b|m2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,m1,l1)*Z64_1(l1,m2)", &
        Z54,S44,Z64_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|m2b,l1b)*Z64_1(l1b|m1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,m2,l1)*Z64_1(l1,m1)", &
        Z54,S44,Z64_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S43(d1b|m1b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S43(d1,m1)*Z65_2(l1,d1)", &
        Z64_1,S43,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|m1b,l1b)*Z64_1(l1b|m2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,m1,l1)*Z64_1(l1,m2)", &
        Z54,S44,Z64_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|m2b,l1b)*Z64_1(l1b|m1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,m2,l1)*Z64_1(l1,m1)", &
        Z54,S44,Z64_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S43(d1b|m1b)*H15(l1b|d1b)*-1.
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S43(d1,m1)*H15(l1,d1)", &
        Z64_1,S43,H15,scale=(-1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|m1b,l1b)*Z64_1(l1b|m2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,m1,l1)*Z64_1(l1,m2)", &
        Z54,S44,Z64_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|m2b,l1b)*Z64_1(l1b|m1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,m2,l1)*Z64_1(l1,m1)", &
        Z54,S44,Z64_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S44(d1bd2b|m1b,l2b)*H24(l1b,l2b|d1bd2b)*-1.
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S44(d1,d2,m1,l2)*H24(l1,l2,d1,d2)", &
        Z64_1,S44,H24,scale=(-0.5d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|m1b,l1b)*Z64_1(l1b|m2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,m1,l1)*Z64_1(l1,m2)", &
        Z54,S44,Z64_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|m2b,l1b)*Z64_1(l1b|m1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,m2,l1)*Z64_1(l1,m1)", &
        Z54,S44,Z64_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|m1b,l1b)*Z64_1(l1b|m2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,m1,l1)*Z64_1(l1,m2)", &
        Z54,S44,Z64_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|m2b,l1b)*Z64_1(l1b|m1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,m2,l1)*Z64_1(l1,m1)", &
        Z54,S44,Z64_1,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|m1b,l1b)*H16(l1b|m2b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,m1,l1)*H16(l1,m2)", &
        Z54,S44,H16,scale=(-1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1be2b|m2b,l1b)*H16(l1b|m1b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,e2,m2,l1)*H16(l1,m1)", &
        Z54,S44,H16,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z100_1, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z100_1(e1b,l1b|m1b,d1b)+=H17(e1b,l1b|d1b,d2b)*S43(d2b|m1b)*-1.
    ierr=talsh_tensor_contract("Z100_1(e1,l1,m1,d1)+=H17(e1,l1,d1,d2)*S43(d2,m1)", &
        Z100_1,H17,S43,scale=(-1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1b,d1b|m1b,l1b)*Z100_1(e2b,l1b|m2b,d1b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,d1,m1,l1)*Z100_1(e2,l1,m2,d1)", &
        Z54,S44,Z100_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e2b,d1b|m1b,l1b)*Z100_1(e1b,l1b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e2,d1,m1,l1)*Z100_1(e1,l1,m2,d1)", &
        Z54,S44,Z100_1,scale=(-1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1b,d1b|m2b,l1b)*Z100_1(e2b,l1b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,d1,m2,l1)*Z100_1(e2,l1,m1,d1)", &
        Z54,S44,Z100_1,scale=(-1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e2b,d1b|m2b,l1b)*Z100_1(e1b,l1b|m1b,d1b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e2,d1,m2,l1)*Z100_1(e1,l1,m1,d1)", &
        Z54,S44,Z100_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z100_1)
    ierr=talsh_tensor_construct(Z100_1, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z100_1(e1b,l1b|m1b,d1b)+=S44(e1b,d2b|m1b,l2b)*H24(l1b,l2b|d1b,d2b)*0.5
    ierr=talsh_tensor_contract("Z100_1(e1,l1,m1,d1)+=S44(e1,d2,m1,l2)*H24(l1,l2,d1,d2)", &
        Z100_1,S44,H24,scale=(0.5d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1b,d1b|m1b,l1b)*Z100_1(e2b,l1b|m2b,d1b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,d1,m1,l1)*Z100_1(e2,l1,m2,d1)", &
        Z54,S44,Z100_1,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e2b,d1b|m1b,l1b)*Z100_1(e1b,l1b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e2,d1,m1,l1)*Z100_1(e1,l1,m2,d1)", &
        Z54,S44,Z100_1,scale=(-1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1b,d1b|m2b,l1b)*Z100_1(e2b,l1b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,d1,m2,l1)*Z100_1(e2,l1,m1,d1)", &
        Z54,S44,Z100_1,scale=(-1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e2b,d1b|m2b,l1b)*Z100_1(e1b,l1b|m1b,d1b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e2,d1,m2,l1)*Z100_1(e1,l1,m1,d1)", &
        Z54,S44,Z100_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z100_1)
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1b,d1b|m1b,l1b)*H18(e2b,l1b|m2b,d1b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,d1,m1,l1)*H18(e2,l1,m2,d1)", &
        Z54,S44,H18,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e2b,d1b|m1b,l1b)*H18(e1b,l1b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e2,d1,m1,l1)*H18(e1,l1,m2,d1)", &
        Z54,S44,H18,scale=(-1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e1b,d1b|m2b,l1b)*H18(e2b,l1b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e1,d1,m2,l1)*H18(e2,l1,m1,d1)", &
        Z54,S44,H18,scale=(-1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S44(e2b,d1b|m2b,l1b)*H18(e1b,l1b|m1b,d1b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S44(e2,d1,m2,l1)*H18(e1,l1,m1,d1)", &
        Z54,S44,H18,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S45(e1b,d1bd2b|m1bm2b,l1b)*H17(e2b,l1b|d1bd2b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S45(e1,d1,d2,m1,m2,l1)*H17(e2,l1,d1,d2)", &
        Z54,S45,H17,scale=(0.5d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S45(e2b,d1bd2b|m1bm2b,l1b)*H17(e1b,l1b|d1bd2b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S45(e2,d1,d2,m1,m2,l1)*H17(e1,l1,d1,d2)", &
        Z54,S45,H17,scale=(-0.5d0,0.0d0))
    ierr=talsh_tensor_construct(Z93_1, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z93_1(l1bl2b|m1b,d1b)+=H24(l1bl2b|d1b,d2b)*S43(d2b|m1b)
    ierr=talsh_tensor_contract("Z93_1(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z93_1,H24,S43,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S45(e1be2b,d1b|m1b,l1bl2b)*Z93_1(l1bl2b|m2b,d1b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S45(e1,e2,d1,m1,l1,l2)*Z93_1(l1,l2,m2,d1)", &
        Z54,S45,Z93_1,scale=(0.5d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S45(e1be2b,d1b|m2b,l1bl2b)*Z93_1(l1bl2b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S45(e1,e2,d1,m2,l1,l2)*Z93_1(l1,l2,m1,d1)", &
        Z54,S45,Z93_1,scale=(-0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z93_1)
!   original expression: Z54(e1be2b|m1bm2b)+=S45(e1be2b,d1b|m1b,l1bl2b)*H25(l1bl2b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S45(e1,e2,d1,m1,l1,l2)*H25(l1,l2,m2,d1)", &
        Z54,S45,H25,scale=(-0.5d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S45(e1be2b,d1b|m2b,l1bl2b)*H25(l1bl2b|m1b,d1b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S45(e1,e2,d1,m2,l1,l2)*H25(l1,l2,m1,d1)", &
        Z54,S45,H25,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_construct(Z65_1, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_1(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)
    ierr=talsh_tensor_contract("Z65_1(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_1,H24,S43,scale=(1.0d0,0.0d0))
!   original expression: Z54(e1be2b|m1bm2b)+=S45(e1be2b,d1b|m1bm2b,l1b)*Z65_1(l1b|d1b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S45(e1,e2,d1,m1,m2,l1)*Z65_1(l1,d1)", &
        Z54,S45,Z65_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_1)
    ierr=talsh_tensor_construct(Z65_1, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z54(e1be2b|m1bm2b)+=S45(e1be2b,d1b|m1bm2b,l1b)*Z65_1(l1b|d1b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S45(e1,e2,d1,m1,m2,l1)*Z65_1(l1,d1)", &
        Z54,S45,Z65_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_1)
!   original expression: Z54(e1be2b|m1bm2b)+=S45(e1be2b,d1b|m1bm2b,l1b)*H15(l1b|d1b)
    ierr=talsh_tensor_contract("Z54(e1,e2,m1,m2)+=S45(e1,e2,d1,m1,m2,l1)*H15(l1,d1)", &
        Z54,S45,H15,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_2(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)*-1.
    ierr=talsh_tensor_contract("Z65_2(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_2,H24,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z65_2)
    ierr=talsh_tensor_construct(Z110_2, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z110_2(l1b,l2b|m1b,d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|m1b)
    ierr=talsh_tensor_contract("Z110_2(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z110_2,H24,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z110_2)
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
!   original expression: Z62_1(e1b|d1b)+=H17(e1b,l1b|d1b,d2b)*S43(d2b|l1b)
    ierr=talsh_tensor_contract("Z62_1(e1,d1)+=H17(e1,l1,d1,d2)*S43(d2,l1)", &
        Z62_1,H17,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
!   original expression: Z62_1(e1b|d1b)+=S44(e1b,d2b|l1bl2b)*H24(l1bl2b|d1b,d2b)*-1.
    ierr=talsh_tensor_contract("Z62_1(e1,d1)+=S44(e1,d2,l1,l2)*H24(l1,l2,d1,d2)", &
        Z62_1,S44,H24,scale=(-0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=H25(l1b,l2b|m1b,d1b)*S43(d1b|l2b)*-1.
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=H25(l1,l2,m1,d1)*S43(d1,l2)", &
        Z64_1,H25,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_2(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)*-1.
    ierr=talsh_tensor_contract("Z65_2(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_2,H24,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S43(d1b|m1b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S43(d1,m1)*Z65_2(l1,d1)", &
        Z64_1,S43,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S43(d1b|m1b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S43(d1,m1)*Z65_2(l1,d1)", &
        Z64_1,S43,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S43(d1b|m1b)*H15(l1b|d1b)*-1.
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S43(d1,m1)*H15(l1,d1)", &
        Z64_1,S43,H15,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S44(d1bd2b|m1b,l2b)*H24(l1b,l2b|d1bd2b)*-1.
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S44(d1,d2,m1,l2)*H24(l1,l2,d1,d2)", &
        Z64_1,S44,H24,scale=(-0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z100_1, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z100_1(e1b,l1b|m1b,d1b)+=H17(e1b,l1b|d1b,d2b)*S43(d2b|m1b)*-1.
    ierr=talsh_tensor_contract("Z100_1(e1,l1,m1,d1)+=H17(e1,l1,d1,d2)*S43(d2,m1)", &
        Z100_1,H17,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z100_1)
    ierr=talsh_tensor_construct(Z100_1, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z100_1(e1b,l1b|m1b,d1b)+=S44(e1b,d2b|m1b,l2b)*H24(l1b,l2b|d1b,d2b)
    ierr=talsh_tensor_contract("Z100_1(e1,l1,m1,d1)+=S44(e1,d2,m1,l2)*H24(l1,l2,d1,d2)", &
        Z100_1,S44,H24,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z100_1)
    ierr=talsh_tensor_construct(Z93_1, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z93_1(l1bl2b|m1b,d1b)+=H24(l1bl2b|d1b,d2b)*S43(d2b|m1b)
    ierr=talsh_tensor_contract("Z93_1(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z93_1,H24,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z93_1)
    ierr=talsh_tensor_construct(Z65_1, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_1(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)
    ierr=talsh_tensor_contract("Z65_1(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_1,H24,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_1)
    ierr=talsh_tensor_construct(Z65_1, C8, (/nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z65_1)
    ierr=talsh_tensor_construct(Z65_1, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_1(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)
    ierr=talsh_tensor_contract("Z65_1(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_1,H24,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_1)
    ierr=talsh_tensor_construct(Z65_1, C8, (/nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z65_1)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=H4(e1be2b|m1b,d1b)*S44(e3b,d1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=H4(e1,e2,m1,d1)*S44(e3,d1,m2,m3)", &
        Z55,H4,S44,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=H4(e1be3b|m1b,d1b)*S44(e2b,d1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=H4(e1,e3,m1,d1)*S44(e2,d1,m2,m3)", &
        Z55,H4,S44,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=H4(e2be3b|m1b,d1b)*S44(e1b,d1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=H4(e2,e3,m1,d1)*S44(e1,d1,m2,m3)", &
        Z55,H4,S44,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=H4(e1be2b|m2b,d1b)*S44(e3b,d1b|m1bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=H4(e1,e2,m2,d1)*S44(e3,d1,m1,m3)", &
        Z55,H4,S44,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=H4(e1be3b|m2b,d1b)*S44(e2b,d1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=H4(e1,e3,m2,d1)*S44(e2,d1,m1,m3)", &
        Z55,H4,S44,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=H4(e2be3b|m2b,d1b)*S44(e1b,d1b|m1bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=H4(e2,e3,m2,d1)*S44(e1,d1,m1,m3)", &
        Z55,H4,S44,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=H4(e1be2b|m3b,d1b)*S44(e3b,d1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=H4(e1,e2,m3,d1)*S44(e3,d1,m1,m2)", &
        Z55,H4,S44,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=H4(e1be3b|m3b,d1b)*S44(e2b,d1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=H4(e1,e3,m3,d1)*S44(e2,d1,m1,m2)", &
        Z55,H4,S44,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=H4(e2be3b|m3b,d1b)*S44(e1b,d1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=H4(e2,e3,m3,d1)*S44(e1,d1,m1,m2)", &
        Z55,H4,S44,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z76_1, C8, (/nvir,nvir,nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=H18(e1b,l1b|m1b,d1b)*S44(e2b,d1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=H18(e1,l1,m1,d1)*S44(e2,d1,m2,m3)", &
        Z76_1,H18,S44,scale=(-1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=H18(e2b,l1b|m1b,d1b)*S44(e1b,d1b|m2bm3b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=H18(e2,l1,m1,d1)*S44(e1,d1,m2,m3)", &
        Z76_1,H18,S44,scale=(1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=H18(e1b,l1b|m2b,d1b)*S44(e2b,d1b|m1bm3b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=H18(e1,l1,m2,d1)*S44(e2,d1,m1,m3)", &
        Z76_1,H18,S44,scale=(1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=H18(e2b,l1b|m2b,d1b)*S44(e1b,d1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=H18(e2,l1,m2,d1)*S44(e1,d1,m1,m3)", &
        Z76_1,H18,S44,scale=(-1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=H18(e1b,l1b|m3b,d1b)*S44(e2b,d1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=H18(e1,l1,m3,d1)*S44(e2,d1,m1,m2)", &
        Z76_1,H18,S44,scale=(-1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=H18(e2b,l1b|m3b,d1b)*S44(e1b,d1b|m1bm2b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=H18(e2,l1,m3,d1)*S44(e1,d1,m1,m2)", &
        Z76_1,H18,S44,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e1b|l1b)*Z76_1(e2be3b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e1,l1)*Z76_1(e2,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e2b|l1b)*Z76_1(e1be3b,l1b|m1bm2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e2,l1)*Z76_1(e1,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e3b|l1b)*Z76_1(e1be2b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e3,l1)*Z76_1(e1,e2,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z76_1)
    ierr=talsh_tensor_construct(Z110_3, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z110_3(l1b,l2b|m1b,d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|m1b)*0.5
    ierr=talsh_tensor_contract("Z110_3(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z110_3,H24,S43,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_construct(Z98_2, C8, (/nvir,nocc,nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z98_2(e1b,l1b,l2b|m1bm2bm3b)+=S44(e1b,d1b|m1bm2b)*Z110_3(l1b,l2b|m3b,d1b)
    ierr=talsh_tensor_contract("Z98_2(e1,l1,l2,m1,m2,m3)+=S44(e1,d1,m1,m2)*Z110_3(l1,l2,m3,d1)", &
        Z98_2,S44,Z110_3,scale=(1.0d0,0.0d0))
!   original expression: Z98_2(e1b,l1b,l2b|m1bm2bm3b)+=S44(e1b,d1b|m1bm3b)*Z110_3(l1b,l2b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z98_2(e1,l1,l2,m1,m2,m3)+=S44(e1,d1,m1,m3)*Z110_3(l1,l2,m2,d1)", &
        Z98_2,S44,Z110_3,scale=(-1.0d0,0.0d0))
!   original expression: Z98_2(e1b,l1b,l2b|m1bm2bm3b)+=S44(e1b,d1b|m2bm3b)*Z110_3(l1b,l2b|m1b,d1b)
    ierr=talsh_tensor_contract("Z98_2(e1,l1,l2,m1,m2,m3)+=S44(e1,d1,m2,m3)*Z110_3(l1,l2,m1,d1)", &
        Z98_2,S44,Z110_3,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z110_3)
    ierr=talsh_tensor_construct(Z76_1, C8, (/nvir,nvir,nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S43(e1b|l2b)*Z98_2(e2b,l1b,l2b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S43(e1,l2)*Z98_2(e2,l1,l2,m1,m2,m3)", &
        Z76_1,S43,Z98_2,scale=(1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S43(e2b|l2b)*Z98_2(e1b,l1b,l2b|m1bm2bm3b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S43(e2,l2)*Z98_2(e1,l1,l2,m1,m2,m3)", &
        Z76_1,S43,Z98_2,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z98_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e1b|l1b)*Z76_1(e2be3b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e1,l1)*Z76_1(e2,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e2b|l1b)*Z76_1(e1be3b,l1b|m1bm2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e2,l1)*Z76_1(e1,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e3b|l1b)*Z76_1(e1be2b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e3,l1)*Z76_1(e1,e2,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z76_1)
    ierr=talsh_tensor_construct(Z98_2, C8, (/nvir,nocc,nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z98_2(e1b,l1b,l2b|m1bm2bm3b)+=S44(e1b,d1b|m1bm2b)*H25(l1b,l2b|m3b,d1b)*-0.5
    ierr=talsh_tensor_contract("Z98_2(e1,l1,l2,m1,m2,m3)+=S44(e1,d1,m1,m2)*H25(l1,l2,m3,d1)", &
        Z98_2,S44,H25,scale=(-0.5d0,0.0d0))
!   original expression: Z98_2(e1b,l1b,l2b|m1bm2bm3b)+=S44(e1b,d1b|m1bm3b)*H25(l1b,l2b|m2b,d1b)*+0.5
    ierr=talsh_tensor_contract("Z98_2(e1,l1,l2,m1,m2,m3)+=S44(e1,d1,m1,m3)*H25(l1,l2,m2,d1)", &
        Z98_2,S44,H25,scale=(0.5d0,0.0d0))
!   original expression: Z98_2(e1b,l1b,l2b|m1bm2bm3b)+=S44(e1b,d1b|m2bm3b)*H25(l1b,l2b|m1b,d1b)*+0.5
    ierr=talsh_tensor_contract("Z98_2(e1,l1,l2,m1,m2,m3)+=S44(e1,d1,m2,m3)*H25(l1,l2,m1,d1)", &
        Z98_2,S44,H25,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_construct(Z76_1, C8, (/nvir,nvir,nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S43(e1b|l2b)*Z98_2(e2b,l1b,l2b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S43(e1,l2)*Z98_2(e2,l1,l2,m1,m2,m3)", &
        Z76_1,S43,Z98_2,scale=(1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S43(e2b|l2b)*Z98_2(e1b,l1b,l2b|m1bm2bm3b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S43(e2,l2)*Z98_2(e1,l1,l2,m1,m2,m3)", &
        Z76_1,S43,Z98_2,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z98_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e1b|l1b)*Z76_1(e2be3b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e1,l1)*Z76_1(e2,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e2b|l1b)*Z76_1(e1be3b,l1b|m1bm2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e2,l1)*Z76_1(e1,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e3b|l1b)*Z76_1(e1be2b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e3,l1)*Z76_1(e1,e2,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z76_1)
    ierr=talsh_tensor_construct(Z98_2, C8, (/nvir,nocc,nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z98_2(e1b,l1b,l2b|m1bm2bm3b)+=S45(e1b,d1bd2b|m1bm2bm3b)*H24(l1b,l2b|d1bd2b)*0.5
    ierr=talsh_tensor_contract("Z98_2(e1,l1,l2,m1,m2,m3)+=S45(e1,d1,d2,m1,m2,m3)*H24(l1,l2,d1,d2)", &
        Z98_2,S45,H24,scale=(0.25d0,0.0d0))
    ierr=talsh_tensor_construct(Z76_1, C8, (/nvir,nvir,nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S43(e1b|l2b)*Z98_2(e2b,l1b,l2b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S43(e1,l2)*Z98_2(e2,l1,l2,m1,m2,m3)", &
        Z76_1,S43,Z98_2,scale=(1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S43(e2b|l2b)*Z98_2(e1b,l1b,l2b|m1bm2bm3b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S43(e2,l2)*Z98_2(e1,l1,l2,m1,m2,m3)", &
        Z76_1,S43,Z98_2,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z98_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e1b|l1b)*Z76_1(e2be3b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e1,l1)*Z76_1(e2,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e2b|l1b)*Z76_1(e1be3b,l1b|m1bm2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e2,l1)*Z76_1(e1,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e3b|l1b)*Z76_1(e1be2b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e3,l1)*Z76_1(e1,e2,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z76_1)
    ierr=talsh_tensor_construct(Z100_2, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z100_2(e1b,l1b|m1b,d1b)+=H17(e1b,l1b|d1b,d2b)*S43(d2b|m1b)*-1.
    ierr=talsh_tensor_contract("Z100_2(e1,l1,m1,d1)+=H17(e1,l1,d1,d2)*S43(d2,m1)", &
        Z100_2,H17,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z76_1, C8, (/nvir,nvir,nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S44(e1b,d1b|m1bm2b)*Z100_2(e2b,l1b|m3b,d1b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S44(e1,d1,m1,m2)*Z100_2(e2,l1,m3,d1)", &
        Z76_1,S44,Z100_2,scale=(1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S44(e2b,d1b|m1bm2b)*Z100_2(e1b,l1b|m3b,d1b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S44(e2,d1,m1,m2)*Z100_2(e1,l1,m3,d1)", &
        Z76_1,S44,Z100_2,scale=(-1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S44(e1b,d1b|m1bm3b)*Z100_2(e2b,l1b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S44(e1,d1,m1,m3)*Z100_2(e2,l1,m2,d1)", &
        Z76_1,S44,Z100_2,scale=(-1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S44(e2b,d1b|m1bm3b)*Z100_2(e1b,l1b|m2b,d1b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S44(e2,d1,m1,m3)*Z100_2(e1,l1,m2,d1)", &
        Z76_1,S44,Z100_2,scale=(1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S44(e1b,d1b|m2bm3b)*Z100_2(e2b,l1b|m1b,d1b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S44(e1,d1,m2,m3)*Z100_2(e2,l1,m1,d1)", &
        Z76_1,S44,Z100_2,scale=(1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S44(e2b,d1b|m2bm3b)*Z100_2(e1b,l1b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S44(e2,d1,m2,m3)*Z100_2(e1,l1,m1,d1)", &
        Z76_1,S44,Z100_2,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z100_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e1b|l1b)*Z76_1(e2be3b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e1,l1)*Z76_1(e2,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e2b|l1b)*Z76_1(e1be3b,l1b|m1bm2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e2,l1)*Z76_1(e1,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e3b|l1b)*Z76_1(e1be2b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e3,l1)*Z76_1(e1,e2,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z76_1)
    ierr=talsh_tensor_construct(Z100_2, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z100_2(e1b,l1b|m1b,d1b)+=S44(e1b,d2b|m1b,l2b)*H24(l1b,l2b|d1b,d2b)
    ierr=talsh_tensor_contract("Z100_2(e1,l1,m1,d1)+=S44(e1,d2,m1,l2)*H24(l1,l2,d1,d2)", &
        Z100_2,S44,H24,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z76_1, C8, (/nvir,nvir,nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S44(e1b,d1b|m1bm2b)*Z100_2(e2b,l1b|m3b,d1b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S44(e1,d1,m1,m2)*Z100_2(e2,l1,m3,d1)", &
        Z76_1,S44,Z100_2,scale=(1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S44(e2b,d1b|m1bm2b)*Z100_2(e1b,l1b|m3b,d1b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S44(e2,d1,m1,m2)*Z100_2(e1,l1,m3,d1)", &
        Z76_1,S44,Z100_2,scale=(-1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S44(e1b,d1b|m1bm3b)*Z100_2(e2b,l1b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S44(e1,d1,m1,m3)*Z100_2(e2,l1,m2,d1)", &
        Z76_1,S44,Z100_2,scale=(-1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S44(e2b,d1b|m1bm3b)*Z100_2(e1b,l1b|m2b,d1b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S44(e2,d1,m1,m3)*Z100_2(e1,l1,m2,d1)", &
        Z76_1,S44,Z100_2,scale=(1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S44(e1b,d1b|m2bm3b)*Z100_2(e2b,l1b|m1b,d1b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S44(e1,d1,m2,m3)*Z100_2(e2,l1,m1,d1)", &
        Z76_1,S44,Z100_2,scale=(1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S44(e2b,d1b|m2bm3b)*Z100_2(e1b,l1b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S44(e2,d1,m2,m3)*Z100_2(e1,l1,m1,d1)", &
        Z76_1,S44,Z100_2,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z100_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e1b|l1b)*Z76_1(e2be3b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e1,l1)*Z76_1(e2,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e2b|l1b)*Z76_1(e1be3b,l1b|m1bm2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e2,l1)*Z76_1(e1,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e3b|l1b)*Z76_1(e1be2b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e3,l1)*Z76_1(e1,e2,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z76_1)
    ierr=talsh_tensor_construct(Z100_2, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_construct(Z76_1, C8, (/nvir,nvir,nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S44(e1b,d1b|m1bm2b)*Z100_2(e2b,l1b|m3b,d1b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S44(e1,d1,m1,m2)*Z100_2(e2,l1,m3,d1)", &
        Z76_1,S44,Z100_2,scale=(1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S44(e2b,d1b|m1bm2b)*Z100_2(e1b,l1b|m3b,d1b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S44(e2,d1,m1,m2)*Z100_2(e1,l1,m3,d1)", &
        Z76_1,S44,Z100_2,scale=(-1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S44(e1b,d1b|m1bm3b)*Z100_2(e2b,l1b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S44(e1,d1,m1,m3)*Z100_2(e2,l1,m2,d1)", &
        Z76_1,S44,Z100_2,scale=(-1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S44(e2b,d1b|m1bm3b)*Z100_2(e1b,l1b|m2b,d1b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S44(e2,d1,m1,m3)*Z100_2(e1,l1,m2,d1)", &
        Z76_1,S44,Z100_2,scale=(1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S44(e1b,d1b|m2bm3b)*Z100_2(e2b,l1b|m1b,d1b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S44(e1,d1,m2,m3)*Z100_2(e2,l1,m1,d1)", &
        Z76_1,S44,Z100_2,scale=(1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S44(e2b,d1b|m2bm3b)*Z100_2(e1b,l1b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S44(e2,d1,m2,m3)*Z100_2(e1,l1,m1,d1)", &
        Z76_1,S44,Z100_2,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z100_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e1b|l1b)*Z76_1(e2be3b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e1,l1)*Z76_1(e2,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e2b|l1b)*Z76_1(e1be3b,l1b|m1bm2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e2,l1)*Z76_1(e1,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e3b|l1b)*Z76_1(e1be2b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e3,l1)*Z76_1(e1,e2,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z76_1)
    ierr=talsh_tensor_construct(Z76_1, C8, (/nvir,nvir,nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S45(e1b,d1bd2b|m1bm2bm3b)*H17(e2b,l1b|d1bd2b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S45(e1,d1,d2,m1,m2,m3)*H17(e2,l1,d1,d2)", &
        Z76_1,S45,H17,scale=(-0.5d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S45(e2b,d1bd2b|m1bm2bm3b)*H17(e1b,l1b|d1bd2b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S45(e2,d1,d2,m1,m2,m3)*H17(e1,l1,d1,d2)", &
        Z76_1,S45,H17,scale=(0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e1b|l1b)*Z76_1(e2be3b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e1,l1)*Z76_1(e2,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e2b|l1b)*Z76_1(e1be3b,l1b|m1bm2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e2,l1)*Z76_1(e1,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e3b|l1b)*Z76_1(e1be2b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e3,l1)*Z76_1(e1,e2,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z76_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_2(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)*-1.
    ierr=talsh_tensor_contract("Z65_2(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_2,H24,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z76_1, C8, (/nvir,nvir,nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm2bm3b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S45(e1,e2,d1,m1,m2,m3)*Z65_2(l1,d1)", &
        Z76_1,S45,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e1b|l1b)*Z76_1(e2be3b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e1,l1)*Z76_1(e2,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e2b|l1b)*Z76_1(e1be3b,l1b|m1bm2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e2,l1)*Z76_1(e1,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e3b|l1b)*Z76_1(e1be2b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e3,l1)*Z76_1(e1,e2,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z76_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_construct(Z76_1, C8, (/nvir,nvir,nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm2bm3b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S45(e1,e2,d1,m1,m2,m3)*Z65_2(l1,d1)", &
        Z76_1,S45,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e1b|l1b)*Z76_1(e2be3b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e1,l1)*Z76_1(e2,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e2b|l1b)*Z76_1(e1be3b,l1b|m1bm2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e2,l1)*Z76_1(e1,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e3b|l1b)*Z76_1(e1be2b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e3,l1)*Z76_1(e1,e2,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z76_1)
    ierr=talsh_tensor_construct(Z76_1, C8, (/nvir,nvir,nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm2bm3b)*H15(l1b|d1b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S45(e1,e2,d1,m1,m2,m3)*H15(l1,d1)", &
        Z76_1,S45,H15,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e1b|l1b)*Z76_1(e2be3b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e1,l1)*Z76_1(e2,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e2b|l1b)*Z76_1(e1be3b,l1b|m1bm2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e2,l1)*Z76_1(e1,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e3b|l1b)*Z76_1(e1be2b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e3,l1)*Z76_1(e1,e2,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z76_1)
    ierr=talsh_tensor_construct(Z110_2, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z110_2(l1b,l2b|m1b,d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|m1b)
    ierr=talsh_tensor_contract("Z110_2(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z110_2,H24,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z76_1, C8, (/nvir,nvir,nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm2b,l2b)*Z110_2(l1b,l2b|m3b,d1b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S45(e1,e2,d1,m1,m2,l2)*Z110_2(l1,l2,m3,d1)", &
        Z76_1,S45,Z110_2,scale=(1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm3b,l2b)*Z110_2(l1b,l2b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S45(e1,e2,d1,m1,m3,l2)*Z110_2(l1,l2,m2,d1)", &
        Z76_1,S45,Z110_2,scale=(-1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S45(e1be2b,d1b|m2bm3b,l2b)*Z110_2(l1b,l2b|m1b,d1b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S45(e1,e2,d1,m2,m3,l2)*Z110_2(l1,l2,m1,d1)", &
        Z76_1,S45,Z110_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z110_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e1b|l1b)*Z76_1(e2be3b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e1,l1)*Z76_1(e2,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e2b|l1b)*Z76_1(e1be3b,l1b|m1bm2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e2,l1)*Z76_1(e1,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e3b|l1b)*Z76_1(e1be2b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e3,l1)*Z76_1(e1,e2,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z76_1)
    ierr=talsh_tensor_construct(Z76_1, C8, (/nvir,nvir,nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm2b,l2b)*H25(l1b,l2b|m3b,d1b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S45(e1,e2,d1,m1,m2,l2)*H25(l1,l2,m3,d1)", &
        Z76_1,S45,H25,scale=(-1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm3b,l2b)*H25(l1b,l2b|m2b,d1b)
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S45(e1,e2,d1,m1,m3,l2)*H25(l1,l2,m2,d1)", &
        Z76_1,S45,H25,scale=(1.0d0,0.0d0))
!   original expression: Z76_1(e1be2b,l1b|m1bm2bm3b)+=S45(e1be2b,d1b|m2bm3b,l2b)*H25(l1b,l2b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z76_1(e1,e2,l1,m1,m2,m3)+=S45(e1,e2,d1,m2,m3,l2)*H25(l1,l2,m1,d1)", &
        Z76_1,S45,H25,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e1b|l1b)*Z76_1(e2be3b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e1,l1)*Z76_1(e2,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e2b|l1b)*Z76_1(e1be3b,l1b|m1bm2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e2,l1)*Z76_1(e1,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e3b|l1b)*Z76_1(e1be2b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e3,l1)*Z76_1(e1,e2,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z76_1)
    ierr=talsh_tensor_construct(Z76_1, C8, (/nvir,nvir,nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e1b|l1b)*Z76_1(e2be3b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e1,l1)*Z76_1(e2,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e2b|l1b)*Z76_1(e1be3b,l1b|m1bm2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e2,l1)*Z76_1(e1,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e3b|l1b)*Z76_1(e1be2b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e3,l1)*Z76_1(e1,e2,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z76_1)
    ierr=talsh_tensor_construct(Z76_1, C8, (/nvir,nvir,nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e1b|l1b)*Z76_1(e2be3b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e1,l1)*Z76_1(e2,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e2b|l1b)*Z76_1(e1be3b,l1b|m1bm2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e2,l1)*Z76_1(e1,e3,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S43(e3b|l1b)*Z76_1(e1be2b,l1b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S43(e3,l1)*Z76_1(e1,e2,l1,m1,m2,m3)", &
        Z55,S43,Z76_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z76_1)
    ierr=talsh_tensor_construct(Z72_1, C8, (/nvir,nocc,nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z72_1(e1b,l1bl2b|m1bm2bm3b)+=S45(e1b,d1bd2b|m1bm2bm3b)*H24(l1bl2b|d1bd2b)
    ierr=talsh_tensor_contract("Z72_1(e1,l1,l2,m1,m2,m3)+=S45(e1,d1,d2,m1,m2,m3)*H24(l1,l2,d1,d2)", &
        Z72_1,S45,H24,scale=(0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|l1bl2b)*Z72_1(e3b,l1bl2b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,l1,l2)*Z72_1(e3,l1,l2,m1,m2,m3)", &
        Z55,S44,Z72_1,scale=(0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|l1bl2b)*Z72_1(e2b,l1bl2b|m1bm2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,l1,l2)*Z72_1(e2,l1,l2,m1,m2,m3)", &
        Z55,S44,Z72_1,scale=(-0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|l1bl2b)*Z72_1(e1b,l1bl2b|m1bm2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,l1,l2)*Z72_1(e1,l1,l2,m1,m2,m3)", &
        Z55,S44,Z72_1,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z72_1)
    ierr=talsh_tensor_construct(Z78_1, C8, (/nvir,nvir,nocc,nvir/), init_val=ZERO)
!   original expression: Z78_1(e1be2b|m1b,d1b)+=H3(e1be2b|d1b,d2b)*S43(d2b|m1b)
    ierr=talsh_tensor_contract("Z78_1(e1,e2,m1,d1)+=H3(e1,e2,d1,d2)*S43(d2,m1)", &
        Z78_1,H3,S43,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m1bm2b)*Z78_1(e2be3b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m1,m2)*Z78_1(e2,e3,m3,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m1bm2b)*Z78_1(e1be3b|m3b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m1,m2)*Z78_1(e1,e3,m3,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m1bm2b)*Z78_1(e1be2b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m1,m2)*Z78_1(e1,e2,m3,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m1bm3b)*Z78_1(e2be3b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m1,m3)*Z78_1(e2,e3,m2,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m1bm3b)*Z78_1(e1be3b|m2b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m1,m3)*Z78_1(e1,e3,m2,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m1bm3b)*Z78_1(e1be2b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m1,m3)*Z78_1(e1,e2,m2,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m2bm3b)*Z78_1(e2be3b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m2,m3)*Z78_1(e2,e3,m1,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m2bm3b)*Z78_1(e1be3b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m2,m3)*Z78_1(e1,e3,m1,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m2bm3b)*Z78_1(e1be2b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m2,m3)*Z78_1(e1,e2,m1,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z78_1)
    ierr=talsh_tensor_construct(Z78_1, C8, (/nvir,nvir,nocc,nvir/), init_val=ZERO)
!   original expression: Z78_1(e1be2b|m1b,d1b)+=H17(e1b,l1b|d1b,d2b)*S44(e2b,d2b|m1b,l1b)
    ierr=talsh_tensor_contract("Z78_1(e1,e2,m1,d1)+=H17(e1,l1,d1,d2)*S44(e2,d2,m1,l1)", &
        Z78_1,H17,S44,scale=(1.0d0,0.0d0))
!   original expression: Z78_1(e1be2b|m1b,d1b)+=H17(e2b,l1b|d1b,d2b)*S44(e1b,d2b|m1b,l1b)*-1.
    ierr=talsh_tensor_contract("Z78_1(e1,e2,m1,d1)+=H17(e2,l1,d1,d2)*S44(e1,d2,m1,l1)", &
        Z78_1,H17,S44,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m1bm2b)*Z78_1(e2be3b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m1,m2)*Z78_1(e2,e3,m3,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m1bm2b)*Z78_1(e1be3b|m3b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m1,m2)*Z78_1(e1,e3,m3,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m1bm2b)*Z78_1(e1be2b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m1,m2)*Z78_1(e1,e2,m3,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m1bm3b)*Z78_1(e2be3b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m1,m3)*Z78_1(e2,e3,m2,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m1bm3b)*Z78_1(e1be3b|m2b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m1,m3)*Z78_1(e1,e3,m2,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m1bm3b)*Z78_1(e1be2b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m1,m3)*Z78_1(e1,e2,m2,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m2bm3b)*Z78_1(e2be3b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m2,m3)*Z78_1(e2,e3,m1,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m2bm3b)*Z78_1(e1be3b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m2,m3)*Z78_1(e1,e3,m1,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m2bm3b)*Z78_1(e1be2b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m2,m3)*Z78_1(e1,e2,m1,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z78_1)
    ierr=talsh_tensor_construct(Z78_1, C8, (/nvir,nvir,nocc,nvir/), init_val=ZERO)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m1bm2b)*Z78_1(e2be3b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m1,m2)*Z78_1(e2,e3,m3,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m1bm2b)*Z78_1(e1be3b|m3b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m1,m2)*Z78_1(e1,e3,m3,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m1bm2b)*Z78_1(e1be2b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m1,m2)*Z78_1(e1,e2,m3,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m1bm3b)*Z78_1(e2be3b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m1,m3)*Z78_1(e2,e3,m2,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m1bm3b)*Z78_1(e1be3b|m2b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m1,m3)*Z78_1(e1,e3,m2,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m1bm3b)*Z78_1(e1be2b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m1,m3)*Z78_1(e1,e2,m2,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m2bm3b)*Z78_1(e2be3b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m2,m3)*Z78_1(e2,e3,m1,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m2bm3b)*Z78_1(e1be3b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m2,m3)*Z78_1(e1,e3,m1,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m2bm3b)*Z78_1(e1be2b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m2,m3)*Z78_1(e1,e2,m1,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z78_1)
    ierr=talsh_tensor_construct(Z93_2, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z93_2(l1bl2b|m1b,d1b)+=H24(l1bl2b|d1b,d2b)*S43(d2b|m1b)
    ierr=talsh_tensor_contract("Z93_2(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z93_2,H24,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z78_1, C8, (/nvir,nvir,nocc,nvir/), init_val=ZERO)
!   original expression: Z78_1(e1be2b|m1b,d1b)+=S44(e1be2b|l1bl2b)*Z93_2(l1bl2b|m1b,d1b)
    ierr=talsh_tensor_contract("Z78_1(e1,e2,m1,d1)+=S44(e1,e2,l1,l2)*Z93_2(l1,l2,m1,d1)", &
        Z78_1,S44,Z93_2,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z93_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m1bm2b)*Z78_1(e2be3b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m1,m2)*Z78_1(e2,e3,m3,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m1bm2b)*Z78_1(e1be3b|m3b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m1,m2)*Z78_1(e1,e3,m3,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m1bm2b)*Z78_1(e1be2b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m1,m2)*Z78_1(e1,e2,m3,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m1bm3b)*Z78_1(e2be3b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m1,m3)*Z78_1(e2,e3,m2,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m1bm3b)*Z78_1(e1be3b|m2b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m1,m3)*Z78_1(e1,e3,m2,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m1bm3b)*Z78_1(e1be2b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m1,m3)*Z78_1(e1,e2,m2,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m2bm3b)*Z78_1(e2be3b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m2,m3)*Z78_1(e2,e3,m1,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m2bm3b)*Z78_1(e1be3b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m2,m3)*Z78_1(e1,e3,m1,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m2bm3b)*Z78_1(e1be2b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m2,m3)*Z78_1(e1,e2,m1,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z78_1)
    ierr=talsh_tensor_construct(Z78_1, C8, (/nvir,nvir,nocc,nvir/), init_val=ZERO)
!   original expression: Z78_1(e1be2b|m1b,d1b)+=S44(e1be2b|l1bl2b)*H25(l1bl2b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z78_1(e1,e2,m1,d1)+=S44(e1,e2,l1,l2)*H25(l1,l2,m1,d1)", &
        Z78_1,S44,H25,scale=(-0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m1bm2b)*Z78_1(e2be3b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m1,m2)*Z78_1(e2,e3,m3,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m1bm2b)*Z78_1(e1be3b|m3b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m1,m2)*Z78_1(e1,e3,m3,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m1bm2b)*Z78_1(e1be2b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m1,m2)*Z78_1(e1,e2,m3,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m1bm3b)*Z78_1(e2be3b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m1,m3)*Z78_1(e2,e3,m2,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m1bm3b)*Z78_1(e1be3b|m2b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m1,m3)*Z78_1(e1,e3,m2,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m1bm3b)*Z78_1(e1be2b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m1,m3)*Z78_1(e1,e2,m2,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m2bm3b)*Z78_1(e2be3b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m2,m3)*Z78_1(e2,e3,m1,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m2bm3b)*Z78_1(e1be3b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m2,m3)*Z78_1(e1,e3,m1,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m2bm3b)*Z78_1(e1be2b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m2,m3)*Z78_1(e1,e2,m1,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z78_1)
    ierr=talsh_tensor_construct(Z78_1, C8, (/nvir,nvir,nocc,nvir/), init_val=ZERO)
!   original expression: Z78_1(e1be2b|m1b,d1b)+=S45(e1be2b,d2b|m1b,l1bl2b)*H24(l1bl2b|d1b,d2b)
    ierr=talsh_tensor_contract("Z78_1(e1,e2,m1,d1)+=S45(e1,e2,d2,m1,l1,l2)*H24(l1,l2,d1,d2)", &
        Z78_1,S45,H24,scale=(0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m1bm2b)*Z78_1(e2be3b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m1,m2)*Z78_1(e2,e3,m3,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m1bm2b)*Z78_1(e1be3b|m3b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m1,m2)*Z78_1(e1,e3,m3,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m1bm2b)*Z78_1(e1be2b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m1,m2)*Z78_1(e1,e2,m3,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m1bm3b)*Z78_1(e2be3b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m1,m3)*Z78_1(e2,e3,m2,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m1bm3b)*Z78_1(e1be3b|m2b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m1,m3)*Z78_1(e1,e3,m2,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m1bm3b)*Z78_1(e1be2b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m1,m3)*Z78_1(e1,e2,m2,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m2bm3b)*Z78_1(e2be3b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m2,m3)*Z78_1(e2,e3,m1,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m2bm3b)*Z78_1(e1be3b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m2,m3)*Z78_1(e1,e3,m1,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m2bm3b)*Z78_1(e1be2b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m2,m3)*Z78_1(e1,e2,m1,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z78_1)
    ierr=talsh_tensor_construct(Z78_1, C8, (/nvir,nvir,nocc,nvir/), init_val=ZERO)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m1bm2b)*Z78_1(e2be3b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m1,m2)*Z78_1(e2,e3,m3,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m1bm2b)*Z78_1(e1be3b|m3b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m1,m2)*Z78_1(e1,e3,m3,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m1bm2b)*Z78_1(e1be2b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m1,m2)*Z78_1(e1,e2,m3,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m1bm3b)*Z78_1(e2be3b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m1,m3)*Z78_1(e2,e3,m2,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m1bm3b)*Z78_1(e1be3b|m2b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m1,m3)*Z78_1(e1,e3,m2,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m1bm3b)*Z78_1(e1be2b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m1,m3)*Z78_1(e1,e2,m2,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1b,d1b|m2bm3b)*Z78_1(e2be3b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,d1,m2,m3)*Z78_1(e2,e3,m1,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2b,d1b|m2bm3b)*Z78_1(e1be3b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,d1,m2,m3)*Z78_1(e1,e3,m1,d1)", &
        Z55,S44,Z78_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e3b,d1b|m2bm3b)*Z78_1(e1be2b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e3,d1,m2,m3)*Z78_1(e1,e2,m1,d1)", &
        Z55,S44,Z78_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z78_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=H17(e1b,l1b|d1bd2b)*S44(d1bd2b|m1bm2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=H17(e1,l1,d1,d2)*S44(d1,d2,m1,m2)", &
        Z71_1,H17,S44,scale=(0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m1b,l1b)*Z71_1(e3b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m1,l1)*Z71_1(e3,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m1b,l1b)*Z71_1(e2b,l1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m1,l1)*Z71_1(e2,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m1b,l1b)*Z71_1(e1b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m1,l1)*Z71_1(e1,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m2b,l1b)*Z71_1(e3b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m2,l1)*Z71_1(e3,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m2b,l1b)*Z71_1(e2b,l1b|m1bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m2,l1)*Z71_1(e2,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m2b,l1b)*Z71_1(e1b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m2,l1)*Z71_1(e1,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m3b,l1b)*Z71_1(e3b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m3,l1)*Z71_1(e3,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m3b,l1b)*Z71_1(e2b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m3,l1)*Z71_1(e2,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m3b,l1b)*Z71_1(e1b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m3,l1)*Z71_1(e1,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=H26(l1b,l2b|m1bm2b)*S43(e1b|l2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=H26(l1,l2,m1,m2)*S43(e1,l2)", &
        Z71_1,H26,S43,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m1b,l1b)*Z71_1(e3b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m1,l1)*Z71_1(e3,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m1b,l1b)*Z71_1(e2b,l1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m1,l1)*Z71_1(e2,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m1b,l1b)*Z71_1(e1b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m1,l1)*Z71_1(e1,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m2b,l1b)*Z71_1(e3b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m2,l1)*Z71_1(e3,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m2b,l1b)*Z71_1(e2b,l1b|m1bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m2,l1)*Z71_1(e2,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m2b,l1b)*Z71_1(e1b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m2,l1)*Z71_1(e1,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m3b,l1b)*Z71_1(e3b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m3,l1)*Z71_1(e3,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m3b,l1b)*Z71_1(e2b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m3,l1)*Z71_1(e2,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m3b,l1b)*Z71_1(e1b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m3,l1)*Z71_1(e1,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=H18(e1b,l1b|m1b,d1b)*S43(d1b|m2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=H18(e1,l1,m1,d1)*S43(d1,m2)", &
        Z71_1,H18,S43,scale=(1.0d0,0.0d0))
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=H18(e1b,l1b|m2b,d1b)*S43(d1b|m1b)*-1.
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=H18(e1,l1,m2,d1)*S43(d1,m1)", &
        Z71_1,H18,S43,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m1b,l1b)*Z71_1(e3b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m1,l1)*Z71_1(e3,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m1b,l1b)*Z71_1(e2b,l1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m1,l1)*Z71_1(e2,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m1b,l1b)*Z71_1(e1b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m1,l1)*Z71_1(e1,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m2b,l1b)*Z71_1(e3b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m2,l1)*Z71_1(e3,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m2b,l1b)*Z71_1(e2b,l1b|m1bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m2,l1)*Z71_1(e2,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m2b,l1b)*Z71_1(e1b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m2,l1)*Z71_1(e1,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m3b,l1b)*Z71_1(e3b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m3,l1)*Z71_1(e3,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m3b,l1b)*Z71_1(e2b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m3,l1)*Z71_1(e2,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m3b,l1b)*Z71_1(e1b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m3,l1)*Z71_1(e1,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z91_2, C8, (/nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z91_2(l1b,l2b|m1bm2b)+=H24(l1b,l2b|d1bd2b)*S44(d1bd2b|m1bm2b)
    ierr=talsh_tensor_contract("Z91_2(l1,l2,m1,m2)+=H24(l1,l2,d1,d2)*S44(d1,d2,m1,m2)", &
        Z91_2,H24,S44,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S43(e1b|l2b)*Z91_2(l1b,l2b|m1bm2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S43(e1,l2)*Z91_2(l1,l2,m1,m2)", &
        Z71_1,S43,Z91_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z91_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m1b,l1b)*Z71_1(e3b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m1,l1)*Z71_1(e3,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m1b,l1b)*Z71_1(e2b,l1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m1,l1)*Z71_1(e2,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m1b,l1b)*Z71_1(e1b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m1,l1)*Z71_1(e1,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m2b,l1b)*Z71_1(e3b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m2,l1)*Z71_1(e3,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m2b,l1b)*Z71_1(e2b,l1b|m1bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m2,l1)*Z71_1(e2,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m2b,l1b)*Z71_1(e1b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m2,l1)*Z71_1(e1,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m3b,l1b)*Z71_1(e3b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m3,l1)*Z71_1(e3,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m3b,l1b)*Z71_1(e2b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m3,l1)*Z71_1(e2,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m3b,l1b)*Z71_1(e1b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m3,l1)*Z71_1(e1,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z91_2, C8, (/nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z91_2(l1b,l2b|m1bm2b)+=H25(l1b,l2b|m1b,d1b)*S43(d1b|m2b)
    ierr=talsh_tensor_contract("Z91_2(l1,l2,m1,m2)+=H25(l1,l2,m1,d1)*S43(d1,m2)", &
        Z91_2,H25,S43,scale=(1.0d0,0.0d0))
!   original expression: Z91_2(l1b,l2b|m1bm2b)+=H25(l1b,l2b|m2b,d1b)*S43(d1b|m1b)*-1.
    ierr=talsh_tensor_contract("Z91_2(l1,l2,m1,m2)+=H25(l1,l2,m2,d1)*S43(d1,m1)", &
        Z91_2,H25,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S43(e1b|l2b)*Z91_2(l1b,l2b|m1bm2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S43(e1,l2)*Z91_2(l1,l2,m1,m2)", &
        Z71_1,S43,Z91_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z91_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m1b,l1b)*Z71_1(e3b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m1,l1)*Z71_1(e3,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m1b,l1b)*Z71_1(e2b,l1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m1,l1)*Z71_1(e2,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m1b,l1b)*Z71_1(e1b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m1,l1)*Z71_1(e1,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m2b,l1b)*Z71_1(e3b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m2,l1)*Z71_1(e3,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m2b,l1b)*Z71_1(e2b,l1b|m1bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m2,l1)*Z71_1(e2,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m2b,l1b)*Z71_1(e1b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m2,l1)*Z71_1(e1,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m3b,l1b)*Z71_1(e3b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m3,l1)*Z71_1(e3,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m3b,l1b)*Z71_1(e2b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m3,l1)*Z71_1(e2,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m3b,l1b)*Z71_1(e1b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m3,l1)*Z71_1(e1,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z110_3, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z110_3(l1b,l2b|m1b,d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|m1b)*0.5
    ierr=talsh_tensor_contract("Z110_3(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z110_3,H24,S43,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_construct(Z91_2, C8, (/nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z91_2(l1b,l2b|m1bm2b)+=S43(d1b|m1b)*Z110_3(l1b,l2b|m2b,d1b)
    ierr=talsh_tensor_contract("Z91_2(l1,l2,m1,m2)+=S43(d1,m1)*Z110_3(l1,l2,m2,d1)", &
        Z91_2,S43,Z110_3,scale=(1.0d0,0.0d0))
!   original expression: Z91_2(l1b,l2b|m1bm2b)+=S43(d1b|m2b)*Z110_3(l1b,l2b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z91_2(l1,l2,m1,m2)+=S43(d1,m2)*Z110_3(l1,l2,m1,d1)", &
        Z91_2,S43,Z110_3,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z110_3)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S43(e1b|l2b)*Z91_2(l1b,l2b|m1bm2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S43(e1,l2)*Z91_2(l1,l2,m1,m2)", &
        Z71_1,S43,Z91_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z91_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m1b,l1b)*Z71_1(e3b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m1,l1)*Z71_1(e3,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m1b,l1b)*Z71_1(e2b,l1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m1,l1)*Z71_1(e2,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m1b,l1b)*Z71_1(e1b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m1,l1)*Z71_1(e1,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m2b,l1b)*Z71_1(e3b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m2,l1)*Z71_1(e3,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m2b,l1b)*Z71_1(e2b,l1b|m1bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m2,l1)*Z71_1(e2,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m2b,l1b)*Z71_1(e1b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m2,l1)*Z71_1(e1,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m3b,l1b)*Z71_1(e3b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m3,l1)*Z71_1(e3,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m3b,l1b)*Z71_1(e2b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m3,l1)*Z71_1(e2,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m3b,l1b)*Z71_1(e1b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m3,l1)*Z71_1(e1,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z100_2, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z100_2(e1b,l1b|m1b,d1b)+=H17(e1b,l1b|d1b,d2b)*S43(d2b|m1b)*0.5
    ierr=talsh_tensor_contract("Z100_2(e1,l1,m1,d1)+=H17(e1,l1,d1,d2)*S43(d2,m1)", &
        Z100_2,H17,S43,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S43(d1b|m1b)*Z100_2(e1b,l1b|m2b,d1b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S43(d1,m1)*Z100_2(e1,l1,m2,d1)", &
        Z71_1,S43,Z100_2,scale=(1.0d0,0.0d0))
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S43(d1b|m2b)*Z100_2(e1b,l1b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S43(d1,m2)*Z100_2(e1,l1,m1,d1)", &
        Z71_1,S43,Z100_2,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z100_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m1b,l1b)*Z71_1(e3b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m1,l1)*Z71_1(e3,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m1b,l1b)*Z71_1(e2b,l1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m1,l1)*Z71_1(e2,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m1b,l1b)*Z71_1(e1b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m1,l1)*Z71_1(e1,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m2b,l1b)*Z71_1(e3b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m2,l1)*Z71_1(e3,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m2b,l1b)*Z71_1(e2b,l1b|m1bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m2,l1)*Z71_1(e2,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m2b,l1b)*Z71_1(e1b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m2,l1)*Z71_1(e1,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m3b,l1b)*Z71_1(e3b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m3,l1)*Z71_1(e3,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m3b,l1b)*Z71_1(e2b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m3,l1)*Z71_1(e2,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m3b,l1b)*Z71_1(e1b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m3,l1)*Z71_1(e1,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_2(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)
    ierr=talsh_tensor_contract("Z65_2(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_2,H24,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m1bm2b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m1,m2)*Z65_2(l1,d1)", &
        Z71_1,S44,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m1b,l1b)*Z71_1(e3b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m1,l1)*Z71_1(e3,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m1b,l1b)*Z71_1(e2b,l1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m1,l1)*Z71_1(e2,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m1b,l1b)*Z71_1(e1b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m1,l1)*Z71_1(e1,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m2b,l1b)*Z71_1(e3b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m2,l1)*Z71_1(e3,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m2b,l1b)*Z71_1(e2b,l1b|m1bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m2,l1)*Z71_1(e2,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m2b,l1b)*Z71_1(e1b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m2,l1)*Z71_1(e1,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m3b,l1b)*Z71_1(e3b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m3,l1)*Z71_1(e3,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m3b,l1b)*Z71_1(e2b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m3,l1)*Z71_1(e2,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m3b,l1b)*Z71_1(e1b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m3,l1)*Z71_1(e1,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m1bm2b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m1,m2)*Z65_2(l1,d1)", &
        Z71_1,S44,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m1b,l1b)*Z71_1(e3b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m1,l1)*Z71_1(e3,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m1b,l1b)*Z71_1(e2b,l1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m1,l1)*Z71_1(e2,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m1b,l1b)*Z71_1(e1b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m1,l1)*Z71_1(e1,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m2b,l1b)*Z71_1(e3b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m2,l1)*Z71_1(e3,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m2b,l1b)*Z71_1(e2b,l1b|m1bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m2,l1)*Z71_1(e2,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m2b,l1b)*Z71_1(e1b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m2,l1)*Z71_1(e1,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m3b,l1b)*Z71_1(e3b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m3,l1)*Z71_1(e3,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m3b,l1b)*Z71_1(e2b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m3,l1)*Z71_1(e2,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m3b,l1b)*Z71_1(e1b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m3,l1)*Z71_1(e1,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m1bm2b)*H15(l1b|d1b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m1,m2)*H15(l1,d1)", &
        Z71_1,S44,H15,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m1b,l1b)*Z71_1(e3b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m1,l1)*Z71_1(e3,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m1b,l1b)*Z71_1(e2b,l1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m1,l1)*Z71_1(e2,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m1b,l1b)*Z71_1(e1b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m1,l1)*Z71_1(e1,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m2b,l1b)*Z71_1(e3b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m2,l1)*Z71_1(e3,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m2b,l1b)*Z71_1(e2b,l1b|m1bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m2,l1)*Z71_1(e2,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m2b,l1b)*Z71_1(e1b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m2,l1)*Z71_1(e1,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m3b,l1b)*Z71_1(e3b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m3,l1)*Z71_1(e3,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m3b,l1b)*Z71_1(e2b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m3,l1)*Z71_1(e2,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m3b,l1b)*Z71_1(e1b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m3,l1)*Z71_1(e1,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z110_2, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z110_2(l1b,l2b|m1b,d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|m1b)*-1.
    ierr=talsh_tensor_contract("Z110_2(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z110_2,H24,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m1b,l2b)*Z110_2(l1b,l2b|m2b,d1b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m1,l2)*Z110_2(l1,l2,m2,d1)", &
        Z71_1,S44,Z110_2,scale=(1.0d0,0.0d0))
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m2b,l2b)*Z110_2(l1b,l2b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m2,l2)*Z110_2(l1,l2,m1,d1)", &
        Z71_1,S44,Z110_2,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z110_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m1b,l1b)*Z71_1(e3b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m1,l1)*Z71_1(e3,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m1b,l1b)*Z71_1(e2b,l1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m1,l1)*Z71_1(e2,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m1b,l1b)*Z71_1(e1b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m1,l1)*Z71_1(e1,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m2b,l1b)*Z71_1(e3b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m2,l1)*Z71_1(e3,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m2b,l1b)*Z71_1(e2b,l1b|m1bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m2,l1)*Z71_1(e2,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m2b,l1b)*Z71_1(e1b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m2,l1)*Z71_1(e1,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m3b,l1b)*Z71_1(e3b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m3,l1)*Z71_1(e3,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m3b,l1b)*Z71_1(e2b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m3,l1)*Z71_1(e2,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m3b,l1b)*Z71_1(e1b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m3,l1)*Z71_1(e1,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m1b,l2b)*H25(l1b,l2b|m2b,d1b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m1,l2)*H25(l1,l2,m2,d1)", &
        Z71_1,S44,H25,scale=(1.0d0,0.0d0))
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m2b,l2b)*H25(l1b,l2b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m2,l2)*H25(l1,l2,m1,d1)", &
        Z71_1,S44,H25,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m1b,l1b)*Z71_1(e3b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m1,l1)*Z71_1(e3,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m1b,l1b)*Z71_1(e2b,l1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m1,l1)*Z71_1(e2,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m1b,l1b)*Z71_1(e1b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m1,l1)*Z71_1(e1,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m2b,l1b)*Z71_1(e3b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m2,l1)*Z71_1(e3,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m2b,l1b)*Z71_1(e2b,l1b|m1bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m2,l1)*Z71_1(e2,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m2b,l1b)*Z71_1(e1b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m2,l1)*Z71_1(e1,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m3b,l1b)*Z71_1(e3b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m3,l1)*Z71_1(e3,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m3b,l1b)*Z71_1(e2b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m3,l1)*Z71_1(e2,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m3b,l1b)*Z71_1(e1b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m3,l1)*Z71_1(e1,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m1b,l1b)*Z71_1(e3b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m1,l1)*Z71_1(e3,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m1b,l1b)*Z71_1(e2b,l1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m1,l1)*Z71_1(e2,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m1b,l1b)*Z71_1(e1b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m1,l1)*Z71_1(e1,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m2b,l1b)*Z71_1(e3b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m2,l1)*Z71_1(e3,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m2b,l1b)*Z71_1(e2b,l1b|m1bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m2,l1)*Z71_1(e2,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m2b,l1b)*Z71_1(e1b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m2,l1)*Z71_1(e1,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m3b,l1b)*Z71_1(e3b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m3,l1)*Z71_1(e3,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m3b,l1b)*Z71_1(e2b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m3,l1)*Z71_1(e2,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m3b,l1b)*Z71_1(e1b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m3,l1)*Z71_1(e1,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m1b,l1b)*Z71_1(e3b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m1,l1)*Z71_1(e3,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m1b,l1b)*Z71_1(e2b,l1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m1,l1)*Z71_1(e2,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m1b,l1b)*Z71_1(e1b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m1,l1)*Z71_1(e1,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m2b,l1b)*Z71_1(e3b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m2,l1)*Z71_1(e3,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m2b,l1b)*Z71_1(e2b,l1b|m1bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m2,l1)*Z71_1(e2,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m2b,l1b)*Z71_1(e1b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m2,l1)*Z71_1(e1,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m3b,l1b)*Z71_1(e3b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m3,l1)*Z71_1(e3,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m3b,l1b)*Z71_1(e2b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m3,l1)*Z71_1(e2,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m3b,l1b)*Z71_1(e1b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m3,l1)*Z71_1(e1,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S45(e1b,d1bd2b|m1bm2b,l2b)*H24(l1b,l2b|d1bd2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S45(e1,d1,d2,m1,m2,l2)*H24(l1,l2,d1,d2)", &
        Z71_1,S45,H24,scale=(0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m1b,l1b)*Z71_1(e3b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m1,l1)*Z71_1(e3,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m1b,l1b)*Z71_1(e2b,l1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m1,l1)*Z71_1(e2,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m1b,l1b)*Z71_1(e1b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m1,l1)*Z71_1(e1,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m2b,l1b)*Z71_1(e3b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m2,l1)*Z71_1(e3,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m2b,l1b)*Z71_1(e2b,l1b|m1bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m2,l1)*Z71_1(e2,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m2b,l1b)*Z71_1(e1b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m2,l1)*Z71_1(e1,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m3b,l1b)*Z71_1(e3b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m3,l1)*Z71_1(e3,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m3b,l1b)*Z71_1(e2b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m3,l1)*Z71_1(e2,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m3b,l1b)*Z71_1(e1b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m3,l1)*Z71_1(e1,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m1b,l1b)*Z71_1(e3b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m1,l1)*Z71_1(e3,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m1b,l1b)*Z71_1(e2b,l1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m1,l1)*Z71_1(e2,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m1b,l1b)*Z71_1(e1b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m1,l1)*Z71_1(e1,l1,m2,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m2b,l1b)*Z71_1(e3b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m2,l1)*Z71_1(e3,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m2b,l1b)*Z71_1(e2b,l1b|m1bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m2,l1)*Z71_1(e2,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m2b,l1b)*Z71_1(e1b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m2,l1)*Z71_1(e1,l1,m1,m3)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m3b,l1b)*Z71_1(e3b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m3,l1)*Z71_1(e3,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m3b,l1b)*Z71_1(e2b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m3,l1)*Z71_1(e2,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m3b,l1b)*Z71_1(e1b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m3,l1)*Z71_1(e1,l1,m1,m2)", &
        Z55,S44,Z71_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m1b,l1b)*H19(e3b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m1,l1)*H19(e3,l1,m2,m3)", &
        Z55,S44,H19,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m1b,l1b)*H19(e2b,l1b|m2bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m1,l1)*H19(e2,l1,m2,m3)", &
        Z55,S44,H19,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m1b,l1b)*H19(e1b,l1b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m1,l1)*H19(e1,l1,m2,m3)", &
        Z55,S44,H19,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m2b,l1b)*H19(e3b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m2,l1)*H19(e3,l1,m1,m3)", &
        Z55,S44,H19,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m2b,l1b)*H19(e2b,l1b|m1bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m2,l1)*H19(e2,l1,m1,m3)", &
        Z55,S44,H19,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m2b,l1b)*H19(e1b,l1b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m2,l1)*H19(e1,l1,m1,m3)", &
        Z55,S44,H19,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be2b|m3b,l1b)*H19(e3b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e2,m3,l1)*H19(e3,l1,m1,m2)", &
        Z55,S44,H19,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e1be3b|m3b,l1b)*H19(e2b,l1b|m1bm2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e1,e3,m3,l1)*H19(e2,l1,m1,m2)", &
        Z55,S44,H19,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S44(e2be3b|m3b,l1b)*H19(e1b,l1b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S44(e2,e3,m3,l1)*H19(e1,l1,m1,m2)", &
        Z55,S44,H19,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1b,d1bd2b|m1bm2bm3b)*H3(e2be3b|d1bd2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,d1,d2,m1,m2,m3)*H3(e2,e3,d1,d2)", &
        Z55,S45,H3,scale=(0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e2b,d1bd2b|m1bm2bm3b)*H3(e1be3b|d1bd2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e2,d1,d2,m1,m2,m3)*H3(e1,e3,d1,d2)", &
        Z55,S45,H3,scale=(-0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e3b,d1bd2b|m1bm2bm3b)*H3(e1be2b|d1bd2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e3,d1,d2,m1,m2,m3)*H3(e1,e2,d1,d2)", &
        Z55,S45,H3,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
!   original expression: Z62_1(e1b|d1b)+=H17(e1b,l1b|d1b,d2b)*S43(d2b|l1b)
    ierr=talsh_tensor_contract("Z62_1(e1,d1)+=H17(e1,l1,d1,d2)*S43(d2,l1)", &
        Z62_1,H17,S43,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm2bm3b)*Z62_1(e3b|d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,d1,m1,m2,m3)*Z62_1(e3,d1)", &
        Z55,S45,Z62_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be3b,d1b|m1bm2bm3b)*Z62_1(e2b|d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e3,d1,m1,m2,m3)*Z62_1(e2,d1)", &
        Z55,S45,Z62_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e2be3b,d1b|m1bm2bm3b)*Z62_1(e1b|d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e2,e3,d1,m1,m2,m3)*Z62_1(e1,d1)", &
        Z55,S45,Z62_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm2bm3b)*Z62_1(e3b|d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,d1,m1,m2,m3)*Z62_1(e3,d1)", &
        Z55,S45,Z62_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be3b,d1b|m1bm2bm3b)*Z62_1(e2b|d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e3,d1,m1,m2,m3)*Z62_1(e2,d1)", &
        Z55,S45,Z62_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e2be3b,d1b|m1bm2bm3b)*Z62_1(e1b|d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e2,e3,d1,m1,m2,m3)*Z62_1(e1,d1)", &
        Z55,S45,Z62_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
!   original expression: Z62_1(e1b|d1b)+=S44(e1b,d2b|l1bl2b)*H24(l1bl2b|d1b,d2b)*-1.
    ierr=talsh_tensor_contract("Z62_1(e1,d1)+=S44(e1,d2,l1,l2)*H24(l1,l2,d1,d2)", &
        Z62_1,S44,H24,scale=(-0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm2bm3b)*Z62_1(e3b|d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,d1,m1,m2,m3)*Z62_1(e3,d1)", &
        Z55,S45,Z62_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be3b,d1b|m1bm2bm3b)*Z62_1(e2b|d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e3,d1,m1,m2,m3)*Z62_1(e2,d1)", &
        Z55,S45,Z62_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e2be3b,d1b|m1bm2bm3b)*Z62_1(e1b|d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e2,e3,d1,m1,m2,m3)*Z62_1(e1,d1)", &
        Z55,S45,Z62_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm2bm3b)*Z62_1(e3b|d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,d1,m1,m2,m3)*Z62_1(e3,d1)", &
        Z55,S45,Z62_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be3b,d1b|m1bm2bm3b)*Z62_1(e2b|d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e3,d1,m1,m2,m3)*Z62_1(e2,d1)", &
        Z55,S45,Z62_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e2be3b,d1b|m1bm2bm3b)*Z62_1(e1b|d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e2,e3,d1,m1,m2,m3)*Z62_1(e1,d1)", &
        Z55,S45,Z62_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z62_1)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm2bm3b)*H1(e3b|d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,d1,m1,m2,m3)*H1(e3,d1)", &
        Z55,S45,H1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be3b,d1b|m1bm2bm3b)*H1(e2b|d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e3,d1,m1,m2,m3)*H1(e2,d1)", &
        Z55,S45,H1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e2be3b,d1b|m1bm2bm3b)*H1(e1b|d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e2,e3,d1,m1,m2,m3)*H1(e1,d1)", &
        Z55,S45,H1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z66_1, C8, (/nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z66_1(l1bl2b|m1bm2b)+=H25(l1bl2b|m1b,d1b)*S43(d1b|m2b)
    ierr=talsh_tensor_contract("Z66_1(l1,l2,m1,m2)+=H25(l1,l2,m1,d1)*S43(d1,m2)", &
        Z66_1,H25,S43,scale=(1.0d0,0.0d0))
!   original expression: Z66_1(l1bl2b|m1bm2b)+=H25(l1bl2b|m2b,d1b)*S43(d1b|m1b)*-1.
    ierr=talsh_tensor_contract("Z66_1(l1,l2,m1,m2)+=H25(l1,l2,m2,d1)*S43(d1,m1)", &
        Z66_1,H25,S43,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1b,l1bl2b)*Z66_1(l1bl2b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,l1,l2)*Z66_1(l1,l2,m2,m3)", &
        Z55,S45,Z66_1,scale=(0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m2b,l1bl2b)*Z66_1(l1bl2b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m2,l1,l2)*Z66_1(l1,l2,m1,m3)", &
        Z55,S45,Z66_1,scale=(-0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m3b,l1bl2b)*Z66_1(l1bl2b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m3,l1,l2)*Z66_1(l1,l2,m1,m2)", &
        Z55,S45,Z66_1,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z66_1)
    ierr=talsh_tensor_construct(Z93_2, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z93_2(l1bl2b|m1b,d1b)+=H24(l1bl2b|d1b,d2b)*S43(d2b|m1b)*0.5
    ierr=talsh_tensor_contract("Z93_2(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z93_2,H24,S43,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_construct(Z66_1, C8, (/nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z66_1(l1bl2b|m1bm2b)+=S43(d1b|m1b)*Z93_2(l1bl2b|m2b,d1b)
    ierr=talsh_tensor_contract("Z66_1(l1,l2,m1,m2)+=S43(d1,m1)*Z93_2(l1,l2,m2,d1)", &
        Z66_1,S43,Z93_2,scale=(1.0d0,0.0d0))
!   original expression: Z66_1(l1bl2b|m1bm2b)+=S43(d1b|m2b)*Z93_2(l1bl2b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z66_1(l1,l2,m1,m2)+=S43(d1,m2)*Z93_2(l1,l2,m1,d1)", &
        Z66_1,S43,Z93_2,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z93_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1b,l1bl2b)*Z66_1(l1bl2b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,l1,l2)*Z66_1(l1,l2,m2,m3)", &
        Z55,S45,Z66_1,scale=(0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m2b,l1bl2b)*Z66_1(l1bl2b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m2,l1,l2)*Z66_1(l1,l2,m1,m3)", &
        Z55,S45,Z66_1,scale=(-0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m3b,l1bl2b)*Z66_1(l1bl2b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m3,l1,l2)*Z66_1(l1,l2,m1,m2)", &
        Z55,S45,Z66_1,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z66_1)
    ierr=talsh_tensor_construct(Z66_1, C8, (/nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z66_1(l1bl2b|m1bm2b)+=S44(d1bd2b|m1bm2b)*H24(l1bl2b|d1bd2b)
    ierr=talsh_tensor_contract("Z66_1(l1,l2,m1,m2)+=S44(d1,d2,m1,m2)*H24(l1,l2,d1,d2)", &
        Z66_1,S44,H24,scale=(0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1b,l1bl2b)*Z66_1(l1bl2b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,l1,l2)*Z66_1(l1,l2,m2,m3)", &
        Z55,S45,Z66_1,scale=(0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m2b,l1bl2b)*Z66_1(l1bl2b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m2,l1,l2)*Z66_1(l1,l2,m1,m3)", &
        Z55,S45,Z66_1,scale=(-0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m3b,l1bl2b)*Z66_1(l1bl2b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m3,l1,l2)*Z66_1(l1,l2,m1,m2)", &
        Z55,S45,Z66_1,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z66_1)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1b,l1bl2b)*H26(l1bl2b|m2bm3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,l1,l2)*H26(l1,l2,m2,m3)", &
        Z55,S45,H26,scale=(0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m2b,l1bl2b)*H26(l1bl2b|m1bm3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m2,l1,l2)*H26(l1,l2,m1,m3)", &
        Z55,S45,H26,scale=(-0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m3b,l1bl2b)*H26(l1bl2b|m1bm2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m3,l1,l2)*H26(l1,l2,m1,m2)", &
        Z55,S45,H26,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=H25(l1b,l2b|m1b,d1b)*S43(d1b|l2b)*-1.
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=H25(l1,l2,m1,d1)*S43(d1,l2)", &
        Z64_1,H25,S43,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1bm2b,l1b)*Z64_1(l1b|m3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,m2,l1)*Z64_1(l1,m3)", &
        Z55,S45,Z64_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1bm3b,l1b)*Z64_1(l1b|m2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,m3,l1)*Z64_1(l1,m2)", &
        Z55,S45,Z64_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m2bm3b,l1b)*Z64_1(l1b|m1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m2,m3,l1)*Z64_1(l1,m1)", &
        Z55,S45,Z64_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1bm2b,l1b)*Z64_1(l1b|m3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,m2,l1)*Z64_1(l1,m3)", &
        Z55,S45,Z64_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1bm3b,l1b)*Z64_1(l1b|m2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,m3,l1)*Z64_1(l1,m2)", &
        Z55,S45,Z64_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m2bm3b,l1b)*Z64_1(l1b|m1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m2,m3,l1)*Z64_1(l1,m1)", &
        Z55,S45,Z64_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_2(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)*-1.
    ierr=talsh_tensor_contract("Z65_2(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_2,H24,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S43(d1b|m1b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S43(d1,m1)*Z65_2(l1,d1)", &
        Z64_1,S43,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1bm2b,l1b)*Z64_1(l1b|m3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,m2,l1)*Z64_1(l1,m3)", &
        Z55,S45,Z64_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1bm3b,l1b)*Z64_1(l1b|m2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,m3,l1)*Z64_1(l1,m2)", &
        Z55,S45,Z64_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m2bm3b,l1b)*Z64_1(l1b|m1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m2,m3,l1)*Z64_1(l1,m1)", &
        Z55,S45,Z64_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S43(d1b|m1b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S43(d1,m1)*Z65_2(l1,d1)", &
        Z64_1,S43,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1bm2b,l1b)*Z64_1(l1b|m3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,m2,l1)*Z64_1(l1,m3)", &
        Z55,S45,Z64_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1bm3b,l1b)*Z64_1(l1b|m2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,m3,l1)*Z64_1(l1,m2)", &
        Z55,S45,Z64_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m2bm3b,l1b)*Z64_1(l1b|m1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m2,m3,l1)*Z64_1(l1,m1)", &
        Z55,S45,Z64_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S43(d1b|m1b)*H15(l1b|d1b)*-1.
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S43(d1,m1)*H15(l1,d1)", &
        Z64_1,S43,H15,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1bm2b,l1b)*Z64_1(l1b|m3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,m2,l1)*Z64_1(l1,m3)", &
        Z55,S45,Z64_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1bm3b,l1b)*Z64_1(l1b|m2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,m3,l1)*Z64_1(l1,m2)", &
        Z55,S45,Z64_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m2bm3b,l1b)*Z64_1(l1b|m1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m2,m3,l1)*Z64_1(l1,m1)", &
        Z55,S45,Z64_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S44(d1bd2b|m1b,l2b)*H24(l1b,l2b|d1bd2b)*-1.
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S44(d1,d2,m1,l2)*H24(l1,l2,d1,d2)", &
        Z64_1,S44,H24,scale=(-0.5d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1bm2b,l1b)*Z64_1(l1b|m3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,m2,l1)*Z64_1(l1,m3)", &
        Z55,S45,Z64_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1bm3b,l1b)*Z64_1(l1b|m2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,m3,l1)*Z64_1(l1,m2)", &
        Z55,S45,Z64_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m2bm3b,l1b)*Z64_1(l1b|m1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m2,m3,l1)*Z64_1(l1,m1)", &
        Z55,S45,Z64_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1bm2b,l1b)*Z64_1(l1b|m3b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,m2,l1)*Z64_1(l1,m3)", &
        Z55,S45,Z64_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1bm3b,l1b)*Z64_1(l1b|m2b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,m3,l1)*Z64_1(l1,m2)", &
        Z55,S45,Z64_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m2bm3b,l1b)*Z64_1(l1b|m1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m2,m3,l1)*Z64_1(l1,m1)", &
        Z55,S45,Z64_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1bm2b,l1b)*H16(l1b|m3b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,m2,l1)*H16(l1,m3)", &
        Z55,S45,H16,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m1bm3b,l1b)*H16(l1b|m2b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m1,m3,l1)*H16(l1,m2)", &
        Z55,S45,H16,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2be3b|m2bm3b,l1b)*H16(l1b|m1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,e3,m2,m3,l1)*H16(l1,m1)", &
        Z55,S45,H16,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z100_1, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z100_1(e1b,l1b|m1b,d1b)+=H17(e1b,l1b|d1b,d2b)*S43(d2b|m1b)*-1.
    ierr=talsh_tensor_contract("Z100_1(e1,l1,m1,d1)+=H17(e1,l1,d1,d2)*S43(d2,m1)", &
        Z100_1,H17,S43,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm2b,l1b)*Z100_1(e3b,l1b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,d1,m1,m2,l1)*Z100_1(e3,l1,m3,d1)", &
        Z55,S45,Z100_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be3b,d1b|m1bm2b,l1b)*Z100_1(e2b,l1b|m3b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e3,d1,m1,m2,l1)*Z100_1(e2,l1,m3,d1)", &
        Z55,S45,Z100_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e2be3b,d1b|m1bm2b,l1b)*Z100_1(e1b,l1b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e2,e3,d1,m1,m2,l1)*Z100_1(e1,l1,m3,d1)", &
        Z55,S45,Z100_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm3b,l1b)*Z100_1(e3b,l1b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,d1,m1,m3,l1)*Z100_1(e3,l1,m2,d1)", &
        Z55,S45,Z100_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be3b,d1b|m1bm3b,l1b)*Z100_1(e2b,l1b|m2b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e3,d1,m1,m3,l1)*Z100_1(e2,l1,m2,d1)", &
        Z55,S45,Z100_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e2be3b,d1b|m1bm3b,l1b)*Z100_1(e1b,l1b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e2,e3,d1,m1,m3,l1)*Z100_1(e1,l1,m2,d1)", &
        Z55,S45,Z100_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2b,d1b|m2bm3b,l1b)*Z100_1(e3b,l1b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,d1,m2,m3,l1)*Z100_1(e3,l1,m1,d1)", &
        Z55,S45,Z100_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be3b,d1b|m2bm3b,l1b)*Z100_1(e2b,l1b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e3,d1,m2,m3,l1)*Z100_1(e2,l1,m1,d1)", &
        Z55,S45,Z100_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e2be3b,d1b|m2bm3b,l1b)*Z100_1(e1b,l1b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e2,e3,d1,m2,m3,l1)*Z100_1(e1,l1,m1,d1)", &
        Z55,S45,Z100_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z100_1)
    ierr=talsh_tensor_construct(Z100_1, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z100_1(e1b,l1b|m1b,d1b)+=S44(e1b,d2b|m1b,l2b)*H24(l1b,l2b|d1b,d2b)
    ierr=talsh_tensor_contract("Z100_1(e1,l1,m1,d1)+=S44(e1,d2,m1,l2)*H24(l1,l2,d1,d2)", &
        Z100_1,S44,H24,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm2b,l1b)*Z100_1(e3b,l1b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,d1,m1,m2,l1)*Z100_1(e3,l1,m3,d1)", &
        Z55,S45,Z100_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be3b,d1b|m1bm2b,l1b)*Z100_1(e2b,l1b|m3b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e3,d1,m1,m2,l1)*Z100_1(e2,l1,m3,d1)", &
        Z55,S45,Z100_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e2be3b,d1b|m1bm2b,l1b)*Z100_1(e1b,l1b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e2,e3,d1,m1,m2,l1)*Z100_1(e1,l1,m3,d1)", &
        Z55,S45,Z100_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm3b,l1b)*Z100_1(e3b,l1b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,d1,m1,m3,l1)*Z100_1(e3,l1,m2,d1)", &
        Z55,S45,Z100_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be3b,d1b|m1bm3b,l1b)*Z100_1(e2b,l1b|m2b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e3,d1,m1,m3,l1)*Z100_1(e2,l1,m2,d1)", &
        Z55,S45,Z100_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e2be3b,d1b|m1bm3b,l1b)*Z100_1(e1b,l1b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e2,e3,d1,m1,m3,l1)*Z100_1(e1,l1,m2,d1)", &
        Z55,S45,Z100_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2b,d1b|m2bm3b,l1b)*Z100_1(e3b,l1b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,d1,m2,m3,l1)*Z100_1(e3,l1,m1,d1)", &
        Z55,S45,Z100_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be3b,d1b|m2bm3b,l1b)*Z100_1(e2b,l1b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e3,d1,m2,m3,l1)*Z100_1(e2,l1,m1,d1)", &
        Z55,S45,Z100_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e2be3b,d1b|m2bm3b,l1b)*Z100_1(e1b,l1b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e2,e3,d1,m2,m3,l1)*Z100_1(e1,l1,m1,d1)", &
        Z55,S45,Z100_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z100_1)
    ierr=talsh_tensor_construct(Z100_1, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm2b,l1b)*Z100_1(e3b,l1b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,d1,m1,m2,l1)*Z100_1(e3,l1,m3,d1)", &
        Z55,S45,Z100_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be3b,d1b|m1bm2b,l1b)*Z100_1(e2b,l1b|m3b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e3,d1,m1,m2,l1)*Z100_1(e2,l1,m3,d1)", &
        Z55,S45,Z100_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e2be3b,d1b|m1bm2b,l1b)*Z100_1(e1b,l1b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e2,e3,d1,m1,m2,l1)*Z100_1(e1,l1,m3,d1)", &
        Z55,S45,Z100_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm3b,l1b)*Z100_1(e3b,l1b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,d1,m1,m3,l1)*Z100_1(e3,l1,m2,d1)", &
        Z55,S45,Z100_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be3b,d1b|m1bm3b,l1b)*Z100_1(e2b,l1b|m2b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e3,d1,m1,m3,l1)*Z100_1(e2,l1,m2,d1)", &
        Z55,S45,Z100_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e2be3b,d1b|m1bm3b,l1b)*Z100_1(e1b,l1b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e2,e3,d1,m1,m3,l1)*Z100_1(e1,l1,m2,d1)", &
        Z55,S45,Z100_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2b,d1b|m2bm3b,l1b)*Z100_1(e3b,l1b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,d1,m2,m3,l1)*Z100_1(e3,l1,m1,d1)", &
        Z55,S45,Z100_1,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be3b,d1b|m2bm3b,l1b)*Z100_1(e2b,l1b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e3,d1,m2,m3,l1)*Z100_1(e2,l1,m1,d1)", &
        Z55,S45,Z100_1,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e2be3b,d1b|m2bm3b,l1b)*Z100_1(e1b,l1b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e2,e3,d1,m2,m3,l1)*Z100_1(e1,l1,m1,d1)", &
        Z55,S45,Z100_1,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z100_1)
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm2b,l1b)*H18(e3b,l1b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,d1,m1,m2,l1)*H18(e3,l1,m3,d1)", &
        Z55,S45,H18,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be3b,d1b|m1bm2b,l1b)*H18(e2b,l1b|m3b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e3,d1,m1,m2,l1)*H18(e2,l1,m3,d1)", &
        Z55,S45,H18,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e2be3b,d1b|m1bm2b,l1b)*H18(e1b,l1b|m3b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e2,e3,d1,m1,m2,l1)*H18(e1,l1,m3,d1)", &
        Z55,S45,H18,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2b,d1b|m1bm3b,l1b)*H18(e3b,l1b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,d1,m1,m3,l1)*H18(e3,l1,m2,d1)", &
        Z55,S45,H18,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be3b,d1b|m1bm3b,l1b)*H18(e2b,l1b|m2b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e3,d1,m1,m3,l1)*H18(e2,l1,m2,d1)", &
        Z55,S45,H18,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e2be3b,d1b|m1bm3b,l1b)*H18(e1b,l1b|m2b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e2,e3,d1,m1,m3,l1)*H18(e1,l1,m2,d1)", &
        Z55,S45,H18,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be2b,d1b|m2bm3b,l1b)*H18(e3b,l1b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e2,d1,m2,m3,l1)*H18(e3,l1,m1,d1)", &
        Z55,S45,H18,scale=(1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e1be3b,d1b|m2bm3b,l1b)*H18(e2b,l1b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e1,e3,d1,m2,m3,l1)*H18(e2,l1,m1,d1)", &
        Z55,S45,H18,scale=(-1.0d0,0.0d0))
!   original expression: Z55(e1be2be3b|m1bm2bm3b)+=S45(e2be3b,d1b|m2bm3b,l1b)*H18(e1b,l1b|m1b,d1b)
    ierr=talsh_tensor_contract("Z55(e1,e2,e3,m1,m2,m3)+=S45(e2,e3,d1,m2,m3,l1)*H18(e1,l1,m1,d1)", &
        Z55,S45,H18,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z110_3, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z110_3(l1b,l2b|m1b,d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|m1b)*0.5
    ierr=talsh_tensor_contract("Z110_3(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z110_3,H24,S43,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z110_3)
    ierr=talsh_tensor_construct(Z100_2, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z100_2(e1b,l1b|m1b,d1b)+=H17(e1b,l1b|d1b,d2b)*S43(d2b|m1b)
    ierr=talsh_tensor_contract("Z100_2(e1,l1,m1,d1)+=H17(e1,l1,d1,d2)*S43(d2,m1)", &
        Z100_2,H17,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z100_2)
    ierr=talsh_tensor_construct(Z100_2, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z100_2(e1b,l1b|m1b,d1b)+=S44(e1b,d2b|m1b,l2b)*H24(l1b,l2b|d1b,d2b)*-1.
    ierr=talsh_tensor_contract("Z100_2(e1,l1,m1,d1)+=S44(e1,d2,m1,l2)*H24(l1,l2,d1,d2)", &
        Z100_2,S44,H24,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z100_2)
    ierr=talsh_tensor_construct(Z100_2, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z100_2)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_2(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)
    ierr=talsh_tensor_contract("Z65_2(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_2,H24,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z65_2)
    ierr=talsh_tensor_construct(Z110_2, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z110_2(l1b,l2b|m1b,d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|m1b)*-1.
    ierr=talsh_tensor_contract("Z110_2(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z110_2,H24,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z110_2)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_2(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)*-1.
    ierr=talsh_tensor_contract("Z65_2(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_2,H24,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z65_2)
    ierr=talsh_tensor_construct(Z110_2, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z110_2(l1b,l2b|m1b,d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|m1b)
    ierr=talsh_tensor_contract("Z110_2(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z110_2,H24,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z110_2)
    ierr=talsh_tensor_construct(Z78_1, C8, (/nvir,nvir,nocc,nvir/), init_val=ZERO)
!   original expression: Z78_1(e1be2b|m1b,d1b)+=H3(e1be2b|d1b,d2b)*S43(d2b|m1b)
    ierr=talsh_tensor_contract("Z78_1(e1,e2,m1,d1)+=H3(e1,e2,d1,d2)*S43(d2,m1)", &
        Z78_1,H3,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z78_1)
    ierr=talsh_tensor_construct(Z78_1, C8, (/nvir,nvir,nocc,nvir/), init_val=ZERO)
!   original expression: Z78_1(e1be2b|m1b,d1b)+=H17(e1b,l1b|d1b,d2b)*S44(e2b,d2b|m1b,l1b)
    ierr=talsh_tensor_contract("Z78_1(e1,e2,m1,d1)+=H17(e1,l1,d1,d2)*S44(e2,d2,m1,l1)", &
        Z78_1,H17,S44,scale=(1.0d0,0.0d0))
!   original expression: Z78_1(e1be2b|m1b,d1b)+=H17(e2b,l1b|d1b,d2b)*S44(e1b,d2b|m1b,l1b)*-1.
    ierr=talsh_tensor_contract("Z78_1(e1,e2,m1,d1)+=H17(e2,l1,d1,d2)*S44(e1,d2,m1,l1)", &
        Z78_1,H17,S44,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z78_1)
    ierr=talsh_tensor_construct(Z78_1, C8, (/nvir,nvir,nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z78_1)
    ierr=talsh_tensor_construct(Z93_2, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z93_2(l1bl2b|m1b,d1b)+=H24(l1bl2b|d1b,d2b)*S43(d2b|m1b)
    ierr=talsh_tensor_contract("Z93_2(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z93_2,H24,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z78_1, C8, (/nvir,nvir,nocc,nvir/), init_val=ZERO)
!   original expression: Z78_1(e1be2b|m1b,d1b)+=S44(e1be2b|l1bl2b)*Z93_2(l1bl2b|m1b,d1b)
    ierr=talsh_tensor_contract("Z78_1(e1,e2,m1,d1)+=S44(e1,e2,l1,l2)*Z93_2(l1,l2,m1,d1)", &
        Z78_1,S44,Z93_2,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z93_2)
    ierr=talsh_tensor_destruct(Z78_1)
    ierr=talsh_tensor_construct(Z78_1, C8, (/nvir,nvir,nocc,nvir/), init_val=ZERO)
!   original expression: Z78_1(e1be2b|m1b,d1b)+=S44(e1be2b|l1bl2b)*H25(l1bl2b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z78_1(e1,e2,m1,d1)+=S44(e1,e2,l1,l2)*H25(l1,l2,m1,d1)", &
        Z78_1,S44,H25,scale=(-0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z78_1)
    ierr=talsh_tensor_construct(Z78_1, C8, (/nvir,nvir,nocc,nvir/), init_val=ZERO)
!   original expression: Z78_1(e1be2b|m1b,d1b)+=S45(e1be2b,d2b|m1b,l1bl2b)*H24(l1bl2b|d1b,d2b)
    ierr=talsh_tensor_contract("Z78_1(e1,e2,m1,d1)+=S45(e1,e2,d2,m1,l1,l2)*H24(l1,l2,d1,d2)", &
        Z78_1,S45,H24,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z78_1)
    ierr=talsh_tensor_construct(Z78_1, C8, (/nvir,nvir,nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z78_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=H17(e1b,l1b|d1bd2b)*S44(d1bd2b|m1bm2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=H17(e1,l1,d1,d2)*S44(d1,d2,m1,m2)", &
        Z71_1,H17,S44,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=H26(l1b,l2b|m1bm2b)*S43(e1b|l2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=H26(l1,l2,m1,m2)*S43(e1,l2)", &
        Z71_1,H26,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=H18(e1b,l1b|m1b,d1b)*S43(d1b|m2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=H18(e1,l1,m1,d1)*S43(d1,m2)", &
        Z71_1,H18,S43,scale=(1.0d0,0.0d0))
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=H18(e1b,l1b|m2b,d1b)*S43(d1b|m1b)*-1.
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=H18(e1,l1,m2,d1)*S43(d1,m1)", &
        Z71_1,H18,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z91_2, C8, (/nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z91_2(l1b,l2b|m1bm2b)+=H24(l1b,l2b|d1bd2b)*S44(d1bd2b|m1bm2b)
    ierr=talsh_tensor_contract("Z91_2(l1,l2,m1,m2)+=H24(l1,l2,d1,d2)*S44(d1,d2,m1,m2)", &
        Z91_2,H24,S44,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S43(e1b|l2b)*Z91_2(l1b,l2b|m1bm2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S43(e1,l2)*Z91_2(l1,l2,m1,m2)", &
        Z71_1,S43,Z91_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z91_2)
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z91_2, C8, (/nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z91_2(l1b,l2b|m1bm2b)+=H25(l1b,l2b|m1b,d1b)*S43(d1b|m2b)
    ierr=talsh_tensor_contract("Z91_2(l1,l2,m1,m2)+=H25(l1,l2,m1,d1)*S43(d1,m2)", &
        Z91_2,H25,S43,scale=(1.0d0,0.0d0))
!   original expression: Z91_2(l1b,l2b|m1bm2b)+=H25(l1b,l2b|m2b,d1b)*S43(d1b|m1b)*-1.
    ierr=talsh_tensor_contract("Z91_2(l1,l2,m1,m2)+=H25(l1,l2,m2,d1)*S43(d1,m1)", &
        Z91_2,H25,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S43(e1b|l2b)*Z91_2(l1b,l2b|m1bm2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S43(e1,l2)*Z91_2(l1,l2,m1,m2)", &
        Z71_1,S43,Z91_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z91_2)
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z110_3, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z110_3(l1b,l2b|m1b,d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|m1b)*0.5
    ierr=talsh_tensor_contract("Z110_3(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z110_3,H24,S43,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_construct(Z91_2, C8, (/nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z91_2(l1b,l2b|m1bm2b)+=S43(d1b|m1b)*Z110_3(l1b,l2b|m2b,d1b)
    ierr=talsh_tensor_contract("Z91_2(l1,l2,m1,m2)+=S43(d1,m1)*Z110_3(l1,l2,m2,d1)", &
        Z91_2,S43,Z110_3,scale=(1.0d0,0.0d0))
!   original expression: Z91_2(l1b,l2b|m1bm2b)+=S43(d1b|m2b)*Z110_3(l1b,l2b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z91_2(l1,l2,m1,m2)+=S43(d1,m2)*Z110_3(l1,l2,m1,d1)", &
        Z91_2,S43,Z110_3,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z110_3)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S43(e1b|l2b)*Z91_2(l1b,l2b|m1bm2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S43(e1,l2)*Z91_2(l1,l2,m1,m2)", &
        Z71_1,S43,Z91_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z91_2)
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z100_2, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z100_2(e1b,l1b|m1b,d1b)+=H17(e1b,l1b|d1b,d2b)*S43(d2b|m1b)*0.5
    ierr=talsh_tensor_contract("Z100_2(e1,l1,m1,d1)+=H17(e1,l1,d1,d2)*S43(d2,m1)", &
        Z100_2,H17,S43,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S43(d1b|m1b)*Z100_2(e1b,l1b|m2b,d1b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S43(d1,m1)*Z100_2(e1,l1,m2,d1)", &
        Z71_1,S43,Z100_2,scale=(1.0d0,0.0d0))
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S43(d1b|m2b)*Z100_2(e1b,l1b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S43(d1,m2)*Z100_2(e1,l1,m1,d1)", &
        Z71_1,S43,Z100_2,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z100_2)
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_2(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)
    ierr=talsh_tensor_contract("Z65_2(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_2,H24,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m1bm2b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m1,m2)*Z65_2(l1,d1)", &
        Z71_1,S44,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m1bm2b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m1,m2)*Z65_2(l1,d1)", &
        Z71_1,S44,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m1bm2b)*H15(l1b|d1b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m1,m2)*H15(l1,d1)", &
        Z71_1,S44,H15,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z110_2, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z110_2(l1b,l2b|m1b,d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|m1b)*-1.
    ierr=talsh_tensor_contract("Z110_2(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z110_2,H24,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m1b,l2b)*Z110_2(l1b,l2b|m2b,d1b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m1,l2)*Z110_2(l1,l2,m2,d1)", &
        Z71_1,S44,Z110_2,scale=(1.0d0,0.0d0))
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m2b,l2b)*Z110_2(l1b,l2b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m2,l2)*Z110_2(l1,l2,m1,d1)", &
        Z71_1,S44,Z110_2,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z110_2)
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m1b,l2b)*H25(l1b,l2b|m2b,d1b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m1,l2)*H25(l1,l2,m2,d1)", &
        Z71_1,S44,H25,scale=(1.0d0,0.0d0))
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S44(e1b,d1b|m2b,l2b)*H25(l1b,l2b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S44(e1,d1,m2,l2)*H25(l1,l2,m1,d1)", &
        Z71_1,S44,H25,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z71_1(e1b,l1b|m1bm2b)+=S45(e1b,d1bd2b|m1bm2b,l2b)*H24(l1b,l2b|d1bd2b)
    ierr=talsh_tensor_contract("Z71_1(e1,l1,m1,m2)+=S45(e1,d1,d2,m1,m2,l2)*H24(l1,l2,d1,d2)", &
        Z71_1,S45,H24,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z71_1, C8, (/nvir,nocc,nocc,nocc/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z71_1)
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
!   original expression: Z62_1(e1b|d1b)+=H17(e1b,l1b|d1b,d2b)*S43(d2b|l1b)
    ierr=talsh_tensor_contract("Z62_1(e1,d1)+=H17(e1,l1,d1,d2)*S43(d2,l1)", &
        Z62_1,H17,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
!   original expression: Z62_1(e1b|d1b)+=S44(e1b,d2b|l1bl2b)*H24(l1bl2b|d1b,d2b)*-1.
    ierr=talsh_tensor_contract("Z62_1(e1,d1)+=S44(e1,d2,l1,l2)*H24(l1,l2,d1,d2)", &
        Z62_1,S44,H24,scale=(-0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z66_1, C8, (/nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z66_1(l1bl2b|m1bm2b)+=H25(l1bl2b|m1b,d1b)*S43(d1b|m2b)
    ierr=talsh_tensor_contract("Z66_1(l1,l2,m1,m2)+=H25(l1,l2,m1,d1)*S43(d1,m2)", &
        Z66_1,H25,S43,scale=(1.0d0,0.0d0))
!   original expression: Z66_1(l1bl2b|m1bm2b)+=H25(l1bl2b|m2b,d1b)*S43(d1b|m1b)*-1.
    ierr=talsh_tensor_contract("Z66_1(l1,l2,m1,m2)+=H25(l1,l2,m2,d1)*S43(d1,m1)", &
        Z66_1,H25,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z66_1)
    ierr=talsh_tensor_construct(Z93_2, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z93_2(l1bl2b|m1b,d1b)+=H24(l1bl2b|d1b,d2b)*S43(d2b|m1b)*0.5
    ierr=talsh_tensor_contract("Z93_2(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z93_2,H24,S43,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_construct(Z66_1, C8, (/nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z66_1(l1bl2b|m1bm2b)+=S43(d1b|m1b)*Z93_2(l1bl2b|m2b,d1b)
    ierr=talsh_tensor_contract("Z66_1(l1,l2,m1,m2)+=S43(d1,m1)*Z93_2(l1,l2,m2,d1)", &
        Z66_1,S43,Z93_2,scale=(1.0d0,0.0d0))
!   original expression: Z66_1(l1bl2b|m1bm2b)+=S43(d1b|m2b)*Z93_2(l1bl2b|m1b,d1b)*-1.
    ierr=talsh_tensor_contract("Z66_1(l1,l2,m1,m2)+=S43(d1,m2)*Z93_2(l1,l2,m1,d1)", &
        Z66_1,S43,Z93_2,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z93_2)
    ierr=talsh_tensor_destruct(Z66_1)
    ierr=talsh_tensor_construct(Z66_1, C8, (/nocc,nocc,nocc,nocc/), init_val=ZERO)
!   original expression: Z66_1(l1bl2b|m1bm2b)+=S44(d1bd2b|m1bm2b)*H24(l1bl2b|d1bd2b)
    ierr=talsh_tensor_contract("Z66_1(l1,l2,m1,m2)+=S44(d1,d2,m1,m2)*H24(l1,l2,d1,d2)", &
        Z66_1,S44,H24,scale=(0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z66_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=H25(l1b,l2b|m1b,d1b)*S43(d1b|l2b)*-1.
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=H25(l1,l2,m1,d1)*S43(d1,l2)", &
        Z64_1,H25,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_2(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)*-1.
    ierr=talsh_tensor_contract("Z65_2(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_2,H24,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S43(d1b|m1b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S43(d1,m1)*Z65_2(l1,d1)", &
        Z64_1,S43,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S43(d1b|m1b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S43(d1,m1)*Z65_2(l1,d1)", &
        Z64_1,S43,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S43(d1b|m1b)*H15(l1b|d1b)*-1.
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S43(d1,m1)*H15(l1,d1)", &
        Z64_1,S43,H15,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S44(d1bd2b|m1b,l2b)*H24(l1b,l2b|d1bd2b)*-1.
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S44(d1,d2,m1,l2)*H24(l1,l2,d1,d2)", &
        Z64_1,S44,H24,scale=(-0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z100_1, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z100_1(e1b,l1b|m1b,d1b)+=H17(e1b,l1b|d1b,d2b)*S43(d2b|m1b)*-1.
    ierr=talsh_tensor_contract("Z100_1(e1,l1,m1,d1)+=H17(e1,l1,d1,d2)*S43(d2,m1)", &
        Z100_1,H17,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z100_1)
    ierr=talsh_tensor_construct(Z100_1, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z100_1(e1b,l1b|m1b,d1b)+=S44(e1b,d2b|m1b,l2b)*H24(l1b,l2b|d1b,d2b)
    ierr=talsh_tensor_contract("Z100_1(e1,l1,m1,d1)+=S44(e1,d2,m1,l2)*H24(l1,l2,d1,d2)", &
        Z100_1,S44,H24,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z100_1)
    ierr=talsh_tensor_construct(Z100_1, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z100_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_2(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)*-1.
    ierr=talsh_tensor_contract("Z65_2(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_2,H24,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z65_2)
    ierr=talsh_tensor_construct(Z110_2, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z110_2(l1b,l2b|m1b,d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|m1b)
    ierr=talsh_tensor_contract("Z110_2(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z110_2,H24,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z110_2)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_2(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)*-1.
    ierr=talsh_tensor_contract("Z65_2(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_2,H24,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z65_2)
    ierr=talsh_tensor_construct(Z110_2, C8, (/nocc,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z110_2(l1b,l2b|m1b,d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|m1b)
    ierr=talsh_tensor_contract("Z110_2(l1,l2,m1,d1)+=H24(l1,l2,d1,d2)*S43(d2,m1)", &
        Z110_2,H24,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z110_2)
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
!   original expression: Z62_1(e1b|d1b)+=H17(e1b,l1b|d1b,d2b)*S43(d2b|l1b)
    ierr=talsh_tensor_contract("Z62_1(e1,d1)+=H17(e1,l1,d1,d2)*S43(d2,l1)", &
        Z62_1,H17,S43,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
!   original expression: Z62_1(e1b|d1b)+=S44(e1b,d2b|l1bl2b)*H24(l1bl2b|d1b,d2b)*-1.
    ierr=talsh_tensor_contract("Z62_1(e1,d1)+=S44(e1,d2,l1,l2)*H24(l1,l2,d1,d2)", &
        Z62_1,S44,H24,scale=(-0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z62_1, C8, (/nvir,nvir/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z62_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=H25(l1b,l2b|m1b,d1b)*S43(d1b|l2b)*-1.
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=H25(l1,l2,m1,d1)*S43(d1,l2)", &
        Z64_1,H25,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
!   original expression: Z65_2(l1b|d1b)+=H24(l1b,l2b|d1b,d2b)*S43(d2b|l2b)*-1.
    ierr=talsh_tensor_contract("Z65_2(l1,d1)+=H24(l1,l2,d1,d2)*S43(d2,l2)", &
        Z65_2,H24,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S43(d1b|m1b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S43(d1,m1)*Z65_2(l1,d1)", &
        Z64_1,S43,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z65_2, C8, (/nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S43(d1b|m1b)*Z65_2(l1b|d1b)
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S43(d1,m1)*Z65_2(l1,d1)", &
        Z64_1,S43,Z65_2,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z65_2)
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S43(d1b|m1b)*H15(l1b|d1b)*-1.
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S43(d1,m1)*H15(l1,d1)", &
        Z64_1,S43,H15,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
!   original expression: Z64_1(l1b|m1b)+=S44(d1bd2b|m1b,l2b)*H24(l1b,l2b|d1bd2b)*-1.
    ierr=talsh_tensor_contract("Z64_1(l1,m1)+=S44(d1,d2,m1,l2)*H24(l1,l2,d1,d2)", &
        Z64_1,S44,H24,scale=(-0.5d0,0.0d0))
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z64_1, C8, (/nocc,nocc/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z64_1)
    ierr=talsh_tensor_construct(Z100_1, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z100_1(e1b,l1b|m1b,d1b)+=H17(e1b,l1b|d1b,d2b)*S43(d2b|m1b)*-1.
    ierr=talsh_tensor_contract("Z100_1(e1,l1,m1,d1)+=H17(e1,l1,d1,d2)*S43(d2,m1)", &
        Z100_1,H17,S43,scale=(-1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z100_1)
    ierr=talsh_tensor_construct(Z100_1, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
!   original expression: Z100_1(e1b,l1b|m1b,d1b)+=S44(e1b,d2b|m1b,l2b)*H24(l1b,l2b|d1b,d2b)
    ierr=talsh_tensor_contract("Z100_1(e1,l1,m1,d1)+=S44(e1,d2,m1,l2)*H24(l1,l2,d1,d2)", &
        Z100_1,S44,H24,scale=(1.0d0,0.0d0))
    ierr=talsh_tensor_destruct(Z100_1)
    ierr=talsh_tensor_construct(Z100_1, C8, (/nvir,nocc,nocc,nvir/), init_val=ZERO)
    ierr=talsh_tensor_destruct(Z100_1)


end subroutine generic_codegen_call
