tmax <- 10
h <- 0.1
source('dhanusa.mod.01.R')

Dhanusa.ACF.data <- read.csv('~/Documents/TB/IMPACTTB/ACF_DATA/Dhanusa_VDC_ACF.csv')

estimates <- read.csv(file=file.estimate)
n.vdc <- dim(estimates)[2]-1
nodata.set <- c(39,42,64)

vdc.sim <- (1:n.vdc)[-nodata.set]

noint.result <- int.result <- vector('list', length(vdc.sim))


ACF.cases <- Dhanusa.ACF.data$Cases
default.pars <- pars

noint.result <- int.result <- vector('list', length(vdc.sim))

ind <- 1
for(jtw in vdc.sim){

	ystart <-c(U.0=estimates[2,jtw+1],
			L.0=estimates[3,jtw+1],
			A.0=estimates[4,jtw+1],
			CI.0=0
	)

	pars$beta <- estimates[1,jtw+1]
	pars$N <- sum(ystart)

	y.noint <- dhanusa.ode.mod.01(h=h, tmax=tmax, pars=pars, ystart=ystart)

	noint.result[[ind]] <- list(y=y.noint,ystart=ystart,pars=pars)

	## Intervention 1
	## Active case finding w/data
	
	ystart.acf.data <- ystart
	
	AtoL <- ACF.cases[jtw]
	ystart.acf.data['A.0'] <- ystart.acf.data['A.0'] - AtoL
	ystart.acf.data['L.0'] <- ystart.acf.data['L.0'] + AtoL
	
	y.acf.data <- dhanusa.ode.mod.01(h=h, tmax=tmax, pars=pars, ystart=ystart.acf.data)


	int.result[[ind]] <- list(y=y.acf.data,ystart=ystart.acf.data,pars=pars)
	ind <- ind + 1

	
}

save(noint.result, file=file.save.noint)
save(int.result, file=file.save.int)


