library(deSolve)

chitawan.mod.01 <- function(t, X, params){
	with(as.list(params),{
		lambda <- beta*(X[3])
		TT <- make.trans(lambda, params)
		DX <- TT%*%X
		list(DX)
	})
}


make.trans <- function(lambda, params){
	ncol <- 4
	with(params,{	
		m.in <- m.out <- m.trans <- matrix(0,ncol,ncol)
		
		## inflows
		
		# mortalities
		m.in[1,] <- c(rep(mu,times=2), mu.A,0)
		
		# transmissions
		m.in[2,1] <- (1-p)*lambda
		m.in[4,1] <- m.in[3,1] <- p*lambda
		
		# L -> A progressions = reactivation + reinfections
		m.in[4,2] <- m.in[3,2] <- phi + p*xi*lambda
				
		# treatments
		m.in[2,3] <- (1-k)*omega
		
						
		## out flows
		diag(m.out[1:3,1:3]) <- colSums(m.in[1:3,1:3])
		
		## final transition matrix
		m.trans <- m.in-m.out	
		m.trans
	})
}


chitawan.ode.mod.01 <- function (h, tmax, pars, ystart){
  sol <- as.data.frame(
                     lsoda(
                           ystart,
                           times=seq(0,tmax,by=h),
                           func=chitawan.mod.01,
                           parms=pars,
                           rtol=1e-10,
                           atol=1e-10
                           )
                     )  
}
