import numpy as np
import ptarcade.models_utils as aux

name = 'uldm_p_unc'

smbhb = True 

parameters ={
    "log10_A_dm" : aux.prior("Uniform", -9, -4),
    "log10_f_dm" : aux.prior("Uniform", -10, -5.5),
    "gamma" : aux.prior("Uniform", 0, 2 * np.pi, common=False),
    "phi_hat_sq" : aux.prior("Gamma", 1,0,1, common=False)
}

group = ['log10_A_dm', 'log10_f_dm']

def signal(toas, log10_A_dm, log10_f_dm, gamma, phi_hat_sq):
    """
    Function that calculates the pulsar term signal generated by
    ultralight dark matter 
    :param toas: Time-of-arrival measurements [s]
    :param log10_A_dm: log10 of GW strain
    :param log10_f_dm: log10 of GW frequency
    :param phase_p: The Pulsar-term phase of the GW
    :param phi_hat_sq: dm fluctuation at the pulsar position
    :return: the waveform as induced timing residuals (seconds)
    """
    
    A = 10**log10_A_dm
    f= 10**log10_f_dm

    return A * np.sqrt(phi_hat_sq) * np.sin(2 * np.pi * f * toas + gamma)
