import ptarcade.models_utils as aux
import scipy.constants as scon

name = 'pbh_static'

smbhb = False

parameters ={
    "log10_A_stat_dm" : aux.prior("Uniform", -21, -13),
    "sign" : aux.prior("Uniform", -1, 1),
}

def signal(toas, log10_A_stat_dm, sign):
    """
    Function that calculates the static pulsar term signal generated by
    DM substructure
    :param toas: Time-of-arrival measurements [s]
    :param log10_A: log10 of GW strain
    :param log10_f: log10 of GW frequency
    :param phase_p: The Pulsar-term phase of the GW
    :return: the waveform as induced timing residuals (seconds)
    """
    
    if sign > 0:
        s = 1
    else:
        s = -1

    # convert 
    A = 10 ** log10_A_stat_dm
    
    # return timing residual in seconds
    return s * A * (toas**3) / (scon.Julian_year**2)
