import ptarcade.models_utils as aux
import numpy as np

name = 'pbh_dynamic'

smbhb = False

parameters ={
    "log10_A_dyn_dm" : aux.prior("Uniform", -20, -12),
    "t0_on_T" : aux.prior("Uniform", 0, 1),
    "sign" : aux.prior("Uniform", -1, 1),
}

def signal(toas, log10_A_dyn_dm, t0_on_T, sign):
    """
    Function that calculates the dynamic pulsar term signal generated by
    DM substructure
    :param toas: Time-of-arrival measurements [s]
    :param log10_A: log10 of GW strain
    :param log10_f: log10 of GW frequency
    :param phase_p: The Pulsar-term phase of the GW
    :return: the waveform as induced timing residuals (seconds)
    """
    
    if sign > 0:
        s = 1
    else:
        s = -1

    # convert 
    A = 10 ** log10_A_dyn_dm

    # shift the TOAs so that they start at t = 0 (s)
    toas_ref = toas - np.amin(toas)

    # observation time (s)
    T = np.amax(toas_ref)

    # get t_0 (s)
    t_0 = t0_on_T * T

    # return timing residual = A*(t-t_0)*step(t-t_0) (unit = s)
    return s * A * (toas_ref - t_0) * np.heaviside(toas_ref - t_0, 0)
