# Important, all the PDB files must only contain the ATOM and/or HETATM lines, nothing else (no chek is done)

import pybel
from pybel import *
ob = pybel.ob

with open("input.pdb") as f:
    docked_lines = list(f.readlines())


new_lines = [i for i in docked_lines]

ref = next(readfile("pdb", "reference.pdb"))
docked = next(readfile("pdb", "input.pdb"))

query = ob.CompileMoleculeQuery(ref.OBMol)
mapper = ob.OBIsomorphismMapper.GetInstance(query)

isomorph = ob.vpairUIntUInt()
mapper.MapFirst(docked.OBMol, isomorph)

print(list(isomorph))


for ref, dock in list(isomorph):
    new_lines[ref] = docked_lines[dock]

with open("output.pdb", "w") as f:
    f.writelines(new_lines)
                          
