from HREMGromacs.solute_tempering import edit_preprocessed_top
from PythonPDBStructures.geometry import get_nearest_neighbors_residues_with_mdtraj

import subprocess

import mdtraj

tt = mdtraj.load("complex_with_dummy.gro")

nn, _ = get_nearest_neighbors_residues_with_mdtraj(mdtraj_trajectory=tt,
                                               ligand_atoms="resname LIG",
                                               protein_atoms='protein')

nn = [tt.top.residue(i).resSeq for i in nn]


edit_preprocessed_top(input_top_file="complex_with_dummy.top",
                          output_top_file="complex_edited_4_plumed.top",
                          protein_resSeq_to_scale=nn,
                          ligand_resname="LIG")


for i in range(16):
    scaling=0.2 ** (i / 15)
    print(subprocess.run(f"./partial_tempering_only_torsions.sh {scaling} < complex_edited_4_plumed.top  > complex_with_dummy_scaled_{i}.top ", shell=True, check=True))

