#!/bin/bash -l
#SBATCH --job-name="make_tpr"
#SBATCH --time=00:30:00
#SBATCH --partition=CPU-PARTITION

export OMP_NUM_THREADS=$SLURM_CPUS_PER_TASK 

# This is an example script to generate the HREM tpr files on an HPC cluster, it will make the tpr files for 6 independent HREM runs (BATTERY0-5) and 16 replicas (scaled0-15)
# Do it on a cpu partition
# Remember that gromacs must be patched with plumed and each BATTERY$i/scaled$j/ directory must contain a empty_plumed.dat file (it is an empty file)
# If you used HPC_Drug to setup the HREM the directories will already be set with this order and contain empty_plumed.dat

# Remember that replica 0 is the reference one and 15 the most scaled one

for i in {0..5}; do
	for j in {0..15}; do
		srun gmx_mpi grompp -maxwarn 100 -o BATTERY$i/scaled$j/HREM.tpr -f complex_HREM.mdp -p complex_with_dummy_scaled_$j\.top -c complex_with_dummy.gro -n index.ndx
	done
done

