#!/bin/bash

int_handler()
{
  echo "Interrupted."
  kill $PPID
  exit 1
}
trap 'int_handler' INT

JAR=$1
MAINCLASS=de.tu_dresden.lat.proofs.data.ProofGeneratorMain
GENCLASS=$2
INPUTFOLDER=$3
OUTPUTFOLDER=$4

mkdir $OUTPUTFOLDER

for NUM in `ls $INPUTFOLDER/*.json | sed -E 's/.*\/task([0-9]+).json/\1/'`
do
  echo "$NUM"
  OUTFILE=$OUTPUTFOLDER/proof$NUM.json
  if [ -f "$OUTFILE" ]; then
    rm "$OUTFILE"
  fi
  timeout 300 java -ea -cp "$JAR" "$MAINCLASS" "$GENCLASS" "$INPUTFOLDER/task$NUM" "$OUTPUTFOLDER/proof$NUM"||gtimeout 300 java -ea -cp "$JAR" "$MAINCLASS" "$GENCLASS" "$INPUTFOLDER/task$NUM" "$OUTPUTFOLDER/proof$NUM"
  if [ ! -f "$OUTFILE" ]; then
    echo "Timeout" > "$OUTFILE"
  fi
done
