#!/bin/bash

int_handler()
{
  echo "Interrupted."
  kill $PPID
  exit 1
}
trap 'int_handler' INT

for path in $(ls -d el-proofs-* el-proofs-*/unique)
do
	echo $path
	java -cp proof-evaluation-0.1-SNAPSHOT-jar-with-dependencies.jar de.tu_dresden.lat.proofs.rule_extraction.ImageGenerator $path/ HYPERGRAPHS &
done

for path in $(ls -d el-proofs-*/trees)
do
	echo $path
	java -cp proof-evaluation-0.1-SNAPSHOT-jar-with-dependencies.jar de.tu_dresden.lat.proofs.rule_extraction.ImageGenerator $path/ TREES &
done

wait
echo "Completed generating proof images"
