#!/bin/bash

int_handler()
{
  echo "Interrupted."
  kill $PPID
  exit 1
}
trap 'int_handler' INT

JAR=proof-evaluation-0.1-SNAPSHOT-jar-with-dependencies.jar
MAINCLASS=de.tu_dresden.lat.proofs.rule_extraction.ExtractEntailments
INPUTFOLDER=el/classification/
OUTPUT=el-tasks/
EXCEPTIONS=el-exceptions.txt
PROCESSED=el-processed.txt

touch $EXCEPTIONS
touch $PROCESSED
mkdir $OUTPUT

for INPUTFILE in $(ls -Sr $INPUTFOLDER/*.owl)
do
#  echo $INPUTFILE
  java -cp $JAR $MAINCLASS $INPUTFILE $OUTPUT $EXCEPTIONS $PROCESSED EL
done
