```{image} ../images/GitHub-logo.png
:alt: GitHub Logo
:width: 600px
```

# Getting Started with GitHub

Python and Jupyter are cool technologies, but they only scratch the surface of why you might want to adopt Python for your geoscience workflow.

This section will introduce GitHub, the de facto standard platform for collaboration and version control used by the open-source Python community.

We will walk users through these topics:

- [What is GitHub?](github/what-is-github), and how to create your free account
- [What are GitHub Repositories](github/github-repos), and what are some Python-specific examples?
- [Issues and Discussions](github/github-issues) on GitHub: what they're for and how to participate
- [Cloning and Forking a Repository](github/github-cloning-forking) (and what's the difference?)
- [Detailed GitHub Configuration](github/github-setup-advanced), including how to set up secure permissions and notifications
- [Basic Version Control with _git_](github/basic-git): why you may need it, and how to get started
- [What is a git _Branch_?](github/git-branches)
- [What's a Pull Request](github/github-pull-request), and how do you open one?
- [GitHub Workflows](github/github-workflows), sets of best practices for collaborative work
- [Contributing to Project Pythia via GitHub](github/contribute-to-pythia)
