# Why Python?

You're already here because you want to learn to use Python for your data analysis and visualizations.

**Perhaps the #1 reason to use Python is because it is so widely used in the scientific community!**

Python can be compared to other high-level, interpreted, object-oriented languages, but is especially great because it is free and open source!

Want to know what these terms mean for you and your work? Read on!

## High level languages

Other high level languages include MatLab, IDL, and NCL. The advantage of high level languages is that they provide built-in functions, data structures, and other utilities that are commonly used, which means it takes less code to get real work done. The disadvantage of high level languages is that they tend to obscure the low level aspects of the machine such as memory use, how many floating point operations are happening, and other information related to performance. C, C++, and Fortran are all examples of lower level languages. The "higher" the level of language, the more computing fundamentals are abstracted.

## Interpreted languages

Most of your work is probably already in interpreted languages if you've ever used IDL, NCL, or MatLab (interpreted languages are typically also high level). So you are already familiar with the advantages of this: you don't have to worry about compiling or machine compatibility (it is portable). And you are probably familiar with their deficiencies: sometimes they can be slower than compiled languages and potentially more memory intensive.

## Object Oriented languages

Objects are custom datatypes. For every custom datatype, you usually have a set of operations you might want to conduct. For example, if you have an object that is a list of numbers, you might want to apply a mathematical operation, such as sum, onto this list object in bulk. Not every function can be applied to every datatype; it wouldn't make sense to apply a logarithm to a string of letters or to capitalize a list of numbers. Data and the operations applied to them are grouped together into one object.

## Open source

Python as a language is open source, which means that there is a community of developers behind its codebase. Anyone can join the developer community and contribute to deciding the future of the language. When someone identifies gaps in Python's abilities, they can write up the code to fill these gaps. The open source nature of Python means that Python as a language is very adaptable to the shifting needs of the user community. This harkens back to the idea that the widespread use of Python within the scientific community is a benefit to you! The large Python user base within your field has established high level community Python packages that are available to you in your workflow.

Python is a language designed for rapid prototyping and efficient programming. It is easy to write new code quickly with less typing.
