# Cartopy

This section contains tutorials on plotting maps with [Cartopy](https://scitools.org.uk/cartopy/docs/latest/); it is cross-referenced with tutorials on [Xarray](xarray) and [Matplotlib](matplotlib).

---

From the [Cartopy website](https://scitools.org.uk/cartopy/docs/latest):

> Cartopy is a Python package designed for geospatial data processing in order to
> produce maps and other geospatial data analyses.
>
> Cartopy makes use of the powerful PROJ.4, NumPy and Shapely libraries and includes a programmatic interface
> built on top of Matplotlib for the creation of publication quality maps.
>
> Key features of Cartopy are its object-oriented [projection definitions](https://scitools.org.uk/cartopy/docs/latest/reference/crs.html#list-of-projections),
> and its ability to transform points, lines, vectors, polygons and images between those projections.

Before working through the Cartopy notebooks in this section of Pythia Foundations, you should first have a basic knowledge of [Matplotlib](matplotlib).

In addition, please note that the geographic-features library used by Cartopy makes use of shapefiles directly served by [Natural Earth](https://www.naturalearthdata.com/).
