clear, close all

L = 2;                          % length of the unit cell

alpha = 1;                      %
beta = 1;                       % material parameters
gamma = 0.5;                    %

singularity = sqrt(4*beta-gamma^2)/2*beta;  % position of the pole(s)

%% Compute dispersion curves

omegas = linspace(0,7,5000);        % set the range of frequencies

as = NaN(size(omegas));             % vector to store the quasiperiodicities

for n = 1:length(omegas)
    omega = omegas(n);
    r = HP(omega,alpha,beta,gamma);
    T = MakeTransferMatrix(r,omega);
    as(n) = acos(trace(T)/2)/L;
end

%% Plot the dispersion curves

subplot(2,1,1)
plot(omegas,real(as),'k')
hold on
scatter(singularity,0,100,'kx')

ylabel('$\Re(\kappa)$','interpreter','latex')
ylim([0,pi/L])
set(gca,'TickLabelInterpreter','latex','FontSize',14)
set(gca,'XTickLabel',[])

subplot(2,1,2)
plot(omegas,abs(imag(as)),'k')
hold on
scatter(singularity,0,100,'kx')

xlabel('Frequency $\omega$','interpreter','latex')
ylabel('$\Im(\kappa)$','interpreter','latex')
set(gca,'TickLabelInterpreter','latex','FontSize',14)
Pos = get(gca,'Position');
set(gca,'Position',Pos+[0 0.075 0 0])