# Guidelines for Contributing

Thank you for being interested in contributing to PyTensor.
PyTensor is an open source, collective effort, maintained by the PyMC team and everyone is welcome to contribute.
There are many ways in which you can help make it better.
Please check the latest information for contributing to the PyTensor or PyMC projects under:
* https://pytensor.readthedocs.io/en/latest/dev_start_guide.html
* https://docs.pymc.io/en/latest/contributing/index.html

## Issues and Discussions

We expect that Github Issues ("issues") indicate work that should be in PyTensor
and can be picked up immediately by a contributor. This includes bugs, which
indicate something not working as advertised.

Discussions should be created when the scope or direction of the work, though
within the stated goals of the PyTensor project, require additional clarification
or consideration before a course of action is chosen.

For issues a minimal working example (MWE) is strongly recommended when relevant
(fixing a typo in the documentation does not require a MWE). For discussions,
MWEs are generally required. All MWEs must be implemented using PyTensor. Please
do not submit MWEs if they are not implemented in PyTensor. In certain cases,
pseudocode may be acceptable, but an PyTensor implementation is always preferable.

## Quick links

Most of these point to PyMC documentation, but are equally relevant for PyTensor.

* [Pull request (PR) step-by-step ](https://docs.pymc.io/en/latest/contributing/pr_tutorial.html)
* [Pull request (PR) checklist](https://docs.pymc.io/en/latest/contributing/pr_checklist.html)
* [Python style guide with pre-commit](https://docs.pymc.io/en/latest/contributing/python_style.html)
* [Running the test suite](https://docs.pymc.io/en/latest/contributing/running_the_test_suite.html)
* [Submitting a bug report or feature request](https://github.com/pymc-devs/pytensor/issues)
