/**
 * 
 */
package utility;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

import javax.swing.JOptionPane;

/**
 * Class for various static utility methods.
 * @author Erik
 *
 */
public class Util {
	/**
	 * This class should not be initiated!
	 */
	private Util() {
	}
	
	/**
	 * Copies a Directory from a to b
	 * @param sourceDirectoryLocation
	 * @param destinationDirectoryLocation
	 * @return
	 */
	public static boolean CopyDirectory(final String sourceDirectoryLocation, final String destinationDirectoryLocation) {
	    try {
		Files.walk(Paths.get(sourceDirectoryLocation))
		  .forEach(new Consumer<Path>() {
				/* (non-Javadoc)
				 * @see java.util.function.Consumer#accept(java.lang.Object)
				 */
				@Override
				public void accept(Path source) {
					      Path destination = Paths.get(destinationDirectoryLocation, source.toString()
				        .substring(sourceDirectoryLocation.length()));
				      try {
				    	  if (Files.exists(destination))
				    		  Util.DeleteDirectory(destination.toFile());
				    		  
				          Files.copy(source, destination);
				      } catch (IOException e) {
				          e.printStackTrace();
				      }
				  }
			});
			return true;
		} catch (IOException e) {
			Debug.Error(e);
			
			JOptionPane.showMessageDialog(null, "Unable to copy data to local drive. Please check your connection to the network (and your VPN) if needed.");
			
			return false;
		}
	}
	
	/**
	 * Deletes a directory from the local drive.
	 * @param directoryToBeDeleted
	 * @return whether the deletion process was successful
	 */
	public static boolean DeleteDirectory(File directoryToBeDeleted) {
	    File[] allContents = directoryToBeDeleted.listFiles();
	    if (allContents != null) {
	        for (File file : allContents) {
	            DeleteDirectory(file);
	        }
	    }
	    return directoryToBeDeleted.delete();
	}
	
	/**
	 * Returns a non dublicate file name.
	 * @param copy file to copy
	 * @return file name
	 */
	public static String GetCopiedPathExtension(File copy) {
		if (!copy.isDirectory()) copy = copy.getParentFile();
		String result = "";
		boolean success = false;
		
		do {
			String newStuff = copy.getName();
			result = newStuff + "-"  + result;
			copy = copy.getParentFile();
			
			success = newStuff.length() == 3 && (newStuff.charAt(0) == 'A' || newStuff.charAt(0) == 'a') && Character.isDigit(newStuff.charAt(1)) && Character.isDigit(newStuff.charAt(2));
			
			if (copy == null) {
				result = "NAME ";
				for(int i = 0; i < 15; i++) {
					result += (char)('A' + Math.random() * ('Z' - 'A'));
				}
				return result;
			}
			
			
		}while(!success);
		return result.substring(0, result.length() - 1);
	}
	
	/**
	 * Sorts a Array alphabeticly after the Object.toString() method.
	 * @param a
	 * @return
	 */
	public static <T> T[] SortArrayAfterToString(T[] a) {
		Arrays.<T>sort(a, new Comparator<T>() {

			@Override
			public int compare(T o1, T o2) {
				return o1.toString().compareTo(o2.toString());
			}
		});
		return a;
	}
	
	/**
	 * Checks if an array contains a certain value.
	 * (In the worst way possible)
	 * 
	 * @param arr
	 * @param element
	 * @return the result
	 */
	public static <T> boolean ArrayContains(T[] arr, final T element) {
		return Arrays.stream(arr).anyMatch(new Predicate<T>() {

			@Override
			public boolean test(T arg0) {
				return arg0.equals(element);
			}
		});
	}
	
	/**
	 * Zips a single file.
	 * @param file unzipped file
	 * @param result resulting file ( + .zip)
	 * @param keepOriginal if false, the original file will be deleted.
	 */
	public static void ZipSingleFile(File file, File result, boolean keepOriginal) {
		try {
			FileOutputStream fos = new FileOutputStream(result);
			ZipOutputStream zipOut = new ZipOutputStream(fos);
			
			FileInputStream fileReader = new FileInputStream(file);
			ZipEntry zipEntry = new ZipEntry(file.getName());
			zipOut.putNextEntry(zipEntry);
			
			byte[] bytes = new byte[2048];
			int length;
			while((length = fileReader.read(bytes)) >= 0) {
				zipOut.write(bytes, 0, length);
			}
			
			fileReader.close();
			zipOut.close();
			fos.close();
			
			if (!keepOriginal) file.delete();
			
		} catch (IOException e) {
			Debug.Error(e);
		}
	}
	
	/**
	 * Unzipps a single file
	 * 
	 * @param zippedFile zipped file
	 * @param unzipFile place to unzip the file
	 * @param keepArchive if false, the zip-archive will be deleted
	 */
	public static void UnzipSingleFile(File zippedFile, File unzipFile, boolean keepArchive) {
		try {
			byte[] buffer = new byte[2048];
			ZipInputStream zis = new ZipInputStream(new FileInputStream(zippedFile));
			zis.getNextEntry();
			
			FileOutputStream fos = new FileOutputStream(unzipFile);
			int len;
            while ((len = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            zis.closeEntry();
            zis.close();
			
            if (!keepArchive) zippedFile.delete();
            
		} catch (IOException e) {
			Debug.Error(e);
		}
	}
	
	public static String Trim(String s, char...trimmingChars) {
		int start = 0, end = s.length();
		out : for(int i = 0; i < s.length(); i++) {
			for(char c : trimmingChars) {
				if (c == s.charAt(i)) {
					start++;
					continue out;
				}
			}
			break;
		}
		
		out : for(int i = s.length() - 1; i >= 0; i--) {
			for(char c : trimmingChars) {
				if (c == s.charAt(i)) {
					end--;
					continue out;
				}
			}
			break;
		}
		
		return s.substring(start, end);
	}
	
	//public static <T> T[] ArrayToString()
}
