package utility;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;


/**
 * This class handles every kind of logging or debugging.
 * Use static methods!
 * 
 * @author Erik
 *
 */
public final class Debug {

	public static PrintStream err = System.err;
	public static PrintStream out = System.out; 
	public static PrintStream warning = System.out;
	
	public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm::ss");
	
	private Debug() {
	}
	
	/**
	 * Changes the Debugmode to File Mode. Log, Error or Warning Calls are now Written into files instead of the system consol
	 * @param dirPath path of the Directory where the files should be placed.
	 */
	public static void ChangeToFileMode(String dirPath) {
		File log = new File(dirPath + "\\DebugLog.txt");
		File err = new File(dirPath + "\\ErrorLog.txt");
		File warning = new File(dirPath + "\\WarningLog.txt");
		
		boolean logNewCreated = false, errNewCreated = false, warningNewCreated = false;
		
		try {
			logNewCreated = log.createNewFile();
			errNewCreated = err.createNewFile();
			warningNewCreated = warning.createNewFile();
		} catch (IOException e) {
			Error(e);
			Error("Unable to create file");
		}
		
		try {
			out = new PrintStream(new FileOutputStream(log, true));
			Debug.err = new PrintStream(new FileOutputStream(err, true));
			Debug.warning = new PrintStream(new FileOutputStream(warning, true));
			
			if (!logNewCreated)out.println("\n-----------------------------------------\n");
			if (!errNewCreated)Debug.err.println("\n-----------------------------------------\n");
			if (!warningNewCreated)Debug.warning.println("\n-----------------------------------------\n");
			Log("");
			Error("");
			Warning("");
			
			
		} catch (FileNotFoundException e) {
			Error(e);
		}
	}
	
	/**
	 * Changes the output of Log, Error or Warning to The System Consol
	 */
	public static void ChangeToConsolMode() {
		out = System.out;
		err = System.err;
		warning = System.out;
	}
	
	/**
	 * Logs a String
	 * @param s
	 */
	public static void Log(String s) {
		out.println("[" + DATE_FORMAT.format(new Date(System.currentTimeMillis())) + "] " + s);
	}
	
	/**
	 * Logs a Warning
	 * @param s warning
	 */
	public static void Warning(String s) {
		if (warning == System.out) s = "[Warning] ";
		warning.println("[" + DATE_FORMAT.format(new Date(System.currentTimeMillis())) + "] " + s);
	}
	
	/**
	 * logs an Exception
	 * @param e exception
	 */
	public static void Error(Exception e) {
		err.println("[" + DATE_FORMAT.format(new Date(System.currentTimeMillis())) + "]:");
		e.printStackTrace(err);
	}
	
	/**
	 * logs an Error
	 * @param s error
	 */
	public static void Error(String s) {
		err.println("[" + DATE_FORMAT.format(new Date(System.currentTimeMillis())) + "] " +s);
	}
	
	/**
	 * Convertes the current Date with a certain dateFormat.
	 * @param dateFormat (Normally: dd.MM.yyyy HH:mm::ss)
	 * @return the formatted date
	 */
	public static String GetCurrentDate(String dateFormat) {
		return new SimpleDateFormat(dateFormat).format(new Date(System.currentTimeMillis()));
	}
	
}
