/**
 * 
 */
package utility;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * This is a class handling the Database.
 * It acts as an Database Connector
 * @author Erik
 *
 */
public class Database {
	private Connection databaseConnector = null;
	private File databaseFile;
	
	
	/**
	 * Creates a new Database based on a database file.
	 * @param database file of a sql-database
	 */
	public Database(File database) {
		this.databaseFile = database;
		try {
			Class.forName("org.sqlite.JDBC");
		} catch (ClassNotFoundException e1) {
			
			Debug.Error(e1);
		}
		
		String connectURL = "jdbc:sqlite:" + database.getPath();
		try {
			databaseConnector = DriverManager.getConnection(connectURL);
		} catch (SQLException e) {
			Debug.Error(e);
			Debug.Error("Unable to open Database!");
			return;
		}
		
		Runtime.getRuntime().addShutdownHook(new Thread(new Runnable() {
			
			@Override
			public void run() {
				try {
					if (databaseConnector != null && !databaseConnector.isClosed()) {
						databaseConnector.close();
					}
				} catch (SQLException e) {
					
					Debug.Error(e);
				}
				
			}
		}));
		
		Debug.Log("Connection Established!");
	}
	
	/**
	 * Executes a Statement on the database
	 * @param statement sql-Statement
	 * @return the resultset (or null) based on the statement
	 * @throws SQLException
	 */
	public ResultSet execute(String statement) throws SQLException {
		Statement s = databaseConnector.createStatement();
		if (s.execute(statement)) {
			return s.getResultSet();
		} else {
			return null;
		}
		
	}
	
	/**
	 * Executes a Statement on the database, and catches every SQLExecption
	 * @param statement sql-Statement
	 * @return the resultset (or null) based on the statement
	 */
	public ResultSet executeSafe(String statement) {
		try {
			return execute(statement);
		} catch (SQLException e) {
			Debug.Error(e);
			return null;
		}
	}
	
	/**
	 * Gets the Database File
	 * @return DatabaseFile
	 */
	public File GetDatabaseFile() {
		return databaseFile;
	}
	
	
}
