/**
 * 
 */
package searching.params;

/**
 * A SearchParam descripes a database search filter.
 * @author Erik
 *
 */
public enum SearchParam {
	CREATOR("Creator", "Creator", InputType.STRING, ComparisonCollection.STRING_FIELD_ONLY_LIKE),
	AGE("Subject Age", "Subject age", InputType.NUMERIC, ComparisonCollection.NUMERIC_FIELD),
	GROUP_ID("Group ID", "Group ID", InputType.GROUP_ID, ComparisonCollection.MULTI_SELECTION_COMBOBOX_ONLY_OR_COMPARE),
	EXPERIMENT_TITLE("Experiment Title", "Experiment title", InputType.STRING, ComparisonCollection.STRING_FIELD),
	CONTRIBUTOR("Contributor", "Contributor", InputType.STRING, ComparisonCollection.STRING_FIELD_ONLY_LIKE),
	DATE("Record Date", "Record date", InputType.DATE, ComparisonCollection.NUMERIC_FIELD),
	MODALITY("Modality", "Modality", InputType.MODALITY, ComparisonCollection.MULTI_SELECTION_COMBOBOX_COMPARE),
	RESOURCE_TYPE("Resource Type", "Resource Type", InputType.RESOURCE_TYPE, ComparisonCollection.STRING_FIELD_ONLY_EQUAL),
	SHARED_WITH("Shared Groups", "Shared with", InputType.STRING, ComparisonCollection.STRING_FIELD_ONLY_LIKE),
	SUBJECT_ID("Subject ID", "Subject ID", InputType.STRING, ComparisonCollection.STRING_FIELD),
	SUBJECT_SPECIES("Subject Species", "Subject Species", InputType.SUBJECT_SPECIES, ComparisonCollection.STRING_FIELD_ONLY_EQUAL),
	SUBJECT_TYPE("Subject Type", "Subject type", InputType.SUBJECT_TYPE, ComparisonCollection.STRING_FIELD_ONLY_EQUAL),
	SUBJECT_SEX("Subject Sex", "Subject sex", InputType.SUBJECT_SEX, ComparisonCollection.STRING_FIELD_ONLY_EQUAL),
	ANIMAL_OR_ETHICS_APPROVAL_NUMBER("Animal/Ethics approval No.", "Animal|Ethics approval No.", InputType.STRING, ComparisonCollection.STRING_FIELD),
	EXTRA_INFO("Extra Info", "Extra information", InputType.STRING, ComparisonCollection.STRING_FIELD_ONLY_LIKE),
	EXPERIMENT_DESCRIPTION("Experiment Description", "Experiment Description", InputType.STRING, ComparisonCollection.STRING_FIELD_ONLY_LIKE);
	
	
	
	private final InputType inputType;
	private final String title;
	private final String sqlName;
	private final ComparisonCollection comparisonCollection;
	
	/**
	 * Creates a new SearchParam
	 * 
	 * @param title Displayed Title of the filter variable
	 * @param sqlName sql-database-column name of the variable
	 * @param inputType Type of the input Component
	 * @param comparisonCollection possible Comparisons
	 */
	private SearchParam(String title, String sqlName, InputType inputType, ComparisonCollection comparisonCollection) {
		this.inputType = inputType;
		this.title = title;
		this.sqlName = sqlName;
		this.comparisonCollection = comparisonCollection;
	}
	
	/**
	 * Retruns the inputType
	 * @return the inputType
	 */
	public InputType GetInputType() {
		return inputType;
	}
	
	/**
	 * Returns the displayed Title
	 * @return the displayed Title
	 */
	public String GetTitle() {
		return title;
	}
	
	/**
	 * Gets the sql-database-column name of the variable;
	 * @return column name
	 */
	public String GetSQLName() {
		return sqlName;
	}
	
	/**
	 * Gets the ComparisonCollection
	 * @return ComparisonCollection
	 */
	public ComparisonCollection GetComparisonCollection() {
		return comparisonCollection;
	}
	
	@Override
	public String toString() {
		return title;		
	}
	
	/**
	 * returns base.toString(), because toString is overwritten!
	 * @return base.toString()
	 */
	public String baseToString() {
		return super.toString();
	}
	
	
}
