/**
 * 
 */
package searching.params;

/**
 * A ComparisonType is the method of comparing the searchvariable with the userdefined input. It consists of an (displayed) Title and the SQL comparerer.
 * @author Erik
 *
 */
public enum ComparisonType {
	NUMERIC_EQUAL("Equal", "="),
	GREATER_AS("Greater", ">"),
	GREATER_OR_EQUAL("Greater or Equal", ">="),
	LESSER_AS("Lesser", "<"),
	LESSER_OR_EQUAL("Lesser or Equal", "<="),
	UNEQUAL("Unequal", "<>"),
	ALPHABETHIC_EQUAL("Equal", "Like"),
	LIKE("Contains", "Like"),
	LIST_CONTAINS_ALL("All [AND]", "AND"),
	LIST_CONTAINS_AT_LEAST_ONE("At least one [OR]", "OR");
	
	
	private final String name; 
	private final String resultingSQL;
	
	/**
	 * Creates a new ComparisonType
	 * @param name displayed Title of the Comparison method
	 * @param resultingSQL SQL-Symbol for comparison
	 */
	private ComparisonType(String name, String resultingSQL) {
		this.name = name;
		this.resultingSQL = resultingSQL;
	}
	
	/**
	 * Returns the displayed title of the ComparisonType
	 * @return
	 */
	public String GetName() {
		return name;
	}
	
	@Override
	public String toString() {
		return name;
	}
	
	/**
	 * returns base.toString(), because toString is overwritten!
	 * @return base.toString()
	 */
	public String baseToString() {
		return super.toString();
	}
	
	/**
	 * Creates a combination out of an input and the sql-Symbol in SQL-Language
	 * @param input input as string
	 * @return SQL-input & comparison combination
	 */
	public String GetResultingSQL(String input) {
		
		switch(this) {
		case LIKE:
			return resultingSQL + " '%" + input + "%'";
		case ALPHABETHIC_EQUAL:
			return resultingSQL + "'"  + input + "'";
		default:
			return resultingSQL + " " + input + "";
		}
	}
	
	/**
	 * Get the Raw SQL comparison symbol
	 * @return SQL symbol
	 */
	public String GetResultingSQL_RAW() {
		return resultingSQL;
	}
}
