/**
 * 
 */
package searching.params;

/**
 * A ComparisonCollection is a collection of ComparisonTypes. A SearchParam will get a ComparisonCollection to determen the possible comparison methods.
 * @author Erik
 *
 */
public enum ComparisonCollection {
	
	NUMERIC_FIELD(ComparisonType.NUMERIC_EQUAL, ComparisonType.GREATER_AS, ComparisonType.GREATER_OR_EQUAL, ComparisonType.LESSER_AS, ComparisonType.LESSER_OR_EQUAL, ComparisonType.UNEQUAL),
	STRING_FIELD(ComparisonType.ALPHABETHIC_EQUAL, ComparisonType.LIKE),
	STRING_FIELD_ONLY_LIKE(ComparisonType.LIKE),
	STRING_FIELD_ONLY_EQUAL(ComparisonType.ALPHABETHIC_EQUAL),
	MULTI_SELECTION_COMBOBOX_COMPARE(ComparisonType.LIST_CONTAINS_ALL, ComparisonType.LIST_CONTAINS_AT_LEAST_ONE),
	MULTI_SELECTION_COMBOBOX_ONLY_OR_COMPARE(ComparisonType.LIST_CONTAINS_AT_LEAST_ONE);
	private ComparisonType[] types;
	
	private ComparisonCollection(ComparisonType... types) {
		this.types = types;
	}
	
	/**
	 * Return all ComparisonTypes as an array.
	 * @return ComparisonType-Array
	 */
	public ComparisonType[] GetComparisonTypes() {
		return types;
	}
}

