/**
 * 
 */
package searching.gui;

import java.awt.Dimension;
import java.util.Vector;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox; 

/**
 * This is a custome component.
 * This behaves as a normal JComboBox, with the single Difference, that the popupmenu expands to its preferred size.
 *
 * @param <T>
 */
public class WideComboBox<T> extends JComboBox<T>{ 

    /**
	 * 
	 */
	private static final long serialVersionUID = 1612647750603048272L;

	public WideComboBox() { 
    } 

    public WideComboBox(final T items[]){ 
        super(items); 
    } 

    public WideComboBox(Vector<T> items) { 
        super(items); 
    } 

    public WideComboBox(ComboBoxModel<T> aModel) { 
        super(aModel); 
    } 

    private boolean layingOut = false; 

    public void doLayout(){ 
        try{ 
            layingOut = true; 
                super.doLayout(); 
        }finally{ 
            layingOut = false; 
        } 
    } 

    public Dimension getSize(){ 
        Dimension dim = super.getSize(); 
        if(!layingOut) 
            dim.width = Math.max(dim.width, getPreferredSize().width); 
        return dim; 
    } 
}