/**
 * 
 */
package searching.gui;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;

import javax.swing.JPanel;

/**
 * This is a custom layout component
 * Components bounds added to this component can be determinated relative to this layout box.
 * Even when rescaled the components inside will keep their ratio to the ScalePanel.
 * @author Erik
 *
 */
public class ScalePanel extends JPanel{
	
	/**
	 * associate certain Components with certain Position
	 */
	protected HashMap<Component, Rectangle2D.Float> componentSize = new HashMap<Component, Rectangle2D.Float>();
	
	/**
	 * Creates a new ScalePanel
	 */
	public ScalePanel() {
		setLayout(null);
		
		addComponentListener(new ComponentAdapter() {
			@Override
			public void componentResized(ComponentEvent e) {
				UpdateBounds();
			}
		});
	}
	
	@Override
	public Component add(Component c) {
		super.add(c);
		
		Rectangle bounds = getBounds();
		Rectangle2D.Float componentBounds = new Rectangle2D.Float((float)(c.getX() / bounds.getWidth()), (float) (c.getY() / bounds.getHeight()), (float)(c.getWidth() / bounds.getWidth()), (float)(c.getHeight() / bounds.getHeight()));
		
		componentSize.put(c, componentBounds);
		return c;
	}
	
	/**
	 * Set the bounds of an child component relative to the bounds of this Panel.
	 * The child component will scale and adjust as the ScalePanel does.
	 * The rectangular bounds are in the range from zero to one. Where this range is mapped to the real size of the ScalePanel.
	 * 
	 * @param c The component, for which the bounds will be set
	 * @param x x-Position of the Component in range [0;1]
	 * @param y y-Position of the Component in range [0;1]
	 * @param w width of the Component in range [0;1]
	 * @param h height of the Component in range [0;1]
	 */
	public void SetComponentBounds(Component c, float x, float y, float w, float h) {
		componentSize.get(c).setRect(x, y, w, h);
		
		UpdateBounds(c);
	}
	
	/**
	 * Renders and Recalculates the bounds of a certain child component new.
	 * @param c the child component
	 */
	public void UpdateBounds(Component c) {
		Rectangle2D.Float b = componentSize.get(c);
		Rectangle pxlB = getBounds();
		c.setBounds((int)(b.x * pxlB.width), (int)(b.y * pxlB.height), (int)(b.width * pxlB.width), (int)(b.height * pxlB.height));
		//c.setBounds(10, 10, 100, 100);
		//Debug.Log(pxlB.toString() + "\n" + c.getBounds()+"\n----------------");
		
		if (c instanceof ScalePanel) ((ScalePanel)c).UpdateBounds();
		
		c.repaint();
	}
	
	
	/**
	 * Renders and Recalculates the bounds of all child component new.
	 */
	public void UpdateBounds() {
		for(Component c : getComponents()) {
			UpdateBounds(c);		
			
		}
	}
	
	
	
	
}
