package searching.gui;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;

import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;

import utility.Util;

/**
 * This is a custom component.
 * This behaves as a multi-selection-JCombobox
 *
 */
public class ComboSelections extends JButton{
	/**
	 * 
	 */
	private static final long serialVersionUID = -6963622395686623256L;
	private JCheckBoxMenuItem[] menuItems;
	private String[] strings;
	private JPopupMenu menu;
	private String nothingSelectedName;
	private LinkedList<String> buttonTitleStrings = new LinkedList<>();
		
	public ComboSelections(String menuButtonName, String[] strings) {
		super(menuButtonName);
		
		this.nothingSelectedName = menuButtonName;
		
		menuItems = new JCheckBoxMenuItem[strings.length];
		this.strings = strings.clone();
		
		menu = new JPopupMenu();
		
		for(int i = 0; i < strings.length; i++) {
			menuItems[i] = new JCheckBoxMenuItem(strings[i]);
			//menuItems[i].setSelected(true);
			//menuItems[i].doClick();
			menu.add(menuItems[i]);
		}
		
		addActionListener(new ActionListener() {
		    @Override
		    public void actionPerformed(ActionEvent e) {
		    	
		        if (!menu.isVisible()) {
		            Point p = ComboSelections.this.getLocationOnScreen();
		            menu.setInvoker(ComboSelections.this);
		            menu.setLocation((int) p.getX(),
		                    (int) p.getY() + ComboSelections.this.getHeight());
		            menu.setVisible(true);
		        } else {
		            menu.setVisible(false);
		        }

		    }
		});
		
		for(JCheckBoxMenuItem m : menuItems) {
			m.addActionListener(new OpenAction(menu, this));
			m.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent e) {
					JCheckBoxMenuItem source = (JCheckBoxMenuItem)e.getSource();
					if (source.getState()) { // Add
						buttonTitleStrings.add(source.getText());
					} else { // remove
						buttonTitleStrings.remove(source.getText());
					}
					UpdateButtonText();
					
				}
			});
		}
		
	}
	
	
	/**
	 * Toggles certain entries of the Multicombobox
	 * 
	 * @param entriesToToggle the entires to toggle
	 */
	public synchronized void ToggleEntries(String[] entriesToToggle) {
		menu.setVisible(true);
		for(JCheckBoxMenuItem m : menuItems) {
			if (Util.ArrayContains(entriesToToggle, m.getText())) {
				//m.setState(true);
				m.setSelected(true);

			
				buttonTitleStrings.add(m.getText());
				

			}
		}
		
		menu.setVisible(false);
		UpdateButtonText();
	}
	
	/**
	 * Updates the Button Title text, so that it fits the buttonTitleStrings List
	 */
	private final void UpdateButtonText() {
		String txt = "";
		for(String s : buttonTitleStrings) {
			txt += s + ", ";
		}
		if (txt.length() > 2) {
			txt = txt.substring(0, txt.length() - 2);
		} else {
			txt = nothingSelectedName;
		}
		this.setText(txt);
	}
	
	
	private static class OpenAction implements ActionListener {
	
	    private JPopupMenu menu;
	    private JButton button;
	
	    private OpenAction(JPopupMenu menu, JButton button) {
	        this.menu = menu;
	        this.button = button;
	    }
	
	    @Override
	    public void actionPerformed(ActionEvent e) {
	        menu.show(button, 0, button.getHeight());
	    }
	}
	
	public String[] GetSelectedStrings(){
		LinkedList<String> result = new LinkedList<>();
		for(int i = 0; i < strings.length; i++) {
			if (menuItems[i].getState())
				result.add(strings[i]);
		}
		return result.toArray(new String[0]);
	}
}