package main;

import creation.DatabaseCreator;
import searching.gui.MainFrame;
import utility.DatabaseInformation;
import utility.Debug;

/**
 * Entry point of the application.
 * @author Erik
 *
 */
public class Main {
	/**Private Constructor so the class cannot be instanciated*/
	private Main() {}
	
	private static final boolean createDatabase = false;
	private static final boolean useHardcodedArgs = false;
	

	/**possible start: java -jar DatabaseCreator.jar "C:\\Users\\Erik\\Desktop\\DatabaseDestination" "D:\\Erik\\Dokumente\\Arbeit\\Beispieldaten" "C:\\Users\\Erik\\Desktop\\LogDestination"
	 *
	 * @param args
	 * If Creator:
	 * arg0 Destination: "C:\\Users\\Erik\\Desktop\\DatabaseDestination"
	 * arg1 Dataset: "D:\\Erik\\Dokumente\\Arbeit\\Beispieldaten"
	 * arg2 Log-File-Directory: "C:\\Users\\Erik\\Desktop\\LogDestination"
	 */

	public static void main(String[] args) {
		//DatabaseInformation.ExtractFieldArray();
		//Debug.ChangeToFileMode("XXX");
		
		if (createDatabase) {
			//args = new String[] {"XXX", "XXX", "XXX"};
			if (useHardcodedArgs) {
				//args = new String[] {"C:\\Users\\Erik\\Desktop\\", "Z:\\", "C:\\Users\\Erik\\Desktop\\"};
				args = new String[] {"C:\\Users\\Erik\\Desktop", "Z:\\", "C:\\Users\\Erik\\Desktop"};

				System.out.println("HARDCODED ARGS ARE USED, SEND THIS MESSAGE TO THE DEVELOPER!");
			}
			if (args.length > 2) {
				Debug.ChangeToFileMode(args[2]);
			}
	
			DatabaseCreator creator = new DatabaseCreator(args[0], args[1]); //TestEnviroment Beispieldaten
			creator.CreateEmptyDatabase(DatabaseInformation.DATABASE_NAME);
			creator.CreateDataTable();//*/
		} else {
			MainFrame.Main(args);
		}
		
		
		
	}
	
	
}
