# SFB 1280 DatabaseApp

## Introduction
The creation of machine-readable and standardized metadata, for example in a json format, is an essential part of good research data management, but can take up a lot of a researcher's time.  To simplify the metadata creation process, the INF project of SFB 1280 has developed the [MetadataApp](https://gitlab.ruhr-uni-bochum.de/sfb1280/metaapp_2). In addition, the DatabaseApp was developed - an easy-to-use database application that makes the results of one's and other's work in creating metadata "visible" and accessible, thereby fostering collaboration and increasing incentives for good research management. 

 

## About this project

The DatabaseApp provides a graphical user interface for faceted search of available metadata records stored in a connected database (.db): Its core functionality is to provide access to the collected metadata, search for research data of interest in the accessible metadata and retrieve the data associated with the search result. All 16 fields of the [SFB 1280 metadata schema](https://gitlab.ruhr-uni-bochum.de/sfb1280/metaapp_2/-/wikis/MetaDataApp-Wiki/Mapping-to-DublinCore-and-DataCite) as well as logical combinations of these metadata fields can be used to search for matching (meta)data in the connected database. In particular, the DatabaseApp allows to apply single or multiple filters to limit the results according to the aspects and properties of the SFB 1280 metadata. It thus provides researchers with a local and simple interface to a central storage shared in the collaborative research centre thereby fostering collaboration and increasing incentives for good research management.

Please review the [DatabaseApp's Wiki pages](https://gitlab.ruhr-uni-bochum.de/sfb1280/databaseapp_2.0/-/wikis/home) for more detailed information on the faceted search capabilities of the app and instructions for setup. You can download an already exported version of the program [here](https://gitlab.ruhr-uni-bochum.de/sfb1280/databaseapp_2.0/-/tree/main/export_examples) as a .jar file to get a first overview of the program. Please note the helpful information in the wiki on [how to setup the program](https://gitlab.ruhr-uni-bochum.de/sfb1280/databaseapp_2.0//-/wikis/home/Setup-for-user) and [how to create a database](https://gitlab.ruhr-uni-bochum.de/sfb1280/databaseapp_2.0/-/wikis/home/Creating-a-database) that can be used by the DatabaseApp.

![](/images/DatabaseApp_Screenshot.png){width=70%}


## License and Citation
This work is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License: https://creativecommons.org/licenses/by-sa/4.0/

Please cite as: Diers, Erik;  Zomorodpoosh, Setareh;  Labrenz, Franziska; Merz, Christian J.; Pacharra, Marlene; Otto, Tobias  (2023). DatabaseApp (v2.0). Zenodo. https//doi.org/10.5281/zenodo.8039273

## Contact
If you have any questions about the DatabaseApp, or if you have feature requests or found bugs, please contact the SFB's INF project via email: sfb1280data@rub.de

## Funding
The development of the DatabaseApp was carried out as part of the SFB 1280 INF project, supported by the Deutsche Forschungsgemeinschaft DFG (German Research Foundation, project number 316803389). CJM received support by the SFB 1280 A09 project and FL by the A10, A12 and F02 projects.
