/* Comment 
------------------------
Digital data from
C. Rinne, Die Megalithgräber im Haldensleber Forst, Landkreis Börde. 
		Frühe Monumentalität und Soziale Differenzierung Bd. 17 (Bonn 2019).
		https://d-nb.info/1180865057

Codepage UTF-8
SpatiaLite database http://www.gaia-gis.it/gaia-sins/index.html

Creates the tables and adds the data.
- Arbeitsgebiet		: The border of the working area.
- boland750			: General soil map (Bodenlandschaften 1:750.000, data from LDA LSA).
- buek200wms		: General soil map (Bodenübersichtskarte 1:200.000 (BÜK200), wms from Fisbo BGR, http://www.bgr.bund.de)
- buek200_land		: General soil map (Bodenübersichtskarte 1:200.000 (BÜK200), data from LDA LSA).
- eisrandlagen		: Glacial border (moraines).
- fluesse			: Rivers in the working area.
- GemarkungenOA		: Local subdivision used in the archive of the LDA LSA (Gemarkungen der Ortsakten) .
- graeber_pt		: Megalith graves basic data with central point coodinates.
- graeber_steine 	: Megalith graves basic data with 2D polyline for each stone.
- HoehenOhneSteinbruch	: Contour lines without the modern stone quarry (interpolation on basis of modern data and old maps).
- landnutzung		: Land use based on shape files from Open Street Map (www.openstreemap.org 03.2010).
- siedlung_beile 	: Localisation and basic data of settlements and stone axes based on the achive of the LDA LSA.
 */

BEGIN TRANSACTION;
CREATE TABLE "Arbeitsgebiet" ( PKUID INTEGER PRIMARY KEY , 
	"OBJECTID" INTEGER, 
	"Id" INTEGER, 
	"Name" TEXT(50), 
	"Shape_Leng" REAL, 
	"Shape_Area" REAL  );
SELECT AddGeometryColumn('Arbeitsgebiet', 'geometry', 31468, 'MULTIPOLYGON', 2);

CREATE TABLE "GemarkungenOA" ( PKUID INTEGER PRIMARY KEY , 
	"OBJECTID" INTEGER, 
	"AREA" REAL, 
	"PERIMETER" REAL, 
	"Gemarkung" TEXT(50)  );
SELECT AddGeometryColumn('GemarkungenOA', 'geometry', 31468, 'MULTIPOLYGON', 2);

CREATE TABLE "HoehenOhneSteinbruch" ( PKUID INTEGER PRIMARY KEY , 
	"Hoehe" INTEGER, 
	"show" INTEGER  );
SELECT AddGeometryColumn('HoehenOhneSteinbruch', 'geometry', 31468, 'MULTILINESTRING', 2);

CREATE TABLE "boland750" ( PKUID INTEGER PRIMARY KEY , 
	"OBJECTID" INTEGER, 
	"AREA" REAL, 
	"PERIMETER" REAL, 
	"BOLAND750_" REAL, 
	"BOLAND7501" REAL, 
	"LANDNR" TEXT(8), 
	"LAND1" INTEGER, 
	"LAND2" INTEGER, 
	"LAND3" INTEGER, 
	"LAND4" INTEGER, 
	"BODENLANDS" TEXT(20), 
	"BODENREGIO" TEXT(16), 
	"GROSSLANDS" TEXT(16), 
	"BODENLAN_1" TEXT(16), 
	"LANDSCHAFT" TEXT(16), 
	"TEILLANDSC" TEXT(16), 
	"BEARB_LEG" REAL, 
	"Shape_Leng" REAL, 
	"Shape_Area" REAL  );
SELECT AddGeometryColumn('boland750', 'geometry', 31468, 'MULTIPOLYGON', 2);

CREATE TABLE "buek200_land" ( PKUID INTEGER PRIMARY KEY , 
	"AREA" REAL, 
	"PERIMETER" REAL, 
	"KUERZEL" TEXT(15), 
	"BODENFORM" TEXT(138), 
	"FL_NR" INTEGER, 
	"BODEINH_NR" REAL, 
	"Shape_Leng" REAL, 
	"Shape_Area" REAL  );
SELECT AddGeometryColumn('buek200_land', 'geometry', 31468, 'MULTIPOLYGON', 2);

CREATE TABLE "buek200wms" ( PKUID INTEGER PRIMARY KEY , 
	"ID" REAL, 
	"Shape_Leng" REAL, 
	"Shape_Area" REAL, 
	"BodenNrKar" INTEGER, 
	"Bodengrupp" TEXT(254), 
	"Flaeche" INTEGER  );
SELECT AddGeometryColumn('buek200wms', 'geometry', 31468, 'MULTIPOLYGON', 2);

CREATE TABLE "eisrandlagen" ( PKUID INTEGER PRIMARY KEY , 
	"LENGTH" REAL, 
	"EIS_ID" INTEGER, 
	"LAND_SA" INTEGER, 
	"KLASSE" TEXT(1)  );
SELECT AddGeometryColumn('eisrandlagen', 'geometry', 31468, 'MULTIPOLYGON', 2);

CREATE TABLE "fluesse" ( PKUID INTEGER PRIMARY KEY , 
	"Id" INTEGER, 
	"Name" TEXT(50)  );
SELECT AddGeometryColumn('fluesse', 'geometry', 31468, 'MULTILINESTRING', 2);

CREATE TABLE "graeber_pt" ( PKUID INTEGER PRIMARY KEY , 
	"OBJECTID" INTEGER, 
	"OBJECTID_1" INTEGER, 
	"MegaID" INTEGER, 
	"LDANr" TEXT(254), 
	"OANr" INTEGER, 
	"OAGem" TEXT(3), 
	"POINT_X" INTEGER, 
	"POINT_Y" INTEGER, 
	"Region" TEXT(25), 
	"lat" REAL, 
	"lng" REAL, 
	"Grabgruppe" INTEGER  );
SELECT AddGeometryColumn('graeber_pt', 'geometry', 31468, 'MULTIPOINT', 2);

CREATE TABLE "graeber_steine" ( PKUID INTEGER PRIMARY KEY , 
	"OBJECTID" INTEGER, 
	"MegaID" INTEGER, 
	"LDANr" TEXT(254), 
	"OANr" INTEGER, 
	"OAGem" TEXT(3), 
	"Quelle" TEXT(50), 
	"Steintyp" TEXT(50), 
	"SeinTyp1" TEXT(50), 
	"SteinNrA" TEXT(3), 
	"Shape_Leng" REAL, 
	"Shape_Area" REAL, 
	"Volumen" REAL, 
	"Gewicht" REAL, 
	"Auswahl" INTEGER  );
SELECT AddGeometryColumn('graeber_steine', 'geometry', 31468, 'MULTIPOLYGON', 2);

CREATE TABLE "landnutzung" ( PKUID INTEGER PRIMARY KEY , 
	"OBJECTID" INTEGER, 
	"osm_id" REAL, 
	"name" TEXT(48), 
	"type" TEXT(16), 
	"Shape_Leng" REAL, 
	"Shape_Area" REAL  );
SELECT AddGeometryColumn('landnutzung', 'geometry', 31468, 'MULTIPOLYGON', 2);

CREATE TABLE "siedlung_beile" ( PKUID INTEGER PRIMARY KEY , 
	"OBJECTID" INTEGER, 
	"Region" TEXT(50), 
	"Gemarkung" TEXT(30), 
	"LDANr" TEXT(254), 
	"Denkmal" INTEGER, 
	"Fundart" TEXT(254), 
	"FundartID" INTEGER, 
	"OANr" INTEGER, 
	"OAGem" TEXT(3), 
	"Datier" TEXT(50), 
	"POINT_X" INTEGER, 
	"POINT_Y" INTEGER  );
SELECT AddGeometryColumn('siedlung_beile', 'geometry', 31468, 'MULTIPOINT', 2);

INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (1,1,10426017.0,'NULL','quarry',1190.44553223,49709.6045154, ST_GeomFromText('MULTIPOLYGON(((4451729.7262 5789135.176799999,4451720.174399999 5789133.0778,4451709.2247 5789137.569099999,4451705.6198 5789143.446399999,4451697.134499999 5789175.7115,4451700.860199999 5789181.5173,4451711.1858 5789188.0043,4451737.6699 5789197.972599999,4451744.333599999 5789204.4954,4451745.909599999 5789216.175599999,4451754.127899999 5789232.186599999,4451769.6266 5789242.9966,4451827.0431 5789267.297299999,4451891.0586 5789292.268999999,4451915.292299999 5789297.1523,4451932.1315 5789294.796499999,4451956.897099999 5789278.4649,4451988.071 5789243.064699999,4452009.9417 5789230.422499999,4452024.5672 5789226.630799999,4452048.013399999 5789225.669099999,4452084.7295 5789232.6245,4452120.7783 5789246.174499999,4452153.073099999 5789250.2466,4452185.3326 5789250.669199999,4452213.881 5789246.7324,4452221.140899999 5789239.351199999,4452218.033499999 5789221.097899999,4452206.801199999 5789196.3464,4452186.924899999 5789187.7695,4452156.063199999 5789180.022299999,4452095.8014 5789164.5141,4452059.865299999 5789162.6699,4451998.2971 5789163.266699999,4451965.313099999 5789163.586799999,4451935.224499999 5789160.2289,4451906.554899999 5789151.727399999,4451880.142199999 5789149.791999999,4451844.1918 5789146.491699999,4451778.1309 5789137.6205,4451745.849399999 5789135.0196,4451729.7262 5789135.176799999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (2,2,13212013.0,'Hermes (Otto)','industrial',3214.93468079,532130.124132, ST_GeomFromText('MULTIPOLYGON(((4462698.713 5794391.868599999,4461870.900299999 5794151.5973,4461443.7426 5794439.483599999,4461469.9318 5794662.8701,4461484.9226 5794679.1444,4461516.855499999 5794685.3942,4461539.668899999 5794695.776799999,4461582.277499999 5794763.7476,4461514.5043 5794804.925,4461578.610899999 5794906.501199999,4461685.511599999 5794869.449799999,4462058.9298 5794804.7412,4462698.713 5794391.868599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (3,3,25098455.0,'NULL','residential',2882.88514148,323505.609314, ST_GeomFromText('MULTIPOLYGON(((4450935.755699999 5789992.4995,4451086.8557 5790007.450699999,4451098.952999999 5790026.0151,4451149.0009 5790034.501,4451185.814199999 5790116.852399999,4451214.375799999 5790116.2034,4451362.249699999 5790105.066099999,4451324.048799999 5790065.392,4451326.257899999 5790005.2454,4451326.600599999 5789892.170099999,4451279.462199999 5789885.1004,4451284.7126 5789772.399599999,4451316.449199999 5789770.6851,4451317.6878 5789747.2817,4451286.0103 5789744.611199999,4451287.0932 5789721.365199999,4451339.4829 5789728.049499999,4451341.982099999 5789684.158299999,4451287.4768 5789676.370799999,4451344.6463 5789563.9382,4451365.3667 5789511.7221,4451367.712399999 5789487.6291,4451361.593 5789475.325999999,4451250.4966 5789501.635399999,4451252.2976 5789428.539899999,4451066.2026 5789427.661299999,4451057.725599999 5789461.685699999,4451021.2779 5789461.823699999,4450986.023199999 5789505.160399999,4450945.0924 5789478.947799999,4450914.7543 5789515.7597,4450901.404699999 5789509.582499999,4450879.0723 5789498.709499999,4450806.3541 5789480.3473,4450740.564899999 5789498.550699999,4450732.3262 5789554.206199999,4450778.723799999 5789697.2407,4450743.3106 5789707.797499999,4450745.0914 5789886.685499999,4450711.062099999 5789914.6442,4450748.554499999 5789992.3231,4450935.755699999 5789992.4995)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (4,4,30150044.0,'NULL','allotments',2808.1535215,288089.303712, ST_GeomFromText('MULTIPOLYGON(((4461203.8305 5792422.715199999,4462072.8864 5792878.907199999,4462088.1524 5792883.4637,4462097.4204 5792851.0109,4462117.975599999 5792719.056199999,4462139.674999999 5792556.269099999,4462140.6776 5792549.8964,4462142.340499999 5792537.019899999,4462142.268899999 5792527.6732,4462134.573699999 5792517.795099999,4461837.962899999 5792354.6511,4461736.1517 5792298.7311,4461780.6188 5792213.6271,4461854.7674 5792253.9711,4461864.5257 5792170.9384,4461865.699599999 5792162.895199999,4461265.674499999 5792398.194299999,4461203.8305 5792422.715199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (5,5,30318589.0,'NULL','farm',7230.52443409,2405347.33705, ST_GeomFromText('MULTIPOLYGON(((4460797.961799999 5790087.6082,4460784.105499999 5790558.477199999,4460814.211799999 5791028.9535,4460856.329099999 5791166.025499999,4460936.0799 5791244.323999999,4461209.597 5791364.954399999,4461551.7642 5790517.364499999,4462217.575299999 5788882.549699999,4461986.247299999 5788254.5949,4461803.9714 5788199.4473,4461733.2986 5788272.679099999,4461196.707499999 5788828.746099999,4460797.961799999 5790087.6082)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (6,6,30318683.0,'NULL','farmland',5255.95761917,987319.994837, ST_GeomFromText('MULTIPOLYGON(((4461568.337 5790537.911,4461256.3612 5791327.2653,4461260.074199999 5791366.2167,4461261.2871 5791390.287599999,4461301.443099999 5791404.3725,4461343.128899999 5791404.5249,4461395.8557 5791400.974999999,4461451.972699999 5791395.162499999,4461509.111499999 5791380.240199999,4461591.266699999 5791339.953199999,4462382.4605 5790839.5445,4462273.016599999 5790802.466099999,4462326.5721 5790520.3377,4462339.170599999 5790442.7596,4462129.5919 5790347.8714,4462260.5102 5789833.6837,4462206.1408 5789815.827099999,4462221.8596 5789763.073,4462192.5645 5789751.123099999,4462217.4028 5789683.087799999,4462157.311499999 5789660.479399999,4462131.456 5789729.4019,4462079.987399999 5789707.863399999,4462105.8535 5789640.398299999,4462036.754599999 5789613.8877,4462011.603299999 5789679.1444,4461946.9192 5789655.516699999,4461972.0585 5789588.790899999,4461948.539699999 5789580.203099999,4461568.337 5790537.911)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (7,7,33367264.0,'NULL','industrial',2463.60040276,272080.674898, ST_GeomFromText('MULTIPOLYGON(((4461884.339499999 5794144.5499,4462587.033599999 5794342.7606,4462678.850899999 5794374.492399999,4462808.565399999 5794257.540599999,4462739.532399999 5794178.2859,4462825.390899999 5794103.5839,4462681.485199999 5793944.406999999,4462599.192599999 5794016.9034,4462408.354299999 5793798.100099999,4461884.339499999 5794144.5499)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (8,8,33577615.0,'NULL','industrial',3714.82169738,520501.976204, ST_GeomFromText('MULTIPOLYGON(((4461850.843899999 5794130.7763,4462069.797 5793984.707499999,4462080.398799999 5793961.8253,4462067.3673 5793942.0623,4461575.780299999 5793487.752699999,4460903.7356 5793855.356499999,4460764.0223 5793928.661199999,4460763.094499999 5793958.7915,4460727.28 5794006.780999999,4460724.123999999 5794132.661599999,4460708.0683 5794151.2169,4460661.489299999 5794207.3825,4460666.014499999 5794265.6895,4460743.5219 5794214.2968,4460813.856499999 5794177.4173,4460891.374499999 5794152.8671,4460959.5371 5794149.2233,4461046.132399999 5794154.7824,4461047.532999999 5794109.0807,4461049.830799999 5794056.8398,4461151.3375 5794084.5054,4461180.1128 5794100.0918,4461311.297799999 5794183.9901,4461416.4242 5794025.475999999,4461850.843899999 5794130.7763)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (9,9,33577775.0,'Euroglas','industrial',2137.15299648,245075.307122, ST_GeomFromText('MULTIPOLYGON(((4462120.8545 5793820.392699999,4462194.7289 5793880.1282,4462412.875699999 5793749.1258,4462331.1452 5793638.314899999,4462326.312099999 5793566.6556,4462116.8293 5793457.402499999,4462015.546 5793377.125499999,4461927.244199999 5793308.4679,4461592.091799999 5793475.9417,4462043.821 5793896.9865,4462120.8545 5793820.392699999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (10,10,37145569.0,'Masche','meadow',640.092642632,21377.2005998, ST_GeomFromText('MULTIPOLYGON(((4459359.683799999 5795584.043199999,4459218.9219 5795751.4097,4459277.717 5795793.622099999,4459458.185999999 5795663.0315,4459359.683799999 5795584.043199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (11,11,37145571.0,'NULL','allotments',782.883881648,37935.2777136, ST_GeomFromText('MULTIPOLYGON(((4458517.981599999 5795850.5558,4458383.9161 5795700.7673,4458231.646499999 5795808.5581,4458368.855899999 5795964.436499999,4458517.981599999 5795850.5558)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (12,12,39128426.0,'NULL','allotments',655.402875464,7860.86925559, ST_GeomFromText('MULTIPOLYGON(((4460043.126199999 5795634.127299999,4460081.544099999 5795621.8208,4460125.424399999 5795566.872999999,4460275.033599999 5795431.2094,4460253.2964 5795406.936499999,4460106.870299999 5795550.653799999,4460043.126199999 5795634.127299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (13,13,43092156.0,'Bahnhof Hundisburg','residential',179.246521208,1816.23980366, ST_GeomFromText('MULTIPOLYGON(((4460738.387799999 5790650.187599999,4460768.2675 5790648.192299999,4460765.5678 5790586.8442,4460750.3874 5790591.5381,4460732.685999999 5790597.019999999,4460735.223299999 5790620.6574,4460738.387799999 5790650.187599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (14,14,43866612.0,'Hundisburg','residential',4205.22819528,376687.279975, ST_GeomFromText('MULTIPOLYGON(((4458933.6968 5790765.9833,4458945.406 5790758.8867,4458978.6188 5790804.8026,4458966.5623 5790835.8936,4458983.4197 5790889.5567,4459002.932 5790909.269099999,4459013.9593 5790895.7354,4459080.466199999 5790928.512399999,4459092.7684 5790903.128299999,4459076.265499999 5790892.148099999,4459041.037299999 5790870.718299999,4459029.151399999 5790851.521099999,4459030.675999999 5790822.854399999,4459040.990299999 5790794.1149,4459054.5201 5790799.8449,4459063.7615 5790783.399499999,4459056.6303 5790771.763199999,4459065.402499999 5790768.7639,4459101.607099999 5790752.095399999,4459119.1352 5790744.928899999,4459124.5043 5790756.5798,4459168.939699999 5790741.601999999,4459252.245099999 5790725.769999999,4459362.156799999 5790681.177999999,4459376.7701 5790675.7945,4459528.141599999 5790636.841499999,4459559.934799999 5790670.9329,4459578.988099999 5790715.7334,4459573.696399999 5790740.9922,4459554.449 5790806.925899999,4459553.127999999 5790824.118,4459556.8453 5790831.0314,4459628.418899999 5790766.128,4459769.2289 5790636.332399999,4459734.2719 5790591.0041,4459648.3377 5790549.607999999,4459685.8503 5790476.7824,4459624.0459 5790446.2956,4459582.438799999 5790520.323599999,4459571.291699999 5790518.6565,4459522.053 5790523.810799999,4459511.4961 5790519.1456,4459405.911999999 5790512.4108,4459410.306699999 5790476.1204,4459443.5844 5790459.467299999,4459447.020399999 5790449.502,4459448.2169 5790380.4888,4459369.7026 5790385.8068,4459337.520299999 5790393.671499999,4459330.9478 5790378.525,4459282.078499999 5790353.199599999,4459146.6222 5790278.8701,4459186.202399999 5790173.285599999,4459140.313699999 5790154.357699999,4459150.634899999 5790126.2082,4458927.1856 5790046.758799999,4458897.8689 5790047.002299999,4458897.281499999 5790047.007099999,4458943.4785 5790204.0818,4458826.1304 5790162.815999999,4458817.4176 5790172.246999999,4458785.193599999 5790191.577299999,4458688.6582 5790269.8098,4458666.320199999 5790332.567999999,4458882.6288 5790400.3585,4458888.9089 5790450.0142,4458876.3523 5790462.0698,4458823.1858 5790513.1325,4458898.904199999 5790594.959799999,4458902.5963 5790615.971799999,4458905.055599999 5790629.994599999,4458910.5924 5790660.9395,4458916.709699999 5790691.879699999,4458920.460099999 5790719.912799999,4458923.0163 5790745.6191,4458933.6968 5790765.9833)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (15,15,43867648.0,'Katholischer Friedhof','cemetery',277.951021919,1868.18011671, ST_GeomFromText('MULTIPOLYGON(((4459049.239599999 5790417.771199999,4459093.817999999 5790419.739199999,4459092.851099999 5790444.884899999,4459106.925699999 5790445.3583,4459121.582899999 5790445.237099999,4459135.6697 5790443.874399999,4459146.2027 5790441.4506,4459145.9829 5790418.139699999,4459054.830599999 5790384.386099999,4459050.856399999 5790400.2093,4459049.239599999 5790417.771199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (16,16,43995336.0,'evangelischer Friedhof','cemetery',406.720056678,7816.57498152, ST_GeomFromText('MULTIPOLYGON(((4459039.6199 5790597.2977,4459027.4592 5790544.1853,4458999.315299999 5790543.8287,4458962.4495 5790551.745899999,4458951.9022 5790552.4121,4458949.1012 5790568.8043,4458942.6878 5790572.9526,4458938.046299999 5790578.254499999,4458934.626 5790589.978299999,4458933.587299999 5790606.367,4458935.1989 5790658.976999999,4458982.649799999 5790655.077999999,4458975.295199999 5790616.5478,4459017.0871 5790609.6916,4459014.451899999 5790601.601199999,4459039.6199 5790597.2977)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (17,17,43995625.0,'NULL','allotments',214.319323153,2617.45421304, ST_GeomFromText('MULTIPOLYGON(((4459624.0459 5790446.2956,4459685.8503 5790476.7824,4459700.8184 5790442.743,4459639.5869 5790410.5043,4459624.0459 5790446.2956)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (18,18,43995792.0,'NULL','farmyard',706.56137693,22263.5289228, ST_GeomFromText('MULTIPOLYGON(((4459700.8184 5790442.743,4459685.8503 5790476.7824,4459663.076299999 5790520.989499999,4459755.290599999 5790572.7949,4459903.710199999 5790448.705499999,4459918.86 5790436.887399999,4459931.3375 5790426.5599,4459860.389 5790383.5588,4459764.298899999 5790462.7013,4459706.012299999 5790432.1849,4459700.8184 5790442.743)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (19,19,43995811.0,'NULL','allotments',260.053945597,2844.20320594, ST_GeomFromText('MULTIPOLYGON(((4459663.076299999 5790520.989499999,4459648.3377 5790549.607999999,4459734.8162 5790589.909099999,4459755.290599999 5790572.7949,4459663.076299999 5790520.989499999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (20,20,43996432.0,'NULL','farm',2737.10253713,307148.88333, ST_GeomFromText('MULTIPOLYGON(((4458688.6582 5790269.8098,4458785.193599999 5790191.577299999,4458817.4176 5790172.246999999,4458826.1304 5790162.815999999,4458943.4785 5790204.0818,4458897.8689 5790047.002299999,4458889.770899999 5790020.307199999,4458864.6835 5789934.4089,4458800.9472 5789814.458599999,4458772.986999999 5789766.1521,4458753.927 5789730.045499999,4458743.124499999 5789700.3131,4458738.192499999 5789671.689099999,4458725.853699999 5789668.286699999,4458715.833499999 5789661.9385,4458713.571999999 5789659.442399999,4458701.629599999 5789646.255499999,4458660.0607 5789583.441299999,4458643.9572 5789551.4055,4458602.234699999 5789540.6377,4458557.620699999 5789534.579299999,4458534.7516 5789534.192299999,4458517.1758 5789536.086699999,4458501.419499999 5789545.577299999,4458487.4796 5789561.4845,4458475.963399999 5789586.151399999,4458467.963499999 5789611.3673,4458453.652499999 5789653.0164,4458448.076299999 5789686.980799999,4458441.2615 5789713.366399999,4458433.9082 5789745.5875,4458428.322499999 5789778.3947,4458428.474799999 5789796.5206,4458422.722 5789809.4327,4458412.814799999 5789816.537599999,4458403.4488 5789818.953199999,4458394.731399999 5789827.806299999,4458392.0025 5789851.798499999,4458386.2333 5789863.5535,4458375.787899999 5789876.5051,4458373.6025 5789895.240499999,4458364.9983 5789917.535099999,4458341.2515 5789952.242399999,4458313.8277 5789968.842399999,4458304.557699999 5789981.795399999,4458304.113199999 5789998.757899999,4458308.366299999 5790016.2706,4458335.028599999 5790048.795099999,4458340.419999999 5790062.781899999,4458359.454199999 5790094.792099999,4458369.6708 5790124.528699999,4458374.6123 5790154.899399999,4458378.815799999 5790166.559299999,4458393.611499999 5790182.803899999,4458384.513799999 5790216.219299999,4458374.774699999 5790243.1972,4458350.5455 5790290.1936,4458311.1556 5790347.243899999,4458308.363499999 5790363.6475,4458310.549499999 5790413.915699999,4458316.513199999 5790426.150599999,4458330.7012 5790440.0632,4458344.2576 5790448.7289,4458360.7094 5790453.264,4458374.2065 5790454.9086,4458387.703599999 5790456.542099999,4458474.723199999 5790206.6925,4458602.848299999 5790244.209899999,4458688.6582 5790269.8098)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (21,21,43996617.0,'NULL','farmyard',592.086682014,21152.1336613, ST_GeomFromText('MULTIPOLYGON(((4458622.0776 5791025.633099999,4458731.5805 5791096.3701,4458772.5739 5791122.8573,4458826.468299999 5790977.980399999,4458743.0169 5790923.248299999,4458730.0931 5790932.8593,4458717.7192 5790942.053999999,4458661.8562 5790991.6388,4458622.0776 5791025.633099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (22,22,43996761.0,'Hundisburg','residential',186.055690538,2146.02621543, ST_GeomFromText('MULTIPOLYGON(((4459070.1199 5791070.544299999,4459075.597099999 5791094.4682,4459074.6155 5791104.591499999,4459102.538499999 5791116.612299999,4459122.0809 5791069.0796,4459078.5427 5791050.144099999,4459070.1199 5791070.544299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (23,23,43996798.0,'Hundisburg','residential',355.29925783,3987.19825654, ST_GeomFromText('MULTIPOLYGON(((4459057.1385 5791272.0205,4459067.4933 5791178.1497,4459073.0301 5791120.984799999,4459006.3886 5791255.3932,4459057.1385 5791272.0205)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (24,24,43996944.0,'Hundisburg','residential',493.190516512,6806.09845184, ST_GeomFromText('MULTIPOLYGON(((4459061.937599999 5791488.739399999,4459064.8052 5791392.971999999,4459063.4789 5791365.5752,4459052.2011 5791330.593699999,4459050.5634 5791310.1432,4459043.1753 5791309.458799999,4459030.292299999 5791310.7451,4459019.7854 5791316.084499999,4459009.8852 5791323.766799999,4459005.2569 5791331.4166,4459034.036799999 5791338.188699999,4459025.9642 5791354.6245,4459034.7839 5791357.478099999,4459012.2702 5791399.761199999,4459034.583999999 5791404.2499,4459003.865 5791465.8299,4459061.937599999 5791488.739399999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (25,25,43997269.0,'NULL','farm',1328.36686516,83485.5511502, ST_GeomFromText('MULTIPOLYGON(((4459864.9949 5791168.2411,4459828.258999999 5791119.432499999,4459799.871399999 5791088.672299999,4459678.489699999 5790968.8684,4459648.060399999 5790980.2332,4459527.5296 5791025.273,4459516.410799999 5791029.425699999,4459545.5843 5791174.360099999,4459411.023 5791205.8639,4459411.080599999 5791212.885099999,4459412.907599999 5791221.6388,4459420.648599999 5791236.186,4459432.467699999 5791248.374199999,4459450.764 5791263.424699999,4459484.9592 5791287.7034,4459497.328999999 5791294.6126,4459507.879499999 5791294.5262,4459533.5551 5791280.8737,4459579.0734 5791255.942299999,4459617.663399999 5791243.9317,4459643.326899999 5791299.8508,4459649.821 5791305.651,4459660.381099999 5791306.7333,4459674.4197 5791303.102399999,4459755.076399999 5791274.970799999,4459767.9095 5791266.6763,4459777.763399999 5791253.153799999,4459799.250099999 5791228.9987,4459821.9375 5791207.1819,4459844.6326 5791187.123299999,4459864.9949 5791168.2411)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (26,26,43998721.0,'ehemalige Kleingartenanlage','allotments',1342.54277795,75990.3572711, ST_GeomFromText('MULTIPOLYGON(((4458888.9089 5790450.0142,4458882.6288 5790400.3585,4458666.320199999 5790332.567999999,4458688.6582 5790269.8098,4458602.848299999 5790244.209899999,4458474.723199999 5790206.6925,4458387.703599999 5790456.542099999,4458409.8622 5790461.4857,4458437.458499999 5790466.5172,4458466.8415 5790474.4605,4458496.8245 5790484.7357,4458519.725499999 5790488.638599999,4458543.759999999 5790488.4371,4458576.5504 5790484.067399999,4458611.068599999 5790475.5884,4458651.4198 5790462.9769,4458695.2768 5790449.7356,4458739.178 5790441.768899999,4458784.914599999 5790442.555999999,4458821.883299999 5790446.9329,4458860.599499999 5790449.5263,4458888.9089 5790450.0142)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (27,27,43999717.0,'NULL','meadow',1479.76914211,55078.7837502, ST_GeomFromText('MULTIPOLYGON(((4458843.273699999 5790813.5273,4458853.2185 5790811.107799999,4458867.238599999 5790805.149,4458933.1095 5790765.988199999,4458923.0163 5790745.6191,4458920.460099999 5790719.912799999,4458916.709699999 5790691.879699999,4458910.5924 5790660.9395,4458905.055599999 5790629.994599999,4458902.5963 5790615.971799999,4458898.904199999 5790594.959799999,4458823.1858 5790513.1325,4458876.3523 5790462.0698,4458846.6271 5790461.348899999,4458815.542899999 5790459.8495,4458790.314 5790457.722799999,4458749.274699999 5790457.475099999,4458710.622 5790462.4824,4458677.8704 5790471.524599999,4458648.629499999 5790480.537699999,4458621.141099999 5790488.367799999,4458588.996899999 5790499.753499999,4458567.931599999 5790504.603599999,4458544.5091 5790507.7265,4458521.065 5790509.091399999,4458503.4829 5790509.8287,4458485.295699999 5790507.6333,4458475.3947 5790515.3167,4458473.218899999 5790546.604199999,4458504.332 5790551.606499999,4458579.3941 5790554.482599999,4458598.7186 5790551.4053,4458625.026999999 5790542.9951,4458646.1117 5790540.482,4458705.275799999 5790534.724199999,4458737.347 5790588.2706,4458749.021599999 5790604.8538,4458767.108799999 5790655.735099999,4458786.868599999 5790708.216099999,4458820.080699999 5790703.788799999,4458830.7834 5790721.826899999,4458837.3716 5790738.730799999,4458841.685499999 5790763.8438,4458843.273699999 5790813.5273)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (28,28,44000027.0,'NULL','farm',7110.47034864,1248967.73912, ST_GeomFromText('MULTIPOLYGON(((4461330.498399999 5787950.8144,4461294.131 5787951.0986,4461241.368099999 5787953.8594,4461224.375799999 5787956.918999999,4461191.1853 5787987.602299999,4461150.4472 5788028.281899999,4461086.269799999 5788071.5053,4460988.218399999 5788133.701899999,4460926.4013 5788178.655799999,4460827.9352 5788261.334,4460766.9663 5788339.632899999,4460749.598899999 5788368.435599999,4460745.055399999 5788386.609799999,4460764.216 5788509.8976,4460722.3848 5788559.948,4460678.7871 5788609.4342,4460600.900299999 5788697.217,4460572.391599999 5788726.109099999,4460538.1424 5788770.2586,4460507.5525 5788831.927699999,4460486.7351 5788868.937799999,4460443.2756 5788934.226399999,4460428.8244 5788960.658999999,4460414.455199999 5788996.4605,4460405.9083 5789028.1094,4460394.699699999 5789092.550799999,4460387.2439 5789113.6641,4460365.859899999 5789153.0272,4460349.626 5789175.9691,4460332.193699999 5789195.9941,4460303.6238 5789216.6983,4460269.1643 5789233.933499999,4460253.4482 5789248.1029,4460234.869699999 5789271.642699999,4460194.747 5789313.494,4460187.2454 5789328.766,4460176.944899999 5789360.4406,4460156.8282 5789410.8999,4460137.1863 5789447.323499999,4460132.7005 5789473.098099999,4460129.4133 5789501.7785,4460115.501099999 5789521.7759,4460096.4144 5789554.100099999,4460068.586099999 5789593.516599999,4460053.631699999 5789629.891499999,4460042.325199999 5789681.459799999,4460030.788399999 5789778.052899999,4460025.069299999 5789795.6475,4460003.113199999 5789836.1742,4459963.2006 5789903.174599999,4459950.4083 5789916.141799999,4459912.437199999 5789933.408099999,4459878.0173 5789954.7408,4459769.144199999 5790049.7882,4459744.224999999 5790085.076799999,4459737.915099999 5790102.086799999,4459738.0864 5790123.1392,4459740.633899999 5790148.2672,4459737.8798 5790169.9331,4459729.244199999 5790189.888699999,4459694.4301 5790234.616599999,4459679.960199999 5790256.9567,4459666.128299999 5790286.3021,4459600.240399999 5790258.775499999,4459586.733599999 5790255.9593,4459558.0104 5790256.7838,4459536.9384 5790261.0511,4459518.8205 5790268.209899999,4459511.298499999 5790280.5565,4459510.827999999 5790294.002699999,4459476.517799999 5790328.2123,4459464.9342 5790345.844599999,4459455.127199999 5790365.220499999,4459448.2169 5790380.4888,4459447.020399999 5790449.502,4459443.5844 5790459.467299999,4459410.306699999 5790476.1204,4459405.911999999 5790512.4108,4459507.348199999 5790518.089099999,4459515.571999999 5790519.768799999,4459522.053 5790523.810799999,4459571.291699999 5790518.6565,4459582.438799999 5790520.323599999,4459624.0459 5790446.2956,4459639.5869 5790410.5043,4459700.8184 5790442.743,4459706.012299999 5790432.1849,4459764.298899999 5790462.7013,4459860.389 5790383.5588,4459931.3375 5790426.5599,4460213.5535 5790194.1486,4460228.0891 5790178.831199999,4460239.6664 5790160.021299999,4460278.363499999 5790087.7806,4460324.593 5790003.1948,4460376.591199999 5789906.868,4460418.180499999 5789829.3307,4460466.1423 5789741.216099999,4460496.763399999 5789684.2423,4460536.0623 5789611.9879,4460593.2679 5789506.252399999,4460642.3924 5789415.7824,4460671.8797 5789363.492399999,4460687.5246 5789339.3878,4460711.3464 5789311.713099999,4460729.388299999 5789295.189899999,4460840.454499999 5789176.734099999,4460920.7065 5789091.284199999,4461021.931699999 5788988.711799999,4461112.1073 5788896.744,4461171.238499999 5788835.2331,4461222.371299999 5788673.5917,4461279.035099999 5788495.305199999,4461323.6599 5788351.631599999,4461361.985299999 5788227.892699999,4461372.769199999 5788181.5842,4461375.184799999 5788115.4557,4461364.1024 5788048.2642,4461330.498399999 5787950.8144)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (29,29,44000149.0,'NULL','farm',4783.89857493,717403.398433, ST_GeomFromText('MULTIPOLYGON(((4461171.238499999 5788835.2331,4461112.1073 5788896.744,4461021.931699999 5788988.711799999,4460920.7065 5789091.284199999,4460840.454499999 5789176.734099999,4460729.388299999 5789295.189899999,4460711.3464 5789311.713099999,4460687.5246 5789339.3878,4460671.8797 5789363.492399999,4460642.3924 5789415.7824,4460593.2679 5789506.252399999,4460536.0623 5789611.9879,4460496.763399999 5789684.2423,4460466.1423 5789741.216099999,4460418.180499999 5789829.3307,4460376.591199999 5789906.868,4460324.593 5790003.1948,4460278.363499999 5790087.7806,4460239.6664 5790160.021299999,4460228.0891 5790178.831199999,4460213.5535 5790194.1486,4459931.3375 5790426.5599,4459918.86 5790436.887399999,4459930.582299999 5790436.2027,4459941.743599999 5790439.617499999,4459957.044999999 5790446.5152,4460403.328599999 5790664.631899999,4460412.592299999 5790669.1535,4460437.889399999 5790680.0566,4460453.737099999 5790682.856399999,4460473.0855 5790682.701799999,4460496.6151 5790676.705099999,4460529.3612 5790665.916799999,4460630.9649 5790632.324599999,4460732.685999999 5790597.019999999,4460750.3874 5790591.5381,4460747.647699999 5790413.282299999,4460746.014299999 5790207.443099999,4460749.1375 5790157.710699999,4460758.648299999 5790100.316299999,4460772.3249 5790050.500199999,4460830.6654 5789866.3969,4460895.9005 5789662.933299999,4460987.5948 5789393.7531,4461060.909599999 5789172.6576,4461124.4768 5788977.957,4461171.238499999 5788835.2331)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (30,30,44000294.0,'NULL','farm',7500.10682048,2039910.60373, ST_GeomFromText('MULTIPOLYGON(((4460397.5091 5787505.036299999,4460092.337899999 5787505.036299999,4460083.057599999 5787534.1796,4459963.481399999 5787908.446799999,4459887.9801 5788145.4221,4459796.492399999 5788435.752499999,4459755.0146 5788565.1268,4459726.1155 5788652.1917,4459663.4926 5788812.407099999,4459601.4423 5788970.2708,4459545.7181 5789111.692399999,4459489.9999 5789254.294199999,4459376.299499999 5789547.096599999,4459273.5157 5789811.714299999,4459268.928799999 5789824.6158,4459193.148599999 5790019.9987,4459150.634899999 5790126.2082,4459140.313699999 5790154.357699999,4459186.202399999 5790173.285599999,4459146.6222 5790278.8701,4459282.078499999 5790353.199599999,4459303.785299999 5790354.767999999,4459326.043999999 5790352.837899999,4459351.148199999 5790339.767799999,4459383.1195 5790306.1663,4459405.7642 5790279.6633,4459420.2395 5790257.3223,4459430.0322 5790236.1882,4459445.1747 5790224.368799999,4459463.388399999 5790228.8931,4459469.8841 5790234.693099999,4459490.469299999 5790242.7145,4459511.016099999 5790246.051599999,4459617.622899999 5790233.484799999,4459639.8392 5790226.281899999,4459651.4857 5790216.2498,4459661.9193 5790201.542799999,4459674.400299999 5790150.564899999,4459678.214599999 5790114.8581,4459685.541899999 5790078.544199999,4459701.7602 5790054.4317,4459787.824799999 5789967.1684,4459823.2861 5789929.457599999,4459844.276899999 5789915.833799999,4459871.6091 5789888.126399999,4459905.0553 5789818.251099999,4460023.7855 5789564.0449,4460086.08 5789436.618799999,4460103.9801 5789401.967299999,4460116.7411 5789384.905799999,4460126.3474 5789339.2046,4460132.541799999 5789307.562999999,4460138.280799999 5789292.316299999,4460157.5054 5789276.949799999,4460210.500099999 5789230.8997,4460226.747299999 5789209.715399999,4460231.8777 5789190.9461,4460249.2439 5789162.7313,4460314.754499999 5789068.6212,4460328.0437 5789043.944599999,4460341.187699999 5789001.1422,4460399.5716 5788895.383999999,4460409.2121 5788854.356899999,4460425.9741 5788823.799599999,4460450.3612 5788793.1926,4460470.059399999 5788763.201799999,4460483.900399999 5788733.8364,4460525.5504 5788661.5522,4460545.308299999 5788608.059499999,4460558.2708 5788572.959499999,4460559.334099999 5788558.9078,4460557.4687 5788546.0479,4460551.517699999 5788534.9788,4460551.387199999 5788518.599799999,4460578.516699999 5788463.9802,4460578.409599999 5788450.527699999,4460583.621399999 5788441.706399999,4460612.791699999 5788422.7574,4460639.6791 5788411.426899999,4460654.212 5788394.931399999,4460664.5409 5788366.184299999,4460682.757799999 5788296.424599999,4460687.2361 5788270.060799999,4460694.1347 5788252.457699999,4460724.3704 5788219.446499999,4460748.332399999 5788208.729699999,4460765.3375 5788207.4264,4460849.8013 5788134.216099999,4460930.2783 5788075.0708,4461037.4643 5788006.469499999,4461080.484899999 5787887.6545,4461049.060399999 5787873.491299999,4460653.456399999 5787648.179199999,4460397.5091 5787505.036299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (31,31,44000315.0,'NULL','farm',461.543903497,9817.64324799, ST_GeomFromText('MULTIPOLYGON(((4458664.039099999 5790831.9809,4458660.580599999 5790839.0314,4458658.296799999 5790846.0722,4458668.2209 5790911.476399999,4458671.9823 5790940.677799999,4458670.9806 5790960.571499999,4458667.311599999 5790980.832599999,4458661.8562 5790991.6388,4458717.7192 5790942.053999999,4458730.0931 5790932.8593,4458743.0169 5790923.248299999,4458750.347599999 5790917.8013,4458773.607599999 5790895.396199999,4458783.9335 5790874.812699999,4458772.2136 5790869.0906,4458664.039099999 5790831.9809)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (32,32,44000586.0,'NULL','farm',1096.75118794,62816.7291544, ST_GeomFromText('MULTIPOLYGON(((4458558.5793 5791079.901,4458622.0776 5791025.633099999,4458661.8562 5790991.6388,4458667.311599999 5790980.832599999,4458670.9806 5790960.571499999,4458671.9823 5790940.677799999,4458668.2209 5790911.476399999,4458658.296799999 5790846.0722,4458660.580599999 5790839.0314,4458664.039099999 5790831.9809,4458671.5925 5790823.7388,4458686.733199999 5790811.327199999,4458630.661799999 5790818.161,4458573.1282 5790825.731,4458494.093299999 5790838.088999999,4458455.4389 5790842.5086,4458439.6425 5790846.725199999,4458429.1353 5790852.076999999,4458420.9774 5790857.408999999,4458401.806699999 5790878.624099999,4458369.2504 5790910.4787,4458358.768 5790918.745899999,4458347.6786 5790924.6926,4458333.6644 5790931.242499999,4458271.426199999 5790954.935399999,4458438.260599999 5791030.935699999,4458558.5793 5791079.901)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (33,33,44848616.0,'NULL','farm',2746.25451819,179711.941748, ST_GeomFromText('MULTIPOLYGON(((4457871.3375 5791022.278999999,4457905.407899999 5791030.7576,4457984.1392 5791052.310399999,4457992.3578 5791053.408999999,4457999.9692 5791052.175899999,4458141.974299999 5791000.095499999,4458223.1188 5790972.6804,4458237.836 5790967.7155,4458223.621399999 5790957.7982,4458170.6971 5790938.3712,4458155.366899999 5790927.384199999,4458141.816599999 5790919.3199,4458137.6577 5790912.923299999,4458137.583499999 5790904.1552,4458139.856599999 5790895.9458,4458147.986299999 5790886.5185,4458157.910899999 5790881.7609,4458184.2564 5790878.0328,4458216.492999999 5790877.170499999,4458239.390399999 5790881.6508,4458253.449099999 5790880.3637,4458261.603699999 5790873.862999999,4458267.951999999 5790862.114099999,4458274.912299999 5790853.286699999,4458299.512699999 5790850.7423,4458312.4314 5790853.56,4458325.971699999 5790860.456499999,4458325.672 5790893.7868,4458318.2427 5790916.661499999,4458304.815799999 5790923.206499999,4458277.1873 5790914.081,4458265.589599999 5790929.379499999,4458255.127199999 5790939.994699999,4458247.360199999 5790964.0853,4458271.426199999 5790954.935399999,4458333.6644 5790931.242499999,4458347.6786 5790924.6926,4458358.768 5790918.745899999,4458369.2504 5790910.4787,4458401.806699999 5790878.624099999,4458420.9774 5790857.408999999,4458429.1353 5790852.076999999,4458439.6425 5790846.725199999,4458455.4389 5790842.5086,4458494.093299999 5790838.088999999,4458573.1282 5790825.731,4458639.2938 5790816.4085,4458559.2696 5790780.823999999,4458673.6194 5790785.130599999,4458650.8289 5790607.988299999,4458502.8459 5790630.915799999,4458494.098299999 5790636.842399999,4458492.392099999 5790642.698799999,4458492.4461 5790649.1302,4458494.299399999 5790660.81,4458462.7028 5790668.096899999,4458452.7284 5790667.012299999,4458442.739299999 5790664.1696,4458431.0048 5790662.509999999,4458417.5162 5790662.6234,4458402.313599999 5790666.8462,4458368.4335 5790681.163499999,4458353.204499999 5790683.0499,4458338.5382 5790682.005,4458326.2065 5790679.182299999,4458289.2686 5790678.3252,4458275.1846 5790676.685799999,4458221.699799999 5790660.7683,4458166.4395 5790642.5183,4458145.9132 5790641.5236,4458128.3365 5790642.8407,4458099.087799999 5790650.699899999,4458063.4384 5790663.276,4458050.025999999 5790671.5798,4458040.139 5790681.6008,4458029.782499999 5790703.911,4458008.164499999 5790781.8669,4458001.8316 5790795.374199999,4457992.5541 5790807.148399999,4457951.2284 5790841.995799999,4457941.371799999 5790855.533199999,4457932.1491 5790873.7277,4457920.787999999 5790915.932099999,4457906.395999999 5790947.0456,4457871.3375 5791022.278999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (34,34,44848937.0,'NULL','farm',3155.86679161,392595.64804, ST_GeomFromText('MULTIPOLYGON(((4457810.282499999 5791018.5598,4457820.232699999 5790879.944399999,4457906.683 5790843.543199999,4457927.6567 5790828.1641,4457942.7459 5790809.9085,4457960.660699999 5790779.3438,4457980.8239 5790737.6545,4457988.8227 5790713.6172,4457988.6687 5790695.491299999,4457978.087199999 5790692.075899999,4457936.5866 5790706.460899999,4457900.8782 5790712.0282,4457858.661199999 5790711.219299999,4457838.095099999 5790705.5413,4457899.588999999 5790698.585599999,4457945.2439 5790690.007099999,4457952.791199999 5790681.1742,4457955.626799999 5790670.0445,4457959.368599999 5790627.3264,4457959.551599999 5790580.5434,4457958.269299999 5790567.1008,4457954.099999999 5790559.5359,4457913.578999999 5790551.1006,4457897.752399999 5790551.825099999,4457862.142599999 5790569.0872,4457851.6155 5790572.103499999,4457842.813599999 5790571.5887,4457832.794099999 5790565.2422,4457821.032399999 5790561.2475,4457787.5909 5790558.027499999,4457770.561499999 5790554.6676,4457745.849999999 5790544.3517,4457731.755499999 5790541.545499999,4457713.596199999 5790543.4589,4457694.293999999 5790548.297599999,4457684.344299999 5790550.141,4457675.537499999 5790549.0479,4457655.5228 5790539.270899999,4457604.926199999 5790518.071799999,4457581.413999999 5790510.673,4457564.9697 5790507.887499999,4457542.6874 5790506.910299999,4457443.632799999 5790510.0983,4457427.2104 5790509.0712,4457413.702999999 5790506.2609,4457403.1105 5790501.6784,4457389.0157 5790498.873199999,4457367.263299999 5790492.038899999,4457342.6061 5790488.1565,4457320.921099999 5790488.343499999,4457276.965099999 5790490.4812,4457244.7379 5790491.928099999,4457227.166 5790493.838199999,4457211.3797 5790499.238199999,4457184.5164 5790511.165999999,4457175.797199999 5790519.4316,4457172.948099999 5790528.8037,4457172.1025 5790566.823699999,4457171.0037 5790575.601999999,4457173.4038 5790581.434499999,4457179.8815 5790584.8837,4457258.6282 5790607.014699999,4457308.5491 5790617.1105,4457306.877899999 5790627.6519,4457224.715499999 5790617.244999999,4457170.705 5790608.9436,4457134.946 5790608.663599999,4457118.522199999 5790608.227299999,4457105.0706 5790611.849199999,4457089.914599999 5790621.339199999,4457032.273199999 5790666.8629,4457023.6138 5790682.728599999,4457017.329199999 5790701.500299999,4457008.099499999 5790718.5394,4457000.241 5790758.9462,4457000.6019 5790800.4611,4457005.446299999 5790817.967599999,4457013.2136 5790835.437599999,4457029.354199999 5790870.9733,4457035.4945 5790896.1468,4457073.5804 5790894.069,4457083.549499999 5790894.5612,4457093.523699999 5790895.642999999,4457119.3842 5790903.0302,4457432.6831 5791002.0657,4457446.195899999 5791004.865,4457464.3717 5791005.877,4457658.4501 5791011.2333,4457810.282499999 5791018.5598)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (35,35,44849455.0,'NULL','farm',1716.58590548,143548.183099, ST_GeomFromText('MULTIPOLYGON(((4459827.4713 5791662.174499999,4459841.030799999 5791685.410399999,4459851.1166 5791700.5291,4459865.936099999 5791720.8728,4459884.887699999 5791744.6883,4459897.3249 5791760.956299999,4459908.551699999 5791771.970799999,4459915.603699999 5791774.2616,4459923.811099999 5791774.1951,4459976.4855 5791765.578299999,4459999.313 5791761.298599999,4460028.5465 5791752.883199999,4460044.956699999 5791752.1608,4460063.721099999 5791753.7674,4460077.805999999 5791755.990499999,4460111.876799999 5791765.652599999,4460138.324699999 5791774.208,4460155.3765 5791781.092199999,4460168.906999999 5791787.414999999,4460201.817099999 5791798.8342,4460228.866 5791809.1434,4460268.2543 5791824.6059,4460271.4193 5791821.631599999,4460274.8935 5791816.340299999,4460299.2224 5791780.480299999,4460308.464599999 5791770.669299999,4459945.835799999 5791278.8078,4459905.9407 5791309.3208,4459850.122399999 5791365.3125,4459836.230999999 5791387.0577,4459822.850999999 5791399.4515,4459810.688199999 5791417.0877,4459806.129999999 5791433.493799999,4459802.225599999 5791458.084499999,4459798.2093 5791468.0543,4459793.584599999 5791476.281999999,4459796.737499999 5791503.730799999,4459805.722699999 5791527.048399999,4459813.455199999 5791541.5963,4459831.1715 5791557.821399999,4459845.3283 5791568.811899999,4459856.503499999 5791573.405999999,4459870.044499999 5791580.896299999,4459884.840499999 5791598.313699999,4459896.714599999 5791617.5129,4459872.2427 5791634.659099999,4459851.7805 5791641.846899999,4459838.334699999 5791646.0511,4459831.3584 5791653.1183,4459827.4713 5791662.174499999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (36,36,44917284.0,'NULL','retail',390.76311969,8696.36523384, ST_GeomFromText('MULTIPOLYGON(((4460695.3682 5792397.109999999,4460700.265599999 5792388.7586,4460709.2039 5792375.979599999,4460725.7575 5792352.312799999,4460734.2796 5792342.13,4460754.1918 5792318.347599999,4460686.6697 5792267.473799999,4460638.644399999 5792330.327299999,4460655.592199999 5792343.345399999,4460645.446499999 5792357.1245,4460644.440299999 5792365.3782,4460641.1204 5792392.611999999,4460695.3682 5792397.109999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (37,37,47008233.0,'NULL','meadow',1051.32687484,29464.0882856, ST_GeomFromText('MULTIPOLYGON(((4458933.737999999 5790766.0052,4458867.238599999 5790805.149,4458853.2185 5790811.107799999,4458843.273699999 5790813.5273,4458847.1775 5790836.1622,4458855.5548 5790857.146299999,4458868.019 5790875.1698,4458870.771399999 5790877.628399999,4458913.334099999 5790850.378799999,4458918.802699999 5790873.134199999,4458888.4835 5790892.6818,4458973.3432 5790960.068099999,4459001.9769 5791000.024299999,4459036.3887 5791030.162599999,4459058.5087 5791046.5153,4459059.583999999 5791043.5909,4459101.213899999 5790986.172,4459107.0125 5790977.934,4459121.3645 5790958.4418,4459128.2971 5790946.0994,4459129.9653 5790935.5587,4459128.7105 5790925.042199999,4459123.3589 5790916.3177,4459080.360299999 5790890.9458,4459075.673399999 5790891.5744,4459092.7684 5790903.128299999,4459080.466199999 5790928.512399999,4459013.9593 5790895.7354,4459002.932 5790909.269099999,4458983.4197 5790889.5567,4458966.5623 5790835.8936,4458978.6188 5790804.8026,4458945.406 5790758.8867,4458933.737999999 5790766.0052)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (38,38,48822717.0,'NULL','farmland',818.431473318,29958.3938042, ST_GeomFromText('MULTIPOLYGON(((4448676.786299999 5794147.125399999,4448676.786299999 5794264.447899999,4448778.583999999 5794318.525699999,4448837.780799999 5794236.097799999,4448817.142799999 5794223.157999999,4448825.3936 5794207.2148,4448853.129499999 5794214.806399999,4448901.9692 5794140.4766,4448793.5234 5794064.158199999,4448736.8261 5794175.794399999,4448676.786299999 5794147.125399999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (39,39,48822729.0,'NULL','farmland',1179.13666255,23052.5292717, ST_GeomFromText('MULTIPOLYGON(((4448676.786299999 5793841.999199999,4448676.786299999 5793904.391599999,4448677.6308 5793905.3815,4448694.6654 5793923.477099999,4448716.9011 5793948.8078,4448742.8254 5793977.027,4448752.423 5793984.961999999,4448764.2251 5793992.874199999,4448782.004399999 5794012.420099999,4448807.182599999 5794039.1896,4448825.7598 5794065.293099999,4448831.706399999 5794073.989399999,4448875.948499999 5794102.7541,4448900.260099999 5794117.114,4448917.864699999 5794119.858599999,4448933.233799999 5794118.965299999,4448947.8727 5794118.0796,4448971.219899999 5794109.803899999,4448988.688799999 5794099.3967,4449000.347 5794093.434,4449017.8914 5794090.3374,4449039.1089 5794088.649599999,4449060.2664 5794081.1313,4449087.263899999 5794071.3496,4449106.998499999 5794067.4963,4449117.934899999 5794062.999099999,4449122.962799999 5794053.455,4449119.8392 5794034.491399999,4449112.4483 5794028.0018,4449091.938099999 5794027.478599999,4449068.567599999 5794033.561799999,4449039.394799999 5794045.547199999,4449016.822599999 5794058.1991,4448999.315899999 5794064.956499999,4448975.908099999 5794067.390399999,4448945.869599999 5794066.2429,4448919.450799999 5794060.673599999,4448892.9714 5794049.2517,4448858.3408 5794029.1564,4448829.5652 5794008.2773,4448810.394399999 5793996.0568,4448782.250199999 5793965.667999999,4448757.793499999 5793937.422299999,4448734.029 5793905.5305,4448726.5842 5793893.9232,4448715.3605 5793871.393699999,4448708.629999999 5793857.586699999,4448688.005199999 5793846.1051,4448676.786299999 5793841.999199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (40,40,48860500.0,'Hundisburg','residential',1263.13681918,44087.3163041, ST_GeomFromText('MULTIPOLYGON(((4458843.273699999 5790813.5273,4458841.685499999 5790763.8438,4458837.3716 5790738.730799999,4458830.7834 5790721.826899999,4458820.080699999 5790703.788799999,4458786.868599999 5790708.216099999,4458767.108799999 5790655.735099999,4458749.021599999 5790604.8538,4458737.347 5790588.2706,4458649.791799999 5790599.9516,4458650.8289 5790607.988299999,4458673.6194 5790785.130599999,4458559.2696 5790780.823999999,4458639.2938 5790816.4085,4458686.6063 5790811.6732,4458664.039099999 5790831.9809,4458772.2136 5790869.0906,4458865.7889 5790913.334499999,4458888.4835 5790892.6818,4458918.802699999 5790873.134199999,4458913.334099999 5790850.378799999,4458870.771399999 5790877.628399999,4458867.229899999 5790874.7313,4458854.7608 5790856.118,4458846.388399999 5790835.723699999,4458843.273699999 5790813.5273)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (41,41,48860501.0,'Hundisburg','residential',259.57572927,3960.47016051, ST_GeomFromText('MULTIPOLYGON(((4459064.37 5791493.014599999,4459063.7202 5791541.548399999,4459129.4056 5791560.289499999,4459150.0805 5791508.674799999,4459064.37 5791493.014599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (42,42,48920560.0,'Schlosspark','village_green',1757.49304157,120892.377638, ST_GeomFromText('MULTIPOLYGON(((4449401.0098 5792472.181199999,4449363.6687 5792502.2868,4449298.9176 5792546.0609,4449240.867899999 5792576.735999999,4449190.6705 5792497.106699999,4449241.1188 5792478.1491,4449268.467 5792465.716399999,4449267.031499999 5792409.6675,4449248.474399999 5792341.976299999,4449230.6911 5792322.4286,4449207.9829 5792322.6619,4449164.0646 5792326.039999999,4449107.014999999 5792334.661399999,4449057.254499999 5792411.1793,4448969.5284 5792426.494999999,4448974.1365 5792443.6182,4448974.3161 5792447.1217,4448975.612499999 5792472.8366,4448976.900999999 5792479.9231,4448983.6901 5792517.176899999,4448997.0684 5792564.3892,4449013.835699999 5792599.292199999,4449037.756 5792645.227499999,4449058.074799999 5792683.5994,4449064.161199999 5792705.7485,4449065.453999999 5792713.936599999,4449066.2126 5792721.952199999,4449074.2971 5792721.345899999,4449153.3733 5792711.2399,4449200.9619 5792708.558399999,4449260.714999999 5792702.992699999,4449394.4389 5792694.7224,4449462.3935 5792629.1501,4449481.087399999 5792613.068099999,4449459.528099999 5792575.2747,4449458.575799999 5792542.233799999,4449401.0098 5792472.181199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (43,43,48920561.0,'NULL','residential',3272.46686005,294025.016271, ST_GeomFromText('MULTIPOLYGON(((4449401.0098 5792472.181199999,4449458.575799999 5792542.233799999,4449530.6091 5792494.003,4449504.8053 5792229.8395,4449525.6638 5792227.6346,4449509.685499999 5792095.239299999,4449482.504499999 5792088.2058,4449474.0486 5791984.411,4449513.8996 5791959.5665,4449354.553199999 5791969.664599999,4449248.990699999 5792035.0566,4449216.0333 5792036.129399999,4449212.653699999 5791992.3081,4449142.9215 5791985.8583,4449136.023599999 5792021.6061,4449081.8847 5792028.7401,4448986.0168 5792039.220599999,4449004.095999999 5792087.274599999,4448756.348199999 5792194.4743,4448782.582399999 5792204.317999999,4448793.029099999 5792292.6008,4448817.966199999 5792295.2693,4448818.1478 5792312.8054,4448827.880099999 5792404.0447,4448852.748499999 5792400.137299999,4448865.0833 5792459.2004,4448900.1758 5792452.2608,4448921.350999999 5792587.2159,4448997.0684 5792564.3892,4448983.6901 5792517.176899999,4448976.900999999 5792479.9231,4448975.612499999 5792472.8366,4448974.3161 5792447.1217,4448969.5284 5792426.494999999,4449057.254499999 5792411.1793,4449107.014999999 5792334.661399999,4449164.0646 5792326.039999999,4449207.9829 5792322.6619,4449230.6911 5792322.4286,4449248.474399999 5792341.976299999,4449267.031499999 5792409.6675,4449268.467 5792465.716399999,4449241.1188 5792478.1491,4449190.6705 5792497.106699999,4449240.867899999 5792576.735999999,4449298.9176 5792546.0609,4449363.6687 5792502.2868,4449401.0098 5792472.181199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (44,44,48920567.0,'NULL','farmland',7639.03900491,1494506.12303, ST_GeomFromText('MULTIPOLYGON(((4450258.706799999 5793585.014299999,4450253.338499999 5793570.501599999,4450259.978 5793480.029799999,4450256.8885 5793437.595899999,4450240.9292 5793413.997999999,4450217.268099999 5793392.313799999,4450179.0239 5793376.6302,4450261.3218 5793257.442399999,4450297.3859 5793201.5503,4450380.1884 5793132.046599999,4450474.8245 5793074.1103,4450418.560899999 5793014.7606,4450259.143099999 5792895.076799999,4450150.0645 5792828.9506,4450000.0707 5792773.478399999,4449898.8216 5792756.9656,4449825.5168 5792751.8669,4449343.0162 5792736.356499999,4449345.5584 5792951.1151,4449302.5607 5793186.8164,4449193.413999999 5793256.876199999,4449109.671799999 5793281.084599999,4449115.111999999 5793558.153599999,4449135.274299999 5793768.0906,4449144.540199999 5793864.532199999,4449148.6058 5793918.662399999,4449157.831199999 5793927.6258,4449168.353299999 5793953.824599999,4449184.901499999 5793966.641,4449208.6633 5793977.335699999,4449268.45 5794002.460999999,4449319.8786 5794018.013499999,4449366.769799999 5794020.4483,4449453.2208 5794023.947699999,4449491.4176 5794035.241699999,4449566.320299999 5794054.930199999,4449562.0382 5794209.833599999,4449603.1017 5794215.267999999,4449623.722699999 5794226.7423,4449700.3798 5794275.626299999,4449757.8677 5794311.563999999,4449829.6228 5794310.834899999,4450057.9702 5794298.2946,4450057.866799999 5794288.0689,4450054.245 5794219.4448,4450000.0773 5794221.4504,4449994.5142 5794106.096599999,4450054.5459 5794104.0316,4450072.3464 5793691.8431,4450070.133 5793617.351399999,4450250.459599999 5793633.070699999,4450289.0689 5793685.2738,4450267.317999999 5793707.414999999,4450260.229399999 5793730.855499999,4450300.937199999 5793845.8781,4450320.296299999 5793877.821499999,4450363.0343 5793903.687799999,4450430.722199999 5793935.1464,4450469.063799999 5793961.0688,4450486.9314 5793990.101099999,4450493.087 5794019.2619,4450493.3651 5794047.0238,4450489.189299999 5794068.976999999,4450461.568599999 5794089.707399999,4450451.3704 5794086.2375,4450433.831 5794098.754499999,4450441.256799999 5794108.906799999,4450452.814 5794110.4044,4450524.8503 5794119.753599999,4450575.1791 5794173.2992,4450652.1923 5794258.728,4450698.4216 5794341.5383,4450738.8376 5794428.7804,4450745.013399999 5794460.856899999,4450753.956699999 5794476.836699999,4450769.9002 5794486.414899999,4450804.636099999 5794455.154999999,4450785.869599999 5794445.8496,4450776.8536 5794422.5592,4450767.626899999 5794378.8285,4450767.117399999 5794327.699799999,4450782.8667 5794291.0204,4450770.6829 5794244.3925,4450763.010599999 5794209.4153,4450736.3179 5794176.0745,4450693.423799999 5794134.137499999,4450669.6583 5794100.767799999,4450650.2664 5794065.9078,4450632.3124 5794028.095699999,4450599.630599999 5793981.6731,4450553.9225 5793951.449999999,4450513.938299999 5793908.016499999,4450493.069299999 5793871.702999999,4450476.4346 5793819.2781,4450440.932099999 5793784.569299999,4450409.736899999 5793741.048599999,4450360.656999999 5793667.0273,4450307.3857 5793613.502199999,4450258.706799999 5793585.014299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (45,45,48920572.0,'NULL','meadow',1517.18687646,71507.4397278, ST_GeomFromText('MULTIPOLYGON(((4449781.957399999 5795024.189999999,4449809.748599999 5795021.715199999,4449831.6401 5795014.1928,4449875.171799999 5794975.0359,4449909.1002 5794944.456499999,4449882.7093 5794934.330499999,4449442.502299999 5794765.4502,4449429.3474 5794767.7771,4449391.8338 5794751.357699999,4449345.514999999 5794732.847799999,4449291.128899999 5794713.686599999,4449297.067699999 5794864.0788,4449521.352199999 5794886.619899999,4449521.162999999 5794935.5525,4449675.0097 5794987.8432,4449781.957399999 5795024.189999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (46,46,48920573.0,'NULL','meadow',2363.34340171,101494.4793, ST_GeomFromText('MULTIPOLYGON(((4449801.882199999 5795040.0565,4449798.9258 5795040.5873,4449780.6907 5795043.922,4449754.278099999 5795038.3483,4449729.2811 5795028.3758,4449688.7613 5795003.9502,4449674.7658 5794996.058299999,4449675.0097 5794987.8432,4449521.1457 5794939.2027,4449520.7438 5795041.4526,4449632.278699999 5795065.875499999,4449599.207399999 5795125.3703,4449571.648599999 5795151.213099999,4449540.335599999 5795167.6019,4449516.195799999 5795170.040899999,4449517.006199999 5795105.7673,4449309.0602 5795104.9702,4449309.985199999 5795123.945399999,4449299.0366 5795131.6917,4449282.2629 5795133.7335,4449212.837 5795146.1314,4449146.188299999 5795143.890399999,4449119.2542 5795144.690799999,4449119.8502 5795217.1182,4449257.442999999 5795212.130599999,4449331.7197 5795228.961799999,4449513.232499999 5795237.9865,4449552.0679 5795241.2398,4449599.580099999 5795233.4546,4449888.788999999 5795090.2969,4449928.3864 5794951.8615,4449909.1002 5794944.456499999,4449875.171799999 5794975.0359,4449831.6401 5795014.1928,4449825.896599999 5795025.201199999,4449801.882199999 5795040.0565)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (47,47,48920868.0,'NULL','farm',2427.19496374,186252.829044, ST_GeomFromText('MULTIPOLYGON(((4450217.320199999 5792233.485899999,4450114.7992 5792237.4348,4450074.457899999 5792305.066999999,4449920.3738 5792426.4754,4449800.9889 5792500.753499999,4449643.1917 5792543.276499999,4449606.081899999 5792542.5752,4449567.282499999 5792570.3573,4449515.212799999 5792581.6608,4449516.8843 5792601.5854,4449593.9877 5792594.6113,4450152.046199999 5792548.1346,4450520.5723 5792517.469,4450519.217 5792386.8274,4450525.8847 5792320.993499999,4450541.4489 5792265.308599999,4450217.320199999 5792233.485899999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (48,48,48920871.0,'NULL','farm',6946.48559194,2436515.44557, ST_GeomFromText('MULTIPOLYGON(((4448676.786299999 5790855.016,4448676.786299999 5791012.8131,4448809.3282 5791293.2345,4449087.5963 5792019.7342,4449136.023599999 5792021.6061,4449142.9215 5791985.8583,4449212.653699999 5791992.3081,4449216.0333 5792036.129399999,4449248.990699999 5792035.0566,4449354.553199999 5791969.664599999,4449513.8996 5791959.5665,4449474.0486 5791984.411,4449482.504499999 5792088.2058,4449509.685499999 5792095.239299999,4449525.6638 5792227.6346,4449504.8053 5792229.8395,4449530.6091 5792494.003,4449561.716099999 5792477.160199999,4449606.081899999 5792542.5752,4449643.1917 5792543.276499999,4449800.9889 5792500.753499999,4449920.3738 5792426.4754,4450074.457899999 5792305.066999999,4450114.7992 5792237.4348,4450257.722699999 5792171.685399999,4450216.1391 5792050.406899999,4450302.8457 5791995.8526,4450331.7626 5791957.559599999,4450211.3015 5791667.615299999,4450281.825299999 5791654.0416,4450350.712899999 5791510.108599999,4450458.617999999 5791164.044399999,4450402.4062 5791111.9831,4450202.264899999 5791029.2092,4450163.1041 5790924.3541,4450199.704099999 5790774.869,4450172.709699999 5790713.735999999,4449980.954099999 5790592.8728,4449904.4046 5790546.375299999,4449840.581299999 5790491.336999999,4449779.174899999 5790352.2134,4449684.275799999 5790244.990199999,4449384.2092 5790429.339199999,4449004.967299999 5790608.680199999,4448885.763 5790703.4758,4448836.6056 5790768.315799999,4448766.8359 5790824.5897,4448676.786299999 5790855.016)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (49,49,48920872.0,'NULL','farm',2935.53089551,513737.411678, ST_GeomFromText('MULTIPOLYGON(((4449687.897199999 5789770.128599999,4449687.110199999 5789946.6839,4449737.742399999 5790025.123099999,4449750.3914 5790115.6552,4449751.0743 5790182.8953,4449780.917899999 5790235.228199999,4449835.2242 5790386.742699999,4449892.5289 5790453.587099999,4450074.816399999 5790308.291799999,4450597.9933 5790009.6149,4450537.1073 5789926.4177,4450522.0684 5789888.5546,4450521.688199999 5789850.5338,4450538.6347 5789786.033099999,4450573.229899999 5789727.1983,4450569.978099999 5789695.059499999,4450543.121899999 5789648.534399999,4450469.6617 5789631.7202,4450337.5327 5789612.580099999,4450266.730299999 5789569.4132,4450224.9221 5789565.6717,4450178.6895 5789561.529899999,4450099.5651 5789565.2539,4450073.8485 5789578.010099999,4450065.2785 5789617.011499999,4449977.590099999 5789642.590399999,4449969.1193 5789634.5525,4449942.264899999 5789644.8505,4449935.381799999 5789635.060699999,4449890.948499999 5789656.7651,4449857.3354 5789666.842599999,4449796.095999999 5789708.704299999,4449739.7794 5789759.5972,4449687.897199999 5789770.128599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (50,50,48920878.0,'NULL','farmland',16094.8376152,5152546.99925, ST_GeomFromText('MULTIPOLYGON(((4450935.755699999 5789992.4995,4450748.554499999 5789992.3231,4450675.916 5790024.4612,4450597.9933 5790009.6149,4450400.016499999 5790142.706599999,4450074.816399999 5790308.291799999,4449892.5289 5790453.587099999,4449918.479 5790502.855399999,4449963.012299999 5790557.956299999,4450024.888299999 5790589.5021,4450110.0334 5790603.2649,4450142.5422 5790629.244,4450223.1502 5790774.632999999,4450206.6823 5790885.901599999,4450257.1567 5790949.714099999,4450343.2048 5791054.110099999,4450431.511699999 5791091.2267,4450475.529699999 5791096.6391,4450534.173399999 5791098.9678,4450454.4866 5791336.582299999,4450411.760599999 5791459.7979,4450350.712899999 5791510.108599999,4450281.825299999 5791654.0416,4450392.709699999 5791898.480699999,4450431.301599999 5791947.791799999,4450698.2865 5791972.241599999,4450706.3848 5791908.496999999,4450781.020899999 5791457.5668,4450781.4127 5791349.3979,4451097.9159 5791251.135399999,4451225.6971 5791367.408099999,4451241.549899999 5791364.8036,4451241.7821 5791357.879699999,4451248.309999999 5791302.353099999,4451422.153199999 5791357.0394,4451583.254999999 5791418.6335,4451746.2785 5791305.948799999,4451754.6748 5791264.937899999,4452152.0438 5791388.281999999,4452383.3908 5791245.2127,4452841.944299999 5791169.6442,4452850.365399999 5791163.9331,4453333.8688 5790835.8121,4453866.4412 5790464.8396,4454101.515599999 5790303.5899,4454245.922299999 5790155.507999999,4454312.132299999 5790084.1892,4454402.590699999 5789984.972599999,4454356.359 5789948.921499999,4454280.9061 5790033.789899999,4454213.334099999 5789957.9659,4454180.5718 5789902.707399999,4454163.2646 5789877.273399999,4454165.296799999 5789835.5916,4454176.3957 5789768.231599999,4454223.4121 5789779.4918,4454237.956299999 5789767.6618,4454245.7811 5789662.3081,4454221.87 5789612.809599999,4454174.6354 5789578.160499999,4454121.7015 5789561.102199999,4454074.771099999 5789558.610999999,4454001.532999999 5789565.1445,4453969.445899999 5789582.980599999,4453943.6626 5789647.5622,4453941.467 5789726.546599999,4453930.718299999 5789831.916999999,4453842.9413 5789850.2839,4453818.992999999 5789797.872099999,4453806.643199999 5789730.7301,4453736.365799999 5789740.1555,4453739.0229 5789710.886399999,4453831.7695 5789595.969799999,4453923.8392 5789516.481599999,4453949.605499999 5789474.979399999,4453857.813799999 5789459.1314,4453640.8371 5789499.261499999,4453434.868999999 5789479.774199999,4453426.2697 5789500.3306,4453344.846199999 5789571.292799999,4453274.815799999 5789607.0401,4453120.936599999 5789766.423699999,4453096.6266 5789675.9945,4453113.496199999 5789599.797199999,4452966.585699999 5789466.186899999,4452840.602699999 5789475.420299999,4452765.9588 5789488.5622,4452711.112499999 5789501.516,4452578.579599999 5789528.6347,4452523.1716 5789537.077999999,4452487.111999999 5789555.495999999,4452460.074199999 5789641.118499999,4452456.928 5789715.405799999,4452481.9149 5789778.3617,4452505.9899 5789842.472599999,4452603.2329 5789894.175499999,4452616.7648 5789777.068399999,4452780.5146 5789731.636499999,4452787.380099999 5789836.8528,4452653.2593 5789914.1609,4452647.7903 5789955.1531,4452726.6863 5789928.0809,4452849.7828 5789923.9907,4452879.3442 5789950.026799999,4452727.4966 5790012.879599999,4452736.9089 5790077.1206,4452722.3903 5790091.8815,4452649.469399999 5790130.5921,4452576.409699999 5790154.694,4452512.372499999 5790202.090399999,4452427.417999999 5790208.759899999,4452385.6776 5790136.050499999,4452347.3073 5790114.063799999,4451798.307 5790089.291999999,4451790.411299999 5790078.886399999,4451784.025999999 5790022.307,4451370.151399999 5790006.8725,4451326.257899999 5790005.2454,4451323.710799999 5790061.5895,4451362.249699999 5790105.066099999,4451214.375799999 5790116.2034,4451249.1584 5790344.096799999,4451185.814199999 5790116.852399999,4451149.0009 5790034.501,4451098.952999999 5790026.0151,4451086.8557 5790007.450699999,4450935.755699999 5789992.4995)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (51,51,48978298.0,'NULL','farmyard',1423.79952127,103078.548067, ST_GeomFromText('MULTIPOLYGON(((4454617.4922 5795659.877199999,4454653.5327 5795518.609699999,4454646.0574 5795501.886199999,4454603.1479 5795453.3506,4454546.378999999 5795410.061699999,4454477.3048 5795382.2102,4454492.9401 5795252.0796,4454354.3799 5795231.4472,4454346.713 5795273.148,4454326.2022 5795271.879799999,4454315.7697 5795410.720599999,4454289.472299999 5795654.144799999,4454462.071499999 5795635.746899999,4454617.4922 5795659.877199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (52,52,48979541.0,'NULL','farm',9182.21893612,3903070.50086, ST_GeomFromText('MULTIPOLYGON(((4460092.2943 5787505.036299999,4458566.661899999 5787505.036299999,4457830.760499999 5787980.7475,4457722.427899999 5788002.1466,4457690.6176 5788055.075099999,4457670.265399999 5788075.7243,4457617.5854 5788087.8703,4457597.584499999 5788149.478199999,4457559.5877 5788164.425699999,4457530.4356 5788185.162,4457479.498499999 5788408.789699999,4457451.019199999 5788498.835899999,4457454.8304 5788601.178999999,4457505.358599999 5788679.7189,4457626.2514 5788757.6565,4457673.187199999 5788760.1815,4457772.678 5788735.9298,4457860.495099999 5788717.632799999,4457986.629499999 5788722.413699999,4458156.817699999 5788735.5938,4458297.461099999 5788746.491499999,4458326.9981 5788748.779799999,4458349.5163 5788761.4428,4458356.593299999 5788780.7123,4458360.0164 5788839.171099999,4458298.5185 5788848.4688,4458232.065299999 5788966.026799999,4458209.203599999 5789036.413899999,4458221.427799999 5789094.798399999,4458198.641099999 5789173.9648,4458155.004499999 5789215.2728,4458079.172899999 5789262.707,4458079.5941 5789312.422499999,4458109.236999999 5789350.1951,4458174.4501 5789434.459599999,4458239.3223 5789477.777499999,4458324.411999999 5789485.8287,4458377.5038 5789523.4055,4458418.8409 5789558.154999999,4458504.765999999 5789525.0852,4458518.813799999 5789522.040799999,4458533.463899999 5789520.7496,4458551.6566 5789522.3442,4458618.615899999 5789536.4056,4458629.194699999 5789539.243799999,4458636.857499999 5789543.864499999,4458643.9572 5789551.4055,4458660.0607 5789583.441299999,4458701.629599999 5789646.255499999,4458713.571999999 5789659.442399999,4458725.853699999 5789668.286699999,4458738.192499999 5789671.689099999,4458743.124499999 5789700.3131,4458753.927 5789730.045499999,4458772.986999999 5789766.1521,4458800.9472 5789814.458599999,4458864.6835 5789934.4089,4458889.770899999 5790020.307199999,4458897.281499999 5790047.007099999,4458927.1856 5790046.758799999,4459150.634899999 5790126.2082,4459193.148599999 5790019.9987,4459264.072399999 5789837.1412,4459273.5157 5789811.714299999,4459376.299499999 5789547.096599999,4459489.9999 5789254.294199999,4459545.7181 5789111.692399999,4459601.4423 5788970.2708,4459663.4926 5788812.407099999,4459726.1155 5788652.1917,4459755.0146 5788565.1268,4459796.492399999 5788435.752499999,4459887.9801 5788145.4221,4459963.481399999 5787908.446799999,4460083.057599999 5787534.1796,4460092.2943 5787505.036299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (53,53,48980786.0,'NULL','meadow',1387.4328867,95561.6407782, ST_GeomFromText('MULTIPOLYGON(((4451381.821399999 5791797.717599999,4451427.210699999 5791645.262099999,4451481.254599999 5791478.099999999,4451413.769999999 5791469.993699999,4451422.153199999 5791357.0394,4451248.309999999 5791302.353099999,4451241.7821 5791357.879699999,4451241.549899999 5791364.8036,4451225.8288 5791574.6337,4451192.143299999 5791798.3844,4451381.821399999 5791797.717599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (54,54,48980787.0,'NULL','farm',3575.9223443,593452.406889, ST_GeomFromText('MULTIPOLYGON(((4451344.6463 5789563.9382,4451287.4768 5789676.370799999,4451341.982099999 5789684.158299999,4451339.4829 5789728.049499999,4451287.0932 5789721.365199999,4451286.0103 5789744.611199999,4451317.6878 5789747.2817,4451316.449199999 5789770.6851,4451284.7126 5789772.399599999,4451279.462199999 5789885.1004,4451326.600599999 5789892.170099999,4451370.4543 5789895.9008,4451370.151399999 5790006.8725,4451784.025999999 5790022.307,4451790.411299999 5790078.886399999,4451798.307 5790089.291999999,4452347.3073 5790114.063799999,4452417.7356 5790116.835599999,4452470.923299999 5789854.504799999,4452417.648699999 5789802.3703,4452389.4193 5789763.1709,4452393.466799999 5789726.5765,4452434.992399999 5789623.821799999,4452454.535799999 5789575.227199999,4452408.704199999 5789555.693099999,4452367.7094 5789539.7182,4452314.912499999 5789545.412399999,4452053.9127 5789550.338099999,4451832.2691 5789526.9297,4451567.0081 5789506.350299999,4451367.712399999 5789487.6291,4451365.3667 5789511.7221,4451344.6463 5789563.9382)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (55,55,48980792.0,'NULL','farm',1985.48569021,129190.359356, ST_GeomFromText('MULTIPOLYGON(((4448676.786299999 5788969.3145,4448676.786299999 5789769.913399999,4448720.411799999 5789780.8286,4448823.3157 5789809.007899999,4448873.184299999 5789811.407899999,4448875.178299999 5789720.7376,4448880.7372 5789691.424399999,4448900.7445 5789641.5084,4448931.998599999 5789544.671599999,4448931.5459 5789500.8092,4448842.171099999 5789364.266799999,4448764.7033 5789245.162699999,4448752.3441 5789183.8635,4448745.597299999 5789099.1148,4448742.6511 5788955.8264,4448676.786299999 5788969.3145)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (56,56,48980797.0,'NULL','farm',3298.87047171,532230.815368, ST_GeomFromText('MULTIPOLYGON(((4448676.786299999 5789792.947399999,4448676.786299999 5790797.3131,4448742.3134 5790759.808599999,4448794.648599999 5790718.3372,4448852.4818 5790641.7115,4448904.517099999 5790570.9997,4449023.9057 5790493.740599999,4449137.7684 5790448.7126,4449318.8435 5790382.5225,4449391.8481 5790355.4572,4449455.830799999 5790305.0938,4449499.200299999 5790246.1727,4449527.9791 5790193.243,4449445.273099999 5789846.0894,4449409.562699999 5789793.818399999,4449347.935399999 5789788.595499999,4449268.964999999 5789806.9536,4449123.5361 5789919.5722,4449076.358199999 5789893.739499999,4448964.870799999 5789886.1192,4448894.2482 5789860.5302,4448800.318799999 5789849.794399999,4448732.588299999 5789821.262199999,4448676.786299999 5789792.947399999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (57,57,48980806.0,'NULL','farm',4618.13697112,800006.949273, ST_GeomFromText('MULTIPOLYGON(((4449158.2986 5789739.754,4449155.5032 5789752.9362,4449190.698099999 5789754.0435,4449232.9456 5789728.7497,4449288.271399999 5789691.626499999,4449317.590499999 5789691.326199999,4449371.822599999 5789690.770999999,4449410.0678 5789703.533199999,4449455.5979 5789711.847999999,4449487.8474 5789711.518699999,4449556.3661 5789674.2639,4449595.655799999 5789646.0767,4449658.980499999 5789529.911299999,4449682.0608 5789493.120799999,4449721.597199999 5789488.334499999,4449784.4455 5789470.147299999,4449813.513799999 5789444.9923,4449830.348699999 5789370.2412,4449844.801699999 5789349.619,4450065.502199999 5789283.0446,4450124.064699999 5789275.142899999,4450231.9435 5789360.332699999,4450359.1063 5789468.733699999,4450404.8272 5789496.062,4450475.263399999 5789502.6677,4450557.597299999 5789526.704399999,4450603.287399999 5789551.1082,4450615.288599999 5789554.9611,4450656.234 5789568.117799999,4450732.3262 5789554.206199999,4450740.564899999 5789498.550699999,4450806.3541 5789480.3473,4450820.155799999 5789230.886299999,4450608.0783 5789169.991399999,4450074.9905 5789012.6147,4449393.6813 5788902.733899999,4449374.828599999 5788981.491,4449344.6271 5789038.842599999,4449291.5564 5789153.448999999,4449259.130599999 5789279.5512,4449235.783599999 5789433.3361,4449206.2317 5789553.5447,4449158.2986 5789739.754)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (58,58,48980928.0,'NULL','farm',2318.68491735,311747.622726, ST_GeomFromText('MULTIPOLYGON(((4460042.5859 5791020.1388,4460403.328599999 5790664.631899999,4459957.044999999 5790446.5152,4459941.743599999 5790439.617499999,4459930.582299999 5790436.2027,4459918.86 5790436.887399999,4459755.290599999 5790572.7949,4459734.8162 5790589.909099999,4459769.2289 5790636.332399999,4459628.418899999 5790766.128,4459556.8453 5790831.0314,4459565.7686 5790851.500299999,4459577.6286 5790867.783399999,4459589.730399999 5790880.2367,4459613.6929 5790904.911599999,4459627.9937 5790919.0272,4459678.489699999 5790968.8684,4459799.871399999 5791088.672299999,4459828.258999999 5791119.432499999,4459864.9949 5791168.2411,4460042.5859 5791020.1388)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (59,59,49204100.0,'NULL','farm',2569.17217051,230979.204345, ST_GeomFromText('MULTIPOLYGON(((4449814.3432 5796791.006999999,4449939.667399999 5796879.5392,4449963.2615 5796896.092499999,4449971.4435 5796909.140799999,4449976.014499999 5796927.3559,4449979.862399999 5796945.567099999,4449994.663099999 5796961.475199999,4450015.2274 5796968.566999999,4450101.7 5796979.3768,4450178.5537 5796980.058399999,4450213.600999999 5796971.670199999,4450272.795099999 5796963.0501,4450327.544499999 5796948.622099999,4450365.569899999 5796945.323999999,4450420.473799999 5796946.2301,4450501.006 5796949.072,4450531.6978 5796944.379799999,4450549.262099999 5796944.2038,4450591.797399999 5796952.5469,4450615.235899999 5796954.493499999,4450621.671799999 5796939.105599999,4450624.349799999 5796914.2518,4450626.246799999 5796884.2981,4450621.496299999 5796848.5796,4450612.9433 5796798.2879,4450583.138899999 5796672.2813,4450578.387799999 5796636.551699999,4450581.797299999 5796608.452299999,4450592.5081 5796584.5754,4450609.817999999 5796558.8519,4450638.177099999 5796540.3069,4450662.1726 5796524.743599999,4450675.935999999 5796509.994699999,4450685.934299999 5796485.078999999,4450535.817099999 5796478.546199999,4450440.303199999 5796662.0285,4450322.5788 5796673.4385,4450231.155199999 5796680.2016,4450212.1085 5796678.924699999,4450196.717699999 5796676.8877,4450179.034099999 5796664.658099999,4450162.8255 5796654.6061,4450134.2696 5796653.425499999,4449953.4632 5796651.605,4449927.171099999 5796657.713899999,4449919.1292 5796658.529899999,4449914.8102 5796665.8738,4449913.8573 5796787.804099999,4449829.2071 5796741.212999999,4449814.3432 5796791.006999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (60,60,49210436.0,'NULL','meadow',1910.05480675,148910.748611, ST_GeomFromText('MULTIPOLYGON(((4448676.786299999 5795757.9287,4448676.786299999 5796265.6367,4448710.5809 5796234.086899999,4448738.0762 5796203.131999999,4448761.1934 5796173.6804,4448785.6566 5796132.5415,4448799.7066 5796075.4415,4448824.2395 5796041.602199999,4448981.529199999 5795819.446499999,4449075.5169 5795704.5569,4449085.162299999 5795504.372099999,4448970.9342 5795502.624299999,4448946.2466 5795521.864099999,4448891.246199999 5795583.782899999,4448772.446499999 5795706.2335,4448695.2975 5795749.388399999,4448676.786299999 5795757.9287)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (61,61,49210437.0,'NULL','meadow',572.898609244,18733.2376354, ST_GeomFromText('MULTIPOLYGON(((4449138.109899999 5795668.857899999,4449325.319699999 5795649.4065,4449324.720399999 5795591.0007,4449248.2297 5795556.7323,4449142.5804 5795534.449799999,4449138.109899999 5795668.857899999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (62,62,49260402.0,'NULL','meadow',2208.52731668,120956.39121, ST_GeomFromText('MULTIPOLYGON(((4451864.306099999 5797124.345599999,4451850.8399 5797169.735099999,4451936.0722 5797203.947,4451965.3025 5797235.5668,4452077.033699999 5797362.5434,4452129.629099999 5797391.132999999,4452193.679999999 5797430.662599999,4452234.953399999 5797460.197599999,4452253.302099999 5797465.8624,4452278.239099999 5797471.452299999,4452264.417299999 5797480.355,4452260.1732 5797495.719499999,4452264.245199999 5797538.0226,4452257.925099999 5797565.815099999,4452247.871799999 5797585.6203,4452229.0411 5797605.5216,4452201.411999999 5797624.0281,4452183.899799999 5797629.3167,4452178.813199999 5797633.016,4452181.122399999 5797644.666999999,4452186.3645 5797657.0241,4452193.0025 5797662.8021,4452234.791699999 5797670.4208,4452250.865899999 5797668.0842,4452277.8216 5797655.415599999,4452311.4011 5797647.0565,4452340.6802 5797648.231399999,4452378.246299999 5797673.418999999,4452424.490699999 5797688.296399999,4452488.240299999 5797697.174599999,4452520.4658 5797699.7912,4452489.850899999 5797673.8902,4452470.6583 5797625.100099999,4452450.4763 5797574.9063,4452441.3261 5797536.3131,4452441.830799999 5797512.9503,4452490.8821 5797439.477299999,4452093.1434 5797175.412,4452063.479299999 5797210.742499999,4451864.306099999 5797124.345599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (63,63,49263093.0,'NULL','quarry',5362.34704345,1322733.77444, ST_GeomFromText('MULTIPOLYGON(((4454345.3003 5791803.296099999,4454205.8114 5791930.287599999,4454116.9522 5792144.490399999,4454083.472699999 5792326.0315,4454105.555999999 5792495.350199999,4454044.219499999 5792516.373299999,4454033.157999999 5792613.2451,4454177.8393 5792722.6809,4454263.9334 5792792.023299999,4454367.779099999 5792909.020099999,4454530.162999999 5792814.649499999,4454597.446399999 5792747.7639,4454698.292399999 5792739.382899999,4454960.0547 5793016.480799999,4454994.6922 5792712.4943,4455018.8546 5792341.079099999,4455051.944199999 5791919.8746,4455061.9621 5791861.317399999,4455084.898299999 5791805.569399999,4455135.6491 5791714.493799999,4455220.9013 5791614.3263,4455160.3174 5791515.2135,4455209.158699999 5791406.5963,4454921.0853 5791312.745799999,4454914.046699999 5791184.171,4454837.9822 5791199.487199999,4454691.774299999 5791235.9109,4454618.506799999 5791236.582699999,4454539.379999999 5791237.309499999,4454485.8523 5791186.323899999,4454409.8174 5791489.916099999,4454345.3003 5791803.296099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (64,64,49263096.0,'NULL','quarry',4089.24460927,548068.669012, ST_GeomFromText('MULTIPOLYGON(((4452177.271099999 5794352.7529,4452157.081799999 5794404.193099999,4452234.2647 5794427.138,4452308.5288 5794534.529899999,4452435.394199999 5794629.7093,4452544.2618 5794681.253599999,4452593.511699999 5794625.2739,4452751.238099999 5794579.9405,4452829.732599999 5794517.830199999,4452878.8201 5794444.328299999,4452889.8135 5794368.252199999,4452921.496799999 5794312.443399999,4452962.144799999 5794274.076199999,4453131.631599999 5794231.5588,4453248.150299999 5794163.252599999,4453382.301799999 5794100.625,4453455.0591 5794050.263499999,4453206.0624 5793739.973099999,4453135.649 5793728.9448,4453103.8141 5793770.1535,4453072.5137 5793866.886299999,4452989.660099999 5793780.007099999,4452928.2049 5793786.434399999,4452876.899699999 5793935.9502,4452912.801199999 5794014.494699999,4452917.009999999 5794148.8704,4452894.081399999 5794201.680099999,4452850.317099999 5794219.624299999,4452806.295099999 5794211.275699999,4452758.765399999 5794141.611999999,4452658.427099999 5794063.685499999,4452350.8508 5793903.2375,4452177.271099999 5794352.7529)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (65,65,49272727.0,'NULL','residential',3044.91648755,305590.158912, ST_GeomFromText('MULTIPOLYGON(((4456195.2834 5789974.884199999,4456196.223 5790014.6469,4456202.435999999 5790088.3475,4456084.54 5790036.1235,4456047.0492 5790105.9055,4455973.0277 5790105.829299999,4455916.594499999 5790105.5974,4455968.0065 5790200.1828,4455944.6555 5790211.3517,4455904.616799999 5790241.675799999,4455857.256699999 5790190.932099999,4455779.7001 5790287.3914,4455760.4297 5790344.5831,4455845.9137 5790397.912,4455907.145899999 5790443.413,4455938.189 5790473.1149,4455961.1787 5790503.600899999,4455980.513899999 5790534.8651,4455994.7779 5790573.4855,4456009.432 5790655.223099999,4456019.774699999 5790664.634299999,4456022.1403 5790664.891499999,4456187.748499999 5790682.873299999,4456187.586699999 5790664.6028,4456245.3973 5790656.0456,4456250.080099999 5790688.1749,4456300.562599999 5790678.948699999,4456362.7011 5790661.596999999,4456334.4533 5790562.797,4456407.2784 5790481.377399999,4456362.034699999 5790420.3727,4456338.3808 5790397.1907,4456366.3002 5790322.387499999,4456413.5376 5790194.045099999,4456463.248399999 5790192.7727,4456541.851499999 5790099.4755,4456436.687499999 5790076.141699999,4456423.3267 5790140.5896,4456359.519899999 5790135.2988,4456345.4402 5790034.537699999,4456321.0421 5789927.2912,4456292.3135 5789911.465199999,4456277.6357 5789908.668199999,4456204.9274 5789929.942399999,4456195.2834 5789974.884199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (66,66,49273667.0,'NULL','residential',7956.59601973,787181.321159, ST_GeomFromText('MULTIPOLYGON(((4454209.6309 5789384.321799999,4454146.536999999 5789380.6663,4454088.302899999 5789383.1425,4454037.359699999 5789378.385299999,4454032.073499999 5789363.1335,4454025.0038 5789335.3571,4453955.2214 5789301.709599999,4453946.130599999 5789336.513399999,4453964.082399999 5789357.478299999,4453978.7268 5789386.474999999,4453975.975399999 5789396.960899999,4453956.9007 5789464.5625,4453949.605499999 5789474.979399999,4453923.8392 5789516.481599999,4453939.9982 5789556.2805,4454005.682199999 5789525.701899999,4454051.0696 5789519.426999999,4454082.6231 5789523.5185,4454113.4796 5789530.543299999,4454124.5728 5789541.412599999,4454121.7015 5789561.102199999,4454174.6354 5789578.160499999,4454221.87 5789612.809599999,4454245.7811 5789662.3081,4454417.5541 5789711.6774,4454356.359 5789948.921499999,4454402.590699999 5789984.972599999,4454407.5228 5789988.666099999,4454405.367499999 5789991.2565,4454269.070399999 5790155.2717,4454273.1396 5790158.005,4454308.5525 5790181.780899999,4454335.1463 5790199.629399999,4454377.694799999 5790124.6685,4454449.662499999 5790060.409199999,4454466.9132 5790059.1488,4454474.315299999 5790059.581399999,4454493.6375 5790060.7278,4454529.518899999 5790057.4824,4454552.176799999 5790050.686499999,4454634.541299999 5790080.6436,4454678.2893 5789976.430199999,4454812.0361 5790007.6225,4454857.666799999 5789955.7838,4454931.106499999 5789971.9285,4454984.9434 5790008.7169,4455005.497299999 5789975.535599999,4455092.777999999 5790061.128599999,4455124.6885 5790092.264299999,4455131.28 5790098.235799999,4455126.602099999 5790112.699999999,4455214.087 5790198.6938,4455225.955799999 5790210.4042,4455231.231599999 5790215.1971,4455127.7438 5790279.9867,4455181.6681 5790313.3712,4455240.926699999 5790383.0184,4455308.418999999 5790391.176999999,4455370.1896 5790414.010199999,4455399.650299999 5790446.616299999,4455357.989699999 5790453.323899999,4455309.000099999 5790455.502199999,4455312.253999999 5790490.5591,4455347.553399999 5790504.8624,4455333.1671 5790534.225299999,4455251.5685 5790587.597899999,4455260.775399999 5790604.9186,4455287.217699999 5790639.899399999,4455322.443799999 5790645.434399999,4455492.471599999 5790537.0402,4455514.0343 5790514.1453,4455519.8196 5790508.050799999,4455520.5025 5790507.2769,4455504.488599999 5790488.6926,4455503.585599999 5790487.7771,4455412.733699999 5790390.102099999,4455409.487099999 5790387.5942,4455339.4841 5790316.9626,4455345.1134 5790311.7484,4455386.6853 5790273.861199999,4455417.2707 5790244.7419,4455429.3096 5790233.6947,4455684.524 5790297.7464,4455704.894199999 5790258.927899999,4455671.214999999 5790248.658099999,4455543.8502 5790213.256999999,4455566.812499999 5790165.757099999,4455595.754599999 5790123.8233,4455447.7253 5789962.8649,4455460.684999999 5789937.153999999,4455338.975899999 5789850.529999999,4455300.6354 5789825.281999999,4455130.399299999 5789965.732599999,4455082.131599999 5789905.734999999,4455064.422899999 5789883.7178,4455036.8196 5789911.0206,4455010.9707 5789889.322399999,4455059.5925 5789835.511099999,4455012.3792 5789802.311599999,4454989.2213 5789834.6819,4454964.189199999 5789822.4798,4454942.7719 5789804.402799999,4455021.6557 5789694.0195,4455009.0562 5789678.777599999,4455006.544099999 5789644.4374,4454985.079699999 5789621.2418,4454904.476599999 5789543.012099999,4454918.032499999 5789502.683499999,4454831.991899999 5789472.0206,4454844.2389 5789448.517999999,4454787.463999999 5789411.746799999,4454831.7153 5789360.888699999,4454748.3452 5789300.569299999,4454789.3558 5789217.235899999,4454834.944 5789171.9297,4454735.011699999 5789206.7717,4454719.570799999 5789181.3967,4454698.382199999 5789177.4955,4454665.3551 5789099.980499999,4454614.0887 5789103.421599999,4454614.9626 5789124.9572,4454598.2966 5789123.285099999,4454557.564899999 5789120.6544,4454554.158099999 5789149.206499999,4454497.693599999 5789146.798699999,4454482.6869 5789268.3089,4454454.847699999 5789270.0228,4454443.131299999 5789271.5996,4454428.5042 5789275.384199999,4454351.4379 5789264.3991,4454351.3435 5789254.162299999,4454291.922399999 5789248.868599999,4454291.9763 5789254.7103,4454248.7048 5789252.183499999,4454246.105299999 5789288.0394,4454222.645499999 5789288.2564,4454209.6309 5789384.321799999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (67,67,49273668.0,'NULL','allotments',1148.0771512,56626.1291181, ST_GeomFromText('MULTIPOLYGON(((4454999.377399999 5790225.7135,4455016.7328 5790199.9614,4455051.517099999 5790157.247899999,4455126.602099999 5790112.699999999,4454812.0361 5790007.6225,4454678.2893 5789976.430199999,4454634.541299999 5790080.6436,4454999.377399999 5790225.7135)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (68,68,49287604.0,'NULL','farm',2459.8903169,274481.328382, ST_GeomFromText('MULTIPOLYGON(((4461710.223199999 5793080.011399999,4461832.91 5793070.7277,4461863.156 5793080.0307,4461905.961099999 5793125.38,4462057.836199999 5793064.299799999,4462117.703999999 5793039.003399999,4462157.0815 5793016.779999999,4462201.9181 5792949.592499999,4462144.909199999 5792924.980299999,4462091.404799999 5792911.413899999,4462036.429399999 5792893.920199999,4461982.297399999 5792864.5251,4461863.2828 5792776.197399999,4461788.8508 5792736.155999999,4461401.359699999 5792533.514699999,4461314.9209 5792488.7002,4461199.2674 5792719.016799999,4461288.331699999 5792797.815199999,4461710.223199999 5793080.011399999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (69,69,49287609.0,'NULL','farm',4149.83441989,821052.473069, ST_GeomFromText('MULTIPOLYGON(((4460752.840699999 5791705.184599999,4460739.7774 5791755.9197,4460837.8283 5791798.050699999,4460877.995799999 5791689.5709,4460935.3195 5791712.508199999,4460912.3172 5791768.228599999,4461048.354199999 5791822.593499999,4461068.675599999 5791767.9297,4461225.202899999 5791386.0192,4461170.3539 5791368.923399999,4461123.298 5791347.6608,4461045.670599999 5791315.5339,4460976.291899999 5791288.595399999,4460926.802199999 5791256.838099999,4460883.7049 5791217.419399999,4460854.1083 5791181.399399999,4460832.1139 5791142.982499999,4460812.384899999 5791094.020899999,4460800.367399999 5791057.283199999,4460794.229899999 5791022.246099999,4460789.7547 5790975.5116,4460768.2675 5790648.192299999,4460738.387799999 5790650.187599999,4460735.223299999 5790620.6574,4460398.772199999 5790765.196499999,4460270.361899999 5790834.929199999,4460236.999499999 5790877.5941,4460209.567699999 5790928.980299999,4460186.6286 5790992.014499999,4460164.9044 5791024.348699999,4460080.587799999 5791108.353399999,4460052.985799999 5791154.356,4460054.946 5791178.8991,4460051.665199999 5791208.158299999,4460045.3557 5791225.167999999,4460035.494199999 5791238.690099999,4460022.094299999 5791248.7355,4460009.8265 5791253.5195,4459945.835799999 5791278.8078,4460236.4707 5791673.0117,4460752.840699999 5791705.184599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (70,70,49287627.0,'NULL','allotments',2275.26957468,135287.120644, ST_GeomFromText('MULTIPOLYGON(((4459687.1336 5792997.596599999,4459833.210699999 5792962.523,4459820.475399999 5792911.761299999,4459866.544999999 5792902.6183,4459842.1002 5792778.6082,4460021.2521 5792741.357699999,4460025.729 5792785.0315,4460027.5307 5792790.858999999,4460033.565 5792819.442099999,4460044.298999999 5792870.3318,4460086.6725 5792859.9187,4460093.7333 5792895.626499999,4460213.2854 5792863.0152,4460228.4989 5792859.966099999,4460280.885099999 5792743.8157,4460296.4232 5792708.037399999,4460318.0163 5792661.906199999,4460354.0289 5792584.2345,4460366.125 5792558.421199999,4460339.862099999 5792571.4956,4460305.978199999 5792585.209899999,4460264.486999999 5792599.5643,4460184.3375 5792615.4099,4459928.6643 5792665.9933,4459630.290799999 5792725.7072,4459632.926599999 5792738.3046,4459687.1336 5792997.596599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (71,71,49287649.0,'NULL','residential',8795.26517113,1225596.57483, ST_GeomFromText('MULTIPOLYGON(((4461000.425999999 5792194.0489,4461011.217799999 5792149.486099999,4461034.2055 5792092.019099999,4461068.875599999 5792029.196799999,4461106.586099999 5791980.371799999,4461157.138 5791925.025499999,4461209.535099999 5791880.180999999,4461264.005699999 5791835.777,4461282.638199999 5791772.681299999,4461191.364199999 5791839.2288,4461182.206399999 5791833.903699999,4461077.5455 5791773.0899,4461068.675599999 5791767.9297,4461049.444099999 5791819.658299999,4461027.304499999 5791874.025,4460837.8283 5791798.050699999,4460739.7774 5791755.9197,4460752.840699999 5791705.184599999,4460236.4707 5791673.0117,4460308.464599999 5791770.669299999,4460299.2224 5791780.480299999,4460274.8935 5791816.340299999,4460271.4193 5791821.631599999,4460268.2543 5791824.6059,4460256.120299999 5791831.435699999,4460275.706199999 5791844.398,4460319.439199999 5791889.0587,4460350.207899999 5791925.644799999,4460361.423899999 5791935.492,4460398.201799999 5791974.7454,4460381.467699999 5791989.490199999,4460435.323499999 5792036.5523,4460483.378499999 5792090.9834,4460460.9501 5792126.2375,4460439.627299999 5792116.170499999,4460378.5244 5792262.0778,4460295.190899999 5792375.2706,4460326.16 5792400.593599999,4460403.3278 5792431.3997,4460391.0564 5792454.1431,4460389.834499999 5792484.843299999,4460385.3421 5792543.6563,4460373.678399999 5792550.1817,4460366.125 5792558.421199999,4460354.0289 5792584.2345,4460318.0163 5792661.906199999,4460296.4232 5792708.037399999,4460280.885099999 5792743.8157,4460228.4989 5792859.966099999,4460213.2854 5792863.0152,4460093.7333 5792895.626499999,4460086.6725 5792859.9187,4460044.298999999 5792870.3318,4460033.565 5792819.442099999,4460027.5307 5792790.858999999,4460025.729 5792785.0315,4460021.2521 5792741.357699999,4459842.1002 5792778.6082,4459866.544999999 5792902.6183,4459820.475399999 5792911.761299999,4459833.210699999 5792962.523,4459914.555499999 5792941.676699999,4459926.178199999 5792938.7004,4459935.9587 5792945.954299999,4460074.2757 5793048.5128,4460190.5257 5793122.5876,4460228.6332 5793091.289799999,4460233.769999999 5793095.0653,4460290.322499999 5793136.6403,4460314.2762 5793110.141799999,4460255.081 5793065.082499999,4460343.637299999 5792977.329399999,4460556.178199999 5793134.511199999,4460595.367399999 5793089.631799999,4460651.8282 5793031.762499999,4460661.9499 5793097.491699999,4460667.0618 5793139.3472,4460667.256699999 5793241.0314,4460622.9599 5793242.8308,4460622.3799 5793262.564999999,4460612.307599999 5793285.2903,4460592.9636 5793339.503399999,4460666.1993 5793338.886499999,4460665.4226 5793358.811499999,4460660.6304 5793379.3804,4460655.171199999 5793389.9063,4460650.563799999 5793398.5225,4460585.014 5793487.9671,4460570.9094 5793522.8318,4460572.274899999 5793555.369699999,4460577.041199999 5793578.688999999,4460587.674899999 5793608.4712,4460618.484799999 5793611.5305,4460853.677899999 5793530.7989,4461043.8585 5793465.5336,4461102.7076 5793444.7507,4461105.075799999 5793426.4713,4461090.3776 5793271.131899999,4461072.4533 5793094.5972,4460981.019399999 5793181.503,4460991.316999999 5793080.704099999,4461063.3135 5793005.502299999,4461042.9181 5792808.445399999,4461022.136599999 5792607.630499999,4460915.222699999 5792691.821799999,4460855.347599999 5792622.891699999,4460933.8858 5792550.6631,4460892.6028 5792517.3725,4460879.4833 5792525.5217,4460855.7854 5792492.8267,4460945.391599999 5792430.737099999,4460980.1962 5792477.9556,4461010.918899999 5792495.9405,4460995.633799999 5792323.9923,4461091.836199999 5792373.253499999,4461143.613099999 5792300.571399999,4461123.6628 5792278.0832,4461090.521599999 5792255.687799999,4461000.425999999 5792194.0489)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (72,72,49368545.0,'NULL','farm',4044.68990202,719327.983783, ST_GeomFromText('MULTIPOLYGON(((4452579.4285 5787710.0603,4452491.1364 5787860.544299999,4452227.6741 5788155.6228,4452147.966799999 5788162.245899999,4452106.709999999 5788170.6236,4452085.5652 5788182.5238,4451910.435999999 5788344.387,4451606.643899999 5788617.1905,4451560.1255 5788658.607699999,4452135.940899999 5788691.0304,4452248.8902 5788696.516,4452274.546099999 5788696.2686,4452306.752799999 5788690.839299999,4452527.0355 5788650.6973,4452612.6502 5788634.5203,4452641.2164 5788631.320199999,4452688.8387 5788628.672599999,4452998.940799999 5788627.910399999,4453111.8141 5788624.6477,4453096.1639 5788597.732799999,4453048.030799999 5788470.2177,4453031.586299999 5788436.733899999,4452805.829199999 5788073.8953,4452579.4285 5787710.0603)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (73,73,49368553.0,'NULL','farm',2826.44968158,459263.563712, ST_GeomFromText('MULTIPOLYGON(((4452538.191999999 5789202.671499999,4452528.3935 5789251.0164,4452525.9817 5789305.143799999,4452537.6331 5789509.831499999,4452605.4841 5789500.145199999,4452711.112499999 5789501.516,4452765.9588 5789488.5622,4452840.602699999 5789475.420299999,4452966.585699999 5789466.186899999,4453195.928299999 5789458.8934,4453199.656799999 5789386.470799999,4453331.4763 5789373.5304,4453382.463999999 5789339.4099,4453415.6753 5789284.9931,4453419.7515 5789251.325999999,4453417.718299999 5789190.6533,4453402.1956 5789176.9118,4453385.8936 5789158.782099999,4453333.593999999 5789053.9823,4453267.886099999 5789004.148199999,4453194.239599999 5788968.277699999,4453100.0684 5788932.6138,4453052.999699999 5788916.9691,4453013.4072 5788915.887,4452931.423399999 5788928.3615,4452924.706199999 5788839.2126,4452839.6649 5788838.5644,4452740.0733 5788849.7521,4452647.960199999 5788876.9613,4452576.5328 5788920.053899999,4452515.494699999 5788976.2123,4452505.377899999 5789144.4865,4452544.751199999 5789122.175599999,4452538.191999999 5789202.671499999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (74,74,49368600.0,'NULL','meadow',2921.79077337,158184.859999, ST_GeomFromText('MULTIPOLYGON(((4449893.1023 5787505.036299999,4449697.9071 5787505.036299999,4449677.5433 5787584.012499999,4449672.0811 5787623.561499999,4449672.3934 5787654.282899999,4449685.363699999 5787703.8824,4450177.214399999 5787709.625,4450148.944 5787815.2364,4450260.4171 5787817.041999999,4450277.161799999 5787732.0225,4450494.1243 5787724.0062,4450502.546099999 5787685.886399999,4450916.301799999 5787705.1696,4450866.445199999 5787683.2412,4450449.258 5787614.2653,4450391.8369 5787591.426899999,4450300.6972 5787570.396299999,4450152.6346 5787576.2803,4450083.6546 5787571.121799999,4449970.218799999 5787521.0665,4449920.304899999 5787515.7178,4449893.1023 5787505.036299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (75,75,49368730.0,'NULL','farm',5944.36681213,1165260.9645, ST_GeomFromText('MULTIPOLYGON(((4452712.2202 5792529.703299999,4452810.147599999 5792351.943099999,4452963.5042 5792147.3285,4453060.375599999 5792010.490299999,4453104.359799999 5791884.7048,4453162.6117 5791823.071,4453197.5558 5791797.256999999,4453406.0606 5791620.6228,4453630.7877 5791397.5642,4453966.2433 5791112.158099999,4453634.9367 5791100.0076,4453525.301799999 5791361.921099999,4453475.512799999 5791333.300699999,4453373.3524 5791324.6817,4453317.5004 5791297.811499999,4453349.429999999 5791207.506999999,4453446.4483 5791103.469699999,4453393.7547 5791098.880499999,4452938.340599999 5791151.255,4452841.944299999 5791169.6442,4452383.3908 5791245.2127,4452384.307699999 5791492.234899999,4452362.210099999 5791632.772199999,4452357.801599999 5791783.354599999,4452337.1741 5791923.8668,4452296.551599999 5792117.185399999,4452272.391699999 5792194.880899999,4452233.933799999 5792309.247999999,4452542.768 5792390.2681,4452491.8243 5792577.8198,4452650.483199999 5792623.0576,4452691.1923 5792590.518899999,4452712.2202 5792529.703299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (76,76,61283860.0,'NULL','cemetery',1511.56778565,128805.764285, ST_GeomFromText('MULTIPOLYGON(((4460669.217699999 5794846.246799999,4460991.479199999 5794681.581199999,4461006.745 5794495.6151,4460703.8662 5794275.058399999,4460666.3865 5794307.260099999,4460668.484 5794755.816899999,4460669.217699999 5794846.246799999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (77,77,61284175.0,'NULL','retail',1167.67609557,73798.9733591, ST_GeomFromText('MULTIPOLYGON(((4461454.952499999 5794767.0208,4461417.355999999 5794453.254399999,4461100.298999999 5794652.413899999,4461110.232599999 5794753.4429,4461212.4538 5794749.6903,4461211.7083 5794779.028999999,4461324.9933 5794781.6237,4461454.952499999 5794767.0208)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (78,78,89947790.0,'NULL','farmland',5037.95648014,1039278.63327, ST_GeomFromText('MULTIPOLYGON(((4454727.640399999 5787505.036299999,4454152.6885 5787505.036299999,4454139.0404 5787541.046599999,4454175.0684 5787551.6852,4454129.798799999 5787651.5766,4454124.991799999 5787686.729699999,4454117.747999999 5787775.297,4454128.953499999 5787797.871899999,4454135.6971 5787813.165899999,4454134.2821 5787819.032299999,4454019.366299999 5787840.573599999,4454004.7489 5787845.828199999,4453984.294599999 5788011.3123,4453872.980999999 5788183.4733,4453925.076799999 5788187.3837,4453968.4802 5788203.0708,4453987.6533 5788215.322499999,4453997.389299999 5788237.1651,4454001.2761 5788261.265399999,4453968.2487 5788336.174,4453982.3293 5788668.0446,4453992.458599999 5788732.292099999,4454069.0903 5789168.852199999,4454086.1681 5789192.819099999,4454227.138899999 5789217.1074,4454222.645499999 5789288.2564,4454246.105299999 5789288.0394,4454248.7048 5789252.183499999,4454291.9763 5789254.7103,4454291.922399999 5789248.868599999,4454351.3435 5789254.162299999,4454351.4379 5789264.3991,4454428.5042 5789275.384199999,4454443.131299999 5789271.5996,4454454.847699999 5789270.0228,4454482.6869 5789268.3089,4454497.693599999 5789146.798699999,4454554.158099999 5789149.206499999,4454557.564899999 5789120.6544,4454598.2966 5789123.285099999,4454605.798999999 5789103.2083,4454595.9866 5788912.4547,4454561.008 5788775.3015,4454552.711 5788749.7946,4454527.417 5788709.799599999,4454521.4203 5788695.967,4454521.063099999 5788576.7682,4454581.880499999 5788573.283099999,4454578.7344 5788470.211999999,4454586.501799999 5788437.958799999,4454687.9318 5787985.8044,4454692.0849 5787958.703299999,4454705.5184 5787824.0109,4454727.640399999 5787505.036299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (79,79,89956193.0,'NULL','farmland',3085.68338089,329368.74154, ST_GeomFromText('MULTIPOLYGON(((4453636.4017 5788991.546099999,4453576.121199999 5789132.5347,4453640.915099999 5789162.640399999,4453671.856599999 5789179.164999999,4453715.9763 5789194.108699999,4453786.677899999 5789229.268799999,4453827.995699999 5789258.138499999,4453862.5772 5789271.7036,4453893.3879 5789274.3431,4453926.296199999 5789265.9911,4453959.9763 5789262.016499999,4453955.2214 5789301.709599999,4454025.0038 5789335.3571,4454055.044999999 5789158.7783,4454028.399899999 5789050.0499,4453976.596199999 5788681.9856,4453957.897099999 5788326.755899999,4453965.5996 5788287.925699999,4453974.1626 5788262.2519,4453979.1106 5788242.4538,4453907.138399999 5788229.235799999,4453904.268299999 5788236.573599999,4453885.3403 5788250.6487,4453833.3611 5788259.1786,4453699.953499999 5788340.133999999,4453725.522599999 5788409.366499999,4453733.913499999 5788443.662299999,4453726.2131 5788483.227299999,4453711.823499999 5788511.8716,4453625.755199999 5788637.732899999,4453600.434999999 5788673.8021,4453587.549999999 5788706.828299999,4453584.8178 5788728.063699999,4453587.3331 5788761.6688,4453583.1456 5788784.3757,4453570.8002 5788796.932499999,4453555.455 5788802.195299999,4453541.04 5788828.648199999,4453554.260499999 5788831.450799999,4453576.991499999 5788831.971899999,4453629.763799999 5788830.742799999,4453648.7504 5788822.5194,4453684.5718 5788811.946399999,4453720.536999999 5788816.7288,4453743.363699999 5788827.4876,4453753.065499999 5788845.680099999,4453752.512099999 5788865.4262,4453701.763 5788925.857999999,4453668.251899999 5788948.1159,4453636.4017 5788991.546099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (80,80,89956195.0,'NULL','farm',725.579253117,27797.5020262, ST_GeomFromText('MULTIPOLYGON(((4453418.113499999 5789319.0105,4453398.5151 5789339.659399999,4453359.932799999 5789367.809399999,4453343.1829 5789379.662799999,4453335.2182 5789389.9756,4453335.5837 5789428.730799999,4453397.148599999 5789428.150599999,4453448.5832 5789440.8197,4453637.592799999 5789356.431299999,4453526.973 5789280.6973,4453502.7341 5789275.806099999,4453470.695 5789298.0404,4453449.5038 5789305.550799999,4453425.3749 5789311.619999999,4453418.113499999 5789319.0105)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (81,81,89956200.0,'NULL','farm',2395.02330941,225250.427298, ST_GeomFromText('MULTIPOLYGON(((4453549.0086 5788196.0393,4453579.8304 5788120.4252,4453410.268799999 5788096.4238,4453337.396599999 5788104.8552,4453226.898199999 5788127.107899999,4453121.583999999 5788232.684399999,4453072.4192 5788228.0314,4452958.309 5788140.190999999,4452900.961799999 5788123.9108,4452843.008399999 5788120.8014,4453037.2944 5788429.0348,4453058.2708 5788475.64,4453096.6505 5788580.58,4453106.424499999 5788606.0817,4453125.7159 5788630.035499999,4453202.4027 5788676.8373,4453218.679399999 5788692.774499999,4453306.9094 5788797.968399999,4453341.304499999 5788596.995999999,4453383.631699999 5788459.4008,4453406.537999999 5788400.685599999,4453449.122899999 5788329.344299999,4453475.864799999 5788288.1421,4453549.0086 5788196.0393)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (82,82,89956204.0,'NULL','farm',911.353034013,21647.7280855, ST_GeomFromText('MULTIPOLYGON(((4453707.581299999 5789314.8253,4453975.975399999 5789396.960899999,4453978.7268 5789386.474999999,4453782.619699999 5789265.873099999,4453762.684999999 5789250.7028,4453748.679999999 5789242.0537,4453705.394399999 5789238.0741,4453653.0903 5789210.7772,4453616.3695 5789203.075699999,4453595.8676 5789205.4712,4453576.281799999 5789227.588099999,4453691.3835 5789307.665799999,4453707.581299999 5789314.8253)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (83,83,89956206.0,'NULL','farm',1325.59630277,54293.7197994, ST_GeomFromText('MULTIPOLYGON(((4455726.0745 5790028.1906,4455765.977699999 5790064.3888,4455783.840699999 5790094.9309,4455818.684799999 5790139.943499999,4455857.256699999 5790190.932099999,4455904.616799999 5790241.675799999,4455944.6555 5790211.3517,4455968.0065 5790200.1828,4455916.594499999 5790105.5974,4455857.418999999 5790045.3,4455826.294599999 5790006.830499999,4455809.854 5789971.88,4455800.4687 5789905.441299999,4455791.461699999 5789882.130999999,4455770.8113 5789867.693499999,4455739.9139 5789854.8055,4455706.164599999 5789850.7232,4455675.378299999 5789850.264499999,4455509.033099999 5789853.949699999,4455498.055499999 5789855.5173,4455527.0102 5789896.9309,4455543.144199999 5789897.509299999,4455562.945799999 5789899.5236,4455586.4682 5789906.6234,4455615.9561 5789926.0996,4455661.760999999 5789966.628399999,4455701.691399999 5790005.752499999,4455726.0745 5790028.1906)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (84,84,89956207.0,'NULL','farm',1503.87809805,59235.7637032, ST_GeomFromText('MULTIPOLYGON(((4453425.2076 5788748.5919,4453441.7466 5788714.0732,4453452.389299999 5788676.683399999,4453522.904099999 5788457.3679,4453528.478199999 5788425.868,4453520.7209 5788380.594499999,4453516.907399999 5788365.2737,4453518.280399999 5788355.023199999,4453550.816899999 5788310.1059,4453550.954199999 5788324.7378,4453549.622299999 5788339.3724,4453554.207999999 5788359.070299999,4453563.1117 5788370.693399999,4453578.5886 5788379.328199999,4453569.657399999 5788364.778699999,4453559.446399999 5788292.476099999,4453551.974299999 5788199.672499999,4453467.987499999 5788308.6916,4453430.457999999 5788371.9396,4453408.1379 5788415.2926,4453375.631299999 5788505.2565,4453345.939 5788621.8122,4453331.847699999 5788721.6848,4453325.999099999 5788800.714999999,4453344.2751 5788795.4238,4453367.6271 5788784.242699999,4453399.048299999 5788773.7091,4453416.552 5788764.029899999,4453425.2076 5788748.5919)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (85,85,89956210.0,'NULL','farm',703.971611952,20602.1292776, ST_GeomFromText('MULTIPOLYGON(((4453680.180599999 5789363.343599999,4453864.7635 5789450.498099999,4453956.9007 5789464.5625,4453975.975399999 5789396.960899999,4453707.581299999 5789314.8253,4453680.180599999 5789363.343599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (86,86,89979518.0,'NULL','farm',2515.10766799,218405.713128, ST_GeomFromText('MULTIPOLYGON(((4454789.6206 5790610.526799999,4454899.7257 5790389.500299999,4454929.3848 5790347.5559,4454967.908499999 5790312.118799999,4455022.472199999 5790268.490599999,4455061.203099999 5790255.719799999,4454999.377399999 5790225.7135,4454634.541299999 5790080.6436,4454552.176799999 5790050.686499999,4454529.518899999 5790057.4824,4454493.6375 5790060.7278,4454474.315299999 5790059.581399999,4454468.8865 5790079.8285,4454427.2152 5790170.137099999,4454679.491299999 5790268.705299999,4454662.975999999 5790305.4008,4454404.800499999 5790203.2378,4454328.5968 5790364.038399999,4454414.608099999 5790472.888599999,4454575.555399999 5790521.850999999,4454649.865899999 5790554.0633,4454789.6206 5790610.526799999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (87,87,89979519.0,'NULL','farm',627.351349441,18956.9955176, ST_GeomFromText('MULTIPOLYGON(((4455182.167399999 5789775.042999999,4455129.151499999 5789828.892999999,4455153.511699999 5789848.413,4455082.131599999 5789905.734999999,4455130.399299999 5789965.732599999,4455300.6354 5789825.281999999,4455247.5283 5789789.0734,4455210.0503 5789778.4516,4455182.167399999 5789775.042999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (88,88,89979522.0,'NULL','farm',3050.28490502,256437.566871, ST_GeomFromText('MULTIPOLYGON(((4453951.5421 5790875.558599999,4454030.682599999 5790718.3967,4453970.5206 5790710.1874,4453971.162899999 5790700.678099999,4453976.2104 5790691.862299999,4453987.1994 5790691.760099999,4454024.693699999 5790704.564699999,4454062.769199999 5790701.284299999,4454078.486899999 5790657.282999999,4454115.079499999 5790573.6173,4453962.5558 5790563.339099999,4453938.357699999 5790561.372099999,4453917.1644 5790568.146099999,4453890.787499999 5790568.391899999,4453803.461099999 5790555.319,4453886.506599999 5790501.9089,4453930.0465 5790534.3975,4453970.451799999 5790545.7168,4454115.681499999 5790558.9896,4454257.8409 5790320.825799999,4454209.252999999 5790297.1499,4454308.5525 5790181.780899999,4454273.1396 5790158.005,4454212.2713 5790226.9492,4454072.009899999 5790354.718499999,4453596.4451 5790673.477199999,4453572.909199999 5790820.620699999,4453951.5421 5790875.558599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (89,89,89979540.0,'NULL','farm',1195.21383544,43228.3961809, ST_GeomFromText('MULTIPOLYGON(((4453302.054899999 5791005.1687,4453324.754599999 5790848.539499999,4452860.251 5791160.6674,4453142.564199999 5791109.010199999,4453302.054899999 5791005.1687)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (90,90,90155685.0,'NULL','farm',4702.34169144,1186740.62546, ST_GeomFromText('MULTIPOLYGON(((4463201.4649 5790135.3945,4463201.4649 5788988.3134,4463151.328999999 5788988.4209,4463023.7242 5788980.5931,4462285.181099999 5788924.4305,4462232.0586 5788893.978599999,4461952.968299999 5789573.3255,4462306.991299999 5789710.167999999,4462337.160199999 5789637.6862,4462384.8896 5789658.966399999,4462355.7536 5789729.014299999,4462435.196299999 5789759.723699999,4462430.8676 5789961.5238,4462450.664099999 5789989.448699999,4462480.3069 5790033.089099999,4462498.2723 5790082.660299999,4462499.727599999 5790120.539,4462598.200899999 5790116.989299999,4462701.308699999 5790145.5545,4462702.0855 5790206.8956,4463016.9175 5790227.8219,4463037.420599999 5790224.742,4463056.415599999 5790217.2893,4463201.4649 5790135.3945)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (91,91,90481015.0,'NULL','farm',1878.74127951,114298.951352, ST_GeomFromText('MULTIPOLYGON(((4462420.893099999 5790781.2881,4462488.615299999 5790725.9589,4462541.069299999 5790685.356899999,4462603.6166 5790622.7576,4462631.207299999 5790588.921199999,4462650.799999999 5790563.1906,4462671.0354 5790525.760099999,4462702.4565 5790417.3396,4462711.852199999 5790399.731599999,4462731.550599999 5790387.8879,4462779.672699999 5790357.247099999,4462857.947999999 5790326.9811,4462914.389899999 5790301.664999999,4462956.398 5790269.769899999,4462964.929899999 5790239.739099999,4462763.8085 5790226.082,4462642.211699999 5790292.440799999,4462666.0767 5790354.753799999,4462604.7505 5790385.1839,4462580.5888 5790387.5588,4462559.300499999 5790383.335599999,4462542.3843 5790374.695,4462522.6253 5790378.494599999,4462426.253399999 5790426.006599999,4462421.257399999 5790443.5929,4462420.791899999 5790479.4165,4462416.661299999 5790513.7991,4462405.826299999 5790535.0797,4462392.1239 5790563.693099999,4462384.9511 5790584.2115,4462385.809799999 5790601.018899999,4462392.0266 5790647.0181,4462384.9429 5790679.231,4462364.8606 5790736.4021,4462364.960699999 5790749.5543,4462370.195299999 5790763.4019,4462381.273 5790775.0128,4462393.032599999 5790779.3077,4462406.236999999 5790781.399499999,4462420.893099999 5790781.2881)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (92,92,90481017.0,'NULL','farm',793.523541364,28385.5543788, ST_GeomFromText('MULTIPOLYGON(((4461411.0811 5791614.909399999,4461541.8678 5791380.7531,4461499.509499999 5791398.6312,4461453.462899999 5791412.877399999,4461419.0728 5791418.2532,4461365.596699999 5791419.4052,4461328.9669 5791420.425899999,4461279.859799999 5791417.8836,4461271.1961 5791434.754399999,4461301.4812 5791465.953199999,4461322.2456 5791497.938799999,4461337.950299999 5791538.743799999,4461344.8036 5791571.572699999,4461411.0811 5791614.909399999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (93,93,90481019.0,'NULL','farm',998.339583403,60287.5951242, ST_GeomFromText('MULTIPOLYGON(((4461206.162899999 5791456.4626,4461077.5455 5791773.0899,4461182.206399999 5791833.903699999,4461300.7252 5791743.6632,4461315.908999999 5791717.961699999,4461327.381599999 5791685.723899999,4461329.408699999 5791663.7752,4461330.5042 5791616.9967,4461326.5185 5791575.3767,4461316.666899999 5791533.7915,4461293.606499999 5791489.3942,4461261.785799999 5791448.7155,4461241.152499999 5791433.532099999,4461206.162899999 5791456.4626)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (94,94,90482207.0,'NULL','farm',2690.42039437,170704.226119, ST_GeomFromText('MULTIPOLYGON(((4461616.747299999 5787906.790999999,4461535.3239 5787995.921499999,4461518.7015 5787933.156999999,4461455.763199999 5787948.2684,4461403.735899999 5787951.6004,4461351.6961 5787954.198599999,4461381.749699999 5788046.846799999,4461392.378299999 5788093.566899999,4461394.8743 5788120.075899999,4461396.3717 5788135.9545,4461393.668399999 5788165.230299999,4461388.045199999 5788195.9866,4461379.5705 5788237.002599999,4461202.16 5788799.993899999,4461597.7752 5788391.070199999,4461523.9373 5788323.6312,4461575.472699999 5788257.4217,4461612.3755 5788288.5822,4461651.6188 5788244.390499999,4461696.680399999 5788287.929099999,4461720.677899999 5788262.138699999,4461688.176099999 5788230.954399999,4461720.939699999 5788201.446299999,4461686.7252 5788178.5877,4461709.306499999 5788149.8704,4461641.5327 5788077.731399999,4461639.2417 5788066.053999999,4461642.8262 5788055.0543,4461596.2702 5788008.612299999,4461655.9027 5787945.2564,4461616.747299999 5787906.790999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (95,95,90482209.0,'NULL','farm',2316.28633,249917.630612, ST_GeomFromText('MULTIPOLYGON(((4462283.671699999 5788735.3383,4462585.1446 5788038.3835,4462597.026399999 5788001.950799999,4462532.7082 5787984.9,4462545.3211 5787934.9416,4462323.912499999 5787936.788699999,4462241.627799999 5787937.860799999,4462232.602199999 5788020.507999999,4462189.1369 5788068.444,4462126.2355 5788279.504799999,4462002.803199999 5788244.608599999,4462170.4626 5788694.5181,4462283.671699999 5788735.3383)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (96,96,90486490.0,'NULL','farm',1707.1753434,122826.717373, ST_GeomFromText('MULTIPOLYGON(((4458771.5645 5793287.7412,4458895.3534 5793438.315899999,4458910.9638 5793548.162599999,4459004.869599999 5793534.763699999,4459010.684399999 5793528.873299999,4459014.264299999 5793519.3516,4459060.927099999 5793317.328199999,4459101.502199999 5793175.267999999,4459101.1999 5793138.7378,4459098.2158 5793105.634899999,4458897.3073 5793076.544399999,4458877.8064 5793108.944,4458845.9309 5793167.8197,4458691.1413 5793145.664699999,4458659.0054 5793172.3065,4458623.2969 5793201.904899999,4458605.79 5793257.7353,4458582.6478 5793314.748099999,4458771.5645 5793287.7412)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (97,97,90486497.0,'NULL','farm',1888.90007561,186915.801856, ST_GeomFromText('MULTIPOLYGON(((4460001.727699999 5793547.0581,4460351.11 5793552.9999,4460353.4916 5793666.907299999,4460501.0586 5793621.203099999,4460519.769299999 5793579.4133,4460555.798999999 5793506.071499999,4460562.247 5793487.759299999,4460566.3386 5793450.470799999,4460566.0296 5793411.7485,4460395.0562 5793278.703099999,4460404.4488 5793263.2826,4460348.4724 5793224.283299999,4460370.953499999 5793196.339099999,4460290.322499999 5793136.6403,4460233.769999999 5793095.0653,4460027.5766 5793302.1148,4460013.0546 5793408.157999999,4460001.727699999 5793547.0581)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (98,98,90486499.0,'NULL','farm',1098.87281953,38582.3993652, ST_GeomFromText('MULTIPOLYGON(((4461278.4407 5793297.2627,4461202.455599999 5793227.731399999,4461245.321299999 5793183.562799999,4461068.9604 5793016.908299999,4461111.8589 5793348.979699999,4461180.5553 5793330.178899999,4461207.671699999 5793332.158099999,4461223.102199999 5793338.6135,4461243.1578 5793374.2542,4461268.720499999 5793365.285099999,4461322.841799999 5793300.119799999,4461310.386099999 5793261.2144,4461278.4407 5793297.2627)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (99,99,90486501.0,'NULL','farm',951.386071017,47755.7517922, ST_GeomFromText('MULTIPOLYGON(((4459353.410799999 5793081.1291,4459304.4358 5792825.825799999,4459135.4226 5792866.3012,4459138.1474 5792899.4174,4459159.6971 5792905.626599999,4459160.2125 5792919.254,4459153.239799999 5792952.850899999,4459135.525799999 5792994.381799999,4459090.792399999 5793005.5236,4459094.252299999 5793064.7507,4459258.275999999 5793090.681199999,4459286.143099999 5793094.835999999,4459307.3798 5793094.661,4459353.410799999 5793081.1291)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (100,100,90486503.0,'NULL','farm',1110.21698578,70038.0315489, ST_GeomFromText('MULTIPOLYGON(((4459956.4813 5793689.9163,4459985.180499999 5793674.2606,4460013.176099999 5793332.9107,4460009.4346 5793322.7145,4459983.0437 5793324.419299999,4459730.821399999 5793470.384299999,4459866.0218 5793740.936899999,4459956.4813 5793689.9163)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (101,101,90486505.0,'NULL','farm',1935.04344757,195269.298424, ST_GeomFromText('MULTIPOLYGON(((4462532.1352 5793564.478599999,4462591.0025 5793408.4221,4462599.678199999 5793393.022399999,4462665.9165 5793339.1863,4462735.932 5793299.944399999,4462782.1342 5793283.7725,4462787.700299999 5793269.5984,4462617.905399999 5793188.3232,4462613.5591 5793194.9326,4462595.2569 5793195.8055,4462578.338 5793186.4305,4462564.3267 5793173.394799999,4462362.307599999 5793094.564699999,4462329.981599999 5793080.923599999,4462304.426799999 5793091.356,4462188.423899999 5793150.6851,4462174.5946 5793162.475099999,4462166.645999999 5793176.423399999,4461989.4669 5793280.058199999,4462105.077999999 5793361.727199999,4462133.148099999 5793392.925599999,4462311.8026 5793482.874099999,4462532.1352 5793564.478599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (102,102,90486511.0,'NULL','farm',1450.21275316,148008.513095, ST_GeomFromText('MULTIPOLYGON(((4458530.322999999 5793712.551799999,4458562.2766 5793680.1464,4458599.1407 5793635.782199999,4458622.0738 5793589.019999999,4458601.971199999 5793383.7236,4458582.6478 5793314.748099999,4458536.9127 5793324.000499999,4458252.1189 5793320.0776,4458212.664699999 5793361.617499999,4458160.810499999 5793422.035499999,4458142.9186 5793449.4392,4458141.350599999 5793472.242399999,4458149.711099999 5793503.4743,4458200.160099999 5793580.486099999,4458295.741299999 5793668.000499999,4458358.654699999 5793677.473799999,4458468.738099999 5793704.3002,4458530.322999999 5793712.551799999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (103,103,90486514.0,'NULL','farm',1369.62362119,102232.911644, ST_GeomFromText('MULTIPOLYGON(((4459937.140399999 5793343.508199999,4459988.417399999 5793315.3066,4460024.5005 5793283.8789,4460042.689799999 5793269.120999999,4460108.7668 5793198.448599999,4460079.310399999 5793178.2335,4460125.760599999 5793125.980699999,4460159.6544 5793151.278999999,4460190.5257 5793122.5876,4460074.2757 5793048.5128,4459935.9587 5792945.954299999,4459720.4221 5792998.493599999,4459739.955099999 5793058.9699,4459750.3749 5793079.349099999,4459764.5733 5793113.562799999,4459768.5831 5793156.639399999,4459793.147099999 5793204.6563,4459810.1714 5793227.1629,4459937.140399999 5793343.508199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (104,104,90486517.0,'NULL','industrial',2685.25274341,227989.413732, ST_GeomFromText('MULTIPOLYGON(((4459724.2752 5793468.735099999,4459702.1452 5793478.0292,4459684.707 5793485.9164,4459555.2559 5793620.396999999,4459539.512 5793641.702199999,4459437.652099999 5793839.377599999,4459417.688299999 5793871.9681,4459574.523799999 5794058.9655,4459884.179299999 5793862.082699999,4460121.450699999 5793762.6378,4460337.1743 5793673.3143,4460345.6491 5793561.512,4460010.3552 5793558.7726,4460013.154199999 5793684.4943,4459863.4434 5793762.1675,4459724.2752 5793468.735099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (105,105,90486519.0,'NULL','farm',1658.73435222,94147.1133298, ST_GeomFromText('MULTIPOLYGON(((4459766.972199999 5793445.9425,4459937.140399999 5793343.508199999,4459810.1714 5793227.1629,4459759.323099999 5793188.128599999,4459745.225999999 5793166.332699999,4459739.897099999 5793141.527699999,4459716.774199999 5793000.7155,4459409.773299999 5793077.016,4459606.7959 5793255.8617,4459617.851599999 5793263.8056,4459688.5332 5793219.396099999,4459597.6506 5793301.2267,4459731.727599999 5793397.300499999,4459731.0865 5793408.255499999,4459766.972199999 5793445.9425)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (106,106,90486523.0,'NULL','farm',1936.79524397,180699.713204, ST_GeomFromText('MULTIPOLYGON(((4459609.147199999 5792719.092,4459518.6769 5792422.9308,4459570.501299999 5792384.783399999,4459422.8004 5792243.0457,4459314.5981 5792269.651399999,4459307.2229 5792331.7386,4459299.4204 5792397.4569,4459285.053899999 5792518.3789,4459164.62 5792579.2846,4459102.5443 5792624.6652,4459102.3282 5792686.838199999,4459084.416699999 5792863.763199999,4459609.147199999 5792719.092)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (107,107,90486526.0,'NULL','farm',3960.81850406,629588.127249, ST_GeomFromText('MULTIPOLYGON(((4458934.4192 5794045.927999999,4458960.2898 5794074.9348,4458990.6281 5794112.662299999,4459011.9999 5794129.288,4459033.0447 5794136.146299999,4459055.208899999 5794119.9384,4459065.4873 5794117.393999999,4459109.5206 5794084.7363,4459206.353099999 5794164.935499999,4459241.302199999 5794140.532999999,4459247.2001 5794145.603099999,4459266.976499999 5794189.0501,4459279.5071 5794191.461699999,4459289.442699999 5794187.907899999,4459331.198099999 5794030.9951,4459339.2598 5794004.5558,4459402.3059 5793897.2323,4459417.688299999 5793871.9681,4459437.652099999 5793839.377599999,4459539.512 5793641.702199999,4459555.2559 5793620.396999999,4459684.707 5793485.9164,4459702.1452 5793478.0292,4459700.7461 5793459.646299999,4459574.5266 5793340.129499999,4459538.558699999 5793330.197399999,4459506.9686 5793318.037499999,4459286.9977 5793198.573699999,4459149.4341 5793125.920199999,4459109.798 5793116.0215,4459108.1281 5793137.8014,4459101.502199999 5793175.267999999,4459060.927099999 5793317.328199999,4459014.264299999 5793519.3516,4459010.684399999 5793528.873299999,4459004.869599999 5793534.763699999,4458969.7483 5793537.981799999,4458910.9638 5793548.162599999,4458599.1407 5793635.782199999,4458511.291699999 5793801.100199999,4458556.1046 5793817.5272,4458527.405 5793888.6303,4458650.0535 5793930.7005,4458694.6912 5793839.0119,4458758.6364 5793866.965099999,4458728.205099999 5793905.933,4458712.2197 5793920.6774,4458683.2192 5793955.983799999,4458716.421299999 5793985.662499999,4458850.144899999 5794126.249099999,4458934.4192 5794045.927999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (108,108,90486538.0,'NULL','farm',2837.86739998,180885.223103, ST_GeomFromText('MULTIPOLYGON(((4461790.135099999 5793169.817099999,4461175.958499999 5792745.0051,4461124.9198 5792681.844499999,4461073.909599999 5792621.5996,4461064.1731 5792594.6469,4461057.7503 5792523.824699999,4461031.4532 5792532.800599999,4461052.3424 5792673.647199999,4461059.3332 5792724.7353,4461058.821499999 5792752.5032,4461058.2695 5792775.163699999,4461070.301099999 5792908.0347,4461087.948699999 5793009.459,4461097.4945 5793012.2993,4461107.6615 5793001.2584,4461137.8969 5793028.0611,4461121.976099999 5793052.2891,4461222.302099999 5793143.5609,4461302.150399999 5793051.6094,4461434.7966 5793155.039999999,4461506.411899999 5793228.269899999,4461480.2942 5793259.887099999,4461413.1595 5793198.3179,4461348.457499999 5793259.458799999,4461390.5015 5793297.8548,4461402.244599999 5793300.6785,4461418.348399999 5793299.8295,4461653.5777 5793222.0181,4461790.135099999 5793169.817099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (109,109,90486547.0,'NULL','farm',1320.63121645,67597.3343552, ST_GeomFromText('MULTIPOLYGON(((4461055.627 5793740.9538,4461561.041799999 5793471.854499999,4461535.246 5793450.8679,4461516.144999999 5793443.7057,4461417.199799999 5793434.2508,4461401.769899999 5793427.805999999,4461389.9186 5793411.095599999,4461386.1743 5793400.164,4461123.9521 5793489.150299999,4461120.4247 5793506.715399999,4461116.6842 5793590.0252,4461107.519899999 5793634.653,4461095.2827 5793661.7454,4461078.724899999 5793698.397199999,4461052.6067 5793729.282299999,4461055.627 5793740.9538)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (110,110,90486553.0,'NULL','farm',1169.62036416,84395.580571, ST_GeomFromText('MULTIPOLYGON(((4459322.678799999 5792817.6302,4459378.2833 5793077.2747,4459687.1336 5792997.596599999,4459632.926599999 5792738.3046,4459322.678799999 5792817.6302)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (111,111,90501870.0,'NULL','farm',1787.82056141,189278.740596, ST_GeomFromText('MULTIPOLYGON(((4455489.337399999 5797108.3868,4455513.3014 5797120.556199999,4455565.8366 5797138.4331,4455769.0223 5797177.9042,4455796.2992 5797195.264399999,4455832.9954 5796733.7913,4455826.380099999 5796730.2005,4455828.293999999 5796617.0227,4455724.3359 5796614.303999999,4455709.709999999 5796615.892899999,4455698.0765 5796624.0317,4455405.101099999 5796844.9568,4455321.6549 5796924.5533,4455309.070399999 5796940.5247,4455469.6315 5797097.158299999,4455489.337399999 5797108.3868)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (112,112,90501879.0,'NULL','farm',1951.62692668,146937.817464, ST_GeomFromText('MULTIPOLYGON(((4455827.949699999 5797314.9298,4455805.710099999 5797241.472599999,4455782.729799999 5797214.848799999,4455740.4791 5797189.7332,4455516.4938 5797148.5589,4455474.337 5797136.3421,4455466.2224 5797129.849799999,4455458.0618 5797117.504499999,4455330.278599999 5796987.994,4455248.211699999 5796977.052999999,4455052.813299999 5797139.428099999,4455007.9142 5797190.9482,4455189.485399999 5797199.512,4455204.248399999 5797213.243599999,4455216.7291 5797217.514699999,4455347.4654 5797269.6224,4455337.432199999 5797293.0709,4455339.076899999 5797312.7638,4455450.806699999 5797367.961699999,4455827.949699999 5797314.9298)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (113,113,90501880.0,'NULL','farm',1032.40851706,64593.7193745, ST_GeomFromText('MULTIPOLYGON(((4454988.69 5797570.700999999,4454902.6047 5797279.498099999,4454892.320199999 5797275.2188,4454702.430599999 5797416.191999999,4454784.9625 5797660.942299999,4454988.69 5797570.700999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (114,114,90501881.0,'NULL','residential',1358.73703646,69138.6343123, ST_GeomFromText('MULTIPOLYGON(((4457515.451799999 5794758.0161,4457046.3962 5794786.609799999,4457047.158999999 5794824.104299999,4457196.869599999 5794825.141499999,4457179.4802 5794918.744599999,4457220.3572 5794924.9559,4457209.3463 5794972.634299999,4457335.642799999 5794993.9534,4457486.0743 5794966.794999999,4457481.2861 5794824.376499999,4457507.817499999 5794821.755699999,4457518.6776 5794795.0555,4457515.451799999 5794758.0161)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (115,115,90501884.0,'NULL','industrial',1001.75467288,38261.9749873, ST_GeomFromText('MULTIPOLYGON(((4457225.9993 5796501.7696,4457230.3108 5796514.3625,4457252.3947 5796535.7038,4457276.904199999 5796510.2089,4457307.8025 5796477.971,4457394.613499999 5796387.7079,4457454.543499999 5796325.4977,4457463.4035 5796316.518999999,4457526.4873 5796250.365599999,4457457.2165 5796187.566099999,4457177.6277 5796469.228,4457170.796099999 5796479.1577,4457225.9993 5796501.7696)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (116,116,90501888.0,'NULL','farm',3171.56142469,552591.177213, ST_GeomFromText('MULTIPOLYGON(((4456421.0449 5797185.569199999,4456417.0717 5797232.319599999,4456628.3617 5797087.6641,4456639.599299999 5796905.500399999,4456640.0475 5796872.6467,4456631.7548 5796844.977499999,4456491.720099999 5796568.7781,4456460.415699999 5796504.8122,4456456.6047 5796487.319299999,4456453.375599999 5796453.0402,4456450.294499999 5796435.540799999,4456444.318699999 5796422.4514,4456426.617399999 5796407.273199999,4456408.999699999 5796401.5866,4456390.735899999 5796405.3979,4456367.361999999 5796410.7232,4456343.955799999 5796412.3879,4456323.4632 5796412.569199999,4456300.088899999 5796418.6182,4455888.2827 5796531.791099999,4455877.3073 5796614.3922,4455902.211699999 5796616.3618,4455923.4594 5796619.0876,4455927.937099999 5796628.539799999,4455918.479799999 5796635.189799999,4455866.5207 5796635.653999999,4455846.147699999 5796731.481399999,4455832.709599999 5796783.435799999,4455808.445 5797178.196499999,4455813.6211 5797210.054199999,4455851.78 5797316.174399999,4455975.5952 5797293.903,4455964.021599999 5797227.5831,4456051.6879 5797210.0096,4456086.097199999 5797211.8956,4456127.0952 5797213.7232,4456129.814 5797189.606899999,4456134.082899999 5797176.426799999,4456150.1737 5797174.825999999,4456421.0449 5797185.569199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (117,117,90501899.0,'NULL','residential',1213.69211844,37010.6796182, ST_GeomFromText('MULTIPOLYGON(((4458107.181599999 5795458.0929,4458100.553399999 5795453.7759,4458018.302199999 5795509.969299999,4457963.0092 5795550.600299999,4457895.478299999 5795614.7049,4457851.2279 5795662.554099999,4457733.940899999 5795815.4417,4457766.4188 5795846.5557,4457751.3912 5795886.8449,4457777.2344 5795912.907999999,4458107.181599999 5795458.0929)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (118,118,90501901.0,'NULL','farm',1337.4476902,102632.235098, ST_GeomFromText('MULTIPOLYGON(((4455000.366899999 5797567.678999999,4455200.1244 5797484.8384,4455230.7242 5797469.960699999,4455274.401899999 5797444.014799999,4455319.8353 5797419.077099999,4455417.2005 5797374.1073,4455330.358199999 5797320.142699999,4455178.145499999 5797240.499399999,4455124.5869 5797225.651599999,4455057.1473 5797213.122999999,4455016.1222 5797208.389,4454978.1429 5797216.7697,4454935.884399999 5797237.5864,4454919.1911 5797253.0733,4454913.4724 5797267.7255,4454912.132799999 5797280.88,4455000.366899999 5797567.678999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (119,119,90503684.0,'NULL','farmland',2283.99468021,224334.813244, ST_GeomFromText('MULTIPOLYGON(((4455331.803299999 5795720.021099999,4455327.9841 5795843.921499999,4455808.331 5795776.804099999,4455809.109299999 5795767.7056,4455956.4389 5795803.222899999,4455981.3864 5795809.577099999,4455969.528699999 5795793.614,4455936.947999999 5795751.5515,4455913.8907 5795710.861999999,4455895.1878 5795665.760399999,4455883.055599999 5795619.1312,4455879.0332 5795578.2718,4455875.3687 5795496.525,4455833.5152 5795482.2881,4455567.0093 5795398.514699999,4455559.986399999 5795520.462799999,4455361.489 5795420.8102,4455340.911799999 5795412.1049,4455247.2768 5795420.386099999,4455238.535299999 5795667.284299999,4455251.815999999 5795678.8484,4455262.2028 5795694.0887,4455268.9457 5795710.8197,4455331.803299999 5795720.021099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (120,120,90503685.0,'NULL','farm',880.838649935,25944.1146186, ST_GeomFromText('MULTIPOLYGON(((4455262.0844 5795034.689099999,4455277.303299999 5795098.0921,4455594.076899999 5795070.4075,4455642.2966 5795059.0131,4455543.686999999 5795003.669999999,4455529.056699999 5795004.525,4455506.433299999 5795012.763199999,4455491.848899999 5795019.4712,4455469.1664 5795021.1334,4455451.588899999 5795020.5686,4455417.8744 5795016.488399999,4455392.9203 5794996.3383,4455254.968799999 5794999.511199999,4455262.0844 5795034.689099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (121,121,90503686.0,'NULL','farm',3181.76767193,227286.500756, ST_GeomFromText('MULTIPOLYGON(((4454645.136199999 5794824.142999999,4454571.1714 5794822.6304,4454409.4625 5794834.346899999,4454388.130199999 5794842.6117,4454380.280199999 5794865.318499999,4454375.218899999 5794920.270899999,4454379.1013 5794975.6081,4454402.639299999 5795089.541999999,4454556.7038 5795160.176,4454598.4483 5795081.6512,4454538.0646 5795044.2267,4454526.997899999 5795034.8364,4454390.9073 5794965.250199999,4454392.300099999 5794957.9262,4454524.672899999 5795020.9811,4454535.611899999 5795016.495999999,4454537.8672 5794942.707599999,4454544.7926 5794900.290699999,4454666.488599999 5794913.9392,4454674.0766 5794945.840299999,4454567.676099999 5795159.3406,4455266.330799999 5795098.925899999,4455208.6715 5794876.6995,4455122.081899999 5794855.5744,4455043.616899999 5794842.411299999,4454645.136199999 5794824.142999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (122,122,90503688.0,'NULL','farm',1443.66323809,128344.673178, ST_GeomFromText('MULTIPOLYGON(((4456516.057 5796560.5404,4456645.406299999 5796816.3811,4456659.0459 5796869.5532,4456661.530799999 5796902.3923,4456671.7761 5796902.3024,4456753.8234 5796743.888299999,4456810.1398 5796762.067999999,4456887.7911 5796579.9143,4456826.2664 5796491.3726,4456788.548899999 5796446.4341,4456748.672199999 5796406.6335,4456733.2131 5796396.5424,4456595.1748 5796347.377699999,4456586.407499999 5796349.646999999,4456576.994099999 5796360.6797,4456571.2434 5796373.1491,4456564.5855 5796447.6761,4456559.6616 5796470.3537,4456516.057 5796560.5404)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (123,123,90503689.0,'NULL','farm',449.304383402,9911.65407453, ST_GeomFromText('MULTIPOLYGON(((4456509.8359 5796547.452999999,4456527.8678 5796517.359999999,4456551.521599999 5796460.933199999,4456556.4649 5796440.447599999,4456565.216799999 5796353.4834,4456533.049499999 5796358.1509,4456506.8836 5796378.8234,4456485.336 5796425.7397,4456481.9884 5796460.8112,4456486.684 5796495.0885,4456509.8359 5796547.452999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (124,124,90503691.0,'NULL','farm',2682.5803287,274710.982011, ST_GeomFromText('MULTIPOLYGON(((4454123.3464 5794379.767799999,4454195.0098 5794685.1456,4454276.2383 5794680.0086,4454425.585599999 5794677.1707,4454563.986499999 5794678.087999999,4454673.117899999 5794681.458799999,4455173.5574 5794718.521999999,4455098.987399999 5794409.5185,4455067.505699999 5794409.8047,4455043.4466 5794420.984699999,4455022.4347 5794446.002499999,4455011.507299999 5794451.944099999,4454999.052799999 5794451.3343,4454986.565 5794447.063599999,4454905.362399999 5794375.4945,4454862.6195 5794345.2049,4454837.656499999 5794338.133099999,4454814.9176 5794333.956599999,4454784.172399999 5794334.9612,4454757.868999999 5794341.778599999,4454723.593 5794356.7037,4454693.7591 5794377.4305,4454636.242399999 5794413.745899999,4454615.848799999 5794425.617599999,4454604.7273 5794410.385399999,4454528.686499999 5794422.769099999,4454476.764499999 5794430.547299999,4454426.9528 5794428.091,4454386.647599999 5794424.812999999,4454334.6447 5794423.8245,4454279.741399999 5794425.0667,4454205.655399999 5794411.141799999,4454160.832899999 5794394.7653,4454123.3464 5794379.767799999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (125,125,90503693.0,'NULL','farm',3299.65983289,511523.568905, ST_GeomFromText('MULTIPOLYGON(((4455528.8091 5796278.014799999,4455572.842799999 5796112.8461,4455591.8311 5796041.611899999,4455502.382899999 5796025.625,4455469.451299999 5796026.645199999,4455429.2258 5796030.658099999,4455371.5584 5796048.7056,4455308.077499999 5796071.190799999,4455237.376199999 5796104.681199999,4454766.7849 5796388.684,4455254.625 5796882.3398,4455282.633899999 5796907.8363,4455533.3069 5796696.320699999,4455623.369699999 5796618.8605,4455676.461299999 5796581.149199999,4455725.9956 5796554.420399999,4455770.4725 5796535.7718,4455820.802899999 5796516.336799999,4455850.628499999 5796495.6279,4455866.655799999 5796487.450099999,4455890.8359 5796244.0985,4455890.371399999 5796235.634199999,4455790.5069 5796239.153599999,4455771.443599999 5796316.719599999,4455528.8091 5796278.014799999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (126,126,90503694.0,'NULL','farm',1188.38799769,74173.190651, ST_GeomFromText('MULTIPOLYGON(((4454009.894299999 5794778.1598,4454207.667999999 5794786.5491,4454113.1501 5794385.7047,4453941.013799999 5794379.271999999,4453954.1222 5794450.7364,4453968.7246 5794524.368,4453977.6347 5794616.313799999,4453984.8868 5794687.0984,4453996.4451 5794749.073999999,4454009.894299999 5794778.1598)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (127,127,90503695.0,'NULL','farm',4019.27620258,708552.279954, ST_GeomFromText('MULTIPOLYGON(((4453773.693199999 5795982.5163,4453600.629999999 5796652.057299999,4453676.058 5796733.841399999,4453714.5113 5796776.557499999,4453670.6845 5796941.2301,4453750.586699999 5796955.0809,4453777.809799999 5796970.160399999,4453794.6578 5796972.1949,4453850.944799999 5796964.3683,4454005.1911 5796866.559699999,4454027.982699999 5796799.1784,4454176.2312 5796764.2267,4454195.436999999 5796704.1795,4454322.987999999 5796725.632099999,4454446.232499999 5796755.8855,4454645.4797 5796774.4931,4454654.6524 5796657.597799999,4454658.9851 5796650.981399999,4454667.751 5796648.708599999,4454913.2876 5796686.621099999,4454938.7925 5796593.6695,4454550.9071 5796200.766599999,4454539.9977 5796191.13,4454449.127799999 5796226.764799999,4454434.2105 5796230.129599999,4454421.241799999 5796229.503699999,4454195.1567 5796200.4041,4454167.295599999 5796195.5437,4454093.099999999 5796167.032999999,4454062.8721 5796143.945199999,4453911.209699999 5796050.4362,4453798.723199999 5795998.1841,4453773.693199999 5795982.5163)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (128,128,90503696.0,'NULL','farmland',3203.27692928,331185.121847, ST_GeomFromText('MULTIPOLYGON(((4455567.0093 5795398.514699999,4455832.015599999 5795478.651599999,4455873.1325 5795492.160599999,4455873.386599999 5795438.120899999,4455869.924499999 5795378.272099999,4455861.422399999 5795328.6839,4455841.8831 5795271.8945,4455817.2839 5795223.1848,4455788.3233 5795177.4743,4455757.960099999 5795139.042999999,4455737.350999999 5795126.8089,4455721.227699999 5795124.761199999,4455705.1765 5795130.7473,4455645.1995 5795218.884999999,4455609.210699999 5795206.066199999,4455580.3814 5795207.0598,4455600.8195 5795087.139,4455446.4456 5795099.490199999,4454959.9493 5795141.8713,4454578.789499999 5795173.1151,4454631.025299999 5795201.078199999,4454684.178799999 5795248.7968,4454726.292 5795290.7638,4454750.7411 5795321.9429,4454822.1632 5795446.1677,4454829.537899999 5795451.942399999,4454839.075899999 5795454.7707,4454851.5213 5795454.656899999,4455247.2768 5795420.386099999,4455541.368499999 5795396.5533,4455567.0093 5795398.514699999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (129,129,90503699.0,'NULL','farm',1238.92240576,42036.2952455, ST_GeomFromText('MULTIPOLYGON(((4455805.097599999 5796069.632699999,4455591.8311 5796041.611899999,4455572.842799999 5796112.8461,4455633.5476 5796122.282099999,4455636.9812 5796097.424599999,4455804.088299999 5796120.752599999,4455813.742499999 5796136.0006,4455835.044499999 5796144.5677,4455892.914699999 5796149.169299999,4455901.8251 5796081.175599999,4456009.385999999 5796076.566099999,4456008.319199999 5795956.8274,4455815.8507 5795962.930299999,4455805.097599999 5796069.632699999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (130,130,90503704.0,'NULL','farm',1949.1698515,209601.278759, ST_GeomFromText('MULTIPOLYGON(((4455866.655799999 5796487.450099999,4455927.480899999 5796495.664499999,4455947.953599999 5796493.289599999,4456452.685499999 5796333.7989,4456470.749599999 5796322.789799999,4456487.8798 5796298.680299999,4456445.8799 5796267.6475,4456466.8009 5796232.421,4456456.270899999 5796200.387399999,4456132.869699999 5795968.8614,4456113.0339 5795961.014399999,4456093.224299999 5795955.3483,4456008.319199999 5795956.8274,4456009.385999999 5796076.566099999,4455901.8251 5796081.175599999,4455892.914699999 5796149.169299999,4455889.0821 5796211.9876,4455890.371399999 5796235.634199999,4455890.8359 5796244.0985,4455866.655799999 5796487.450099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (131,131,90507850.0,'NULL','farm',2408.47520804,221014.927976, ST_GeomFromText('MULTIPOLYGON(((4450795.2669 5795637.7805,4450547.274299999 5795721.893799999,4450586.560899999 5795814.354,4450647.9462 5795803.7025,4450670.0722 5795823.990599999,4450729.1823 5795804.8165,4450799.2351 5795767.606599999,4450850.115699999 5795727.706199999,4450924.584499999 5795633.422399999,4450982.7207 5795644.3627,4451067.672 5795547.762599999,4451076.024899999 5795527.1706,4451080.165699999 5795501.568299999,4451120.797799999 5795168.879799999,4450637.5437 5795165.6512,4450620.0251 5795167.6179,4450603.469499999 5795181.2596,4450594.8485 5795194.0208,4450584.951799999 5795210.9122,4450580.354 5795233.5817,4450582.608 5795254.9364,4450594.6341 5795271.5083,4450610.224299999 5795291.7058,4450645.7719 5795322.553799999,4450667.232599999 5795334.0907,4450676.813699999 5795362.8058,4450690.6239 5795385.2136,4450748.361899999 5795452.363399999,4450758.0546 5795470.450099999,4450795.2669 5795637.7805)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (132,132,90507851.0,'NULL','farmland',1848.6298773,193525.416107, ST_GeomFromText('MULTIPOLYGON(((4451884.258799999 5794775.038,4451969.2538 5794705.550499999,4452001.257799999 5794683.328199999,4452061.807599999 5794660.105799999,4452079.096499999 5794630.7156,4452109.691899999 5794539.124099999,4452017.6096 5794482.307299999,4452004.4813 5794487.553799999,4451988.524799999 5794503.777799999,4451857.4736 5794423.6399,4451778.112399999 5794395.2027,4451623.853799999 5794345.577099999,4451581.383899999 5794345.9931,4451521.426599999 5794355.349999999,4451454.268199999 5794376.451799999,4451399.9593 5794402.1019,4451423.5135 5794439.6168,4451479.8885 5794531.937999999,4451593.5307 5794689.1651,4451615.8025 5794697.070399999,4451699.956199999 5794796.5556,4451724.6719 5794778.052799999,4451763.228199999 5794827.3409,4451884.258799999 5794775.038)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (133,133,90507856.0,'NULL','farm',1949.30485361,221238.066065, ST_GeomFromText('MULTIPOLYGON(((4452777.330799999 5796053.126599999,4453119.6748 5796104.6258,4453343.8695 5795738.1359,4453257.8852 5795703.1611,4453260.5842 5795679.043299999,4453190.7969 5795653.4086,4453209.4039 5795608.697799999,4453160.2915 5795601.852199999,4452892.8059 5795496.3539,4452880.3886 5795499.3991,4452872.462799999 5795512.6169,4452864.641599999 5795536.794999999,4452791.2286 5795898.9253,4452814.7756 5795911.1081,4452777.330799999 5796053.126599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (134,134,90507863.0,'NULL','farm',2412.34587494,330153.348138, ST_GeomFromText('MULTIPOLYGON(((4452911.410799999 5796449.041099999,4452838.430599999 5796528.1797,4453244.432 5796755.337099999,4453253.115299999 5796745.8627,4453263.9526 5796731.160099999,4453278.3287 5796703.2817,4453282.5766 5796687.906999999,4453286.1292 5796676.923299999,4453291.871399999 5796664.4612,4453309.353799999 5796655.538,4453322.4916 5796651.7638,4453343.7269 5796653.0208,4453353.3256 5796661.687899999,4453529.843999999 5796756.3923,4453544.5032 5796758.446599999,4453559.0388 5796748.0942,4453673.421699999 5796301.6519,4453120.5296 5796117.759899999,4452911.410799999 5796449.041099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (135,135,90507876.0,'NULL','farm',1892.95578965,215228.561204, ST_GeomFromText('MULTIPOLYGON(((4453127.029699999 5796108.206,4453674.7925 5796291.412399999,4453679.915699999 5796291.364299999,4453687.2015 5796288.3804,4453766.2141 5795970.746099999,4453397.4976 5795680.664899999,4453127.029699999 5796108.206)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (136,136,90507878.0,'NULL','farm',1984.81746768,209072.339125, ST_GeomFromText('MULTIPOLYGON(((4451855.9548 5794950.592599999,4452214.0425 5795031.844699999,4452297.6725 5795048.5631,4452336.4719 5795048.188599999,4452396.4433 5795041.0335,4452503.975499999 5795031.229399999,4452589.910299999 5794830.298699999,4452536.2613 5794809.626099999,4452550.519799999 5794769.3167,4452522.6209 5794761.5503,4452382.4334 5794717.5416,4452194.217799999 5794596.038,4452160.032899999 5794568.682199999,4452125.959999999 5794553.6333,4452063.565499999 5794690.757699999,4452031.766699999 5794733.431099999,4451986.1112 5794782.8048,4451922.8846 5794831.6267,4451903.2504 5794844.9713,4451928.435899999 5794875.395099999,4451891.365299999 5794902.7751,4451875.282599999 5794905.8584,4451855.9548 5794950.592599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (137,137,90507884.0,'NULL','farm',1497.14833204,111289.463706, ST_GeomFromText('MULTIPOLYGON(((4451376.703599999 5795281.741499999,4451288.2955 5795300.139399999,4451187.370099999 5795311.3626,4451109.819099999 5795317.2486,4451081.1807 5795532.3943,4451228.101599999 5795583.5217,4451274.378499999 5795524.6422,4451344.246 5795483.057399999,4451447.076899999 5795480.665599999,4451554.614299999 5795434.251299999,4451589.9144 5795435.696799999,4451612.990299999 5795287.800499999,4451620.1173 5795242.105399999,4451549.1347 5795245.7279,4451476.0338 5795257.3956,4451425.613499999 5795267.3835,4451376.703599999 5795281.741499999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (138,138,90507886.0,'NULL','residential',3310.17206768,390499.811806, ST_GeomFromText('MULTIPOLYGON(((4453927.353699999 5795431.8332,4454142.738499999 5795472.3154,4454183.574 5795365.941899999,4454201.8671 5795365.037799999,4454212.675499999 5795267.0888,4454286.620199999 5795267.1271,4454295.0168 5795225.4306,4454335.2953 5795226.515799999,4454337.365399999 5795197.252199999,4454278.8267 5795200.720499999,4454305.0645 5795109.183299999,4454402.639299999 5795089.541999999,4454379.1013 5794975.6081,4454375.218899999 5794920.270899999,4454380.280199999 5794865.318499999,4454388.130199999 5794842.6117,4454409.4625 5794834.346899999,4454412.2547 5794824.094499999,4454316.1479 5794803.071299999,4454012.1934 5794793.472899999,4453987.4899 5794814.156199999,4453874.750799999 5794815.942099999,4453881.3216 5794892.563999999,4453844.090499999 5794904.5962,4453796.200299999 5794872.1829,4453775.707999999 5794873.097899999,4453775.3947 5794918.380799999,4453741.637 5794909.939099999,4453694.821 5794992.9033,4453719.565499999 5795054.754699999,4453530.1863 5795018.5861,4453515.8832 5795118.0052,4453693.413499999 5795155.0521,4453682.75 5795171.3322,4453663.098299999 5795201.3397,4453671.3322 5795209.0521,4453680.0893 5795217.249299999,4453611.2328 5795337.6556,4453901.6374 5795421.846499999,4453889.068599999 5795486.9516,4453919.137699999 5795492.513199999,4453927.353699999 5795431.8332)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (139,139,90507891.0,'NULL','farm',1880.02825646,186936.572744, ST_GeomFromText('MULTIPOLYGON(((4453797.1803 5795916.4184,4453826.660299999 5795937.319399999,4453839.882299999 5795942.314699999,4454441.6047 5796020.698499999,4454177.3864 5795552.182499999,4453925.216799999 5795516.5598,4453886.6101 5795772.4646,4453881.6227 5795787.1223,4453872.2346 5795801.0755,4453799.233699999 5795901.064799999,4453797.1803 5795916.4184)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (140,140,90507892.0,'NULL','farm',1581.70235774,158479.126466, ST_GeomFromText('MULTIPOLYGON(((4453452.2708 5795592.526,4453473.223799999 5795626.346999999,4453775.016099999 5795895.705099999,4453859.9423 5795781.694,4453875.2914 5795736.0592,4453919.137699999 5795492.513199999,4453889.068599999 5795486.9516,4453901.6374 5795421.846499999,4453611.2328 5795337.6556,4453452.2708 5795592.526)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (141,141,90507896.0,'NULL','farmland',871.635513832,31694.4811539, ST_GeomFromText('MULTIPOLYGON(((4450617.542299999 5795142.482,4450989.137099999 5795149.474999999,4450985.840599999 5795137.7452,4450972.5629 5795127.661399999,4450937.189299999 5795104.6435,4450750.4379 5795026.156799999,4450700.477099999 5795009.128399999,4450678.518299999 5795009.347599999,4450636.608799999 5795065.273399999,4450615.7686 5795111.830499999,4450617.542299999 5795142.482)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (142,142,90507900.0,'NULL','farm',4578.82864594,414373.829547, ST_GeomFromText('MULTIPOLYGON(((4452950.4999 5795199.051599999,4452976.376 5795209.721799999,4453008.2986 5795312.241399999,4453192.964499999 5795435.7453,4453161.842199999 5795487.6412,4453229.6205 5795501.1872,4453306.6686 5795520.176999999,4453440.438799999 5795580.218599999,4453671.3322 5795209.0521,4453663.098299999 5795201.3397,4453682.75 5795171.3322,4453362.746799999 5795101.9221,4453043.6715 5795039.9461,4452820.198599999 5795023.091099999,4452787.108799999 5795023.229199999,4452330.077399999 5795067.969299999,4452305.1776 5795067.475199999,4452268.5261 5795062.7214,4452012.4462 5795006.0457,4451815.0146 5794957.568499999,4451830.299399999 5795023.1531,4451831.9802 5795045.048,4451820.6842 5795088.2462,4451845.7263 5795103.3365,4451889.040699999 5795115.333399999,4451917.6545 5795121.6203,4451931.660299999 5795130.9874,4451942.0371 5795144.028699999,4451953.916799999 5795161.439899999,4451969.417999999 5795174.4315,4452019.4506 5795199.5064,4452072.346199999 5795217.977399999,4452101.6823 5795223.535099999,4452130.982699999 5795224.72,4452165.372299999 5795222.917899999,4452193.878999999 5795217.534099999,4452206.927899999 5795204.265499999,4452219.345599999 5795201.218699999,4452295.7218 5795225.318299999,4452311.909699999 5795233.9198,4452338.599999999 5795268.7157,4452359.2521 5795283.850999999,4452376.8437 5795286.607999999,4452405.364199999 5795282.6831,4452440.3638 5795267.734699999,4452449.7702 5795256.694099999,4452457.2302 5795118.5895,4452540.9632 5795146.272099999,4452598.195799999 5795159.5993,4452920.696899999 5795196.676,4452950.4999 5795199.051599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (143,144,91243154.0,'NULL','farmland',8969.34701135,1387095.08715, ST_GeomFromText('MULTIPOLYGON(((4458490.6511 5792064.883099999,4458608.4923 5791859.287599999,4458750.825799999 5791638.278999999,4458839.2176 5791694.8284,4458963.5734 5791463.3377,4458480.579099999 5791284.9622,4458382.914099999 5791520.3913,4458323.4511 5791506.270099999,4458291.6205 5791554.777699999,4458282.1133 5791557.0501,4458265.1626 5791544.763299999,4458247.4312 5791527.3756,4458213.436099999 5791492.587799999,4458143.3563 5791436.895899999,4457804.6226 5791705.4745,4457254.8092 5792138.0194,4457399.9308 5792315.791999999,4457409.523799999 5792324.478099999,4457432.962799999 5792323.552899999,4457463.6705 5792316.711999999,4457502.2965 5792293.7235,4457527.020999999 5792272.323499999,4457540.129499999 5792263.442099999,4457563.467899999 5792251.546299999,4457613.8201 5792313.9535,4457632.936999999 5792322.558299999,4457781.522599999 5792309.391499999,4457910.9269 5792091.4283,4457999.2344 5791903.128399999,4458125.523299999 5791951.876599999,4458024.1988 5792090.465199999,4458008.926599999 5792141.404699999,4457999.8715 5792190.310699999,4458281.821299999 5792360.8167,4458223.648799999 5792499.037399999,4458064.8561 5792456.137599999,4457976.815499999 5792439.592599999,4458016.269299999 5792638.524,4458395.387799999 5792608.945399999,4458433.313599999 5792629.134899999,4458701.3865 5792650.3343,4458971.423999999 5792642.866499999,4458978.0519 5792624.584,4459014.5455 5792460.824599999,4459077.722099999 5792601.8694,4459164.62 5792579.2846,4459285.053899999 5792518.3789,4459299.4204 5792397.4569,4459204.4115 5792383.3177,4459213.777999999 5792317.786599999,4459289.3704 5792327.044999999,4459307.2229 5792331.7386,4459314.5981 5792269.651399999,4459314.7379 5792215.290899999,4459282.610799999 5792157.100899999,4459054.407999999 5792129.753,4459063.504599999 5791954.291999999,4458871.360199999 5791895.095399999,4458825.868599999 5792132.819499999,4458653.4265 5792046.571399999,4458599.3386 5792166.281099999,4458490.6511 5792064.883099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (144,145,91243157.0,'NULL','farm',1749.09125974,101830.511363, ST_GeomFromText('MULTIPOLYGON(((4458742.203999999 5791202.385199999,4458772.5739 5791122.8573,4458731.5805 5791096.3701,4458717.3759 5791125.1094,4458719.6786 5791137.519899999,4458719.745699999 5791145.5537,4458713.179399999 5791149.2695,4458579.9362 5791075.104,4458385.6561 5791236.7977,4459003.865 5791465.8299,4459034.583999999 5791404.2499,4459012.2702 5791399.761199999,4459034.7839 5791357.478099999,4459025.9642 5791354.6245,4459034.036799999 5791338.188699999,4459005.2569 5791331.4166,4458991.5787 5791321.626299999,4458829.0843 5791252.8156,4458742.203999999 5791202.385199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (145,146,91243160.0,'NULL','farm',4641.59020815,1035131.55237, ST_GeomFromText('MULTIPOLYGON(((4457025.439899999 5792298.580299999,4457881.2136 5791627.683199999,4457288.002199999 5791146.027899999,4457019.3771 5790926.153999999,4457003.068799999 5790905.0972,4457001.5438 5790897.810599999,4456718.144799999 5790751.169099999,4456672.291 5790786.6567,4456648.9153 5790795.6303,4456616.679899999 5790795.913,4456582.9566 5790794.751099999,4456561.7163 5790795.6609,4456530.1732 5790791.5537,4456507.445399999 5790790.2957,4456481.826299999 5790793.447699999,4456435.204699999 5790825.283299999,4456710.8857 5791512.8134,4456719.885599999 5791536.125499999,4456753.143099999 5791736.804099999,4456764.391699999 5791766.6731,4456880.707899999 5791998.775499999,4456911.219899999 5791968.542099999,4456920.9609 5791994.0402,4456892.654299999 5792024.2432,4456953.775299999 5792144.2924,4456971.8835 5792120.744,4456981.338299999 5792112.627399999,4456991.5299 5792105.2277,4457019.753999999 5792149.560499999,4457023.5153 5792161.2232,4457022.892599999 5792173.647399999,4456989.586199999 5792218.5153,4457025.439899999 5792298.580299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (146,147,91243161.0,'NULL','farm',2894.97559959,321245.32489, ST_GeomFromText('MULTIPOLYGON(((4457889.933899999 5791618.840199999,4458142.5082 5791423.026599999,4458073.7833 5791354.171099999,4458063.4647 5791346.958799999,4458034.874499999 5791344.997999999,4458020.9259 5791342.200899999,4458012.718999999 5791324.721999999,4458000.033599999 5791297.7891,4457993.2514 5791275.1904,4457995.2889 5791256.177799999,4458021.7964 5791098.8054,4457996.548799999 5791059.560499999,4457871.711799999 5791027.728399999,4457833.586799999 5791025.1267,4457461.224299999 5791010.7781,4457442.9084 5791010.935699999,4457426.016099999 5791006.696699999,4457098.3058 5790902.077999999,4457082.9002 5790900.0194,4457038.2083 5790901.141899999,4457021.372899999 5790902.745899999,4457021.423799999 5790908.598699999,4457034.7383 5790923.1051,4457889.933899999 5791618.840199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (147,148,100237208.0,'NULL','meadow',971.434172587,51452.5178916, ST_GeomFromText('MULTIPOLYGON(((4458226.1567 5797692.8131,4458467.2701 5797692.8131,4458476.507399999 5797678.821299999,4458554.7339 5797583.2758,4458561.1507 5797562.790999999,4458555.8815 5797545.3087,4458482.4489 5797428.403899999,4458377.065 5797514.6984,4458300.765499999 5797578.115299999,4458196.1424 5797667.322899999,4458226.1567 5797692.8131)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (148,149,100237209.0,'NULL','meadow',472.445691183,12673.0695842, ST_GeomFromText('MULTIPOLYGON(((4458168.4674 5797596.027,4458175.803999999 5797598.156999999,4458188.2191 5797595.125099999,4458202.804999999 5797589.893899999,4458215.9259 5797583.217299999,4458228.611299999 5797588.7517,4458239.296199999 5797577.911699999,4458173.9106 5797461.6666,4458160.579699999 5797442.806399999,4458129.956199999 5797459.1237,4458076.8062 5797490.9669,4458087.929399999 5797507.6534,4458168.4674 5797596.027)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (149,150,100237212.0,'NULL','meadow',882.65032281,35864.8593482, ST_GeomFromText('MULTIPOLYGON(((4458787.199699999 5797291.535499999,4458727.3914 5797228.5283,4458486.086299999 5797426.192199999,4458561.003499999 5797545.265699999,4458584.8836 5797513.684499999,4458612.444899999 5797484.253599999,4458643.0241 5797465.7474,4458651.6802 5797450.3406,4458741.416299999 5797330.609899999,4458761.759399999 5797312.189999999,4458787.199699999 5797291.535499999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (150,151,100237217.0,'NULL','meadow',3449.35167708,191657.697247, ST_GeomFromText('MULTIPOLYGON(((4458173.9106 5797461.6666,4458239.296199999 5797577.911699999,4458228.611299999 5797588.7517,4458223.3298 5797594.104499999,4458213.147699999 5797601.490599999,4458197.8129 5797605.2704,4458182.54 5797616.3497,4458189.8797 5797639.778599999,4458236.927299999 5797601.033399999,4458501.413099999 5797383.243,4458985.319 5796990.6556,4459320.9104 5796715.612099999,4459441.077899999 5796617.8441,4459356.562099999 5796582.340199999,4459233.134499999 5796614.026399999,4459208.3222 5796622.989,4459192.270999999 5796629.6871,4459174.8507 5796647.357599999,4459093.7071 5796747.312499999,4459084.988699999 5796754.6958,4459065.3304 5796767.2664,4458950.949699999 5796854.9471,4458884.454199999 5796905.921099999,4458863.1571 5796922.2563,4458825.729899999 5796951.1782,4458763.4835 5796999.303099999,4458743.2319 5797014.951199999,4458707.541299999 5797042.546499999,4458692.277599999 5797055.0818,4458678.479899999 5797068.3394,4458653.7571 5797086.796199999,4458603.5443 5797120.8012,4458590.501899999 5797136.233699999,4458601.7459 5797168.265699999,4458173.9106 5797461.6666)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (151,152,100246406.0,'NULL','allotments',924.370585121,29253.3312766, ST_GeomFromText('MULTIPOLYGON(((4458659.8694 5796593.232999999,4458825.729899999 5796951.1782,4458863.1571 5796922.2563,4458884.454199999 5796905.921099999,4458734.0437 5796562.0997,4458659.8694 5796593.232999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (152,153,100246410.0,'NULL','meadow',307.391992846,3810.72504642, ST_GeomFromText('MULTIPOLYGON(((4457931.8273 5797043.989199999,4457842.405299999 5797121.401399999,4457879.6787 5797115.241,4457908.204499999 5797113.539899999,4457938.914099999 5797110.3626,4457958.6801 5797110.9175,4457931.8273 5797043.989199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (153,154,100246454.0,'NULL','allotments',338.311331252,3676.48648693, ST_GeomFromText('MULTIPOLYGON(((4458707.160799999 5796869.866599999,4458683.736999999 5796883.093399999,4458743.2319 5797014.951199999,4458763.4835 5796999.303099999,4458707.160799999 5796869.866599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (154,155,100246457.0,'NULL','meadow',881.526832509,27231.9313619, ST_GeomFromText('MULTIPOLYGON(((4458950.949699999 5796854.9471,4458796.99 5796535.879599999,4458734.0437 5796562.0997,4458884.454199999 5796905.921099999,4458950.949699999 5796854.9471)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (155,156,100246477.0,'NULL','farm',2458.34008685,372816.537248, ST_GeomFromText('MULTIPOLYGON(((4458160.579699999 5797442.806399999,4458173.9106 5797461.6666,4458601.7459 5797168.265699999,4458590.501899999 5797136.233699999,4458603.5443 5797120.8012,4458653.7571 5797086.796199999,4458678.479899999 5797068.3394,4458692.277599999 5797055.0818,4458707.541299999 5797042.546499999,4458743.2319 5797014.951199999,4458683.736999999 5796883.093399999,4458564.336299999 5796634.917899999,4458549.010599999 5796640.1654,4458504.4992 5796656.596999999,4458422.7114 5796678.4616,4458367.200699999 5796692.071499999,4458329.8863 5796697.8613,4457931.8273 5797043.989199999,4457958.6801 5797110.9175,4457978.6326 5797133.381799999,4458129.956199999 5797459.1237,4458160.579699999 5797442.806399999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (156,157,100246484.0,'NULL','meadow',1020.88169002,37628.5345846, ST_GeomFromText('MULTIPOLYGON(((4458707.160799999 5796869.866599999,4458763.4835 5796999.303099999,4458825.729899999 5796951.1782,4458659.8694 5796593.232999999,4458564.336299999 5796634.917899999,4458683.736999999 5796883.093399999,4458707.160799999 5796869.866599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (157,158,100246494.0,'NULL','farm',1389.96644835,117583.122945, ST_GeomFromText('MULTIPOLYGON(((4459817.9083 5796521.621999999,4460100.9751 5796769.7365,4460203.365 5796648.2839,4460288.7445 5796547.011499999,4460240.147199999 5796510.9033,4460258.978699999 5796486.6598,4460023.8174 5796279.7441,4459854.844299999 5796473.1378,4459817.9083 5796521.621999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (158,159,100246498.0,'NULL','farm',1851.80337458,122091.316043, ST_GeomFromText('MULTIPOLYGON(((4460231.5575 5796898.633999999,4460168.053999999 5796829.062699999,4460100.9751 5796769.7365,4459817.9083 5796521.621999999,4459726.760099999 5796653.050599999,4459741.5656 5796673.3717,4459796.451799999 5796762.715299999,4459825.7406 5796854.459899999,4459880.108 5796879.567299999,4460085.8934 5796986.674,4460228.187699999 5797116.199999999,4460281.8958 5797151.5324,4460302.4205 5797155.7517,4460278.705299999 5797118.708599999,4460277.0979 5797101.206299999,4460273.742899999 5797047.941899999,4460171.331199999 5796948.616399999,4460231.5575 5796898.633999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (159,160,100249727.0,'NULL','farm',1590.47049517,121368.273769, ST_GeomFromText('MULTIPOLYGON(((4459171.0038 5797692.8131,4459167.555599999 5797685.106399999,4459352.820399999 5797594.119699999,4459306.406399999 5797489.8998,4459336.6875 5797474.6498,4459323.278699999 5797445.783199999,4459239.971599999 5797265.1524,4459180.235899999 5797298.495699999,4459142.3655 5797320.708799999,4459124.9002 5797331.8033,4459112.5504 5797342.855499999,4459069.254099999 5797385.99,4458900.719999999 5797566.516799999,4458934.3157 5797646.5251,4458892.7997 5797669.504899999,4458846.131699999 5797688.867,4458831.594999999 5797692.8131,4459171.0038 5797692.8131)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (160,161,100249736.0,'NULL','farm',2078.67513169,158436.403328, ST_GeomFromText('MULTIPOLYGON(((4459702.0125 5797028.484899999,4459839.471199999 5797012.764699999,4459856.951999999 5797002.407099999,4459814.059299999 5796857.481599999,4459682.516999999 5796792.120799999,4459664.2224 5796792.2703,4459648.8721 5796794.576799999,4459622.653099999 5796810.859899999,4459604.502 5796828.5237,4459570.486299999 5796874.7937,4459561.8563 5796893.8486,4459553.268899999 5796917.276399999,4459538.5235 5796993.322899999,4459529.959499999 5797020.400499999,4459518.4824 5797048.2364,4459501.852099999 5797073.1992,4459471.3212 5797098.265,4459405.161999999 5797151.3658,4459332.3382 5797208.394899999,4459298.953399999 5797229.6239,4459239.971599999 5797265.1524,4459323.278699999 5797445.783199999,4459377.814299999 5797425.481899999,4459375.020299999 5797397.6183,4459397.574799999 5797385.7595,4459412.857099999 5797375.407299999,4459428.139499999 5797365.066199999,4459451.493999999 5797357.5744,4459444.013799999 5797337.9283,4459455.682599999 5797332.724799999,4459465.854899999 5797323.8724,4459476.7152 5797309.917899999,4459489.759899999 5797294.4877,4459575.862599999 5797263.847599999,4459639.389399999 5797245.8124,4459702.9812 5797236.524,4459744.570199999 5797221.584799999,4459735.4467 5797179.3287,4459752.2257 5797173.3497,4459702.0125 5797028.484899999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (161,162,100249745.0,'NULL','meadow',1314.9876144,48561.7086567, ST_GeomFromText('MULTIPOLYGON(((4458870.9801 5797509.823,4458878.322599999 5797512.6884,4458890.123399999 5797524.263299999,4458901.9614 5797539.498999999,4459089.0926 5797338.6655,4459111.577899999 5797314.387199999,4459099.577499999 5797278.721499999,4459097.2785 5797266.333,4459101.5076 5797246.590399999,4459089.587799999 5797238.7661,4459088.342299999 5797248.157199999,4459079.600499999 5797252.603,4459062.8036 5797257.1267,4459037.9592 5797260.982799999,4459007.309799999 5797272.1871,4458975.2927 5797293.6184,4458936.0175 5797323.1447,4458911.397599999 5797354.741499999,4458885.403699999 5797396.565199999,4458866.5694 5797420.0797,4458851.331 5797435.540999999,4458839.700299999 5797444.3957,4458824.498599999 5797464.23,4458819.4983 5797478.8716,4458805.792899999 5797503.077899999,4458790.573099999 5797520.7203,4458762.3178 5797554.5293,4458747.846499999 5797574.357799999,4458736.252999999 5797587.596799999,4458719.897199999 5797616.955499999,4458764.2125 5797693.9353,4458831.5864 5797612.350299999,4458828.520499999 5797595.5839,4458821.8288 5797583.232,4458819.523 5797570.1092,4458824.468399999 5797548.902599999,4458829.456399999 5797532.8034,4458835.9351 5797519.6073,4458851.957799999 5797510.716,4458870.9801 5797509.823)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (162,163,100249755.0,'NULL','meadow',759.524139278,33712.0823779, ST_GeomFromText('MULTIPOLYGON(((4459286.848299999 5797004.15,4459223.9128 5796827.279699999,4459051.609199999 5796965.946499999,4459106.1501 5797100.5537,4459149.8562 5797076.099899999,4459186.238699999 5797050.249199999,4459286.848299999 5797004.15)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (163,164,100249758.0,'NULL','meadow',1004.87527207,42236.1769854, ST_GeomFromText('MULTIPOLYGON(((4459092.224399999 5797098.4769,4459048.713299999 5796969.6205,4458727.3914 5797228.5283,4458787.199699999 5797291.535499999,4458857.882899999 5797255.1807,4458899.226099999 5797211.036699999,4458937.138799999 5797193.929099999,4458986.0809 5797183.3068,4458999.1675 5797172.248199999,4459031.070299999 5797136.9415,4459067.4276 5797108.174599999,4459092.224399999 5797098.4769)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (164,165,100249760.0,'NULL','farm',1186.68313159,59348.2154017, ST_GeomFromText('MULTIPOLYGON(((4459877.62 5797024.138699999,4459914.420099999 5797139.9035,4459996.148299999 5797110.040899999,4460005.685999999 5797113.6135,4460021.0947 5797118.607499999,4460099.6705 5797242.0698,4460219.426099999 5797119.1861,4460081.548899999 5796991.827899999,4459830.9523 5796865.3673,4459877.62 5797024.138699999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (165,166,100249765.0,'NULL','meadow',1280.8555113,88171.8040204, ST_GeomFromText('MULTIPOLYGON(((4459304.364099999 5796998.174599999,4459325.530799999 5796990.7002,4459337.1874 5796984.762,4459354.6491 5796972.1994,4459381.518099999 5796946.4286,4459408.3874 5796920.657899999,4459442.6412 5796903.5844,4459480.438199999 5796871.8822,4459511.761199999 5796853.375399999,4459545.967899999 5796830.471899999,4459572.9642 5796820.024199999,4459593.484899999 5796823.5061,4459643.516599999 5796766.1554,4459663.62 5796718.541799999,4459679.473799999 5796688.478299999,4459682.268899999 5796672.3868,4459678.427799999 5796649.784099999,4459673.1798 5796634.503799999,4459663.651899999 5796633.1239,4459612.4647 5796638.6501,4459529.767599999 5796640.050699999,4459469.6336 5796625.221,4459226.808899999 5796823.605799999,4459290.445 5796996.0972,4459304.364099999 5796998.174599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (166,167,100249768.0,'NULL','meadow',2679.33277913,142215.454281, ST_GeomFromText('MULTIPOLYGON(((4459111.577899999 5797314.387199999,4459127.5783 5797301.846999999,4459199.729399999 5797266.2083,4459264.5458 5797227.7156,4459374.4451 5797154.545199999,4459465.3842 5797088.821699999,4459485.707 5797067.489499999,4459500.163999999 5797046.194499999,4459513.1024 5797016.8888,4459530.791699999 5796943.0214,4459540.725599999 5796904.971599999,4459553.645899999 5796874.208399999,4459571.701 5796844.860899999,4459589.122 5796827.1918,4459563.520399999 5796828.8592,4459536.5661 5796844.4143,4459468.134399999 5796888.7752,4459391.769299999 5796947.0787,4459335.075199999 5796994.994799999,4459271.6133 5797020.344399999,4459206.7467 5797052.2608,4459169.6222 5797076.6597,4459123.7076 5797099.6739,4459077.781299999 5797121.219699999,4459043.6204 5797149.979399999,4459005.1166 5797183.871899999,4458978.135599999 5797195.7804,4458931.383799999 5797205.661299999,4458911.715599999 5797216.7749,4458882.6298 5797239.6402,4458857.882899999 5797255.1807,4458787.199699999 5797291.535499999,4458761.759399999 5797312.189999999,4458741.416299999 5797330.609899999,4458651.6802 5797450.3406,4458643.0241 5797465.7474,4458612.444899999 5797484.253599999,4458643.1648 5797482.5383,4458691.444099999 5797567.529699999,4458709.601499999 5797551.3201,4458837.3885 5797430.538399999,4458866.405199999 5797400.3735,4458883.000799999 5797371.769999999,4458894.5108 5797347.5822,4458908.8611 5797313.878599999,4458924.745699999 5797287.4734,4458977.9336 5797259.2891,4459030.4105 5797233.3035,4459063.2981 5797227.9229,4459080.909599999 5797233.619,4459089.587799999 5797238.7661,4459101.5076 5797246.590399999,4459097.2785 5797266.333,4459099.577499999 5797278.721499999,4459111.577899999 5797314.387199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (167,168,100251791.0,'NULL','farm',1662.07329112,158535.037312, ST_GeomFromText('MULTIPOLYGON(((4458197.6671 5796291.218599999,4458285.0562 5796671.5885,4458296.829599999 5796679.523399999,4458315.855 5796678.628299999,4458324.701999999 5796686.587999999,4458520.4451 5796637.4787,4458555.464499999 5796624.777,4458788.843 5796524.263299999,4458781.8145 5796471.753699999,4458766.371199999 5796388.6905,4458760.3891 5796360.230699999,4458197.6671 5796291.218599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (168,169,100251793.0,'NULL','residential',8550.1283413,1693796.47819, ST_GeomFromText('MULTIPOLYGON(((4459161.361999999 5796255.411199999,4459220.0728 5796184.831299999,4459287.314699999 5796261.6708,4459404.688199999 5796204.486199999,4459338.6073 5796090.390599999,4459444.2724 5796032.569,4459549.0761 5796227.392999999,4459730.7805 5796248.541699999,4459786.3057 5796235.670399999,4459920.7761 5795849.0631,4459957.502299999 5795864.822599999,4459921.4517 5795932.293999999,4460052.048899999 5796059.740199999,4460127.410799999 5795964.9449,4460082.2675 5795813.436599999,4460095.9829 5795669.197799999,4460081.544099999 5795621.8208,4460040.924899999 5795633.599899999,4460106.870299999 5795550.653799999,4460253.2964 5795406.936499999,4460275.033599999 5795431.2094,4460350.2158 5795360.7224,4460261.4389 5795246.062499999,4460281.619099999 5795206.463099999,4460282.0614 5795170.672399999,4460260.6397 5795146.7418,4460371.2609 5795064.0633,4460536.033499999 5795161.3366,4460571.433199999 5795101.163799999,4460639.5383 5795195.5632,4460714.647699999 5795157.7203,4460658.7911 5795039.130599999,4460642.197499999 5795015.471499999,4460701.4808 5795006.342,4460680.6441 5794932.285199999,4460608.0548 5794963.921399999,4460599.0399 5794902.311799999,4460596.5109 5794866.733999999,4460615.1518 5794651.517899999,4460598.9374 5794602.8628,4460586.753999999 5794544.527899999,4460536.639 5794412.0061,4460437.5047 5794367.442099999,4460406.333999999 5794322.190199999,4460331.892799999 5794454.752199999,4460289.065 5794493.5986,4460190.716599999 5794373.8758,4460169.0723 5794414.221799999,4460125.555599999 5794465.694099999,4460042.7477 5794548.1751,4459971.3069 5794606.3845,4459934.9945 5794562.0118,4459754.206399999 5794691.785499999,4459787.979399999 5794733.4735,4459584.779 5794865.2166,4459432.989099999 5794926.351099999,4459332.392099999 5794992.576799999,4459405.902099999 5795110.483799999,4459501.310899999 5795222.2923,4459403.787299999 5795293.198499999,4459431.9298 5795332.4044,4459388.876799999 5795349.5502,4459362.3333 5795326.4,4459317.305999999 5795370.592299999,4459343.0953 5795390.821799999,4459306.8622 5795436.399599999,4459269.262 5795403.848899999,4459260.5641 5795414.8705,4459214.802799999 5795369.9689,4459179.1747 5795399.473999999,4459117.979399999 5795347.401,4459054.830299999 5795412.9221,4459084.466 5795455.0292,4458997.912899999 5795523.660499999,4459028.2301 5795559.9195,4458933.823699999 5795651.251299999,4459047.4523 5795759.1049,4459012.6187 5795795.9046,4459056.1387 5795835.703999999,4459001.029099999 5795898.956,4459062.1584 5795943.728199999,4458991.6611 5796004.915699999,4459007.1529 5796019.3868,4458962.1178 5796060.655999999,4458995.3283 5796093.229599999,4459038.125199999 5796046.148299999,4459161.361999999 5796255.411199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (169,170,100251805.0,'NULL','farm',1181.53650929,80174.0871447, ST_GeomFromText('MULTIPOLYGON(((4458114.019799999 5796177.2989,4458368.855899999 5795964.436499999,4458231.646499999 5795808.5581,4458193.0234 5795829.794299999,4458159.533499999 5795851.254399999,4458116.572999999 5795874.2528,4458053.8519 5795901.069399999,4457970.648699999 5795930.253299999,4457922.438699999 5795942.3482,4458114.019799999 5796177.2989)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (170,414,0.0,'NULL','farm',5068.03048054,598796.718366, ST_GeomFromText('MULTIPOLYGON(((4456540.8391 5793067.4154,4456612.805399999 5792899.876,4456711.8377 5793001.7289,4456877.41 5793017.295199999,4457115.5147 5792987.188699999,4457171.0773 5792926.3344,4457338.189299999 5792903.164499999,4457134.0356 5792630.000499999,4457075.8271 5792510.937799999,4457028.2021 5792540.041999999,4456967.347799999 5792413.041699999,4456919.722699999 5792428.916799999,4456866.8059 5792373.3541,4456967.347799999 5792243.7081,4456732.5447 5791791.889499999,4456431.401399999 5792148.4567,4456729.762299999 5792485.070199999,4456540.0437 5792786.250099999,4456201.055599999 5792402.3723,4456124.0038 5792552.4045,4456540.8391 5793067.4154)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (171,415,0.0,'NULL','farm',2616.45769577,305825.639945, ST_GeomFromText('MULTIPOLYGON(((4457052.0146 5792312.4999,4457181.660699999 5792590.312899999,4457348.3485 5792828.4384,4457451.536199999 5792690.8548,4457536.203099999 5792677.6256,4457750.515999999 5792775.5216,4457790.203599999 5792823.1467,4457880.2087 5792707.083,4457843.120299999 5792582.375399999,4457790.203599999 5792465.958499999,4457774.328499999 5792357.4791,4457758.453499999 5792331.0207,4457589.1198 5792341.6041,4457576.9221 5792268.221599999,4457425.0778 5792346.8958,4457247.806699999 5792161.6871,4457052.0146 5792312.4999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (172,171,100251809.0,'NULL','farm',2461.31661523,243283.295656, ST_GeomFromText('MULTIPOLYGON(((4457252.405899999 5796930.1008,4457567.048499999 5797007.6853,4457844.563199999 5797109.698599999,4458302.9296 5796707.9371,4458293.395299999 5796705.8255,4458247.3331 5796711.333699999,4457942.386199999 5796737.279899999,4457684.7789 5796740.2159,4457347.371899999 5796740.193099999,4457292.519199999 5796744.317299999,4457259.6303 5796749.720799999,4457250.1714 5796756.3682,4457248.0635 5796766.612999999,4457257.326299999 5796906.7006,4457255.980299999 5796919.854399999,4457252.405899999 5796930.1008)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (173,172,100251813.0,'NULL','farm',2577.42770739,276322.093993, ST_GeomFromText('MULTIPOLYGON(((4457055.3287 5796990.210999999,4457179.6973 5797659.980299999,4457185.631699999 5797668.686499999,4457190.0107 5797667.9252,4457427.0124 5797458.594299999,4457411.066599999 5797257.9611,4457523.6874 5797248.967399999,4457532.893099999 5797297.795499999,4457636.6599 5797280.1117,4457844.563199999 5797109.698599999,4457567.048499999 5797007.6853,4457252.405899999 5796930.1008,4457241.5004 5796938.229699999,4457232.765999999 5796943.4131,4457055.3287 5796990.210999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (174,173,100251816.0,'NULL','farm',2310.05922693,311906.747172, ST_GeomFromText('MULTIPOLYGON(((4457371.164599999 5796528.2671,4457512.567699999 5796714.6765,4457536.7843 5796722.502499999,4457585.853699999 5796726.464999999,4457857.388399999 5796726.320499999,4457917.3963 5796725.0853,4457975.1889 5796721.6663,4458280.8606 5796694.981499999,4458185.205299999 5796289.131999999,4457878.942099999 5796249.3825,4457371.164599999 5796528.2671)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (175,175,100452235.0,'NULL','meadow',320.877293511,5909.24518214, ST_GeomFromText('MULTIPOLYGON(((4457588.1851 5797345.493,4457600.7197 5797356.3352,4457608.251199999 5797381.096999999,4457614.2849 5797402.2105,4457617.3117 5797413.1345,4457627.649899999 5797423.9956,4457647.332799999 5797415.7923,4457665.481599999 5797398.1212,4457680.7165 5797382.656199999,4457655.4724 5797340.541999999,4457636.8228 5797299.094599999,4457588.1851 5797345.493)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (176,176,100452238.0,'NULL','meadow',1443.05756428,51580.2739377, ST_GeomFromText('MULTIPOLYGON(((4457414.5652 5797487.1447,4457629.887099999 5797684.5598,4457630.4664 5797667.039499999,4457638.188299999 5797629.015699999,4457659.6725 5797574.0929,4457700.8585 5797513.148,4457722.0268 5797506.4011,4457747.649299999 5797507.639399999,4457763.907499999 5797526.4845,4457796.268 5797545.1809,4457836.514 5797544.836799999,4457844.761599999 5797482.7169,4457826.163999999 5797447.1106,4457809.973899999 5797437.0335,4457785.6675 5797418.256999999,4457746.8057 5797409.108599999,4457706.4648 5797398.5042,4457684.691399999 5797419.8562,4457684.8667 5797440.2968,4457683.594899999 5797462.207499999,4457674.8353 5797465.1981,4457660.2115 5797466.7813,4457633.266999999 5797481.6125,4457626.0366 5797491.89,4457629.798799999 5797504.276499999,4457662.197599999 5797527.356,4457651.3491 5797542.0379,4457634.441599999 5797533.4253,4457600.5832 5797510.3585,4457581.4231 5797495.199899999,4457561.489 5797474.929199999,4457553.215099999 5797448.727299999,4457555.3108 5797437.0249,4457569.840499999 5797424.4923,4457566.1216 5797417.958699999,4457546.847799999 5797410.2682,4457516.933299999 5797399.3976,4457414.5652 5797487.1447)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (177,177,113759215.0,'NULL','quarry',1296.55581189,55159.0449121, ST_GeomFromText('MULTIPOLYGON(((4456017.455199999 5797576.9713,4456180.414599999 5797338.74,4456270.695299999 5797400.0558,4456379.2953 5797266.971999999,4456235.988199999 5797282.1173,4456040.8857 5797315.2321,4455958.3178 5797329.1103,4455941.2993 5797548.406199999,4456017.455199999 5797576.9713)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (178,178,113759217.0,'NULL','industrial',2067.08433309,200474.56666, ST_GeomFromText('MULTIPOLYGON(((4455989.015599999 5797692.8131,4456281.8875 5797692.8131,4456340.447599999 5797591.4185,4456390.176099999 5797504.848099999,4456392.985799999 5797491.681099999,4456442.703399999 5797403.653599999,4456500.361499999 5797303.1378,4456544.3721 5797231.2083,4456574.7399 5797189.333499999,4456604.25 5797132.866499999,4456554.7554 5797163.959499999,4456459.450299999 5797228.3067,4456425.0136 5797248.7857,4456362.390599999 5797265.207499999,4455963.7548 5797326.123999999,4455904.123399999 5797351.8836,4455901.772599999 5797401.7804,4455879.250699999 5797428.5887,4455952.9685 5797671.3111,4455989.015599999 5797692.8131)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (179,179,117559982.0,'NULL','farmland',756.348815114,27279.1320067, ST_GeomFromText('MULTIPOLYGON(((4459508.169599999 5796593.4907,4459556.610199999 5796609.8856,4459652.4263 5796601.801599999,4459731.882 5796561.7268,4459819.7328 5796479.2433,4459736.508399999 5796411.2958,4459508.169599999 5796593.4907)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (180,180,120135003.0,'NULL','allotments',1223.85632773,88115.9508581, ST_GeomFromText('MULTIPOLYGON(((4460503.541199999 5795495.3201,4460532.509899999 5795575.119899999,4460563.690299999 5795602.1785,4460658.959599999 5795642.7474,4460774.9796 5795659.6401,4460905.2048 5795649.8497,4460684.6934 5795260.924499999,4460622.159599999 5795314.724999999,4460550.4296 5795408.771299999,4460503.541199999 5795495.3201)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (181,181,120135012.0,'NULL','farm',709.24997967,23513.1174007, ST_GeomFromText('MULTIPOLYGON(((4460520.378999999 5795587.1905,4460466.182599999 5795675.9791,4460598.4281 5795762.9878,4460706.7297 5795730.2881,4460754.5711 5795670.7631,4460667.4358 5795667.8065,4460555.0541 5795621.231599999,4460520.378999999 5795587.1905)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (182,182,120135017.0,'NULL','farm',2249.38625727,138100.07027, ST_GeomFromText('MULTIPOLYGON(((4460737.362399999 5795716.167999999,4460720.0147 5795744.0588,4460451.2915 5795827.247899999,4460713.9335 5796019.0872,4460815.8832 5796017.108599999,4461013.678299999 5796036.7191,4461038.3239 5796005.8562,4461072.5952 5795989.5173,4461099.398 5795953.530099999,4461139.547699999 5795939.348699999,4461198.891599999 5795946.1818,4461208.3228 5795935.157899999,4460865.279199999 5795692.5185,4460824.224499999 5795684.8098,4460778.769999999 5795676.413,4460757.6895 5795694.830099999,4460945.222299999 5795831.7847,4460914.265399999 5795869.563799999,4460847.2406 5795817.5269,4460858.067699999 5795798.457,4460737.362399999 5795716.167999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (183,183,120135028.0,'NULL','farm',2263.58536243,221931.152322, ST_GeomFromText('MULTIPOLYGON(((4461281.795099999 5795783.432,4461551.824099999 5795113.152699999,4461326.3864 5795120.754899999,4461340.380699999 5795159.781899999,4461166.260099999 5795241.0457,4461112.624999999 5795123.156799999,4460942.9022 5795139.841399999,4460987.665799999 5795273.5667,4460957.9572 5795285.0405,4461105.41 5795629.718599999,4461281.795099999 5795783.432)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (184,184,120135030.0,'NULL','farm',1970.70199545,204096.73734, ST_GeomFromText('MULTIPOLYGON(((4460784.6346 5796598.486199999,4461039.8245 5796752.7005,4461175.1346 5796090.2069,4460920.845399999 5796053.5105,4460746.551099999 5796319.2017,4460713.225899999 5796270.5488,4460684.763399999 5796281.7363,4460710.271399999 5796359.650699999,4460784.6346 5796598.486199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (185,185,120135039.0,'NULL','farm',1005.59033662,47066.1443288, ST_GeomFromText('MULTIPOLYGON(((4460871.0126 5795676.4045,4461210.8912 5795917.3109,4461265.808299999 5795798.157099999,4461093.2778 5795641.787699999,4460871.0126 5795676.4045)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (186,187,132453115.0,'NULL','farm',2000.00527898,106886.979463, ST_GeomFromText('MULTIPOLYGON(((4458473.392199999 5787540.8648,4458430.7537 5787528.058499999,4458359.582899999 5787522.8033,4458297.834499999 5787504.3057,4458153.6682 5787538.437999999,4458101.7684 5787562.0227,4458088.831199999 5787588.716399999,4458070.9917 5787737.812799999,4458009.858099999 5787787.593599999,4457919.6314 5787782.5065,4457853.5272 5787769.170199999,4457814.6957 5787772.4275,4457781.0968 5787792.209799999,4457728.668399999 5787830.2135,4457700.227099999 5787852.867799999,4457697.7318 5787899.959699999,4457716.0277 5787981.714999999,4457824.4604 5787972.010199999,4458034.4839 5787837.8493,4458473.392199999 5787540.8648)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (187,188,132454158.0,'NULL','farmland',14711.6820786,4401932.86541, ST_GeomFromText('MULTIPOLYGON(((4455838.313 5787505.036299999,4454738.1308 5787505.036299999,4454712.756 5787823.2881,4454686.353199999 5788073.161599999,4454597.8195 5788466.4426,4454614.0887 5789103.421599999,4454665.3551 5789099.980499999,4454698.382199999 5789177.4955,4454719.570799999 5789181.3967,4454735.011699999 5789206.7717,4454834.944 5789171.9297,4454789.3558 5789217.235899999,4454748.3452 5789300.569299999,4454831.7153 5789360.888699999,4454914.534099999 5789441.1446,4454923.345999999 5789443.2565,4454945.316399999 5789440.864199999,4454975.939 5789423.0368,4454992.0146 5789417.7717,4455011.021099999 5789411.7456,4455024.9237 5789409.426999999,4455035.928999999 5789410.061499999,4455038.926099999 5789417.3453,4455041.238699999 5789429.7541,4455042.813599999 5789442.1697,4455076.7922 5789470.370799999,4455098.5367 5789443.8559,4455351.989799999 5789181.9933,4455268.824599999 5789145.4548,4455244.4945 5789129.595,4455190.064399999 5789109.612199999,4455126.0042 5789078.021999999,4455076.182 5789047.927899999,4455071.1463 5788967.385399999,4454914.4994 5788509.5841,4454947.797799999 5788301.601099999,4455068.024 5788300.5083,4455075.0016 5788423.2968,4455007.641599999 5788432.688599999,4455062.867899999 5788701.2926,4455231.260099999 5788692.2441,4455301.699099999 5788970.4054,4455349.1819 5789033.5949,4455412.767199999 5789093.713099999,4455455.3589 5789121.605499999,4455408.249099999 5789161.7452,4455421.125199999 5789207.698599999,4455427.131699999 5789223.7243,4455447.127199999 5789246.211799999,4455468.459499999 5789254.799699999,4455475.124699999 5789262.050699999,4455457.5755 5789310.180999999,4455415.479799999 5789301.5131,4455329.573599999 5789226.718299999,4455296.6425 5789259.275499999,4455103.0826 5789462.2202,4455068.478799999 5789535.1995,4455032.3771 5789517.655999999,4455011.569199999 5789542.660399999,4455121.888899999 5789596.8307,4455184.395999999 5789602.484699999,4455213.197399999 5789613.674499999,4455267.963999999 5789648.8329,4455299.0535 5789623.7145,4455390.4071 5789671.463199999,4455558.938599999 5789459.4515,4455550.544099999 5789428.4912,4455608.019199999 5789377.209899999,4455644.763199999 5789369.7363,4455660.742999999 5789384.9495,4455575.836099999 5789533.5117,4455606.206799999 5789555.194399999,4455690.3058 5789475.811,4455719.2235 5789508.4461,4455723.0685 5789528.152599999,4455734.9022 5789540.4765,4455764.4965 5789570.924799999,4455782.915799999 5789581.7211,4455791.0811 5789593.343599999,4455815.838299999 5789656.729399999,4455821.112099999 5789672.773199999,4455821.2231 5789685.202099999,4455809.938099999 5789735.011099999,4455811.4851 5789743.7772,4455949.365899999 5789918.7354,4456006.938199999 5789881.667999999,4456008.497899999 5789891.891799999,4456021.7955 5789986.082399999,4456028.503899999 5789999.175899999,4456042.5096 5790007.831299999,4456104.9839 5789945.861899999,4456088.7273 5789930.6608,4456199.210099999 5789826.5928,4456163.6879 5789788.160199999,4456301.0882 5789660.465399999,4456284.041799999 5789639.4174,4456261.851999999 5789616.946,4456328.6814 5789572.255999999,4456306.738699999 5789720.116499999,4456246.230999999 5789840.542799999,4456286.3902 5789905.986899999,4456324.57 5789913.695199999,4456359.272699999 5790025.969599999,4456524.526999999 5790062.0489,4456611.8568 5789995.238399999,4456820.552 5790054.3486,4457175.649899999 5788951.509199999,4457114.742499999 5788909.505999999,4457046.9588 5788865.7495,4457020.9166 5788821.364099999,4456953.1068 5788694.7178,4456817.141099999 5788487.500299999,4456814.0458 5788469.500199999,4456887.0673 5788313.5414,4456919.3979 5788254.8277,4456998.514399999 5788124.767799999,4457041.5716 5788051.295299999,4457060.0755 5788007.725199999,4456558.135599999 5788275.8563,4456346.8151 5788049.516799999,4455838.313 5787505.036299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (188,189,132454159.0,'NULL','farm',1726.18466335,166394.889136, ST_GeomFromText('MULTIPOLYGON(((4457051.6435 5790164.9175,4456898.642599999 5790110.5644,4456623.775299999 5790012.9384,4456459.877899999 5790210.295399999,4456568.650899999 5790312.0383,4456792.693199999 5790434.2411,4456940.529 5790491.796099999,4456980.3212 5790495.500399999,4457007.8798 5790479.514799999,4457028.1829 5790454.7013,4457040.3026 5790424.2949,4457034.212199999 5790381.3275,4457023.407399999 5790335.085,4457003.3223 5790304.880499999,4456964.1176 5790267.6093,4457051.6435 5790164.9175)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (189,190,132454163.0,'NULL','farm',5554.71628876,1289751.40846, ST_GeomFromText('MULTIPOLYGON(((4457181.9368 5788961.091499999,4456832.3119 5790057.895899999,4457074.1896 5790145.715399999,4456981.3605 5790257.6334,4457047.9855 5790279.3881,4457069.5809 5790335.6633,4457085.370799999 5790356.6136,4457098.1177 5790359.8748,4457114.193699999 5790354.761199999,4457133.4687 5790333.362199999,4457193.8957 5790313.176,4457242.0641 5790315.352199999,4457343.3743 5790196.2331,4457392.881 5790157.7826,4457474.3519 5790086.909499999,4457494.6697 5790063.3441,4457492.191599999 5790116.000099999,4457463.6364 5790203.966299999,4457373.1688 5790251.526499999,4457347.470999999 5790330.699999999,4457714.342799999 5790383.1004,4458090.213999999 5790435.2958,4458129.94 5790448.991599999,4458151.7081 5790448.9187,4458166.280199999 5790443.5876,4458172.601999999 5790423.8156,4458174.7115 5790370.361999999,4458207.0021 5790301.931199999,4458139.9559 5790277.349199999,4458121.2894 5790270.307499999,4458221.842299999 5789620.4833,4458102.813199999 5789586.392699999,4458037.724899999 5789516.761199999,4457862.3232 5789404.9262,4457818.349299999 5789405.300899999,4457765.376799999 5789382.350899999,4457754.7801 5789347.0995,4457538.0628 5789201.5108,4457181.9368 5788961.091499999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (190,191,132454164.0,'NULL','farm',2843.60802569,318225.691282, ST_GeomFromText('MULTIPOLYGON(((4457073.363699999 5788867.7126,4457767.189699999 5789337.0119,4457814.233099999 5789356.8187,4457934.3425 5789431.1092,4457950.545099999 5789435.6118,4457962.9248 5789426.003399999,4457939.5075 5789344.312899999,4457945.3979 5789261.65,4457960.7695 5789172.3077,4457989.068099999 5789138.4392,4458019.083999999 5789133.8001,4458039.501299999 5789121.1972,4458062.7443 5789096.140599999,4458085.275299999 5788986.9974,4458106.115 5788937.8253,4458103.575299999 5788896.9076,4458102.490799999 5788855.966499999,4458086.1067 5788825.3925,4458056.5288 5788795.664799999,4458021.957299999 5788785.4644,4457959.552699999 5788770.893699999,4457924.4291 5788777.768699999,4457890.7982 5788789.026799999,4457865.924899999 5788799.2201,4457858.285199999 5788844.8758,4457801.3689 5788875.338999999,4457723.1106 5788896.4821,4457640.2527 5788894.264,4457580.7937 5788884.5357,4457460.986299999 5788847.5403,4457421.1803 5788822.288699999,4457380.0252 5788810.213099999,4457339.7662 5788821.2761,4457295.2565 5788840.933299999,4457238.140899999 5788848.7375,4457193.348699999 5788839.6104,4457124.515499999 5788848.2517,4457073.363699999 5788867.7126)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (191,192,132454165.0,'NULL','farm',5159.46334908,496036.942494, ST_GeomFromText('MULTIPOLYGON(((4458014.070899999 5787505.036299999,4457567.4164 5787505.036299999,4457417.137799999 5787584.9449,4457242.5727 5787748.815099999,4457067.357099999 5788009.709599999,4456824.344999999 5788472.8043,4456966.9932 5788690.2127,4457039.2597 5788823.396999999,4457071.6052 5788837.493499999,4457107.4318 5788822.8057,4457152.4367 5788771.2279,4457241.984899999 5788784.352099999,4457285.844399999 5788770.074699999,4457346.4846 5788746.1611,4457358.8459 5788734.348099999,4457348.2876 5788700.0764,4457306.626699999 5788629.506799999,4457283.6809 5788604.110899999,4457261.856599999 5788538.478199999,4457244.1299 5788523.2749,4457199.4482 5788528.0566,4457234.711799999 5788455.821599999,4457238.196299999 5788430.4534,4457287.4105 5788356.9077,4457269.620099999 5788334.382699999,4457240.855899999 5788318.295499999,4457220.157599999 5788294.594,4457210.4422 5788273.468399999,4457186.1206 5788258.3223,4457216.129499999 5788257.072499999,4457262.409099999 5788266.910299999,4457335.9153 5788289.677999999,4457359.6951 5788241.211799999,4457364.4537 5788193.888699999,4457351.4861 5788135.490399999,4457341.809399999 5788118.0252,4457330.7197 5788107.883199999,4457335.712799999 5788091.749399999,4457356.7762 5788068.166099999,4457363.1562 5788043.240499999,4457359.3172 5788022.798399999,4457343.656999999 5787992.220599999,4457362.754599999 5788000.58,4457425.9318 5788014.658199999,4457471.385999999 5788010.1391,4457521.941899999 5788006.043999999,4457550.482499999 5787999.9459,4457562.883899999 5787992.528599999,4457563.4521 5787973.5063,4457538.9357 5787935.6929,4457513.837799999 5787916.1564,4457436.626699999 5787894.619699999,4457407.813699999 5787865.145099999,4457397.928999999 5787823.545399999,4457401.0695 5787762.805099999,4457435.9802 5787729.599999999,4457478.012199999 5787846.726099999,4457500.103199999 5787858.242799999,4457524.987399999 5787848.047599999,4457545.314799999 5787824.471499999,4457557.0833 5787743.182199999,4457586.926799999 5787803.628599999,4457657.013199999 5787767.9316,4457686.9121 5787748.6585,4457711.5285 5787712.605599999,4457715.3923 5787649.6783,4457813.255699999 5787640.319599999,4457824.5573 5787639.232899999,4457864.122 5787640.108999999,4457920.025299999 5787655.9802,4457959.514399999 5787643.9383,4458000.088299999 5787586.541899999,4458028.960699999 5787532.171499999,4458014.070899999 5787505.036299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (192,193,132460978.0,'NULL','farm',2297.43976306,62842.6864737, ST_GeomFromText('MULTIPOLYGON(((4458143.7366 5790268.8712,4458275.580199999 5790321.1486,4458300.268 5790294.623199999,4458328.6686 5790211.7487,4458328.3546 5790174.4732,4458318.5367 5790140.193199999,4458256.9286 5790047.8734,4458237.081699999 5790015.1804,4458236.566499999 5789980.0543,4458242.1934 5789951.4973,4458297.520399999 5789907.899299999,4458345.314399999 5789812.4874,4458383.3086 5789737.566899999,4458394.5756 5789683.368699999,4458404.766599999 5789648.230499999,4458342.510099999 5789653.873099999,4458308.5421 5789710.4547,4458227.1758 5789735.956,4458199.1982 5789894.1071,4458279.3868 5789755.9907,4458289.2087 5789764.709899999,4458234.410299999 5789871.910199999,4458213.7827 5789946.651799999,4458212.7285 5789994.9109,4458229.478299999 5790069.336899999,4458253.779299999 5790108.5688,4458252.804299999 5790167.064799999,4458235.2284 5790168.6709,4458203.602599999 5790155.050499999,4458208.682799999 5790149.1654,4458226.2526 5790146.824899999,4458225.391499999 5790132.2102,4458206.8623 5790107.5072,4458181.4133 5790044.850099999,4458143.7366 5790268.8712)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (193,194,132460979.0,'NULL','farm',1003.11377457,27527.6235667, ST_GeomFromText('MULTIPOLYGON(((4458025.971199999 5789172.4998,4458051.428399999 5789209.606599999,4458121.3804 5789160.0295,4458174.4269 5789131.0269,4458175.4687 5789081.2991,4458177.886699999 5789020.5877,4458209.1961 5788969.1798,4458225.569899999 5788911.2661,4458240.796099999 5788891.3969,4458222.3421 5788876.9307,4458150.4274 5788807.310799999,4458124.321999999 5788814.876,4458150.6484 5788919.9111,4458117.905899999 5789009.433,4458081.6546 5789143.540599999,4458025.971199999 5789172.4998)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (194,195,132460980.0,'NULL','farm',429.973091491,10935.4057028, ST_GeomFromText('MULTIPOLYGON(((4458181.1084 5788794.6106,4458240.425999999 5788847.534199999,4458347.883799999 5788837.8155,4458345.9287 5788780.0676,4458325.189 5788754.648299999,4458293.6468 5788751.9874,4458181.1084 5788794.6106)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (195,196,132460981.0,'NULL','farm',297.916548296,4529.92632391, ST_GeomFromText('MULTIPOLYGON(((4458197.158599999 5790433.623099999,4458261.888 5790349.0503,4458261.5519 5790335.121099999,4458217.6507 5790317.253299999,4458190.748499999 5790368.6129,4458187.5536 5790397.917199999,4458190.431699999 5790417.600199999,4458187.8256 5790430.0854,4458197.158599999 5790433.623099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (196,197,132460983.0,'NULL','farm',1396.0741311,17174.4328938, ST_GeomFromText('MULTIPOLYGON(((4458408.7311 5789623.3043,4458429.993499999 5789597.564999999,4458359.2142 5789548.452299999,4458321.581199999 5789518.790899999,4458264.2876 5789503.9175,4458205.605299999 5789498.570699999,4458165.9072 5789485.0075,4458144.195 5789456.648299999,4458099.6699 5789392.6842,4458051.029799999 5789361.649199999,4458024.342799999 5789326.055099999,4458006.9862 5789267.7146,4458030.336199999 5789228.791699999,4458006.2975 5789186.554199999,4457981.347599999 5789243.8405,4457994.3157 5789329.2365,4458011.572999999 5789375.8824,4458026.933199999 5789372.091099999,4458062.006 5789419.3539,4458109.287999999 5789463.5537,4458190.2761 5789506.011199999,4458252.6385 5789513.518899999,4458265.2159 5789527.3114,4458297.247299999 5789526.996799999,4458318.264499999 5789559.757999999,4458332.1216 5789577.8909,4458367.570299999 5789583.468,4458408.7311 5789623.3043)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (197,198,132460984.0,'NULL','farm',1303.30619553,18498.114678, ST_GeomFromText('MULTIPOLYGON(((4458122.4576 5789573.0733,4458287.781899999 5789621.3958,4458327.440799999 5789631.2992,4458373.624599999 5789632.3682,4458400.737999999 5789631.4057,4458359.432099999 5789600.317199999,4458329.5761 5789597.6864,4458303.709499999 5789572.310399999,4458291.570299999 5789549.711999999,4458268.837399999 5789548.4459,4458243.0257 5789529.6574,4458204.3897 5789528.5481,4458163.735899999 5789514.2364,4458081.905299999 5789458.6334,4458039.7286 5789411.463999999,4458028.031899999 5789389.663699999,4458013.9402 5789395.603099999,4458024.760999999 5789435.7606,4458062.4522 5789471.995799999,4458126.593299999 5789516.052799999,4458179.3925 5789545.5401,4458234.829199999 5789574.3602,4458200.141999999 5789572.4164,4458078.9768 5789519.3826,4458077.375799999 5789529.589299999,4458122.4576 5789573.0733)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (198,199,134407696.0,'NULL','farm',456.253048845,12260.5771775, ST_GeomFromText('MULTIPOLYGON(((4457813.0009 5796155.7364,4457914.8031 5796076.738399999,4457845.914499999 5795981.6816,4457770.721099999 5796091.1107,4457813.0009 5796155.7364)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (199,200,134407697.0,'NULL','farm',1741.8113579,97192.324439, ST_GeomFromText('MULTIPOLYGON(((4458391.102599999 5795701.775,4458517.8892 5795845.2486,4458637.5141 5795754.465199999,4458683.985799999 5795709.531199999,4458907.9976 5795446.2456,4458868.0274 5795393.264699999,4458977.031899999 5795295.968299999,4458974.0137 5795285.0324,4458989.9954 5795270.2999,4458981.925699999 5795268.174699999,4458956.3344 5795272.0372,4458777.374099999 5795408.6315,4458569.305499999 5795564.4495,4458391.102599999 5795701.775)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (200,201,134407699.0,'NULL','farm',324.595820326,5622.01490532, ST_GeomFromText('MULTIPOLYGON(((4459261.366999999 5795329.390699999,4459217.0345 5795369.1938,4459260.562699999 5795409.729499999,4459269.272599999 5795400.1655,4459305.3886 5795429.812899999,4459335.820799999 5795391.5828,4459261.366999999 5795329.390699999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (201,202,134407700.0,'NULL','farm',521.367589305,16907.3386801, ST_GeomFromText('MULTIPOLYGON(((4458831.2515 5795548.3823,4458924.2434 5795638.89,4459012.795699999 5795547.606599999,4458914.637299999 5795452.0325,4458831.2515 5795548.3823)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (202,203,134407702.0,'NULL','farm',372.663694591,7552.22045116, ST_GeomFromText('MULTIPOLYGON(((4459072.07 5795279.111099999,4459167.911 5795360.107599999,4459205.7182 5795328.3923,4459125.8474 5795231.194199999,4459072.07 5795279.111099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (203,204,134407703.0,'NULL','farm',1847.40238699,59187.2600839, ST_GeomFromText('MULTIPOLYGON(((4457717.8398 5796155.815999999,4457572.9133 5796326.459899999,4457396.603199999 5796507.5832,4457877.4446 5796244.9886,4458070.559999999 5796268.872199999,4457930.235799999 5796083.906799999,4457843.691499999 5796149.632099999,4457830.018099999 5796177.4908,4457858.6577 5796226.8657,4457797.0438 5796258.817299999,4457717.8398 5796155.815999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (204,205,134407705.0,'NULL','farmland',823.805416587,39210.1725277, ST_GeomFromText('MULTIPOLYGON(((4459039.059399999 5796065.825799999,4458894.656899999 5796217.4305,4458989.4225 5796347.3396,4459052.7471 5796303.7379,4459076.105299999 5796335.637099999,4459118.5892 5796299.5423,4459156.322399999 5796259.803899999,4459039.059399999 5796065.825799999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (205,206,134407706.0,'NULL','farmland',1882.98527692,138654.75383, ST_GeomFromText('MULTIPOLYGON(((4458928.870299999 5796282.8672,4458888.1155 5796223.327199999,4458747.7861 5796073.3585,4458637.771999999 5795960.3737,4458539.0299 5796056.8573,4458503.4291 5796088.5482,4458522.848899999 5796135.1223,4458466.6754 5796157.4942,4458445.9483 5796129.926799999,4458171.949199999 5796274.610999999,4458641.652499999 5796335.6409,4458733.968 5796346.552699999,4458859.237099999 5796359.3726,4458866.258799999 5796323.5379,4458895.276999999 5796291.9044,4458928.870299999 5796282.8672)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (206,207,134407707.0,'NULL','farm',1554.91817579,90914.2299658, ST_GeomFromText('MULTIPOLYGON(((4459197.194099999 5796245.5894,4459331.225599999 5796521.9241,4459422.6035 5796548.880599999,4459439.672699999 5796541.473799999,4459453.982099999 5796501.2068,4459480.4998 5796433.086699999,4459497.7543 5796394.9768,4459582.2635 5796292.764499999,4459552.4046 5796221.4568,4459528.637199999 5796233.3692,4459439.975499999 5796043.531899999,4459395.5921 5796072.372899999,4459405.673299999 5796091.964099999,4459357.879499999 5796115.0359,4459396.453099999 5796216.894799999,4459329.694199999 5796247.4228,4459300.6791 5796279.7881,4459274.393 5796287.3048,4459229.781 5796202.978599999,4459197.194099999 5796245.5894)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (207,208,134407708.0,'NULL','farm',584.635259836,16448.8912981, ST_GeomFromText('MULTIPOLYGON(((4458995.002299999 5795520.735799999,4459033.807099999 5795472.185499999,4459046.849999999 5795416.6159,4459112.901899999 5795348.143999999,4459067.923999999 5795309.0906,4458918.160799999 5795435.934499999,4458995.002299999 5795520.735799999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (208,209,134407710.0,'NULL','farm',1107.41760375,59988.6261438, ST_GeomFromText('MULTIPOLYGON(((4458925.9106 5795662.968,4458645.019 5795951.555299999,4458746.204199999 5796058.7719,4459032.2004 5795768.7013,4458925.9106 5795662.968)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (209,210,134407711.0,'NULL','farm',2204.52096342,113106.471938, ST_GeomFromText('MULTIPOLYGON(((4458107.690899999 5796206.529999999,4458167.4631 5796263.6992,4458184.250199999 5796257.7148,4458421.711799999 5796119.9042,4458529.093 5796045.946399999,4458625.217799999 5795947.336799999,4458697.501299999 5795876.603599999,4458677.114299999 5795850.523499999,4458727.145399999 5795793.1413,4458761.3331 5795806.698799999,4458917.025799999 5795651.368699999,4458824.788399999 5795563.7704,4458685.6604 5795734.343499999,4458580.297699999 5795827.966099999,4458445.000799999 5795930.6005,4458325.6813 5796017.035099999,4458107.690899999 5796206.529999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (210,211,134408698.0,'NULL','residential',3743.42498821,392137.811333, ST_GeomFromText('MULTIPOLYGON(((4459825.6079 5796477.7266,4460014.942699999 5796268.1094,4460337.0946 5796552.4315,4460412.990799999 5796706.5997,4460467.239 5796717.849199999,4460546.096699999 5796694.5843,4460599.349499999 5796855.5017,4460637.313699999 5796752.2662,4460713.882 5796993.297599999,4460771.2054 5796967.982,4460732.486499999 5796847.864199999,4460799.939199999 5796770.6794,4460778.1209 5796695.6618,4460807.039699999 5796688.087799999,4460785.5727 5796620.400599999,4460681.1698 5796285.392599999,4460707.7964 5796264.694199999,4460671.8539 5796219.022399999,4460423.775399999 5796043.582299999,4460271.500699999 5796041.1553,4460207.6331 5796108.8374,4460162.958599999 5796106.282199999,4460125.274799999 5796062.0416,4460029.3787 5796152.629899999,4459965.5158 5796220.315199999,4459743.0257 5796403.1972,4459825.6079 5796477.7266)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (211,212,134408813.0,'NULL','farm',466.255344828,8104.90025086, ST_GeomFromText('MULTIPOLYGON(((4460683.9265 5795252.874099999,4460774.5306 5795414.998199999,4460786.647499999 5795410.4843,4460782.3847 5795390.109699999,4460804.0628 5795377.151699999,4460722.2038 5795224.0489,4460683.9265 5795252.874099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (212,213,134408814.0,'NULL','meadow',1451.54827748,54859.7778918, ST_GeomFromText('MULTIPOLYGON(((4460102.3015 5795665.007099999,4460188.873499999 5795637.801899999,4460312.161799999 5795544.2925,4460395.786899999 5795474.250199999,4460444.8238 5795417.594799999,4460483.913399999 5795326.0335,4460541.8869 5795175.666899999,4460432.3874 5795197.374299999,4460467.0141 5795270.996999999,4460374.8781 5795332.0149,4460348.866899999 5795374.5874,4460125.898299999 5795568.938999999,4460086.361999999 5795621.058499999,4460102.3015 5795665.007099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (213,214,134408815.0,'NULL','meadow',933.924292342,45372.8059056, ST_GeomFromText('MULTIPOLYGON(((4460907.441499999 5795650.544199999,4461085.870099999 5795626.4897,4460966.6314 5795359.4394,4460941.241299999 5795388.8507,4460909.271999999 5795419.7719,4460871.033699999 5795435.375499999,4460846.426199999 5795433.4118,4460792.187099999 5795425.8078,4460787.138399999 5795435.351099999,4460907.441499999 5795650.544199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (214,215,134413089.0,'NULL','farm',1259.00277546,70745.0545759, ST_GeomFromText('MULTIPOLYGON(((4461596.961199999 5795078.505599999,4462109.992999999 5795053.3668,4462039.1222 5794881.552699999,4461711.558799999 5794938.863299999,4461639.9714 5794960.595,4461580.9571 5794997.563999999,4461596.961199999 5795078.505599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (215,216,134413090.0,'NULL','farm',1599.16246425,80446.0748645, ST_GeomFromText('MULTIPOLYGON(((4462350.0853 5794855.0697,4462563.5602 5794716.152599999,4462569.243599999 5794693.4645,4462586.776999999 5794688.223999999,4462611.914599999 5794720.1707,4462667.957 5794675.925599999,4462916.329099999 5794502.420099999,4462927.2285 5794490.642999999,4462908.035 5794470.345399999,4462789.128399999 5794432.5263,4462756.4345 5794465.632899999,4462688.632899999 5794504.8581,4462286.319699999 5794749.6642,4462350.0853 5794855.0697)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (216,217,134413093.0,'NULL','farm',629.785186203,22892.1098684, ST_GeomFromText('MULTIPOLYGON(((4462974.902099999 5795673.3559,4463100.066599999 5795671.684499999,4463055.414599999 5795476.3254,4462943.830699999 5795483.4821,4462974.902099999 5795673.3559)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (217,218,134413096.0,'NULL','farm',2063.08561709,283376.721343, ST_GeomFromText('MULTIPOLYGON(((4463201.4649 5795086.4251,4463201.4649 5794529.1608,4463169.859 5794526.807,4462986.554299999 5794493.1247,4462963.104299999 5794490.3739,4462938.296699999 5794502.2552,4462721.9353 5794649.222999999,4462620.0388 5794729.601099999,4462748.033999999 5795051.172499999,4462774.887699999 5795117.425,4463019.6516 5795099.7847,4463201.4649 5795086.4251)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (218,219,134413097.0,'NULL','farm',1783.33377813,112549.584841, ST_GeomFromText('MULTIPOLYGON(((4463184.8393 5792802.7312,4463057.238599999 5792684.5833,4462410.1769 5793033.5875,4462571.976499999 5793120.7583,4463184.8393 5792802.7312)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (219,220,134413099.0,'NULL','farm',2145.41533608,297972.221814, ST_GeomFromText('MULTIPOLYGON(((4461519.117999999 5795329.5984,4461892.358199999 5795597.6215,4461922.495699999 5795613.446499999,4461962.0542 5795617.5259,4462036.008899999 5795619.8834,4462247.418999999 5795599.2674,4462194.5963 5795106.754899999,4462174.706799999 5795090.115399999,4462118.240899999 5795078.864,4461626.053399999 5795100.6575,4461599.5842 5795133.2562,4461519.117999999 5795329.5984)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (220,221,134413100.0,'NULL','farm',1664.74536101,149529.37002, ST_GeomFromText('MULTIPOLYGON(((4463010.2982 5795121.030899999,4462674.4334 5795145.468499999,4462444.619699999 5795154.5106,4462754.276999999 5795490.750299999,4463049.4621 5795463.228099999,4463010.2982 5795121.030899999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (221,222,134413101.0,'NULL','farm',1713.90495003,176100.534606, ST_GeomFromText('MULTIPOLYGON(((4463201.4649 5793740.979,4463201.4649 5793556.445499999,4463071.094499999 5793509.0555,4463053.196 5793466.091499999,4462924.6457 5793415.176899999,4462664.7416 5793377.941899999,4462628.429999999 5793419.133099999,4462598.393199999 5793465.852099999,4462572.6117 5793543.4853,4462565.312599999 5793581.9647,4462619.806099999 5793643.500399999,4462700.7121 5793682.136499999,4462729.173999999 5793700.861099999,4462759.368999999 5793704.138699999,4462829.3529 5793729.339099999,4462912.2395 5793723.0744,4463046.004999999 5793796.984099999,4463201.4649 5793740.979)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (222,223,134413104.0,'NULL','farm',1757.88663677,77492.0899141, ST_GeomFromText('MULTIPOLYGON(((4462055.2433 5794883.620999999,4462113.101999999 5795028.9842,4462214.468 5795072.028799999,4462278.021399999 5795101.732699999,4462411.392599999 5795117.518699999,4462313.180999999 5794911.5909,4462609.036799999 5794726.757799999,4462599.3513 5794704.9206,4462348.6862 5794863.1146,4462285.6217 5794754.7772,4462114.335199999 5794856.1491,4462055.2433 5794883.620999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (223,224,134413106.0,'NULL','farm',3001.4399076,483180.470029, ST_GeomFromText('MULTIPOLYGON(((4461555.0334 5796087.957299999,4461573.964999999 5796074.667999999,4461615.3047 5796119.614399999,4461700.5245 5796159.1129,4461799.005499999 5796210.9177,4462329.807099999 5795843.983699999,4462339.725999999 5795800.832399999,4462348.302 5795773.025399999,4462380.3446 5795750.8705,4462424.1286 5795733.0108,4462377.5301 5795669.837099999,4462329.6697 5795633.6917,4462267.362099999 5795623.2177,4462209.5108 5795620.010199999,4462071.2697 5795635.6698,4462009.086299999 5795640.532199999,4461946.868099999 5795641.745699999,4461907.966599999 5795628.169299999,4461842.420599999 5795577.5543,4461515.596199999 5795347.875399999,4461332.0389 5795793.765499999,4461330.8579 5795830.285099999,4461375.888299999 5795878.1161,4461555.0334 5796087.957299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (224,225,134413107.0,'NULL','farm',894.650586948,31557.8479069, ST_GeomFromText('MULTIPOLYGON(((4463047.566499999 5793448.117799999,4463024.649899999 5793321.1772,4462873.5568 5793292.354199999,4462828.183 5793297.0796,4462759.4637 5793313.676599999,4462691.58 5793344.1334,4462669.807199999 5793369.8694,4462928.2455 5793406.3924,4463047.566499999 5793448.117799999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (225,226,134413108.0,'NULL','farm',820.728890867,22658.4632941, ST_GeomFromText('MULTIPOLYGON(((4461299.818699999 5795834.4341,4461258.5136 5795938.914499999,4461486.3694 5796100.9,4461544.6052 5796111.184399999,4461327.839999999 5795860.4985,4461299.818699999 5795834.4341)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (226,227,134413109.0,'NULL','farm',1329.61663245,106450.951403, ST_GeomFromText('MULTIPOLYGON(((4462610.5635 5794735.5149,4462323.806699999 5794913.4461,4462423.1518 5795124.005799999,4462442.2559 5795132.618,4462767.206299999 5795117.7389,4462610.5635 5794735.5149)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (227,228,134413111.0,'NULL','farm',3021.31080611,204971.004315, ST_GeomFromText('MULTIPOLYGON(((4462259.121399999 5795598.4546,4462291.754399999 5795605.249199999,4462328.4468 5795617.3877,4462368.897499999 5795641.9054,4462442.0788 5795735.5449,4462529.329199999 5795850.243799999,4462601.281999999 5795926.6247,4462612.5025 5795958.665599999,4462564.765499999 5796082.1675,4463107.2163 5796236.744,4463132.364699999 5796075.192199999,4463066.5661 5796085.910399999,4462998.6039 5796101.018999999,4462950.630099999 5796096.782999999,4462890.808699999 5796074.8209,4462845.9434 5796046.7157,4462805.360899999 5796003.945699999,4462775.849799999 5795972.765499999,4462709.6204 5795926.539699999,4462649.2269 5795878.067299999,4462625.534599999 5795842.470799999,4462620.682099999 5795781.9056,4462629.653099999 5795613.162699999,4462627.8062 5795562.0557,4462623.047399999 5795513.897299999,4462571.3255 5795450.7605,4462522.091699999 5795427.0423,4462385.603199999 5795384.258899999,4462309.303299999 5795362.929999999,4462231.8464 5795334.0554,4462259.121399999 5795598.4546)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (228,229,134413445.0,'NULL','farm',545.163783493,10575.3611573, ST_GeomFromText('MULTIPOLYGON(((4462547.7947 5793602.3723,4462537.836099999 5793641.161199999,4462559.125799999 5793648.310799999,4462564.7346 5793663.3464,4462553.5075 5793679.755799999,4462539.551599999 5793674.754,4462532.865199999 5793661.651699999,4462523.699199999 5793660.0075,4462513.059299999 5793706.1126,4462521.8183 5793717.096,4462575.217899999 5793730.756699999,4462604.600399999 5793726.8065,4462648.9899 5793717.023199999,4462679.6584 5793704.372899999,4462687.6242 5793692.628599999,4462654.5493 5793676.7989,4462601.6398 5793653.0964,4462561.0414 5793611.0405,4462547.7947 5793602.3723)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (229,230,134413446.0,'NULL','farm',1883.85240028,176927.594978, ST_GeomFromText('MULTIPOLYGON(((4463201.4649 5793081.6762,4463201.4649 5792819.5698,4463184.8393 5792802.7312,4462571.976499999 5793120.7583,4462610.851499999 5793128.498199999,4462643.36 5793165.5192,4462796.724499999 5793253.228299999,4462817.765499999 5793275.2475,4462852.897699999 5793272.0567,4462890.659099999 5793278.093499999,4463089.422699999 5793315.329399999,4463100.2174 5793250.719,4463177.0701 5793253.5063,4463179.9331 5793081.628399999,4463201.4649 5793081.6762)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (230,426,0.0,'NULL','farm',3013.73446325,535417.951583, ST_GeomFromText('MULTIPOLYGON(((4454764.1074 5796338.201099999,4455299.625099999 5796050.3339,4455295.3918 5795853.4835,4455269.9917 5795741.2999,4455219.191599999 5795694.7331,4455221.308299999 5795451.315999999,4454859.357599999 5795483.066099999,4454690.0239 5795557.149499999,4454613.8238 5795690.4998,4454330.189899999 5795677.799799999,4454518.573599999 5796050.3339,4454764.1074 5796338.201099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (231,427,0.0,'NULL','meadow',3765.58840782,243781.402057, ST_GeomFromText('MULTIPOLYGON(((4455350.4252 5796024.9338,4455617.125799999 5795995.3004,4455765.2927 5796031.2838,4455799.1595 5795933.916999999,4456046.809999999 5795929.683599999,4456095.4934 5795864.0668,4456029.8766 5795489.416099999,4456067.9767 5795197.3155,4455955.7931 5794892.5149,4455852.0762 5795013.1651,4455754.7094 5795053.381899999,4455849.959599999 5795190.9655,4455921.9264 5795502.1161,4455972.726499999 5795732.8332,4456002.359899999 5795819.616699999,4455849.959599999 5795806.916699999,4455337.7252 5795859.833499999,4455350.4252 5796024.9338)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (232,231,173762920.0,'NULL','residential',706.569877676,23578.2277497, ST_GeomFromText('MULTIPOLYGON(((4455248.382899999 5790046.676699999,4455464.431599999 5790110.5152,4455520.319199999 5790050.0664,4455447.067499999 5789972.5076,4455418.7844 5790005.6564,4455335.442099999 5789947.930999999,4455264.179299999 5790009.978599999,4455275.255699999 5790019.381699999,4455248.382899999 5790046.676699999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (233,232,173769206.0,'NULL','reservoir',123.143666059,933.407333484, ST_GeomFromText('MULTIPOLYGON(((4455026.711199999 5789687.274599999,4455047.338299999 5789698.0592,4455057.5586 5789693.5709,4455061.858099999 5789683.305299999,4455055.923899999 5789675.313699999,4455027.9806 5789665.3299,4455017.0093 5789667.621899999,4455013.4231 5789676.6903,4455026.711199999 5789687.274599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (234,233,174599647.0,'NULL','residential',2998.76593455,336866.251804, ST_GeomFromText('MULTIPOLYGON(((4461413.260599999 5787780.426899999,4461455.763199999 5787948.2684,4461518.7015 5787933.156999999,4461616.747299999 5787906.790999999,4461655.9027 5787945.2564,4461596.2702 5788008.612299999,4461642.8262 5788055.0543,4461639.2417 5788066.053999999,4461641.5327 5788077.731399999,4461709.306499999 5788149.8704,4461686.7252 5788178.5877,4461720.939699999 5788201.446299999,4461688.176099999 5788230.954399999,4461720.677899999 5788262.138699999,4461733.2986 5788272.679099999,4461803.9714 5788199.4473,4461986.247299999 5788254.5949,4462002.803199999 5788244.608599999,4462126.2355 5788279.504799999,4462189.1369 5788068.444,4462232.602199999 5788020.507999999,4462241.627799999 5787937.860799999,4462323.912499999 5787936.788699999,4462314.195299999 5787852.470499999,4462190.759399999 5787818.303999999,4462198.660699999 5787701.225199999,4462154.5377 5787684.014,4462078.3535 5787756.693099999,4462040.656 5787754.8121,4461985.169999999 5787763.706,4461934.990699999 5787738.353299999,4461928.513 5787659.4078,4461790.878299999 5787686.807399999,4461632.807099999 5787726.0532,4461506.879599999 5787750.443399999,4461416.0394 5787759.919199999,4461413.260599999 5787780.426899999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (235,234,174599656.0,'NULL','farm',5590.27080923,623334.730596, ST_GeomFromText('MULTIPOLYGON(((4451512.0224 5789061.979499999,4451792.668499999 5789049.7345,4451798.3995 5788960.4766,4451831.3776 5788959.421099999,4451841.6913 5789040.488399999,4451855.6502 5789043.2792,4451868.218299999 5789054.1181,4451873.498399999 5789069.423399999,4451884.647499999 5789085.406099999,4452024.6967 5789089.1653,4452054.118499999 5789099.118,4452093.893799999 5789119.2083,4452175.671299999 5789161.549399999,4452208.535299999 5789148.801999999,4452217.9105 5789132.6315,4452235.5025 5789132.461699999,4452264.044599999 5789127.801899999,4452289.571399999 5789114.3913,4452324.7202 5789110.391499999,4452353.283699999 5789107.9242,4452397.7311 5789079.709899999,4452471.2001 5789020.504,4452499.399199999 5788980.016699999,4452498.569899999 5788969.7869,4452496.2438 5788956.655999999,4452477.8008 5788944.4031,4452440.4927 5788952.7959,4452400.858199999 5788947.334699999,4452246.606599999 5788915.9152,4452397.0416 5788932.014799999,4452429.0712 5788908.3047,4452469.015599999 5788869.1621,4452482.6589 5788839.7868,4452485.2965 5788658.297599999,4452306.752799999 5788690.839299999,4452274.546099999 5788696.2686,4452248.8902 5788696.516,4452135.940899999 5788691.0304,4451560.1255 5788658.607699999,4451314.052099999 5789014.5258,4451245.297199999 5789084.819499999,4451108.4978 5789192.986999999,4451000.8512 5789239.075699999,4450981.682 5789251.7401,4450892.3879 5789343.808499999,4450880.4242 5789401.5817,4450878.300499999 5789445.7366,4450889.3787 5789486.010299999,4450901.404699999 5789509.582499999,4450914.7543 5789515.7597,4450945.0924 5789478.947799999,4450986.023199999 5789505.160399999,4451021.2779 5789461.823699999,4451057.725599999 5789461.685699999,4451066.2026 5789427.661299999,4451252.2976 5789428.539899999,4451250.4966 5789501.635399999,4451361.593 5789475.325999999,4451346.037399999 5789467.0884,4451354.6281 5789431.9284,4451396.135099999 5789425.1776,4451443.985899999 5789282.3025,4451503.2092 5789285.1826,4451535.3481 5789275.3867,4451581.268699999 5789231.46,4451621.946499999 5789217.263499999,4451709.8294 5789220.5447,4451726.3836 5789214.8749,4451729.998599999 5789203.733799999,4451725.9335 5789194.648499999,4451696.299899999 5789185.401,4451673.814699999 5789178.4429,4451672.1752 5789168.6774,4451680.147599999 5789155.969299999,4451693.838299999 5789158.606499999,4451703.3732 5789126.0753,4451640.282999999 5789111.5128,4451516.5201 5789080.9977,4451512.0224 5789061.979499999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (236,235,174973111.0,'NULL','farmland',1115.34196624,58765.1148628, ST_GeomFromText('MULTIPOLYGON(((4448758.597599999 5793803.0076,4448773.328999999 5793811.6127,4448940.6551 5793831.770099999,4449029.650899999 5793822.8724,4449106.5301 5793831.806099999,4449097.1856 5793794.7453,4449110.821299999 5793786.503599999,4449112.0191 5793766.927899999,4449089.5513 5793561.9111,4448943.794099999 5793581.921,4448939.0546 5793690.091399999,4448833.7877 5793708.7182,4448758.597599999 5793803.0076)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (237,236,174973113.0,'NULL','farmland',2906.07401946,188265.211995, ST_GeomFromText('MULTIPOLYGON(((4455575.587899999 5794349.224899999,4455838.235199999 5794241.688699999,4455831.9094 5794189.1434,4455954.5558 5794147.1532,4456083.6014 5794175.9943,4456058.7273 5794003.0534,4456105.380699999 5793979.258899999,4456158.001199999 5793967.1074,4456231.228199999 5793966.4582,4456233.664499999 5793910.919299999,4456201.4166 5793908.2784,4456154.3731 5793888.242499999,4456145.0963 5793832.807499999,4455954.938199999 5793860.805299999,4455973.4505 5793965.821699999,4455950.195199999 5793986.4822,4455922.794099999 5793869.8497,4455771.239599999 5793955.943299999,4455778.141599999 5794072.7585,4455681.4335 5794067.7828,4455655.258799999 5794088.470899999,4455635.097599999 5794126.631599999,4455608.5229 5794103.501599999,4455588.2308 5794127.052699999,4455570.840499999 5794147.6622,4455521.157999999 5794159.7936,4455459.8629 5794183.7257,4455383.526499999 5794163.9612,4455372.972599999 5794176.608899999,4455438.4199 5794276.3146,4455468.693699999 5794398.627399999,4455469.3265 5794442.332399999,4455531.7761 5794499.245799999,4455573.520299999 5794445.6563,4455575.798 5794372.5918,4455575.587899999 5794349.224899999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (238,237,174973116.0,'NULL','residential',2909.81137805,181967.864811, ST_GeomFromText('MULTIPOLYGON(((4451586.064899999 5794823.6213,4451529.1698 5794846.0905,4451470.539499999 5794881.5194,4451471.4764 5794926.8684,4451551.7806 5794939.411599999,4451440.087199999 5795079.9548,4451312.4302 5795164.2718,4451345.996299999 5795232.634999999,4451405.365899999 5795199.345,4451491.157399999 5795151.229399999,4451627.1412 5795181.677699999,4451623.2455 5795215.2115,4451620.1173 5795242.105399999,4451612.990299999 5795287.800499999,4451725.9981 5795304.777899999,4451740.052199999 5795235.3012,4451757.374499999 5795149.645899999,4451889.178999999 5795172.9756,4451889.040699999 5795115.333399999,4451845.7263 5795103.3365,4451820.6842 5795088.2462,4451831.9802 5795045.048,4451830.299399999 5795023.1531,4451815.0146 5794957.568499999,4451855.9548 5794950.592599999,4451875.282599999 5794905.8584,4451891.365299999 5794902.7751,4451928.435899999 5794875.395099999,4451903.2504 5794844.9713,4451986.1112 5794782.8048,4452031.766699999 5794733.431099999,4452063.565499999 5794690.757699999,4452061.807599999 5794660.105799999,4452001.257799999 5794683.328199999,4451969.2538 5794705.550499999,4451884.258799999 5794775.038,4451763.228199999 5794827.3409,4451724.6719 5794778.052799999,4451699.956199999 5794796.5556,4451615.8025 5794697.070399999,4451592.6842 5794704.4634,4451586.064899999 5794823.6213)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (239,238,174973120.0,'NULL','meadow',357.839192633,6443.5972873, ST_GeomFromText('MULTIPOLYGON(((4450387.6028 5794438.1706,4450505.7898 5794452.609099999,4450532.997299999 5794403.0723,4450495.286799999 5794366.204199999,4450387.6028 5794438.1706)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (240,239,176258326.0,'NULL','farmland',6722.13577341,1365641.27879, ST_GeomFromText('MULTIPOLYGON(((4455309.646099999 5790848.2783,4455369.7308 5791013.397099999,4455393.9998 5791103.815099999,4455376.968799999 5791165.3614,4455292.7675 5791253.8211,4455373.133899999 5791390.5028,4455585.147199999 5791175.1829,4455606.1407 5791227.6183,4455503.566899999 5791312.422399999,4455521.8015 5791364.0811,4455533.1511 5791383.753299999,4455492.562199999 5791448.716,4455491.9785 5791461.262499999,4455505.272699999 5791469.366399999,4455531.580699999 5791473.402799999,4455557.6809 5791487.745799999,4455593.122899999 5791457.2039,4455730.772499999 5791417.645199999,4455741.0492 5791565.521099999,4455730.1167 5791653.318099999,4455820.539099999 5791652.6762,4455926.4 5791645.7225,4455941.2839 5791640.7826,4455961.253499999 5791610.3256,4455979.521599999 5791582.0205,4455998.985 5791569.0613,4456015.2136 5791558.6347,4456035.4379 5791555.205499999,4456014.262299999 5791636.705399999,4456291.812099999 5791873.405099999,4456327.3934 5791893.2433,4456380.084099999 5791913.553999999,4456408.381599999 5791922.095499999,4456460.712199999 5791924.082499999,4456491.5376 5791924.2562,4456563.699 5791943.4517,4456581.4406 5791956.816199999,4456743.110299999 5791780.3574,4456736.3545 5791745.764299999,4456696.1035 5791513.8999,4456396.3572 5790790.6062,4456326.368099999 5790847.6754,4456317.8551 5791008.2036,4456285.0097 5790999.580399999,4456267.976599999 5790757.0763,4456250.080099999 5790688.1749,4456245.3973 5790656.0456,4456187.586699999 5790664.6028,4456187.748499999 5790682.873299999,4456022.1403 5790664.891499999,4455998.538599999 5790667.6052,4456005.097099999 5790663.162399999,4456005.7433 5790653.6535,4455998.8403 5790619.363099999,4455990.371399999 5790573.3801,4455962.0251 5790517.3475,4455913.121799999 5790457.1138,4455866.6319 5790420.9844,4455758.2746 5790350.311,4455709.628899999 5790319.31,4455684.524 5790297.7464,4455429.3096 5790233.6947,4455417.2707 5790244.7419,4455386.6853 5790273.861199999,4455345.1134 5790311.7484,4455515.3859 5790492.021999999,4455525.0798 5790502.8179,4455522.407399999 5790505.6684,4455519.8196 5790508.050799999,4455514.0343 5790514.1453,4455492.471599999 5790537.0402,4455322.443799999 5790645.434399999,4455371.3096 5790822.0272,4455309.646099999 5790848.2783)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (241,240,176259180.0,'NULL','farmland',297.150005772,4435.05509864, ST_GeomFromText('MULTIPOLYGON(((4449897.2564 5789625.264299999,4449987.1091 5789565.076099999,4449961.047399999 5789530.842499999,4449874.741899999 5789591.874399999,4449897.2564 5789625.264299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (242,241,176259181.0,'NULL','farm',3719.33099273,524511.779378, ST_GeomFromText('MULTIPOLYGON(((4448676.786299999 5788404.8912,4448676.786299999 5788957.3493,4448746.1527 5788942.9371,4448758.310399999 5788960.950099999,4448769.3244 5788983.337099999,4448782.9862 5789028.5316,4448813.367899999 5789130.584799999,4448842.2191 5789226.811799999,4448888.6606 5789322.846,4448949.4522 5789389.487999999,4448958.673399999 5789430.3332,4448981.350599999 5789497.368799999,4448989.042399999 5789532.387599999,4448970.4422 5789576.446399999,4448904.3092 5789702.8877,4448897.190799999 5789723.425799999,4448898.7954 5789736.573799999,4448912.3786 5789774.4472,4448918.556599999 5789805.096999999,4448892.6436 5789850.6895,4448966.203599999 5789876.248199999,4448997.0136 5789878.8572,4449051.168399999 5789870.988099999,4449049.4356 5789844.687999999,4449059.6505 5789840.1983,4449084.4643 5789829.705,4449078.2806 5789799.066199999,4449091.4259 5789794.535299999,4449116.3002 5789789.894999999,4449135.0129 5789756.0734,4449174.641999999 5789618.211799999,4449219.9697 5789464.211999999,4449259.130599999 5789279.5512,4449291.5564 5789153.448999999,4449344.6271 5789038.842599999,4449374.828599999 5788981.491,4449382.8262 5788888.2671,4448676.786299999 5788404.8912)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (243,242,176259182.0,'NULL','farmland',644.748026258,18268.2116179, ST_GeomFromText('MULTIPOLYGON(((4449959.5776 5789497.6512,4449916.282399999 5789495.5854,4449825.033499999 5789464.605599999,4449766.3139 5789487.7245,4449722.022599999 5789510.697599999,4449815.4291 5789630.478,4449837.4411 5789636.508799999,4449854.9084 5789627.573999999,4449836.286399999 5789584.607999999,4449959.5776 5789497.6512)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (244,243,180748272.0,'NULL','farmland',7.31942973868,0.27441687485, ST_GeomFromText('MULTIPOLYGON(((4451238.2289 5789078.924499999,4451241.1198 5789081.077199999,4451238.350999999 5789078.8343,4451238.2289 5789078.924499999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (245,244,185618076.0,'NULL','industrial',526.889317133,13947.3685516, ST_GeomFromText('MULTIPOLYGON(((4459660.355899999 5796768.2322,4459703.7911 5796795.140799999,4459763.269299999 5796823.599199999,4459815.4527 5796850.159199999,4459810.0926 5796821.036699999,4459791.352099999 5796766.428999999,4459760.9532 5796714.3757,4459734.221699999 5796671.2617,4459715.819899999 5796654.1414,4459706.375599999 5796662.987199999,4459692.735 5796695.9481,4459660.355899999 5796768.2322)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (246,245,194825731.0,'NULL','farmland',535.315861239,9726.74249586, ST_GeomFromText('MULTIPOLYGON(((4460220.288499999 5793090.143999999,4460253.7218 5793057.3596,4460093.434899999 5792936.4568,4460037.695799999 5792949.515,4460220.288499999 5793090.143999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (247,246,194826649.0,'NULL','basin',107.338123707,449.132431427, ST_GeomFromText('MULTIPOLYGON(((4460391.4619 5793882.871799999,4460435.022599999 5793881.065099999,4460434.746 5793872.0983,4460391.899 5793870.972699999,4460391.4619 5793882.871799999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (248,247,195324787.0,'NULL','basin',174.872032102,655.992833329, ST_GeomFromText('MULTIPOLYGON(((4461826.973799999 5793975.0382,4461821.3217 5793981.1466,4461879.540199999 5794034.7224,4461885.185499999 5794028.614199999,4461826.973799999 5793975.0382)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (249,248,195324805.0,'NULL','basin',176.210410893,690.796480858, ST_GeomFromText('MULTIPOLYGON(((4461816.0608 5793986.651,4461810.1451 5793993.084,4461868.698099999 5794046.668199999,4461874.607099999 5794040.2464,4461816.0608 5793986.651)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (250,249,195324810.0,'NULL','basin',174.436161997,651.426524304, ST_GeomFromText('MULTIPOLYGON(((4461805.3561 5793998.7072,4461799.7861 5794004.837099999,4461858.3545 5794057.764599999,4461863.9177 5794051.6347,4461805.3561 5793998.7072)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (251,250,195419722.0,'NULL','meadow',282.231047153,4655.77879808, ST_GeomFromText('MULTIPOLYGON(((4462477.625799999 5794085.315099999,4462521.4906 5794057.2072,4462475.592799999 5793982.0983,4462430.062699999 5794011.1651,4462477.625799999 5794085.315099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (252,251,195431808.0,'NULL','meadow',251.471793597,4257.20608542, ST_GeomFromText('MULTIPOLYGON(((4461478.124599999 5794764.8036,4461523.122399999 5794760.9921,4461540.463499999 5794754.8814,4461549.9461 5794750.067199999,4461548.9521 5794739.8484,4461532.6412 5794713.502399999,4461520.293999999 5794702.771299999,4461500.636199999 5794693.6105,4461477.382199999 5794693.2354,4461468.889299999 5794706.8219,4461478.124599999 5794764.8036)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (253,252,195437497.0,'NULL','industrial',1003.08955122,59597.7349158, ST_GeomFromText('MULTIPOLYGON(((4460698.325199999 5795037.703099999,4460797.6315 5795050.0558,4461034.4762 5795050.3737,4460995.887 5794891.472599999,4460960.738099999 5794786.503399999,4460769.8305 5794868.792899999,4460704.681499999 5795008.074699999,4460698.325199999 5795037.703099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (254,253,195437513.0,'NULL','basin',124.753651429,763.971137249, ST_GeomFromText('MULTIPOLYGON(((4460837.2466 5794965.047599999,4460881.922299999 5794956.1586,4460878.625199999 5794939.6599,4460833.9561 5794948.537799999,4460837.2466 5794965.047599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (255,254,195437529.0,'NULL','basin',123.164053047,743.080654323, ST_GeomFromText('MULTIPOLYGON(((4460841.474799999 5794987.069399999,4460885.597 5794978.118,4460882.288399999 5794961.886499999,4460838.1661 5794970.849099999,4460841.474799999 5794987.069399999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (256,255,195437532.0,'NULL','basin',107.793653484,498.631240361, ST_GeomFromText('MULTIPOLYGON(((4460898.9127 5794980.928099999,4460910.533499999 5794978.254399999,4460901.078999999 5794937.356599999,4460889.4649 5794940.0302,4460898.9127 5794980.928099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (257,256,195437541.0,'NULL','basin',52.909319012,96.3806190387, ST_GeomFromText('MULTIPOLYGON(((4460803.649199999 5795000.044099999,4460825.6955 5794998.878799999,4460825.462899999 5794994.5074,4460803.4166 5794995.6727,4460803.649199999 5795000.044099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (258,257,195438015.0,'NULL','basin',20.3319203915,32.4380195762, ST_GeomFromText('MULTIPOLYGON(((4460955.700899999 5795003.079399999,4460956.827899999 5795003.215199999,4460957.9314 5795002.9616,4460958.8074 5795002.4206,4460959.516999999 5795001.5359,4460959.877 5795000.4647,4460959.8832 5794999.518799999,4460959.5266 5794998.442299999,4460958.8304 5794997.557499999,4460957.781299999 5794996.920399999,4460956.667399999 5794996.7289,4460955.5498 5794996.915799999,4460954.815799999 5794997.2999,4460954.0031 5794998.0853,4460953.519799999 5794999.1018,4460953.4203 5795000.3266,4460953.735999999 5795001.414599999,4460954.4051 5795002.321799999,4460955.700899999 5795003.079399999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (259,258,195438018.0,'NULL','basin',23.4214191501,42.9225427744, ST_GeomFromText('MULTIPOLYGON(((4460953.7307 5794988.6622,4460954.9208 5794988.1409,4460955.855399999 5794987.2322,4460956.366499999 5794986.282299999,4460956.574699999 5794985.0009,4460956.339399999 5794983.723099999,4460956.020399999 5794983.069099999,4460955.1528 5794982.096699999,4460954.0015 5794981.482599999,4460952.226099999 5794981.3409,4460951.001099999 5794981.762299999,4460949.990799999 5794982.582599999,4460949.484899999 5794983.3322,4460949.1057 5794984.570399999,4460949.170599999 5794985.871799999,4460949.4082 5794986.571,4460950.139999999 5794987.6446,4460951.196899999 5794988.403999999,4460952.4554 5794988.761299999,4460953.7307 5794988.6622)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (260,259,195438019.0,'NULL','basin',24.2510133682,46.0651715035, ST_GeomFromText('MULTIPOLYGON(((4460944.1204 5794986.6907,4460943.5579 5794985.459899999,4460942.608699999 5794984.510399999,4460941.7794 5794984.060799999,4460940.460199999 5794983.792999999,4460939.1243 5794983.992699999,4460937.941999999 5794984.636399999,4460937.177199999 5794985.4436,4460936.6068 5794986.6611,4460936.4878 5794988.0085,4460937.0816 5794989.7509,4460937.9971 5794990.7451,4460939.189399999 5794991.358799999,4460940.309899999 5794991.5392,4460941.6458 5794991.328299999,4460942.8211 5794990.662499999,4460943.700199999 5794989.642899999,4460944.181499999 5794988.381599999,4460944.1204 5794986.6907)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (261,260,195438020.0,'NULL','basin',22.8259467153,40.8633889763, ST_GeomFromText('MULTIPOLYGON(((4460946.409599999 5795005.2115,4460947.042399999 5795004.116,4460947.2646 5795002.8679,4460947.0432 5795001.6234,4460946.751799999 5795001.013599999,4460945.9253 5795000.051999999,4460944.938 5794999.4701,4460943.694099999 5794999.223999999,4460942.439899999 5794999.4119,4460941.3256 5795000.0216,4460940.6555 5795000.7169,4460940.098 5795001.8452,4460939.957899999 5795003.1149,4460940.0936 5795003.8705,4460940.6485 5795005.012299999,4460941.343399999 5795005.7301,4460942.4605 5795006.3333,4460943.7176 5795006.512499999,4460944.957499999 5795006.257899999,4460946.409599999 5795005.2115)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (262,261,196105699.0,'NULL','retail',1495.85420345,109371.740683, ST_GeomFromText('MULTIPOLYGON(((4461367.3322 5794437.8551,4461818.894199999 5794144.8438,4461422.5777 5794030.3242,4461258.308299999 5794275.5754,4461339.7844 5794329.385399999,4461300.5794 5794378.7882,4461367.3322 5794437.8551)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (263,262,196105707.0,'NULL','retail',557.140649173,13765.5203112, ST_GeomFromText('MULTIPOLYGON(((4460834.7888 5794194.5328,4460879.038099999 5794234.353499999,4460850.7148 5794263.788399999,4460906.005099999 5794311.200099999,4461030.501 5794173.6227,4460960.183299999 5794170.527899999,4460895.0707 5794178.3428,4460834.7888 5794194.5328)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (264,263,196111578.0,'NULL','industrial',795.920919642,33709.848282, ST_GeomFromText('MULTIPOLYGON(((4460536.211799999 5794361.945499999,4460637.6606 5794291.9545,4460643.6335 5794283.5054,4460642.9017 5794218.202099999,4460643.2229 5794025.488099999,4460603.544099999 5794054.2915,4460538.343 5794096.440999999,4460508.5558 5794172.2814,4460501.586099999 5794216.525699999,4460504.837199999 5794279.138199999,4460529.5568 5794349.057,4460536.211799999 5794361.945499999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (265,264,196111583.0,'NULL','industrial',1703.33380255,106454.965194, ST_GeomFromText('MULTIPOLYGON(((4460725.0453 5794254.559399999,4460792.9276 5794299.187999999,4460800.557699999 5794288.8342,4460874.240199999 5794349.8537,4460851.959599999 5794376.069299999,4460925.7565 5794428.508999999,4460929.1276 5794435.3593,4461068.255199999 5794528.290799999,4461165.4594 5794551.628499999,4461204.785099999 5794525.758899999,4461168.8442 5794469.979399999,4461272.517799999 5794386.0854,4461309.965699999 5794331.989099999,4461216.091599999 5794266.448,4461120.071499999 5794204.319599999,4461051.9954 5794184.224899999,4461025.080799999 5794183.880799999,4460906.1983 5794313.1905,4460849.0564 5794263.8015,4460877.0125 5794234.536499999,4460832.922 5794194.9593,4460800.2664 5794209.105799999,4460725.0453 5794254.559399999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (266,265,196111612.0,'NULL','garages',315.128500768,5595.37507848, ST_GeomFromText('MULTIPOLYGON(((4460262.193599999 5794841.1589,4460312.707 5794909.044199999,4460374.578399999 5794863.446399999,4460344.203999999 5794819.323499999,4460311.006799999 5794834.189799999,4460294.3974 5794817.342299999,4460262.193599999 5794841.1589)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (267,266,196115439.0,'NULL','residential',2612.06738816,197308.573673, ST_GeomFromText('MULTIPOLYGON(((4458096.802699999 5795443.5811,4458124.9439 5795421.1423,4458225.799999999 5795288.4002,4458326.8678 5795162.301799999,4458505.5854 5794980.1246,4458685.316399999 5794820.424,4458706.411899999 5794787.097599999,4458667.7001 5794772.009299999,4458496.3551 5794727.064999999,4458355.1957 5794701.9579,4458281.544099999 5794693.821699999,4458081.5579 5794725.46,4458083.842199999 5794779.1216,4458106.919099999 5794781.118,4458107.9094 5794768.323599999,4458242.4171 5794768.7203,4458235.6945 5795030.160299999,4458135.4592 5795033.935599999,4458133.989199999 5795123.772399999,4458103.8167 5795131.406099999,4458096.6796 5795213.546099999,4458016.552799999 5795287.325799999,4458096.802699999 5795443.5811)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (268,267,196115448.0,'NULL','allotments',966.578218107,36105.0608819, ST_GeomFromText('MULTIPOLYGON(((4458110.864799999 5794771.592399999,4458099.587399999 5795125.154699999,4458128.4994 5795124.1862,4458129.5387 5795031.0591,4458233.484899999 5795028.7213,4458239.7258 5794770.8574,4458110.864799999 5794771.592399999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (269,268,196180964.0,'NULL','allotments',911.161867935,19785.9632216, ST_GeomFromText('MULTIPOLYGON(((4460736.610299999 5794880.017699999,4460963.554399999 5794783.6436,4461094.8068 5794761.7879,4461091.252 5794728.955399999,4461020.294499999 5794737.182,4461017.548399999 5794688.4304,4460952.0886 5794723.109899999,4460717.305599999 5794845.8419,4460736.610299999 5794880.017699999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (270,269,196194769.0,'NULL','meadow',445.305116945,11429.7314318, ST_GeomFromText('MULTIPOLYGON(((4462196.558 5794185.1597,4462234.142099999 5794241.111899999,4462248.45 5794244.1072,4462375.225399999 5794160.605399999,4462360.236399999 5794139.899499999,4462337.257899999 5794127.656099999,4462320.7576 5794124.499199999,4462294.3776 5794121.7739,4462196.558 5794185.1597)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (271,270,196201255.0,'NULL','farmland',1945.08396438,148105.924788, ST_GeomFromText('MULTIPOLYGON(((4462460.690299999 5793848.8231,4462594.405299999 5794003.029999999,4462684.5437 5793934.558,4462829.122499999 5794102.4208,4462744.030399999 5794180.1215,4462811.6096 5794256.672,4462865.571399999 5794324.200999999,4462921.400299999 5794318.807499999,4463009.398599999 5794238.172599999,4463012.935999999 5794075.258199999,4463015.0722 5794046.9777,4462989.671199999 5793979.967499999,4462953.730499999 5793874.679099999,4462923.4241 5793837.2946,4462847.5338 5793776.1391,4462801.6845 5793765.156099999,4462735.301699999 5793799.262099999,4462628.3897 5793800.069599999,4462568.3321 5793799.422599999,4462460.690299999 5793848.8231)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (272,271,196350557.0,'NULL','industrial',313.619195334,5249.41868574, ST_GeomFromText('MULTIPOLYGON(((4458918.191499999 5794166.989399999,4458983.473199999 5794115.726199999,4458935.0289 5794057.696299999,4458882.5602 5794109.209499999,4458921.166899999 5794150.528799999,4458910.425499999 5794158.1072,4458918.191499999 5794166.989399999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (273,272,196353046.0,'NULL','allotments',469.462335687,12717.5088194, ST_GeomFromText('MULTIPOLYGON(((4457904.594999999 5793638.2674,4457825.938 5793603.874099999,4457766.3326 5793742.0797,4457845.517599999 5793773.763399999,4457904.594999999 5793638.2674)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (274,273,196353047.0,'NULL','allotments',687.892190345,27474.7768021, ST_GeomFromText('MULTIPOLYGON(((4457527.4729 5793643.686699999,4457633.999699999 5793682.5767,4457753.722 5793487.826199999,4457739.1781 5793478.592,4457565.737499999 5793493.966,4457527.4729 5793643.686699999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (275,275,196353058.0,'NULL','farmland',1654.54669289,177337.493033, ST_GeomFromText('MULTIPOLYGON(((4457597.961299999 5793195.250499999,4457752.062199999 5793400.675699999,4457863.0614 5793469.7224,4457918.036799999 5793454.0532,4457981.308199999 5793401.6478,4458176.5762 5793021.5547,4458156.626799999 5793001.2594,4458055.61 5793008.692299999,4458026.961199999 5792998.709,4457954.6666 5792959.730499999,4457786.518799999 5792975.919399999,4457597.961299999 5793195.250499999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (276,277,196353063.0,'NULL','residential',675.850965679,22510.1842492, ST_GeomFromText('MULTIPOLYGON(((4457830.3025 5793600.175799999,4457906.3651 5793631.308499999,4457942.6716 5793551.7355,4457985.0184 5793557.807099999,4458013.4779 5793545.880999999,4458032.5892 5793531.9757,4458034.2629 5793470.235099999,4457968.722799999 5793428.417199999,4457880.767099999 5793503.956599999,4457795.8611 5793576.5894,4457830.3025 5793600.175799999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (277,278,196353067.0,'NULL','farmland',1174.20762013,87200.7151552, ST_GeomFromText('MULTIPOLYGON(((4457139.2004 5793185.91,4457426.094299999 5793331.0084,4457454.177 5793274.515,4457510.718 5793291.554999999,4457537.342799999 5793151.0591,4457429.126299999 5793002.219799999,4457196.423299999 5793027.6094,4457156.8371 5793108.318099999,4457139.2004 5793185.91)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (278,279,196353736.0,'NULL','industrial',1001.262635,46562.6645642, ST_GeomFromText('MULTIPOLYGON(((4454203.8601 5790658.312899999,4454257.1644 5790662.059399999,4454358.302899999 5790639.347699999,4454435.922299999 5790736.424499999,4454537.246799999 5790653.779699999,4454366.0502 5790446.295399999,4454297.6287 5790496.6356,4454282.721599999 5790469.7214,4454203.8601 5790658.312899999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (279,280,196383814.0,'NULL','residential',369.44247028,6203.84381697, ST_GeomFromText('MULTIPOLYGON(((4462634.995 5787934.1081,4462545.3211 5787934.9416,4462532.7082 5787984.9,4462597.026399999 5788001.950799999,4462585.1446 5788038.3835,4462622.611999999 5787993.8124,4462636.350599999 5787968.8384,4462640.943699999 5787945.4022,4462634.995 5787934.1081)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (280,281,197477741.0,'NULL','allotments',604.899101532,21489.713171, ST_GeomFromText('MULTIPOLYGON(((4453821.893099999 5794775.662799999,4453993.572599999 5794779.9254,4453984.4264 5794746.103499999,4453967.2289 5794654.624399999,4453792.2708 5794649.080199999,4453821.893099999 5794775.662799999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (281,282,197672680.0,'NULL','industrial',280.788744234,4631.74628751, ST_GeomFromText('MULTIPOLYGON(((4460195.889299999 5795696.4002,4460203.755499999 5795754.7024,4460280.8918 5795752.312,4460294.314399999 5795737.237099999,4460220.3437 5795678.6323,4460195.889299999 5795696.4002)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (282,283,197795607.0,'NULL','allotments',492.222522742,8663.55024289, ST_GeomFromText('MULTIPOLYGON(((4459963.279699999 5794591.9055,4460040.3574 5794525.193199999,4460116.9978 5794449.7057,4460101.8365 5794431.567399999,4460060.620299999 5794455.1465,4460037.6639 5794468.106899999,4459931.8387 5794556.6181,4459963.279699999 5794591.9055)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (283,284,197795610.0,'NULL','railway',1948.5649192,75531.022028, ST_GeomFromText('MULTIPOLYGON(((4459427.7038 5794908.5009,4459456.892799999 5794896.209699999,4459546.004399999 5794825.3736,4459721.067099999 5794699.422199999,4459725.0959 5794704.730799999,4459924.2844 5794568.485999999,4460107.527599999 5794410.334,4460175.2016 5794357.565099999,4460151.2011 5794332.565199999,4460127.0355 5794339.570399999,4460001.544999999 5794344.001099999,4459923.589999999 5794397.0896,4459833.307699999 5794455.6542,4459759.7182 5794545.721,4459676.817499999 5794661.069499999,4459574.008899999 5794758.321499999,4459441.2668 5794865.6696,4459418.4301 5794893.610099999,4459427.7038 5794908.5009)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (284,285,197796574.0,'NULL','industrial',4437.93088628,489307.365843, ST_GeomFromText('MULTIPOLYGON(((4459722.752799999 5794434.933,4459746.9012 5794437.662799999,4459891.0743 5794374.207599999,4459890.432199999 5794331.259299999,4460028.5382 5794331.364,4460033.157599999 5794259.5076,4460138.358099999 5794333.6369,4460641.906799999 5793977.660099999,4460658.7421 5793838.3728,4460473.4933 5793796.753299999,4460454.2696 5793728.2374,4459969.728199999 5793901.115199999,4459618.1869 5794116.673499999,4459362.2434 5794337.534499999,4459316.496399999 5794382.467,4459434.666899999 5794745.910199999,4459432.864799999 5794758.321399999,4459479.421199999 5794830.6598,4459596.442699999 5794726.0007,4459544.936599999 5794650.8308,4459584.144199999 5794609.9711,4459563.6988 5794571.791799999,4459532.576999999 5794571.6795,4459544.7345 5794536.1599,4459465.381299999 5794413.7364,4459589.450899999 5794367.674399999,4459632.116299999 5794392.1629,4459695.611499999 5794271.9868,4459706.960799999 5794294.4615,4459722.752799999 5794434.933)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (285,286,197796575.0,'NULL','residential',279.825545547,3285.22694598, ST_GeomFromText('MULTIPOLYGON(((4460032.5913 5794334.6139,4460128.881799999 5794334.9375,4460036.760499999 5794266.1663,4460032.5913 5794334.6139)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (286,416,0.0,'NULL','farm',5045.78208736,1345996.24777, ST_GeomFromText('MULTIPOLYGON(((4461127.1643 5792355.8671,4461188.547799999 5792400.317199999,4461252.047899999 5792387.6171,4461978.065999999 5792101.866599999,4462630.000699999 5791854.216099999,4462617.300699999 5791579.0489,4462718.900899999 5791236.148199999,4462670.2174 5791087.9812,4462395.0502 5790863.614099999,4461567.4319 5791375.8485,4461495.472199999 5791463.818199999,4461403.5255 5791609.9691,4461351.531499999 5791600.2156,4461359.9981 5791722.982499999,4461307.081399999 5791837.2827,4461213.9478 5791913.482899999,4461082.7143 5792040.4831,4461014.9808 5792184.416699999,4461167.381099999 5792300.833599999,4461127.1643 5792355.8671)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (287,417,0.0,'NULL','meadow',1947.09350712,158596.023454, ST_GeomFromText('MULTIPOLYGON(((4460500.8355 5797240.806099999,4460591.228699999 5796896.334499999,4460535.0383 5796735.092499999,4460412.8853 5796730.206399999,4460329.8212 5796590.951899999,4460266.301599999 5796605.6103,4460322.491999999 5796754.637,4460207.6682 5796769.295299999,4460244.3141 5796871.903899999,4460239.428 5796930.537399999,4460236.984899999 5796967.183299999,4460332.264299999 5797082.007099999,4460329.8212 5797194.3879,4460290.7323 5797272.565899999,4460378.6824 5797316.540999999,4460500.8355 5797240.806099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (288,418,0.0,'NULL','farm',1709.42267179,120590.941895, ST_GeomFromText('MULTIPOLYGON(((4460525.266099999 5797260.3506,4460640.089999999 5797301.8826,4460713.381799999 5797504.6567,4460925.9281 5797389.8328,4460906.3836 5797270.1228,4460769.5722 5797125.9822,4460757.3569 5797008.715299999,4460681.622 5797006.272299999,4460630.317699999 5796835.257999999,4460525.266099999 5797260.3506)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (289,287,197796577.0,'NULL','allotments',353.237740089,4369.13349722, ST_GeomFromText('MULTIPOLYGON(((4459897.7175 5794407.2923,4460001.1626 5794341.4448,4460025.295099999 5794337.9668,4460024.175699999 5794335.4164,4459895.276899999 5794332.8113,4459897.7175 5794407.2923)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (290,288,197798981.0,'NULL','allotments',442.347238829,9723.17848873, ST_GeomFromText('MULTIPOLYGON(((4459151.6792 5795127.658199999,4459086.9154 5795174.942399999,4459177.5098 5795285.560499999,4459216.0383 5795258.468499999,4459183.5338 5795216.8629,4459207.133999999 5795193.299399999,4459151.6792 5795127.658199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (291,289,197798982.0,'NULL','allotments',473.660846622,9391.33541673, ST_GeomFromText('MULTIPOLYGON(((4459702.0431 5794611.934499999,4459718.0208 5794600.353599999,4459716.9758 5794467.195199999,4459651.5535 5794440.577199999,4459639.659099999 5794463.308399999,4459659.1511 5794515.138499999,4459633.550099999 5794522.5251,4459649.3639 5794576.0766,4459677.444699999 5794562.338099999,4459702.0431 5794611.934499999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (292,290,197798990.0,'NULL','allotments',559.212410626,16147.1686734, ST_GeomFromText('MULTIPOLYGON(((4459261.4719 5795168.380699999,4459378.975899999 5795081.605799999,4459326.313799999 5794996.9778,4459177.491899999 5795105.9012,4459203.014399999 5795138.1948,4459224.8376 5795120.855399999,4459261.4719 5795168.380699999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (293,291,197800345.0,'NULL','farmland',1470.31861328,69990.7708995, ST_GeomFromText('MULTIPOLYGON(((4457780.904299999 5795188.1151,4457839.0148 5795176.668899999,4457855.4493 5795179.344,4457882.0195 5795197.478299999,4457896.632 5795200.169099999,4457909.0992 5795196.156999999,4457954.583499999 5795170.8319,4457995.207499999 5795162.919199999,4458097.024199999 5795126.2781,4458105.4638 5794783.333599999,4458081.652999999 5794781.710699999,4458079.028699999 5794730.6114,4458050.507199999 5794735.2379,4458049.667 5794808.277499999,4458001.6864 5794806.1258,4457999.0482 5794969.3834,4457976.5263 5794990.016899999,4457959.6781 5795031.789799999,4457778.214399999 5795044.287599999,4457780.904299999 5795188.1151)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (294,292,197800349.0,'NULL','meadow',636.876498854,9731.20128403, ST_GeomFromText('MULTIPOLYGON(((4457710.8162 5795168.2728,4457739.730999999 5795167.658099999,4457741.6572 5795185.424,4457766.233799999 5795191.4231,4457782.031 5795191.399399999,4457836.1742 5795187.642999999,4457857.792299999 5795190.017899999,4457876.9143 5795206.1794,4457880.5711 5795199.6829,4457855.5272 5795181.2795,4457837.9318 5795178.5031,4457778.713399999 5795188.8683,4457775.6675 5795046.501599999,4457705.405899999 5795049.6621,4457710.8162 5795168.2728)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (295,293,197800354.0,'NULL','farmland',2396.35205581,146973.467475, ST_GeomFromText('MULTIPOLYGON(((4457445.9187 5795311.1271,4457448.093799999 5795402.012399999,4457266.014 5795441.775699999,4457324.278699999 5795550.492599999,4457488.8321 5795455.242599999,4457511.5027 5795495.2082,4457521.961299999 5795519.5774,4457546.360999999 5795583.742599999,4457554.8684 5795593.896099999,4457604.2766 5795593.104399999,4457587.205699999 5795480.425,4457671.410299999 5795445.6399,4457757.284099999 5795422.3706,4457825.5273 5795398.4187,4457919.942599999 5795352.345,4457951.6719 5795424.3616,4458008.6528 5795502.6402,4458088.7843 5795449.124099999,4458042.259399999 5795358.9714,4457982.5948 5795272.5697,4457951.915199999 5795238.145099999,4457935.0135 5795230.254599999,4457930.829099999 5795211.673299999,4457905.184799999 5795210.0668,4457881.0548 5795213.1881,4457874.413599999 5795207.402499999,4457854.1599 5795192.9755,4457764.479399999 5795193.741599999,4457736.9724 5795187.400299999,4457611.168399999 5795201.9878,4457587.8721 5795217.154799999,4457588.724499999 5795231.3912,4457588.445899999 5795283.973099999,4457501.227199999 5795296.262499999,4457445.9187 5795311.1271)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (296,294,197804430.0,'NULL','residential',2277.12339962,100209.866825, ST_GeomFromText('MULTIPOLYGON(((4457534.3207 5794502.267999999,4457674.292899999 5794524.613399999,4457684.839499999 5794539.211799999,4457913.029199999 5794570.568199999,4457999.987999999 5794237.9053,4457945.5295 5794225.1041,4457942.1688 5794200.740399999,4457924.0663 5794198.9249,4457928.954099999 5794158.143999999,4457741.2433 5794120.6983,4457591.8507 5794092.344699999,4457556.691399999 5794167.6599,4457624.3973 5794221.572,4457662.0075 5794184.482999999,4457690.5723 5794193.3409,4457771.2021 5794217.555299999,4457816.166699999 5794235.0982,4457828.622499999 5794337.4019,4457862.723399999 5794336.910599999,4457856.596699999 5794403.5745,4457828.9093 5794391.7926,4457804.5855 5794437.4133,4457769.3634 5794465.545099999,4457691.467 5794469.149399999,4457705.884499999 5794442.419099999,4457549.5882 5794425.254,4457534.3207 5794502.267999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (297,295,197804450.0,'NULL','allotments',766.968074316,25585.6622847, ST_GeomFromText('MULTIPOLYGON(((4457407.496 5794675.909299999,4457629.8024 5794663.948999999,4457639.5296 5794652.247999999,4457651.787399999 5794580.6795,4457662.3233 5794528.7331,4457533.051799999 5794503.914699999,4457507.694799999 5794620.263599999,4457425.8923 5794608.2488,4457407.496 5794675.909299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (298,296,197805138.0,'NULL','meadow',1211.43940768,50045.8679968, ST_GeomFromText('MULTIPOLYGON(((4457534.5897 5794075.410299999,4457593.865899999 5794081.3998,4457915.1577 5794145.8539,4458005.536299999 5793958.3812,4457982.9034 5793964.115299999,4457960.5869 5794026.2763,4457938.514499999 5794014.412699999,4457926.8025 5793965.5942,4457636.4878 5793996.6513,4457620.0891 5794014.529799999,4457539.0366 5794021.8135,4457534.5897 5794075.410299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (299,297,197806272.0,'NULL','meadow',1193.9016947,71824.5730901, ST_GeomFromText('MULTIPOLYGON(((4457534.145299999 5794417.552699999,4457709.710599999 5794440.505799999,4457696.7515 5794466.188699999,4457768.095099999 5794460.092199999,4457800.097599999 5794435.3596,4457826.0958 5794392.4064,4457853.6227 5794400.5731,4457860.069099999 5794340.983799999,4457826.020999999 5794341.274299999,4457818.49 5794273.781199999,4457812.2543 5794235.7214,4457662.5202 5794188.5514,4457626.233799999 5794227.2092,4457559.224 5794183.595499999,4457496.845499999 5794301.609099999,4457473.313199999 5794411.1322,4457534.145299999 5794417.552699999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (300,298,197806273.0,'NULL','residential',564.449514931,19480.9934003, ST_GeomFromText('MULTIPOLYGON(((4457986.119599999 5794567.798399999,4458114.3141 5794581.1871,4458147.8376 5794426.548,4458004.3974 5794435.4436,4457986.119599999 5794567.798399999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (301,299,198428784.0,'NULL','farm',1178.11360565,34606.2245394, ST_GeomFromText('MULTIPOLYGON(((4462360.2915 5792877.3442,4462507.921 5792797.5712,4462485.637299999 5792758.8934,4462493.346499999 5792684.401499999,4462504.108799999 5792668.5296,4462497.1775 5792614.3344,4462515.106999999 5792573.9272,4462516.112099999 5792512.906199999,4462524.3969 5792472.7835,4462464.065499999 5792486.761499999,4462424.433199999 5792524.685499999,4462411.931499999 5792585.660399999,4462404.8684 5792600.458399999,4462399.5118 5792637.6324,4462420.0838 5792645.877399999,4462480.852699999 5792642.132999999,4462493.1028 5792645.088999999,4462494.9406 5792665.0382,4462488.053299999 5792674.226399999,4462450.643799999 5792667.5667,4462418.010599999 5792662.3399,4462392.910799999 5792665.5798,4462360.2915 5792877.3442)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (302,300,198428789.0,'NULL','farm',2984.32170853,355447.123083, ST_GeomFromText('MULTIPOLYGON(((4462492.123999999 5791922.1947,4461864.5257 5792170.9384,4461854.7674 5792253.9711,4461780.6188 5792213.6271,4461736.1517 5792298.7311,4461837.962899999 5792354.6511,4462134.573699999 5792517.795099999,4462142.268899999 5792527.6732,4462142.340499999 5792537.019899999,4462140.6776 5792549.8964,4462139.674999999 5792556.269099999,4462117.975599999 5792719.056199999,4462097.4204 5792851.0109,4462209.1522 5792916.231799999,4462242.8162 5792927.8923,4462285.2377 5792917.909499999,4462342.4653 5792889.7762,4462492.123999999 5791922.1947)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (303,301,198428790.0,'NULL','farmland',612.51616056,15318.9245871, ST_GeomFromText('MULTIPOLYGON(((4462833.5914 5792406.7539,4462779.935999999 5792431.627499999,4462775.054899999 5792561.357799999,4462761.4921 5792587.1651,4462766.829699999 5792663.1161,4462862.242399999 5792613.313899999,4462834.057799999 5792517.804999999,4462833.5914 5792406.7539)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (304,302,198428792.0,'NULL','farm',2123.8437089,281143.199922, ST_GeomFromText('MULTIPOLYGON(((4463201.4649 5792313.6782,4463201.4649 5792216.469399999,4462994.62 5791808.2212,4462947.293499999 5791750.121899999,4462648.3737 5791863.9933,4462613.4868 5792436.299799999,4462775.731999999 5792408.301999999,4463127.807599999 5792327.991699999,4463201.4649 5792313.6782)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (305,303,198428795.0,'NULL','scrub',1490.17813414,93388.2069871, ST_GeomFromText('MULTIPOLYGON(((4462495.8748 5791921.5653,4462414.0158 5792474.5898,4462606.740799999 5792438.0534,4462645.997399999 5791864.8903,4462495.8748 5791921.5653)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (306,304,198439598.0,'NULL','meadow',741.253316816,22726.4601953, ST_GeomFromText('MULTIPOLYGON(((4462325.5208 5787921.832,4462479.448099999 5787918.470699999,4462594.514899999 5787912.8484,4462599.2351 5787858.320599999,4462620.9203 5787816.8399,4462471.483699999 5787835.151599999,4462452.821499999 5787837.1292,4462318.932099999 5787856.173299999,4462325.5208 5787921.832)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (307,305,198444244.0,'NULL','residential',261.476433371,4249.36181057, ST_GeomFromText('MULTIPOLYGON(((4461974.3277 5789592.4901,4461951.993999999 5789657.169099999,4462010.9205 5789677.413799999,4462033.261699999 5789612.734999999,4461974.3277 5789592.4901)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (308,306,198444245.0,'NULL','farmland',1150.16446465,49732.1660774, ST_GeomFromText('MULTIPOLYGON(((4462196.6626 5790105.0304,4462318.726999999 5790139.6632,4462375.6276 5790172.012299999,4462388.0223 5790163.516599999,4462378.440899999 5790060.513599999,4462343.5925 5790007.043199999,4462341.957 5789985.122899999,4462374.902499999 5789864.7265,4462408.938 5789830.0054,4462416.308899999 5789816.5294,4462417.485999999 5789778.141,4462402.3359 5789762.176599999,4462373.1227 5789747.4765,4462350.4027 5789799.671299999,4462282.406399999 5789773.950099999,4462196.6626 5790105.0304)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (309,307,198444247.0,'NULL','residential',751.258251172,17622.1577899, ST_GeomFromText('MULTIPOLYGON(((4462218.5393 5789684.3143,4462194.650799999 5789750.5953,4462224.794999999 5789762.7947,4462208.517199999 5789814.818499999,4462261.048999999 5789831.7879,4462276.192599999 5789771.6051,4462282.406399999 5789773.950099999,4462350.4027 5789799.671299999,4462373.1227 5789747.4765,4462349.2198 5789736.686499999,4462383.791799999 5789660.1432,4462336.7258 5789639.8483,4462306.359299999 5789718.674399999,4462218.5393 5789684.3143)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (310,308,198444248.0,'NULL','residential',248.499237618,3754.1969305, ST_GeomFromText('MULTIPOLYGON(((4462106.9862 5789641.124099999,4462082.215699999 5789708.024399999,4462131.099 5789727.390499999,4462156.0558 5789659.754599999,4462106.9862 5789641.124099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (311,309,198444249.0,'NULL','residential',869.186792209,35586.960032, ST_GeomFromText('MULTIPOLYGON(((4462552.256 5790369.501599999,4462567.721599999 5790379.621999999,4462583.109699999 5790379.505499999,4462613.6445 5790373.5328,4462659.854399999 5790352.9758,4462647.352599999 5790324.672299999,4462650.046299999 5790315.037699999,4462637.403099999 5790290.6411,4462761.4917 5790225.020099999,4462697.877999999 5790222.316899999,4462698.997999999 5790149.822699999,4462628.3458 5790136.9471,4462609.4378 5790129.667799999,4462483.057799999 5790231.8756,4462552.256 5790369.501599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (312,310,198444250.0,'NULL','farmland',526.562852987,11972.0403399, ST_GeomFromText('MULTIPOLYGON(((4462171.4505 5790210.4912,4462345.086199999 5790300.1687,4462375.616499999 5790247.780799999,4462186.1856 5790153.471499999,4462171.4505 5790210.4912)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (313,311,48921394.0,'NULL','farmland',1874.4858107,197554.746478, ST_GeomFromText('MULTIPOLYGON(((4455270.8108 5797692.8131,4455927.4959 5797692.8131,4455817.7931 5797332.4472,4455469.651399999 5797376.082,4455214.081699999 5797490.298,4455270.8108 5797692.8131)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (314,312,100242683.0,'NULL','meadow',3075.15374227,272365.489486, ST_GeomFromText('MULTIPOLYGON(((4456401.362599999 5797692.8131,4457191.6193 5797692.8131,4457179.861999999 5797678.963199999,4457173.934399999 5797670.245799999,4457045.838899999 5796993.2203,4456913.630099999 5797024.284499999,4456721.617499999 5797494.6194,4456693.491399999 5797541.581399999,4456659.609899999 5797600.2785,4456621.215599999 5797644.4045,4456621.059999999 5797543.6753,4456628.701299999 5797330.4626,4456590.401899999 5797384.825699999,4456499.367899999 5797517.7499,4456401.362599999 5797692.8131)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (315,313,100246486.0,'NULL','meadow',1048.71308093,47293.5649535, ST_GeomFromText('MULTIPOLYGON(((4457205.5711 5797692.8131,4457637.8469 5797692.8131,4457629.887099999 5797684.5598,4457414.5652 5797487.1447,4457192.2954 5797678.120799999,4457205.5711 5797692.8131)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (316,314,100237211.0,'NULL','meadow',769.966548015,34505.9512283, ST_GeomFromText('MULTIPOLYGON(((4457885.3375 5797692.8131,4458125.4851 5797692.8131,4458180.627399999 5797647.401799999,4458170.8243 5797614.9801,4458167.056699999 5797602.604399999,4458168.4674 5797596.027,4458087.929399999 5797507.6534,4458045.679399999 5797530.6466,4457946.7565 5797600.826799999,4457921.308799999 5797620.028,4457888.024799999 5797664.834899999,4457885.248399999 5797682.373999999,4457885.3375 5797692.8131)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (317,315,196201251.0,'NULL','farmland',931.380207011,24212.6783263, ST_GeomFromText('MULTIPOLYGON(((4463201.4649 5794406.754799999,4463194.6149 5794409.013299999,4463107.140999999 5794432.822699999,4463056.581199999 5794428.0818,4462996.879399999 5794404.648499999,4462951.972099999 5794372.848099999,4462914.7805 5794363.412699999,4462870.1467 5794368.1323,4462826.856999999 5794385.4722,4462810.564 5794409.697599999,4463081.683199999 5794484.7235,4463186.19 5794506.5885,4463201.4649 5794507.8372,4463201.4649 5794406.754799999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (318,316,134413098.0,'NULL','farm',995.659423309,55610.0109321, ST_GeomFromText('MULTIPOLYGON(((4463201.4649 5794365.6304,4463201.4649 5794024.033299999,4463039.058199999 5794072.748099999,4463031.843999999 5794381.040699999,4463082.4806 5794395.995999999,4463115.407499999 5794392.8234,4463201.4649 5794365.6304)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (319,317,134413094.0,'NULL','farm',868.328158131,46838.6331775, ST_GeomFromText('MULTIPOLYGON(((4463201.4649 5794000.7616,4463201.4649 5793759.531999999,4463114.546299999 5793786.579299999,4462972.894 5793842.4207,4462998.177099999 5793942.7816,4463043.273199999 5794048.6139,4463201.4649 5794000.7616)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (320,318,97845271.0,'NULL','residential',1197.24888706,38689.2188316, ST_GeomFromText('MULTIPOLYGON(((4463201.4649 5793088.283199999,4463184.0426 5793088.930999999,4463180.453599999 5793256.8528,4463102.336099999 5793255.6217,4463102.6155 5793345.1533,4463033.491999999 5793325.996099999,4463053.923299999 5793451.063699999,4463077.261099999 5793501.186599999,4463201.4649 5793546.516799999,4463201.4649 5793088.283199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (321,319,134413443.0,'NULL','farm',544.734442369,13640.4089937, ST_GeomFromText('MULTIPOLYGON(((4463201.4649 5792608.119,4463068.5734 5792682.050499999,4463187.0157 5792799.788399999,4463201.4649 5792813.710599999,4463201.4649 5792608.119)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (322,320,90155693.0,'NULL','farmland',5859.7985137,753105.749826, ST_GeomFromText('MULTIPOLYGON(((4463201.4649 5791565.1665,4463201.4649 5790161.5459,4463052.207999999 5790242.9032,4463044.906499999 5790246.618799999,4463046.545199999 5790367.219399999,4463053.972099999 5790380.316899999,4463067.9846 5790392.641799999,4463103.9937 5790406.260399999,4463096.2615 5790548.1293,4463139.2055 5790509.062499999,4463154.440799999 5790488.4852,4463198.385099999 5790387.285599999,4463199.313099999 5790412.861199999,4463188.757399999 5790472.1501,4463175.748399999 5790496.3606,4463161.233 5790515.474799999,4463109.7933 5790594.074699999,4462961.6831 5790484.806099999,4462986.326299999 5790252.8988,4462917.0853 5790303.1248,4462771.8886 5790387.550699999,4462744.966 5790413.335999999,4462715.2955 5790463.267,4462682.3343 5790562.1959,4462661.3448 5790597.439999999,4462644.661399999 5790619.4875,4462561.752299999 5790702.715299999,4462550.098299999 5790715.9899,4462536.233799999 5790724.1402,4462491.2856 5790788.0646,4462484.1017 5790807.125199999,4462483.443099999 5790816.633199999,4462488.616299999 5790822.4361,4462504.0585 5790829.629799999,4462531.304299999 5790846.971699999,4462540.226499999 5790864.4414,4462553.6078 5790889.9227,4462569.8536 5790905.8792,4462589.0941 5790931.316199999,4462601.711 5790952.418999999,4462620.159699999 5790969.8168,4462551.6923 5790926.480499999,4462445.3804 5790822.040899999,4462419.8913 5790842.6984,4462669.1473 5791048.353299999,4462702.371899999 5791081.719399999,4462704.049599999 5791109.481499999,4462703.510499999 5791135.8026,4462705.0504 5791145.293999999,4462731.266099999 5791221.0986,4462733.602699999 5791239.3527,4462730.096699999 5791259.8429,4462641.570399999 5791568.192099999,4462638.2017 5791607.6765,4462645.939 5791855.354299999,4462947.6451 5791740.549399999,4462949.706899999 5791722.262299999,4463027.557799999 5791681.853399999,4463057.027599999 5791574.573499999,4463201.4649 5791565.1665)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (323,321,90155698.0,'NULL','farm',3853.41214494,817572.265287, ST_GeomFromText('MULTIPOLYGON(((4463201.4649 5788973.325799999,4463201.4649 5787750.9308,4463200.0842 5787750.4417,4463153.222599999 5787759.5589,4462730.653699999 5787922.159099999,4462683.882799999 5787942.9864,4462662.1287 5787975.331599999,4462636.0032 5788010.636399999,4462586.666899999 5788079.755699999,4462444.023599999 5788407.8,4462470.688199999 5788406.2068,4462477.509999999 5788418.217399999,4462435.4741 5788427.449599999,4462237.87 5788881.9275,4462291.924499999 5788910.948,4462827.1747 5788951.1085,4463149.0372 5788973.337799999,4463201.4649 5788973.325799999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (324,322,48981186.0,'NULL','farm',1974.70123416,159495.007095, ST_GeomFromText('MULTIPOLYGON(((4463201.4649 5787739.294199999,4463201.4649 5787505.036299999,4462773.165599999 5787505.036299999,4462759.594899999 5787566.0348,4462753.1353 5787583.142,4462741.0037 5787606.656999999,4462726.955 5787635.138299999,4462663.015899999 5787757.7126,4462648.7795 5787788.376499999,4462642.4488 5787810.6907,4462639.9616 5787827.0449,4462643.9035 5787846.8001,4462650.461799999 5787863.698,4462662.5519 5787864.730699999,4462810.2774 5787853.3923,4462798.380499999 5787859.8912,4462656.761199999 5787879.8189,4462665.066999999 5787908.2542,4462670.9702 5787913.517599999,4462673.6282 5787919.817999999,4462698.2279 5787919.5436,4462725.0573 5787914.0558,4462758.624599999 5787902.174799999,4462914.773799999 5787839.5557,4463118.993499999 5787754.405799999,4463154.2674 5787742.9153,4463174.612399999 5787739.2476,4463194.8876 5787738.117599999,4463201.4649 5787739.294199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (325,323,30246639.0,'NULL','farm',3549.5767128,344597.574664, ST_GeomFromText('MULTIPOLYGON(((4462773.165599999 5787505.036299999,4461496.582999999 5787505.036299999,4461310.0705 5787711.016599999,4461334.124699999 5787786.886399999,4461413.260599999 5787780.426899999,4461416.0394 5787759.919199999,4461506.879599999 5787750.443399999,4461568.373999999 5787738.259299999,4461632.807099999 5787726.0532,4461790.878299999 5787686.807399999,4461928.513 5787659.4078,4461934.990699999 5787738.353299999,4461985.169999999 5787763.706,4462040.656 5787754.8121,4462078.3535 5787756.693099999,4462154.5377 5787684.014,4462198.660699999 5787701.225199999,4462190.759399999 5787818.303999999,4462314.195299999 5787852.470499999,4462387.467899999 5787846.0601,4462472.407499999 5787830.7937,4462642.4488 5787810.6907,4462648.7795 5787788.376499999,4462663.015899999 5787757.7126,4462726.955 5787635.138299999,4462741.0037 5787606.656999999,4462753.1353 5787583.142,4462773.165599999 5787505.036299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (326,324,30246639.0,'NULL','farm',650.049749031,21917.2196207, ST_GeomFromText('MULTIPOLYGON(((4461424.4533 5787505.036299999,4461185.225599999 5787505.036299999,4461198.976999999 5787543.0569,4461228.170699999 5787615.1358,4461240.680999999 5787633.910399999,4461247.9002 5787643.8021,4461297.970999999 5787664.297,4461402.481499999 5787525.9875,4461424.4533 5787505.036299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (327,325,30318852.0,'NULL','farm',2109.87557969,179001.644966, ST_GeomFromText('MULTIPOLYGON(((4461161.596599999 5787505.036299999,4460423.0131 5787505.036299999,4460761.4088 5787695.394099999,4461085.4526 5787877.1443,4461137.187699999 5787891.3596,4461221.610899999 5787886.6026,4461300.685499999 5787872.5304,4461166.4956 5787515.503399999,4461161.596599999 5787505.036299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (328,326,48979542.0,'NULL','farm',3817.73983789,685126.14737, ST_GeomFromText('MULTIPOLYGON(((4457407.648099999 5787505.036299999,4455838.313 5787505.036299999,4456558.135599999 5788275.8563,4457060.0755 5788007.725199999,4457061.093899999 5788006.1696,4457231.651399999 5787745.6267,4457403.065999999 5787573.0701,4457407.648099999 5787505.036299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (329,327,174599649.0,'NULL','farmland',3769.66205099,681043.160088, ST_GeomFromText('MULTIPOLYGON(((4454044.643 5787505.036299999,4452633.3843 5787505.036299999,4452631.358599999 5787512.387,4452588.9521 5787694.7015,4452588.305499999 5787709.2519,4452731.9709 5787934.6103,4453191.193699999 5788035.561899999,4453208.954099999 5787975.425599999,4453239.0765 5787981.717599999,4453274.4274 5787998.2092,4453289.181699999 5788008.3077,4453284.932699999 5788023.704399999,4453492.150399999 5788072.218499999,4453487.231599999 5788094.943399999,4453587.0935 5788110.820499999,4453751.808899999 5788161.9363,4453784.5059 5788130.183399999,4453808.306599999 5788088.2761,4453837.430399999 5788066.0602,4453858.389 5788033.694,4453868.9681 5787988.9724,4453920.2618 5787749.344799999,4453975.6412 5787632.531899999,4454005.3706 5787597.147099999,4454044.643 5787505.036299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (330,328,196355666.0,'Biogasanlage','industrial',615.786857056,17687.5032313, ST_GeomFromText('MULTIPOLYGON(((4452622.191399999 5787505.036299999,4452437.925999999 5787505.036299999,4452503.4555 5787598.0623,4452583.053999999 5787693.990199999,4452614.646999999 5787530.162399999,4452622.191399999 5787505.036299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (331,329,49368582.0,'NULL','meadow',724.310858609,26790.2731745, ST_GeomFromText('MULTIPOLYGON(((4449697.9071 5787505.036299999,4449505.110299999 5787505.036299999,4449608.934999999 5787729.597599999,4449685.363699999 5787703.8824,4449672.3934 5787654.282899999,4449672.0811 5787623.561499999,4449677.5433 5787584.012499999,4449697.9071 5787505.036299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (332,330,47679811.0,'NULL','farm',2488.0751244,207866.006237, ST_GeomFromText('MULTIPOLYGON(((4448676.786299999 5791076.2539,4448676.786299999 5792120.891599999,4448751.955 5792146.1457,4448795.1095 5792123.597999999,4448984.278599999 5792032.2389,4449066.440299999 5792021.6325,4448676.786299999 5791076.2539)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (333,331,47679776.0,'NULL','farm',1455.0341947,92511.7872006, ST_GeomFromText('MULTIPOLYGON(((4448676.786299999 5792215.661199999,4448676.786299999 5792770.797299999,4448965.567099999 5792738.5697,4448763.1259 5792289.082499999,4448712.528699999 5792229.859999999,4448676.786299999 5792215.661199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (334,332,34424013.0,'NULL','meadow',1745.64435884,156622.530886, ST_GeomFromText('MULTIPOLYGON(((4448676.786299999 5792791.103,4448676.786299999 5793264.022299999,4448764.219399999 5793302.291899999,4448795.2065 5793302.949999999,4448825.9817 5793238.310399999,4448880.5547 5793132.539799999,4448915.0459 5793067.8846,4449064.5355 5793089.254699999,4449065.8996 5792749.230599999,4448694.6501 5792788.902499999,4448676.786299999 5792791.103)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (335,333,35264498.0,'NULL','park',1259.88578049,87779.6566907, ST_GeomFromText('MULTIPOLYGON(((4459570.5815 5790878.801899999,4459548.9241 5790837.049499999,4459553.9225 5790796.8373,4459567.178399999 5790752.429199999,4459571.5283 5790728.9363,4459566.3042 5790718.1739,4459557.701799999 5790680.1872,4459552.4855 5790672.0621,4459528.021099999 5790647.157899999,4459525.214399999 5790637.1993,4459258.2604 5790731.339999999,4459155.0197 5790779.595899999,4459156.896099999 5790785.9901,4459159.0811 5790793.360899999,4459168.5031 5790789.6443,4459172.165799999 5790799.796,4459168.154799999 5790801.2312,4459173.1527 5790815.0997,4459176.673299999 5790813.8354,4459180.9724 5790825.7846,4459176.695799999 5790827.311,4459182.2319 5790842.6773,4459184.955799999 5790841.697799999,4459188.300999999 5790853.944199999,4459180.698699999 5790856.3438,4459186.705099999 5790873.253,4459173.255599999 5790878.037699999,4459165.751899999 5790891.553099999,4459168.8799 5790898.982899999,4459180.850399999 5790911.1358,4459200.7001 5790931.2802,4459271.887199999 5790953.7058,4459338.5267 5790943.9436,4459570.5815 5790878.801899999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (336,334,38242299.0,'NULL','forest',1150.60615261,77259.5227126, ST_GeomFromText('MULTIPOLYGON(((4458599.1407 5793635.782199999,4458910.9638 5793548.162599999,4458895.3534 5793438.315899999,4458771.5645 5793287.7412,4458582.6478 5793314.748099999,4458601.971199999 5793383.7236,4458622.0738 5793589.019999999,4458599.1407 5793635.782199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (337,335,38242301.0,'Klingteich','water',282.268905054,5143.69025064, ST_GeomFromText('MULTIPOLYGON(((4457998.985299999 5793928.0689,4458024.506 5793928.007799999,4458034.566999999 5793927.198999999,4458044.886699999 5793911.0316,4458046.0968 5793898.4023,4458044.587299999 5793888.6337,4458035.075799999 5793872.979599999,4458041.983799999 5793856.1401,4457999.6507 5793860.205399999,4457978.964599999 5793851.7015,4457959.0146 5793882.394999999,4457962.4938 5793902.2287,4457976.2308 5793920.3059,4457998.985299999 5793928.0689)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (338,336,38242303.0,'NULL','forest',1774.24604885,105984.473481, ST_GeomFromText('MULTIPOLYGON(((4458310.9187 5794473.219299999,4458170.2368 5794436.9743,4458153.555599999 5794451.3593,4458128.944899999 5794571.3484,4458115.872499999 5794583.878,4458104.186099999 5794587.627,4457891.7504 5794576.2913,4457684.993099999 5794545.1862,4457673.539099999 5794575.229499999,4457658.5771 5794623.563899999,4457658.0968 5794653.513199999,4457670.1018 5794687.005499999,4457672.9105 5794728.8668,4458015.150999999 5794708.163699999,4458098.5548 5794700.1556,4458184.1184 5794688.469499999,4458248.484 5794679.890699999,4458305.560499999 5794680.1431,4458310.9187 5794473.219299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (339,337,38293149.0,'NULL','forest',7896.55009913,908403.350051, ST_GeomFromText('MULTIPOLYGON(((4459135.4226 5792866.3012,4459084.416699999 5792863.763199999,4459102.3282 5792686.838199999,4459102.5443 5792624.6652,4459164.62 5792579.2846,4459077.722099999 5792601.8694,4459014.5455 5792460.824599999,4458978.0519 5792624.584,4458971.423999999 5792642.866499999,4458701.3865 5792650.3343,4458433.313599999 5792629.134899999,4458395.387799999 5792608.945399999,4458016.269299999 5792638.524,4457976.815499999 5792439.592599999,4458064.8561 5792456.137599999,4458223.648799999 5792499.037399999,4458281.821299999 5792360.8167,4457999.8715 5792190.310699999,4458008.926599999 5792141.404699999,4458024.1988 5792090.465199999,4458125.523299999 5791951.876599999,4457999.2344 5791903.128399999,4457910.9269 5792091.4283,4457781.522599999 5792309.391499999,4457822.7489 5792505.368499999,4457879.3348 5792604.5249,4457880.2087 5792707.083,4457983.3776 5792788.2618,4458018.0613 5792849.5042,4458124.0838 5792890.1896,4458092.3662 5792995.004799999,4458099.182 5792996.0932,4458159.4187 5792995.571699999,4458183.235299999 5793021.0755,4457984.7887 5793425.620999999,4458043.1304 5793473.4648,4458036.490299999 5793537.996099999,4457990.883 5793573.169399999,4458060.537299999 5793644.7531,4458094.9323 5793677.577899999,4458200.154099999 5793760.5241,4458241.0618 5793785.572,4458455.7488 5793862.669999999,4458549.465499999 5793718.5449,4458431.0623 5793701.4901,4458327.122999999 5793682.057299999,4458295.741299999 5793668.000499999,4458200.160099999 5793580.486099999,4458149.711099999 5793503.4743,4458141.350599999 5793472.242399999,4458142.9186 5793449.4392,4458160.810499999 5793422.035499999,4458212.664699999 5793361.617499999,4458252.1189 5793320.0776,4458536.9127 5793324.000499999,4458582.6478 5793314.748099999,4458605.79 5793257.7353,4458623.2969 5793201.904899999,4458659.0054 5793172.3065,4458691.1413 5793145.664699999,4458845.9309 5793167.8197,4458877.8064 5793108.944,4458897.3073 5793076.544399999,4459098.2158 5793105.634899999,4459097.4643 5793090.7298,4459094.252299999 5793064.7507,4459090.792399999 5793005.5236,4459135.525799999 5792994.381799999,4459153.239799999 5792952.850899999,4459160.2125 5792919.254,4459159.6971 5792905.626599999,4459138.1474 5792899.4174,4459135.4226 5792866.3012)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (340,338,38293150.0,'NULL','forest',530.593460914,16688.8626472, ST_GeomFromText('MULTIPOLYGON(((4458639.9923 5792542.3956,4458795.847099999 5792539.335799999,4458813.030299999 5792421.1151,4458681.7987 5792425.7267,4458639.9923 5792542.3956)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (341,339,38293151.0,'NULL','water',417.28444473,9876.94077469, ST_GeomFromText('MULTIPOLYGON(((4458669.227199999 5793104.819599999,4458688.3173 5793022.614299999,4458544.0771 5793053.3999,4458576.2598 5793134.953199999,4458669.227199999 5793104.819599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (342,340,38293152.0,'NULL','forest',547.634153336,17500.2000807, ST_GeomFromText('MULTIPOLYGON(((4458259.5992 5792117.6939,4458401.085599999 5792215.872999999,4458458.9252 5792124.7837,4458313.424399999 5792036.562799999,4458285.5103 5792078.639,4458259.5992 5792117.6939)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (343,341,43869090.0,'NULL','forest',5322.07176544,806706.198932, ST_GeomFromText('MULTIPOLYGON(((4458825.868599999 5792132.819499999,4458871.360199999 5791895.095399999,4459063.504599999 5791954.291999999,4459054.407999999 5792129.753,4459282.610799999 5792157.100899999,4459314.7379 5792215.290899999,4459314.5981 5792269.651399999,4459422.8004 5792243.0457,4459570.501299999 5792384.783399999,4459610.635499999 5792423.3025,4459655.1172 5792416.5074,4459936.5794 5792654.467399999,4460051.826999999 5792630.155099999,4460038.1583 5792389.437799999,4460079.855399999 5792327.7199,4460007.272699999 5792265.7572,4459785.065899999 5792038.405099999,4459661.7125 5791904.3519,4459734.639299999 5791864.008899999,4459751.860299999 5791846.342399999,4459742.938699999 5791803.139,4459708.7591 5791708.119,4459693.1325 5791660.8976,4459695.174399999 5791624.0479,4459688.3601 5791606.566099999,4459665.697399999 5791602.655899999,4459611.5301 5791573.275499999,4459568.611299999 5791556.6675,4459364.5371 5791544.308299999,4459311.204699999 5791545.3366,4459268.971099999 5791541.589299999,4459217.881699999 5791529.7365,4459150.0805 5791508.674799999,4459129.4056 5791560.289499999,4459063.7202 5791541.548399999,4459064.37 5791493.014599999,4459000.618999999 5791468.0379,4458967.9313 5791455.222699999,4458963.5734 5791463.3377,4458839.2176 5791694.8284,4458750.825799999 5791638.278999999,4458608.4923 5791859.287599999,4458490.6511 5792064.883099999,4458599.3386 5792166.281099999,4458653.4265 5792046.571399999,4458825.868599999 5792132.819499999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (344,342,43996580.0,'Dorfsteinbruch','water',845.58302794,3799.52051684, ST_GeomFromText('MULTIPOLYGON(((4458405.524299999 5790623.0535,4458391.455 5790623.1719,4458386.165799999 5790622.048,4458373.858599999 5790622.151499999,4458369.1469 5790619.854299999,4458366.754999999 5790614.021199999,4458366.6911 5790606.421499999,4458367.8146 5790601.1486,4458367.755599999 5790594.138499999,4458354.7822 5790584.8892,4458344.792899999 5790582.0467,4458334.8233 5790581.5521,4458306.111899999 5790583.541099999,4458293.246899999 5790587.165899999,4458278.639399999 5790593.1312,4458254.1513 5790609.1282,4458244.191499999 5790609.790899999,4458238.3217 5790608.6721,4458232.437199999 5790605.806299999,4458224.8053 5790604.702299999,4458216.5217 5790595.992399999,4458204.145399999 5790587.917999999,4458184.722299999 5790579.3024,4458170.0409 5790576.510999999,4458165.957799999 5790578.2926,4458160.145399999 5790584.7736,4458151.923 5790582.5064,4458147.270499999 5790587.219399999,4458143.768 5790589.0073,4458139.6534 5790587.8737,4458131.416199999 5790583.8483,4458124.3667 5790582.1609,4458120.222299999 5790577.511199999,4458114.3426 5790575.224199999,4458109.067999999 5790575.8475,4458104.3958 5790578.234999999,4458099.735299999 5790581.189999999,4458095.630599999 5790581.224799999,4458091.535799999 5790582.438999999,4458089.213 5790584.795499999,4458088.670199999 5790590.063599999,4458089.3666 5790602.921499999,4458093.5902 5790616.917899999,4458097.152099999 5790622.1511,4458109.503899999 5790627.31,4458118.315499999 5790628.993599999,4458124.7527 5790627.7595,4458132.930599999 5790624.7748,4458152.3139 5790628.7058,4458162.2735 5790628.031799999,4458163.974399999 5790621.5855,4458170.974399999 5790617.431199999,4458178.018899999 5790618.5401,4458190.308199999 5790615.5096,4458192.715099999 5790623.1007,4458204.515899999 5790631.7697,4458208.0431 5790632.908299999,4458212.698699999 5790629.3637,4458221.490399999 5790628.699599999,4458264.342899999 5790635.9382,4458291.963 5790643.8953,4458310.7341 5790644.9054,4458323.663099999 5790648.891499999,4458321.394399999 5790657.6793,4458329.648099999 5790662.873299999,4458339.0646 5790667.467599999,4458350.2186 5790669.131899999,4458359.6007 5790669.642699999,4458369.5455 5790667.210999999,4458380.645399999 5790662.4439,4458389.963499999 5790655.3438,4458399.8887 5790650.5866,4458409.272699999 5790650.507699999,4458414.506 5790645.789999999,4458421.525799999 5790643.972799999,4458427.3759 5790642.7552,4458433.257399999 5790644.463999999,4458437.927799999 5790642.6666,4458440.8381 5790640.305299999,4458440.2379 5790637.9735,4458436.6911 5790634.486899999,4458420.8254 5790630.5252,4458416.1107 5790627.059599999,4458413.717 5790621.816199999,4458409.5877 5790618.9243,4458405.524299999 5790623.0535)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (345,343,44500195.0,'NULL','water',232.407736669,2845.23067963, ST_GeomFromText('MULTIPOLYGON(((4462442.061999999 5790304.071599999,4462471.156 5790251.316999999,4462456.226499999 5790235.4064,4462432.022699999 5790234.1324,4462405.761099999 5790241.6206,4462397.920199999 5790268.664799999,4462398.844999999 5790294.184699999,4462424.5153 5790304.2049,4462442.061999999 5790304.071599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (346,344,44506206.0,'NULL','water',335.348123786,7098.61320212, ST_GeomFromText('MULTIPOLYGON(((4457773.2909 5790481.534399999,4457860.2263 5790489.261299999,4457877.932599999 5790454.191299999,4457850.123499999 5790422.669399999,4457776.9653 5790415.8822,4457742.253299999 5790444.754899999,4457773.2909 5790481.534399999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (347,345,44848342.0,'NULL','forest',512.211478297,12029.6547289, ST_GeomFromText('MULTIPOLYGON(((4458237.836 5790967.7155,4458247.360199999 5790964.0853,4458255.127199999 5790939.994699999,4458265.589599999 5790929.379499999,4458277.1873 5790914.081,4458304.815799999 5790923.206499999,4458318.2427 5790916.661499999,4458325.672 5790893.7868,4458325.971699999 5790860.456499999,4458312.4314 5790853.56,4458299.512699999 5790850.7423,4458274.912299999 5790853.286699999,4458267.951999999 5790862.114099999,4458261.603699999 5790873.862999999,4458253.449099999 5790880.3637,4458239.390399999 5790881.6508,4458216.492999999 5790877.170499999,4458184.2564 5790878.0328,4458157.910899999 5790881.7609,4458147.986299999 5790886.5185,4458139.856599999 5790895.9458,4458137.583499999 5790904.1552,4458137.6577 5790912.923299999,4458141.816599999 5790919.3199,4458155.366899999 5790927.384199999,4458170.6971 5790938.3712,4458223.621399999 5790957.7982,4458237.836 5790967.7155)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (348,346,44849286.0,'NULL','forest',409.517823024,9418.591092, ST_GeomFromText('MULTIPOLYGON(((4459943.5295 5791275.6773,4459945.835799999 5791278.8078,4460009.8265 5791253.5195,4460022.094299999 5791248.7355,4460035.494199999 5791238.690099999,4460045.3557 5791225.167999999,4460051.665199999 5791208.158299999,4460054.946 5791178.8991,4460052.985799999 5791154.356,4460030.1716 5791159.8037,4459998.050099999 5791174.6743,4459983.3857 5791173.6245,4459977.5548 5791177.176899999,4459972.9533 5791188.3308,4459953.168399999 5791206.0284,4459948.564199999 5791216.0028,4459914.870199999 5791236.472699999,4459943.5295 5791275.6773)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (349,347,48822689.0,'NULL','water',123.607355289,1026.59528376, ST_GeomFromText('MULTIPOLYGON(((4448767.1489 5793921.990599999,4448778.205699999 5793928.4527,4448789.149799999 5793924.6893,4448800.048299999 5793916.5306,4448801.4477 5793909.9505,4448797.721199999 5793903.412299999,4448784.489299999 5793899.164999999,4448772.001299999 5793894.9099,4448763.917899999 5793892.8015,4448756.6398 5793897.261399999,4448758.213299999 5793907.471899999,4448763.429999999 5793916.186899999,4448767.1489 5793921.990599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (350,348,48822691.0,'NULL','water',218.702523005,235773.6026, ST_GeomFromText('MULTIPOLYGON(((4448811.487399999 5793889.392899999,4448820.880099999 5793876.876499999,4448824.4477 5793868.070499999,4448826.494099999 5793853.437999999,4448825.673 5793844.6775,4448814.690999999 5793844.7913,4448802.256599999 5793846.3779,4448785.4116 5793846.5524,4448761.927099999 5793841.687999999,4448752.4057 5793841.7868,4448748.0557 5793846.216399999,4448744.5261 5793858.6721,4448746.7844 5793864.4909,4448757.058799999 5793866.5766,4448780.5584 5793872.9098,4448790.162999999 5793880.844799999,4448796.802299999 5793885.883799999,4448811.487399999 5793889.392899999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (351,349,48822696.0,'NULL','water',574.664465643,27150.3560763, ST_GeomFromText('MULTIPOLYGON(((4449014.079599999 5794359.912699999,4448995.557099999 5794338.915799999,4448976.372899999 5794325.236999999,4448961.734699999 5794326.1227,4448950.829199999 5794333.535499999,4448942.9194 5794347.494,4448936.3797 5794352.6806,4448930.5241 5794352.7411,4448926.0913 5794349.1369,4448928.9511 5794342.5306,4448936.943099999 5794335.8712,4448938.328099999 5794328.5568,4448938.169599999 5794313.2126,4448941.668399999 5794297.1074,4448944.4528 5794283.2017,4448949.4198 5794267.8157,4448946.408999999 5794259.8123,4448936.797799999 5794251.142599999,4448915.452399999 5794240.402,4448904.4494 5794239.0579,4448893.5513 5794247.205199999,4448877.6715 5794269.280899999,4448870.5147 5794285.4241,4448866.4598 5794318.3388,4448875.4851 5794341.6257,4448890.4784 5794375.0666,4448912.7263 5794401.867,4448928.192699999 5794410.4649,4448943.6138 5794414.690099999,4448955.309 5794412.377,4448967.689899999 5794406.406799999,4448988.0469 5794391.5852,4449004.770299999 5794380.4624,4449011.264899999 5794370.903,4449014.079599999 5794359.912699999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (352,350,48822708.0,'NULL','water',257.617800734,4496.82650452, ST_GeomFromText('MULTIPOLYGON(((4449219.7548 5794065.6129,4449221.026999999 5794046.604,4449221.464499999 5794018.1113,4449218.3864 5794003.5316,4449205.161999999 5793999.283099999,4449185.427 5794003.135999999,4449169.4023 5794011.3354,4449162.929499999 5794023.097699999,4449159.437199999 5794039.9261,4449159.625199999 5794058.196599999,4449164.1332 5794069.1004,4449179.6078 5794078.4447,4449202.382899999 5794085.5106,4449214.876899999 5794089.766599999,4449220.695199999 5794086.0568,4449219.7548 5794065.6129)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (353,351,48912649.0,'NULL','water',212.514095614,2562.6227349, ST_GeomFromText('MULTIPOLYGON(((4449084.758999999 5796174.718,4449128.6281 5796169.8813,4449150.5436 5796165.282199999,4449159.2636 5796159.350099999,4449160.670199999 5796153.4933,4449156.216599999 5796147.696799999,4449134.165699999 5796139.165999999,4449110.6999 5796135.023199999,4449082.946 5796141.151699999,4449071.3528 5796152.9559,4449071.503399999 5796167.5545,4449084.758999999 5796174.718)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (354,352,48914420.0,'NULL','forest',19059.4038502,9568259.25313, ST_GeomFromText('MULTIPOLYGON(((4449291.478799999 5797692.8131,4454105.5124 5797692.8131,4454386.593 5797607.432199999,4454433.258299999 5797589.4744,4454481.296 5797561.3,4454538.011199999 5797521.3616,4454784.9949 5797321.992699999,4454727.0031 5797127.2827,4454609.3267 5797064.1212,4454667.4948 5797022.702199999,4454619.420699999 5796888.817299999,4454549.1699 5796889.4637,4454461.779 5796936.995799999,4454270.4729 5797143.175599999,4454105.680499999 5797051.2627,4454273.512199999 5796839.4516,4453993.1934 5796917.982999999,4453853.6139 5797018.570499999,4453795.178999999 5797030.7905,4453736.580199999 5797025.508199999,4453630.922299999 5796997.288399999,4453583.814899999 5796968.530999999,4453478.5403 5796981.206499999,4453384.7087 5796964.564999999,4453284.734199999 5796918.794399999,4453249.273799999 5796884.0877,4453256.0842 5796761.859099999,4453244.432 5796755.337099999,4452838.430599999 5796528.1797,4452832.936599999 5796525.1052,4452659.6709 5796714.283299999,4452474.2028 5796859.751499999,4452446.458399999 5796815.8289,4452562.4363 5796697.9013,4452631.569199999 5796580.425699999,4452531.8673 5796563.856599999,4452600.279299999 5796370.4494,4452764.278099999 5796374.7199,4452813.7867 5796125.355499999,4452577.603799999 5796098.629499999,4452607.837299999 5795938.1169,4452707.5584 5795954.687599999,4452783.068599999 5795889.7003,4452843.798899999 5795503.565199999,4452216.5552 5795445.329399999,4452170.216699999 5795498.3582,4452076.0054 5795446.691199999,4452070.4845 5795481.798299999,4451906.569 5795489.234099999,4451900.3097 5795448.399199999,4451589.9144 5795435.696799999,4451554.614299999 5795434.251299999,4451447.076899999 5795480.665599999,4451443.8086 5795482.0776,4451344.246 5795483.057399999,4451274.378499999 5795524.6422,4451228.101599999 5795583.5217,4451081.1807 5795532.3943,4451067.672 5795547.762599999,4450982.7207 5795644.3627,4450924.584499999 5795633.422399999,4450850.115699999 5795727.706199999,4450799.2351 5795767.606599999,4450729.1823 5795804.8165,4450670.0722 5795823.990599999,4450647.9462 5795803.7025,4450586.560899999 5795814.354,4450547.274299999 5795721.893799999,4450795.2669 5795637.7805,4450758.0546 5795470.450099999,4450748.361899999 5795452.363399999,4450690.6239 5795385.2136,4450676.813699999 5795362.8058,4450667.232599999 5795334.0907,4450645.7719 5795322.553799999,4450610.224299999 5795291.7058,4450594.6341 5795271.5083,4450582.608 5795254.9364,4450580.354 5795233.5817,4450584.951799999 5795210.9122,4450594.8485 5795194.0208,4450603.469499999 5795181.2596,4450620.0251 5795167.6179,4450615.518199999 5795155.7224,4450416.2182 5795153.178799999,4450345.577399999 5795118.2561,4450289.661399999 5795091.354199999,4450240.943799999 5795081.3286,4450175.1595 5795063.296399999,4450116.473899999 5795052.204099999,4449998.467199999 5794986.205399999,4449928.3864 5794951.8615,4449888.788999999 5795090.2969,4449599.580099999 5795233.4546,4449552.0679 5795241.2398,4449513.232499999 5795237.9865,4449334.496799999 5795229.600999999,4449331.7197 5795228.961799999,4449257.442999999 5795212.130599999,4449119.8502 5795217.1182,4449116.9237 5795217.226199999,4449119.190299999 5795474.998999999,4449109.9127 5795711.6916,4449120.144899999 5795851.790599999,4449165.925999999 5796032.4197,4449269.6879 5796156.945699999,4449308.258399999 5796206.1926,4449339.3967 5796386.9514,4449379.5218 5796588.060799999,4449374.4774 5796666.9671,4449367.338399999 5796827.653999999,4449327.794999999 5796968.2309,4449285.1178 5797088.3978,4449280.2575 5797130.568099999,4449271.6205 5797199.5073,4449290.1467 5797662.841499999,4449291.478799999 5797692.8131)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (355,353,48920559.0,'NULL','water',445.185869505,13334.0296291, ST_GeomFromText('MULTIPOLYGON(((4449387.3212 5792665.728599999,4449403.313199999 5792653.8692,4449409.781 5792641.383999999,4449410.3694 5792627.49,4449406.7527 5792560.301899999,4449403.651899999 5792543.530099999,4449393.165699999 5792520.991599999,4449385.7728 5792514.490599999,4449375.518299999 5792514.595599999,4449360.196499999 5792520.594799999,4449299.1425 5792567.9811,4449287.5246 5792577.6037,4449281.027099999 5792587.1738,4449280.401499999 5792597.406999999,4449285.656 5792609.772099999,4449293.816899999 5792619.9152,4449303.4681 5792632.2463,4449321.205 5792647.410199999,4449335.9687 5792658.943399999,4449349.956399999 5792665.3768,4449359.5025 5792667.4713,4449371.962399999 5792668.078099999,4449387.3212 5792665.728599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (356,354,48920565.0,'NULL','forest',6033.12010262,930508.569512, ST_GeomFromText('MULTIPOLYGON(((4450777.0903 5792534.782999999,4450730.985399999 5792906.420199999,4450489.4593 5793072.494799999,4450762.2263 5793395.6235,4450960.792 5793633.5379,4451048.973299999 5792802.151,4450911.635599999 5792805.260099999,4450933.462 5792642.828999999,4451069.6127 5792662.122099999,4451079.319899999 5792577.0853,4451192.143299999 5791798.3844,4451225.8288 5791574.6337,4451241.549899999 5791364.8036,4451225.6971 5791367.408099999,4451097.9159 5791251.135399999,4450781.4127 5791349.3979,4450781.020899999 5791457.5668,4450706.3848 5791908.496999999,4450698.2865 5791972.241599999,4450688.719299999 5792047.5295,4450606.6467 5792045.4221,4450541.4489 5792265.308599999,4450525.8847 5792320.993499999,4450519.217 5792386.8274,4450520.5723 5792517.469,4450567.4302 5792519.337099999,4450777.0903 5792534.782999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (357,355,48920574.0,'NULL','forest',351.51484169,2664.62027377, ST_GeomFromText('MULTIPOLYGON(((4449729.2811 5795028.3758,4449754.278099999 5795038.3483,4449780.6907 5795043.922,4449798.9258 5795040.5873,4449825.896599999 5795025.201199999,4449831.6401 5795014.1928,4449809.748599999 5795021.715199999,4449781.957399999 5795024.189999999,4449675.0097 5794987.8432,4449674.7658 5794996.058299999,4449688.7613 5795003.9502,4449729.2811 5795028.3758)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (358,356,48920575.0,'NULL','forest',2977.02280277,215948.631251, ST_GeomFromText('MULTIPOLYGON(((4449312.1578 5794586.7763,4449301.6907 5794557.093499999,4449294.075 5794527.9491,4449287.101099999 5794419.698899999,4449277.937699999 5794382.7583,4449267.3721 5794352.1864,4449256.1594 5794330.3901,4449239.097699999 5794308.653999999,4449216.9263 5794289.162699999,4449197.9764 5794277.650599999,4449169.510499999 5794264.689699999,4449150.152599999 5794259.981399999,4449147.9188 5794263.776799999,4449144.304899999 5794267.4418,4449140.003399999 5794269.956499999,4449135.5596 5794271.2486,4449131.254999999 5794271.471,4449131.318599999 5794288.2517,4449119.3342 5794669.437899999,4449115.0059 5794960.173299999,4449119.2542 5795144.690799999,4449146.188299999 5795143.890399999,4449212.837 5795146.1314,4449282.2629 5795133.7335,4449299.0366 5795131.6917,4449302.008299999 5795131.3385,4449309.985199999 5795123.945399999,4449309.0602 5795104.9702,4449517.006199999 5795105.7673,4449516.195799999 5795170.040899999,4449540.335599999 5795167.6019,4449571.648599999 5795151.213099999,4449599.207399999 5795125.3703,4449632.278699999 5795065.875499999,4449520.7438 5795041.4526,4449521.1457 5794939.2027,4449521.162999999 5794935.5525,4449521.352199999 5794886.619899999,4449297.067699999 5794864.0788,4449291.128899999 5794713.686599999,4449345.514999999 5794732.847799999,4449391.8338 5794751.357699999,4449429.3474 5794767.7771,4449442.502299999 5794765.4502,4449413.785699999 5794749.6751,4449396.064 5794735.2453,4449375.9353 5794700.3977,4449312.1578 5794586.7763)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (359,357,48980801.0,'NULL','water',196.806361062,463.367041897, ST_GeomFromText('MULTIPOLYGON(((4448797.9186 5789196.556299999,4448789.8233 5789122.059399999,4448776.624099999 5789122.196,4448769.3994 5789132.5087,4448769.974499999 5789188.0654,4448773.063699999 5789202.666899999,4448797.9186 5789196.556299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (360,358,48980802.0,'NULL','water',202.140717232,2214.89838626, ST_GeomFromText('MULTIPOLYGON(((4449732.4686 5789692.9363,4449755.8753 5789688.314099999,4449766.0317 5789677.9732,4449765.764499999 5789651.657999999,4449752.2766 5789622.5503,4449739.085599999 5789622.684299999,4449717.170199999 5789630.2181,4449712.896599999 5789641.9571,4449716.0798 5789666.7849,4449720.605999999 5789679.9035,4449732.4686 5789692.9363)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (361,359,48980810.0,'NULL','water',212.943906474,2368.1444409, ST_GeomFromText('MULTIPOLYGON(((4448920.4702 5789421.958399999,4448932.1628 5789418.9111,4448934.9879 5789408.644099999,4448933.36 5789392.5807,4448921.449199999 5789375.1546,4448891.878299999 5789350.5997,4448877.1875 5789347.824799999,4448865.5937 5789361.109099999,4448920.4702 5789421.958399999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (362,360,48980811.0,'NULL','water',157.448114347,287.927743276, ST_GeomFromText('MULTIPOLYGON(((4448849.2444 5789339.333399999,4448858.0738 5789342.168899999,4448866.7905 5789334.767599999,4448865.170599999 5789320.162,4448853.281399999 5789304.2048,4448839.908099999 5789286.793899999,4448828.1781 5789286.9152,4448818.037899999 5789298.7157,4448818.113499999 5789306.0261,4448849.2444 5789339.333399999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (363,361,48980814.0,'NULL','water',165.084405118,1505.1128516, ST_GeomFromText('MULTIPOLYGON(((4448797.2735 5789275.5281,4448819.1287 5789262.1486,4448799.5387 5789211.1619,4448777.6078 5789217.2422,4448780.772499999 5789239.142999999,4448797.2735 5789275.5281)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (364,362,49263098.0,'NULL','forest',55571.881075,17329149.9848, ST_GeomFromText('MULTIPOLYGON(((4455309.646099999 5790848.2783,4455371.3096 5790822.0272,4455322.443799999 5790645.434399999,4455287.217699999 5790639.899399999,4455260.775399999 5790604.9186,4455251.5685 5790587.597899999,4455333.1671 5790534.225299999,4455347.553399999 5790504.8624,4455312.253999999 5790490.5591,4455309.000099999 5790455.502199999,4455357.989699999 5790453.323899999,4455399.650299999 5790446.616299999,4455370.1896 5790414.010199999,4455308.418999999 5790391.176999999,4455240.926699999 5790383.0184,4455181.6681 5790313.3712,4455127.7438 5790279.9867,4455061.484 5790314.4615,4455035.9828 5790411.194599999,4455024.6809 5790458.079099999,4454827.7443 5790720.100199999,4454735.290599999 5790867.133099999,4454498.5438 5791148.6948,4454485.8523 5791186.323899999,4454539.379999999 5791237.309499999,4454618.506799999 5791236.582699999,4454691.774299999 5791235.9109,4454837.9822 5791199.487199999,4454914.046699999 5791184.171,4454921.0853 5791312.745799999,4455209.158699999 5791406.5963,4455160.3174 5791515.2135,4455220.9013 5791614.3263,4455135.6491 5791714.493799999,4455084.898299999 5791805.569399999,4455051.944199999 5791919.8746,4455018.8546 5792341.079099999,4454994.6922 5792712.4943,4454698.292399999 5792739.382899999,4454597.446399999 5792747.7639,4454530.162999999 5792814.649499999,4454367.779099999 5792909.020099999,4454263.9334 5792792.023299999,4454177.8393 5792722.6809,4454033.157999999 5792613.2451,4453964.035 5792715.865299999,4453104.444 5792601.192399999,4453119.667999999 5792352.6149,4453272.221599999 5792371.6239,4453301.103699999 5792327.506699999,4453407.248599999 5792396.656099999,4453433.8085 5792416.8703,4453498.3819 5792427.946799999,4453683.101499999 5792440.834899999,4453744.1435 5792387.6502,4453909.771999999 5792390.1872,4453969.670099999 5792460.959499999,4454044.219499999 5792516.373299999,4454105.555999999 5792495.350199999,4454083.472699999 5792326.0315,4454116.9522 5792144.490399999,4454205.8114 5791930.287599999,4453886.221699999 5791912.7936,4453928.1309 5791693.159499999,4453661.116 5791657.652499999,4453547.1594 5791693.808299999,4453480.2247 5791744.135199999,4453337.2406 5791809.791099999,4453060.375599999 5792010.490299999,4452963.5042 5792147.3285,4452810.147599999 5792351.943099999,4452712.2202 5792529.703299999,4452691.1923 5792590.518899999,4452650.483199999 5792623.0576,4452491.8243 5792577.8198,4452542.768 5792390.2681,4452233.933799999 5792309.247999999,4452272.391699999 5792194.880899999,4452296.551599999 5792117.185399999,4452337.1741 5791923.8668,4452357.801599999 5791783.354599999,4452362.210099999 5791632.772199999,4452384.307699999 5791492.234899999,4452383.3908 5791245.2127,4452152.0438 5791388.281999999,4451754.6748 5791264.937899999,4451746.2785 5791305.948799999,4451583.254999999 5791418.6335,4451422.153199999 5791357.0394,4451413.769999999 5791469.993699999,4451481.254599999 5791478.099999999,4451427.210699999 5791645.262099999,4451381.821399999 5791797.717599999,4451192.143299999 5791798.3844,4451079.319899999 5792577.0853,4451069.6127 5792662.122099999,4451048.973299999 5792802.151,4450960.792 5793633.5379,4450964.397199999 5793650.8286,4451000.141599999 5793686.818399999,4451043.745699999 5793702.477499999,4451125.8262 5793707.5073,4451213.640599999 5793700.797299999,4451240.209499999 5793720.9885,4451252.440799999 5793773.4593,4451296.6423 5793799.330299999,4451326.1604 5793822.4085,4451393.8212 5793850.9649,4451458.201799999 5793844.4897,4451501.8786 5793817.7652,4451563.424399999 5793820.077099999,4451607.874499999 5793872.2441,4451640.010999999 5793863.160499999,4451656.814399999 5793784.097899999,4451653.1934 5793714.0041,4451608.8283 5793670.6048,4451535.4819 5793659.6391,4451465.184999999 5793660.328999999,4451432.9039 5793654.803899999,4451452.8627 5793599.0897,4451534.9088 5793601.199999999,4451631.860199999 5793629.4725,4451705.7494 5793695.9635,4451776.480299999 5793739.1063,4451828.6376 5793680.152799999,4451863.355499999 5793635.981,4451876.7514 5793507.276699999,4451617.143799999 5793322.781799999,4451588.018099999 5793340.6048,4451599.1946 5793284.966199999,4451607.4363 5793229.367499999,4451574.643899999 5793171.232899999,4451588.9142 5793133.1018,4451644.4619 5793120.8735,4451646.9615 5793077.004499999,4451605.090099999 5792989.747199999,4451528.0886 5792905.739199999,4451398.5202 5792839.7978,4451313.359799999 5792820.171299999,4451230.868099999 5792774.2243,4451189.506199999 5792739.5568,4451177.034099999 5792663.697399999,4451300.6018 5792715.0809,4451365.320299999 5792740.7506,4451444.7105 5792769.2036,4451521.113599999 5792791.833799999,4451594.9593 5792852.481399999,4451613.110299999 5792910.7595,4451666.153599999 5792942.389599999,4451789.8585 5793008.394999999,4451851.065799999 5792975.649399999,4451979.432099999 5792918.8716,4452049.576299999 5792900.652799999,4452076.3092 5792938.3958,4452076.705799999 5792979.298699999,4451988.927699999 5792991.8462,4451863.526899999 5793051.5105,4451800.183199999 5793166.1127,4451806.8447 5793247.8725,4451872.5996 5793381.6589,4451937.7257 5793451.1542,4452004.3095 5793368.682399999,4452045.263399999 5793362.4426,4452045.887299999 5793426.7346,4452012.265899999 5793584.857,4451983.4879 5793637.739,4451922.6222 5793705.533199999,4451885.139899999 5793767.2583,4451882.6955 5793816.9579,4452032.876899999 5793897.322499999,4452196.0891 5793811.0006,4452257.345499999 5793784.1127,4452287.0283 5793824.732799999,4452150.520499999 5793945.846499999,4452098.1709 5793984.345,4452063.2481 5794008.063799999,4452001.903599999 5794026.186,4451981.7417 5794061.446499999,4451993.658999999 5794081.784099999,4452061.5957 5794139.5581,4451967.755199999 5794128.785,4451882.640999999 5794112.0753,4451794.7763 5794112.9317,4451721.522599999 5794110.731399999,4451639.1922 5794079.3986,4451577.3441 5794123.904699999,4451884.042899999 5794349.935699999,4451919.637699999 5794301.638199999,4451966.297399999 5794280.7309,4452021.946399999 5794280.190199999,4452086.4707 5794288.333,4452090.3617 5794387.6357,4452157.081799999 5794404.193099999,4452124.2947 5794500.8132,4452117.649899999 5794536.309499999,4452176.3277 5794564.117699999,4452254.810499999 5794622.960599999,4452331.4632 5794674.811699999,4452385.6398 5794704.668899999,4452443.258399999 5794726.3255,4452500.2378 5794743.303999999,4452598.222699999 5794759.889499999,4453066.446 5794841.894899999,4453132.139 5794851.208499999,4453202.783699999 5794631.149199999,4453302.356399999 5794630.2069,4453336.5778 5794623.874399999,4453369.387699999 5794594.5204,4453376.7356 5794543.6292,4453416.7339 5794459.357599999,4453508.0229 5794456.094,4453517.196 5794406.788399999,4453497.3742 5794343.533999999,4453456.156799999 5794297.929899999,4453489.5409 5794258.2111,4453526.564399999 5794256.315899999,4453591.589999999 5794240.359099999,4453652.282599999 5794231.0317,4453693.1079 5794211.6533,4453712.251799999 5794223.158299999,4453760.715099999 5794237.3156,4453843.765899999 5794269.411299999,4453895.244699999 5794293.0339,4454360.1028 5794357.377599999,4454790.046 5794289.1491,4454936.810399999 5794322.8614,4455063.337399999 5794385.9953,4455213.860299999 5794188.8651,4455185.9325 5794016.734799999,4455234.7571 5793984.4217,4455262.2582 5794045.532199999,4455309.790199999 5794119.3145,4455343.638799999 5794169.262399999,4455383.526499999 5794163.9612,4455415.819099999 5794172.438599999,4455459.8629 5794183.7257,4455521.157999999 5794159.7936,4455570.840499999 5794147.6622,4455588.2308 5794127.052699999,4455608.5229 5794103.501599999,4455635.097599999 5794126.631599999,4455655.258799999 5794088.470899999,4455681.4335 5794067.7828,4455778.141599999 5794072.7585,4455771.239599999 5793955.943299999,4455922.794099999 5793869.8497,4455950.195199999 5793986.4822,4455973.4505 5793965.821699999,4455954.938199999 5793860.805299999,4456145.0963 5793832.807499999,4456154.3731 5793888.242499999,4456201.4166 5793908.2784,4456233.664499999 5793910.919299999,4456231.228199999 5793966.4582,4456158.001199999 5793967.1074,4456105.380699999 5793979.258899999,4456058.7273 5794003.0534,4456083.6014 5794175.9943,4455954.5558 5794147.1532,4455831.9094 5794189.1434,4455838.235199999 5794241.688699999,4455575.587899999 5794349.224899999,4455575.798 5794372.5918,4455573.520299999 5794445.6563,4455531.7761 5794499.245799999,4455606.1325 5794489.1851,4455655.346599999 5794424.4679,4455907.5508 5794787.3969,4456254.287499999 5794585.6577,4456260.875099999 5794861.0051,4456183.2657 5794853.8811,4456192.0096 5794828.687799999,4456153.5498 5794785.2071,4456092.5673 5794842.9799,4456067.0447 5794845.3879,4456039.1209 5794852.513499999,4456152.7937 5795030.607599999,4456027.3185 5795081.387199999,4456092.804899999 5795200.574999999,4456101.878999999 5795232.620699999,4456105.1177 5795267.645099999,4456096.9265 5795334.9085,4456068.4274 5795422.7947,4456063.0148 5795472.495899999,4456121.6551 5795480.7434,4456206.568099999 5795479.9897,4456201.465099999 5795564.741,4456145.8567 5795568.1501,4456087.243499999 5795562.8287,4456054.980399999 5795557.273499999,4456136.658099999 5795913.7554,4456307.318099999 5796022.0643,4456396.287399999 5796065.266699999,4456431.2071 5796047.5655,4456495.2816 5796009.031899999,4456524.2219 5795970.808299999,4456581.8864 5795868.068299999,4456611.444099999 5795899.9349,4456603.0229 5795940.9042,4456571.379399999 5796005.4353,4456530.648 5796035.004599999,4456554.5058 5796084.447699999,4456581.1357 5796116.3399,4456608.871199999 5796151.4162,4456546.7262 5796132.333,4456463.7723 5796097.086999999,4456446.510599999 5796123.367699999,4456590.5902 5796192.194,4456558.7686 5796236.2736,4456637.5844 5796209.296399999,4456678.6994 5796223.546499999,4456754.921799999 5796234.551599999,4456822.886599999 5796250.003299999,4457052.692499999 5796183.723799999,4457192.936099999 5796141.8333,4457085.6792 5796222.907899999,4457093.2329 5796418.5162,4457099.4159 5796456.430999999,4457131.0625 5796467.2396,4457096.944199999 5796500.942099999,4457101.6083 5796503.817099999,4457138.3101 5796526.444199999,4457142.116399999 5796520.891599999,4457170.796099999 5796479.1577,4457177.6277 5796469.228,4457457.2165 5796187.566099999,4457526.4873 5796250.365599999,4457534.8716 5796241.569099999,4457576.703499999 5796217.328999999,4457585.711299999 5796209.617799999,4457604.358199999 5796183.5073,4457700.4619 5796049.8155,4457686.041299999 5796007.141,4457678.501899999 5795981.655899999,4457672.974499999 5795960.8495,4457666.097 5795934.5909,4457664.0184 5795918.150599999,4457670.9724 5795883.304999999,4457623.816499999 5795812.2904,4457626.367499999 5795768.4579,4457684.650899999 5795735.820599999,4457759.3118 5795777.467499999,4457863.6007 5795644.421299999,4457903.722299999 5795598.8552,4457967.201799999 5795546.936899999,4457828.842899999 5795403.932099999,4457784.488099999 5795425.3539,4457592.142799999 5795482.4524,4457607.37 5795602.1249,4457534.1741 5795602.753799999,4457394.0903 5795708.752199999,4457290.1922 5795643.2048,4457296.239599999 5795517.1842,4457266.3808 5795450.252,4457257.3146 5795418.204199999,4457444.4923 5795390.2924,4457443.7121 5795299.751199999,4457584.428799999 5795274.682399999,4457580.013899999 5795199.228499999,4457709.658599999 5795184.496099999,4457738.1419 5795182.916899999,4457736.7669 5795169.764299999,4457708.8892 5795170.359099999,4457702.176599999 5795046.3069,4457956.82 5795029.532899999,4457974.042899999 5794988.4802,4457997.2949 5794967.840399999,4457998.084699999 5794724.455299999,4457667.8101 5794748.4845,4457692.387 5794929.5477,4457486.0743 5794966.794999999,4457335.642799999 5794993.9534,4457209.3463 5794972.634299999,4457220.3572 5794924.9559,4457179.4802 5794918.744599999,4457196.869599999 5794825.141499999,4457047.158999999 5794824.104299999,4457046.3962 5794786.609799999,4456984.199799999 5794790.801,4456953.9948 5794685.893999999,4456926.6167 5794264.2729,4457029.803399999 5794248.8746,4457118.229199999 5794239.1706,4457056.470499999 5794210.4962,4456988.8808 5794184.788899999,4456971.1796 5794170.3321,4456963.9937 5794018.453999999,4457025.406399999 5794006.2352,4457115.8709 5793967.469599999,4457291.870699999 5793995.155899999,4457298.080199999 5794036.0084,4457471.167 5794066.664,4457530.1654 5794076.0492,4457535.2001 5794019.3649,4457618.1469 5794011.7089,4457636.344999999 5793995.1169,4458011.3256 5793954.504,4457915.8715 5794147.9177,4457937.109799999 5794148.4601,4457959.0914 5794224.3099,4458192.4216 5794296.274599999,4458289.0859 5794216.182499999,4458412.934399999 5793905.2716,4458435.2933 5793875.805999999,4458235.201799999 5793798.084799999,4458092.312599999 5793688.216099999,4457984.569799999 5793580.5118,4457954.4078 5793557.577899999,4457846.1264 5793777.118899999,4457763.410299999 5793742.7946,4457810.4057 5793620.331299999,4457775.8051 5793592.4844,4457873.365199999 5793503.697,4457748.500599999 5793483.1193,4457636.763399999 5793688.840199999,4457517.360999999 5793646.5778,4457559.856999999 5793487.2507,4457737.627399999 5793476.8582,4457761.7839 5793458.2796,4457747.583399999 5793420.554999999,4457726.0871 5793403.791099999,4457579.969299999 5793201.981499999,4457773.086299999 5792972.2729,4457942.756099999 5792959.2421,4458003.874699999 5792997.3695,4458024.418499999 5792989.505599999,4457971.887299999 5792942.413699999,4457947.4548 5792924.138199999,4457946.7444 5792909.6446,4457914.965099999 5792897.7078,4457855.3617 5792891.7838,4457813.7889 5792877.894799999,4457784.598399999 5792869.375199999,4457723.862599999 5792773.415699999,4457676.6736 5792752.8212,4457513.492399999 5792701.018799999,4457484.854799999 5792697.437,4457466.3163 5792705.119,4457375.063099999 5792834.354199999,4457360.9357 5792857.087999999,4457356.1994 5792878.6502,4457338.189299999 5792903.164499999,4457214.2647 5792925.3899,4457186.0311 5792934.436499999,4457163.406399999 5792947.852499999,4457148.4461 5792971.217199999,4457129.1358 5793016.4638,4456738.3848 5793017.754399999,4456724.414599999 5793012.034499999,4456711.8377 5793001.7289,4456694.716099999 5792986.978599999,4456674.831699999 5792983.391699999,4456625.1617 5792931.6597,4456540.8391 5793067.4154,4456119.164599999 5792561.827199999,4456201.055599999 5792402.3723,4456533.225499999 5792797.073999999,4456729.762299999 5792485.070199999,4456431.401399999 5792148.4567,4456581.4406 5791956.816199999,4456563.699 5791943.4517,4456491.5376 5791924.2562,4456460.712199999 5791924.082499999,4456408.381599999 5791922.095499999,4456380.084099999 5791913.553999999,4456327.3934 5791893.2433,4456291.812099999 5791873.405099999,4456014.262299999 5791636.705399999,4456035.4379 5791555.205499999,4456015.2136 5791558.6347,4455998.985 5791569.0613,4455979.521599999 5791582.0205,4455961.253499999 5791610.3256,4455941.2839 5791640.7826,4455926.4 5791645.7225,4455820.539099999 5791652.6762,4455730.1167 5791653.318099999,4455741.0492 5791565.521099999,4455730.772499999 5791417.645199999,4455593.122899999 5791457.2039,4455557.6809 5791487.745799999,4455531.580699999 5791473.402799999,4455505.272699999 5791469.366399999,4455491.9785 5791461.262499999,4455492.562199999 5791448.716,4455533.1511 5791383.753299999,4455521.8015 5791364.0811,4455503.566899999 5791312.422399999,4455606.1407 5791227.6183,4455585.147199999 5791175.1829,4455373.133899999 5791390.5028,4455292.7675 5791253.8211,4455376.968799999 5791165.3614,4455393.9998 5791103.815099999,4455369.7308 5791013.397099999,4455309.646099999 5790848.2783)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (365,363,49263227.0,'NULL','water',572.422449759,13795.0652426, ST_GeomFromText('MULTIPOLYGON(((4452631.983099999 5794971.822599999,4452638.707899999 5794985.634899999,4452648.3322 5794997.227099999,4452661.564799999 5795002.2191,4452671.792999999 5794999.928899999,4452687.1039 5794993.205499999,4452697.9505 5794979.224899999,4452705.834699999 5794961.6227,4452715.0394 5794928.673399999,4452716.1781 5794895.0668,4452710.162399999 5794878.321,4452691.7488 5794866.812899999,4452674.900399999 5794866.2509,4452663.204499999 5794867.8208,4452651.459699999 5794865.006699999,4452643.463499999 5794870.925499999,4452634.1052 5794887.8187,4452608.859799999 5794927.4987,4452592.326999999 5794959.795299999,4452574.0466 5794962.163,4452558.679499999 5794963.0339,4452549.981499999 5794971.886299999,4452549.370799999 5794985.034499999,4452553.2596 5795008.3661,4452560.6726 5795017.7871,4452573.8563 5795018.394999999,4452588.4439 5795012.412699999,4452600.750199999 5794997.683399999,4452604.9768 5794980.8506,4452607.805999999 5794970.596699999,4452616.538999999 5794964.6707,4452626.7674 5794962.3804,4452631.983099999 5794971.822599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (366,364,49263228.0,'NULL','water',440.036554228,13745.5018993, ST_GeomFromText('MULTIPOLYGON(((4452642.632399999 5794708.062999999,4452688.1456 5794720.0458,4452718.881199999 5794718.2938,4452744.3731 5794704.1732,4452748.5932 5794685.8716,4452747.667399999 5794665.4271,4452740.149299999 5794645.0456,4452724.5996 5794626.933199999,4452703.257699999 5794616.1875,4452676.8534 5794611.332599999,4452635.8321 5794609.5335,4452613.892699999 5794612.659399999,4452602.968399999 5794618.606499999,4452591.454499999 5794639.904799999,4452590.850399999 5794653.052899999,4452596.0245 5794658.122099999,4452595.3994 5794669.078099999,4452596.9649 5794680.024299999,4452604.3923 5794690.903,4452619.093 5794696.604199999,4452632.3265 5794702.319599999,4452642.632399999 5794708.062999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (367,365,49263229.0,'NULL','water',640.656356465,21673.4715094, ST_GeomFromText('MULTIPOLYGON(((4453268.757299999 5794483.7123,4453243.0278 5794473.729,4453223.1605 5794462.9671,4453204.732699999 5794449.988299999,4453189.322599999 5794447.218699999,4453165.921699999 5794450.3561,4453158.661399999 5794457.001599999,4453144.1544 5794471.015799999,4453135.530899999 5794488.635399999,4453123.2355 5794504.821,4453120.432599999 5794517.9898,4453121.2668 5794528.942999999,4453121.481499999 5794551.5755,4453115.0623 5794569.1631,4453110.0135 5794577.2454,4453105.688099999 5794584.597599999,4453106.4807 5794591.166799999,4453118.2187 5794593.2365,4453154.789699999 5794589.239499999,4453197.8353 5794572.762599999,4453211.750199999 5794572.630799999,4453230.790199999 5794573.185,4453245.4697 5794576.696,4453263.1391 5794586.755499999,4453274.147099999 5794589.578099999,4453288.075699999 5794590.9041,4453308.5827 5794591.433599999,4453318.0958 5794590.6203,4453329.007 5794583.2061,4453336.894199999 5794565.6049,4453336.707999999 5794545.8878,4453335.123399999 5794532.7605,4453311.5366 5794516.914499999,4453291.5453 5794493.000099999,4453268.757299999 5794483.7123)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (368,366,49263230.0,'NULL','water',371.512060186,3252.83597836, ST_GeomFromText('MULTIPOLYGON(((4453567.180599999 5794292.456299999,4453556.2751 5794301.3165,4453546.0931 5794308.7234,4453549.2955 5794337.180999999,4453564.0305 5794347.2692,4453579.433899999 5794350.039999999,4453602.8766 5794350.554199999,4453622.5859 5794344.5269,4453629.116799999 5794337.889,4453632.6719 5794326.8945,4453636.199799999 5794312.261399999,4453644.9214 5794305.6029,4453666.1599 5794305.403699999,4453680.054999999 5794303.8156,4453682.8869 5794293.5624,4453681.3031 5794280.4239,4453674.587199999 5794267.344699999,4453662.097699999 5794263.0774,4453645.977599999 5794261.7708,4453629.1478 5794263.386499999,4453617.4845 5794268.6037,4453599.924499999 5794270.2375,4453584.5827 5794274.0316,4453574.4142 5794282.884899999,4453567.180599999 5794292.456299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (369,367,49272728.0,'NULL','water',296.323022557,4109.15713969, ST_GeomFromText('MULTIPOLYGON(((4456253.838499999 5790615.777,4456262.512 5790602.536,4456279.2323 5790587.042799999,4456292.3173 5790575.231799999,4456296.6188 5790564.221699999,4456298.695299999 5790550.315799999,4456294.187199999 5790537.936899999,4456281.626099999 5790526.352499999,4456269.860299999 5790522.061,4456258.890499999 5790524.3613,4456246.575 5790540.55,4456235.753899999 5790559.6522,4456230.844499999 5790584.544199999,4456225.9741 5790613.831299999,4456229.026999999 5790627.691899999,4456239.3693 5790637.103599999,4456248.8968 5790637.0193,4456255.455199999 5790633.3003,4456253.838499999 5790615.777)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (370,368,49272729.0,'NULL','water',189.013037697,2314.537118, ST_GeomFromText('MULTIPOLYGON(((4456341.521999999 5790503.890399999,4456359.756 5790494.226299999,4456372.912399999 5790490.4603,4456381.638399999 5790482.337899999,4456383.003399999 5790471.3649,4456377.7322 5790455.320499999,4456362.247499999 5790444.496099999,4456354.912499999 5790443.8264,4456345.4621 5790452.689699999,4456336.8073 5790468.1114,4456328.107499999 5790478.425799999,4456324.5431 5790490.152699999,4456324.639899999 5790501.1128,4456328.3656 5790507.6565,4456341.521999999 5790503.890399999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (371,369,49368550.0,'NULL','water',665.44389975,11643.7966027, ST_GeomFromText('MULTIPOLYGON(((4452945.201299999 5788912.8739,4452968.6561 5788912.651,4453016.2618 5788907.8144,4453060.999099999 5788909.5821,4453089.647199999 5788915.898299999,4453133.7434 5788927.910399999,4453149.136199999 5788927.764699999,4453165.2322 5788923.9513,4453173.190299999 5788912.903799999,4453175.2796 5788901.1885,4453175.1067 5788882.906899999,4453174.9269 5788863.9021,4453170.395399999 5788850.046199999,4453173.974499999 5788841.243499999,4453172.415599999 5788831.0205,4453164.291199999 5788824.5096,4453148.1117 5788819.543899999,4453133.4428 5788818.959499999,4453112.201399999 5788820.6184,4453045.601999999 5788832.221999999,4453030.250599999 5788836.752,4452971.156299999 5788867.291899999,4452963.8322 5788867.3615,4452954.8585 5788849.163599999,4452949.657999999 5788841.9019,4452940.113199999 5788840.5349,4452932.7822 5788840.604599999,4452932.092799999 5788844.9956,4452935.593999999 5788904.9198,4452940.0635 5788912.1995,4452945.201299999 5788912.8739)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (372,370,49368571.0,'NULL','forest',1342.54466544,99369.3161747, ST_GeomFromText('MULTIPOLYGON(((4451524.772499999 5787505.036299999,4451263.825799999 5787505.036299999,4451263.789499999 5787513.6739,4451224.445299999 5787735.3527,4451297.518699999 5787749.199899999,4451368 5787758.0216,4451448.8025 5787772.5852,4451490.669599999 5787780.220399999,4451529.597299999 5787786.415799999,4451550.04 5787777.446799999,4451571.113699999 5787758.222899999,4451587.443099999 5787735.362099999,4451617.405399999 5787693.405999999,4451706.464499999 5787576.9725,4451726.7296 5787555.9766,4451523.267699999 5787532.214299999,4451524.772499999 5787505.036299999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (373,371,49368583.0,'NULL','forest',288.194939908,5635.76626609, ST_GeomFromText('MULTIPOLYGON(((4449904.0793 5787796.753799999,4449877.643 5787792.6258,4449849.826399999 5787797.302999999,4449838.3004 5787817.8954,4449841.558 5787850.0448,4449862.2264 5787862.9999,4449894.791899999 5787893.3836,4449906.4216 5787883.0282,4449917.674599999 5787836.109699999,4449917.4231 5787811.2411,4449904.0793 5787796.753799999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (374,374,89956189.0,'NULL','water',344.563603434,6328.59367857, ST_GeomFromText('MULTIPOLYGON(((4453944.9642 5787838.5833,4453987.8874 5787839.041099999,4454008.624699999 5787800.3013,4454037.939 5787740.1721,4453985.0745 5787713.599999999,4453959.097699999 5787778.349999999,4453944.9642 5787838.5833)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (375,375,89956196.0,'NULL','water',400.077061698,6823.91664715, ST_GeomFromText('MULTIPOLYGON(((4453945.426799999 5788013.1982,4453965.716199999 5787987.4042,4453971.4434 5787972.7288,4453972.368599999 5787914.209699999,4453972.9978 5787903.231699999,4453974.3583 5787891.5236,4453978.3715 5787850.524499999,4453939.4884 5787847.9594,4453920.6401 5787985.308599999,4453914.5403 5788003.247999999,4453945.426799999 5788013.1982)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (376,376,89956198.0,'NULL','water',408.351069393,5504.38785943, ST_GeomFromText('MULTIPOLYGON(((4453852.331799999 5788172.726999999,4453942.644999999 5788029.315099999,4453910.228099999 5788012.7913,4453848.916199999 5788121.559299999,4453824.3775 5788162.75,4453852.331799999 5788172.726999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (377,379,90501873.0,'NULL','forest',432.940299342,9643.16587641, ST_GeomFromText('MULTIPOLYGON(((4457804.294099999 5796252.200999999,4457854.578499999 5796226.945,4457795.969399999 5796134.7166,4457764.092299999 5796088.263,4457717.732499999 5796144.8782,4457804.294099999 5796252.200999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (378,380,90501877.0,'NULL','forest',705.165249303,24816.3043591, ST_GeomFromText('MULTIPOLYGON(((4458165.362599999 5794423.1391,4458314.2964 5794461.829199999,4458327.9044 5794377.5765,4458355.707299999 5794288.2299,4458306.521999999 5794273.310499999,4458297.087899999 5794283.616699999,4458289.9533 5794301.937799999,4458262.2119 5794294.2045,4458267.407599999 5794250.773,4458254.633999999 5794260.0503,4458242.198699999 5794261.690999999,4458229.6474 5794270.5993,4458196.4736 5794300.8584,4458165.362599999 5794423.1391)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (379,381,90501893.0,'NULL','forest',225.394417566,3194.99383196, ST_GeomFromText('MULTIPOLYGON(((4457207.332399999 5796535.437699999,4457230.3108 5796514.3625,4457225.9993 5796501.7696,4457170.796099999 5796479.1577,4457142.116399999 5796520.891599999,4457189.730399999 5796540.0526,4457196.3327 5796541.453099999,4457207.332399999 5796535.437699999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (380,382,100180472.0,'ehem. Schwimmbad','water',146.050681282,1161.41056039, ST_GeomFromText('MULTIPOLYGON(((4459770.8627 5796319.7671,4459807.9297 5796288.073499999,4459792.9653 5796270.1237,4459754.6134 5796302.373199999,4459770.8627 5796319.7671)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (381,383,100187611.0,'NULL','water',433.270230326,7285.35837458, ST_GeomFromText('MULTIPOLYGON(((4456414.7154 5796139.438899999,4456545.7947 5796228.820699999,4456558.7686 5796236.2736,4456590.5902 5796192.194,4456446.510599999 5796123.367699999,4456426.9658 5796117.4309,4456414.7154 5796139.438899999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (382,384,100237214.0,'NULL','forest',220.744569073,1152.73490902, ST_GeomFromText('MULTIPOLYGON(((4458659.294099999 5797398.454099999,4458670.8512 5797380.8419,4458675.851099999 5797366.2002,4458679.3792 5797350.113099999,4458668.3562 5797344.363199999,4458651.517099999 5797343.769799999,4458623.716199999 5797344.737299999,4458609.079499999 5797344.859999999,4458596.632799999 5797344.23,4458612.8645 5797359.428099999,4458630.537299999 5797372.422,4458640.848899999 5797380.358799999,4458647.516099999 5797390.5184,4458659.294099999 5797398.454099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (383,385,100237216.0,'NULL','forest',204.563924415,3835.74287982, ST_GeomFromText('MULTIPOLYGON(((4458609.758999999 5797425.8768,4458620.0093 5797426.5252,4458628.0573 5797426.4578,4458632.370099999 5797416.9295,4458630.831 5797407.4503,4458626.3958 5797402.379699999,4458614.6546 5797398.828199999,4458597.067699999 5797396.0602,4458586.762199999 5797388.846799999,4458576.505599999 5797387.463899999,4458564.832399999 5797391.211899999,4458558.9523 5797401.7104,4458552.575899999 5797413.2146,4458554.8457 5797421.964299999,4458561.482499999 5797428.474099999,4458570.309999999 5797433.507699999,4458598.8218 5797430.3529,4458609.758999999 5797425.8768)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (384,386,100246507.0,'NULL','forest',631.975301118,14985.103084, ST_GeomFromText('MULTIPOLYGON(((4460311.3985 5796724.964199999,4460296.260999999 5796663.0369,4460225.4472 5796685.506599999,4460203.365 5796648.2839,4460100.9751 5796769.7365,4460168.053999999 5796829.062699999,4460175.8792 5796801.257799999,4460188.786899999 5796767.5698,4460194.5218 5796752.923699999,4460198.873399999 5796747.769799999,4460311.3985 5796724.964199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (385,387,113759216.0,'NULL','forest',1027.4012122,29905.5374934, ST_GeomFromText('MULTIPOLYGON(((4455981.465599999 5797298.969499999,4456156.867499999 5797272.5928,4456411.211299999 5797235.298,4456416.6835 5797191.449899999,4456138.4872 5797180.783199999,4456135.645399999 5797190.289499999,4456132.248999999 5797219.5196,4456053.178799999 5797216.573,4455970.6221 5797231.9087,4455981.465599999 5797298.969499999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (386,388,132470093.0,'NULL','water',380.416236442,6702.36731224, ST_GeomFromText('MULTIPOLYGON(((4459650.173299999 5791665.153799999,4459612.5641 5791635.493699999,4459581.0283 5791632.1015,4459534.3243 5791654.4053,4459598.376299999 5791692.617399999,4459675.6721 5791738.022099999,4459677.4834 5791690.502699999,4459650.173299999 5791665.153799999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (387,389,141689362.0,'Weißer Garten','park',111.784752415,557.616544901, ST_GeomFromText('MULTIPOLYGON(((4459876.6419 5795590.8768,4459893.331899999 5795579.1238,4459874.743599999 5795562.983599999,4459853.1545 5795579.7729,4459857.940299999 5795590.172,4459868.4763 5795580.1937,4459876.6419 5795590.8768)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (388,390,164935046.0,'NULL','water',373.43816256,9289.82707808, ST_GeomFromText('MULTIPOLYGON(((4458087.758399999 5792987.799599999,4458110.574199999 5792915.308399999,4458097.3908 5792895.946399999,4458043.536199999 5792891.640599999,4457994.9411 5792892.476199999,4457978.8124 5792935.4778,4458033.008399999 5792980.040699999,4458087.758399999 5792987.799599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (389,391,173763505.0,'Königssee','water',165.598318601,3375.90879558, ST_GeomFromText('MULTIPOLYGON(((4455157.6939 5790633.037599999,4455178.309799999 5790643.811699999,4455200.287899999 5790643.6126,4455208.978699999 5790631.8385,4455201.5246 5790618.0183,4455181.626099999 5790605.768699999,4455164.671 5790594.2269,4455153.010499999 5790601.643699999,4455152.432199999 5790618.463199999,4455157.6939 5790633.037599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (390,392,174279686.0,'NULL','forest',814.579541046,37872.605114, ST_GeomFromText('MULTIPOLYGON(((4451011.3775 5791111.1216,4451074.058699999 5791093.5865,4451074.746799999 5791045.083599999,4451112.965599999 5790997.9678,4451107.6654 5790876.345899999,4451074.981999999 5790861.712999999,4451073.1107 5790821.6816,4450943.8737 5790811.755699999,4450936.180399999 5790849.3781,4450945.460599999 5790918.7363,4450965.131599999 5790987.6688,4450972.2399 5791030.2189,4450990.7367 5791067.5817,4451011.3775 5791111.1216)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (391,393,174280980.0,'NULL','forest',7322.14567839,627796.689306, ST_GeomFromText('MULTIPOLYGON(((4449998.467199999 5794986.205399999,4450116.473899999 5795052.204099999,4450175.1595 5795063.296399999,4450240.943799999 5795081.3286,4450284.258999999 5795090.2401,4450345.577399999 5795118.2561,4450416.2182 5795153.178799999,4450615.518199999 5795155.7224,4450607.9922 5795110.795399999,4450349.999599999 5794746.175,4450054.0772 5794348.010099999,4450057.9702 5794298.2946,4449829.6228 5794310.834899999,4449835.7306 5794335.610899999,4449833.099499999 5794364.8602,4449770.0788 5794504.279899999,4449755.7454 5794535.0949,4449757.4356 5794557.000199999,4449767.938199999 5794581.720399999,4449779.826899999 5794599.126399999,4449807.7685 5794610.5381,4449851.9702 5794636.373999999,4449897.898599999 5794688.4997,4449920.2735 5794729.179999999,4449926.7207 5794787.537499999,4449940.112099999 5794807.855399999,4450024.36 5794884.421,4450028.939899999 5794903.3705,4450011.516099999 5794918.1469,4449992.484299999 5794918.3396,4449967.4133 5794901.0666,4449915.691899999 5794854.852399999,4449875.620299999 5794802.667099999,4449857.9298 5794791.162,4449805.0871 5794778.545199999,4449661.315799999 5794753.7233,4449659.7214 5794740.5861,4449674.2997 5794734.5953,4449702.151499999 5794737.238299999,4449735.8354 5794736.8955,4449770.928299999 5794732.153999999,4449792.791299999 5794721.705,4449798.483099999 5794705.578099999,4449798.304999999 5794688.052999999,4449771.7718 5794670.7958,4449662.769899999 5794609.086699999,4449624.6375 5794603.633099999,4449566.0793 5794605.6884,4449530.978799999 5794610.431299999,4449514.828599999 5794606.211799999,4449511.7368 5794590.1743,4449518.850399999 5794569.648,4449564.1715 5794561.885099999,4449594.936999999 5794563.028899999,4449638.716699999 5794547.9822,4449717.4193 5794510.657899999,4449734.605899999 5794472.502499999,4449760.367999999 5794413.8065,4449761.493599999 5794380.187999999,4449750.8865 5794345.2421,4449737.5148 5794326.3823,4449684.689899999 5794316.693199999,4449566.129099999 5794323.7443,4449454.734 5794314.655899999,4449390.2203 5794308.0162,4449335.828999999 5794288.119999999,4449319.5959 5794276.6019,4449354.0547 5794209.045499999,4449374.616499999 5794214.6771,4449424.5004 5794222.9352,4449477.2224 5794222.3958,4449528.432199999 5794217.4879,4449562.0382 5794209.833599999,4449566.320299999 5794054.930199999,4449491.4176 5794035.241699999,4449453.2208 5794023.947699999,4449366.769799999 5794020.4483,4449319.8786 5794018.013499999,4449268.45 5794002.460999999,4449208.6633 5793977.335699999,4449184.901499999 5793966.641,4449168.353299999 5793953.824599999,4449157.831199999 5793927.6258,4449148.6058 5793918.662399999,4449142.4292 5793884.9297,4449133.562199999 5793766.2276,4449128.2174 5793769.5543,4449141.6063 5793917.721799999,4449144.4971 5793936.621099999,4449145.293499999 5794053.7927,4449144.029299999 5794108.700999999,4449132.563199999 5794232.7982,4449139.826999999 5794234.259099999,4449143.6024 5794236.334599999,4449146.012099999 5794238.3463,4449147.814399999 5794240.375299999,4449150.204099999 5794244.423599999,4449151.740399999 5794250.4504,4449151.7412 5794253.844499999,4449151.3704 5794256.274299999,4449150.152599999 5794259.981399999,4449169.510499999 5794264.689699999,4449197.9764 5794277.650599999,4449216.9263 5794289.162699999,4449239.097699999 5794308.653999999,4449256.1594 5794330.3901,4449267.3721 5794352.1864,4449277.937699999 5794382.7583,4449287.101099999 5794419.698899999,4449294.075 5794527.9491,4449301.6907 5794557.093499999,4449312.1578 5794586.7763,4449375.9353 5794700.3977,4449396.064 5794735.2453,4449413.785699999 5794749.6751,4449451.8799 5794751.477399999,4449608.8676 5794780.542799999,4449685.189299999 5794797.302899999,4449746.7389 5794801.049799999,4449799.507399999 5794806.366699999,4449834.6808 5794808.9249,4449864.0881 5794820.311,4449893.666199999 5794849.2223,4449912.912499999 5794869.480699999,4449918.959999999 5794888.4152,4449907.4506 5794908.9744,4449882.7093 5794934.330499999,4449909.1002 5794944.456499999,4449928.3864 5794951.8615,4449998.467199999 5794986.205399999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (392,394,174973121.0,'NULL','forest',3559.80576997,264199.899424, ST_GeomFromText('MULTIPOLYGON(((4452239.795599999 5795413.434,4453052.1435 5795488.949899999,4453056.700899999 5795456.557299999,4453074.398199999 5795441.833599999,4453129.146999999 5795486.6049,4453192.964499999 5795435.7453,4453008.2986 5795312.241399999,4452976.376 5795209.721799999,4452950.4999 5795199.051599999,4452920.696899999 5795196.676,4452598.195799999 5795159.5993,4452540.9632 5795146.272099999,4452457.2302 5795118.5895,4452449.7702 5795256.694099999,4452440.3638 5795267.734699999,4452405.364199999 5795282.6831,4452376.8437 5795286.607999999,4452359.2521 5795283.850999999,4452338.599999999 5795268.7157,4452311.909699999 5795233.9198,4452295.7218 5795225.318299999,4452219.345599999 5795201.218699999,4452206.927899999 5795204.265499999,4452193.878999999 5795217.534099999,4452165.372299999 5795222.917899999,4452130.982699999 5795224.72,4452101.6823 5795223.535099999,4452072.346199999 5795217.977399999,4452019.4506 5795199.5064,4451969.417999999 5795174.4315,4451953.916799999 5795161.439899999,4451942.0371 5795144.028699999,4451931.660299999 5795130.9874,4451917.6545 5795121.6203,4451889.040699999 5795115.333399999,4451889.178999999 5795172.9756,4451757.374499999 5795149.645899999,4451740.052199999 5795235.3012,4451943.5059 5795294.989499999,4451968.737499999 5795304.447799999,4451996.586799999 5795333.2993,4452121.258999999 5795313.482899999,4452183.590599999 5795302.362999999,4452231.633399999 5795323.742599999,4452257.106599999 5795358.2716,4452250.149799999 5795393.9265,4452239.795599999 5795413.434)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (393,395,176256520.0,'NULL','forest',2825.44058936,189519.201621, ST_GeomFromText('MULTIPOLYGON(((4455916.594499999 5790105.5974,4455973.0277 5790105.829299999,4456047.0492 5790105.9055,4456084.54 5790036.1235,4456042.5096 5790007.831299999,4456028.503899999 5789999.175899999,4456021.7955 5789986.082399999,4456008.497899999 5789891.891799999,4456006.938199999 5789881.667999999,4455949.365899999 5789918.7354,4455811.4851 5789743.7772,4455809.938099999 5789735.011099999,4455821.2231 5789685.202099999,4455821.112099999 5789672.773199999,4455815.838299999 5789656.729399999,4455791.0811 5789593.343599999,4455782.915799999 5789581.7211,4455764.4965 5789570.924799999,4455734.9022 5789540.4765,4455723.0685 5789528.152599999,4455719.2235 5789508.4461,4455690.3058 5789475.811,4455606.206799999 5789555.194399999,4455575.836099999 5789533.5117,4455660.742999999 5789384.9495,4455644.763199999 5789369.7363,4455608.019199999 5789377.209899999,4455550.544099999 5789428.4912,4455558.938599999 5789459.4515,4455390.4071 5789671.463199999,4455299.0535 5789623.7145,4455267.963999999 5789648.8329,4455265.741899999 5789661.471999999,4455284.814799999 5789676.478099999,4455291.142099999 5789703.0722,4455372.3496 5789745.5153,4455473.0804 5789778.147199999,4455487.348699999 5789785.441199999,4455498.055499999 5789855.5173,4455509.033099999 5789853.949699999,4455675.378299999 5789850.264499999,4455706.164599999 5789850.7232,4455739.9139 5789854.8055,4455770.8113 5789867.693499999,4455791.461699999 5789882.130999999,4455800.4687 5789905.441299999,4455809.854 5789971.88,4455826.294599999 5790006.830499999,4455857.418999999 5790045.3,4455916.594499999 5790105.5974)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (394,396,182331803.0,'NULL','water',139.504511423,1314.77533487, ST_GeomFromText('MULTIPOLYGON(((4456469.932 5796258.688799999,4456477.2713 5796260.805199999,4456480.268699999 5796268.8131,4456487.1353 5796275.3626,4456500.314899999 5796275.9809,4456511.7389 5796267.812499999,4456517.7143 5796256.843299999,4456509.362099999 5796247.3802,4456497.053799999 5796238.040999999,4456491.142599999 5796231.516499999,4456478.5514 5796239.628499999,4456469.8547 5796249.9206,4456469.932 5796258.688799999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (395,397,182421164.0,'NULL','water',521.609750518,12637.2959184, ST_GeomFromText('MULTIPOLYGON(((4453830.334499999 5791034.1048,4453841.878499999 5791035.0097,4453860.9697 5791021.3111,4453872.138899999 5791025.2352,4453896.439399999 5791027.434499999,4453908.0837 5791017.845,4453913.0652 5791009.319,4453922.917999999 5791003.173599999,4453933.472699999 5790985.1148,4453897.0551 5790985.0424,4453871.4824 5790976.8124,4453836.209599999 5790969.875,4453797.6204 5790954.489199999,4453753.490199999 5790952.0752,4453744.359299999 5790971.1337,4453709.8019 5790996.8845,4453716.792299999 5791008.9263,4453730.7768 5791033.421599999,4453758.378399999 5791042.444199999,4453830.334499999 5791034.1048)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (396,398,197441563.0,'NULL','water',435.558877159,9108.62684585, ST_GeomFromText('MULTIPOLYGON(((4455244.8135 5794499.277799999,4455348.949699999 5794536.3486,4455373.0305 5794538.134099999,4455385.979199999 5794528.5138,4455386.8289 5794511.502599999,4455375.1194 5794492.100999999,4455325.739199999 5794465.528599999,4455224.918999999 5794436.050799999,4455212.4813 5794436.541899999,4455221.424599999 5794466.172599999,4455244.8135 5794499.277799999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (397,399,197477746.0,'Hofteich','water',547.284250511,13900.7117232, ST_GeomFromText('MULTIPOLYGON(((4451491.157399999 5795151.229399999,4451405.365899999 5795199.345,4451399.1578 5795221.7291,4451401.398799999 5795241.414899999,4451408.65 5795251.537,4451435.8392 5795244.815199999,4451482.404799999 5795232.8066,4451518.226499999 5795237.885399999,4451553.878499999 5795224.960799999,4451588.2423 5795220.551,4451602.882299999 5795219.3837,4451623.2455 5795215.2115,4451627.1412 5795181.677699999,4451491.157399999 5795151.229399999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (398,400,197806267.0,'NULL','forest',242.359865094,2642.99105802, ST_GeomFromText('MULTIPOLYGON(((4458662.407399999 5793709.542099999,4458694.6039 5793750.178899999,4458739.4593 5793771.7149,4458751.863099999 5793766.136399999,4458756.519799999 5793754.046099999,4458740.250199999 5793734.819399999,4458718.1967 5793725.1443,4458701.6864 5793721.2651,4458670.7751 5793702.8956,4458664.927899999 5793704.035,4458662.407399999 5793709.542099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (399,419,0.0,'NULL','farm',1220.81052606,69667.6474658, ST_GeomFromText('MULTIPOLYGON(((4460923.485 5797179.729599999,4461011.4352 5796776.6245,4460818.4334 5796654.471499999,4460818.4334 5796769.295299999,4460772.0152 5796854.8025,4460869.7377 5797138.197499999,4460923.485 5797179.729599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (400,420,0.0,'NULL','farm',4092.62577242,681771.315016, ST_GeomFromText('MULTIPOLYGON(((4461023.6505 5797096.6655,4461062.7395 5797145.526699999,4461087.170099999 5797209.046299999,4461573.3392 5796974.512499999,4461504.9335 5796859.688599999,4461487.8321 5796788.8398,4461707.707499999 5796654.471499999,4461795.6577 5796849.9164,4462176.7752 5796783.9537,4462196.319699999 5796671.572899999,4462235.408699999 5796554.305999999,4461934.9122 5796415.0515,4461602.655899999 5796165.8593,4461407.211099999 5796153.643999999,4461233.7537 5796119.441199999,4461109.157599999 5796622.711699999,4461023.6505 5797096.6655)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (401,421,0.0,'NULL','forest',4534.61439585,970718.664108, ST_GeomFromText('MULTIPOLYGON(((4461077.3978 5797663.4556,4461092.0562 5797692.8131,4462357.5617 5797692.8131,4462325.8019 5797524.201099999,4462377.1062 5796732.649399999,4462235.408699999 5796691.117399999,4462188.9905 5796815.7135,4461802.986899999 5796886.5623,4461680.833899999 5796715.548,4461541.5794 5796788.8398,4461531.807199999 5796837.701099999,4461585.554499999 5797003.829199999,4461297.273299999 5797182.172599999,4460996.7768 5797350.743799999,4461077.3978 5797663.4556)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (402,422,0.0,'NULL','meadow',2216.19052271,288193.729832, ST_GeomFromText('MULTIPOLYGON(((4461837.189799999 5796214.720499999,4462057.0652 5796410.1654,4462323.3589 5796529.875399999,4462550.5635 5796082.795299999,4462587.2094 5795936.2116,4462428.4105 5795765.1973,4462308.7005 5795877.578099999,4461944.684399999 5796129.2134,4461837.189799999 5796214.720499999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (403,401,100239740.0,'NULL','forest',5067.29698989,662336.909938, ST_GeomFromText('MULTIPOLYGON(((4459171.0038 5797692.8131,4461045.0701 5797692.8131,4460978.4049 5797516.600899999,4460917.1231 5797428.964299999,4460891.6632 5797448.1502,4460863.225499999 5797460.783199999,4460841.9959 5797459.482699999,4460696.3786 5797552.623299999,4460605.116799999 5797303.6972,4460507.684 5797290.6106,4460503.215599999 5797281.1542,4460501.6675 5797270.9513,4460493.589999999 5797267.366,4460478.2701 5797273.3308,4460475.461 5797287.952999999,4460442.461299999 5797279.459799999,4460433.0694 5797294.8581,4460433.1924 5797310.1914,4460438.501799999 5797333.5062,4460436.399199999 5797345.1962,4460424.730399999 5797349.6741,4460370.022099999 5797372.0128,4460350.6834 5797332.7532,4460250.1353 5797297.062599999,4460307.1946 5797203.162599999,4460219.426099999 5797119.1861,4460099.6705 5797242.0698,4460021.0947 5797118.607499999,4460005.685999999 5797113.6135,4459996.148299999 5797110.040899999,4459914.420099999 5797139.9035,4459752.2257 5797173.3497,4459779.934299999 5797250.496099999,4459717.9153 5797273.635999999,4459702.9812 5797236.524,4459639.389399999 5797245.8124,4459575.862599999 5797263.847599999,4459489.759899999 5797294.4877,4459476.7152 5797309.917899999,4459465.854899999 5797323.8724,4459455.682599999 5797332.724799999,4459444.013799999 5797337.9283,4459451.493999999 5797357.5744,4459428.139499999 5797365.066199999,4459412.857099999 5797375.407299999,4459397.574799999 5797385.7595,4459375.020299999 5797397.6183,4459377.814299999 5797425.481899999,4459323.278699999 5797445.783199999,4459336.6875 5797474.6498,4459306.406399999 5797489.8998,4459352.820399999 5797594.119699999,4459167.555599999 5797685.106399999,4459171.0038 5797692.8131)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (404,402,100237213.0,'NULL','forest',834.383111129,37213.9196093, ST_GeomFromText('MULTIPOLYGON(((4458763.566499999 5797692.8131,4458719.897199999 5797616.955499999,4458691.444099999 5797567.529699999,4458643.1648 5797482.5383,4458612.444899999 5797484.253599999,4458584.8836 5797513.684499999,4458561.003499999 5797545.265699999,4458555.8815 5797545.3087,4458561.1507 5797562.790999999,4458554.7339 5797583.2758,4458476.507399999 5797678.821299999,4458467.2701 5797692.8131,4458763.566499999 5797692.8131)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (405,403,48921389.0,'NULL','forest',2645.54240226,122631.985563, ST_GeomFromText('MULTIPOLYGON(((4454172.648 5797692.8131,4455270.8108 5797692.8131,4455214.081699999 5797490.298,4454787.9912 5797669.917099999,4454784.9625 5797660.942299999,4454702.430599999 5797416.191999999,4454509.1961 5797571.2583,4454464.0707 5797597.947799999,4454418.878399999 5797617.3494,4454172.648 5797692.8131)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (406,404,174282159.0,'NULL','forest',10998.6368901,2200336.8595, ST_GeomFromText('MULTIPOLYGON(((4448676.786299999 5793268.3651,4448676.786299999 5797692.8131,4449281.5569 5797692.8131,4449261.698599999 5797199.5073,4449275.195899999 5797088.3978,4449317.8731 5796968.2309,4449357.4165 5796827.653999999,4449364.555499999 5796666.9671,4449369.599899999 5796588.060799999,4449329.474799999 5796386.9514,4449298.3365 5796206.1926,4449259.765999999 5796156.945699999,4449167.8984 5796049.8131,4449156.004099999 5796032.4197,4449110.223 5795851.790599999,4449099.990799999 5795711.6916,4449109.2684 5795474.998999999,4449109.332299999 5795144.690799999,4449105.083999999 5794960.173299999,4449109.412299999 5794669.437899999,4449119.328499999 5794435.4099,4449121.3967 5794288.2517,4449121.3331 5794271.471,4449116.8062 5794270.649599999,4449114.0444 5794269.5764,4449110.650999999 5794267.4747,4449108.163499999 5794265.196799999,4449105.6297 5794261.728599999,4449104.1913 5794258.5942,4449103.3304 5794255.186699999,4449103.101099999 5794251.4833,4449103.792 5794246.991599999,4449105.751 5794242.364299999,4449109.038999999 5794238.201899999,4449114.8081 5794234.369999999,4449118.161899999 5794233.2783,4449122.6413 5794232.7982,4449126.329599999 5793935.971499999,4449111.7877 5793766.661199999,4449102.097199999 5793766.927899999,4449100.8994 5793786.503599999,4449087.2637 5793794.7453,4449096.608199999 5793831.806099999,4449019.7291 5793822.8724,4448930.733199999 5793831.770099999,4448763.4071 5793811.6127,4448748.675699999 5793803.0076,4448823.865799999 5793708.7182,4448929.132699999 5793690.091399999,4448933.8722 5793581.921,4449079.629399999 5793561.9111,4449100.0596 5793559.107799999,4449055.9971 5793263.2629,4449054.613599999 5793089.254699999,4448905.123999999 5793067.8846,4448870.632799999 5793132.539799999,4448816.059799999 5793238.310399999,4448785.284599999 5793302.949999999,4448754.2975 5793302.291899999,4448676.786299999 5793268.3651)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (407,405,0.0,'NULL','farm',12911.3027941,4473703.26354, ST_GeomFromText('MULTIPOLYGON(((4448676.786299999 5788377.615599999,4449404.824599999 5788874.9262,4450122.0344 5788989.9504,4450876.457999999 5789233.531199999,4450900.139499999 5789287.660199999,4450984.716099999 5789209.8497,4451214.186999999 5789109.4184,4451560.1255 5788658.607699999,4452090.9785 5788147.567199999,4452242.111899999 5788139.4524,4452441.5689 5787903.570299999,4452552.694099999 5787716.244999999,4452390.768799999 5787505.036299999,4451524.772499999 5787505.036299999,4451523.267699999 5787532.214299999,4451726.7296 5787555.9766,4451617.405399999 5787693.405999999,4451560.576899999 5787767.834899999,4451529.597299999 5787786.415799999,4451297.518699999 5787749.199899999,4451224.445299999 5787735.3527,4451263.789499999 5787513.6739,4451263.825799999 5787505.036299999,4449944.4264 5787505.036299999,4450028.5641 5787527.3321,4450083.6546 5787571.121799999,4450177.7894 5787567.0197,4450309.552199999 5787559.0822,4450438.139899999 5787592.4197,4450712.777999999 5787647.9823,4450841.365699999 5787660.682399999,4450923.9159 5787694.019899999,4450933.440899999 5787721.0075,4450502.546099999 5787685.886399999,4450494.1243 5787724.0062,4450277.161799999 5787732.0225,4450261.927099999 5787825.7827,4450148.944 5787815.2364,4450177.214399999 5787709.625,4449685.363699999 5787703.8824,4449608.934999999 5787729.597599999,4449505.110299999 5787505.036299999,4448676.786299999 5787505.036299999,4448676.786299999 5788377.615599999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (408,406,0.0,'NULL','meadow',1923.20590889,212828.971905, ST_GeomFromText('MULTIPOLYGON(((4454041.957299999 5791072.8881,4454444.1248 5791159.671599999,4454522.441599999 5791096.171499999,4454702.358599999 5790878.1544,4454583.8251 5790772.3209,4454545.724999999 5790677.070699999,4454431.4248 5790765.970899999,4454350.991299999 5790658.0206,4454185.890899999 5790677.070699999,4454041.957299999 5791072.8881)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (409,407,0.0,'NULL','meadow',2520.13826417,365316.749432, ST_GeomFromText('MULTIPOLYGON(((4453904.3737 5791896.273099999,4454202.8243 5791913.206499999,4454336.174599999 5791792.556199999,4454471.641499999 5791187.1884,4454029.257299999 5791102.5215,4453792.1902 5791648.6226,4453944.590499999 5791680.3727,4453904.3737 5791896.273099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (410,408,0.0,'NULL','meadow',2293.8045352,111111.638516, ST_GeomFromText('MULTIPOLYGON(((4453163.5389 5791868.7564,4453406.9561 5791758.6895,4453555.122999999 5791661.322599999,4453756.206799999 5791635.922599999,4453976.340499999 5791132.154899999,4453163.5389 5791868.7564)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (411,409,0.0,'NULL','forest',9421.36813783,2002847.60367, ST_GeomFromText('MULTIPOLYGON(((4450614.8026 5795070.717199999,4450680.948499999 5794978.1129,4451024.907499999 5795130.2486,4451120.819199999 5795130.2486,4451124.1265 5795298.9208,4451274.729299999 5795301.648,4451341.8529 5795288.994,4451292.7987 5795136.863199999,4451428.3979 5795054.1807,4451491.2366 5794984.727499999,4451471.4764 5794926.8684,4451471.392799999 5794855.742799999,4451587.1792 5794803.562699999,4451573.919099999 5794693.6852,4451399.9593 5794402.1019,4451467.6935 5794372.2335,4451581.383899999 5794345.9931,4451623.853799999 5794345.577099999,4451855.0394 5794399.335699999,4451884.042899999 5794349.935699999,4451577.3441 5794123.904699999,4451021.943699999 5793694.648,4450489.4593 5793072.494799999,4450405.451799999 5793116.580299999,4450297.3859 5793201.5503,4450220.172899999 5793317.036299999,4450179.0239 5793376.6302,4450240.9292 5793413.997999999,4450259.978 5793480.029799999,4450254.474899999 5793555.0161,4450360.656999999 5793667.0273,4450502.354399999 5793840.4023,4450599.630599999 5793981.6731,4450681.5411 5794117.4527,4450770.2456 5794181.053999999,4450780.1019 5794280.4395,4450767.626899999 5794378.8285,4450804.636099999 5794455.154999999,4450769.9002 5794486.414899999,4450741.925499999 5794444.8187,4450675.307 5794300.133199999,4450550.0147 5794146.526399999,4450488.8322 5794115.078999999,4450441.256799999 5794108.906799999,4450451.3704 5794086.2375,4450493.3651 5794047.0238,4450449.437599999 5793969.3869,4450363.0343 5793903.687799999,4450293.1769 5793823.950999999,4450260.229399999 5793730.855499999,4450289.0689 5793685.2738,4450214.6195 5793612.198699999,4450070.133 5793617.351399999,4450054.5459 5794104.0316,4449994.5142 5794106.096599999,4450000.0773 5794221.4504,4450054.245 5794219.4448,4450054.0772 5794348.010099999,4450582.540099999 5795074.823999999,4450614.8026 5795070.717199999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (412,410,0.0,'NULL','farm',2683.71966927,306748.45339, ST_GeomFromText('MULTIPOLYGON(((4449708.6028 5792705.998999999,4450029.410799999 5792748.993799999,4450257.614299999 5792864.749299999,4450492.4325 5793043.343399999,4450706.778699999 5792923.064899999,4450774.100899999 5792558.879699999,4450518.890899999 5792537.3267,4449704.0694 5792585.443399999,4449708.6028 5792705.998999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (413,411,0.0,'NULL','farm',1273.46454956,82933.3759467, ST_GeomFromText('MULTIPOLYGON(((4449109.9818 5793228.5521,4449281.961299999 5793172.327999999,4449308.4197 5792752.3011,4449103.3672 5792762.222999999,4449109.9818 5793228.5521)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (414,412,0.0,'NULL','residential',6327.929538,1214295.49579, ST_GeomFromText('MULTIPOLYGON(((4457896.9861 5795906.189999999,4458746.3003 5795400.834799999,4459444.728099999 5794862.8704,4459358.475499999 5794511.577299999,4459259.593 5794347.790999999,4459143.176099999 5794149.353099999,4459092.9051 5794130.832299999,4458918.279799999 5794226.082499999,4458677.5085 5793969.4361,4458460.5497 5793887.4151,4458301.799399999 5794260.478399999,4458397.049599999 5794286.936699999,4458306.843 5794630.615299999,4458780.6962 5794765.833499999,4458452.6122 5795072.7508,4457907.5694 5795803.002299999,4457867.8819 5795879.731599999,4457896.9861 5795906.189999999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (415,413,0.0,'NULL','residential',2752.41324816,334086.468173, ST_GeomFromText('MULTIPOLYGON(((4456994.755099999 5794773.771099999,4457386.3392 5794728.791799999,4457410.1518 5794570.0415,4457500.110299999 5794570.0415,4457513.339499999 5794448.3329,4457455.131 5794413.937,4457478.943599999 5794292.228399999,4457572.7482 5794079.266,4457288.443199999 5794062.0405,4457243.463899999 5794027.6446,4457148.2138 5794009.1237,4457007.984299999 5794046.1654,4457007.984299999 5794130.832299999,4457137.6304 5794196.978199999,4457137.6304 5794260.478399999,4456947.129999999 5794284.290899999,4456994.755099999 5794773.771099999)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (416,423,0.0,'NULL','farm',3857.48548975,769560.509417, ST_GeomFromText('MULTIPOLYGON(((4462369.776999999 5797692.8131,4463201.4649 5797692.8131,4463201.4649 5797375.174399999,4463124.682799999 5797362.9591,4463097.8092 5797016.0445,4463022.0743 5796954.968,4463046.5049 5796793.725999999,4462895.035099999 5796688.6743,4462467.499499999 5796610.4964,4462301.371299999 5796568.9644,4462272.0546 5796649.5854,4462413.7521 5796703.332699999,4462342.9034 5797509.542799999,4462369.776999999 5797692.8131)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (417,424,0.0,'NULL','farm',2223.52585227,274095.045283, ST_GeomFromText('MULTIPOLYGON(((4462377.1062 5796500.5587,4462912.1365 5796617.8256,4463070.935499999 5796730.206399999,4463085.593799999 5796615.3825,4463139.341199999 5796302.6707,4463105.138299999 5796248.923399999,4462567.6649 5796114.554999999,4462377.1062 5796500.5587)))', 31468));
INSERT INTO "landnutzung" ("PKUID","OBJECTID","osm_id","name","type","Shape_Leng","Shape_Area","geometry")
  VALUES (418,425,0.0,'NULL','meadow',3017.0818405,248172.834926, ST_GeomFromText('MULTIPOLYGON(((4463107.581399999 5796058.3646,4463107.581399999 5795699.234699999,4462975.6561 5795691.9055,4462899.921199999 5795508.676,4462777.768199999 5795547.7649,4462440.625799999 5795178.8627,4462245.1809 5795156.875199999,4462242.7379 5795308.345,4462662.944299999 5795467.143899999,4462665.3874 5795581.9678,4462675.159599999 5795762.7543,4462675.159599999 5795875.135099999,4462890.149 5796048.592399999,4463107.581399999 5796058.3646)))', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (1,5,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun003',110000,'Siedlung',110000,3,'Hun','Spätneolithikum',4458161,5791300, ST_GeomFromText('MULTIPOINT(4458160.656697383 5791299.985235091)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (2,7,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)','NHa007',110000,'Siedlung',110000,7,'NHa','Spätneolithikum',4458461,5794629, ST_GeomFromText('MULTIPOINT(4458460.999993662 5794629.000022191)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (3,8,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)','NHa022',110000,'Siedlung, Fuchsberg',110000,22,'NHa','Spätneolithikum',4462234,5796362, ST_GeomFromText('MULTIPOINT(4462233.590717175 5796361.623127806)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (4,9,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)','AHa049',0,'Grab KAK?',0,49,'AHa','Spätneolithikum',4461117,5792333, ST_GeomFromText('MULTIPOINT(4461116.999996135 5792333.000020053)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (5,10,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun010',110000,'Siedlung',110000,10,'Hun','Spätneolithikum',4458345,5789996, ST_GeomFromText('MULTIPOINT(4458344.841401554 5789995.986769877)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (6,11,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun002',110000,'Siedlung',110000,2,'Hun','Spätneolithikum',4458346,5791367, ST_GeomFromText('MULTIPOINT(4458346.462649555 5791366.840787153)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (7,12,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)','AHa007',110000,'Siedlung',110000,7,'AHa','Spätneolithikum',4459974,5792407, ST_GeomFromText('MULTIPOINT(4459973.580219071 5792406.966868123)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (8,13,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)','AHa005',0,'Einzelfund, Kupferbeil',0,5,'AHa','Spätneolithikum',4461357,5794456, ST_GeomFromText('MULTIPOINT(4461356.999996359 5794456.000086031)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (9,14,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)','AHa008',0,'Einzelfund, dicknackige Felsgesteinbeil',0,8,'AHa','Spätneolithikum',4457219,5792752, ST_GeomFromText('MULTIPOINT(4457218.999992505 5792752.000084444)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (10,15,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)','AHa010',0,'Einzelfund, Steinaxt',0,10,'AHa','Spätneolithikum/Endneolithikum',4458017,5793704, ST_GeomFromText('MULTIPOINT(4458016.616505248 5793703.81410133)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (11,16,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)','AHa038',0,'Einzelfund, Feuersteinbeil',0,38,'AHa','Spätneolithikum/Endneolithikum',4456136,5794573, ST_GeomFromText('MULTIPOINT(4456135.999927497 5794573.000022139)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (12,17,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun056',0,'Einzelfund, Dechsel',0,56,'Hun','Frühneolithikum',4458492,5790101, ST_GeomFromText('MULTIPOINT(4458491.864761691 5790101.437649976)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (13,18,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun057',0,'Einzelfund, Flintrechteckbeil',0,57,'Hun','Spätneolithikum',4459438,5791122, ST_GeomFromText('MULTIPOINT(4459438.402234572 5791122.492882926)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (14,19,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun058',0,'Einzelfund, Schuhleistenkeil',0,58,'Hun','Frühneolithikum',4457859,5791684, ST_GeomFromText('MULTIPOINT(4457858.999993101 5791684.00008345)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (15,20,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun009',0,'Einzelfund, Steinbeil',0,9,'Hun','Neolithikum',4458929,5791101, ST_GeomFromText('MULTIPOINT(4458928.999994098 5791101.000018905)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (16,22,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun063',0,'Einzelfund, Felsgesteinaxt, Dechsel',0,63,'Hun','Frühneolithikum, Spätneolithikum',4457727,5790936, ST_GeomFromText('MULTIPOINT(4457727.000120978 5790936.000082753)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (17,23,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun064',0,'Einzelfund, 1 dünnackiges Felsgesteinbeil',0,64,'Hun','Spätneolithikum',4458097,5790357, ST_GeomFromText('MULTIPOINT(4458096.999993323 5790357.000018212)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (18,24,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun065',0,'Einzelfund, 1 Steinaxtfrg.',0,65,'Hun','Spätneolithikum/Endneolithikum',4458768,5790325, ST_GeomFromText('MULTIPOINT(4458767.812409948 5790324.954322183)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (19,25,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun036',0,'Einzelfund, Steinaxt',0,36,'Hun','Spätneolithikum/Endneolithikum',4457836,5789184, ST_GeomFromText('MULTIPOINT(4457836.00005708 5789183.99995312)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (20,26,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun013',0,'Einzelfund, Bronzebeil',0,13,'Hun','Bronzezeit',4458242,5792531, ST_GeomFromText('MULTIPOINT(4458242.000057458 5792531.000020237)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (21,55,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)','Dön002',0,'Einzelfund, Steinaxt, Nackenfragment mit nicht vollständiger Durchbohrung',0,2,'Dön','Spätneolithikum/Endneolithikum',4456936,5790435, ST_GeomFromText('MULTIPOINT(4456936.274360242 5790435.060690285)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (22,56,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)','Dön002',0,'Einzelfund, Bruchstück Felsgesteinbeil von ursprünglich dreieckiger Form aus einer zerbrochenen Axt gearbeitet (Reste vom Schaftloch)',0,2,'Dön','Spätneolithikum',4456943,5790430, ST_GeomFromText('MULTIPOINT(4456943.153464249 5790429.769042281)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (23,68,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)','AHa046',0,'Einzelfund, Feuersteinbeil, grau, Schneide geschliffen',0,46,'AHa','Spätneolithikum/Endneolithikum',4457372,5793063, ST_GeomFromText('MULTIPOINT(4457371.999928648 5793063.000020733)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (24,69,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)','AHa003',0,'Einzelfund, Schneide eines Felsgesteinbeils, L p cm, Br. 6,3 cm, grau',0,3,'AHa','Spätneolithikum/Endneolithikum',4462314,5794368, ST_GeomFromText('MULTIPOINT(4462313.63487725 5794367.807189948)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (25,70,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)','AHa003',0,'Einzelfund, Bruchstück einer Felsgesteinaxt L 10,2 cm, Br. 5 cm',0,3,'AHa','Spätneolithikum/Endneolithikum',4462326,5794355, ST_GeomFromText('MULTIPOINT(4462326.202557262 5794355.239509938)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (26,71,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)','AHa503',0,'Einzelfund, Fragment eines Ovalbeiles aus Grünstein, Acker bei der Ziegelei',0,503,'AHa','Spätneolithikum',4457861,5793396, ST_GeomFromText('MULTIPOINT(4457861.257273104 5793395.775701044)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (27,72,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)','AHa502',0,'Einzelfund, schmales dickblattiges Flintrechteckbeil, Bereich der Mühle',0,502,'AHa','Spätneolithikum',4461026,5791877, ST_GeomFromText('MULTIPOINT(4461025.724476051 5791876.843859629)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (28,73,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun047',0,'Einzelfund, donauländische Steinaxt',0,47,'Hun','Neolithikum',4458410,5791755, ST_GeomFromText('MULTIPOINT(4458410.000057615 5791754.999891515)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (29,74,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun050',0,'Einzelfund, Ovalbeil aus Felsgestein, Schneidenfragment',0,50,'Hun','Spätneolithikum',4457909,5790605, ST_GeomFromText('MULTIPOINT(4457908.992697148 5790605.408082444)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (30,75,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun059',110000,'Siedlung, zahlr. Scherben u.a. 1 Trichterrand mit Pech-Reparatur',110000,59,'Hun','Frühneolithikum, Linienbandkeramik',4458983,5790300, ST_GeomFromText('MULTIPOINT(4458982.938554149 5790300.16661016)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (31,77,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun002',0,'Einzelfund, Axthammer aus Felsgestein, an einer Seite nachgeschliffen',0,2,'Hun','Urgeschichte',4458362,5791360, ST_GeomFromText('MULTIPOINT(4458362.35704957 5791359.692627146)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (32,78,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun042',0,'Einzelfund, Felsgesteinbeil, längs gespalten',0,42,'Hun','Neolithikum',4458212,5789243, ST_GeomFromText('MULTIPOINT(4458211.99992943 5789243.000017175)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (33,79,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun015',0,'Einzelfund, geschliffenes Beil aus Felsgestein, dicknackig',0,15,'Hun','Spätneolithikum',4458753,5791015, ST_GeomFromText('MULTIPOINT(4458752.999993934 5791015.000018825)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (34,80,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun005',0,'Einzelfund, Schaftrillenaxt aus Felsgestein',0,5,'Hun','Urgeschichte',4458177,5790932, ST_GeomFromText('MULTIPOINT(4458176.999993397 5790931.999954748)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (35,81,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun003',0,'Einzelfund, hellgraues Felsbeil',0,3,'Hun','Neolithikum',4458190,5791325, ST_GeomFromText('MULTIPOINT(4458190.25413741 5791324.723411114)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (36,52,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun010',0,'Einzelfund, Steinaxt',0,10,'Hun','Spätneolithikum/Endneolithikum',4458488,5790020, ST_GeomFromText('MULTIPOINT(4458487.938489687 5790020.2645299)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (37,57,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)','Dön023',0,'Einzelfund, Nacken eines Steinbeiles',0,23,'Dön','Neolithikum',4455949,5789700, ST_GeomFromText('MULTIPOINT(4455949.402935323 5789699.537361601)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (38,58,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)','Dön023',0,'Einzelfunde, 2 Fragmente von Steinbeilen',0,23,'Dön','Neolithikum',4456023,5789689, ST_GeomFromText('MULTIPOINT(4456023.486519392 5789688.954065591)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (39,60,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)','Alv512',0,'Einzelfund, Steinaxt',0,512,'Alv','Spätneolithikum/Endneolithikum',4452676,5790175, ST_GeomFromText('MULTIPOINT(4452676.369844275 5790175.454290045)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (40,65,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)','Doe002',0,'Einzelfund, Felsgesteinbeil, grau, beschädigt',0,2,'Doe','Neolithikum',4456959,5790411, ST_GeomFromText('MULTIPOINT(4456958.865464263 5790410.548562264)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (41,66,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)','AHa501',0,'Einzelfund, Dünnackiges beil mit spitzovalem Querschnitt, Gräberweg',0,501,'AHa','Spätneolithikum',4456550,5794168, ST_GeomFromText('MULTIPOINT(4456550.313911883 5794167.777493763)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (42,27,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)','NHa005',110000,'Siedlung, Rosmarienbreite',110000,5,'NHa','Spätneolithikum',4461473,5796731, ST_GeomFromText('MULTIPOINT(4461472.999996467 5796731.000024149)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (43,28,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)','NHa021',0,'Erdgrab, Kugelamphorenkultur',0,21,'NHa','Spätneolithikum',4460935,5797272, ST_GeomFromText('MULTIPOINT(4460934.673339966 5797271.893976652)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (44,29,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)','NHa015',0,'Einzelfund, Felsgesteinbeil',0,15,'NHa','Neolithikum',4458825,5796077, ST_GeomFromText('MULTIPOINT(4458824.999994001 5796077.00002354)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (45,30,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)','NHa028',0,'Einzelfund, kleines Feuersteinbeil',0,28,'NHa','Spätneolithikum/Endneolithikum',4461404,5795909, ST_GeomFromText('MULTIPOINT(4461404.177084404 5795908.510423384)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (46,32,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)','NHa003',0,'Einzelfund, dicknackiges Felsgesteinbeil',0,3,'NHa','Spätneolithikum',4458798,5795902, ST_GeomFromText('MULTIPOINT(4458797.999929976 5795901.999959377)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (47,33,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)','NHa006',0,'Einzelfund, dünnackiges Flintbeil',0,6,'NHa','Spätneolithikum',4458385,5794430, ST_GeomFromText('MULTIPOINT(4458384.999993591 5794430.000086007)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (48,34,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)','NHa008',0,'Einzelfund, großes Felsgesteinbeil',0,8,'NHa','Neolithikum',4459251,5796248, ST_GeomFromText('MULTIPOINT(4459250.999994398 5796247.999959699)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (49,35,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun053',0,'Einzelfund, Dechsel, Steinbeil',0,53,'Hun','Frühneolithikum/Mittelneolithikum',4457841,5789684, ST_GeomFromText('MULTIPOINT(4457840.999993084 5789684.000081587)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (50,36,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun001',0,'Einzelfund, Axt, Datierung unsicher',0,1,'Hun','Spätneolithikum/Endneolithikum',4459581,5791296, ST_GeomFromText('MULTIPOINT(4459580.999994705 5791295.999955087)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (51,88,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun011',0,'Einzelfund, Beil aus schwarz melliertem Felsgestein, Nacken sehr beschädigt',0,11,'Hun','Neolithikum',4457330,5790956, ST_GeomFromText('MULTIPOINT(4457329.764408608 5790956.374226771)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (52,89,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun050',0,'Einzelfund, Steinbeil',0,50,'Hun','Neolithikum',4457875,5790633, ST_GeomFromText('MULTIPOINT(4457875.125945117 5790632.92475447)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (53,37,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)','Alv501',0,'Einzelfund, dünnackiges Feuersteinbeil',0,501,'Alv','Spätneolithikum',4453481,5790868, ST_GeomFromText('MULTIPOINT(4453480.991541024 5790868.03822669)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (54,38,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)','Alv502',0,'Einzelfund, dünnackiges Beil',0,502,'Alv','Spätneolithikum/Endneolithikum',4455798,5788836, ST_GeomFromText('MULTIPOINT(4455797.687735182 5788836.475088797)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (55,39,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)','Alv503',0,'Einzelfund, dünnackiges Feuersteinbeil',0,503,'Alv','Spätneolithikum/Endneolithikum',4453413,5790950, ST_GeomFromText('MULTIPOINT(4453413.401908962 5790949.888850765)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (56,40,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)','Alv504',0,'Einzelfund aus Steinbruch Siebert, "Hacke aus Felsgestein"',0,504,'Alv','Frühneolithikum/Mittelneolithikum',4454518,5791977, ST_GeomFromText('MULTIPOINT(4454518.171829991 5791976.562387721)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (57,41,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)','Alv505',0,'Einzelfund, Druschplatz am Bever, "Beil aus grauem Felsgestein"',0,505,'Alv','Neolithikum',4454721,5789481, ST_GeomFromText('MULTIPOINT(4454720.644662179 5789481.305041398)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (58,43,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)','Alv506',0,'Einzelfund, Breite Dönstedter Weg-Nordh. u. Straße nach Rottmersleben, Beil aus grauem Felsgestein',0,506,'Alv','Neolithikum',4456377,5788349, ST_GeomFromText('MULTIPOINT(4456377.468855721 5788348.621648343)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (59,44,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)','Alv507',0,'Einzelfund, "Esse" Acker bei der Markgrafenmühle, Feuersteinbeil',0,507,'Alv','Spätneolithikum/Endneolithikum',4453163,5789058, ST_GeomFromText('MULTIPOINT(4453162.692148728 5789057.623633002)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (60,45,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)','Alv508',0,'Einzelfund, "angeblich im Bauernholz", Steinaxt',0,508,'Alv','Spätneolithikum/Endneolithikum',4454082,5792818, ST_GeomFromText('MULTIPOINT(4454081.988789584 5792817.757268505)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (61,46,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)','Alv509',0,'Einzelfund, "Richtung Emden am Steinbruch Schwentesius", Steinaxt',0,509,'Alv','Spätneolithikum/Endneolithikum',4452726,5789690, ST_GeomFromText('MULTIPOINT(4452725.864244321 5789689.681489592)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (62,47,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)','Alv510',0,'Einzelfund, Bauernholz, Felsgesteinbeil',0,510,'Alv','Neolithikum',4453968,5792770, ST_GeomFromText('MULTIPOINT(4453968.350005478 5792770.495956461)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (63,48,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)','Alv511',0,'Einzelfund, Bauernholz, Feuersteinbeil',0,511,'Alv','Spätneolithikum/Endneolithikum',4454032,5792776, ST_GeomFromText('MULTIPOINT(4454031.850165537 5792775.787604466)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (64,49,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)','Alv051',0,'Einzelfund, Steinaxt aus Nephrit',0,51,'Alv','Spätneolithikum/Endneolithikum',4452783,5788779, ST_GeomFromText('MULTIPOINT(4452782.999988374 5788778.999888744)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (65,50,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)','Alv065',0,'Einzelfund, Feuersteinbeil',0,65,'Alv','Spätneolithikum/Endneolithikum',4453601,5788070, ST_GeomFromText('MULTIPOINT(4453600.999989136 5788070.000080084)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (66,51,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)','Dön501',0,'Einzelfund, Rüsterberg, dünnackiges Feuersteinbeil',0,501,'Dön','Spätneolithikum',4455690,5789673, ST_GeomFromText('MULTIPOINT(4455690.245303082 5789673.215569576)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (67,82,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun003',0,'Einzelfund, Axthammer mit Randbildung',0,3,'Hun','Urgeschichte',4458190,5791307, ST_GeomFromText('MULTIPOINT(4458190.25413741 5791306.864083098)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (68,83,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun065',0,'Einzelfund, 1 Steinaxtfrg.',0,65,'Hun','Spätneolithikum/Endneolithikum',4458730,5790321, ST_GeomFromText('MULTIPOINT(4458730.241465913 5790321.250002181)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (69,84,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun065',0,'Einzelfund, 1 Steinaxtfrg.',0,65,'Hun','Spätneolithikum/Endneolithikum',4458691,5790316, ST_GeomFromText('MULTIPOINT(4458691.082937876 5790316.487506175)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (70,85,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun065',0,'Einzelfund, 1 Steinaxtfrg.',0,65,'Hun','Spätneolithikum/Endneolithikum',4458820,5790319, ST_GeomFromText('MULTIPOINT(4458819.670713996 5790319.133394178)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (71,86,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun064',0,'Einzelfund, 1 Steinaxt',0,64,'Hun','Spätneolithikum/Endneolithikum',4458136,5790342, ST_GeomFromText('MULTIPOINT(4458136.158393359 5790342.183378199)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (72,87,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun064',0,'Einzelfund, 1 Steinaxt',0,64,'Hun','Spätneolithikum/Endneolithikum',4458060,5790375, ST_GeomFromText('MULTIPOINT(4458059.958329289 5790374.991698229)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (73,107,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)','AHa007',0,'dünnblattiges Ovalbeil aus Feuerstein mit angeschliffener Schneide',110000,7,'AHa','Spätneolithikum',4459974,4459974, ST_GeomFromText('MULTIPOINT(4459923.532219024 5792421.847252136)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (74,90,'Ohrekreis/Börde/Magdeburg','Süpplingen','Sup005',0,'Einzelfund, 1 Steinbeil, vorzeitliche Keramik',0,5,'Süp','Spätneolithikum',4456725,5794962, ST_GeomFromText('MULTIPOINT(4456725.452600046 5794962.268502503)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (75,91,'Ohrekreis/Börde/Magdeburg','Bodendorf','Bod001',0,'Einzelfund, 1 Beil aus Felsgestein, helles grau-grünes Gestein',0,1,'Bod','Spätneolithikum',4452940,5795087, ST_GeomFromText('MULTIPOINT(4452939.79307652 5795086.507094617)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (76,92,'Ohrekreis/Börde/Magdeburg','Süpplingen','Sup001',0,'Einzelfund, 1 Steinbeil',0,1,'Süp','Spätneolithikum',4452314,5797540, ST_GeomFromText('MULTIPOINT(4452314.061235938 5797539.667160904)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (77,93,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)','NULL',110000,'Siedlungsgruben, AktNr. 6657, 6748',110000,0,'Alv','Spätneolithikum, Frühneol, Mittelneol., BZ, EZ',4453188,5789497, ST_GeomFromText('MULTIPOINT(4453188.407860752 5789496.910545412)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (78,94,'Ohrekreis/Börde/Magdeburg','NULL','TSd001',110000,'fiktive Testsiedlung abstand 3,6 km',0,1,'TSd','Spätneolithikum',0,0, ST_GeomFromText('MULTIPOINT(4454834.186294284 5794939.421782482)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (79,95,'Ohrekreis/Börde/Magdeburg','NULL','TSd002',110000,'fiktive Testsiedlung abstand 3,6 km',0,2,'TSd','Spätneolithikum',0,0, ST_GeomFromText('MULTIPOINT(4451876.13867553 5792954.513620633)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (80,96,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)','Dön005',0,'Fund aus Megalithgrab, Feuersteinbeil',422000,5,'Dön','Spätneolithikum',4454638,5791272, ST_GeomFromText('MULTIPOINT(4454638.408758102 5791271.519827065)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (81,97,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)','Dön005',0,'Fund aus Megalithgrab, Feuersteinbeil',422000,5,'Dön','Spätneolithikum',4454696,5791271, ST_GeomFromText('MULTIPOINT(4454695.558966156 5791270.726099064)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (82,98,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)','Dön005',0,'Fund aus Megalithgrab, Felsgesteinbeil',422000,5,'Dön','Spätneolithikum',4454658,5791184, ST_GeomFromText('MULTIPOINT(4454657.80664612 5791183.631442984)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (83,99,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)','Dön005',0,'Fund aus Megalithgrab, Felsgesteinbeil',422000,5,'Dön','Spätneolithikum',4454718,5791183, ST_GeomFromText('MULTIPOINT(4454717.783990176 5791183.413458984)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (84,100,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)','Dön008',0,'Fund aus Megalithgrab, Felsovalbeil',422000,8,'Dön','Spätneolithikum',4454605,5791378, ST_GeomFromText('MULTIPOINT(4454605.335862072 5791378.411731164)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (85,101,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun014',0,'Fund aus Megalithgrab, Feuersteinbeil',422000,14,'Hun','Spätneolithikum',4458273,5792573, ST_GeomFromText('MULTIPOINT(4458272.980793487 5792573.492948278)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (86,102,'Ohrekreis/Börde/Magdeburg','Hundisburg','Hun014',0,'Fund aus Megalithgrab, Felsgesteinbeil',422000,14,'Hun','Spätneolithikum',4458206,5792586, ST_GeomFromText('MULTIPOINT(4458206.305593425 5792586.192980289)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (87,103,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)','NHa007',0,'Fund aus Hausgrube, Feuersteinovalbeil',110000,7,'NHa','Spätneolithikum',4458392,5794646, ST_GeomFromText('MULTIPOINT(4458392.069945598 5794645.943126209)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (88,104,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)','NHa007',0,'Fund aus Hausgrube, Nackenfragment Felsgesteinaxt (Schneide?)',110000,7,'NHa','Spätneolithikum',4458532,5794645, ST_GeomFromText('MULTIPOINT(4458531.637945728 5794645.281494207)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (89,105,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)','NHa007',0,'Lesefund in der Nähe, dünnblattiges Ovalbeil',0,7,'NHa','Spätneolithikum',4458462,5794542, ST_GeomFromText('MULTIPOINT(4458461.523257663 5794542.093910111)', 31468));
INSERT INTO "siedlung_beile" ("PKUID","OBJECTID","Region","Gemarkung","LDANr","Denkmal","Fundart","FundartID","OANr","OAGem","Datier","POINT_X","POINT_Y","geometry")
  VALUES (90,106,'Ohrekreis/Börde/Magdeburg','NULL','NHa32',0,'Einzelfund bei Ausschachtung, 1 Feuersteinbei,geschliffen',0,32,'NHa','Spätneolithikum',4460616,5795330, ST_GeomFromText('MULTIPOINT(4460613.579835667 5795325.365462841)', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (1,1,247,'Alv010',10,'Alv','Stuhlmann','Stein','Stein','NULL',1.56216612119,0.15953856973,0.146570359841,0.381082935587,1, ST_GeomFromText('MULTIPOLYGON(((4455504.266599999 5793220.722899999,4455504.427899999 5793220.685399999,4455504.527999999 5793220.6622,4455504.639299999 5793220.5829,4455504.639299999 5793220.5229,4455504.516699999 5793220.4667,4455504.382899999 5793220.382899999,4455504.254099999 5793220.345399999,4455504.1516 5793220.3879,4455504.043999999 5793220.4867,4455504.019 5793220.541699999,4455504.0403 5793220.5842,4455504.082799999 5793220.669199999,4455504.1266 5793220.7179,4455504.1841 5793220.7379,4455504.266599999 5793220.722899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (2,2,247,'Alv010',10,'Alv','Stuhlmann','Kammerstein?','Kammerstein','NULL',2.35155239817,0.379162759807,0.314890339116,0.818714881702,1, ST_GeomFromText('MULTIPOLYGON(((4455509.2948 5793220.730799999,4455509.370099999 5793220.707599999,4455509.404299999 5793220.707599999,4455509.527499999 5793220.591299999,4455509.513799999 5793220.5338,4455509.496 5793220.4517,4455509.4577 5793220.412,4455509.409799999 5793220.327199999,4455509.378299999 5793220.264299999,4455509.3386 5793220.198599999,4455509.301699999 5793220.1534,4455509.255099999 5793220.087799999,4455509.211299999 5793220.0426,4455509.144199999 5793220.000199999,4455509.0772 5793219.9824,4455509.0662 5793219.9824,4455508.960799999 5793219.9646,4455508.915599999 5793219.983799999,4455508.8568 5793220.0317,4455508.8239 5793220.0741,4455508.800699999 5793220.143899999,4455508.800699999 5793220.193099999,4455508.8184 5793220.2355,4455508.860899999 5793220.3956,4455508.9362 5793220.503699999,4455509.001899999 5793220.6542,4455509.0909 5793220.7431,4455509.1812 5793220.773199999,4455509.2401 5793220.773199999,4455509.2948 5793220.730799999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (3,3,247,'Alv010',10,'Alv','Stuhlmann','Kammerstein?','Kammerstein','NULL',2.0153351747,0.308482175005,0.260720738924,0.677873921202,1, ST_GeomFromText('MULTIPOLYGON(((4455500.543399999 5793221.0325,4455500.6259 5793220.9682,4455500.683699999 5793220.897299999,4455500.711799999 5793220.804899999,4455500.711799999 5793220.707599999,4455500.695199999 5793220.625099999,4455500.6094 5793220.478299999,4455500.5137 5793220.412399999,4455500.3124 5793220.4338,4455500.206799999 5793220.4866,4455500.1474 5793220.572399999,4455500.1375 5793220.673,4455500.1787 5793220.8956,4455500.1972 5793220.9953,4455500.231499999 5793221.044099999,4455500.3207 5793221.0952,4455500.4296 5793221.0952,4455500.543399999 5793221.0325)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (4,4,247,'Alv010',10,'Alv','Stuhlmann','Kammerstein?','Kammerstein','NULL',1.75462124404,0.223005705137,0.195211572417,0.507550088284,1, ST_GeomFromText('MULTIPOLYGON(((4455507.3141 5793221.3416,4455507.3683 5793221.285399999,4455507.415 5793221.236899999,4455507.415 5793221.2047,4455507.387 5793221.138399999,4455507.387 5793221.107499999,4455507.387 5793221.0589,4455507.351599999 5793221.014799999,4455507.3163 5793220.950699999,4455507.2478 5793220.8801,4455507.183799999 5793220.827099999,4455507.0866 5793220.798399999,4455507.007 5793220.855799999,4455506.9341 5793220.9,4455506.878899999 5793220.972799999,4455506.8546 5793221.0501,4455506.8546 5793221.094299999,4455506.892199999 5793221.176,4455506.9165 5793221.2025,4455507.0645 5793221.308399999,4455507.1572 5793221.3769,4455507.205799999 5793221.4034,4455507.254399999 5793221.4034,4455507.3141 5793221.3416)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (5,5,247,'Alv010',10,'Alv','Stuhlmann','Stein','Stein','NULL',1.21607627888,0.105296410078,0.104999168684,0.272997838577,1, ST_GeomFromText('MULTIPOLYGON(((4455506.7795 5793221.800799999,4455506.8391 5793221.756599999,4455506.8391 5793221.650699999,4455506.8391 5793221.617499999,4455506.803799999 5793221.5425,4455506.7766 5793221.4846,4455506.717699999 5793221.454199999,4455506.653599999 5793221.454199999,4455506.6028 5793221.516,4455506.5608 5793221.5668,4455506.5255 5793221.619799999,4455506.5255 5793221.6904,4455506.5255 5793221.7302,4455506.523299999 5793221.763299999,4455506.576299999 5793221.845,4455506.669099999 5793221.898,4455506.726499999 5793221.898,4455506.7795 5793221.800799999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (6,6,247,'Alv010',10,'Alv','Stuhlmann','Deckstein?','Deckstein','NULL',3.16910034095,0.771549515364,0.615615548575,1.60060042629,1, ST_GeomFromText('MULTIPOLYGON(((4455502.875 5793222.170399999,4455502.9356 5793222.1052,4455502.998399999 5793221.963199999,4455502.998399999 5793221.8771,4455503.024 5793221.7375,4455503.024 5793221.663,4455502.9658 5793221.4582,4455502.9193 5793221.404699999,4455502.871399999 5793221.3497,4455502.7889 5793221.311599999,4455502.688699999 5793221.2232,4455502.593299999 5793221.1883,4455502.462899999 5793221.1883,4455502.393 5793221.213899999,4455502.304499999 5793221.251099999,4455502.225399999 5793221.3046,4455502.169499999 5793221.3605,4455502.143899999 5793221.4349,4455502.104299999 5793221.5699,4455502.104299999 5793221.7235,4455502.104299999 5793221.804999999,4455502.1299 5793221.8702,4455502.190499999 5793221.960899999,4455502.253299999 5793222.0656,4455502.379099999 5793222.1797,4455502.469899999 5793222.2192,4455502.529299999 5793222.2451,4455502.621199999 5793222.2451,4455502.7027 5793222.2451,4455502.793499999 5793222.2451,4455502.875 5793222.170399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (7,7,247,'Alv010',10,'Alv','Stuhlmann','Deckstein?','Deckstein','NULL',3.25902112118,0.702845829929,0.562961044058,1.46369871455,1, ST_GeomFromText('MULTIPOLYGON(((4455505.6068 5793222.286299999,4455505.7471 5793222.223099999,4455505.882199999 5793222.1267,4455506.029699999 5793222.0127,4455506.1637 5793221.872899999,4455506.2626 5793221.7695,4455506.330799999 5793221.675,4455506.370099999 5793221.591499999,4455506.370099999 5793221.512199999,4455506.319099999 5793221.4396,4455506.163999999 5793221.3179,4455506.060899999 5793221.2904,4455505.9176 5793221.2747,4455505.8381 5793221.2747,4455505.662499999 5793221.3793,4455505.5262 5793221.564899999,4455505.4253 5793221.6643,4455505.3819 5793221.777799999,4455505.345399999 5793221.912299999,4455505.320199999 5793222.1041,4455505.320199999 5793222.2288,4455505.327899999 5793222.2705,4455505.3858 5793222.3319,4455505.489299999 5793222.3319,4455505.6068 5793222.286299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (8,8,247,'Alv010',10,'Alv','Stuhlmann','Kammerstein?','Kammerstein','NULL',2.36703384788,0.381272605097,0.316507324546,0.82291904382,1, ST_GeomFromText('MULTIPOLYGON(((4455507.9998 5793222.358799999,4455508.084999999 5793222.313599999,4455508.1633 5793222.219699999,4455508.187599999 5793222.148399999,4455508.208499999 5793222.073699999,4455508.1911 5793221.969399999,4455508.1911 5793221.8825,4455508.1911 5793221.814699999,4455508.138899999 5793221.746999999,4455508.092 5793221.684399999,4455508.025899999 5793221.5853,4455507.9181 5793221.4897,4455507.8364 5793221.461899999,4455507.771999999 5793221.461899999,4455507.699 5793221.5436,4455507.632899999 5793221.600999999,4455507.603299999 5793221.670499999,4455507.603299999 5793221.74,4455507.6068 5793221.771299999,4455507.651999999 5793221.9416,4455507.7372 5793222.073699999,4455507.754599999 5793222.1641,4455507.7894 5793222.2423,4455507.862399999 5793222.3396,4455507.933699999 5793222.379599999,4455507.9998 5793222.358799999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (9,9,247,'Alv010',10,'Alv','Stuhlmann','Deckstein?','Deckstein','NULL',3.21818769912,0.728600710209,0.582699584304,1.51501891919,1, ST_GeomFromText('MULTIPOLYGON(((4455504.6407 5793222.642899999,4455504.741299999 5793222.5854,4455504.827499999 5793222.513599999,4455504.8688 5793222.459799999,4455504.8688 5793222.386199999,4455504.839999999 5793222.310799999,4455504.8103 5793222.232699999,4455504.8103 5793222.134899999,4455504.7718 5793222.034399999,4455504.723799999 5793221.9437,4455504.704699999 5793221.773299999,4455504.665099999 5793221.5883,4455504.552799999 5793221.500099999,4455504.4143 5793221.500099999,4455504.281899999 5793221.5402,4455504.193599999 5793221.606399999,4455504.1365 5793221.649199999,4455504.045199999 5793221.7949,4455504.021099999 5793221.975299999,4455504.021099999 5793222.0896,4455504.0431 5793222.250099999,4455504.1222 5793222.3825,4455504.234899999 5793222.517,4455504.3426 5793222.617699999,4455504.4324 5793222.6464,4455504.5294 5793222.6662,4455504.6407 5793222.642899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (10,10,247,'Alv010',10,'Alv','Stuhlmann','Kammerstein?','Kammerstein','NULL',2.36064624027,0.421825885356,0.347587358537,0.903727132196,1, ST_GeomFromText('MULTIPOLYGON(((4455501.354899999 5793222.6894,4455501.4455 5793222.587799999,4455501.4862 5793222.4547,4455501.4603 5793222.328999999,4455501.4369 5793222.215299999,4455501.3475 5793222.068399999,4455501.249499999 5793221.957499999,4455501.121899999 5793221.911299999,4455501.016499999 5793221.911299999,4455500.9093 5793221.989,4455500.859299999 5793222.086899999,4455500.8057 5793222.188599999,4455500.8057 5793222.3013,4455500.8371 5793222.4251,4455500.848199999 5793222.4528,4455500.918499999 5793222.5822,4455501.025799999 5793222.693099999,4455501.121899999 5793222.7412,4455501.229199999 5793222.7412,4455501.354899999 5793222.6894)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (11,11,247,'Alv010',10,'Alv','Stuhlmann','Stein','Stein','NULL',1.40795082598,0.147413359895,0.137277599024,0.356921757461,1, ST_GeomFromText('MULTIPOLYGON(((4455504.7922 5793223.220399999,4455504.848399999 5793223.116,4455504.872499999 5793222.9987,4455504.872499999 5793222.916799999,4455504.835599999 5793222.8365,4455504.782499999 5793222.8091,4455504.7022 5793222.8091,4455504.616999999 5793222.858899999,4455504.535 5793222.9296,4455504.4594 5793223.058199999,4455504.4594 5793223.1127,4455504.4707 5793223.138499999,4455504.5141 5793223.238099999,4455504.588 5793223.2815,4455504.6539 5793223.2815,4455504.7182 5793223.2815,4455504.7922 5793223.220399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (12,12,247,'Alv010',10,'Alv','Stuhlmann','Kammerstein?','Kammerstein','NULL',2.78242511017,0.492378915082,0.401659200519,1.04431392135,1, ST_GeomFromText('MULTIPOLYGON(((4455502.4729 5793223.355299999,4455502.5546 5793223.287599999,4455502.587299999 5793223.210599999,4455502.587299999 5793223.1336,4455502.587299999 5793223.0565,4455502.5453 5793222.944499999,4455502.4729 5793222.818499999,4455502.421699999 5793222.729299999,4455502.3048 5793222.5477,4455502.2137 5793222.41,4455502.136599999 5793222.3516,4455502.0969 5793222.3516,4455502.0455 5793222.3516,4455501.9895 5793222.379599999,4455501.931099999 5793222.419299999,4455501.878499999 5793222.455099999,4455501.839999999 5793222.515,4455501.839999999 5793222.5874,4455501.839999999 5793222.6621,4455501.839999999 5793222.725099999,4455501.877399999 5793222.795099999,4455501.9236 5793222.8671,4455502.093899999 5793223.179199999,4455502.1496 5793223.2813,4455502.250099999 5793223.3826,4455502.3398 5793223.4067,4455502.409799999 5793223.4067,4455502.4729 5793223.355299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (13,13,247,'Alv010',10,'Alv','Stuhlmann','Stein','Stein','NULL',1.64664604732,0.187316585086,0.16785943081,0.436434520105,1, ST_GeomFromText('MULTIPOLYGON(((4455505.8238 5793223.3958,4455505.887199999 5793223.3296,4455505.9313 5793223.257999999,4455505.969899999 5793223.197399999,4455505.969899999 5793223.081599999,4455505.9424 5793222.968599999,4455505.9424 5793222.929999999,4455505.9424 5793222.872099999,4455505.892699999 5793222.872099999,4455505.7576 5793222.918999999,4455505.683199999 5793222.963099999,4455505.589399999 5793222.9962,4455505.5343 5793223.0623,4455505.501199999 5793223.1257,4455505.525999999 5793223.197399999,4455505.586699999 5793223.376499999,4455505.674899999 5793223.439899999,4455505.7466 5793223.439899999,4455505.8238 5793223.3958)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (14,14,247,'Alv010',10,'Alv','Stuhlmann','Kammerstein?','Kammerstein','NULL',2.12460238617,0.314275400376,0.265160666848,0.689417733805,1, ST_GeomFromText('MULTIPOLYGON(((4455504.3035 5793223.5763,4455504.362099999 5793223.547,4455504.418999999 5793223.491699999,4455504.4483 5793223.4186,4455504.470999999 5793223.306399999,4455504.4548 5793223.23,4455504.439299999 5793223.1574,4455504.418999999 5793223.0919,4455504.3832 5793223.061,4455504.3084 5793223.0009,4455504.2434 5793223.018699999,4455504.1084 5793223.080499999,4455504.023799999 5793223.116299999,4455503.8726 5793223.190999999,4455503.8108 5793223.221899999,4455503.742499999 5793223.2739,4455503.696899999 5793223.3341,4455503.7012 5793223.3615,4455503.831899999 5793223.4934,4455503.935999999 5793223.547,4455504.036799999 5793223.5763,4455504.1084 5793223.6039,4455504.1653 5793223.6039,4455504.217299999 5793223.6039,4455504.261199999 5793223.6039,4455504.3035 5793223.5763)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (15,15,247,'Alv010',10,'Alv','Stuhlmann','Stein','Stein','NULL',2.72553350671,0.567269864985,0.459055624524,1.19354462376,1, ST_GeomFromText('MULTIPOLYGON(((4455511.7773 5793223.6475,4455511.889999999 5793223.503299999,4455511.9561 5793223.2584,4455511.983099999 5793223.0932,4455511.9681 5793222.9986,4455511.899 5793222.899499999,4455511.8118 5793222.8123,4455511.7126 5793222.7342,4455511.613499999 5793222.7102,4455511.529299999 5793222.744699999,4455511.388 5793222.7913,4455511.282899999 5793222.8649,4455511.221199999 5793222.997099999,4455511.1912 5793223.099199999,4455511.1912 5793223.219399999,4455511.230299999 5793223.366599999,4455511.263299999 5793223.414699999,4455511.2889 5793223.452199999,4455511.384999999 5793223.545299999,4455511.4767 5793223.600899999,4455511.5729 5793223.6475,4455511.66 5793223.6685,4455511.7773 5793223.6475)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (16,16,247,'Alv010',10,'Alv','Stuhlmann','Stein','Stein','NULL',1.61990272159,0.196955650343,0.175246810423,0.455641707099,1, ST_GeomFromText('MULTIPOLYGON(((4455508.5667 5793223.7686,4455508.644899999 5793223.6554,4455508.6989 5793223.563699999,4455508.712399999 5793223.4342,4455508.6867 5793223.342599999,4455508.6112 5793223.281899999,4455508.524799999 5793223.265699999,4455508.4331 5793223.293999999,4455508.314399999 5793223.347999999,4455508.229399999 5793223.4208,4455508.229399999 5793223.5394,4455508.229399999 5793223.606799999,4455508.247 5793223.6217,4455508.319799999 5793223.7444,4455508.4088 5793223.798299999,4455508.4763 5793223.815799999,4455508.5667 5793223.7686)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (17,17,247,'Alv010',10,'Alv','Stuhlmann','Stein','Stein','NULL',1.54830307271,0.179653419856,0.161986380978,0.421164590542,1, ST_GeomFromText('MULTIPOLYGON(((4455503.4801 5793224.299399999,4455503.5667 5793224.217199999,4455503.620099999 5793224.140699999,4455503.620099999 5793224.0109,4455503.620099999 5793223.896999999,4455503.5667 5793223.837899999,4455503.4614 5793223.796,4455503.330099999 5793223.835,4455503.252199999 5793223.898399999,4455503.206 5793223.984999999,4455503.206 5793224.0975,4455503.206 5793224.1782,4455503.2421 5793224.263299999,4455503.307 5793224.3167,4455503.368999999 5793224.340199999,4455503.437099999 5793224.340199999,4455503.4801 5793224.299399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (18,18,247,'Alv010',10,'Alv','Stuhlmann','Stein','Stein','NULL',1.76353340193,0.23556982479,0.204840713719,0.532585855669,1, ST_GeomFromText('MULTIPOLYGON(((4455504.440999999 5793224.3969,4455504.489799999 5793224.369599999,4455504.549999999 5793224.303799999,4455504.599999999 5793224.184599999,4455504.614799999 5793224.090399999,4455504.614799999 5793224.050599999,4455504.578399999 5793223.990499999,4455504.526999999 5793223.9053,4455504.4649 5793223.8406,4455504.406899999 5793223.8111,4455504.3058 5793223.8111,4455504.219499999 5793223.833799999,4455504.137699999 5793223.897399999,4455504.093399999 5793223.991599999,4455504.115 5793224.0449,4455504.1287 5793224.150499999,4455504.1287 5793224.252699999,4455504.165 5793224.2936,4455504.264999999 5793224.367399999,4455504.313799999 5793224.3957,4455504.378499999 5793224.409399999,4455504.440999999 5793224.3969)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (19,19,247,'Alv010',10,'Alv','Stuhlmann','Stein','Stein','NULL',1.17339660597,0.0946795997182,0.0968624452241,0.251842357583,1, ST_GeomFromText('MULTIPOLYGON(((4455488.224999999 5793228.084699999,4455488.1944 5793227.9733,4455488.088499999 5793227.9065,4455487.871199999 5793227.9984,4455487.834999999 5793228.107,4455487.8879 5793228.2323,4455487.971499999 5793228.3047,4455488.224999999 5793228.084699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (20,20,247,'Alv010',10,'Alv','Stuhlmann','Kammerstein?','Kammerstein','NULL',1.97352136069,0.284665655204,0.242467758149,0.630416171186,1, ST_GeomFromText('MULTIPOLYGON(((4455487.462799999 5793230.673699999,4455487.5415 5793230.5622,4455487.5992 5793230.442399999,4455487.582 5793230.368499999,4455487.5299 5793230.285499999,4455487.4105 5793230.205499999,4455487.2992 5793230.2113,4455487.177 5793230.1501,4455487.0442 5793230.1611,4455486.9993 5793230.1981,4455486.9742 5793230.279999999,4455486.976099999 5793230.410199999,4455487.0032 5793230.6247,4455487.035 5793230.6841,4455487.2807 5793230.7409,4455487.389899999 5793230.711899999,4455487.462799999 5793230.673699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (21,21,247,'Alv010',10,'Alv','Stuhlmann','Kammerstein?','Kammerstein','NULL',1.78603021097,0.226376709745,0.197795110349,0.514267286906,1, ST_GeomFromText('MULTIPOLYGON(((4455488.6014 5793230.6553,4455488.615899999 5793230.549599999,4455488.571 5793230.349899999,4455488.4811 5793230.3,4455488.396399999 5793230.303899999,4455488.2889 5793230.3812,4455488.1072 5793230.470399999,4455488.0932 5793230.740499999,4455488.166199999 5793230.846799999,4455488.3397 5793230.912799999,4455488.4917 5793230.7596,4455488.6014 5793230.6553)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (22,22,247,'Alv010',10,'Alv','Stuhlmann','Kammerstein?','Kammerstein','NULL',1.32008484578,0.120440655207,0.116605718151,0.303174867192,1, ST_GeomFromText('MULTIPOLYGON(((4455488.417 5793231.412,4455488.4345 5793231.1992,4455488.362999999 5793231.104,4455488.2614 5793231.010299999,4455488.087199999 5793231.0962,4455488.0606 5793231.1491,4455488.1193 5793231.296099999,4455488.235999999 5793231.4898,4455488.327499999 5793231.4918,4455488.417 5793231.412)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (23,23,248,'Alv011',11,'Alv','Stuhlmann','Deckstein?','Deckstein','NULL',3.2001655707,0.746466279756,0.596391756805,1.55061856769,1, ST_GeomFromText('MULTIPOLYGON(((4455487.9024 5793231.433,4455487.927699999 5793231.3438,4455487.8331 5793231.068299999,4455487.7324 5793230.8746,4455487.580099999 5793230.780799999,4455487.2152 5793230.8966,4455487.1513 5793230.8859,4455487.0767 5793230.9019,4455486.9582 5793231.037699999,4455486.893299999 5793231.214099999,4455486.8786 5793231.294299999,4455486.865 5793231.478199999,4455486.8956 5793231.597999999,4455487.1287 5793231.660599999,4455487.4921 5793231.708,4455487.6446 5793231.708,4455487.9024 5793231.433)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (24,24,248,'Alv011',11,'Alv','Stuhlmann','Kammerstein?','Kammerstein','NULL',2.41943869201,0.426315310243,0.35102805377,0.912672939803,1, ST_GeomFromText('MULTIPOLYGON(((4455487.850899999 5793233.7125,4455487.915199999 5793233.5699,4455487.927099999 5793233.297399999,4455487.814699999 5793233.1585,4455487.6348 5793233.137199999,4455487.363599999 5793233.232599999,4455487.1982 5793233.382099999,4455487.145499999 5793233.681199999,4455487.5771 5793233.869,4455487.682599999 5793233.8825,4455487.850899999 5793233.7125)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (25,25,248,'Alv011',11,'Alv','Stuhlmann','Kammerstein?','Kammerstein','NULL',1.80644002472,0.192889854704,0.172130784645,0.447540040078,1, ST_GeomFromText('MULTIPOLYGON(((4455487.494699999 5793234.2606,4455487.5634 5793234.186899999,4455487.5695 5793234.1502,4455487.440299999 5793234.0383,4455487.167799999 5793233.9853,4455486.896399999 5793233.9307,4455486.870099999 5793234.072799999,4455486.883299999 5793234.220799999,4455486.9905 5793234.3015,4455487.1703 5793234.297299999,4455487.3787 5793234.3124,4455487.494699999 5793234.2606)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (26,26,249,'Alv012',12,'Alv','Stuhlmann','Deckstein?','Deckstein','NULL',2.88290592532,0.602172280071,0.485804835447,1.26309257216,1, ST_GeomFromText('MULTIPOLYGON(((4455926.848699999 5793358.033999999,4455926.9006 5793358.029699999,4455926.9934 5793357.991499999,4455927.061599999 5793357.9634,4455927.1692 5793357.8923,4455927.1692 5793357.8186,4455927.2203 5793357.7335,4455927.2033 5793357.662599999,4455927.188 5793357.599099999,4455927.1677 5793357.514299999,4455927.148599999 5793357.4348,4455927.0586 5793357.356399999,4455927.0246 5793357.288399999,4455926.9309 5793357.197599999,4455926.8688 5793357.137399999,4455926.7664 5793357.109699999,4455926.7016 5793357.092199999,4455926.5776 5793357.0588,4455926.5026 5793357.106899999,4455926.445799999 5793357.203299999,4455926.397599999 5793357.285199999,4455926.394799999 5793357.3933,4455926.3924 5793357.481699999,4455926.4028 5793357.5961,4455926.4175 5793357.674,4455926.4345 5793357.764699999,4455926.4714 5793357.807199999,4455926.5037 5793357.844599999,4455926.5054 5793357.9206,4455926.5848 5793357.963199999,4455926.6522 5793357.999199999,4455926.7465 5793358.0426,4455926.848699999 5793358.033999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (27,27,249,'Alv012',12,'Alv','Stuhlmann','Deckstein?','Deckstein','NULL',3.14583191033,0.749187285623,0.598477135702,1.55604055282,1, ST_GeomFromText('MULTIPOLYGON(((4455933.457899999 5793358.1102,4455933.5426 5793358.0536,4455933.5899 5793357.9462,4455933.5827 5793357.782199999,4455933.5778 5793357.6674,4455933.571 5793357.513299999,4455933.4543 5793357.343699999,4455933.3437 5793357.258099999,4455933.168899999 5793357.2082,4455932.965599999 5793357.197499999,4455932.773 5793357.243899999,4455932.6517 5793357.3473,4455932.612499999 5793357.479199999,4455932.626699999 5793357.6147,4455932.636599999 5793357.7082,4455932.669499999 5793357.7608,4455932.8015 5793357.992599999,4455932.9192 5793358.0567,4455932.9817 5793358.0908,4455933.051199999 5793358.135199999,4455933.183199999 5793358.1423,4455933.2866 5793358.1479,4455933.3929 5793358.153599999,4455933.457899999 5793358.1102)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (28,28,249,'Alv012',12,'Alv','Stuhlmann','Stein','Stein','NULL',1.51581872548,0.173152884962,0.157004371035,0.40821136469,1, ST_GeomFromText('MULTIPOLYGON(((4455928.082499999 5793358.6399,4455928.1549 5793358.607699999,4455928.2055 5793358.5852,4455928.2575 5793358.5293,4455928.324099999 5793358.457599999,4455928.333999999 5793358.410599999,4455928.315899999 5793358.330199999,4455928.273599999 5793358.288,4455928.2273 5793358.241699999,4455928.178999999 5793358.2115,4455928.088499999 5793358.2115,4455927.9879 5793358.2156,4455927.911399999 5793358.2598,4455927.808799999 5793358.400599999,4455927.8068 5793358.482999999,4455927.8591 5793358.595599999,4455927.979799999 5793358.629799999,4455928.0322 5793358.6519,4455928.082499999 5793358.6399)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (29,29,249,'Alv012',12,'Alv','Stuhlmann','Deckstein?','Deckstein','NULL',2.41814600936,0.367768549994,0.306157816716,0.796010323461,1, ST_GeomFromText('MULTIPOLYGON(((4455927.6945 5793359.628,4455927.7799 5793359.570199999,4455927.786899999 5793359.4779,4455927.7975 5793359.3366,4455927.807199999 5793359.2069,4455927.766099999 5793358.9999,4455927.7361 5793358.848899999,4455927.671299999 5793358.743599999,4455927.642599999 5793358.696699999,4455927.504399999 5793358.674699999,4455927.4165 5793358.7431,4455927.348 5793358.8668,4455927.318699999 5793359.013299999,4455927.3513 5793359.137,4455927.3578 5793359.2673,4455927.3732 5793359.358799999,4455927.400999999 5793359.512499999,4455927.4703 5793359.597999999,4455927.518899999 5793359.6464,4455927.613599999 5793359.6511,4455927.6945 5793359.628)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (30,30,249,'Alv012',12,'Alv','Stuhlmann','Stein','Stein','NULL',2.05848795334,0.320814669835,0.270172362962,0.702448143701,1, ST_GeomFromText('MULTIPOLYGON(((4455931.578099999 5793361.4688,4455931.699699999 5793361.429099999,4455931.786199999 5793361.356699999,4455931.832999999 5793361.246799999,4455931.858699999 5793361.1019,4455931.8486 5793360.9821,4455931.7839 5793360.912699999,4455931.7207 5793360.8449,4455931.6386 5793360.8177,4455931.540699999 5793360.842599999,4455931.427699999 5793360.8713,4455931.3233 5793360.9688,4455931.258999999 5793361.028699999,4455931.2554 5793361.116,4455931.250799999 5793361.230499999,4455931.284099999 5793361.3738,4455931.355999999 5793361.459499999,4455931.4346 5793361.515699999,4455931.578099999 5793361.4688)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (31,31,337,'Hun016',16,'Hun','Stuhlmann','Deckstein?','Deckstein','NULL',4.57730788554,1.37210154574,1.07587862466,2.7972844241,1, ST_GeomFromText('MULTIPOLYGON(((4456578.290099999 5793363.435699999,4456578.4718 5793363.3004,4456578.6051 5793363.2794,4456578.8145 5793363.1103,4456578.931699999 5793363.038699999,4456578.9845 5793362.947699999,4456578.948099999 5793362.808,4456578.893899999 5793362.7299,4456578.8108 5793362.677799999,4456578.2076 5793362.502699999,4456577.977199999 5793362.415899999,4456577.8152 5793362.418299999,4456577.6583 5793362.3846,4456577.394199999 5793362.415899999,4456577.33 5793362.459699999,4456577.2752 5793362.5284,4456577.253899999 5793362.6367,4456577.443799999 5793363.224799999,4456577.499699999 5793363.303899999,4456577.6513 5793363.445599999,4456577.8568 5793363.567399999,4456577.910899999 5793363.578099999,4456577.955699999 5793363.5592,4456578.023199999 5793363.5128,4456578.1535 5793363.496899999,4456578.290099999 5793363.435699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (32,32,337,'Hun016',16,'Hun','Stuhlmann','Stein','Stein','NULL',1.55811232841,0.184461764982,0.165671496682,0.430745891373,1, ST_GeomFromText('MULTIPOLYGON(((4456583.9819 5793364.1291,4456584.0257 5793364.0291,4456584.003399999 5793363.9052,4456583.957 5793363.7937,4456583.906999999 5793363.729499999,4456583.8528 5793363.7078,4456583.750599999 5793363.733699999,4456583.631799999 5793363.808299999,4456583.5383 5793363.8953,4456583.5119 5793363.9646,4456583.536999999 5793364.0535,4456583.6072 5793364.138599999,4456583.7417 5793364.210799999,4456583.8392 5793364.2057,4456583.9819 5793364.1291)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (33,33,337,'Hun016',16,'Hun','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',3.66848658049,0.823361185585,0.655324012632,1.70384243284,1, ST_GeomFromText('MULTIPOLYGON(((4456582.7593 5793367.3628,4456582.8299 5793367.2725,4456582.9654 5793367.1925,4456583.151399999 5793367.131699999,4456583.243099999 5793367.0423,4456583.2877 5793366.9502,4456583.300099999 5793366.8046,4456583.2279 5793366.6005,4456583.188699999 5793366.5437,4456583.0887 5793366.515799999,4456582.6692 5793366.632899999,4456582.5158 5793366.705099999,4456582.3826 5793366.800599999,4456582.004599999 5793366.9067,4456581.905199999 5793366.9635,4456581.888 5793367.013299999,4456581.906899999 5793367.1103,4456582.035099999 5793367.292999999,4456582.215099999 5793367.395899999,4456582.4511 5793367.458,4456582.5712 5793367.4571,4456582.675699999 5793367.422199999,4456582.7593 5793367.3628)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (34,34,337,'Hun016',16,'Hun','Stuhlmann','Kammerstein','Kammerstein','NULL',2.35676081225,0.351476220123,0.293671375102,0.763545575266,1, ST_GeomFromText('MULTIPOLYGON(((4456581.324799999 5793368.7977,4456581.358599999 5793368.7653,4456581.3589 5793368.7277,4456581.1693 5793368.539999999,4456580.9062 5793368.375099999,4456580.738499999 5793368.333399999,4456580.3974 5793368.502499999,4456580.391999999 5793368.554999999,4456580.4428 5793368.6523,4456580.669499999 5793368.8387,4456580.903599999 5793368.914999999,4456581.095999999 5793368.883199999,4456581.324799999 5793368.7977)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (35,35,337,'Hun016',16,'Hun','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.78429756244,0.486887950052,0.39745092492,1.03337240479,1, ST_GeomFromText('MULTIPOLYGON(((4456582.6999 5793368.7444,4456582.597799999 5793368.5382,4456582.422399999 5793368.323699999,4456582.2503 5793367.9889,4456582.193099999 5793367.955299999,4456581.8173 5793368.120799999,4456581.7788 5793368.181299999,4456581.7679 5793368.274499999,4456581.805999999 5793368.494799999,4456581.9127 5793368.647299999,4456581.9751 5793368.6885,4456582.144299999 5793368.7475,4456582.2647 5793368.765399999,4456582.397199999 5793368.7977,4456582.605399999 5793368.810699999,4456582.676599999 5793368.7938,4456582.6999 5793368.7444)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (36,36,337,'Hun016',16,'Hun','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',3.04105384689,0.688586669998,0.552032823886,1.4352853421,1, ST_GeomFromText('MULTIPOLYGON(((4456584.635999999 5793368.352399999,4456584.8014 5793368.175,4456584.807699999 5793368.042999999,4456584.763199999 5793367.8442,4456584.7208 5793367.7245,4456584.5821 5793367.4997,4456584.4369 5793367.470699999,4456584.2854 5793367.489299999,4456584.063199999 5793367.5831,4456583.9259 5793367.690199999,4456583.9259 5793367.9459,4456584.083399999 5793368.3439,4456584.138 5793368.434,4456584.1791 5793368.4868,4456584.2213 5793368.508099999,4456584.411799999 5793368.4846,4456584.635999999 5793368.352399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (37,37,337,'Hun016',16,'Hun','Stuhlmann','Kammerstein','Kammerstein','NULL',1.21485158669,0.111343430079,0.109633604813,0.285047372513,1, ST_GeomFromText('MULTIPOLYGON(((4456586.4078 5793367.378299999,4456586.396099999 5793367.263299999,4456586.3649 5793367.2002,4456586.275799999 5793367.1184,4456586.225899999 5793367.101999999,4456586.147099999 5793367.1161,4456586.0274 5793367.2068,4456586.0119 5793367.3037,4456586.086199999 5793367.4264,4456586.271599999 5793367.4876,4456586.3649 5793367.4579,4456586.4078 5793367.378299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (38,38,337,'Hun016',16,'Hun','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',1.83201422049,0.247042154944,0.213633107549,0.555446079628,1, ST_GeomFromText('MULTIPOLYGON(((4456583.657399999 5793370.48,4456583.6924 5793370.287799999,4456583.661399999 5793370.1677,4456583.602199999 5793370.103499999,4456583.428999999 5793370.091499999,4456583.2625 5793370.1508,4456583.1741 5793370.222999999,4456583.089999999 5793370.381699999,4456583.064299999 5793370.484899999,4456583.1096 5793370.547599999,4456583.254099999 5793370.590199999,4456583.4378 5793370.6051,4456583.596099999 5793370.554199999,4456583.657399999 5793370.48)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (39,39,337,'Hun016',16,'Hun','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.35025197712,0.416126465252,0.343219322969,0.89237023972,1, ST_GeomFromText('MULTIPOLYGON(((4456585.2933 5793370.070499999,4456585.3732 5793369.9777,4456585.398299999 5793369.9166,4456585.3968 5793369.791699999,4456585.3046 5793369.6401,4456585.161399999 5793369.513699999,4456585.015599999 5793369.426999999,4456584.858699999 5793369.4887,4456584.6698 5793369.606499999,4456584.626099999 5793369.6719,4456584.638299999 5793369.783199999,4456584.722199999 5793369.9756,4456584.8788 5793370.143799999,4456584.966799999 5793370.2059,4456585.0219 5793370.219,4456585.076399999 5793370.2093,4456585.2933 5793370.070499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (40,40,337,'Hun016',16,'Hun','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.10853718771,0.244415140384,0.21161976359,0.550211385334,1, ST_GeomFromText('MULTIPOLYGON(((4456585.649 5793370.8858,4456585.6972 5793370.793199999,4456585.684799999 5793370.724799999,4456585.5877 5793370.630699999,4456585.413999999 5793370.560699999,4456585.353699999 5793370.312599999,4456585.2849 5793370.304199999,4456585.1802 5793370.325899999,4456585.020899999 5793370.411,4456585.017199999 5793370.5018,4456585.1347 5793370.6806,4456585.470999999 5793370.9921,4456585.5114 5793371.009899999,4456585.552299999 5793371.001599999,4456585.649 5793370.8858)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (41,41,337,'Hun016',16,'Hun','Stuhlmann','Stein','Stein','NULL',4.26808581588,1.32375054999,1.03882242151,2.70093829594,1, ST_GeomFromText('MULTIPOLYGON(((4456593.980299999 5793368.305299999,4456594.1007 5793368.126599999,4456594.1604 5793367.9877,4456594.2494 5793367.5361,4456594.1895 5793367.2379,4456594.0674 5793366.969399999,4456593.9671 5793366.8637,4456593.8766 5793366.8146,4456593.649699999 5793366.7848,4456593.5842 5793366.7949,4456593.493599999 5793366.847899999,4456593.379399999 5793366.886199999,4456593.239099999 5793366.9988,4456593.1994 5793367.0623,4456593.140499999 5793367.2498,4456593.1017 5793367.4722,4456593.1308 5793367.718699999,4456593.2175 5793367.9033,4456593.310999999 5793367.9974,4456593.472199999 5793368.0985,4456593.5919 5793368.150299999,4456593.6842 5793368.254499999,4456593.756699999 5793368.3199,4456593.843899999 5793368.3662,4456593.9084 5793368.358999999,4456593.980299999 5793368.305299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (42,42,337,'Hun016',16,'Hun','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',1.84846374723,0.243347765219,0.210801727264,0.548084490887,1, ST_GeomFromText('MULTIPOLYGON(((4456583.359199999 5793371.853,4456583.5016 5793371.5798,4456583.540099999 5793371.419399999,4456583.5212 5793371.336799999,4456583.4682 5793371.3121,4456583.2182 5793371.326199999,4456582.9802 5793371.426799999,4456582.9364 5793371.485099999,4456582.926699999 5793371.5579,4456582.955099999 5793371.6456,4456583.014999999 5793371.726299999,4456583.1549 5793371.826999999,4456583.291699999 5793371.8681,4456583.359199999 5793371.853)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (43,43,337,'Hun016',16,'Hun','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',1.90561028521,0.232154325056,0.202223074723,0.52577999428,1, ST_GeomFromText('MULTIPOLYGON(((4456583.8639 5793372.6236,4456583.891099999 5793372.500499999,4456583.8485 5793372.3364,4456583.7662 5793372.169199999,4456583.6518 5793372.0598,4456583.541799999 5793372.0686,4456583.3979 5793372.045399999,4456583.315399999 5793372.0828,4456583.2986 5793372.1315,4456583.311099999 5793372.203199999,4456583.4111 5793372.365499999,4456583.518899999 5793372.504399999,4456583.713299999 5793372.6622,4456583.7925 5793372.686,4456583.8639 5793372.6236)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (44,44,337,'Hun016',16,'Hun','Stuhlmann','Kammerstein','Kammerstein','NULL',4.42983802084,1.38305812045,1.08427574352,2.81911693314,1, ST_GeomFromText('MULTIPOLYGON(((4456585.1116 5793373.1511,4456585.2707 5793373.079099999,4456585.399 5793373.049799999,4456585.501099999 5793373.0039,4456585.5733 5793372.930999999,4456585.6513 5793372.478499999,4456585.676599999 5793372.319399999,4456585.671299999 5793372.0899,4456585.652599999 5793372.0514,4456585.593799999 5793372.0108,4456585.4543 5793371.988099999,4456585.3228 5793372.0186,4456584.7926 5793372.076899999,4456584.550999999 5793372.159299999,4456584.360999999 5793372.251599999,4456584.290699999 5793372.3068,4456584.272199999 5793372.3475,4456584.2779 5793372.4195,4456584.2537 5793372.5314,4456584.2651 5793372.654699999,4456584.250199999 5793372.806099999,4456584.349999999 5793373.0185,4456584.397699999 5793373.106599999,4456584.487399999 5793373.1642,4456584.5975 5793373.185,4456584.8667 5793373.138199999,4456585.1116 5793373.1511)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (45,45,337,'Hun016',16,'Hun','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.33073030177,0.405170964845,0.334823027457,0.870539871389,1, ST_GeomFromText('MULTIPOLYGON(((4456584.852599999 5793374.456399999,4456584.9632 5793374.358799999,4456584.987099999 5793374.2627,4456584.966 5793374.1664,4456584.875099999 5793373.972699999,4456584.691999999 5793373.777,4456584.613699999 5793373.748099999,4456584.443699999 5793373.812599999,4456584.356399999 5793373.868,4456584.2291 5793373.9864,4456584.191599999 5793374.095599999,4456584.227699999 5793374.1863,4456584.3809 5793374.3472,4456584.5526 5793374.474799999,4456584.662999999 5793374.5009,4456584.7717 5793374.494999999,4456584.852599999 5793374.456399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (46,46,337,'Hun016',16,'Hun','Stuhlmann','Stein','Stein','NULL',3.07219186027,0.685586535356,0.549733520697,1.42930715381,1, ST_GeomFromText('MULTIPOLYGON(((4456579.7499 5793376.5612,4456579.8651 5793376.3682,4456579.909599999 5793376.2122,4456579.9039 5793376.1096,4456579.8163 5793375.9309,4456579.557599999 5793375.548399999,4456579.4718 5793375.4779,4456579.383799999 5793375.4743,4456579.294999999 5793375.513599999,4456579.167899999 5793375.6159,4456579.1061 5793375.704399999,4456579.042399999 5793375.923299999,4456579.095099999 5793376.1969,4456579.207 5793376.400399999,4456579.314899999 5793376.4932,4456579.486399999 5793376.576899999,4456579.619199999 5793376.614199999,4456579.667299999 5793376.6104,4456579.7499 5793376.5612)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (47,47,337,'Hun016',16,'Hun','Stuhlmann','Kammerstein','Kammerstein','NULL',1.44081549232,0.153252485148,0.141752704617,0.368557032005,1, ST_GeomFromText('MULTIPOLYGON(((4456588.3611 5793373.677899999,4456588.371299999 5793373.5844,4456588.298999999 5793373.4502,4456588.2499 5793373.403,4456588.1403 5793373.346799999,4456588.0135 5793373.360799999,4456587.9082 5793373.4001,4456587.857499999 5793373.475899999,4456587.882799999 5793373.5932,4456587.972299999 5793373.6958,4456588.1347 5793373.7462,4456588.279 5793373.736899999,4456588.3611 5793373.677899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (48,48,337,'Hun016',16,'Hun','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.3130554946,0.366442875188,0.305141819544,0.793368730816,1, ST_GeomFromText('MULTIPOLYGON(((4456585.263 5793375.5852,4456585.3178 5793375.537499999,4456585.380099999 5793375.440799999,4456585.3541 5793375.2575,4456585.269999999 5793375.046499999,4456585.121199999 5793374.8212,4456585.0606 5793374.794299999,4456584.829599999 5793374.864199999,4456584.704599999 5793374.947799999,4456584.6831 5793375.013199999,4456584.7141 5793375.0907,4456584.788599999 5793375.186499999,4456584.8903 5793375.4252,4456584.944 5793375.509099999,4456585.046 5793375.5831,4456585.1824 5793375.615499999,4456585.263 5793375.5852)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (49,49,337,'Hun016',16,'Hun','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.18944900345,0.348678945002,0.291527543449,0.757971612968,1, ST_GeomFromText('MULTIPOLYGON(((4456587.7559 5793374.930299999,4456587.913599999 5793374.8429,4456587.946299999 5793374.807,4456587.948699999 5793374.763599999,4456587.8265 5793374.5742,4456587.652499999 5793374.409399999,4456587.588999999 5793374.390599999,4456587.4895 5793374.4097,4456587.319 5793374.503299999,4456587.1803 5793374.6447,4456587.1494 5793374.6971,4456587.1375 5793374.761399999,4456587.152599999 5793374.814899999,4456587.293999999 5793374.9756,4456587.425699999 5793375.0391,4456587.5245 5793375.0252,4456587.7559 5793374.930299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (50,50,337,'Hun016',16,'Hun','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',3.38870375704,0.844561980136,0.671572301577,1.7460879841,1, ST_GeomFromText('MULTIPOLYGON(((4456586.9785 5793376.163599999,4456587.173399999 5793375.873299999,4456587.2367 5793375.683199999,4456587.234699999 5793375.516799999,4456587.159099999 5793375.3848,4456587.0882 5793375.3306,4456586.987399999 5793375.310699999,4456586.720399999 5793375.332299999,4456586.4483 5793375.441199999,4456586.083999999 5793375.654999999,4456586.063099999 5793375.7233,4456586.1354 5793376.001099999,4456586.2059 5793376.116699999,4456586.2932 5793376.1936,4456586.4243 5793376.2759,4456586.5433 5793376.296599999,4456586.787299999 5793376.253299999,4456586.9785 5793376.163599999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (51,51,340,'Hun019',19,'Hun','Stuhlmann','Verkeilstein','Verkeilstein/Zwickelmauerwerk','NULL',0.377252022072,0.00955234491161,0.0316209171403,0.0822143845647,1, ST_GeomFromText('MULTIPOLYGON(((4455832.161 5793622.030099999,4455832.189799999 5793622.0052,4455832.179899999 5793621.9604,4455832.141699999 5793621.9492,4455832.070299999 5793621.9846,4455832.051599999 5793622.0296,4455832.068699999 5793622.051699999,4455832.095499999 5793622.055099999,4455832.161 5793622.030099999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (52,52,340,'Hun019',19,'Hun','Stuhlmann','Verkeilstein','Verkeilstein/Zwickelmauerwerk','NULL',0.338163871182,0.00757533509539,0.0301057368171,0.0782749157245,1, ST_GeomFromText('MULTIPOLYGON(((4455833.158099999 5793622.2562,4455833.181499999 5793622.2247,4455833.173799999 5793622.1949,4455833.1398 5793622.180199999,4455833.050699999 5793622.203999999,4455833.0706 5793622.2463,4455833.1074 5793622.264,4455833.158099999 5793622.2562)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (53,53,340,'Hun019',19,'Hun','Stuhlmann','Verkeilstein','Verkeilstein/Zwickelmauerwerk','NULL',0.384009858969,0.0104587950141,0.0323156204988,0.0840206132969,1, ST_GeomFromText('MULTIPOLYGON(((4455832.608 5793622.2519,4455832.639299999 5793622.2221,4455832.633399999 5793622.174799999,4455832.591 5793622.1553,4455832.5212 5793622.1776,4455832.4988 5793622.207299999,4455832.5104 5793622.241399999,4455832.558799999 5793622.2561,4455832.608 5793622.2519)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (54,54,340,'Hun019',19,'Hun','Stuhlmann','Verkeilstein','Verkeilstein/Zwickelmauerwerk','NULL',0.378135896141,0.0103716249924,0.0322488133942,0.0838469148248,1, ST_GeomFromText('MULTIPOLYGON(((4455832.3196 5793622.2182,4455832.3426 5793622.188799999,4455832.3386 5793622.151499999,4455832.3013 5793622.123099999,4455832.2565 5793622.1289,4455832.2219 5793622.1621,4455832.214599999 5793622.215299999,4455832.2521 5793622.231399999,4455832.3196 5793622.2182)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (55,55,340,'Hun019',19,'Hun','Stuhlmann','Verkeilstein','Verkeilstein/Zwickelmauerwerk','NULL',0.51261913945,0.0170773148835,0.0373880541267,0.0972089407295,1, ST_GeomFromText('MULTIPOLYGON(((4455832.9111 5793622.344499999,4455832.941599999 5793622.313899999,4455832.9627 5793622.2352,4455832.807099999 5793622.24,4455832.780399999 5793622.2717,4455832.7794 5793622.3211,4455832.829699999 5793622.353,4455832.9111 5793622.344499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (56,56,340,'Hun019',19,'Hun','Stuhlmann','Verkeilstein','Verkeilstein/Zwickelmauerwerk','NULL',0.386311612959,0.00983591004927,0.0318382414618,0.0827794278006,1, ST_GeomFromText('MULTIPOLYGON(((4455832.036899999 5793622.2346,4455832.0564 5793622.201799999,4455832.039699999 5793622.172499999,4455832.0065 5793622.162399999,4455831.9456 5793622.185799999,4455831.9099 5793622.215199999,4455831.91 5793622.2486,4455831.959699999 5793622.264299999,4455832.036899999 5793622.2346)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (57,57,340,'Hun019',19,'Hun','Stuhlmann','Verkeilstein','Verkeilstein/Zwickelmauerwerk','NULL',0.489070013772,0.0172648350954,0.0375317696171,0.0975826010046,1, ST_GeomFromText('MULTIPOLYGON(((4455833.146399999 5793622.4964,4455833.178 5793622.459699999,4455833.1653 5793622.390699999,4455833.135599999 5793622.3628,4455833.088899999 5793622.3657,4455833.0186 5793622.419299999,4455833.011099999 5793622.47,4455833.0585 5793622.4986,4455833.146399999 5793622.4964)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (58,58,340,'Hun019',19,'Hun','Stuhlmann','Verkeilstein','Verkeilstein/Zwickelmauerwerk','NULL',0.361647127156,0.00912288509939,0.0312917791402,0.0813586257644,1, ST_GeomFromText('MULTIPOLYGON(((4455833.005699999 5793622.7211,4455833.032599999 5793622.688999999,4455833.023799999 5793622.639299999,4455832.936099999 5793622.636399999,4455832.907399999 5793622.6654,4455832.905299999 5793622.6982,4455832.939799999 5793622.7221,4455833.005699999 5793622.7211)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (59,59,340,'Hun019',19,'Hun','Stuhlmann','Stein','Stein','NULL',2.18845333458,0.350998704787,0.293305407349,0.762594059107,1, ST_GeomFromText('MULTIPOLYGON(((4455829.250799999 5793623.821299999,4455829.367999999 5793623.786599999,4455829.5142 5793623.696599999,4455829.624599999 5793623.580199999,4455829.631099999 5793623.549,4455829.612599999 5793623.5054,4455829.5696 5793623.3629,4455829.504599999 5793623.296099999,4455829.432099999 5793623.2772,4455829.205299999 5793623.260299999,4455829.0453 5793623.294199999,4455828.9571 5793623.3373,4455828.8287 5793623.4691,4455828.8015 5793623.536199999,4455828.8486 5793623.675699999,4455828.9165 5793623.7451,4455829.0218 5793623.798,4455829.250799999 5793623.821299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (60,60,340,'Hun019',19,'Hun','Stuhlmann','Stein','Stein','NULL',1.71297933687,0.174293239945,0.157878339094,0.410483681644,1, ST_GeomFromText('MULTIPOLYGON(((4455825.7926 5793624.001599999,4455825.896599999 5793623.8958,4455825.960699999 5793623.7969,4455826.003499999 5793623.702099999,4455826.053299999 5793623.6424,4455826.135599999 5793623.5076,4455826.134399999 5793623.466399999,4455826.099799999 5793623.414799999,4455826.030799999 5793623.3723,4455825.942599999 5793623.3563,4455825.877399999 5793623.3629,4455825.789699999 5793623.4,4455825.716599999 5793623.618799999,4455825.7023 5793623.711699999,4455825.718999999 5793623.9556,4455825.739799999 5793623.996999999,4455825.765499999 5793624.0095,4455825.7926 5793624.001599999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (61,61,340,'Hun019',19,'Hun','Stuhlmann','Stein','Stein','NULL',0.945647823042,0.0680401450873,0.0764459671949,0.198759514707,1, ST_GeomFromText('MULTIPOLYGON(((4455831.288099999 5793624.9879,4455831.407599999 5793624.9249,4455831.445 5793624.8822,4455831.454199999 5793624.8165,4455831.4471 5793624.777699999,4455831.415799999 5793624.742499999,4455831.297799999 5793624.696,4455831.2334 5793624.708699999,4455831.189 5793624.739399999,4455831.1605 5793624.792899999,4455831.148199999 5793624.885399999,4455831.156899999 5793624.9293,4455831.184299999 5793624.9681,4455831.218899999 5793624.986199999,4455831.288099999 5793624.9879)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (62,62,340,'Hun019',19,'Hun','Stuhlmann','Bettstein in situ','Bettstein in situ','NULL',1.79944389529,0.247784414758,0.21420197547,0.556925136222,1, ST_GeomFromText('MULTIPOLYGON(((4455835.4093 5793625.564999999,4455835.5683 5793625.4922,4455835.6775 5793625.404999999,4455835.7006 5793625.366399999,4455835.707499999 5793625.3223,4455835.696999999 5793625.216,4455835.666199999 5793625.138599999,4455835.608799999 5793625.0874,4455835.529199999 5793625.0598,4455835.3584 5793625.0426,4455835.2231 5793625.0986,4455835.1644 5793625.141699999,4455835.1101 5793625.2726,4455835.115399999 5793625.389,4455835.127399999 5793625.4331,4455835.198499999 5793625.535399999,4455835.263899999 5793625.5787,4455835.4093 5793625.564999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (63,63,340,'Hun019',19,'Hun','Stuhlmann','Stein','Stein','NULL',0.833362854665,0.0513722298588,0.0636716769638,0.165546360106,1, ST_GeomFromText('MULTIPOLYGON(((4455826.5557 5793625.147399999,4455826.578999999 5793625.120999999,4455826.628399999 5793624.9681,4455826.615299999 5793624.935499999,4455826.5798 5793624.9064,4455826.4718 5793624.8988,4455826.422 5793624.913799999,4455826.397199999 5793624.9392,4455826.3792 5793625.0745,4455826.414499999 5793625.1389,4455826.507799999 5793625.169199999,4455826.5557 5793625.147399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (64,64,340,'Hun019',19,'Hun','Stuhlmann','Deckstein','Deckstein','NULL',3.19486518183,0.759849089959,0.606648342545,1.57728569062,1, ST_GeomFromText('MULTIPOLYGON(((4455829.668999999 5793624.566299999,4455829.5388 5793624.552799999,4455829.445199999 5793624.5756,4455829.3101 5793624.647399999,4455829.184 5793624.7991,4455829.113499999 5793624.9232,4455829.1045 5793625.0512,4455829.114 5793625.182299999,4455829.0815 5793625.3055,4455829.0811 5793625.3595,4455829.1303 5793625.4678,4455829.226099999 5793625.537,4455829.2762 5793625.5996,4455829.3715 5793625.6609,4455829.500699999 5793625.6904,4455829.5952 5793625.682499999,4455829.715499999 5793625.595599999,4455829.854299999 5793625.437999999,4455829.895899999 5793625.339199999,4455829.8881 5793625.2692,4455829.8854 5793625.234699999,4455829.923999999 5793625.123999999,4455829.950799999 5793624.8911,4455829.923799999 5793624.804999999,4455829.8415 5793624.668099999,4455829.8024 5793624.627299999,4455829.668999999 5793624.566299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (65,65,340,'Hun019',19,'Hun','Stuhlmann','Stein','Stein','NULL',2.51678660312,0.448856254831,0.368303433703,0.957588927627,1, ST_GeomFromText('MULTIPOLYGON(((4455825.474799999 5793625.5021,4455825.6332 5793625.458699999,4455825.956699999 5793625.291999999,4455826.004499999 5793625.252599999,4455826.0124 5793625.203999999,4455826.0102 5793625.061699999,4455825.962199999 5793624.8802,4455825.919499999 5793624.807399999,4455825.884399999 5793624.7739,4455825.8063 5793624.752499999,4455825.7631 5793624.7551,4455825.5646 5793624.8054,4455825.457999999 5793624.868699999,4455825.393899999 5793624.8923,4455825.273199999 5793625.107599999,4455825.2087 5793625.175499999,4455825.160799999 5793625.2554,4455825.1462 5793625.3209,4455825.1841 5793625.3769,4455825.281 5793625.4526,4455825.381 5793625.492,4455825.474799999 5793625.5021)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (66,66,340,'Hun019',19,'Hun','Stuhlmann','Deckstein','Deckstein','NULL',3.86096571199,0.98221561468,0.777070047091,2.02038212244,1, ST_GeomFromText('MULTIPOLYGON(((4455830.1639 5793626.118599999,4455830.2548 5793626.098699999,4455830.365 5793626.0919,4455830.9807 5793625.877199999,4455831.149299999 5793625.792199999,4455831.311999999 5793625.6881,4455831.3579 5793625.5807,4455831.3558 5793625.5247,4455831.252899999 5793625.368,4455831.211 5793625.2817,4455831.155399999 5793625.2278,4455831.0672 5793625.1804,4455830.9138 5793625.129699999,4455830.698499999 5793625.089299999,4455830.6177 5793625.0932,4455830.530299999 5793625.1302,4455830.2706 5793625.2772,4455830.0751 5793625.459499999,4455830.0328 5793625.5821,4455830.0345 5793625.6794,4455830.0152 5793625.7982,4455829.9368 5793625.9626,4455829.9243 5793626.030099999,4455829.979199999 5793626.088999999,4455830.0811 5793626.1184,4455830.1639 5793626.118599999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (67,67,340,'Hun019',19,'Hun','Stuhlmann','Stein','Stein','NULL',2.21240049266,0.313597650015,0.264641238971,0.688067221326,1, ST_GeomFromText('MULTIPOLYGON(((4455832.0442 5793626.772299999,4455832.095499999 5793626.751399999,4455832.286399999 5793626.5632,4455832.376799999 5793626.445399999,4455832.442699999 5793626.333,4455832.4775 5793626.2006,4455832.4856 5793626.1138,4455832.4675 5793626.057299999,4455832.438799999 5793626.0383,4455832.375699999 5793626.0403,4455832.251699999 5793626.081599999,4455831.9598 5793626.259899999,4455831.8721 5793626.342199999,4455831.7947 5793626.4581,4455831.772099999 5793626.583,4455831.7997 5793626.6641,4455831.922399999 5793626.7705,4455832.0442 5793626.772299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (68,68,340,'Hun019',19,'Hun','Stuhlmann','Bettstein in situ','Bettstein in situ','NULL',2.569248025,0.471634220015,0.38576046622,1.00297721217,1, ST_GeomFromText('MULTIPOLYGON(((4455837.3436 5793627.659399999,4455837.4944 5793627.598999999,4455837.616999999 5793627.4919,4455837.6544 5793627.445599999,4455837.7324 5793627.3234,4455837.7165 5793627.0806,4455837.7224 5793626.9755,4455837.685499999 5793626.8275,4455837.6363 5793626.752599999,4455837.5848 5793626.7299,4455837.4648 5793626.715199999,4455837.3369 5793626.743499999,4455837.2849 5793626.783399999,4455837.172899999 5793626.936799999,4455837.1419 5793627.072,4455837.1167 5793627.131999999,4455837.1046 5793627.4395,4455837.1408 5793627.574799999,4455837.166899999 5793627.6085,4455837.2218 5793627.647199999,4455837.287399999 5793627.6629,4455837.3436 5793627.659399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (69,69,340,'Hun019',19,'Hun','Stuhlmann','Bettstein in situ','Bettstein in situ','NULL',3.06241493184,0.623891964791,0.502450801816,1.30637208472,1, ST_GeomFromText('MULTIPOLYGON(((4455822.4351 5793626.7441,4455822.576399999 5793626.6239,4455822.7273 5793626.3594,4455822.792799999 5793626.274,4455822.8935 5793626.0449,4455822.9254 5793625.9133,4455822.919999999 5793625.844799999,4455822.843999999 5793625.7225,4455822.724499999 5793625.628599999,4455822.6069 5793625.5664,4455822.5129 5793625.5657,4455822.359199999 5793625.660499999,4455822.319199999 5793625.7061,4455822.2931 5793625.7607,4455822.1686 5793626.1994,4455822.1611 5793626.530099999,4455822.1889 5793626.633899999,4455822.228099999 5793626.6859,4455822.3184 5793626.743699999,4455822.3709 5793626.755499999,4455822.4351 5793626.7441)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (70,70,340,'Hun019',19,'Hun','Stuhlmann','Stein','Stein','NULL',1.69834360868,0.205995569559,0.18217500451,0.473655011726,1, ST_GeomFromText('MULTIPOLYGON(((4455826.811599999 5793627.459499999,4455826.873999999 5793627.437799999,4455827.0749 5793627.2956,4455827.117499999 5793627.244799999,4455827.126099999 5793627.2149,4455827.086099999 5793627.124199999,4455826.999999999 5793627.0664,4455826.7827 5793627.0258,4455826.6539 5793627.0379,4455826.5946 5793627.068199999,4455826.5096 5793627.159099999,4455826.473699999 5793627.2532,4455826.478799999 5793627.2988,4455826.498999999 5793627.3342,4455826.5898 5793627.385299999,4455826.664499999 5793627.453099999,4455826.704599999 5793627.471899999,4455826.811599999 5793627.459499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (71,71,340,'Hun019',19,'Hun','Stuhlmann','Bettstein in situ','Bettstein in situ','NULL',1.87095945063,0.265445434918,0.227737381322,0.592117191436,1, ST_GeomFromText('MULTIPOLYGON(((4455837.0822 5793628.8121,4455837.2377 5793628.677699999,4455837.260099999 5793628.603399999,4455837.269999999 5793628.398399999,4455837.2368 5793628.2703,4455837.165599999 5793628.188699999,4455837.0821 5793628.165599999,4455836.9943 5793628.173299999,4455836.858 5793628.2188,4455836.8092 5793628.252,4455836.773599999 5793628.294399999,4455836.744599999 5793628.398499999,4455836.7646 5793628.563799999,4455836.848199999 5793628.6972,4455836.942099999 5793628.7883,4455837.021399999 5793628.819099999,4455837.0822 5793628.8121)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (72,72,340,'Hun019',19,'Hun','Stuhlmann','Bettstein in situ','Bettstein in situ','NULL',1.77512086394,0.225578550296,0.197183400947,0.512676842461,1, ST_GeomFromText('MULTIPOLYGON(((4455835.502399999 5793630.7916,4455835.6665 5793630.7374,4455835.783499999 5793630.6545,4455835.8382 5793630.538399999,4455835.8421 5793630.430999999,4455835.7915 5793630.328099999,4455835.719299999 5793630.286,4455835.610899999 5793630.2719,4455835.5383 5793630.299699999,4455835.481499999 5793630.367699999,4455835.431599999 5793630.4057,4455835.303 5793630.448999999,4455835.272099999 5793630.469499999,4455835.2438 5793630.554999999,4455835.241299999 5793630.659299999,4455835.2823 5793630.7276,4455835.342 5793630.770999999,4455835.4312 5793630.800799999,4455835.502399999 5793630.7916)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (73,73,340,'Hun019',19,'Hun','Stuhlmann','Bettstein in situ','Bettstein in situ','NULL',3.06979289767,0.712665325077,0.570486705139,1.48326543336,1, ST_GeomFromText('MULTIPOLYGON(((4455828.9049 5793630.233799999,4455829.111299999 5793630.1468,4455829.179999999 5793630.105699999,4455829.2466 5793630.056199999,4455829.287499999 5793630.0094,4455829.322999999 5793629.9273,4455829.3525 5793629.8144,4455829.328499999 5793629.703199999,4455829.296799999 5793629.638699999,4455829.2131 5793629.559,4455829.024199999 5793629.4593,4455828.7788 5793629.428799999,4455828.5608 5793629.449999999,4455828.4615 5793629.492,4455828.3853 5793629.551799999,4455828.311099999 5793629.7247,4455828.293499999 5793629.8859,4455828.3084 5793630.093,4455828.346499999 5793630.1608,4455828.387199999 5793630.2047,4455828.477699999 5793630.2388,4455828.724299999 5793630.279899999,4455828.9049 5793630.233799999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (74,74,344,'Süp002',2,'Süp','Stuhlmann','Stein','Stein','NULL',3.16553785312,0.584649285256,0.47237521222,1.22817555177,1, ST_GeomFromText('MULTIPOLYGON(((4456044.0892 5794859.336799999,4456043.984799999 5794859.1972,4456043.710099999 5794859.073699999,4456043.6073 5794859.052799999,4456043.5257 5794859.0723,4456043.198699999 5794859.289999999,4456043.156499999 5794859.3376,4456043.1221 5794859.4122,4456043.104899999 5794859.515599999,4456043.137699999 5794859.7083,4456043.0707 5794859.856799999,4456043.0579 5794859.928799999,4456043.1003 5794860.037699999,4456043.159699999 5794860.0853,4456043.2043 5794860.091199999,4456043.2854 5794860.072,4456043.365 5794860.032099999,4456043.587899999 5794859.7772,4456043.8524 5794859.507899999,4456044.088999999 5794859.3549,4456044.0892 5794859.336799999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (75,75,344,'Süp002',2,'Süp','Stuhlmann','Stein','Stein','NULL',2.62015091004,0.510560960191,0.415593919891,1.08054419172,1, ST_GeomFromText('MULTIPOLYGON(((4456044.533599999 5794858.7352,4456044.515399999 5794858.603599999,4456044.4599 5794858.4822,4456044.394999999 5794858.4119,4456044.3311 5794858.370999999,4456044.2038 5794858.3429,4456044.053999999 5794858.367,4456043.960799999 5794858.4273,4456043.904099999 5794858.527599999,4456043.8777 5794858.607799999,4456043.835599999 5794858.908099999,4456043.8711 5794859.0076,4456043.984799999 5794859.1972,4456044.3682 5794859.2474,4456044.428799999 5794859.2244,4456044.4703 5794859.1622,4456044.521999999 5794858.9414,4456044.533599999 5794858.7352)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (76,76,344,'Süp002',2,'Süp','Stuhlmann','Stein','Stein','NULL',0.582691602848,0.0243751300487,0.0429810996693,0.11175085914,1, ST_GeomFromText('MULTIPOLYGON(((4456044.8914 5794859.3824,4456044.8009 5794859.382699999,4456044.7416 5794859.437,4456044.7229 5794859.502499999,4456044.7653 5794859.5357,4456044.8528 5794859.5349,4456044.9153 5794859.4896,4456044.9336 5794859.434399999,4456044.8914 5794859.3824)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (77,77,344,'Süp002',2,'Süp','Stuhlmann','Stein','Stein','NULL',3.1292786369,0.700606399563,0.561244744625,1.45923633603,1, ST_GeomFromText('MULTIPOLYGON(((4456045.460199999 5794860.1851,4456045.305399999 5794859.9668,4456045.1803 5794859.876,4456045.0696 5794859.8701,4456044.6123 5794860.037699999,4456044.483 5794860.1237,4456044.419599999 5794860.2093,4456044.402499999 5794860.327999999,4456044.4495 5794860.454199999,4456044.6266 5794860.682499999,4456044.8068 5794860.8045,4456044.925699999 5794860.8662,4456044.991 5794860.859699999,4456045.159699999 5794860.6269,4456045.3887 5794860.465199999,4456045.4753 5794860.366499999,4456045.491299999 5794860.2934,4456045.460199999 5794860.1851)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (78,78,344,'Süp002',2,'Süp','Stuhlmann','Stein','Stein','NULL',1.77119763855,0.23009785991,0.200646999835,0.521682199572,1, ST_GeomFromText('MULTIPOLYGON(((4456046.4192 5794857.4086,4456046.343999999 5794857.3211,4456046.203599999 5794857.2301,4456046.131 5794857.2309,4456045.9057 5794857.297199999,4456045.800699999 5794857.360099999,4456045.765599999 5794857.4394,4456045.7916 5794857.5576,4456045.8536 5794857.6412,4456045.916299999 5794857.709699999,4456045.9528 5794857.724099999,4456046.086799999 5794857.712099999,4456046.2016 5794857.676,4456046.371799999 5794857.535099999,4456046.4183 5794857.453999999,4456046.4192 5794857.4086)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (79,79,344,'Süp002',2,'Süp','Stuhlmann','Stein','Stein','NULL',1.70137762277,0.179215299994,0.161650605915,0.42029157538,1, ST_GeomFromText('MULTIPOLYGON(((4456047.7384 5794857.862299999,4456047.699 5794857.7969,4456047.6458 5794857.7661,4456047.589399999 5794857.7649,4456047.346499999 5794857.899599999,4456047.2285 5794857.9956,4456047.1271 5794858.1095,4456047.1074 5794858.162799999,4456047.137699999 5794858.219299999,4456047.226999999 5794858.253,4456047.3064 5794858.253599999,4456047.406999999 5794858.2301,4456047.6024 5794858.1149,4456047.736899999 5794857.942399999,4456047.7384 5794857.862299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (80,80,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',2.29501452174,0.345951670123,0.289437359982,0.752537135954,1, ST_GeomFromText('MULTIPOLYGON(((4455282.5854 5793326.2222,4455282.6161 5793326.2221,4455282.649699999 5793326.216,4455282.674399999 5793326.2069,4455282.693099999 5793326.1949,4455282.7158 5793326.177899999,4455282.7296 5793326.162,4455282.746299999 5793326.145999999,4455282.7581 5793326.125099999,4455282.763 5793326.1102,4455282.769799999 5793326.0863,4455282.7757 5793326.0654,4455282.781499999 5793326.039599999,4455282.786399999 5793326.018699999,4455282.791299999 5793325.996799999,4455282.796199999 5793325.9779,4455282.798999999 5793325.957,4455282.802899999 5793325.932199999,4455282.8048 5793325.907299999,4455282.806699999 5793325.8815,4455282.8086 5793325.856699999,4455282.810399999 5793325.8288,4455282.8123 5793325.804999999,4455282.812199999 5793325.7772,4455282.8112 5793325.750399999,4455282.814 5793325.7235,4455282.8139 5793325.697699999,4455282.8129 5793325.6709,4455282.813599999 5793325.648499999,4455282.7675 5793325.5667,4455282.752799999 5793325.535599999,4455282.740799999 5793325.523499999,4455282.735299999 5793325.5205,4455282.724899999 5793325.5106,4455282.719299999 5793325.5086,4455282.7071 5793325.4973,4455282.703399999 5793325.495699999,4455282.690499999 5793325.4833,4455282.687499999 5793325.482799999,4455282.677199999 5793325.472899999,4455282.6725 5793325.471,4455282.6617 5793325.4581,4455282.6571 5793325.455199999,4455282.644999999 5793325.444,4455282.639299999 5793325.441999999,4455282.6288 5793325.4331,4455282.6193 5793325.4294,4455282.609 5793325.4195,4455282.6025 5793325.4163,4455282.5913 5793325.4053,4455282.5886 5793325.403799999,4455282.579699999 5793325.397199999,4455282.514999999 5793325.380599999,4455282.487999999 5793325.3738,4455282.4658 5793325.367799999,4455282.4457 5793325.362199999,4455282.4209 5793325.3537,4455282.353799999 5793325.356,4455282.325899999 5793325.362199999,4455282.3168 5793325.388599999,4455282.315499999 5793325.412499999,4455282.317999999 5793325.437999999,4455282.317099999 5793325.466,4455282.316899999 5793325.49,4455282.3179 5793325.512299999,4455282.317999999 5793325.5404,4455282.319699999 5793325.564899999,4455282.320399999 5793325.589099999,4455282.3211 5793325.613299999,4455282.321499999 5793325.675,4455282.3256 5793325.7058,4455282.329599999 5793325.7345,4455282.3337 5793325.764299999,4455282.336699999 5793325.7901,4455282.343799999 5793325.823899999,4455282.3459 5793325.8527,4455282.348899999 5793325.880499999,4455282.353 5793325.911299999,4455282.3561 5793325.940099999,4455282.362099999 5793325.9768,4455282.3662 5793326.005599999,4455282.3705 5793326.0282,4455282.3798 5793326.0678,4455282.396599999 5793326.1102,4455282.441599999 5793326.169999999,4455282.512199999 5793326.212099999,4455282.5568 5793326.2223,4455282.5854 5793326.2222)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (81,81,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',0.0927387464573,0.000433589981293,0.0246323033617,0.0640439887403,1, ST_GeomFromText('MULTIPOLYGON(((4455283.4999 5793326.490499999,4455283.481999999 5793326.4743,4455283.4653 5793326.4757,4455283.489099999 5793326.502399999,4455283.4999 5793326.490499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (82,82,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',0.291494483564,0.00206682503685,0.0258840147082,0.0672984382414,1, ST_GeomFromText('MULTIPOLYGON(((4455283.5718 5793326.5511,4455283.5157 5793326.501499999,4455283.4999 5793326.490499999,4455283.489099999 5793326.502399999,4455283.552899999 5793326.5591,4455283.597299999 5793326.5866,4455283.5718 5793326.5511)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (83,83,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',2.82623390441,0.584538600053,0.472290383081,1.22795499601,1, ST_GeomFromText('MULTIPOLYGON(((4455283.678299999 5793326.596999999,4455283.703999999 5793326.5919,4455283.731599999 5793326.586799999,4455283.756299999 5793326.5817,4455283.781 5793326.5797,4455283.8107 5793326.5775,4455283.837399999 5793326.573499999,4455283.87 5793326.570299999,4455283.892699999 5793326.568199999,4455283.9164 5793326.5632,4455283.9411 5793326.554099999,4455283.9609 5793326.5471,4455283.9846 5793326.538,4455284.001299999 5793326.530999999,4455284.022099999 5793326.523,4455284.040799999 5793326.514,4455284.065499999 5793326.499999999,4455284.0822 5793326.484999999,4455284.090099999 5793326.48,4455284.105499999 5793326.468499999,4455284.110799999 5793326.454099999,4455284.114699999 5793326.4252,4455284.1156 5793326.400399999,4455284.1155 5793326.3716,4455284.116399999 5793326.3497,4455284.114299999 5793326.3179,4455284.1112 5793326.2891,4455284.1062 5793326.2584,4455284.102099999 5793326.230599999,4455284.094999999 5793326.1939,4455284.0821 5793326.158099999,4455284.064299999 5793326.118599999,4455284.0376 5793326.0698,4455283.9965 5793326.006599999,4455283.934899999 5793325.923299999,4455283.9182 5793325.895099999,4455283.871 5793325.8473,4455283.845599999 5793325.831499999,4455283.8013 5793325.815799999,4455283.769899999 5793325.786399999,4455283.7286 5793325.7661,4455283.6758 5793325.751499999,4455283.633299999 5793325.741,4455283.585799999 5793325.723999999,4455283.530399999 5793325.7159,4455283.504099999 5793325.7136,4455283.474399999 5793325.7157,4455283.449699999 5793325.719799999,4455283.4241 5793325.7278,4455283.4013 5793325.734899999,4455283.3836 5793325.7419,4455283.3638 5793325.75,4455283.3421 5793325.758999999,4455283.322399999 5793325.768999999,4455283.301599999 5793325.7771,4455283.282899999 5793325.7861,4455283.256199999 5793325.8001,4455283.243499999 5793325.82,4455283.2366 5793325.8429,4455283.234699999 5793325.8727,4455283.234799999 5793325.8965,4455283.2339 5793325.923399999,4455283.235 5793325.9462,4455283.2351 5793325.972999999,4455283.235199999 5793325.9999,4455283.2373 5793326.0326,4455283.2384 5793326.058499999,4455283.241399999 5793326.0873,4455283.2445 5793326.119999999,4455283.248599999 5793326.1508,4455283.2576 5793326.183499999,4455283.2614 5793326.209699999,4455283.283499999 5793326.2606,4455283.324799999 5793326.323799999,4455283.367899999 5793326.3835,4455283.4653 5793326.4757,4455283.481999999 5793326.4743,4455283.4999 5793326.490499999,4455283.5157 5793326.501499999,4455283.5718 5793326.5511,4455283.597299999 5793326.5866,4455283.648599999 5793326.599099999,4455283.678299999 5793326.596999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (84,84,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',0.193814280908,0.00120791496845,0.0252257460318,0.0655869396827,1, ST_GeomFromText('MULTIPOLYGON(((4455276.6189 5793326.6359,4455276.572499999 5793326.6179,4455276.5932 5793326.6436,4455276.6222 5793326.666999999,4455276.647699999 5793326.673599999,4455276.6189 5793326.6359)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (85,85,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',3.70207589761,0.97109858498,0.768549955528,1.99822988437,1, ST_GeomFromText('MULTIPOLYGON(((4455287.516599999 5793326.6917,4455287.548299999 5793326.688599999,4455287.577899999 5793326.684499999,4455287.602599999 5793326.6794,4455287.631299999 5793326.672399999,4455287.656 5793326.6643,4455287.672699999 5793326.657299999,4455287.696399999 5793326.6512,4455287.721099999 5793326.646099999,4455287.7478 5793326.642999999,4455287.776499999 5793326.6409,4455287.806099999 5793326.639799999,4455287.832799999 5793326.6367,4455287.8645 5793326.6356,4455287.8951 5793326.6345,4455287.927699999 5793326.6313,4455287.9603 5793326.626199999,4455287.983 5793326.6202,4455288.0097 5793326.614099999,4455288.0403 5793326.607,4455288.067999999 5793326.599899999,4455288.092699999 5793326.5939,4455288.1184 5793326.583799999,4455288.137099999 5793326.576799999,4455288.1549 5793326.5698,4455288.1796 5793326.5567,4455288.191399999 5793326.548699999,4455288.211099999 5793326.536699999,4455288.225899999 5793326.5208,4455288.2426 5793326.5028,4455288.2564 5793326.485899999,4455288.2741 5793326.462999999,4455288.286899999 5793326.446,4455288.2997 5793326.4261,4455288.311499999 5793326.410099999,4455288.3223 5793326.395199999,4455288.3371 5793326.3782,4455288.349899999 5793326.363299999,4455288.363699999 5793326.3493,4455288.3775 5793326.3363,4455288.3913 5793326.3264,4455288.4061 5793326.3164,4455288.423799999 5793326.298399999,4455288.436599999 5793326.286399999,4455288.451399999 5793326.273399999,4455288.4764 5793326.2507,4455288.454499999 5793326.2089,4455288.422 5793326.1564,4455288.377999999 5793326.0927,4455288.342299999 5793326.0424,4455288.294599999 5793326.001599999,4455288.2735 5793325.973099999,4455288.2109 5793325.9154,4455288.1524 5793325.8803,4455288.0537 5793325.8277,4455287.999999999 5793325.810499999,4455287.957499999 5793325.805199999,4455287.925699999 5793325.7979,4455287.886199999 5793325.7901,4455287.829499999 5793325.7825,4455287.803999999 5793325.774599999,4455287.766499999 5793325.7707,4455287.706799999 5793325.7586,4455287.6714 5793325.753,4455287.642799999 5793325.753399999,4455287.609199999 5793325.752499999,4455287.572599999 5793325.754699999,4455287.542 5793325.754799999,4455287.509399999 5793325.755999999,4455287.4747 5793325.7541,4455287.449 5793325.7572,4455287.412499999 5793325.7594,4455287.383799999 5793325.764399999,4455287.3552 5793325.7705,4455287.323599999 5793325.775599999,4455287.3019 5793325.7926,4455287.289099999 5793325.809599999,4455287.2822 5793325.822499999,4455287.2684 5793325.843399999,4455287.260599999 5793325.8594,4455287.251699999 5793325.875299999,4455287.242899999 5793325.895199999,4455287.233099999 5793325.9151,4455287.2252 5793325.934,4455287.2174 5793325.951899999,4455287.208599999 5793325.974799999,4455287.2027 5793325.992699999,4455287.194899999 5793326.017599999,4455287.189 5793326.037499999,4455287.1812 5793326.058399999,4455287.174399999 5793326.079299999,4455287.168499999 5793326.1041,4455287.163599999 5793326.121999999,4455287.156799999 5793326.144899999,4455287.149899999 5793326.164799999,4455287.142099999 5793326.187699999,4455287.1363 5793326.206599999,4455287.1304 5793326.231399999,4455287.124599999 5793326.253299999,4455287.120699999 5793326.271199999,4455287.116799999 5793326.295099999,4455287.1129 5793326.3209,4455287.1101 5793326.344799999,4455287.109199999 5793326.3706,4455287.1083 5793326.401399999,4455287.1084 5793326.422299999,4455287.110399999 5793326.454099999,4455287.1155 5793326.4868,4455287.1216 5793326.513599999,4455287.139 5793326.538899999,4455287.1705 5793326.5765,4455287.213399999 5793326.602399999,4455287.257399999 5793326.634299999,4455287.3228 5793326.6576,4455287.371299999 5793326.6721,4455287.3868 5793326.6793,4455287.4203 5793326.6794,4455287.4555 5793326.6873,4455287.492999999 5793326.6938,4455287.516599999 5793326.6917)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (86,86,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',2.17988348493,0.373163079923,0.310292184453,0.806759679578,1, ST_GeomFromText('MULTIPOLYGON(((4455285.8294 5793326.806299999,4455285.8541 5793326.8002,4455285.8808 5793326.793099999,4455285.905399999 5793326.784099999,4455285.9281 5793326.7751,4455285.951799999 5793326.765,4455285.9696 5793326.756999999,4455285.989299999 5793326.745999999,4455286.0071 5793326.733999999,4455286.0219 5793326.722999999,4455286.039599999 5793326.71,4455286.053399999 5793326.697,4455286.0672 5793326.6831,4455286.082999999 5793326.667099999,4455286.092799999 5793326.6512,4455286.1056 5793326.633199999,4455286.117399999 5793326.613299999,4455286.127199999 5793326.595399999,4455286.135099999 5793326.5775,4455286.1419 5793326.558599999,4455286.148799999 5793326.537699999,4455286.1556 5793326.5118,4455286.157499999 5793326.486999999,4455286.1593 5793326.456199999,4455286.1573 5793326.424399999,4455286.1561 5793326.3986,4455286.1392 5793326.3519,4455286.127199999 5793326.320199999,4455286.1171 5793326.286599999,4455286.099299999 5793326.249299999,4455286.0745 5793326.2181,4455286.037399999 5793326.1742,4455286.0064 5793326.1587,4455285.976999999 5793326.139799999,4455285.934899999 5793326.1246,4455285.9011 5793326.1195,4455285.872399999 5793326.116699999,4455285.8398 5793326.119799999,4455285.8092 5793326.1239,4455285.7845 5793326.129,4455285.7598 5793326.138,4455285.737099999 5793326.148,4455285.7203 5793326.157099999,4455285.6966 5793326.169099999,4455285.6808 5793326.1771,4455285.6611 5793326.1871,4455285.6413 5793326.1981,4455285.624599999 5793326.2091,4455285.608799999 5793326.2211,4455285.5891 5793326.235099999,4455285.5743 5793326.248099999,4455285.5595 5793326.261099999,4455285.5447 5793326.273,4455285.529 5793326.286,4455285.517099999 5793326.298,4455285.5014 5793326.313999999,4455285.487599999 5793326.3299,4455285.474799999 5793326.3449,4455285.463 5793326.369799999,4455285.4532 5793326.3946,4455285.450299999 5793326.413499999,4455285.4484 5793326.4404,4455285.447499999 5793326.466199999,4455285.449599999 5793326.496999999,4455285.453099999 5793326.522099999,4455285.4658 5793326.5602,4455285.4916 5793326.6168,4455285.5163 5793326.6567,4455285.563199999 5793326.71,4455285.6047 5793326.743599999,4455285.659099999 5793326.7697,4455285.683 5793326.785199999,4455285.7235 5793326.796199999,4455285.7713 5793326.804999999,4455285.808899999 5793326.8078,4455285.8294 5793326.806299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (87,87,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',0.0866450615264,0.000371205017177,0.0245844915252,0.0639196779654,1, ST_GeomFromText('MULTIPOLYGON(((4455281.2933 5793326.8452,4455281.3063 5793326.8317,4455281.2954 5793326.8288,4455281.286199999 5793326.833599999,4455281.273699999 5793326.834799999,4455281.272699999 5793326.847699999,4455281.2933 5793326.8452)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (88,88,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',2.66184148665,0.464873000084,0.380578667264,0.989504534888,1, ST_GeomFromText('MULTIPOLYGON(((4455281.2076 5793326.871899999,4455281.234199999 5793326.8638,4455281.256 5793326.855799999,4455281.272699999 5793326.847699999,4455281.273699999 5793326.834799999,4455281.286199999 5793326.833599999,4455281.2954 5793326.8288,4455281.3063 5793326.8317,4455281.317099999 5793326.823699999,4455281.338899999 5793326.814699999,4455281.356599999 5793326.8037,4455281.378299999 5793326.7936,4455281.398099999 5793326.7846,4455281.4148 5793326.7736,4455281.431599999 5793326.762599999,4455281.4504 5793326.7506,4455281.466099999 5793326.741599999,4455281.485899999 5793326.730599999,4455281.5036 5793326.718599999,4455281.521399999 5793326.709599999,4455281.540199999 5793326.7016,4455281.578099999 5793326.6849,4455281.5942 5793326.6782,4455281.603299999 5793326.6685,4455281.6161 5793326.661499999,4455281.6359 5793326.651499999,4455281.653599999 5793326.640499999,4455281.672399999 5793326.629499999,4455281.692099999 5793326.6194,4455281.712799999 5793326.606399999,4455281.7296 5793326.595399999,4455281.746399999 5793326.5854,4455281.762099999 5793326.570499999,4455281.7845 5793326.5577,4455281.7832 5793326.528699999,4455281.7773 5793326.4941,4455281.7581 5793326.460599999,4455281.7456 5793326.415999999,4455281.715599999 5793326.355299999,4455281.685899999 5793326.303899999,4455281.641999999 5793326.2408,4455281.6035 5793326.2149,4455281.563 5793326.201199999,4455281.5241 5793326.202099999,4455281.502799999 5793326.203999999,4455281.4731 5793326.2061,4455281.4445 5793326.2072,4455281.415799999 5793326.2113,4455281.392099999 5793326.2124,4455281.3644 5793326.2145,4455281.335699999 5793326.2167,4455281.3051 5793326.2178,4455281.2774 5793326.220899999,4455281.246799999 5793326.221,4455281.220099999 5793326.223099999,4455281.1875 5793326.225199999,4455281.1588 5793326.227399999,4455281.130099999 5793326.228499999,4455281.1035 5793326.231599999,4455281.075799999 5793326.2357,4455281.0481 5793326.2398,4455281.020499999 5793326.243799999,4455280.9967 5793326.245899999,4455280.966099999 5793326.25,4455280.9384 5793326.2521,4455280.9127 5793326.2562,4455280.881099999 5793326.259299999,4455280.8574 5793326.263399999,4455280.829699999 5793326.2705,4455280.804999999 5793326.276599999,4455280.7893 5793326.2945,4455280.7832 5793326.3166,4455280.7903 5793326.3504,4455280.803399999 5793326.3881,4455280.8234 5793326.4404,4455280.8354 5793326.474099999,4455280.846699999 5793326.505,4455280.8731 5793326.5546,4455280.910099999 5793326.6169,4455280.946399999 5793326.6754,4455280.983599999 5793326.728,4455281.0628 5793326.8078,4455281.1391 5793326.864499999,4455281.1769 5793326.877,4455281.2076 5793326.871899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (89,89,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',0.0848399377477,0.000247184978085,0.0244894425672,0.0636725506747,1, ST_GeomFromText('MULTIPOLYGON(((4455276.688299999 5793326.8625,4455276.677199999 5793326.8736,4455276.6754 5793326.8768,4455276.6763 5793326.880799999,4455276.685499999 5793326.9013,4455276.688299999 5793326.8625)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (90,90,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',0.122805434108,0.000459049980149,0.0246518159048,0.0640947213524,1, ST_GeomFromText('MULTIPOLYGON(((4455277.166899999 5793326.990199999,4455277.139 5793326.979699999,4455277.156 5793327.001399999,4455277.1873 5793327.014299999,4455277.166899999 5793326.990199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (91,91,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',2.32912811876,0.353946740123,0.29556478163,0.768468432239,1, ST_GeomFromText('MULTIPOLYGON(((4455280.097799999 5793327.018699999,4455280.119599999 5793327.0127,4455280.139299999 5793327.004599999,4455280.1719 5793326.9846,4455280.1906 5793326.971599999,4455280.211299999 5793326.9527,4455280.220099999 5793326.9417,4455280.236899999 5793326.9227,4455280.245699999 5793326.9098,4455280.2585 5793326.891899999,4455280.269299999 5793326.8779,4455280.283099999 5793326.859999999,4455280.292999999 5793326.843,4455280.306699999 5793326.826099999,4455280.3337 5793326.7905,4455280.351999999 5793326.761299999,4455280.362499999 5793326.753,4455280.365799999 5793326.741399999,4455280.3726 5793326.7245,4455280.382399999 5793326.705499999,4455280.3912 5793326.6827,4455280.392699999 5793326.668199999,4455280.3843 5793326.6553,4455280.3387 5793326.640399999,4455280.269299999 5793326.592399999,4455280.241799999 5793326.5798,4455280.150399999 5793326.509899999,4455280.048799999 5793326.4023,4455280.030399999 5793326.394099999,4455279.9976 5793326.3913,4455279.972 5793326.3944,4455279.9334 5793326.3965,4455279.922899999 5793326.394999999,4455279.870199999 5793326.396099999,4455279.841 5793326.395999999,4455279.789699999 5793326.399199999,4455279.7593 5793326.404699999,4455279.7328 5793326.4034,4455279.7061 5793326.4055,4455279.679399999 5793326.4056,4455279.644799999 5793326.4107,4455279.6172 5793326.416799999,4455279.5974 5793326.425799999,4455279.573699999 5793326.438799999,4455279.559899999 5793326.449799999,4455279.5442 5793326.462799999,4455279.5284 5793326.473799999,4455279.510599999 5793326.491699999,4455279.4999 5793326.516599999,4455279.5003 5793326.5413,4455279.522699999 5793326.581499999,4455279.592799999 5793326.650399999,4455279.673899999 5793326.745999999,4455279.737599999 5793326.8285,4455279.819899999 5793326.9043,4455279.8991 5793326.9615,4455279.979299999 5793326.9985,4455280.0031 5793327.0098,4455280.0387 5793327.015599999,4455280.078999999 5793327.0229,4455280.097799999 5793327.018699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (92,92,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',1.61528137538,0.166795750049,0.152132262837,0.395543883377,1, ST_GeomFromText('MULTIPOLYGON(((4455278.3057 5793327.067299999,4455278.3343 5793327.058199999,4455278.356999999 5793327.053799999,4455278.383999999 5793327.0491,4455278.411 5793327.045199999,4455278.437099999 5793327.035499999,4455278.458399999 5793327.0315,4455278.479 5793327.021199999,4455278.4889 5793327.021199999,4455278.501 5793327.0159,4455278.5268 5793327.010099999,4455278.5471 5793327.002299999,4455278.5684 5793326.996899999,4455278.5926 5793326.9874,4455278.6116 5793326.980399999,4455278.6242 5793326.9776,4455278.6375 5793326.970399999,4455278.649199999 5793326.9634,4455278.657399999 5793326.953199999,4455278.649699999 5793326.9185,4455278.6485 5793326.903,4455278.6434 5793326.8909,4455278.639299999 5793326.865499999,4455278.6314 5793326.831399999,4455278.6282 5793326.813799999,4455278.619599999 5793326.793199999,4455278.611499999 5793326.7631,4455278.598699999 5793326.726399999,4455278.5936 5793326.698599999,4455278.588299999 5793326.664799999,4455278.5783 5793326.649499999,4455278.561499999 5793326.6442,4455278.535199999 5793326.649,4455278.512299999 5793326.6534,4455278.485299999 5793326.6574,4455278.4603 5793326.6619,4455278.4331 5793326.6619,4455278.4188 5793326.6597,4455278.399299999 5793326.662699999,4455278.3755 5793326.6644,4455278.367499999 5793326.662499999,4455278.346099999 5793326.664999999,4455278.315799999 5793326.6687,4455278.284699999 5793326.6663,4455278.255499999 5793326.672299999,4455278.2317 5793326.6687,4455278.2171 5793326.669399999,4455278.187699999 5793326.670299999,4455278.165199999 5793326.671499999,4455278.1474 5793326.671399999,4455278.138199999 5793326.6838,4455278.136099999 5793326.755999999,4455278.135599999 5793326.775399999,4455278.139399999 5793326.787599999,4455278.1387 5793326.812,4455278.137799999 5793326.829199999,4455278.1403 5793326.841,4455278.1375 5793326.8617,4455278.1379 5793326.878499999,4455278.140499999 5793326.886099999,4455278.167299999 5793326.914799999,4455278.201 5793326.937,4455278.237099999 5793326.9648,4455278.2478 5793326.9701,4455278.2581 5793326.970399999,4455278.2593 5793326.993899999,4455278.2604 5793327.015499999,4455278.265499999 5793327.0292,4455278.2729 5793327.049399999,4455278.2828 5793327.0632,4455278.2922 5793327.068499999,4455278.3057 5793327.067299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (93,93,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Stein','Stein','NULL',0.725224400218,0.0278554499938,0.0456484168753,0.118685883876,1, ST_GeomFromText('MULTIPOLYGON(((4455279.588899999 5793327.0865,4455279.5899 5793327.082499999,4455279.5975 5793327.066199999,4455279.600999999 5793327.0456,4455279.598 5793327.036,4455279.5948 5793327.009099999,4455279.592799999 5793326.9868,4455279.5893 5793326.960899999,4455279.5869 5793326.9404,4455279.58 5793326.927799999,4455279.5684 5793326.923299999,4455279.543399999 5793326.923699999,4455279.5186 5793326.9276,4455279.500099999 5793326.931099999,4455279.483699999 5793326.923499999,4455279.4598 5793326.9199,4455279.4186 5793326.9144,4455279.389399999 5793326.9177,4455279.3771 5793326.934599999,4455279.388899999 5793326.971499999,4455279.4187 5793327.0237,4455279.4214 5793327.0503,4455279.412899999 5793327.0743,4455279.426699999 5793327.076199999,4455279.4455 5793327.065199999,4455279.4603 5793327.054199999,4455279.475999999 5793327.045199999,4455279.5163 5793327.060499999,4455279.569099999 5793327.0885,4455279.588899999 5793327.0865)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (94,94,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',2.82352321113,0.54425187998,0.441414640817,1.14767806612,1, ST_GeomFromText('MULTIPOLYGON(((4455277.724299999 5793327.095499999,4455277.747999999 5793327.0964,4455277.7806 5793327.090299999,4455277.8063 5793327.0852,4455277.833999999 5793327.080099999,4455277.8557 5793327.068099999,4455277.862599999 5793327.068099999,4455277.8754 5793327.0601,4455277.893199999 5793327.051,4455277.906 5793327.048,4455277.911 5793327.042999999,4455277.9263 5793327.041099999,4455277.937599999 5793327.029999999,4455277.951399999 5793327.023,4455277.972099999 5793327.010999999,4455277.984 5793327,4455278.000699999 5793326.983999999,4455278.016499999 5793326.971,4455278.034199999 5793326.9571,4455278.049999999 5793326.939099999,4455278.0608 5793326.930099999,4455278.0608 5793326.922199999,4455278.0706 5793326.9033,4455278.0804 5793326.8814,4455278.087299999 5793326.8585,4455278.091199999 5793326.8376,4455278.094999999 5793326.8078,4455278.0959 5793326.7859,4455278.097799999 5793326.758099999,4455278.0958 5793326.734099999,4455278.0837 5793326.686599999,4455278.073099999 5793326.662299999,4455278.023599999 5793326.622999999,4455277.992999999 5793326.591399999,4455277.9768 5793326.5807,4455277.9548 5793326.5789,4455277.905899999 5793326.546199999,4455277.857699999 5793326.5272,4455277.798499999 5793326.5064,4455277.7448 5793326.490299999,4455277.703099999 5793326.4878,4455277.6698 5793326.484899999,4455277.6341 5793326.4798,4455277.5968 5793326.473099999,4455277.568099999 5793326.476999999,4455277.5393 5793326.4791,4455277.5277 5793326.475199999,4455277.5102 5793326.478399999,4455277.489599999 5793326.484699999,4455277.451899999 5793326.4876,4455277.423399999 5793326.492,4455277.404799999 5793326.494799999,4455277.3821 5793326.496899999,4455277.370699999 5793326.496099999,4455277.360299999 5793326.502,4455277.3288 5793326.5072,4455277.303999999 5793326.510199999,4455277.2783 5793326.514299999,4455277.2526 5793326.5184,4455277.2269 5793326.524399999,4455277.1993 5793326.534499999,4455277.176599999 5793326.537599999,4455277.1538 5793326.5436,4455277.131099999 5793326.551699999,4455277.1025 5793326.5577,4455277.081699999 5793326.5668,4455277.056099999 5793326.575799999,4455277.037299999 5793326.586799999,4455277.0206 5793326.6038,4455277.008799999 5793326.6217,4455277.001899999 5793326.6446,4455277.003999999 5793326.6764,4455277.006099999 5793326.703199999,4455277.013799999 5793326.730699999,4455277.025799999 5793326.7685,4455277.045699999 5793326.815099999,4455277.063199999 5793326.848899999,4455277.089499999 5793326.8804,4455277.113099999 5793326.9249,4455277.139 5793326.979699999,4455277.166899999 5793326.990199999,4455277.1873 5793327.014299999,4455277.213899999 5793327.033099999,4455277.257799999 5793327.0458,4455277.2892 5793327.06,4455277.357099999 5793327.0711,4455277.400899999 5793327.078099999,4455277.4358 5793327.0807,4455277.4698 5793327.0853,4455277.4855 5793327.0928,4455277.507699999 5793327.095899999,4455277.5465 5793327.093499999,4455277.581699999 5793327.099199999,4455277.6057 5793327.096999999,4455277.628399999 5793327.097899999,4455277.664699999 5793327.095699999,4455277.703999999 5793327.1017,4455277.724299999 5793327.095499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (95,95,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',2.44202666524,0.448056480149,0.367690486386,0.955995264605,1, ST_GeomFromText('MULTIPOLYGON(((4455276.472199999 5793327.254899999,4455276.496899999 5793327.246799999,4455276.5196 5793327.234799999,4455276.5387 5793327.223799999,4455276.551099999 5793327.2068,4455276.5689 5793327.191899999,4455276.5787 5793327.175899999,4455276.5915 5793327.157999999,4455276.6003 5793327.142999999,4455276.612099999 5793327.127299999,4455276.613099999 5793327.115199999,4455276.617999999 5793327.100199999,4455276.625799999 5793327.081299999,4455276.6347 5793327.0654,4455276.6445 5793327.047499999,4455276.6524 5793327.0335,4455276.664099999 5793327.014599999,4455276.672 5793326.992699999,4455276.6759 5793326.972799999,4455276.6797 5793326.948999999,4455276.6846 5793326.9231,4455276.685499999 5793326.9013,4455276.6763 5793326.880799999,4455276.6754 5793326.8768,4455276.677199999 5793326.8736,4455276.688299999 5793326.8625,4455276.6853 5793326.843699999,4455276.6862 5793326.8198,4455276.6873 5793326.8003,4455276.6791 5793326.783099999,4455276.6731 5793326.751299999,4455276.6714 5793326.73,4455276.663499999 5793326.717,4455276.647699999 5793326.673599999,4455276.6222 5793326.666999999,4455276.5932 5793326.6436,4455276.572499999 5793326.6179,4455276.554299999 5793326.6019,4455276.5136 5793326.586999999,4455276.4757 5793326.579299999,4455276.4391 5793326.571499999,4455276.382399999 5793326.558499999,4455276.358 5793326.56,4455276.3244 5793326.557099999,4455276.286799999 5793326.5533,4455276.255199999 5793326.550499999,4455276.220599999 5793326.550599999,4455276.1889 5793326.5488,4455276.1622 5793326.551899999,4455276.131599999 5793326.553999999,4455276.1029 5793326.5581,4455276.0762 5793326.5622,4455276.050599999 5793326.569199999,4455276.0288 5793326.5753,4455276.0042 5793326.5883,4455275.9884 5793326.600299999,4455275.9736 5793326.6172,4455275.9559 5793326.637199999,4455275.951999999 5793326.6432,4455275.934299999 5793326.672,4455275.9274 5793326.684,4455275.915599999 5793326.7089,4455275.9078 5793326.7298,4455275.9029 5793326.7507,4455275.897099999 5793326.774499999,4455275.8952 5793326.797399999,4455275.893299999 5793326.826199999,4455275.8974 5793326.855,4455275.9034 5793326.889699999,4455275.9144 5793326.924499999,4455275.926799999 5793326.9527,4455275.948099999 5793327.004399999,4455275.969299999 5793327.0438,4455275.995299999 5793327.0755,4455276.047799999 5793327.1311,4455276.101999999 5793327.163,4455276.136099999 5793327.186,4455276.1829 5793327.2039,4455276.2421 5793327.219399999,4455276.288099999 5793327.2267,4455276.295599999 5793327.239399999,4455276.303999999 5793327.2454,4455276.324799999 5793327.2396,4455276.374599999 5793327.252199999,4455276.416299999 5793327.258199999,4455276.442599999 5793327.258999999,4455276.472199999 5793327.254899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (96,96,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Stein','Stein','NULL',0.939539959342,0.0552390950333,0.0666352424335,0.173251630327,1, ST_GeomFromText('MULTIPOLYGON(((4455279.565 5793327.2992,4455279.575699999 5793327.276,4455279.5838 5793327.258999999,4455279.593799999 5793327.2419,4455279.6056 5793327.2256,4455279.6117 5793327.2027,4455279.615 5793327.183599999,4455279.613199999 5793327.1608,4455279.608099999 5793327.1501,4455279.6014 5793327.114099999,4455279.588899999 5793327.0865,4455279.569099999 5793327.0885,4455279.5163 5793327.060499999,4455279.475999999 5793327.045199999,4455279.4603 5793327.054199999,4455279.4455 5793327.065199999,4455279.426699999 5793327.076199999,4455279.412899999 5793327.0743,4455279.400999999 5793327.0763,4455279.3754 5793327.0631,4455279.349799999 5793327.0656,4455279.3403 5793327.083,4455279.340099999 5793327.097999999,4455279.3431 5793327.1094,4455279.345999999 5793327.1664,4455279.345099999 5793327.192099999,4455279.340499999 5793327.2145,4455279.3342 5793327.233899999,4455279.334099999 5793327.2627,4455279.3408 5793327.2749,4455279.3594 5793327.281899999,4455279.388199999 5793327.2783,4455279.4104 5793327.2738,4455279.433 5793327.269099999,4455279.446399999 5793327.2727,4455279.470499999 5793327.272099999,4455279.485999999 5793327.2791,4455279.5196 5793327.285599999,4455279.5305 5793327.293899999,4455279.5453 5793327.299799999,4455279.5541 5793327.3013,4455279.565 5793327.2992)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (97,97,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Stein','Stein','NULL',0.697863542085,0.0227096199411,0.0417046527228,0.108432097079,1, ST_GeomFromText('MULTIPOLYGON(((4455279.2651 5793327.427899999,4455279.2648 5793327.4196,4455279.2575 5793327.4086,4455279.245299999 5793327.3802,4455279.2278 5793327.357599999,4455279.215699999 5793327.335599999,4455279.195799999 5793327.313699999,4455279.181699999 5793327.3047,4455279.164599999 5793327.293099999,4455279.1544 5793327.284199999,4455279.148199999 5793327.273199999,4455279.138399999 5793327.2574,4455279.121799999 5793327.2474,4455279.103 5793327.240499999,4455279.097099999 5793327.242599999,4455279.0673 5793327.2201,4455279.054899999 5793327.2158,4455279.0442 5793327.224099999,4455279.048799999 5793327.2422,4455279.062699999 5793327.2714,4455279.078599999 5793327.318199999,4455279.0891 5793327.3528,4455279.0921 5793327.378,4455279.100499999 5793327.398299999,4455279.1127 5793327.421499999,4455279.1304 5793327.429199999,4455279.1363 5793327.4242,4455279.1491 5793327.4221,4455279.162999999 5793327.418099999,4455279.1709 5793327.420099999,4455279.2 5793327.416999999,4455279.249999999 5793327.429899999,4455279.259899999 5793327.4319,4455279.2651 5793327.427899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (98,98,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',3.36053887994,0.880703809896,0.699271399904,1.81810563975,1, ST_GeomFromText('MULTIPOLYGON(((4455273.840099999 5793327.4649,4455273.861899999 5793327.4638,4455273.8984 5793327.459699999,4455273.9221 5793327.4546,4455273.9429 5793327.4495,4455273.971499999 5793327.442399999,4455273.9923 5793327.435399999,4455274.010999999 5793327.4294,4455274.035699999 5793327.419299999,4455274.056499999 5793327.410299999,4455274.074199999 5793327.400299999,4455274.092 5793327.3903,4455274.113699999 5793327.378299999,4455274.1354 5793327.363299999,4455274.1502 5793327.352299999,4455274.163999999 5793327.341299999,4455274.182699999 5793327.328299999,4455274.1955 5793327.316299999,4455274.2143 5793327.3023,4455274.234 5793327.286299999,4455274.249699999 5793327.2704,4455274.2596 5793327.254399999,4455274.273299999 5793327.239499999,4455274.285199999 5793327.2235,4455274.2969 5793327.2026,4455274.3058 5793327.188699999,4455274.3206 5793327.1707,4455274.3294 5793327.154799999,4455274.350999999 5793327.120899999,4455274.3569 5793327.103,4455274.363699999 5793327.080099999,4455274.3843 5793327.016499999,4455274.3891 5793326.9896,4455274.389 5793326.9638,4455274.3879 5793326.936,4455274.388799999 5793326.9122,4455274.385999999 5793326.888199999,4455274.364699999 5793326.7924,4455274.348899999 5793326.754899999,4455274.330699999 5793326.7059,4455274.316399999 5793326.675899999,4455274.279699999 5793326.628799999,4455274.205299999 5793326.575699999,4455274.1661 5793326.558499999,4455274.0826 5793326.520199999,4455274.016599999 5793326.4922,4455273.9703 5793326.4832,4455273.954199999 5793326.4723,4455273.9335 5793326.4701,4455273.898799999 5793326.4633,4455273.846699999 5793326.4524,4455273.8084 5793326.450999999,4455273.784099999 5793326.448799999,4455273.7554 5793326.451899999,4455273.7218 5793326.455099999,4455273.654699999 5793326.4722,4455273.629999999 5793326.479299999,4455273.604299999 5793326.488399999,4455273.584599999 5793326.4954,4455273.5628 5793326.5054,4455273.544099999 5793326.513499999,4455273.520399999 5793326.524499999,4455273.4839 5793326.545499999,4455273.4671 5793326.5565,4455273.451299999 5793326.5655,4455273.4434 5793326.5688,4455273.4374 5793326.577999999,4455273.427 5793326.579399999,4455273.422699999 5793326.5865,4455273.410899999 5793326.595499999,4455273.397099999 5793326.606499999,4455273.382299999 5793326.6195,4455273.366499999 5793326.6304,4455273.352699999 5793326.6434,4455273.3331 5793326.6674,4455273.325199999 5793326.6892,4455273.320399999 5793326.713099999,4455273.3145 5793326.732999999,4455273.312599999 5793326.7598,4455273.3117 5793326.7837,4455273.3108 5793326.810499999,4455273.310899999 5793326.839299999,4455273.311999999 5793326.8661,4455273.314199999 5793326.917799999,4455273.3113 5793326.948599999,4455273.3134 5793326.967399999,4455273.3145 5793327.001199999,4455273.316499999 5793327.026,4455273.317599999 5793327.050899999,4455273.318699999 5793327.0767,4455273.3238 5793327.1124,4455273.3288 5793327.147199999,4455273.3369 5793327.177999999,4455273.3413 5793327.205499999,4455273.3651 5793327.2553,4455273.427699999 5793327.327999999,4455273.476099999 5793327.366599999,4455273.528199999 5793327.392999999,4455273.5711 5793327.418899999,4455273.62 5793327.435,4455273.669999999 5793327.448499999,4455273.715699999 5793327.4594,4455273.739299999 5793327.4623,4455273.7729 5793327.464199999,4455273.805499999 5793327.464999999,4455273.840099999 5793327.4649)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (99,99,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Stein','Stein','NULL',0.502284681788,0.0158966350607,0.0364831811105,0.0948562708873,1, ST_GeomFromText('MULTIPOLYGON(((4455279.418499999 5793327.5303,4455279.434299999 5793327.534199999,4455279.448099999 5793327.5291,4455279.461 5793327.531099999,4455279.4757 5793327.5171,4455279.4797 5793327.5161,4455279.483599999 5793327.512099999,4455279.4846 5793327.4952,4455279.489199999 5793327.4798,4455279.4828 5793327.466399999,4455279.4638 5793327.4473,4455279.4265 5793327.420299999,4455279.417799999 5793327.398199999,4455279.406299999 5793327.382699999,4455279.388899999 5793327.374099999,4455279.3684 5793327.3725,4455279.3517 5793327.3801,4455279.3322 5793327.401,4455279.336799999 5793327.4174,4455279.348799999 5793327.442099999,4455279.355999999 5793327.4789,4455279.354 5793327.4908,4455279.377999999 5793327.5172,4455279.4106 5793327.536299999,4455279.418499999 5793327.5303)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (100,100,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Stein','Stein','NULL',0.726780949525,0.0328164050396,0.0494504928224,0.128571281338,1, ST_GeomFromText('MULTIPOLYGON(((4455279.1341 5793327.6487,4455279.145899999 5793327.632799999,4455279.160699999 5793327.617799999,4455279.174499999 5793327.600899999,4455279.1853 5793327.587899999,4455279.199099999 5793327.573899999,4455279.2119 5793327.555999999,4455279.223699999 5793327.542999999,4455279.223699999 5793327.5381,4455279.227599999 5793327.531099999,4455279.2165 5793327.506599999,4455279.206699999 5793327.4778,4455279.194799999 5793327.4614,4455279.1709 5793327.420099999,4455279.162999999 5793327.418099999,4455279.1491 5793327.4221,4455279.1363 5793327.4242,4455279.1304 5793327.429199999,4455279.1127 5793327.421499999,4455279.100499999 5793327.398299999,4455279.082899999 5793327.424399999,4455279.0721 5793327.4404,4455279.063199999 5793327.446399999,4455279.062199999 5793327.4503,4455279.065299999 5793327.463199999,4455279.059399999 5793327.472699999,4455279.0584 5793327.484099999,4455279.051599999 5793327.501,4455279.045599999 5793327.505,4455279.045699999 5793327.5249,4455279.040099999 5793327.5438,4455279.037999999 5793327.570599999,4455279.028099999 5793327.5866,4455279.0421 5793327.6114,4455279.0466 5793327.625499999,4455279.059999999 5793327.6388,4455279.0837 5793327.6522,4455279.1035 5793327.654799999,4455279.120299999 5793327.663699999,4455279.1341 5793327.6487)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (101,101,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Stein','Stein','NULL',0.619734755157,0.0224439900159,0.0415010739482,0.107902792265,1, ST_GeomFromText('MULTIPOLYGON(((4455279.1681 5793327.754899999,4455279.1829 5793327.744899999,4455279.2021 5793327.732799999,4455279.2192 5793327.7214,4455279.235 5793327.7083,4455279.2492 5793327.6947,4455279.266499999 5793327.676799999,4455279.272599999 5793327.663,4455279.2854 5793327.653,4455279.2794 5793327.6312,4455279.2833 5793327.625199999,4455279.2783 5793327.602399999,4455279.2734 5793327.5994,4455279.264399999 5793327.5777,4455279.2576 5793327.57,4455279.2499 5793327.5337,4455279.2422 5793327.5291,4455279.227599999 5793327.531099999,4455279.223699999 5793327.5381,4455279.223699999 5793327.542999999,4455279.2119 5793327.555999999,4455279.199099999 5793327.573899999,4455279.1853 5793327.587899999,4455279.174499999 5793327.600899999,4455279.160699999 5793327.617799999,4455279.145899999 5793327.632799999,4455279.1341 5793327.6487,4455279.120299999 5793327.663699999,4455279.122299999 5793327.6686,4455279.1155 5793327.687499999,4455279.115 5793327.708499999,4455279.1227 5793327.7397,4455279.1379 5793327.760099999,4455279.151499999 5793327.763499999,4455279.1681 5793327.754899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (102,102,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Stein','Stein','NULL',1.20220479665,0.0883909648068,0.0920428354279,0.239311372113,1, ST_GeomFromText('MULTIPOLYGON(((4455279.568599999 5793327.8321,4455279.5914 5793327.821299999,4455279.607599999 5793327.8099,4455279.621799999 5793327.794399999,4455279.6343 5793327.7806,4455279.644399999 5793327.763499999,4455279.651999999 5793327.742699999,4455279.655399999 5793327.7221,4455279.658099999 5793327.7015,4455279.661399999 5793327.6751,4455279.663099999 5793327.6486,4455279.662999999 5793327.6136,4455279.661999999 5793327.601299999,4455279.6567 5793327.5951,4455279.624699999 5793327.587099999,4455279.615299999 5793327.5887,4455279.604399999 5793327.598999999,4455279.548999999 5793327.5456,4455279.523099999 5793327.5283,4455279.483599999 5793327.512099999,4455279.4797 5793327.5161,4455279.4757 5793327.5171,4455279.461 5793327.531099999,4455279.448099999 5793327.5291,4455279.434299999 5793327.534199999,4455279.418499999 5793327.5303,4455279.4106 5793327.536299999,4455279.377999999 5793327.5172,4455279.354 5793327.4908,4455279.3311 5793327.4952,4455279.3162 5793327.5128,4455279.303199999 5793327.528799999,4455279.293999999 5793327.5536,4455279.290099999 5793327.5755,4455279.285199999 5793327.5974,4455279.2783 5793327.602399999,4455279.2833 5793327.625199999,4455279.2794 5793327.6312,4455279.2854 5793327.653,4455279.2943 5793327.6609,4455279.303199999 5793327.6828,4455279.3243 5793327.7102,4455279.338 5793327.731699999,4455279.3579 5793327.748099999,4455279.376799999 5793327.7641,4455279.386099999 5793327.763499999,4455279.407899999 5793327.769799999,4455279.4259 5793327.7686,4455279.4691 5793327.7817,4455279.5366 5793327.8353,4455279.568599999 5793327.8321)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (103,103,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',2.66163973358,0.502074909933,0.409090210973,1.06363454853,1, ST_GeomFromText('MULTIPOLYGON(((4455287.212799999 5793327.9964,4455287.225599999 5793327.981399999,4455287.240399999 5793327.9645,4455287.250199999 5793327.947599999,4455287.264 5793327.926599999,4455287.274799999 5793327.9067,4455287.2925 5793327.870899999,4455287.304299999 5793327.851999999,4455287.312099999 5793327.835999999,4455287.320899999 5793327.815099999,4455287.326799999 5793327.795199999,4455287.348299999 5793327.731599999,4455287.354199999 5793327.707699999,4455287.3551 5793327.6809,4455287.355899999 5793327.6511,4455287.355899999 5793327.627199999,4455287.3528 5793327.595399999,4455287.3497 5793327.5657,4455287.3437 5793327.532899999,4455287.3366 5793327.498199999,4455287.328599999 5793327.4644,4455287.3245 5793327.436599999,4455287.321499999 5793327.4088,4455287.320399999 5793327.380999999,4455287.3173 5793327.352199999,4455287.313199999 5793327.320399999,4455287.3062 5793327.289699999,4455287.301199999 5793327.2619,4455287.2932 5793327.2331,4455287.2855 5793327.2104,4455287.267599999 5793327.191199999,4455287.215699999 5793327.1532,4455287.170699999 5793327.129799999,4455287.157399999 5793327.119899999,4455287.116799999 5793327.066099999,4455287.092699999 5793327.0185,4455287.047399999 5793327.000099999,4455287.0185 5793327.008799999,4455287.0047 5793327.0118,4455286.9879 5793327.0159,4455286.9523 5793327.025,4455286.932599999 5793327.033999999,4455286.916799999 5793327.048,4455286.898099999 5793327.064899999,4455286.888199999 5793327.077899999,4455286.8754 5793327.0919,4455286.858699999 5793327.110799999,4455286.848899999 5793327.1247,4455286.8331 5793327.142699999,4455286.819299999 5793327.1567,4455286.805499999 5793327.1706,4455286.7937 5793327.184599999,4455286.7799 5793327.198599999,4455286.768099999 5793327.2105,4455286.752299999 5793327.2265,4455286.733599999 5793327.241499999,4455286.718799999 5793327.2564,4455286.706 5793327.272399999,4455286.695199999 5793327.2923,4455286.689399999 5793327.316199999,4455286.686499999 5793327.338999999,4455286.6836 5793327.3639,4455286.6847 5793327.390699999,4455286.688799999 5793327.420499999,4455286.6918 5793327.4493,4455286.695899999 5793327.476099999,4455286.696 5793327.5039,4455286.6971 5793327.529699999,4455286.6982 5793327.558499999,4455286.6973 5793327.590299999,4455286.6983 5793327.6082,4455286.697499999 5793327.639,4455286.7015 5793327.6718,4455286.706199999 5793327.699799999,4455286.7263 5793327.745899999,4455286.756199999 5793327.782199999,4455286.7855 5793327.819199999,4455286.8256 5793327.845,4455286.9071 5793327.903,4455286.947599999 5793327.921,4455286.9844 5793327.945399999,4455287.0437 5793327.969299999,4455287.1068 5793327.9932,4455287.142699999 5793328.0007,4455287.177299999 5793328.005499999,4455287.1956 5793328.0076,4455287.212799999 5793327.9964)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (104,104,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',3.34635364005,0.750034949967,0.599126785655,1.5577296427,1, ST_GeomFromText('MULTIPOLYGON(((4455272.248399999 5793328.019099999,4455272.273 5793328.009999999,4455272.2948 5793328,4455272.315499999 5793327.989,4455272.332299999 5793327.979,4455272.351999999 5793327.968,4455272.369699999 5793327.956,4455272.385499999 5793327.946,4455272.405299999 5793327.935,4455272.424999999 5793327.924,4455272.440799999 5793327.911,4455272.458499999 5793327.898,4455272.474299999 5793327.885999999,4455272.4901 5793327.871999999,4455272.5058 5793327.858999999,4455272.522599999 5793327.8451,4455272.5394 5793327.8311,4455272.5541 5793327.818099999,4455272.5679 5793327.807099999,4455272.586699999 5793327.794099999,4455272.601499999 5793327.782099999,4455272.6162 5793327.7692,4455272.633 5793327.758199999,4455272.650799999 5793327.7462,4455272.668499999 5793327.7322,4455272.6823 5793327.7202,4455272.701 5793327.704199999,4455272.7158 5793327.692199999,4455272.7306 5793327.680199999,4455272.746399999 5793327.6673,4455272.7641 5793327.6533,4455272.7789 5793327.6413,4455272.7947 5793327.627299999,4455272.806499999 5793327.614399999,4455272.819299999 5793327.602399999,4455272.835099999 5793327.5844,4455272.849799999 5793327.568499999,4455272.8607 5793327.557499999,4455272.873499999 5793327.537599999,4455272.887299999 5793327.5236,4455272.901999999 5793327.502699999,4455272.910899999 5793327.4887,4455272.921699999 5793327.471799999,4455272.931499999 5793327.452899999,4455272.9423 5793327.433,4455272.9501 5793327.4141,4455272.957999999 5793327.396099999,4455272.9658 5793327.3782,4455272.9687 5793327.3474,4455272.9696 5793327.323599999,4455272.969499999 5793327.298699999,4455272.965099999 5793327.2716,4455272.9501 5793327.2313,4455272.9303 5793327.1864,4455272.9071 5793327.141899999,4455272.8912 5793327.1267,4455272.865 5793327.0777,4455272.8464 5793327.042199999,4455272.821499999 5793327.011499999,4455272.756799999 5793326.9318,4455272.714399999 5793326.8825,4455272.6407 5793326.8355,4455272.599 5793326.811599999,4455272.5877 5793326.8069,4455272.575199999 5793326.8067,4455272.528199999 5793326.799699999,4455272.503999999 5793326.7991,4455272.475399999 5793326.8002,4455272.450699999 5793326.8023,4455272.424999999 5793326.807399999,4455272.3963 5793326.8144,4455272.3716 5793326.819499999,4455272.349899999 5793326.830499999,4455272.3332 5793326.844499999,4455272.3174 5793326.866399999,4455272.3086 5793326.8844,4455272.297799999 5793326.908199999,4455272.291899999 5793326.9271,4455272.285099999 5793326.943099999,4455272.2762 5793326.962999999,4455272.2674 5793326.9789,4455272.255599999 5793326.9988,4455272.245799999 5793327.015799999,4455272.236899999 5793327.0337,4455272.227099999 5793327.0536,4455272.217299999 5793327.0745,4455272.209499999 5793327.092399999,4455272.2016 5793327.1083,4455272.190799999 5793327.1292,4455272.184899999 5793327.148099999,4455272.176099999 5793327.169999999,4455272.1703 5793327.186899999,4455272.161399999 5793327.212799999,4455272.1546 5793327.2357,4455272.148699999 5793327.253599999,4455272.1478 5793327.276499999,4455272.137 5793327.297399999,4455272.131199999 5793327.319199999,4455272.126299999 5793327.340099999,4455272.122399999 5793327.362999999,4455272.1176 5793327.384899999,4455272.113699999 5793327.4087,4455272.109799999 5793327.4296,4455272.105 5793327.4545,4455272.1001 5793327.466399999,4455272.0942 5793327.4952,4455272.089399999 5793327.5181,4455272.0865 5793327.537,4455272.0826 5793327.563799999,4455272.0787 5793327.583699999,4455272.0749 5793327.607599999,4455272.071 5793327.6314,4455272.0661 5793327.657299999,4455272.064199999 5793327.671199999,4455272.058899999 5793327.685599999,4455272.0614 5793327.703999999,4455272.0595 5793327.7278,4455272.057599999 5793327.754699999,4455272.0537 5793327.7805,4455272.052799999 5793327.8024,4455272.049899999 5793327.827199999,4455272.050999999 5793327.857,4455272.050099999 5793327.879899999,4455272.051199999 5793327.9077,4455272.0563 5793327.9404,4455272.063199999 5793327.965399999,4455272.0826 5793327.987099999,4455272.114 5793328.005799999,4455272.153699999 5793328.0184,4455272.1891 5793328.024299999,4455272.2207 5793328.0262,4455272.248399999 5793328.019099999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (105,105,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Zwickelmauerwerk','Verkeilstein/Zwickelmauerwerk','NULL',0.379717098842,0.00992786497443,0.0319087157164,0.0829626608627,1, ST_GeomFromText('MULTIPOLYGON(((4455279.7016 5793328.323699999,4455279.7092 5793328.3165,4455279.718999999 5793328.2982,4455279.7275 5793328.279799999,4455279.7355 5793328.260299999,4455279.726499999 5793328.232599999,4455279.689699999 5793328.1962,4455279.6764 5793328.1904,4455279.6578 5793328.197,4455279.6518 5793328.2155,4455279.6434 5793328.236999999,4455279.637 5793328.250399999,4455279.6226 5793328.2684,4455279.6222 5793328.287499999,4455279.626 5793328.295499999,4455279.651999999 5793328.309,4455279.6769 5793328.3144,4455279.682599999 5793328.321499999,4455279.693799999 5793328.3252,4455279.7016 5793328.323699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (106,106,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Zwickelmauerwerk','Verkeilstein/Zwickelmauerwerk','NULL',0.423730622101,0.0109778100895,0.0327133936526,0.0850548234966,1, ST_GeomFromText('MULTIPOLYGON(((4455279.7905 5793328.361999999,4455279.819099999 5793328.3604,4455279.8539 5793328.3614,4455279.883399999 5793328.360799999,4455279.8995 5793328.363399999,4455279.911299999 5793328.357699999,4455279.9137 5793328.333799999,4455279.918499999 5793328.3266,4455279.9186 5793328.3201,4455279.903099999 5793328.300799999,4455279.857499999 5793328.288799999,4455279.842799999 5793328.278899999,4455279.8141 5793328.2751,4455279.7921 5793328.282299999,4455279.778099999 5793328.2958,4455279.767799999 5793328.314099999,4455279.758399999 5793328.333499999,4455279.7569 5793328.3527,4455279.760499999 5793328.3606,4455279.768799999 5793328.363399999,4455279.7905 5793328.361999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (107,107,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Zwickelmauerwerk','Verkeilstein/Zwickelmauerwerk','NULL',0.342693473263,0.00558699502537,0.0285818729874,0.0743128697674,1, ST_GeomFromText('MULTIPOLYGON(((4455279.569 5793328.437599999,4455279.5788 5793328.4207,4455279.576799999 5793328.4107,4455279.584699999 5793328.3978,4455279.580699999 5793328.3879,4455279.5886 5793328.3769,4455279.5865 5793328.367,4455279.594399999 5793328.355,4455279.5924 5793328.3461,4455279.6003 5793328.3341,4455279.582299999 5793328.3135,4455279.563599999 5793328.299699999,4455279.551599999 5793328.298499999,4455279.5345 5793328.3025,4455279.535 5793328.329099999,4455279.541 5793328.358599999,4455279.547699999 5793328.3925,4455279.551699999 5793328.4186,4455279.565999999 5793328.438599999,4455279.569 5793328.437599999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (108,108,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Verkeilstein','Verkeilstein/Zwickelmauerwerk','NULL',0.504393679467,0.015590664991,0.0362486856491,0.0942465826876,1, ST_GeomFromText('MULTIPOLYGON(((4455279.347599999 5793328.4604,4455279.355999999 5793328.4516,4455279.3584 5793328.4395,4455279.364299999 5793328.424599999,4455279.380699999 5793328.412499999,4455279.388199999 5793328.391799999,4455279.391999999 5793328.3691,4455279.3947 5793328.347699999,4455279.3924 5793328.3232,4455279.381699999 5793328.306299999,4455279.365299999 5793328.300699999,4455279.3491 5793328.307399999,4455279.331299999 5793328.3144,4455279.318799999 5793328.319199999,4455279.3106 5793328.3265,4455279.2958 5793328.3394,4455279.28 5793328.3574,4455279.2702 5793328.377299999,4455279.2673 5793328.386199999,4455279.2527 5793328.4055,4455279.253299999 5793328.435599999,4455279.265499999 5793328.4548,4455279.272499999 5793328.4538,4455279.285299999 5793328.440799999,4455279.303999999 5793328.446,4455279.337799999 5793328.4714,4455279.347599999 5793328.4604)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (109,109,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Verkeilstein','Verkeilstein/Zwickelmauerwerk','NULL',0.391565670457,0.00869838992966,0.0309664460421,0.0805127597094,1, ST_GeomFromText('MULTIPOLYGON(((4455279.626199999 5793328.4604,4455279.6347 5793328.436899999,4455279.642199999 5793328.4154,4455279.650999999 5793328.401499999,4455279.660899999 5793328.380699999,4455279.660199999 5793328.3625,4455279.6528 5793328.3517,4455279.623499999 5793328.3344,4455279.6052 5793328.3331,4455279.6003 5793328.3341,4455279.5924 5793328.3461,4455279.594399999 5793328.355,4455279.5865 5793328.367,4455279.5886 5793328.3769,4455279.580699999 5793328.3879,4455279.584699999 5793328.3978,4455279.576799999 5793328.4107,4455279.5788 5793328.4207,4455279.569 5793328.437599999,4455279.565999999 5793328.438599999,4455279.572399999 5793328.458599999,4455279.579099999 5793328.467,4455279.598899999 5793328.475999999,4455279.6205 5793328.479599999,4455279.626199999 5793328.4604)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (110,110,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Verkeilstein','Verkeilstein/Zwickelmauerwerk','NULL',0.385924686142,0.00825361497445,0.0306255705164,0.0796264833427,1, ST_GeomFromText('MULTIPOLYGON(((4455279.3519 5793328.5488,4455279.3717 5793328.5537,4455279.3835 5793328.549699999,4455279.396399999 5793328.549599999,4455279.3903 5793328.5327,4455279.377299999 5793328.5204,4455279.337799999 5793328.4714,4455279.303999999 5793328.446,4455279.285299999 5793328.440799999,4455279.272499999 5793328.4538,4455279.265499999 5793328.4548,4455279.2636 5793328.4757,4455279.264999999 5793328.490499999,4455279.275899999 5793328.509099999,4455279.334099999 5793328.5588,4455279.3519 5793328.5488)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (111,111,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Verkeilstein','Verkeilstein/Zwickelmauerwerk','NULL',0.346561127672,0.00637261999682,0.0291839759656,0.0758783375105,1, ST_GeomFromText('MULTIPOLYGON(((4455279.502199999 5793328.5581,4455279.5071 5793328.553099999,4455279.5289 5793328.554999999,4455279.5388 5793328.549,4455279.5585 5793328.552899999,4455279.571399999 5793328.5479,4455279.597099999 5793328.552699999,4455279.601099999 5793328.5547,4455279.611999999 5793328.541799999,4455279.608 5793328.5316,4455279.569299999 5793328.496999999,4455279.5608 5793328.493499999,4455279.541699999 5793328.491399999,4455279.519899999 5793328.496799999,4455279.4938 5793328.506799999,4455279.4797 5793328.523,4455279.4775 5793328.559699999,4455279.502199999 5793328.5581)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (112,112,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Kammerstein','Kammerstein','NULL',2.14139375117,0.292254884963,0.248284143835,0.645538773972,1, ST_GeomFromText('MULTIPOLYGON(((4455282.060899999 5793328.564999999,4455282.089599999 5793328.5569,4455282.110299999 5793328.5459,4455282.128999999 5793328.531899999,4455282.1468 5793328.520899999,4455282.168499999 5793328.509899999,4455282.1823 5793328.5028,4455282.206 5793328.4908,4455282.2257 5793328.482799999,4455282.2494 5793328.4767,4455282.2712 5793328.477099999,4455282.2969 5793328.469599999,4455282.3196 5793328.4625,4455282.343299999 5793328.455499999,4455282.358099999 5793328.4534,4455282.362999999 5793328.446399999,4455282.382799999 5793328.433399999,4455282.396599999 5793328.422399999,4455282.4143 5793328.409499999,4455282.4281 5793328.3975,4455282.4439 5793328.3815,4455282.458599999 5793328.367499999,4455282.4714 5793328.3496,4455282.485199999 5793328.335599999,4455282.501 5793328.3157,4455282.512799999 5793328.301699999,4455282.521599999 5793328.2868,4455282.5334 5793328.268899999,4455282.5432 5793328.248999999,4455282.553999999 5793328.226099999,4455282.553899999 5793328.2002,4455282.5514 5793328.1752,4455282.532999999 5793328.1027,4455282.518799999 5793328.0645,4455282.4603 5793327.991,4455281.763399999 5793328.164799999,4455281.765599999 5793328.203999999,4455281.7795 5793328.244899999,4455281.802099999 5793328.291999999,4455281.8298 5793328.343599999,4455281.854799999 5793328.3909,4455281.8715 5793328.4118,4455281.875599999 5793328.4326,4455281.893799999 5793328.454199999,4455281.9187 5793328.4929,4455281.972199999 5793328.543999999,4455281.9989 5793328.558499999,4455282.0354 5793328.567099999,4455282.060899999 5793328.564999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (113,113,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Verkeilstein','Verkeilstein/Zwickelmauerwerk','NULL',0.221185787992,0.00300019498849,0.0265993494392,0.0691583085419,1, ST_GeomFromText('MULTIPOLYGON(((4455279.394299999 5793328.611199999,4455279.3995 5793328.603399999,4455279.403199999 5793328.5853,4455279.406499999 5793328.561899999,4455279.396399999 5793328.549599999,4455279.3835 5793328.549699999,4455279.3717 5793328.5537,4455279.3519 5793328.5488,4455279.334099999 5793328.5588,4455279.3421 5793328.5667,4455279.3437 5793328.5754,4455279.348399999 5793328.5833,4455279.387699999 5793328.615199999,4455279.394299999 5793328.611199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (114,114,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Verkeilstein','Verkeilstein/Zwickelmauerwerk','NULL',0.605208477603,0.0139789049489,0.0350134327528,0.0910349251573,1, ST_GeomFromText('MULTIPOLYGON(((4455279.6873 5793328.628799999,4455279.6957 5793328.624299999,4455279.700199999 5793328.617499999,4455279.703099999 5793328.606499999,4455279.7001 5793328.594,4455279.703499999 5793328.584,4455279.702899999 5793328.568199999,4455279.7044 5793328.5477,4455279.695899999 5793328.5304,4455279.6978 5793328.5096,4455279.699699999 5793328.504599999,4455279.715099999 5793328.4845,4455279.7055 5793328.4613,4455279.7176 5793328.447599999,4455279.718299999 5793328.428999999,4455279.722199999 5793328.415599999,4455279.7191 5793328.399199999,4455279.7191 5793328.381699999,4455279.714999999 5793328.370899999,4455279.7094 5793328.3682,4455279.692999999 5793328.3703,4455279.670699999 5793328.3899,4455279.6665 5793328.413699999,4455279.66 5793328.4352,4455279.656299999 5793328.4418,4455279.6562 5793328.449799999,4455279.653699999 5793328.453999999,4455279.651999999 5793328.4646,4455279.6533 5793328.4801,4455279.6469 5793328.497999999,4455279.643699999 5793328.5208,4455279.642199999 5793328.545399999,4455279.6396 5793328.5657,4455279.642699999 5793328.5795,4455279.6489 5793328.601999999,4455279.662399999 5793328.6237,4455279.6747 5793328.631999999,4455279.6873 5793328.628799999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (115,115,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Verkeilstein','Verkeilstein/Zwickelmauerwerk','NULL',0.635331753431,0.0252478199989,0.0436499292471,0.113489816043,1, ST_GeomFromText('MULTIPOLYGON(((4455279.625199999 5793328.6864,4455279.6524 5793328.685499999,4455279.6533 5793328.6699,4455279.6484 5793328.657899999,4455279.6396 5793328.627699999,4455279.627 5793328.614099999,4455279.6226 5793328.5895,4455279.601099999 5793328.5547,4455279.597099999 5793328.552699999,4455279.571399999 5793328.5479,4455279.5585 5793328.552899999,4455279.5388 5793328.549,4455279.5289 5793328.554999999,4455279.5071 5793328.553099999,4455279.502199999 5793328.5581,4455279.4775 5793328.559699999,4455279.4663 5793328.5635,4455279.456699999 5793328.571399999,4455279.4455 5793328.594,4455279.436099999 5793328.6094,4455279.427299999 5793328.6303,4455279.415599999 5793328.648099999,4455279.435899999 5793328.670499999,4455279.4593 5793328.6808,4455279.487399999 5793328.6808,4455279.502199999 5793328.6851,4455279.5278 5793328.686799999,4455279.562699999 5793328.686699999,4455279.5937 5793328.6874,4455279.625199999 5793328.6864)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (116,116,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Verkeilstein','Verkeilstein/Zwickelmauerwerk','NULL',0.288280214234,0.00516029003228,0.0282548462807,0.0734626003299,1, ST_GeomFromText('MULTIPOLYGON(((4455279.345999999 5793328.6904,4455279.351099999 5793328.6849,4455279.350399999 5793328.675,4455279.359199999 5793328.657099999,4455279.3572 5793328.6521,4455279.353199999 5793328.6491,4455279.349399999 5793328.6333,4455279.341 5793328.6238,4455279.3293 5793328.6206,4455279.311499999 5793328.6225,4455279.288099999 5793328.633099999,4455279.277099999 5793328.641499999,4455279.2613 5793328.651499999,4455279.250799999 5793328.663,4455279.256799999 5793328.6782,4455279.272199999 5793328.6831,4455279.300099999 5793328.6829,4455279.3278 5793328.685399999,4455279.336799999 5793328.6905,4455279.345999999 5793328.6904)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (117,117,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Verkeilstein','Verkeilstein/Zwickelmauerwerk','NULL',0.212267135799,0.00270287999375,0.0263714872272,0.0685658667908,1, ST_GeomFromText('MULTIPOLYGON(((4455279.432099999 5793328.6874,4455279.435899999 5793328.670499999,4455279.415599999 5793328.648099999,4455279.4024 5793328.6334,4455279.387799999 5793328.626099999,4455279.372999999 5793328.636099999,4455279.3572 5793328.6521,4455279.359199999 5793328.657099999,4455279.4187 5793328.6917,4455279.432099999 5793328.6874)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (118,118,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Zwickelmauerwerk','Stein','NULL',0.983692014647,0.0694058950256,0.0774926779476,0.201480962664,1, ST_GeomFromText('MULTIPOLYGON(((4455273.906799999 5793328.686499999,4455273.910699999 5793328.686499999,4455273.9216 5793328.675,4455273.9334 5793328.6576,4455273.945199999 5793328.6436,4455273.960799999 5793328.629,4455273.9697 5793328.624399999,4455273.979 5793328.6157,4455273.995799999 5793328.600899999,4455274.003499999 5793328.581199999,4455274.0102 5793328.548299999,4455274.006299999 5793328.5325,4455274.001199999 5793328.500499999,4455273.991499999 5793328.4671,4455273.9879 5793328.448799999,4455273.982499999 5793328.4362,4455273.9742 5793328.4043,4455273.966099999 5793328.373199999,4455273.947599999 5793328.348899999,4455273.910099999 5793328.3254,4455273.8989 5793328.324599999,4455273.8864 5793328.330299999,4455273.875 5793328.329399999,4455273.8618 5793328.3317,4455273.8442 5793328.3432,4455273.825299999 5793328.349099999,4455273.804299999 5793328.3637,4455273.795599999 5793328.3813,4455273.786999999 5793328.393699999,4455273.7794 5793328.406099999,4455273.776999999 5793328.415999999,4455273.7658 5793328.4298,4455273.7641 5793328.434299999,4455273.760999999 5793328.456299999,4455273.7548 5793328.4875,4455273.7505 5793328.5031,4455273.7481 5793328.5174,4455273.7505 5793328.529799999,4455273.7482 5793328.543199999,4455273.749499999 5793328.555099999,4455273.763799999 5793328.5909,4455273.786299999 5793328.6157,4455273.818099999 5793328.658299999,4455273.842799999 5793328.6674,4455273.890999999 5793328.696499999,4455273.906799999 5793328.686499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (119,119,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Kammerstein','Kammerstein','NULL',1.80234851441,0.209388039949,0.184774993817,0.480414983924,1, ST_GeomFromText('MULTIPOLYGON(((4455277.121199999 5793328.764,4455277.139999999 5793328.756999999,4455277.1627 5793328.748999999,4455277.1834 5793328.7379,4455277.2022 5793328.7289,4455277.225899999 5793328.7179,4455277.238699999 5793328.709899999,4455277.2564 5793328.697899999,4455277.273199999 5793328.6849,4455277.291899999 5793328.6729,4455277.307699999 5793328.6609,4455277.327499999 5793328.652899999,4455277.342199999 5793328.634899999,4455277.355999999 5793328.622999999,4455277.3738 5793328.6159,4455277.3896 5793328.598999999,4455277.405299999 5793328.587999999,4455277.425599999 5793328.5785,4455277.428999999 5793328.575999999,4455277.4418 5793328.559,4455277.455599999 5793328.548,4455277.468399999 5793328.5271,4455277.4802 5793328.5131,4455277.489099999 5793328.5032,4455277.49 5793328.491299999,4455277.500799999 5793328.476299999,4455277.4988 5793328.4723,4455277.5027 5793328.446499999,4455277.5036 5793328.432099999,4455277.4977 5793328.4187,4455277.499499999 5793328.4042,4455277.4862 5793328.387299999,4455277.456899999 5793328.369999999,4455277.424999999 5793328.3605,4455277.4077 5793328.3526,4455277.373399999 5793328.347599999,4455277.348199999 5793328.3452,4455277.311099999 5793328.344499999,4455277.274 5793328.342399999,4455277.2147 5793328.3471,4455277.189899999 5793328.3505,4455277.166199999 5793328.353599999,4455277.140499999 5793328.357699999,4455277.111899999 5793328.3637,4455277.0902 5793328.369799999,4455277.0635 5793328.3749,4455277.0427 5793328.380899999,4455277.019999999 5793328.389,4455276.997299999 5793328.392999999,4455276.971599999 5793328.4011,4455276.946899999 5793328.407199999,4455276.9242 5793328.4132,4455276.889899999 5793328.4185,4455276.8809 5793328.417999999,4455276.8699 5793328.424399999,4455276.8501 5793328.434399999,4455276.833399999 5793328.444399999,4455276.8217 5793328.4495,4455276.813699999 5793328.4604,4455276.802799999 5793328.479299999,4455276.790099999 5793328.495799999,4455276.7843 5793328.5207,4455276.798299999 5793328.5611,4455276.8337 5793328.614299999,4455276.894899999 5793328.671299999,4455276.9948 5793328.7433,4455277.0557 5793328.7664,4455277.0926 5793328.769099999,4455277.121199999 5793328.764)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (120,120,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Kammerstein','Kammerstein','NULL',1.68780082183,0.191871040046,0.171349965092,0.445509909238,1, ST_GeomFromText('MULTIPOLYGON(((4455280.1705 5793328.8155,4455280.199099999 5793328.8114,4455280.2258 5793328.805299999,4455280.2383 5793328.8057,4455280.2505 5793328.8002,4455280.274199999 5793328.7892,4455280.2949 5793328.782199999,4455280.3157 5793328.7781,4455280.318599999 5793328.7751,4455280.3453 5793328.7651,4455280.37 5793328.756999999,4455280.3868 5793328.748999999,4455280.407499999 5793328.741,4455280.4312 5793328.731899999,4455280.452899999 5793328.724899999,4455280.472699999 5793328.7148,4455280.492399999 5793328.7068,4455280.5141 5793328.698799999,4455280.535799999 5793328.688699999,4455280.5536 5793328.6787,4455280.5674 5793328.6598,4455280.574199999 5793328.6379,4455280.580099999 5793328.616,4455280.5849 5793328.5961,4455280.5888 5793328.5733,4455280.5926 5793328.560799999,4455280.590699999 5793328.547399999,4455280.5946 5793328.527599999,4455280.595499999 5793328.502699999,4455280.596499999 5793328.4911,4455280.5914 5793328.4779,4455280.590699999 5793328.4571,4455280.572599999 5793328.4282,4455280.5487 5793328.413499999,4455280.521999999 5793328.4087,4455280.519 5793328.411699999,4455280.4993 5793328.4177,4455280.4844 5793328.415799999,4455280.472599999 5793328.417799999,4455280.445899999 5793328.415899999,4455280.4172 5793328.418999999,4455280.3876 5793328.420199999,4455280.3539 5793328.420299999,4455280.3243 5793328.419399999,4455280.295599999 5793328.4206,4455280.266999999 5793328.4227,4455280.2472 5793328.424699999,4455280.208599999 5793328.427899999,4455280.182 5793328.430999999,4455280.1622 5793328.434,4455280.159199999 5793328.436,4455280.1365 5793328.440099999,4455280.1128 5793328.4462,4455280.0931 5793328.453199999,4455280.0674 5793328.4623,4455280.0476 5793328.4713,4455280.0414 5793328.481899999,4455280.0409 5793328.494599999,4455280.0251 5793328.519099999,4455280.0202 5793328.537,4455280.013399999 5793328.5609,4455280.0075 5793328.5807,4455279.9987 5793328.603599999,4455279.996799999 5793328.626499999,4455279.9939 5793328.650299999,4455279.991999999 5793328.6762,4455279.9894 5793328.697499999,4455280.0036 5793328.730499999,4455280.026899999 5793328.7598,4455280.0607 5793328.7901,4455280.104199999 5793328.815799999,4455280.108199999 5793328.813799999,4455280.143799999 5793328.8166,4455280.1705 5793328.8155)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (121,121,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Zwickelmauerwerk','Stein','NULL',0.843280640919,0.0384080650079,0.0537359410221,0.139713446657,1, ST_GeomFromText('MULTIPOLYGON(((4455273.886699999 5793328.884299999,4455273.895999999 5793328.879899999,4455273.9022 5793328.872099999,4455273.9172 5793328.851299999,4455273.9291 5793328.8463,4455273.930999999 5793328.8374,4455273.9369 5793328.8274,4455273.929899999 5793328.8046,4455273.9329 5793328.790699999,4455273.9258 5793328.767899999,4455273.927799999 5793328.7639,4455273.9198 5793328.753499999,4455273.9188 5793328.745999999,4455273.9007 5793328.7387,4455273.8875 5793328.7377,4455273.836699999 5793328.7116,4455273.821899999 5793328.717599999,4455273.7937 5793328.7016,4455273.781899999 5793328.700099999,4455273.7456 5793328.6852,4455273.728799999 5793328.684299999,4455273.6977 5793328.662699999,4455273.687699999 5793328.6642,4455273.674999999 5793328.675499999,4455273.671099999 5793328.6972,4455273.666899999 5793328.7144,4455273.6682 5793328.7291,4455273.668499999 5793328.7562,4455273.6754 5793328.774499999,4455273.687699999 5793328.7957,4455273.708399999 5793328.788699999,4455273.737099999 5793328.798499999,4455273.75 5793328.807399999,4455273.756 5793328.829199999,4455273.746199999 5793328.850099999,4455273.750199999 5793328.861999999,4455273.786799999 5793328.8879,4455273.799999999 5793328.8899,4455273.825699999 5793328.886499999,4455273.8591 5793328.889299999,4455273.8808 5793328.896199999,4455273.886699999 5793328.884299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (122,122,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Kammerstein','Kammerstein','NULL',2.72013781876,0.477900239934,0.390562743885,1.0154631341,1, ST_GeomFromText('MULTIPOLYGON(((4455275.654099999 5793329.0515,4455275.673799999 5793329.0504,4455275.714599999 5793329.048599999,4455275.739099999 5793329.044199999,4455275.767699999 5793329.042099999,4455275.8102 5793329.0413,4455275.8437 5793329.0368,4455275.864599999 5793329.0357,4455275.883399999 5793329.0346,4455275.9049 5793329.0338,4455275.9247 5793329.0261,4455275.943599999 5793329.0206,4455275.9829 5793329.016499999,4455276.008799999 5793329.013199999,4455276.022699999 5793329.0052,4455276.048399999 5793329.001099999,4455276.074099999 5793328.997999999,4455276.1057 5793328.9919,4455276.129399999 5793328.9879,4455276.1561 5793328.982799999,4455276.182699999 5793328.9757,4455276.2054 5793328.9667,4455276.2253 5793328.9528,4455276.220099999 5793328.91,4455276.222 5793328.899,4455276.219499999 5793328.8837,4455276.219899999 5793328.873199999,4455276.213499999 5793328.853199999,4455276.206399999 5793328.8176,4455276.203399999 5793328.7958,4455276.1928 5793328.7541,4455276.194799999 5793328.7452,4455276.189799999 5793328.7233,4455276.184299999 5793328.702899999,4455276.181099999 5793328.675699999,4455276.175699999 5793328.663799999,4455276.175599999 5793328.641,4455276.170599999 5793328.633999999,4455276.1725 5793328.6062,4455276.169499999 5793328.603199999,4455276.157499999 5793328.5752,4455276.160299999 5793328.5546,4455276.156499999 5793328.540699999,4455276.151399999 5793328.517899999,4455276.150299999 5793328.496999999,4455276.1447 5793328.4625,4455276.131099999 5793328.435799999,4455276.1111 5793328.4121,4455276.083899999 5793328.3954,4455276.055499999 5793328.3909,4455276.0235 5793328.3923,4455276.000699999 5793328.3953,4455275.980999999 5793328.3964,4455275.9369 5793328.4044,4455275.9062 5793328.407299999,4455275.879399999 5793328.411499999,4455275.8594 5793328.413799999,4455275.8387 5793328.4209,4455275.814 5793328.426899999,4455275.7893 5793328.433,4455275.7646 5793328.4381,4455275.742899999 5793328.443099999,4455275.716199999 5793328.4492,4455275.690499999 5793328.454299999,4455275.6648 5793328.4594,4455275.6401 5793328.4635,4455275.6105 5793328.467599999,4455275.586799999 5793328.480599999,4455275.581899999 5793328.5074,4455275.573099999 5793328.5174,4455275.554299999 5793328.522399999,4455275.528599999 5793328.526499999,4455275.5 5793328.5296,4455275.4753 5793328.5337,4455275.447599999 5793328.538799999,4455275.4199 5793328.540899999,4455275.393199999 5793328.547,4455275.3705 5793328.553999999,4455275.3528 5793328.562999999,4455275.3261 5793328.5741,4455275.3103 5793328.5821,4455275.288599999 5793328.599099999,4455275.275799999 5793328.610099999,4455275.264899999 5793328.6169,4455275.260099999 5793328.627,4455275.2483 5793328.644899999,4455275.236399999 5793328.665699999,4455275.2494 5793328.703199999,4455275.268299999 5793328.727299999,4455275.281299999 5793328.757099999,4455275.297199999 5793328.777899999,4455275.3289 5793328.8112,4455275.3518 5793328.850099999,4455275.3568 5793328.8561,4455275.375599999 5793328.870899999,4455275.3925 5793328.889699999,4455275.4312 5793328.921299999,4455275.4341 5793328.923299999,4455275.443099999 5793328.940099999,4455275.455 5793328.955,4455275.5388 5793329.0281,4455275.583999999 5793329.049599999,4455275.6216 5793329.0512,4455275.6414 5793329.055999999,4455275.654099999 5793329.0515)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (123,123,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',4.02633067385,1.02405119016,0.809132832136,2.10374536355,1, ST_GeomFromText('MULTIPOLYGON(((4455272.035 5793329.051999999,4455272.0652 5793329.0501,4455272.092899999 5793329.047,4455272.118499999 5793329.042899999,4455272.1458 5793329.047,4455272.1814 5793329.031099999,4455272.209499999 5793329.0335,4455272.237099999 5793329.027499999,4455272.258899999 5793329.022399999,4455272.287499999 5793329.013299999,4455272.3013 5793329.010299999,4455272.328999999 5793329.0042,4455272.3468 5793328.999199999,4455272.372499999 5793328.9921,4455272.3912 5793328.985099999,4455272.4159 5793328.978,4455272.4396 5793328.97,4455272.458399999 5793328.9649,4455272.49 5793328.9558,4455272.506799999 5793328.948799999,4455272.5295 5793328.9418,4455272.5482 5793328.9337,4455272.571899999 5793328.925699999,4455272.5887 5793328.9187,4455272.6094 5793328.911599999,4455272.6292 5793328.901599999,4455272.6418 5793328.8956,4455272.6489 5793328.8836,4455272.6528 5793328.858799999,4455272.6675 5793328.834899999,4455272.6704 5793328.816999999,4455272.6763 5793328.794099999,4455272.682099999 5793328.7682,4455272.685999999 5793328.7454,4455272.6889 5793328.7255,4455272.694699999 5793328.7036,4455272.7016 5793328.684699999,4455272.706399999 5793328.6618,4455272.7103 5793328.633999999,4455272.712199999 5793328.6082,4455272.7141 5793328.582299999,4455272.714999999 5793328.5545,4455272.712899999 5793328.525699999,4455272.7158 5793328.5029,4455272.7137 5793328.4711,4455272.710599999 5793328.4482,4455272.7059 5793328.422,4455272.695399999 5793328.3826,4455272.6692 5793328.332399999,4455272.632799999 5793328.2868,4455272.584699999 5793328.2616,4455272.542799999 5793328.2517,4455272.5142 5793328.250399999,4455272.475599999 5793328.2476,4455272.4479 5793328.2477,4455272.416299999 5793328.2508,4455272.391599999 5793328.2539,4455272.360899999 5793328.255999999,4455272.3273 5793328.2572,4455272.300599999 5793328.260299999,4455272.269999999 5793328.261399999,4455272.2443 5793328.263499999,4455272.214599999 5793328.264599999,4455272.183 5793328.265699999,4455272.1573 5793328.269799999,4455272.1286 5793328.269899999,4455272.097 5793328.2681,4455272.0683 5793328.271199999,4455272.040699999 5793328.275299999,4455272.010999999 5793328.275399999,4455271.985299999 5793328.277499999,4455271.9517 5793328.279699999,4455271.925999999 5793328.2817,4455271.896399999 5793328.2849,4455271.863699999 5793328.287,4455271.843 5793328.2871,4455271.803 5793328.289599999,4455271.7807 5793328.294299999,4455271.751099999 5793328.296399999,4455271.725399999 5793328.299499999,4455271.699699999 5793328.3026,4455271.673 5793328.3057,4455271.6512 5793328.3068,4455271.614699999 5793328.3109,4455271.583999999 5793328.313999999,4455271.559299999 5793328.316099999,4455271.5257 5793328.318199999,4455271.498999999 5793328.320299999,4455271.4724 5793328.3264,4455271.4477 5793328.331499999,4455271.388 5793328.345599999,4455271.3706 5793328.357699999,4455271.3578 5793328.3726,4455271.3431 5793328.3846,4455271.3332 5793328.401499999,4455271.3234 5793328.4254,4455271.317599999 5793328.4473,4455271.3107 5793328.4702,4455271.304899999 5793328.489099999,4455271.3059 5793328.493,4455271.299999999 5793328.519899999,4455271.2971 5793328.541799999,4455271.2942 5793328.5537,4455271.2904 5793328.584499999,4455271.287499999 5793328.604399999,4455271.283599999 5793328.633199999,4455271.2807 5793328.6511,4455271.276899999 5793328.676899999,4455271.270999999 5793328.7038,4455271.2751 5793328.7256,4455271.268199999 5793328.7465,4455271.264399999 5793328.7793,4455271.2625 5793328.796199999,4455271.2586 5793328.8211,4455271.255699999 5793328.8439,4455271.252799999 5793328.869799999,4455271.2509 5793328.889599999,4455271.2481 5793328.9185,4455271.246199999 5793328.943299999,4455271.2443 5793328.9701,4455271.2437 5793328.9956,4455271.253399999 5793329.0098,4455271.2783 5793329.0184,4455271.313799999 5793329.0197,4455271.337399999 5793329.0214,4455271.3661 5793329.021299999,4455271.413999999 5793329.023199999,4455271.447999999 5793329.0284,4455271.483 5793329.0291,4455271.519399999 5793329.029699999,4455271.5564 5793329.041699999,4455271.584699999 5793329.0412,4455271.6084 5793329.043099999,4455271.6533 5793329.042799999,4455271.718299999 5793329.0445,4455271.7494 5793329.0459,4455271.777499999 5793329.0493,4455271.8101 5793329.0502,4455271.835799999 5793329.051,4455271.8831 5793329.0544,4455271.9182 5793329.0478,4455271.9296 5793329.0557,4455271.951299999 5793329.056299999,4455271.9713 5793329.0534,4455271.992999999 5793329.055299999,4455272.011699999 5793329.058399999,4455272.035 5793329.051999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (124,124,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Kammerstein','Kammerstein','NULL',2.25761840749,0.341623144965,0.286119978301,0.743911943584,1, ST_GeomFromText('MULTIPOLYGON(((4455274.6593 5793329.064799999,4455274.685899999 5793329.061499999,4455274.709599999 5793329.054999999,4455274.7307 5793329.0515,4455274.748399999 5793329.0504,4455274.7653 5793329.047399999,4455274.778099999 5793329.037399999,4455274.797799999 5793329.0294,4455274.816599999 5793329.022299999,4455274.838299999 5793329.013299999,4455274.859 5793329.0062,4455274.880699999 5793328.9962,4455274.901499999 5793328.989199999,4455274.9232 5793328.978099999,4455274.9429 5793328.966099999,4455274.964599999 5793328.955099999,4455274.975499999 5793328.950099999,4455274.981399999 5793328.9382,4455274.980399999 5793328.930199999,4455274.985199999 5793328.9153,4455274.984199999 5793328.910299999,4455274.988099999 5793328.8855,4455274.995299999 5793328.873099999,4455274.992999999 5793328.8606,4455274.996799999 5793328.8417,4455275.010599999 5793328.814899999,4455275.005599999 5793328.798,4455275.0124 5793328.7761,4455275.0173 5793328.751199999,4455275.0202 5793328.7254,4455275.024199999 5793328.706399999,4455275.021499999 5793328.671399999,4455275.0109 5793328.6455,4455274.991299999 5793328.6215,4455274.950199999 5793328.592199999,4455274.9155 5793328.580199999,4455274.868999999 5793328.575999999,4455274.8322 5793328.5756,4455274.800099999 5793328.570599999,4455274.764399999 5793328.571,4455274.740199999 5793328.5774,4455274.728 5793328.572499999,4455274.715099999 5793328.575699999,4455274.6884 5793328.5778,4455274.6485 5793328.574999999,4455274.618999999 5793328.5842,4455274.600499999 5793328.5832,4455274.5738 5793328.5843,4455274.544099999 5793328.5894,4455274.5184 5793328.591499999,4455274.4888 5793328.5985,4455274.4641 5793328.6026,4455274.439399999 5793328.606699999,4455274.415699999 5793328.6118,4455274.385099999 5793328.619899999,4455274.364299999 5793328.6279,4455274.3446 5793328.6359,4455274.3238 5793328.644999999,4455274.2982 5793328.654999999,4455274.2844 5793328.664,4455274.261699999 5793328.677999999,4455274.2489 5793328.694,4455274.238099999 5793328.712899999,4455274.2285 5793328.7222,4455274.224299999 5793328.7378,4455274.2214 5793328.7418,4455274.2224 5793328.7576,4455274.2185 5793328.767599999,4455274.219499999 5793328.7805,4455274.2147 5793328.8014,4455274.216699999 5793328.8054,4455274.2138 5793328.831199999,4455274.208899999 5793328.8362,4455274.213899999 5793328.858999999,4455274.2169 5793328.8858,4455274.222 5793328.915599999,4455274.221099999 5793328.9414,4455274.224 5793328.9613,4455274.216699999 5793328.991399999,4455274.239799999 5793329.030099999,4455274.2856 5793329.0491,4455274.315399999 5793329.0503,4455274.3293 5793329.0602,4455274.336199999 5793329.0611,4455274.356999999 5793329.0591,4455274.4023 5793329.062999999,4455274.435899999 5793329.058399999,4455274.462799999 5793329.063599999,4455274.492399999 5793329.0644,4455274.5312 5793329.066999999,4455274.556699999 5793329.0642,4455274.5854 5793329.062999999,4455274.629999999 5793329.0675,4455274.6593 5793329.064799999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (125,125,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Zwickelmauerwerk','Stein','NULL',0.790223508223,0.0318424000098,0.0487040153675,0.126630439956,1, ST_GeomFromText('MULTIPOLYGON(((4455274.103 5793329.095399999,4455274.111999999 5793329.0721,4455274.112599999 5793329.065099999,4455274.1199 5793329.053099999,4455274.125799999 5793329.0305,4455274.138299999 5793329.014299999,4455274.138299999 5793329.010299999,4455274.1491 5793328.9974,4455274.156999999 5793328.9963,4455274.157999999 5793328.979499999,4455274.1648 5793328.9743,4455274.1704 5793328.9627,4455274.1764 5793328.955099999,4455274.178299999 5793328.946399999,4455274.1842 5793328.932199999,4455274.1831 5793328.9163,4455274.183899999 5793328.903999999,4455274.172 5793328.88,4455274.151899999 5793328.842,4455274.116299999 5793328.8058,4455274.098 5793328.7949,4455274.090099999 5793328.8079,4455274.093399999 5793328.8177,4455274.086699999 5793328.8242,4455274.0832 5793328.833599999,4455274.0789 5793328.8464,4455274.072499999 5793328.855599999,4455274.072499999 5793328.8596,4455274.0617 5793328.8706,4455274.0617 5793328.8746,4455274.048899999 5793328.888499999,4455274.0371 5793328.901499999,4455274.033099999 5793328.901499999,4455274.0218 5793328.912499999,4455274.003499999 5793328.9295,4455274.000599999 5793328.9305,4455273.996899999 5793328.952099999,4455273.994099999 5793328.9711,4455274.000799999 5793328.9911,4455274.009499999 5793328.9907,4455274.0175 5793328.993499999,4455274.042899999 5793329.014399999,4455274.047399999 5793329.0207,4455274.038499999 5793329.0316,4455274.0584 5793329.0633,4455274.0564 5793329.071299999,4455274.061499999 5793329.100099999,4455274.082299999 5793329.1026,4455274.103 5793329.095399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (126,126,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Zwickelmauerwerk','Stein','NULL',1.26693565221,0.0938636499754,0.0962371013412,0.250216463487,1, ST_GeomFromText('MULTIPOLYGON(((4455273.5151 5793329.2057,4455273.5151 5793329.200799999,4455273.524 5793329.1918,4455273.5295 5793329.1894,4455273.535799999 5793329.1838,4455273.565799999 5793329.141799999,4455273.582299999 5793329.124399999,4455273.5915 5793329.104299999,4455273.6096 5793329.089099999,4455273.613499999 5793329.069199999,4455273.6238 5793329.0522,4455273.631699999 5793329.030899999,4455273.639 5793329.0061,4455273.641499999 5793328.9835,4455273.627799999 5793328.9481,4455273.620099999 5793328.9394,4455273.6078 5793328.9162,4455273.603099999 5793328.906199999,4455273.6029 5793328.876499999,4455273.6089 5793328.8715,4455273.605399999 5793328.8639,4455273.6083 5793328.858599999,4455273.6176 5793328.8407,4455273.628499999 5793328.825799999,4455273.6255 5793328.815799999,4455273.6314 5793328.803099999,4455273.6381 5793328.7761,4455273.6364 5793328.7659,4455273.6271 5793328.7543,4455273.618099999 5793328.7497,4455273.600399999 5793328.747999999,4455273.585099999 5793328.7485,4455273.553799999 5793328.762,4455273.532499999 5793328.769999999,4455273.520499999 5793328.771999999,4455273.510099999 5793328.776799999,4455273.492899999 5793328.7881,4455273.478799999 5793328.802899999,4455273.4643 5793328.817099999,4455273.453499999 5793328.830499999,4455273.443599999 5793328.8405,4455273.435399999 5793328.842199999,4455273.422299999 5793328.8572,4455273.408499999 5793328.8726,4455273.393 5793328.885199999,4455273.3759 5793328.898399999,4455273.360799999 5793328.9108,4455273.3464 5793328.9239,4455273.3354 5793328.944,4455273.330099999 5793328.952099999,4455273.3271 5793328.9622,4455273.315499999 5793328.980699999,4455273.312699999 5793329.0021,4455273.312699999 5793329.0273,4455273.321 5793329.0426,4455273.329199999 5793329.061699999,4455273.3391 5793329.0745,4455273.3706 5793329.095599999,4455273.387199999 5793329.100999999,4455273.392199999 5793329.1059,4455273.407999999 5793329.117799999,4455273.428899999 5793329.130899999,4455273.449099999 5793329.147199999,4455273.4643 5793329.1599,4455273.4844 5793329.183,4455273.4845 5793329.200899999,4455273.501299999 5793329.210799999,4455273.5151 5793329.2057)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (127,127,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Zwickelmauerwerk','Stein','NULL',0.940734284374,0.044791544901,0.0586282400121,0.152433424032,1, ST_GeomFromText('MULTIPOLYGON(((4455273.7844 5793329.302899999,4455273.7953 5793329.300899999,4455273.810899999 5793329.289999999,4455273.836199999 5793329.2847,4455273.8539 5793329.271299999,4455273.8662 5793329.267599999,4455273.8742 5793329.2618,4455273.8792 5793329.2618,4455273.8831 5793329.244899999,4455273.8821 5793329.2409,4455273.888899999 5793329.222999999,4455273.899699999 5793329.21,4455273.9165 5793329.198999999,4455273.9323 5793329.198,4455273.938199999 5793329.194,4455273.966199999 5793329.192099999,4455273.9649 5793329.1819,4455273.972699999 5793329.164,4455273.9846 5793329.156999999,4455273.981399999 5793329.144099999,4455273.989299999 5793329.129399999,4455273.9899 5793329.119599999,4455273.995699999 5793329.109799999,4455273.9992 5793329.0874,4455273.999099999 5793329.083499999,4455274.007 5793329.068499999,4455274.004999999 5793329.060599999,4455274.0109 5793329.047599999,4455274.008899999 5793329.036699999,4455274.0148 5793329.0238,4455273.9998 5793329.001,4455273.9791 5793329.012,4455273.9648 5793329.0152,4455273.950699999 5793329.0228,4455273.9368 5793329.0324,4455273.893199999 5793329.049,4455273.875199999 5793329.0599,4455273.8558 5793329.07,4455273.839999999 5793329.078199999,4455273.8183 5793329.081199999,4455273.8106 5793329.084799999,4455273.8047 5793329.095399999,4455273.8035 5793329.1062,4455273.7926 5793329.1201,4455273.7838 5793329.138,4455273.773 5793329.154999999,4455273.756199999 5793329.165999999,4455273.7483 5793329.1729,4455273.748399999 5793329.188799999,4455273.734799999 5793329.206599999,4455273.736899999 5793329.229499999,4455273.7328 5793329.250499999,4455273.7388 5793329.260399999,4455273.734799999 5793329.2694,4455273.7399 5793329.2739,4455273.7455 5793329.286699999,4455273.7586 5793329.3023,4455273.7785 5793329.3069,4455273.7844 5793329.302899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (128,128,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',3.0861244164,0.685412284932,0.549599975172,1.42895993545,1, ST_GeomFromText('MULTIPOLYGON(((4455286.879399999 5793329.3131,4455286.908999999 5793329.307,4455286.9318 5793329.298,4455286.954499999 5793329.286,4455286.9692 5793329.275,4455286.983 5793329.263,4455286.9978 5793329.2441,4455287.0096 5793329.2321,4455287.0274 5793329.215099999,4455287.0392 5793329.1962,4455287.049999999 5793329.1763,4455287.062699999 5793329.158299999,4455287.0716 5793329.147399999,4455287.082399999 5793329.128499999,4455287.0932 5793329.1125,4455287.105999999 5793329.0916,4455287.1129 5793329.0777,4455287.120699999 5793329.0558,4455287.130599999 5793329.0438,4455287.1491 5793329.026399999,4455287.1522 5793329.0129,4455287.1551 5793328.998999999,4455287.16 5793328.9821,4455287.1659 5793328.9612,4455287.172699999 5793328.943299999,4455287.1786 5793328.9184,4455287.1864 5793328.8975,4455287.190299999 5793328.8737,4455287.1922 5793328.8518,4455287.194 5793328.823,4455287.194899999 5793328.796199999,4455287.194799999 5793328.7694,4455287.193799999 5793328.7445,4455287.188699999 5793328.711799999,4455287.1846 5793328.682,4455287.180599999 5793328.657899999,4455287.1726 5793328.6303,4455287.1606 5793328.615199999,4455287.153099999 5793328.5808,4455287.1419 5793328.541699999,4455287.1266 5793328.500399999,4455287.106999999 5793328.4602,4455287.082399999 5793328.4287,4455286.961099999 5793328.2992,4455286.821899999 5793328.1741,4455286.767799999 5793328.132999999,4455286.717199999 5793328.1173,4455286.680599999 5793328.121099999,4455286.664599999 5793328.130899999,4455286.6458 5793328.1389,4455286.6281 5793328.154899999,4455286.614299999 5793328.1688,4455286.599499999 5793328.1848,4455286.5848 5793328.199799999,4455286.5749 5793328.211699999,4455286.557199999 5793328.231699999,4455286.547399999 5793328.2466,4455286.5356 5793328.263599999,4455286.5208 5793328.2825,4455286.508999999 5793328.3014,4455286.4982 5793328.320299999,4455286.4894 5793328.3373,4455286.4795 5793328.3552,4455286.4697 5793328.371099999,4455286.4599 5793328.3891,4455286.4511 5793328.408999999,4455286.4422 5793328.426899999,4455286.4324 5793328.4458,4455286.4236 5793328.4677,4455286.416699999 5793328.4886,4455286.410899999 5793328.5095,4455286.404 5793328.535299999,4455286.4012 5793328.558199999,4455286.4012 5793328.581,4455286.3994 5793328.6049,4455286.3994 5793328.630699999,4455286.402499999 5793328.6575,4455286.403599999 5793328.6863,4455286.4057 5793328.714099999,4455286.4078 5793328.743899999,4455286.4128 5793328.7707,4455286.410799999 5793328.7935,4455286.423 5793328.8518,4455286.4252 5793328.887399999,4455286.433199999 5793328.923699999,4455286.445899999 5793328.966399999,4455286.454099999 5793329.0018,4455286.468399999 5793329.0324,4455286.4978 5793329.0679,4455286.574699999 5793329.1311,4455286.6319 5793329.1695,4455286.6852 5793329.199799999,4455286.788499999 5793329.292199999,4455286.8524 5793329.317299999,4455286.879399999 5793329.3131)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (129,129,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Kammerstein','Kammerstein','NULL',2.92606834759,0.430730734998,0.354412035302,0.921471291786,1, ST_GeomFromText('MULTIPOLYGON(((4455282.8876 5793329.7267,4455282.910299999 5793329.719599999,4455282.9281 5793329.7116,4455282.949799999 5793329.7006,4455282.973199999 5793329.6962,4455282.9834 5793329.683499999,4455282.986299999 5793329.6796,4455283.004099999 5793329.6666,4455283.018899999 5793329.659499999,4455283.0416 5793329.6465,4455283.0613 5793329.637499999,4455283.0771 5793329.6315,4455283.099799999 5793329.6195,4455283.1156 5793329.6015,4455283.128299999 5793329.5786,4455283.132199999 5793329.5548,4455283.1331 5793329.5259,4455283.132 5793329.500099999,4455283.1319 5793329.4743,4455283.132799999 5793329.4514,4455283.1347 5793329.4296,4455283.130699999 5793329.394799999,4455283.130599999 5793329.367,4455283.1255 5793329.340199999,4455283.122499999 5793329.3154,4455283.1253 5793329.289499999,4455283.126199999 5793329.263699999,4455283.126099999 5793329.236899999,4455283.124099999 5793329.2111,4455283.123999999 5793329.1872,4455283.1239 5793329.1574,4455283.1238 5793329.1326,4455283.1277 5793329.1107,4455283.135499999 5793329.0918,4455283.1424 5793329.0799,4455283.155199999 5793329.0599,4455283.163999999 5793329.043999999,4455283.176799999 5793329.0271,4455283.191599999 5793329.012099999,4455283.203399999 5793328.997099999,4455283.2125 5793328.9879,4455283.2152 5793328.977199999,4455283.23 5793328.965199999,4455283.239799999 5793328.946299999,4455283.250599999 5793328.9284,4455283.2614 5793328.9055,4455283.267199999 5793328.8846,4455283.273099999 5793328.8657,4455283.274 5793328.837899999,4455283.273599999 5793328.8113,4455283.268799999 5793328.7806,4455283.2569 5793328.763499999,4455283.256799999 5793328.745899999,4455283.246 5793328.7312,4455283.2301 5793328.690899999,4455283.2088 5793328.648399999,4455283.187599999 5793328.6234,4455283.16 5793328.606899999,4455283.137699999 5793328.606,4455283.1051 5793328.604199999,4455283.0842 5793328.5973,4455283.067499999 5793328.603299999,4455283.041799999 5793328.605399999,4455283.0092 5793328.608599999,4455282.9835 5793328.6116,4455282.950899999 5793328.610799999,4455282.922199999 5793328.6129,4455282.8886 5793328.612999999,4455282.859899999 5793328.615199999,4455282.831299999 5793328.616299999,4455282.8046 5793328.6214,4455282.782899999 5793328.626399999,4455282.753299999 5793328.6424,4455282.741499999 5793328.662399999,4455282.7406 5793328.6862,4455282.7367 5793328.7091,4455282.733799999 5793328.736899999,4455282.729899999 5793328.756799999,4455282.724999999 5793328.7638,4455282.730999999 5793328.7846,4455282.7311 5793328.8134,4455282.7312 5793328.8372,4455282.726499999 5793328.857699999,4455282.7273 5793328.888499999,4455282.7335 5793328.925599999,4455282.733599999 5793328.9505,4455282.734699999 5793328.9682,4455282.7416 5793328.9822,4455282.7268 5793328.9942,4455282.733799999 5793329.010099999,4455282.735899999 5793329.0349,4455282.7368 5793329.0546,4455282.737999999 5793329.0876,4455282.739099999 5793329.1124,4455282.739199999 5793329.1442,4455282.7423 5793329.164,4455282.741399999 5793329.189899999,4455282.737399999 5793329.1958,4455282.7444 5793329.2147,4455282.7465 5793329.240499999,4455282.7476 5793329.2673,4455282.7503 5793329.2923,4455282.758 5793329.3167,4455282.7741 5793329.338099999,4455282.809399999 5793329.3967,4455282.8271 5793329.4309,4455282.8388 5793329.4645,4455282.8463 5793329.5083,4455282.8474 5793329.534099999,4455282.8475 5793329.56,4455282.8486 5793329.5927,4455282.847699999 5793329.6225,4455282.848799999 5793329.6444,4455282.844899999 5793329.669199999,4455282.843 5793329.6951,4455282.8448 5793329.710599999,4455282.854 5793329.7221,4455282.8704 5793329.728499999,4455282.8876 5793329.7267)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (130,130,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',0.0630082494715,0.000132125001265,0.024401260601,0.0634432775625,1, ST_GeomFromText('MULTIPOLYGON(((4455287.211 5793330.1271,4455287.219399999 5793330.114299999,4455287.204099999 5793330.1216,4455287.1977 5793330.135299999,4455287.211 5793330.1271)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (131,131,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',2.59886803803,0.503512355055,0.410191868914,1.06649885918,1, ST_GeomFromText('MULTIPOLYGON(((4455287.0207 5793330.252499999,4455287.041899999 5793330.2423,4455287.062599999 5793330.236199999,4455287.086299999 5793330.2222,4455287.1198 5793330.195199999,4455287.1346 5793330.1842,4455287.1524 5793330.170299999,4455287.1721 5793330.1563,4455287.185899999 5793330.1443,4455287.1977 5793330.135299999,4455287.204099999 5793330.1216,4455287.219399999 5793330.114299999,4455287.2312 5793330.102399999,4455287.2421 5793330.093399999,4455287.2559 5793330.0764,4455287.271599999 5793330.0634,4455287.292299999 5793330.046499999,4455287.3041 5793330.0315,4455287.316899999 5793330.0205,4455287.3337 5793329.9986,4455287.3435 5793329.979699999,4455287.3523 5793329.958799999,4455287.358199999 5793329.9339,4455287.362999999 5793329.914,4455287.3649 5793329.8803,4455287.3618 5793329.8515,4455287.3558 5793329.813699999,4455287.353699999 5793329.782899999,4455287.3446 5793329.7452,4455287.3327 5793329.7125,4455287.3256 5793329.6773,4455287.2993 5793329.634899999,4455287.285699999 5793329.600899999,4455287.270499999 5793329.5844,4455287.2602 5793329.550699999,4455287.247999999 5793329.536199999,4455287.2231 5793329.488299999,4455287.193799999 5793329.458399999,4455287.1632 5793329.411299999,4455287.1217 5793329.3659,4455287.0822 5793329.3421,4455287.049599999 5793329.338199999,4455287.012 5793329.3364,4455286.9764 5793329.3355,4455286.948699999 5793329.3386,4455286.9171 5793329.346699999,4455286.898299999 5793329.3548,4455286.874599999 5793329.3638,4455286.8529 5793329.3758,4455286.831199999 5793329.3868,4455286.8145 5793329.3978,4455286.795699999 5793329.4108,4455286.7799 5793329.4208,4455286.768099999 5793329.426799999,4455286.746399999 5793329.440799999,4455286.7286 5793329.450899999,4455286.7099 5793329.462899999,4455286.692099999 5793329.474899999,4455286.673399999 5793329.4879,4455286.6566 5793329.4989,4455286.649199999 5793329.508799999,4455286.649 5793329.523099999,4455286.6424 5793329.542099999,4455286.6469 5793329.5545,4455286.6451 5793329.565899999,4455286.6353 5793329.5763,4455286.635599999 5793329.582399999,4455286.6402 5793329.591299999,4455286.6412 5793329.6072,4455286.6423 5793329.63,4455286.6414 5793329.657899999,4455286.641499999 5793329.6837,4455286.640599999 5793329.7125,4455286.6397 5793329.738299999,4455286.6408 5793329.7661,4455286.639899999 5793329.789999999,4455286.639999999 5793329.8168,4455286.6391 5793329.8397,4455286.636199999 5793329.8635,4455286.6343 5793329.8933,4455286.6364 5793329.920099999,4455286.6392 5793329.9425,4455286.658999999 5793329.9898,4455286.683799999 5793330.0225,4455286.762699999 5793330.106399999,4455286.82 5793330.1523,4455286.8666 5793330.179199999,4455286.929399999 5793330.232,4455286.9877 5793330.254399999,4455287.0207 5793330.252499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (132,132,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Kammerstein','Kammerstein','NULL',1.66637629568,0.175682975019,0.158943432054,0.413252923342,1, ST_GeomFromText('MULTIPOLYGON(((4455280.144199999 5793330.584899999,4455280.173799999 5793330.5828,4455280.1906 5793330.5767,4455280.227199999 5793330.5766,4455280.256799999 5793330.573499999,4455280.2855 5793330.570399999,4455280.319099999 5793330.5712,4455280.347799999 5793330.569099999,4455280.368499999 5793330.572499999,4455280.383399999 5793330.5689,4455280.411 5793330.5678,4455280.442699999 5793330.5667,4455280.470399999 5793330.5646,4455280.495099999 5793330.560499999,4455280.5207 5793330.5515,4455280.5415 5793330.5434,4455280.563199999 5793330.534399999,4455280.5908 5793330.5263,4455280.607599999 5793330.5203,4455280.633299999 5793330.5063,4455280.647099999 5793330.4973,4455280.6698 5793330.4823,4455280.674599999 5793330.4534,4455280.6776 5793330.4495,4455280.6785 5793330.443499999,4455280.674499999 5793330.4276,4455280.674399999 5793330.403799999,4455280.6743 5793330.376,4455280.671299999 5793330.3482,4455280.6732 5793330.328299999,4455280.6802 5793330.3058,4455280.673 5793330.267899999,4455280.663099999 5793330.2518,4455280.630199999 5793330.2344,4455280.590699999 5793330.228,4455280.5469 5793330.2222,4455280.516699999 5793330.218499999,4455280.492899999 5793330.219799999,4455280.4652 5793330.222899999,4455280.441499999 5793330.228,4455280.416799999 5793330.232,4455280.392099999 5793330.238099999,4455280.3684 5793330.2452,4455280.342699999 5793330.250199999,4455280.314 5793330.2573,4455280.2933 5793330.264399999,4455280.267599999 5793330.273399999,4455280.2449 5793330.2805,4455280.217299999 5793330.286499999,4455280.1945 5793330.2936,4455280.172799999 5793330.300599999,4455280.1511 5793330.3067,4455280.1244 5793330.314799999,4455280.107699999 5793330.3267,4455280.093999999 5793330.3363,4455280.0919 5793330.353599999,4455280.092 5793330.378499999,4455280.0941 5793330.4063,4455280.092199999 5793330.428099999,4455280.0886 5793330.4428,4455280.0963 5793330.460899999,4455280.095399999 5793330.4867,4455280.094499999 5793330.513599999,4455280.097599999 5793330.545299999,4455280.096699999 5793330.5646,4455280.106399999 5793330.580399999,4455280.1226 5793330.5874,4455280.144199999 5793330.584899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (133,133,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',0.0733997240637,0.000267589993091,0.0245050809707,0.0637132105238,1, ST_GeomFromText('MULTIPOLYGON(((4455284.6873 5793330.674699999,4455284.685499999 5793330.6696,4455284.6759 5793330.6588,4455284.672399999 5793330.6577,4455284.6676 5793330.6588,4455284.6699 5793330.669999999,4455284.6874 5793330.6851,4455284.6873 5793330.674699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (134,134,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Kammerstein','Kammerstein','NULL',3.86556733087,1.08967945491,0.85943033424,2.23451886902,1, ST_GeomFromText('MULTIPOLYGON(((4455273.5562 5793330.7464,4455273.5651 5793330.748299999,4455273.5898 5793330.7442,4455273.602699999 5793330.748099999,4455273.612599999 5793330.7421,4455273.6402 5793330.739,4455273.6639 5793330.733999999,4455273.688599999 5793330.7299,4455273.7114 5793330.7258,4455273.741 5793330.718699999,4455273.761699999 5793330.711699999,4455273.773599999 5793330.7116,4455273.783499999 5793330.7037,4455273.806699999 5793330.6971,4455273.8239 5793330.6816,4455273.845599999 5793330.6696,4455273.861399999 5793330.6546,4455273.8782 5793330.641699999,4455273.889999999 5793330.627699999,4455273.9038 5793330.6117,4455273.918499999 5793330.597799999,4455273.9313 5793330.5808,4455273.9461 5793330.561899999,4455273.9559 5793330.5459,4455273.9648 5793330.529999999,4455273.975599999 5793330.512099999,4455273.9824 5793330.4952,4455273.991299999 5793330.477299999,4455273.999099999 5793330.457299999,4455274.003999999 5793330.435499999,4455274.0093 5793330.416999999,4455274.0097 5793330.380799999,4455274.010599999 5793330.356,4455274.0085 5793330.329199999,4455274.0065 5793330.3023,4455274.000099999 5793330.2795,4455273.9966 5793330.244999999,4455273.990899999 5793330.214999999,4455273.985199999 5793330.168299999,4455273.9822 5793330.139499999,4455273.976099999 5793330.1107,4455273.9697 5793330.083399999,4455273.968399999 5793330.0581,4455273.959999999 5793330.0164,4455273.9549 5793329.9896,4455273.954099999 5793329.970499999,4455273.9434 5793329.9295,4455273.9325 5793329.8968,4455273.930599999 5793329.8702,4455273.9153 5793329.822499999,4455273.9115 5793329.7926,4455273.902099999 5793329.7674,4455273.889999999 5793329.7561,4455273.8793 5793329.7045,4455273.8682 5793329.685699999,4455273.8552 5793329.6545,4455273.838399999 5793329.626599999,4455273.8178 5793329.5896,4455273.8009 5793329.555299999,4455273.778699999 5793329.5273,4455273.759899999 5793329.502199999,4455273.732599999 5793329.48,4455273.727699999 5793329.48,4455273.708899999 5793329.465199999,4455273.692999999 5793329.4513,4455273.6692 5793329.4326,4455273.646399999 5793329.4207,4455273.623599999 5793329.414899999,4455273.6187 5793329.414899999,4455273.6002 5793329.413799999,4455273.591 5793329.407099999,4455273.580099999 5793329.408099999,4455273.5771 5793329.4052,4455273.5564 5793329.400299999,4455273.5376 5793329.4013,4455273.533599999 5793329.399399999,4455273.509899999 5793329.3975,4455273.5069 5793329.399499999,4455273.478299999 5793329.4011,4455273.4565 5793329.400699999,4455273.448599999 5793329.4067,4455273.4269 5793329.4108,4455273.4209 5793329.4088,4455273.4062 5793329.4188,4455273.381 5793329.421399999,4455273.354299999 5793329.4349,4455273.339999999 5793329.4449,4455273.3183 5793329.449999999,4455273.314299999 5793329.4569,4455273.300499999 5793329.4699,4455273.281799999 5793329.481899999,4455273.269 5793329.485999999,4455273.2631 5793329.493899999,4455273.2483 5793329.505899999,4455273.232499999 5793329.517899999,4455273.217699999 5793329.529899999,4455273.2 5793329.5478,4455273.1862 5793329.5598,4455273.1714 5793329.5688,4455273.152599999 5793329.5828,4455273.0992 5793329.6212,4455273.066899999 5793329.6607,4455273.047199999 5793329.674699999,4455273.042299999 5793329.6826,4455273.032399999 5793329.698599999,4455273.0207 5793329.721499999,4455273.0157 5793329.730399999,4455273.0207 5793329.7443,4455273.0179 5793329.7682,4455273.014 5793329.792999999,4455273.011099999 5793329.814899999,4455273.0092 5793329.8427,4455273.008299999 5793329.8695,4455273.009399999 5793329.8944,4455273.004499999 5793329.911699999,4455273.0102 5793329.9414,4455273.005199999 5793329.9671,4455273.007799999 5793329.9877,4455273.0157 5793330.005599999,4455273.0148 5793330.0314,4455273.014899999 5793330.058299999,4455273.016999999 5793330.0831,4455273.0153 5793330.1039,4455273.0137 5793330.1322,4455273.0191 5793330.156099999,4455273.0274 5793330.193499999,4455273.0338 5793330.2233,4455273.037999999 5793330.255,4455273.047399999 5793330.2905,4455273.0701 5793330.381999999,4455273.072599999 5793330.392899999,4455273.0783 5793330.4162,4455273.085799999 5793330.459,4455273.094299999 5793330.4867,4455273.1008 5793330.5205,4455273.114799999 5793330.565999999,4455273.1248 5793330.594,4455273.137 5793330.6106,4455273.1775 5793330.660399999,4455273.231499999 5793330.7005,4455273.243999999 5793330.699999999,4455273.2702 5793330.716099999,4455273.299899999 5793330.7257,4455273.319799999 5793330.728299999,4455273.3513 5793330.7235,4455273.3589 5793330.732999999,4455273.3722 5793330.7385,4455273.394 5793330.737099999,4455273.416799999 5793330.74,4455273.4763 5793330.7506,4455273.5009 5793330.7476,4455273.5295 5793330.749399999,4455273.532499999 5793330.752399999,4455273.5562 5793330.7464)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (135,135,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Kammerstein','Kammerstein','NULL',2.43076515891,0.393810559878,0.32611641309,0.847902674035,1, ST_GeomFromText('MULTIPOLYGON(((4455279.232499999 5793330.830199999,4455279.2651 5793330.830099999,4455279.292799999 5793330.826999999,4455279.309999999 5793330.829399999,4455279.328399999 5793330.824799999,4455279.3491 5793330.821799999,4455279.3798 5793330.8167,4455279.4055 5793330.813599999,4455279.4292 5793330.807499999,4455279.4548 5793330.8024,4455279.477599999 5793330.796399999,4455279.5032 5793330.7903,4455279.526999999 5793330.783199999,4455279.5546 5793330.7772,4455279.576299999 5793330.7661,4455279.5931 5793330.759099999,4455279.615799999 5793330.748099999,4455279.635599999 5793330.7401,4455279.654299999 5793330.728,4455279.673 5793330.719,4455279.6928 5793330.707,4455279.708599999 5793330.696,4455279.728299999 5793330.680999999,4455279.7421 5793330.6651,4455279.752899999 5793330.6521,4455279.7696 5793330.637199999,4455279.7834 5793330.6202,4455279.795199999 5793330.605299999,4455279.810999999 5793330.590299999,4455279.8278 5793330.578299999,4455279.8327 5793330.5763,4455279.8386 5793330.566299999,4455279.850399999 5793330.549399999,4455279.8671 5793330.5294,4455279.872999999 5793330.523499999,4455279.867999999 5793330.503599999,4455279.8699 5793330.474799999,4455279.852099999 5793330.459,4455279.841099999 5793330.4471,4455279.8243 5793330.432299999,4455279.819299999 5793330.4293,4455279.8113 5793330.409499999,4455279.7975 5793330.3956,4455279.787499999 5793330.3857,4455279.7538 5793330.360099999,4455279.732099999 5793330.3582,4455279.716199999 5793330.3483,4455279.696399999 5793330.3384,4455279.6796 5793330.333599999,4455279.6737 5793330.334599999,4455279.624099999 5793330.2901,4455279.603199999 5793330.2763,4455279.566599999 5793330.253799999,4455279.5224 5793330.239499999,4455279.486399999 5793330.2311,4455279.460699999 5793330.2332,4455279.434 5793330.2353,4455279.405399999 5793330.2423,4455279.3837 5793330.252399999,4455279.362999999 5793330.262399999,4455279.346199999 5793330.2714,4455279.326399999 5793330.2814,4455279.3047 5793330.2925,4455279.2899 5793330.299499999,4455279.273199999 5793330.310499999,4455279.253399999 5793330.320499999,4455279.2357 5793330.331499999,4455279.218899999 5793330.3405,4455279.199099999 5793330.3515,4455279.179399999 5793330.3625,4455279.158699999 5793330.3745,4455279.1478 5793330.377599999,4455279.1429 5793330.3845,4455279.1232 5793330.3936,4455279.1162 5793330.391599999,4455279.101499999 5793330.402599999,4455279.0837 5793330.412599999,4455279.0718 5793330.411699999,4455279.061999999 5793330.421599999,4455279.039699999 5793330.425699999,4455279.026499999 5793330.444599999,4455279.0126 5793330.4517,4455279.0087 5793330.458599999,4455278.992899999 5793330.470599999,4455278.9703 5793330.4876,4455278.9565 5793330.501599999,4455278.9457 5793330.5185,4455278.933299999 5793330.541799999,4455278.932 5793330.570199999,4455278.9291 5793330.5752,4455278.9331 5793330.600999999,4455278.9401 5793330.632799999,4455278.9362 5793330.652699999,4455278.943199999 5793330.6655,4455278.940299999 5793330.6795,4455278.9532 5793330.706199999,4455278.961299999 5793330.736999999,4455278.9658 5793330.7573,4455278.980299999 5793330.774299999,4455279.032599999 5793330.798399999,4455279.084999999 5793330.8179,4455279.138 5793330.831,4455279.1653 5793330.830499999,4455279.201899999 5793330.832299999,4455279.232499999 5793330.830199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (136,136,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',0.0956871163684,0.000523280006496,0.024701041797,0.0642227086721,1, ST_GeomFromText('MULTIPOLYGON(((4455286.126199999 5793330.8537,4455286.132 5793330.844,4455286.1325 5793330.832299999,4455286.113699999 5793330.8344,4455286.1039 5793330.8563,4455286.1039 5793330.862199999,4455286.126199999 5793330.8537)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (137,137,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',0.942637658644,0.0128947999582,0.034182574688,0.0888746941888,1, ST_GeomFromText('MULTIPOLYGON(((4455284.9516 5793330.8757,4455284.9473 5793330.8692,4455284.818799999 5793330.755899999,4455284.806099999 5793330.747199999,4455284.7823 5793330.723099999,4455284.772599999 5793330.7169,4455284.764 5793330.7056,4455284.7405 5793330.6882,4455284.719299999 5793330.6673,4455284.710799999 5793330.662,4455284.705299999 5793330.654999999,4455284.690999999 5793330.646199999,4455284.682 5793330.6357,4455284.6676 5793330.6259,4455284.6402 5793330.601999999,4455284.611899999 5793330.584499999,4455284.6375 5793330.6304,4455284.6578 5793330.653899999,4455284.6676 5793330.6588,4455284.672399999 5793330.6577,4455284.6759 5793330.6588,4455284.685499999 5793330.6696,4455284.6873 5793330.674699999,4455284.6874 5793330.6851,4455284.765599999 5793330.737199999,4455284.871299999 5793330.864399999,4455284.876 5793330.8716,4455284.886099999 5793330.876099999,4455284.929999999 5793330.8815,4455284.954099999 5793330.887,4455284.9516 5793330.8757)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (138,138,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',1.67708449248,0.176033345084,0.159211955672,0.413951084747,1, ST_GeomFromText('MULTIPOLYGON(((4455284.9779 5793330.882999999,4455285.0085 5793330.8759,4455285.029199999 5793330.867799999,4455285.046 5793330.860799999,4455285.0707 5793330.847799999,4455285.089399999 5793330.835799999,4455285.1072 5793330.823799999,4455285.1239 5793330.8098,4455285.1397 5793330.7978,4455285.1545 5793330.787799999,4455285.171199999 5793330.770899999,4455285.184999999 5793330.7519,4455285.194799999 5793330.736999999,4455285.2076 5793330.715099999,4455285.2165 5793330.6962,4455285.221099999 5793330.6696,4455285.1973 5793330.638599999,4455285.003899999 5793330.4746,4455284.949699999 5793330.438999999,4455284.9011 5793330.421399999,4455284.872399999 5793330.422499999,4455284.8398 5793330.423599999,4455284.807199999 5793330.423699999,4455284.7805 5793330.428799999,4455284.756799999 5793330.4309,4455284.7251 5793330.433,4455284.698499999 5793330.4381,4455284.673799999 5793330.443199999,4455284.650999999 5793330.4483,4455284.6254 5793330.456299999,4455284.6056 5793330.4633,4455284.582899999 5793330.477399999,4455284.580099999 5793330.510199999,4455284.5991 5793330.542099999,4455284.611899999 5793330.584499999,4455284.6402 5793330.601999999,4455284.6676 5793330.6259,4455284.682 5793330.6357,4455284.690999999 5793330.646199999,4455284.705299999 5793330.654999999,4455284.710799999 5793330.662,4455284.719299999 5793330.6673,4455284.7405 5793330.6882,4455284.764 5793330.7056,4455284.772599999 5793330.7169,4455284.7823 5793330.723099999,4455284.806099999 5793330.747199999,4455284.818799999 5793330.755899999,4455284.9473 5793330.8692,4455284.9516 5793330.8757,4455284.954099999 5793330.887,4455284.9779 5793330.882999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (139,139,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil. 1','Bettstein','Bettstein','NULL',4.05888536898,1.19213437518,0.937951785138,2.43867464136,1, ST_GeomFromText('MULTIPOLYGON(((4455271.605299999 5793330.9505,4455271.6379 5793330.9473,4455271.6686 5793330.945199999,4455271.6982 5793330.941099999,4455271.7209 5793330.936,4455271.744599999 5793330.930999999,4455271.7713 5793330.925899999,4455271.7931 5793330.9218,4455271.8227 5793330.915699999,4455271.8464 5793330.9107,4455271.8731 5793330.9046,4455271.898799999 5793330.898499999,4455271.918499999 5793330.891499999,4455271.944199999 5793330.8834,4455271.9718 5793330.874399999,4455271.9945 5793330.866299999,4455272.0202 5793330.8573,4455272.047899999 5793330.8472,4455272.072599999 5793330.8372,4455272.094299999 5793330.827199999,4455272.121899999 5793330.8131,4455272.1456 5793330.7991,4455272.162399999 5793330.7901,4455272.1831 5793330.7771,4455272.2038 5793330.7651,4455272.2225 5793330.751099999,4455272.2422 5793330.737099999,4455272.258 5793330.723099999,4455272.2728 5793330.7082,4455272.2915 5793330.690199999,4455272.3053 5793330.6743,4455272.318099999 5793330.6563,4455272.335799999 5793330.6344,4455272.347599999 5793330.614499999,4455272.360399999 5793330.593499999,4455272.370199999 5793330.572599999,4455272.377999999 5793330.552699999,4455272.3868 5793330.530799999,4455272.3907 5793330.502,4455272.392599999 5793330.474199999,4455272.3935 5793330.4513,4455272.390399999 5793330.415599999,4455272.383399999 5793330.3848,4455272.3709 5793330.356599999,4455272.372899999 5793330.323799999,4455272.3556 5793330.289999999,4455272.349299999 5793330.255799999,4455272.347199999 5793330.228,4455272.3442 5793330.204199999,4455272.349 5793330.1793,4455272.3524 5793330.134199999,4455272.356599999 5793330.084899999,4455272.3585 5793330.0621,4455272.3607 5793330.0467,4455272.348299999 5793330.027699999,4455272.3157 5793329.980399999,4455272.2724 5793329.941299999,4455272.2361 5793329.8987,4455272.1694 5793329.8354,4455272.0997 5793329.7992,4455272.070199999 5793329.7912,4455272.024 5793329.790999999,4455271.9844 5793329.7839,4455271.9488 5793329.781799999,4455271.9264 5793329.781799999,4455271.892799999 5793329.780999999,4455271.863099999 5793329.781099999,4455271.817499999 5793329.7759,4455271.7849 5793329.777699999,4455271.751099999 5793329.7769,4455271.7197 5793329.775699999,4455271.712 5793329.7714,4455271.7004 5793329.7696,4455271.669599999 5793329.7827,4455271.633799999 5793329.7791,4455271.6051 5793329.7782,4455271.5744 5793329.7784,4455271.5277 5793329.7762,4455271.4923 5793329.768699999,4455271.454199999 5793329.766799999,4455271.418899999 5793329.7696,4455271.391499999 5793329.7652,4455271.3678 5793329.764299999,4455271.343 5793329.765399999,4455271.313699999 5793329.765799999,4455271.309 5793329.773,4455271.3097 5793329.788,4455271.311599999 5793329.8311,4455271.3117 5793329.855,4455271.307799999 5793329.8779,4455271.298999999 5793329.901699999,4455271.2991 5793329.926599999,4455271.2893 5793329.945499999,4455271.283499999 5793329.967399999,4455271.277599999 5793329.9813,4455271.2658 5793330.010199999,4455271.259899999 5793330.0251,4455271.249099999 5793330.05,4455271.240299999 5793330.066899999,4455271.230499999 5793330.0888,4455271.2207 5793330.108699999,4455271.2119 5793330.129599999,4455271.199099999 5793330.148499999,4455271.184399999 5793330.183399999,4455271.181499999 5793330.203199999,4455271.1776 5793330.227099999,4455271.177699999 5793330.248999999,4455271.177799999 5793330.2827,4455271.1759 5793330.3046,4455271.179999999 5793330.3364,4455271.184999999 5793330.364199999,4455271.188099999 5793330.3847,4455271.197499999 5793330.421,4455271.206199999 5793330.454099999,4455271.220099999 5793330.498099999,4455271.2251 5793330.528899999,4455271.234199999 5793330.5656,4455271.2412 5793330.593399999,4455271.251199999 5793330.6271,4455271.256199999 5793330.655099999,4455271.268199999 5793330.6926,4455271.273299999 5793330.7214,4455271.276399999 5793330.7532,4455271.280399999 5793330.779999999,4455271.2889 5793330.808299999,4455271.3002 5793330.8517,4455271.331199999 5793330.8989,4455271.377399999 5793330.9232,4455271.4077 5793330.9373,4455271.4482 5793330.944299999,4455271.472799999 5793330.944099999,4455271.507399999 5793330.947899999,4455271.542999999 5793330.948699999,4455271.573699999 5793330.9506,4455271.605299999 5793330.9505)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (140,140,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',0.156782425244,0.00110821001164,0.0251493321529,0.0653882635976,1, ST_GeomFromText('MULTIPOLYGON(((4455285.648699999 5793330.993699999,4455285.6337 5793330.980499999,4455285.604399999 5793330.992499999,4455285.597199999 5793330.9985,4455285.6079 5793331.004599999,4455285.664599999 5793331.0142,4455285.648699999 5793330.993699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (141,141,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',2.90218680599,0.579710335038,0.468590000773,1.21833400201,1, ST_GeomFromText('MULTIPOLYGON(((4455285.785099999 5793331.015599999,4455285.817699999 5793331.014399999,4455285.838499999 5793331.012399999,4455285.8671 5793331.0043,4455285.8898 5793330.999199999,4455285.9175 5793330.988199999,4455285.9362 5793330.9802,4455285.9658 5793330.965099999,4455285.9757 5793330.9581,4455285.993499999 5793330.9461,4455286.0092 5793330.9341,4455286.026999999 5793330.9221,4455286.042799999 5793330.909199999,4455286.0585 5793330.899199999,4455286.0793 5793330.885199999,4455286.0925 5793330.8782,4455286.1019 5793330.864199999,4455286.1039 5793330.862199999,4455286.1039 5793330.8563,4455286.113699999 5793330.8344,4455286.1325 5793330.832299999,4455286.1374 5793330.8233,4455286.147199999 5793330.810399999,4455286.16 5793330.7924,4455286.171799999 5793330.776499999,4455286.1856 5793330.7595,4455286.196399999 5793330.7456,4455286.211199999 5793330.728599999,4455286.224 5793330.7147,4455286.234799999 5793330.7017,4455286.249599999 5793330.6818,4455286.2624 5793330.663799999,4455286.269199999 5793330.6499,4455286.279 5793330.626,4455286.282899999 5793330.5962,4455286.280799999 5793330.5614,4455286.2767 5793330.5307,4455286.267699999 5793330.5009,4455286.262699999 5793330.473799999,4455286.254399999 5793330.439699999,4455286.241999999 5793330.401499999,4455286.2268 5793330.3661,4455286.2147 5793330.327299999,4455286.198099999 5793330.288699999,4455286.1853 5793330.252299999,4455286.1661 5793330.2258,4455286.1467 5793330.214199999,4455286.1204 5793330.2134,4455286.0947 5793330.216499999,4455286.067999999 5793330.220599999,4455286.053299999 5793330.219399999,4455286.0403 5793330.2247,4455286.015599999 5793330.2288,4455285.985999999 5793330.235899999,4455285.9642 5793330.2399,4455285.936599999 5793330.244999999,4455285.912899999 5793330.250099999,4455285.886199999 5793330.259199999,4455285.8595 5793330.262199999,4455285.836799999 5793330.2693,4455285.8161 5793330.2773,4455285.788399999 5793330.2824,4455285.7706 5793330.288499999,4455285.743999999 5793330.295499999,4455285.723199999 5793330.3026,4455285.7015 5793330.3066,4455285.6748 5793330.3177,4455285.652099999 5793330.324699999,4455285.633399999 5793330.3318,4455285.6116 5793330.337799999,4455285.5662 5793330.3529,4455285.543499999 5793330.360999999,4455285.519799999 5793330.369999999,4455285.502 5793330.376,4455285.478299999 5793330.383099999,4455285.4566 5793330.3911,4455285.4369 5793330.399199999,4455285.414099999 5793330.407199999,4455285.3934 5793330.4162,4455285.366799999 5793330.4253,4455285.349999999 5793330.4353,4455285.326299999 5793330.445299999,4455285.306599999 5793330.455399999,4455285.2888 5793330.465399999,4455285.2691 5793330.476399999,4455285.247399999 5793330.4934,4455285.2499 5793330.5193,4455285.2618 5793330.552999999,4455285.269 5793330.5832,4455285.280799999 5793330.5984,4455285.296199999 5793330.6453,4455285.3052 5793330.669399999,4455285.3267 5793330.7003,4455285.358 5793330.751299999,4455285.422199999 5793330.838099999,4455285.475499999 5793330.903599999,4455285.5482 5793330.9669,4455285.592199999 5793330.994599999,4455285.597199999 5793330.9985,4455285.604399999 5793330.992499999,4455285.6337 5793330.980499999,4455285.648699999 5793330.993699999,4455285.664599999 5793331.0142,4455285.7278 5793331.0196,4455285.7604 5793331.0197,4455285.785099999 5793331.015599999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (142,142,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Kammerstein','Kammerstein','NULL',2.64694368102,0.42904303003,0.353118578215,0.91810830336,1, ST_GeomFromText('MULTIPOLYGON(((4455277.3344 5793331.1632,4455277.3651 5793331.1611,4455277.3908 5793331.156999999,4455277.4214 5793331.155899999,4455277.449099999 5793331.1478,4455277.4758 5793331.1457,4455277.503399999 5793331.139599999,4455277.527099999 5793331.1326,4455277.5568 5793331.127499999,4455277.5854 5793331.1204,4455277.6101 5793331.114299999,4455277.628899999 5793331.102299999,4455277.648599999 5793331.093299999,4455277.6703 5793331.082299999,4455277.692999999 5793331.0743,4455277.717699999 5793331.070199999,4455277.747399999 5793331.066099999,4455277.7701 5793331.061,4455277.791799999 5793331.052999999,4455277.8125 5793331.038,4455277.8283 5793331.020999999,4455277.8381 5793331.0031,4455277.8469 5793330.9832,4455277.8557 5793330.9613,4455277.862599999 5793330.9404,4455277.866499999 5793330.920499999,4455277.871299999 5793330.8967,4455277.874599999 5793330.869799999,4455277.8046 5793330.769799999,4455277.7888 5793330.7609,4455277.764999999 5793330.738199999,4455277.754999999 5793330.726299999,4455277.714499999 5793330.7155,4455277.689699999 5793330.7127,4455277.6562 5793330.6927,4455277.605299999 5793330.675899999,4455277.575799999 5793330.652899999,4455277.515899999 5793330.626099999,4455277.4774 5793330.602299999,4455277.4521 5793330.6004,4455277.4155 5793330.5986,4455277.3918 5793330.605699999,4455277.37 5793330.6127,4455277.345399999 5793330.620799999,4455277.3256 5793330.628799999,4455277.3019 5793330.6359,4455277.2772 5793330.644899999,4455277.2604 5793330.6509,4455277.2377 5793330.656999999,4455277.213 5793330.664999999,4455277.1884 5793330.6741,4455277.1676 5793330.682099999,4455277.140999999 5793330.690199999,4455277.1172 5793330.6972,4455277.0935 5793330.703299999,4455277.065899999 5793330.7094,4455277.041199999 5793330.716499999,4455277.0135 5793330.7225,4455276.989799999 5793330.7276,4455276.9641 5793330.7367,4455276.940399999 5793330.743699999,4455276.9148 5793330.7508,4455276.892099999 5793330.7598,4455276.871299999 5793330.769799999,4455276.8486 5793330.780899999,4455276.827899999 5793330.7949,4455276.812199999 5793330.812799999,4455276.798399999 5793330.8288,4455276.784599999 5793330.8537,4455276.774799999 5793330.876499999,4455276.772699999 5793330.893899999,4455276.7821 5793330.913899999,4455276.814399999 5793330.9592,4455276.8863 5793331.027599999,4455276.9658 5793331.0822,4455277.0118 5793331.097999999,4455277.0656 5793331.104399999,4455277.1019 5793331.1092,4455277.137799999 5793331.1051,4455277.172399999 5793331.101399999,4455277.2077 5793331.1104,4455277.257799999 5793331.1554,4455277.3057 5793331.171599999,4455277.3344 5793331.1632)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (143,143,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Kammerstein','Kammerstein','NULL',2.38659016739,0.421504304799,0.347340899198,0.903086337915,1, ST_GeomFromText('MULTIPOLYGON(((4455278.2817 5793331.2068,4455278.3064 5793331.201799999,4455278.3311 5793331.196699999,4455278.3618 5793331.1916,4455278.384499999 5793331.186499999,4455278.4072 5793331.182399999,4455278.440799999 5793331.1783,4455278.464499999 5793331.172299999,4455278.4912 5793331.170199999,4455278.520899999 5793331.167999999,4455278.5466 5793331.164999999,4455278.5732 5793331.1609,4455278.595999999 5793331.156799999,4455278.6226 5793331.151699999,4455278.6463 5793331.1447,4455278.671 5793331.1346,4455278.690799999 5793331.1256,4455278.707499999 5793331.1146,4455278.723299999 5793331.1026,4455278.738099999 5793331.083699999,4455278.747899999 5793331.060799999,4455278.7527 5793331.0379,4455278.7571 5793331.011099999,4455278.7585 5793330.9912,4455278.753499999 5793330.9843,4455278.7554 5793330.9634,4455278.747499999 5793330.9545,4455278.7543 5793330.9326,4455278.748399999 5793330.9197,4455278.7334 5793330.883999999,4455278.724799999 5793330.854399999,4455278.707299999 5793330.815099999,4455278.693699999 5793330.7758,4455278.6776 5793330.751099999,4455278.680499999 5793330.7412,4455278.669499999 5793330.720399999,4455278.6626 5793330.7105,4455278.664499999 5793330.6936,4455278.6446 5793330.6688,4455278.631799999 5793330.656999999,4455278.632699999 5793330.653,4455278.6238 5793330.633099999,4455278.609799999 5793330.6113,4455278.546199999 5793330.5733,4455278.507299999 5793330.5577,4455278.459099999 5793330.548299999,4455278.4287 5793330.5416,4455278.393099999 5793330.538799999,4455278.357499999 5793330.5359,4455278.330799999 5793330.539999999,4455278.295199999 5793330.5392,4455278.2735 5793330.547199999,4455278.2537 5793330.556299999,4455278.229 5793330.567299999,4455278.2083 5793330.579299999,4455278.1935 5793330.590299999,4455278.171799999 5793330.601299999,4455278.1511 5793330.613299999,4455278.1353 5793330.625299999,4455278.123499999 5793330.6323,4455278.1018 5793330.646299999,4455278.0821 5793330.659299999,4455278.0673 5793330.672299999,4455278.050499999 5793330.6853,4455278.0377 5793330.7002,4455278.025899999 5793330.714199999,4455278.002199999 5793330.7232,4455278.000699999 5793330.725199999,4455277.996399999 5793330.7451,4455277.983599999 5793330.7631,4455277.9718 5793330.780999999,4455277.958999999 5793330.800899999,4455277.949199999 5793330.8198,4455277.940299999 5793330.8427,4455277.9345 5793330.867599999,4455277.9336 5793330.8924,4455277.937699999 5793330.9232,4455277.9537 5793330.960999999,4455277.9791 5793331.012499999,4455278.0239 5793331.073599999,4455278.044499999 5793331.1083,4455278.0766 5793331.143999999,4455278.124699999 5793331.176999999,4455278.168899999 5793331.193499999,4455278.216699999 5793331.205299999,4455278.255199999 5793331.210599999,4455278.268 5793331.213899999,4455278.2817 5793331.2068)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (144,144,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Kammerstein','Kammerstein','NULL',1.63582413585,0.169085229915,0.153886920207,0.400105992539,1, ST_GeomFromText('MULTIPOLYGON(((4455275.425499999 5793331.226099999,4455275.455199999 5793331.225899999,4455275.483799999 5793331.2199,4455275.509499999 5793331.2138,4455275.529299999 5793331.2068,4455275.542 5793331.197799999,4455275.548999999 5793331.1848,4455275.5618 5793331.166899999,4455275.568599999 5793331.141,4455275.565 5793331.1225,4455275.5531 5793331.107799999,4455275.536899999 5793331.0708,4455275.5207 5793331.0479,4455275.4862 5793330.9852,4455275.481999999 5793330.9834,4455275.458399999 5793330.9481,4455275.449 5793330.921299999,4455275.431699999 5793330.895999999,4455275.3907 5793330.8835,4455275.360999999 5793330.8836,4455275.3255 5793330.8848,4455275.296799999 5793330.8859,4455275.266099999 5793330.888,4455275.2355 5793330.886199999,4455275.2098 5793330.8912,4455275.176199999 5793330.8914,4455275.152499999 5793330.8935,4455275.1198 5793330.8956,4455275.0882 5793330.8967,4455275.065499999 5793330.8998,4455275.031899999 5793330.9009,4455275.0042 5793330.903,4455274.974499999 5793330.9032,4455274.944899999 5793330.9152,4455274.936099999 5793330.941099999,4455274.937199999 5793330.971899999,4455274.9373 5793331.002699999,4455274.939399999 5793331.0315,4455274.947599999 5793331.0622,4455274.992499999 5793331.118,4455275.0449 5793331.140699999,4455275.0695 5793331.1586,4455275.1083 5793331.172599999,4455275.1686 5793331.194099999,4455275.228 5793331.2078,4455275.271399999 5793331.2189,4455275.308299999 5793331.223999999,4455275.341599999 5793331.225899999,4455275.3743 5793331.2246,4455275.398799999 5793331.226199999,4455275.425499999 5793331.226099999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (145,145,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Kammerstein','Kammerstein','NULL',2.498789683,0.413940044945,0.341543650446,0.88801349116,1, ST_GeomFromText('MULTIPOLYGON(((4455274.452399999 5793331.550699999,4455274.483199999 5793331.549499999,4455274.503299999 5793331.542999999,4455274.525 5793331.5359,4455274.5487 5793331.5338,4455274.5754 5793331.5317,4455274.603 5793331.525699999,4455274.630699999 5793331.5186,4455274.6544 5793331.5095,4455274.670199999 5793331.504499999,4455274.6939 5793331.493499999,4455274.7116 5793331.482499999,4455274.7236 5793331.474799999,4455274.729399999 5793331.4655,4455274.7412 5793331.456499999,4455274.757 5793331.443499999,4455274.7718 5793331.425599999,4455274.7855 5793331.4076,4455274.798299999 5793331.3947,4455274.812099999 5793331.3767,4455274.8239 5793331.357799999,4455274.8337 5793331.336899999,4455274.832999999 5793331.3123,4455274.814799999 5793331.287299999,4455274.8107 5793331.2595,4455274.7899 5793331.235799999,4455274.771999999 5793331.223899999,4455274.7492 5793331.2071,4455274.731399999 5793331.192999999,4455274.724399999 5793331.1774,4455274.715499999 5793331.1675,4455274.716799999 5793331.1402,4455274.7114 5793331.1238,4455274.6807 5793331.1289,4455274.6341 5793331.080499999,4455274.6123 5793331.060699999,4455274.589399999 5793331.037,4455274.5855 5793331.035,4455274.5153 5793330.9592,4455274.4767 5793330.9315,4455274.444199999 5793330.9218,4455274.4121 5793330.931399999,4455274.3874 5793330.935499999,4455274.3617 5793330.9416,4455274.333999999 5793330.947599999,4455274.309299999 5793330.9547,4455274.290599999 5793330.959799999,4455274.2626 5793330.968,4455274.235299999 5793330.9711,4455274.215499999 5793330.9809,4455274.1928 5793330.985999999,4455274.1681 5793330.9931,4455274.1562 5793330.9951,4455274.138899999 5793330.9973,4455274.120699999 5793331.008199999,4455274.100999999 5793331.0142,4455274.0782 5793331.0193,4455274.054499999 5793331.0263,4455274.0338 5793331.0314,4455274.005099999 5793331.037499999,4455273.9824 5793331.0416,4455273.959699999 5793331.047599999,4455273.936999999 5793331.0557,4455273.9105 5793331.067199999,4455273.8876 5793331.084699999,4455273.8739 5793331.0996,4455273.866999999 5793331.1195,4455273.8572 5793331.1414,4455273.8633 5793331.1698,4455273.891699999 5793331.2236,4455273.9187 5793331.265,4455273.9494 5793331.2968,4455274.0097 5793331.367799999,4455274.1188 5793331.4655,4455274.1913 5793331.4987,4455274.246399999 5793331.5153,4455274.260499999 5793331.525,4455274.296 5793331.5307,4455274.3163 5793331.5381,4455274.373999999 5793331.5437,4455274.3923 5793331.550599999,4455274.417 5793331.551799999,4455274.452399999 5793331.550699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (146,146,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Kammerstein','Kammerstein','NULL',2.67763829926,0.504104680118,0.410645826842,1.06767914979,1, ST_GeomFromText('MULTIPOLYGON(((4455276.007399999 5793331.651699999,4455276.035099999 5793331.6476,4455276.058799999 5793331.6456,4455276.084499999 5793331.6444,4455276.113099999 5793331.636399999,4455276.1359 5793331.627299999,4455276.1605 5793331.6223,4455276.1862 5793331.6162,4455276.2011 5793331.613099999,4455276.235 5793331.6026,4455276.2695 5793331.6059,4455276.296 5793331.6007,4455276.317699999 5793331.6027,4455276.3463 5793331.5986,4455276.385099999 5793331.5973,4455276.4121 5793331.5908,4455276.422899999 5793331.591499999,4455276.4323 5793331.5853,4455276.4501 5793331.578299999,4455276.478799999 5793331.5699,4455276.497399999 5793331.5523,4455276.512199999 5793331.5393,4455276.523 5793331.5263,4455276.539699999 5793331.5117,4455276.5486 5793331.491399999,4455276.556499999 5793331.478499999,4455276.565 5793331.4702,4455276.569299999 5793331.457599999,4455276.574099999 5793331.436699999,4455276.578999999 5793331.417799999,4455276.582899999 5793331.389,4455276.586799999 5793331.3691,4455276.5876 5793331.339299999,4455276.585599999 5793331.3135,4455276.5897 5793331.2904,4455276.584499999 5793331.278699999,4455276.581399999 5793331.2519,4455276.5843 5793331.2429,4455276.572399999 5793331.2201,4455276.570299999 5793331.1993,4455276.565399999 5793331.196299999,4455276.567699999 5793331.176699999,4455276.5603 5793331.160599999,4455276.562199999 5793331.1487,4455276.5542 5793331.1239,4455276.548299999 5793331.1159,4455276.5492 5793331.104,4455276.536299999 5793331.0822,4455276.529299999 5793331.0753,4455276.5333 5793331.0624,4455276.5213 5793331.0445,4455276.509399999 5793331.0307,4455276.504499999 5793331.026699999,4455276.503399999 5793331.0019,4455276.4627 5793330.9703,4455276.444899999 5793330.956399999,4455276.4389 5793330.9545,4455276.425099999 5793330.957499999,4455276.4039 5793330.946399999,4455276.3684 5793330.940999999,4455276.344999999 5793330.942999999,4455276.315299999 5793330.944099999,4455276.283699999 5793330.945199999,4455276.256 5793330.9473,4455276.229299999 5793330.9514,4455276.186499999 5793330.946299999,4455276.165099999 5793330.9547,4455276.1374 5793330.9568,4455276.1058 5793330.959899999,4455276.0969 5793330.956,4455276.0811 5793330.964999999,4455276.0564 5793330.965099999,4455276.029699999 5793330.963199999,4455276.024699999 5793330.965199999,4455276.002 5793330.964299999,4455275.993099999 5793330.967299999,4455275.9674 5793330.9655,4455275.958499999 5793330.968499999,4455275.943699999 5793330.9656,4455275.9308 5793330.972599999,4455275.916 5793330.970599999,4455275.899199999 5793330.974199999,4455275.873499999 5793330.9798,4455275.843899999 5793330.983899999,4455275.833999999 5793330.983899999,4455275.8172 5793330.9919,4455275.798399999 5793330.998999999,4455275.7856 5793331.008999999,4455275.784699999 5793331.016899999,4455275.7768 5793331.039799999,4455275.773 5793331.063599999,4455275.7691 5793331.0865,4455275.768199999 5793331.113299999,4455275.768299999 5793331.137199999,4455275.7684 5793331.164999999,4455275.7685 5793331.1918,4455275.7696 5793331.2147,4455275.765499999 5793331.2343,4455275.775899999 5793331.322899999,4455275.775999999 5793331.348699999,4455275.778199999 5793331.3693,4455275.787899999 5793331.407899999,4455275.7849 5793331.4251,4455275.7882 5793331.4381,4455275.790199999 5793331.4649,4455275.7892 5793331.478299999,4455275.7958 5793331.4908,4455275.8024 5793331.5261,4455275.8102 5793331.5546,4455275.82 5793331.5688,4455275.8331 5793331.6104,4455275.8452 5793331.626499999,4455275.8528 5793331.6303,4455275.8831 5793331.6469,4455275.916699999 5793331.6543,4455275.9506 5793331.6564,4455275.985399999 5793331.6576,4455276.007399999 5793331.651699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (147,147,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',2.68327412771,0.47762562505,0.390352279038,1.0149159255,1, ST_GeomFromText('MULTIPOLYGON(((4455283.729799999 5793331.903599999,4455283.754599999 5793331.901499999,4455283.768799999 5793331.893999999,4455283.7772 5793331.877599999,4455283.7811 5793331.8527,4455283.781 5793331.8219,4455283.782899999 5793331.8001,4455283.7877 5793331.783099999,4455283.7936 5793331.763299999,4455283.8014 5793331.7434,4455283.808299999 5793331.721499999,4455283.814199999 5793331.7026,4455283.82 5793331.6817,4455283.825899999 5793331.662799999,4455283.8298 5793331.642899999,4455283.834599999 5793331.611099999,4455283.838499999 5793331.590199999,4455283.839399999 5793331.5654,4455283.8403 5793331.5405,4455283.842199999 5793331.514699999,4455283.843999999 5793331.484899999,4455283.844899999 5793331.462999999,4455283.8448 5793331.432199999,4455283.8447 5793331.4074,4455283.8436 5793331.379599999,4455283.8435 5793331.3518,4455283.8415 5793331.323999999,4455283.8375 5793331.3012,4455283.826299999 5793331.2564,4455283.807 5793331.212899999,4455283.7785 5793331.1828,4455283.748599999 5793331.1708,4455283.7055 5793331.1706,4455283.676799999 5793331.1717,4455283.647199999 5793331.175799999,4455283.6205 5793331.1809,4455283.597799999 5793331.1859,4455283.577999999 5793331.192999999,4455283.549399999 5793331.203999999,4455283.5277 5793331.2111,4455283.507899999 5793331.2181,4455283.484199999 5793331.227099999,4455283.4664 5793331.2352,4455283.444699999 5793331.2442,4455283.424999999 5793331.2542,4455283.4013 5793331.2662,4455283.381599999 5793331.275299999,4455283.366799999 5793331.286299999,4455283.3441 5793331.297299999,4455283.325299999 5793331.309299999,4455283.3086 5793331.319299999,4455283.286899999 5793331.3343,4455283.2701 5793331.3463,4455283.2514 5793331.3603,4455283.238499999 5793331.3693,4455283.2218 5793331.3823,4455283.202999999 5793331.3953,4455283.1912 5793331.408199999,4455283.174499999 5793331.420199999,4455283.158699999 5793331.433199999,4455283.144899999 5793331.445199999,4455283.129099999 5793331.4591,4455283.112399999 5793331.4711,4455283.095599999 5793331.486099999,4455283.081799999 5793331.497099999,4455283.066999999 5793331.511099999,4455283.052199999 5793331.525,4455283.037499999 5793331.540999999,4455283.0257 5793331.555999999,4455283.008899999 5793331.575899999,4455282.9971 5793331.597799999,4455282.990299999 5793331.617699999,4455282.986399999 5793331.6455,4455282.9835 5793331.6654,4455282.9807 5793331.692199999,4455282.9768 5793331.715099999,4455282.974899999 5793331.7409,4455282.974999999 5793331.765799999,4455282.9731 5793331.789599999,4455282.980499999 5793331.8123,4455283.003899999 5793331.8253,4455283.013799999 5793331.8252,4455283.043499999 5793331.838999999,4455283.054399999 5793331.8399,4455283.0909 5793331.8428,4455283.104799999 5793331.848699999,4455283.130499999 5793331.847599999,4455283.173 5793331.855299999,4455283.205699999 5793331.8582,4455283.2373 5793331.860999999,4455283.276899999 5793331.8668,4455283.3095 5793331.8706,4455283.3442 5793331.8735,4455283.3847 5793331.8802,4455283.4193 5793331.883099999,4455283.4559 5793331.8879,4455283.4866 5793331.889699999,4455283.522199999 5793331.892599999,4455283.553799999 5793331.8944,4455283.5855 5793331.8943,4455283.6211 5793331.898099999,4455283.654699999 5793331.9009,4455283.689299999 5793331.903799999,4455283.729799999 5793331.903599999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (148,148,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',0.732321223961,0.0380660950264,0.0534738552283,0.139032023593,1, ST_GeomFromText('MULTIPOLYGON(((4455281.0617 5793332.2499,4455281.0854 5793332.243799999,4455281.1051 5793332.235799999,4455281.126799999 5793332.221799999,4455281.142599999 5793332.2048,4455281.156299999 5793332.1829,4455281.160199999 5793332.1531,4455281.1469 5793332.117399999,4455281.0974 5793332.071299999,4455281.0361 5793332.028599999,4455280.9844 5793332.011399999,4455280.9692 5793332.016599999,4455280.963 5793332.037699999,4455280.961099999 5793332.062499999,4455280.9543 5793332.082399999,4455280.9504 5793332.1083,4455280.948499999 5793332.132099999,4455280.9457 5793332.154999999,4455280.9477 5793332.1798,4455280.951799999 5793332.210599999,4455280.9538 5793332.2279,4455280.961799999 5793332.2389,4455280.9797 5793332.2488,4455281.0004 5793332.251099999,4455281.031999999 5793332.252,4455281.0617 5793332.2499)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (149,149,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil. 1','Bettstein','Bettstein','NULL',2.95917603483,0.611350355098,0.492838912147,1.28138117158,1, ST_GeomFromText('MULTIPOLYGON(((4455271.902599999 5793332.7989,4455271.928199999 5793332.7879,4455271.950899999 5793332.7749,4455271.9697 5793332.7629,4455271.990399999 5793332.7489,4455272.011099999 5793332.7388,4455272.0299 5793332.730799999,4455272.051599999 5793332.719799999,4455272.075299999 5793332.7028,4455272.093 5793332.689799999,4455272.1127 5793332.675799999,4455272.1364 5793332.6588,4455272.159099999 5793332.643799999,4455272.174899999 5793332.630899999,4455272.1956 5793332.617799999,4455272.2153 5793332.600899999,4455272.231999999 5793332.5839,4455272.2488 5793332.566999999,4455272.261599999 5793332.554999999,4455272.2744 5793332.540999999,4455272.290199999 5793332.5251,4455272.304899999 5793332.509099999,4455272.3167 5793332.4941,4455272.3315 5793332.478199999,4455272.3453 5793332.4583,4455272.342899999 5793332.4252,4455272.3063 5793332.3736,4455272.284099999 5793332.328199999,4455272.263799999 5793332.282999999,4455272.240799999 5793332.239299999,4455272.2088 5793332.1817,4455272.1978 5793332.152,4455272.148599999 5793332.1105,4455272.1194 5793332.054899999,4455272.105399999 5793332.0142,4455272.0935 5793331.9822,4455272.045699999 5793331.968,4455272.0027 5793331.953299999,4455271.9395 5793331.937799999,4455271.890499999 5793331.9254,4455271.8392 5793331.909199999,4455271.790599999 5793331.8901,4455271.7379 5793331.875099999,4455271.685899999 5793331.853599999,4455271.638799999 5793331.8387,4455271.5969 5793331.827099999,4455271.5767 5793331.832399999,4455271.548799999 5793331.8186,4455271.5244 5793331.819099999,4455271.501699999 5793331.841,4455271.490899999 5793331.861899999,4455271.482099999 5793331.8749,4455271.4791 5793331.8868,4455271.473299999 5793331.900699999,4455271.4654 5793331.921599999,4455271.4576 5793331.948499999,4455271.4537 5793331.9733,4455271.4538 5793332.000199999,4455271.456 5793332.037399999,4455271.463999999 5793332.0865,4455271.4641 5793332.1124,4455271.4632 5793332.138199999,4455271.4604 5793332.168999999,4455271.4565 5793332.191899999,4455271.454599999 5793332.219699999,4455271.454699999 5793332.251499999,4455271.4554 5793332.2661,4455271.462199999 5793332.2781,4455271.4538 5793332.3101,4455271.4609 5793332.3363,4455271.466699999 5793332.3695,4455271.471499999 5793332.399299999,4455271.475399999 5793332.4392,4455271.5003 5793332.519999999,4455271.519299999 5793332.572499999,4455271.5322 5793332.602499999,4455271.545599999 5793332.6162,4455271.5772 5793332.6552,4455271.605499999 5793332.672,4455271.658099999 5793332.7094,4455271.720399999 5793332.7387,4455271.803899999 5793332.7773,4455271.8332 5793332.791699999,4455271.8728 5793332.7993,4455271.902599999 5793332.7989)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (150,150,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil. 1','Stein','Stein','NULL',0.662006447575,0.0274128799803,0.0453092312169,0.117804001164,1, ST_GeomFromText('MULTIPOLYGON(((4455275.2494 5793332.838199999,4455275.257199999 5793332.8034,4455275.258999999 5793332.776499999,4455275.2619 5793332.7517,4455275.258799999 5793332.7199,4455275.206799999 5793332.694399999,4455275.184799999 5793332.6543,4455275.1682 5793332.6489,4455275.150799999 5793332.654799999,4455275.125199999 5793332.6688,4455275.111399999 5793332.6808,4455275.092699999 5793332.6958,4455275.0789 5793332.7068,4455275.0651 5793332.721699999,4455275.0513 5793332.7357,4455275.0365 5793332.755599999,4455275.035299999 5793332.7707,4455275.042299999 5793332.7838,4455275.0854 5793332.8045,4455275.125699999 5793332.8088,4455275.1544 5793332.813699999,4455275.208399999 5793332.827099999,4455275.228099999 5793332.8416,4455275.2494 5793332.838199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (151,151,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil. 1','Stein','Stein','NULL',0.765370963466,0.0364047600538,0.0522006081052,0.135721581074,1, ST_GeomFromText('MULTIPOLYGON(((4455275.445399999 5793332.9098,4455275.485899999 5793332.9087,4455275.5126 5793332.903599999,4455275.536299999 5793332.898499999,4455275.557799999 5793332.893799999,4455275.5718 5793332.879499999,4455275.579699999 5793332.8671,4455275.577999999 5793332.848699999,4455275.5453 5793332.8102,4455275.5255 5793332.7715,4455275.493499999 5793332.733899999,4455275.4747 5793332.7236,4455275.4516 5793332.723999999,4455275.4281 5793332.714999999,4455275.403199999 5793332.716299999,4455275.374499999 5793332.716399999,4455275.333999999 5793332.7235,4455275.298399999 5793332.719699999,4455275.2991 5793332.739199999,4455275.310399999 5793332.7584,4455275.3218 5793332.7892,4455275.3529 5793332.8231,4455275.3721 5793332.855599999,4455275.4128 5793332.9012,4455275.427 5793332.91,4455275.445399999 5793332.9098)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (152,152,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil. 1','Stein','Stein','NULL',0.482907853296,0.0152080849574,0.0359554763113,0.0934842384094,1, ST_GeomFromText('MULTIPOLYGON(((4455274.9543 5793332.981499999,4455274.980899999 5793332.9744,4455275.000699999 5793332.9634,4455275.019399999 5793332.945399999,4455275.024299999 5793332.921599999,4455275.028099999 5793332.900699999,4455275.029 5793332.8629,4455275.030899999 5793332.857,4455275.0383 5793332.834699999,4455275.0338 5793332.820299999,4455275.0164 5793332.810699999,4455274.9932 5793332.8144,4455274.9696 5793332.830399999,4455274.950899999 5793332.8593,4455274.9351 5793332.8723,4455274.9164 5793332.8942,4455274.9105 5793332.916099999,4455274.908599999 5793332.938999999,4455274.9073 5793332.958399999,4455274.9161 5793332.974099999,4455274.933799999 5793332.9822,4455274.9543 5793332.981499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (153,153,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',2.98713190008,0.61172600483,0.493126810102,1.28212970626,1, ST_GeomFromText('MULTIPOLYGON(((4455282.138199999 5793333.0569,4455282.1659 5793333.050799999,4455282.182699999 5793333.0368,4455282.197399999 5793333.0238,4455282.2092 5793333.0039,4455282.223 5793332.983999999,4455282.2328 5793332.967,4455282.2437 5793332.952099999,4455282.254499999 5793332.9362,4455282.291899999 5793332.8833,4455282.296799999 5793332.8734,4455282.297699999 5793332.8704,4455282.306599999 5793332.8574,4455282.3085 5793332.8505,4455282.316399999 5793332.8385,4455282.3184 5793332.8286,4455282.325199999 5793332.8166,4455282.3262 5793332.810699999,4455282.334999999 5793332.7967,4455282.337 5793332.791699999,4455282.347799999 5793332.778799999,4455282.348799999 5793332.7738,4455282.3567 5793332.7619,4455282.3567 5793332.758899999,4455282.366499999 5793332.743899999,4455282.367499999 5793332.74,4455282.376299999 5793332.725999999,4455282.377299999 5793332.72,4455282.3852 5793332.7081,4455282.387099999 5793332.702099999,4455282.3969 5793332.6882,4455282.423399999 5793332.625499999,4455282.4323 5793332.607599999,4455282.442099999 5793332.585699999,4455282.4489 5793332.5687,4455282.455799999 5793332.550799999,4455282.466599999 5793332.530899999,4455282.473399999 5793332.513,4455282.4823 5793332.4921,4455282.4901 5793332.4722,4455282.497 5793332.452299999,4455282.5048 5793332.433399999,4455282.5136 5793332.412499999,4455282.520499999 5793332.3936,4455282.5263 5793332.3717,4455282.534199999 5793332.3508,4455282.541 5793332.327899999,4455282.547799999 5793332.305099999,4455282.550699999 5793332.2762,4455282.5526 5793332.252399999,4455282.5535 5793332.2266,4455282.555399999 5793332.2027,4455282.5553 5793332.176899999,4455282.557199999 5793332.146099999,4455282.557099999 5793332.122199999,4455282.553999999 5793332.093399999,4455282.553999999 5793332.0645,4455282.5367 5793332.0271,4455282.516499999 5793332.0051,4455282.4922 5793331.992399999,4455282.4571 5793331.9878,4455282.4291 5793331.9907,4455282.3974 5793331.9918,4455282.3678 5793331.9919,4455282.336099999 5793331.994999999,4455282.306499999 5793331.9952,4455282.2768 5793331.9973,4455282.254099999 5793332.002299999,4455282.2284 5793332.0064,4455282.2017 5793332.0095,4455282.175999999 5793332.013599999,4455282.145399999 5793332.016699999,4455282.1217 5793332.018799999,4455282.091 5793332.0219,4455282.065399999 5793332.028999999,4455282.0436 5793332.035,4455282.019899999 5793332.044099999,4455282.001199999 5793332.0521,4455281.9785 5793332.065099999,4455281.961699999 5793332.075099999,4455281.944 5793332.087099999,4455281.9302 5793332.099099999,4455281.9144 5793332.111099999,4455281.898599999 5793332.126099999,4455281.8799 5793332.1391,4455281.8612 5793332.153999999,4455281.8474 5793332.168999999,4455281.833599999 5793332.184,4455281.8178 5793332.202899999,4455281.805999999 5793332.221799999,4455281.7992 5793332.234799999,4455281.788399999 5793332.254699999,4455281.7805 5793332.2716,4455281.7756 5793332.2925,4455281.769799999 5793332.3124,4455281.762199999 5793332.324699999,4455281.762 5793332.342199999,4455281.760099999 5793332.362099999,4455281.753299999 5793332.392899999,4455281.7553 5793332.415799999,4455281.757399999 5793332.4406,4455281.7575 5793332.470399999,4455281.7615 5793332.498199999,4455281.766599999 5793332.531899999,4455281.773599999 5793332.561699999,4455281.778699999 5793332.584799999,4455281.789699999 5793332.621099999,4455281.8002 5793332.657199999,4455281.813099999 5793332.697499999,4455281.8276 5793332.7332,4455281.844899999 5793332.774499999,4455281.867999999 5793332.817999999,4455281.9027 5793332.882699999,4455281.9258 5793332.922,4455281.956 5793332.953299999,4455282.0108 5793333.021299999,4455282.067599999 5793333.0512,4455282.1056 5793333.057,4455282.138199999 5793333.0569)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (154,154,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil. 1','Stein','Stein','NULL',0.192486761507,0.00194497503956,0.0257906288703,0.0670556350628,1, ST_GeomFromText('MULTIPOLYGON(((4455275.0524 5793333.049599999,4455275.0701 5793333.026,4455275.067099999 5793333.0097,4455275.0509 5793333.011299999,4455275.028599999 5793333.031799999,4455275.0148 5793333.041799999,4455275.001 5793333.0598,4455275.035699999 5793333.0676,4455275.0524 5793333.049599999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (155,155,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',2.1765843263,0.297540525189,0.252335058505,0.656071152112,1, ST_GeomFromText('MULTIPOLYGON(((4455282.3391 5793333.1017,4455282.3638 5793333.094599999,4455282.391499999 5793333.0905,4455282.415199999 5793333.0865,4455282.4369 5793333.081399999,4455282.464599999 5793333.0763,4455282.4883 5793333.070199999,4455282.512 5793333.065199999,4455282.535699999 5793333.0601,4455282.5624 5793333.052999999,4455282.5871 5793333.046,4455282.610799999 5793333.0379,4455282.6325 5793333.029899999,4455282.653199999 5793333.0228,4455282.673899999 5793333.0138,4455282.693699999 5793333.005799999,4455282.719399999 5793332.995699999,4455282.7401 5793332.9877,4455282.7618 5793332.9777,4455282.778599999 5793332.9677,4455282.797299999 5793332.9557,4455282.8151 5793332.946699999,4455282.8338 5793332.9337,4455282.8486 5793332.9217,4455282.8683 5793332.9067,4455282.8821 5793332.8947,4455282.8979 5793332.878699999,4455282.9117 5793332.8648,4455282.928399999 5793332.8508,4455282.940299999 5793332.835799999,4455282.953099999 5793332.8209,4455282.9659 5793332.8069,4455282.9796 5793332.789,4455282.992399999 5793332.774,4455283.0042 5793332.759099999,4455283.0151 5793332.740199999,4455283.0229 5793332.724199999,4455283.033699999 5793332.697399999,4455283.0415 5793332.675499999,4455283.047399999 5793332.6546,4455283.050999999 5793332.632899999,4455283.039099999 5793332.5897,4455283.019 5793332.5545,4455282.986499999 5793332.517799999,4455282.961799999 5793332.5028,4455282.923399999 5793332.4912,4455282.892599999 5793332.490299999,4455282.8589 5793332.491499999,4455282.830299999 5793332.4956,4455282.8046 5793332.501599999,4455282.776899999 5793332.5097,4455282.753299999 5793332.517799999,4455282.7296 5793332.526799999,4455282.706799999 5793332.5348,4455282.6901 5793332.542899999,4455282.672299999 5793332.550899999,4455282.648599999 5793332.5609,4455282.631799999 5793332.567999999,4455282.614099999 5793332.576999999,4455282.593299999 5793332.586999999,4455282.5696 5793332.597999999,4455282.553899999 5793332.606,4455282.529199999 5793332.6161,4455282.5114 5793332.624099999,4455282.493599999 5793332.632099999,4455282.4709 5793332.644099999,4455282.4532 5793332.6522,4455282.3969 5793332.6882,4455282.387099999 5793332.702099999,4455282.3852 5793332.7081,4455282.377299999 5793332.72,4455282.376299999 5793332.725999999,4455282.367499999 5793332.74,4455282.366499999 5793332.743899999,4455282.3567 5793332.758899999,4455282.3567 5793332.7619,4455282.348799999 5793332.7738,4455282.347799999 5793332.778799999,4455282.337 5793332.791699999,4455282.334999999 5793332.7967,4455282.3262 5793332.810699999,4455282.325199999 5793332.8166,4455282.3184 5793332.8286,4455282.316399999 5793332.8385,4455282.3085 5793332.8505,4455282.306599999 5793332.8574,4455282.297699999 5793332.8704,4455282.296799999 5793332.8734,4455282.291899999 5793332.8833,4455282.2872 5793332.949899999,4455282.285299999 5793332.9777,4455282.2834 5793333.0006,4455282.281499999 5793333.0215,4455282.277599999 5793333.047299999,4455282.2767 5793333.0741,4455282.2878 5793333.1005,4455282.315399999 5793333.1048,4455282.3391 5793333.1017)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (156,156,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil','Bettstein','Bettstein','NULL',2.33259730314,0.341949705045,0.286370253946,0.74456266026,1, ST_GeomFromText('MULTIPOLYGON(((4455280.0107 5793333.084899999,4455280.0235 5793333.0699,4455280.035299999 5793333.055999999,4455280.0471 5793333.042999999,4455280.059899999 5793333.0281,4455280.074699999 5793333.011099999,4455280.0875 5793332.998099999,4455280.1013 5793332.979199999,4455280.114099999 5793332.965199999,4455280.1249 5793332.954299999,4455280.1387 5793332.9373,4455280.1555 5793332.919399999,4455280.166299999 5793332.9074,4455280.182099999 5793332.8924,4455280.1929 5793332.879499999,4455280.204699999 5793332.8625,4455280.2185 5793332.8486,4455280.2333 5793332.831599999,4455280.2461 5793332.8166,4455280.2598 5793332.8037,4455280.273599999 5793332.790699999,4455280.2914 5793332.7737,4455280.301199999 5793332.7628,4455280.317999999 5793332.7488,4455280.331799999 5793332.734799999,4455280.3426 5793332.724799999,4455280.360299999 5793332.7059,4455280.376099999 5793332.690899999,4455280.393799999 5793332.6749,4455280.4027 5793332.664,4455280.419499999 5793332.646999999,4455280.433199999 5793332.6311,4455280.445 5793332.6072,4455280.450699999 5793332.591,4455280.4479 5793332.5774,4455280.446499999 5793332.554099999,4455280.430999999 5793332.514499999,4455280.415199999 5793332.4765,4455280.3891 5793332.4232,4455280.3677 5793332.3878,4455280.3355 5793332.371899999,4455280.3068 5793332.3793,4455280.2702 5793332.3735,4455280.2125 5793332.351199999,4455280.1831 5793332.345,4455280.131299999 5793332.3102,4455280.081199999 5793332.289599999,4455280.059399999 5793332.278,4455280.0345 5793332.274199999,4455279.9999 5793332.271299999,4455279.972199999 5793332.274399999,4455279.947499999 5793332.2795,4455279.922799999 5793332.287599999,4455279.8962 5793332.298599999,4455279.8848 5793332.310499999,4455279.883399999 5793332.3275,4455279.885499999 5793332.3563,4455279.8896 5793332.387,4455279.8897 5793332.4099,4455279.887799999 5793332.435699999,4455279.8869 5793332.4635,4455279.883 5793332.4864,4455279.8792 5793332.510299999,4455279.8753 5793332.531099999,4455279.8694 5793332.551999999,4455279.8557 5793332.595799999,4455279.848899999 5793332.607799999,4455279.836099999 5793332.630699999,4455279.8262 5793332.6466,4455279.816399999 5793332.660499999,4455279.8046 5793332.6775,4455279.792799999 5793332.6994,4455279.7909 5793332.728199999,4455279.7911 5793332.756999999,4455279.790099999 5793332.7739,4455279.792 5793332.8057,4455279.8052 5793332.8464,4455279.813199999 5793332.8791,4455279.816599999 5793332.903599999,4455279.839999999 5793332.951799999,4455279.8705 5793333.0041,4455279.900399999 5793333.0504,4455279.9286 5793333.079199999,4455279.9671 5793333.104,4455279.991 5793333.1048,4455280.0107 5793333.084899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (157,157,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil. 1','Stein','Stein','NULL',0.346024719358,0.0086593450143,0.030936522019,0.0804349572493,1, ST_GeomFromText('MULTIPOLYGON(((4455275.201799999 5793333.1127,4455275.215699999 5793333.095599999,4455275.2285 5793333.0767,4455275.227599999 5793333.0592,4455275.203999999 5793333.012299999,4455275.181699999 5793333.0107,4455275.163999999 5793333.024299999,4455275.149199999 5793333.032299999,4455275.1325 5793333.046299999,4455275.115699999 5793333.0603,4455275.1095 5793333.075099999,4455275.1209 5793333.0929,4455275.1434 5793333.109799999,4455275.172399999 5793333.1193,4455275.201799999 5793333.1127)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (158,158,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil. 1','Bettstein','Bettstein','NULL',2.63670056544,0.53242866999,0.43235333268,1.12411866497,1, ST_GeomFromText('MULTIPOLYGON(((4455277.9171 5793333.204199999,4455277.9488 5793333.201099999,4455277.9636 5793333.199599999,4455277.974399999 5793333.190999999,4455277.988199999 5793333.180999999,4455278.0109 5793333.164,4455278.022699999 5793333.1491,4455278.0345 5793333.134099999,4455278.0464 5793333.1202,4455278.058199999 5793333.103199999,4455278.071899999 5793333.0843,4455278.080799999 5793333.0664,4455278.090599999 5793333.049399999,4455278.099399999 5793333.027599999,4455278.109199999 5793333.0106,4455278.119099999 5793332.993699999,4455278.128899999 5793332.971799999,4455278.1387 5793332.950899999,4455278.145499999 5793332.930999999,4455278.1534 5793332.910099999,4455278.161199999 5793332.8922,4455278.1671 5793332.8683,4455278.1759 5793332.8464,4455278.1818 5793332.830499999,4455278.187599999 5793332.8066,4455278.191399999 5793332.776799999,4455278.1864 5793332.7485,4455278.1628 5793332.700699999,4455278.125199999 5793332.6337,4455278.114199999 5793332.617399999,4455278.1041 5793332.615499999,4455278.073599999 5793332.574999999,4455278.0124 5793332.517799999,4455277.949799999 5793332.471699999,4455277.910899999 5793332.452899999,4455277.8435 5793332.4195,4455277.8145 5793332.4122,4455277.786799999 5793332.413,4455277.760099999 5793332.416099999,4455277.7295 5793332.420199999,4455277.7028 5793332.4243,4455277.6791 5793332.4283,4455277.651399999 5793332.433399999,4455277.626699999 5793332.4405,4455277.604 5793332.444599999,4455277.580299999 5793332.448599999,4455277.556599999 5793332.4547,4455277.531899999 5793332.4637,4455277.5131 5793332.470799999,4455277.490399999 5793332.484799999,4455277.472699999 5793332.4978,4455277.456899999 5793332.508799999,4455277.438199999 5793332.5228,4455277.4254 5793332.5347,4455277.408599999 5793332.551699999,4455277.394799999 5793332.5677,4455277.380099999 5793332.584599999,4455277.370199999 5793332.595599999,4455277.3584 5793332.6125,4455277.347599999 5793332.6314,4455277.336799999 5793332.648399999,4455277.326 5793332.668299999,4455277.3152 5793332.6882,4455277.3073 5793332.705099999,4455277.2975 5793332.732,4455277.291699999 5793332.7529,4455277.292799999 5793332.779699999,4455277.2998 5793332.8124,4455277.3163 5793332.847999999,4455277.3392 5793332.8925,4455277.363699999 5793332.912799999,4455277.379599999 5793332.9515,4455277.395299999 5793332.969399999,4455277.410199999 5793332.9989,4455277.4391 5793333.034399999,4455277.455799999 5793333.0642,4455277.486999999 5793333.099899999,4455277.519199999 5793333.1466,4455277.549399999 5793333.167999999,4455277.583599999 5793333.182,4455277.608599999 5793333.1807,4455277.642199999 5793333.185499999,4455277.678799999 5793333.1883,4455277.713399999 5793333.193099999,4455277.745099999 5793333.195,4455277.7777 5793333.196799999,4455277.826299999 5793333.2002,4455277.856999999 5793333.202099999,4455277.8835 5793333.204299999,4455277.9171 5793333.204199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (159,159,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil. 1','Bettstein','Bettstein','NULL',2.52341730167,0.47969380512,0.391937332244,1.01903706383,1, ST_GeomFromText('MULTIPOLYGON(((4455276.5612 5793333.3441,4455276.5809 5793333.3341,4455276.597699999 5793333.3211,4455276.6144 5793333.306099999,4455276.6282 5793333.2892,4455276.639 5793333.2762,4455276.649899999 5793333.263299999,4455276.6666 5793333.2473,4455276.675499999 5793333.230399999,4455276.693199999 5793333.219399999,4455276.707 5793333.205399999,4455276.7218 5793333.192399999,4455276.7366 5793333.1804,4455276.752399999 5793333.1685,4455276.7701 5793333.1565,4455276.787899999 5793333.1445,4455276.801699999 5793333.137399999,4455276.825299999 5793333.1205,4455276.840099999 5793333.1095,4455276.8589 5793333.094499999,4455276.873599999 5793333.080499999,4455276.8874 5793333.062599999,4455276.899199999 5793333.0427,4455276.9061 5793333.019799999,4455276.9099 5793332.9909,4455276.910799999 5793332.9701,4455276.9127 5793332.942299999,4455276.909599999 5793332.911499999,4455276.9016 5793332.878699999,4455276.8896 5793332.843,4455276.8786 5793332.8081,4455276.849799999 5793332.760399999,4455276.796 5793332.7058,4455276.6221 5793332.5589,4455276.5519 5793332.5252,4455276.5256 5793332.5317,4455276.502899999 5793332.537699999,4455276.479199999 5793332.5478,4455276.4565 5793332.5558,4455276.4378 5793332.564799999,4455276.415099999 5793332.576799999,4455276.395299999 5793332.587799999,4455276.3786 5793332.597899999,4455276.358799999 5793332.610899999,4455276.343999999 5793332.618899999,4455276.3283 5793332.6259,4455276.306499999 5793332.6389,4455276.2878 5793332.6479,4455276.268099999 5793332.6609,4455276.2483 5793332.6719,4455276.232499999 5793332.6819,4455276.210799999 5793332.692999999,4455276.194099999 5793332.702999999,4455276.1753 5793332.713999999,4455276.157599999 5793332.725999999,4455276.1398 5793332.7399,4455276.1221 5793332.755899999,4455276.110299999 5793332.768899999,4455276.099499999 5793332.7958,4455276.0946 5793332.8176,4455276.0898 5793332.845499999,4455276.087899999 5793332.8703,4455276.083999999 5793332.8932,4455276.0821 5793332.915999999,4455276.0822 5793332.9458,4455276.080299999 5793332.968699999,4455276.081399999 5793332.9985,4455276.0865 5793333.0273,4455276.095499999 5793333.062999999,4455276.110399999 5793333.096699999,4455276.123599999 5793333.1279,4455276.1653 5793333.1706,4455276.2317 5793333.219799999,4455276.2982 5793333.257799999,4455276.398199999 5793333.3176,4455276.432699999 5793333.3364,4455276.456399999 5793333.3416,4455276.487999999 5793333.3484,4455276.5415 5793333.354499999,4455276.5612 5793333.3441)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (160,160,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil. 1','Bettstein','Bettstein','NULL',2.82631158746,0.601112505133,0.484992623934,1.26098082223,1, ST_GeomFromText('MULTIPOLYGON(((4455272.949699999 5793333.929899999,4455272.9773 5793333.9208,4455272.9961 5793333.913799999,4455273.0168 5793333.9097,4455273.044499999 5793333.9046,4455273.0732 5793333.902499999,4455273.1028 5793333.899399999,4455273.1215 5793333.886399999,4455273.142199999 5793333.867499999,4455273.155 5793333.853499999,4455273.1649 5793333.8405,4455273.177699999 5793333.8256,4455273.191499999 5793333.808599999,4455273.2033 5793333.791699999,4455273.2121 5793333.7738,4455273.224899999 5793333.754899999,4455273.234699999 5793333.736899999,4455273.2465 5793333.714999999,4455273.2553 5793333.6971,4455273.2651 5793333.679199999,4455273.274 5793333.662299999,4455273.2828 5793333.6433,4455273.2926 5793333.624399999,4455273.3024 5793333.6015,4455273.309299999 5793333.581599999,4455273.317099999 5793333.5568,4455273.321 5793333.5379,4455273.3239 5793333.515,4455273.324799999 5793333.489199999,4455273.328599999 5793333.4633,4455273.3276 5793333.436499999,4455273.323499999 5793333.404699999,4455273.3184 5793333.373999999,4455273.315399999 5793333.3462,4455273.3113 5793333.3124,4455273.3062 5793333.2826,4455273.301199999 5793333.2519,4455273.297799999 5793333.2289,4455273.2812 5793333.183399999,4455273.273099999 5793333.1477,4455273.265899999 5793333.126499999,4455273.249599999 5793333.1104,4455273.174899999 5793333.073699999,4455273.1386 5793333.0488,4455273.084999999 5793333.034499999,4455273.034599999 5793333.024399999,4455272.9998 5793333.0127,4455272.9642 5793333.007899999,4455272.935499999 5793333.009999999,4455272.9128 5793333.012099999,4455272.8792 5793333.021199999,4455272.856499999 5793333.0273,4455272.835699999 5793333.035299999,4455272.815 5793333.045299999,4455272.797199999 5793333.0534,4455272.776499999 5793333.0624,4455272.7558 5793333.0744,4455272.743999999 5793333.0874,4455272.724299999 5793333.1004,4455272.7055 5793333.114299999,4455272.689799999 5793333.1303,4455272.673999999 5793333.1453,4455272.6622 5793333.158199999,4455272.6484 5793333.1762,4455272.639499999 5793333.190099999,4455272.625799999 5793333.211999999,4455272.616 5793333.226999999,4455272.6012 5793333.2489,4455272.5902 5793333.263499999,4455272.5855 5793333.286699999,4455272.580599999 5793333.289699999,4455272.5777 5793333.3056,4455272.573699999 5793333.309599999,4455272.5718 5793333.3275,4455272.5689 5793333.330499999,4455272.561999999 5793333.3474,4455272.559 5793333.3494,4455272.5581 5793333.3604,4455272.552199999 5793333.3683,4455272.5493 5793333.385199999,4455272.5444 5793333.3912,4455272.542399999 5793333.405099999,4455272.537499999 5793333.410099999,4455272.5356 5793333.426999999,4455272.5307 5793333.429999999,4455272.529799999 5793333.451899999,4455272.5244 5793333.475199999,4455272.520499999 5793333.4966,4455272.517099999 5793333.5215,4455272.518199999 5793333.5284,4455272.517199999 5793333.5314,4455272.520299999 5793333.579099999,4455272.520399999 5793333.6029,4455272.521499999 5793333.631699999,4455272.523599999 5793333.6575,4455272.5266 5793333.6873,4455272.5317 5793333.715099999,4455272.5377 5793333.7509,4455272.5438 5793333.7826,4455272.5498 5793333.810399999,4455272.6133 5793333.8944,4455272.644999999 5793333.891499999,4455272.6786 5793333.8943,4455272.728299999 5793333.9008,4455272.771999999 5793333.907299999,4455272.8128 5793333.9153,4455272.8539 5793333.9227,4455272.891699999 5793333.9298,4455272.919999999 5793333.932,4455272.9378 5793333.9359,4455272.949699999 5793333.929899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (161,161,251,'Alv014',14,'Alv','Preuss 1973 Abb.17 u. Beil. 1','Bettstein','Bettstein','NULL',3.53377259188,0.89699210992,0.711754753043,1.85056235791,1, ST_GeomFromText('MULTIPOLYGON(((4455272.126199999 5793333.963199999,4455272.1578 5793333.9591,4455272.185499999 5793333.951099999,4455272.2072 5793333.944,4455272.2289 5793333.933,4455272.249699999 5793333.919999999,4455272.2674 5793333.906999999,4455272.288099999 5793333.891,4455272.3009 5793333.88,4455272.3167 5793333.864099999,4455272.3354 5793333.8461,4455272.347199999 5793333.831199999,4455272.359 5793333.817199999,4455272.370799999 5793333.8022,4455272.3826 5793333.784299999,4455272.3925 5793333.7664,4455272.4023 5793333.7475,4455272.414099999 5793333.728499999,4455272.423899999 5793333.708599999,4455272.431699999 5793333.688699999,4455272.442499999 5793333.6708,4455272.4533 5793333.6509,4455272.460199999 5793333.631999999,4455272.468999999 5793333.614099999,4455272.4769 5793333.5961,4455272.4867 5793333.576199999,4455272.517099999 5793333.5215,4455272.520499999 5793333.4966,4455272.5244 5793333.475199999,4455272.529799999 5793333.451899999,4455272.5307 5793333.429999999,4455272.5356 5793333.426999999,4455272.537499999 5793333.410099999,4455272.542399999 5793333.405099999,4455272.5444 5793333.3912,4455272.5493 5793333.385199999,4455272.552199999 5793333.3683,4455272.5581 5793333.3604,4455272.559 5793333.3494,4455272.561999999 5793333.3474,4455272.5689 5793333.330499999,4455272.5718 5793333.3275,4455272.573699999 5793333.309599999,4455272.5777 5793333.3056,4455272.580599999 5793333.289699999,4455272.5855 5793333.286699999,4455272.5902 5793333.263499999,4455272.5663 5793333.2432,4455272.5207 5793333.1771,4455272.474499999 5793333.117799999,4455272.3935 5793333.0437,4455272.3381 5793333.010299999,4455272.297399999 5793332.994699999,4455272.240699999 5793332.976099999,4455272.184999999 5793332.957,4455272.131599999 5793332.942999999,4455272.0921 5793332.9349,4455272.052299999 5793332.9283,4455272.017799999 5793332.9252,4455271.987099999 5793332.9227,4455271.9515 5793332.918899999,4455271.9208 5793332.916099999,4455271.8901 5793332.9162,4455271.8545 5793332.9144,4455271.819899999 5793332.913499999,4455271.792299999 5793332.914599999,4455271.761599999 5793332.916699999,4455271.728 5793332.915899999,4455271.697399999 5793332.914999999,4455271.666699999 5793332.9142,4455271.635099999 5793332.9133,4455271.606399999 5793332.9154,4455271.574799999 5793332.915599999,4455271.5421 5793332.9177,4455271.515499999 5793332.9218,4455271.4937 5793332.927799999,4455271.466099999 5793332.945299999,4455271.455299999 5793332.9578,4455271.4543 5793332.9638,4455271.4445 5793332.982699999,4455271.4357 5793333.007099999,4455271.4298 5793333.0324,4455271.4329 5793333.0622,4455271.434 5793333.089999999,4455271.438099999 5793333.118799999,4455271.438199999 5793333.1476,4455271.4402 5793333.172399999,4455271.440299999 5793333.1973,4455271.446399999 5793333.23,4455271.446499999 5793333.254899999,4455271.447599999 5793333.286699999,4455271.449599999 5793333.3155,4455271.4527 5793333.3482,4455271.457799999 5793333.379,4455271.461799999 5793333.4098,4455271.4659 5793333.436599999,4455271.4709 5793333.467399999,4455271.4769 5793333.494899999,4455271.4948 5793333.5347,4455271.5377 5793333.5863,4455271.593799999 5793333.632999999,4455271.6403 5793333.665899999,4455271.675699999 5793333.6839,4455271.853199999 5793333.836899999,4455271.9808 5793333.923399999,4455272.0601 5793333.9589,4455272.095599999 5793333.965399999,4455272.126199999 5793333.963199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (162,162,258,'Alv019',19,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',1.58301404255,0.191352339926,0.170952433319,0.44447632663,1, ST_GeomFromText('MULTIPOLYGON(((4455529.4972 5792590.2277,4455529.601599999 5792590.1807,4455529.691599999 5792590.082299999,4455529.729299999 5792589.980799999,4455529.709499999 5792589.8452,4455529.638799999 5792589.7692,4455529.504399999 5792589.738099999,4455529.393199999 5792589.771299999,4455529.312099999 5792589.8451,4455529.2319 5792589.991,4455529.217199999 5792590.080299999,4455529.227599999 5792590.139,4455529.2608 5792590.179999999,4455529.3419 5792590.229699999,4455529.408699999 5792590.243,4455529.4972 5792590.2277)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (163,163,258,'Alv019',19,'Alv','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',3.14711454738,0.720990364761,0.576867015553,1.49985424044,1, ST_GeomFromText('MULTIPOLYGON(((4455530.804299999 5792591.3197,4455530.875199999 5792591.284399999,4455531.2657 5792591.021099999,4455531.333899999 5792590.9373,4455531.3842 5792590.8087,4455531.3958 5792590.7167,4455531.3119 5792590.479599999,4455531.256099999 5792590.3942,4455531.1901 5792590.3432,4455531.072999999 5792590.324899999,4455530.9046 5792590.352099999,4455530.781999999 5792590.3954,4455530.635499999 5792590.491699999,4455530.5431 5792590.6018,4455530.4094 5792590.9834,4455530.3776 5792591.104699999,4455530.381599999 5792591.184299999,4455530.410699999 5792591.2247,4455530.5246 5792591.3033,4455530.603699999 5792591.330299999,4455530.715699999 5792591.333799999,4455530.804299999 5792591.3197)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (164,164,258,'Alv019',19,'Alv','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',3.60230521374,0.895354314882,0.710499546926,1.84729882201,1, ST_GeomFromText('MULTIPOLYGON(((4455528.565 5792591.9734,4455528.6639 5792591.9308,4455528.760599999 5792591.8516,4455528.954199999 5792591.601999999,4455529.0164 5792591.4757,4455529.081699999 5792591.2401,4455529.107499999 5792591.097899999,4455529.098199999 5792590.826199999,4455529.028699999 5792590.7484,4455528.891999999 5792590.676899999,4455528.769899999 5792590.6771,4455528.614099999 5792590.728099999,4455528.4703 5792590.8352,4455528.3397 5792591.051799999,4455528.273299999 5792591.261399999,4455528.173399999 5792591.4569,4455528.1434 5792591.560399999,4455528.1516 5792591.764299999,4455528.2039 5792591.8855,4455528.4011 5792591.996799999,4455528.565 5792591.9734)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (165,165,258,'Alv019',19,'Alv','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.67154593576,0.519056619704,0.422104993341,1.09747298269,1, ST_GeomFromText('MULTIPOLYGON(((4455532.4889 5792592.072899999,4455532.579599999 5792592.013199999,4455532.701899999 5792591.887399999,4455532.7811 5792591.754699999,4455532.769 5792591.6322,4455532.724299999 5792591.565099999,4455532.6342 5792591.4956,4455532.510099999 5792591.437,4455532.231599999 5792591.4208,4455531.9489 5792591.460599999,4455531.841099999 5792591.536,4455531.765399999 5792591.667999999,4455531.767199999 5792591.7489,4455531.7927 5792591.806199999,4455531.9451 5792591.9535,4455532.069 5792592.0238,4455532.3084 5792592.091199999,4455532.3847 5792592.0964,4455532.4889 5792592.072899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (166,166,258,'Alv019',19,'Alv','Stuhlmann','Stein','Stein','NULL',1.09684001629,0.0824722700856,0.0875067477936,0.227517544263,1, ST_GeomFromText('MULTIPOLYGON(((4455530.874499999 5792592.268699999,4455530.966199999 5792592.2028,4455530.9912 5792592.151499999,4455530.965099999 5792592.0131,4455530.8854 5792591.9625,4455530.811499999 5792591.981699999,4455530.7581 5792592.0283,4455530.674599999 5792592.164899999,4455530.6458 5792592.2672,4455530.666 5792592.3167,4455530.7229 5792592.334,4455530.874499999 5792592.268699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (167,167,258,'Alv019',19,'Alv','Stuhlmann','Deckstein, gesprengt','Deckstein','NULL',2.6124247092,0.475329284656,0.38859236376,1.01034014578,1, ST_GeomFromText('MULTIPOLYGON(((4455531.8661 5792593.354399999,4455532.031499999 5792593.2715,4455532.137299999 5792593.192099999,4455532.2274 5792593.0799,4455532.427699999 5792592.776599999,4455532.432099999 5792592.700099999,4455532.3891 5792592.645099999,4455532.204499999 5792592.5622,4455532.042 5792592.535199999,4455531.8759 5792592.5938,4455531.7012 5792592.763299999,4455531.6063 5792592.9567,4455531.5678 5792593.1257,4455531.587399999 5792593.2333,4455531.625599999 5792593.318099999,4455531.6797 5792593.367399999,4455531.757899999 5792593.379899999,4455531.8661 5792593.354399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (168,168,258,'Alv019',19,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',3.3047659327,0.756126349551,0.603795234296,1.56986760917,1, ST_GeomFromText('MULTIPOLYGON(((4455533.241799999 5792593.7772,4455533.3025 5792593.7247,4455533.4517 5792593.459899999,4455533.5564 5792593.1818,4455533.6578 5792593.014599999,4455533.6672 5792592.9231,4455533.6314 5792592.8306,4455533.492499999 5792592.6849,4455533.3573 5792592.616,4455533.1655 5792592.6093,4455533.0701 5792592.6673,4455532.8881 5792592.9583,4455532.775899999 5792593.2839,4455532.7525 5792593.526799999,4455532.7932 5792593.6632,4455532.8645 5792593.7366,4455532.971599999 5792593.7979,4455533.144999999 5792593.819499999,4455533.241799999 5792593.7772)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (169,169,258,'Alv019',19,'Alv','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',4.05548935597,1.11402975597,0.878092404974,2.28304025293,1, ST_GeomFromText('MULTIPOLYGON(((4455530.952899999 5792594.156899999,4455531.098699999 5792594.1179,4455531.212299999 5792594.0811,4455531.2751 5792594.0203,4455531.325199999 5792593.911,4455531.3528 5792593.6553,4455531.3123 5792593.500499999,4455531.2432 5792593.391499999,4455531.1798 5792593.337799999,4455531.0652 5792593.288499999,4455530.8251 5792593.261499999,4455530.495199999 5792593.2999,4455530.3771 5792593.3321,4455530.112499999 5792593.432499999,4455529.910199999 5792593.5537,4455529.841199999 5792593.628,4455529.781399999 5792593.7594,4455529.7854 5792593.835699999,4455529.8612 5792593.970499999,4455529.912899999 5792594.0217,4455530.009399999 5792594.0731,4455530.5042 5792594.1127,4455530.6699 5792594.1497,4455530.8113 5792594.159299999,4455530.952899999 5792594.156899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (170,170,260,'Alv023',23,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',2.83222575995,0.61078368999,0.492404620008,1.28025201202,1, ST_GeomFromText('MULTIPOLYGON(((4455495.4934 5792389.7431,4455495.631799999 5792389.6369,4455495.7279 5792389.4251,4455495.7684 5792389.139499999,4455495.731999999 5792389.016499999,4455495.6819 5792388.944399999,4455495.6173 5792388.8891,4455495.404 5792388.8078,4455495.3068 5792388.806099999,4455495.246299999 5792388.8253,4455494.9549 5792389.004599999,4455494.906899999 5792389.0526,4455494.8865 5792389.103499999,4455494.8918 5792389.253299999,4455494.9144 5792389.3167,4455495.057699999 5792389.536399999,4455495.1326 5792389.613199999,4455495.2554 5792389.689799999,4455495.415699999 5792389.752299999,4455495.4934 5792389.7431)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (171,171,260,'Alv023',23,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',2.52792115574,0.482889165429,0.394386256385,1.0254042666,1, ST_GeomFromText('MULTIPOLYGON(((4455492.060499999 5792389.695299999,4455492.187499999 5792389.653899999,4455492.277499999 5792389.5874,4455492.3354 5792389.513299999,4455492.347099999 5792389.443299999,4455492.172699999 5792389.106899999,4455492.105299999 5792389.0162,4455491.969399999 5792388.908199999,4455491.848399999 5792388.909499999,4455491.7004 5792388.9527,4455491.560999999 5792389.087899999,4455491.5343 5792389.135399999,4455491.504099999 5792389.254599999,4455491.512099999 5792389.3673,4455491.5625 5792389.4954,4455491.602099999 5792389.5412,4455491.709999999 5792389.609699999,4455491.8617 5792389.6719,4455491.953999999 5792389.6969,4455492.060499999 5792389.695299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (172,172,260,'Alv023',23,'Alv','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.20034763461,0.34748999541,0.290616332483,0.755602464455,1, ST_GeomFromText('MULTIPOLYGON(((4455491.328999999 5792391.2385,4455491.4172 5792391.129499999,4455491.416699999 5792391.0537,4455491.200899999 5792390.761399999,4455491.0844 5792390.661499999,4455490.968899999 5792390.6052,4455490.802299999 5792390.6291,4455490.7297 5792390.6817,4455490.672699999 5792390.777599999,4455490.6682 5792390.8991,4455490.701399999 5792391.0197,4455490.8103 5792391.1497,4455491.112399999 5792391.2739,4455491.227599999 5792391.2837,4455491.328999999 5792391.2385)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (173,173,260,'Alv023',23,'Alv','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.72188128604,0.549950664996,0.445782189653,1.1590336931,1, ST_GeomFromText('MULTIPOLYGON(((4455490.639299999 5792391.6071,4455490.6983 5792391.525299999,4455490.725999999 5792391.411399999,4455490.6561 5792391.228199999,4455490.5645 5792391.1049,4455490.429399999 5792391.0273,4455490.320899999 5792391.030799999,4455490.1304 5792391.096,4455489.798299999 5792391.291799999,4455489.761599999 5792391.377699999,4455489.784099999 5792391.497899999,4455489.8436 5792391.6457,4455489.923299999 5792391.720499999,4455490.1078 5792391.838199999,4455490.201299999 5792391.8571,4455490.639299999 5792391.6071)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (174,174,260,'Alv023',23,'Alv','Stuhlmann','Bettstein','Bettstein','NULL',2.25226762008,0.38819604029,0.321813445279,0.836714957724,1, ST_GeomFromText('MULTIPOLYGON(((4455489.070899999 5792393.0434,4455489.1801 5792392.9449,4455489.2246 5792392.8355,4455489.2004 5792392.697399999,4455489.091699999 5792392.479399999,4455488.9884 5792392.3801,4455488.8914 5792392.3472,4455488.7647 5792392.371099999,4455488.624499999 5792392.4382,4455488.518899999 5792392.528999999,4455488.4819 5792392.620699999,4455488.4883 5792392.7017,4455488.555499999 5792392.876099999,4455488.667399999 5792392.968599999,4455488.8457 5792393.0445,4455489.012699999 5792393.0592,4455489.070899999 5792393.0434)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (175,175,260,'Alv023',23,'Alv','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',3.56634772445,0.839610045424,0.667777138813,1.73622056091,1, ST_GeomFromText('MULTIPOLYGON(((4455490.4192 5792393.107499999,4455490.5608 5792392.978399999,4455490.588899999 5792392.911699999,4455490.580699999 5792392.810599999,4455490.4773 5792392.5576,4455490.279099999 5792392.260199999,4455490.125199999 5792392.094799999,4455489.952999999 5792391.9833,4455489.8781 5792391.955199999,4455489.6955 5792391.930099999,4455489.5877 5792391.948,4455489.5065 5792392.010999999,4455489.4769 5792392.067999999,4455489.471099999 5792392.257899999,4455489.494599999 5792392.3921,4455489.542799999 5792392.5032,4455489.624699999 5792392.6315,4455489.799599999 5792392.7828,4455489.9555 5792392.946,4455490.175599999 5792393.129499999,4455490.3331 5792393.1511,4455490.4192 5792393.107499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (176,176,260,'Alv023',23,'Alv','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.64461034007,0.530957400507,0.431225751748,1.12118695455,1, ST_GeomFromText('MULTIPOLYGON(((4455491.913099999 5792393.206499999,4455492.088899999 5792393.15,4455492.224799999 5792393.0569,4455492.313099999 5792392.9249,4455492.332999999 5792392.830099999,4455492.323599999 5792392.7486,4455492.2361 5792392.569499999,4455492.118499999 5792392.4285,4455492.036999999 5792392.404999999,4455491.873999999 5792392.4111,4455491.6216 5792392.535499999,4455491.431699999 5792392.678099999,4455491.409799999 5792392.739399999,4455491.4143 5792392.7948,4455491.506099999 5792392.9612,4455491.6627 5792393.1325,4455491.846699999 5792393.2071,4455491.913099999 5792393.206499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (177,177,260,'Alv023',23,'Alv','Stuhlmann','Bettstein','Bettstein','NULL',2.77476532437,0.540112565196,0.438242269966,1.13942990191,1, ST_GeomFromText('MULTIPOLYGON(((4455490.843399999 5792394.5949,4455490.895999999 5792394.5501,4455490.9445 5792394.470599999,4455490.949 5792394.389499999,4455490.7554 5792394.1278,4455490.4746 5792393.884299999,4455490.2629 5792393.814899999,4455490.1117 5792393.8241,4455490.0536 5792393.864399999,4455490.0272 5792393.924,4455490.011099999 5792394.0818,4455490.048 5792394.2407,4455490.1297 5792394.420299999,4455490.234899999 5792394.546,4455490.300999999 5792394.5907,4455490.447399999 5792394.645099999,4455490.6375 5792394.6555,4455490.843399999 5792394.5949)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (178,178,260,'Alv023',23,'Alv','Stuhlmann','Bettstein','Bettstein','NULL',2.92174274968,0.626726295319,0.504623032732,1.3120198851,1, ST_GeomFromText('MULTIPOLYGON(((4455492.1775 5792395.026399999,4455492.358699999 5792394.9185,4455492.429899999 5792394.8516,4455492.5585 5792394.6665,4455492.588899999 5792394.5853,4455492.592899999 5792394.4995,4455492.542999999 5792394.433299999,4455492.280799999 5792394.305199999,4455491.933199999 5792394.265,4455491.8408 5792394.285499999,4455491.699099999 5792394.3516,4455491.520399999 5792394.501399999,4455491.502 5792394.5555,4455491.5164 5792394.6511,4455491.703099999 5792394.934,4455491.826299999 5792395.0303,4455492.0404 5792395.059699999,4455492.1775 5792395.026399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (179,179,260,'Alv023',23,'Alv','Stuhlmann','Bettstein','Bettstein','NULL',2.55949536797,0.508308899871,0.413867940861,1.07605664624,1, ST_GeomFromText('MULTIPOLYGON(((4455493.803399999 5792395.560399999,4455493.968 5792395.444599999,4455493.997399999 5792395.370799999,4455494.002199999 5792395.1557,4455493.9515 5792394.969399999,4455493.8501 5792394.834499999,4455493.7105 5792394.7793,4455493.5087 5792394.7803,4455493.3633 5792394.831299999,4455493.270499999 5792394.926999999,4455493.2313 5792395.045399999,4455493.2361 5792395.235099999,4455493.2717 5792395.331,4455493.399699999 5792395.4976,4455493.514999999 5792395.5745,4455493.634399999 5792395.603,4455493.803399999 5792395.560399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (180,180,262,'Alv025',25,'Alv','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.66040485389,0.522193480223,0.424509083243,1.10372361643,1, ST_GeomFromText('MULTIPOLYGON(((4455456.459699999 5792225.6282,4455456.6079 5792225.802699999,4455456.750199999 5792225.942399999,4455456.840599999 5792225.9985,4455456.946999999 5792226.004,4455457.107699999 5792225.9121,4455457.187599999 5792225.6936,4455457.1902 5792225.600099999,4455457.1626 5792225.494899999,4455457.080599999 5792225.345899999,4455456.953999999 5792225.182,4455456.8035 5792225.096,4455456.644799999 5792225.1072,4455456.535 5792225.155099999,4455456.406 5792225.2685,4455456.361999999 5792225.3494,4455456.359899999 5792225.4571,4455456.459699999 5792225.6282)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (181,181,262,'Alv025',25,'Alv','Stuhlmann','Stein','Stein','NULL',1.80753061237,0.243960275085,0.211271154825,0.549305002546,1, ST_GeomFromText('MULTIPOLYGON(((4455453.845599999 5792222.4021,4455454.054899999 5792222.444199999,4455454.24 5792222.427799999,4455454.295699999 5792222.3942,4455454.3562 5792222.300699999,4455454.395899999 5792222.1543,4455454.3886 5792222.0394,4455454.332299999 5792221.9658,4455454.2483 5792221.9251,4455454.110299999 5792221.9111,4455453.981499999 5792221.978599999,4455453.8634 5792222.0928,4455453.802899999 5792222.304899999,4455453.811999999 5792222.3614,4455453.845599999 5792222.4021)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (182,182,262,'Alv025',25,'Alv','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.62308636407,0.514317175116,0.418472683009,1.08802897582,1, ST_GeomFromText('MULTIPOLYGON(((4455456.4872 5792226.9612,4455456.8129 5792226.963999999,4455456.916199999 5792226.913499999,4455457.039699999 5792226.7659,4455457.1227 5792226.508199999,4455457.1281 5792226.425499999,4455457.1019 5792226.305199999,4455457.0317 5792226.240199999,4455456.893199999 5792226.187499999,4455456.753999999 5792226.1784,4455456.626899999 5792226.2137,4455456.4671 5792226.3288,4455456.3332 5792226.534399999,4455456.270899999 5792226.786199999,4455456.313299999 5792226.882799999,4455456.4872 5792226.9612)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (183,183,262,'Alv025',25,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',3.7678028169,1.05922121435,0.836087138679,2.17382656057,1, ST_GeomFromText('MULTIPOLYGON(((4455455.087199999 5792226.781199999,4455455.257899999 5792226.9088,4455455.4581 5792226.987099999,4455455.597099999 5792227.031199999,4455455.663499999 5792226.996799999,4455455.840599999 5792226.914599999,4455455.952399999 5792226.7937,4455456.014399999 5792226.626299999,4455456.0546 5792226.4119,4455456.099999999 5792226.284499999,4455456.109199999 5792226.1728,4455456.093399999 5792226.005499999,4455456.0255 5792225.924499999,4455455.9318 5792225.8712,4455455.786799999 5792225.853199999,4455455.582399999 5792225.853499999,4455455.445299999 5792225.8988,4455455.008899999 5792226.1431,4455454.930999999 5792226.221499999,4455454.8804 5792226.3372,4455454.894199999 5792226.4647,4455454.9641 5792226.6238,4455455.087199999 5792226.781199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (184,184,262,'Alv025',25,'Alv','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',3.47777247916,0.766662629933,0.611870239581,1.59086262291,1, ST_GeomFromText('MULTIPOLYGON(((4455453.4407 5792224.7278,4455453.5257 5792224.859999999,4455453.6743 5792224.9856,4455453.8229 5792225.0327,4455453.935999999 5792224.982599999,4455454.1402 5792224.808299999,4455454.3622 5792224.657899999,4455454.436999999 5792224.559699999,4455454.436599999 5792224.475999999,4455454.389499999 5792224.427799999,4455454.229899999 5792224.344799999,4455453.9358 5792224.2475,4455453.609799999 5792224.071399999,4455453.384499999 5792224.0521,4455453.215599999 5792224.098899999,4455453.142199999 5792224.1521,4455453.1177 5792224.206,4455453.184899999 5792224.404899999,4455453.319899999 5792224.6072,4455453.4407 5792224.7278)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (185,185,262,'Alv025',25,'Alv','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',3.64783217592,0.882917594508,0.700968044431,1.82251691552,1, ST_GeomFromText('MULTIPOLYGON(((4455455.377299999 5792227.7617,4455455.807099999 5792227.912599999,4455455.9205 5792227.916899999,4455456.0733 5792227.849199999,4455456.1402 5792227.812699999,4455456.221699999 5792227.728499999,4455456.4466 5792227.444299999,4455456.539099999 5792227.2916,4455456.610999999 5792227.1256,4455456.579499999 5792227.0676,4455456.4159 5792227.0084,4455456.2626 5792226.889799999,4455456.187599999 5792226.8615,4455456.099499999 5792226.8814,4455455.879399999 5792226.9856,4455455.7264 5792227.100199999,4455455.603099999 5792227.1563,4455455.438 5792227.3012,4455455.3841 5792227.398399999,4455455.247299999 5792227.536699999,4455455.226999999 5792227.5917,4455455.2608 5792227.683299999,4455455.377299999 5792227.7617)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (186,186,262,'Alv025',25,'Alv','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',3.13664186386,0.63899273965,0.514024035668,1.33646249274,1, ST_GeomFromText('MULTIPOLYGON(((4455453.6331 5792225.8967,4455453.680399999 5792225.965299999,4455453.894 5792226.1849,4455453.971599999 5792226.292999999,4455454.1703 5792226.4506,4455454.326799999 5792226.5174,4455454.4242 5792226.523399999,4455454.5113 5792226.4989,4455454.5892 5792226.4371,4455454.618499999 5792226.3768,4455454.616299999 5792226.3033,4455454.589399999 5792226.2203,4455454.3946 5792225.848699999,4455454.207499999 5792225.6137,4455454.017199999 5792225.461699999,4455453.951 5792225.4547,4455453.7231 5792225.552699999,4455453.6287 5792225.6685,4455453.588399999 5792225.756999999,4455453.592 5792225.819,4455453.6331 5792225.8967)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (187,187,264,'Alv027',27,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',3.72846286088,0.990124249782,0.783131225033,2.03614118509,1, ST_GeomFromText('MULTIPOLYGON(((4455368.852699999 5791843.1347,4455368.8952 5791843.0328,4455368.905899999 5791842.870999999,4455368.8547 5791842.744,4455368.7937 5791842.691899999,4455368.242999999 5791842.4285,4455368.096099999 5791842.3836,4455367.952399999 5791842.376399999,4455367.7843 5791842.4143,4455367.637799999 5791842.526499999,4455367.559399999 5791842.627499999,4455367.514999999 5791842.784199999,4455367.5378 5791842.838899999,4455367.6242 5791842.9374,4455367.875199999 5791843.1774,4455368.196499999 5791843.385299999,4455368.282899999 5791843.4254,4455368.354299999 5791843.432499999,4455368.728799999 5791843.2817,4455368.852699999 5791843.1347)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (188,188,264,'Alv027',27,'Alv','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',3.85811610244,0.879838719697,0.698608394776,1.81638182642,1, ST_GeomFromText('MULTIPOLYGON(((4455368.901999999 5791845.9417,4455368.942699999 5791845.874999999,4455368.9839 5791845.7233,4455368.9604 5791845.5755,4455368.8392 5791845.3089,4455368.6189 5791845.029699999,4455368.453399999 5791844.887599999,4455368.300099999 5791844.6511,4455368.199699999 5791844.5821,4455368.112399999 5791844.5897,4455368.008299999 5791844.659199999,4455367.866799999 5791844.8132,4455367.8069 5791844.925599999,4455367.7938 5791844.991,4455367.823499999 5791845.085999999,4455368.0754 5791845.416999999,4455368.3095 5791845.664,4455368.625799999 5791845.936799999,4455368.7723 5791846.007899999,4455368.847599999 5791845.9908,4455368.901999999 5791845.9417)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (189,189,264,'Alv027',27,'Alv','Stuhlmann','Deckstein','Deckstein','NULL',5.0174818865,1.87658226471,1.46251264767,3.80253288395,1, ST_GeomFromText('MULTIPOLYGON(((4455372.316899999 5791842.934299999,4455372.355499999 5791842.8749,4455372.342799999 5791842.780799999,4455372.325299999 5791842.593399999,4455372.201899999 5791842.247899999,4455372.115799999 5791842.122899999,4455371.988199999 5791841.9746,4455371.9089 5791841.8946,4455371.5639 5791841.695499999,4455371.333599999 5791841.6695,4455371.2247 5791841.7037,4455371.079599999 5791841.8768,4455370.9434 5791842.043099999,4455370.694099999 5791842.290999999,4455370.6539 5791842.380899999,4455370.6342 5791842.481899999,4455370.646499999 5791842.5382,4455370.8293 5791842.887199999,4455371.036799999 5791843.060399999,4455371.210699999 5791843.1468,4455371.382299999 5791843.178799999,4455371.498599999 5791843.23,4455371.798499999 5791843.153799999,4455371.9297 5791843.14,4455372.1436 5791843.043199999,4455372.316899999 5791842.934299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (190,190,264,'Alv027',27,'Alv','Stuhlmann','Deckstein','Deckstein','NULL',6.13890764504,2.76819130479,2.14584181599,5.57918872158,1, ST_GeomFromText('MULTIPOLYGON(((4455370.754499999 5791844.504799999,4455370.862499999 5791844.377699999,4455371.1237 5791844.1412,4455371.1731 5791844.074999999,4455371.305599999 5791843.887299999,4455371.3309 5791843.7149,4455371.241799999 5791843.582299999,4455371.127999999 5791843.471499999,4455370.9967 5791843.253599999,4455370.7608 5791842.993699999,4455370.677199999 5791842.9414,4455370.5859 5791842.800499999,4455370.4988 5791842.716399999,4455370.401399999 5791842.665699999,4455370.251699999 5791842.6479,4455369.8628 5791842.863199999,4455369.7017 5791843.0019,4455369.5212 5791843.2785,4455369.500099999 5791843.335699999,4455369.4934 5791843.4122,4455369.513 5791843.538499999,4455369.490199999 5791843.996799999,4455369.5152 5791844.1797,4455369.549499999 5791844.284299999,4455369.617999999 5791844.4086,4455369.7603 5791844.574799999,4455369.911999999 5791844.676899999,4455369.9808 5791844.7429,4455370.062599999 5791844.785599999,4455370.177299999 5791844.827299999,4455370.3556 5791844.828999999,4455370.5327 5791844.7451,4455370.754499999 5791844.504799999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (191,191,264,'Alv027',27,'Alv','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',1.78848558218,0.23442330498,0.203962020936,0.530301254434,1, ST_GeomFromText('MULTIPOLYGON(((4455371.182199999 5791844.826999999,4455371.196999999 5791844.7287,4455371.1704 5791844.637599999,4455371.115899999 5791844.567999999,4455370.968899999 5791844.4866,4455370.754499999 5791844.504799999,4455370.5327 5791844.7451,4455370.642599999 5791844.8902,4455370.763299999 5791844.950899999,4455370.971099999 5791844.970399999,4455371.079099999 5791844.9417,4455371.1445 5791844.8945,4455371.182199999 5791844.826999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (192,192,264,'Alv027',27,'Alv','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',3.02161440444,0.664381910078,0.533482295883,1.3870539693,1, ST_GeomFromText('MULTIPOLYGON(((4455370.0239 5791846.077999999,4455370.146399999 5791845.864,4455370.160899999 5791845.650699999,4455370.1184 5791845.5919,4455369.898 5791845.4613,4455369.8311 5791845.4416,4455369.7592 5791845.443399999,4455369.567099999 5791845.527899999,4455369.383 5791845.703099999,4455369.2904 5791845.905899999,4455369.281299999 5791846.109699999,4455369.3425 5791846.271099999,4455369.496399999 5791846.4417,4455369.593299999 5791846.496099999,4455369.7267 5791846.501099999,4455369.8124 5791846.4865,4455369.867499999 5791846.4382,4455370.0239 5791846.077999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (193,193,269,'Alv032',32,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',3.19045079987,0.758431304928,0.605561752097,1.57446055545,1, ST_GeomFromText('MULTIPOLYGON(((4455706.0009 5791033.527599999,4455706.0952 5791033.469299999,4455706.144999999 5791033.3737,4455706.1507 5791033.266699999,4455706.138899999 5791033.1808,4455706.109 5791033.0711,4455706.067099999 5791032.981499999,4455705.8546 5791032.6906,4455705.6309 5791032.540799999,4455705.5244 5791032.501299999,4455705.465499999 5791032.4975,4455705.413099999 5791032.525299999,4455705.319899999 5791032.6081,4455705.2466 5791032.6962,4455705.1979 5791032.7826,4455705.178999999 5791032.912399999,4455705.230899999 5791033.226199999,4455705.307099999 5791033.360799999,4455705.478299999 5791033.495999999,4455705.633899999 5791033.558299999,4455705.724899999 5791033.57,4455705.857599999 5791033.575899999,4455706.0009 5791033.527599999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (194,194,269,'Alv032',32,'Alv','Stuhlmann','Deckstein','Deckstein','NULL',5.50936763573,1.96401211484,1.52951888481,3.97674910051,1, ST_GeomFromText('MULTIPOLYGON(((4455702.8985 5791035.1565,4455702.9696 5791035.1202,4455703.0822 5791034.9878,4455703.132 5791034.880799999,4455703.257 5791034.6883,4455703.285699999 5791034.605499999,4455703.289699999 5791034.524599999,4455703.271999999 5791034.403999999,4455703.175499999 5791034.199999999,4455703.0981 5791034.084,4455702.889899999 5791033.849799999,4455702.5563 5791033.556199999,4455702.235999999 5791033.3175,4455702.0718 5791033.2301,4455702.0115 5791033.2135,4455701.8946 5791033.2145,4455701.776499999 5791033.2542,4455701.689399999 5791033.3188,4455701.6605 5791033.3571,4455701.614799999 5791033.501199999,4455701.619699999 5791033.5822,4455701.819099999 5791034.037299999,4455701.8618 5791034.188899999,4455701.9116 5791034.2934,4455701.9784 5791034.3923,4455702.0344 5791034.566299999,4455702.2448 5791034.9141,4455702.303199999 5791034.992699999,4455702.364099999 5791035.0456,4455702.517099999 5791035.129599999,4455702.839599999 5791035.1675,4455702.8985 5791035.1565)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (195,195,269,'Alv032',32,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',3.39687823156,0.884553864818,0.702222081996,1.82577741319,1, ST_GeomFromText('MULTIPOLYGON(((4455704.900299999 5791035.229199999,4455705.100399999 5791035.167899999,4455705.168499999 5791035.1082,4455705.224 5791034.9864,4455705.326299999 5791034.831199999,4455705.3644 5791034.7137,4455705.3693 5791034.585899999,4455705.3086 5791034.3672,4455705.2311 5791034.2683,4455705.1632 5791034.2111,4455705.036299999 5791034.1389,4455704.923899999 5791034.102299999,4455704.6533 5791034.0806,4455704.5175 5791034.1334,4455704.427899999 5791034.3003,4455704.3936 5791034.463899999,4455704.384999999 5791034.702899999,4455704.4649 5791034.953299999,4455704.508299999 5791035.024199999,4455704.686499999 5791035.184499999,4455704.779 5791035.217,4455704.8437 5791035.233899999,4455704.900299999 5791035.229199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (196,196,269,'Alv032',32,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',2.22077756266,0.360060809536,0.300250604428,0.780651571514,1, ST_GeomFromText('MULTIPOLYGON(((4455706.020299999 5791035.8848,4455706.216199999 5791035.779799999,4455706.257 5791035.7223,4455706.2576 5791035.6555,4455706.2028 5791035.535,4455706.097099999 5791035.4197,4455705.9949 5791035.3659,4455705.837899999 5791035.3561,4455705.7214 5791035.387199999,4455705.6527 5791035.4227,4455705.450299999 5791035.6421,4455705.4269 5791035.684499999,4455705.425499999 5791035.7312,4455705.474499999 5791035.8471,4455705.5186 5791035.887599999,4455705.655399999 5791035.936899999,4455705.8118 5791035.9538,4455706.020299999 5791035.8848)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (197,197,269,'Alv032',32,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',2.88399997565,0.560856094978,0.454140111191,1.1807642891,1, ST_GeomFromText('MULTIPOLYGON(((4455705.0268 5791037.281899999,4455705.239699999 5791037.1685,4455705.2585 5791037.1467,4455705.257399999 5791037.0305,4455705.319299999 5791036.848799999,4455705.3344 5791036.706599999,4455705.367499999 5791036.577999999,4455705.3743 5791036.4392,4455705.3513 5791036.3541,4455705.319299999 5791036.301799999,4455705.213499999 5791036.212999999,4455705.126099999 5791036.1761,4455705.0327 5791036.174799999,4455704.871899999 5791036.287299999,4455704.8232 5791036.368599999,4455704.724999999 5791036.649399999,4455704.7176 5791036.697599999,4455704.7437 5791036.899599999,4455704.741999999 5791037.0017,4455704.7691 5791037.145999999,4455704.8068 5791037.221899999,4455704.864799999 5791037.2705,4455704.9433 5791037.2904,4455705.0268 5791037.281899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (198,198,269,'Alv032',32,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',2.7673388659,0.467308664944,0.382445360813,0.994357938113,1, ST_GeomFromText('MULTIPOLYGON(((4455708.104899999 5791037.4339,4455708.2242 5791037.323499999,4455708.2422 5791037.287699999,4455708.2399 5791037.251,4455708.2207 5791037.1992,4455708.2198 5791037.117599999,4455708.250199999 5791036.967199999,4455708.2866 5791036.885199999,4455708.406 5791036.7411,4455708.419599999 5791036.6476,4455708.321 5791036.4594,4455708.205 5791036.4184,4455708.1193 5791036.419999999,4455707.9993 5791036.479199999,4455707.7959 5791036.662499999,4455707.750699999 5791036.7532,4455707.7322 5791036.898499999,4455707.836699999 5791037.2092,4455707.869199999 5791037.3582,4455707.939399999 5791037.467199999,4455708.008999999 5791037.483899999,4455708.104899999 5791037.4339)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (199,199,269,'Alv032',32,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',2.26738654345,0.389249965111,0.322621173261,0.838815050478,1, ST_GeomFromText('MULTIPOLYGON(((4455708.815 5791037.989499999,4455708.859299999 5791037.9207,4455708.9126 5791037.7158,4455708.9062 5791037.470799999,4455708.859699999 5791037.358999999,4455708.8201 5791037.307499999,4455708.723299999 5791037.240399999,4455708.615699999 5791037.2309,4455708.4615 5791037.3015,4455708.3846 5791037.3694,4455708.2806 5791037.552799999,4455708.2673 5791037.6596,4455708.3403 5791037.8471,4455708.458899999 5791037.9428,4455708.6577 5791038.0153,4455708.723199999 5791038.016,4455708.815 5791037.989499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (200,200,269,'Alv032',32,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',1.68574887746,0.209916824992,0.185180254674,0.481468662153,1, ST_GeomFromText('MULTIPOLYGON(((4455708.150999999 5791038.359999999,4455708.195 5791038.2817,4455708.213499999 5791038.217199999,4455708.257899999 5791038.0478,4455708.213299999 5791037.9483,4455707.927199999 5791037.857899999,4455707.874099999 5791037.854399999,4455707.851499999 5791037.8671,4455707.7807 5791037.9877,4455707.7516 5791038.085999999,4455707.7591 5791038.2683,4455707.7812 5791038.3089,4455707.923299999 5791038.3694,4455708.099299999 5791038.3946,4455708.150999999 5791038.359999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (201,201,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Gang','Gang','NULL',2.16745858942,0.343340939949,0.287436496377,0.747334890579,1, ST_GeomFromText('MULTIPOLYGON(((4455429.4696 5793676.085699999,4455429.558899999 5793675.9832,4455429.638199999 5793675.860799999,4455429.7011 5793675.738399999,4455429.7143 5793675.659099999,4455429.641499999 5793675.5896,4455429.5026 5793675.496999999,4455429.4001 5793675.463899999,4455429.254599999 5793675.480499999,4455429.0958 5793675.543299999,4455428.9999 5793675.6028,4455428.937099999 5793675.702099999,4455428.99 5793675.8112,4455429.0826 5793675.943499999,4455429.1851 5793676.0328,4455429.3075 5793676.105499999,4455429.3803 5793676.138599999,4455429.4696 5793676.085699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (202,202,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Gang','Gang','NULL',0.962621481073,0.0681328752301,0.0765170355763,0.198944292498,1, ST_GeomFromText('MULTIPOLYGON(((4455427.663999999 5793676.5238,4455427.7619 5793676.4867,4455427.7778 5793676.417899999,4455427.740699999 5793676.3333,4455427.663999999 5793676.285599999,4455427.587299999 5793676.264499999,4455427.497299999 5793676.296199999,4455427.452399999 5793676.327999999,4455427.4471 5793676.407299999,4455427.452399999 5793676.4788,4455427.542299999 5793676.526399999,4455427.663999999 5793676.5238)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (203,203,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Bettstein','Bettstein','NULL',3.14441708251,0.72013341499,0.576210249248,1.49814664805,1, ST_GeomFromText('MULTIPOLYGON(((4455423.757199999 5793676.6863,4455423.847199999 5793676.5117,4455423.939799999 5793676.329099999,4455424.013799999 5793676.1545,4455424.0059 5793676.0963,4455423.9133 5793675.9878,4455423.8075 5793675.9296,4455423.6117 5793675.895199999,4455423.407899999 5793675.895199999,4455423.235999999 5793675.9428,4455423.0931 5793676.022199999,4455422.9767 5793676.1148,4455422.931699999 5793676.2048,4455423.019 5793676.413799999,4455423.175099999 5793676.649299999,4455423.267699999 5793676.765699999,4455423.325899999 5793676.8054,4455423.495299999 5793676.834499999,4455423.614299999 5793676.850299999,4455423.757199999 5793676.6863)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (204,204,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Gang','Gang','NULL',0.929643657021,0.0569990401465,0.0679840643682,0.176758567357,1, ST_GeomFromText('MULTIPOLYGON(((4455428.0635 5793676.8987,4455428.0826 5793676.8574,4455428.1001 5793676.787499999,4455428.108 5793676.720899999,4455428.0842 5793676.681199999,4455428.028599999 5793676.658999999,4455427.9572 5793676.638299999,4455427.904799999 5793676.677999999,4455427.8699 5793676.7352,4455427.8381 5793676.795499999,4455427.8064 5793676.8701,4455427.8842 5793676.878,4455427.9762 5793676.9034,4455428.015899999 5793676.933599999,4455428.0635 5793676.8987)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (205,205,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Bettstein','Bettstein','NULL',2.85381212752,0.531126659906,0.431355472152,1.12152422759,1, ST_GeomFromText('MULTIPOLYGON(((4455430.2269 5793677.071299999,4455430.329499999 5793677.058,4455430.5014 5793677.0018,4455430.570899999 5793676.952199999,4455430.604 5793676.8133,4455430.597299999 5793676.723999999,4455430.547699999 5793676.6512,4455430.4121 5793676.5917,4455430.3129 5793676.5752,4455430.1079 5793676.548699999,4455430.0285 5793676.492499999,4455429.849899999 5793676.4396,4455429.7077 5793676.4131,4455429.638199999 5793676.4263,4455429.582 5793676.508999999,4455429.545599999 5793676.595,4455429.519199999 5793676.671099999,4455429.525799999 5793676.753799999,4455429.6052 5793676.922399999,4455429.6945 5793677.0117,4455429.836699999 5793677.0514,4455430.0186 5793677.077899999,4455430.2269 5793677.071299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (206,206,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Gang','Gang','NULL',1.14746638477,0.0931372800705,0.095680411446,0.24876906976,1, ST_GeomFromText('MULTIPOLYGON(((4455429.2171 5793677.124199999,4455429.3013 5793677.0972,4455429.3727 5793677.063899999,4455429.4029 5793677.041699999,4455429.4172 5793677.002,4455429.413999999 5793676.946399999,4455429.3902 5793676.902,4455429.3251 5793676.874999999,4455429.2695 5793676.847999999,4455429.212399999 5793676.844799999,4455429.1489 5793676.854399999,4455429.1012 5793676.8671,4455429.063099999 5793676.8988,4455429.032999999 5793676.9528,4455428.986899999 5793677.0163,4455428.9774 5793677.048,4455429.0092 5793677.0861,4455429.080599999 5793677.1226,4455429.136199999 5793677.135299999,4455429.2171 5793677.124199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (207,207,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Gang','Gang','NULL',1.10923775204,0.085431339945,0.0897745789338,0.233413905228,1, ST_GeomFromText('MULTIPOLYGON(((4455428.061999999 5793677.141599999,4455428.071499999 5793677.0939,4455428.053999999 5793677.0098,4455428.015899999 5793676.933599999,4455427.9762 5793676.9034,4455427.8842 5793676.878,4455427.8064 5793676.8701,4455427.753999999 5793676.8955,4455427.706399999 5793676.9526,4455427.680999999 5793677.035199999,4455427.677799999 5793677.0876,4455427.755599999 5793677.120899999,4455427.8715 5793677.14,4455427.968299999 5793677.1543,4455428.061999999 5793677.141599999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (208,208,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Gang','Gang','NULL',0.594453332324,0.0230802349099,0.0419886920349,0.109170599291,1, ST_GeomFromText('MULTIPOLYGON(((4455427.895299999 5793677.2606,4455427.877799999 5793677.205099999,4455427.826999999 5793677.1685,4455427.725399999 5793677.1479,4455427.6857 5793677.1828,4455427.674599999 5793677.241599999,4455427.741299999 5793677.276499999,4455427.817499999 5793677.2924,4455427.887299999 5793677.293999999,4455427.895299999 5793677.2606)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (209,209,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Bettstein','Bettstein','NULL',3.27046675217,0.718998625518,0.575340546597,1.49588542115,1, ST_GeomFromText('MULTIPOLYGON(((4455425.4378 5793677.4626,4455425.5732 5793677.449899999,4455425.6134 5793677.4308,4455425.7023 5793677.3419,4455425.8547 5793677.204299999,4455425.772199999 5793677.0964,4455425.696 5793676.994799999,4455425.6304 5793676.876199999,4455425.6029 5793676.842399999,4455425.5118 5793676.806399999,4455425.247299999 5793676.749199999,4455425.0038 5793676.715399999,4455424.819699999 5793676.709,4455424.752 5793676.715399999,4455424.722299999 5793676.753499999,4455424.6906 5793676.9186,4455424.660899999 5793677.115399999,4455424.6694 5793677.272099999,4455424.6906 5793677.386399999,4455424.722299999 5793677.413899999,4455424.908599999 5793677.451999999,4455425.2028 5793677.4668,4455425.4378 5793677.4626)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (210,210,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Gang','Gang','NULL',1.58912630116,0.163312204939,0.149462473865,0.388602432049,1, ST_GeomFromText('MULTIPOLYGON(((4455429.3283 5793677.4592,4455429.407599999 5793677.4227,4455429.4203 5793677.3814,4455429.4489 5793677.3131,4455429.4489 5793677.1544,4455429.410799999 5793677.095699999,4455429.3727 5793677.063899999,4455429.3013 5793677.0972,4455429.2171 5793677.124199999,4455429.136199999 5793677.135299999,4455429.080599999 5793677.1226,4455429.0092 5793677.0861,4455428.9615 5793677.098799999,4455428.926599999 5793677.129,4455428.9155 5793677.184599999,4455428.9298 5793677.255999999,4455428.958399999 5793677.308399999,4455429.0266 5793677.371899999,4455429.1012 5793677.443299999,4455429.155199999 5793677.478199999,4455429.2171 5793677.478199999,4455429.3283 5793677.4592)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (211,211,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Gang','Gang','NULL',2.55152740637,0.445878530241,0.366021305577,0.9516553945,1, ST_GeomFromText('MULTIPOLYGON(((4455428.683699999 5793677.420199999,4455428.773 5793677.3507,4455428.792899999 5793677.2978,4455428.7598 5793677.1291,4455428.7333 5793676.996799999,4455428.686999999 5793676.814899999,4455428.6308 5793676.7521,4455428.488599999 5793676.652899999,4455428.376099999 5793676.6793,4455428.2472 5793676.649599999,4455428.2273 5793676.6959,4455428.187599999 5793676.9241,4455428.161199999 5793677.139,4455428.101599999 5793677.231699999,4455428.1182 5793677.354,4455428.157899999 5793677.423499999,4455428.3563 5793677.4962,4455428.5151 5793677.5227,4455428.683699999 5793677.420199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (212,212,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Bettstein','Bettstein','NULL',1.68516459205,0.206830304922,0.182814745692,0.4753183388,1, ST_GeomFromText('MULTIPOLYGON(((4455430.445199999 5793677.534299999,4455430.5411 5793677.487999999,4455430.604 5793677.4152,4455430.6238 5793677.355699999,4455430.580799999 5793677.2466,4455430.491499999 5793677.160599999,4455430.355899999 5793677.097699999,4455430.2796 5793677.085999999,4455430.198699999 5793677.0971,4455430.106599999 5793677.1447,4455430.030399999 5793677.2257,4455429.978 5793677.290699999,4455429.9789 5793677.332499999,4455430.0913 5793677.4351,4455430.2203 5793677.507799999,4455430.336099999 5793677.540899999,4455430.445199999 5793677.534299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (213,213,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Bettstein','Bettstein','NULL',2.99307353772,0.658867745362,0.529256240046,1.37606622412,1, ST_GeomFromText('MULTIPOLYGON(((4455426.881299999 5793677.5493,4455426.978699999 5793677.5028,4455427.1036 5793677.4414,4455427.160699999 5793677.3483,4455427.222099999 5793677.210699999,4455427.275 5793677.0731,4455427.275 5793676.98,4455427.2158 5793676.8932,4455427.1184 5793676.780999999,4455427.067599999 5793676.755599999,4455426.913099999 5793676.7619,4455426.659099999 5793676.819099999,4455426.428399999 5793676.899499999,4455426.258999999 5793677.024399999,4455426.216699999 5793677.1302,4455426.2125 5793677.2572,4455426.250599999 5793677.384199999,4455426.341599999 5793677.483699999,4455426.4241 5793677.538799999,4455426.6633 5793677.5536,4455426.881299999 5793677.5493)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (214,214,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Bettstein','Bettstein','NULL',2.12610135988,0.31720167006,0.267403359934,0.695248735828,1, ST_GeomFromText('MULTIPOLYGON(((4455431.879399999 5793677.559299999,4455431.983099999 5793677.5064,4455432.0551 5793677.440799999,4455432.0678 5793677.396299999,4455432.053 5793677.3032,4455432.0191 5793677.2122,4455431.9789 5793677.0852,4455431.936599999 5793677.063999999,4455431.8053 5793677.006899999,4455431.676199999 5793676.9899,4455431.5535 5793677.0153,4455431.4561 5793677.063999999,4455431.382 5793677.1487,4455431.3354 5793677.216399999,4455431.3206 5793677.313799999,4455431.331199999 5793677.3921,4455431.49 5793677.428099999,4455431.599999999 5793677.4789,4455431.6889 5793677.550799999,4455431.7313 5793677.5974,4455431.879399999 5793677.559299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (215,215,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Bettstein','Bettstein','NULL',1.65716990927,0.18782379025,0.168248152847,0.437445197403,1, ST_GeomFromText('MULTIPOLYGON(((4455426.1172 5793677.6742,4455426.167999999 5793677.5938,4455426.1934 5793677.479499999,4455426.1595 5793677.38,4455426.051599999 5793677.3186,4455425.9331 5793677.3059,4455425.8399 5793677.327099999,4455425.744699999 5793677.4012,4455425.628299999 5793677.517599999,4455425.579599999 5793677.5917,4455425.562599999 5793677.640399999,4455425.655799999 5793677.6827,4455425.774299999 5793677.706,4455425.9182 5793677.7123,4455426.034699999 5793677.7144,4455426.1172 5793677.6742)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (216,216,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Gang','Gang','NULL',1.23622019655,0.0742465997956,0.0812025940833,0.211126744617,1, ST_GeomFromText('MULTIPOLYGON(((4455429.439399999 5793677.730699999,4455429.4505 5793677.583,4455429.302899999 5793677.567099999,4455429.210799999 5793677.563999999,4455429.1298 5793677.583,4455429.064699999 5793677.602099999,4455428.9917 5793677.6148,4455428.951999999 5793677.648099999,4455428.942499999 5793677.698899999,4455428.9647 5793677.736999999,4455429.1346 5793677.736999999,4455429.439399999 5793677.730699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (217,217,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Gang','Gang','NULL',0.875558640111,0.0504791749292,0.0629872396657,0.163766823131,1, ST_GeomFromText('MULTIPOLYGON(((4455428.8711 5793677.7815,4455428.9012 5793677.695699999,4455428.958399999 5793677.575099999,4455428.9488 5793677.5544,4455428.8996 5793677.5306,4455428.850399999 5793677.537,4455428.790099999 5793677.5481,4455428.755199999 5793677.570299999,4455428.7044 5793677.613199999,4455428.671 5793677.690999999,4455428.682099999 5793677.725899999,4455428.724999999 5793677.7465,4455428.8425 5793677.819599999,4455428.8711 5793677.7815)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (218,218,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Gang','Gang','NULL',0.742349819236,0.0387123549886,0.0539691488633,0.140319787045,1, ST_GeomFromText('MULTIPOLYGON(((4455428.860999999 5793678.294999999,4455428.8974 5793678.2586,4455428.904 5793678.1859,4455428.8908 5793678.08,4455428.831199999 5793678.0271,4455428.7783 5793678.0437,4455428.738599999 5793678.096599999,4455428.731999999 5793678.1892,4455428.745199999 5793678.2785,4455428.8048 5793678.311599999,4455428.860999999 5793678.294999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (219,219,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Gang','Gang','NULL',2.51551251189,0.427931020028,0.35226633375,0.915892467749,1, ST_GeomFromText('MULTIPOLYGON(((4455428.134999999 5793678.378499999,4455428.198499999 5793678.3123,4455428.2011 5793678.066299999,4455428.193199999 5793677.918099999,4455428.1588 5793677.7541,4455428.1456 5793677.597999999,4455428.100599999 5793677.489499999,4455427.994699999 5793677.4472,4455427.8836 5793677.4604,4455427.791 5793677.534499999,4455427.7037 5793677.6535,4455427.629599999 5793677.7991,4455427.5899 5793677.9287,4455427.5926 5793678.026599999,4455427.6217 5793678.0557,4455427.666699999 5793678.121799999,4455427.7593 5793678.211799999,4455427.8704 5793678.3176,4455427.939199999 5793678.386399999,4455428.060899999 5793678.3944,4455428.134999999 5793678.378499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (220,220,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Gang','Gang','NULL',1.22081341043,0.0686862101017,0.0769411114219,0.200046889697,1, ST_GeomFromText('MULTIPOLYGON(((4455429.367899999 5793678.403799999,4455429.433 5793678.371999999,4455429.433 5793678.346599999,4455429.364799999 5793678.325999999,4455429.3775 5793678.286299999,4455429.439399999 5793678.2387,4455429.4362 5793678.162499999,4455429.4029 5793678.1513,4455429.4045 5793678.133899999,4455429.442599999 5793678.1117,4455429.4346 5793677.989399999,4455429.379099999 5793678.006899999,4455429.314 5793678.041799999,4455429.2648 5793678.092599999,4455429.213999999 5793678.1577,4455429.196499999 5793678.222799999,4455429.2251 5793678.289499999,4455429.2521 5793678.3561,4455429.288599999 5793678.3958,4455429.3267 5793678.414899999,4455429.367899999 5793678.403799999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (221,221,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Gang','Gang','NULL',1.9248842032,0.231099860024,0.201414932722,0.523678825078,1, ST_GeomFromText('MULTIPOLYGON(((4455428.0334 5793679.2056,4455428.119099999 5793679.1738,4455428.1842 5793679.1564,4455428.1874 5793678.878599999,4455428.190499999 5793678.584899999,4455428.189 5793678.545199999,4455428.1604 5793678.5087,4455428.1239 5793678.492799999,4455428.046099999 5793678.515,4455427.969899999 5793678.5611,4455427.8699 5793678.6674,4455427.8207 5793678.737299999,4455427.808 5793678.8452,4455427.799999999 5793678.969,4455427.847599999 5793679.108699999,4455427.8857 5793679.189699999,4455427.938099999 5793679.254799999,4455427.9731 5793679.2564,4455428.0334 5793679.2056)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (222,222,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Kammerstein','Kammerstein','NULL',2.25161186677,0.349623179883,0.292251205062,0.759853133161,1, ST_GeomFromText('MULTIPOLYGON(((4455430.399699999 5793679.6051,4455430.472699999 5793679.557499999,4455430.520299999 5793679.494,4455430.5536 5793679.3924,4455430.5568 5793679.2813,4455430.502799999 5793679.1797,4455430.3901 5793679.109799999,4455430.244099999 5793679.0876,4455430.0695 5793679.094,4455429.9297 5793679.1432,4455429.875799999 5793679.178099999,4455429.8075 5793679.286,4455429.756699999 5793679.362199999,4455429.696399999 5793679.4765,4455429.788499999 5793679.497199999,4455429.9297 5793679.5623,4455430.0568 5793679.601999999,4455430.182199999 5793679.6337,4455430.3108 5793679.638499999,4455430.399699999 5793679.6051)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (223,223,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Gang','Gang','NULL',2.47036874327,0.404295249687,0.33415187936,0.868794886336,1, ST_GeomFromText('MULTIPOLYGON(((4455429.0312 5793679.701999999,4455429.116899999 5793679.675,4455429.1836 5793679.644799999,4455429.221699999 5793679.5591,4455429.2471 5793679.478099999,4455429.251899999 5793679.3956,4455429.2487 5793679.3067,4455429.2344 5793679.198699999,4455429.221699999 5793679.0908,4455429.193099999 5793678.8844,4455429.164599999 5793678.786,4455429.1074 5793678.7495,4455429.026499999 5793678.7368,4455428.9312 5793678.7717,4455428.826399999 5793678.8352,4455428.774 5793678.890799999,4455428.7629 5793678.947899999,4455428.750199999 5793679.144799999,4455428.756599999 5793679.3067,4455428.7613 5793679.4527,4455428.7788 5793679.552699999,4455428.8185 5793679.6162,4455428.893099999 5793679.666999999,4455428.9757 5793679.7083,4455429.0312 5793679.701999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (224,224,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Kammerstein','Kammerstein','NULL',1.98171487365,0.214783125147,0.188909787112,0.491165446492,1, ST_GeomFromText('MULTIPOLYGON(((4455431.2823 5793679.8099,4455431.367999999 5793679.811499999,4455431.4188 5793679.779799999,4455431.376 5793679.716299999,4455431.2712 5793679.613099999,4455431.142599999 5793679.514599999,4455431.0394 5793679.4273,4455430.9521 5793679.3892,4455430.855299999 5793679.3813,4455430.756799999 5793679.4019,4455430.655199999 5793679.4527,4455430.580599999 5793679.5226,4455430.683799999 5793679.601999999,4455430.7949 5793679.692399999,4455430.9188 5793679.8067,4455431.0712 5793679.821,4455431.2823 5793679.8099)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (225,225,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Kammerstein','Kammerstein','NULL',2.31040806798,0.226688939831,0.198034403487,0.514889449066,1, ST_GeomFromText('MULTIPOLYGON(((4455429.1582 5793680.011499999,4455429.283599999 5793679.971799999,4455429.358199999 5793679.928999999,4455429.394799999 5793679.886099999,4455429.437599999 5793679.793999999,4455429.4471 5793679.7353,4455429.451899999 5793679.6432,4455429.4598 5793679.538499999,4455429.455099999 5793679.449599999,4455429.423299999 5793679.3845,4455429.375699999 5793679.330499999,4455429.3201 5793679.316199999,4455429.2487 5793679.3067,4455429.251899999 5793679.3956,4455429.2471 5793679.478099999,4455429.221699999 5793679.5591,4455429.221699999 5793679.681299999,4455429.2027 5793679.7115,4455429.0661 5793679.7607,4455428.9106 5793679.808299999,4455428.845499999 5793679.825799999,4455428.8106 5793679.833699999,4455428.8042 5793679.8639,4455428.8629 5793680.006799999,4455428.8788 5793680.024199999,4455429.0376 5793680.0306,4455429.1582 5793680.011499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (226,226,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Kammerstein','Kammerstein','NULL',2.58042475237,0.435732544918,0.358245422425,0.931438098306,1, ST_GeomFromText('MULTIPOLYGON(((4455427.887299999 5793680.254899999,4455427.9318 5793680.2311,4455428.0064 5793680.189799999,4455428.0985 5793680.151699999,4455428.133399999 5793680.1184,4455428.138199999 5793680.0565,4455428.165099999 5793679.8914,4455428.198499999 5793679.683399999,4455428.266699999 5793679.4866,4455428.1747 5793679.4516,4455428.087399999 5793679.4516,4455428.0175 5793679.453199999,4455427.903199999 5793679.4469,4455427.8397 5793679.438899999,4455427.755599999 5793679.430999999,4455427.6111 5793679.421499999,4455427.572999999 5793679.499299999,4455427.546 5793679.5866,4455427.538099999 5793679.6596,4455427.5508 5793679.735799999,4455427.582499999 5793679.8453,4455427.627 5793679.953299999,4455427.6889 5793680.0612,4455427.738099999 5793680.161299999,4455427.7953 5793680.2232,4455427.830199999 5793680.2565,4455427.887299999 5793680.254899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (227,227,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Kammerstein','Kammerstein','NULL',3.23241564618,0.761713645055,0.60807733757,1.58100107768,1, ST_GeomFromText('MULTIPOLYGON(((4455426.2586 5793680.322399999,4455426.5338 5793680.2631,4455426.705299999 5793680.2398,4455426.881 5793680.165699999,4455426.9889 5793680.0599,4455427.0376 5793679.954099999,4455427.056599999 5793679.888399999,4455427.029099999 5793679.8101,4455427.024899999 5793679.740299999,4455427.029099999 5793679.638699999,4455426.991 5793679.545499999,4455426.8683 5793679.5117,4455426.677699999 5793679.456599999,4455426.537999999 5793679.456599999,4455426.404699999 5793679.467199999,4455426.269199999 5793679.5138,4455426.133799999 5793679.6006,4455425.989799999 5793679.753,4455425.9538 5793679.8736,4455425.956 5793680.074699999,4455425.9708 5793680.186899999,4455426.0618 5793680.286399999,4455426.1211 5793680.3245,4455426.2586 5793680.322399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (228,228,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Kammerstein','Kammerstein','NULL',2.66019845015,0.492171654854,0.40150035628,1.04390092633,1, ST_GeomFromText('MULTIPOLYGON(((4455432.188799999 5793680.665599999,4455432.220499999 5793680.592599999,4455432.253899999 5793680.500499999,4455432.280799999 5793680.397299999,4455432.299899999 5793680.2814,4455432.2904 5793680.2258,4455432.2459 5793680.1576,4455432.112599999 5793680.0401,4455431.9713 5793679.9385,4455431.8157 5793679.8782,4455431.7125 5793679.840099999,4455431.6697 5793679.8464,4455431.576 5793679.8988,4455431.507699999 5793679.957599999,4455431.479199999 5793680.006799999,4455431.458499999 5793680.0798,4455431.471199999 5793680.1608,4455431.5157 5793680.300499999,4455431.568099999 5793680.3878,4455431.6173 5793680.463999999,4455431.6776 5793680.567199999,4455431.704599999 5793680.602099999,4455431.752199999 5793680.616399999,4455431.7728 5793680.584599999,4455431.849 5793680.5894,4455431.918899999 5793680.6227,4455432.006199999 5793680.665599999,4455432.1681 5793680.6894,4455432.188799999 5793680.665599999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (229,229,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Kammerstein','Kammerstein','NULL',2.42536822038,0.446339865092,0.366374872607,0.952574668777,1, ST_GeomFromText('MULTIPOLYGON(((4455424.2311 5793680.8408,4455424.403099999 5793680.785199999,4455424.506299999 5793680.7243,4455424.569799999 5793680.6556,4455424.598899999 5793680.5603,4455424.612099999 5793680.472999999,4455424.506299999 5793680.3407,4455424.3528 5793680.176699999,4455424.2285 5793680.131699999,4455424.0459 5793680.1105,4455423.929499999 5793680.131699999,4455423.8501 5793680.197799999,4455423.797199999 5793680.3089,4455423.8051 5793680.4756,4455423.897699999 5793680.6926,4455424.035299999 5793680.8143,4455424.156999999 5793680.851299999,4455424.2311 5793680.8408)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (230,230,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Kammerstein','Kammerstein','NULL',1.72437845355,0.209455624781,0.184826790832,0.480549656164,1, ST_GeomFromText('MULTIPOLYGON(((4455431.0458 5793681.1148,4455431.1029 5793681.063999999,4455431.2077 5793680.992599999,4455431.307699999 5793680.925899999,4455431.3649 5793680.892599999,4455431.3776 5793680.857699999,4455431.3633 5793680.787799999,4455431.3299 5793680.725899999,4455431.275999999 5793680.6497,4455431.199799999 5793680.6005,4455431.112399999 5793680.591,4455431.015599999 5793680.602099999,4455430.915599999 5793680.648099999,4455430.820299999 5793680.718,4455430.745699999 5793680.808499999,4455430.8013 5793680.871999999,4455430.852099999 5793680.946599999,4455430.9029 5793681.013199999,4455430.985399999 5793681.092599999,4455431.0251 5793681.118,4455431.0458 5793681.1148)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (231,231,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Kammerstein','Kammerstein','NULL',1.90067394687,0.254412420432,0.219281679019,0.570132365449,1, ST_GeomFromText('MULTIPOLYGON(((4455431.5776 5793681.4197,4455431.623599999 5793681.381599999,4455431.6665 5793681.3308,4455431.690299999 5793681.254499999,4455431.718899999 5793681.1641,4455431.722 5793681.0831,4455431.7268 5793680.9831,4455431.7427 5793680.910099999,4455431.683899999 5793680.886199999,4455431.5935 5793680.868799999,4455431.5014 5793680.878299999,4455431.380699999 5793680.9275,4455431.2537 5793681.017999999,4455431.183899999 5793681.084699999,4455431.1347 5793681.1323,4455431.1299 5793681.165599999,4455431.149 5793681.253,4455431.1632 5793681.340299999,4455431.2252 5793681.3562,4455431.2521 5793681.38,4455431.463299999 5793681.426,4455431.5284 5793681.4339,4455431.5776 5793681.4197)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (232,232,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Kammerstein','Kammerstein','NULL',1.9974840353,0.292740259966,0.248656135238,0.646505951618,1, ST_GeomFromText('MULTIPOLYGON(((4455429.450299999 5793681.464099999,4455429.516999999 5793681.4197,4455429.5678 5793681.345,4455429.602699999 5793681.2704,4455429.634499999 5793681.1752,4455429.6408 5793681.0752,4455429.6297 5793680.989399999,4455429.5948 5793680.910099999,4455429.5503 5793680.868799999,4455429.5075 5793680.857699999,4455429.4138 5793680.8878,4455429.281999999 5793680.945,4455429.196299999 5793680.981499999,4455429.0661 5793681.038599999,4455429.0058 5793681.081499999,4455428.9899 5793681.126,4455428.994699999 5793681.190999999,4455429.0312 5793681.291099999,4455429.109 5793681.392699999,4455429.207399999 5793681.452999999,4455429.2789 5793681.484699999,4455429.3709 5793681.484699999,4455429.450299999 5793681.464099999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (233,233,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Kammerstein','Kammerstein','NULL',2.5232727358,0.4632506697,0.379335313258,0.986271814472,1, ST_GeomFromText('MULTIPOLYGON(((4455430.2631 5793681.6435,4455430.3568 5793681.570499999,4455430.425099999 5793681.4768,4455430.479 5793681.375199999,4455430.550499999 5793681.156099999,4455430.5536 5793681.084699999,4455430.545699999 5793681.0307,4455430.5108 5793680.992599999,4455430.3901 5793680.943399999,4455430.2663 5793680.9228,4455430.052 5793680.9053,4455429.8996 5793680.911599999,4455429.8266 5793680.9243,4455429.7964 5793680.975099999,4455429.742399999 5793681.105299999,4455429.7186 5793681.2212,4455429.7916 5793681.299,4455429.845599999 5793681.378399999,4455429.9186 5793681.510099999,4455429.9901 5793681.595899999,4455430.063099999 5793681.630799999,4455430.1917 5793681.656199999,4455430.2631 5793681.6435)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (234,234,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Kammerstein','Kammerstein','NULL',3.54418193529,0.820146695126,0.652860427145,1.69743711058,1, ST_GeomFromText('MULTIPOLYGON(((4455423.639399999 5793681.7674,4455423.7346 5793681.7396,4455423.7955 5793681.6642,4455423.841799999 5793681.591399999,4455423.8722 5793681.5094,4455423.8656 5793681.4221,4455423.815299999 5793681.2356,4455423.803399999 5793681.057,4455423.8299 5793680.9855,4455423.844399999 5793680.9154,4455423.8167 5793680.8519,4455423.684399999 5793680.681299999,4455423.549399999 5793680.507899999,4455423.4674 5793680.419299999,4455423.4357 5793680.391499999,4455423.344399999 5793680.410099999,4455423.2756 5793680.4616,4455423.2094 5793680.5291,4455423.164499999 5793680.6336,4455423.141999999 5793680.7805,4455423.133999999 5793680.918099999,4455423.111499999 5793680.974899999,4455423.091699999 5793681.0292,4455423.098299999 5793681.115199999,4455423.116799999 5793681.231599999,4455423.104899999 5793681.3242,4455423.104899999 5793681.398299999,4455423.1182 5793681.516,4455423.269 5793681.691999999,4455423.3775 5793681.743599999,4455423.521599999 5793681.769999999,4455423.639399999 5793681.7674)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (235,235,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Kammerstein','Kammerstein','NULL',2.45171009697,0.391528709722,0.324367603131,0.843355768141,1, ST_GeomFromText('MULTIPOLYGON(((4455428.5855 5793681.784499999,4455428.7236 5793681.666999999,4455428.7887 5793681.5686,4455428.839499999 5793681.4591,4455428.874499999 5793681.3495,4455428.868099999 5793681.3098,4455428.775999999 5793681.293999999,4455428.642699999 5793681.2606,4455428.5712 5793681.233599999,4455428.5284 5793681.205099999,4455428.471199999 5793681.1511,4455428.398199999 5793681.1162,4455428.355299999 5793681.103499999,4455428.2569 5793681.1797,4455428.1807 5793681.241599999,4455428.083899999 5793681.301899999,4455428.015599999 5793681.3384,4455427.960099999 5793681.3527,4455427.9616 5793681.3702,4455428.0585 5793681.503499999,4455428.195 5793681.663899999,4455428.2998 5793681.775,4455428.376 5793681.805099999,4455428.4982 5793681.8131,4455428.5855 5793681.784499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (236,236,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Kammerstein','Kammerstein','NULL',2.39394566941,0.355246574997,0.296560975078,0.771058535202,1, ST_GeomFromText('MULTIPOLYGON(((4455427.6172 5793682.1258,4455427.683799999 5793682.0655,4455427.850499999 5793681.900399999,4455427.9061 5793681.8353,4455427.960099999 5793681.7496,4455428.0124 5793681.641599999,4455427.9934 5793681.5972,4455427.852099999 5793681.5559,4455427.66 5793681.5654,4455427.4298 5793681.6019,4455427.210799999 5793681.6226,4455427.105999999 5793681.644799999,4455427.078999999 5793681.6607,4455427.074199999 5793681.716199999,4455427.090099999 5793681.7861,4455427.1425 5793681.8813,4455427.199599999 5793681.9448,4455427.3425 5793682.0306,4455427.5235 5793682.1084,4455427.5711 5793682.129,4455427.6172 5793682.1258)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (237,237,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Kammerstein','Kammerstein','NULL',2.53799996649,0.418262450341,0.344856341941,0.896626489048,1, ST_GeomFromText('MULTIPOLYGON(((4455424.3355 5793682.2518,4455424.524 5793682.169199999,4455424.679499999 5793682.1162,4455424.825 5793682.0302,4455424.8501 5793681.9909,4455424.799899999 5793681.943299999,4455424.6199 5793681.8004,4455424.4943 5793681.726299999,4455424.282599999 5793681.654899999,4455424.1556 5793681.615199999,4455424.018 5793681.5861,4455423.9955 5793681.5993,4455423.9347 5793681.732899999,4455423.9188 5793681.8705,4455423.942599999 5793682.0438,4455423.971699999 5793682.0997,4455424.0213 5793682.188999999,4455424.137099999 5793682.2882,4455424.239599999 5793682.2915,4455424.3355 5793682.2518)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (238,238,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Kammerstein','Kammerstein','NULL',2.59928240515,0.489367125263,0.399350964802,1.03831250848,1, ST_GeomFromText('MULTIPOLYGON(((4455426.49 5793682.4941,4455426.671 5793682.4449,4455426.7488 5793682.41,4455426.8075 5793682.3592,4455426.8218 5793682.3131,4455426.832899999 5793682.219499999,4455426.820199999 5793681.9591,4455426.779 5793681.7496,4455426.7536 5793681.6575,4455426.7297 5793681.64,4455426.615399999 5793681.6575,4455426.4472 5793681.709899999,4455426.3059 5793681.765499999,4455426.2297 5793681.8099,4455426.144 5793681.9131,4455426.082 5793682.000399999,4455426.075699999 5793682.0369,4455426.102699999 5793682.1433,4455426.177299999 5793682.286199999,4455426.2741 5793682.4195,4455426.329699999 5793682.4989,4455426.3726 5793682.513199999,4455426.49 5793682.4941)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (239,239,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Kammerstein','Kammerstein','NULL',2.9703996542,0.604328279811,0.487457193647,1.26738870348,1, ST_GeomFromText('MULTIPOLYGON(((4455425.721699999 5793682.7497,4455425.781999999 5793682.667199999,4455425.918499999 5793682.463999999,4455425.969299999 5793682.3592,4455425.980399999 5793682.2576,4455425.9582 5793682.046399999,4455425.934399999 5793681.936899999,4455425.918499999 5793681.893999999,4455425.875699999 5793681.893999999,4455425.602599999 5793681.9353,4455425.232699999 5793681.9941,4455425.1025 5793682.017899999,4455425.0756 5793682.038499999,4455425.0279 5793682.1655,4455424.991399999 5793682.311599999,4455424.9978 5793682.336999999,4455425.099399999 5793682.4417,4455425.223199999 5793682.5259,4455425.356599999 5793682.606799999,4455425.524799999 5793682.716399999,4455425.613699999 5793682.759199999,4455425.6661 5793682.7672,4455425.721699999 5793682.7497)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (240,240,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Bettstein','Bettstein','NULL',1.20649607621,0.0947828051336,0.0969415418544,0.252048008821,1, ST_GeomFromText('MULTIPOLYGON(((4455427.064399999 5793683.2573,4455427.0723 5793683.1501,4455427.0723 5793683.039,4455427.040599999 5793682.991399999,4455426.861999999 5793682.959599999,4455426.758799999 5793682.9874,4455426.6913 5793683.023099999,4455426.6397 5793683.0708,4455426.794499999 5793683.2017,4455426.913599999 5793683.2573,4455427.012799999 5793683.285099999,4455427.064399999 5793683.2573)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (241,241,271,'Alv034',34,'Alv','Stuhlmann','Bettstein in situ','Bettstein in situ','NULL',3.12425086389,0.750373364988,0.599386146927,1.55840398201,1, ST_GeomFromText('MULTIPOLYGON(((4455348.6617 5793911.4637,4455348.7922 5793911.3934,4455348.9533 5793911.276699999,4455349.12 5793911.0972,4455349.132299999 5793911.004,4455349.113499999 5793910.881999999,4455348.989699999 5793910.7016,4455348.823699999 5793910.5369,4455348.693199999 5793910.473899999,4455348.4455 5793910.489,4455348.3096 5793910.546199999,4455348.2426 5793910.594299999,4455348.191599999 5793910.656099999,4455348.133999999 5793910.741599999,4455348.1058 5793910.8252,4455348.0996 5793910.902599999,4455348.116 5793910.9944,4455348.296799999 5793911.3179,4455348.417399999 5793911.439699999,4455348.5323 5793911.4824,4455348.594499999 5793911.482999999,4455348.6617 5793911.4637)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (242,242,271,'Alv034',34,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',1.52302293587,0.174302404681,0.157885362948,0.410501943664,1, ST_GeomFromText('MULTIPOLYGON(((4455355.8934 5793911.546399999,4455355.978 5793911.509299999,4455356.0881 5793911.414599999,4455356.152999999 5793911.323899999,4455356.174999999 5793911.2542,4455356.1681 5793911.1874,4455356.148799999 5793911.1444,4455356.107499999 5793911.115599999,4455355.9833 5793911.0829,4455355.9028 5793911.0785,4455355.7651 5793911.1436,4455355.706 5793911.202199999,4455355.680399999 5793911.2706,4455355.6901 5793911.380699999,4455355.7176 5793911.475999999,4455355.7772 5793911.5469,4455355.8934 5793911.546399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (243,243,271,'Alv034',34,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',1.18110060639,0.10407481505,0.104062938254,0.270563639461,1, ST_GeomFromText('MULTIPOLYGON(((4455357.0377 5793911.9396,4455357.173499999 5793911.773,4455357.1807 5793911.722699999,4455357.147499999 5793911.6356,4455357.077399999 5793911.5645,4455357.0213 5793911.55,4455356.9412 5793911.556099999,4455356.8914 5793911.5921,4455356.851099999 5793911.6499,4455356.842899999 5793911.828999999,4455356.877399999 5793911.919199999,4455356.918999999 5793911.9528,4455356.9811 5793911.9602,4455357.0377 5793911.9396)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (244,244,271,'Alv034',34,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',1.25265427229,0.115709075247,0.11297943527,0.293746531701,1, ST_GeomFromText('MULTIPOLYGON(((4455355.650399999 5793912.3307,4455355.6862 5793912.255499999,4455355.697599999 5793912.1727,4455355.674999999 5793912.0788,4455355.614299999 5793912.025699999,4455355.5354 5793912.0131,4455355.440899999 5793912.041899999,4455355.403099999 5793912.075699999,4455355.381799999 5793912.128,4455355.3513 5793912.2982,4455355.365899999 5793912.373999999,4455355.439299999 5793912.4545,4455355.528199999 5793912.4556,4455355.650399999 5793912.3307)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (245,245,271,'Alv034',34,'Alv','Stuhlmann','Bettstein in situ','Bettstein in situ','NULL',2.95887654421,0.630006560126,0.507137027681,1.31855627197,1, ST_GeomFromText('MULTIPOLYGON(((4455347.8333 5793912.721799999,4455348.0278 5793912.668899999,4455348.1628 5793912.6904,4455348.2417 5793912.673699999,4455348.3721 5793912.5898,4455348.4445 5793912.498999999,4455348.5218 5793912.4309,4455348.5196 5793912.410199999,4455348.465599999 5793912.396299999,4455348.4813 5793912.324599999,4455348.462199999 5793912.2401,4455348.414499999 5793912.1217,4455348.3432 5793912.005599999,4455348.190999999 5793911.8878,4455348.063599999 5793911.855599999,4455347.8815 5793911.910199999,4455347.716 5793911.992399999,4455347.553199999 5793912.142899999,4455347.546099999 5793912.320299999,4455347.6062 5793912.6085,4455347.6786 5793912.6917,4455347.7478 5793912.7254,4455347.8333 5793912.721799999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (246,246,271,'Alv034',34,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',1.34749203711,0.128923400208,0.123106893919,0.32007792419,1, ST_GeomFromText('MULTIPOLYGON(((4455357.0142 5793912.778599999,4455357.132 5793912.6355,4455357.1425 5793912.5784,4455357.0881 5793912.495899999,4455357.0382 5793912.379899999,4455356.992899999 5793912.367599999,4455356.9468 5793912.376199999,4455356.841199999 5793912.4374,4455356.7911 5793912.484899999,4455356.7663 5793912.5645,4455356.7729 5793912.762,4455356.7872 5793912.8134,4455356.812199999 5793912.841299999,4455356.903099999 5793912.8482,4455357.0142 5793912.778599999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (247,247,271,'Alv034',34,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',0.905483153673,0.0590717200694,0.0695725662612,0.180888672279,1, ST_GeomFromText('MULTIPOLYGON(((4455356.148 5793913.145899999,4455356.2054 5793913.014499999,4455356.206 5793912.9647,4455356.183 5793912.927799999,4455356.1359 5793912.910299999,4455356.058799999 5793912.913399999,4455355.980399999 5793912.968599999,4455355.9395 5793913.095,4455355.950299999 5793913.160499999,4455355.9828 5793913.2091,4455356.043499999 5793913.217299999,4455356.148 5793913.145899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (248,248,271,'Alv034',34,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',0.920270496447,0.066077025088,0.0749414320274,0.194847723271,1, ST_GeomFromText('MULTIPOLYGON(((4455355.2504 5793913.474799999,4455355.303999999 5793913.444499999,4455355.3321 5793913.4032,4455355.3414 5793913.345399999,4455355.3348 5793913.2752,4455355.309299999 5793913.231799999,4455355.252899999 5793913.193399999,4455355.1879 5793913.183299999,4455355.1359 5793913.194599999,4455355.0935 5793913.223999999,4455355.0623 5793913.275299999,4455355.052 5793913.332499999,4455355.0623 5793913.370999999,4455355.1047 5793913.425499999,4455355.153199999 5793913.468,4455355.192099999 5793913.479299999,4455355.2504 5793913.474799999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (249,249,271,'Alv034',34,'Alv','Stuhlmann','Bettstein','Bettstein','NULL',2.63462198634,0.489716585103,0.399618790823,1.03900885614,1, ST_GeomFromText('MULTIPOLYGON(((4455362.644 5793913.468599999,4455362.680399999 5793913.4209,4455362.691399999 5793913.25,4455362.617499999 5793912.9964,4455362.558899999 5793912.935599999,4455362.426699999 5793912.8618,4455362.223699999 5793912.6611,4455362.156499999 5793912.645199999,4455362.058299999 5793912.6717,4455361.954099999 5793912.7573,4455361.891599999 5793912.850099999,4455361.866499999 5793913.0612,4455361.890499999 5793913.1905,4455361.9987 5793913.3011,4455362.3265 5793913.479199999,4455362.410099999 5793913.5062,4455362.504499999 5793913.512,4455362.644 5793913.468599999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (250,250,271,'Alv034',34,'Alv','Stuhlmann','Bettstein in situ','Bettstein in situ','NULL',3.58560504588,0.837242259958,0.665962468032,1.73150241688,1, ST_GeomFromText('MULTIPOLYGON(((4455347.7893 5793913.992499999,4455347.987999999 5793913.9483,4455348.0766 5793913.8965,4455348.107699999 5793913.8583,4455348.128299999 5793913.776499999,4455348.131099999 5793913.6431,4455348.0909 5793913.378,4455347.9906 5793913.2385,4455347.910799999 5793913.2006,4455347.7341 5793913.198499999,4455347.540699999 5793913.235799999,4455347.1863 5793913.3684,4455347.0886 5793913.388399999,4455346.872299999 5793913.4809,4455346.8393 5793913.509199999,4455346.818099999 5793913.5675,4455346.8386 5793913.842499999,4455346.899299999 5793913.9271,4455346.964599999 5793913.967299999,4455347.192599999 5793913.9349,4455347.4303 5793913.9638,4455347.528699999 5793913.999099999,4455347.7893 5793913.992499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (251,251,271,'Alv034',34,'Alv','Stuhlmann','Bettstein','Bettstein','NULL',1.69630847886,0.216677295321,0.190361479134,0.494939845749,1, ST_GeomFromText('MULTIPOLYGON(((4455350.676799999 5793914.6914,4455350.779199999 5793914.6453,4455350.842699999 5793914.5602,4455350.869199999 5793914.488399999,4455350.8616 5793914.398199999,4455350.816599999 5793914.2848,4455350.7246 5793914.172399999,4455350.6352 5793914.1292,4455350.552899999 5793914.121099999,4455350.4988 5793914.1303,4455350.390499999 5793914.187599999,4455350.379099999 5793914.2224,4455350.4067 5793914.5063,4455350.444699999 5793914.5839,4455350.513899999 5793914.662299999,4455350.583399999 5793914.6971,4455350.676799999 5793914.6914)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (252,252,271,'Alv034',34,'Alv','Stuhlmann','Kammerstein','Kammerstein','NULL',0.889925912942,0.0573762799083,0.0682731809218,0.177510270397,1, ST_GeomFromText('MULTIPOLYGON(((4455354.577899999 5793914.687699999,4455354.652599999 5793914.6311,4455354.703399999 5793914.5666,4455354.722799999 5793914.4929,4455354.6846 5793914.4602,4455354.604299999 5793914.4447,4455354.542999999 5793914.4495,4455354.477199999 5793914.4801,4455354.422699999 5793914.5504,4455354.4115 5793914.605299999,4455354.4364 5793914.6688,4455354.4741 5793914.703999999,4455354.5272 5793914.7059,4455354.577899999 5793914.687699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (253,253,271,'Alv034',34,'Alv','Stuhlmann','Bettstein in situ','Bettstein in situ','NULL',2.26188723917,0.390306370391,0.323430802268,0.840920085897,1, ST_GeomFromText('MULTIPOLYGON(((4455350.3004 5793915.160199999,4455350.3776 5793915.0839,4455350.4028 5793914.957299999,4455350.4199 5793914.803099999,4455350.387 5793914.6599,4455350.3229 5793914.566299999,4455350.237399999 5793914.486199999,4455350.1381 5793914.4539,4455349.9955 5793914.482999999,4455349.864699999 5793914.5457,4455349.82 5793914.5928,4455349.773799999 5793914.7189,4455349.7434 5793914.8932,4455349.7761 5793915.004899999,4455349.831899999 5793915.084,4455350.0794 5793915.171,4455350.137 5793915.2016,4455350.228699999 5793915.2104,4455350.3004 5793915.160199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (254,254,271,'Alv034',34,'Alv','Stuhlmann','Bettstein','Bettstein','NULL',2.61734501775,0.505738569701,0.411898039819,1.07093490353,1, ST_GeomFromText('MULTIPOLYGON(((4455362.847099999 5793915.7825,4455362.9144 5793915.7138,4455362.969899999 5793915.597999999,4455363.006299999 5793915.463199999,4455363.010999999 5793915.375299999,4455362.9889 5793915.267799999,4455362.9171 5793915.1477,4455362.7986 5793915.0831,4455362.632399999 5793914.942099999,4455362.5866 5793914.9337,4455362.501299999 5793914.9758,4455362.3167 5793915.1381,4455362.1819 5793915.284299999,4455362.1708 5793915.3351,4455362.211699999 5793915.4295,4455362.301099999 5793915.515499999,4455362.3864 5793915.669399999,4455362.502799999 5793915.767599999,4455362.6293 5793915.83,4455362.7076 5793915.835999999,4455362.847099999 5793915.7825)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (255,255,271,'Alv034',34,'Alv','Stuhlmann','Bettstein','Bettstein','NULL',1.45826884617,0.15983609488,0.146798383116,0.381675796102,1, ST_GeomFromText('MULTIPOLYGON(((4455360.3129 5793916.499399999,4455360.3629 5793916.4852,4455360.410099999 5793916.4515,4455360.476499999 5793916.366699999,4455360.526499999 5793916.261299999,4455360.521999999 5793916.1928,4455360.480399999 5793916.116299999,4455360.414699999 5793916.080199999,4455360.280299999 5793916.0897,4455360.1562 5793916.141799999,4455360.090499999 5793916.1861,4455360.0603 5793916.244699999,4455360.051099999 5793916.381999999,4455360.069199999 5793916.446599999,4455360.109199999 5793916.4987,4455360.1682 5793916.518899999,4455360.3129 5793916.499399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (256,256,271,'Alv034',34,'Alv','Stuhlmann','Bettstein','Bettstein','NULL',2.39590927858,0.403952389709,0.333889111473,0.86811168983,1, ST_GeomFromText('MULTIPOLYGON(((4455358.556599999 5793917.652,4455358.722599999 5793917.580499999,4455358.835099999 5793917.4976,4455358.9632 5793917.307499999,4455359.030799999 5793917.150299999,4455359.014899999 5793916.984099999,4455358.9676 5793916.9209,4455358.868999999 5793916.9098,4455358.633799999 5793916.970399999,4455358.4747 5793917.0633,4455358.270999999 5793917.253299999,4455358.230399999 5793917.325699999,4455358.223699999 5793917.403899999,4455358.274799999 5793917.518899999,4455358.361299999 5793917.621899999,4455358.451399999 5793917.657999999,4455358.556599999 5793917.652)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (257,257,271,'Alv034',34,'Alv','Stuhlmann','Bettstein','Bettstein','NULL',1.49271504632,0.133616424939,0.126703628073,0.32942943299,1, ST_GeomFromText('MULTIPOLYGON(((4455353.3448 5793917.896099999,4455353.4137 5793917.846,4455353.470499999 5793917.7434,4455353.491 5793917.671399999,4455353.484699999 5793917.6201,4455353.4978 5793917.527799999,4455353.473199999 5793917.3942,4455353.436499999 5793917.330199999,4455353.4022 5793917.3032,4455353.323099999 5793917.2905,4455353.268699999 5793917.3045,4455353.2417 5793917.327099999,4455353.2355 5793917.3561,4455353.2494 5793917.4789,4455353.2286 5793917.5939,4455353.225499999 5793917.741399999,4455353.2433 5793917.841299999,4455353.291899999 5793917.8967,4455353.3448 5793917.896099999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (258,258,271,'Alv034',34,'Alv','Stuhlmann','Bettstein in situ','Bettstein in situ','NULL',3.83074280953,1.02110278062,0.806873171068,2.09787024478,1, ST_GeomFromText('MULTIPOLYGON(((4455362.9412 5793918.126199999,4455362.990299999 5793918.0555,4455363.0338 5793917.924599999,4455363.068199999 5793917.6367,4455363.165099999 5793917.2958,4455363.1819 5793916.9964,4455363.1638 5793916.958699999,4455363.107699999 5793916.927899999,4455362.724899999 5793916.928099999,4455362.5591 5793916.979499999,4455362.428399999 5793917.0468,4455362.3331 5793917.123299999,4455362.2472 5793917.2607,4455362.2077 5793917.3702,4455362.159099999 5793917.5875,4455362.1687 5793917.6939,4455362.133999999 5793917.910399999,4455362.148299999 5793917.975099999,4455362.1901 5793918.0159,4455362.3097 5793918.073,4455362.582399999 5793918.1447,4455362.838999999 5793918.16,4455362.9412 5793918.126199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (259,259,271,'Alv034',34,'Alv','Stuhlmann','Bettstein in situ','Bettstein in situ','NULL',2.98547199028,0.606477210081,0.489104133806,1.2716707479,1, ST_GeomFromText('MULTIPOLYGON(((4455358.554399999 5793918.9605,4455358.7049 5793918.8275,4455358.8009 5793918.7155,4455358.926599999 5793918.494599999,4455359.010599999 5793918.296,4455359.023799999 5793918.2092,4455358.9987 5793918.099799999,4455358.937499999 5793918.0412,4455358.864 5793918.0205,4455358.600599999 5793918.066099999,4455358.512299999 5793918.104199999,4455358.366899999 5793918.2003,4455358.2916 5793918.2728,4455358.1675 5793918.4462,4455358.113499999 5793918.5839,4455358.1138 5793918.647199999,4455358.187199999 5793918.8715,4455358.2521 5793919.004,4455358.308699999 5793919.0622,4455358.352599999 5793919.0708,4455358.554399999 5793918.9605)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (260,260,271,'Alv034',34,'Alv','Stuhlmann','Bettstein in situ','Bettstein in situ','NULL',2.66685980994,0.503570519733,0.410236446323,1.06661476044,1, ST_GeomFromText('MULTIPOLYGON(((4455361.630699999 5793919.518999999,4455361.8743 5793919.3978,4455361.934899999 5793919.3376,4455362.025 5793919.2269,4455362.065799999 5793919.1345,4455362.0613 5793919.081,4455362.025899999 5793918.988299999,4455361.945799999 5793918.9252,4455361.650799999 5793918.879399999,4455361.349399999 5793918.9065,4455361.1714 5793918.9384,4455361.1013 5793919.002399999,4455361.068599999 5793919.0522,4455361.068599999 5793919.1325,4455361.1144 5793919.2869,4455361.189399999 5793919.447899999,4455361.2437 5793919.483899999,4455361.567999999 5793919.5261,4455361.630699999 5793919.518999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (261,261,274,'Alv037',37,'Alv','Stuhlmann','Stein','NULL','NULL',3.02864721841,0.591314794639,0.477483658612,1.24145751239,1, ST_GeomFromText('MULTIPOLYGON(((4454605.0586 5793010.795099999,4454605.165599999 5793010.7782,4454605.2121 5793010.7576,4454605.239099999 5793010.7302,4454605.249999999 5793010.562699999,4454605.234799999 5793010.4831,4454605.0284 5793010.2478,4454604.9406 5793010.1826,4454604.805599999 5793010.1293,4454604.6084 5793010.0942,4454604.438099999 5793010.152499999,4454604.2784 5793010.2396,4454604.051099999 5793010.472999999,4454604.046299999 5793010.5185,4454604.0672 5793010.560399999,4454604.1639 5793010.627599999,4454604.549499999 5793010.738199999,4454604.8452 5793010.7758,4454604.9445 5793010.8021,4454605.0586 5793010.795099999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (262,262,274,'Alv037',37,'Alv','Stuhlmann','Stein','NULL','NULL',3.06154497985,0.588305340303,0.475177212808,1.2354607533,1, ST_GeomFromText('MULTIPOLYGON(((4454608.3469 5793015.687699999,4454608.370299999 5793015.663699999,4454608.4093 5793015.572899999,4454608.4051 5793015.471899999,4454608.352099999 5793015.3758,4454608.0475 5793015.144799999,4454607.9466 5793015.046499999,4454607.8117 5793014.9471,4454607.747 5793014.9208,4454607.680999999 5793014.9122,4454607.6025 5793014.940999999,4454607.4197 5793015.074799999,4454607.344399999 5793015.147299999,4454607.223299999 5793015.3265,4454607.220399999 5793015.3748,4454607.252 5793015.433299999,4454607.3387 5793015.4889,4454607.501799999 5793015.5262,4454607.782399999 5793015.6403,4454607.9396 5793015.682299999,4454608.0542 5793015.6917,4454608.2986 5793015.7004,4454608.3469 5793015.687699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (263,263,274,'Alv037',37,'Alv','Stuhlmann','Stein','NULL','NULL',3.52650254251,0.931798214736,0.738430151774,1.91991839461,1, ST_GeomFromText('MULTIPOLYGON(((4454612.352199999 5793016.9109,4454612.5444 5793016.8703,4454612.688 5793016.824999999,4454612.8777 5793016.743599999,4454612.930399999 5793016.713199999,4454612.970399999 5793016.6644,4454613.0152 5793016.543999999,4454613.058699999 5793016.3658,4454613.0678 5793016.1783,4454613.054299999 5793016.1093,4454612.9956 5793015.9896,4454612.906899999 5793015.8617,4454612.832999999 5793015.8145,4454612.727199999 5793015.7837,4454612.6391 5793015.808399999,4454612.216599999 5793016.0238,4454612.0717 5793016.184399999,4454612.0328 5793016.248299999,4454611.9735 5793016.405899999,4454611.9527 5793016.5151,4454611.9834 5793016.7002,4454612.0551 5793016.818099999,4454612.126099999 5793016.8913,4454612.2454 5793016.9143,4454612.352199999 5793016.9109)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (264,264,274,'Alv037',37,'Alv','Stuhlmann','Stein','NULL','NULL',3.60528520625,0.931290121028,0.738040748756,1.91890594676,1, ST_GeomFromText('MULTIPOLYGON(((4454611.0899 5793018.033999999,4454611.1593 5793017.8724,4454611.3655 5793017.5357,4454611.3869 5793017.383999999,4454611.3561 5793017.2498,4454611.208599999 5793017.026699999,4454611.0981 5793016.929199999,4454610.9636 5793016.858699999,4454610.687099999 5793016.815099999,4454610.607499999 5793016.823799999,4454610.451 5793016.8736,4454610.360999999 5793016.938599999,4454610.275299999 5793017.0436,4454610.270999999 5793017.1444,4454610.2993 5793017.293999999,4454610.3918 5793017.4165,4454610.443099999 5793017.527799999,4454610.597299999 5793017.7572,4454610.804999999 5793017.957399999,4454610.913399999 5793018.0227,4454610.997999999 5793018.0482,4454611.0663 5793018.050699999,4454611.0899 5793018.033999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (265,265,274,'Alv037',37,'Alv','Stuhlmann','Stein','NULL','NULL',3.35995837882,0.812088539677,0.646684656809,1.6813801077,1, ST_GeomFromText('MULTIPOLYGON(((4454609.5157 5793018.064799999,4454609.645399999 5793018.023099999,4454609.7006 5793017.989499999,4454609.8606 5793017.905099999,4454610.1643 5793017.7027,4454610.217699999 5793017.616499999,4454610.2319 5793017.5007,4454610.2023 5793017.430999999,4454610.068199999 5793017.298499999,4454609.608799999 5793017.0295,4454609.558 5793017.020199999,4454609.4477 5793017.051799999,4454609.3755 5793017.0894,4454609.244599999 5793017.2137,4454609.205299999 5793017.2683,4454609.161299999 5793017.4493,4454609.1622 5793017.904999999,4454609.211299999 5793018.039999999,4454609.352199999 5793018.0921,4454609.4122 5793018.092499999,4454609.5157 5793018.064799999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (266,266,274,'Alv037',37,'Alv','Stuhlmann','Stein','NULL','NULL',3.59685753884,0.981276880161,0.776350600955,2.01851156248,1, ST_GeomFromText('MULTIPOLYGON(((4454612.854 5793018.486999999,4454613.0608 5793018.443299999,4454613.302299999 5793018.361099999,4454613.466099999 5793018.2456,4454613.5859 5793018.113099999,4454613.6287 5793017.908299999,4454613.6117 5793017.7344,4454613.493099999 5793017.5875,4454613.331199999 5793017.463099999,4454612.9785 5793017.482799999,4454612.739199999 5793017.535199999,4454612.6835 5793017.5621,4454612.625599999 5793017.6128,4454612.524799999 5793017.716,4454612.412899999 5793017.8648,4454612.375699999 5793017.9656,4454612.3666 5793018.043899999,4454612.377299999 5793018.1487,4454612.427199999 5793018.247999999,4454612.5617 5793018.3735,4454612.667 5793018.4359,4454612.790199999 5793018.4886,4454612.854 5793018.486999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (267,267,274,'Alv037',37,'Alv','Stuhlmann','Stein','NULL','NULL',4.11690379478,1.23769596532,0.972870187818,2.52946248833,1, ST_GeomFromText('MULTIPOLYGON(((4454615.010999999 5793018.4779,4454615.094399999 5793018.441899999,4454615.1479 5793018.3931,4454615.185899999 5793018.3344,4454615.219999999 5793018.0328,4454615.2483 5793017.9207,4454615.2395 5793017.6749,4454615.250099999 5793017.5523,4454615.2372 5793017.4778,4454615.244599999 5793017.421599999,4454615.235199999 5793017.369999999,4454615.1885 5793017.260199999,4454615.129599999 5793017.1772,4454615.0206 5793017.100899999,4454614.825199999 5793017.025499999,4454614.7317 5793017.0611,4454614.5805 5793017.176,4454614.428399999 5793017.3726,4454614.3491 5793017.451899999,4454614.296199999 5793017.529699999,4454614.198099999 5793017.733799999,4454614.1606 5793017.853199999,4454614.1577 5793017.9273,4454614.247299999 5793018.237999999,4454614.292999999 5793018.3048,4454614.3748 5793018.378,4454614.575199999 5793018.4787,4454614.916899999 5793018.4977,4454615.010999999 5793018.4779)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (268,268,275,'Alv038',38,'Alv','Stuhlmann','Stein','NULL','NULL',3.40725136317,0.863225310108,0.685875877667,1.78327728193,1, ST_GeomFromText('MULTIPOLYGON(((4454562.781 5792782.0402,4454562.8836 5792781.977099999,4454562.9247 5792781.9315,4454562.949099999 5792781.869699999,4454562.961799999 5792781.7883,4454562.964499999 5792781.637399999,4454562.944199999 5792781.5163,4454562.8684 5792781.316099999,4454562.854199999 5792781.246799999,4454562.8278 5792781.197799999,4454562.774799999 5792781.1565,4454562.583599999 5792781.1247,4454562.4418 5792781.082599999,4454562.1971 5792781.0808,4454562.0097 5792781.119699999,4454561.9883 5792781.152,4454561.963299999 5792781.289899999,4454561.923799999 5792781.417999999,4454561.911999999 5792781.5767,4454561.955099999 5792781.800699999,4454561.9856 5792781.850999999,4454562.028199999 5792781.920499999,4454562.075 5792781.946299999,4454562.155399999 5792781.9758,4454562.300999999 5792781.9944,4454562.495199999 5792782.0515,4454562.6178 5792782.0655,4454562.781 5792782.0402)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (269,269,275,'Alv038',38,'Alv','Stuhlmann','Stein','NULL','NULL',3.41791671852,0.837573475106,0.666216311321,1.73216240943,1, ST_GeomFromText('MULTIPOLYGON(((4454562.5531 5792783.753399999,4454562.5991 5792783.714999999,4454562.663099999 5792783.582499999,4454562.6813 5792783.514399999,4454562.8139 5792783.1896,4454562.8464 5792783.0591,4454562.852199999 5792782.813699999,4454562.8075 5792782.7752,4454562.7136 5792782.6414,4454562.651399999 5792782.5784,4454562.5519 5792782.5337,4454562.4948 5792782.523299999,4454562.453999999 5792782.5285,4454562.324099999 5792782.611999999,4454562.2176 5792782.640599999,4454562.183299999 5792782.6609,4454561.950799999 5792782.9174,4454561.856599999 5792783.052999999,4454561.8528 5792783.092,4454561.881599999 5792783.1753,4454561.955299999 5792783.285,4454562.0535 5792783.4713,4454562.173999999 5792783.6173,4454562.2718 5792783.6808,4454562.326799999 5792783.6973,4454562.400999999 5792783.740299999,4454562.4675 5792783.760299999,4454562.5531 5792783.753399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (270,270,275,'Alv038',38,'Alv','Stuhlmann','Stein','NULL','NULL',3.7424771823,1.07380716038,0.847265807712,2.20289110005,1, ST_GeomFromText('MULTIPOLYGON(((4454547.8541 5792799.2957,4454547.9653 5792799.2484,4454548.1593 5792799.119799999,4454548.271399999 5792798.994599999,4454548.4035 5792798.672,4454548.399199999 5792798.561699999,4454548.383299999 5792798.5075,4454548.2626 5792798.3452,4454548.032999999 5792798.181199999,4454547.9203 5792798.150599999,4454547.8146 5792798.091,4454547.758 5792798.081499999,4454547.536 5792798.080099999,4454547.4457 5792798.0939,4454547.3622 5792798.1773,4454547.2975 5792798.2914,4454547.269799999 5792798.380899999,4454547.243099999 5792798.672199999,4454547.325 5792799.0095,4454547.4422 5792799.1368,4454547.582499999 5792799.2363,4454547.6413 5792799.263199999,4454547.7866 5792799.306299999,4454547.8541 5792799.2957)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (271,271,289,'Alv046',46,'Alv','Stuhlmann','Stein','Stein','NULL',0.897390375413,0.060497310112,0.0706651384698,0.183729360021,1, ST_GeomFromText('MULTIPOLYGON(((4455534.5979 5793164.797299999,4455534.6535 5793164.762499999,4455534.6923 5793164.6798,4455534.690999999 5793164.551699999,4455534.671799999 5793164.522199999,4455534.6176 5793164.484099999,4455534.555499999 5793164.478199999,4455534.501299999 5793164.515799999,4455534.463899999 5793164.594699999,4455534.4493 5793164.6458,4455534.461299999 5793164.706299999,4455534.4956 5793164.766799999,4455534.5482 5793164.798,4455534.5979 5793164.797299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (272,272,289,'Alv046',46,'Alv','Stuhlmann','Stein','Stein','NULL',1.03482289168,0.0833482298717,0.0881780833736,0.229263016771,1, ST_GeomFromText('MULTIPOLYGON(((4455535.2286 5793165.5219,4455535.2887 5793165.476399999,4455535.317099999 5793165.417199999,4455535.3206 5793165.353599999,4455535.3004 5793165.2847,4455535.270299999 5793165.2374,4455535.2241 5793165.203199999,4455535.171199999 5793165.1849,4455535.106599999 5793165.204299999,4455535.0624 5793165.238299999,4455535.0142 5793165.308299999,4455535.0102 5793165.3563,4455535.0277 5793165.458799999,4455535.0729 5793165.505599999,4455535.1199 5793165.529699999,4455535.173399999 5793165.535099999,4455535.2286 5793165.5219)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (273,273,289,'Alv046',46,'Alv','Stuhlmann','Stein','Stein','NULL',2.49375410525,0.45088123014,0.36985537478,0.961623974427,1, ST_GeomFromText('MULTIPOLYGON(((4455538.047199999 5793165.8428,4455538.1193 5793165.8168,4455538.1968 5793165.765599999,4455538.2854 5793165.6502,4455538.304399999 5793165.6026,4455538.3069 5793165.390499999,4455538.266599999 5793165.2324,4455538.2417 5793165.197599999,4455538.058899999 5793165.0722,4455537.9845 5793165.036599999,4455537.868599999 5793165.015499999,4455537.802 5793165.014499999,4455537.746899999 5793165.0335,4455537.7126 5793165.059399999,4455537.682799999 5793165.142799999,4455537.6917 5793165.2693,4455537.669999999 5793165.5427,4455537.632799999 5793165.653,4455537.6365 5793165.7039,4455537.656499999 5793165.736899999,4455537.7547 5793165.8156,4455537.815799999 5793165.8388,4455537.95 5793165.853199999,4455538.047199999 5793165.8428)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (274,274,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','19',2.85109213016,0.594337764708,0.479800462872,1.24748120347,1, ST_GeomFromText('MULTIPOLYGON(((4454682.177099999 5791258.628799999,4454682.256599999 5791258.606499999,4454682.2903 5791258.6062,4454682.3387 5791258.58,4454682.358199999 5791258.565899999,4454682.431599999 5791258.5372,4454682.5536 5791258.4626,4454682.638199999 5791258.376099999,4454682.6594 5791258.319199999,4454682.6567 5791258.222599999,4454682.6052 5791258.1259,4454682.581199999 5791258.096799999,4454682.5606 5791258.0511,4454682.506699999 5791257.9668,4454682.4445 5791257.887599999,4454682.396999999 5791257.8418,4454682.309299999 5791257.7935,4454682.237599999 5791257.8046,4454682.1527 5791257.8475,4454682.087 5791257.8669,4454682.055599999 5791257.8681,4454681.994599999 5791257.8933,4454681.803199999 5791257.989399999,4454681.6973 5791258.0284,4454681.649899999 5791258.0602,4454681.642699999 5791258.082299999,4454681.662999999 5791258.1816,4454681.746899999 5791258.375499999,4454681.8283 5791258.497099999,4454681.882399999 5791258.551899999,4454681.9786 5791258.609999999,4454682.063299999 5791258.634099999,4454682.177099999 5791258.628799999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (275,275,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','1',4.34616697577,1.37907707049,1.08122466683,2.81118413375,1, ST_GeomFromText('MULTIPOLYGON(((4454670.375799999 5791257.9831,4454670.617899999 5791257.848699999,4454670.763299999 5791257.604299999,4454670.6665 5791257.256599999,4454670.6101 5791257.148,4454670.559799999 5791257.088999999,4454670.480499999 5791257.049399999,4454670.2066 5791256.983699999,4454669.882899999 5791256.885099999,4454669.751 5791256.897199999,4454669.565799999 5791256.985099999,4454669.3869 5791257.093499999,4454669.2394 5791257.210799999,4454669.173499999 5791257.345499999,4454669.1666 5791257.393799999,4454669.1868 5791257.5359,4454669.235299999 5791257.609799999,4454669.3524 5791257.891599999,4454669.394999999 5791257.920199999,4454670.188199999 5791258.0273,4454670.375799999 5791257.9831)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (276,276,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','22',4.07191537538,1.1777408203,0.926920564681,2.40999346817,1, ST_GeomFromText('MULTIPOLYGON(((4454673.777999999 5791258.4669,4454673.832 5791258.451199999,4454673.8667 5791258.4261,4454674.026999999 5791258.263599999,4454674.108 5791258.200899999,4454674.142099999 5791258.1531,4454674.2264 5791258.0766,4454674.2702 5791258.0196,4454674.359199999 5791257.932299999,4454674.5064 5791257.708799999,4454674.512299999 5791257.634999999,4454674.2466 5791257.162699999,4454674.156 5791257.043299999,4454674.0899 5791257.0138,4454673.901399999 5791257.024399999,4454673.821899999 5791257.0458,4454673.7478 5791257.086899999,4454673.4823 5791257.354199999,4454673.440499999 5791257.408399999,4454673.383899999 5791257.5402,4454673.354299999 5791257.741399999,4454673.3535 5791257.8355,4454673.383899999 5791258.139699999,4454673.456299999 5791258.419099999,4454673.4987 5791258.446,4454673.672799999 5791258.4681,4454673.777999999 5791258.4669)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (277,277,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','18',3.03564032914,0.652248934967,0.524183583759,1.36287731777,1, ST_GeomFromText('MULTIPOLYGON(((4454685.1935 5791259.4462,4454685.2465 5791259.4372,4454685.3519 5791259.395899999,4454685.4061 5791259.3716,4454685.462899999 5791259.33,4454685.5147 5791259.2791,4454685.596499999 5791259.180099999,4454685.608199999 5791259.128,4454685.6074 5791259.079299999,4454685.5909 5791259.012499999,4454685.5431 5791258.9337,4454685.404199999 5791258.786,4454685.365299999 5791258.754399999,4454685.1945 5791258.720799999,4454685.095599999 5791258.709799999,4454685 5791258.660199999,4454684.916699999 5791258.6281,4454684.779299999 5791258.5875,4454684.684399999 5791258.5806,4454684.6392 5791258.590399999,4454684.603799999 5791258.617599999,4454684.5798 5791258.6642,4454684.5629 5791258.7301,4454684.564 5791258.8076,4454684.5919 5791258.973899999,4454684.626899999 5791259.0822,4454684.6834 5791259.183,4454684.711099999 5791259.236199999,4454684.7876 5791259.342199999,4454684.908999999 5791259.427699999,4454685.0466 5791259.4526,4454685.1935 5791259.4462)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (278,278,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','21',2.55611223926,0.409243820021,0.337944463664,0.878655605526,1, ST_GeomFromText('MULTIPOLYGON(((4454676.0459 5791258.948899999,4454676.132799999 5791258.9217,4454676.178799999 5791258.891499999,4454676.288099999 5791258.8395,4454676.3749 5791258.7771,4454676.391099999 5791258.7574,4454676.428299999 5791258.739399999,4454676.4603 5791258.7014,4454676.502199999 5791258.673599999,4454676.5173 5791258.6522,4454676.561499999 5791258.615299999,4454676.5761 5791258.5809,4454676.605 5791258.544099999,4454676.637699999 5791258.465299999,4454676.634999999 5791258.446799999,4454676.616 5791258.4199,4454676.5733 5791258.4011,4454676.470599999 5791258.4019,4454676.1944 5791258.375399999,4454676.145899999 5791258.3778,4454676.1041 5791258.369799999,4454675.9587 5791258.364399999,4454675.8046 5791258.3212,4454675.7766 5791258.3264,4454675.744199999 5791258.345,4454675.691899999 5791258.421,4454675.682799999 5791258.564099999,4454675.700199999 5791258.629,4454675.7421 5791258.7268,4454675.813099999 5791258.835899999,4454675.8721 5791258.907199999,4454675.922199999 5791258.9438,4454675.9697 5791258.959799999,4454676.0459 5791258.948899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (279,279,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','20',3.27487307641,0.787609189831,0.627923683087,1.63260157602,1, ST_GeomFromText('MULTIPOLYGON(((4454678.499099999 5791259.557399999,4454678.5855 5791259.511099999,4454678.729399999 5791259.3942,4454678.847299999 5791259.259299999,4454678.915799999 5791259.164799999,4454678.928999999 5791259.1182,4454678.924599999 5791259.030099999,4454678.8715 5791258.845799999,4454678.8298 5791258.738099999,4454678.8073 5791258.6577,4454678.7763 5791258.580199999,4454678.7449 5791258.529799999,4454678.706799999 5791258.4976,4454678.663499999 5791258.4746,4454678.615699999 5791258.464999999,4454678.4523 5791258.4691,4454678.282599999 5791258.5052,4454678.2302 5791258.512199999,4454678.1742 5791258.5098,4454678.001799999 5791258.566299999,4454677.967799999 5791258.600999999,4454677.946399999 5791258.6434,4454677.9435 5791258.7663,4454677.954699999 5791258.847699999,4454677.9948 5791258.969,4454678.1034 5791259.206399999,4454678.1765 5791259.3285,4454678.2626 5791259.453099999,4454678.3119 5791259.4978,4454678.398099999 5791259.5438,4454678.446399999 5791259.554999999,4454678.499099999 5791259.557399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (280,280,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','2',4.48158217512,1.46127642984,1.14422225583,2.97497786516,1, ST_GeomFromText('MULTIPOLYGON(((4454671.0108 5791259.0383,4454671.179899999 5791259.0142,4454671.3688 5791258.9581,4454671.459699999 5791258.9186,4454671.5888 5791258.8395,4454671.6398 5791258.7265,4454671.6402 5791258.594399999,4454671.5997 5791258.4057,4454671.5729 5791258.1535,4454671.452999999 5791257.692199999,4454671.396599999 5791257.651,4454671.189699999 5791257.6147,4454671.032999999 5791257.6015,4454670.763299999 5791257.604299999,4454670.617899999 5791257.848699999,4454670.583499999 5791257.960599999,4454670.5437 5791258.039799999,4454670.433899999 5791258.324899999,4454670.3649 5791258.642899999,4454670.3683 5791258.704299999,4454670.3858 5791258.7609,4454670.5058 5791258.933199999,4454670.5848 5791258.981599999,4454670.6946 5791259.012,4454670.878499999 5791259.042199999,4454671.0108 5791259.0383)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (281,281,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','32',2.12694698271,0.28102445998,0.239677146129,0.623160579935,1, ST_GeomFromText('MULTIPOLYGON(((4454687.513299999 5791260.8867,4454687.565999999 5791260.8495,4454687.623999999 5791260.7926,4454687.722699999 5791260.6686,4454687.7378 5791260.6234,4454687.770999999 5791260.579299999,4454687.820299999 5791260.437799999,4454687.8627 5791260.2396,4454687.8644 5791260.1763,4454687.8536 5791260.1127,4454687.840599999 5791260.088999999,4454687.8227 5791260.0767,4454687.7947 5791260.071799999,4454687.7684 5791260.0775,4454687.588399999 5791260.182499999,4454687.5147 5791260.243,4454687.318799999 5791260.4121,4454687.2964 5791260.468299999,4454687.294099999 5791260.4964,4454687.3978 5791260.817999999,4454687.4389 5791260.8739,4454687.494099999 5791260.889799999,4454687.513299999 5791260.8867)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (282,282,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','15',4.64344807687,1.53374838455,1.19976476192,3.11938838099,1, ST_GeomFromText('MULTIPOLYGON(((4454690.179999999 5791261.0865,4454690.3536 5791260.979,4454690.644399999 5791260.824899999,4454690.7899 5791260.7136,4454690.861999999 5791260.5611,4454690.882299999 5791260.331399999,4454690.809799999 5791259.833799999,4454690.792299999 5791259.759899999,4454690.7674 5791259.727499999,4454690.7181 5791259.7113,4454690.575299999 5791259.7257,4454690.204499999 5791259.7993,4454690.086299999 5791259.8386,4454690.0126 5791259.8932,4454689.977099999 5791259.905099999,4454689.8369 5791259.893799999,4454689.5343 5791260.0139,4454689.44 5791260.090399999,4454689.413399999 5791260.173299999,4454689.4319 5791260.340099999,4454689.502 5791260.6928,4454689.568199999 5791260.905799999,4454689.597 5791260.936699999,4454689.6441 5791260.9626,4454689.739099999 5791261.0017,4454689.850499999 5791261.0316,4454689.928299999 5791261.046399999,4454690.092899999 5791261.102399999,4454690.179999999 5791261.0865)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (283,283,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Kammerstein','Kammerstein','23',2.5137540192,0.43344812951,0.356494646457,0.926886080787,1, ST_GeomFromText('MULTIPOLYGON(((4454678.4626 5791260.270199999,4454679.0498 5791260.1633,4454679.0821 5791260.1535,4454679.097599999 5791260.140799999,4454679.1078 5791260.077899999,4454679.0787 5791259.949999999,4454679.062599999 5791259.924599999,4454679.0054 5791259.8825,4454678.983699999 5791259.8461,4454678.962399999 5791259.789599999,4454678.9538 5791259.6884,4454678.9225 5791259.649599999,4454678.891999999 5791259.6379,4454678.8075 5791259.6239,4454678.7289 5791259.6195,4454678.555499999 5791259.649,4454678.4378 5791259.6992,4454678.349 5791259.7707,4454678.2543 5791259.8638,4454678.2158 5791259.9315,4454678.206799999 5791259.969699999,4454678.2158 5791260.038,4454678.239 5791260.077199999,4454678.264 5791260.161599999,4454678.295599999 5791260.2123,4454678.354399999 5791260.258099999,4454678.405199999 5791260.275599999,4454678.4626 5791260.270199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (284,284,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Kammerstein','Kammerstein','29',3.23589204635,0.754683959664,0.602689786686,1.56699344538,1, ST_GeomFromText('MULTIPOLYGON(((4454682.9713 5791261.1632,4454683.039699999 5791261.129399999,4454683.077999999 5791261.100999999,4454683.1517 5791261.023099999,4454683.192599999 5791260.96,4454683.2505 5791260.825799999,4454683.252299999 5791260.727299999,4454683.237499999 5791260.617499999,4454683.2023 5791260.514599999,4454683.194799999 5791260.4649,4454683.0952 5791260.2353,4454683.027099999 5791260.151499999,4454682.9751 5791260.1017,4454682.870699999 5791260.0501,4454682.780899999 5791260.0414,4454682.5776 5791260.0833,4454682.485999999 5791260.115,4454682.3985 5791260.1586,4454682.321499999 5791260.1787,4454682.355899999 5791260.559599999,4454682.3978 5791260.708599999,4454682.5398 5791260.8747,4454682.6194 5791260.9415,4454682.7768 5791261.108599999,4454682.820899999 5791261.140599999,4454682.9177 5791261.160599999,4454682.9713 5791261.1632)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (285,285,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','3',3.94099188514,1.15921624524,0.912723330352,2.37308065892,1, ST_GeomFromText('MULTIPOLYGON(((4454670.3578 5791260.289,4454670.439 5791260.2453,4454670.495799999 5791260.2038,4454670.613499999 5791260.081199999,4454670.661 5791259.9416,4454670.682799999 5791259.8055,4454670.699699999 5791259.6083,4454670.684399999 5791259.5196,4454670.663099999 5791259.473799999,4454670.661399999 5791259.433299999,4454670.6358 5791259.3416,4454670.5751 5791259.232,4454670.461199999 5791259.106899999,4454670.354799999 5791259.028599999,4454670.2296 5791258.994899999,4454670.1732 5791259.0042,4454670.0147 5791259.063799999,4454669.722 5791259.2246,4454669.692999999 5791259.2564,4454669.648099999 5791259.3552,4454669.6628 5791259.557299999,4454669.6489 5791259.624399999,4454669.6019 5791259.7397,4454669.5542 5791259.9844,4454669.5641 5791260.0371,4454669.589999999 5791260.095,4454669.6248 5791260.142899999,4454669.6628 5791260.171499999,4454669.831 5791260.2267,4454670.2735 5791260.3043,4454670.3578 5791260.289)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (286,286,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Kammerstein','Kammerstein','24',3.56030968268,0.84526085022,0.672107915608,1.74748058058,1, ST_GeomFromText('MULTIPOLYGON(((4454678.210799999 5791261.524199999,4454678.310999999 5791261.512299999,4454678.3369 5791261.4922,4454678.3556 5791261.356499999,4454678.352599999 5791261.1212,4454678.3634 5791260.961999999,4454678.344299999 5791260.8505,4454678.3448 5791260.5763,4454678.358 5791260.4801,4454678.349299999 5791260.431299999,4454678.3294 5791260.4098,4454678.2992 5791260.399399999,4454678.1763 5791260.3991,4454678.002199999 5791260.3791,4454677.905 5791260.388399999,4454677.8053 5791260.420099999,4454677.787499999 5791260.4327,4454677.7356 5791260.493599999,4454677.6489 5791260.510999999,4454677.528199999 5791260.5766,4454677.469499999 5791260.644899999,4454677.456799999 5791260.6741,4454677.469999999 5791260.7543,4454677.4576 5791260.807299999,4454677.453599999 5791260.8771,4454677.503499999 5791260.9955,4454677.557099999 5791261.1347,4454677.6825 5791261.2257,4454677.723399999 5791261.2685,4454677.8397 5791261.486899999,4454677.8709 5791261.523499999,4454677.941499999 5791261.5602,4454678.0354 5791261.573599999,4454678.210799999 5791261.524199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (287,287,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Deckstein','Deckstein','27',3.90233925655,0.937581859738,0.742862737303,1.93144311699,1, ST_GeomFromText('MULTIPOLYGON(((4454680.741 5791261.850099999,4454680.7911 5791261.8278,4454680.825699999 5791261.801999999,4454680.9061 5791261.6992,4454680.9177 5791261.6453,4454680.933699999 5791261.285299999,4454680.953099999 5791261.1663,4454680.9577 5791261.042899999,4454680.971099999 5791260.9966,4454681.000799999 5791260.947499999,4454680.9653 5791260.888299999,4454680.941599999 5791260.7751,4454680.928999999 5791260.7444,4454680.888899999 5791260.526,4454680.8623 5791260.459799999,4454680.8425 5791260.421299999,4454680.7976 5791260.367399999,4454680.767799999 5791260.350199999,4454680.743599999 5791260.348799999,4454680.708599999 5791260.3705,4454680.590499999 5791260.495899999,4454680.4758 5791260.6501,4454680.3092 5791260.8441,4454680.256 5791260.922499999,4454680.213399999 5791260.9649,4454680.158599999 5791261.0427,4454680.0751 5791261.116,4454680.062599999 5791261.247999999,4454679.9965 5791261.3582,4454680.006599999 5791261.4087,4454680.046799999 5791261.4878,4454680.086799999 5791261.537799999,4454680.150899999 5791261.5906,4454680.276399999 5791261.664899999,4454680.4934 5791261.762499999,4454680.6156 5791261.838899999,4454680.6633 5791261.8496,4454680.741 5791261.850099999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (288,288,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Deckstein','Deckstein','26',5.04667993016,1.62369263506,1.26869803551,3.29861489232,1, ST_GeomFromText('MULTIPOLYGON(((4454679.405 5791261.924499999,4454679.4609 5791261.914799999,4454679.5365 5791261.8803,4454679.653199999 5791261.770899999,4454679.7251 5791261.728099999,4454679.774799999 5791261.5883,4454679.838399999 5791261.4911,4454679.916299999 5791261.416099999,4454679.9965 5791261.3582,4454680.062599999 5791261.247999999,4454680.0751 5791261.116,4454680.0255 5791261.0383,4454679.994599999 5791260.965099999,4454679.9767 5791260.8629,4454679.9763 5791260.7202,4454679.989699999 5791260.615499999,4454679.983799999 5791260.340199999,4454679.9948 5791260.2638,4454679.9817 5791260.2222,4454679.959599999 5791260.2045,4454679.928299999 5791260.1938,4454679.858 5791260.2049,4454679.7423 5791260.201799999,4454679.648199999 5791260.139699999,4454679.5229 5791260.0755,4454679.432199999 5791260.0424,4454679.3771 5791260.042899999,4454679.3096 5791260.120799999,4454679.163499999 5791260.344799999,4454679.0639 5791260.462999999,4454678.954099999 5791260.6135,4454678.905299999 5791260.7146,4454678.870299999 5791260.8571,4454678.859899999 5791260.9342,4454678.8918 5791260.9887,4454678.936599999 5791261.029699999,4454678.9527 5791261.0565,4454678.9616 5791261.183199999,4454678.936999999 5791261.323599999,4454678.8749 5791261.4315,4454678.871799999 5791261.460999999,4454678.8788 5791261.482599999,4454678.9209 5791261.557,4454678.9632 5791261.5984,4454678.999499999 5791261.6476,4454679.0629 5791261.6958,4454679.165 5791261.802999999,4454679.3091 5791261.901399999,4454679.372 5791261.9229,4454679.405 5791261.924499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (289,289,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Deckstein','Deckstein','28',6.02240314752,2.37316170024,1.84309112707,4.79203693037,1, ST_GeomFromText('MULTIPOLYGON(((4454682.1182 5791262.131999999,4454682.1719 5791262.094299999,4454682.321899999 5791261.936799999,4454682.3808 5791261.8881,4454682.433699999 5791261.764599999,4454682.469899999 5791261.547199999,4454682.4417 5791261.424499999,4454682.438599999 5791261.2802,4454682.422699999 5791261.1765,4454682.3967 5791260.8596,4454682.3978 5791260.708599999,4454682.355899999 5791260.559599999,4454682.321499999 5791260.1787,4454682.300599999 5791260.0523,4454682.247299999 5791259.959699999,4454682.2065 5791259.924,4454682.131099999 5791259.899399999,4454682.048299999 5791259.886499999,4454681.8403 5791259.880799999,4454681.5634 5791259.8913,4454681.437199999 5791259.911599999,4454681.319 5791259.959599999,4454681.2794 5791260.0029,4454681.2383 5791260.0953,4454681.202499999 5791260.345499999,4454681.1457 5791260.5372,4454681.049599999 5791260.7627,4454681.0339 5791260.8747,4454681.000799999 5791260.947499999,4454681.040699999 5791261.0579,4454681.060999999 5791261.0895,4454681.2137 5791261.276799999,4454681.284799999 5791261.379,4454681.4138 5791261.541799999,4454681.5425 5791261.696299999,4454681.7673 5791261.932099999,4454681.853799999 5791262.002,4454681.922399999 5791262.076199999,4454681.9802 5791262.1224,4454682.056099999 5791262.142,4454682.1182 5791262.131999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (290,290,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Kammerstein','Kammerstein','25',2.54529103435,0.340173524662,0.285008989301,0.741023372183,1, ST_GeomFromText('MULTIPOLYGON(((4454678.6632 5791262.252399999,4454678.722199999 5791262.2322,4454678.794099999 5791262.1809,4454678.881299999 5791262.0962,4454678.940799999 5791262.0489,4454678.9819 5791262.005699999,4454678.991999999 5791261.981599999,4454678.990299999 5791261.955499999,4454678.970399999 5791261.923599999,4454678.917 5791261.8923,4454678.7158 5791261.8361,4454678.552799999 5791261.8066,4454678.3397 5791261.737999999,4454678.187199999 5791261.6804,4454678.1237 5791261.6478,4454678.064699999 5791261.6369,4454678.012799999 5791261.648499999,4454677.982599999 5791261.6686,4454677.964599999 5791261.698499999,4454677.9489 5791261.747199999,4454677.9565 5791261.807099999,4454678.0274 5791261.907999999,4454678.089999999 5791261.970399999,4454678.165 5791262.0226,4454678.2532 5791262.064699999,4454678.303999999 5791262.098099999,4454678.364299999 5791262.115299999,4454678.5827 5791262.2355,4454678.637 5791262.2531,4454678.6632 5791262.252399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (291,291,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Kammerstein','Kammerstein','30',3.75204585472,1.04754498974,0.82713848014,2.15056004836,1, ST_GeomFromText('MULTIPOLYGON(((4454682.809799999 5791262.5942,4454682.9571 5791262.558299999,4454683.070799999 5791262.513299999,4454683.158099999 5791262.4493,4454683.185399999 5791262.398099999,4454683.223699999 5791262.354199999,4454683.2471 5791262.3114,4454683.3273 5791262.125299999,4454683.3441 5791262.049,4454683.362499999 5791262.0083,4454683.3831 5791261.878,4454683.369599999 5791261.797599999,4454683.331299999 5791261.693499999,4454683.255099999 5791261.5471,4454683.173 5791261.4319,4454683.062699999 5791261.298,4454682.978099999 5791261.2374,4454682.894399999 5791261.219399999,4454682.841099999 5791261.2331,4454682.6276 5791261.378,4454682.469899999 5791261.547199999,4454682.433699999 5791261.764599999,4454682.3808 5791261.8881,4454682.376299999 5791261.972999999,4454682.354799999 5791262.100999999,4454682.3596 5791262.219499999,4454682.3731 5791262.303099999,4454682.410299999 5791262.4021,4454682.468299999 5791262.471499999,4454682.538599999 5791262.5282,4454682.5831 5791262.5504,4454682.720999999 5791262.587899999,4454682.809799999 5791262.5942)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (292,292,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','4',4.68320552993,1.65175851518,1.29020772604,3.35454008769,1, ST_GeomFromText('MULTIPOLYGON(((4454669.3124 5791261.492399999,4454669.5765 5791261.338899999,4454669.673399999 5791261.233699999,4454669.7591 5791261.0929,4454669.8184 5791260.976199999,4454669.890999999 5791260.7858,4454669.906999999 5791260.666699999,4454669.8936 5791260.621999999,4454669.8387 5791260.532999999,4454669.6748 5791260.354599999,4454669.4764 5791260.234099999,4454669.3682 5791260.2048,4454669.1358 5791260.2324,4454668.9017 5791260.279699999,4454668.7609 5791260.3341,4454668.538999999 5791260.459499999,4454668.381299999 5791260.6115,4454668.2768 5791260.741,4454668.2039 5791260.869899999,4454668.2015 5791260.936699999,4454668.236999999 5791261.0632,4454668.323499999 5791261.1831,4454668.405399999 5791261.2573,4454668.643099999 5791261.413799999,4454668.933799999 5791261.5601,4454669.082999999 5791261.584699999,4454669.3124 5791261.492399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (293,293,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','14',5.33643452762,1.97705238018,1.53951294417,4.00273365485,1, ST_GeomFromText('MULTIPOLYGON(((4454690.1814 5791263.5895,4454690.3185 5791263.565799999,4454690.491499999 5791263.517599999,4454690.5465 5791263.482499999,4454690.587399999 5791263.412299999,4454690.632 5791263.1958,4454690.644299999 5791262.9295,4454690.632 5791262.649299999,4454690.6151 5791262.5921,4454690.610199999 5791262.5259,4454690.572399999 5791262.4383,4454690.517699999 5791262.360899999,4454690.481399999 5791262.332499999,4454690.4039 5791262.2945,4454690.256799999 5791262.264299999,4454690.1545 5791262.231,4454690.1129 5791262.207299999,4454690.066399999 5791262.199699999,4454689.783999999 5791262.059499999,4454689.705699999 5791262.046,4454689.674599999 5791262.027599999,4454689.495699999 5791261.973899999,4454689.376299999 5791261.969699999,4454689.3386 5791261.981,4454689.282599999 5791262.0403,4454689.219299999 5791262.127,4454689.180599999 5791262.153999999,4454689.120299999 5791262.176799999,4454689.1062 5791262.196599999,4454689.082799999 5791262.282099999,4454688.891499999 5791262.524399999,4454688.875 5791262.572399999,4454688.880199999 5791262.618799999,4454688.935999999 5791262.710999999,4454689.040599999 5791262.845,4454689.258999999 5791263.051799999,4454689.4016 5791263.2937,4454689.424899999 5791263.3168,4454689.4592 5791263.3333,4454689.4939 5791263.345799999,4454689.558299999 5791263.346899999,4454689.6253 5791263.3614,4454689.948699999 5791263.494999999,4454690.083999999 5791263.573699999,4454690.1445 5791263.587999999,4454690.1814 5791263.5895)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (294,294,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','31',1.0989236803,0.0900266649635,0.093296436028,0.242570733673,1, ST_GeomFromText('MULTIPOLYGON(((4454682.426199999 5791263.483999999,4454682.450899999 5791263.491299999,4454682.526399999 5791263.4526,4454682.585799999 5791263.384999999,4454682.597599999 5791263.3494,4454682.612999999 5791263.238099999,4454682.587799999 5791263.197499999,4454682.563099999 5791263.176999999,4454682.451899999 5791263.117599999,4454682.4231 5791263.112299999,4454682.3951 5791263.1337,4454682.301099999 5791263.2441,4454682.265899999 5791263.319299999,4454682.286299999 5791263.345399999,4454682.2975 5791263.390499999,4454682.337899999 5791263.447799999,4454682.4073 5791263.489,4454682.426199999 5791263.483999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (295,295,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','13',3.5198600213,0.875574205092,0.695340070782,1.80788418403,1, ST_GeomFromText('MULTIPOLYGON(((4454688.8711 5791264.0225,4454688.9763 5791264.003599999,4454689.0696 5791263.966499999,4454689.0942 5791263.939999999,4454689.092 5791263.8682,4454689.035199999 5791263.588999999,4454688.9965 5791263.4622,4454688.941399999 5791263.355299999,4454688.893199999 5791263.290899999,4454688.7695 5791263.192199999,4454688.717899999 5791263.164499999,4454688.5798 5791263.1124,4454688.5234 5791263.103,4454688.4768 5791263.083,4454688.4353 5791263.0863,4454688.299999999 5791263.128,4454688.224999999 5791263.1631,4454688.1505 5791263.217199999,4454688.072999999 5791263.296599999,4454687.945299999 5791263.467399999,4454687.9225 5791263.513599999,4454687.888199999 5791263.563999999,4454687.8348 5791263.7563,4454687.849999999 5791263.808399999,4454687.882699999 5791263.8451,4454687.9424 5791263.8826,4454688.0942 5791263.9327,4454688.247399999 5791263.970499999,4454688.365699999 5791263.980299999,4454688.473699999 5791264.004399999,4454688.541899999 5791264.004699999,4454688.742499999 5791264.0274,4454688.8711 5791264.0225)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (296,296,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','6',3.00930464128,0.655128480064,0.526390467121,1.36861521451,1, ST_GeomFromText('MULTIPOLYGON(((4454675.0207 5791262.9271,4454675.121399999 5791262.911499999,4454675.205299999 5791262.878799999,4454675.2766 5791262.8287,4454675.320299999 5791262.760999999,4454675.3371 5791262.697499999,4454675.3508 5791262.669199999,4454675.3491 5791262.6169,4454675.373599999 5791262.457299999,4454675.364799999 5791262.4199,4454675.3765 5791262.344599999,4454675.364099999 5791262.3032,4454675.361399999 5791262.239,4454675.337 5791262.1906,4454675.2982 5791262.1521,4454675.219399999 5791262.121099999,4454675.050999999 5791262.1223,4454674.979 5791262.137599999,4454674.939 5791262.129799999,4454674.6994 5791262.110899999,4454674.628399999 5791262.119,4454674.559 5791262.149,4454674.5261 5791262.173,4454674.5009 5791262.216399999,4454674.4868 5791262.304099999,4454674.4895 5791262.3507,4454674.482499999 5791262.458499999,4454674.4927 5791262.565199999,4454674.49 5791262.6007,4454674.501799999 5791262.6984,4454674.4989 5791262.7815,4454674.5137 5791262.8506,4454674.5208 5791262.8602,4454674.5531 5791262.881799999,4454674.6352 5791262.8975,4454674.7542 5791262.9162,4454674.802799999 5791262.911,4454674.944199999 5791262.932499999,4454675.0207 5791262.9271)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (297,297,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','12',4.02964917504,1.00482391042,0.794397044942,2.06543231685,1, ST_GeomFromText('MULTIPOLYGON(((4454686.8535 5791263.9326,4454686.904799999 5791263.9154,4454687.0798 5791263.891899999,4454687.1507 5791263.8647,4454687.257399999 5791263.8595,4454687.302899999 5791263.843499999,4454687.384499999 5791263.8317,4454687.498599999 5791263.799,4454687.6469 5791263.7849,4454687.7478 5791263.7607,4454687.758899999 5791263.751199999,4454687.763799999 5791263.7342,4454687.649 5791263.5097,4454687.5333 5791263.323899999,4454687.4899 5791263.168999999,4454687.453499999 5791263.103,4454687.3479 5791262.981699999,4454687.242399999 5791262.914899999,4454687.184799999 5791262.8909,4454687.1293 5791262.887499999,4454687.083399999 5791262.8987,4454686.949699999 5791262.955399999,4454686.891999999 5791262.9976,4454686.7882 5791263.0558,4454686.680999999 5791263.134899999,4454686.640599999 5791263.152499999,4454686.534599999 5791263.229,4454686.5124 5791263.2585,4454686.458899999 5791263.2936,4454686.388399999 5791263.381799999,4454686.3254 5791263.4439,4454686.2773 5791263.507799999,4454686.2591 5791263.560699999,4454686.2575 5791263.598899999,4454686.2878 5791263.6674,4454686.3639 5791263.7619,4454686.512299999 5791263.8,4454686.539599999 5791263.799499999,4454686.6106 5791263.7807,4454686.6379 5791263.784399999,4454686.6535 5791263.798,4454686.666299999 5791263.828999999,4454686.675499999 5791263.895999999,4454686.6856 5791263.9209,4454686.7125 5791263.9416,4454686.7592 5791263.948999999,4454686.8535 5791263.9326)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (298,298,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','7',3.41094997704,0.844979429778,0.671892234982,1.74691981095,1, ST_GeomFromText('MULTIPOLYGON(((4454676.0618 5791263.1293,4454676.094899999 5791263.124199999,4454676.2012 5791263.0877,4454676.325 5791263.0861,4454676.3914 5791263.0677,4454676.4457 5791263.0437,4454676.5323 5791262.994699999,4454676.622299999 5791262.932099999,4454676.6622 5791262.8881,4454676.684799999 5791262.8474,4454676.707999999 5791262.7398,4454676.7164 5791262.665999999,4454676.672 5791262.460799999,4454676.659099999 5791262.414499999,4454676.645999999 5791262.3923,4454676.6162 5791262.3723,4454676.505699999 5791262.351199999,4454676.451899999 5791262.3285,4454676.2553 5791262.2924,4454676.172299999 5791262.2508,4454676.121 5791262.2332,4454676.048299999 5791262.240399999,4454676.0021 5791262.232599999,4454675.879599999 5791262.2375,4454675.8102 5791262.232499999,4454675.7586 5791262.2199,4454675.734699999 5791262.222799999,4454675.716199999 5791262.232699999,4454675.686599999 5791262.269999999,4454675.6781 5791262.305099999,4454675.6122 5791262.4273,4454675.557699999 5791262.5009,4454675.542 5791262.5755,4454675.5602 5791262.647399999,4454675.5932 5791262.854499999,4454675.6365 5791262.9692,4454675.677799999 5791263.013199999,4454675.758799999 5791263.0667,4454675.846099999 5791263.0884,4454675.8662 5791263.1004,4454675.987599999 5791263.124399999,4454676.0618 5791263.1293)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (299,299,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','8',2.86834684441,0.61937941045,0.498992380169,1.29738018844,1, ST_GeomFromText('MULTIPOLYGON(((4454677.370799999 5791263.4888,4454677.424399999 5791263.4945,4454677.479199999 5791263.4863,4454677.545699999 5791263.466499999,4454677.6505 5791263.4208,4454677.866899999 5791263.267,4454677.885499999 5791263.2445,4454677.890399999 5791263.2244,4454677.858099999 5791263.1237,4454677.8332 5791263.085999999,4454677.814399999 5791263.020999999,4454677.781299999 5791262.9701,4454677.7629 5791262.921,4454677.7301 5791262.863099999,4454677.6677 5791262.773499999,4454677.581 5791262.694,4454677.522099999 5791262.667999999,4454677.4867 5791262.6618,4454677.409599999 5791262.676699999,4454677.3036 5791262.679999999,4454677.222099999 5791262.6972,4454677.1287 5791262.730699999,4454677.069099999 5791262.771199999,4454676.95 5791262.9371,4454676.9237 5791262.959,4454676.908599999 5791263.004499999,4454676.8913 5791263.032199999,4454676.8775 5791263.103499999,4454676.887199999 5791263.168199999,4454676.899799999 5791263.210899999,4454676.9199 5791263.2642,4454676.968999999 5791263.3364,4454677.006299999 5791263.3746,4454677.0959 5791263.437,4454677.1445 5791263.456199999,4454677.169499999 5791263.4568,4454677.190899999 5791263.470399999,4454677.226999999 5791263.478399999,4454677.2861 5791263.4868,4454677.319099999 5791263.482499999,4454677.341699999 5791263.493,4454677.370799999 5791263.4888)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (300,300,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','11',3.08759627495,0.726258785361,0.580904733101,1.51035230606,1, ST_GeomFromText('MULTIPOLYGON(((4454685.377 5791264.172399999,4454685.4312 5791264.1743,4454685.5125 5791264.1566,4454685.611299999 5791264.111199999,4454685.683199999 5791264.060399999,4454685.747899999 5791263.9898,4454685.780399999 5791263.9636,4454685.8194 5791263.906999999,4454685.8331 5791263.876099999,4454685.8776 5791263.8284,4454685.8591 5791263.8046,4454685.8474 5791263.7631,4454685.849999999 5791263.7345,4454685.8704 5791263.6903,4454685.8474 5791263.636499999,4454685.8108 5791263.591299999,4454685.753299999 5791263.491699999,4454685.632299999 5791263.388,4454685.5765 5791263.347899999,4454685.501099999 5791263.301999999,4454685.4236 5791263.270899999,4454685.347199999 5791263.2543,4454685.251199999 5791263.2529,4454685.200199999 5791263.241599999,4454685.1578 5791263.2509,4454685.1091 5791263.2518,4454685.059 5791263.282099999,4454685.027099999 5791263.293199999,4454685.000799999 5791263.3144,4454684.9713 5791263.359099999,4454684.886599999 5791263.4572,4454684.854 5791263.526399999,4454684.841 5791263.587999999,4454684.8436 5791263.682199999,4454684.8841 5791263.8373,4454684.943599999 5791263.949699999,4454684.974999999 5791263.9809,4454685.002199999 5791264.021299999,4454685.0482 5791264.0568,4454685.110899999 5791264.1193,4454685.1983 5791264.1607,4454685.3086 5791264.1794,4454685.377 5791264.172399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (301,301,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','33',1.68855555197,0.162891654964,0.149140164364,0.387764427347,1, ST_GeomFromText('MULTIPOLYGON(((4454689.5392 5791264.5884,4454689.642099999 5791264.5173,4454689.727099999 5791264.4272,4454689.747999999 5791264.3913,4454689.8289 5791264.044199999,4454689.7718 5791263.965199999,4454689.7341 5791263.891599999,4454689.5904 5791263.9594,4454689.5498 5791263.9911,4454689.5241 5791264.0295,4454689.4789 5791264.3836,4454689.4752 5791264.4867,4454689.4862 5791264.5623,4454689.5109 5791264.593299999,4454689.5392 5791264.5884)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (302,302,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','9',4.14385379323,1.23074190998,0.967540599809,2.5156055595,1, ST_GeomFromText('MULTIPOLYGON(((4454681.597799999 5791264.066199999,4454681.636699999 5791264.058499999,4454681.7406 5791264.018799999,4454681.9017 5791263.9195,4454681.9324 5791263.8866,4454682.043899999 5791263.8036,4454682.086299999 5791263.758999999,4454682.1524 5791263.643999999,4454682.190799999 5791263.546,4454682.205299999 5791263.524,4454682.24 5791263.354499999,4454682.265899999 5791263.319299999,4454682.233799999 5791263.295099999,4454682.227199999 5791263.2828,4454682.213399999 5791263.14,4454682.146599999 5791262.934599999,4454682.0672 5791262.7419,4454682.0299 5791262.669199999,4454682.004399999 5791262.634899999,4454681.989799999 5791262.598099999,4454681.9609 5791262.5732,4454681.9308 5791262.5643,4454681.838399999 5791262.595599999,4454681.8046 5791262.619799999,4454681.7426 5791262.639499999,4454681.671 5791262.675699999,4454681.5732 5791262.729599999,4454681.516099999 5791262.770999999,4454681.4724 5791262.788499999,4454681.4106 5791262.824599999,4454681.3502 5791262.8749,4454681.2964 5791262.956599999,4454681.223299999 5791263.1171,4454681.189699999 5791263.171099999,4454681.163099999 5791263.307399999,4454681.135999999 5791263.3836,4454681.118599999 5791263.4942,4454681.1228 5791263.539599999,4454681.113499999 5791263.595599999,4454681.121899999 5791263.6303,4454681.122399999 5791263.757799999,4454681.141599999 5791263.818399999,4454681.1879 5791263.8902,4454681.2476 5791263.947899999,4454681.328399999 5791264.008899999,4454681.3629 5791264.023099999,4454681.4128 5791264.058,4454681.568699999 5791264.082599999,4454681.597799999 5791264.066199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (303,303,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','34',2.30512267347,0.337005700156,0.2825811686,0.734711038359,1, ST_GeomFromText('MULTIPOLYGON(((4454689.849899999 5791264.8497,4454689.8868 5791264.834,4454689.931499999 5791264.8001,4454690.1297 5791264.552799999,4454690.1853 5791264.498199999,4454690.2554 5791264.379599999,4454690.278699999 5791264.3101,4454690.301699999 5791264.216,4454690.2942 5791264.1556,4454690.2487 5791264.097699999,4454690.1545 5791264.0296,4454690.098199999 5791264.0032,4454690.007399999 5791263.99,4454689.895499999 5791264.0041,4454689.8289 5791264.044199999,4454689.747999999 5791264.3913,4454689.727099999 5791264.4272,4454689.738699999 5791264.534299999,4454689.7187 5791264.669999999,4454689.724999999 5791264.7883,4454689.7444 5791264.820299999,4454689.7937 5791264.846699999,4454689.849899999 5791264.8497)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (304,304,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','5',4.47920828368,1.40358322542,1.10000618397,2.86001607831,1, ST_GeomFromText('MULTIPOLYGON(((4454670.4066 5791263.3955,4454670.4811 5791263.3734,4454670.6198 5791263.3909,4454670.6923 5791263.4043,4454670.7427 5791263.397099999,4454670.8095 5791263.361999999,4454670.865899999 5791263.302799999,4454671.0005 5791263.114499999,4454671.091799999 5791262.964299999,4454671.239199999 5791262.6665,4454671.3397 5791262.41,4454671.388299999 5791262.225899999,4454671.379099999 5791262.171299999,4454671.3567 5791262.128699999,4454671.256799999 5791262.034499999,4454671.099499999 5791261.990199999,4454670.876299999 5791261.968299999,4454670.7807 5791261.978499999,4454670.697599999 5791261.971599999,4454670.482599999 5791261.998999999,4454670.334699999 5791262.034299999,4454670.2483 5791262.065999999,4454670.2005 5791262.115399999,4454670.1381 5791262.232899999,4454670.076799999 5791262.400599999,4454670.0573 5791262.538399999,4454670.0794 5791262.6578,4454670.104799999 5791262.7006,4454670.120199999 5791262.7607,4454670.2278 5791263.0293,4454670.271099999 5791263.3187,4454670.299899999 5791263.372199999,4454670.358699999 5791263.3921,4454670.4066 5791263.3955)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (305,305,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','10',3.78825505368,1.05083279512,0.829658254179,2.15711146087,1, ST_GeomFromText('MULTIPOLYGON(((4454684.313099999 5791265.0031,4454684.412999999 5791264.9744,4454684.487599999 5791264.9232,4454684.5091 5791264.904799999,4454684.570199999 5791264.807,4454684.6008 5791264.728599999,4454684.628299999 5791264.590099999,4454684.647099999 5791264.546299999,4454684.6392 5791264.479,4454684.6429 5791264.374999999,4454684.6149 5791264.262,4454684.563 5791264.1936,4454684.4307 5791264.092499999,4454684.3732 5791264.058399999,4454684.319299999 5791264.0108,4454684.2823 5791263.994599999,4454684.2648 5791263.977499999,4454684.223399999 5791263.9556,4454684.171699999 5791263.9129,4454684.112099999 5791263.888,4454684.0805 5791263.856499999,4454683.957299999 5791263.7892,4454683.921099999 5791263.7763,4454683.8836 5791263.7716,4454683.8441 5791263.7541,4454683.7604 5791263.7495,4454683.6829 5791263.775299999,4454683.656299999 5791263.808399999,4454683.6073 5791263.842,4454683.557799999 5791263.895899999,4454683.5108 5791263.974199999,4454683.4582 5791264.104599999,4454683.457999999 5791264.1973,4454683.475499999 5791264.295099999,4454683.5053 5791264.3756,4454683.581399999 5791264.527599999,4454683.6194 5791264.580499999,4454683.6276 5791264.6026,4454683.657999999 5791264.633899999,4454683.722099999 5791264.724799999,4454683.855999999 5791264.8363,4454683.8951 5791264.8856,4454683.9638 5791264.9437,4454684.033699999 5791264.974199999,4454684.1287 5791264.982699999,4454684.2138 5791265.0051,4454684.313099999 5791265.0031)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (306,306,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','17',3.61360765738,0.997925089822,0.789109788839,2.05168545098,1, ST_GeomFromText('MULTIPOLYGON(((4454686.100999999 5791259.437699999,4454686.202499999 5791259.6795,4454686.4413 5791259.9163,4454686.665799999 5791260.030999999,4454686.900299999 5791259.9209,4454687.171699999 5791259.652499999,4454687.2054 5791259.3329,4454687.1184 5791259.0116,4454686.945799999 5791258.8527,4454686.5608 5791258.8299,4454686.2757 5791258.9682,4454686.1062 5791259.1721,4454686.100999999 5791259.437699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (307,307,293,'Dön005',5,'Dön','Schlette 1962 Abb.3','Bettstein','Bettstein','16',3.47273352682,0.888105100324,0.704943748888,1.83285374711,1, ST_GeomFromText('MULTIPOLYGON(((4454687.853099999 5791259.094699999,4454687.936599999 5791259.560799999,4454687.9961 5791259.823499999,4454688.100499999 5791259.9285,4454688.290099999 5791259.975999999,4454688.5332 5791259.8585,4454688.877 5791259.4912,4454688.8671 5791259.3131,4454688.649699999 5791258.9089,4454688.496 5791258.815899999,4454688.3557 5791258.7563,4454687.983199999 5791258.879499999,4454687.853099999 5791259.094699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (308,308,294,'Dön007',7,'Dön','Stuhlmann','Deckstein?','Deckstein','NULL',6.87939777842,3.4773840162,2.68936711001,6.99235448603,1, ST_GeomFromText('MULTIPOLYGON(((4454691.412499999 5792411.100199999,4454691.5355 5792411.0337,4454691.6731 5792410.998999999,4454691.7185 5792410.9495,4454691.7926 5792410.7444,4454691.8221 5792410.5172,4454691.824699999 5792410.275,4454691.863599999 5792410.120699999,4454691.8375 5792409.570499999,4454691.7854 5792409.411399999,4454691.608099999 5792409.156999999,4454691.4753 5792409.0269,4454691.292899999 5792408.927799999,4454690.9331 5792408.832599999,4454690.769999999 5792408.8408,4454690.649299999 5792408.876599999,4454690.460099999 5792408.993499999,4454690.338899999 5792409.1085,4454690.235299999 5792409.251099999,4454690.1353 5792409.455,4454690.140399999 5792409.6171,4454690.189299999 5792409.847899999,4454690.167399999 5792410.013299999,4454690.112499999 5792410.213999999,4454690.144199999 5792410.490599999,4454690.140599999 5792410.5776,4454690.2015 5792410.7806,4454690.219999999 5792410.9681,4454690.2657 5792411.028999999,4454690.360899999 5792411.0843,4454690.631799999 5792411.1772,4454690.773 5792411.2071,4454690.8731 5792411.2078,4454691.412499999 5792411.100199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (309,309,295,'Dön008',8,'Dön','Schlette 1962 Abb. 9','Kammerstein','Kammerstein','1',3.50127194418,0.858497535091,0.682252510893,1.77385652832,1, ST_GeomFromText('MULTIPOLYGON(((4454534.023 5791336.0569,4454534.1237 5791336.049799999,4454534.166699999 5791336.042199999,4454534.194199999 5791336.031899999,4454534.234 5791335.9973,4454534.2966 5791335.9096,4454534.330199999 5791335.880499999,4454534.369699999 5791335.838199999,4454534.3843 5791335.8101,4454534.400799999 5791335.758799999,4454534.406799999 5791335.7332,4454534.4153 5791335.659399999,4454534.454599999 5791335.548,4454534.4707 5791335.4854,4454534.482499999 5791335.415699999,4454534.4812 5791335.390599999,4454534.475399999 5791335.367799999,4454534.4685 5791335.355699999,4454534.4565 5791335.3439,4454534.4401 5791335.313899999,4454534.391699999 5791335.2747,4454534.370699999 5791335.265,4454534.3409 5791335.2441,4454534.314199999 5791335.232899999,4454534.223799999 5791335.1839,4454534.1445 5791335.148299999,4454534.0684 5791335.130599999,4454533.922799999 5791335.115399999,4454533.813799999 5791335.093399999,4454533.721199999 5791335.066099999,4454533.6239 5791335.014299999,4454533.613199999 5791335.0129,4454533.5964 5791335.0164,4454533.5756 5791335.0348,4454533.5624 5791335.0614,4454533.5427 5791335.227299999,4454533.535099999 5791335.2695,4454533.519999999 5791335.316199999,4454533.4856 5791335.393699999,4454533.4621 5791335.462799999,4454533.455299999 5791335.497199999,4454533.425699999 5791335.5971,4454533.4056 5791335.7213,4454533.4005 5791335.7948,4454533.406 5791335.839999999,4454533.4194 5791335.902599999,4454533.4494 5791335.967599999,4454533.4779 5791336.0043,4454533.520399999 5791336.036399999,4454533.548 5791336.047499999,4454533.6023 5791336.0536,4454533.676799999 5791336.0435,4454533.729199999 5791336.0425,4454533.9314 5791336.058499999,4454534.023 5791336.0569)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (310,310,295,'Dön008',8,'Dön','Schlette 1962 Abb. 9','Kammerstein','Kammerstein','2',3.73783532022,1.01719581525,0.803878872806,2.09008506929,1, ST_GeomFromText('MULTIPOLYGON(((4454532.108099999 5791336.933199999,4454532.1479 5791336.910099999,4454532.184 5791336.880499999,4454532.2055 5791336.8716,4454532.233199999 5791336.8635,4454532.3128 5791336.856599999,4454532.3704 5791336.845899999,4454532.3913 5791336.831299999,4454532.431499999 5791336.784199999,4454532.473699999 5791336.718599999,4454532.583499999 5791336.4736,4454532.614699999 5791336.3955,4454532.688699999 5791336.1644,4454532.701799999 5791336.084699999,4454532.7038 5791336.036199999,4454532.7094 5791336.001299999,4454532.703999999 5791335.949699999,4454532.6852 5791335.927699999,4454532.6725 5791335.9064,4454532.6231 5791335.8517,4454532.603099999 5791335.835999999,4454532.571999999 5791335.820299999,4454532.471199999 5791335.784399999,4454532.3967 5791335.7763,4454532.3704 5791335.780999999,4454532.326 5791335.796599999,4454532.3112 5791335.807,4454532.2571 5791335.822399999,4454532.1874 5791335.832699999,4454532.0756 5791335.8079,4454531.983799999 5791335.799599999,4454531.951999999 5791335.7992,4454531.8517 5791335.809599999,4454531.780799999 5791335.8156,4454531.753899999 5791335.822,4454531.738199999 5791335.8322,4454531.7125 5791335.867599999,4454531.6567 5791335.9682,4454531.6462 5791335.9956,4454531.614699999 5791336.045299999,4454531.581899999 5791336.1162,4454531.538399999 5791336.2485,4454531.535299999 5791336.278799999,4454531.5414 5791336.3372,4454531.563599999 5791336.451999999,4454531.584099999 5791336.4855,4454531.613199999 5791336.5437,4454531.710699999 5791336.6653,4454531.763299999 5791336.7377,4454531.820899999 5791336.795199999,4454531.900299999 5791336.855399999,4454531.9603 5791336.8924,4454532.0158 5791336.9217,4454532.0301 5791336.9352,4454532.041299999 5791336.935499999,4454532.059799999 5791336.936499999,4454532.108099999 5791336.933199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (311,311,295,'Dön008',8,'Dön','Schlette 1962 Abb. 9','Kammerstein in situ','Kammerstein in situ','4',3.12439007572,0.553934955164,0.448835749638,1.16697294906,1, ST_GeomFromText('MULTIPOLYGON(((4454529.824099999 5791337.0502,4454529.842799999 5791337.0424,4454529.8568 5791337.032299999,4454529.865899999 5791337.021199999,4454529.892799999 5791336.943499999,4454529.911 5791336.911699999,4454529.9274 5791336.8986,4454529.946999999 5791336.889699999,4454530.001299999 5791336.8782,4454530.020499999 5791336.8702,4454530.032899999 5791336.8592,4454530.047399999 5791336.8374,4454530.0614 5791336.810799999,4454530.0749 5791336.7659,4454530.0957 5791336.6499,4454530.1204 5791336.5807,4454530.163499999 5791336.4987,4454530.211299999 5791336.4348,4454530.236899999 5791336.4063,4454530.259499999 5791336.3648,4454530.297699999 5791336.241,4454530.3009 5791336.1972,4454530.314899999 5791336.105599999,4454530.315499999 5791336.034199999,4454530.319299999 5791335.9997,4454530.315999999 5791335.946,4454530.3063 5791335.9284,4454530.2876 5791335.9177,4454530.258299999 5791335.911499999,4454530.202399999 5791335.9087,4454530.1408 5791335.9099,4454530.031299999 5791335.925499999,4454529.9548 5791335.9449,4454529.91 5791335.9605,4454529.8787 5791335.976399999,4454529.8196 5791336.019799999,4454529.8074 5791336.0555,4454529.802799999 5791336.1322,4454529.796 5791336.1588,4454529.781499999 5791336.1849,4454529.757299999 5791336.2509,4454529.740699999 5791336.2825,4454529.695 5791336.388399999,4454529.631799999 5791336.480799999,4454529.601099999 5791336.531899999,4454529.565799999 5791336.5767,4454529.536199999 5791336.625099999,4454529.5299 5791336.655999999,4454529.5383 5791336.7078,4454529.538599999 5791336.728599999,4454529.5146 5791336.807499999,4454529.5148 5791336.8363,4454529.5471 5791336.923599999,4454529.5679 5791336.9503,4454529.5936 5791336.9703,4454529.621299999 5791336.9879,4454529.6582 5791337.005,4454529.695299999 5791337.0302,4454529.762 5791337.0521,4454529.803799999 5791337.054099999,4454529.824099999 5791337.0502)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (312,312,295,'Dön008',8,'Dön','Schlette 1962 Abb. 9','Kammerstein in situ','Kammerstein in situ','5',3.44262099691,0.758370280126,0.605514982689,1.57433895499,1, ST_GeomFromText('MULTIPOLYGON(((4454530.882799999 5791337.266899999,4454530.946999999 5791337.2236,4454530.9719 5791337.211699999,4454531.018099999 5791337.179199999,4454531.1068 5791337.130599999,4454531.1463 5791337.1096,4454531.2159 5791337.0807,4454531.2953 5791337.065799999,4454531.3233 5791337.063799999,4454531.349799999 5791337.0532,4454531.377999999 5791337.024299999,4454531.402099999 5791336.9787,4454531.4351 5791336.9338,4454531.4411 5791336.880599999,4454531.443699999 5791336.777499999,4454531.451399999 5791336.7254,4454531.4521 5791336.717599999,4454531.4483 5791336.7091,4454531.404199999 5791336.663699999,4454531.376199999 5791336.6194,4454531.3382 5791336.573799999,4454531.322599999 5791336.561499999,4454531.2801 5791336.536299999,4454531.233 5791336.5203,4454531.178999999 5791336.506899999,4454531.097599999 5791336.4945,4454530.964399999 5791336.4879,4454530.896499999 5791336.489099999,4454530.805399999 5791336.504799999,4454530.729399999 5791336.537799999,4454530.6708 5791336.552999999,4454530.616299999 5791336.5721,4454530.570799999 5791336.603299999,4454530.547899999 5791336.6117,4454530.4906 5791336.6202,4454530.441599999 5791336.622099999,4454530.373399999 5791336.6303,4454530.341699999 5791336.635399999,4454530.292799999 5791336.6502,4454530.2615 5791336.666699999,4454530.2379 5791336.675499999,4454530.2262 5791336.6838,4454530.186599999 5791336.7234,4454530.1266 5791336.772199999,4454530.104799999 5791336.798599999,4454530.099399999 5791336.8098,4454530.080799999 5791336.857999999,4454530.081699999 5791336.870999999,4454530.1993 5791337.072,4454530.247 5791337.111899999,4454530.2916 5791337.126399999,4454530.3388 5791337.130599999,4454530.423399999 5791337.159199999,4454530.5004 5791337.171199999,4454530.546099999 5791337.1817,4454530.633999999 5791337.2201,4454530.6988 5791337.226199999,4454530.7171 5791337.2342,4454530.7537 5791337.260199999,4454530.800499999 5791337.2781,4454530.8415 5791337.2785,4454530.882799999 5791337.266899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (313,313,295,'Dön008',8,'Dön','Schlette 1962 Abb. 9','Kammerstein in situ','Kammerstein in situ','6',2.62249520271,0.362349829859,0.302004909604,0.78521276497,1, ST_GeomFromText('MULTIPOLYGON(((4454531.987499999 5791337.366599999,4454532.0277 5791337.357999999,4454532.1024 5791337.3284,4454532.1264 5791337.315199999,4454532.207799999 5791337.290799999,4454532.5652 5791337.223999999,4454532.596499999 5791337.209,4454532.616 5791337.1862,4454532.6237 5791337.169099999,4454532.626799999 5791337.1488,4454532.625799999 5791337.115,4454532.6171 5791337.0883,4454532.619199999 5791337.059399999,4454532.616399999 5791336.9777,4454532.591599999 5791336.882899999,4454532.581699999 5791336.8705,4454532.5595 5791336.865,4454532.534799999 5791336.866599999,4454532.426599999 5791336.888599999,4454532.336 5791336.902799999,4454532.2306 5791336.9341,4454532.1468 5791336.9364,4454532.108099999 5791336.933199999,4454532.059799999 5791336.936499999,4454532.041299999 5791336.935499999,4454532.0301 5791336.9352,4454532.018199999 5791336.940199999,4454531.9856 5791336.9438,4454531.9214 5791336.959499999,4454531.7509 5791337.0084,4454531.6912 5791337.033399999,4454531.6632 5791337.0514,4454531.610299999 5791337.075699999,4454531.5718 5791337.100299999,4454531.5573 5791337.1128,4454531.5536 5791337.120699999,4454531.557799999 5791337.134999999,4454531.598699999 5791337.1915,4454531.6129 5791337.2155,4454531.6566 5791337.2704,4454531.678399999 5791337.308599999,4454531.706399999 5791337.3408,4454531.7225 5791337.345799999,4454531.7454 5791337.346699999,4454531.848399999 5791337.343399999,4454531.905299999 5791337.3628,4454531.9493 5791337.369599999,4454531.987499999 5791337.366599999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (314,314,295,'Dön008',8,'Dön','Schlette 1962 Abb. 9','Kammerstein in situ','Kammerstein in situ','3',3.11842941904,0.618949645312,0.498663008167,1.29652382123,1, ST_GeomFromText('MULTIPOLYGON(((4454531.258999999 5791336.0829,4454531.2871 5791336.069599999,4454531.296699999 5791336.060399999,4454531.303299999 5791336.047499999,4454531.309 5791336.0225,4454531.3052 5791335.9999,4454531.302699999 5791335.929999999,4454531.2932 5791335.7935,4454531.266099999 5791335.739399999,4454531.2253 5791335.6578,4454531.148099999 5791335.552799999,4454531.1254 5791335.534299999,4454531.0548 5791335.489499999,4454530.9899 5791335.443499999,4454530.865 5791335.376499999,4454530.775 5791335.3354,4454530.7001 5791335.2714,4454530.674499999 5791335.254799999,4454530.6478 5791335.243599999,4454530.620299999 5791335.239199999,4454530.5893 5791335.238199999,4454530.5689 5791335.240299999,4454530.544999999 5791335.2466,4454530.414099999 5791335.3144,4454530.353199999 5791335.348899999,4454530.330099999 5791335.3649,4454530.294999999 5791335.402799999,4454530.252999999 5791335.4638,4454530.175599999 5791335.580199999,4454530.1676 5791335.6267,4454530.1633 5791335.6753,4454530.162499999 5791335.6937,4454530.165799999 5791335.715199999,4454530.1752 5791335.738199999,4454530.204199999 5791335.7739,4454530.224299999 5791335.790999999,4454530.2434 5791335.8021,4454530.269199999 5791335.812699999,4454530.3234 5791335.827299999,4454530.3731 5791335.8471,4454530.532899999 5791335.898499999,4454530.567099999 5791335.9162,4454530.6977 5791335.962899999,4454530.737599999 5791335.971499999,4454530.770399999 5791335.983699999,4454530.7937 5791335.989199999,4454530.8223 5791336.001199999,4454530.983799999 5791336.042099999,4454531.0926 5791336.0743,4454531.121399999 5791336.0799,4454531.206899999 5791336.0841,4454531.258999999 5791336.0829)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (315,315,298,'Dön011',11,'Dön','Stuhlmann','Bettstein','Bettstein','NULL',2.73800457563,0.51854566515,0.421713397771,1.0964548342,0, ST_GeomFromText('MULTIPOLYGON(((4454682.1973 5790980.6114,4454682.2269 5790980.557499999,4454682.2734 5790980.323999999,4454682.2756 5790980.244599999,4454682.2368 5790980.1095,4454682.2262 5790979.8857,4454682.1551 5790979.695199999,4454682.078099999 5790979.6436,4454681.8797 5790979.624399999,4454681.845099999 5790979.6346,4454681.804899999 5790979.673,4454681.6414 5790979.921299999,4454681.563699999 5790980.135299999,4454681.5579 5790980.2245,4454681.5788 5790980.269799999,4454681.7488 5790980.437499999,4454681.9455 5790980.568099999,4454682.1248 5790980.6359,4454682.1973 5790980.6114)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (316,317,298,'Dön011',11,'Dön','Stuhlmann','Bettstein','Bettstein','NULL',2.57235918244,0.465736214814,0.381240235033,0.991224611087,0, ST_GeomFromText('MULTIPOLYGON(((4454694.273599999 5790984.7148,4454694.328399999 5790984.568499999,4454694.356599999 5790984.4403,4454694.349399999 5790984.3045,4454694.1659 5790984.0576,4454694.089399999 5790983.875199999,4454694.0492 5790983.853399999,4454693.9818 5790983.854499999,4454693.752899999 5790983.948499999,4454693.705699999 5790984.0324,4454693.6906 5790984.297199999,4454693.735799999 5790984.5282,4454693.809899999 5790984.663799999,4454693.9992 5790984.783299999,4454694.147099999 5790984.8087,4454694.273599999 5790984.7148)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (317,318,298,'Dön011',11,'Dön','Stuhlmann','Stein','Stein','NULL',1.04616430623,0.0833679401857,0.0881931893583,0.229302292332,0, ST_GeomFromText('MULTIPOLYGON(((4454694.5551 5790985.5258,4454694.6003 5790985.465399999,4454694.6162 5790985.402699999,4454694.5888 5790985.312899999,4454694.5481 5790985.259299999,4454694.4774 5790985.2366,4454694.395299999 5790985.244699999,4454694.28 5790985.3451,4454694.264999999 5790985.433399999,4454694.3327 5790985.529899999,4454694.416299999 5790985.5521,4454694.5551 5790985.5258)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (318,319,298,'Dön011',11,'Dön','Stuhlmann','Bettstein','Bettstein','NULL',3.20784226972,0.784386080552,0.625453492135,1.62617907955,0, ST_GeomFromText('MULTIPOLYGON(((4454683.375699999 5790985.8307,4454683.4641 5790985.7977,4454683.545199999 5790985.744,4454683.794499999 5790985.4545,4454683.824099999 5790985.3701,4454683.818099999 5790985.177699999,4454683.795699999 5790985.096999999,4454683.746299999 5790985.0512,4454683.582399999 5790984.971599999,4454683.391099999 5790984.9132,4454683.3277 5790984.907199999,4454683.0586 5790984.986099999,4454682.842799999 5790985.143999999,4454682.7947 5790985.2092,4454682.7509 5790985.321499999,4454682.745299999 5790985.530899999,4454682.8068 5790985.7134,4454682.871299999 5790985.760999999,4454683.0277 5790985.8362,4454683.1967 5790985.852299999,4454683.375699999 5790985.8307)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (319,320,298,'Dön011',11,'Dön','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',3.31416102445,0.748523329577,0.597968279788,1.55471752745,0, ST_GeomFromText('MULTIPOLYGON(((4454693.872499999 5790986.207699999,4454693.968399999 5790986.1238,4454694.106499999 5790985.920199999,4454694.171099999 5790985.7478,4454694.1626 5790985.6423,4454694.0415 5790985.492499999,4454693.780899999 5790985.340399999,4454693.4989 5790985.2462,4454693.2164 5790985.181299999,4454693.1834 5790985.2301,4454693.079099999 5790985.311899999,4454693.0492 5790985.408199999,4454693.063599999 5790985.498299999,4454693.2011 5790985.743799999,4454693.648699999 5790986.242399999,4454693.724 5790986.259099999,4454693.872499999 5790986.207699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (320,321,298,'Dön011',11,'Dön','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',4.82519682196,1.69007665508,1.31957474845,3.43089434598,0, ST_GeomFromText('MULTIPOLYGON(((4454691.1072 5790986.9251,4454691.1983 5790986.8394,4454691.3667 5790986.558,4454691.481999999 5790986.317999999,4454691.525 5790986.1861,4454691.598699999 5790986.0776,4454691.657999999 5790985.8493,4454691.563299999 5790985.670099999,4454691.514999999 5790985.5285,4454691.3628 5790985.3835,4454691.138199999 5790985.284099999,4454690.982699999 5790985.3284,4454690.8836 5790985.387299999,4454690.730299999 5790985.5205,4454690.6116 5790985.661399999,4454690.423799999 5790985.7739,4454690.1742 5790986.2255,4454690.143699999 5790986.388,4454690.1675 5790986.4622,4454690.3255 5790986.729299999,4454690.500199999 5790986.8548,4454690.8546 5790986.946,4454691.0097 5790986.957299999,4454691.1072 5790986.9251)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (321,322,298,'Dön011',11,'Dön','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',3.7470655661,0.854741590276,0.679373954788,1.76637228245,0, ST_GeomFromText('MULTIPOLYGON(((4454694.3485 5790987.5109,4454694.6162 5790987.404999999,4454694.6692 5790987.3495,4454694.7322 5790987.2333,4454694.7981 5790986.8965,4454694.8523 5790986.733899999,4454694.9046 5790986.350199999,4454694.8996 5790986.2375,4454694.858099999 5790986.1369,4454694.7647 5790986.047499999,4454694.6983 5790986.024299999,4454694.555399999 5790986.0512,4454694.4044 5790986.155899999,4454694.195 5790986.5065,4454694.1195 5790986.8475,4454694.154799999 5790987.152899999,4454694.148199999 5790987.443199999,4454694.167899999 5790987.495799999,4454694.235 5790987.5227,4454694.3485 5790987.5109)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (322,323,298,'Dön011',11,'Dön','Stuhlmann','Bettstein','Bettstein','NULL',4.01559190195,1.21014966998,0.951758707074,2.47457263839,0, ST_GeomFromText('MULTIPOLYGON(((4454695.8254 5790988.1324,4454695.963 5790988.1028,4454696.081399999 5790988.037699999,4454696.1748 5790987.9647,4454696.268799999 5790987.8529,4454696.386099999 5790987.626099999,4454696.4467 5790987.3353,4454696.442099999 5790987.2418,4454696.389999999 5790987.165899999,4454696.1857 5790987.002199999,4454696.031299999 5790986.9348,4454695.956299999 5790986.937,4454695.6237 5790987.036599999,4454695.490199999 5790987.056099999,4454695.3267 5790987.1653,4454695.1193 5790987.384299999,4454695.0937 5790987.431399999,4454695.1061 5790987.5208,4454695.2652 5790987.8867,4454695.4599 5790988.1557,4454695.545199999 5790988.1873,4454695.8254 5790988.1324)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (323,324,298,'Dön011',11,'Dön','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.94212006023,0.646374895087,0.519681719595,1.35117247095,0, ST_GeomFromText('MULTIPOLYGON(((4454693.3722 5790988.689899999,4454693.5656 5790988.6414,4454693.673 5790988.596799999,4454693.7922 5790988.5263,4454693.8836 5790988.3355,4454693.891699999 5790988.213099999,4454693.8755 5790988.050499999,4454693.8557 5790987.973899999,4454693.815799999 5790987.922,4454693.6199 5790987.8355,4454693.472599999 5790987.830299999,4454693.155799999 5790987.864299999,4454692.951 5790987.959699999,4454692.923799999 5790988.048,4454692.9961 5790988.287299999,4454693.0875 5790988.495699999,4454693.228 5790988.6641,4454693.29 5790988.692399999,4454693.3722 5790988.689899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (324,325,298,'Dön011',11,'Dön','Stuhlmann','Bettstein','Bettstein','NULL',3.60336097099,0.835858339885,0.664901831688,1.72874476239,0, ST_GeomFromText('MULTIPOLYGON(((4454691.3558 5790990.9682,4454691.4835 5790990.928999999,4454691.633999999 5790990.840399999,4454691.8808 5790990.6346,4454692.124699999 5790990.381999999,4454692.2619 5790990.276799999,4454692.2922 5790990.165599999,4454692.2821 5790990.107699999,4454692.254999999 5790990.071799999,4454692.182 5790990.035599999,4454692.025799999 5790990.0028,4454691.6584 5790989.981799999,4454691.4198 5790990.029999999,4454691.2651 5790990.162,4454691.1359 5790990.330399999,4454691.015599999 5790990.5548,4454690.9697 5790990.7334,4454690.991399999 5790990.834799999,4454691.066999999 5790990.929899999,4454691.229199999 5790990.983699999,4454691.3558 5790990.9682)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (325,326,298,'Dön011',11,'Dön','Stuhlmann','Bettstein','Bettstein','NULL',4.7105538757,1.70425748525,1.3304429367,3.45915163541,0, ST_GeomFromText('MULTIPOLYGON(((4454694.4456 5790991.754,4454694.6939 5790991.663,4454694.967199999 5790991.450799999,4454695.104399999 5790991.224199999,4454695.1693 5790991.013499999,4454695.1516 5790990.844399999,4454695.044599999 5790990.574799999,4454694.9647 5790990.452999999,4454694.878499999 5790990.388599999,4454694.6397 5790990.319399999,4454694.4533 5790990.3504,4454694.2241 5790990.4286,4454693.892199999 5790990.6379,4454693.660899999 5790990.851199999,4454693.582899999 5790990.982,4454693.569299999 5790991.0436,4454693.581699999 5790991.204399999,4454693.6145 5790991.3112,4454693.688699999 5790991.458799999,4454693.844399999 5790991.630799999,4454693.9061 5790991.6784,4454694.0009 5790991.715099999,4454694.1933 5790991.757699999,4454694.314799999 5790991.7584,4454694.4456 5790991.754)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (326,327,300,'Dön013',13,'Dön','Stuhlmann','Kammerstein','Kammerstein','NULL',3.04419621564,0.692222034713,0.554818967404,1.44252931525,1, ST_GeomFromText('MULTIPOLYGON(((4454607.7827 5791384.841099999,4454607.7965 5791384.832599999,4454607.905399999 5791384.8376,4454607.9649 5791384.827199999,4454608.0217 5791384.8289,4454608.0997 5791384.800899999,4454608.160799999 5791384.752399999,4454608.1988 5791384.689999999,4454608.255199999 5791384.5096,4454608.272099999 5791384.392699999,4454608.2697 5791384.307099999,4454608.249099999 5791384.167999999,4454608.2279 5791384.104199999,4454608.156999999 5791383.9645,4454608.132399999 5791383.942099999,4454608.0257 5791383.8912,4454607.9659 5791383.8757,4454607.8854 5791383.871999999,4454607.7159 5791383.958399999,4454607.677299999 5791383.9966,4454607.5904 5791384.0379,4454607.532399999 5791384.076799999,4454607.375199999 5791384.190899999,4454607.348799999 5791384.2211,4454607.316399999 5791384.2641,4454607.2993 5791384.3114,4454607.315499999 5791384.3551,4454607.3585 5791384.4032,4454607.3809 5791384.4616,4454607.4298 5791384.5579,4454607.4389 5791384.594499999,4454607.469499999 5791384.645899999,4454607.5065 5791384.696399999,4454607.5383 5791384.737099999,4454607.594499999 5791384.7846,4454607.6654 5791384.821799999,4454607.699 5791384.834699999,4454607.746 5791384.843,4454607.7827 5791384.841099999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (327,328,300,'Dön013',13,'Dön','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',1.25730751209,0.119124804949,0.115597250513,0.300552851333,1, ST_GeomFromText('MULTIPOLYGON(((4454606.473299999 5791384.704099999,4454606.5124 5791384.7058,4454606.538599999 5791384.6863,4454606.5493 5791384.658199999,4454606.5613 5791384.6401,4454606.6013 5791384.551,4454606.591199999 5791384.527799999,4454606.5926 5791384.492499999,4454606.5685 5791384.431399999,4454606.5411 5791384.414799999,4454606.4336 5791384.3714,4454606.3846 5791384.352199999,4454606.338499999 5791384.3516,4454606.3161 5791384.368499999,4454606.2794 5791384.3837,4454606.2483 5791384.41,4454606.201799999 5791384.4603,4454606.183 5791384.506999999,4454606.188799999 5791384.6049,4454606.212399999 5791384.6622,4454606.2416 5791384.685799999,4454606.317699999 5791384.716399999,4454606.473299999 5791384.704099999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (328,329,300,'Dön013',13,'Dön','Stuhlmann','Stein','Stein','NULL',1.31821517958,0.128989545154,0.123157587406,0.320209727256,1, ST_GeomFromText('MULTIPOLYGON(((4454603.832 5791384.326199999,4454603.871799999 5791384.3155,4454603.944799999 5791384.274499999,4454603.970599999 5791384.244799999,4454603.998399999 5791384.197,4454604.001099999 5791384.1816,4454604.012199999 5791384.1524,4454604.019999999 5791384.0665,4454604.012299999 5791384.049,4454603.990399999 5791384.028599999,4454603.988499999 5791383.991399999,4454603.956399999 5791383.965099999,4454603.9353 5791383.9264,4454603.9154 5791383.912,4454603.8536 5791383.884299999,4454603.828099999 5791383.878399999,4454603.810999999 5791383.880999999,4454603.668499999 5791383.985099999,4454603.649299999 5791384.028899999,4454603.638 5791384.0752,4454603.636599999 5791384.1228,4454603.639999999 5791384.1541,4454603.648 5791384.174499999,4454603.6524 5791384.2036,4454603.680999999 5791384.253,4454603.7038 5791384.2671,4454603.7126 5791384.2769,4454603.718299999 5791384.291099999,4454603.717899999 5791384.3153,4454603.7564 5791384.3342,4454603.832 5791384.326199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (329,330,300,'Dön013',13,'Dön','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',1.54597538353,0.184484795007,0.165689146894,0.430791781923,1, ST_GeomFromText('MULTIPOLYGON(((4454606.823499999 5791384.951199999,4454606.858099999 5791384.944,4454606.918399999 5791384.9122,4454606.9616 5791384.879899999,4454606.9758 5791384.8603,4454606.995799999 5791384.844299999,4454607.033599999 5791384.7923,4454607.0634 5791384.715399999,4454607.071399999 5791384.641499999,4454607.051599999 5791384.598999999,4454607.047799999 5791384.5756,4454607.0305 5791384.544199999,4454607.001299999 5791384.5272,4454606.970099999 5791384.5186,4454606.940399999 5791384.496099999,4454606.8234 5791384.4546,4454606.7855 5791384.452999999,4454606.768099999 5791384.4567,4454606.713299999 5791384.4833,4454606.706899999 5791384.493699999,4454606.6748 5791384.507899999,4454606.662299999 5791384.521299999,4454606.653099999 5791384.539699999,4454606.6151 5791384.602199999,4454606.593999999 5791384.652799999,4454606.580699999 5791384.7213,4454606.581699999 5791384.7791,4454606.591599999 5791384.8232,4454606.609899999 5791384.856899999,4454606.630099999 5791384.8812,4454606.6764 5791384.910299999,4454606.744099999 5791384.944099999,4454606.823499999 5791384.951199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (330,331,300,'Dön013',13,'Dön','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',3.48878706531,0.844355744803,0.671414242817,1.74567703133,1, ST_GeomFromText('MULTIPOLYGON(((4454609.563699999 5791386.991,4454609.691499999 5791386.948699999,4454609.8365 5791386.8836,4454610.1802 5791386.643999999,4454610.2026 5791386.6323,4454610.280799999 5791386.535499999,4454610.306699999 5791386.5138,4454610.3179 5791386.492799999,4454610.336699999 5791386.441199999,4454610.337799999 5791386.393999999,4454610.296299999 5791386.220799999,4454610.2796 5791386.1864,4454610.2712 5791386.146999999,4454610.243099999 5791386.0799,4454610.192599999 5791385.9885,4454610.121399999 5791385.887399999,4454610.0409 5791385.7979,4454609.9939 5791385.769799999,4454609.910899999 5791385.7322,4454609.851099999 5791385.740399999,4454609.718899999 5791385.790899999,4454609.6348 5791385.8803,4454609.597799999 5791385.9395,4454609.4992 5791386.1916,4454609.4802 5791386.213099999,4454609.4187 5791386.4056,4454609.317999999 5791386.6543,4454609.3013 5791386.759099999,4454609.3101 5791386.793199999,4454609.3239 5791386.8109,4454609.3727 5791386.8846,4454609.458499999 5791386.9624,4454609.4922 5791386.981599999,4454609.563699999 5791386.991)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (331,332,300,'Dön013',13,'Dön','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.53360372299,0.450606319669,0.369644683395,0.961076176826,1, ST_GeomFromText('MULTIPOLYGON(((4454606.821899999 5791386.815799999,4454606.853299999 5791386.807299999,4454606.910199999 5791386.765499999,4454606.972799999 5791386.6728,4454606.9989 5791386.6303,4454607.0299 5791386.5357,4454607.0493 5791386.500399999,4454607.060499999 5791386.4008,4454607.0563 5791386.360799999,4454607.0427 5791386.3241,4454607.039699999 5791386.2937,4454607.015999999 5791386.281899999,4454606.996899999 5791386.261199999,4454606.9165 5791386.2277,4454606.8304 5791386.202999999,4454606.796 5791386.1862,4454606.780299999 5791386.168999999,4454606.740799999 5791386.1644,4454606.558 5791386.105,4454606.534799999 5791386.1038,4454606.515599999 5791386.1126,4454606.4594 5791386.093299999,4454606.382199999 5791386.1015,4454606.336299999 5791386.1158,4454606.2986 5791386.1513,4454606.209499999 5791386.356899999,4454606.182 5791386.451899999,4454606.1792 5791386.504,4454606.192599999 5791386.547299999,4454606.217 5791386.571399999,4454606.2997 5791386.612999999,4454606.535199999 5791386.706599999,4454606.6605 5791386.7685,4454606.728099999 5791386.7912,4454606.739699999 5791386.803999999,4454606.794599999 5791386.816199999,4454606.821899999 5791386.815799999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (332,333,300,'Dön013',13,'Dön','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',3.30668569588,0.706057674727,0.565422601911,1.47009876497,1, ST_GeomFromText('MULTIPOLYGON(((4454608.033599999 5791387.1915,4454608.107099999 5791387.161199999,4454608.1545 5791387.125299999,4454608.1704 5791387.106499999,4454608.1951 5791387.063699999,4454608.217199999 5791387.0064,4454608.226099999 5791386.987999999,4454608.241799999 5791386.9065,4454608.289499999 5791386.773499999,4454608.2866 5791386.728599999,4454608.258399999 5791386.699799999,4454608.223399999 5791386.6753,4454608.170699999 5791386.6508,4454608.1014 5791386.6191,4454608.063299999 5791386.608699999,4454608.0086 5791386.5886,4454607.972099999 5791386.5733,4454607.9505 5791386.550799999,4454607.8287 5791386.491499999,4454607.802299999 5791386.46,4454607.6929 5791386.4407,4454607.3717 5791386.3394,4454607.310399999 5791386.331399999,4454607.2596 5791386.3418,4454607.183 5791386.394899999,4454607.1484 5791386.443199999,4454607.118099999 5791386.508799999,4454607.0766 5791386.605599999,4454607.062199999 5791386.686699999,4454607.0552 5791386.7213,4454607.0541 5791386.757799999,4454607.0738 5791386.819,4454607.1299 5791386.872099999,4454607.341099999 5791386.9813,4454607.502899999 5791387.0435,4454607.5272 5791387.078299999,4454607.552099999 5791387.084799999,4454607.575699999 5791387.079399999,4454607.594899999 5791387.0844,4454607.647599999 5791387.1183,4454607.686099999 5791387.1193,4454607.751 5791387.1565,4454607.8031 5791387.1662,4454607.8446 5791387.191999999,4454607.911999999 5791387.206399999,4454608.033599999 5791387.1915)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (333,334,301,'Dön014',14,'Dön','Stuhlmann','Stein','Stein','NULL',4.03391745562,1.26734221447,0.995591073168,2.58853679024,1, ST_GeomFromText('MULTIPOLYGON(((4454257.7093 5790519.242699999,4454257.780799999 5790519.197699999,4454257.8546 5790519.1433,4454257.972099999 5790519.0028,4454258.103799999 5790518.743,4454258.1172 5790518.6212,4454258.035799999 5790518.3626,4454258.0031 5790518.2979,4454257.8826 5790518.1499,4454257.7784 5790518.061599999,4454257.6429 5790517.9855,4454257.502399999 5790517.9331,4454257.391699999 5790517.907199999,4454257.3304 5790517.9096,4454257.118599999 5790518.028,4454256.999099999 5790518.140699999,4454256.902999999 5790518.2607,4454256.8331 5790518.491399999,4454256.831899999 5790518.6159,4454256.8496 5790518.693099999,4454256.904 5790518.797,4454257.1232 5790519.079199999,4454257.271999999 5790519.177799999,4454257.3524 5790519.213999999,4454257.586799999 5790519.260199999,4454257.7093 5790519.242699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (334,335,301,'Dön014',14,'Dön','Stuhlmann','Stein','Stein','NULL',5.05868449125,1.87294893468,1.45972806354,3.7952929652,1, ST_GeomFromText('MULTIPOLYGON(((4454266.992499999 5790522.641799999,4454267.064899999 5790522.618,4454267.102099999 5790522.5842,4454267.257 5790522.332599999,4454267.5959 5790521.624999999,4454267.643199999 5790521.4875,4454267.6425 5790521.413399999,4454267.592 5790521.2321,4454267.5251 5790521.159299999,4454267.4561 5790521.1158,4454267.171799999 5790521.021199999,4454266.8775 5790521.019999999,4454266.7198 5790521.0581,4454266.4977 5790521.1443,4454266.1642 5790521.3208,4454266.097 5790521.420099999,4454266.063599999 5790521.544199999,4454266.0656 5790521.622199999,4454266.143699999 5790521.959499999,4454266.302199999 5790522.2311,4454266.406899999 5790522.4613,4454266.4778 5790522.544399999,4454266.583899999 5790522.6203,4454266.7076 5790522.6513,4454266.992499999 5790522.641799999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (335,336,301,'Dön014',14,'Dön','Stuhlmann','Stein','Stein','NULL',4.52320498307,1.57677826009,1.23274285853,3.20513143219,1, ST_GeomFromText('MULTIPOLYGON(((4454267.9856 5790524.885299999,4454268.194699999 5790524.7748,4454268.4763 5790524.4777,4454268.545699999 5790524.325799999,4454268.5426 5790524.1709,4454268.5721 5790523.983899999,4454268.4971 5790523.720599999,4454268.4347 5790523.6454,4454268.350999999 5790523.585599999,4454268.006199999 5790523.4725,4454267.865199999 5790523.4776,4454267.735799999 5790523.5131,4454267.4391 5790523.659099999,4454267.288499999 5790523.827199999,4454267.1994 5790524.0547,4454267.2033 5790524.230599999,4454267.1732 5790524.4262,4454267.1994 5790524.6048,4454267.2362 5790524.6808,4454267.294499999 5790524.752699999,4454267.354899999 5790524.787599999,4454267.654299999 5790524.8976,4454267.7548 5790524.907299999,4454267.9856 5790524.885299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (336,337,301,'Dön014',14,'Dön','Stuhlmann','Stein','Stein','NULL',4.62174006977,1.57993654537,1.23516336837,3.21142475776,1, ST_GeomFromText('MULTIPOLYGON(((4454270.0129 5790532.1519,4454270.1402 5790532.0844,4454270.2077 5790532.0139,4454270.3267 5790531.8153,4454270.361499999 5790531.662399999,4454270.3447 5790531.6191,4454270.2708 5790531.548699999,4454270.103099999 5790531.3004,4454269.923299999 5790531.088899999,4454269.864199999 5790531.0403,4454269.677699999 5790530.9527,4454269.592 5790530.932099999,4454269.383899999 5790530.9624,4454269.1644 5790531.034099999,4454269.016699999 5790531.107599999,4454268.8101 5790531.260199999,4454268.7114 5790531.3635,4454268.6549 5790531.516799999,4454268.677799999 5790531.689699999,4454268.7258 5790531.809299999,4454268.838 5790531.9129,4454269.1162 5790532.039599999,4454269.2723 5790532.146999999,4454269.544599999 5790532.2287,4454269.873599999 5790532.233599999,4454270.0129 5790532.1519)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (337,338,307,'NHa009',9,'NHa','Stuhlmann','Stein','Stein','NULL',3.60773422889,0.940565285087,0.74514923449,1.93738800967,1, ST_GeomFromText('MULTIPOLYGON(((4457038.701999999 5795605.158999999,4457038.7608 5795605.115499999,4457038.841099999 5795605.0159,4457038.8892 5795604.9337,4457038.906899999 5795604.847699999,4457038.900399999 5795604.779799999,4457038.853699999 5795604.6633,4457038.762699999 5795604.532899999,4457038.520899999 5795604.2869,4457038.348699999 5795604.1642,4457038.268299999 5795604.1293,4457038.097 5795604.0887,4457037.931099999 5795604.084799999,4457037.849499999 5795604.112299999,4457037.772199999 5795604.1743,4457037.6812 5795604.3035,4457037.685899999 5795604.4338,4457037.786399999 5795604.674599999,4457038.010499999 5795605.016,4457038.114099999 5795605.0874,4457038.4029 5795605.1983,4457038.533999999 5795605.208799999,4457038.701999999 5795605.158999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (338,339,307,'NHa009',9,'NHa','Stuhlmann','Stein','Stein','NULL',3.93992854651,1.01208668967,0.799963238962,2.0799044213,1, ST_GeomFromText('MULTIPOLYGON(((4457036.285299999 5795606.933499999,4457036.5454 5795606.720799999,4457036.740699999 5795606.513199999,4457036.8327 5795606.286699999,4457036.888399999 5795606.049499999,4457036.8967 5795605.986099999,4457036.875699999 5795605.794299999,4457036.844899999 5795605.727399999,4457036.802099999 5795605.658999999,4457036.706799999 5795605.561799999,4457036.576799999 5795605.4908,4457036.415 5795605.489399999,4457036.268 5795605.5393,4457036.122999999 5795605.746999999,4457036.0569 5795605.936899999,4457036.004999999 5795606.2562,4457036.015999999 5795606.401499999,4457035.9566 5795606.601299999,4457035.923399999 5795606.7639,4457035.923 5795606.845399999,4457035.973 5795606.9407,4457036.0716 5795606.981499999,4457036.171699999 5795606.983999999,4457036.285299999 5795606.933499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (339,340,307,'NHa009',9,'NHa','Stuhlmann','Stein','Stein','NULL',3.79524757156,1.02321790557,0.808494202827,2.10208492735,1, ST_GeomFromText('MULTIPOLYGON(((4457040.3585 5795609.445199999,4457040.468999999 5795609.417099999,4457040.678299999 5795609.2803,4457040.888899999 5795609.0939,4457041.0969 5795608.9787,4457041.2022 5795608.831199999,4457041.213299999 5795608.661399999,4457041.195899999 5795608.559399999,4457041.163599999 5795608.512499999,4457041.0151 5795608.388399999,4457040.832 5795608.3395,4457040.6369 5795608.358999999,4457040.3956 5795608.435599999,4457040.2609 5795608.489399999,4457040.0849 5795608.6204,4457039.9889 5795608.757099999,4457039.9274 5795608.8978,4457039.9018 5795609.0247,4457039.915199999 5795609.2178,4457039.966599999 5795609.3463,4457040.0241 5795609.3999,4457040.163499999 5795609.4495,4457040.3585 5795609.445199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (340,341,307,'NHa009',9,'NHa','Stuhlmann','Stein','Stein','NULL',3.26537299921,0.81667535032,0.650199988486,1.69051997006,1, ST_GeomFromText('MULTIPOLYGON(((4457036.9215 5795610.0262,4457037.023199999 5795609.9857,4457037.0888 5795609.9371,4457037.2082 5795609.7796,4457037.2456 5795609.6564,4457037.2516 5795609.582699999,4457037.247899999 5795609.4909,4457037.216599999 5795609.3833,4457037.204599999 5795609.1939,4457037.1572 5795609.1336,4457037.013 5795609.077099999,4457036.805499999 5795609.028,4457036.6501 5795609.046399999,4457036.4937 5795609.122999999,4457036.423899999 5795609.2034,4457036.353099999 5795609.3398,4457036.315899999 5795609.437,4457036.277499999 5795609.6162,4457036.275 5795609.742499999,4457036.295199999 5795609.864099999,4457036.340499999 5795609.9546,4457036.467899999 5795610.0326,4457036.724299999 5795610.0568,4457036.9215 5795610.0262)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (341,342,307,'NHa009',9,'NHa','Stuhlmann','Stein','Stein','NULL',3.66648961732,0.995420375437,0.787190175735,2.04669445691,1, ST_GeomFromText('MULTIPOLYGON(((4457043.1638 5795614.7138,4457043.2728 5795614.6676,4457043.3754 5795614.592499999,4457043.626299999 5795614.1829,4457043.6535 5795613.999199999,4457043.6396 5795613.893699999,4457043.497 5795613.724199999,4457043.3898 5795613.64,4457043.2993 5795613.602399999,4457043.1675 5795613.5874,4457043.073099999 5795613.604299999,4457042.9538 5795613.6597,4457042.814899999 5795613.7528,4457042.549599999 5795614.070699999,4457042.4094 5795614.388599999,4457042.429999999 5795614.5074,4457042.5355 5795614.596499999,4457042.973299999 5795614.7191,4457043.1638 5795614.7138)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (342,343,308,'NHa010',10,'NHa','Stuhlmann','Stein','Stein','NULL',3.13228156152,0.596295445626,0.481300829528,1.25138215677,1, ST_GeomFromText('MULTIPOLYGON(((4457321.290099999 5795674.3702,4457321.3962 5795674.2331,4457321.4241 5795674.1563,4457321.453099999 5795673.732499999,4457321.4281 5795673.663899999,4457321.3699 5795673.580499999,4457321.1911 5795673.4087,4457321.1359 5795673.3771,4457321.006 5795673.385099999,4457320.8919 5795673.436499999,4457320.742899999 5795673.542199999,4457320.705299999 5795673.5884,4457320.7012 5795673.628799999,4457320.8041 5795673.8571,4457320.862599999 5795673.934,4457320.8865 5795674.026,4457320.893299999 5795674.1236,4457320.855299999 5795674.489199999,4457320.890999999 5795674.550599999,4457320.9499 5795674.560399999,4457321.290099999 5795674.3702)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (343,344,308,'NHa010',10,'NHa','Stuhlmann','Stein','Stein','NULL',2.9996214533,0.631783529867,0.50849889729,1.32209713295,1, ST_GeomFromText('MULTIPOLYGON(((4457337.7274 5795674.732899999,4457338.069899999 5795674.628299999,4457338.366499999 5795674.473799999,4457338.450199999 5795674.400399999,4457338.5021 5795674.3223,4457338.507 5795674.1851,4457338.463999999 5795674.046099999,4457338.371899999 5795673.937599999,4457338.2499 5795673.879899999,4457338.1496 5795673.8749,4457337.8266 5795673.9798,4457337.750199999 5795674.027799999,4457337.664599999 5795674.097799999,4457337.5537 5795674.239499999,4457337.4242 5795674.487199999,4457337.427199999 5795674.5416,4457337.505599999 5795674.660099999,4457337.627799999 5795674.7387,4457337.7274 5795674.732899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (344,345,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.95324393195,0.293458189904,0.249206356742,0.64793652753,0, ST_GeomFromText('MULTIPOLYGON(((4456889.399699999 5793444.849899999,4456889.569199999 5793444.635199999,4456889.594299999 5793444.538,4456889.5718 5793444.4581,4456889.495099999 5793444.3695,4456889.355999999 5793444.288,4456889.2274 5793444.2793,4456889.0749 5793444.322599999,4456888.9945 5793444.407299999,4456888.955699999 5793444.5457,4456888.961799999 5793444.619,4456889.013199999 5793444.7367,4456889.0968 5793444.8342,4456889.2198 5793444.9065,4456889.309299999 5793444.9078,4456889.399699999 5793444.849899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (345,346,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',2.03931530081,0.317547269942,0.267668227684,0.695937391977,0, ST_GeomFromText('MULTIPOLYGON(((4456890.5673 5793444.969299999,4456890.668499999 5793444.9187,4456890.763399999 5793444.809399999,4456890.7883 5793444.639,4456890.775999999 5793444.5029,4456890.7186 5793444.3902,4456890.6309 5793444.3176,4456890.569199999 5793444.3026,4456890.3024 5793444.360899999,4456890.2263 5793444.401499999,4456890.172399999 5793444.475199999,4456890.1776 5793444.6015,4456890.2251 5793444.746099999,4456890.310399999 5793444.8593,4456890.3846 5793444.934,4456890.471099999 5793444.9757,4456890.5673 5793444.969299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (346,347,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.8284748487,0.221759915097,0.19425679893,0.505067677219,0, ST_GeomFromText('MULTIPOLYGON(((4456890.6017 5793446.9175,4456890.6288 5793446.841099999,4456890.5902 5793446.717,4456890.5614 5793446.3804,4456890.518899999 5793446.2934,4456890.439199999 5793446.275299999,4456890.3435 5793446.333599999,4456890.239099999 5793446.456499999,4456890.212199999 5793446.561599999,4456890.200799999 5793446.7813,4456890.28 5793446.901699999,4456890.3914 5793446.969299999,4456890.493499999 5793446.975099999,4456890.6017 5793446.9175)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (347,348,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',2.38881024842,0.426500539996,0.351170013853,0.913042036017,0, ST_GeomFromText('MULTIPOLYGON(((4456889.294099999 5793447.0041,4456889.419499999 5793446.9133,4456889.565 5793446.671299999,4456889.6139 5793446.5076,4456889.6156 5793446.3988,4456889.577999999 5793446.306299999,4456889.493499999 5793446.2034,4456889.3638 5793446.139599999,4456889.2866 5793446.134099999,4456889.111899999 5793446.2157,4456888.9686 5793446.366,4456888.9407 5793446.443199999,4456888.9435 5793446.5786,4456888.9868 5793446.722899999,4456889.0958 5793446.9063,4456889.171699999 5793446.9821,4456889.2339 5793447.008099999,4456889.294099999 5793447.0041)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (348,349,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.91093230942,0.26050608962,0.223951867085,0.58227485442,0, ST_GeomFromText('MULTIPOLYGON(((4456889.880199999 5793449.374199999,4456890.177 5793449.195499999,4456890.253299999 5793449.104399999,4456890.2768 5793449.0314,4456890.2335 5793448.961999999,4456890.048999999 5793448.866299999,4456889.9013 5793448.856,4456889.749999999 5793448.8965,4456889.6557 5793448.9591,4456889.6183 5793449.0218,4456889.604799999 5793449.239299999,4456889.622 5793449.3223,4456889.6638 5793449.369899999,4456889.723699999 5793449.3942,4456889.880199999 5793449.374199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (349,350,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.52914936451,0.162256784891,0.148653599941,0.386499359846,0, ST_GeomFromText('MULTIPOLYGON(((4456891.4116 5793449.389699999,4456891.4791 5793449.3441,4456891.5772 5793449.2353,4456891.570199999 5793449.168299999,4456891.499699999 5793449.068099999,4456891.435999999 5793449.0348,4456891.348699999 5793449.0324,4456891.103099999 5793449.1173,4456890.996299999 5793449.216,4456890.983599999 5793449.301999999,4456891.022199999 5793449.3373,4456891.224999999 5793449.419099999,4456891.4116 5793449.389699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (350,351,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',2.41076959705,0.435844169884,0.358330971799,0.931660526678,0, ST_GeomFromText('MULTIPOLYGON(((4456895.2756 5793450.8322,4456895.3656 5793450.741499999,4456895.469299999 5793450.5712,4456895.493499999 5793450.4198,4456895.4791 5793450.3109,4456895.375799999 5793450.1576,4456895.3096 5793450.1236,4456895.0426 5793450.0921,4456894.837199999 5793450.1302,4456894.7614 5793450.167799999,4456894.7213 5793450.2407,4456894.710699999 5793450.387499999,4456894.7581 5793450.4974,4456894.882899999 5793450.6729,4456895.062699999 5793450.7793,4456895.229799999 5793450.840399999,4456895.2756 5793450.8322)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (351,352,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.1615447943,0.0961228300063,0.0979685369169,0.254718195984,0, ST_GeomFromText('MULTIPOLYGON(((4456893.568599999 5793451.2276,4456893.656299999 5793451.1585,4456893.779799999 5793451.057399999,4456893.7982 5793451.022299999,4456893.7691 5793450.9076,4456893.7043 5793450.8669,4456893.616999999 5793450.8749,4456893.506099999 5793450.9243,4456893.4428 5793450.976099999,4456893.4082 5793451.047399999,4456893.4341 5793451.1578,4456893.4934 5793451.2343,4456893.568599999 5793451.2276)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (352,353,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',3.65358747153,0.873327739929,0.693618379882,1.80340778769,0, ST_GeomFromText('MULTIPOLYGON(((4456891.5339 5793451.3473,4456891.7054 5793451.2748,4456891.766499999 5793451.229199999,4456891.847 5793451.1093,4456891.958399999 5793450.729399999,4456892.063099999 5793450.4944,4456892.070799999 5793450.299599999,4456892.0405 5793450.1454,4456891.993499999 5793450.0336,4456891.9605 5793449.9989,4456891.756699999 5793449.9656,4456891.6797 5793450.011499999,4456891.523 5793450.184,4456891.4544 5793450.3077,4456891.286 5793450.5053,4456891.184399999 5793450.671099999,4456891.113699999 5793450.8947,4456891.1918 5793451.187999999,4456891.312599999 5793451.3242,4456891.372999999 5793451.352099999,4456891.5339 5793451.3473)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (353,354,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.02331064514,0.0774557400901,0.0836620792051,0.217521405933,0, ST_GeomFromText('MULTIPOLYGON(((4456892.8919 5793451.793899999,4456893.0164 5793451.6991,4456893.035699999 5793451.536399999,4456892.994699999 5793451.4624,4456892.9367 5793451.446799999,4456892.8667 5793451.466399999,4456892.7626 5793451.5401,4456892.7394 5793451.6585,4456892.7593 5793451.73,4456892.797199999 5793451.7805,4456892.8393 5793451.8013,4456892.8919 5793451.793899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (354,355,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.18727362947,0.102372850109,0.102758552323,0.267172236041,0, ST_GeomFromText('MULTIPOLYGON(((4456895.2231 5793452.194,4456895.2538 5793452.001299999,4456895.1588 5793451.876299999,4456895.097099999 5793451.855499999,4456895.0267 5793451.8726,4456894.976499999 5793451.9232,4456894.9429 5793452.008999999,4456894.956699999 5793452.2072,4456894.998599999 5793452.2781,4456895.105 5793452.280999999,4456895.2231 5793452.194)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (355,356,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.95543863475,0.252535504862,0.217843210927,0.566392348409,0, ST_GeomFromText('MULTIPOLYGON(((4456898.562699999 5793452.332,4456898.576299999 5793452.271099999,4456898.547199999 5793452.0219,4456898.509999999 5793451.7956,4456898.448699999 5793451.710699999,4456898.3863 5793451.6839,4456898.3069 5793451.689799999,4456898.195199999 5793451.7554,4456898.133799999 5793452.0711,4456898.228099999 5793452.4153,4456898.3645 5793452.418099999,4456898.562699999 5793452.332)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (356,357,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.36862753426,0.141444809893,0.132703302302,0.345028585985,0, ST_GeomFromText('MULTIPOLYGON(((4456901.5739 5793452.397299999,4456901.672399999 5793452.225999999,4456901.6654 5793452.1498,4456901.622399999 5793452.064999999,4456901.475599999 5793451.992499999,4456901.3457 5793452.041699999,4456901.270999999 5793452.1248,4456901.247 5793452.193099999,4456901.292 5793452.392799999,4456901.4062 5793452.4557,4456901.5739 5793452.397299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (357,358,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',0.75575985277,0.0413323350316,0.0559771015682,0.145540464077,0, ST_GeomFromText('MULTIPOLYGON(((4456913.7684 5793452.5788,4456913.7866 5793452.5337,4456913.7624 5793452.479199999,4456913.7017 5793452.4305,4456913.6193 5793452.4141,4456913.5136 5793452.4835,4456913.502999999 5793452.515499999,4456913.5115 5793452.5543,4456913.5491 5793452.5962,4456913.6567 5793452.6204,4456913.7684 5793452.5788)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (358,359,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.98344011005,0.293486454638,0.249228018834,0.647992848969,0, ST_GeomFromText('MULTIPOLYGON(((4456899.3704 5793452.639699999,4456899.455699999 5793452.5832,4456899.5464 5793452.448499999,4456899.559899999 5793452.377499999,4456899.534699999 5793452.2848,4456899.326399999 5793452.013199999,4456899.262799999 5793451.9714,4456899.1851 5793451.9579,4456899.108199999 5793451.9735,4456899.0584 5793452.008999999,4456899.0179 5793452.0828,4456898.955599999 5793452.322899999,4456899.018 5793452.459,4456899.120799999 5793452.595799999,4456899.215699999 5793452.6424,4456899.3704 5793452.639699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (359,360,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',2.22348672349,0.332187110348,0.278888201371,0.725109323564,0, ST_GeomFromText('MULTIPOLYGON(((4456892.5475 5793452.809699999,4456892.635099999 5793452.7572,4456892.651499999 5793452.695699999,4456892.575899999 5793452.531899999,4456892.459999999 5793452.4232,4456892.379499999 5793452.3275,4456892.3042 5793452.2806,4456892.211 5793452.266499999,4456892.1227 5793452.277699999,4456891.971199999 5793452.363199999,4456891.887 5793452.46,4456891.817699999 5793452.468499999,4456891.818199999 5793452.628799999,4456891.840599999 5793452.659099999,4456891.935999999 5793452.6961,4456892.0032 5793452.7529,4456892.177199999 5793452.8154,4456892.382199999 5793452.8449,4456892.5475 5793452.809699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (360,361,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.12949216228,0.0945485051931,0.09676197438,0.251581133388,0, ST_GeomFromText('MULTIPOLYGON(((4456893.2734 5793452.8791,4456893.343299999 5793452.8493,4456893.413099999 5793452.773199999,4456893.4248 5793452.605599999,4456893.3579 5793452.504799999,4456893.226999999 5793452.4999,4456893.168899999 5793452.5295,4456893.123499999 5793452.5872,4456893.133999999 5793452.784299999,4456893.161999999 5793452.853199999,4456893.1979 5793452.8793,4456893.2734 5793452.8791)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (361,362,318,'AHa015',15,'AHa','Stuhlmann','Gang','Gang','NULL',2.01427819636,0.304050519775,0.257324318356,0.669043227725,0, ST_GeomFromText('MULTIPOLYGON(((4456907.451999999 5793453.0526,4456907.5126 5793452.979399999,4456907.551799999 5793452.898399999,4456907.566399999 5793452.6818,4456907.5053 5793452.570399999,4456907.4565 5793452.546,4456907.227599999 5793452.508799999,4456907.132199999 5793452.518699999,4456906.991999999 5793452.5611,4456906.9581 5793452.6173,4456906.9537 5793452.833,4456906.979199999 5793453.0086,4456907.037999999 5793453.061,4456907.227699999 5793453.087999999,4456907.451999999 5793453.0526)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (362,363,318,'AHa015',15,'AHa','Stuhlmann','Bettstein in situ','Bettstein in situ','NULL',3.25868521446,0.782408184996,0.623937632981,1.62223784575,0, ST_GeomFromText('MULTIPOLYGON(((4456904.3799 5793453.1204,4456904.496399999 5793453.026399999,4456904.5811 5793452.8485,4456904.5842 5793452.652899999,4456904.5316 5793452.448699999,4456904.4175 5793452.359699999,4456904.254999999 5793452.2894,4456904.1648 5793452.1717,4456904.045099999 5793452.096899999,4456903.8349 5793452.1106,4456903.664699999 5793452.2148,4456903.596499999 5793452.310399999,4456903.565399999 5793452.5598,4456903.6424 5793452.778599999,4456903.8173 5793453.004699999,4456903.9296 5793453.079299999,4456904.124699999 5793453.083699999,4456904.269899999 5793453.1401,4456904.3799 5793453.1204)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (363,364,318,'AHa015',15,'AHa','Stuhlmann','Bettstein in situ','Bettstein','NULL',2.92908724876,0.585563444975,0.473075824229,1.229997143,0, ST_GeomFromText('MULTIPOLYGON(((4456905.443099999 5793453.47,4456905.560399999 5793453.4238,4456905.6567 5793453.3593,4456905.712199999 5793453.24,4456905.6823 5793453.154799999,4456905.599499999 5793453.068099999,4456905.4455 5793452.8333,4456905.3766 5793452.795399999,4456905.2922 5793452.7813,4456904.984799999 5793452.7871,4456904.8369 5793452.8276,4456904.764999999 5793452.8833,4456904.619599999 5793453.186,4456904.605 5793453.289799999,4456904.629499999 5793453.3453,4456904.716099999 5793453.377,4456904.923999999 5793453.379599999,4456905.109799999 5793453.480499999,4456905.3452 5793453.4909,4456905.443099999 5793453.47)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (364,365,318,'AHa015',15,'AHa','Stuhlmann','Bettstein','Bettstein','NULL',2.44914574465,0.427585334956,0.352001400711,0.915203641847,0, ST_GeomFromText('MULTIPOLYGON(((4456902.831699999 5793453.158999999,4456902.8398 5793453.0456,4456902.8196 5793452.9545,4456902.709699999 5793452.8022,4456902.632299999 5793452.748099999,4456902.3322 5793452.6761,4456902.241299999 5793452.692999999,4456902.094999999 5793452.9404,4456902.1336 5793453.2071,4456902.6232 5793453.4975,4456902.681599999 5793453.5017,4456902.831699999 5793453.158999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (365,366,318,'AHa015',15,'AHa','Stuhlmann','Bettstein in situ','Bettstein in situ','NULL',2.36145503513,0.418079384776,0.344716040492,0.896261705279,0, ST_GeomFromText('MULTIPOLYGON(((4456908.244699999 5793453.585999999,4456908.3448 5793453.525299999,4456908.408699999 5793453.453099999,4456908.4423 5793453.326199999,4456908.519799999 5793453.1201,4456908.4851 5793453.0537,4456908.404099999 5793452.9778,4456908.2367 5793452.911499999,4456908.080699999 5793452.878799999,4456907.9171 5793452.901499999,4456907.813 5793452.9835,4456907.7843 5793453.1005,4456907.7975 5793453.3125,4456907.9077 5793453.547499999,4456907.991999999 5793453.632099999,4456908.078999999 5793453.6399,4456908.244699999 5793453.585999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (366,367,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.69233781822,0.199570764756,0.177251034109,0.460852688684,0, ST_GeomFromText('MULTIPOLYGON(((4456894.9948 5793453.9558,4456895.078099999 5793453.901,4456895.1801 5793453.769899999,4456895.201299999 5793453.701999999,4456895.1599 5793453.4107,4456895.137799999 5793453.3497,4456895.1019 5793453.318299999,4456895.021599999 5793453.3308,4456894.9243 5793453.3901,4456894.7586 5793453.5719,4456894.7602 5793453.634099999,4456894.8447 5793453.868899999,4456894.8847 5793453.934399999,4456894.9264 5793453.9623,4456894.9948 5793453.9558)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (367,368,318,'AHa015',15,'AHa','Stuhlmann','Gang','Gang','NULL',2.38132741185,0.406461740188,0.33581227768,0.873111921968,0, ST_GeomFromText('MULTIPOLYGON(((4456907.390599999 5793454.051599999,4456907.491499999 5793454.018699999,4456907.536299999 5793453.958399999,4456907.5707 5793453.746099999,4456907.553799999 5793453.354199999,4456907.513399999 5793453.2806,4456907.410699999 5793453.2301,4456907.291899999 5793453.2083,4456907.1446 5793453.221599999,4456907.019399999 5793453.293199999,4456906.986899999 5793453.5075,4456906.998999999 5793453.663499999,4456907.023799999 5793453.735999999,4456907.170699999 5793453.9988,4456907.311099999 5793454.0543,4456907.390599999 5793454.051599999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (368,369,318,'AHa015',15,'AHa','Stuhlmann','Bettstein in situ','Bettstein in situ','NULL',3.29661724724,0.814401289308,0.648457148126,1.68598858513,0, ST_GeomFromText('MULTIPOLYGON(((4456910.0932 5793454.2816,4456910.2662 5793454.215199999,4456910.389299999 5793454.138599999,4456910.4165 5793454.100199999,4456910.417299999 5793453.869899999,4456910.3048 5793453.5829,4456910.144999999 5793453.4502,4456909.917 5793453.357,4456909.7679 5793453.3421,4456909.631099999 5793453.368,4456909.5482 5793453.4041,4456909.3342 5793453.605,4456909.2931 5793453.709799999,4456909.3092 5793453.7651,4456909.385599999 5793453.8624,4456909.4435 5793453.996099999,4456909.540699999 5793454.127399999,4456909.570799999 5793454.207299999,4456909.6924 5793454.3004,4456909.783699999 5793454.3287,4456909.9231 5793454.331199999,4456910.0932 5793454.2816)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (369,370,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',3.24444842717,0.752415844705,0.600951503382,1.56247390879,0, ST_GeomFromText('MULTIPOLYGON(((4456902.036399999 5793454.3388,4456902.1535 5793454.1498,4456902.220499999 5793453.8844,4456902.3207 5793453.695299999,4456902.288099999 5793453.6213,4456901.866899999 5793453.4569,4456901.3868 5793453.537599999,4456901.2925 5793453.6137,4456901.2889 5793454.112299999,4456901.420199999 5793454.3048,4456901.9028 5793454.4317,4456902.036399999 5793454.3388)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (370,371,318,'AHa015',15,'AHa','Stuhlmann','Bettstein in situ','Bettstein','NULL',4.11808986757,1.23855314519,0.973527130472,2.53117053923,0, ST_GeomFromText('MULTIPOLYGON(((4456913.6513 5793454.5866,4456913.705 5793454.546399999,4456913.949 5793454.191899999,4456914.009399999 5793454.0898,4456914.080299999 5793453.8344,4456914.0932 5793453.724799999,4456914.082299999 5793453.578199999,4456914.054999999 5793453.5205,4456914.006299999 5793453.484099999,4456913.7975 5793453.425499999,4456913.500799999 5793453.3867,4456913.2591 5793453.408399999,4456913.0745 5793453.449599999,4456912.9352 5793453.5219,4456912.8327 5793453.615499999,4456912.707999999 5793453.833499999,4456912.666799999 5793453.9461,4456912.6752 5793454.022199999,4456912.740199999 5793454.1246,4456912.9663 5793454.3266,4456913.5788 5793454.5898,4456913.6513 5793454.5866)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (371,372,318,'AHa015',15,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.72350941977,0.531083674994,0.431322528515,1.12143857414,0, ST_GeomFromText('MULTIPOLYGON(((4456907.581899999 5793454.932,4456907.7262 5793454.8617,4456907.775299999 5793454.7396,4456907.7564 5793454.613399999,4456907.684399999 5793454.411299999,4456907.628499999 5793454.338899999,4456907.5415 5793454.3066,4456907.338899999 5793454.2772,4456907.1418 5793454.285099999,4456906.921799999 5793454.343699999,4456906.812199999 5793454.4309,4456906.781 5793454.5314,4456906.836699999 5793454.7594,4456906.901499999 5793454.8374,4456907.0793 5793454.899399999,4456907.341099999 5793454.909299999,4456907.488499999 5793454.9375,4456907.581899999 5793454.932)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (372,373,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.00477728795,0.0744004547075,0.0813205084878,0.211433322068,0, ST_GeomFromText('MULTIPOLYGON(((4456894.439799999 5793454.922499999,4456894.508399999 5793454.811599999,4456894.439199999 5793454.6718,4456894.343399999 5793454.6563,4456894.2103 5793454.7386,4456894.1873 5793454.8694,4456894.2295 5793454.9637,4456894.3167 5793454.9863,4456894.439799999 5793454.922499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (373,374,318,'AHa015',15,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',1.83410638358,0.256531329645,0.22090561104,0.574354588703,0, ST_GeomFromText('MULTIPOLYGON(((4456908.821399999 5793455.083699999,4456908.901899999 5793455.0437,4456908.981599999 5793454.8701,4456908.955199999 5793454.695699999,4456908.880499999 5793454.594699999,4456908.805599999 5793454.563899999,4456908.6562 5793454.5785,4456908.4972 5793454.641599999,4456908.4161 5793454.704099999,4456908.3864 5793454.7561,4456908.3759 5793454.8451,4456908.3962 5793454.945599999,4456908.4527 5793455.0468,4456908.559899999 5793455.093699999,4456908.821399999 5793455.083699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (374,375,318,'AHa015',15,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.5735982208,0.496551380112,0.404856977718,1.05262814207,0, ST_GeomFromText('MULTIPOLYGON(((4456902.8048 5793455.2006,4456902.8854 5793455.0886,4456902.870799999 5793454.9019,4456902.8355 5793454.754599999,4456902.716599999 5793454.553999999,4456902.5886 5793454.434699999,4456902.520899999 5793454.406199999,4456902.411 5793454.3978,4456902.2674 5793454.4206,4456902.176599999 5793454.5107,4456902.144399999 5793454.5744,4456902.1436 5793454.8735,4456902.1774 5793455.015799999,4456902.250099999 5793455.1135,4456902.357499999 5793455.187,4456902.502299999 5793455.230799999,4456902.678 5793455.2477,4456902.8048 5793455.2006)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (375,376,318,'AHa015',15,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',3.57498820691,0.924786359677,0.733056266057,1.90594629175,0, ST_GeomFromText('MULTIPOLYGON(((4456904.4922 5793455.175699999,4456904.5743 5793455.086999999,4456904.5991 5793455.004499999,4456904.5865 5793454.730299999,4456904.5179 5793454.4656,4456904.4724 5793454.4154,4456904.217699999 5793454.4074,4456903.9671 5793454.3409,4456903.846499999 5793454.3355,4456903.661999999 5793454.3737,4456903.483099999 5793454.495699999,4456903.467699999 5793454.6049,4456903.5037 5793454.7771,4456903.496299999 5793455.029799999,4456903.5197 5793455.172299999,4456903.566599999 5793455.229,4456903.7197 5793455.275,4456904.2252 5793455.288799999,4456904.4922 5793455.175699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (376,377,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.2471483187,0.114992539919,0.112430282594,0.292318734745,0, ST_GeomFromText('MULTIPOLYGON(((4456893.462799999 5793455.4571,4456893.5289 5793455.388,4456893.563599999 5793455.343,4456893.5694 5793455.2967,4456893.484699999 5793455.0765,4456893.402099999 5793455.0513,4456893.261099999 5793455.101999999,4456893.2191 5793455.225899999,4456893.2362 5793455.3769,4456893.272699999 5793455.454299999,4456893.3309 5793455.489399999,4456893.396599999 5793455.4899,4456893.462799999 5793455.4571)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (377,378,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.79743808412,0.236690805181,0.205699833091,0.534819566036,0, ST_GeomFromText('MULTIPOLYGON(((4456913.184 5793455.4581,4456913.2872 5793455.387199999,4456913.3125 5793455.3278,4456913.2444 5793455.1992,4456913.2082 5793455.078999999,4456913.1622 5793455.010199999,4456913.0799 5793454.9777,4456912.9466 5793454.9967,4456912.756299999 5793455.094,4456912.6929 5793455.276599999,4456912.710099999 5793455.3668,4456912.762 5793455.456299999,4456912.906299999 5793455.492,4456913.184 5793455.4581)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (378,379,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.258474541,0.116869604788,0.113868865109,0.296059049284,0, ST_GeomFromText('MULTIPOLYGON(((4456907.4027 5793455.725899999,4456907.496299999 5793455.628799999,4456907.5431 5793455.5139,4456907.524699999 5793455.443099999,4456907.4594 5793455.3957,4456907.3064 5793455.3781,4456907.2158 5793455.4141,4456907.1604 5793455.471799999,4456907.1403 5793455.541999999,4456907.2006 5793455.7554,4456907.2766 5793455.783199999,4456907.4027 5793455.725899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (379,380,318,'AHa015',15,'AHa','Stuhlmann','Kammerstein','Kammerstein','NULL',3.11296312817,0.625741699836,0.503868438754,1.31005794076,0, ST_GeomFromText('MULTIPOLYGON(((4456900.264299999 5793455.613199999,4456900.4314 5793455.412599999,4456900.521099999 5793455.176599999,4456900.5115 5793454.9867,4456900.4287 5793454.9206,4456900.2925 5793454.870999999,4456900.1884 5793454.8701,4456900.0979 5793454.899499999,4456899.872499999 5793455.0842,4456899.6145 5793455.472599999,4456899.559399999 5793455.626499999,4456899.6039 5793455.8637,4456899.688099999 5793455.946399999,4456899.771399999 5793455.947,4456900.264299999 5793455.613199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (380,381,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.79872915512,0.234993259992,0.204398834458,0.53143696959,0, ST_GeomFromText('MULTIPOLYGON(((4456911.779 5793456.021099999,4456911.8497 5793456.0085,4456911.9439 5793455.960799999,4456912.0213 5793455.848799999,4456912.0069 5793455.7719,4456911.8651 5793455.629699999,4456911.774299999 5793455.576099999,4456911.598 5793455.549,4456911.4725 5793455.575699999,4456911.3502 5793455.6718,4456911.3408 5793455.6994,4456911.4067 5793455.876,4456911.455299999 5793455.9418,4456911.6582 5793456.022099999,4456911.779 5793456.021099999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (381,382,318,'AHa015',15,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',4.50447569904,1.48697871006,1.16392048339,3.02619325681,0, ST_GeomFromText('MULTIPOLYGON(((4456899.108599999 5793456.239199999,4456899.234899999 5793456.195199999,4456899.2887 5793456.132699999,4456899.3929 5793455.821799999,4456899.397199999 5793455.580399999,4456899.4593 5793455.3329,4456899.4297 5793455.05,4456899.3387 5793454.8377,4456899.2498 5793454.744799999,4456899.104799999 5793454.672299999,4456898.939 5793454.665599999,4456898.8353 5793454.7113,4456898.5432 5793454.966399999,4456898.358799999 5793455.195299999,4456898.2843 5793455.3505,4456898.223199999 5793455.8087,4456898.3952 5793456.077299999,4456898.519299999 5793456.137199999,4456898.874499999 5793456.2453,4456899.108599999 5793456.239199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (382,383,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',2.39913435161,0.351612820176,0.293776065383,0.763817769995,0, ST_GeomFromText('MULTIPOLYGON(((4456909.522099999 5793456.416099999,4456909.6067 5793456.3551,4456909.682 5793456.2144,4456909.8051 5793455.8691,4456909.808699999 5793455.6939,4456909.7674 5793455.606699999,4456909.5992 5793455.5185,4456909.535899999 5793455.520999999,4456909.4778 5793455.5602,4456909.3426 5793455.786599999,4456909.2993 5793456.0644,4456909.302799999 5793456.2861,4456909.278599999 5793456.4153,4456909.292799999 5793456.449999999,4456909.4051 5793456.460799999,4456909.522099999 5793456.416099999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (383,384,318,'AHa015',15,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',3.70173885715,0.848428890429,0.674535901625,1.75379334423,0, ST_GeomFromText('MULTIPOLYGON(((4456908.6002 5793456.648199999,4456908.7335 5793456.4986,4456908.821899999 5793456.288599999,4456908.9313 5793456.0896,4456909.0026 5793455.8954,4456909.0299 5793455.536699999,4456908.9643 5793455.353299999,4456908.8721 5793455.243599999,4456908.8114 5793455.218399999,4456908.7253 5793455.252299999,4456908.381 5793455.5129,4456908.3195 5793455.5844,4456908.234899999 5793455.755799999,4456908.210699999 5793456.1567,4456908.2684 5793456.3935,4456908.283999999 5793456.607499999,4456908.312599999 5793456.708499999,4456908.3919 5793456.721799999,4456908.6002 5793456.648199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (384,385,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',2.46792012484,0.400405955208,0.331171124071,0.861044922585,0, ST_GeomFromText('MULTIPOLYGON(((4456900.431599999 5793456.8014,4456900.507299999 5793456.6819,4456900.5547 5793456.4396,4456900.525 5793456.040899999,4456900.4302 5793455.893999999,4456900.3534 5793455.876399999,4456900.264 5793455.887,4456900.186599999 5793455.925899999,4456900.145899999 5793455.9734,4456900.0756 5793456.204299999,4456900.0415 5793456.480399999,4456900.103799999 5793456.7528,4456900.1736 5793456.850199999,4456900.3024 5793456.853399999,4456900.431599999 5793456.8014)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (385,386,318,'AHa015',15,'AHa','Stuhlmann','Kammerstein','Kammerstein','NULL',1.60062386725,0.173324624978,0.157135992583,0.408553580715,0, ST_GeomFromText('MULTIPOLYGON(((4456905.866899999 5793457.065199999,4456905.9751 5793456.9052,4456905.9989 5793456.812999999,4456905.928799999 5793456.745899999,4456905.646099999 5793456.7825,4456905.435999999 5793456.876199999,4456905.407399999 5793456.937699999,4456905.4183 5793457.040799999,4456905.445399999 5793457.103199999,4456905.501099999 5793457.146199999,4456905.706399999 5793457.1565,4456905.866899999 5793457.065199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (386,387,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',0.85612840274,0.0533069448216,0.0651544425113,0.169401550529,0, ST_GeomFromText('MULTIPOLYGON(((4456893.3945 5793457.153999999,4456893.4927 5793457.049599999,4456893.4933 5793456.922299999,4456893.423999999 5793456.8844,4456893.297299999 5793456.911,4456893.258299999 5793456.967199999,4456893.2471 5793457.078999999,4456893.297399999 5793457.163899999,4456893.3945 5793457.153999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (387,388,318,'AHa015',15,'AHa','Stuhlmann','Bettstein','Bettstein','NULL',3.82362541026,1.09250194033,0.86159348707,2.24014306638,0, ST_GeomFromText('MULTIPOLYGON(((4456911.394 5793457.1258,4456911.518799999 5793457.045199999,4456911.564899999 5793456.974199999,4456911.5931 5793456.8584,4456911.5821 5793456.7214,4456911.547 5793456.603099999,4456911.5208 5793456.253299999,4456911.476599999 5793456.173299999,4456911.4126 5793456.1334,4456911.063099999 5793456.081,4456910.705099999 5793456.145099999,4456910.498599999 5793456.246999999,4456910.448599999 5793456.308199999,4456910.4117 5793456.402499999,4456910.396499999 5793456.547399999,4456910.4966 5793457.0064,4456910.553999999 5793457.0785,4456910.6633 5793457.122099999,4456911.115399999 5793457.1806,4456911.394 5793457.1258)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (388,389,318,'AHa015',15,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.66512348385,0.486988089668,0.397527671921,1.033571947,0, ST_GeomFromText('MULTIPOLYGON(((4456906.917899999 5793457.2334,4456907.179899999 5793457.128699999,4456907.411299999 5793456.9855,4456907.487099999 5793456.8935,4456907.4999 5793456.8339,4456907.4818 5793456.758099999,4456907.3846 5793456.6323,4456907.2712 5793456.598699999,4456907.0399 5793456.612199999,4456906.657599999 5793456.6412,4456906.5606 5793456.6892,4456906.5261 5793456.836899999,4456906.5277 5793456.993799999,4456906.5721 5793457.151599999,4456906.624499999 5793457.216399999,4456906.6951 5793457.236899999,4456906.917899999 5793457.2334)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (389,390,318,'AHa015',15,'AHa','Stuhlmann','Kammerstein','Kammerstein','NULL',1.89502872674,0.272159895081,0.23288334359,0.605496693333,0, ST_GeomFromText('MULTIPOLYGON(((4456904.747 5793457.4802,4456904.8852 5793457.440899999,4456904.9561 5793457.391899999,4456905.0509 5793457.195699999,4456905.047399999 5793457.085799999,4456904.9945 5793457.001099999,4456904.871399999 5793456.932499999,4456904.773299999 5793456.925599999,4456904.593299999 5793457.0054,4456904.4682 5793457.095399999,4456904.406 5793457.1774,4456904.4046 5793457.2936,4456904.440899999 5793457.374999999,4456904.546699999 5793457.4581,4456904.6101 5793457.4812,4456904.747 5793457.4802)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (390,391,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.37031795261,0.124868144843,0.119998946207,0.311997260139,0, ST_GeomFromText('MULTIPOLYGON(((4456895.0256 5793457.513399999,4456895.0343 5793457.4659,4456894.9956 5793457.3891,4456894.934299999 5793457.287299999,4456894.855999999 5793457.2094,4456894.765999999 5793457.164,4456894.566999999 5793457.2233,4456894.6999 5793457.5207,4456894.750099999 5793457.5822,4456894.8322 5793457.5953,4456895.0256 5793457.513399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (391,392,318,'AHa015',15,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.93557092795,0.626405909764,0.504377489243,1.31138147203,0, ST_GeomFromText('MULTIPOLYGON(((4456902.491999999 5793457.5844,4456902.592699999 5793457.535399999,4456902.663499999 5793457.458499999,4456902.779199999 5793457.104299999,4456902.750099999 5793456.9447,4456902.682799999 5793456.8452,4456902.6134 5793456.8287,4456902.438 5793456.854299999,4456902.2718 5793456.843699999,4456901.923999999 5793456.9315,4456901.7827 5793457.0204,4456901.736899999 5793457.168099999,4456901.751299999 5793457.2407,4456901.8738 5793457.4403,4456902.021599999 5793457.546499999,4456902.222699999 5793457.596599999,4456902.3671 5793457.6049,4456902.491999999 5793457.5844)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (392,393,318,'AHa015',15,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.74632318303,0.487933879562,0.398252525296,1.03545656577,0, ST_GeomFromText('MULTIPOLYGON(((4456899.548399999 5793457.635299999,4456899.6588 5793457.5249,4456899.832 5793457.162499999,4456899.8936 5793456.9024,4456899.8815 5793456.801899999,4456899.8271 5793456.7452,4456899.718899999 5793456.7122,4456899.3059 5793456.7232,4456899.2626 5793456.7774,4456899.2478 5793457.040799999,4456899.2684 5793457.2265,4456899.252899999 5793457.479699999,4456899.278699999 5793457.611199999,4456899.3338 5793457.671299999,4456899.4296 5793457.685699999,4456899.548399999 5793457.635299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (393,394,318,'AHa015',15,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.87594953698,0.604023164919,0.487223353594,1.26678071934,0, ST_GeomFromText('MULTIPOLYGON(((4456900.9813 5793457.6984,4456901.0597 5793457.659099999,4456901.093299999 5793457.6183,4456901.1336 5793457.5161,4456901.1546 5793457.3496,4456901.1336 5793457.1392,4456901.052099999 5793457.0063,4456900.922 5793456.9481,4456900.766599999 5793456.945299999,4456900.537399999 5793457.010299999,4456900.3645 5793457.1082,4456900.3414 5793457.153999999,4456900.3523 5793457.292199999,4456900.3024 5793457.623299999,4456900.3095 5793457.7069,4456900.3491 5793457.7883,4456900.4539 5793457.8254,4456900.532499999 5793457.825799999,4456900.9813 5793457.6984)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (394,395,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.35408821091,0.135344850136,0.128028293144,0.332873562174,0, ST_GeomFromText('MULTIPOLYGON(((4456908.818699999 5793457.815099999,4456908.843299999 5793457.749399999,4456908.812199999 5793457.6433,4456908.7888 5793457.5851,4456908.7247 5793457.5186,4456908.596199999 5793457.450899999,4456908.4762 5793457.457599999,4456908.410799999 5793457.5314,4456908.452999999 5793457.7649,4456908.5096 5793457.8276,4456908.605299999 5793457.870699999,4456908.714399999 5793457.8712,4456908.818699999 5793457.815099999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (395,396,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',2.27269111831,0.35719508523,0.29805431332,0.774941214632,0, ST_GeomFromText('MULTIPOLYGON(((4456895.9204 5793458.050899999,4456895.967 5793458.0142,4456895.9741 5793457.959899999,4456895.8342 5793457.6599,4456895.6725 5793457.4098,4456895.600599999 5793457.3504,4456895.505699999 5793457.353,4456895.419499999 5793457.397299999,4456895.3163 5793457.4908,4456895.2833 5793457.546099999,4456895.269399999 5793457.686699999,4456895.327499999 5793457.9339,4456895.365299999 5793457.999199999,4456895.4407 5793458.049,4456895.6977 5793458.058,4456895.9204 5793458.050899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (396,397,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.49125826562,0.137551055174,0.129719128686,0.337269734582,0, ST_GeomFromText('MULTIPOLYGON(((4456896.119099999 5793458.5084,4456896.2794 5793458.4603,4456896.325899999 5793458.416999999,4456896.308299999 5793458.2783,4456896.270999999 5793458.231499999,4456896.144299999 5793458.219599999,4456895.849899999 5793458.281899999,4456895.786999999 5793458.3088,4456895.752399999 5793458.3515,4456895.7467 5793458.4624,4456895.791699999 5793458.516799999,4456896.119099999 5793458.5084)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (397,398,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.34019696114,0.121295525143,0.11726089047,0.304878315221,0, ST_GeomFromText('MULTIPOLYGON(((4456896.9899 5793458.731,4456897.197499999 5793458.6464,4456897.301699999 5793458.5537,4456897.326399999 5793458.416099999,4456897.273199999 5793458.3438,4456897.175499999 5793458.341099999,4456896.9654 5793458.413599999,4456896.9275 5793458.4569,4456896.8947 5793458.578299999,4456896.884499999 5793458.692999999,4456896.9088 5793458.733699999,4456896.9899 5793458.731)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (398,399,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',2.9560736947,0.63088565034,0.507810762421,1.32030798229,0, ST_GeomFromText('MULTIPOLYGON(((4456903.5443 5793458.7201,4456903.758399999 5793458.597799999,4456903.8639 5793458.4879,4456903.9001 5793458.385999999,4456904.0047 5793457.908999999,4456903.9018 5793457.7685,4456903.7592 5793457.718599999,4456903.557699999 5793457.7872,4456903.420599999 5793457.878599999,4456903.166299999 5793458.1445,4456903.080699999 5793458.327199999,4456903.1352 5793458.504699999,4456903.211099999 5793458.611999999,4456903.3128 5793458.6938,4456903.4417 5793458.738199999,4456903.5443 5793458.7201)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (399,400,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.16542393023,0.0972679250018,0.0988461377214,0.256999958076,0, ST_GeomFromText('MULTIPOLYGON(((4456897.3853 5793459.296,4456897.4757 5793459.2213,4456897.534599999 5793459.0767,4456897.5173 5793458.964999999,4456897.4402 5793458.9096,4456897.364299999 5793458.9298,4456897.264 5793459.011099999,4456897.1945 5793459.165699999,4456897.195199999 5793459.2488,4456897.234799999 5793459.303999999,4456897.3003 5793459.320199999,4456897.3853 5793459.296)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (400,401,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',2.32372141654,0.393011890211,0.325504312657,0.846311212909,0, ST_GeomFromText('MULTIPOLYGON(((4456895.8809 5793461.741499999,4456895.9982 5793461.694399999,4456896.0575 5793461.6212,4456896.0685 5793461.328299999,4456896.0162 5793461.084899999,4456895.9621 5793461.0032,4456895.876099999 5793460.963199999,4456895.7788 5793460.958699999,4456895.5924 5793460.997999999,4456895.5344 5793461.07,4456895.4977 5793461.395099999,4456895.5334 5793461.6577,4456895.5816 5793461.715099999,4456895.702399999 5793461.7771,4456895.7713 5793461.7795,4456895.8809 5793461.741499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (401,402,318,'AHa015',15,'AHa','Stuhlmann','Stein','Stein','NULL',1.91501283808,0.262323200038,0.225344500509,0.585895701324,0, ST_GeomFromText('MULTIPOLYGON(((4456901.381299999 5793461.9627,4456901.5888 5793461.797299999,4456901.6243 5793461.695399999,4456901.6463 5793461.5098,4456901.641099999 5793461.4319,4456901.6079 5793461.3812,4456901.506 5793461.3515,4456901.3035 5793461.342499999,4456901.223399999 5793461.360899999,4456901.149199999 5793461.418299999,4456901.153099999 5793461.8253,4456901.1765 5793461.9154,4456901.219899999 5793461.963899999,4456901.2812 5793461.982599999,4456901.381299999 5793461.9627)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (402,403,321,'AHa018',18,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.58823653549,0.411978285321,0.34004015787,0.884104410462,1, ST_GeomFromText('MULTIPOLYGON(((4456391.510999999 5793727.8507,4456391.588399999 5793727.8114,4456391.660899999 5793727.707599999,4456391.768899999 5793727.5219,4456391.8913 5793727.3648,4456391.9883 5793727.166099999,4456391.987499999 5793727.054099999,4456391.9314 5793726.9987,4456391.7944 5793726.978099999,4456391.6829 5793727.013699999,4456391.451799999 5793727.170399999,4456391.303299999 5793727.352499999,4456391.2116 5793727.724799999,4456391.2119 5793727.788899999,4456391.231599999 5793727.828199999,4456391.3568 5793727.8705,4456391.510999999 5793727.8507)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (403,404,321,'AHa018',18,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.5399354682,0.399083384807,0.330157506116,0.858409515901,1, ST_GeomFromText('MULTIPOLYGON(((4456393.9073 5793728.4932,4456394.042999999 5793728.430999999,4456394.0909 5793728.363299999,4456394.085099999 5793728.270099999,4456394.022199999 5793728.167799999,4456393.732599999 5793728.0149,4456393.682199999 5793727.963099999,4456393.5963 5793727.817099999,4456393.5047 5793727.7433,4456393.425599999 5793727.7235,4456393.345399999 5793727.738399999,4456393.304499999 5793727.7675,4456393.223 5793727.870799999,4456393.203499999 5793727.9427,4456393.222199999 5793728.073799999,4456393.2476 5793728.1325,4456393.394199999 5793728.303099999,4456393.647199999 5793728.467599999,4456393.751699999 5793728.4995,4456393.9073 5793728.4932)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (404,405,321,'AHa018',18,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',1.56834323723,0.181888920055,0.16369966833,0.425619137659,1, ST_GeomFromText('MULTIPOLYGON(((4456391.490199999 5793728.685,4456391.5296 5793728.6304,4456391.514899999 5793728.4581,4456391.4609 5793728.332499999,4456391.411299999 5793728.2795,4456391.314399999 5793728.246899999,4456391.1162 5793728.2815,4456391.054999999 5793728.3372,4456391.009399999 5793728.411499999,4456391.005199999 5793728.467499999,4456391.0317 5793728.5467,4456391.124699999 5793728.628799999,4456391.375799999 5793728.7113,4456391.490199999 5793728.685)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (405,406,321,'AHa018',18,'AHa','Stuhlmann','Deckstein','Deckstein','NULL',4.64904917464,1.6198609906,1.26576146319,3.2909798043,1, ST_GeomFromText('MULTIPOLYGON(((4456392.3716 5793728.779699999,4456392.491999999 5793728.73,4456392.6199 5793728.6487,4456392.8031 5793728.456599999,4456392.927299999 5793728.2203,4456392.9987 5793728.040899999,4456393.053899999 5793727.7496,4456393.0295 5793727.530899999,4456392.940899999 5793727.361199999,4456392.7865 5793727.271099999,4456392.644 5793727.219,4456392.513299999 5793727.197799999,4456392.3859 5793727.219699999,4456392.1347 5793727.3855,4456391.790799999 5793727.815199999,4456391.658699999 5793728.117499999,4456391.6529 5793728.267,4456391.6878 5793728.4153,4456391.730499999 5793728.5173,4456391.847699999 5793728.6763,4456391.913599999 5793728.7235,4456392.0689 5793728.776699999,4456392.250699999 5793728.797,4456392.3716 5793728.779699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (406,407,321,'AHa018',18,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',2.05105931432,0.306284255008,0.259036253038,0.673494257899,1, ST_GeomFromText('MULTIPOLYGON(((4456394.2936 5793729.1871,4456394.3426 5793729.138399999,4456394.4543 5793728.906999999,4456394.465099999 5793728.7685,4456394.4483 5793728.694099999,4456394.3612 5793728.6217,4456394.291899999 5793728.600299999,4456394.1183 5793728.6129,4456393.8693 5793728.726199999,4456393.8287 5793728.763299999,4456393.776499999 5793728.879399999,4456393.777499999 5793728.9152,4456393.881799999 5793728.992499999,4456393.9296 5793729.131999999,4456394.031 5793729.177699999,4456394.1408 5793729.207699999,4456394.220999999 5793729.208799999,4456394.2936 5793729.1871)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (407,408,321,'AHa018',18,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',1.72302545779,0.223120819772,0.195299796273,0.50777947031,1, ST_GeomFromText('MULTIPOLYGON(((4456391.820199999 5793729.192299999,4456391.9142 5793729.1523,4456391.966599999 5793729.095899999,4456391.984799999 5793729.043099999,4456391.9482 5793728.876,4456391.872899999 5793728.806099999,4456391.7503 5793728.7598,4456391.5776 5793728.7726,4456391.4482 5793728.832699999,4456391.3843 5793728.897399999,4456391.3589 5793729.0229,4456391.3963 5793729.1071,4456391.4807 5793729.1727,4456391.5618 5793729.203299999,4456391.684799999 5793729.220899999,4456391.820199999 5793729.192299999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (408,409,321,'AHa018',18,'AHa','Stuhlmann','Stein','Stein','NULL',2.04784357927,0.279774385022,0.238719088681,0.62066963057,1, ST_GeomFromText('MULTIPOLYGON(((4456393.434 5793729.814899999,4456393.546199999 5793729.7489,4456393.7788 5793729.5764,4456393.906799999 5793729.459599999,4456393.9471 5793729.334499999,4456393.901999999 5793729.263499999,4456393.778099999 5793729.2081,4456393.639299999 5793729.193099999,4456393.4939 5793729.2038,4456393.4115 5793729.2675,4456393.352099999 5793729.418299999,4456393.2428 5793729.5292,4456393.2437 5793729.637599999,4456393.2822 5793729.719499999,4456393.366499999 5793729.818099999,4456393.434 5793729.814899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (409,410,321,'AHa018',18,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',1.6726710184,0.206694534941,0.182710691579,0.475047798105,1, ST_GeomFromText('MULTIPOLYGON(((4456395.116799999 5793729.817399999,4456395.162399999 5793729.7574,4456395.1847 5793729.6793,4456395.1896 5793729.595399999,4456395.158599999 5793729.535,4456395.078599999 5793729.4768,4456395.0025 5793729.46,4456394.7472 5793729.489399999,4456394.676799999 5793729.524,4456394.6046 5793729.625499999,4456394.5892 5793729.7642,4456394.654099999 5793729.845499999,4456394.777999999 5793729.8845,4456394.9576 5793729.8881,4456395.116799999 5793729.817399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (410,411,321,'AHa018',18,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',1.52153892261,0.165327155028,0.151006731614,0.392617502195,1, ST_GeomFromText('MULTIPOLYGON(((4456392.384499999 5793729.961899999,4456392.420599999 5793729.914799999,4456392.4067 5793729.815999999,4456392.3798 5793729.753599999,4456392.2175 5793729.5588,4456392.0525 5793729.5172,4456392.005199999 5793729.5241,4456391.975399999 5793729.552699999,4456391.938699999 5793729.660299999,4456391.9336 5793729.7565,4456391.9581 5793729.856,4456392.0175 5793729.9174,4456392.201299999 5793729.9791,4456392.3391 5793729.986899999,4456392.384499999 5793729.961899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (411,412,321,'AHa018',18,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',1.5482576184,0.175465379976,0.158776667214,0.412819334756,1, ST_GeomFromText('MULTIPOLYGON(((4456393.080599999 5793730.466099999,4456393.1599 5793730.401399999,4456393.189799999 5793730.3537,4456393.1836 5793730.263699999,4456393.088999999 5793730.011199999,4456393.034799999 5793729.9582,4456392.9774 5793729.9308,4456392.899299999 5793729.922599999,4456392.842 5793729.9414,4456392.782599999 5793730.039999999,4456392.7618 5793730.1292,4456392.7757 5793730.2576,4456392.847199999 5793730.385399999,4456392.924999999 5793730.4601,4456392.9967 5793730.483999999,4456393.080599999 5793730.466099999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (412,413,321,'AHa018',18,'AHa','Stuhlmann','Deckstein','Deckstein','NULL',2.57946005626,0.481979874698,0.393689375968,1.02359237752,1, ST_GeomFromText('MULTIPOLYGON(((4456394.1901 5793730.633099999,4456394.2641 5793730.573499999,4456394.381699999 5793730.392799999,4456394.433199999 5793730.2738,4456394.4873 5793729.919199999,4456394.433799999 5793729.7796,4456394.2543 5793729.685399999,4456394.1069 5793729.736899999,4456393.9385 5793729.8616,4456393.805599999 5793730.0609,4456393.789499999 5793730.1322,4456393.8139 5793730.2454,4456393.8156 5793730.3859,4456393.8459 5793730.473999999,4456393.8859 5793730.525399999,4456394.0092 5793730.608599999,4456394.1216 5793730.642599999,4456394.1901 5793730.633099999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (413,414,321,'AHa018',18,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',1.8878674551,0.253316245077,0.218441570227,0.56794808259,1, ST_GeomFromText('MULTIPOLYGON(((4456395.489099999 5793730.652799999,4456395.832899999 5793730.4416,4456395.875799999 5793730.370799999,4456395.887 5793730.306099999,4456395.842299999 5793730.172399999,4456395.766099999 5793730.1192,4456395.6182 5793730.103599999,4456395.485799999 5793730.143899999,4456395.3343 5793730.246999999,4456395.258999999 5793730.3712,4456395.2389 5793730.46,4456395.2882 5793730.6334,4456395.316399999 5793730.6608,4456395.366899999 5793730.6729,4456395.489099999 5793730.652799999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (414,415,321,'AHa018',18,'AHa','Stuhlmann','Kammerstein in situ','Kammerstein in situ','NULL',1.3998193167,0.151145564878,0.140137960923,0.364358698399,1, ST_GeomFromText('MULTIPOLYGON(((4456393.6754 5793731.045499999,4456393.7361 5793731.010199999,4456393.7925 5793730.923399999,4456393.8152 5793730.8494,4456393.798499999 5793730.7639,4456393.7602 5793730.7015,4456393.7021 5793730.665799999,4456393.5147 5793730.6477,4456393.387699999 5793730.714099999,4456393.353799999 5793730.7563,4456393.336799999 5793730.844,4456393.364699999 5793730.931199999,4456393.415799999 5793730.988199999,4456393.494199999 5793731.038399999,4456393.591199999 5793731.057499999,4456393.6754 5793731.045499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (415,416,321,'AHa018',18,'AHa','Stuhlmann','Stein','Stein','NULL',2.3745033437,0.297138205109,0.252026720396,0.655269473029,1, ST_GeomFromText('MULTIPOLYGON(((4456394.4353 5793731.3267,4456394.575 5793731.268799999,4456394.6912 5793731.1793,4456395.010999999 5793730.9035,4456395.0832 5793730.811899999,4456395.1019 5793730.6849,4456395.074199999 5793730.627699999,4456395.0278 5793730.5862,4456394.9643 5793730.577899999,4456394.842899999 5793730.616299999,4456394.695 5793730.7083,4456394.556099999 5793730.822,4456394.29 5793731.2049,4456394.269399999 5793731.287399999,4456394.3207 5793731.337899999,4456394.4353 5793731.3267)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (416,417,418,'AHa033',33,'AHa','Rinne 02.2012','Bettstein','Bettstein','NULL',2.80883090002,0.563863415045,0.45644492129,1.18675679536,1, ST_GeomFromText('MULTIPOLYGON(((4459513.5519 5792291.366399999,4459513.623599999 5792291.3395,4459513.764 5792291.276799999,4459513.8223 5792291.2365,4459513.8552 5792291.1962,4459513.901499999 5792291.126,4459513.923899999 5792291.0065,4459513.922399999 5792290.945299999,4459513.8985 5792290.895999999,4459513.8507 5792290.879599999,4459513.832799999 5792290.846699999,4459513.8283 5792290.797399999,4459513.8074 5792290.7541,4459513.7028 5792290.682399999,4459513.507 5792290.5436,4459513.394999999 5792290.4689,4459513.3382 5792290.437499999,4459513.2949 5792290.437499999,4459513.2202 5792290.4689,4459513.138 5792290.509199999,4459513.112599999 5792290.548,4459513.108099999 5792290.633199999,4459513.102099999 5792290.7631,4459513.1036 5792290.883999999,4459513.1275 5792291.0423,4459513.163399999 5792291.169299999,4459513.2202 5792291.293199999,4459513.244099999 5792291.3186,4459513.264999999 5792291.332,4459513.324699999 5792291.3604,4459513.400999999 5792291.3679,4459513.487599999 5792291.378299999,4459513.5519 5792291.366399999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (417,418,418,'AHa033',33,'AHa','Rinne 02.2012','Kammerstein','Kammerstein','NULL',1.90355820597,0.24007967024,0.208297059272,0.541572354107,1, ST_GeomFromText('MULTIPOLYGON(((4459518.646399999 5792291.9996,4459518.7571 5792291.8691,4459518.8298 5792291.7354,4459518.8232 5792291.628,4459518.762099999 5792291.4679,4459518.7142 5792291.419999999,4459518.657999999 5792291.368799999,4459518.6117 5792291.3341,4459518.553899999 5792291.3341,4459518.5126 5792291.355599999,4459518.4994 5792291.391899999,4459518.4845 5792291.466199999,4459518.420099999 5792291.566899999,4459518.3507 5792291.6512,4459518.309399999 5792291.6776,4459518.268099999 5792291.682499999,4459518.2631 5792291.703999999,4459518.291199999 5792291.779999999,4459518.3705 5792291.890599999,4459518.463 5792291.9534,4459518.558899999 5792292.0095,4459518.6035 5792292.027699999,4459518.646399999 5792291.9996)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (418,419,418,'AHa033',33,'AHa','Rinne 02.2012','Deckstein?','Deckstein','NULL',3.03503903757,0.587368475025,0.474459199259,1.23359391807,1, ST_GeomFromText('MULTIPOLYGON(((4459516.4521 5792292.0258,4459516.525399999 5792292.0192,4459516.5837 5792291.9876,4459516.601999999 5792291.9626,4459516.601999999 5792291.915999999,4459516.666899999 5792291.911,4459516.7268 5792291.8911,4459516.8151 5792291.8362,4459516.841699999 5792291.8012,4459516.848299999 5792291.6981,4459516.833399999 5792291.5766,4459516.8234 5792291.4868,4459516.7734 5792291.4052,4459516.7318 5792291.3603,4459516.661899999 5792291.3603,4459516.6003 5792291.3903,4459516.5787 5792291.410199999,4459516.561999999 5792291.4086,4459516.5137 5792291.388599999,4459516.437199999 5792291.365299999,4459516.3523 5792291.358699999,4459516.2224 5792291.3703,4459516.144199999 5792291.355299999,4459516.0743 5792291.348699999,4459515.892799999 5792291.3603,4459515.829599999 5792291.357,4459515.8162 5792291.3603,4459515.8013 5792291.388599999,4459515.8229 5792291.4801,4459515.889499999 5792291.7596,4459515.931099999 5792291.886099999,4459515.974399999 5792291.957599999,4459516.041 5792292.0075,4459516.1675 5792292.030799999,4459516.333999999 5792292.037499999,4459516.4521 5792292.0258)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (419,420,418,'AHa033',33,'AHa','Rinne 02.2012','Bettstein','Bettstein','NULL',1.89223563267,0.214758014917,0.188890542632,0.491115410843,1, ST_GeomFromText('MULTIPOLYGON(((4459512.0766 5792292.221499999,4459512.103799999 5792292.1892,4459512.131099999 5792292.0888,4459512.131099999 5792291.9714,4459512.131099999 5792291.787599999,4459512.117399999 5792291.6498,4459512.088499999 5792291.593599999,4459512.068099999 5792291.5664,4459512.040799999 5792291.5613,4459512.0136 5792291.5885,4459511.960799999 5792291.642999999,4459511.892699999 5792291.716099999,4459511.807599999 5792291.7825,4459511.763299999 5792291.8046,4459511.7361 5792291.8114,4459511.718999999 5792291.8318,4459511.713899999 5792291.9067,4459511.713899999 5792292.087099999,4459511.7207 5792292.1892,4459511.7224 5792292.2147,4459511.7395 5792292.2266,4459511.797399999 5792292.221499999,4459511.826299999 5792292.216399999,4459511.848399999 5792292.201099999,4459511.8825 5792292.196,4459511.9285 5792292.2028,4459512.0119 5792292.216399999,4459512.0459 5792292.2334,4459512.0766 5792292.221499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (420,421,418,'AHa033',33,'AHa','Rinne 02.2012','Bettstein','Bettstein','NULL',1.71912322579,0.194301190064,0.173212432065,0.450352323369,1, ST_GeomFromText('MULTIPOLYGON(((4459512.376199999 5792292.3321,4459512.428999999 5792292.330399999,4459512.4988 5792292.31,4459512.539699999 5792292.3032,4459512.636699999 5792292.3015,4459512.650299999 5792292.2913,4459512.6401 5792292.235099999,4459512.6401 5792292.144899999,4459512.665699999 5792292.0752,4459512.6606 5792291.974799999,4459512.650299999 5792291.894799999,4459512.634999999 5792291.8353,4459512.597599999 5792291.8012,4459512.5261 5792291.7246,4459512.491999999 5792291.7144,4459512.456199999 5792291.7298,4459512.4018 5792291.7791,4459512.364299999 5792291.836999999,4459512.2894 5792291.996899999,4459512.245099999 5792292.0548,4459512.245099999 5792292.0973,4459512.2553 5792292.1552,4459512.282599999 5792292.265799999,4459512.3354 5792292.344,4459512.376199999 5792292.3321)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (421,422,418,'AHa033',33,'AHa','Rinne 02.2012','Bettstein','Bettstein','NULL',3.62352134901,0.635973055373,0.511709749638,1.33044534906,1, ST_GeomFromText('MULTIPOLYGON(((4459527.276399999 5792292.7036,4459527.348899999 5792292.642899999,4459527.3979 5792292.430299999,4459527.4587 5792292.059,4459527.472699999 5792291.851099999,4459527.463399999 5792291.7927,4459527.4143 5792291.757699999,4459527.3512 5792291.778699999,4459527.2461 5792291.8418,4459527.126899999 5792291.8978,4459527.038099999 5792291.909499999,4459526.8605 5792291.904799999,4459526.5754 5792291.9165,4459526.402499999 5792291.921199999,4459526.2763 5792291.963199999,4459526.243599999 5792291.981899999,4459526.236499999 5792292.059,4459526.2739 5792292.1641,4459526.334699999 5792292.227099999,4459526.388399999 5792292.243499999,4459526.491299999 5792292.245799999,4459526.734299999 5792292.3252,4459526.902499999 5792292.411599999,4459527.019399999 5792292.5448,4459527.161899999 5792292.698899999,4459527.213299999 5792292.7223,4459527.276399999 5792292.7036)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (422,423,418,'AHa033',33,'AHa','Rinne 02.2012','Bettstein','Bettstein','NULL',2.15040393749,0.310073490124,0.261940322831,0.68104483936,1, ST_GeomFromText('MULTIPOLYGON(((4459512.677 5792292.877,4459512.710099999 5792292.8725,4459512.7914 5792292.8439,4459512.8651 5792292.8153,4459512.928399999 5792292.785199999,4459512.9901 5792292.746099999,4459513.029199999 5792292.691899999,4459513.0338 5792292.6633,4459513.023199999 5792292.6107,4459513.006699999 5792292.5415,4459513.005099999 5792292.4888,4459513.0082 5792292.4316,4459513.0082 5792292.406099999,4459512.9675 5792292.3188,4459512.934399999 5792292.2631,4459512.899799999 5792292.2586,4459512.816999999 5792292.2737,4459512.704099999 5792292.293199999,4459512.643799999 5792292.312799999,4459512.5475 5792292.324799999,4459512.4707 5792292.333799999,4459512.377399999 5792292.344399999,4459512.341199999 5792292.360899999,4459512.336699999 5792292.377499999,4459512.3458 5792292.410599999,4459512.384899999 5792292.506899999,4459512.4301 5792292.588099999,4459512.479799999 5792292.693399999,4459512.509899999 5792292.7807,4459512.524899999 5792292.8243,4459512.585099999 5792292.868,4459512.6243 5792292.885999999,4459512.633299999 5792292.899599999,4459512.677 5792292.877)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (423,424,418,'AHa033',33,'AHa','Rinne 02.2012','Bettstein','Bettstein','NULL',1.08186132667,0.080557714825,0.0860394326419,0.223702524869,1, ST_GeomFromText('MULTIPOLYGON(((4459513.6474 5792293.9317,4459513.705799999 5792293.873299999,4459513.745299999 5792293.7661,4459513.734 5792293.6475,4459513.692599999 5792293.536499999,4459513.5345 5792293.6325,4459513.5137 5792293.6475,4459513.4686 5792293.7661,4459513.462899999 5792293.8376,4459513.489299999 5792293.895899999,4459513.542 5792293.933499999,4459513.6079 5792293.946699999,4459513.6474 5792293.9317)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (424,425,426,'Süp001',1,'Süp','Stuhlmann','Stein','Stein','NULL',4.11923009458,1.16235742489,0.915130730434,2.37933989913,1, ST_GeomFromText('MULTIPOLYGON(((4456266.0718 5795042.071699999,4456266.1823 5795042.0181,4456266.235999999 5795041.932299999,4456266.2779 5795041.788799999,4456266.4115 5795041.5249,4456266.4778 5795041.24,4456266.459099999 5795040.8109,4456266.416299999 5795040.6991,4456266.3431 5795040.6103,4456266.2421 5795040.541799999,4456266.1052 5795040.5008,4456266.002799999 5795040.5358,4456265.7509 5795040.698899999,4456265.5941 5795040.912499999,4456265.537299999 5795041.035199999,4456265.526499999 5795041.119699999,4456265.554399999 5795041.2333,4456265.5826 5795041.6498,4456265.6222 5795041.9362,4456265.6583 5795042.008099999,4456265.765399999 5795042.0687,4456265.9122 5795042.082499999,4456266.0718 5795042.071699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (425,426,426,'Süp001',1,'Süp','Stuhlmann','Bettstein','Bettstein','NULL',2.92137769311,0.627023699782,0.504850963513,1.31261250513,1, ST_GeomFromText('MULTIPOLYGON(((4456272.493499999 5795047.054199999,4456272.624499999 5795047.013,4456272.728799999 5795046.9407,4456272.8037 5795046.840199999,4456272.855899999 5795046.6794,4456272.8717 5795046.4243,4456272.8452 5795046.299499999,4456272.800099999 5795046.2663,4456272.414099999 5795046.152899999,4456272.343899999 5795046.177799999,4456272.2538 5795046.2616,4456272.1353 5795046.4458,4456272.012799999 5795046.592299999,4456271.9203 5795046.809699999,4456271.9391 5795046.8574,4456272.1435 5795047.026499999,4456272.305399999 5795047.081199999,4456272.493499999 5795047.054199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (426,427,426,'Süp001',1,'Süp','Stuhlmann','Stein','Stein','NULL',3.08292914215,0.60486996054,0.487872337758,1.26846807817,1, ST_GeomFromText('MULTIPOLYGON(((4456292.2926 5795051.5403,4456292.3676 5795051.499399999,4456292.4188 5795051.3991,4456292.446499999 5795051.2945,4456292.435899999 5795050.907999999,4456292.3338 5795050.7345,4456292.2148 5795050.678899999,4456292.1244 5795050.537799999,4456292.0327 5795050.433499999,4456291.991299999 5795050.418999999,4456291.7592 5795050.432399999,4456291.705099999 5795050.4647,4456291.6622 5795050.524199999,4456291.5898 5795050.781899999,4456291.5877 5795050.8438,4456291.7181 5795051.0313,4456291.837899999 5795051.1269,4456291.935499999 5795051.246799999,4456292.042999999 5795051.335699999,4456292.247399999 5795051.538,4456292.2926 5795051.5403)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (427,428,426,'Süp001',1,'Süp','Stuhlmann','Stein','Stein','NULL',1.10538715652,0.0805949349065,0.0860679581124,0.223776691092,1, ST_GeomFromText('MULTIPOLYGON(((4456285.317699999 5795052.4635,4456285.340599999 5795052.4371,4456285.340499999 5795052.3957,4456285.270499999 5795052.254799999,4456285.222699999 5795052.207,4456285.1178 5795052.154699999,4456285.0217 5795052.137199999,4456284.9708 5795052.1674,4456284.9797 5795052.2539,4456285.035099999 5795052.370999999,4456285.1642 5795052.459599999,4456285.253399999 5795052.4779,4456285.317699999 5795052.4635)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (428,429,426,'Süp001',1,'Süp','Stuhlmann','Stein','Stein','NULL',1.29554745477,0.107428385226,0.106633114437,0.277246097536,1, ST_GeomFromText('MULTIPOLYGON(((4456285.0317 5795053.6113,4456285.0743 5795053.5873,4456285.110199999 5795053.536499999,4456285.184899999 5795053.3398,4456285.212 5795053.2291,4456285.1731 5795053.178799999,4456285.120699999 5795053.1851,4456285.047899999 5795053.242599999,4456284.940799999 5795053.2957,4456284.8689 5795053.366499999,4456284.8355 5795053.429099999,4456284.810899999 5795053.5241,4456284.831799999 5795053.5743,4456284.9248 5795053.6114,4456285.0317 5795053.6113)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (429,430,426,'Süp001',1,'Süp','Stuhlmann','Bettstein','Bettstein','NULL',3.45933035546,0.864819470277,0.68709764202,1.78645386925,1, ST_GeomFromText('MULTIPOLYGON(((4456283.102099999 5795053.7477,4456283.254499999 5795053.720799999,4456283.4095 5795053.6554,4456283.6242 5795053.4633,4456283.826399999 5795053.149,4456283.8399 5795053.082399999,4456283.8207 5795053.022299999,4456283.746399999 5795052.9373,4456283.6632 5795052.878399999,4456283.508999999 5795052.823999999,4456283.280799999 5795052.800699999,4456283.1068 5795052.8286,4456282.9807 5795052.888399999,4456282.7745 5795053.029799999,4456282.5469 5795053.24,4456282.528599999 5795053.3339,4456282.558899999 5795053.4571,4456282.7426 5795053.640699999,4456282.998399999 5795053.738099999,4456283.102099999 5795053.7477)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (430,431,426,'Süp001',1,'Süp','Stuhlmann','Stein','Stein','NULL',0.851472235991,0.0480779599677,0.0611469485192,0.15898206615,1, ST_GeomFromText('MULTIPOLYGON(((4456284.8073 5795054.155799999,4456284.926699999 5795054.0601,4456284.975999999 5795053.9973,4456284.983099999 5795053.9504,4456284.953599999 5795053.9122,4456284.891499999 5795053.9089,4456284.7263 5795053.979,4456284.690499999 5795054.027499999,4456284.677099999 5795054.0918,4456284.7094 5795054.137099999,4456284.8073 5795054.155799999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (431,432,426,'Süp001',1,'Süp','Stuhlmann','Stein','Stein','NULL',4.08797147591,0.985630805463,0.779687449307,2.0271873682,1, ST_GeomFromText('MULTIPOLYGON(((4456288.418499999 5795055.9802,4456289.1056 5795055.2697,4456289.1847 5795054.990399999,4456289.223699999 5795054.5657,4456289.2098 5795054.539799999,4456289.1489 5795054.4966,4456289.0283 5795054.435499999,4456288.928999999 5795054.421299999,4456288.8003 5795054.4417,4456288.6709 5795054.498999999,4456288.5838 5795054.577299999,4456288.427899999 5795054.8179,4456288.3421 5795055.050599999,4456288.3205 5795055.202199999,4456288.274299999 5795055.387299999,4456288.2153 5795055.537299999,4456288.1303 5795055.683599999,4456288.139399999 5795055.7629,4456288.206699999 5795055.857899999,4456288.2975 5795055.9316,4456288.374499999 5795055.9733,4456288.418499999 5795055.9802)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (432,433,313,'AHa010',10,'AHa','Rinne 2010','Gang','Gang','NULL',2.6166867468,0.343664000272,0.287684089808,0.747978633501,1, ST_GeomFromText('MULTIPOLYGON(((4458031.4901 5793698.617,4458031.6715 5793698.311,4458031.779799999 5793698.113299999,4458031.8222 5793698.0379,4458031.8716 5793697.948499999,4458031.8693 5793697.858999999,4458031.8447 5793697.843499999,4458031.8092 5793697.8298,4458031.691499999 5793697.844699999,4458031.4954 5793697.8933,4458031.4627 5793697.9616,4458031.404199999 5793698.1107,4458031.325299999 5793698.2101,4458031.2477 5793698.2715,4458031.194799999 5793698.3274,4458031.1479 5793698.3529,4458031.107099999 5793698.362099999,4458031.0948 5793698.3825,4458031.0826 5793698.406899999,4458031.103 5793698.4813,4458031.156999999 5793698.5537,4458031.208999999 5793698.6026,4458031.223299999 5793698.649499999,4458031.2499 5793698.6947,4458031.299399999 5793698.720599999,4458031.348799999 5793698.73,4458031.4148 5793698.763,4458031.4901 5793698.617)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (433,434,313,'AHa010',10,'AHa','Rinne 2010','Kammerstein in situ','Kammerstein in situ','NULL',2.65396691063,0.45310716509,0.371561331325,0.966059461445,1, ST_GeomFromText('MULTIPOLYGON(((4458028.087399999 5793699.403699999,4458028.186599999 5793699.4077,4458028.3097 5793699.3878,4458028.432699999 5793699.352099999,4458028.595399999 5793699.296599999,4458028.8097 5793699.1815,4458028.881599999 5793699.101999999,4458028.8923 5793699.103199999,4458028.891099999 5793699.056099999,4458028.868099999 5793699.0128,4458028.832799999 5793698.9613,4458028.803 5793698.896199999,4458028.764999999 5793698.848799999,4458028.7176 5793698.8054,4458028.6566 5793698.774299999,4458028.5766 5793698.764799999,4458028.5224 5793698.779699999,4458028.415199999 5793698.799699999,4458028.391099999 5793698.8123,4458028.367899999 5793698.824599999,4458028.353299999 5793698.834499999,4458028.292999999 5793698.856,4458028.2509 5793698.865299999,4458028.207499999 5793698.876199999,4458028.158499999 5793698.905999999,4458028.115399999 5793698.931199999,4458028.076 5793698.966,4458028.035199999 5793698.996099999,4458028.016599999 5793699.0017,4458027.9731 5793699.012299999,4458027.902599999 5793699.059599999,4458027.8485 5793699.125199999,4458027.826299999 5793699.1754,4458027.8611 5793699.2507,4458027.9132 5793699.342399999,4458027.9888 5793699.388599999,4458028.087399999 5793699.403699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (434,435,313,'AHa010',10,'AHa','Rinne 2010','Kammerstein in situ','Kammerstein in situ','NULL',2.75829615478,0.513418599728,0.417784014832,1.08623843856,1, ST_GeomFromText('MULTIPOLYGON(((4458030.662499999 5793699.398099999,4458030.7981 5793699.320399999,4458030.873499999 5793699.2529,4458031.0481 5793699.114,4458031.1672 5793699.0307,4458031.194899999 5793698.931399999,4458031.186999999 5793698.840199999,4458031.1303 5793698.7169,4458031.1319 5793698.6564,4458031.126799999 5793698.6173,4458031.1079 5793698.5866,4458031.0465 5793698.5819,4458030.9402 5793698.5842,4458030.834999999 5793698.616,4458030.7602 5793698.6455,4458030.602199999 5793698.6994,4458030.495099999 5793698.758899999,4458030.4094 5793698.8208,4458030.366499999 5793698.939699999,4458030.3134 5793699.182399999,4458030.296 5793699.224799999,4458030.291899999 5793699.2905,4458030.3152 5793699.3365,4458030.345999999 5793699.382999999,4458030.394799999 5793699.395199999,4458030.4769 5793699.403899999,4458030.5705 5793699.4056,4458030.662499999 5793699.398099999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (435,436,313,'AHa010',10,'AHa','Rinne 2010','Stein','Stein','NULL',0.624081501189,0.0276656349878,0.0455029426547,0.118307650902,1, ST_GeomFromText('MULTIPOLYGON(((4458032.583599999 5793699.876599999,4458032.6046 5793699.8361,4458032.6079 5793699.7924,4458032.5771 5793699.759999999,4458032.520299999 5793699.737299999,4458032.4652 5793699.716299999,4458032.4198 5793699.725999999,4458032.415 5793699.7989,4458032.410099999 5793699.8604,4458032.436099999 5793699.886399999,4458032.5366 5793699.896099999,4458032.583599999 5793699.876599999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (436,437,313,'AHa010',10,'AHa','Rinne 2010','Kammerstein in situ','Kammerstein in situ','NULL',3.81800041106,0.839592404824,0.667763619057,1.73618540955,1, ST_GeomFromText('MULTIPOLYGON(((4458032.0827 5793700.4032,4458032.131299999 5793700.357799999,4458032.184799999 5793700.2703,4458032.222099999 5793700.163399999,4458032.2707 5793699.9787,4458032.283699999 5793699.8102,4458032.3048 5793699.648199999,4458032.324199999 5793699.4603,4458032.333599999 5793699.278599999,4458032.3272 5793699.213199999,4458032.320799999 5793699.160499999,4458032.302699999 5793699.1059,4458032.2417 5793699.0532,4458032.113499999 5793698.957699999,4458032.003399999 5793698.888599999,4458031.9506 5793698.8659,4458031.920599999 5793698.8668,4458031.898799999 5793698.8823,4458031.859699999 5793698.910399999,4458031.778699999 5793698.9677,4458031.7269 5793699.022299999,4458031.6599 5793699.1015,4458031.603699999 5793699.256899999,4458031.655299999 5793699.6458,4458031.786299999 5793700.141899999,4458031.865699999 5793700.391899999,4458031.921199999 5793700.506999999,4458032.0108 5793700.463199999,4458032.0827 5793700.4032)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (437,438,313,'AHa010',10,'AHa','Rinne 2010','Kammerstein','Kammerstein','NULL',0.147641255358,7.20750091925e-05,0.024355238287,0.0633236195463,1, ST_GeomFromText('MULTIPOLYGON(((4458029.5974 5793700.722999999,4458029.594299999 5793700.750199999,4458029.594299999 5793700.7967,4458029.5974 5793700.722999999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (438,439,313,'AHa010',10,'AHa','Rinne 2010','Kammerstein in situ','Kammerstein in situ','NULL',3.96527522684,1.13898468497,0.897217862562,2.33276644266,1, ST_GeomFromText('MULTIPOLYGON(((4458027.5948 5793700.856899999,4458027.6917 5793700.821699999,4458027.7685 5793700.749399999,4458027.774899999 5793700.733799999,4458027.813599999 5793700.665799999,4458027.853299999 5793700.590399999,4458027.8731 5793700.5031,4458027.884999999 5793700.4396,4458027.900899999 5793700.3364,4458027.932599999 5793700.1697,4458027.9604 5793699.9832,4458027.984199999 5793699.8562,4458027.980299999 5793699.7609,4458027.886699999 5793699.582299999,4458027.8273 5793699.544199999,4458027.773199999 5793699.502699999,4458027.705599999 5793699.455399999,4458027.647599999 5793699.4196,4458027.5926 5793699.400299999,4458027.5124 5793699.41,4458027.460199999 5793699.4196,4458027.4197 5793699.457299999,4458027.3579 5793699.5075,4458027.3026 5793699.584899999,4458027.2569 5793699.612999999,4458027.2023 5793699.625299999,4458027.1671 5793699.6552,4458027.1248 5793699.7168,4458027.063199999 5793699.846999999,4458026.978699999 5793700.043999999,4458026.9312 5793700.230499999,4458026.920599999 5793700.341399999,4458026.9347 5793700.394099999,4458027.005099999 5793700.5138,4458027.105499999 5793700.6651,4458027.1935 5793700.754799999,4458027.3185 5793700.8252,4458027.4188 5793700.8639,4458027.497999999 5793700.870899999,4458027.5948 5793700.856899999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (439,440,313,'AHa010',10,'AHa','Rinne 2010','Deckstein','Deckstein','NULL',6.44285239051,2.60820830005,2.02323084116,5.26040018701,1, ST_GeomFromText('MULTIPOLYGON(((4458031.294499999 5793700.911,4458031.439699999 5793700.9165,4458031.5498 5793700.902799999,4458031.6116 5793700.893999999,4458031.680499999 5793700.8728,4458031.744099999 5793700.8339,4458031.768799999 5793700.8167,4458031.8607 5793700.752699999,4458031.9472 5793700.659199999,4458032.000199999 5793700.5391,4458032.005499999 5793700.491399999,4458032.0108 5793700.463199999,4458032.005499999 5793700.401399999,4458031.9949 5793700.196599999,4458031.9225 5793699.8646,4458031.8448 5793699.5592,4458031.6945 5793699.1706,4458031.6599 5793699.1015,4458031.621199999 5793699.0932,4458031.6116 5793699.058599999,4458031.5811 5793699.046199999,4458031.5383 5793698.982599999,4458031.476099999 5793698.9218,4458031.417999999 5793698.9011,4458031.4017 5793698.8355,4458031.3338 5793698.798499999,4458031.2383 5793698.764599999,4458031.1874 5793698.733799999,4458031.158099999 5793698.7354,4458031.1303 5793698.7169,4458031.002399999 5793698.696799999,4458030.9006 5793698.6367,4458030.871299999 5793698.6629,4458030.8081 5793698.6675,4458030.754099999 5793698.679899999,4458030.751 5793698.7246,4458030.6447 5793698.756899999,4458030.5969 5793698.816999999,4458030.5475 5793698.9295,4458030.516699999 5793699.0251,4458030.508999999 5793699.0975,4458030.502799999 5793699.148399999,4458030.510499999 5793699.2177,4458030.5537 5793699.220799999,4458030.5969 5793699.2763,4458030.6632 5793699.334899999,4458030.662499999 5793699.398099999,4458030.660099999 5793699.612299999,4458030.6644 5793699.6874,4458030.655199999 5793699.767999999,4458030.6309 5793699.810499999,4458030.632399999 5793699.879,4458030.615699999 5793699.9671,4458030.601999999 5793700.0523,4458030.5974 5793700.1359,4458030.5776 5793700.1663,4458030.551799999 5793700.214999999,4458030.5503 5793700.3245,4458030.5959 5793700.479599999,4458030.629399999 5793700.517599999,4458030.6446 5793700.611899999,4458030.696299999 5793700.707599999,4458030.707999999 5793700.737199999,4458030.7196 5793700.766799999,4458030.744599999 5793700.7977,4458030.760099999 5793700.804899999,4458030.759399999 5793700.832499999,4458030.945799999 5793700.8968,4458031.0425 5793700.9142,4458031.183 5793700.918099999,4458031.294499999 5793700.911)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (440,441,313,'AHa010',10,'AHa','Rinne 2010','Kammerstein','Kammerstein','NULL',0.158672022932,0.000198080010807,0.0244518085203,0.0635747021527,1, ST_GeomFromText('MULTIPOLYGON(((4458029.582799999 5793700.9473,4458029.595499999 5793700.891,4458029.571499999 5793700.966199999,4458029.582799999 5793700.9473)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (441,442,313,'AHa010',10,'AHa','Rinne 2010','Kammerstein','Kammerstein','NULL',0.428292383503,0.000300640036569,0.024530410524,0.0637790673625,1, ST_GeomFromText('MULTIPOLYGON(((4458029.538999999 5793700.986199999,4458029.502999999 5793701.093399999,4458029.475899999 5793701.190799999,4458029.538999999 5793700.986199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (442,443,313,'AHa010',10,'AHa','Rinne 2010','Kammerstein in situ','Kammerstein in situ','NULL',1.54452185878,0.15558985494,0.143544064826,0.373214568548,1, ST_GeomFromText('MULTIPOLYGON(((4458028.2899 5793701.1983,4458028.356999999 5793701.196399999,4458028.465499999 5793701.182,4458028.486999999 5793701.1728,4458028.4976 5793701.1447,4458028.493099999 5793701.117799999,4458028.480299999 5793701.030899999,4458028.432699999 5793700.955499999,4458028.353299999 5793700.8999,4458028.269999999 5793700.8682,4458028.087399999 5793700.800699999,4458027.9965 5793700.898099999,4458027.979299999 5793700.920099999,4458027.9763 5793700.9528,4458027.975399999 5793700.978599999,4458027.964499999 5793700.9934,4458027.9418 5793701.020899999,4458027.9199 5793701.056299999,4458027.919499999 5793701.0711,4458027.962 5793701.087999999,4458027.9846 5793701.1037,4458028.042299999 5793701.141899999,4458028.0843 5793701.163799999,4458028.196499999 5793701.1914,4458028.257299999 5793701.198899999,4458028.2899 5793701.1983)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (443,444,313,'AHa010',10,'AHa','Rinne 2010','Kammerstein in situ','Kammerstein in situ','NULL',3.1012564082,0.5085733801,0.414070638508,1.07658366012,1, ST_GeomFromText('MULTIPOLYGON(((4458030.929999999 5793701.2189,4458031.0608 5793701.186599999,4458031.2171 5793701.147199999,4458031.3321 5793701.1105,4458031.4614 5793701.0371,4458031.6003 5793700.947699999,4458031.74 5793700.8538,4458031.769 5793700.833699999,4458031.768799999 5793700.8167,4458031.873599999 5793700.6618,4458031.849799999 5793700.558599999,4458031.706899999 5793700.542799999,4458031.5482 5793700.5864,4458031.3854 5793700.642,4458031.1195 5793700.697499999,4458030.988599999 5793700.685599999,4458030.909199999 5793700.677699999,4458030.8139 5793700.665799999,4458030.707999999 5793700.737199999,4458030.676199999 5793700.766499999,4458030.650899999 5793700.8452,4458030.645899999 5793700.8749,4458030.6528 5793700.921399999,4458030.655299999 5793700.991,4458030.682099999 5793701.024399999,4458030.706899999 5793701.0591,4458030.745 5793701.1556,4458030.795699999 5793701.201199999,4458030.8388 5793701.2214,4458030.8857 5793701.2278,4458030.929999999 5793701.2189)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (444,445,313,'AHa010',10,'AHa','Rinne 2010','Deckstein','Deckstein','NULL',7.1970319268,3.44109554963,2.66155562923,6.92004463601,1, ST_GeomFromText('MULTIPOLYGON(((4458029.4154 5793701.270099999,4458029.475899999 5793701.190799999,4458029.502999999 5793701.093399999,4458029.538999999 5793700.986199999,4458029.552 5793700.980799999,4458029.5612 5793700.971599999,4458029.571499999 5793700.966199999,4458029.595499999 5793700.891,4458029.607699999 5793700.8383,4458029.594299999 5793700.7967,4458029.594299999 5793700.750199999,4458029.5974 5793700.722999999,4458029.5979 5793700.718399999,4458029.594299999 5793700.658399999,4458029.601599999 5793700.6217,4458029.606499999 5793700.5898,4458029.595999999 5793700.571499999,4458029.5761 5793700.517799999,4458029.571299999 5793700.4714,4458029.5393 5793700.434599999,4458029.537499999 5793700.4045,4458029.540699999 5793700.3285,4458029.529099999 5793700.2758,4458029.517599999 5793700.246099999,4458029.5109 5793700.1972,4458029.505199999 5793700.150299999,4458029.4851 5793700.087099999,4458029.466799999 5793700.006599999,4458029.4544 5793699.9414,4458029.4707 5793699.899299999,4458029.480299999 5793699.881999999,4458029.4774 5793699.8418,4458029.474499999 5793699.822599999,4458029.474399999 5793699.796,4458029.4948 5793699.772199999,4458029.5016 5793699.741699999,4458029.504099999 5793699.7256,4458029.521099999 5793699.704399999,4458029.536299999 5793699.690899999,4458029.556699999 5793699.6587,4458029.5575 5793699.6409,4458029.550099999 5793699.5842,4458029.541699999 5793699.5423,4458029.522499999 5793699.497899999,4458029.5285 5793699.4583,4458029.498499999 5793699.397099999,4458029.474499999 5793699.357499999,4458029.4493 5793699.3131,4458029.442099999 5793699.244799999,4458029.402499999 5793699.2124,4458029.3677 5793699.174,4458029.326799999 5793699.166799999,4458029.2032 5793699.1524,4458029.1204 5793699.118799999,4458029.035199999 5793699.118799999,4458028.8923 5793699.103199999,4458028.881599999 5793699.101999999,4458028.7652 5793699.077999999,4458028.5826 5793699.028,4458028.464499999 5793699.024499999,4458028.4121 5793699.026799999,4458028.387099999 5793699.041099999,4458028.3382 5793699.038799999,4458028.300099999 5793699.0471,4458028.260099999 5793699.0623,4458028.218399999 5793699.102499999,4458028.148299999 5793699.196399999,4458028.0932 5793699.2992,4458028.0261 5793699.349899999,4458027.9888 5793699.388599999,4458027.991799999 5793699.3976,4458027.954499999 5793699.4437,4458027.963499999 5793699.466099999,4458027.9664 5793699.491399999,4458027.886699999 5793699.582299999,4458027.8069 5793699.6732,4458027.800999999 5793699.698599999,4458027.7707 5793699.709899999,4458027.747 5793699.777899999,4458027.7278 5793699.8416,4458027.7174 5793699.8682,4458027.7219 5793699.9008,4458027.747 5793699.9363,4458027.7515 5793699.996999999,4458027.744099999 5793700.022199999,4458027.749999999 5793700.097599999,4458027.7959 5793700.144999999,4458027.7959 5793700.1776,4458027.807799999 5793700.196799999,4458027.810899999 5793700.2564,4458027.816899999 5793700.2982,4458027.813299999 5793700.3484,4458027.807699999 5793700.3627,4458027.803799999 5793700.424,4458027.802199999 5793700.456599999,4458027.7894 5793700.4984,4458027.783499999 5793700.516699999,4458027.767799999 5793700.606399999,4458027.7587 5793700.6731,4458027.774899999 5793700.733799999,4458027.7992 5793700.745999999,4458027.820399999 5793700.7793,4458027.8629 5793700.8319,4458027.875099999 5793700.842,4458027.9965 5793700.898099999,4458028.117899999 5793700.954299999,4458028.2514 5793701.003799999,4458028.3607 5793701.047299999,4458028.440299999 5793701.069499999,4458028.4725 5793701.084699999,4458028.493099999 5793701.117799999,4458028.4976 5793701.1447,4458028.503899999 5793701.172399999,4458028.525399999 5793701.197399999,4458028.5728 5793701.225199999,4458028.605899999 5793701.230499999,4458028.625199999 5793701.256999999,4458028.6785 5793701.2927,4458028.7219 5793701.297599999,4458028.824199999 5793701.303899999,4458028.9587 5793701.307399999,4458029.013299999 5793701.313699999,4458029.0619 5793701.3167,4458029.120299999 5793701.3,4458029.1544 5793701.2993,4458029.2087 5793701.2993,4458029.261599999 5793701.298599999,4458029.294999999 5793701.3125,4458029.336699999 5793701.3209,4458029.4154 5793701.270099999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (445,446,313,'AHa010',10,'AHa','Rinne 2010','Kammerstein in situ','Kammerstein in situ','NULL',3.26300929514,0.619211290454,0.498863533004,1.29704518581,1, ST_GeomFromText('MULTIPOLYGON(((4458029.533699999 5793701.319199999,4458029.5723 5793701.3109,4458029.5974 5793701.297499999,4458029.6309 5793701.252199999,4458029.6611 5793701.2422,4458029.709699999 5793701.223799999,4458029.7516 5793701.205399999,4458029.8085 5793701.024499999,4458029.847099999 5793700.970899999,4458029.878899999 5793700.925699999,4458029.922399999 5793700.903899999,4458029.9358 5793700.858699999,4458029.904 5793700.833599999,4458029.823599999 5793700.776599999,4458029.773299999 5793700.748099999,4458029.738099999 5793700.731399999,4458029.701299999 5793700.719699999,4458029.650999999 5793700.726399999,4458029.5974 5793700.722999999,4458029.543899999 5793700.7015,4458029.4011 5793700.729299999,4458029.0915 5793700.780899999,4458028.849399999 5793700.820599999,4458028.7224 5793700.8999,4458028.662899999 5793700.999199999,4458028.599399999 5793701.1063,4458028.599399999 5793701.205499999,4458028.6518 5793701.2749,4458028.861399999 5793701.304899999,4458029.336699999 5793701.3209,4458029.372 5793701.315899999,4458029.393 5793701.315899999,4458029.4768 5793701.322599999,4458029.533699999 5793701.319199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (446,447,313,'AHa010',10,'AHa','Rinne 2010','Kammerstein in situ','Kammerstein in situ','NULL',2.67988713996,0.510294515012,0.415389716305,1.08001326239,1, ST_GeomFromText('MULTIPOLYGON(((4458030.153099999 5793701.5929,4458030.182199999 5793701.578999999,4458030.215099999 5793701.5676,4458030.242899999 5793701.556199999,4458030.293499999 5793701.5537,4458030.315 5793701.547399999,4458030.3441 5793701.5499,4458030.368099999 5793701.540999999,4458030.4175 5793701.505599999,4458030.470599999 5793701.4045,4458030.5427 5793701.300799999,4458030.5908 5793701.175599999,4458030.5996 5793701.133899999,4458030.6047 5793701.078199999,4458030.6287 5793701.042799999,4458030.655299999 5793700.991,4458030.6528 5793700.921399999,4458030.6376 5793700.880899999,4458030.547799999 5793700.845499999,4458030.371899999 5793700.839199999,4458030.178399999 5793700.8417,4458030.1303 5793700.8519,4458030.0455 5793700.845499999,4458029.9861 5793700.863199999,4458029.9582 5793700.8923,4458029.911399999 5793700.912599999,4458029.881099999 5793700.9315,4458029.824099999 5793701.011199999,4458029.745699999 5793701.266599999,4458029.7811 5793701.3602,4458029.851999999 5793701.424699999,4458030.025299999 5793701.539799999,4458030.1012 5793701.599199999,4458030.153099999 5793701.5929)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (447,448,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Bettstein','Bettstein','NULL',2.44956278371,0.379370939877,0.315049888322,0.819129709637,1, ST_GeomFromText('MULTIPOLYGON(((4455421.669999999 5793676.947699999,4455421.7653 5793676.9583,4455421.8923 5793676.942399999,4455422.0087 5793676.921199999,4455422.125099999 5793676.9318,4455422.304999999 5793676.894799999,4455422.4796 5793676.8471,4455422.5696 5793676.788899999,4455422.564299999 5793676.704299999,4455422.521999999 5793676.619599999,4455422.4214 5793676.5402,4455422.2997 5793676.492599999,4455422.172699999 5793676.460799999,4455422.019299999 5793676.445,4455421.823499999 5793676.492599999,4455421.6594 5793676.6037,4455421.5959 5793676.709499999,4455421.5853 5793676.857699999,4455421.669999999 5793676.947699999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (448,449,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Bettstein','Bettstein','NULL',3.15684384249,0.689465190352,0.552706121886,1.4370359169,1, ST_GeomFromText('MULTIPOLYGON(((4455419.489799999 5793677.434499999,4455419.847 5793677.569399999,4455419.934299999 5793677.5139,4455420.053399999 5793677.394799999,4455420.148599999 5793677.2519,4455420.2598 5793677.0614,4455420.299499999 5793676.8789,4455420.3074 5793676.7122,4455420.283599999 5793676.537599999,4455420.196299999 5793676.466099999,4455420.0137 5793676.466099999,4455419.847 5793676.5296,4455419.489799999 5793676.743899999,4455419.489799999 5793677.434499999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (449,450,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Bettstein','Bettstein','NULL',2.62012642272,0.510226759969,0.41533778884,1.07987825099,1, ST_GeomFromText('MULTIPOLYGON(((4455420.481999999 5793678.7363,4455420.6249 5793678.7521,4455420.743999999 5793678.7442,4455420.878899999 5793678.633099999,4455421.0853 5793678.4188,4455421.1567 5793678.2521,4455421.0932 5793678.0854,4455420.9027 5793677.9504,4455420.728099999 5793677.9504,4455420.5296 5793677.9901,4455420.355 5793678.0774,4455420.283599999 5793678.204399999,4455420.352199999 5793678.504899999,4455420.481999999 5793678.7363)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (450,451,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Bettstein','Bettstein','NULL',3.16937477464,0.703449379235,0.563423604246,1.46490137104,1, ST_GeomFromText('MULTIPOLYGON(((4455420.2263 5793679.5722,4455420.202499999 5793679.778599999,4455420.1946 5793680.0008,4455420.2263 5793680.254799999,4455420.281899999 5793680.413599999,4455420.496199999 5793680.484999999,4455420.599399999 5793680.477099999,4455420.718399999 5793680.318299999,4455420.8375 5793680.175499999,4455420.964499999 5793680.1358,4455421.0597 5793680.016699999,4455421.115299999 5793679.826199999,4455421.051799999 5793679.6754,4455420.885099999 5793679.5008,4455420.7264 5793679.4055,4455420.2263 5793679.5722)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (451,452,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Bettstein','Bettstein','NULL',3.88200001147,1.04617781484,0.826090677292,2.14783576096,1, ST_GeomFromText('MULTIPOLYGON(((4455421.2899 5793681.739199999,4455421.194699999 5793681.5645,4455421.0042 5793681.286699999,4455420.869199999 5793681.0883,4455420.718399999 5793680.8581,4455420.583499999 5793680.810499999,4455420.385099999 5793680.945399999,4455420.2581 5793681.080299999,4455420.1469 5793681.2232,4455420.115199999 5793681.3978,4455420.115199999 5793681.5963,4455420.1549 5793681.8662,4455420.265999999 5793682.0328,4455420.329499999 5793682.135999999,4455420.432699999 5793682.207499999,4455420.627899999 5793682.152699999,4455420.831699999 5793682.0601,4455421.2899 5793681.739199999)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (452,453,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Bettstein','Bettstein','NULL',3.91092232263,1.12278449465,0.8848020367,2.30048529542,1, ST_GeomFromText('MULTIPOLYGON(((4455420.7922 5793682.7322,4455420.669499999 5793682.9142,4455420.533999999 5793683.146999999,4455420.487399999 5793683.2719,4455420.4895 5793683.379899999,4455420.531899999 5793683.5174,4455420.6885 5793683.807399999,4455420.7838 5793683.934399999,4455420.923499999 5793684.048699999,4455421.0526 5793684.112199999,4455421.1436 5793684.1228,4455421.2537 5793684.0932,4455421.370099999 5793684,4455421.473799999 5793683.9154,4455421.564799999 5793683.809499999,4455421.607099999 5793683.6804,4455421.6643 5793683.5513,4455421.683299999 5793683.415799999,4455421.6664 5793683.290999999,4455421.569 5793683.146999999,4455421.241 5793682.9417,4455420.7922 5793682.7322)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (453,454,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Bettstein','Bettstein','NULL',2.5719694121,0.447409369495,0.367194540781,0.954705806031,1, ST_GeomFromText('MULTIPOLYGON(((4455421.8914 5793684.1698,4455421.8962 5793684.4175,4455421.893 5793684.542899999,4455421.902499999 5793684.596799999,4455421.946999999 5793684.666699999,4455421.9994 5793684.717499999,4455422.054899999 5793684.746099999,4455422.1073 5793684.728599999,4455422.1692 5793684.6937,4455422.308899999 5793684.625399999,4455422.432799999 5793684.533299999,4455422.510499999 5793684.472999999,4455422.583599999 5793684.4,4455422.632799999 5793684.3143,4455422.661399999 5793684.2365,4455422.6979 5793684.142799999,4455422.710599999 5793684.068199999,4455422.675599999 5793683.993599999,4455422.5947 5793683.937999999,4455422.416899999 5793683.9666,4455422.1518 5793684.025299999,4455421.8914 5793684.1698)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (454,455,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Bettstein','Bettstein','NULL',2.43851967998,0.438212980433,0.360146428204,0.936380713331,1, ST_GeomFromText('MULTIPOLYGON(((4455423.139999999 5793684.6314,4455423.3583 5793684.8298,4455423.520999999 5793684.8616,4455423.6599 5793684.8933,4455423.886099999 5793684.7385,4455423.9933 5793684.583699999,4455423.9615 5793684.4329,4455423.8464 5793684.270199999,4455423.723399999 5793684.147199999,4455423.600399999 5793684.1234,4455423.505099999 5793684.135299999,4455423.3305 5793684.2901,4455423.139999999 5793684.6314)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (455,456,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Bettstein','Bettstein','NULL',1.42250196865,0.125539800087,0.120513702786,0.313335627244,1, ST_GeomFromText('MULTIPOLYGON(((4455424.929499999 5793684.7321,4455424.9335 5793684.5535,4455424.8118 5793684.509899999,4455424.697999999 5793684.509899999,4455424.564399999 5793684.525699999,4455424.4466 5793684.5654,4455424.371199999 5793684.620999999,4455424.375199999 5793684.662,4455424.4188 5793684.6937,4455424.4599 5793684.722799999,4455424.5591 5793684.7467,4455424.631799999 5793684.7824,4455424.684799999 5793684.806199999,4455424.753499999 5793684.806199999,4455424.839499999 5793684.785,4455424.929499999 5793684.7321)))', 31468));
INSERT INTO "graeber_steine" ("PKUID","OBJECTID","MegaID","LDANr","OANr","OAGem","Quelle","Steintyp","SeinTyp1","SteinNrA","Shape_Leng","Shape_Area","Volumen","Gewicht","Auswahl","geometry")
  VALUES (456,457,270,'Alv033',33,'Alv','Preuss 1973 Abb.47','Bettstein','Bettstein','NULL',1.85505813738,0.215387704864,0.189373137007,0.492370156219,1, ST_GeomFromText('MULTIPOLYGON(((4455427.4528 5793684.2608,4455427.190899999 5793684.6497,4455427.278199999 5793684.7212,4455427.492499999 5793684.736999999,4455427.722699999 5793684.7291,4455427.8815 5793684.697399999,4455427.87349