/* Comment 
------------------------
Digital data from
C. Rinne, Die Megalithgräber im Haldensleber Forst, Landkreis Börde. 
		Frühe Monumentalität und Soziale Differenzierung Bd. 17 (Bonn 2019).
		https://d-nb.info/1180865057

Codepage UTF-8

Creates the tables and adds the data.
 */
begin transaction;
PRAGMA foreign_keys = OFF;
/* Comment 
------------------------
 Table for the evaluation parameters of the sites (megaliths)
 forein key for T_Wertung
 */
DROP TABLE IF EXISTS "WT_Erhaltung";
CREATE TABLE "WT_Erhaltung" (
"ErhaltID" INTEGER PRIMARY KEY  NOT NULL  UNIQUE , 
"Erhaltung" TEXT NOT NULL );
INSERT INTO "WT_Erhaltung" VALUES(-1,'rekonstruiert');
INSERT INTO "WT_Erhaltung" VALUES(0,'k.A.');
INSERT INTO "WT_Erhaltung" VALUES(1,'sehr gut');
INSERT INTO "WT_Erhaltung" VALUES(2,'gut (meisten Merkmale erkennbar)');
INSERT INTO "WT_Erhaltung" VALUES(3,'befriedigend (wesentliche Merkmale vorhanden)');
INSERT INTO "WT_Erhaltung" VALUES(4,'ausreichend (Denkmaltyp erkennbar)');
INSERT INTO "WT_Erhaltung" VALUES(5,'ungenügend (Reste erlauben lokalisierung)');
INSERT INTO "WT_Erhaltung" VALUES(6,'zerstört (nicht zu orten)');

/* Comment 
------------------------
 Table for the description of sites or features.
 Part of the GDB of the LDA LSA, reduced to used values.
 */
DROP TABLE IF EXISTS "WT_Fundart";
CREATE TABLE "WT_Fundart" (
"FundartID" INTEGER PRIMARY KEY NOT NULL , 
"Favorit" TEXT, 
"Kategorie" TEXT, 
"Fundart" TEXT, 
"Fundart_kurz" TEXT);
INSERT INTO "WT_Fundart" VALUES(110800,'0','Sdl','Burg','Burg');
INSERT INTO "WT_Fundart" VALUES(130250,'0','div','Landmarke/Flur > Menhir','Menhir');
INSERT INTO "WT_Fundart" VALUES(421000,'0','Grb','Grabmal > Grabhügel','Grabhügel');
INSERT INTO "WT_Fundart" VALUES(422000,'0','Grb','Grabmal > Megalithgrab','Megalithgrab');
INSERT INTO "WT_Fundart" VALUES(500000,'0','div','sonstiger Befund','sonstiger Befund');
INSERT INTO "WT_Fundart" VALUES(510100,'0','div','Einzelfund','Einzelfund');

/* Comment 
------------------------
 Table for the possible dimensions evaluated for each site (megalith).
 forein key for T_Masse.
"m_order": order of the dimensions in a report
"Mass": dimension evaluated
"n_count": current counting of evaluations for this dimension
 */
DROP TABLE IF EXISTS "WT_Masse";
CREATE TABLE "WT_Masse" (
"ID" INTEGER PRIMARY KEY  NOT NULL  UNIQUE , 
"m_order" INTEGER NOT NULL , 
"Mass" TEXT NOT NULL , 
"n_count" INTEGER);
INSERT INTO "WT_Masse" VALUES(1,14,'Decksteine erhalten',163);
INSERT INTO "WT_Masse" VALUES(2,15,'Decksteine rekostruiert',96);
INSERT INTO "WT_Masse" VALUES(3,16,'Joche nach Tragsteinen',73);
INSERT INTO "WT_Masse" VALUES(4,17,'Joche nach Tragsteinen rekonstr.',96);
INSERT INTO "WT_Masse" VALUES(5,12,'Kammersteine erhalten',104);
INSERT INTO "WT_Masse" VALUES(6,13,'Kammersteine rekonstruiert',15);
INSERT INTO "WT_Masse" VALUES(7,11,'Steine erhalten',118);
INSERT INTO "WT_Masse" VALUES(8,18,'Steine Umfassung',12);
INSERT INTO "WT_Masse" VALUES(9,19,'Steine Umfassung rekonstr.',2);
INSERT INTO "WT_Masse" VALUES(10,33,'Breite Deckstein',80);
INSERT INTO "WT_Masse" VALUES(11,28,'Breite Hügel',33);
INSERT INTO "WT_Masse" VALUES(12,22,'Breite Kammer außen',107);
INSERT INTO "WT_Masse" VALUES(13,21,'Breite Kammer innen',163);
INSERT INTO "WT_Masse" VALUES(14,25,'Breite Umfassung',70);
INSERT INTO "WT_Masse" VALUES(15,27,'Durchmesser Hügel',15);
INSERT INTO "WT_Masse" VALUES(16,31,'Höhe Tragstein',1);
INSERT INTO "WT_Masse" VALUES(17,32,'Länge Deckstein',165);
INSERT INTO "WT_Masse" VALUES(18,29,'Länge Hügel',42);
INSERT INTO "WT_Masse" VALUES(19,24,'Länge Kammer außen',105);
INSERT INTO "WT_Masse" VALUES(20,23,'Länge Kammer innen',98);
INSERT INTO "WT_Masse" VALUES(21,26,'Länge Umfassung',182);
INSERT INTO "WT_Masse" VALUES(22,30,'Resthöhe Hügel',75);

/* Comment 
 ------------------------
 Table for the activity, part of the GDB LSA (Grabungsdatenbank Land Sachsen-Anhalt). 
*/
DROP TABLE IF EXISTS "T_Aktivitaet";
CREATE TABLE "T_Aktivitaet" (
AktID INTEGER PRIMARY KEY, 
"AktivitaetsNr" INTEGER, 
"D_Nr" text, 
"Aktivitaetsart" integer, 
"Anlass" text, 
"Gebietsreferent" text, 
"Koordinator" text, 
"Bezeichnung" text, 
"Gemeinde" integer, 
"Lage" text, 
"Beginn" datetime, 
"EndeGelaende" datetime, 
"Ende" datetime, 
"TK25" text, 
"RW_110" integer, 
"HW_110" integer, 
"Investor" text, 
"Bemerkung" text);
INSERT INTO "T_Aktivitaet" VALUES(1,3365,'DFG RI-2028/1',30,'Forschungsprojekt','Dr. Fritsch, Barbara','Rinne, Christoph','Haldensleber Forst',212,'Hundisburg, Olbetal','5.8.2010 00:00:00','18.10.2010 00:00:00',NULL,'3734',4456000,579300,'DFG','Forschungsprojekt CAU Kiel');

/* Comment 
------------------------
 Table for persons taking part in the documentation, part of GDB LSA (Grabungsdatenbank Land Sachsen-Anhalt).
 */
DROP TABLE IF EXISTS "T_Bearbeiter";
CREATE TABLE "T_Bearbeiter" (
"AktivitaetsNr" integer, 
"Bearb_Kurz" text PRIMARY KEY, 
"Nachname" text, 
"Vorname" text, 
"Eintrag" datetime);
INSERT INTO "T_Bearbeiter" VALUES(0,'AB','Bock','Annalena','16.2.2012 18:04:28');
INSERT INTO "T_Bearbeiter" VALUES(0,'CR','Rinne','Christoph','16.2.2012 18:04:27');
INSERT INTO "T_Bearbeiter" VALUES(0,'KS','Schmütz','Kay','16.2.2012 18:04:36');
INSERT INTO "T_Bearbeiter" VALUES(0,'ML','Lindemann','Matthias','11.5.2012 09:22:18');

/* Comment 
------------------------
 Table for the description of each site in the GDB LSA (Grabungsdatenbank Land Sachsen-Anhalt). 
(site = Flaeche = Fundstelle)
  */
DROP TABLE IF EXISTS "T_Flaeche";
CREATE TABLE "T_Flaeche" (
"AktivitaetsNr" integer, 
"FundstelleID" INTEGER PRIMARY KEY, 
"F_Name" text, 
"RegBezirkID" integer, 
"GNR" integer, 
"GemeindeID" integer, 
"TK25ID" integer, 
"RW_110" integer, 
"HW_110" integer, 
"KOMessungID" integer, 
"Flurbezeichnung" text, 
"FundstelleZustandID" integer, 
"Grabungsleiter" text, 
"Grabungsbedingung" text, 
"Grabungsergebnis" text, 
"Geografie" text, 
"Eintrag" datetime, 
"ZustandVorBeginn" text,
FOREIGN KEY (AktivitaetsNr) REFERENCES T_Aktivitaet(AktivitaetsNr)
);
INSERT INTO "T_Flaeche" VALUES(3365,1,'Forst',1,15083270,212,82,0,0,100,NULL,5,'Rinne, Christoph',NULL,NULL,NULL,'16.2.2012 18:02:33',NULL);
INSERT INTO "T_Flaeche" VALUES(3365,10,'AHa',1,15083005,212,82,0,0,80,'Alt Haldensleben',5,'Rinne, Christoph',NULL,NULL,NULL,'23.4.2012 14:09:15',NULL);
INSERT INTO "T_Flaeche" VALUES(3365,11,'Alv',1,15083005,212,82,0,0,80,'Alvensleben (Bebertal I)',5,'Rinne, Christoph',NULL,NULL,NULL,'23.4.2012 14:10:07',NULL);
INSERT INTO "T_Flaeche" VALUES(3365,12,'Dön',1,15083005,212,82,0,0,80,'Dönsted (Bebertal II)',5,'Rinne, Christoph',NULL,NULL,NULL,'23.4.2012 14:11:28',NULL);
INSERT INTO "T_Flaeche" VALUES(3365,13,'Emd',1,15083005,212,82,0,0,80,'Emden',5,'Rinne, Christoph',NULL,NULL,NULL,'23.4.2012 14:11:51',NULL);
INSERT INTO "T_Flaeche" VALUES(3365,14,'Erx',1,15083005,212,82,0,0,80,'Erxleben',5,'Rinne, Christoph',NULL,NULL,NULL,'23.4.2012 14:12:05',NULL);
INSERT INTO "T_Flaeche" VALUES(3365,15,'Hun',1,15083005,212,82,0,0,80,'Hundisburg',5,'Rinne, Christoph',NULL,NULL,NULL,'23.4.2012 14:12:11',NULL);
INSERT INTO "T_Flaeche" VALUES(3365,16,'NHa',1,15083005,212,82,0,0,80,'Neu Haldensleben',5,'Rinne, Christoph',NULL,NULL,NULL,'23.4.2012 14:12:23',NULL);
INSERT INTO "T_Flaeche" VALUES(3365,17,'Süp',1,15083005,212,82,0,0,80,'Süpplingen',5,'Rinne, Christoph',NULL,NULL,NULL,'23.4.2012 14:12:29',NULL);
INSERT INTO "T_Flaeche" VALUES(3365,18,'Bod',1,15083005,450,82,0,0,80,'Bodendorf',5,'Rinne, Christoph',NULL,NULL,NULL,'23.4.2012 14:24:30',NULL);

/* Comment 
------------------------
 Table for the feature description, part of the GDB LSA (Grabungsdatenbank Land Sachsen-Anhalt).
 Only used for the handling of the fotos of the project.
 */
DROP TABLE IF EXISTS "T_Befundbeschreibung";
CREATE TABLE "T_Befundbeschreibung" (
"Bef_Nr" integer, 
"FundstelleID" integer, 
"AktivitaetsNr" integer, 
"Datum" datetime, 
"Schnitt" text, 
"Lage" text, 
"Siedlung" bool, 
"Grab" bool, 
"Hort" bool, 
"Sonst" bool, 
"FundartID" integer, 
"FundartTxt" text, 
"ZeitstellungID" integer, 
"ZeitSicher" bool, 
"Bearbeiter" text, 
"Profile" text, 
"Fundnummern" text, 
"unter" text, 
"gleichzeitig" text, 
"ueber" text, 
"Bemerkung" text, 
"Erfassungsdatum" datetime, 
"Endkontrolle" bool, 
"Merker" bool,
FOREIGN KEY (FundstelleID) REFERENCES T_Flaeche(FundstelleID)
FOREIGN KEY (FundartID) REFERENCES WT_Fundart(FundartID)
);
INSERT INTO "T_Befundbeschreibung" VALUES(1,10,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 428. Saal 17.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(1,11,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 429. Saal 40.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(1,17,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 426. Saal 4. Wegener 1896; Sage','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(1,18,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 303. Saal 0. Beier 1991, 49; Emden 1930','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(2,10,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 427. Saal 13.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(2,11,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 425. Saal 47.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(2,17,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 344. Saal 6.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(3,11,NULL,NULL,NULL,'leicht exponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 242. Saal 33.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(3,17,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 345. Saal 111. Wegener 1896','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(4,11,NULL,NULL,NULL,'leicht exponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 243. Saal 32.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(4,12,NULL,NULL,NULL,'exponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 292. Saal 69. Bericht G. Maas','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(4,17,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 346. Saal 112. Wegener 1896','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(5,11,NULL,NULL,NULL,'sehr exponiert',0,1,0,0,422000,'Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 244. Saal 31.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(5,12,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 293. Saal 96. Schlette 1962; Beier 1984, 90 (24)a','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(5,16,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 506. Saal 118. Beier 1991, 49','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(5,17,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 281. Saal 5. Beier 1991, 51','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(6,11,NULL,NULL,NULL,'sehr exponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 246. Saal 39.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(6,15,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 333. Saal 105.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(6,17,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',32040,0,'CR',NULL,NULL,NULL,NULL,NULL,'MegaID: 347. Saal 0.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(7,12,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 294. Saal 62.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(8,10,NULL,NULL,NULL,NULL,0,1,0,0,422000,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 311. Saal 0.','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(8,12,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 295. Saal 97. Schlette 1962; Beier 1984, 90 (24b)','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(9,10,NULL,NULL,NULL,'exponiert',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 312. Saal 29.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(9,12,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 296. Saal 98. Schlette 1962; Beier 1984, 91 (24c)','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(9,16,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 307. Saal 0.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(10,10,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 313. Saal 22. Wegener 1896','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(10,11,NULL,NULL,NULL,'leichte Hanglage',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 247. Saal 44.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(10,12,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 297. Saal 80.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(10,16,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 308. Saal 1.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(11,10,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 314. Saal 27.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(11,11,NULL,NULL,NULL,'leichte Hanglage',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 248. Saal 43.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(11,12,NULL,NULL,NULL,'leicht exponiert',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 298. Saal 83.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(11,16,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 309. Saal 7. Wegener 1896','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(12,10,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 315. Saal 26.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(12,11,NULL,NULL,NULL,'exponiert',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 249. Saal 35.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(12,12,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 299. Saal 0.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(12,13,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 422. Saal 59.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(12,16,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 310. Saal 123.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(13,10,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 316. Saal 26.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(13,11,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 250. Saal 42.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(13,12,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 300. Saal 99. Schlette 1962','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(13,15,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 334. Saal 0.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(14,10,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 317. Saal 25.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(14,11,NULL,NULL,NULL,'leichte Hanglage',0,1,0,0,422000,'Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 251. Saal 85. Preuß 1973','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(14,12,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 301. Saal 84. Bericht Mewes','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(14,15,NULL,NULL,NULL,'leicht exponiert',0,1,0,0,422000,'Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 335. Saal 57.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(15,10,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 318. Saal 30.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(15,11,NULL,NULL,NULL,'Niederung',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 252. Saal 38.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(15,12,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 302. Saal 100.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(15,13,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 438. Saal 113.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(15,15,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 336. Saal 82.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(16,10,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 319. Saal 37.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(16,11,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 253. Saal 41.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(16,12,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 430. Saal 101.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(16,13,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 439. Saal 114.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(16,15,NULL,NULL,NULL,'exponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 337. Saal 34.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(17,10,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 320. Saal 46.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(17,11,NULL,NULL,NULL,'Niederung',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 254. Saal 48.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(17,12,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 431. Saal 101.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(17,13,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 440. Saal 115.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(17,15,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 338. Saal 28.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(18,10,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 321. Saal 21.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(18,11,NULL,NULL,NULL,'nicht expponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 255. Saal 54.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(18,12,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 432. Saal 101.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(18,15,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 339. Saal 36.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(19,10,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 322. Saal 18.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(19,11,NULL,NULL,NULL,'exponiert',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 258. Saal 56.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(19,12,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 433. Saal 102.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(19,15,NULL,NULL,NULL,'sehr exponiert',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 340. Saal 23.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(20,10,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 323. Saal 19.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(20,11,NULL,NULL,NULL,'leichte Hanglage',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 257. Saal 58.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(20,12,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 434. Saal 103.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(20,15,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 341. Saal 107.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(21,10,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 324. Saal 16. Wegener 1896','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(21,11,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 256. Saal 55. Wegener 1896','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(21,12,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 435. Saal 104.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(21,15,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 342. Saal 108.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(22,10,NULL,NULL,NULL,'leicht exponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 325. Saal 15.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(22,11,NULL,NULL,NULL,'exponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 259. Saal 61.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(22,15,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 423. Saal 60.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(23,10,NULL,NULL,NULL,'leicht exponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 326. Saal 14.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(23,11,NULL,NULL,NULL,'leicht exponiert',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 260. Saal 63.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(23,15,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 453. Saal 0.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(24,10,NULL,NULL,NULL,'leichte Hanglage',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 327. Saal 12.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(24,11,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 261. Saal 92.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(24,15,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 437. Saal 110.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(25,10,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 328. Saal 10.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(25,11,NULL,NULL,NULL,'leicht exponiert',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 262. Saal 67.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(25,15,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 436. Saal 109.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(26,10,NULL,NULL,NULL,'leichte Hanglage',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 329. Saal 11.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(26,11,NULL,NULL,NULL,'leichte Hanglage',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 263. Saal 74.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(26,15,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 507. Saal 120.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(27,10,NULL,NULL,NULL,'leicht exponiert',0,1,0,0,422000,'Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 330. Saal 8.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(27,11,NULL,NULL,NULL,'leichte Hanglage',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 264. Saal 76.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(27,15,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 508. Saal 120.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(28,10,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 331. Saal 24.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(28,11,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 265. Saal 77.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(28,15,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 445. Saal 121.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(29,10,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 332. Saal 116. Wegener 1896','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(29,11,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 266. Saal 75.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(29,15,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 446. Saal 121.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(30,10,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 441. Saal 117.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(30,11,NULL,NULL,NULL,'leicht exponiert',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 267. Saal 79.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(30,15,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 454. Saal 0.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(30,16,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 442. Saal 0.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(31,10,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 419. Saal 66.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(31,11,NULL,NULL,NULL,'nicht exponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 268. Saal 78.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(32,10,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 421. Saal 70.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(32,11,NULL,NULL,NULL,'exponiert',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 269. Saal 81.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(33,10,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 418. Saal 65.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(33,11,NULL,NULL,NULL,'natürliche Anhöhe',0,1,0,0,422000,'Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 270. Saal 86. Preuß 1973; G.Maas 1900','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(34,10,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 420. Saal 68.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(34,11,NULL,NULL,NULL,'leichte Hanglage',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 271. Saal 20.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(35,10,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 447. Saal 0.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(35,11,NULL,NULL,NULL,'exponiert',0,1,0,0,422000,'Großdolmen/Ganggrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 272. Saal 9.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(35,15,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 455. Saal 109.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(36,11,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 273. Saal 49.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(37,11,NULL,NULL,NULL,'Niederung',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 274. Saal 50.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(37,15,NULL,NULL,NULL,NULL,0,1,0,0,500000,'Lesesteinhaufen',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 456. Saal 0.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(38,11,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 275. Saal 51.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(39,11,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 276. Saal 88. Preuß 1973','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(40,11,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 277. Saal 89. Preuß 1973','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(41,11,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 284. Saal 73.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(42,10,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 424. Saal 0.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(42,11,NULL,NULL,NULL,'natürliche kleine Anhöhe',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 285. Saal 90. Preuß 1973','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(43,11,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 286. Saal 91.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(44,11,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 287. Saal 72.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(44,13,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 450. Saal 0.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(45,11,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 288. Saal 71.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(45,13,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 451. Saal 0.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(46,11,NULL,NULL,NULL,'nicht gefunden',0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 289. Saal 45.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(47,11,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 290. Saal 93.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(48,11,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 291. Saal 94.  ','16.2.2012 18:27:49',0,0);
INSERT INTO "T_Befundbeschreibung" VALUES(52,11,NULL,NULL,NULL,NULL,0,1,0,0,422000,'Megalithgrab',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MegaID: 449. Saal 0.  ','16.2.2012 18:27:49',0,0);

/* Comment 
------------------------
 Table for the documentation of the pictures, part of the GDB LSA (Grabungsdatenbank Land Sachsen-Anhalt).
 Used to handle the pictures of the project.
 */
DROP TABLE IF EXISTS "T_Fotoliste";
CREATE TABLE "T_Fotoliste" (
"FotoID" INTEGER PRIMARY KEY AUTOINCREMENT, 
"Datum" datetime, 
"Film_Nr" integer, 
"Bild_Nr" integer, 
"Bild_a" text, 
"Bef_Nr" text, 
"AktivitaetsNr" integer, 
"FundstelleID" integer, 
"Schnitt" text, 
"Format_Code" integer, 
"Planum" text, 
"Profil" text, 
"FundNr" text, 
"Blickrichtung" text, 
"Bildinhalt" text, 
"Fehler" bool, 
"chic" bool, 
"Pfad" text, 
"Dateiname" text, 
"Verbleib" text, 
"Merker" bool, 
"BAutor" text, 
"DS_Datum" datetime, 
"istMessbild" bool, 
"Fundfoto" bool, 
"Dublette" bool, 
"loeschen" bool, 
"Bildkennung" text, 
"origDateiname" text);
INSERT INTO "T_Fotoliste" VALUES(1,'30.4.2009 11:18:13',1,1,NULL,'3',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A03: Bebertal I 3. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0001.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0001','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A03.tif');
INSERT INTO "T_Fotoliste" VALUES(2,'30.4.2009 11:16:13',1,2,NULL,'4',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A04: Bebertal I 4. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0002.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0002','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A04.tif');
INSERT INTO "T_Fotoliste" VALUES(3,'30.4.2009 07:59:34',1,3,NULL,'5',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A05: Bebertal I 5. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0003.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0003','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A05.tif');
INSERT INTO "T_Fotoliste" VALUES(4,'30.4.2009 11:21:13',1,4,NULL,'6',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A06: Bebertal I 6. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0004.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0004','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A06.tif');
INSERT INTO "T_Fotoliste" VALUES(5,'30.4.2009 11:25:56',1,5,NULL,'10',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A10: Bebertal I 10. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0005.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0005','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A10.tif');
INSERT INTO "T_Fotoliste" VALUES(6,'30.4.2009 11:25:29',1,6,NULL,'11',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A11: Bebertal I 11. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0006.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0006','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A11.tif');
INSERT INTO "T_Fotoliste" VALUES(7,'30.4.2009 11:19:26',1,7,NULL,'12',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A12: Bebertal I 12. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0007.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0007','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A12.tif');
INSERT INTO "T_Fotoliste" VALUES(8,'30.4.2009 11:25:09',1,8,NULL,'13',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A13: Bebertal I 13. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0008.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0008','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A13.tif');
INSERT INTO "T_Fotoliste" VALUES(9,'30.4.2009 12:14:21',1,9,NULL,'14',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A14: Bebertal I 14. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0009.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0009','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A14.tif');
INSERT INTO "T_Fotoliste" VALUES(10,'30.4.2009 11:20:34',1,10,NULL,'15',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A15: Bebertal I 15. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0010.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0010','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A15.tif');
INSERT INTO "T_Fotoliste" VALUES(11,'30.4.2009 11:24:41',1,11,NULL,'16',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A16: Bebertal I 16. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0011.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0011','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A16.tif');
INSERT INTO "T_Fotoliste" VALUES(12,'30.4.2009 11:29:47',1,12,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A17: Bebertal I 17. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0012.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0012','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A17.tif');
INSERT INTO "T_Fotoliste" VALUES(13,'30.4.2009 11:32:42',1,13,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A18: Bebertal I 18. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0013.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0013','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A18.tif');
INSERT INTO "T_Fotoliste" VALUES(14,'30.4.2009 11:33:04',1,14,NULL,'19',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A19: Bebertal I 19. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0014.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0014','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A19.tif');
INSERT INTO "T_Fotoliste" VALUES(15,'30.4.2009 12:06:11',1,15,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A20: Bebertal I 20. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0015.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0015','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A20.tif');
INSERT INTO "T_Fotoliste" VALUES(16,'30.4.2009 12:04:46',1,16,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A21: Bebertal I 21. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0016.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0016','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A21.tif');
INSERT INTO "T_Fotoliste" VALUES(17,'30.4.2009 12:06:48',1,17,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A22: Bebertal I 22. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0017.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0017','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A22.tif');
INSERT INTO "T_Fotoliste" VALUES(18,'30.4.2009 12:07:32',1,18,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A23: Bebertal I 23. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0018.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0018','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A23.tif');
INSERT INTO "T_Fotoliste" VALUES(19,'30.4.2009 12:08:07',1,19,NULL,'25',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A25: Bebertal I 25. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0019.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0019','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A25.tif');
INSERT INTO "T_Fotoliste" VALUES(20,'30.4.2009 12:10:19',1,20,NULL,'26',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A26: Bebertal I 26. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0020.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0020','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A26.tif');
INSERT INTO "T_Fotoliste" VALUES(21,'30.4.2009 12:11:01',1,21,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A27: Bebertal I 27. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0021.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0021','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A27.tif');
INSERT INTO "T_Fotoliste" VALUES(22,'30.4.2009 12:11:29',1,22,NULL,'28',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A28: Bebertal I 28. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0022.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0022','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A28.tif');
INSERT INTO "T_Fotoliste" VALUES(23,'30.4.2009 12:10:37',1,23,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A29: Bebertal I 29. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0023.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0023','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A29.tif');
INSERT INTO "T_Fotoliste" VALUES(24,'30.4.2009 12:12:02',1,24,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A30: Bebertal I 30. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0024.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0024','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A30.tif');
INSERT INTO "T_Fotoliste" VALUES(25,'30.4.2009 12:11:46',1,25,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A31: Bebertal I 31. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0025.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0025','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A31.tif');
INSERT INTO "T_Fotoliste" VALUES(26,'30.4.2009 12:12:55',1,26,NULL,'32',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A32: Bebertal I 32. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0026.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0026','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A32.tif');
INSERT INTO "T_Fotoliste" VALUES(27,'30.4.2009 07:43:18',1,27,NULL,'34',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A34: Bebertal I 34. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0027.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0027','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A34.tif');
INSERT INTO "T_Fotoliste" VALUES(28,'30.4.2009 11:30:17',1,28,NULL,'36',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A36: Bebertal I 36. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0028.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0028','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A36.tif');
INSERT INTO "T_Fotoliste" VALUES(29,'30.4.2009 11:30:39',1,29,NULL,'37',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A37: Bebertal I 37. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0029.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0029','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A37.tif');
INSERT INTO "T_Fotoliste" VALUES(30,'30.4.2009 11:31:07',1,30,NULL,'38',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A38: Bebertal I 38. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0030.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0030','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A38.tif');
INSERT INTO "T_Fotoliste" VALUES(31,'30.4.2009 07:31:55',1,31,NULL,'39',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A39: Bebertal I 39. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0031.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0031','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A39.tif');
INSERT INTO "T_Fotoliste" VALUES(32,'30.4.2009 11:26:33',1,32,NULL,'46',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A46: Bebertal I 46. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0032.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0032','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_A46.tif');
INSERT INTO "T_Fotoliste" VALUES(33,'30.4.2009 07:44:44',1,33,NULL,'10',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH10: Haldensleben II (Alt) 10. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0033.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0033','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_AH10.tif');
INSERT INTO "T_Fotoliste" VALUES(34,'30.4.2009 07:54:43',1,34,NULL,'11',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH11: Haldensleben II (Alt) 11. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0034.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0034','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_AH11.tif');
INSERT INTO "T_Fotoliste" VALUES(35,'30.4.2009 07:51:51',1,35,NULL,'12',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH12: Haldensleben II (Alt) 12. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0035.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0035','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_AH12.tif');
INSERT INTO "T_Fotoliste" VALUES(36,'30.4.2009 07:53:48',1,36,NULL,'13',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH13: Haldensleben II (Alt) 13. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0036.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0036','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_AH13.tif');
INSERT INTO "T_Fotoliste" VALUES(37,'30.4.2009 07:51:14',1,37,NULL,'14',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH14: Haldensleben II (Alt) 14. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0037.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0037','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_AH14.tif');
INSERT INTO "T_Fotoliste" VALUES(38,'30.4.2009 07:57:34',1,38,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH15: Haldensleben II (Alt) 15. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0038.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0038','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_AH15.tif');
INSERT INTO "T_Fotoliste" VALUES(39,'30.4.2009 11:20:12',1,39,NULL,'16',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH16: Haldensleben II (Alt) 16. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0039.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0039','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_AH16.tif');
INSERT INTO "T_Fotoliste" VALUES(40,'30.4.2009 11:27:16',1,40,NULL,'17',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH17: Haldensleben II (Alt) 17. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0040.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0040','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_AH17.tif');
INSERT INTO "T_Fotoliste" VALUES(41,'30.4.2009 07:43:58',1,41,NULL,'18',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH18: Haldensleben II (Alt) 18. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0041.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0041','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_AH18.tif');
INSERT INTO "T_Fotoliste" VALUES(42,'30.4.2009 07:42:45',1,42,NULL,'20',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH20: Haldensleben II (Alt) 20. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0042.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0042','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_AH20.tif');
INSERT INTO "T_Fotoliste" VALUES(43,'30.4.2009 07:41:30',1,43,NULL,'21',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH21: Haldensleben II (Alt) 21. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0043.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0043','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_AH21.tif');
INSERT INTO "T_Fotoliste" VALUES(44,'30.4.2009 07:40:59',1,44,NULL,'22',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH22: Haldensleben II (Alt) 22. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0044.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0044','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_AH22.tif');
INSERT INTO "T_Fotoliste" VALUES(45,'30.4.2009 07:35:25',1,45,NULL,'23',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH23: Haldensleben II (Alt) 23. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0045.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0045','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_AH23.tif');
INSERT INTO "T_Fotoliste" VALUES(46,'30.4.2009 07:34:46',1,46,NULL,'25',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH25: Haldensleben II (Alt) 25. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0046.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0046','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_AH25.tif');
INSERT INTO "T_Fotoliste" VALUES(47,'30.4.2009 07:13:59',1,47,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH27: Haldensleben II (Alt) 27. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0047.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0047','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_AH27.tif');
INSERT INTO "T_Fotoliste" VALUES(48,'30.4.2009 07:49:18',1,48,NULL,'28',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH28: Haldensleben II (Alt) 28. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0048.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0048','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_AH28.tif');
INSERT INTO "T_Fotoliste" VALUES(49,'30.4.2009 12:08:44',1,49,NULL,'4',3365,12,NULL,3,NULL,NULL,NULL,NULL,'Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0049.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0049','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_D04.tif');
INSERT INTO "T_Fotoliste" VALUES(50,'30.4.2009 12:07:12',1,50,NULL,'7',3365,12,NULL,3,NULL,NULL,NULL,NULL,'Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0050.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0050','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_D07.tif');
INSERT INTO "T_Fotoliste" VALUES(51,'30.4.2009 12:12:29',1,51,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,NULL,'D10: Bebertal II 10. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0051.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0051','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_D10.tif');
INSERT INTO "T_Fotoliste" VALUES(52,'30.4.2009 12:13:29',1,52,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,'D11: Bebertal II 11. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0052.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0052','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_D11.tif');
INSERT INTO "T_Fotoliste" VALUES(53,'30.4.2009 12:13:44',1,53,NULL,'14',3365,12,NULL,3,NULL,NULL,NULL,NULL,'D14: Bebertal II 14. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0053.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0053','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_D14.tif');
INSERT INTO "T_Fotoliste" VALUES(54,'30.4.2009 12:05:18',1,54,NULL,'14',3365,15,NULL,3,NULL,NULL,NULL,NULL,'H14: Hundisburg 14. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0054.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0054','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_H14.tif');
INSERT INTO "T_Fotoliste" VALUES(55,'30.4.2009 12:13:14',1,55,NULL,'15',3365,15,NULL,3,NULL,NULL,NULL,NULL,'H15: Hundisburg 15. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0055.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0055','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_H15.tif');
INSERT INTO "T_Fotoliste" VALUES(56,'30.4.2009 11:18:40',1,56,NULL,'16',3365,15,NULL,3,NULL,NULL,NULL,NULL,'H16: Hundisburg 16. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0056.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0056','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_H16.tif');
INSERT INTO "T_Fotoliste" VALUES(57,'30.4.2009 07:55:45',1,57,NULL,'17',3365,15,NULL,3,NULL,NULL,NULL,NULL,'H17: Hundisburg 17. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0057.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0057','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_H17.tif');
INSERT INTO "T_Fotoliste" VALUES(58,'30.4.2009 11:19:50',1,58,NULL,'18',3365,15,NULL,3,NULL,NULL,NULL,NULL,'H18: Hundisburg 18. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0058.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0058','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_H18.tif');
INSERT INTO "T_Fotoliste" VALUES(59,'30.4.2009 07:48:40',1,59,NULL,'19',3365,15,NULL,3,NULL,NULL,NULL,NULL,'H19: Hundisburg 19. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0059.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0059','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_H19.tif');
INSERT INTO "T_Fotoliste" VALUES(60,'17.4.2009 10:23:23',1,60,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,'Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0060.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0060','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_NH09.tif');
INSERT INTO "T_Fotoliste" VALUES(61,'17.4.2009 10:17:38',1,61,NULL,'10',3365,16,NULL,3,NULL,NULL,NULL,NULL,'NH10: Haldensleben I (Neu) 10. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0061.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0061','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_NH10.tif');
INSERT INTO "T_Fotoliste" VALUES(62,'17.4.2009 10:26:09',1,62,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,'S01: Süplingen 1. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0062.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0062','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_S01.tif');
INSERT INTO "T_Fotoliste" VALUES(63,'30.4.2009 07:12:31',1,63,NULL,'26',3365,10,NULL,3,NULL,NULL,NULL,NULL,'Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0063.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0063','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_S01b.tif');
INSERT INTO "T_Fotoliste" VALUES(64,'30.4.2009 07:13:07',1,64,NULL,'2',3365,17,NULL,3,NULL,NULL,NULL,NULL,'S02: Süplingen 2. Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal.',0,0,NULL,'003365_0001_0064.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0064','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_S02.tif');
INSERT INTO "T_Fotoliste" VALUES(65,'30.4.2009 11:32:07',1,65,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,'Planskizze von Stuhlmann nach der Sammlung/Dokumenatation von Saal. Kein Megalithgrab sonder Teil der Burg Wichmannsdorf.',0,0,NULL,'003365_0001_0065.jpg',NULL,0,'Stuhlmann',NULL,0,0,0,0,'003365_0001_0065','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Saal_Saal53.tif');
INSERT INTO "T_Fotoliste" VALUES(66,'4.5.2009 20:05:19',1,66,NULL,'3',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A03: Bebertal I 3. Planskizze von Worschech.',0,0,NULL,'003365_0001_0066.jpg',NULL,0,'Worschech',NULL,0,0,0,0,'003365_0001_0066','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Worschech_A03.tif');
INSERT INTO "T_Fotoliste" VALUES(67,'4.5.2009 20:05:05',1,67,NULL,'16',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A16: Bebertal I 16. Planskizze von Worschech.',0,0,NULL,'003365_0001_0067.jpg',NULL,0,'Worschech',NULL,0,0,0,0,'003365_0001_0067','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Worschech_A16.tif');
INSERT INTO "T_Fotoliste" VALUES(68,'4.5.2009 20:34:38',1,68,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A18: Bebertal I 18. Planskizze von Worschech.',0,0,NULL,'003365_0001_0068.jpg',NULL,0,'Worschech',NULL,0,0,0,0,'003365_0001_0068','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Worschech_A18.tif');
INSERT INTO "T_Fotoliste" VALUES(69,'4.5.2009 20:19:33',1,69,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A21: Bebertal I 21. Planskizze von Worschech.',0,0,NULL,'003365_0001_0069.jpg',NULL,0,'Worschech',NULL,0,0,0,0,'003365_0001_0069','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Worschech_A21.tif');
INSERT INTO "T_Fotoliste" VALUES(70,'4.5.2009 20:18:16',1,70,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,NULL,'A27: Bebertal I 27. Planskizze von Worschech.',0,0,NULL,'003365_0001_0070.jpg',NULL,0,'Worschech',NULL,0,0,0,0,'003365_0001_0070','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Worschech_A27.tif');
INSERT INTO "T_Fotoliste" VALUES(71,'4.5.2009 20:20:27',1,71,NULL,'10',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH10: Haldensleben II (Alt) 10. Planskizze von Worschech.',0,0,NULL,'003365_0001_0071.jpg',NULL,0,'Worschech',NULL,0,0,0,0,'003365_0001_0071','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Worschech_AH10.tif');
INSERT INTO "T_Fotoliste" VALUES(72,'4.5.2009 20:20:05',1,72,NULL,'18',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH18: Haldensleben II (Alt) 18. Planskizze von Worschech.',0,0,NULL,'003365_0001_0072.jpg',NULL,0,'Worschech',NULL,0,0,0,0,'003365_0001_0072','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Worschech_AH18.tif');
INSERT INTO "T_Fotoliste" VALUES(73,'4.5.2009 20:17:43',1,73,NULL,'25',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH25: Haldensleben II (Alt) 25. Planskizze von Worschech.',0,0,NULL,'003365_0001_0073.jpg',NULL,0,'Worschech',NULL,0,0,0,0,'003365_0001_0073','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Worschech_AH25.tif');
INSERT INTO "T_Fotoliste" VALUES(74,'4.5.2009 20:26:06',1,74,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,'AH27: Haldensleben II (Alt) 27. Planskizze von Worschech.',0,0,NULL,'003365_0001_0074.jpg',NULL,0,'Worschech',NULL,0,0,0,0,'003365_0001_0074','P:\SPP_Monumental\3365_Megalithgraber\Fotos\stuhlmann\Worschech_AH27.tif');
INSERT INTO "T_Fotoliste" VALUES(75,'22.3.2010 16:13:16',2,1,NULL,'3',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0001.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0001','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(76,'22.3.2010 16:13:34',2,2,NULL,'3',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0002.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0002','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(77,'22.3.2010 16:13:42',2,3,NULL,'3',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0003.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0003','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(78,'22.3.2010 16:13:44',2,4,NULL,'3',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0004.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0004','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_007.JPG');
INSERT INTO "T_Fotoliste" VALUES(79,'22.3.2010 16:13:56',2,5,NULL,'3',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0005.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0005','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_008.JPG');
INSERT INTO "T_Fotoliste" VALUES(80,'22.3.2010 16:30:52',2,6,NULL,'3',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0006.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0006','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_009.JPG');
INSERT INTO "T_Fotoliste" VALUES(81,'22.3.2010 16:30:54',2,7,NULL,'3',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0007.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0007','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_010.JPG');
INSERT INTO "T_Fotoliste" VALUES(82,'22.3.2010 16:53:40',2,8,NULL,'3',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0008.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0008','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_014.JPG');
INSERT INTO "T_Fotoliste" VALUES(83,'22.3.2010 16:53:42',2,9,NULL,'3',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0009.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0009','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_015.JPG');
INSERT INTO "T_Fotoliste" VALUES(84,'22.3.2010 16:54:00',2,10,NULL,'3',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0010.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0010','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_016.JPG');
INSERT INTO "T_Fotoliste" VALUES(85,'22.3.2010 16:54:12',2,11,NULL,'3',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0011.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0011','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_017.JPG');
INSERT INTO "T_Fotoliste" VALUES(86,'22.3.2010 16:56:06',2,12,NULL,'3',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0012.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0012','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_021.JPG');
INSERT INTO "T_Fotoliste" VALUES(87,'22.3.2010 16:56:08',2,13,NULL,'3',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0013.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0013','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_022.JPG');
INSERT INTO "T_Fotoliste" VALUES(88,'22.3.2010 17:02:56',2,15,NULL,'5',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0015.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0015','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_026.JPG');
INSERT INTO "T_Fotoliste" VALUES(89,'22.3.2010 17:06:26',2,16,NULL,'6',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0016.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0016','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_027.JPG');
INSERT INTO "T_Fotoliste" VALUES(90,'22.3.2010 17:06:28',2,17,NULL,'6',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0017.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0017','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_028.JPG');
INSERT INTO "T_Fotoliste" VALUES(91,'22.3.2010 17:06:28',2,18,NULL,'6',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0018.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0018','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_029.JPG');
INSERT INTO "T_Fotoliste" VALUES(92,'22.3.2010 17:06:52',2,19,NULL,'6',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0019.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0019','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_030.JPG');
INSERT INTO "T_Fotoliste" VALUES(93,'22.3.2010 16:07:14',2,20,NULL,'6',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0020.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0020','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_032.JPG');
INSERT INTO "T_Fotoliste" VALUES(94,'22.3.2010 16:07:18',2,21,NULL,'6',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0021.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0021','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_034.JPG');
INSERT INTO "T_Fotoliste" VALUES(95,'22.3.2010 16:07:30',2,22,NULL,'6',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0022.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0022','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_035.JPG');
INSERT INTO "T_Fotoliste" VALUES(96,'22.3.2010 16:08:38',2,23,NULL,'6',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0023.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0023','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_037.JPG');
INSERT INTO "T_Fotoliste" VALUES(97,'22.3.2010 16:08:38',2,24,NULL,'6',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0002_0024.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0002_0024','P:\SPP_Monumental\3365_Megalithgraber\Fotos\2010_03_22\3365_002_038.JPG');
INSERT INTO "T_Fotoliste" VALUES(99,'23.3.2010 09:45:54',3,1,NULL,'5',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0001.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0001','Z:\3365_Megalithgraber\Fotos\003\3365_003_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(100,'23.3.2010 09:45:56',3,2,NULL,'5',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0002.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0002','Z:\3365_Megalithgraber\Fotos\003\3365_003_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(101,'23.3.2010 08:46:38',3,3,NULL,'5',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0003.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0003','Z:\3365_Megalithgraber\Fotos\003\3365_003_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(102,'23.3.2010 08:46:53',3,4,NULL,'5',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0004.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0004','Z:\3365_Megalithgraber\Fotos\003\3365_003_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(103,'23.3.2010 08:48:01',3,5,NULL,'5',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0005.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0005','Z:\3365_Megalithgraber\Fotos\003\3365_003_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(104,'23.3.2010 08:48:01',3,6,NULL,'5',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0006.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0006','Z:\3365_Megalithgraber\Fotos\003\3365_003_007.JPG');
INSERT INTO "T_Fotoliste" VALUES(105,'23.3.2010 08:48:14',3,7,NULL,'5',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0007.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0007','Z:\3365_Megalithgraber\Fotos\003\3365_003_008.JPG');
INSERT INTO "T_Fotoliste" VALUES(106,'23.3.2010 08:48:15',3,8,NULL,'5',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0008.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0008','Z:\3365_Megalithgraber\Fotos\003\3365_003_009.JPG');
INSERT INTO "T_Fotoliste" VALUES(107,'23.3.2010 08:48:16',3,9,NULL,'5',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0009.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0009','Z:\3365_Megalithgraber\Fotos\003\3365_003_010.JPG');
INSERT INTO "T_Fotoliste" VALUES(108,'23.3.2010 08:48:31',3,10,NULL,'5',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0010.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0010','Z:\3365_Megalithgraber\Fotos\003\3365_003_012.JPG');
INSERT INTO "T_Fotoliste" VALUES(109,'23.3.2010 08:48:31',3,11,NULL,'5',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0011.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0011','Z:\3365_Megalithgraber\Fotos\003\3365_003_013.JPG');
INSERT INTO "T_Fotoliste" VALUES(110,'23.3.2010 08:48:49',3,12,NULL,'5',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0012.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0012','Z:\3365_Megalithgraber\Fotos\003\3365_003_014.JPG');
INSERT INTO "T_Fotoliste" VALUES(111,'23.3.2010 08:48:59',3,13,NULL,'5',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0013.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0013','Z:\3365_Megalithgraber\Fotos\003\3365_003_016.JPG');
INSERT INTO "T_Fotoliste" VALUES(112,'23.3.2010 08:49:16',3,14,NULL,'5',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0014.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0014','Z:\3365_Megalithgraber\Fotos\003\3365_003_018.JPG');
INSERT INTO "T_Fotoliste" VALUES(113,'23.3.2010 09:52:39',3,15,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0015.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0015','Z:\3365_Megalithgraber\Fotos\003\3365_003_019.JPG');
INSERT INTO "T_Fotoliste" VALUES(114,'23.3.2010 09:52:39',3,16,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0016.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0016','Z:\3365_Megalithgraber\Fotos\003\3365_003_020.JPG');
INSERT INTO "T_Fotoliste" VALUES(115,'23.3.2010 09:53:38',3,17,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0017.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0017','Z:\3365_Megalithgraber\Fotos\003\3365_003_021.JPG');
INSERT INTO "T_Fotoliste" VALUES(116,'23.3.2010 09:54:02',3,18,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0018.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0018','Z:\3365_Megalithgraber\Fotos\003\3365_003_022.JPG');
INSERT INTO "T_Fotoliste" VALUES(117,'23.3.2010 09:54:25',3,19,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0019.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0019','Z:\3365_Megalithgraber\Fotos\003\3365_003_023.JPG');
INSERT INTO "T_Fotoliste" VALUES(118,'23.3.2010 09:55:01',3,20,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0020.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0020','Z:\3365_Megalithgraber\Fotos\003\3365_003_024.JPG');
INSERT INTO "T_Fotoliste" VALUES(119,'23.3.2010 09:55:11',3,21,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0021.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0021','Z:\3365_Megalithgraber\Fotos\003\3365_003_025.JPG');
INSERT INTO "T_Fotoliste" VALUES(120,'23.3.2010 10:00:35',3,22,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0022.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0022','Z:\3365_Megalithgraber\Fotos\003\3365_003_026.JPG');
INSERT INTO "T_Fotoliste" VALUES(121,'23.3.2010 10:00:38',3,23,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0023.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0023','Z:\3365_Megalithgraber\Fotos\003\3365_003_027.JPG');
INSERT INTO "T_Fotoliste" VALUES(122,'23.3.2010 10:02:34',3,24,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0024.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0024','Z:\3365_Megalithgraber\Fotos\003\3365_003_028.JPG');
INSERT INTO "T_Fotoliste" VALUES(123,'23.3.2010 10:02:34',3,25,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0025.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0025','Z:\3365_Megalithgraber\Fotos\003\3365_003_029.JPG');
INSERT INTO "T_Fotoliste" VALUES(124,'23.3.2010 10:02:47',3,26,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0026.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0026','Z:\3365_Megalithgraber\Fotos\003\3365_003_030.JPG');
INSERT INTO "T_Fotoliste" VALUES(125,'23.3.2010 10:03:30',3,27,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0027.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0027','Z:\3365_Megalithgraber\Fotos\003\3365_003_031.JPG');
INSERT INTO "T_Fotoliste" VALUES(126,'23.3.2010 10:03:31',3,28,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0028.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0028','Z:\3365_Megalithgraber\Fotos\003\3365_003_032.JPG');
INSERT INTO "T_Fotoliste" VALUES(127,'23.3.2010 10:03:40',3,29,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0029.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0029','Z:\3365_Megalithgraber\Fotos\003\3365_003_033.JPG');
INSERT INTO "T_Fotoliste" VALUES(128,'23.3.2010 10:03:40',3,30,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0030.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0030','Z:\3365_Megalithgraber\Fotos\003\3365_003_034.JPG');
INSERT INTO "T_Fotoliste" VALUES(129,'23.3.2010 10:03:55',3,31,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0031.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0031','Z:\3365_Megalithgraber\Fotos\003\3365_003_036.JPG');
INSERT INTO "T_Fotoliste" VALUES(130,'23.3.2010 10:03:56',3,32,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0032.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0032','Z:\3365_Megalithgraber\Fotos\003\3365_003_037.JPG');
INSERT INTO "T_Fotoliste" VALUES(131,'23.3.2010 10:13:35',3,33,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0033.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0033','Z:\3365_Megalithgraber\Fotos\003\3365_003_038.JPG');
INSERT INTO "T_Fotoliste" VALUES(132,'23.3.2010 10:13:35',3,34,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0034.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0034','Z:\3365_Megalithgraber\Fotos\003\3365_003_039.JPG');
INSERT INTO "T_Fotoliste" VALUES(133,'23.3.2010 10:13:36',3,35,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0035.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0035','Z:\3365_Megalithgraber\Fotos\003\3365_003_040.JPG');
INSERT INTO "T_Fotoliste" VALUES(134,'23.3.2010 10:13:42',3,36,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0036.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0036','Z:\3365_Megalithgraber\Fotos\003\3365_003_041.JPG');
INSERT INTO "T_Fotoliste" VALUES(135,'23.3.2010 10:13:42',3,37,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0037.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0037','Z:\3365_Megalithgraber\Fotos\003\3365_003_042.JPG');
INSERT INTO "T_Fotoliste" VALUES(136,'23.3.2010 10:13:59',3,38,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0038.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0038','Z:\3365_Megalithgraber\Fotos\003\3365_003_043.JPG');
INSERT INTO "T_Fotoliste" VALUES(137,'23.3.2010 10:14:00',3,39,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0039.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0039','Z:\3365_Megalithgraber\Fotos\003\3365_003_044.JPG');
INSERT INTO "T_Fotoliste" VALUES(138,'23.3.2010 10:14:11',3,40,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0040.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0040','Z:\3365_Megalithgraber\Fotos\003\3365_003_046.JPG');
INSERT INTO "T_Fotoliste" VALUES(139,'23.3.2010 10:14:23',3,41,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0041.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0041','Z:\3365_Megalithgraber\Fotos\003\3365_003_047.JPG');
INSERT INTO "T_Fotoliste" VALUES(140,'23.3.2010 10:14:23',3,42,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0042.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0042','Z:\3365_Megalithgraber\Fotos\003\3365_003_048.JPG');
INSERT INTO "T_Fotoliste" VALUES(141,'23.3.2010 10:37:22',3,43,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0043.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0043','Z:\3365_Megalithgraber\Fotos\003\3365_003_049.JPG');
INSERT INTO "T_Fotoliste" VALUES(142,'23.3.2010 10:37:22',3,44,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0044.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0044','Z:\3365_Megalithgraber\Fotos\003\3365_003_050.JPG');
INSERT INTO "T_Fotoliste" VALUES(143,'23.3.2010 10:37:33',3,45,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0045.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0045','Z:\3365_Megalithgraber\Fotos\003\3365_003_052.JPG');
INSERT INTO "T_Fotoliste" VALUES(144,'23.3.2010 10:37:34',3,46,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0046.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0046','Z:\3365_Megalithgraber\Fotos\003\3365_003_054.JPG');
INSERT INTO "T_Fotoliste" VALUES(145,'23.3.2010 10:38:32',3,47,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0047.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0047','Z:\3365_Megalithgraber\Fotos\003\3365_003_056.JPG');
INSERT INTO "T_Fotoliste" VALUES(146,'23.3.2010 10:38:33',3,48,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0048.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0048','Z:\3365_Megalithgraber\Fotos\003\3365_003_057.JPG');
INSERT INTO "T_Fotoliste" VALUES(147,'23.3.2010 10:38:42',3,49,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0049.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0049','Z:\3365_Megalithgraber\Fotos\003\3365_003_059.JPG');
INSERT INTO "T_Fotoliste" VALUES(148,'23.3.2010 10:39:52',3,50,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0050.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0050','Z:\3365_Megalithgraber\Fotos\003\3365_003_060.JPG');
INSERT INTO "T_Fotoliste" VALUES(149,'23.3.2010 10:39:54',3,51,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0051.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0051','Z:\3365_Megalithgraber\Fotos\003\3365_003_062.JPG');
INSERT INTO "T_Fotoliste" VALUES(150,'23.3.2010 10:39:54',3,52,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0052.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0052','Z:\3365_Megalithgraber\Fotos\003\3365_003_063.JPG');
INSERT INTO "T_Fotoliste" VALUES(151,'23.3.2010 10:41:15',3,53,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0053.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0053','Z:\3365_Megalithgraber\Fotos\003\3365_003_065.JPG');
INSERT INTO "T_Fotoliste" VALUES(152,'23.3.2010 10:41:18',3,54,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0054.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0054','Z:\3365_Megalithgraber\Fotos\003\3365_003_066.JPG');
INSERT INTO "T_Fotoliste" VALUES(153,'23.3.2010 10:41:52',3,55,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0055.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0055','Z:\3365_Megalithgraber\Fotos\003\3365_003_068.JPG');
INSERT INTO "T_Fotoliste" VALUES(154,'23.3.2010 10:43:56',3,56,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0056.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0056','Z:\3365_Megalithgraber\Fotos\003\3365_003_070.JPG');
INSERT INTO "T_Fotoliste" VALUES(155,'23.3.2010 10:43:58',3,57,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0057.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0057','Z:\3365_Megalithgraber\Fotos\003\3365_003_073.JPG');
INSERT INTO "T_Fotoliste" VALUES(156,'23.3.2010 10:50:47',3,58,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0058.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0058','Z:\3365_Megalithgraber\Fotos\003\3365_003_074.JPG');
INSERT INTO "T_Fotoliste" VALUES(157,'23.3.2010 10:50:54',3,59,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0059.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0059','Z:\3365_Megalithgraber\Fotos\003\3365_003_076.JPG');
INSERT INTO "T_Fotoliste" VALUES(158,'23.3.2010 10:50:54',3,60,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0060.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0060','Z:\3365_Megalithgraber\Fotos\003\3365_003_077.JPG');
INSERT INTO "T_Fotoliste" VALUES(159,'23.3.2010 10:51:01',3,61,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0061.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0061','Z:\3365_Megalithgraber\Fotos\003\3365_003_078.JPG');
INSERT INTO "T_Fotoliste" VALUES(160,'23.3.2010 10:51:25',3,62,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0062.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0062','Z:\3365_Megalithgraber\Fotos\003\3365_003_080.JPG');
INSERT INTO "T_Fotoliste" VALUES(161,'23.3.2010 10:51:26',3,63,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0063.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0063','Z:\3365_Megalithgraber\Fotos\003\3365_003_081.JPG');
INSERT INTO "T_Fotoliste" VALUES(162,'23.3.2010 10:52:40',3,64,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0064.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0064','Z:\3365_Megalithgraber\Fotos\003\3365_003_082.JPG');
INSERT INTO "T_Fotoliste" VALUES(163,'23.3.2010 10:54:22',3,65,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0065.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0065','Z:\3365_Megalithgraber\Fotos\003\3365_003_084.JPG');
INSERT INTO "T_Fotoliste" VALUES(164,'23.3.2010 10:54:23',3,66,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0066.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0066','Z:\3365_Megalithgraber\Fotos\003\3365_003_085.JPG');
INSERT INTO "T_Fotoliste" VALUES(165,'23.3.2010 11:07:11',3,67,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0067.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0067','Z:\3365_Megalithgraber\Fotos\003\3365_003_087.JPG');
INSERT INTO "T_Fotoliste" VALUES(166,'23.3.2010 11:07:15',3,68,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0068.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0068','Z:\3365_Megalithgraber\Fotos\003\3365_003_088.JPG');
INSERT INTO "T_Fotoliste" VALUES(167,'23.3.2010 11:07:15',3,69,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0069.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0069','Z:\3365_Megalithgraber\Fotos\003\3365_003_089.JPG');
INSERT INTO "T_Fotoliste" VALUES(168,'23.3.2010 13:25:01',3,70,NULL,'34',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0070.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0070','Z:\3365_Megalithgraber\Fotos\003\3365_003_111.JPG');
INSERT INTO "T_Fotoliste" VALUES(169,'23.3.2010 13:25:19',3,71,NULL,'34',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0071.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0071','Z:\3365_Megalithgraber\Fotos\003\3365_003_115.JPG');
INSERT INTO "T_Fotoliste" VALUES(170,'23.3.2010 13:25:21',3,72,NULL,'34',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0072.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0072','Z:\3365_Megalithgraber\Fotos\003\3365_003_117.JPG');
INSERT INTO "T_Fotoliste" VALUES(171,'23.3.2010 13:26:49',3,73,NULL,'34',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0073.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0073','Z:\3365_Megalithgraber\Fotos\003\3365_003_120.JPG');
INSERT INTO "T_Fotoliste" VALUES(172,'23.3.2010 13:26:50',3,74,NULL,'34',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0074.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0074','Z:\3365_Megalithgraber\Fotos\003\3365_003_121.JPG');
INSERT INTO "T_Fotoliste" VALUES(173,'23.3.2010 13:27:37',3,75,NULL,'34',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0075.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0075','Z:\3365_Megalithgraber\Fotos\003\3365_003_122.JPG');
INSERT INTO "T_Fotoliste" VALUES(174,'23.3.2010 13:27:37',3,76,NULL,'34',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0076.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0076','Z:\3365_Megalithgraber\Fotos\003\3365_003_123.JPG');
INSERT INTO "T_Fotoliste" VALUES(175,'23.3.2010 13:27:45',3,77,NULL,'34',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0077.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0077','Z:\3365_Megalithgraber\Fotos\003\3365_003_124.JPG');
INSERT INTO "T_Fotoliste" VALUES(176,'23.3.2010 13:37:16',3,78,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0078.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0078','Z:\3365_Megalithgraber\Fotos\003\3365_003_126.JPG');
INSERT INTO "T_Fotoliste" VALUES(177,'23.3.2010 13:45:34',3,79,NULL,'35',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0079.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0079','Z:\3365_Megalithgraber\Fotos\003\3365_003_127.JPG');
INSERT INTO "T_Fotoliste" VALUES(178,'23.3.2010 13:45:35',3,80,NULL,'35',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0080.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0080','Z:\3365_Megalithgraber\Fotos\003\3365_003_128.JPG');
INSERT INTO "T_Fotoliste" VALUES(179,'23.3.2010 13:46:43',3,81,NULL,'35',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0081.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0081','Z:\3365_Megalithgraber\Fotos\003\3365_003_130.JPG');
INSERT INTO "T_Fotoliste" VALUES(180,'23.3.2010 13:46:48',3,82,NULL,'35',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0082.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0082','Z:\3365_Megalithgraber\Fotos\003\3365_003_132.JPG');
INSERT INTO "T_Fotoliste" VALUES(181,'23.3.2010 13:46:51',3,83,NULL,'35',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0083.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0083','Z:\3365_Megalithgraber\Fotos\003\3365_003_133.JPG');
INSERT INTO "T_Fotoliste" VALUES(182,'23.3.2010 14:38:28',3,84,NULL,'19',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0084.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0084','Z:\3365_Megalithgraber\Fotos\003\3365_003_134.JPG');
INSERT INTO "T_Fotoliste" VALUES(183,'23.3.2010 14:38:34',3,85,NULL,'19',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0085.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0085','Z:\3365_Megalithgraber\Fotos\003\3365_003_136.JPG');
INSERT INTO "T_Fotoliste" VALUES(184,'23.3.2010 14:39:00',3,86,NULL,'19',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0086.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0086','Z:\3365_Megalithgraber\Fotos\003\3365_003_137.JPG');
INSERT INTO "T_Fotoliste" VALUES(185,'23.3.2010 14:39:02',3,87,NULL,'19',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0087.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0087','Z:\3365_Megalithgraber\Fotos\003\3365_003_138.JPG');
INSERT INTO "T_Fotoliste" VALUES(186,'23.3.2010 14:39:10',3,88,NULL,'19',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0088.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0088','Z:\3365_Megalithgraber\Fotos\003\3365_003_139.JPG');
INSERT INTO "T_Fotoliste" VALUES(187,'23.3.2010 14:39:10',3,89,NULL,'19',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0089.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0089','Z:\3365_Megalithgraber\Fotos\003\3365_003_140.JPG');
INSERT INTO "T_Fotoliste" VALUES(188,'23.3.2010 14:40:13',3,90,NULL,'19',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0090.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0090','Z:\3365_Megalithgraber\Fotos\003\3365_003_141.JPG');
INSERT INTO "T_Fotoliste" VALUES(189,'23.3.2010 15:06:00',3,91,NULL,'18',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0091.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0091','Z:\3365_Megalithgraber\Fotos\003\3365_003_143.JPG');
INSERT INTO "T_Fotoliste" VALUES(190,'23.3.2010 15:06:01',3,92,NULL,'18',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0092.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0092','Z:\3365_Megalithgraber\Fotos\003\3365_003_144.JPG');
INSERT INTO "T_Fotoliste" VALUES(191,'23.3.2010 15:06:01',3,93,NULL,'18',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0093.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0093','Z:\3365_Megalithgraber\Fotos\003\3365_003_145.JPG');
INSERT INTO "T_Fotoliste" VALUES(192,'23.3.2010 15:06:23',3,94,NULL,'18',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0094.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0094','Z:\3365_Megalithgraber\Fotos\003\3365_003_146.JPG');
INSERT INTO "T_Fotoliste" VALUES(193,'23.3.2010 15:06:24',3,95,NULL,'18',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0095.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0095','Z:\3365_Megalithgraber\Fotos\003\3365_003_147.JPG');
INSERT INTO "T_Fotoliste" VALUES(194,'23.3.2010 15:06:38',3,96,NULL,'18',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0096.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0096','Z:\3365_Megalithgraber\Fotos\003\3365_003_148.JPG');
INSERT INTO "T_Fotoliste" VALUES(195,'23.3.2010 15:06:38',3,97,NULL,'18',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0097.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0097','Z:\3365_Megalithgraber\Fotos\003\3365_003_149.JPG');
INSERT INTO "T_Fotoliste" VALUES(196,'23.3.2010 16:35:01',3,98,NULL,'14',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0098.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0098','Z:\3365_Megalithgraber\Fotos\003\3365_003_156.JPG');
INSERT INTO "T_Fotoliste" VALUES(197,'23.3.2010 16:35:33',3,99,NULL,'14',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0099.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0099','Z:\3365_Megalithgraber\Fotos\003\3365_003_158.JPG');
INSERT INTO "T_Fotoliste" VALUES(198,'23.3.2010 16:35:45',3,100,NULL,'14',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0100.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0100','Z:\3365_Megalithgraber\Fotos\003\3365_003_159.JPG');
INSERT INTO "T_Fotoliste" VALUES(199,'23.3.2010 16:35:45',3,101,NULL,'14',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0101.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0101','Z:\3365_Megalithgraber\Fotos\003\3365_003_160.JPG');
INSERT INTO "T_Fotoliste" VALUES(200,'23.3.2010 16:36:17',3,102,NULL,'14',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0102.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0102','Z:\3365_Megalithgraber\Fotos\003\3365_003_161.JPG');
INSERT INTO "T_Fotoliste" VALUES(201,'23.3.2010 16:36:34',3,103,NULL,'14',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0103.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0103','Z:\3365_Megalithgraber\Fotos\003\3365_003_162.JPG');
INSERT INTO "T_Fotoliste" VALUES(202,'23.3.2010 16:36:34',3,104,NULL,'14',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0003_0104.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0003_0104','Z:\3365_Megalithgraber\Fotos\003\3365_003_163.JPG');
INSERT INTO "T_Fotoliste" VALUES(203,'24.3.2010 11:19:32',4,1,NULL,'9',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0001.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0001','Z:\3365_Megalithgraber\Fotos\004\3365_004_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(204,'24.3.2010 11:19:34',4,2,NULL,'9',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0002.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0002','Z:\3365_Megalithgraber\Fotos\004\3365_004_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(205,'24.3.2010 11:19:44',4,3,NULL,'9',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0003.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0003','Z:\3365_Megalithgraber\Fotos\004\3365_004_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(206,'24.3.2010 11:19:48',4,4,NULL,'9',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0004.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0004','Z:\3365_Megalithgraber\Fotos\004\3365_004_007.JPG');
INSERT INTO "T_Fotoliste" VALUES(207,'24.3.2010 11:19:58',4,5,NULL,'9',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0005.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0005','Z:\3365_Megalithgraber\Fotos\004\3365_004_008.JPG');
INSERT INTO "T_Fotoliste" VALUES(208,'24.3.2010 11:19:58',4,6,NULL,'9',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0006.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0006','Z:\3365_Megalithgraber\Fotos\004\3365_004_009.JPG');
INSERT INTO "T_Fotoliste" VALUES(209,'24.3.2010 11:54:38',4,7,NULL,'28',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0007.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0007','Z:\3365_Megalithgraber\Fotos\004\3365_004_010.JPG');
INSERT INTO "T_Fotoliste" VALUES(210,'24.3.2010 11:55:08',4,8,NULL,'28',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0008.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0008','Z:\3365_Megalithgraber\Fotos\004\3365_004_011.JPG');
INSERT INTO "T_Fotoliste" VALUES(211,'24.3.2010 11:55:22',4,9,NULL,'28',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0009.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0009','Z:\3365_Megalithgraber\Fotos\004\3365_004_013.JPG');
INSERT INTO "T_Fotoliste" VALUES(212,'24.3.2010 11:55:34',4,10,NULL,'28',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0010.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0010','Z:\3365_Megalithgraber\Fotos\004\3365_004_014.JPG');
INSERT INTO "T_Fotoliste" VALUES(213,'24.3.2010 11:55:36',4,11,NULL,'28',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0011.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0011','Z:\3365_Megalithgraber\Fotos\004\3365_004_015.JPG');
INSERT INTO "T_Fotoliste" VALUES(214,'24.3.2010 12:14:56',4,12,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0012.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0012','Z:\3365_Megalithgraber\Fotos\004\3365_004_016.JPG');
INSERT INTO "T_Fotoliste" VALUES(215,'24.3.2010 12:15:00',4,13,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0013.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0013','Z:\3365_Megalithgraber\Fotos\004\3365_004_017.JPG');
INSERT INTO "T_Fotoliste" VALUES(216,'24.3.2010 12:15:10',4,14,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0014.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0014','Z:\3365_Megalithgraber\Fotos\004\3365_004_019.JPG');
INSERT INTO "T_Fotoliste" VALUES(217,'24.3.2010 12:15:16',4,15,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0015.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0015','Z:\3365_Megalithgraber\Fotos\004\3365_004_022.JPG');
INSERT INTO "T_Fotoliste" VALUES(218,'24.3.2010 12:15:20',4,16,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0016.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0016','Z:\3365_Megalithgraber\Fotos\004\3365_004_024.JPG');
INSERT INTO "T_Fotoliste" VALUES(219,'24.3.2010 12:15:36',4,17,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0017.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0017','Z:\3365_Megalithgraber\Fotos\004\3365_004_027.JPG');
INSERT INTO "T_Fotoliste" VALUES(220,'24.3.2010 12:15:44',4,18,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0018.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0018','Z:\3365_Megalithgraber\Fotos\004\3365_004_029.JPG');
INSERT INTO "T_Fotoliste" VALUES(221,'24.3.2010 12:15:44',4,19,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0019.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0019','Z:\3365_Megalithgraber\Fotos\004\3365_004_030.JPG');
INSERT INTO "T_Fotoliste" VALUES(222,'24.3.2010 12:16:04',4,20,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0020.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0020','Z:\3365_Megalithgraber\Fotos\004\3365_004_031.JPG');
INSERT INTO "T_Fotoliste" VALUES(223,'24.3.2010 12:16:08',4,21,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0021.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0021','Z:\3365_Megalithgraber\Fotos\004\3365_004_032.JPG');
INSERT INTO "T_Fotoliste" VALUES(224,'24.3.2010 12:16:20',4,22,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0022.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0022','Z:\3365_Megalithgraber\Fotos\004\3365_004_033.JPG');
INSERT INTO "T_Fotoliste" VALUES(225,'24.3.2010 12:25:22',4,23,NULL,'26',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0023.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0023','Z:\3365_Megalithgraber\Fotos\004\3365_004_035.JPG');
INSERT INTO "T_Fotoliste" VALUES(226,'24.3.2010 12:25:36',4,24,NULL,'26',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0024.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0024','Z:\3365_Megalithgraber\Fotos\004\3365_004_038.JPG');
INSERT INTO "T_Fotoliste" VALUES(227,'24.3.2010 12:25:42',4,25,NULL,'26',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0025.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0025','Z:\3365_Megalithgraber\Fotos\004\3365_004_039.JPG');
INSERT INTO "T_Fotoliste" VALUES(228,'24.3.2010 12:25:46',4,26,NULL,'26',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0026.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0026','Z:\3365_Megalithgraber\Fotos\004\3365_004_040.JPG');
INSERT INTO "T_Fotoliste" VALUES(229,'24.3.2010 12:27:12',4,27,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0027.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0027','Z:\3365_Megalithgraber\Fotos\004\3365_004_041.JPG');
INSERT INTO "T_Fotoliste" VALUES(230,'24.3.2010 12:27:14',4,28,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0028.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0028','Z:\3365_Megalithgraber\Fotos\004\3365_004_042.JPG');
INSERT INTO "T_Fotoliste" VALUES(231,'24.3.2010 15:38:18',4,29,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0029.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0029','Z:\3365_Megalithgraber\Fotos\004\3365_004_059.JPG');
INSERT INTO "T_Fotoliste" VALUES(232,'24.3.2010 15:38:20',4,30,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0030.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0030','Z:\3365_Megalithgraber\Fotos\004\3365_004_060.JPG');
INSERT INTO "T_Fotoliste" VALUES(233,'24.3.2010 15:55:16',4,31,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0031.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0031','Z:\3365_Megalithgraber\Fotos\004\3365_004_062.JPG');
INSERT INTO "T_Fotoliste" VALUES(234,'24.3.2010 15:55:18',4,32,NULL,'34',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0032.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0032','Z:\3365_Megalithgraber\Fotos\004\3365_004_063.JPG');
INSERT INTO "T_Fotoliste" VALUES(235,'24.3.2010 15:55:24',4,33,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0033.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0033','Z:\3365_Megalithgraber\Fotos\004\3365_004_065.JPG');
INSERT INTO "T_Fotoliste" VALUES(236,'24.3.2010 15:55:26',4,34,NULL,'34',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0034.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0034','Z:\3365_Megalithgraber\Fotos\004\3365_004_066.JPG');
INSERT INTO "T_Fotoliste" VALUES(237,'24.3.2010 16:08:30',4,35,NULL,'35',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0035.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0035','Z:\3365_Megalithgraber\Fotos\004\3365_004_071.JPG');
INSERT INTO "T_Fotoliste" VALUES(238,'24.3.2010 16:08:32',4,36,NULL,'35',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0036.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0036','Z:\3365_Megalithgraber\Fotos\004\3365_004_072.JPG');
INSERT INTO "T_Fotoliste" VALUES(239,'24.3.2010 16:08:32',4,37,NULL,'35',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0037.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0037','Z:\3365_Megalithgraber\Fotos\004\3365_004_073.JPG');
INSERT INTO "T_Fotoliste" VALUES(240,'24.3.2010 16:08:50',4,38,NULL,'35',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0038.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0038','Z:\3365_Megalithgraber\Fotos\004\3365_004_074.JPG');
INSERT INTO "T_Fotoliste" VALUES(241,'24.3.2010 16:08:54',4,39,NULL,'35',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0039.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0039','Z:\3365_Megalithgraber\Fotos\004\3365_004_076.JPG');
INSERT INTO "T_Fotoliste" VALUES(242,'24.3.2010 16:30:14',4,40,NULL,'32',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0040.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0040','Z:\3365_Megalithgraber\Fotos\004\3365_004_079.JPG');
INSERT INTO "T_Fotoliste" VALUES(243,'24.3.2010 16:30:16',4,41,NULL,'32',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0041.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0041','Z:\3365_Megalithgraber\Fotos\004\3365_004_081.JPG');
INSERT INTO "T_Fotoliste" VALUES(244,'24.3.2010 16:30:42',4,42,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0042.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0042','Z:\3365_Megalithgraber\Fotos\004\3365_004_082.JPG');
INSERT INTO "T_Fotoliste" VALUES(245,'24.3.2010 16:30:42',4,43,NULL,'32',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0043.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0043','Z:\3365_Megalithgraber\Fotos\004\3365_004_083.JPG');
INSERT INTO "T_Fotoliste" VALUES(246,'24.3.2010 16:30:50',4,44,NULL,'32',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0044.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0044','Z:\3365_Megalithgraber\Fotos\004\3365_004_084.JPG');
INSERT INTO "T_Fotoliste" VALUES(247,'24.3.2010 16:30:50',4,45,NULL,'32',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0045.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0045','Z:\3365_Megalithgraber\Fotos\004\3365_004_085.JPG');
INSERT INTO "T_Fotoliste" VALUES(248,'24.3.2010 16:31:00',4,46,NULL,'32',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0046.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0046','Z:\3365_Megalithgraber\Fotos\004\3365_004_086.JPG');
INSERT INTO "T_Fotoliste" VALUES(249,'24.3.2010 16:33:56',4,47,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0047.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0047','Z:\3365_Megalithgraber\Fotos\004\3365_004_087.JPG');
INSERT INTO "T_Fotoliste" VALUES(250,'24.3.2010 16:33:58',4,48,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0048.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0048','Z:\3365_Megalithgraber\Fotos\004\3365_004_089.JPG');
INSERT INTO "T_Fotoliste" VALUES(251,'24.3.2010 16:34:02',4,49,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0049.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0049','Z:\3365_Megalithgraber\Fotos\004\3365_004_090.JPG');
INSERT INTO "T_Fotoliste" VALUES(252,'24.3.2010 16:34:36',4,50,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0050.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0050','Z:\3365_Megalithgraber\Fotos\004\3365_004_092.JPG');
INSERT INTO "T_Fotoliste" VALUES(253,'24.3.2010 17:08:18',4,51,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0051.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0051','Z:\3365_Megalithgraber\Fotos\004\3365_004_096.JPG');
INSERT INTO "T_Fotoliste" VALUES(254,'24.3.2010 16:08:20',4,52,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0052.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0052','Z:\3365_Megalithgraber\Fotos\004\3365_004_098.JPG');
INSERT INTO "T_Fotoliste" VALUES(255,'24.3.2010 16:08:20',4,53,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0053.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0053','Z:\3365_Megalithgraber\Fotos\004\3365_004_099.JPG');
INSERT INTO "T_Fotoliste" VALUES(256,'24.3.2010 16:08:42',4,54,NULL,'35',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0054.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0054','Z:\3365_Megalithgraber\Fotos\004\3365_004_100.JPG');
INSERT INTO "T_Fotoliste" VALUES(257,'24.3.2010 16:08:43',4,55,NULL,'35',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0055.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0055','Z:\3365_Megalithgraber\Fotos\004\3365_004_101.JPG');
INSERT INTO "T_Fotoliste" VALUES(258,'24.3.2010 16:11:17',4,56,NULL,'35',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0056.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0056','Z:\3365_Megalithgraber\Fotos\004\3365_004_102.JPG');
INSERT INTO "T_Fotoliste" VALUES(259,'24.3.2010 16:11:17',4,57,NULL,'35',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0004_0057.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0004_0057','Z:\3365_Megalithgraber\Fotos\004\3365_004_103.JPG');
INSERT INTO "T_Fotoliste" VALUES(260,'25.3.2010 09:23:30',5,1,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0001.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0001','Z:\3365_Megalithgraber\Fotos\005\3365_005_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(261,'25.3.2010 09:23:30',5,2,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0002.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0002','Z:\3365_Megalithgraber\Fotos\005\3365_005_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(262,'25.3.2010 09:24:12',5,3,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0003.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0003','Z:\3365_Megalithgraber\Fotos\005\3365_005_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(263,'25.3.2010 09:24:28',5,4,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0004.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0004','Z:\3365_Megalithgraber\Fotos\005\3365_005_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(264,'25.3.2010 09:24:28',5,5,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0005.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0005','Z:\3365_Megalithgraber\Fotos\005\3365_005_007.JPG');
INSERT INTO "T_Fotoliste" VALUES(265,'25.3.2010 09:25:04',5,6,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0006.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0006','Z:\3365_Megalithgraber\Fotos\005\3365_005_013.JPG');
INSERT INTO "T_Fotoliste" VALUES(266,'25.3.2010 09:25:54',5,7,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0007.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0007','Z:\3365_Megalithgraber\Fotos\005\3365_005_017.JPG');
INSERT INTO "T_Fotoliste" VALUES(267,'25.3.2010 09:25:58',5,8,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0008.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0008','Z:\3365_Megalithgraber\Fotos\005\3365_005_019.JPG');
INSERT INTO "T_Fotoliste" VALUES(268,'25.3.2010 10:13:06',5,9,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0009.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0009','Z:\3365_Megalithgraber\Fotos\005\3365_005_027.JPG');
INSERT INTO "T_Fotoliste" VALUES(269,'25.3.2010 10:32:30',5,10,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0010.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0010','Z:\3365_Megalithgraber\Fotos\005\3365_005_032.JPG');
INSERT INTO "T_Fotoliste" VALUES(270,'25.3.2010 10:32:30',5,11,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0011.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0011','Z:\3365_Megalithgraber\Fotos\005\3365_005_033.JPG');
INSERT INTO "T_Fotoliste" VALUES(271,'25.3.2010 10:32:48',5,12,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0012.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0012','Z:\3365_Megalithgraber\Fotos\005\3365_005_034.JPG');
INSERT INTO "T_Fotoliste" VALUES(272,'25.3.2010 10:33:08',5,13,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0013.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0013','Z:\3365_Megalithgraber\Fotos\005\3365_005_036.JPG');
INSERT INTO "T_Fotoliste" VALUES(273,'25.3.2010 10:33:18',5,14,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0014.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0014','Z:\3365_Megalithgraber\Fotos\005\3365_005_038.JPG');
INSERT INTO "T_Fotoliste" VALUES(274,'25.3.2010 12:34:22',5,15,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0015.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0015','Z:\3365_Megalithgraber\Fotos\005\3365_005_044.JPG');
INSERT INTO "T_Fotoliste" VALUES(275,'25.3.2010 12:34:26',5,16,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0016.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0016','Z:\3365_Megalithgraber\Fotos\005\3365_005_045.JPG');
INSERT INTO "T_Fotoliste" VALUES(276,'25.3.2010 12:34:52',5,17,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0017.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0017','Z:\3365_Megalithgraber\Fotos\005\3365_005_048.JPG');
INSERT INTO "T_Fotoliste" VALUES(277,'25.3.2010 12:45:42',5,18,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0018.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0018','Z:\3365_Megalithgraber\Fotos\005\3365_005_050.JPG');
INSERT INTO "T_Fotoliste" VALUES(278,'25.3.2010 12:46:34',5,19,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0019.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0019','Z:\3365_Megalithgraber\Fotos\005\3365_005_055.JPG');
INSERT INTO "T_Fotoliste" VALUES(279,'25.3.2010 12:49:48',5,20,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0020.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0020','Z:\3365_Megalithgraber\Fotos\005\3365_005_057.JPG');
INSERT INTO "T_Fotoliste" VALUES(280,'25.3.2010 13:01:34',5,21,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0021.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0021','Z:\3365_Megalithgraber\Fotos\005\3365_005_061.JPG');
INSERT INTO "T_Fotoliste" VALUES(281,'25.3.2010 13:01:52',5,22,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0022.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0022','Z:\3365_Megalithgraber\Fotos\005\3365_005_065.JPG');
INSERT INTO "T_Fotoliste" VALUES(282,'25.3.2010 13:03:16',5,23,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0023.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0023','Z:\3365_Megalithgraber\Fotos\005\3365_005_070.JPG');
INSERT INTO "T_Fotoliste" VALUES(283,'25.3.2010 13:03:20',5,24,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0024.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0024','Z:\3365_Megalithgraber\Fotos\005\3365_005_072.JPG');
INSERT INTO "T_Fotoliste" VALUES(284,'25.3.2010 13:11:36',5,25,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0025.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0025','Z:\3365_Megalithgraber\Fotos\005\3365_005_073.JPG');
INSERT INTO "T_Fotoliste" VALUES(285,'25.3.2010 13:12:24',5,26,NULL,'19',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0026.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0026','Z:\3365_Megalithgraber\Fotos\005\3365_005_079.JPG');
INSERT INTO "T_Fotoliste" VALUES(286,'25.3.2010 13:34:28',5,27,NULL,'14',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0027.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0027','Z:\3365_Megalithgraber\Fotos\005\3365_005_085.JPG');
INSERT INTO "T_Fotoliste" VALUES(287,'25.3.2010 13:34:34',5,28,NULL,'14',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0028.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0028','Z:\3365_Megalithgraber\Fotos\005\3365_005_086.JPG');
INSERT INTO "T_Fotoliste" VALUES(288,'25.3.2010 13:34:48',5,29,NULL,'14',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0029.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0029','Z:\3365_Megalithgraber\Fotos\005\3365_005_087.JPG');
INSERT INTO "T_Fotoliste" VALUES(289,'25.3.2010 13:35:10',5,30,NULL,'14',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0030.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0030','Z:\3365_Megalithgraber\Fotos\005\3365_005_089.JPG');
INSERT INTO "T_Fotoliste" VALUES(290,'25.3.2010 13:35:26',5,31,NULL,'14',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0031.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0031','Z:\3365_Megalithgraber\Fotos\005\3365_005_091.JPG');
INSERT INTO "T_Fotoliste" VALUES(291,'25.3.2010 13:35:32',5,32,NULL,'14',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0032.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0032','Z:\3365_Megalithgraber\Fotos\005\3365_005_094.JPG');
INSERT INTO "T_Fotoliste" VALUES(292,'25.3.2010 13:36:16',5,33,NULL,'14',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0033.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0033','Z:\3365_Megalithgraber\Fotos\005\3365_005_098.JPG');
INSERT INTO "T_Fotoliste" VALUES(293,'25.3.2010 14:34:30',5,34,NULL,'15',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0034.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0034','Z:\3365_Megalithgraber\Fotos\005\3365_005_102.JPG');
INSERT INTO "T_Fotoliste" VALUES(294,'25.3.2010 14:34:38',5,35,NULL,'15',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0035.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0035','Z:\3365_Megalithgraber\Fotos\005\3365_005_105.JPG');
INSERT INTO "T_Fotoliste" VALUES(295,'25.3.2010 13:35:00',5,36,NULL,'15',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0036.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0036','Z:\3365_Megalithgraber\Fotos\005\3365_005_108.JPG');
INSERT INTO "T_Fotoliste" VALUES(296,'25.3.2010 14:03:16',5,37,NULL,'17',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0037.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0037','Z:\3365_Megalithgraber\Fotos\005\3365_005_112.JPG');
INSERT INTO "T_Fotoliste" VALUES(297,'25.3.2010 14:03:17',5,38,NULL,'17',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0038.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0038','Z:\3365_Megalithgraber\Fotos\005\3365_005_113.JPG');
INSERT INTO "T_Fotoliste" VALUES(298,'25.3.2010 14:03:40',5,39,NULL,'17',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0039.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0039','Z:\3365_Megalithgraber\Fotos\005\3365_005_114.JPG');
INSERT INTO "T_Fotoliste" VALUES(299,'25.3.2010 14:33:19',5,40,NULL,'16',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0040.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0040','Z:\3365_Megalithgraber\Fotos\005\3365_005_125.JPG');
INSERT INTO "T_Fotoliste" VALUES(300,'25.3.2010 14:33:33',5,41,NULL,'16',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0041.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0041','Z:\3365_Megalithgraber\Fotos\005\3365_005_126.JPG');
INSERT INTO "T_Fotoliste" VALUES(301,'25.3.2010 14:34:09',5,42,NULL,'16',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0042.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0042','Z:\3365_Megalithgraber\Fotos\005\3365_005_131.JPG');
INSERT INTO "T_Fotoliste" VALUES(302,'25.3.2010 14:56:39',5,43,NULL,'18',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0043.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0043','Z:\3365_Megalithgraber\Fotos\005\3365_005_140.JPG');
INSERT INTO "T_Fotoliste" VALUES(303,'25.3.2010 14:56:52',5,44,NULL,'18',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0044.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0044','Z:\3365_Megalithgraber\Fotos\005\3365_005_142.JPG');
INSERT INTO "T_Fotoliste" VALUES(304,'25.3.2010 14:57:14',5,45,NULL,'18',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0045.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0045','Z:\3365_Megalithgraber\Fotos\005\3365_005_144.JPG');
INSERT INTO "T_Fotoliste" VALUES(305,'25.3.2010 14:59:27',5,46,NULL,'18',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0046.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0046','Z:\3365_Megalithgraber\Fotos\005\3365_005_149.JPG');
INSERT INTO "T_Fotoliste" VALUES(306,'25.3.2010 15:01:24',5,47,NULL,'18',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0047.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0047','Z:\3365_Megalithgraber\Fotos\005\3365_005_156.JPG');
INSERT INTO "T_Fotoliste" VALUES(307,'25.3.2010 16:12:25',5,48,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0048.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0048','Z:\3365_Megalithgraber\Fotos\005\3365_005_161.JPG');
INSERT INTO "T_Fotoliste" VALUES(308,'25.3.2010 16:12:44',5,49,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0049.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0049','Z:\3365_Megalithgraber\Fotos\005\3365_005_163.JPG');
INSERT INTO "T_Fotoliste" VALUES(309,'25.3.2010 16:13:05',5,50,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0050.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0050','Z:\3365_Megalithgraber\Fotos\005\3365_005_165.JPG');
INSERT INTO "T_Fotoliste" VALUES(310,'25.3.2010 16:13:41',5,51,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0051.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0051','Z:\3365_Megalithgraber\Fotos\005\3365_005_169.JPG');
INSERT INTO "T_Fotoliste" VALUES(311,'25.3.2010 16:15:36',5,52,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0052.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0052','Z:\3365_Megalithgraber\Fotos\005\3365_005_176.JPG');
INSERT INTO "T_Fotoliste" VALUES(312,'25.3.2010 16:45:40',5,53,NULL,'16',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0053.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0053','Z:\3365_Megalithgraber\Fotos\005\3365_005_184.JPG');
INSERT INTO "T_Fotoliste" VALUES(313,'25.3.2010 16:45:50',5,54,NULL,'16',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0054.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0054','Z:\3365_Megalithgraber\Fotos\005\3365_005_185.JPG');
INSERT INTO "T_Fotoliste" VALUES(314,'25.3.2010 16:46:48',5,55,NULL,'16',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0055.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0055','Z:\3365_Megalithgraber\Fotos\005\3365_005_194.JPG');
INSERT INTO "T_Fotoliste" VALUES(315,'25.3.2010 17:00:29',5,56,NULL,'17',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0056.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0056','Z:\3365_Megalithgraber\Fotos\005\3365_005_199.JPG');
INSERT INTO "T_Fotoliste" VALUES(316,'25.3.2010 17:00:44',5,57,NULL,'17',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0005_0057.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0005_0057','Z:\3365_Megalithgraber\Fotos\005\3365_005_200.JPG');
INSERT INTO "T_Fotoliste" VALUES(317,'26.3.2010 08:29:36',6,1,NULL,'22',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0001.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0001','Z:\3365_Megalithgraber\Fotos\006\3365_006_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(318,'26.3.2010 08:29:38',6,2,NULL,'22',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0002.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0002','Z:\3365_Megalithgraber\Fotos\006\3365_006_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(319,'26.3.2010 08:29:46',6,3,NULL,'22',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0003.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0003','Z:\3365_Megalithgraber\Fotos\006\3365_006_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(320,'26.3.2010 08:30:02',6,4,NULL,'22',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0004.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0004','Z:\3365_Megalithgraber\Fotos\006\3365_006_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(321,'26.3.2010 08:30:04',6,5,NULL,'22',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0005.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0005','Z:\3365_Megalithgraber\Fotos\006\3365_006_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(322,'26.3.2010 09:11:06',6,6,NULL,'12',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0006.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0006','Z:\3365_Megalithgraber\Fotos\006\3365_006_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(323,'26.3.2010 09:11:22',6,7,NULL,'12',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0007.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0007','Z:\3365_Megalithgraber\Fotos\006\3365_006_007.JPG');
INSERT INTO "T_Fotoliste" VALUES(324,'26.3.2010 09:11:22',6,8,NULL,'12',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0008.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0008','Z:\3365_Megalithgraber\Fotos\006\3365_006_008.JPG');
INSERT INTO "T_Fotoliste" VALUES(325,'26.3.2010 09:12:16',6,9,NULL,'12',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0009.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0009','Z:\3365_Megalithgraber\Fotos\006\3365_006_010.JPG');
INSERT INTO "T_Fotoliste" VALUES(326,'26.3.2010 09:12:26',6,10,NULL,'12',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0010.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0010','Z:\3365_Megalithgraber\Fotos\006\3365_006_012.JPG');
INSERT INTO "T_Fotoliste" VALUES(327,'26.3.2010 09:12:28',6,11,NULL,'12',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0011.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0011','Z:\3365_Megalithgraber\Fotos\006\3365_006_013.JPG');
INSERT INTO "T_Fotoliste" VALUES(328,'26.3.2010 09:12:47',6,12,NULL,'12',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0012.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0012','Z:\3365_Megalithgraber\Fotos\006\3365_006_014.JPG');
INSERT INTO "T_Fotoliste" VALUES(329,'26.3.2010 09:12:58',6,13,NULL,'12',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0013.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0013','Z:\3365_Megalithgraber\Fotos\006\3365_006_016.JPG');
INSERT INTO "T_Fotoliste" VALUES(330,'26.3.2010 09:14:27',6,14,NULL,'13',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0014.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0014','Z:\3365_Megalithgraber\Fotos\006\3365_006_018.JPG');
INSERT INTO "T_Fotoliste" VALUES(331,'26.3.2010 09:14:28',6,15,NULL,'13',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0015.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0015','Z:\3365_Megalithgraber\Fotos\006\3365_006_019.JPG');
INSERT INTO "T_Fotoliste" VALUES(332,'26.3.2010 09:14:31',6,16,NULL,'13',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0016.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0016','Z:\3365_Megalithgraber\Fotos\006\3365_006_020.JPG');
INSERT INTO "T_Fotoliste" VALUES(333,'26.3.2010 09:14:39',6,17,NULL,'13',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0017.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0017','Z:\3365_Megalithgraber\Fotos\006\3365_006_021.JPG');
INSERT INTO "T_Fotoliste" VALUES(334,'26.3.2010 09:14:39',6,18,NULL,'13',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0018.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0018','Z:\3365_Megalithgraber\Fotos\006\3365_006_022.JPG');
INSERT INTO "T_Fotoliste" VALUES(335,'26.3.2010 09:15:16',6,19,NULL,'13',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0019.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0019','Z:\3365_Megalithgraber\Fotos\006\3365_006_024.JPG');
INSERT INTO "T_Fotoliste" VALUES(336,'26.3.2010 09:15:17',6,20,NULL,'13',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0020.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0020','Z:\3365_Megalithgraber\Fotos\006\3365_006_025.JPG');
INSERT INTO "T_Fotoliste" VALUES(337,'26.3.2010 09:38:54',6,21,NULL,'13',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0021.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0021','Z:\3365_Megalithgraber\Fotos\006\3365_006_026.JPG');
INSERT INTO "T_Fotoliste" VALUES(338,'26.3.2010 09:38:54',6,22,NULL,'14',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0022.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0022','Z:\3365_Megalithgraber\Fotos\006\3365_006_027.JPG');
INSERT INTO "T_Fotoliste" VALUES(339,'26.3.2010 09:38:54',6,23,NULL,'14',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0023.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0023','Z:\3365_Megalithgraber\Fotos\006\3365_006_028.JPG');
INSERT INTO "T_Fotoliste" VALUES(340,'26.3.2010 09:38:56',6,24,NULL,'14',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0024.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0024','Z:\3365_Megalithgraber\Fotos\006\3365_006_029.JPG');
INSERT INTO "T_Fotoliste" VALUES(341,'26.3.2010 09:39:01',6,25,NULL,'14',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0025.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0025','Z:\3365_Megalithgraber\Fotos\006\3365_006_030.JPG');
INSERT INTO "T_Fotoliste" VALUES(342,'26.3.2010 09:39:20',6,26,NULL,'14',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0026.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0026','Z:\3365_Megalithgraber\Fotos\006\3365_006_032.JPG');
INSERT INTO "T_Fotoliste" VALUES(343,'26.3.2010 09:39:21',6,27,NULL,'14',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0027.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0027','Z:\3365_Megalithgraber\Fotos\006\3365_006_033.JPG');
INSERT INTO "T_Fotoliste" VALUES(344,'26.3.2010 09:44:28',6,28,NULL,'14',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0006_0028.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0006_0028','Z:\3365_Megalithgraber\Fotos\006\3365_006_035.JPG');
INSERT INTO "T_Fotoliste" VALUES(345,'16.3.2010 10:00:30',7,1,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0001.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0001','Z:\3365_Megalithgraber\Fotos\001\3365_001_012.JPG');
INSERT INTO "T_Fotoliste" VALUES(346,'16.3.2010 10:01:20',7,2,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0002.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0002','Z:\3365_Megalithgraber\Fotos\001\3365_001_013.JPG');
INSERT INTO "T_Fotoliste" VALUES(347,'16.3.2010 11:02:04',7,3,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0003.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0003','Z:\3365_Megalithgraber\Fotos\001\3365_001_021.JPG');
INSERT INTO "T_Fotoliste" VALUES(348,'16.3.2010 11:07:04',7,4,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0004.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0004','Z:\3365_Megalithgraber\Fotos\001\3365_001_024.JPG');
INSERT INTO "T_Fotoliste" VALUES(349,'16.3.2010 11:19:12',7,5,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0005.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0005','Z:\3365_Megalithgraber\Fotos\001\3365_001_029.JPG');
INSERT INTO "T_Fotoliste" VALUES(350,'16.3.2010 11:20:14',7,6,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0006.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0006','Z:\3365_Megalithgraber\Fotos\001\3365_001_032.JPG');
INSERT INTO "T_Fotoliste" VALUES(351,'16.3.2010 11:21:34',7,7,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0007.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0007','Z:\3365_Megalithgraber\Fotos\001\3365_001_040.JPG');
INSERT INTO "T_Fotoliste" VALUES(352,'16.3.2010 11:23:34',7,8,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0008.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0008','Z:\3365_Megalithgraber\Fotos\001\3365_001_043.JPG');
INSERT INTO "T_Fotoliste" VALUES(353,'16.3.2010 11:23:42',7,9,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0009.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0009','Z:\3365_Megalithgraber\Fotos\001\3365_001_044.JPG');
INSERT INTO "T_Fotoliste" VALUES(354,'16.3.2010 11:23:50',7,10,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0010.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0010','Z:\3365_Megalithgraber\Fotos\001\3365_001_045.JPG');
INSERT INTO "T_Fotoliste" VALUES(355,'16.3.2010 11:23:56',7,11,NULL,'21',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0011.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0011','Z:\3365_Megalithgraber\Fotos\001\3365_001_046.JPG');
INSERT INTO "T_Fotoliste" VALUES(356,'16.3.2010 11:44:50',7,12,NULL,'21',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0012.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0012','Z:\3365_Megalithgraber\Fotos\001\3365_001_047.JPG');
INSERT INTO "T_Fotoliste" VALUES(357,'16.3.2010 11:49:32',7,13,NULL,'21',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0013.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0013','Z:\3365_Megalithgraber\Fotos\001\3365_001_051.JPG');
INSERT INTO "T_Fotoliste" VALUES(358,'16.3.2010 12:21:42',7,14,NULL,'21',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0014.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0014','Z:\3365_Megalithgraber\Fotos\001\3365_001_053.JPG');
INSERT INTO "T_Fotoliste" VALUES(359,'16.3.2010 14:40:32',7,15,NULL,'21',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0015.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0015','Z:\3365_Megalithgraber\Fotos\001\3365_001_054.JPG');
INSERT INTO "T_Fotoliste" VALUES(360,'16.3.2010 14:40:46',7,16,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0016.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0016','Z:\3365_Megalithgraber\Fotos\001\3365_001_056.JPG');
INSERT INTO "T_Fotoliste" VALUES(361,'16.3.2010 14:41:10',7,17,NULL,'21',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0017.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0017','Z:\3365_Megalithgraber\Fotos\001\3365_001_057.JPG');
INSERT INTO "T_Fotoliste" VALUES(362,'16.3.2010 14:41:50',7,18,NULL,'21',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0018.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0018','Z:\3365_Megalithgraber\Fotos\001\3365_001_063.JPG');
INSERT INTO "T_Fotoliste" VALUES(363,'16.3.2010 14:51:10',7,19,NULL,'21',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0019.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0019','Z:\3365_Megalithgraber\Fotos\001\3365_001_065.JPG');
INSERT INTO "T_Fotoliste" VALUES(364,'16.3.2010 14:51:30',7,20,NULL,'21',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0020.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0020','Z:\3365_Megalithgraber\Fotos\001\3365_001_069.JPG');
INSERT INTO "T_Fotoliste" VALUES(365,'16.3.2010 14:51:44',7,21,NULL,'21',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0021.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0021','Z:\3365_Megalithgraber\Fotos\001\3365_001_071.JPG');
INSERT INTO "T_Fotoliste" VALUES(366,'16.3.2010 15:38:58',7,22,NULL,'1',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0022.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0022','Z:\3365_Megalithgraber\Fotos\001\3365_001_074.JPG');
INSERT INTO "T_Fotoliste" VALUES(367,'16.3.2010 15:39:30',7,23,NULL,'1',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0023.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0023','Z:\3365_Megalithgraber\Fotos\001\3365_001_077.JPG');
INSERT INTO "T_Fotoliste" VALUES(368,'16.3.2010 15:40:18',7,24,NULL,'1',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0024.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0024','Z:\3365_Megalithgraber\Fotos\001\3365_001_080.JPG');
INSERT INTO "T_Fotoliste" VALUES(369,'16.3.2010 15:42:42',7,25,NULL,'1',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0007_0025.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0007_0025','Z:\3365_Megalithgraber\Fotos\001\3365_001_085.JPG');
INSERT INTO "T_Fotoliste" VALUES(370,'9.12.2009 14:55:54',8,1,NULL,'9',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0008_0001.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0008_0001','Z:\3365_Megalithgraber\Fotos\AHa\AHa_09_1.JPG');
INSERT INTO "T_Fotoliste" VALUES(371,'9.12.2009 14:56:06',8,2,NULL,'9',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0008_0002.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0008_0002','Z:\3365_Megalithgraber\Fotos\AHa\AHa_09_2.JPG');
INSERT INTO "T_Fotoliste" VALUES(372,'28.2.2012 12:12:04',8,3,NULL,'31',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0008_0003.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0008_0003','Z:\3365_Megalithgraber\Fotos\AHa\AHa31_0001.jpg');
INSERT INTO "T_Fotoliste" VALUES(373,'28.2.2012 12:12:20',8,4,NULL,'31',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0008_0004.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0008_0004','Z:\3365_Megalithgraber\Fotos\AHa\AHa31_0002.jpg');
INSERT INTO "T_Fotoliste" VALUES(374,'28.2.2012 12:12:42',8,5,NULL,'31',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0008_0005.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0008_0005','Z:\3365_Megalithgraber\Fotos\AHa\AHa31_0003.jpg');
INSERT INTO "T_Fotoliste" VALUES(375,'28.2.2012 11:52:02',8,6,NULL,'33',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0008_0006.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0008_0006','Z:\3365_Megalithgraber\Fotos\AHa\AHa33_0001.jpg');
INSERT INTO "T_Fotoliste" VALUES(376,'28.2.2012 11:52:04',8,7,NULL,'33',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0008_0007.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0008_0007','Z:\3365_Megalithgraber\Fotos\AHa\AHa33_0002.jpg');
INSERT INTO "T_Fotoliste" VALUES(377,'28.2.2012 11:53:20',8,8,NULL,'33',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0008_0008.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0008_0008','Z:\3365_Megalithgraber\Fotos\AHa\AHa33_0003.jpg');
INSERT INTO "T_Fotoliste" VALUES(378,'28.2.2012 11:54:38',8,9,NULL,'33',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0008_0009.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0008_0009','Z:\3365_Megalithgraber\Fotos\AHa\AHa33_0004.jpg');
INSERT INTO "T_Fotoliste" VALUES(379,'21.4.2010 14:39:27',8,10,NULL,'25',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0008_0010.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0008_0010','Z:\3365_Megalithgraber\Fotos\AHa\Alt-Haldensleben_25_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(380,'21.4.2010 14:39:28',8,11,NULL,'25',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0008_0011.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0008_0011','Z:\3365_Megalithgraber\Fotos\AHa\Alt-Haldensleben_25_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(381,'21.4.2010 14:39:51',8,12,NULL,'25',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0008_0012.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0008_0012','Z:\3365_Megalithgraber\Fotos\AHa\Alt-Haldensleben_25_008.JPG');
INSERT INTO "T_Fotoliste" VALUES(382,'21.4.2010 14:55:37',8,13,NULL,'25',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0008_0013.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0008_0013','Z:\3365_Megalithgraber\Fotos\AHa\Alt-Haldensleben_25_016.JPG');
INSERT INTO "T_Fotoliste" VALUES(383,'21.4.2010 09:39:01',8,14,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0008_0014.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0008_0014','Z:\3365_Megalithgraber\Fotos\AHa\Alt-Haldensleben_27_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(384,'21.4.2010 09:39:14',8,15,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0008_0015.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0008_0015','Z:\3365_Megalithgraber\Fotos\AHa\Alt-Haldensleben_27_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(385,'21.4.2010 09:39:39',8,16,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0008_0016.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0008_0016','Z:\3365_Megalithgraber\Fotos\AHa\Alt-Haldensleben_27_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(386,'21.4.2010 09:42:22',8,17,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0008_0017.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0008_0017','Z:\3365_Megalithgraber\Fotos\AHa\Alt-Haldensleben_27_015.JPG');
INSERT INTO "T_Fotoliste" VALUES(387,'21.4.2010 09:43:24',8,18,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0008_0018.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0008_0018','Z:\3365_Megalithgraber\Fotos\AHa\Alt-Haldensleben_27_020.JPG');
INSERT INTO "T_Fotoliste" VALUES(388,'22.4.2010 14:09:10',9,1,NULL,'12',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0001.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0001','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_12_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(389,'22.4.2010 14:10:30',9,2,NULL,'12',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0002.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0002','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_12_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(390,'22.4.2010 14:10:30',9,3,NULL,'12',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0003.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0003','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_12_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(391,'22.4.2010 14:38:32',9,4,NULL,'12',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0004.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0004','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_12_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(392,'22.4.2010 14:38:40',9,5,NULL,'13',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0005.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0005','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_13_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(393,'22.4.2010 14:42:50',9,6,NULL,'13',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0006.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0006','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_13_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(394,'22.4.2010 14:42:54',9,7,NULL,'13',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0007.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0007','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_13_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(395,'22.4.2010 14:43:10',9,8,NULL,'13',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0008.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0008','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_13_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(396,'22.4.2010 14:43:10',9,9,NULL,'13',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0009.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0009','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_13_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(397,'22.4.2010 14:43:34',9,10,NULL,'13',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0010.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0010','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_13_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(398,'22.4.2010 14:43:36',9,11,NULL,'13',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0011.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0011','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_13_007.JPG');
INSERT INTO "T_Fotoliste" VALUES(399,'22.4.2010 14:59:58',9,12,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0012.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0012','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(400,'22.4.2010 15:00:00',9,13,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0013.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0013','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(401,'22.4.2010 15:20:28',9,14,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0014.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0014','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(402,'22.4.2010 15:20:30',9,15,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0015.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0015','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(403,'22.4.2010 15:20:30',9,16,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0016.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0016','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(404,'22.4.2010 15:20:32',9,17,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0017.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0017','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(405,'22.4.2010 15:20:32',9,18,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0018.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0018','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_007.JPG');
INSERT INTO "T_Fotoliste" VALUES(406,'22.4.2010 15:20:34',9,19,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0019.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0019','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_008.JPG');
INSERT INTO "T_Fotoliste" VALUES(407,'22.4.2010 15:20:40',9,20,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0020.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0020','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_009.JPG');
INSERT INTO "T_Fotoliste" VALUES(408,'22.4.2010 15:20:42',9,21,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0021.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0021','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_010.JPG');
INSERT INTO "T_Fotoliste" VALUES(409,'22.4.2010 15:20:54',9,22,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0022.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0022','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_011.JPG');
INSERT INTO "T_Fotoliste" VALUES(410,'22.4.2010 15:20:54',9,23,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0023.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0023','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_012.JPG');
INSERT INTO "T_Fotoliste" VALUES(411,'22.4.2010 15:21:06',9,24,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0024.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0024','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_013.JPG');
INSERT INTO "T_Fotoliste" VALUES(412,'22.4.2010 15:21:08',9,25,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0025.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0025','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_014.JPG');
INSERT INTO "T_Fotoliste" VALUES(413,'22.4.2010 15:21:24',9,26,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0026.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0026','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_015.JPG');
INSERT INTO "T_Fotoliste" VALUES(414,'22.4.2010 15:21:32',9,27,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0027.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0027','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_016.JPG');
INSERT INTO "T_Fotoliste" VALUES(415,'22.4.2010 15:21:42',9,28,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0028.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0028','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_017.JPG');
INSERT INTO "T_Fotoliste" VALUES(416,'22.4.2010 15:21:44',9,29,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0029.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0029','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_018.JPG');
INSERT INTO "T_Fotoliste" VALUES(417,'22.4.2010 15:26:08',9,30,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0030.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0030','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_019.JPG');
INSERT INTO "T_Fotoliste" VALUES(418,'22.4.2010 15:26:16',9,31,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0031.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0031','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_020.JPG');
INSERT INTO "T_Fotoliste" VALUES(419,'22.4.2010 15:26:18',9,32,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0032.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0032','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_021.JPG');
INSERT INTO "T_Fotoliste" VALUES(420,'22.4.2010 15:26:54',9,33,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0033.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0033','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_022.JPG');
INSERT INTO "T_Fotoliste" VALUES(421,'22.4.2010 15:26:54',9,34,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0034.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0034','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_023.JPG');
INSERT INTO "T_Fotoliste" VALUES(422,'22.4.2010 15:28:26',9,35,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0035.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0035','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_024.JPG');
INSERT INTO "T_Fotoliste" VALUES(423,'22.4.2010 15:28:26',9,36,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0036.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0036','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_025.JPG');
INSERT INTO "T_Fotoliste" VALUES(424,'22.4.2010 15:28:28',9,37,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0037.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0037','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_026.JPG');
INSERT INTO "T_Fotoliste" VALUES(425,'22.4.2010 15:28:44',9,38,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0038.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0038','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_027.JPG');
INSERT INTO "T_Fotoliste" VALUES(426,'22.4.2010 15:28:46',9,39,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0039.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0039','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_028.JPG');
INSERT INTO "T_Fotoliste" VALUES(427,'22.4.2010 15:38:44',9,40,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0040.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0040','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_029.JPG');
INSERT INTO "T_Fotoliste" VALUES(428,'22.4.2010 15:38:46',9,41,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0041.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0041','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_030.JPG');
INSERT INTO "T_Fotoliste" VALUES(429,'22.4.2010 15:38:48',9,42,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0042.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0042','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_031.JPG');
INSERT INTO "T_Fotoliste" VALUES(430,'22.4.2010 15:38:50',9,43,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0043.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0043','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_17_032.JPG');
INSERT INTO "T_Fotoliste" VALUES(431,'9.3.2010 16:52:58',9,44,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0044.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0044','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_18_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(432,'9.3.2010 16:53:04',9,45,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0045.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0045','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_18_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(433,'9.3.2010 16:53:22',9,46,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0046.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0046','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_18_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(434,'9.3.2010 16:53:30',9,47,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0047.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0047','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_18_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(435,'9.3.2010 16:38:04',9,48,NULL,'19',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0048.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0048','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_19_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(436,'9.3.2010 16:38:30',9,49,NULL,'19',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0049.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0049','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_19_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(437,'9.3.2010 16:38:36',9,50,NULL,'19',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0050.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0050','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_19_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(438,'9.3.2010 16:38:48',9,51,NULL,'19',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0051.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0051','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_19_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(439,'9.3.2010 16:39:06',9,52,NULL,'19',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0052.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0052','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_19_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(440,'9.3.2010 16:39:40',9,53,NULL,'19',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0053.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0053','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_19_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(441,'9.3.2010 16:34:16',9,54,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0054.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0054','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_20_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(442,'9.3.2010 16:34:26',9,55,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0055.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0055','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_20_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(443,'9.3.2010 16:10:18',9,56,NULL,'21',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0056.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0056','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_21_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(444,'9.3.2010 15:24:08',9,57,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0057.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0057','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_22_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(445,'9.3.2010 15:24:22',9,58,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0058.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0058','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_22_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(446,'9.3.2010 15:25:22',9,59,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0059.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0059','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_22_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(447,'9.3.2010 15:25:34',9,60,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0060.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0060','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_22_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(448,'9.3.2010 15:26:04',9,61,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0061.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0061','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_22_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(449,'9.3.2010 15:26:12',9,62,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0062.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0062','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_22_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(450,'9.3.2010 17:14:42',9,63,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0063.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0063','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_23_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(451,'9.3.2010 17:14:50',9,64,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0064.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0064','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_23_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(452,'9.3.2010 17:14:58',9,65,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0065.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0065','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_23_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(453,'9.3.2010 17:15:28',9,66,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0066.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0066','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_23_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(454,'9.3.2010 17:15:38',9,67,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0067.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0067','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_23_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(455,'9.3.2010 14:40:22',9,68,NULL,'25',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0068.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0068','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_25_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(456,'9.3.2010 14:40:34',9,69,NULL,'25',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0069.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0069','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_25_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(457,'9.3.2010 14:40:46',9,70,NULL,'25',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0070.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0070','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_25_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(458,'9.3.2010 14:42:08',9,71,NULL,'25',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0071.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0071','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_25_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(459,'9.3.2010 13:42:00',9,72,NULL,'26',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0072.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0072','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_26_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(460,'9.3.2010 13:42:10',9,73,NULL,'26',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0073.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0073','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_26_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(461,'9.3.2010 13:59:08',9,74,NULL,'26',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0074.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0074','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_26_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(462,'9.3.2010 13:59:18',9,75,NULL,'26',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0075.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0075','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_26_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(463,'9.3.2010 13:59:34',9,76,NULL,'26',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0076.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0076','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_26_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(464,'9.3.2010 13:59:56',9,77,NULL,'26',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0077.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0077','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_26_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(465,'10.3.2010 12:09:03',9,78,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0078.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0078','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_29_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(466,'10.3.2010 12:09:10',9,79,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0079.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0079','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_29_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(467,'10.3.2010 12:09:47',9,80,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0080.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0080','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_29_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(468,'10.3.2010 12:16:54',9,81,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0081.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0081','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_29_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(469,'10.3.2010 12:17:06',9,82,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0082.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0082','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_29_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(470,'10.3.2010 11:11:53',9,83,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0083.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0083','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_30_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(471,'10.3.2010 11:12:10',9,84,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0084.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0084','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_30_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(472,'10.3.2010 11:20:52',9,85,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0085.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0085','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_30_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(473,'10.3.2010 11:20:58',9,86,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0086.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0086','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_30_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(474,'10.3.2010 11:35:50',9,87,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0087.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0087','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_31_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(475,'10.3.2010 11:33:47',9,88,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0088.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0088','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_31_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(476,'10.3.2010 11:33:53',9,89,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0089.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0089','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_31_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(477,'10.3.2010 11:34:34',9,90,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0090.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0090','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_31_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(478,'10.3.2010 11:34:42',9,91,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0091.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0091','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_31_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(479,'10.3.2010 11:34:51',9,92,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0092.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0092','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_31_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(480,'10.3.2010 11:35:39',9,93,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0093.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0093','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_31_007.JPG');
INSERT INTO "T_Fotoliste" VALUES(481,'10.3.2010 13:31:18',9,94,NULL,'32',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0094.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0094','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_32_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(482,'10.3.2010 13:31:59',9,95,NULL,'32',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0095.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0095','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_32_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(483,'10.3.2010 13:32:47',9,96,NULL,'32',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0096.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0096','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_32_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(484,'10.3.2010 13:33:25',9,97,NULL,'32',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0097.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0097','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_32_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(485,'10.3.2010 13:33:41',9,98,NULL,'32',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0098.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0098','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_32_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(486,'10.3.2010 13:33:57',9,99,NULL,'32',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0099.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0009_0099','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_32_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(487,'21.4.2010 10:58:11',9,100,NULL,'36',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0100.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0100','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_36_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(488,'21.4.2010 10:58:12',9,101,NULL,'36',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0101.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0101','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_36_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(489,'21.4.2010 10:59:12',9,102,NULL,'36',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0102.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0102','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_36_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(490,'21.4.2010 10:59:12',9,103,NULL,'36',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0103.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0103','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_36_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(491,'21.4.2010 11:26:05',9,104,NULL,'36',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0104.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0104','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_36_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(492,'21.4.2010 11:26:05',9,105,NULL,'36',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0105.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0105','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_36_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(493,'21.4.2010 11:33:29',9,106,NULL,'36',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0106.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0106','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_36_007.JPG');
INSERT INTO "T_Fotoliste" VALUES(494,'21.4.2010 11:36:55',9,107,NULL,'37',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0107.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0107','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_37_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(495,'21.4.2010 11:37:05',9,108,NULL,'37',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0108.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0108','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_37_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(496,'21.4.2010 11:37:59',9,109,NULL,'37',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0009_0109.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0009_0109','Z:\3365_Megalithgraber\Fotos\Alv\Alvensleben_37_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(497,'9.3.2010 00:00:00',10,1,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0001.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0001','Z:\3365_Megalithgraber\Fotos\Doen\Bebertal_FSt1a.JPG');
INSERT INTO "T_Fotoliste" VALUES(498,'9.3.2010 00:00:00',10,2,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0002.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0002','Z:\3365_Megalithgraber\Fotos\Doen\Bebertal_FSt1b.JPG');
INSERT INTO "T_Fotoliste" VALUES(499,'25.4.2008 09:44:47',10,4,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,NULL,'zerstört durch Forstarbeiten',0,0,NULL,'003365_0010_0004.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0010_0004','Z:\3365_Megalithgraber\Fotos\Doen\BebertalII_10_06.JPG');
INSERT INTO "T_Fotoliste" VALUES(500,'25.4.2008 09:47:13',10,5,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0005.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0010_0005','Z:\3365_Megalithgraber\Fotos\Doen\BebertalII_10_07.JPG');
INSERT INTO "T_Fotoliste" VALUES(501,'25.4.2008 09:47:23',10,6,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0006.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0010_0006','Z:\3365_Megalithgraber\Fotos\Doen\BebertalII_10_08.JPG');
INSERT INTO "T_Fotoliste" VALUES(502,'25.4.2008 09:50:15',10,7,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0007.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0010_0007','Z:\3365_Megalithgraber\Fotos\Doen\BebertalII_10_09.JPG');
INSERT INTO "T_Fotoliste" VALUES(503,'21.4.2010 13:01:48',10,8,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0008.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0010_0008','Z:\3365_Megalithgraber\Fotos\Doen\Doenstedt_10_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(504,'21.4.2010 13:01:48',10,9,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0009.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0010_0009','Z:\3365_Megalithgraber\Fotos\Doen\Doenstedt_10_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(505,'21.4.2010 13:18:45',10,10,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0010.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0010_0010','Z:\3365_Megalithgraber\Fotos\Doen\Doenstedt_10_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(506,'21.4.2010 13:18:45',10,11,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0011.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0010_0011','Z:\3365_Megalithgraber\Fotos\Doen\Doenstedt_10_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(507,'21.4.2010 12:13:17',10,12,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0012.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0010_0012','Z:\3365_Megalithgraber\Fotos\Doen\Doenstedt_11_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(508,'21.4.2010 12:13:51',10,13,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0013.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0010_0013','Z:\3365_Megalithgraber\Fotos\Doen\Doenstedt_11_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(509,'21.4.2010 12:14:10',10,14,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0014.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0010_0014','Z:\3365_Megalithgraber\Fotos\Doen\Doenstedt_11_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(510,'21.4.2010 12:15:11',10,15,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0015.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0010_0015','Z:\3365_Megalithgraber\Fotos\Doen\Doenstedt_11_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(511,'21.4.2010 12:15:12',10,16,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0016.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0010_0016','Z:\3365_Megalithgraber\Fotos\Doen\Doenstedt_11_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(512,'21.4.2010 12:17:41',10,17,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0017.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0010_0017','Z:\3365_Megalithgraber\Fotos\Doen\Doenstedt_11_007.JPG');
INSERT INTO "T_Fotoliste" VALUES(513,'21.4.2010 12:17:42',10,18,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0018.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0010_0018','Z:\3365_Megalithgraber\Fotos\Doen\Doenstedt_11_008.JPG');
INSERT INTO "T_Fotoliste" VALUES(514,'9.3.2010 11:52:04',10,19,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0019.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0019','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_10_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(515,'9.3.2010 11:53:01',10,20,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0020.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0020','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_10_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(516,'9.3.2010 11:53:45',10,21,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0021.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0021','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_10_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(517,'9.3.2010 11:54:18',10,22,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0022.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0022','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_10_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(518,'9.3.2010 11:54:44',10,23,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0023.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0023','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_10_007.JPG');
INSERT INTO "T_Fotoliste" VALUES(519,'10.3.2010 08:44:32',10,24,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0024.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0024','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_11_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(520,'10.3.2010 08:44:32',10,25,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0025.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0025','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_11_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(521,'10.3.2010 08:44:40',10,26,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0026.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0026','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_11_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(522,'10.3.2010 08:44:40',10,27,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0027.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0027','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_11_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(523,'10.3.2010 08:45:03',10,28,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0028.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0028','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_11_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(524,'10.3.2010 08:45:03',10,29,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0029.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0029','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_11_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(525,'10.3.2010 08:45:30',10,30,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0030.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0030','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_11_007.JPG');
INSERT INTO "T_Fotoliste" VALUES(526,'10.3.2010 08:45:30',10,31,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0031.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0031','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_11_008.JPG');
INSERT INTO "T_Fotoliste" VALUES(527,'10.3.2010 10:18:04',10,32,NULL,'4',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0032.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0032','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_4_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(528,'10.3.2010 10:18:13',10,33,NULL,'4',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0033.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0033','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_4_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(529,'10.3.2010 10:18:27',10,34,NULL,'4',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0034.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0034','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_4_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(530,'10.3.2010 10:19:14',10,35,NULL,'4',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0035.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0035','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_4_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(531,'10.3.2010 10:19:46',10,36,NULL,'4',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0036.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0036','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_4_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(532,'10.3.2010 10:21:48',10,37,NULL,'4',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0037.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0037','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_4_009.JPG');
INSERT INTO "T_Fotoliste" VALUES(533,'10.3.2010 10:22:28',10,38,NULL,'4',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0038.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0038','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_4_010.JPG');
INSERT INTO "T_Fotoliste" VALUES(534,'10.3.2010 10:22:35',10,39,NULL,'4',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0039.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0039','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_4_011.JPG');
INSERT INTO "T_Fotoliste" VALUES(535,'10.3.2010 10:23:19',10,40,NULL,'4',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0010_0040.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0010_0040','Z:\3365_Megalithgraber\Fotos\Doen\Dönstedt_4_013.JPG');
INSERT INTO "T_Fotoliste" VALUES(536,'9.12.2009 16:21:44',11,1,NULL,'12',3365,13,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0011_0001.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0011_0001','Z:\3365_Megalithgraber\Fotos\Emd12\DSC_0216.JPG');
INSERT INTO "T_Fotoliste" VALUES(537,'9.12.2009 16:21:50',11,2,NULL,'12',3365,13,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0011_0002.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0011_0002','Z:\3365_Megalithgraber\Fotos\Emd12\DSC_0218.JPG');
INSERT INTO "T_Fotoliste" VALUES(538,'9.12.2009 16:22:06',11,3,NULL,'12',3365,13,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0011_0003.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0011_0003','Z:\3365_Megalithgraber\Fotos\Emd12\DSC_0220.JPG');
INSERT INTO "T_Fotoliste" VALUES(539,'9.12.2009 16:23:20',11,4,NULL,'12',3365,13,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0011_0004.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0011_0004','Z:\3365_Megalithgraber\Fotos\Emd12\DSC_0224.JPG');
INSERT INTO "T_Fotoliste" VALUES(540,'9.12.2009 16:23:36',11,5,NULL,'12',3365,13,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0011_0005.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0011_0005','Z:\3365_Megalithgraber\Fotos\Emd12\DSC_0226.JPG');
INSERT INTO "T_Fotoliste" VALUES(541,'9.12.2009 16:23:46',11,6,NULL,'12',3365,13,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0011_0006.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0011_0006','Z:\3365_Megalithgraber\Fotos\Emd12\DSC_0227.JPG');
INSERT INTO "T_Fotoliste" VALUES(542,'9.12.2009 16:24:38',11,7,NULL,'12',3365,13,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0011_0007.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0011_0007','Z:\3365_Megalithgraber\Fotos\Emd12\DSC_0228.JPG');
INSERT INTO "T_Fotoliste" VALUES(543,'9.12.2009 12:54:50',12,1,NULL,'14',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0001.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0012_0001','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_14.jpg');
INSERT INTO "T_Fotoliste" VALUES(544,'11.3.2010 14:52:15',12,2,NULL,'14',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0002.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0002','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_14_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(545,'11.3.2010 14:52:26',12,3,NULL,'14',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0003.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0003','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_14_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(546,'11.3.2010 14:52:42',12,4,NULL,'14',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0004.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0004','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_14_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(547,'11.3.2010 14:53:39',12,5,NULL,'14',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0005.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0005','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_14_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(548,'11.3.2010 14:53:54',12,6,NULL,'14',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0006.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0006','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_14_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(549,'11.3.2010 14:54:05',12,7,NULL,'14',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0007.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0007','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_14_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(550,'8.12.2009 16:06:22',12,8,NULL,'15',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0008.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0012_0008','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_15_1.JPG');
INSERT INTO "T_Fotoliste" VALUES(551,'8.12.2009 16:06:22',12,9,NULL,'15',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0009.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0012_0009','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_15_2.JPG');
INSERT INTO "T_Fotoliste" VALUES(552,'8.12.2009 16:06:55',12,10,NULL,'15',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0010.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0012_0010','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_15_3.JPG');
INSERT INTO "T_Fotoliste" VALUES(553,'8.12.2009 16:06:55',12,11,NULL,'15',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0011.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0012_0011','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_15_4.JPG');
INSERT INTO "T_Fotoliste" VALUES(554,'11.3.2010 12:33:58',12,12,NULL,'16',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0012.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0012','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_16_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(555,'11.3.2010 12:34:12',12,13,NULL,'16',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0013.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0013','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_16_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(556,'11.3.2010 12:34:24',12,14,NULL,'16',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0014.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0014','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_16_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(557,'11.3.2010 12:34:42',12,15,NULL,'16',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0015.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0015','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_16_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(558,'11.3.2010 12:35:01',12,16,NULL,'16',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0016.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0016','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_16_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(559,'11.3.2010 12:35:16',12,17,NULL,'16',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0017.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0017','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_16_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(560,'11.3.2010 12:36:04',12,18,NULL,'16',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0018.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0018','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_16_007.JPG');
INSERT INTO "T_Fotoliste" VALUES(561,'11.3.2010 12:37:19',12,19,NULL,'16',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0019.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0019','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_16_008.JPG');
INSERT INTO "T_Fotoliste" VALUES(562,'11.3.2010 12:37:31',12,20,NULL,'16',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0020.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0020','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_16_009.JPG');
INSERT INTO "T_Fotoliste" VALUES(563,'11.3.2010 16:29:45',12,21,NULL,'22',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0021.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0021','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_22_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(564,'11.3.2010 16:30:23',12,22,NULL,'22',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0022.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0022','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_22_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(565,'11.3.2010 16:30:32',12,23,NULL,'22',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0023.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0023','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_22_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(566,'11.3.2010 16:31:04',12,24,NULL,'22',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0024.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0024','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_22_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(567,'11.3.2010 16:32:36',12,25,NULL,'22',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0025.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0025','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_22_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(568,'11.3.2010 16:33:02',12,26,NULL,'22',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0026.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0026','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_22_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(569,'9.12.2009 11:54:46',12,27,NULL,'24',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0027.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0012_0027','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_24_1.JPG');
INSERT INTO "T_Fotoliste" VALUES(570,'8.12.2009 16:17:42',12,29,NULL,'30',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0029.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0012_0029','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_30_1.JPG');
INSERT INTO "T_Fotoliste" VALUES(571,'11.3.2010 15:54:31',12,30,NULL,'35',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0030.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0030','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_35_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(572,'11.3.2010 15:54:57',12,31,NULL,'35',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0031.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0031','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_35_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(573,'11.3.2010 15:55:23',12,32,NULL,'35',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0032.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0032','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_35_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(574,'11.3.2010 15:55:30',12,33,NULL,'35',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0033.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0033','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_35_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(575,'11.3.2010 15:55:51',12,34,NULL,'35',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0034.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0034','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_35_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(576,'11.3.2010 15:56:39',12,35,NULL,'35',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0035.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0035','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_35_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(577,'11.3.2010 15:56:51',12,36,NULL,'35',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0012_0036.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0012_0036','Z:\3365_Megalithgraber\Fotos\Hun\Hundisburg_35_007.JPG');
INSERT INTO "T_Fotoliste" VALUES(578,'20.4.2010 16:08:38',13,1,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0001.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0001','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(579,'20.4.2010 16:08:38',13,2,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0002.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0002','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(580,'20.4.2010 16:08:40',13,3,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0003.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0003','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(581,'20.4.2010 16:08:58',13,4,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0004.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0004','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(582,'20.4.2010 16:08:58',13,5,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0005.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0005','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(583,'20.4.2010 16:09:48',13,6,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0006.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0006','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(584,'20.4.2010 16:09:48',13,7,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0007.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0007','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_007.JPG');
INSERT INTO "T_Fotoliste" VALUES(585,'20.4.2010 16:09:54',13,8,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0008.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0008','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_008.JPG');
INSERT INTO "T_Fotoliste" VALUES(586,'20.4.2010 16:09:54',13,9,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0009.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0009','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_009.JPG');
INSERT INTO "T_Fotoliste" VALUES(587,'20.4.2010 16:10:30',13,10,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0010.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0010','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_010.JPG');
INSERT INTO "T_Fotoliste" VALUES(588,'20.4.2010 16:10:30',13,11,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0011.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0011','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_011.JPG');
INSERT INTO "T_Fotoliste" VALUES(589,'20.4.2010 16:14:16',13,12,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0012.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0012','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_012.JPG');
INSERT INTO "T_Fotoliste" VALUES(590,'21.4.2010 09:00:20',13,13,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0013.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0013','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_013.JPG');
INSERT INTO "T_Fotoliste" VALUES(591,'21.4.2010 09:00:20',13,14,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0014.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0014','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_014.JPG');
INSERT INTO "T_Fotoliste" VALUES(592,'21.4.2010 09:00:34',13,15,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0015.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0015','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_015.JPG');
INSERT INTO "T_Fotoliste" VALUES(593,'21.4.2010 09:00:38',13,16,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0016.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0016','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_016.JPG');
INSERT INTO "T_Fotoliste" VALUES(594,'21.4.2010 09:00:40',13,17,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0017.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0017','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_017.JPG');
INSERT INTO "T_Fotoliste" VALUES(595,'21.4.2010 09:00:58',13,18,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0018.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0018','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_018.JPG');
INSERT INTO "T_Fotoliste" VALUES(596,'21.4.2010 09:01:20',13,19,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0019.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0019','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_019.JPG');
INSERT INTO "T_Fotoliste" VALUES(597,'21.4.2010 09:01:36',13,20,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0020.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0020','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_020.JPG');
INSERT INTO "T_Fotoliste" VALUES(598,'21.4.2010 09:01:36',13,21,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0021.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0021','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_021.JPG');
INSERT INTO "T_Fotoliste" VALUES(599,'21.4.2010 09:01:46',13,22,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0022.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0022','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_022.JPG');
INSERT INTO "T_Fotoliste" VALUES(600,'21.4.2010 09:01:48',13,23,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0023.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0023','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_023.JPG');
INSERT INTO "T_Fotoliste" VALUES(601,'21.4.2010 09:01:50',13,24,NULL,'1',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0024.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0024','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_1_024.JPG');
INSERT INTO "T_Fotoliste" VALUES(602,'20.4.2010 16:04:02',13,25,NULL,'2',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0025.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0025','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_2_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(603,'20.4.2010 16:04:02',13,26,NULL,'2',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0026.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0026','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_2_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(604,'20.4.2010 16:04:04',13,27,NULL,'2',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0027.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0027','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_2_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(605,'20.4.2010 16:04:04',13,28,NULL,'2',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0028.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0028','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_2_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(606,'20.4.2010 15:58:04',13,29,NULL,'6',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0029.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0029','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_6_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(607,'20.4.2010 15:58:04',13,30,NULL,'6',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0030.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0030','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_6_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(608,'20.4.2010 15:58:10',13,31,NULL,'6',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0031.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0031','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_6_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(609,'20.4.2010 15:58:10',13,32,NULL,'6',3365,17,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0013_0032.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0013_0032','Z:\3365_Megalithgraber\Fotos\Suep\Sueplingen_6_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(610,'10.3.2010 15:25:20',14,1,NULL,'12',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0014_0001.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0014_0001','Z:\3365_Megalithgraber\Fotos\Rinne_2010_03\Alt-Haldensleben_12_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(611,'10.3.2010 15:25:28',14,2,NULL,'12',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0014_0002.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0014_0002','Z:\3365_Megalithgraber\Fotos\Rinne_2010_03\Alt-Haldensleben_12_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(612,'10.3.2010 15:34:15',14,3,NULL,'12',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0014_0003.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0014_0003','Z:\3365_Megalithgraber\Fotos\Rinne_2010_03\Alt-Haldensleben_12_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(613,'11.3.2010 08:51:39',14,4,NULL,'14',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0014_0004.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0014_0004','Z:\3365_Megalithgraber\Fotos\Rinne_2010_03\Alt-Haldensleben_14_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(614,'11.3.2010 08:52:35',14,5,NULL,'14',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0014_0005.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0014_0005','Z:\3365_Megalithgraber\Fotos\Rinne_2010_03\Alt-Haldensleben_14_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(615,'11.3.2010 09:23:16',14,6,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0014_0006.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0014_0006','Z:\3365_Megalithgraber\Fotos\Rinne_2010_03\Alt-Haldensleben_15_003.JPG');
INSERT INTO "T_Fotoliste" VALUES(616,'11.3.2010 09:24:20',14,7,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0014_0007.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0014_0007','Z:\3365_Megalithgraber\Fotos\Rinne_2010_03\Alt-Haldensleben_15_005.JPG');
INSERT INTO "T_Fotoliste" VALUES(617,'11.3.2010 10:42:29',14,8,NULL,'16',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0014_0008.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0014_0008','Z:\3365_Megalithgraber\Fotos\Rinne_2010_03\Alt-Haldensleben_16_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(618,'11.3.2010 10:43:58',14,9,NULL,'16',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0014_0009.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0014_0009','Z:\3365_Megalithgraber\Fotos\Rinne_2010_03\Alt-Haldensleben_16_004.JPG');
INSERT INTO "T_Fotoliste" VALUES(619,'11.3.2010 11:38:15',14,10,NULL,'17',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0014_0010.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0014_0010','Z:\3365_Megalithgraber\Fotos\Rinne_2010_03\Alt-Haldensleben_17_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(620,'11.3.2010 14:06:01',14,11,NULL,'28',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0014_0011.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0014_0011','Z:\3365_Megalithgraber\Fotos\Rinne_2010_03\Alt-Haldensleben_28_002.JPG');
INSERT INTO "T_Fotoliste" VALUES(621,'11.3.2010 14:34:26',14,12,NULL,'28',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0014_0012.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0014_0012','Z:\3365_Megalithgraber\Fotos\Rinne_2010_03\Alt-Haldensleben_28_007.JPG');
INSERT INTO "T_Fotoliste" VALUES(622,'16.3.2010 09:05:40',15,1,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,'Arbeitsfoto',0,0,NULL,'003365_0015_0001.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0015_0001','Z:\3365_Megalithgraber\Fotos\Arbeitsbilder\3365_001_006.JPG');
INSERT INTO "T_Fotoliste" VALUES(623,'22.3.2010 16:12:56',15,2,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,'Arbeitsfoto',0,0,NULL,'003365_0015_0002.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0015_0002','Z:\3365_Megalithgraber\Fotos\Arbeitsbilder\3365_002_001.JPG');
INSERT INTO "T_Fotoliste" VALUES(624,'22.3.2010 16:46:34',15,3,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,'Arbeitsfoto',0,0,NULL,'003365_0015_0003.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0015_0003','Z:\3365_Megalithgraber\Fotos\Arbeitsbilder\3365_002_011.JPG');
INSERT INTO "T_Fotoliste" VALUES(625,'23.3.2010 11:37:54',15,4,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,'Arbeitsfoto',0,0,NULL,'003365_0015_0004.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0015_0004','Z:\3365_Megalithgraber\Fotos\Arbeitsbilder\3365_003_055.JPG');
INSERT INTO "T_Fotoliste" VALUES(626,'23.3.2010 14:57:18',15,5,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,'Arbeitsfoto',0,0,NULL,'003365_0015_0005.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0015_0005','Z:\3365_Megalithgraber\Fotos\Arbeitsbilder\3365_003_142.JPG');
INSERT INTO "T_Fotoliste" VALUES(627,'23.3.2010 16:31:23',15,6,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,'Arbeitsfoto',0,0,NULL,'003365_0015_0006.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0015_0006','Z:\3365_Megalithgraber\Fotos\Arbeitsbilder\3365_003_150.JPG');
INSERT INTO "T_Fotoliste" VALUES(628,'24.3.2010 14:09:38',15,7,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,'Arbeitsfoto',0,0,NULL,'003365_0015_0007.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0015_0007','Z:\3365_Megalithgraber\Fotos\Arbeitsbilder\3365_004_051.JPG');
INSERT INTO "T_Fotoliste" VALUES(629,'24.3.2010 15:07:53',15,8,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,'Arbeitsfoto',0,0,NULL,'003365_0015_0008.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0015_0008','Z:\3365_Megalithgraber\Fotos\Arbeitsbilder\3365_004_068.JPG');
INSERT INTO "T_Fotoliste" VALUES(630,'24.3.2010 16:41:02',15,9,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,'Arbeitsfoto',0,0,NULL,'003365_0015_0009.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0015_0009','Z:\3365_Megalithgraber\Fotos\Arbeitsbilder\3365_004_109.JPG');
INSERT INTO "T_Fotoliste" VALUES(631,'25.3.2010 10:51:31',15,10,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,'Arbeitsfoto',0,0,NULL,'003365_0015_0010.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0015_0010','Z:\3365_Megalithgraber\Fotos\Arbeitsbilder\3365_005_042.JPG');
INSERT INTO "T_Fotoliste" VALUES(632,'25.3.2010 16:44:52',15,11,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,'Arbeitsfoto',0,0,NULL,'003365_0015_0011.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0015_0011','Z:\3365_Megalithgraber\Fotos\Arbeitsbilder\3365_005_182.JPG');
INSERT INTO "T_Fotoliste" VALUES(633,'25.3.2010 16:46:04',15,12,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,'Arbeitsfoto',0,0,NULL,'003365_0015_0012.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0015_0012','Z:\3365_Megalithgraber\Fotos\Arbeitsbilder\3365_005_188.JPG');
INSERT INTO "T_Fotoliste" VALUES(634,'25.3.2010 16:46:04',15,13,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,'Arbeitsfoto',0,0,NULL,'003365_0015_0013.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0015_0013','Z:\3365_Megalithgraber\Fotos\Arbeitsbilder\3365_005_189.JPG');
INSERT INTO "T_Fotoliste" VALUES(635,'25.3.2010 16:46:17',15,14,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,'Arbeitsfoto',0,0,NULL,'003365_0015_0014.jpg',NULL,0,'Lindemann',NULL,0,0,0,0,'003365_0015_0014','Z:\3365_Megalithgraber\Fotos\Arbeitsbilder\3365_005_191.JPG');
INSERT INTO "T_Fotoliste" VALUES(636,'25.4.2008 11:08:50',16,1,NULL,'11',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0001.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0001','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_11_33.JPG');
INSERT INTO "T_Fotoliste" VALUES(637,'25.4.2008 11:09:06',16,2,NULL,'11',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0002.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0002','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_11_34.JPG');
INSERT INTO "T_Fotoliste" VALUES(638,'25.4.2008 11:30:46',16,3,NULL,'14',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0003.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0003','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_14_41.JPG');
INSERT INTO "T_Fotoliste" VALUES(639,'25.4.2008 11:31:12',16,4,NULL,'14',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0004.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0004','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_14_42.JPG');
INSERT INTO "T_Fotoliste" VALUES(640,'25.4.2008 11:31:33',16,5,NULL,'14',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0005.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0005','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_14_43.JPG');
INSERT INTO "T_Fotoliste" VALUES(641,'25.4.2008 11:32:32',16,6,NULL,'14',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0006.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0006','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_14_44.JPG');
INSERT INTO "T_Fotoliste" VALUES(642,'25.4.2008 11:33:02',16,7,NULL,'14',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0007.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0007','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_14_45.JPG');
INSERT INTO "T_Fotoliste" VALUES(643,'25.4.2008 11:35:31',16,8,NULL,'14',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0008.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0008','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_14_46.JPG');
INSERT INTO "T_Fotoliste" VALUES(644,'25.4.2008 11:36:11',16,9,NULL,'14',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0009.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0009','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_14_47.JPG');
INSERT INTO "T_Fotoliste" VALUES(645,'25.4.2008 11:29:46',16,10,NULL,'14',3365,11,NULL,3,NULL,NULL,NULL,NULL,'Küchentanne',0,0,NULL,'003365_0016_0010.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0010','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_14Kuechent_40.JPG');
INSERT INTO "T_Fotoliste" VALUES(646,'25.4.2008 11:25:30',16,11,NULL,'15',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0011.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0011','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_15_38.JPG');
INSERT INTO "T_Fotoliste" VALUES(647,'25.4.2008 11:25:37',16,12,NULL,'15',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0012.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0012','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_15_39.JPG');
INSERT INTO "T_Fotoliste" VALUES(648,'25.4.2008 11:18:10',16,13,NULL,'16',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0013.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0013','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_16_35.JPG');
INSERT INTO "T_Fotoliste" VALUES(649,'25.4.2008 11:18:29',16,14,NULL,'16',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0014.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0014','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_16_36.JPG');
INSERT INTO "T_Fotoliste" VALUES(650,'25.4.2008 11:18:48',16,15,NULL,'16',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0015.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0015','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_16_37.JPG');
INSERT INTO "T_Fotoliste" VALUES(651,'25.4.2008 11:06:32',16,16,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0016.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0016','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_17_30.JPG');
INSERT INTO "T_Fotoliste" VALUES(652,'25.4.2008 11:06:44',16,17,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0017.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0017','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_17_31.JPG');
INSERT INTO "T_Fotoliste" VALUES(653,'25.4.2008 11:07:08',16,18,NULL,'17',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0018.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0018','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_17_32.JPG');
INSERT INTO "T_Fotoliste" VALUES(654,'25.4.2008 10:53:38',16,19,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0019.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0019','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_18_27.JPG');
INSERT INTO "T_Fotoliste" VALUES(655,'25.4.2008 10:53:50',16,20,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0020.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0020','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_18_28.JPG');
INSERT INTO "T_Fotoliste" VALUES(656,'25.4.2008 10:54:25',16,21,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0021.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0021','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_18_29.JPG');
INSERT INTO "T_Fotoliste" VALUES(657,'25.4.2008 10:49:01',16,22,NULL,'19',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0022.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0022','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_19_25.JPG');
INSERT INTO "T_Fotoliste" VALUES(658,'25.4.2008 10:49:19',16,23,NULL,'19',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0023.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0023','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_19_26.JPG');
INSERT INTO "T_Fotoliste" VALUES(659,'25.4.2008 10:43:18',16,24,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0024.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0024','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_20_22.JPG');
INSERT INTO "T_Fotoliste" VALUES(660,'25.4.2008 10:43:44',16,25,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0025.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0025','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_20_23.JPG');
INSERT INTO "T_Fotoliste" VALUES(661,'25.4.2008 10:43:57',16,26,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0026.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0026','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_20_24.JPG');
INSERT INTO "T_Fotoliste" VALUES(662,'25.4.2008 10:28:30',16,28,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0028.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0028','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_22_17.JPG');
INSERT INTO "T_Fotoliste" VALUES(663,'25.4.2008 10:28:43',16,29,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0029.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0029','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_22_18.JPG');
INSERT INTO "T_Fotoliste" VALUES(664,'25.4.2008 10:29:02',16,30,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0030.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0030','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_22_19.JPG');
INSERT INTO "T_Fotoliste" VALUES(665,'25.4.2008 10:23:28',16,31,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0031.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0031','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_23_14.JPG');
INSERT INTO "T_Fotoliste" VALUES(666,'25.4.2008 10:23:39',16,32,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0032.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0032','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_23_15.JPG');
INSERT INTO "T_Fotoliste" VALUES(667,'25.4.2008 10:15:48',16,34,NULL,'25',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0034.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0034','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_25_12.JPG');
INSERT INTO "T_Fotoliste" VALUES(668,'25.4.2008 10:16:03',16,35,NULL,'25',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0035.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0035','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_25_13.JPG');
INSERT INTO "T_Fotoliste" VALUES(669,'25.4.2008 10:01:57',16,36,NULL,'28',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0036.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0036','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_28_10.JPG');
INSERT INTO "T_Fotoliste" VALUES(670,'25.4.2008 10:02:04',16,37,NULL,'28',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0037.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0037','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_28_11.JPG');
INSERT INTO "T_Fotoliste" VALUES(671,'25.4.2008 12:44:47',16,38,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0038.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0038','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_29_64.JPG');
INSERT INTO "T_Fotoliste" VALUES(672,'25.4.2008 11:44:27',16,39,NULL,'3',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0039.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0039','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_3_48.JPG');
INSERT INTO "T_Fotoliste" VALUES(673,'25.4.2008 11:44:51',16,40,NULL,'3',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0040.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0040','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_3_49.JPG');
INSERT INTO "T_Fotoliste" VALUES(674,'25.4.2008 12:50:52',16,41,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0041.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0041','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_31_65.JPG');
INSERT INTO "T_Fotoliste" VALUES(675,'25.4.2008 12:51:31',16,42,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0042.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0042','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_31_66.JPG');
INSERT INTO "T_Fotoliste" VALUES(676,'25.4.2008 12:51:57',16,43,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0043.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0043','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_31_67.JPG');
INSERT INTO "T_Fotoliste" VALUES(677,'25.4.2008 12:52:20',16,44,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0044.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0044','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_31_68.JPG');
INSERT INTO "T_Fotoliste" VALUES(678,'25.4.2008 12:53:12',16,45,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0045.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0045','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_31_69.JPG');
INSERT INTO "T_Fotoliste" VALUES(679,'25.4.2008 12:53:34',16,46,NULL,'31',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0046.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0046','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_31_70.JPG');
INSERT INTO "T_Fotoliste" VALUES(680,'25.4.2008 11:58:30',16,47,NULL,'33',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0047.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0047','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_33_56.JPG');
INSERT INTO "T_Fotoliste" VALUES(681,'25.4.2008 11:59:06',16,48,NULL,'33',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0048.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0048','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_33_57.JPG');
INSERT INTO "T_Fotoliste" VALUES(682,'25.4.2008 11:59:58',16,49,NULL,'33',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0049.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0049','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_33_58.JPG');
INSERT INTO "T_Fotoliste" VALUES(683,'25.4.2008 12:00:07',16,50,NULL,'33',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0050.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0050','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_33_59.JPG');
INSERT INTO "T_Fotoliste" VALUES(684,'25.4.2008 12:01:53',16,51,NULL,'33',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0051.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0051','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_33_60.JPG');
INSERT INTO "T_Fotoliste" VALUES(685,'25.4.2008 11:58:13',16,52,NULL,'33',3365,11,NULL,3,NULL,NULL,NULL,NULL,'Kaisergrab',0,0,NULL,'003365_0016_0052.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0052','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_33Kaisergr_55.JPG');
INSERT INTO "T_Fotoliste" VALUES(686,'25.4.2008 11:47:47',16,53,NULL,'4',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0053.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0053','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_4_50.JPG');
INSERT INTO "T_Fotoliste" VALUES(687,'25.4.2008 11:50:49',16,55,NULL,'5',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0055.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0055','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_5_52.JPG');
INSERT INTO "T_Fotoliste" VALUES(688,'25.4.2008 11:51:03',16,56,NULL,'5',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0056.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0056','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_5_53.JPG');
INSERT INTO "T_Fotoliste" VALUES(689,'25.4.2008 11:51:29',16,57,NULL,'5',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0057.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0057','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_5_54.JPG');
INSERT INTO "T_Fotoliste" VALUES(690,'25.4.2008 12:18:59',16,58,NULL,'6',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0058.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0058','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_6_61.JPG');
INSERT INTO "T_Fotoliste" VALUES(691,'25.4.2008 12:19:04',16,59,NULL,'6',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0059.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0059','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_6_62.JPG');
INSERT INTO "T_Fotoliste" VALUES(692,'25.4.2008 12:19:25',16,60,NULL,'6',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0060.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0060','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_I_6_63.JPG');
INSERT INTO "T_Fotoliste" VALUES(693,'25.4.2008 09:44:04',16,61,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0061.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0061','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_II_10_04.JPG');
INSERT INTO "T_Fotoliste" VALUES(694,'25.4.2008 09:24:57',16,63,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0063.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0063','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_II_11_01.JPG');
INSERT INTO "T_Fotoliste" VALUES(695,'25.4.2008 09:25:56',16,64,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0064.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0064','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_II_11_02.JPG');
INSERT INTO "T_Fotoliste" VALUES(696,'25.4.2008 09:26:25',16,65,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0065.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0065','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Bebertal_II_11_03.JPG');
INSERT INTO "T_Fotoliste" VALUES(697,'25.4.2008 13:48:04',16,66,NULL,'15',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0066.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0066','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Hundisburg15_72.JPG');
INSERT INTO "T_Fotoliste" VALUES(698,'25.4.2008 13:48:35',16,67,NULL,'15',3365,15,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0016_0067.jpg',NULL,0,'Fritsch',NULL,0,0,0,0,'003365_0016_0067','Z:\3365_Megalithgraber\Fotos\Fritsch_080425\Hundisburg15_73.JPG');
INSERT INTO "T_Fotoliste" VALUES(699,'14.3.2013 19:12:04',17,1,NULL,'12',3365,10,NULL,3,NULL,NULL,NULL,'SO','Fluchstange 5x 0,2m = 1 m',0,0,NULL,'003365_0017_0001.jpg',NULL,0,'Rinne, Christoph',NULL,0,0,0,0,'003365_0017_0001','D:\temp\20130314\DSC_0069.JPG');
INSERT INTO "T_Fotoliste" VALUES(700,'14.3.2013 19:12:06',17,2,NULL,'12',3365,10,NULL,3,NULL,NULL,NULL,'SO','Fluchstange 5x 0,2m = 1 m',0,0,NULL,'003365_0017_0002.jpg',NULL,0,'Rinne, Christoph',NULL,0,0,0,0,'003365_0017_0002','D:\temp\20130314\DSC_0070.JPG');
INSERT INTO "T_Fotoliste" VALUES(701,'14.3.2013 19:12:10',17,3,NULL,'12',3365,10,NULL,3,NULL,NULL,NULL,'NW','Zum rechten Bildrand liegt das Megalithgrab Steineiche Aha 13',0,0,NULL,'003365_0017_0003.jpg',NULL,0,NULL,NULL,0,0,0,0,'003365_0017_0003','D:\temp\20130314\DSC_0071.JPG');
INSERT INTO "T_Fotoliste" VALUES(702,'14.3.2013 19:12:12',17,4,NULL,'13',3365,10,NULL,3,NULL,NULL,NULL,'SW','Blick von Aha 12 zu Aha 13 (Steineiche), Abstand 24 m. Richtung 250° N.',0,0,NULL,'003365_0017_0004.jpg',NULL,0,NULL,NULL,0,0,0,0,'003365_0017_0004','D:\temp\20130314\DSC_0072.JPG');
INSERT INTO "T_Fotoliste" VALUES(703,'14.3.2013 19:12:16',17,5,NULL,'26',3365,11,NULL,3,NULL,NULL,NULL,'SO',NULL,0,0,NULL,'003365_0017_0005.jpg',NULL,0,'Rinne, Christoph',NULL,0,0,0,0,'003365_0017_0005','D:\temp\20130314\DSC_0073.JPG');
INSERT INTO "T_Fotoliste" VALUES(704,'14.3.2013 19:12:18',17,6,NULL,'26',3365,11,NULL,3,NULL,NULL,NULL,'N',NULL,0,0,NULL,'003365_0017_0006.jpg',NULL,0,NULL,NULL,0,0,0,0,'003365_0017_0006','D:\temp\20130314\DSC_0074.JPG');
INSERT INTO "T_Fotoliste" VALUES(705,'14.3.2013 19:12:23',17,7,NULL,'26',3365,11,NULL,3,NULL,NULL,NULL,'N',NULL,0,0,NULL,'003365_0017_0007.jpg',NULL,0,'Rinne, Christoph',NULL,0,0,0,0,'003365_0017_0007','D:\temp\20130314\DSC_0075.JPG');
INSERT INTO "T_Fotoliste" VALUES(706,'14.3.2013 19:12:22',17,8,NULL,'26',3365,11,NULL,3,NULL,NULL,NULL,NULL,'Stein 2 (rechts) mit Verkeilsteinen und Pflasterrest (?). Fluchtstange 1 m.',0,0,NULL,'003365_0017_0008.jpg',NULL,0,'Rinne, Christoph',NULL,0,0,0,0,'003365_0017_0008','D:\temp\20130314\DSC_0076.JPG');
INSERT INTO "T_Fotoliste" VALUES(707,'14.3.2013 19:12:27',17,9,NULL,'26',3365,11,NULL,3,NULL,NULL,NULL,NULL,'Stein 2 (rechts) mit Verkeilsteinen und Pflasterrest (?). Fluchtstange 1 m.',0,0,NULL,'003365_0017_0009.jpg',NULL,0,'Rinne, Christoph',NULL,0,0,0,0,'003365_0017_0009','D:\temp\20130314\DSC_0077.JPG');
INSERT INTO "T_Fotoliste" VALUES(708,'14.3.2013 19:12:30',17,10,NULL,'28',3365,11,NULL,3,NULL,NULL,NULL,'O','Fluchtstange liegt nördlich Stein 4, Tragstein in situ.',0,0,NULL,'003365_0017_0010.jpg',NULL,0,'Rinne, Christoph',NULL,0,0,0,0,'003365_0017_0010','D:\temp\20130314\DSC_0078.JPG');
INSERT INTO "T_Fotoliste" VALUES(709,'26.3.2013 18:50:07',18,1,NULL,'9',3365,10,NULL,3,NULL,NULL,NULL,'S','Megalithgrab AHa009 im Schnee',0,0,NULL,'003365_0018_0001.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0018_0001','D:\temp\DSC_0001.JPG');
INSERT INTO "T_Fotoliste" VALUES(710,'26.3.2013 18:50:07',18,2,NULL,'9',3365,10,NULL,3,NULL,NULL,NULL,'S','Megalithgrab AHa009 im Schnee',0,0,NULL,'003365_0018_0002.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0018_0002','D:\temp\DSC_0003.JPG');
INSERT INTO "T_Fotoliste" VALUES(711,'26.3.2013 18:50:11',18,3,NULL,'9',3365,10,NULL,3,NULL,NULL,NULL,'W','Megalithgrab AHa009 im Schnee, freigefegt',0,0,NULL,'003365_0018_0003.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0018_0003','D:\temp\DSC_0005.JPG');
INSERT INTO "T_Fotoliste" VALUES(712,'26.3.2013 18:50:11',18,4,NULL,'9',3365,10,NULL,3,NULL,NULL,NULL,'N','Megalithgrab AHa009 im Schnee, freigefegt',0,0,NULL,'003365_0018_0004.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0018_0004','D:\temp\DSC_0006.JPG');
INSERT INTO "T_Fotoliste" VALUES(713,'26.3.2013 18:50:14',18,5,NULL,'6',3365,17,NULL,3,NULL,NULL,NULL,'W','Megalithgrab Süplingen Fpl. 6, im Schnee. Traurige Reste',0,0,NULL,'003365_0018_0005.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0018_0005','D:\temp\DSC_0008.JPG');
INSERT INTO "T_Fotoliste" VALUES(714,'26.3.2013 18:50:14',18,6,NULL,'6',3365,17,NULL,3,NULL,NULL,NULL,'NO','Megalithgrab Süplingen Fpl. 6, im Schnee. Traurige Reste',0,0,NULL,'003365_0018_0006.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0018_0006','D:\temp\DSC_0009.JPG');
INSERT INTO "T_Fotoliste" VALUES(715,'26.3.2013 18:50:17',18,7,NULL,'4',3365,17,NULL,3,NULL,NULL,NULL,'S','Verbuschter und vermüllter Bereich im Acker. Unter der iche großer Findling, nach Norden zahlreiche Findlinge und Lesesteine. Fundplatz zerstörtes Megalithgrab.',0,0,NULL,'003365_0018_0007.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0018_0007','D:\temp\DSC_0010.JPG');
INSERT INTO "T_Fotoliste" VALUES(716,'26.3.2013 18:50:18',18,8,NULL,'35',3365,11,NULL,3,NULL,NULL,NULL,'SW','Megalithgrab Alvensleben 35 im Schnee, freigefegt.',0,0,NULL,'003365_0018_0008.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0018_0008','D:\temp\DSC_0012.JPG');
INSERT INTO "T_Fotoliste" VALUES(717,'26.3.2013 18:50:21',18,9,NULL,'35',3365,11,NULL,3,NULL,NULL,NULL,'O','Megalithgrab Alvensleben 35 im Schnee, freigefegt.',0,0,NULL,'003365_0018_0009.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0018_0009','D:\temp\DSC_0013.JPG');
INSERT INTO "T_Fotoliste" VALUES(718,'26.3.2013 18:50:21',18,10,NULL,'35',3365,11,NULL,3,NULL,NULL,NULL,'S','Megalithgrab Alvensleben 35 im Schnee, freigefegt.',0,0,NULL,'003365_0018_0010.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0018_0010','D:\temp\DSC_0014.JPG');
INSERT INTO "T_Fotoliste" VALUES(719,'26.3.2013 18:50:24',18,11,NULL,NULL,3365,1,NULL,3,NULL,NULL,NULL,NULL,'Megalithgrabbegehung und Vermessung C. Rinne im verschneiten Haldensleber Forst. Wald im Schnee.',0,0,NULL,'003365_0018_0011.jpg',NULL,0,NULL,NULL,0,0,0,0,'003365_0018_0011','D:\temp\DSC_0016.JPG');
INSERT INTO "T_Fotoliste" VALUES(720,'26.3.2013 18:50:27',18,12,NULL,'16',3365,15,NULL,3,NULL,NULL,NULL,'S','Megalithgrab Hundisburg 16 im Schnee',0,0,NULL,'003365_0018_0012.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0018_0012','D:\temp\DSC_0019.JPG');
INSERT INTO "T_Fotoliste" VALUES(721,'26.3.2013 18:50:27',18,13,NULL,'16',3365,15,NULL,3,NULL,NULL,NULL,'S','Megalithgrab Hundisburg 16 im Schnee',0,0,NULL,'003365_0018_0013.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0018_0013','D:\temp\DSC_0020.JPG');
INSERT INTO "T_Fotoliste" VALUES(722,'26.3.2013 18:50:30',18,14,NULL,'17',3365,15,NULL,3,NULL,NULL,NULL,'NO','Megalithgrab Hundisburg 17 im Schnee',0,0,NULL,'003365_0018_0014.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0018_0014','D:\temp\DSC_0021.JPG');
INSERT INTO "T_Fotoliste" VALUES(723,'26.3.2013 18:50:30',18,15,NULL,'17',3365,15,NULL,3,NULL,NULL,NULL,'NO','Megalithgrab Hundisburg 17 im Schnee',0,0,NULL,'003365_0018_0015.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0018_0015','D:\temp\DSC_0022.JPG');
INSERT INTO "T_Fotoliste" VALUES(724,'26.3.2013 18:50:34',18,16,NULL,'18',3365,15,NULL,3,NULL,NULL,NULL,'NO','Megalithgrab Hundisburg 18 im Schnee',0,0,NULL,'003365_0018_0016.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0018_0016','D:\temp\DSC_0023.JPG');
INSERT INTO "T_Fotoliste" VALUES(725,'26.3.2013 18:50:34',18,17,NULL,'18',3365,15,NULL,3,NULL,NULL,NULL,'NO','Megalithgrab Hundisburg 18 im Schnee',0,0,NULL,'003365_0018_0017.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0018_0017','D:\temp\DSC_0024.JPG');
INSERT INTO "T_Fotoliste" VALUES(726,'26.3.2013 18:50:37',18,18,NULL,'18',3365,15,NULL,3,NULL,NULL,NULL,'NO','Megalithgrab Hundisburg 18 im Schnee',0,0,NULL,'003365_0018_0018.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0018_0018','D:\temp\DSC_0025.JPG');
INSERT INTO "T_Fotoliste" VALUES(727,'26.3.2013 18:50:37',18,19,NULL,'18',3365,15,NULL,3,NULL,NULL,NULL,'N','Megalithgrab Hundisburg 18 im Schnee',0,0,NULL,'003365_0018_0019.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0018_0019','D:\temp\DSC_0027.JPG');
INSERT INTO "T_Fotoliste" VALUES(728,'14.3.2010 16:33:14',19,1,NULL,'33',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0019_0001.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0019_0001',NULL);
INSERT INTO "T_Fotoliste" VALUES(729,'14.3.2010 16:33:42',19,2,NULL,'33',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0019_0002.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0019_0002',NULL);
INSERT INTO "T_Fotoliste" VALUES(730,'14.3.2010 16:33:58',19,3,NULL,'33',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0019_0003.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0019_0003',NULL);
INSERT INTO "T_Fotoliste" VALUES(731,'14.3.2010 16:34:36',19,4,NULL,'33',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0019_0004.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0019_0004',NULL);
INSERT INTO "T_Fotoliste" VALUES(732,'14.3.2010 16:35:46',19,5,NULL,'33',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0019_0005.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0019_0005',NULL);
INSERT INTO "T_Fotoliste" VALUES(733,'28.2.2012 11:07:04',20,1,NULL,'34',3365,10,NULL,3,'0',NULL,NULL,'W',NULL,0,0,NULL,'003365_0020_0001.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0020_0001',NULL);
INSERT INTO "T_Fotoliste" VALUES(734,'29.2.2012 15:06:22',20,2,NULL,'34',3365,10,NULL,3,'0',NULL,NULL,NULL,NULL,0,0,NULL,'003365_0020_0002.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0020_0002',NULL);
INSERT INTO "T_Fotoliste" VALUES(735,'29.2.2012 16:27:52',20,3,NULL,'34',3365,10,NULL,3,NULL,'1',NULL,'N',NULL,0,0,NULL,'003365_0020_0003.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0020_0003',NULL);
INSERT INTO "T_Fotoliste" VALUES(736,'1.3.2012 10:40:28',20,4,NULL,'34',3365,10,NULL,3,NULL,NULL,NULL,'O','Arbeitsfoto',0,0,NULL,'003365_0020_0004.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0020_0004',NULL);
INSERT INTO "T_Fotoliste" VALUES(737,'1.3.2012 12:10:12',20,5,NULL,'34',3365,10,NULL,3,NULL,NULL,NULL,'N','mittiges Längsprofil',0,0,NULL,'003365_0020_0005.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0020_0005',NULL);
INSERT INTO "T_Fotoliste" VALUES(738,'1.3.2012 15:45:12',20,6,NULL,'34',3365,10,NULL,3,NULL,NULL,NULL,NULL,'Arbeitsfoto',0,0,NULL,'003365_0020_0006.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0020_0006',NULL);
INSERT INTO "T_Fotoliste" VALUES(739,'1.3.2012 18:46:56',20,7,NULL,'34',3365,10,NULL,3,'3',NULL,NULL,NULL,NULL,0,0,NULL,'003365_0020_0007.jpg',NULL,0,'Rinne',NULL,0,0,0,0,'003365_0020_0007',NULL);
INSERT INTO "T_Fotoliste" VALUES(740,'24.5.2013 07:39:55',21,1,NULL,'2',3365,11,NULL,3,NULL,NULL,NULL,'NW','Reste Veltheimsburg, Alv. Fpl. 2, birnenförmige Steinhaufen von ca. 10 m Länge',0,0,NULL,'003365_0021_0001.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0001','C:\Users\crinne\Desktop\foto130524\DSC_0003.JPG');
INSERT INTO "T_Fotoliste" VALUES(741,'24.5.2013 07:40:07',21,2,NULL,'2',3365,11,NULL,3,NULL,NULL,NULL,'N','Reste Veltheimsburg, Alv. Fpl. 2, birnenförmige Steinhaufen von ca. 10 m Länge',0,0,NULL,'003365_0021_0002.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0002','C:\Users\crinne\Desktop\foto130524\DSC_0004.JPG');
INSERT INTO "T_Fotoliste" VALUES(742,'24.5.2013 07:40:28',21,3,NULL,'2',3365,11,NULL,3,NULL,NULL,NULL,'S','Reste Veltheimsburg, Alv. Fpl. 2, birnenförmige Steinhaufen von ca. 10 m Länge',0,0,NULL,'003365_0021_0003.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0003','C:\Users\crinne\Desktop\foto130524\DSC_0005.JPG');
INSERT INTO "T_Fotoliste" VALUES(743,'24.5.2013 08:49:09',21,4,NULL,'2',3365,11,NULL,3,NULL,NULL,NULL,'O','Reste Veltheimsburg, Alv. Fpl. 2, birnenförmige Steinhaufen von ca. 10 m Länge',0,0,NULL,'003365_0021_0004.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0004','C:\Users\crinne\Desktop\foto130524\DSC_0007.JPG');
INSERT INTO "T_Fotoliste" VALUES(744,'24.5.2013 12:11:47',21,5,NULL,'37',3365,11,NULL,3,NULL,NULL,NULL,'W','Angeblich Megalithgrab, Alvensleben Fpl. 37. Einfache Steinreihe parallel zur Niederung. Zusammenhang mit Veldheimsburg scheint eher plausibel.',0,0,NULL,'003365_0021_0005.jpg',NULL,0,NULL,NULL,0,0,0,0,'003365_0021_0005','C:\Users\crinne\Desktop\foto130524\DSC_0017.JPG');
INSERT INTO "T_Fotoliste" VALUES(745,'24.5.2013 13:24:07',21,6,NULL,'45',3365,11,NULL,3,NULL,NULL,NULL,'S','Alv. Fpl. 45, Dolmen. Serie Rundumblick im Norden beginnend',0,0,NULL,'003365_0021_0006.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0006','C:\Users\crinne\Desktop\foto130524\DSC_0021.JPG');
INSERT INTO "T_Fotoliste" VALUES(746,'24.5.2013 13:24:38',21,7,NULL,'45',3365,11,NULL,3,NULL,NULL,NULL,'SW','Alv. Fpl. 45, Dolmen. Serie Rundumblick im Norden beginnend',0,0,NULL,'003365_0021_0007.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0007','C:\Users\crinne\Desktop\foto130524\DSC_0023.JPG');
INSERT INTO "T_Fotoliste" VALUES(747,'24.5.2013 13:24:45',21,8,NULL,'45',3365,11,NULL,3,NULL,NULL,NULL,'SW','Alv. Fpl. 45, Dolmen. Serie Rundumblick im Norden beginnend',0,0,NULL,'003365_0021_0008.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0008','C:\Users\crinne\Desktop\foto130524\DSC_0024.JPG');
INSERT INTO "T_Fotoliste" VALUES(748,'24.5.2013 13:24:57',21,9,NULL,'45',3365,11,NULL,3,NULL,NULL,NULL,'W','Alv. Fpl. 45, Dolmen. Serie Rundumblick im Norden beginnend',0,0,NULL,'003365_0021_0009.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0009','C:\Users\crinne\Desktop\foto130524\DSC_0025.JPG');
INSERT INTO "T_Fotoliste" VALUES(749,'24.5.2013 13:25:05',21,10,NULL,'45',3365,11,NULL,3,NULL,NULL,NULL,'W','Alv. Fpl. 45, Dolmen. Serie Rundumblick im Norden beginnend',0,0,NULL,'003365_0021_0010.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0010','C:\Users\crinne\Desktop\foto130524\DSC_0026.JPG');
INSERT INTO "T_Fotoliste" VALUES(750,'24.5.2013 13:25:17',21,11,NULL,'45',3365,11,NULL,3,NULL,NULL,NULL,'NW','Alv. Fpl. 45, Dolmen. Serie Rundumblick im Norden beginnend',0,0,NULL,'003365_0021_0011.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0011','C:\Users\crinne\Desktop\foto130524\DSC_0027.JPG');
INSERT INTO "T_Fotoliste" VALUES(751,'24.5.2013 13:25:28',21,12,NULL,'45',3365,11,NULL,3,NULL,NULL,NULL,'NW','Alv. Fpl. 45, Dolmen. Serie Rundumblick im Norden beginnend',0,0,NULL,'003365_0021_0012.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0012','C:\Users\crinne\Desktop\foto130524\DSC_0028.JPG');
INSERT INTO "T_Fotoliste" VALUES(752,'24.5.2013 13:25:34',21,13,NULL,'45',3365,11,NULL,3,NULL,NULL,NULL,'NW','Alv. Fpl. 45, Dolmen. Serie Rundumblick im Norden beginnend',0,0,NULL,'003365_0021_0013.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0013','C:\Users\crinne\Desktop\foto130524\DSC_0029.JPG');
INSERT INTO "T_Fotoliste" VALUES(753,'24.5.2013 13:25:57',21,14,NULL,'45',3365,11,NULL,3,NULL,NULL,NULL,'N','Alv. Fpl. 45, Dolmen. Serie Rundumblick im Norden beginnend',0,0,NULL,'003365_0021_0014.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0014','C:\Users\crinne\Desktop\foto130524\DSC_0030.JPG');
INSERT INTO "T_Fotoliste" VALUES(754,'24.5.2013 13:26:22',21,15,NULL,'45',3365,11,NULL,3,NULL,NULL,NULL,'NO','Alv. Fpl. 45, Dolmen. Serie Rundumblick im Norden beginnend',0,0,NULL,'003365_0021_0015.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0015','C:\Users\crinne\Desktop\foto130524\DSC_0031.JPG');
INSERT INTO "T_Fotoliste" VALUES(755,'24.5.2013 13:26:54',21,16,NULL,'45',3365,11,NULL,3,NULL,NULL,NULL,'NO','Alv. Fpl. 45, Dolmen. Serie Rundumblick im Norden beginnend',0,0,NULL,'003365_0021_0016.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0016','C:\Users\crinne\Desktop\foto130524\DSC_0032.JPG');
INSERT INTO "T_Fotoliste" VALUES(756,'24.5.2013 13:27:06',21,17,NULL,'45',3365,11,NULL,3,NULL,NULL,NULL,'NO','Alv. Fpl. 45, Dolmen. Serie Rundumblick im Norden beginnend',0,0,NULL,'003365_0021_0017.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0017','C:\Users\crinne\Desktop\foto130524\DSC_0033.JPG');
INSERT INTO "T_Fotoliste" VALUES(757,'24.5.2013 13:27:34',21,18,NULL,'45',3365,11,NULL,3,NULL,NULL,NULL,'O','Alv. Fpl. 45, Dolmen. Serie Rundumblick im Norden beginnend',0,0,NULL,'003365_0021_0018.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0018','C:\Users\crinne\Desktop\foto130524\DSC_0034.JPG');
INSERT INTO "T_Fotoliste" VALUES(758,'24.5.2013 13:27:54',21,19,NULL,'45',3365,11,NULL,3,NULL,NULL,NULL,'SO','Alv. Fpl. 45, Dolmen. Serie Rundumblick im Norden beginnend',0,0,NULL,'003365_0021_0019.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0019','C:\Users\crinne\Desktop\foto130524\DSC_0035.JPG');
INSERT INTO "T_Fotoliste" VALUES(759,'24.5.2013 13:55:08',21,20,NULL,'45',3365,11,NULL,3,NULL,NULL,NULL,'SW','Alv. Fpl. 45, Dolmen. Maßstab',0,0,NULL,'003365_0021_0020.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0020','C:\Users\crinne\Desktop\foto130524\DSC_0037.JPG');
INSERT INTO "T_Fotoliste" VALUES(760,'24.5.2013 13:55:35',21,21,NULL,'45',3365,11,NULL,3,NULL,NULL,NULL,'NO','Alv. Fpl. 45, Dolmen. Maßstab',0,0,NULL,'003365_0021_0021.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0021','C:\Users\crinne\Desktop\foto130524\DSC_0038.JPG');
INSERT INTO "T_Fotoliste" VALUES(761,'24.5.2013 13:55:58',21,22,NULL,'45',3365,11,NULL,3,NULL,NULL,NULL,'NW','Alv. Fpl. 45, Dolmen. Maßstab',0,0,NULL,'003365_0021_0022.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0022','C:\Users\crinne\Desktop\foto130524\DSC_0039.JPG');
INSERT INTO "T_Fotoliste" VALUES(762,'24.5.2013 14:22:48',21,23,NULL,'44',3365,11,NULL,3,NULL,NULL,NULL,'W','Ganggrab Alv. Fpl. 44',0,0,NULL,'003365_0021_0023.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0023','C:\Users\crinne\Desktop\foto130524\DSC_0040.JPG');
INSERT INTO "T_Fotoliste" VALUES(763,'24.5.2013 14:23:22',21,24,NULL,'44',3365,11,NULL,3,NULL,NULL,NULL,'W','Ganggrab Alv. Fpl. 44',0,0,NULL,'003365_0021_0024.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0024','C:\Users\crinne\Desktop\foto130524\DSC_0042.JPG');
INSERT INTO "T_Fotoliste" VALUES(764,'24.5.2013 14:23:42',21,25,NULL,'44',3365,11,NULL,3,NULL,NULL,NULL,'W','Ganggrab Alv. Fpl. 44',0,0,NULL,'003365_0021_0025.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0025','C:\Users\crinne\Desktop\foto130524\DSC_0043.JPG');
INSERT INTO "T_Fotoliste" VALUES(765,'24.5.2013 14:24:09',21,26,NULL,'44',3365,11,NULL,3,NULL,NULL,NULL,'SW','Ganggrab Alv. Fpl. 44',0,0,NULL,'003365_0021_0026.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0026','C:\Users\crinne\Desktop\foto130524\DSC_0044.JPG');
INSERT INTO "T_Fotoliste" VALUES(766,'24.5.2013 15:43:09',21,27,NULL,'41',3365,11,NULL,3,NULL,NULL,NULL,'O','Dolmen Alvensleben Fpl. 41',0,0,NULL,'003365_0021_0027.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0027','C:\Users\crinne\Desktop\foto130524\DSC_0045.JPG');
INSERT INTO "T_Fotoliste" VALUES(767,'24.5.2013 15:43:24',21,28,NULL,'41',3365,11,NULL,3,NULL,NULL,NULL,'O','Dolmen Alvensleben Fpl. 41',0,0,NULL,'003365_0021_0028.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0028','C:\Users\crinne\Desktop\foto130524\DSC_0046.JPG');
INSERT INTO "T_Fotoliste" VALUES(768,'24.5.2013 15:45:06',21,29,NULL,'41',3365,11,NULL,3,NULL,NULL,NULL,'O','Dolmen Alvensleben Fpl. 41',0,0,NULL,'003365_0021_0029.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0029','C:\Users\crinne\Desktop\foto130524\DSC_0049.JPG');
INSERT INTO "T_Fotoliste" VALUES(769,'24.5.2013 15:45:44',21,30,NULL,'41',3365,11,NULL,3,NULL,NULL,NULL,'O','Dolmen Alvensleben Fpl. 41',0,0,NULL,'003365_0021_0030.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0021_0030','C:\Users\crinne\Desktop\foto130524\DSC_0050.JPG');
INSERT INTO "T_Fotoliste" VALUES(770,'25.5.2013 08:24:25',22,1,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'S','Dolmen Alvensleben Fpl. 30. Bildserie Runblick von Norden beginnend.',0,0,NULL,'003365_0022_0001.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0001','C:\Users\crinne\Desktop\foto130525\DSC_0052.JPG');
INSERT INTO "T_Fotoliste" VALUES(771,'25.5.2013 08:24:35',22,2,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'S','Dolmen Alvensleben Fpl. 30. Bildserie Runblick von Norden beginnend.',0,0,NULL,'003365_0022_0002.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0002','C:\Users\crinne\Desktop\foto130525\DSC_0053.JPG');
INSERT INTO "T_Fotoliste" VALUES(772,'25.5.2013 08:24:51',22,3,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'SW','Dolmen Alvensleben Fpl. 30. Bildserie Runblick von Norden beginnend.',0,0,NULL,'003365_0022_0003.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0003','C:\Users\crinne\Desktop\foto130525\DSC_0054.JPG');
INSERT INTO "T_Fotoliste" VALUES(773,'25.5.2013 08:25:15',22,4,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'W','Dolmen Alvensleben Fpl. 30. Bildserie Runblick von Norden beginnend.',0,0,NULL,'003365_0022_0004.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0004','C:\Users\crinne\Desktop\foto130525\DSC_0055.JPG');
INSERT INTO "T_Fotoliste" VALUES(774,'25.5.2013 08:25:31',22,5,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'NW','Dolmen Alvensleben Fpl. 30. Bildserie Runblick von Norden beginnend.',0,0,NULL,'003365_0022_0005.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0005','C:\Users\crinne\Desktop\foto130525\DSC_0056.JPG');
INSERT INTO "T_Fotoliste" VALUES(775,'25.5.2013 08:25:59',22,6,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'NW','Dolmen Alvensleben Fpl. 30. Bildserie Runblick von Norden beginnend.',0,0,NULL,'003365_0022_0006.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0006','C:\Users\crinne\Desktop\foto130525\DSC_0057.JPG');
INSERT INTO "T_Fotoliste" VALUES(776,'25.5.2013 08:26:20',22,7,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'NO','Dolmen Alvensleben Fpl. 30. Bildserie Runblick von Norden beginnend.',0,0,NULL,'003365_0022_0007.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0007','C:\Users\crinne\Desktop\foto130525\DSC_0058.JPG');
INSERT INTO "T_Fotoliste" VALUES(777,'25.5.2013 08:26:48',22,8,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'NW','Dolmen Alvensleben Fpl. 30. Bildserie Runblick von Norden beginnend.',0,0,NULL,'003365_0022_0008.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0008','C:\Users\crinne\Desktop\foto130525\DSC_0059.JPG');
INSERT INTO "T_Fotoliste" VALUES(778,'25.5.2013 08:27:13',22,9,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'NO','Dolmen Alvensleben Fpl. 30. Bildserie Runblick von Norden beginnend.',0,0,NULL,'003365_0022_0009.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0009','C:\Users\crinne\Desktop\foto130525\DSC_0060.JPG');
INSERT INTO "T_Fotoliste" VALUES(779,'25.5.2013 08:28:19',22,10,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'NO','Dolmen Alvensleben Fpl. 30. Bildserie Runblick von Norden beginnend.',0,0,NULL,'003365_0022_0010.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0010','C:\Users\crinne\Desktop\foto130525\DSC_0061.JPG');
INSERT INTO "T_Fotoliste" VALUES(780,'25.5.2013 08:28:58',22,11,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'O','Dolmen Alvensleben Fpl. 30. Bildserie Runblick von Norden beginnend.',0,0,NULL,'003365_0022_0011.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0011','C:\Users\crinne\Desktop\foto130525\DSC_0062.JPG');
INSERT INTO "T_Fotoliste" VALUES(781,'25.5.2013 08:29:24',22,12,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'SO','Dolmen Alvensleben Fpl. 30. Bildserie Runblick von Norden beginnend.',0,0,NULL,'003365_0022_0012.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0012','C:\Users\crinne\Desktop\foto130525\DSC_0063.JPG');
INSERT INTO "T_Fotoliste" VALUES(782,'25.5.2013 08:30:19',22,13,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'SW','Dolmen Alvensleben Fpl. 30. Maßstab',0,0,NULL,'003365_0022_0013.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0013','C:\Users\crinne\Desktop\foto130525\DSC_0064.JPG');
INSERT INTO "T_Fotoliste" VALUES(783,'25.5.2013 09:07:48',22,14,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,'N','(Polygonal?) Dolmen Alvensleben Fpl. 29',0,0,NULL,'003365_0022_0014.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0014','C:\Users\crinne\Desktop\foto130525\DSC_0065.JPG');
INSERT INTO "T_Fotoliste" VALUES(784,'25.5.2013 09:40:24',22,15,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,'S','(Polygonal?) Dolmen Alvensleben Fpl. 29',0,0,NULL,'003365_0022_0015.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0015','C:\Users\crinne\Desktop\foto130525\DSC_0066.JPG');
INSERT INTO "T_Fotoliste" VALUES(785,'25.5.2013 09:40:39',22,16,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,'SW','(Polygonal?) Dolmen Alvensleben Fpl. 29',0,0,NULL,'003365_0022_0016.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0016','C:\Users\crinne\Desktop\foto130525\DSC_0067.JPG');
INSERT INTO "T_Fotoliste" VALUES(786,'25.5.2013 09:40:50',22,17,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,'SW','(Polygonal?) Dolmen Alvensleben Fpl. 29',0,0,NULL,'003365_0022_0017.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0017','C:\Users\crinne\Desktop\foto130525\DSC_0068.JPG');
INSERT INTO "T_Fotoliste" VALUES(787,'25.5.2013 09:41:08',22,18,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,'W','(Polygonal?) Dolmen Alvensleben Fpl. 29',0,0,NULL,'003365_0022_0018.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0018','C:\Users\crinne\Desktop\foto130525\DSC_0069.JPG');
INSERT INTO "T_Fotoliste" VALUES(788,'25.5.2013 09:41:21',22,19,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,'W','(Polygonal?) Dolmen Alvensleben Fpl. 29',0,0,NULL,'003365_0022_0019.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0019','C:\Users\crinne\Desktop\foto130525\DSC_0070.JPG');
INSERT INTO "T_Fotoliste" VALUES(789,'25.5.2013 09:41:36',22,20,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,'NW','(Polygonal?) Dolmen Alvensleben Fpl. 29',0,0,NULL,'003365_0022_0020.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0020','C:\Users\crinne\Desktop\foto130525\DSC_0071.JPG');
INSERT INTO "T_Fotoliste" VALUES(790,'25.5.2013 09:41:49',22,21,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,'NW','(Polygonal?) Dolmen Alvensleben Fpl. 29',0,0,NULL,'003365_0022_0021.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0021','C:\Users\crinne\Desktop\foto130525\DSC_0072.JPG');
INSERT INTO "T_Fotoliste" VALUES(791,'25.5.2013 09:42:03',22,22,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,'N','(Polygonal?) Dolmen Alvensleben Fpl. 29',0,0,NULL,'003365_0022_0022.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0022','C:\Users\crinne\Desktop\foto130525\DSC_0073.JPG');
INSERT INTO "T_Fotoliste" VALUES(792,'25.5.2013 09:42:17',22,23,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,'N','(Polygonal?) Dolmen Alvensleben Fpl. 29',0,0,NULL,'003365_0022_0023.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0023','C:\Users\crinne\Desktop\foto130525\DSC_0074.JPG');
INSERT INTO "T_Fotoliste" VALUES(793,'25.5.2013 09:42:39',22,24,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,'NO','(Polygonal?) Dolmen Alvensleben Fpl. 29',0,0,NULL,'003365_0022_0024.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0024','C:\Users\crinne\Desktop\foto130525\DSC_0075.JPG');
INSERT INTO "T_Fotoliste" VALUES(794,'25.5.2013 09:42:56',22,25,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,'NO','(Polygonal?) Dolmen Alvensleben Fpl. 29',0,0,NULL,'003365_0022_0025.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0025','C:\Users\crinne\Desktop\foto130525\DSC_0076.JPG');
INSERT INTO "T_Fotoliste" VALUES(795,'25.5.2013 09:43:10',22,26,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,'O','(Polygonal?) Dolmen Alvensleben Fpl. 29',0,0,NULL,'003365_0022_0026.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0026','C:\Users\crinne\Desktop\foto130525\DSC_0077.JPG');
INSERT INTO "T_Fotoliste" VALUES(796,'25.5.2013 09:43:22',22,27,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,'O','(Polygonal?) Dolmen Alvensleben Fpl. 29',0,0,NULL,'003365_0022_0027.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0027','C:\Users\crinne\Desktop\foto130525\DSC_0078.JPG');
INSERT INTO "T_Fotoliste" VALUES(797,'25.5.2013 09:43:50',22,28,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,'SO','(Polygonal?) Dolmen Alvensleben Fpl. 29',0,0,NULL,'003365_0022_0028.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0028','C:\Users\crinne\Desktop\foto130525\DSC_0079.JPG');
INSERT INTO "T_Fotoliste" VALUES(798,'25.5.2013 09:45:06',22,29,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,'O','(Polygonal?) Dolmen Alvensleben Fpl. 29. Maßstab',0,0,NULL,'003365_0022_0029.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0029','C:\Users\crinne\Desktop\foto130525\DSC_0080.JPG');
INSERT INTO "T_Fotoliste" VALUES(799,'25.5.2013 09:45:26',22,30,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,'SO','(Polygonal?) Dolmen Alvensleben Fpl. 29. Maßstab',0,0,NULL,'003365_0022_0030.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0030','C:\Users\crinne\Desktop\foto130525\DSC_0081.JPG');
INSERT INTO "T_Fotoliste" VALUES(800,'25.5.2013 10:39:13',22,31,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'O','Ganggrab Alvensleben Fpl. 22, Zugewachsen mit Pflanzen (Farn)',0,0,NULL,'003365_0022_0031.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0031','C:\Users\crinne\Desktop\foto130525\DSC_0082.JPG');
INSERT INTO "T_Fotoliste" VALUES(801,'25.5.2013 10:39:29',22,32,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'O','Ganggrab Alvensleben Fpl. 22, Zugewachsen mit Pflanzen (Farn)',0,0,NULL,'003365_0022_0032.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0032','C:\Users\crinne\Desktop\foto130525\DSC_0083.JPG');
INSERT INTO "T_Fotoliste" VALUES(802,'25.5.2013 10:40:30',22,33,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'SW','Ganggrab Alvensleben Fpl. 22, Zugewachsen mit Pflanzen (Farn)',0,0,NULL,'003365_0022_0033.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0033','C:\Users\crinne\Desktop\foto130525\DSC_0084.JPG');
INSERT INTO "T_Fotoliste" VALUES(803,'25.5.2013 10:40:45',22,34,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'SW','Ganggrab Alvensleben Fpl. 22, Zugewachsen mit Pflanzen (Farn)',0,0,NULL,'003365_0022_0034.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0034','C:\Users\crinne\Desktop\foto130525\DSC_0085.JPG');
INSERT INTO "T_Fotoliste" VALUES(804,'25.5.2013 12:49:36',22,35,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'S','Ganggrab Alvensleben Fpl. 22, Zugewachsen mit Pflanzen (Farn)',0,0,NULL,'003365_0022_0035.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0035','C:\Users\crinne\Desktop\foto130525\DSC_0086.JPG');
INSERT INTO "T_Fotoliste" VALUES(805,'25.5.2013 12:50:00',22,36,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'SO','Ganggrab Alvensleben Fpl. 22, Zugewachsen mit Pflanzen (Farn)',0,0,NULL,'003365_0022_0036.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0036','C:\Users\crinne\Desktop\foto130525\DSC_0087.JPG');
INSERT INTO "T_Fotoliste" VALUES(806,'25.5.2013 12:50:44',22,37,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'S','Ganggrab Alvensleben Fpl. 22. Bildserie Rudblick von Norden beginnen.',0,0,NULL,'003365_0022_0037.jpg',NULL,0,NULL,NULL,0,0,0,0,'003365_0022_0037','C:\Users\crinne\Desktop\foto130525\DSC_0089.JPG');
INSERT INTO "T_Fotoliste" VALUES(807,'25.5.2013 12:51:06',22,38,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'SW','Ganggrab Alvensleben Fpl. 22. Bildserie Rudblick von Norden beginnen.',0,0,NULL,'003365_0022_0038.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0038','C:\Users\crinne\Desktop\foto130525\DSC_0090.JPG');
INSERT INTO "T_Fotoliste" VALUES(808,'25.5.2013 12:51:40',22,39,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'SW','Ganggrab Alvensleben Fpl. 22. Bildserie Rudblick von Norden beginnen.',0,0,NULL,'003365_0022_0039.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0039','C:\Users\crinne\Desktop\foto130525\DSC_0091.JPG');
INSERT INTO "T_Fotoliste" VALUES(809,'25.5.2013 12:51:57',22,40,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'SW','Ganggrab Alvensleben Fpl. 22. Bildserie Rudblick von Norden beginnen.',0,0,NULL,'003365_0022_0040.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0040','C:\Users\crinne\Desktop\foto130525\DSC_0092.JPG');
INSERT INTO "T_Fotoliste" VALUES(810,'25.5.2013 12:52:40',22,41,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'SW','Ganggrab Alvensleben Fpl. 22. Bildserie Rudblick von Norden beginnen.',0,0,NULL,'003365_0022_0041.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0041','C:\Users\crinne\Desktop\foto130525\DSC_0093.JPG');
INSERT INTO "T_Fotoliste" VALUES(811,'25.5.2013 12:53:10',22,42,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'W','Ganggrab Alvensleben Fpl. 22. Bildserie Rudblick von Norden beginnen.',0,0,NULL,'003365_0022_0042.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0042','C:\Users\crinne\Desktop\foto130525\DSC_0094.JPG');
INSERT INTO "T_Fotoliste" VALUES(812,'25.5.2013 12:53:24',22,43,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'W','Ganggrab Alvensleben Fpl. 22. Bildserie Rudblick von Norden beginnen.',0,0,NULL,'003365_0022_0043.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0043','C:\Users\crinne\Desktop\foto130525\DSC_0095.JPG');
INSERT INTO "T_Fotoliste" VALUES(813,'25.5.2013 12:53:45',22,44,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'W','Ganggrab Alvensleben Fpl. 22. Bildserie Rudblick von Norden beginnen.',0,0,NULL,'003365_0022_0044.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0044','C:\Users\crinne\Desktop\foto130525\DSC_0096.JPG');
INSERT INTO "T_Fotoliste" VALUES(814,'25.5.2013 12:53:57',22,45,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'NW','Ganggrab Alvensleben Fpl. 22. Bildserie Rudblick von Norden beginnen.',0,0,NULL,'003365_0022_0045.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0045','C:\Users\crinne\Desktop\foto130525\DSC_0097.JPG');
INSERT INTO "T_Fotoliste" VALUES(815,'25.5.2013 12:54:11',22,46,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'NW','Ganggrab Alvensleben Fpl. 22. Bildserie Rudblick von Norden beginnen.',0,0,NULL,'003365_0022_0046.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0046','C:\Users\crinne\Desktop\foto130525\DSC_0098.JPG');
INSERT INTO "T_Fotoliste" VALUES(816,'25.5.2013 12:55:30',22,47,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'N','Ganggrab Alvensleben Fpl. 22. Bildserie Rudblick von Norden beginnen.',0,0,NULL,'003365_0022_0047.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0047','C:\Users\crinne\Desktop\foto130525\DSC_0099.JPG');
INSERT INTO "T_Fotoliste" VALUES(817,'25.5.2013 12:55:49',22,48,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'N','Ganggrab Alvensleben Fpl. 22. Bildserie Rudblick von Norden beginnen.',0,0,NULL,'003365_0022_0048.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0048','C:\Users\crinne\Desktop\foto130525\DSC_0100.JPG');
INSERT INTO "T_Fotoliste" VALUES(818,'25.5.2013 12:56:41',22,49,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'NO','Ganggrab Alvensleben Fpl. 22. Bildserie Rudblick von Norden beginnen.',0,0,NULL,'003365_0022_0049.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0049','C:\Users\crinne\Desktop\foto130525\DSC_0101.JPG');
INSERT INTO "T_Fotoliste" VALUES(819,'25.5.2013 12:56:58',22,50,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'NO','Ganggrab Alvensleben Fpl. 22. Bildserie Rudblick von Norden beginnen.',0,0,NULL,'003365_0022_0050.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0050','C:\Users\crinne\Desktop\foto130525\DSC_0102.JPG');
INSERT INTO "T_Fotoliste" VALUES(820,'25.5.2013 12:57:17',22,51,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'O','Ganggrab Alvensleben Fpl. 22. Bildserie Rudblick von Norden beginnen.',0,0,NULL,'003365_0022_0051.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0051','C:\Users\crinne\Desktop\foto130525\DSC_0103.JPG');
INSERT INTO "T_Fotoliste" VALUES(821,'25.5.2013 12:57:34',22,52,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'O','Ganggrab Alvensleben Fpl. 22. Bildserie Rudblick von Norden beginnen.',0,0,NULL,'003365_0022_0052.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0052','C:\Users\crinne\Desktop\foto130525\DSC_0104.JPG');
INSERT INTO "T_Fotoliste" VALUES(822,'25.5.2013 12:57:50',22,53,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'O','Ganggrab Alvensleben Fpl. 22. Bildserie Rudblick von Norden beginnen.',0,0,NULL,'003365_0022_0053.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0053','C:\Users\crinne\Desktop\foto130525\DSC_0105.JPG');
INSERT INTO "T_Fotoliste" VALUES(823,'25.5.2013 12:58:06',22,54,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'SO','Ganggrab Alvensleben Fpl. 22. Bildserie Rudblick von Norden beginnen.',0,0,NULL,'003365_0022_0054.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0054','C:\Users\crinne\Desktop\foto130525\DSC_0106.JPG');
INSERT INTO "T_Fotoliste" VALUES(824,'25.5.2013 12:58:23',22,55,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'O','Ganggrab Alvensleben Fpl. 22. Zwickelmauerwerk außen an westlicher Langseite, u.a. mit 2 Flinttrümmern',0,0,NULL,'003365_0022_0055.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0055','C:\Users\crinne\Desktop\foto130525\DSC_0107.JPG');
INSERT INTO "T_Fotoliste" VALUES(825,'25.5.2013 13:00:44',22,56,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'S','Ganggrab Alvensleben Fpl. 22. Maßstab',0,0,NULL,'003365_0022_0056.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0056','C:\Users\crinne\Desktop\foto130525\DSC_0108.JPG');
INSERT INTO "T_Fotoliste" VALUES(826,'25.5.2013 13:01:22',22,57,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'N','Ganggrab Alvensleben Fpl. 22. Maßstab',0,0,NULL,'003365_0022_0057.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0057','C:\Users\crinne\Desktop\foto130525\DSC_0110.JPG');
INSERT INTO "T_Fotoliste" VALUES(827,'25.5.2013 14:46:35',22,58,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,'S','Ganggrab Alvensleben Fpl. 20. Maßstab',0,0,NULL,'003365_0022_0058.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0058','C:\Users\crinne\Desktop\foto130525\DSC_0111.JPG');
INSERT INTO "T_Fotoliste" VALUES(828,'25.5.2013 14:49:31',22,59,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,'W','Ganggrab Alvensleben Fpl. 20. Maßstab',0,0,NULL,'003365_0022_0059.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0059','C:\Users\crinne\Desktop\foto130525\DSC_0112.JPG');
INSERT INTO "T_Fotoliste" VALUES(829,'25.5.2013 14:50:05',22,60,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,'N','Ganggrab Alvensleben Fpl. 20. Maßstab',0,0,NULL,'003365_0022_0060.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0060','C:\Users\crinne\Desktop\foto130525\DSC_0113.JPG');
INSERT INTO "T_Fotoliste" VALUES(830,'25.5.2013 14:51:01',22,61,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,'O','Ganggrab Alvensleben Fpl. 20. Maßstab',0,0,NULL,'003365_0022_0061.jpg',NULL,0,'Christoph Rinne',NULL,0,0,0,0,'003365_0022_0061','C:\Users\crinne\Desktop\foto130525\DSC_0114.JPG');
INSERT INTO "T_Fotoliste" VALUES(831,'21.5.2014 11:19:56',23,1,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'NO','Ausgrabung K. Schwertfeger',0,0,NULL,'003365_0023_0001.jpg',NULL,0,'B. Fritsch',NULL,0,0,0,0,'003365_0023_0001',NULL);
INSERT INTO "T_Fotoliste" VALUES(832,'21.5.2014 11:20:20',23,2,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'O','Ausgrabung K. Schwertfeger',0,0,NULL,'003365_0023_0002.jpg',NULL,0,'B. Fritsch',NULL,0,0,0,0,'003365_0023_0002',NULL);
INSERT INTO "T_Fotoliste" VALUES(833,'21.5.2014 11:20:36',23,3,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'SO','Ausgrabung K. Schwertfeger',0,0,NULL,'003365_0023_0003.jpg',NULL,0,'B. Fritsch',NULL,0,0,0,0,'003365_0023_0003',NULL);
INSERT INTO "T_Fotoliste" VALUES(834,'21.5.2014 11:21:02',23,4,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'S','Ausgrabung K. Schwertfeger',0,0,NULL,'003365_0023_0004.jpg',NULL,0,'B. Fritsch',NULL,0,0,0,0,'003365_0023_0004',NULL);
INSERT INTO "T_Fotoliste" VALUES(835,'21.5.2014 11:21:26',23,5,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'S','Ausgrabung K. Schwertfeger',0,0,NULL,'003365_0023_0005.jpg',NULL,0,'B. Fritsch',NULL,0,0,0,0,'003365_0023_0005',NULL);
INSERT INTO "T_Fotoliste" VALUES(836,'21.5.2014 11:21:32',23,6,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'S','Ausgrabung K. Schwertfeger',0,0,NULL,'003365_0023_0006.jpg',NULL,0,'B. Fritsch',NULL,0,0,0,0,'003365_0023_0006',NULL);
INSERT INTO "T_Fotoliste" VALUES(837,'21.5.2014 11:21:36',23,7,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'S','Ausgrabung K. Schwertfeger, Kammerinnere',0,0,NULL,'003365_0023_0007.jpg',NULL,0,'B. Fritsch',NULL,0,0,0,0,'003365_0023_0007',NULL);
INSERT INTO "T_Fotoliste" VALUES(838,'21.5.2014 11:21:46',23,8,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'SW','Ausgrabung K. Schwertfeger, Kammerinnere',0,0,NULL,'003365_0023_0008.jpg',NULL,0,'B. Fritsch',NULL,0,0,0,0,'003365_0023_0008',NULL);
INSERT INTO "T_Fotoliste" VALUES(839,'21.5.2014 11:22:08',23,9,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'S','Ausgrabung K. Schwertfeger, Kammerinnere',0,0,NULL,'003365_0023_0009.jpg',NULL,0,'B. Fritsch',NULL,0,0,0,0,'003365_0023_0009',NULL);
INSERT INTO "T_Fotoliste" VALUES(840,'21.5.2014 11:22:14',23,10,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'S','Ausgrabung K. Schwertfeger, Kammerinnere',0,0,NULL,'003365_0023_0010.jpg',NULL,0,'B. Fritsch',NULL,0,0,0,0,'003365_0023_0010',NULL);
INSERT INTO "T_Fotoliste" VALUES(841,'21.5.2014 11:22:20',23,11,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'SO','Ausgrabung K. Schwertfeger, Bett Einfassung mit Standspuren',0,0,NULL,'003365_0023_0011.jpg',NULL,0,'B. Fritsch',NULL,0,0,0,0,'003365_0023_0011',NULL);
INSERT INTO "T_Fotoliste" VALUES(842,'21.5.2014 11:22:32',23,12,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'SW','Ausgrabung K. Schwertfeger, Bett Einfassung mit Standspuren',0,0,NULL,'003365_0023_0012.jpg',NULL,0,'B. Fritsch',NULL,0,0,0,0,'003365_0023_0012',NULL);
INSERT INTO "T_Fotoliste" VALUES(843,'21.5.2014 11:22:44',23,13,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'W','Ausgrabung K. Schwertfeger, Bett Einfassung mit Standspuren',0,0,NULL,'003365_0023_0013.jpg',NULL,0,'B. Fritsch',NULL,0,0,0,0,'003365_0023_0013',NULL);
INSERT INTO "T_Fotoliste" VALUES(844,'21.5.2014 11:22:58',23,14,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'NW','Ausgrabung K. Schwertfeger',0,0,NULL,'003365_0023_0014.jpg',NULL,0,'B. Fritsch',NULL,0,0,0,0,'003365_0023_0014',NULL);
INSERT INTO "T_Fotoliste" VALUES(845,'21.5.2014 11:23:14',23,15,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'N','Ausgrabung K. Schwertfeger',0,0,NULL,'003365_0023_0015.jpg',NULL,0,'B. Fritsch',NULL,0,0,0,0,'003365_0023_0015',NULL);
INSERT INTO "T_Fotoliste" VALUES(846,'21.5.2014 11:23:46',23,16,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,NULL,'Ausgrabung K. Schwertfeger, Zwickelmauerwerk',0,0,NULL,'003365_0023_0016.jpg',NULL,0,'B. Fritsch',NULL,0,0,0,0,'003365_0023_0016',NULL);
INSERT INTO "T_Fotoliste" VALUES(847,'21.5.2014 11:28:02',23,17,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'O','Ausgrabung K. Schwertfeger',0,0,NULL,'003365_0023_0017.jpg',NULL,0,'B. Fritsch',NULL,0,0,0,0,'003365_0023_0017',NULL);
INSERT INTO "T_Fotoliste" VALUES(848,'9.3.2010 12:25:16',24,2,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'SW',NULL,0,0,NULL,'003365_0024_0002.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0002',NULL);
INSERT INTO "T_Fotoliste" VALUES(849,'9.3.2010 12:25:26',24,3,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'SW',NULL,0,0,NULL,'003365_0024_0003.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0003',NULL);
INSERT INTO "T_Fotoliste" VALUES(850,'9.3.2010 12:38:58',24,4,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'SW',NULL,0,0,NULL,'003365_0024_0004.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0004',NULL);
INSERT INTO "T_Fotoliste" VALUES(851,'9.3.2010 12:39:10',24,5,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'SW',NULL,0,0,NULL,'003365_0024_0005.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0005',NULL);
INSERT INTO "T_Fotoliste" VALUES(852,'9.3.2010 12:52:08',24,7,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,'W',NULL,0,0,NULL,'003365_0024_0007.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0007',NULL);
INSERT INTO "T_Fotoliste" VALUES(853,'9.3.2010 12:53:04',24,8,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,'SW',NULL,0,0,NULL,'003365_0024_0008.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0008',NULL);
INSERT INTO "T_Fotoliste" VALUES(854,'9.3.2010 12:53:12',24,9,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,'SW',NULL,0,0,NULL,'003365_0024_0009.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0009',NULL);
INSERT INTO "T_Fotoliste" VALUES(855,'9.3.2010 12:53:48',24,10,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,'O',NULL,0,0,NULL,'003365_0024_0010.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0010',NULL);
INSERT INTO "T_Fotoliste" VALUES(856,'9.3.2010 12:53:56',24,11,NULL,'1',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0024_0011.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0011',NULL);
INSERT INTO "T_Fotoliste" VALUES(857,'9.3.2010 12:54:20',24,12,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0024_0012.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0012',NULL);
INSERT INTO "T_Fotoliste" VALUES(858,'9.3.2010 12:54:48',24,13,NULL,'10',3365,12,NULL,3,NULL,NULL,NULL,'S',NULL,0,0,NULL,'003365_0024_0013.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0013',NULL);
INSERT INTO "T_Fotoliste" VALUES(859,'9.3.2010 13:19:52',24,16,NULL,NULL,3365,11,NULL,3,NULL,NULL,NULL,'O',NULL,0,0,NULL,'003365_0024_0016.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0016',NULL);
INSERT INTO "T_Fotoliste" VALUES(860,'9.3.2010 13:20:02',24,17,NULL,NULL,3365,11,NULL,3,NULL,NULL,NULL,'W','Rand des Haldensleber Forst',0,0,NULL,'003365_0024_0017.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0017',NULL);
INSERT INTO "T_Fotoliste" VALUES(861,'9.3.2010 13:20:20',24,18,NULL,NULL,3365,11,NULL,3,NULL,NULL,NULL,'SO','Rand des Haldensleber Forst',0,0,NULL,'003365_0024_0018.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0018',NULL);
INSERT INTO "T_Fotoliste" VALUES(862,'9.3.2010 13:31:20',24,20,NULL,'28',3365,11,NULL,3,NULL,NULL,NULL,'NO',NULL,0,0,NULL,'003365_0024_0020.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0020',NULL);
INSERT INTO "T_Fotoliste" VALUES(863,'9.3.2010 13:31:46',24,22,NULL,'28',3365,11,NULL,3,NULL,NULL,NULL,'NW',NULL,0,0,NULL,'003365_0024_0022.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0022',NULL);
INSERT INTO "T_Fotoliste" VALUES(864,'9.3.2010 13:42:00',24,23,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,'W',NULL,0,0,NULL,'003365_0024_0023.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0023',NULL);
INSERT INTO "T_Fotoliste" VALUES(865,'9.3.2010 13:59:08',24,25,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,'W',NULL,0,0,NULL,'003365_0024_0025.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0025',NULL);
INSERT INTO "T_Fotoliste" VALUES(866,'9.3.2010 13:59:18',24,26,NULL,'27',3365,12,NULL,3,NULL,NULL,NULL,'W',NULL,0,0,NULL,'003365_0024_0026.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0026',NULL);
INSERT INTO "T_Fotoliste" VALUES(867,'9.3.2010 13:59:56',24,28,NULL,'27',3365,11,NULL,3,NULL,NULL,NULL,'W',NULL,0,0,NULL,'003365_0024_0028.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0028',NULL);
INSERT INTO "T_Fotoliste" VALUES(868,'9.3.2010 14:40:22',24,29,NULL,'25',3365,11,NULL,3,NULL,NULL,NULL,'W',NULL,0,0,NULL,'003365_0024_0029.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0029',NULL);
INSERT INTO "T_Fotoliste" VALUES(869,'9.3.2010 14:40:46',24,31,NULL,'25',3365,11,NULL,3,NULL,NULL,NULL,'W',NULL,0,0,NULL,'003365_0024_0031.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0031',NULL);
INSERT INTO "T_Fotoliste" VALUES(870,'9.3.2010 14:51:02',24,38,NULL,NULL,3365,11,NULL,3,NULL,NULL,NULL,'N','BZ Grabhügel',0,0,NULL,'003365_0024_0038.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0038',NULL);
INSERT INTO "T_Fotoliste" VALUES(871,'9.3.2010 15:01:24',24,43,NULL,NULL,3365,11,NULL,3,NULL,NULL,NULL,'N','BZ Grabhügel',0,0,NULL,'003365_0024_0043.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0043',NULL);
INSERT INTO "T_Fotoliste" VALUES(872,'9.3.2010 15:01:36',24,44,NULL,NULL,3365,11,NULL,3,NULL,NULL,NULL,'N','BZ Grabhügel',0,0,NULL,'003365_0024_0044.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0044',NULL);
INSERT INTO "T_Fotoliste" VALUES(873,'9.3.2010 15:07:46',24,46,NULL,NULL,3365,11,NULL,3,NULL,NULL,NULL,'N','BZ Grabhügel',0,0,NULL,'003365_0024_0046.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0046',NULL);
INSERT INTO "T_Fotoliste" VALUES(874,'9.3.2010 15:12:48',24,52,NULL,NULL,3365,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0024_0052.jpg',NULL,0,NULL,NULL,0,0,0,0,'003365_0024_0052',NULL);
INSERT INTO "T_Fotoliste" VALUES(875,'9.3.2010 15:24:08',24,53,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'NW',NULL,0,0,NULL,'003365_0024_0053.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0053',NULL);
INSERT INTO "T_Fotoliste" VALUES(876,'9.3.2010 15:24:22',24,54,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'NW',NULL,0,0,NULL,'003365_0024_0054.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0054',NULL);
INSERT INTO "T_Fotoliste" VALUES(877,'9.3.2010 15:26:04',24,57,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,'SO',NULL,0,0,NULL,'003365_0024_0057.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0057',NULL);
INSERT INTO "T_Fotoliste" VALUES(878,'9.3.2010 15:26:12',24,58,NULL,'22',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0024_0058.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0058',NULL);
INSERT INTO "T_Fotoliste" VALUES(879,'9.3.2010 16:34:16',24,60,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0024_0060.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0060',NULL);
INSERT INTO "T_Fotoliste" VALUES(880,'9.3.2010 16:34:26',24,61,NULL,'20',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0024_0061.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0061',NULL);
INSERT INTO "T_Fotoliste" VALUES(881,'9.3.2010 16:38:04',24,62,NULL,'19',3365,11,NULL,3,NULL,NULL,NULL,'N',NULL,0,0,NULL,'003365_0024_0062.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0062',NULL);
INSERT INTO "T_Fotoliste" VALUES(882,'9.3.2010 16:38:36',24,64,NULL,'19',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0024_0064.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0064',NULL);
INSERT INTO "T_Fotoliste" VALUES(883,'9.3.2010 16:38:48',24,65,NULL,'19',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0024_0065.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0065',NULL);
INSERT INTO "T_Fotoliste" VALUES(884,'9.3.2010 16:39:06',24,66,NULL,'19',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0024_0066.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0066',NULL);
INSERT INTO "T_Fotoliste" VALUES(885,'9.3.2010 16:39:40',24,67,NULL,'19',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0024_0067.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0067',NULL);
INSERT INTO "T_Fotoliste" VALUES(886,'9.3.2010 16:52:58',24,68,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0024_0068.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0068',NULL);
INSERT INTO "T_Fotoliste" VALUES(887,'9.3.2010 16:53:04',24,69,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0024_0069.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0069',NULL);
INSERT INTO "T_Fotoliste" VALUES(888,'9.3.2010 16:53:22',24,70,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0024_0070.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0070',NULL);
INSERT INTO "T_Fotoliste" VALUES(889,'9.3.2010 16:53:30',24,71,NULL,'18',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0024_0071.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0071',NULL);
INSERT INTO "T_Fotoliste" VALUES(890,'9.3.2010 17:14:42',24,72,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0024_0072.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0072',NULL);
INSERT INTO "T_Fotoliste" VALUES(891,'9.3.2010 17:14:50',24,73,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0024_0073.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0073',NULL);
INSERT INTO "T_Fotoliste" VALUES(892,'9.3.2010 17:14:58',24,74,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,'SO',NULL,0,0,NULL,'003365_0024_0074.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0074',NULL);
INSERT INTO "T_Fotoliste" VALUES(893,'9.3.2010 17:15:28',24,75,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,'NW',NULL,0,0,NULL,'003365_0024_0075.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0075',NULL);
INSERT INTO "T_Fotoliste" VALUES(894,'9.3.2010 17:15:38',24,76,NULL,'23',3365,11,NULL,3,NULL,NULL,NULL,'NW',NULL,0,0,NULL,'003365_0024_0076.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0024_0076',NULL);
INSERT INTO "T_Fotoliste" VALUES(895,'13.3.2010 09:22:42',25,2,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'SW',NULL,0,0,NULL,'003365_0025_0002.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0002',NULL);
INSERT INTO "T_Fotoliste" VALUES(896,'13.3.2010 09:23:08',25,4,NULL,'11',3365,12,NULL,3,NULL,NULL,NULL,'S',NULL,0,0,NULL,'003365_0025_0004.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0004',NULL);
INSERT INTO "T_Fotoliste" VALUES(897,'13.3.2010 09:23:28',25,5,NULL,'4',3365,12,NULL,3,NULL,NULL,NULL,'N','Königsgrab',0,0,NULL,'003365_0025_0005.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0005',NULL);
INSERT INTO "T_Fotoliste" VALUES(898,'13.3.2010 09:23:40',25,6,NULL,'4',3365,12,NULL,3,NULL,NULL,NULL,'N','Königsgrab',0,0,NULL,'003365_0025_0006.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0006',NULL);
INSERT INTO "T_Fotoliste" VALUES(899,'13.3.2010 09:23:50',25,7,NULL,'4',3365,12,NULL,3,NULL,NULL,NULL,'N','Königsgrab',0,0,NULL,'003365_0025_0007.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0007',NULL);
INSERT INTO "T_Fotoliste" VALUES(900,'13.3.2010 09:23:58',25,8,NULL,NULL,3365,12,NULL,3,NULL,NULL,NULL,'NO','Königsgrab',0,0,NULL,'003365_0025_0008.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0008',NULL);
INSERT INTO "T_Fotoliste" VALUES(901,'13.3.2010 09:24:36',25,10,NULL,'4',3365,12,NULL,3,NULL,NULL,NULL,'S','Königsgrab',0,0,NULL,'003365_0025_0010.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0010',NULL);
INSERT INTO "T_Fotoliste" VALUES(902,'13.3.2010 09:24:44',25,11,NULL,'4',3365,12,NULL,3,NULL,NULL,NULL,'S','Königsgrab',0,0,NULL,'003365_0025_0011.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0011',NULL);
INSERT INTO "T_Fotoliste" VALUES(903,'13.3.2010 09:24:52',25,12,NULL,'4',3365,12,NULL,3,NULL,NULL,NULL,'S','Königsgrab',0,0,NULL,'003365_0025_0012.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0012',NULL);
INSERT INTO "T_Fotoliste" VALUES(904,'13.3.2010 09:25:10',25,13,NULL,'4',3365,12,NULL,3,NULL,NULL,NULL,'S','Königsgrab',0,0,NULL,'003365_0025_0013.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0013',NULL);
INSERT INTO "T_Fotoliste" VALUES(905,'13.3.2010 09:25:38',25,14,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0025_0014.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0014',NULL);
INSERT INTO "T_Fotoliste" VALUES(906,'13.3.2010 09:25:46',25,15,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0025_0015.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0015',NULL);
INSERT INTO "T_Fotoliste" VALUES(907,'13.3.2010 09:25:56',25,16,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'W',NULL,0,1,NULL,'003365_0025_0016.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0016',NULL);
INSERT INTO "T_Fotoliste" VALUES(908,'13.3.2010 09:26:06',25,17,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'W',NULL,0,0,NULL,'003365_0025_0017.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0017',NULL);
INSERT INTO "T_Fotoliste" VALUES(909,'13.3.2010 09:26:14',25,18,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'W',NULL,0,0,NULL,'003365_0025_0018.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0018',NULL);
INSERT INTO "T_Fotoliste" VALUES(910,'13.3.2010 09:26:20',25,19,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'NW',NULL,0,0,NULL,'003365_0025_0019.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0019',NULL);
INSERT INTO "T_Fotoliste" VALUES(911,'13.3.2010 09:26:28',25,20,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'NW',NULL,0,0,NULL,'003365_0025_0020.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0020',NULL);
INSERT INTO "T_Fotoliste" VALUES(912,'13.3.2010 09:26:34',25,21,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'NO',NULL,0,0,NULL,'003365_0025_0021.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0021',NULL);
INSERT INTO "T_Fotoliste" VALUES(913,'13.3.2010 09:26:42',25,22,NULL,'30',3365,11,NULL,3,NULL,NULL,NULL,'O',NULL,0,0,NULL,'003365_0025_0022.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0022',NULL);
INSERT INTO "T_Fotoliste" VALUES(914,'13.3.2010 09:26:48',25,23,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,'O',NULL,0,0,NULL,'003365_0025_0023.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0023',NULL);
INSERT INTO "T_Fotoliste" VALUES(915,'13.3.2010 09:26:56',25,24,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,'O',NULL,0,0,NULL,'003365_0025_0024.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0024',NULL);
INSERT INTO "T_Fotoliste" VALUES(916,'13.3.2010 09:27:20',25,27,NULL,'29',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0025_0027.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0027',NULL);
INSERT INTO "T_Fotoliste" VALUES(917,'13.3.2010 09:27:30',25,28,NULL,'32',3365,11,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0025_0028.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0028',NULL);
INSERT INTO "T_Fotoliste" VALUES(918,'13.3.2010 09:27:38',25,29,NULL,'32',3365,11,NULL,3,NULL,NULL,NULL,'W',NULL,0,0,NULL,'003365_0025_0029.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0029',NULL);
INSERT INTO "T_Fotoliste" VALUES(919,'13.3.2010 09:27:48',25,30,NULL,'32',3365,11,NULL,3,NULL,NULL,NULL,'SW',NULL,0,0,NULL,'003365_0025_0030.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0030',NULL);
INSERT INTO "T_Fotoliste" VALUES(920,'13.3.2010 09:28:10',25,32,NULL,NULL,3365,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0025_0032.jpg',NULL,0,NULL,NULL,0,0,0,0,'003365_0025_0032',NULL);
INSERT INTO "T_Fotoliste" VALUES(921,'13.3.2010 09:28:18',25,33,NULL,'32',3365,11,NULL,3,NULL,NULL,NULL,'s',NULL,0,0,NULL,'003365_0025_0033.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0033',NULL);
INSERT INTO "T_Fotoliste" VALUES(922,'13.3.2010 09:28:26',25,34,NULL,'13',3365,10,NULL,3,NULL,NULL,NULL,'N','Steineiche',0,0,NULL,'003365_0025_0034.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0034',NULL);
INSERT INTO "T_Fotoliste" VALUES(923,'13.3.2010 09:28:36',25,35,NULL,'13',3365,10,NULL,3,NULL,NULL,NULL,'N','Steineiche',0,0,NULL,'003365_0025_0035.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0025_0035',NULL);
INSERT INTO "T_Fotoliste" VALUES(924,'13.3.2010 11:40:08',26,1,NULL,'14',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0026_0001.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0001',NULL);
INSERT INTO "T_Fotoliste" VALUES(925,'13.3.2010 11:40:18',26,2,NULL,'14',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0026_0002.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0002',NULL);
INSERT INTO "T_Fotoliste" VALUES(926,'13.3.2010 11:40:40',26,4,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,NULL,'Navi Medion am Megalithgrab',0,0,NULL,'003365_0026_0004.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0004',NULL);
INSERT INTO "T_Fotoliste" VALUES(927,'13.3.2010 11:41:02',26,5,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,'SO',NULL,0,0,NULL,'003365_0026_0005.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0005',NULL);
INSERT INTO "T_Fotoliste" VALUES(928,'13.3.2010 11:41:20',26,6,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,'SO',NULL,0,0,NULL,'003365_0026_0006.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0006',NULL);
INSERT INTO "T_Fotoliste" VALUES(929,'13.3.2010 11:41:26',26,7,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,'SO',NULL,0,0,NULL,'003365_0026_0007.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0007',NULL);
INSERT INTO "T_Fotoliste" VALUES(930,'13.3.2010 11:41:34',26,8,NULL,NULL,3365,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0026_0008.jpg',NULL,0,NULL,NULL,0,0,0,0,'003365_0026_0008',NULL);
INSERT INTO "T_Fotoliste" VALUES(931,'13.3.2010 11:41:40',26,9,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,'O',NULL,0,0,NULL,'003365_0026_0009.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0009',NULL);
INSERT INTO "T_Fotoliste" VALUES(932,'13.3.2010 11:41:48',26,10,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,'O',NULL,0,0,NULL,'003365_0026_0010.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0010',NULL);
INSERT INTO "T_Fotoliste" VALUES(933,'13.3.2010 11:42:06',26,12,NULL,'16',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0026_0012.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0012',NULL);
INSERT INTO "T_Fotoliste" VALUES(934,'13.3.2010 11:42:30',26,15,NULL,'16',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0026_0015.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0015',NULL);
INSERT INTO "T_Fotoliste" VALUES(935,'13.3.2010 11:43:34',26,22,NULL,'16',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0026_0022.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0022',NULL);
INSERT INTO "T_Fotoliste" VALUES(936,'13.3.2010 11:44:00',26,25,NULL,'16',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0026_0025.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0025',NULL);
INSERT INTO "T_Fotoliste" VALUES(937,'13.3.2010 11:44:08',26,26,NULL,'16',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0026_0026.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0026',NULL);
INSERT INTO "T_Fotoliste" VALUES(938,'13.3.2010 11:44:36',26,30,NULL,'16',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0026_0030.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0030',NULL);
INSERT INTO "T_Fotoliste" VALUES(939,'13.3.2010 11:44:44',26,31,NULL,'28',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0026_0031.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0031',NULL);
INSERT INTO "T_Fotoliste" VALUES(940,'13.3.2010 11:45:44',26,38,NULL,'14',3365,15,NULL,3,NULL,NULL,NULL,'s',NULL,0,0,NULL,'003365_0026_0038.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0038',NULL);
INSERT INTO "T_Fotoliste" VALUES(941,'13.3.2010 11:46:10',26,41,NULL,'14',3365,15,NULL,3,NULL,NULL,NULL,'SO',NULL,0,0,NULL,'003365_0026_0041.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0041',NULL);
INSERT INTO "T_Fotoliste" VALUES(942,'13.3.2010 11:46:26',26,43,NULL,'14',3365,15,NULL,3,NULL,NULL,NULL,'SO',NULL,0,0,NULL,'003365_0026_0043.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0043',NULL);
INSERT INTO "T_Fotoliste" VALUES(943,'13.3.2010 11:46:34',26,44,NULL,'35',3365,15,NULL,3,NULL,NULL,NULL,'NO',NULL,0,0,NULL,'003365_0026_0044.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0044',NULL);
INSERT INTO "T_Fotoliste" VALUES(944,'13.3.2010 11:46:46',26,45,NULL,'35',3365,15,NULL,3,NULL,NULL,NULL,'SO',NULL,0,0,NULL,'003365_0026_0045.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0045',NULL);
INSERT INTO "T_Fotoliste" VALUES(945,'13.3.2010 11:46:52',26,46,NULL,'35',3365,15,NULL,3,NULL,NULL,NULL,'SO',NULL,0,0,NULL,'003365_0026_0046.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0046',NULL);
INSERT INTO "T_Fotoliste" VALUES(946,'13.3.2010 11:47:14',26,49,NULL,'35',3365,15,NULL,3,NULL,NULL,NULL,'SO',NULL,0,0,NULL,'003365_0026_0049.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0049',NULL);
INSERT INTO "T_Fotoliste" VALUES(947,'13.3.2010 11:47:28',26,51,NULL,'22',3365,15,NULL,3,NULL,NULL,NULL,'SW',NULL,0,0,NULL,'003365_0026_0051.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0051',NULL);
INSERT INTO "T_Fotoliste" VALUES(948,'13.3.2010 11:47:44',26,53,NULL,'22',3365,15,NULL,3,NULL,NULL,NULL,'W',NULL,0,0,NULL,'003365_0026_0053.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0026_0053',NULL);
INSERT INTO "T_Fotoliste" VALUES(949,'10.3.2016 09:18:14',27,1,NULL,'24',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0027_0001.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0027_0001',NULL);
INSERT INTO "T_Fotoliste" VALUES(950,'10.3.2016 09:18:28',27,2,NULL,'24',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0027_0002.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0027_0002',NULL);
INSERT INTO "T_Fotoliste" VALUES(951,'10.3.2016 09:18:42',27,3,NULL,'24',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0027_0003.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0027_0003',NULL);
INSERT INTO "T_Fotoliste" VALUES(952,'10.3.2016 09:18:48',27,4,NULL,'24',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0027_0004.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0027_0004',NULL);
INSERT INTO "T_Fotoliste" VALUES(953,'10.3.2016 10:09:04',28,1,NULL,'24',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0028_0001.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0028_0001',NULL);
INSERT INTO "T_Fotoliste" VALUES(954,'10.3.2016 10:52:52',28,2,NULL,'24',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0028_0002.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0028_0002',NULL);
INSERT INTO "T_Fotoliste" VALUES(955,'10.3.2016 10:52:58',28,3,NULL,'24',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0028_0003.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0028_0003',NULL);
INSERT INTO "T_Fotoliste" VALUES(956,'10.3.2016 10:53:02',28,4,NULL,'24',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0028_0004.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0028_0004',NULL);
INSERT INTO "T_Fotoliste" VALUES(957,'10.3.2016 10:53:06',28,5,NULL,'24',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0028_0005.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0028_0005',NULL);
INSERT INTO "T_Fotoliste" VALUES(958,'10.3.2016 10:53:08',28,6,NULL,'24',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0028_0006.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0028_0006',NULL);
INSERT INTO "T_Fotoliste" VALUES(959,'10.3.2016 10:53:20',28,7,NULL,'24',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0028_0007.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0028_0007',NULL);
INSERT INTO "T_Fotoliste" VALUES(960,'10.3.2016 10:53:32',28,8,NULL,'24',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0028_0008.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0028_0008',NULL);
INSERT INTO "T_Fotoliste" VALUES(961,'10.3.2016 10:53:42',28,9,NULL,'24',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0028_0009.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0028_0009',NULL);
INSERT INTO "T_Fotoliste" VALUES(962,'10.3.2016 14:48:56',29,1,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0029_0001.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0029_0001',NULL);
INSERT INTO "T_Fotoliste" VALUES(963,'10.3.2016 14:49:16',29,2,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0029_0002.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0029_0002',NULL);
INSERT INTO "T_Fotoliste" VALUES(964,'10.3.2016 14:50:06',29,3,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0029_0003.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0029_0003',NULL);
INSERT INTO "T_Fotoliste" VALUES(965,'10.3.2016 16:06:10',29,4,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0029_0004.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0029_0004',NULL);
INSERT INTO "T_Fotoliste" VALUES(966,'10.3.2016 16:06:20',29,5,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0029_0005.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0029_0005',NULL);
INSERT INTO "T_Fotoliste" VALUES(967,'10.3.2016 16:06:30',29,6,NULL,'15',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0029_0006.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0029_0006',NULL);
INSERT INTO "T_Fotoliste" VALUES(968,'9.3.2016 14:12:18',30,17,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0017.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0017',NULL);
INSERT INTO "T_Fotoliste" VALUES(969,'9.3.2016 14:40:14',30,18,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0018.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0018',NULL);
INSERT INTO "T_Fotoliste" VALUES(970,'9.3.2016 14:40:50',30,19,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0019.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0019',NULL);
INSERT INTO "T_Fotoliste" VALUES(971,'9.3.2016 14:42:06',30,20,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0020.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0020',NULL);
INSERT INTO "T_Fotoliste" VALUES(972,'9.3.2016 12:05:28',30,1,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0001.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0001',NULL);
INSERT INTO "T_Fotoliste" VALUES(973,'9.3.2016 12:05:44',30,2,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0002.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0002',NULL);
INSERT INTO "T_Fotoliste" VALUES(974,'9.3.2016 12:06:28',30,3,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0003.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0003',NULL);
INSERT INTO "T_Fotoliste" VALUES(975,'9.3.2016 12:07:00',30,4,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0004.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0004',NULL);
INSERT INTO "T_Fotoliste" VALUES(976,'9.3.2016 12:07:54',30,5,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0005.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0005',NULL);
INSERT INTO "T_Fotoliste" VALUES(977,'9.3.2016 12:08:10',30,6,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0006.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0006',NULL);
INSERT INTO "T_Fotoliste" VALUES(978,'9.3.2016 13:40:38',30,7,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0007.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0007',NULL);
INSERT INTO "T_Fotoliste" VALUES(979,'9.3.2016 13:40:54',30,8,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0008.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0008',NULL);
INSERT INTO "T_Fotoliste" VALUES(980,'9.3.2016 13:41:10',30,9,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0009.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0009',NULL);
INSERT INTO "T_Fotoliste" VALUES(981,'9.3.2016 13:41:24',30,10,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0010.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0010',NULL);
INSERT INTO "T_Fotoliste" VALUES(982,'9.3.2016 14:00:48',30,11,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0011.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0011',NULL);
INSERT INTO "T_Fotoliste" VALUES(983,'9.3.2016 14:01:16',30,12,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0012.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0012',NULL);
INSERT INTO "T_Fotoliste" VALUES(984,'9.3.2016 14:01:54',30,13,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0013.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0013',NULL);
INSERT INTO "T_Fotoliste" VALUES(985,'9.3.2016 14:01:56',30,14,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0014.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0014',NULL);
INSERT INTO "T_Fotoliste" VALUES(986,'9.3.2016 14:11:32',30,15,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0015.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0015',NULL);
INSERT INTO "T_Fotoliste" VALUES(987,'9.3.2016 14:12:02',30,16,NULL,'27',3365,10,NULL,3,NULL,NULL,NULL,NULL,NULL,0,0,NULL,'003365_0030_0016.jpg',NULL,0,'C. Rinne',NULL,0,0,0,0,'003365_0030_0016',NULL);

/* Comment 
------------------------
Table for relations between Megalith Site and Picture, part of GDB LSA (Grabungsdatenbank Land Sachsen-Anhalt).
"AktivitaetsNr": activity number as given by the LSA
"FundstelleID": site ID (Flächen-Nr. = Fundstellen-Nr.)
"Bef_Nr": number of the feature
"Foto_Nr": number of the foto
*/
DROP TABLE IF EXISTS "RT_Befund_Bild";
CREATE TABLE "RT_Befund_Bild" (
"ID" INTEGER PRIMARY KEY AUTOINCREMENT,
"AktivitaetsNr" INTEGER,
"FundstelleID" INTEGER,
"Bef_Nr" INTEGER,
"Foto_Nr" TEXT,
FOREIGN KEY (AktivitaetsNr) REFERENCES T_Befundbeschreibung(AktivitaetsNr),
FOREIGN KEY (FundstelleID) REFERENCES T_Befundbeschreibung(FundstelleID),
FOREIGN KEY (Bef_Nr) REFERENCES T_Befundbeschreibung(Bef_Nr),
FOREIGN KEY (Foto_Nr) REFERENCES T_Fotoliste(Bildkennung)
);
INSERT INTO "RT_Befund_Bild" VALUES(1,3365,11,3,'003365_0001_0066');
INSERT INTO "RT_Befund_Bild" VALUES(2,3365,11,3,'003365_0001_0001');
INSERT INTO "RT_Befund_Bild" VALUES(3,3365,11,4,'003365_0001_0002');
INSERT INTO "RT_Befund_Bild" VALUES(4,3365,11,5,'003365_0001_0003');
INSERT INTO "RT_Befund_Bild" VALUES(5,3365,11,6,'003365_0001_0004');
INSERT INTO "RT_Befund_Bild" VALUES(6,3365,11,10,'003365_0001_0005');
INSERT INTO "RT_Befund_Bild" VALUES(7,3365,11,11,'003365_0001_0006');
INSERT INTO "RT_Befund_Bild" VALUES(8,3365,11,12,'003365_0001_0007');
INSERT INTO "RT_Befund_Bild" VALUES(9,3365,11,13,'003365_0001_0008');
INSERT INTO "RT_Befund_Bild" VALUES(10,3365,11,14,'003365_0001_0009');
INSERT INTO "RT_Befund_Bild" VALUES(11,3365,11,15,'003365_0001_0010');
INSERT INTO "RT_Befund_Bild" VALUES(13,3365,11,16,'003365_0001_0011');
INSERT INTO "RT_Befund_Bild" VALUES(14,3365,11,17,'003365_0001_0012');
INSERT INTO "RT_Befund_Bild" VALUES(15,3365,11,18,'003365_0001_0068');
INSERT INTO "RT_Befund_Bild" VALUES(16,3365,11,18,'003365_0001_0013');
INSERT INTO "RT_Befund_Bild" VALUES(17,3365,11,21,'003365_0001_0016');
INSERT INTO "RT_Befund_Bild" VALUES(18,3365,11,21,'003365_0001_0069');
INSERT INTO "RT_Befund_Bild" VALUES(19,3365,11,20,'003365_0001_0015');
INSERT INTO "RT_Befund_Bild" VALUES(20,3365,11,19,'003365_0001_0014');
INSERT INTO "RT_Befund_Bild" VALUES(21,3365,11,22,'003365_0001_0017');
INSERT INTO "RT_Befund_Bild" VALUES(22,3365,11,23,'003365_0001_0018');
INSERT INTO "RT_Befund_Bild" VALUES(23,3365,11,25,'003365_0001_0019');
INSERT INTO "RT_Befund_Bild" VALUES(24,3365,11,26,'003365_0001_0020');
INSERT INTO "RT_Befund_Bild" VALUES(25,3365,11,27,'003365_0001_0070');
INSERT INTO "RT_Befund_Bild" VALUES(26,3365,11,27,'003365_0001_0021');
INSERT INTO "RT_Befund_Bild" VALUES(27,3365,11,28,'003365_0001_0022');
INSERT INTO "RT_Befund_Bild" VALUES(28,3365,11,29,'003365_0001_0023');
INSERT INTO "RT_Befund_Bild" VALUES(29,3365,11,30,'003365_0001_0024');
INSERT INTO "RT_Befund_Bild" VALUES(30,3365,11,31,'003365_0001_0025');
INSERT INTO "RT_Befund_Bild" VALUES(31,3365,11,32,'003365_0001_0026');
INSERT INTO "RT_Befund_Bild" VALUES(32,3365,11,34,'003365_0001_0027');
INSERT INTO "RT_Befund_Bild" VALUES(33,3365,11,36,'003365_0001_0028');
INSERT INTO "RT_Befund_Bild" VALUES(34,3365,11,37,'003365_0001_0029');
INSERT INTO "RT_Befund_Bild" VALUES(35,3365,11,38,'003365_0001_0030');
INSERT INTO "RT_Befund_Bild" VALUES(36,3365,11,39,'003365_0001_0031');
INSERT INTO "RT_Befund_Bild" VALUES(37,3365,11,46,'003365_0001_0032');
INSERT INTO "RT_Befund_Bild" VALUES(38,3365,12,10,'003365_0001_0051');
INSERT INTO "RT_Befund_Bild" VALUES(39,3365,12,11,'003365_0001_0052');
INSERT INTO "RT_Befund_Bild" VALUES(40,3365,12,14,'003365_0001_0053');
INSERT INTO "RT_Befund_Bild" VALUES(41,3365,16,10,'003365_0001_0061');
INSERT INTO "RT_Befund_Bild" VALUES(42,3365,10,10,'003365_0001_0033');
INSERT INTO "RT_Befund_Bild" VALUES(43,3365,10,10,'003365_0001_0071');
INSERT INTO "RT_Befund_Bild" VALUES(44,3365,10,11,'003365_0001_0034');
INSERT INTO "RT_Befund_Bild" VALUES(45,3365,10,12,'003365_0001_0035');
INSERT INTO "RT_Befund_Bild" VALUES(46,3365,10,13,'003365_0001_0036');
INSERT INTO "RT_Befund_Bild" VALUES(47,3365,10,14,'003365_0001_0037');
INSERT INTO "RT_Befund_Bild" VALUES(48,3365,10,15,'003365_0001_0038');
INSERT INTO "RT_Befund_Bild" VALUES(49,3365,10,16,'003365_0001_0039');
INSERT INTO "RT_Befund_Bild" VALUES(50,3365,10,17,'003365_0001_0040');
INSERT INTO "RT_Befund_Bild" VALUES(51,3365,10,18,'003365_0001_0041');
INSERT INTO "RT_Befund_Bild" VALUES(52,3365,10,18,'003365_0001_0072');
INSERT INTO "RT_Befund_Bild" VALUES(53,3365,10,20,'003365_0001_0042');
INSERT INTO "RT_Befund_Bild" VALUES(54,3365,10,21,'003365_0001_0043');
INSERT INTO "RT_Befund_Bild" VALUES(55,3365,10,22,'003365_0001_0044');
INSERT INTO "RT_Befund_Bild" VALUES(56,3365,10,23,'003365_0001_0045');
INSERT INTO "RT_Befund_Bild" VALUES(57,3365,10,25,'003365_0001_0073');
INSERT INTO "RT_Befund_Bild" VALUES(58,3365,10,25,'003365_0001_0046');
INSERT INTO "RT_Befund_Bild" VALUES(59,3365,10,27,'003365_0001_0074');
INSERT INTO "RT_Befund_Bild" VALUES(60,3365,10,27,'003365_0001_0047');
INSERT INTO "RT_Befund_Bild" VALUES(61,3365,10,28,'003365_0001_0048');
INSERT INTO "RT_Befund_Bild" VALUES(63,3365,15,15,'003365_0001_0055');
INSERT INTO "RT_Befund_Bild" VALUES(64,3365,15,16,'003365_0001_0056');
INSERT INTO "RT_Befund_Bild" VALUES(65,3365,15,17,'003365_0001_0057');
INSERT INTO "RT_Befund_Bild" VALUES(66,3365,15,18,'003365_0001_0058');
INSERT INTO "RT_Befund_Bild" VALUES(67,3365,15,19,'003365_0001_0059');
INSERT INTO "RT_Befund_Bild" VALUES(68,3365,17,1,'003365_0001_0062');
INSERT INTO "RT_Befund_Bild" VALUES(69,3365,17,2,'003365_0001_0064');
INSERT INTO "RT_Befund_Bild" VALUES(70,3365,12,4,'003365_0001_0049');
INSERT INTO "RT_Befund_Bild" VALUES(71,3365,10,26,'003365_0001_0063');
INSERT INTO "RT_Befund_Bild" VALUES(72,3365,12,7,'003365_0001_0050');
INSERT INTO "RT_Befund_Bild" VALUES(73,3365,11,5,'003365_0003_0001');
INSERT INTO "RT_Befund_Bild" VALUES(74,3365,11,5,'003365_0003_0002');
INSERT INTO "RT_Befund_Bild" VALUES(75,3365,11,5,'003365_0003_0003');
INSERT INTO "RT_Befund_Bild" VALUES(76,3365,11,5,'003365_0003_0004');
INSERT INTO "RT_Befund_Bild" VALUES(77,3365,11,5,'003365_0003_0005');
INSERT INTO "RT_Befund_Bild" VALUES(78,3365,11,5,'003365_0003_0006');
INSERT INTO "RT_Befund_Bild" VALUES(79,3365,11,5,'003365_0003_0007');
INSERT INTO "RT_Befund_Bild" VALUES(80,3365,11,5,'003365_0003_0008');
INSERT INTO "RT_Befund_Bild" VALUES(81,3365,11,5,'003365_0003_0009');
INSERT INTO "RT_Befund_Bild" VALUES(82,3365,11,5,'003365_0003_0010');
INSERT INTO "RT_Befund_Bild" VALUES(83,3365,11,5,'003365_0003_0011');
INSERT INTO "RT_Befund_Bild" VALUES(84,3365,11,5,'003365_0003_0012');
INSERT INTO "RT_Befund_Bild" VALUES(85,3365,11,5,'003365_0003_0013');
INSERT INTO "RT_Befund_Bild" VALUES(86,3365,11,5,'003365_0003_0014');
INSERT INTO "RT_Befund_Bild" VALUES(87,3365,11,20,'003365_0003_0015');
INSERT INTO "RT_Befund_Bild" VALUES(88,3365,11,20,'003365_0003_0016');
INSERT INTO "RT_Befund_Bild" VALUES(89,3365,11,20,'003365_0003_0017');
INSERT INTO "RT_Befund_Bild" VALUES(90,3365,11,20,'003365_0003_0018');
INSERT INTO "RT_Befund_Bild" VALUES(91,3365,11,20,'003365_0003_0019');
INSERT INTO "RT_Befund_Bild" VALUES(92,3365,11,20,'003365_0003_0020');
INSERT INTO "RT_Befund_Bild" VALUES(93,3365,11,20,'003365_0003_0021');
INSERT INTO "RT_Befund_Bild" VALUES(94,3365,11,20,'003365_0003_0022');
INSERT INTO "RT_Befund_Bild" VALUES(95,3365,11,20,'003365_0003_0023');
INSERT INTO "RT_Befund_Bild" VALUES(96,3365,11,20,'003365_0003_0024');
INSERT INTO "RT_Befund_Bild" VALUES(97,3365,11,22,'003365_0003_0025');
INSERT INTO "RT_Befund_Bild" VALUES(98,3365,11,22,'003365_0003_0026');
INSERT INTO "RT_Befund_Bild" VALUES(99,3365,11,22,'003365_0003_0027');
INSERT INTO "RT_Befund_Bild" VALUES(100,3365,11,22,'003365_0003_0028');
INSERT INTO "RT_Befund_Bild" VALUES(101,3365,11,22,'003365_0003_0029');
INSERT INTO "RT_Befund_Bild" VALUES(102,3365,11,22,'003365_0003_0030');
INSERT INTO "RT_Befund_Bild" VALUES(103,3365,11,22,'003365_0003_0031');
INSERT INTO "RT_Befund_Bild" VALUES(104,3365,11,22,'003365_0003_0032');
INSERT INTO "RT_Befund_Bild" VALUES(105,3365,11,23,'003365_0003_0033');
INSERT INTO "RT_Befund_Bild" VALUES(106,3365,11,23,'003365_0003_0034');
INSERT INTO "RT_Befund_Bild" VALUES(107,3365,11,3,'003365_0002_0005');
INSERT INTO "RT_Befund_Bild" VALUES(108,3365,11,3,'003365_0002_0006');
INSERT INTO "RT_Befund_Bild" VALUES(109,3365,11,3,'003365_0002_0007');
INSERT INTO "RT_Befund_Bild" VALUES(110,3365,11,3,'003365_0002_0008');
INSERT INTO "RT_Befund_Bild" VALUES(111,3365,11,3,'003365_0002_0009');
INSERT INTO "RT_Befund_Bild" VALUES(112,3365,11,3,'003365_0002_0010');
INSERT INTO "RT_Befund_Bild" VALUES(113,3365,11,3,'003365_0002_0011');
INSERT INTO "RT_Befund_Bild" VALUES(114,3365,11,3,'003365_0002_0012');
INSERT INTO "RT_Befund_Bild" VALUES(115,3365,11,3,'003365_0002_0013');
INSERT INTO "RT_Befund_Bild" VALUES(116,3365,11,5,'003365_0002_0015');
INSERT INTO "RT_Befund_Bild" VALUES(117,3365,11,6,'003365_0002_0016');
INSERT INTO "RT_Befund_Bild" VALUES(118,3365,11,6,'003365_0002_0017');
INSERT INTO "RT_Befund_Bild" VALUES(119,3365,11,6,'003365_0002_0018');
INSERT INTO "RT_Befund_Bild" VALUES(120,3365,11,6,'003365_0002_0019');
INSERT INTO "RT_Befund_Bild" VALUES(121,3365,11,6,'003365_0002_0020');
INSERT INTO "RT_Befund_Bild" VALUES(122,3365,11,6,'003365_0002_0021');
INSERT INTO "RT_Befund_Bild" VALUES(123,3365,11,6,'003365_0002_0022');
INSERT INTO "RT_Befund_Bild" VALUES(124,3365,11,6,'003365_0002_0023');
INSERT INTO "RT_Befund_Bild" VALUES(125,3365,11,6,'003365_0002_0024');
INSERT INTO "RT_Befund_Bild" VALUES(126,3365,11,23,'003365_0003_0035');
INSERT INTO "RT_Befund_Bild" VALUES(127,3365,11,23,'003365_0003_0036');
INSERT INTO "RT_Befund_Bild" VALUES(128,3365,11,23,'003365_0003_0037');
INSERT INTO "RT_Befund_Bild" VALUES(129,3365,11,23,'003365_0003_0038');
INSERT INTO "RT_Befund_Bild" VALUES(130,3365,11,23,'003365_0003_0039');
INSERT INTO "RT_Befund_Bild" VALUES(131,3365,11,23,'003365_0003_0040');
INSERT INTO "RT_Befund_Bild" VALUES(132,3365,11,23,'003365_0003_0041');
INSERT INTO "RT_Befund_Bild" VALUES(133,3365,11,23,'003365_0003_0042');
INSERT INTO "RT_Befund_Bild" VALUES(134,3365,11,18,'003365_0003_0043');
INSERT INTO "RT_Befund_Bild" VALUES(135,3365,11,18,'003365_0003_0044');
INSERT INTO "RT_Befund_Bild" VALUES(136,3365,11,18,'003365_0003_0045');
INSERT INTO "RT_Befund_Bild" VALUES(137,3365,11,18,'003365_0003_0046');
INSERT INTO "RT_Befund_Bild" VALUES(138,3365,11,18,'003365_0003_0047');
INSERT INTO "RT_Befund_Bild" VALUES(139,3365,11,18,'003365_0003_0048');
INSERT INTO "RT_Befund_Bild" VALUES(140,3365,11,3,'003365_0002_0001');
INSERT INTO "RT_Befund_Bild" VALUES(141,3365,11,3,'003365_0002_0002');
INSERT INTO "RT_Befund_Bild" VALUES(142,3365,11,3,'003365_0002_0003');
INSERT INTO "RT_Befund_Bild" VALUES(143,3365,11,3,'003365_0002_0004');
INSERT INTO "RT_Befund_Bild" VALUES(144,3365,11,27,'003365_0004_0015');
INSERT INTO "RT_Befund_Bild" VALUES(145,3365,11,27,'003365_0004_0016');
INSERT INTO "RT_Befund_Bild" VALUES(146,3365,11,27,'003365_0004_0017');
INSERT INTO "RT_Befund_Bild" VALUES(147,3365,11,27,'003365_0004_0018');
INSERT INTO "RT_Befund_Bild" VALUES(148,3365,11,27,'003365_0004_0019');
INSERT INTO "RT_Befund_Bild" VALUES(149,3365,11,27,'003365_0004_0020');
INSERT INTO "RT_Befund_Bild" VALUES(150,3365,11,27,'003365_0004_0021');
INSERT INTO "RT_Befund_Bild" VALUES(151,3365,11,27,'003365_0004_0022');
INSERT INTO "RT_Befund_Bild" VALUES(152,3365,11,26,'003365_0004_0023');
INSERT INTO "RT_Befund_Bild" VALUES(153,3365,11,26,'003365_0004_0024');
INSERT INTO "RT_Befund_Bild" VALUES(154,3365,11,26,'003365_0004_0025');
INSERT INTO "RT_Befund_Bild" VALUES(155,3365,11,26,'003365_0004_0026');
INSERT INTO "RT_Befund_Bild" VALUES(156,3365,11,27,'003365_0004_0027');
INSERT INTO "RT_Befund_Bild" VALUES(157,3365,11,27,'003365_0004_0029');
INSERT INTO "RT_Befund_Bild" VALUES(158,3365,11,27,'003365_0004_0030');
INSERT INTO "RT_Befund_Bild" VALUES(159,3365,11,27,'003365_0004_0031');
INSERT INTO "RT_Befund_Bild" VALUES(160,3365,10,34,'003365_0004_0032');
INSERT INTO "RT_Befund_Bild" VALUES(161,3365,11,27,'003365_0004_0033');
INSERT INTO "RT_Befund_Bild" VALUES(162,3365,10,34,'003365_0004_0034');
INSERT INTO "RT_Befund_Bild" VALUES(163,3365,10,35,'003365_0004_0035');
INSERT INTO "RT_Befund_Bild" VALUES(164,3365,10,35,'003365_0004_0036');
INSERT INTO "RT_Befund_Bild" VALUES(165,3365,10,35,'003365_0004_0037');
INSERT INTO "RT_Befund_Bild" VALUES(166,3365,10,35,'003365_0004_0038');
INSERT INTO "RT_Befund_Bild" VALUES(167,3365,10,35,'003365_0004_0039');
INSERT INTO "RT_Befund_Bild" VALUES(168,3365,10,32,'003365_0004_0040');
INSERT INTO "RT_Befund_Bild" VALUES(169,3365,10,32,'003365_0004_0041');
INSERT INTO "RT_Befund_Bild" VALUES(170,3365,10,32,'003365_0004_0043');
INSERT INTO "RT_Befund_Bild" VALUES(171,3365,10,32,'003365_0004_0044');
INSERT INTO "RT_Befund_Bild" VALUES(172,3365,10,32,'003365_0004_0045');
INSERT INTO "RT_Befund_Bild" VALUES(173,3365,10,32,'003365_0004_0046');
INSERT INTO "RT_Befund_Bild" VALUES(174,3365,15,35,'003365_0004_0054');
INSERT INTO "RT_Befund_Bild" VALUES(175,3365,15,35,'003365_0004_0055');
INSERT INTO "RT_Befund_Bild" VALUES(176,3365,15,35,'003365_0004_0056');
INSERT INTO "RT_Befund_Bild" VALUES(177,3365,15,35,'003365_0004_0057');
INSERT INTO "RT_Befund_Bild" VALUES(178,3365,11,31,'003365_0005_0001');
INSERT INTO "RT_Befund_Bild" VALUES(179,3365,11,31,'003365_0005_0002');
INSERT INTO "RT_Befund_Bild" VALUES(180,3365,11,31,'003365_0005_0003');
INSERT INTO "RT_Befund_Bild" VALUES(181,3365,11,31,'003365_0005_0004');
INSERT INTO "RT_Befund_Bild" VALUES(182,3365,11,31,'003365_0005_0005');
INSERT INTO "RT_Befund_Bild" VALUES(183,3365,11,31,'003365_0005_0006');
INSERT INTO "RT_Befund_Bild" VALUES(184,3365,11,31,'003365_0005_0007');
INSERT INTO "RT_Befund_Bild" VALUES(185,3365,11,31,'003365_0005_0008');
INSERT INTO "RT_Befund_Bild" VALUES(186,3365,11,29,'003365_0005_0009');
INSERT INTO "RT_Befund_Bild" VALUES(187,3365,11,30,'003365_0005_0010');
INSERT INTO "RT_Befund_Bild" VALUES(188,3365,11,30,'003365_0005_0011');
INSERT INTO "RT_Befund_Bild" VALUES(189,3365,11,30,'003365_0005_0012');
INSERT INTO "RT_Befund_Bild" VALUES(190,3365,11,30,'003365_0005_0013');
INSERT INTO "RT_Befund_Bild" VALUES(191,3365,11,30,'003365_0005_0014');
INSERT INTO "RT_Befund_Bild" VALUES(192,3365,11,22,'003365_0005_0015');
INSERT INTO "RT_Befund_Bild" VALUES(193,3365,11,22,'003365_0005_0016');
INSERT INTO "RT_Befund_Bild" VALUES(194,3365,11,22,'003365_0005_0017');
INSERT INTO "RT_Befund_Bild" VALUES(195,3365,11,23,'003365_0005_0018');
INSERT INTO "RT_Befund_Bild" VALUES(196,3365,11,23,'003365_0005_0019');
INSERT INTO "RT_Befund_Bild" VALUES(197,3365,11,21,'003365_0005_0020');
INSERT INTO "RT_Befund_Bild" VALUES(198,3365,11,21,'003365_0005_0021');
INSERT INTO "RT_Befund_Bild" VALUES(199,3365,11,21,'003365_0005_0022');
INSERT INTO "RT_Befund_Bild" VALUES(200,3365,11,21,'003365_0005_0023');
INSERT INTO "RT_Befund_Bild" VALUES(201,3365,11,21,'003365_0005_0024');
INSERT INTO "RT_Befund_Bild" VALUES(202,3365,11,29,'003365_0005_0025');
INSERT INTO "RT_Befund_Bild" VALUES(203,3365,11,19,'003365_0005_0026');
INSERT INTO "RT_Befund_Bild" VALUES(204,3365,11,14,'003365_0005_0027');
INSERT INTO "RT_Befund_Bild" VALUES(205,3365,11,14,'003365_0005_0028');
INSERT INTO "RT_Befund_Bild" VALUES(206,3365,11,14,'003365_0005_0029');
INSERT INTO "RT_Befund_Bild" VALUES(207,3365,11,14,'003365_0005_0030');
INSERT INTO "RT_Befund_Bild" VALUES(208,3365,11,14,'003365_0005_0031');
INSERT INTO "RT_Befund_Bild" VALUES(209,3365,11,14,'003365_0005_0032');
INSERT INTO "RT_Befund_Bild" VALUES(210,3365,11,14,'003365_0005_0033');
INSERT INTO "RT_Befund_Bild" VALUES(211,3365,11,15,'003365_0005_0034');
INSERT INTO "RT_Befund_Bild" VALUES(212,3365,11,15,'003365_0005_0035');
INSERT INTO "RT_Befund_Bild" VALUES(213,3365,11,15,'003365_0005_0036');
INSERT INTO "RT_Befund_Bild" VALUES(214,3365,15,17,'003365_0005_0037');
INSERT INTO "RT_Befund_Bild" VALUES(215,3365,15,17,'003365_0005_0038');
INSERT INTO "RT_Befund_Bild" VALUES(216,3365,15,17,'003365_0005_0039');
INSERT INTO "RT_Befund_Bild" VALUES(217,3365,15,16,'003365_0005_0040');
INSERT INTO "RT_Befund_Bild" VALUES(218,3365,15,16,'003365_0005_0041');
INSERT INTO "RT_Befund_Bild" VALUES(219,3365,15,16,'003365_0005_0042');
INSERT INTO "RT_Befund_Bild" VALUES(220,3365,10,18,'003365_0005_0043');
INSERT INTO "RT_Befund_Bild" VALUES(221,3365,10,18,'003365_0005_0044');
INSERT INTO "RT_Befund_Bild" VALUES(222,3365,10,18,'003365_0005_0045');
INSERT INTO "RT_Befund_Bild" VALUES(223,3365,10,18,'003365_0005_0046');
INSERT INTO "RT_Befund_Bild" VALUES(224,3365,10,18,'003365_0005_0047');
INSERT INTO "RT_Befund_Bild" VALUES(225,3365,10,15,'003365_0005_0048');
INSERT INTO "RT_Befund_Bild" VALUES(226,3365,10,15,'003365_0005_0049');
INSERT INTO "RT_Befund_Bild" VALUES(227,3365,10,15,'003365_0005_0050');
INSERT INTO "RT_Befund_Bild" VALUES(228,3365,10,15,'003365_0005_0051');
INSERT INTO "RT_Befund_Bild" VALUES(229,3365,10,15,'003365_0005_0052');
INSERT INTO "RT_Befund_Bild" VALUES(230,3365,10,16,'003365_0005_0053');
INSERT INTO "RT_Befund_Bild" VALUES(231,3365,10,16,'003365_0005_0054');
INSERT INTO "RT_Befund_Bild" VALUES(232,3365,10,16,'003365_0005_0055');
INSERT INTO "RT_Befund_Bild" VALUES(233,3365,10,17,'003365_0005_0056');
INSERT INTO "RT_Befund_Bild" VALUES(234,3365,10,17,'003365_0005_0057');
INSERT INTO "RT_Befund_Bild" VALUES(235,3365,15,22,'003365_0006_0001');
INSERT INTO "RT_Befund_Bild" VALUES(236,3365,15,22,'003365_0006_0002');
INSERT INTO "RT_Befund_Bild" VALUES(237,3365,15,22,'003365_0006_0003');
INSERT INTO "RT_Befund_Bild" VALUES(238,3365,15,22,'003365_0006_0004');
INSERT INTO "RT_Befund_Bild" VALUES(239,3365,15,22,'003365_0006_0005');
INSERT INTO "RT_Befund_Bild" VALUES(240,3365,10,12,'003365_0006_0006');
INSERT INTO "RT_Befund_Bild" VALUES(241,3365,10,12,'003365_0006_0007');
INSERT INTO "RT_Befund_Bild" VALUES(242,3365,10,12,'003365_0006_0008');
INSERT INTO "RT_Befund_Bild" VALUES(243,3365,11,18,'003365_0003_0049');
INSERT INTO "RT_Befund_Bild" VALUES(244,3365,11,18,'003365_0003_0050');
INSERT INTO "RT_Befund_Bild" VALUES(245,3365,11,18,'003365_0003_0051');
INSERT INTO "RT_Befund_Bild" VALUES(246,3365,11,18,'003365_0003_0052');
INSERT INTO "RT_Befund_Bild" VALUES(247,3365,11,21,'003365_0003_0053');
INSERT INTO "RT_Befund_Bild" VALUES(248,3365,11,21,'003365_0003_0054');
INSERT INTO "RT_Befund_Bild" VALUES(249,3365,11,21,'003365_0003_0055');
INSERT INTO "RT_Befund_Bild" VALUES(250,3365,11,21,'003365_0003_0056');
INSERT INTO "RT_Befund_Bild" VALUES(251,3365,11,18,'003365_0003_0057');
INSERT INTO "RT_Befund_Bild" VALUES(252,3365,11,21,'003365_0003_0058');
INSERT INTO "RT_Befund_Bild" VALUES(253,3365,11,21,'003365_0003_0059');
INSERT INTO "RT_Befund_Bild" VALUES(254,3365,11,21,'003365_0003_0060');
INSERT INTO "RT_Befund_Bild" VALUES(255,3365,11,21,'003365_0003_0061');
INSERT INTO "RT_Befund_Bild" VALUES(256,3365,11,21,'003365_0003_0062');
INSERT INTO "RT_Befund_Bild" VALUES(257,3365,11,21,'003365_0003_0063');
INSERT INTO "RT_Befund_Bild" VALUES(258,3365,11,21,'003365_0003_0064');
INSERT INTO "RT_Befund_Bild" VALUES(259,3365,11,21,'003365_0003_0065');
INSERT INTO "RT_Befund_Bild" VALUES(260,3365,11,21,'003365_0003_0066');
INSERT INTO "RT_Befund_Bild" VALUES(261,3365,11,21,'003365_0003_0068');
INSERT INTO "RT_Befund_Bild" VALUES(262,3365,11,34,'003365_0003_0070');
INSERT INTO "RT_Befund_Bild" VALUES(263,3365,11,34,'003365_0003_0071');
INSERT INTO "RT_Befund_Bild" VALUES(264,3365,11,34,'003365_0003_0072');
INSERT INTO "RT_Befund_Bild" VALUES(265,3365,11,34,'003365_0003_0073');
INSERT INTO "RT_Befund_Bild" VALUES(266,3365,11,34,'003365_0003_0074');
INSERT INTO "RT_Befund_Bild" VALUES(267,3365,11,34,'003365_0003_0075');
INSERT INTO "RT_Befund_Bild" VALUES(268,3365,11,34,'003365_0003_0076');
INSERT INTO "RT_Befund_Bild" VALUES(269,3365,11,34,'003365_0003_0077');
INSERT INTO "RT_Befund_Bild" VALUES(270,3365,11,21,'003365_0003_0078');
INSERT INTO "RT_Befund_Bild" VALUES(271,3365,11,35,'003365_0003_0079');
INSERT INTO "RT_Befund_Bild" VALUES(272,3365,11,35,'003365_0003_0080');
INSERT INTO "RT_Befund_Bild" VALUES(273,3365,11,35,'003365_0003_0081');
INSERT INTO "RT_Befund_Bild" VALUES(274,3365,11,35,'003365_0003_0082');
INSERT INTO "RT_Befund_Bild" VALUES(275,3365,11,35,'003365_0003_0083');
INSERT INTO "RT_Befund_Bild" VALUES(276,3365,15,19,'003365_0003_0084');
INSERT INTO "RT_Befund_Bild" VALUES(277,3365,15,19,'003365_0003_0085');
INSERT INTO "RT_Befund_Bild" VALUES(278,3365,15,19,'003365_0003_0086');
INSERT INTO "RT_Befund_Bild" VALUES(279,3365,15,19,'003365_0003_0087');
INSERT INTO "RT_Befund_Bild" VALUES(280,3365,15,19,'003365_0003_0088');
INSERT INTO "RT_Befund_Bild" VALUES(281,3365,15,19,'003365_0003_0089');
INSERT INTO "RT_Befund_Bild" VALUES(282,3365,15,19,'003365_0003_0090');
INSERT INTO "RT_Befund_Bild" VALUES(283,3365,15,18,'003365_0003_0091');
INSERT INTO "RT_Befund_Bild" VALUES(284,3365,15,18,'003365_0003_0092');
INSERT INTO "RT_Befund_Bild" VALUES(285,3365,15,18,'003365_0003_0093');
INSERT INTO "RT_Befund_Bild" VALUES(286,3365,15,18,'003365_0003_0094');
INSERT INTO "RT_Befund_Bild" VALUES(287,3365,15,18,'003365_0003_0095');
INSERT INTO "RT_Befund_Bild" VALUES(288,3365,15,18,'003365_0003_0096');
INSERT INTO "RT_Befund_Bild" VALUES(289,3365,15,18,'003365_0003_0097');
INSERT INTO "RT_Befund_Bild" VALUES(290,3365,15,14,'003365_0003_0098');
INSERT INTO "RT_Befund_Bild" VALUES(291,3365,15,14,'003365_0003_0099');
INSERT INTO "RT_Befund_Bild" VALUES(292,3365,15,14,'003365_0003_0100');
INSERT INTO "RT_Befund_Bild" VALUES(293,3365,15,14,'003365_0003_0101');
INSERT INTO "RT_Befund_Bild" VALUES(294,3365,15,14,'003365_0003_0102');
INSERT INTO "RT_Befund_Bild" VALUES(295,3365,15,14,'003365_0003_0103');
INSERT INTO "RT_Befund_Bild" VALUES(296,3365,15,14,'003365_0003_0104');
INSERT INTO "RT_Befund_Bild" VALUES(297,3365,10,9,'003365_0004_0001');
INSERT INTO "RT_Befund_Bild" VALUES(298,3365,10,9,'003365_0004_0002');
INSERT INTO "RT_Befund_Bild" VALUES(299,3365,10,9,'003365_0004_0003');
INSERT INTO "RT_Befund_Bild" VALUES(300,3365,10,9,'003365_0004_0004');
INSERT INTO "RT_Befund_Bild" VALUES(301,3365,10,9,'003365_0004_0005');
INSERT INTO "RT_Befund_Bild" VALUES(302,3365,10,9,'003365_0004_0006');
INSERT INTO "RT_Befund_Bild" VALUES(303,3365,11,28,'003365_0004_0007');
INSERT INTO "RT_Befund_Bild" VALUES(304,3365,11,28,'003365_0004_0008');
INSERT INTO "RT_Befund_Bild" VALUES(305,3365,11,28,'003365_0004_0009');
INSERT INTO "RT_Befund_Bild" VALUES(306,3365,11,28,'003365_0004_0010');
INSERT INTO "RT_Befund_Bild" VALUES(307,3365,11,28,'003365_0004_0011');
INSERT INTO "RT_Befund_Bild" VALUES(308,3365,11,27,'003365_0004_0012');
INSERT INTO "RT_Befund_Bild" VALUES(309,3365,11,27,'003365_0004_0013');
INSERT INTO "RT_Befund_Bild" VALUES(310,3365,11,27,'003365_0004_0014');
INSERT INTO "RT_Befund_Bild" VALUES(311,3365,10,12,'003365_0006_0009');
INSERT INTO "RT_Befund_Bild" VALUES(312,3365,10,12,'003365_0006_0010');
INSERT INTO "RT_Befund_Bild" VALUES(313,3365,10,12,'003365_0006_0011');
INSERT INTO "RT_Befund_Bild" VALUES(314,3365,10,12,'003365_0006_0012');
INSERT INTO "RT_Befund_Bild" VALUES(315,3365,10,12,'003365_0006_0013');
INSERT INTO "RT_Befund_Bild" VALUES(316,3365,10,13,'003365_0006_0014');
INSERT INTO "RT_Befund_Bild" VALUES(317,3365,10,13,'003365_0006_0015');
INSERT INTO "RT_Befund_Bild" VALUES(318,3365,10,13,'003365_0006_0016');
INSERT INTO "RT_Befund_Bild" VALUES(319,3365,10,13,'003365_0006_0017');
INSERT INTO "RT_Befund_Bild" VALUES(320,3365,10,13,'003365_0006_0018');
INSERT INTO "RT_Befund_Bild" VALUES(321,3365,10,13,'003365_0006_0019');
INSERT INTO "RT_Befund_Bild" VALUES(322,3365,10,13,'003365_0006_0020');
INSERT INTO "RT_Befund_Bild" VALUES(323,3365,10,13,'003365_0006_0021');
INSERT INTO "RT_Befund_Bild" VALUES(324,3365,10,14,'003365_0006_0022');
INSERT INTO "RT_Befund_Bild" VALUES(325,3365,10,14,'003365_0006_0023');
INSERT INTO "RT_Befund_Bild" VALUES(326,3365,10,14,'003365_0006_0024');
INSERT INTO "RT_Befund_Bild" VALUES(327,3365,10,14,'003365_0006_0025');
INSERT INTO "RT_Befund_Bild" VALUES(328,3365,10,14,'003365_0006_0026');
INSERT INTO "RT_Befund_Bild" VALUES(329,3365,10,14,'003365_0006_0027');
INSERT INTO "RT_Befund_Bild" VALUES(330,3365,10,14,'003365_0006_0028');
INSERT INTO "RT_Befund_Bild" VALUES(331,3365,10,21,'003365_0007_0011');
INSERT INTO "RT_Befund_Bild" VALUES(332,3365,10,21,'003365_0007_0012');
INSERT INTO "RT_Befund_Bild" VALUES(333,3365,10,21,'003365_0007_0013');
INSERT INTO "RT_Befund_Bild" VALUES(334,3365,10,21,'003365_0007_0014');
INSERT INTO "RT_Befund_Bild" VALUES(335,3365,10,21,'003365_0007_0015');
INSERT INTO "RT_Befund_Bild" VALUES(336,3365,10,21,'003365_0007_0017');
INSERT INTO "RT_Befund_Bild" VALUES(337,3365,10,21,'003365_0007_0018');
INSERT INTO "RT_Befund_Bild" VALUES(338,3365,10,21,'003365_0007_0019');
INSERT INTO "RT_Befund_Bild" VALUES(339,3365,10,21,'003365_0007_0020');
INSERT INTO "RT_Befund_Bild" VALUES(340,3365,10,21,'003365_0007_0021');
INSERT INTO "RT_Befund_Bild" VALUES(341,3365,10,1,'003365_0007_0022');
INSERT INTO "RT_Befund_Bild" VALUES(342,3365,10,1,'003365_0007_0023');
INSERT INTO "RT_Befund_Bild" VALUES(343,3365,10,1,'003365_0007_0024');
INSERT INTO "RT_Befund_Bild" VALUES(344,3365,10,1,'003365_0007_0025');
INSERT INTO "RT_Befund_Bild" VALUES(345,3365,11,16,'003365_0001_0067');
INSERT INTO "RT_Befund_Bild" VALUES(346,3365,10,9,'003365_0008_0001');
INSERT INTO "RT_Befund_Bild" VALUES(347,3365,10,9,'003365_0008_0002');
INSERT INTO "RT_Befund_Bild" VALUES(348,3365,10,31,'003365_0008_0003');
INSERT INTO "RT_Befund_Bild" VALUES(349,3365,10,31,'003365_0008_0004');
INSERT INTO "RT_Befund_Bild" VALUES(350,3365,10,31,'003365_0008_0005');
INSERT INTO "RT_Befund_Bild" VALUES(351,3365,10,33,'003365_0008_0006');
INSERT INTO "RT_Befund_Bild" VALUES(352,3365,10,33,'003365_0008_0007');
INSERT INTO "RT_Befund_Bild" VALUES(353,3365,10,33,'003365_0008_0008');
INSERT INTO "RT_Befund_Bild" VALUES(354,3365,10,33,'003365_0008_0009');
INSERT INTO "RT_Befund_Bild" VALUES(355,3365,10,25,'003365_0008_0010');
INSERT INTO "RT_Befund_Bild" VALUES(356,3365,10,25,'003365_0008_0011');
INSERT INTO "RT_Befund_Bild" VALUES(357,3365,10,25,'003365_0008_0012');
INSERT INTO "RT_Befund_Bild" VALUES(358,3365,10,25,'003365_0008_0013');
INSERT INTO "RT_Befund_Bild" VALUES(359,3365,10,27,'003365_0008_0014');
INSERT INTO "RT_Befund_Bild" VALUES(360,3365,10,27,'003365_0008_0015');
INSERT INTO "RT_Befund_Bild" VALUES(361,3365,10,27,'003365_0008_0016');
INSERT INTO "RT_Befund_Bild" VALUES(362,3365,10,27,'003365_0008_0017');
INSERT INTO "RT_Befund_Bild" VALUES(363,3365,10,27,'003365_0008_0018');
INSERT INTO "RT_Befund_Bild" VALUES(364,3365,11,12,'003365_0009_0001');
INSERT INTO "RT_Befund_Bild" VALUES(365,3365,11,12,'003365_0009_0002');
INSERT INTO "RT_Befund_Bild" VALUES(366,3365,11,12,'003365_0009_0003');
INSERT INTO "RT_Befund_Bild" VALUES(367,3365,11,12,'003365_0009_0004');
INSERT INTO "RT_Befund_Bild" VALUES(368,3365,11,13,'003365_0009_0005');
INSERT INTO "RT_Befund_Bild" VALUES(369,3365,11,13,'003365_0009_0006');
INSERT INTO "RT_Befund_Bild" VALUES(370,3365,11,13,'003365_0009_0007');
INSERT INTO "RT_Befund_Bild" VALUES(371,3365,11,13,'003365_0009_0008');
INSERT INTO "RT_Befund_Bild" VALUES(372,3365,11,13,'003365_0009_0009');
INSERT INTO "RT_Befund_Bild" VALUES(373,3365,11,13,'003365_0009_0010');
INSERT INTO "RT_Befund_Bild" VALUES(374,3365,11,13,'003365_0009_0011');
INSERT INTO "RT_Befund_Bild" VALUES(375,3365,11,17,'003365_0009_0012');
INSERT INTO "RT_Befund_Bild" VALUES(376,3365,11,17,'003365_0009_0013');
INSERT INTO "RT_Befund_Bild" VALUES(377,3365,11,17,'003365_0009_0014');
INSERT INTO "RT_Befund_Bild" VALUES(378,3365,11,17,'003365_0009_0015');
INSERT INTO "RT_Befund_Bild" VALUES(379,3365,11,17,'003365_0009_0016');
INSERT INTO "RT_Befund_Bild" VALUES(380,3365,11,17,'003365_0009_0017');
INSERT INTO "RT_Befund_Bild" VALUES(381,3365,11,17,'003365_0009_0018');
INSERT INTO "RT_Befund_Bild" VALUES(382,3365,11,17,'003365_0009_0019');
INSERT INTO "RT_Befund_Bild" VALUES(383,3365,11,17,'003365_0009_0020');
INSERT INTO "RT_Befund_Bild" VALUES(384,3365,11,17,'003365_0009_0021');
INSERT INTO "RT_Befund_Bild" VALUES(385,3365,11,17,'003365_0009_0022');
INSERT INTO "RT_Befund_Bild" VALUES(386,3365,11,17,'003365_0009_0023');
INSERT INTO "RT_Befund_Bild" VALUES(387,3365,11,17,'003365_0009_0024');
INSERT INTO "RT_Befund_Bild" VALUES(388,3365,11,17,'003365_0009_0025');
INSERT INTO "RT_Befund_Bild" VALUES(389,3365,11,17,'003365_0009_0026');
INSERT INTO "RT_Befund_Bild" VALUES(390,3365,11,17,'003365_0009_0027');
INSERT INTO "RT_Befund_Bild" VALUES(391,3365,11,17,'003365_0009_0028');
INSERT INTO "RT_Befund_Bild" VALUES(392,3365,11,17,'003365_0009_0029');
INSERT INTO "RT_Befund_Bild" VALUES(393,3365,11,17,'003365_0009_0030');
INSERT INTO "RT_Befund_Bild" VALUES(394,3365,11,17,'003365_0009_0031');
INSERT INTO "RT_Befund_Bild" VALUES(395,3365,11,17,'003365_0009_0032');
INSERT INTO "RT_Befund_Bild" VALUES(396,3365,11,17,'003365_0009_0033');
INSERT INTO "RT_Befund_Bild" VALUES(397,3365,11,17,'003365_0009_0034');
INSERT INTO "RT_Befund_Bild" VALUES(398,3365,11,17,'003365_0009_0035');
INSERT INTO "RT_Befund_Bild" VALUES(399,3365,11,0,'003365_0009_0036');
INSERT INTO "RT_Befund_Bild" VALUES(400,3365,11,17,'003365_0009_0037');
INSERT INTO "RT_Befund_Bild" VALUES(401,3365,11,17,'003365_0009_0038');
INSERT INTO "RT_Befund_Bild" VALUES(402,3365,11,17,'003365_0009_0039');
INSERT INTO "RT_Befund_Bild" VALUES(403,3365,11,17,'003365_0009_0040');
INSERT INTO "RT_Befund_Bild" VALUES(404,3365,11,17,'003365_0009_0041');
INSERT INTO "RT_Befund_Bild" VALUES(405,3365,11,17,'003365_0009_0042');
INSERT INTO "RT_Befund_Bild" VALUES(406,3365,11,17,'003365_0009_0043');
INSERT INTO "RT_Befund_Bild" VALUES(407,3365,11,18,'003365_0009_0044');
INSERT INTO "RT_Befund_Bild" VALUES(408,3365,11,18,'003365_0009_0045');
INSERT INTO "RT_Befund_Bild" VALUES(409,3365,11,18,'003365_0009_0046');
INSERT INTO "RT_Befund_Bild" VALUES(410,3365,11,18,'003365_0009_0047');
INSERT INTO "RT_Befund_Bild" VALUES(411,3365,11,19,'003365_0009_0048');
INSERT INTO "RT_Befund_Bild" VALUES(412,3365,11,19,'003365_0009_0049');
INSERT INTO "RT_Befund_Bild" VALUES(413,3365,11,19,'003365_0009_0050');
INSERT INTO "RT_Befund_Bild" VALUES(414,3365,11,19,'003365_0009_0051');
INSERT INTO "RT_Befund_Bild" VALUES(415,3365,11,19,'003365_0009_0052');
INSERT INTO "RT_Befund_Bild" VALUES(416,3365,11,19,'003365_0009_0053');
INSERT INTO "RT_Befund_Bild" VALUES(417,3365,11,20,'003365_0009_0054');
INSERT INTO "RT_Befund_Bild" VALUES(418,3365,11,20,'003365_0009_0055');
INSERT INTO "RT_Befund_Bild" VALUES(419,3365,11,21,'003365_0009_0056');
INSERT INTO "RT_Befund_Bild" VALUES(420,3365,11,22,'003365_0009_0057');
INSERT INTO "RT_Befund_Bild" VALUES(421,3365,11,22,'003365_0009_0058');
INSERT INTO "RT_Befund_Bild" VALUES(422,3365,11,22,'003365_0009_0059');
INSERT INTO "RT_Befund_Bild" VALUES(423,3365,11,22,'003365_0009_0060');
INSERT INTO "RT_Befund_Bild" VALUES(424,3365,11,22,'003365_0009_0061');
INSERT INTO "RT_Befund_Bild" VALUES(425,3365,11,22,'003365_0009_0062');
INSERT INTO "RT_Befund_Bild" VALUES(426,3365,11,23,'003365_0009_0063');
INSERT INTO "RT_Befund_Bild" VALUES(427,3365,11,23,'003365_0009_0064');
INSERT INTO "RT_Befund_Bild" VALUES(428,3365,11,23,'003365_0009_0065');
INSERT INTO "RT_Befund_Bild" VALUES(429,3365,11,23,'003365_0009_0066');
INSERT INTO "RT_Befund_Bild" VALUES(430,3365,11,23,'003365_0009_0067');
INSERT INTO "RT_Befund_Bild" VALUES(431,3365,11,25,'003365_0009_0068');
INSERT INTO "RT_Befund_Bild" VALUES(432,3365,11,25,'003365_0009_0069');
INSERT INTO "RT_Befund_Bild" VALUES(433,3365,11,25,'003365_0009_0070');
INSERT INTO "RT_Befund_Bild" VALUES(434,3365,11,25,'003365_0009_0071');
INSERT INTO "RT_Befund_Bild" VALUES(435,3365,11,26,'003365_0009_0072');
INSERT INTO "RT_Befund_Bild" VALUES(436,3365,11,26,'003365_0009_0073');
INSERT INTO "RT_Befund_Bild" VALUES(437,3365,11,26,'003365_0009_0074');
INSERT INTO "RT_Befund_Bild" VALUES(438,3365,11,26,'003365_0009_0075');
INSERT INTO "RT_Befund_Bild" VALUES(439,3365,11,26,'003365_0009_0076');
INSERT INTO "RT_Befund_Bild" VALUES(440,3365,11,26,'003365_0009_0077');
INSERT INTO "RT_Befund_Bild" VALUES(441,3365,11,29,'003365_0009_0078');
INSERT INTO "RT_Befund_Bild" VALUES(442,3365,11,29,'003365_0009_0079');
INSERT INTO "RT_Befund_Bild" VALUES(443,3365,11,29,'003365_0009_0080');
INSERT INTO "RT_Befund_Bild" VALUES(444,3365,11,29,'003365_0009_0081');
INSERT INTO "RT_Befund_Bild" VALUES(445,3365,11,29,'003365_0009_0082');
INSERT INTO "RT_Befund_Bild" VALUES(446,3365,11,30,'003365_0009_0083');
INSERT INTO "RT_Befund_Bild" VALUES(447,3365,11,30,'003365_0009_0084');
INSERT INTO "RT_Befund_Bild" VALUES(448,3365,11,30,'003365_0009_0085');
INSERT INTO "RT_Befund_Bild" VALUES(449,3365,11,30,'003365_0009_0086');
INSERT INTO "RT_Befund_Bild" VALUES(450,3365,11,31,'003365_0009_0087');
INSERT INTO "RT_Befund_Bild" VALUES(451,3365,11,31,'003365_0009_0088');
INSERT INTO "RT_Befund_Bild" VALUES(452,3365,11,31,'003365_0009_0089');
INSERT INTO "RT_Befund_Bild" VALUES(453,3365,11,31,'003365_0009_0090');
INSERT INTO "RT_Befund_Bild" VALUES(454,3365,11,31,'003365_0009_0091');
INSERT INTO "RT_Befund_Bild" VALUES(455,3365,11,31,'003365_0009_0092');
INSERT INTO "RT_Befund_Bild" VALUES(456,3365,11,31,'003365_0009_0093');
INSERT INTO "RT_Befund_Bild" VALUES(457,3365,11,32,'003365_0009_0094');
INSERT INTO "RT_Befund_Bild" VALUES(458,3365,11,32,'003365_0009_0095');
INSERT INTO "RT_Befund_Bild" VALUES(459,3365,11,32,'003365_0009_0096');
INSERT INTO "RT_Befund_Bild" VALUES(460,3365,11,32,'003365_0009_0097');
INSERT INTO "RT_Befund_Bild" VALUES(461,3365,11,32,'003365_0009_0098');
INSERT INTO "RT_Befund_Bild" VALUES(462,3365,11,32,'003365_0009_0099');
INSERT INTO "RT_Befund_Bild" VALUES(463,3365,11,36,'003365_0009_0100');
INSERT INTO "RT_Befund_Bild" VALUES(464,3365,11,36,'003365_0009_0101');
INSERT INTO "RT_Befund_Bild" VALUES(465,3365,11,36,'003365_0009_0102');
INSERT INTO "RT_Befund_Bild" VALUES(466,3365,11,36,'003365_0009_0103');
INSERT INTO "RT_Befund_Bild" VALUES(467,3365,11,36,'003365_0009_0104');
INSERT INTO "RT_Befund_Bild" VALUES(468,3365,11,36,'003365_0009_0105');
INSERT INTO "RT_Befund_Bild" VALUES(469,3365,11,36,'003365_0009_0106');
INSERT INTO "RT_Befund_Bild" VALUES(470,3365,11,37,'003365_0009_0107');
INSERT INTO "RT_Befund_Bild" VALUES(471,3365,11,37,'003365_0009_0108');
INSERT INTO "RT_Befund_Bild" VALUES(472,3365,11,37,'003365_0009_0109');
INSERT INTO "RT_Befund_Bild" VALUES(473,3365,12,11,'003365_0010_0001');
INSERT INTO "RT_Befund_Bild" VALUES(474,3365,12,11,'003365_0010_0002');
INSERT INTO "RT_Befund_Bild" VALUES(475,3365,12,10,'003365_0010_0004');
INSERT INTO "RT_Befund_Bild" VALUES(476,3365,12,10,'003365_0010_0005');
INSERT INTO "RT_Befund_Bild" VALUES(477,3365,12,10,'003365_0010_0006');
INSERT INTO "RT_Befund_Bild" VALUES(478,3365,12,10,'003365_0010_0007');
INSERT INTO "RT_Befund_Bild" VALUES(479,3365,12,10,'003365_0010_0008');
INSERT INTO "RT_Befund_Bild" VALUES(480,3365,12,10,'003365_0010_0009');
INSERT INTO "RT_Befund_Bild" VALUES(481,3365,12,10,'003365_0010_0010');
INSERT INTO "RT_Befund_Bild" VALUES(482,3365,12,10,'003365_0010_0011');
INSERT INTO "RT_Befund_Bild" VALUES(483,3365,12,11,'003365_0010_0012');
INSERT INTO "RT_Befund_Bild" VALUES(484,3365,12,11,'003365_0010_0013');
INSERT INTO "RT_Befund_Bild" VALUES(485,3365,12,11,'003365_0010_0014');
INSERT INTO "RT_Befund_Bild" VALUES(486,3365,12,11,'003365_0010_0015');
INSERT INTO "RT_Befund_Bild" VALUES(487,3365,12,11,'003365_0010_0016');
INSERT INTO "RT_Befund_Bild" VALUES(488,3365,12,11,'003365_0010_0017');
INSERT INTO "RT_Befund_Bild" VALUES(489,3365,12,11,'003365_0010_0018');
INSERT INTO "RT_Befund_Bild" VALUES(490,3365,12,10,'003365_0010_0019');
INSERT INTO "RT_Befund_Bild" VALUES(491,3365,12,10,'003365_0010_0020');
INSERT INTO "RT_Befund_Bild" VALUES(492,3365,12,10,'003365_0010_0021');
INSERT INTO "RT_Befund_Bild" VALUES(493,3365,12,10,'003365_0010_0022');
INSERT INTO "RT_Befund_Bild" VALUES(494,3365,12,10,'003365_0010_0023');
INSERT INTO "RT_Befund_Bild" VALUES(495,3365,12,11,'003365_0010_0024');
INSERT INTO "RT_Befund_Bild" VALUES(496,3365,12,11,'003365_0010_0025');
INSERT INTO "RT_Befund_Bild" VALUES(497,3365,12,11,'003365_0010_0026');
INSERT INTO "RT_Befund_Bild" VALUES(498,3365,12,11,'003365_0010_0027');
INSERT INTO "RT_Befund_Bild" VALUES(499,3365,12,11,'003365_0010_0028');
INSERT INTO "RT_Befund_Bild" VALUES(500,3365,12,11,'003365_0010_0029');
INSERT INTO "RT_Befund_Bild" VALUES(501,3365,12,11,'003365_0010_0030');
INSERT INTO "RT_Befund_Bild" VALUES(502,3365,12,11,'003365_0010_0031');
INSERT INTO "RT_Befund_Bild" VALUES(503,3365,12,4,'003365_0010_0032');
INSERT INTO "RT_Befund_Bild" VALUES(504,3365,12,4,'003365_0010_0033');
INSERT INTO "RT_Befund_Bild" VALUES(505,3365,12,4,'003365_0010_0034');
INSERT INTO "RT_Befund_Bild" VALUES(506,3365,12,4,'003365_0010_0035');
INSERT INTO "RT_Befund_Bild" VALUES(507,3365,12,4,'003365_0010_0036');
INSERT INTO "RT_Befund_Bild" VALUES(508,3365,12,4,'003365_0010_0037');
INSERT INTO "RT_Befund_Bild" VALUES(509,3365,12,4,'003365_0010_0038');
INSERT INTO "RT_Befund_Bild" VALUES(510,3365,12,4,'003365_0010_0039');
INSERT INTO "RT_Befund_Bild" VALUES(511,3365,12,4,'003365_0010_0040');
INSERT INTO "RT_Befund_Bild" VALUES(512,3365,13,12,'003365_0011_0001');
INSERT INTO "RT_Befund_Bild" VALUES(513,3365,13,12,'003365_0011_0002');
INSERT INTO "RT_Befund_Bild" VALUES(514,3365,13,12,'003365_0011_0003');
INSERT INTO "RT_Befund_Bild" VALUES(515,3365,13,12,'003365_0011_0004');
INSERT INTO "RT_Befund_Bild" VALUES(516,3365,13,12,'003365_0011_0005');
INSERT INTO "RT_Befund_Bild" VALUES(517,3365,13,12,'003365_0011_0006');
INSERT INTO "RT_Befund_Bild" VALUES(518,3365,13,12,'003365_0011_0007');
INSERT INTO "RT_Befund_Bild" VALUES(519,3365,15,14,'003365_0012_0001');
INSERT INTO "RT_Befund_Bild" VALUES(520,3365,15,14,'003365_0012_0002');
INSERT INTO "RT_Befund_Bild" VALUES(521,3365,15,14,'003365_0012_0003');
INSERT INTO "RT_Befund_Bild" VALUES(522,3365,15,14,'003365_0012_0004');
INSERT INTO "RT_Befund_Bild" VALUES(523,3365,15,14,'003365_0012_0005');
INSERT INTO "RT_Befund_Bild" VALUES(524,3365,15,14,'003365_0012_0006');
INSERT INTO "RT_Befund_Bild" VALUES(525,3365,15,14,'003365_0012_0007');
INSERT INTO "RT_Befund_Bild" VALUES(526,3365,15,15,'003365_0012_0008');
INSERT INTO "RT_Befund_Bild" VALUES(527,3365,15,15,'003365_0012_0009');
INSERT INTO "RT_Befund_Bild" VALUES(528,3365,15,15,'003365_0012_0010');
INSERT INTO "RT_Befund_Bild" VALUES(529,3365,15,15,'003365_0012_0011');
INSERT INTO "RT_Befund_Bild" VALUES(530,3365,15,16,'003365_0012_0012');
INSERT INTO "RT_Befund_Bild" VALUES(531,3365,15,16,'003365_0012_0013');
INSERT INTO "RT_Befund_Bild" VALUES(532,3365,15,16,'003365_0012_0014');
INSERT INTO "RT_Befund_Bild" VALUES(533,3365,15,16,'003365_0012_0015');
INSERT INTO "RT_Befund_Bild" VALUES(534,3365,15,16,'003365_0012_0016');
INSERT INTO "RT_Befund_Bild" VALUES(535,3365,15,16,'003365_0012_0017');
INSERT INTO "RT_Befund_Bild" VALUES(536,3365,15,16,'003365_0012_0018');
INSERT INTO "RT_Befund_Bild" VALUES(537,3365,15,16,'003365_0012_0019');
INSERT INTO "RT_Befund_Bild" VALUES(538,3365,15,16,'003365_0012_0020');
INSERT INTO "RT_Befund_Bild" VALUES(539,3365,15,22,'003365_0012_0021');
INSERT INTO "RT_Befund_Bild" VALUES(540,3365,15,22,'003365_0012_0022');
INSERT INTO "RT_Befund_Bild" VALUES(541,3365,15,22,'003365_0012_0023');
INSERT INTO "RT_Befund_Bild" VALUES(542,3365,15,22,'003365_0012_0024');
INSERT INTO "RT_Befund_Bild" VALUES(543,3365,15,22,'003365_0012_0025');
INSERT INTO "RT_Befund_Bild" VALUES(544,3365,15,22,'003365_0012_0026');
INSERT INTO "RT_Befund_Bild" VALUES(545,3365,15,24,'003365_0012_0027');
INSERT INTO "RT_Befund_Bild" VALUES(546,3365,15,30,'003365_0012_0029');
INSERT INTO "RT_Befund_Bild" VALUES(547,3365,15,35,'003365_0012_0030');
INSERT INTO "RT_Befund_Bild" VALUES(548,3365,15,35,'003365_0012_0031');
INSERT INTO "RT_Befund_Bild" VALUES(549,3365,15,35,'003365_0012_0032');
INSERT INTO "RT_Befund_Bild" VALUES(550,3365,15,35,'003365_0012_0033');
INSERT INTO "RT_Befund_Bild" VALUES(551,3365,15,35,'003365_0012_0034');
INSERT INTO "RT_Befund_Bild" VALUES(552,3365,15,35,'003365_0012_0035');
INSERT INTO "RT_Befund_Bild" VALUES(553,3365,15,35,'003365_0012_0036');
INSERT INTO "RT_Befund_Bild" VALUES(554,3365,17,1,'003365_0013_0001');
INSERT INTO "RT_Befund_Bild" VALUES(555,3365,17,1,'003365_0013_0002');
INSERT INTO "RT_Befund_Bild" VALUES(556,3365,17,1,'003365_0013_0003');
INSERT INTO "RT_Befund_Bild" VALUES(557,3365,17,1,'003365_0013_0004');
INSERT INTO "RT_Befund_Bild" VALUES(558,3365,17,1,'003365_0013_0005');
INSERT INTO "RT_Befund_Bild" VALUES(559,3365,17,1,'003365_0013_0006');
INSERT INTO "RT_Befund_Bild" VALUES(560,3365,17,1,'003365_0013_0007');
INSERT INTO "RT_Befund_Bild" VALUES(561,3365,17,1,'003365_0013_0008');
INSERT INTO "RT_Befund_Bild" VALUES(562,3365,17,1,'003365_0013_0009');
INSERT INTO "RT_Befund_Bild" VALUES(563,3365,17,1,'003365_0013_0010');
INSERT INTO "RT_Befund_Bild" VALUES(564,3365,17,1,'003365_0013_0011');
INSERT INTO "RT_Befund_Bild" VALUES(565,3365,17,1,'003365_0013_0012');
INSERT INTO "RT_Befund_Bild" VALUES(566,3365,17,1,'003365_0013_0013');
INSERT INTO "RT_Befund_Bild" VALUES(567,3365,17,1,'003365_0013_0014');
INSERT INTO "RT_Befund_Bild" VALUES(568,3365,17,1,'003365_0013_0015');
INSERT INTO "RT_Befund_Bild" VALUES(569,3365,17,1,'003365_0013_0016');
INSERT INTO "RT_Befund_Bild" VALUES(570,3365,17,1,'003365_0013_0017');
INSERT INTO "RT_Befund_Bild" VALUES(571,3365,17,1,'003365_0013_0018');
INSERT INTO "RT_Befund_Bild" VALUES(572,3365,17,1,'003365_0013_0019');
INSERT INTO "RT_Befund_Bild" VALUES(573,3365,17,1,'003365_0013_0020');
INSERT INTO "RT_Befund_Bild" VALUES(574,3365,17,1,'003365_0013_0021');
INSERT INTO "RT_Befund_Bild" VALUES(575,3365,17,1,'003365_0013_0022');
INSERT INTO "RT_Befund_Bild" VALUES(576,3365,17,1,'003365_0013_0023');
INSERT INTO "RT_Befund_Bild" VALUES(577,3365,17,1,'003365_0013_0024');
INSERT INTO "RT_Befund_Bild" VALUES(578,3365,17,2,'003365_0013_0025');
INSERT INTO "RT_Befund_Bild" VALUES(579,3365,17,2,'003365_0013_0026');
INSERT INTO "RT_Befund_Bild" VALUES(580,3365,17,2,'003365_0013_0027');
INSERT INTO "RT_Befund_Bild" VALUES(581,3365,17,2,'003365_0013_0028');
INSERT INTO "RT_Befund_Bild" VALUES(582,3365,17,6,'003365_0013_0029');
INSERT INTO "RT_Befund_Bild" VALUES(583,3365,17,6,'003365_0013_0030');
INSERT INTO "RT_Befund_Bild" VALUES(584,3365,17,6,'003365_0013_0031');
INSERT INTO "RT_Befund_Bild" VALUES(585,3365,17,6,'003365_0013_0032');
INSERT INTO "RT_Befund_Bild" VALUES(586,3365,10,12,'003365_0014_0001');
INSERT INTO "RT_Befund_Bild" VALUES(587,3365,10,12,'003365_0014_0002');
INSERT INTO "RT_Befund_Bild" VALUES(588,3365,10,12,'003365_0014_0003');
INSERT INTO "RT_Befund_Bild" VALUES(589,3365,10,14,'003365_0014_0004');
INSERT INTO "RT_Befund_Bild" VALUES(590,3365,10,14,'003365_0014_0005');
INSERT INTO "RT_Befund_Bild" VALUES(591,3365,10,15,'003365_0014_0006');
INSERT INTO "RT_Befund_Bild" VALUES(592,3365,10,15,'003365_0014_0007');
INSERT INTO "RT_Befund_Bild" VALUES(593,3365,10,16,'003365_0014_0008');
INSERT INTO "RT_Befund_Bild" VALUES(594,3365,10,16,'003365_0014_0009');
INSERT INTO "RT_Befund_Bild" VALUES(595,3365,10,17,'003365_0014_0010');
INSERT INTO "RT_Befund_Bild" VALUES(596,3365,10,28,'003365_0014_0011');
INSERT INTO "RT_Befund_Bild" VALUES(597,3365,10,28,'003365_0014_0012');
INSERT INTO "RT_Befund_Bild" VALUES(598,3365,11,11,'003365_0016_0001');
INSERT INTO "RT_Befund_Bild" VALUES(599,3365,11,11,'003365_0016_0002');
INSERT INTO "RT_Befund_Bild" VALUES(600,3365,11,14,'003365_0016_0003');
INSERT INTO "RT_Befund_Bild" VALUES(601,3365,11,14,'003365_0016_0004');
INSERT INTO "RT_Befund_Bild" VALUES(602,3365,11,14,'003365_0016_0005');
INSERT INTO "RT_Befund_Bild" VALUES(603,3365,11,14,'003365_0016_0006');
INSERT INTO "RT_Befund_Bild" VALUES(604,3365,11,14,'003365_0016_0007');
INSERT INTO "RT_Befund_Bild" VALUES(605,3365,11,14,'003365_0016_0008');
INSERT INTO "RT_Befund_Bild" VALUES(606,3365,11,14,'003365_0016_0009');
INSERT INTO "RT_Befund_Bild" VALUES(607,3365,11,14,'003365_0016_0010');
INSERT INTO "RT_Befund_Bild" VALUES(608,3365,11,15,'003365_0016_0011');
INSERT INTO "RT_Befund_Bild" VALUES(609,3365,11,15,'003365_0016_0012');
INSERT INTO "RT_Befund_Bild" VALUES(610,3365,11,16,'003365_0016_0013');
INSERT INTO "RT_Befund_Bild" VALUES(611,3365,11,16,'003365_0016_0014');
INSERT INTO "RT_Befund_Bild" VALUES(612,3365,11,16,'003365_0016_0015');
INSERT INTO "RT_Befund_Bild" VALUES(613,3365,11,17,'003365_0016_0016');
INSERT INTO "RT_Befund_Bild" VALUES(614,3365,11,17,'003365_0016_0017');
INSERT INTO "RT_Befund_Bild" VALUES(615,3365,11,17,'003365_0016_0018');
INSERT INTO "RT_Befund_Bild" VALUES(616,3365,11,18,'003365_0016_0019');
INSERT INTO "RT_Befund_Bild" VALUES(617,3365,11,18,'003365_0016_0020');
INSERT INTO "RT_Befund_Bild" VALUES(618,3365,11,18,'003365_0016_0021');
INSERT INTO "RT_Befund_Bild" VALUES(619,3365,11,19,'003365_0016_0022');
INSERT INTO "RT_Befund_Bild" VALUES(620,3365,11,19,'003365_0016_0023');
INSERT INTO "RT_Befund_Bild" VALUES(621,3365,11,0,'003365_0016_0024');
INSERT INTO "RT_Befund_Bild" VALUES(622,3365,11,20,'003365_0016_0025');
INSERT INTO "RT_Befund_Bild" VALUES(623,3365,11,20,'003365_0016_0026');
INSERT INTO "RT_Befund_Bild" VALUES(624,3365,11,22,'003365_0016_0028');
INSERT INTO "RT_Befund_Bild" VALUES(625,3365,11,22,'003365_0016_0029');
INSERT INTO "RT_Befund_Bild" VALUES(626,3365,11,22,'003365_0016_0030');
INSERT INTO "RT_Befund_Bild" VALUES(627,3365,11,23,'003365_0016_0031');
INSERT INTO "RT_Befund_Bild" VALUES(628,3365,11,23,'003365_0016_0032');
INSERT INTO "RT_Befund_Bild" VALUES(629,3365,11,25,'003365_0016_0034');
INSERT INTO "RT_Befund_Bild" VALUES(630,3365,11,25,'003365_0016_0035');
INSERT INTO "RT_Befund_Bild" VALUES(631,3365,11,28,'003365_0016_0036');
INSERT INTO "RT_Befund_Bild" VALUES(632,3365,11,28,'003365_0016_0037');
INSERT INTO "RT_Befund_Bild" VALUES(633,3365,11,29,'003365_0016_0038');
INSERT INTO "RT_Befund_Bild" VALUES(634,3365,11,3,'003365_0016_0039');
INSERT INTO "RT_Befund_Bild" VALUES(635,3365,11,3,'003365_0016_0040');
INSERT INTO "RT_Befund_Bild" VALUES(636,3365,11,31,'003365_0016_0041');
INSERT INTO "RT_Befund_Bild" VALUES(637,3365,11,31,'003365_0016_0042');
INSERT INTO "RT_Befund_Bild" VALUES(638,3365,11,31,'003365_0016_0043');
INSERT INTO "RT_Befund_Bild" VALUES(639,3365,11,31,'003365_0016_0044');
INSERT INTO "RT_Befund_Bild" VALUES(640,3365,11,31,'003365_0016_0045');
INSERT INTO "RT_Befund_Bild" VALUES(641,3365,11,31,'003365_0016_0046');
INSERT INTO "RT_Befund_Bild" VALUES(642,3365,11,33,'003365_0016_0047');
INSERT INTO "RT_Befund_Bild" VALUES(643,3365,11,33,'003365_0016_0048');
INSERT INTO "RT_Befund_Bild" VALUES(644,3365,11,33,'003365_0016_0049');
INSERT INTO "RT_Befund_Bild" VALUES(645,3365,11,33,'003365_0016_0050');
INSERT INTO "RT_Befund_Bild" VALUES(646,3365,11,33,'003365_0016_0051');
INSERT INTO "RT_Befund_Bild" VALUES(647,3365,11,33,'003365_0016_0052');
INSERT INTO "RT_Befund_Bild" VALUES(648,3365,11,4,'003365_0016_0053');
INSERT INTO "RT_Befund_Bild" VALUES(649,3365,11,5,'003365_0016_0055');
INSERT INTO "RT_Befund_Bild" VALUES(650,3365,11,5,'003365_0016_0056');
INSERT INTO "RT_Befund_Bild" VALUES(651,3365,11,5,'003365_0016_0057');
INSERT INTO "RT_Befund_Bild" VALUES(652,3365,11,6,'003365_0016_0058');
INSERT INTO "RT_Befund_Bild" VALUES(653,3365,11,6,'003365_0016_0059');
INSERT INTO "RT_Befund_Bild" VALUES(654,3365,11,6,'003365_0016_0060');
INSERT INTO "RT_Befund_Bild" VALUES(655,3365,12,10,'003365_0016_0061');
INSERT INTO "RT_Befund_Bild" VALUES(656,3365,12,11,'003365_0016_0063');
INSERT INTO "RT_Befund_Bild" VALUES(657,3365,12,11,'003365_0016_0064');
INSERT INTO "RT_Befund_Bild" VALUES(658,3365,12,11,'003365_0016_0065');
INSERT INTO "RT_Befund_Bild" VALUES(659,3365,15,15,'003365_0016_0066');
INSERT INTO "RT_Befund_Bild" VALUES(660,3365,15,15,'003365_0016_0067');
INSERT INTO "RT_Befund_Bild" VALUES(661,3365,10,12,'003365_0017_0001');
INSERT INTO "RT_Befund_Bild" VALUES(662,3365,10,12,'003365_0017_0002');
INSERT INTO "RT_Befund_Bild" VALUES(663,3365,10,12,'003365_0017_0003');
INSERT INTO "RT_Befund_Bild" VALUES(664,3365,10,13,'003365_0017_0004');
INSERT INTO "RT_Befund_Bild" VALUES(665,3365,11,26,'003365_0017_0005');
INSERT INTO "RT_Befund_Bild" VALUES(666,3365,11,26,'003365_0017_0006');
INSERT INTO "RT_Befund_Bild" VALUES(667,3365,11,26,'003365_0017_0007');
INSERT INTO "RT_Befund_Bild" VALUES(668,3365,11,26,'003365_0017_0008');
INSERT INTO "RT_Befund_Bild" VALUES(669,3365,11,26,'003365_0017_0009');
INSERT INTO "RT_Befund_Bild" VALUES(670,3365,11,28,'003365_0017_0010');
INSERT INTO "RT_Befund_Bild" VALUES(671,3365,10,0,'003365_0018_0001');
INSERT INTO "RT_Befund_Bild" VALUES(672,3365,10,0,'003365_0018_0002');
INSERT INTO "RT_Befund_Bild" VALUES(673,3365,10,0,'003365_0018_0003');
INSERT INTO "RT_Befund_Bild" VALUES(674,3365,10,0,'003365_0018_0004');
INSERT INTO "RT_Befund_Bild" VALUES(675,3365,17,0,'003365_0018_0005');
INSERT INTO "RT_Befund_Bild" VALUES(676,3365,17,0,'003365_0018_0006');
INSERT INTO "RT_Befund_Bild" VALUES(677,3365,17,0,'003365_0018_0007');
INSERT INTO "RT_Befund_Bild" VALUES(678,3365,11,0,'003365_0018_0008');
INSERT INTO "RT_Befund_Bild" VALUES(679,3365,11,0,'003365_0018_0009');
INSERT INTO "RT_Befund_Bild" VALUES(680,3365,11,0,'003365_0018_0010');
INSERT INTO "RT_Befund_Bild" VALUES(689,3365,15,14,'003365_0001_0054');
INSERT INTO "RT_Befund_Bild" VALUES(690,3365,15,16,'003365_0018_0012');
INSERT INTO "RT_Befund_Bild" VALUES(691,3365,15,16,'003365_0018_0013');
INSERT INTO "RT_Befund_Bild" VALUES(692,3365,15,17,'003365_0018_0014');
INSERT INTO "RT_Befund_Bild" VALUES(693,3365,15,17,'003365_0018_0015');
INSERT INTO "RT_Befund_Bild" VALUES(694,3365,15,18,'003365_0018_0016');
INSERT INTO "RT_Befund_Bild" VALUES(695,3365,15,18,'003365_0018_0017');
INSERT INTO "RT_Befund_Bild" VALUES(696,3365,15,18,'003365_0018_0018');
INSERT INTO "RT_Befund_Bild" VALUES(697,3365,15,18,'003365_0018_0019');
INSERT INTO "RT_Befund_Bild" VALUES(698,3365,11,33,'003365_0019_0001');
INSERT INTO "RT_Befund_Bild" VALUES(699,3365,11,33,'003365_0019_0002');
INSERT INTO "RT_Befund_Bild" VALUES(700,3365,11,33,'003365_0019_0003');
INSERT INTO "RT_Befund_Bild" VALUES(701,3365,11,33,'003365_0019_0004');
INSERT INTO "RT_Befund_Bild" VALUES(702,3365,11,33,'003365_0019_0005');
INSERT INTO "RT_Befund_Bild" VALUES(703,3365,10,34,'003365_0020_0001');
INSERT INTO "RT_Befund_Bild" VALUES(704,3365,10,34,'003365_0020_0002');
INSERT INTO "RT_Befund_Bild" VALUES(705,3365,10,34,'003365_0020_0003');
INSERT INTO "RT_Befund_Bild" VALUES(706,3365,10,34,'003365_0020_0004');
INSERT INTO "RT_Befund_Bild" VALUES(707,3365,10,34,'003365_0020_0005');
INSERT INTO "RT_Befund_Bild" VALUES(708,3365,10,34,'003365_0020_0006');
INSERT INTO "RT_Befund_Bild" VALUES(709,3365,10,34,'003365_0020_0007');
INSERT INTO "RT_Befund_Bild" VALUES(710,3365,11,2,'003365_0021_0001');
INSERT INTO "RT_Befund_Bild" VALUES(711,3365,11,2,'003365_0021_0002');
INSERT INTO "RT_Befund_Bild" VALUES(712,3365,11,2,'003365_0021_0003');
INSERT INTO "RT_Befund_Bild" VALUES(713,3365,11,2,'003365_0021_0004');
INSERT INTO "RT_Befund_Bild" VALUES(714,3365,11,37,'003365_0021_0005');
INSERT INTO "RT_Befund_Bild" VALUES(715,3365,11,45,'003365_0021_0006');
INSERT INTO "RT_Befund_Bild" VALUES(716,3365,11,45,'003365_0021_0007');
INSERT INTO "RT_Befund_Bild" VALUES(717,3365,11,45,'003365_0021_0008');
INSERT INTO "RT_Befund_Bild" VALUES(718,3365,11,45,'003365_0021_0009');
INSERT INTO "RT_Befund_Bild" VALUES(719,3365,11,45,'003365_0021_0010');
INSERT INTO "RT_Befund_Bild" VALUES(720,3365,11,45,'003365_0021_0011');
INSERT INTO "RT_Befund_Bild" VALUES(721,3365,11,45,'003365_0021_0012');
INSERT INTO "RT_Befund_Bild" VALUES(722,3365,11,45,'003365_0021_0013');
INSERT INTO "RT_Befund_Bild" VALUES(723,3365,11,45,'003365_0021_0014');
INSERT INTO "RT_Befund_Bild" VALUES(724,3365,11,45,'003365_0021_0015');
INSERT INTO "RT_Befund_Bild" VALUES(725,3365,11,45,'003365_0021_0016');
INSERT INTO "RT_Befund_Bild" VALUES(726,3365,11,45,'003365_0021_0017');
INSERT INTO "RT_Befund_Bild" VALUES(727,3365,11,45,'003365_0021_0018');
INSERT INTO "RT_Befund_Bild" VALUES(728,3365,11,45,'003365_0021_0019');
INSERT INTO "RT_Befund_Bild" VALUES(729,3365,11,45,'003365_0021_0020');
INSERT INTO "RT_Befund_Bild" VALUES(730,3365,11,45,'003365_0021_0021');
INSERT INTO "RT_Befund_Bild" VALUES(731,3365,11,45,'003365_0021_0022');
INSERT INTO "RT_Befund_Bild" VALUES(732,3365,11,44,'003365_0021_0023');
INSERT INTO "RT_Befund_Bild" VALUES(733,3365,11,44,'003365_0021_0024');
INSERT INTO "RT_Befund_Bild" VALUES(734,3365,11,44,'003365_0021_0025');
INSERT INTO "RT_Befund_Bild" VALUES(735,3365,11,44,'003365_0021_0026');
INSERT INTO "RT_Befund_Bild" VALUES(736,3365,11,41,'003365_0021_0027');
INSERT INTO "RT_Befund_Bild" VALUES(737,3365,11,41,'003365_0021_0028');
INSERT INTO "RT_Befund_Bild" VALUES(738,3365,11,41,'003365_0021_0029');
INSERT INTO "RT_Befund_Bild" VALUES(739,3365,11,41,'003365_0021_0030');
INSERT INTO "RT_Befund_Bild" VALUES(740,3365,11,30,'003365_0022_0001');
INSERT INTO "RT_Befund_Bild" VALUES(741,3365,11,30,'003365_0022_0002');
INSERT INTO "RT_Befund_Bild" VALUES(742,3365,11,30,'003365_0022_0003');
INSERT INTO "RT_Befund_Bild" VALUES(743,3365,11,30,'003365_0022_0004');
INSERT INTO "RT_Befund_Bild" VALUES(744,3365,11,30,'003365_0022_0005');
INSERT INTO "RT_Befund_Bild" VALUES(745,3365,11,30,'003365_0022_0006');
INSERT INTO "RT_Befund_Bild" VALUES(746,3365,11,30,'003365_0022_0007');
INSERT INTO "RT_Befund_Bild" VALUES(747,3365,11,30,'003365_0022_0008');
INSERT INTO "RT_Befund_Bild" VALUES(748,3365,11,30,'003365_0022_0009');
INSERT INTO "RT_Befund_Bild" VALUES(749,3365,11,30,'003365_0022_0010');
INSERT INTO "RT_Befund_Bild" VALUES(750,3365,11,30,'003365_0022_0011');
INSERT INTO "RT_Befund_Bild" VALUES(751,3365,11,30,'003365_0022_0012');
INSERT INTO "RT_Befund_Bild" VALUES(752,3365,11,30,'003365_0022_0013');
INSERT INTO "RT_Befund_Bild" VALUES(753,3365,11,29,'003365_0022_0014');
INSERT INTO "RT_Befund_Bild" VALUES(754,3365,11,29,'003365_0022_0015');
INSERT INTO "RT_Befund_Bild" VALUES(755,3365,11,29,'003365_0022_0016');
INSERT INTO "RT_Befund_Bild" VALUES(756,3365,11,29,'003365_0022_0017');
INSERT INTO "RT_Befund_Bild" VALUES(757,3365,11,29,'003365_0022_0018');
INSERT INTO "RT_Befund_Bild" VALUES(758,3365,11,29,'003365_0022_0019');
INSERT INTO "RT_Befund_Bild" VALUES(759,3365,11,29,'003365_0022_0020');
INSERT INTO "RT_Befund_Bild" VALUES(760,3365,11,29,'003365_0022_0021');
INSERT INTO "RT_Befund_Bild" VALUES(761,3365,11,29,'003365_0022_0022');
INSERT INTO "RT_Befund_Bild" VALUES(762,3365,11,29,'003365_0022_0023');
INSERT INTO "RT_Befund_Bild" VALUES(763,3365,11,29,'003365_0022_0024');
INSERT INTO "RT_Befund_Bild" VALUES(764,3365,11,29,'003365_0022_0025');
INSERT INTO "RT_Befund_Bild" VALUES(765,3365,11,29,'003365_0022_0026');
INSERT INTO "RT_Befund_Bild" VALUES(766,3365,11,29,'003365_0022_0027');
INSERT INTO "RT_Befund_Bild" VALUES(767,3365,11,29,'003365_0022_0028');
INSERT INTO "RT_Befund_Bild" VALUES(768,3365,11,29,'003365_0022_0029');
INSERT INTO "RT_Befund_Bild" VALUES(769,3365,11,29,'003365_0022_0030');
INSERT INTO "RT_Befund_Bild" VALUES(770,3365,11,22,'003365_0022_0031');
INSERT INTO "RT_Befund_Bild" VALUES(771,3365,11,22,'003365_0022_0032');
INSERT INTO "RT_Befund_Bild" VALUES(772,3365,11,22,'003365_0022_0033');
INSERT INTO "RT_Befund_Bild" VALUES(773,3365,11,22,'003365_0022_0034');
INSERT INTO "RT_Befund_Bild" VALUES(774,3365,11,22,'003365_0022_0035');
INSERT INTO "RT_Befund_Bild" VALUES(775,3365,11,22,'003365_0022_0036');
INSERT INTO "RT_Befund_Bild" VALUES(776,3365,11,22,'003365_0022_0037');
INSERT INTO "RT_Befund_Bild" VALUES(777,3365,11,22,'003365_0022_0038');
INSERT INTO "RT_Befund_Bild" VALUES(778,3365,11,22,'003365_0022_0039');
INSERT INTO "RT_Befund_Bild" VALUES(779,3365,11,22,'003365_0022_0040');
INSERT INTO "RT_Befund_Bild" VALUES(780,3365,11,22,'003365_0022_0041');
INSERT INTO "RT_Befund_Bild" VALUES(781,3365,11,22,'003365_0022_0042');
INSERT INTO "RT_Befund_Bild" VALUES(782,3365,11,22,'003365_0022_0043');
INSERT INTO "RT_Befund_Bild" VALUES(783,3365,11,22,'003365_0022_0044');
INSERT INTO "RT_Befund_Bild" VALUES(784,3365,11,22,'003365_0022_0045');
INSERT INTO "RT_Befund_Bild" VALUES(785,3365,11,22,'003365_0022_0046');
INSERT INTO "RT_Befund_Bild" VALUES(786,3365,11,22,'003365_0022_0047');
INSERT INTO "RT_Befund_Bild" VALUES(787,3365,11,22,'003365_0022_0048');
INSERT INTO "RT_Befund_Bild" VALUES(788,3365,11,22,'003365_0022_0049');
INSERT INTO "RT_Befund_Bild" VALUES(789,3365,11,22,'003365_0022_0050');
INSERT INTO "RT_Befund_Bild" VALUES(790,3365,11,22,'003365_0022_0051');
INSERT INTO "RT_Befund_Bild" VALUES(791,3365,11,22,'003365_0022_0052');
INSERT INTO "RT_Befund_Bild" VALUES(792,3365,11,22,'003365_0022_0053');
INSERT INTO "RT_Befund_Bild" VALUES(793,3365,11,22,'003365_0022_0054');
INSERT INTO "RT_Befund_Bild" VALUES(794,3365,11,22,'003365_0022_0055');
INSERT INTO "RT_Befund_Bild" VALUES(795,3365,11,22,'003365_0022_0056');
INSERT INTO "RT_Befund_Bild" VALUES(796,3365,11,22,'003365_0022_0057');
INSERT INTO "RT_Befund_Bild" VALUES(797,3365,11,20,'003365_0022_0058');
INSERT INTO "RT_Befund_Bild" VALUES(798,3365,11,20,'003365_0022_0059');
INSERT INTO "RT_Befund_Bild" VALUES(799,3365,11,20,'003365_0022_0060');
INSERT INTO "RT_Befund_Bild" VALUES(800,3365,11,20,'003365_0022_0061');
INSERT INTO "RT_Befund_Bild" VALUES(801,3365,12,11,'003365_0023_0001');
INSERT INTO "RT_Befund_Bild" VALUES(802,3365,12,11,'003365_0023_0002');
INSERT INTO "RT_Befund_Bild" VALUES(803,3365,12,11,'003365_0023_0003');
INSERT INTO "RT_Befund_Bild" VALUES(804,3365,12,11,'003365_0023_0004');
INSERT INTO "RT_Befund_Bild" VALUES(805,3365,12,11,'003365_0023_0005');
INSERT INTO "RT_Befund_Bild" VALUES(806,3365,12,11,'003365_0023_0006');
INSERT INTO "RT_Befund_Bild" VALUES(807,3365,12,11,'003365_0023_0007');
INSERT INTO "RT_Befund_Bild" VALUES(808,3365,12,11,'003365_0023_0008');
INSERT INTO "RT_Befund_Bild" VALUES(809,3365,12,11,'003365_0023_0009');
INSERT INTO "RT_Befund_Bild" VALUES(810,3365,12,11,'003365_0023_0010');
INSERT INTO "RT_Befund_Bild" VALUES(811,3365,12,11,'003365_0023_0011');
INSERT INTO "RT_Befund_Bild" VALUES(812,3365,12,11,'003365_0023_0012');
INSERT INTO "RT_Befund_Bild" VALUES(813,3365,12,11,'003365_0023_0013');
INSERT INTO "RT_Befund_Bild" VALUES(814,3365,12,11,'003365_0023_0014');
INSERT INTO "RT_Befund_Bild" VALUES(815,3365,12,11,'003365_0023_0015');
INSERT INTO "RT_Befund_Bild" VALUES(816,3365,12,11,'003365_0023_0016');
INSERT INTO "RT_Befund_Bild" VALUES(817,3365,12,11,'003365_0023_0017');
INSERT INTO "RT_Befund_Bild" VALUES(818,3365,12,11,'003365_0024_0002');
INSERT INTO "RT_Befund_Bild" VALUES(819,3365,12,11,'003365_0024_0003');
INSERT INTO "RT_Befund_Bild" VALUES(820,3365,12,11,'003365_0024_0004');
INSERT INTO "RT_Befund_Bild" VALUES(821,3365,12,11,'003365_0024_0005');
INSERT INTO "RT_Befund_Bild" VALUES(822,3365,12,10,'003365_0024_0007');
INSERT INTO "RT_Befund_Bild" VALUES(823,3365,12,10,'003365_0024_0008');
INSERT INTO "RT_Befund_Bild" VALUES(824,3365,12,10,'003365_0024_0009');
INSERT INTO "RT_Befund_Bild" VALUES(825,3365,12,10,'003365_0024_0010');
INSERT INTO "RT_Befund_Bild" VALUES(826,3365,12,1,'003365_0024_0011');
INSERT INTO "RT_Befund_Bild" VALUES(827,3365,12,10,'003365_0024_0012');
INSERT INTO "RT_Befund_Bild" VALUES(828,3365,12,10,'003365_0024_0013');
INSERT INTO "RT_Befund_Bild" VALUES(829,3365,11,28,'003365_0024_0020');
INSERT INTO "RT_Befund_Bild" VALUES(830,3365,11,28,'003365_0024_0022');
INSERT INTO "RT_Befund_Bild" VALUES(831,3365,11,27,'003365_0024_0023');
INSERT INTO "RT_Befund_Bild" VALUES(832,3365,11,27,'003365_0024_0025');
INSERT INTO "RT_Befund_Bild" VALUES(833,3365,12,27,'003365_0024_0026');
INSERT INTO "RT_Befund_Bild" VALUES(834,3365,11,27,'003365_0024_0028');
INSERT INTO "RT_Befund_Bild" VALUES(835,3365,11,25,'003365_0024_0029');
INSERT INTO "RT_Befund_Bild" VALUES(836,3365,11,25,'003365_0024_0031');
INSERT INTO "RT_Befund_Bild" VALUES(837,3365,11,22,'003365_0024_0053');
INSERT INTO "RT_Befund_Bild" VALUES(838,3365,11,22,'003365_0024_0054');
INSERT INTO "RT_Befund_Bild" VALUES(839,3365,11,22,'003365_0024_0057');
INSERT INTO "RT_Befund_Bild" VALUES(840,3365,11,22,'003365_0024_0058');
INSERT INTO "RT_Befund_Bild" VALUES(841,3365,11,20,'003365_0024_0060');
INSERT INTO "RT_Befund_Bild" VALUES(842,3365,11,20,'003365_0024_0061');
INSERT INTO "RT_Befund_Bild" VALUES(843,3365,11,19,'003365_0024_0062');
INSERT INTO "RT_Befund_Bild" VALUES(844,3365,11,19,'003365_0024_0064');
INSERT INTO "RT_Befund_Bild" VALUES(845,3365,11,19,'003365_0024_0065');
INSERT INTO "RT_Befund_Bild" VALUES(846,3365,11,19,'003365_0024_0066');
INSERT INTO "RT_Befund_Bild" VALUES(847,3365,11,19,'003365_0024_0067');
INSERT INTO "RT_Befund_Bild" VALUES(848,3365,11,18,'003365_0024_0068');
INSERT INTO "RT_Befund_Bild" VALUES(849,3365,11,18,'003365_0024_0069');
INSERT INTO "RT_Befund_Bild" VALUES(850,3365,11,18,'003365_0024_0070');
INSERT INTO "RT_Befund_Bild" VALUES(851,3365,11,18,'003365_0024_0071');
INSERT INTO "RT_Befund_Bild" VALUES(852,3365,11,23,'003365_0024_0072');
INSERT INTO "RT_Befund_Bild" VALUES(853,3365,11,23,'003365_0024_0073');
INSERT INTO "RT_Befund_Bild" VALUES(854,3365,11,23,'003365_0024_0074');
INSERT INTO "RT_Befund_Bild" VALUES(855,3365,11,23,'003365_0024_0075');
INSERT INTO "RT_Befund_Bild" VALUES(856,3365,11,23,'003365_0024_0076');
INSERT INTO "RT_Befund_Bild" VALUES(857,3365,12,11,'003365_0025_0002');
INSERT INTO "RT_Befund_Bild" VALUES(858,3365,12,11,'003365_0025_0004');
INSERT INTO "RT_Befund_Bild" VALUES(859,3365,12,4,'003365_0025_0005');
INSERT INTO "RT_Befund_Bild" VALUES(860,3365,12,4,'003365_0025_0006');
INSERT INTO "RT_Befund_Bild" VALUES(861,3365,12,4,'003365_0025_0007');
INSERT INTO "RT_Befund_Bild" VALUES(862,3365,12,0,'003365_0025_0008');
INSERT INTO "RT_Befund_Bild" VALUES(863,3365,12,4,'003365_0025_0010');
INSERT INTO "RT_Befund_Bild" VALUES(864,3365,12,4,'003365_0025_0011');
INSERT INTO "RT_Befund_Bild" VALUES(865,3365,12,4,'003365_0025_0012');
INSERT INTO "RT_Befund_Bild" VALUES(866,3365,12,4,'003365_0025_0013');
INSERT INTO "RT_Befund_Bild" VALUES(867,3365,11,30,'003365_0025_0014');
INSERT INTO "RT_Befund_Bild" VALUES(868,3365,11,30,'003365_0025_0015');
INSERT INTO "RT_Befund_Bild" VALUES(869,3365,11,30,'003365_0025_0016');
INSERT INTO "RT_Befund_Bild" VALUES(870,3365,11,30,'003365_0025_0017');
INSERT INTO "RT_Befund_Bild" VALUES(871,3365,11,30,'003365_0025_0018');
INSERT INTO "RT_Befund_Bild" VALUES(872,3365,11,30,'003365_0025_0019');
INSERT INTO "RT_Befund_Bild" VALUES(873,3365,11,30,'003365_0025_0020');
INSERT INTO "RT_Befund_Bild" VALUES(874,3365,11,30,'003365_0025_0021');
INSERT INTO "RT_Befund_Bild" VALUES(875,3365,11,30,'003365_0025_0022');
INSERT INTO "RT_Befund_Bild" VALUES(876,3365,11,29,'003365_0025_0023');
INSERT INTO "RT_Befund_Bild" VALUES(877,3365,11,29,'003365_0025_0024');
INSERT INTO "RT_Befund_Bild" VALUES(878,3365,11,29,'003365_0025_0027');
INSERT INTO "RT_Befund_Bild" VALUES(879,3365,11,32,'003365_0025_0028');
INSERT INTO "RT_Befund_Bild" VALUES(880,3365,11,32,'003365_0025_0029');
INSERT INTO "RT_Befund_Bild" VALUES(881,3365,11,32,'003365_0025_0030');
INSERT INTO "RT_Befund_Bild" VALUES(882,3365,11,32,'003365_0025_0033');
INSERT INTO "RT_Befund_Bild" VALUES(883,3365,11,13,'003365_0025_0034');
INSERT INTO "RT_Befund_Bild" VALUES(884,3365,11,13,'003365_0025_0035');
INSERT INTO "RT_Befund_Bild" VALUES(885,3365,10,14,'003365_0026_0001');
INSERT INTO "RT_Befund_Bild" VALUES(886,3365,10,14,'003365_0026_0002');
INSERT INTO "RT_Befund_Bild" VALUES(887,3365,10,15,'003365_0026_0004');
INSERT INTO "RT_Befund_Bild" VALUES(888,3365,10,15,'003365_0026_0005');
INSERT INTO "RT_Befund_Bild" VALUES(889,3365,10,15,'003365_0026_0006');
INSERT INTO "RT_Befund_Bild" VALUES(890,3365,10,15,'003365_0026_0007');
INSERT INTO "RT_Befund_Bild" VALUES(891,3365,10,15,'003365_0026_0009');
INSERT INTO "RT_Befund_Bild" VALUES(892,3365,10,15,'003365_0026_0010');
INSERT INTO "RT_Befund_Bild" VALUES(893,3365,10,16,'003365_0026_0012');
INSERT INTO "RT_Befund_Bild" VALUES(894,3365,10,16,'003365_0026_0015');
INSERT INTO "RT_Befund_Bild" VALUES(895,3365,10,16,'003365_0026_0022');
INSERT INTO "RT_Befund_Bild" VALUES(896,3365,10,16,'003365_0026_0025');
INSERT INTO "RT_Befund_Bild" VALUES(897,3365,10,16,'003365_0026_0026');
INSERT INTO "RT_Befund_Bild" VALUES(898,3365,10,16,'003365_0026_0030');
INSERT INTO "RT_Befund_Bild" VALUES(899,3365,10,28,'003365_0026_0031');
INSERT INTO "RT_Befund_Bild" VALUES(900,3365,15,14,'003365_0026_0038');
INSERT INTO "RT_Befund_Bild" VALUES(901,3365,15,14,'003365_0026_0041');
INSERT INTO "RT_Befund_Bild" VALUES(902,3365,15,14,'003365_0026_0043');
INSERT INTO "RT_Befund_Bild" VALUES(903,3365,15,35,'003365_0026_0044');
INSERT INTO "RT_Befund_Bild" VALUES(904,3365,15,35,'003365_0026_0045');
INSERT INTO "RT_Befund_Bild" VALUES(905,3365,15,35,'003365_0026_0046');
INSERT INTO "RT_Befund_Bild" VALUES(906,3365,15,35,'003365_0026_0049');
INSERT INTO "RT_Befund_Bild" VALUES(907,3365,15,22,'003365_0026_0051');
INSERT INTO "RT_Befund_Bild" VALUES(908,3365,15,22,'003365_0026_0053');
INSERT INTO "RT_Befund_Bild" VALUES(909,3365,10,24,'003365_0027_0001');
INSERT INTO "RT_Befund_Bild" VALUES(910,3365,10,24,'003365_0027_0002');
INSERT INTO "RT_Befund_Bild" VALUES(911,3365,10,24,'003365_0027_0003');
INSERT INTO "RT_Befund_Bild" VALUES(912,3365,10,24,'003365_0027_0004');
INSERT INTO "RT_Befund_Bild" VALUES(913,3365,10,24,'003365_0028_0001');
INSERT INTO "RT_Befund_Bild" VALUES(914,3365,10,24,'003365_0028_0002');
INSERT INTO "RT_Befund_Bild" VALUES(915,3365,10,24,'003365_0028_0003');
INSERT INTO "RT_Befund_Bild" VALUES(916,3365,10,24,'003365_0028_0004');
INSERT INTO "RT_Befund_Bild" VALUES(917,3365,10,24,'003365_0028_0005');
INSERT INTO "RT_Befund_Bild" VALUES(918,3365,10,24,'003365_0028_0006');
INSERT INTO "RT_Befund_Bild" VALUES(919,3365,10,24,'003365_0028_0007');
INSERT INTO "RT_Befund_Bild" VALUES(920,3365,10,24,'003365_0028_0008');
INSERT INTO "RT_Befund_Bild" VALUES(921,3365,10,24,'003365_0028_0009');
INSERT INTO "RT_Befund_Bild" VALUES(922,3365,10,15,'003365_0029_0001');
INSERT INTO "RT_Befund_Bild" VALUES(923,3365,10,15,'003365_0029_0002');
INSERT INTO "RT_Befund_Bild" VALUES(924,3365,10,15,'003365_0029_0003');
INSERT INTO "RT_Befund_Bild" VALUES(925,3365,10,15,'003365_0029_0004');
INSERT INTO "RT_Befund_Bild" VALUES(926,3365,10,15,'003365_0029_0005');
INSERT INTO "RT_Befund_Bild" VALUES(927,3365,10,15,'003365_0029_0006');
INSERT INTO "RT_Befund_Bild" VALUES(928,3365,10,27,'003365_0030_0001');
INSERT INTO "RT_Befund_Bild" VALUES(929,3365,10,27,'003365_0030_0002');
INSERT INTO "RT_Befund_Bild" VALUES(930,3365,10,27,'003365_0030_0003');
INSERT INTO "RT_Befund_Bild" VALUES(931,3365,10,27,'003365_0030_0004');
INSERT INTO "RT_Befund_Bild" VALUES(932,3365,10,27,'003365_0030_0005');
INSERT INTO "RT_Befund_Bild" VALUES(933,3365,10,27,'003365_0030_0006');
INSERT INTO "RT_Befund_Bild" VALUES(934,3365,10,27,'003365_0030_0007');
INSERT INTO "RT_Befund_Bild" VALUES(935,3365,10,27,'003365_0030_0008');
INSERT INTO "RT_Befund_Bild" VALUES(936,3365,10,27,'003365_0030_0009');
INSERT INTO "RT_Befund_Bild" VALUES(937,3365,10,27,'003365_0030_0010');
INSERT INTO "RT_Befund_Bild" VALUES(938,3365,10,27,'003365_0030_0011');
INSERT INTO "RT_Befund_Bild" VALUES(939,3365,10,27,'003365_0030_0012');
INSERT INTO "RT_Befund_Bild" VALUES(940,3365,10,27,'003365_0030_0013');
INSERT INTO "RT_Befund_Bild" VALUES(941,3365,10,27,'003365_0030_0014');
INSERT INTO "RT_Befund_Bild" VALUES(942,3365,10,27,'003365_0030_0015');
INSERT INTO "RT_Befund_Bild" VALUES(943,3365,10,27,'003365_0030_0016');
INSERT INTO "RT_Befund_Bild" VALUES(944,3365,10,27,'003365_0030_0017');
INSERT INTO "RT_Befund_Bild" VALUES(945,3365,10,27,'003365_0030_0018');
INSERT INTO "RT_Befund_Bild" VALUES(946,3365,10,27,'003365_0030_0019');
INSERT INTO "RT_Befund_Bild" VALUES(947,3365,10,27,'003365_0030_0020');

/* Comment 
------------------------
Table for thedata for each megalith. Main table. 
"MegaID": ID for each megalith 
"LDANr": Indentifyer based on abbrev. of the local subdivision and consecutive counting
"Region":  region
"Kreis_neu": district
"Gemarkung": local subdivision, new official name 
"Gemeinde":  county
"OAGem":  abreviation of the local subdivision in the official archive (Ortsakten)
"OANr" consecutive numbering in the local subdivision (Ortsakten) 
"lokalisierung":  quality of localisation
"Erhaltung": preservation (0-6), foreign key on wt_erhaltung 
"Topografie": description of the topografy
"Lage":  description of the localisation
"Bemerkungen":  remark
"GradNord":  orientation of the monument in degrees from North
"Umfassung": description of the surrounding construction 
"Grabtyp":  type of megalith
"FundartID": id of the monument type (part of the GDB LSA (Grabungsdatenbank Land Sachsen-Anhalt)).
*/
DROP TABLE IF EXISTS "T_MegalitheDaten";
CREATE TABLE "T_MegalitheDaten" (
"MegaID" integer PRIMARY KEY AUTOINCREMENT, 
"LDANr" text,
"Region" text, 
"Kreis_neu" text, 
"Gemarkung" text, 
"Gemeinde" text, 
"OAGem" text, 
"OANr" integer, 
"lokalisierung" text, 
"Erhaltung" integer, 
"Topografie" text, 
"Lage" text, 
"Bemerkungen" text, 
"GradNord" integer, 
"Umfassung" text, 
"Grabtyp" TEXT, 
"FundartID" INTEGER,
FOREIGN KEY (FundartID) REFERENCES WT_Fundart(FundartID)
);
INSERT INTO "T_MegalitheDaten" VALUES(242,'Alv003','Haldensleben','BK','Bebertal I','Bebertal','Alv',3,'sicher',2,'leicht exponiert','Küchentannen; Gräberweg',NULL,90,'rechteckig','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(243,'Alv004','Haldensleben','BK','Bebertal I','Bebertal','Alv',4,'sicher',2,'leicht exponiert','Küchentannen; Gräberweg',NULL,67,'trapezförmig','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(244,'Alv005','Haldensleben','BK','Bebertal I','Bebertal','Alv',5,'sicher',1,'sehr exponiert','Küchentannen; Gräberweg drüber mit Eiche darin',NULL,67,'rechteckig','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(246,'Alv006','Haldensleben','BK','Bebertal I','Bebertal','Alv',6,'sicher',1,'sehr exponiert','Küchentannen; Kuppenlage im Wald',NULL,45,'rechteckig','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(247,'Alv010','Haldensleben','BK','Bebertal I','Bebertal','Alv',10,'sicher',5,'leichte Hanglage','Küchentannen',NULL,90,NULL,'Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(248,'Alv011','Haldensleben','BK','Bebertal I','Bebertal','Alv',11,'sicher',5,'leichte Hanglage',NULL,'Grab?',0,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(249,'Alv012','Haldensleben','BK','Bebertal I','Bebertal','Alv',12,'sicher',5,'exponiert','Gräberweg','Hügel, wenige Steine, Spuren alter Raubgrabung',-1,'ohne Umfassung','Grabhügel',421000);
INSERT INTO "T_MegalitheDaten" VALUES(250,'Alv013','Haldensleben','BK','Bebertal I','Bebertal','Alv',13,'sicher',5,'nicht exponiert','westl. Gräberweg','Teil zerstört, Profil am Weg',0,'ohne Umfassung','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(251,'Alv014','Haldensleben','BK','Bebertal I','Bebertal','Alv',14,'sicher',-1,'leichte Anhöhe','Küchentannen','Gegraben, umgesetzt und rekonstruiert Preuß, BZ Sicheldepots',90,'trapezförmig','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(252,'Alv015','Haldensleben','BK','Bebertal I','Bebertal','Alv',15,'sicher',5,'natürliche kleine Anhöhe','nordöstlich Forsthaus Eiche',NULL,45,'vorhanden','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(253,'Alv016','Haldensleben','BK','Bebertal I','Bebertal','Alv',16,'sicher',3,'leichte Hanglage','90 m südlich Alv 14 in dichtem Unterholz',' ',135,'vorhanden','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(254,'Alv017','Haldensleben','BK','Bebertal I','Bebertal','Alv',17,'sicher',3,'Niederung','Saurer Grund','gut erhalten, Niederung, Rillenstein',45,'vorhanden','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(255,'Alv018','Haldensleben','BK','Bebertal I','Bebertal','Alv',18,'sicher',4,'Nordwesthang',NULL,NULL,0,'vorhanden','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(256,'Alv021','Haldensleben','BK','Bebertal I','Bebertal','Alv',21,'sicher',3,'Spornlage','deutlicher Sporn nach Süden',NULL,0,NULL,'Dolmen',422000);
INSERT INTO "T_MegalitheDaten" VALUES(257,'Alv020','Haldensleben','BK','Bebertal I','Bebertal','Alv',20,'sicher',3,'leichte Hanglage','Hünenberge','Kammer mäßig erhalten, Bett und Hügel kaum',67,'vorhanden','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(258,'Alv019','Haldensleben','BK','Bebertal I','Bebertal','Alv',19,'sicher',5,'exponiert',NULL,NULL,45,'ohne Umfassung','Dolmen',422000);
INSERT INTO "T_MegalitheDaten" VALUES(259,'Alv022','Haldensleben','BK','Bebertal I','Bebertal','Alv',22,'sicher',2,'exponiert',NULL,'recht große Anlage, keine Umfassung erkennbar',0,'ohne Umfassung','Dolmen',422000);
INSERT INTO "T_MegalitheDaten" VALUES(260,'Alv023','Haldensleben','BK','Bebertal I','Bebertal','Alv',23,'sicher',4,'leichte Anhöhe','deutliche Kuppe einer leichten Anhöhe','Kammer erhalten',292,'vorhanden','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(261,'Alv024','Haldensleben','BK','Bebertal I','Bebertal','Alv',24,'unsicher',6,NULL,'Steinbruch','24 Blöcke auf 27 Schritt länge und 10 Schritte Breite, O-W (Blasius)',90,'vorhanden','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(262,'Alv025','Haldensleben','BK','Bebertal I','Bebertal','Alv',25,'sicher',3,'leicht exponiert','50 m östlich des Waldwegs',NULL,45,'k. A.','Dolmen',422000);
INSERT INTO "T_MegalitheDaten" VALUES(263,'Alv026','Haldensleben','BK','Bebertal I','Bebertal','Alv',26,'sicher',5,'leichte Hanglage','untere, nach Westen exponierte Hangbereich','Ein Kammerstein in situ mit (H: 0,6), Verkeil- u. Pflastersteine',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(264,'Alv027','Haldensleben','BK','Bebertal I','Bebertal','Alv',27,'sicher',4,'leichte Hanglage','Seekante; Lage zur Niederung','Kammerrest, Lage zur Niederung',315,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(265,'Alv028','Haldensleben','BK','Bebertal I','Bebertal','Alv',28,'sicher',3,'sanfte Hanglage','nach Süden exponierte untere Hangabschnitt zur Niederung','Kammerrest',-1,'k. A.','erweiterter Dolmen',422000);
INSERT INTO "T_MegalitheDaten" VALUES(266,'Alv029','Haldensleben','BK','Bebertal I','Bebertal','Alv',29,'sicher',4,'ebenes Gelände','Kl. Steinbreite / am Bierweg','2 Kamersteine in situ, Rest nach außen verlagert, Deckstein fehlt',-1,'k. A.','Dolmen',422000);
INSERT INTO "T_MegalitheDaten" VALUES(267,'Alv030','Haldensleben','BK','Bebertal I','Bebertal','Alv',30,'sicher',4,'leicht exponiert','Seekante öst. v. Bierweg','Kammerrest',-1,'k. A.','Dolmen',422000);
INSERT INTO "T_MegalitheDaten" VALUES(268,'Alv031','Haldensleben','BK','Bebertal I','Bebertal','Alv',31,'sicher',3,'nicht exponiert','öst. Kl. Steinbreite - Zollstange','Wildschweinstörungen',45,'vorhanden','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(269,'Alv032','Haldensleben','BK','Bebertal I','Bebertal','Alv',32,'sicher',5,'exponiert','westl. der stillgelegten Bahnlinie / Dornengebüsch im Feld / große Steinbreite','nahezu vollständig zerstört',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(270,'Alv033','Haldensleben','BK','Bebertal I','Bebertal','Alv',33,'sicher',1,'natürliche Anhöhe','Kaisergrab','nach Ausgrabung rekonstruiert',90,'trapezförmig','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(271,'Alv034','Haldensleben','BK','Bebertal I','Bebertal','Alv',34,'sicher',5,'leichte Hanglage','Küchentannen / Bahnlinie/ Raubgrabung','stark gestört',67,'vorhanden','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(272,'Alv035','Haldensleben','BK','Bebertal I','Bebertal','Alv',35,'sicher',3,'Hügelkuppe','Nordöstliche Geländesporn Wolfswinkel','fast alle Steine verkippt oder verlagert, Struktur aber erkennbar',22,NULL,'Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(273,'Alv036','Haldensleben','BK','Bebertal I','Bebertal','Alv',36,'sicher',5,'Niederung','Forsthaus Eiche','4x4 m messende viereckige Fundamentierung',-1,'k. A.',NULL,110800);
INSERT INTO "T_MegalitheDaten" VALUES(274,'Alv037','Haldensleben','BK','Bebertal I','Bebertal','Alv',37,'sicher',5,'Niederung','Forsthaus Eiche','Niederungsburg, vgl. Alv. Fpl. 2,  Steine in Reihe, Grab fraglich',-1,'k. A.',NULL,110800);
INSERT INTO "T_MegalitheDaten" VALUES(275,'Alv038','Haldensleben','BK','Bebertal I','Bebertal','Alv',38,'unsicher',6,NULL,NULL,'3 Steine nach Stuhlmann, am Rand der Halde nicht auffindbar',-1,'k. A.','sonstige Steine',500000);
INSERT INTO "T_MegalitheDaten" VALUES(276,'Alv039','Haldensleben','BK','Bebertal I','Bebertal','Alv',39,'sicher',5,NULL,NULL,'vermutlich stark gestört oder nicht fertiggestellt',90,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(277,'Alv040','Haldensleben','BK','Bebertal I','Bebertal','Alv',40,'sicher',3,NULL,'Steinbruch','keine Funde, deshalb ev.unvollendet. Steinpackung Hinweis auf Grabbau?',270,'ja','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(281,'Süp005','Haldensleben','BK','Süplingen','Süplingen','Süp',5,'unsicher',6,NULL,NULL,NULL,-1,'k. A.',NULL,500000);
INSERT INTO "T_MegalitheDaten" VALUES(284,'Alv041','Haldensleben','BK','Bebertal I','Bebertal','Alv',41,'sicher',5,'ebenes Gelände','Forsthaus Hüsig','Raubgrabung',22,'k. A.','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(285,'Alv042','Haldensleben','BK','Bebertal I','Bebertal','Alv',42,'sicher',5,'natürliche kleine Anhöhe','Steinbruch','Aufnahme nach Preuß 1973',292,'k. A.','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(286,'Alv043','Haldensleben','BK','Bebertal I','Bebertal','Alv',43,'sicher',6,NULL,'Steinbruch','zerstört, keine weitere Angabe in den OA des LDA',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(287,'Alv044','Haldensleben','BK','Bebertal I','Bebertal','Alv',44,'sicher',5,'ebenes Gelände','Forsthaus Hüsig',' ',315,'k. A.','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(288,'Alv045','Haldensleben','BK','Bebertal I','Bebertal','Alv',45,'sicher',3,'ebenes Gelände','Forsthaus Hüsig',' ',-1,'k. A.','Dolmen',422000);
INSERT INTO "T_MegalitheDaten" VALUES(289,'Alv046','Haldensleben','BK','Bebertal I','Bebertal','Alv',46,'unsicher',5,'nicht gefunden',NULL,'Bei Stuhlmann 3 Steine, nicht gefunden',90,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(290,'Alv047','Haldensleben','BK','Bebertal I','Bebertal','Alv',47,'unsicher',6,NULL,NULL,'OA: Großsteingrab, zerstört, keine weiteren Angaben',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(291,'Alv048','Haldensleben','BK','Bebertal I','Bebertal','Alv',48,'unsicher',6,NULL,'Steinbruch','OA: Großsteingrab, zerstört 1955, keine weiteren Angaben',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(292,'Dön004','Haldensleben','BK','Bebertal II','Bebertal','Dön',4,'sicher',1,'exponiert','Anhöhe Klönsberg östl. des Steinbruch','Königsgrab, evtl. auch Saal 95 und 134',292,'trapezförmig','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(293,'Dön005','Haldensleben','BK','Bebertal II','Bebertal','Dön',5,'unsicher',2,'exponiert','Kuckucksberg','ausgegraben und zerstört',90,'rechteckig','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(294,'Dön007','Haldensleben','BK','Bebertal II','Bebertal','Dön',7,'sicher',6,'exponiert','Steinbruch, Anhöhe Klönsberg','einzelner Deckstein?, angeblich zu Alv. 48 168m NW',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(295,'Dön008','Haldensleben','BK','Bebertal II','Bebertal','Dön',8,'sicher',2,'Hügelkuppe','Steinbruch','ausgegraben',90,'keine','Dolmen',422000);
INSERT INTO "T_MegalitheDaten" VALUES(296,'Dön009','Haldensleben','BK','Bebertal II','Bebertal','Dön',9,'sicher',6,'exponiert','Steinbruch','Ausgrabung 1958/59',90,'vorhanden','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(297,'Dön010','Haldensleben','BK','Bebertal II','Bebertal','Dön',10,'sicher',4,'nicht exponiert','westl. der Bahnlinie','MAT Aufmaß CAD; Grab nicht fertiggestellt?',90,'ohne Umfassung','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(298,'Dön011','Haldensleben','BK','Bebertal II','Bebertal','Dön',11,'sicher',5,'leicht exponiert','Kuckucksberg / Bierweg','Raubgrabung, durch OU gefährdet',45,'ja','Dolmen',422000);
INSERT INTO "T_MegalitheDaten" VALUES(299,'Dön012','Haldensleben','BK','Bebertal II','Bebertal','Dön',12,'unsicher',6,'exponiert','nördliche Teil Kuckucksberg','Bei Schlette (1962, 138) erwähnt',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(300,'Dön013','Haldensleben','BK','Bebertal II','Bebertal','Dön',13,'wahrscheinlich',4,'leichte Anhöhe','Kuckucksberg','nach Vermessung (1959) und Plänen von Grimm (OA LDA)',247,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(301,'Dön014','Haldensleben','BK','Bebertal II','Bebertal','Dön',14,'unsicher',5,NULL,'Gr. Steinbreite am Waldrande','bei Blasius (1902, 130) bereits als zerstört beschrieben',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(302,'Dön015','Haldensleben','BK','Bebertal II','Bebertal','Dön',15,'unsicher',6,NULL,'Acker Blockshornberg',NULL,-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(303,'Bod001','Haldensleben','BK','Bodendorf','Süplingen','Bod',1,'unsicher',5,NULL,'Fuchsberg, nordlich des Landweges Bodendorf zum Waldbahnhof Emden','größere Steine noch sichtbar, It. Bock, Emden',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(307,'NHa009','Haldensleben','BK','Haldensleben I (Neu)','Haldensleben, Stadt','NHa',9,'sicher',5,'leicht exponiert','Papenberg / alte Bahnlinie / St. Telegraphenstange Nr. 11',NULL,-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(308,'NHa010','Haldensleben','BK','Haldensleben I (Neu)','Haldensleben, Stadt','NHa',10,'sicher',6,NULL,NULL,' sehr fraglich ob Grab',-1,'k. A.',NULL,500000);
INSERT INTO "T_MegalitheDaten" VALUES(309,'NHa011','Haldensleben','BK','Haldensleben I (Neu)','Haldensleben, Stadt','NHa',11,'sicher',6,NULL,NULL,' ',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(310,'NHa012','Haldensleben','BK','Haldensleben I (Neu)','Haldensleben, Stadt','NHa',12,'unsicher',6,NULL,' ','zerstört (OA)',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(311,'AHa008','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',8,'unsicher',6,NULL,'Sandgrube','1950 unverz. Trichterb. aus Sandgrube, keine Steine',-1,'k. A.','Flachgrab?',510100);
INSERT INTO "T_MegalitheDaten" VALUES(312,'AHa009','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',9,'sicher',3,'leichte Anhöhe','Str. Bebertal- Waldweg an Tankstelle',NULL,90,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(313,'AHa010','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',10,'sicher',-1,'nicht exponiert','Teufelsküche','Grab ist rekonstruiert, benachbart Fund eines Felsgesteinbeils (1950)',90,'k. A.','erweiterter Dolmen',422000);
INSERT INTO "T_MegalitheDaten" VALUES(314,'AHa011','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',11,'sicher',5,'ebenes Gelände','zwischen Grab Steineiche und Schrebergarten','2 Tragstein in situ (?) erlaubt Aussage zur Orientierung und Breite',337,'zerstört, wahrscheinlich','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(315,'AHa012','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',12,'sicher',4,NULL,'Nach den Plänen und Skizzen der Vorgänger Teil von Megalithgrab Steineiche AHa 13',NULL,-1,'k. A.',NULL,NULL);
INSERT INTO "T_MegalitheDaten" VALUES(316,'AHa013','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',13,'sicher',2,'nicht exponiert','flache Erhebung','"Steineiche", dazu gehört AHa12',45,'vorhanden','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(317,'AHa014','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',14,'sicher',4,'natürliche kleine Anhöhe','Alt Emdener Weg','schlecht erhalten',45,'vorhanden','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(318,'AHa015','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',15,'sicher',2,'natürliche kleine Anhöhe','Alt Emdener Weg / auf einem Hügel','große Steinstreuung im Westen unklar',90,'vorhanden','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(319,'AHa016','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',16,'sicher',3,'ebenes Gelände, sanft wellig','nördlich Alt Emdener Weg in der Kurve','Störungen',45,'vorhanden','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(320,'AHa017','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',17,'sicher',4,'ebenes Gelände, sanft wellig','Alt Emdener Weg','1 Stein mit Sprengloch, Zerstörungen',45,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(321,'AHa018','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',18,'sicher',2,'ebenes Gelände','östl. Gräberweg','Keine Umfassung',45,'keine','Großdolmen',422000);
INSERT INTO "T_MegalitheDaten" VALUES(322,'AHa019','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',19,'sicher',4,'nicht exponiert','östl. Gräberweg','massiv gestörte Anlage, Kammer gesprengt',90,'rechteckig','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(323,'AHa020','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',20,'sicher',3,'ebenes Gelände','östl. Gräberweg','Hügel mit Steineinfassung, ggf. durch Aushub überprägt',112,'Steineinfassung möglich','Großdolmen',422000);
INSERT INTO "T_MegalitheDaten" VALUES(324,'AHa021','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',21,'sicher',4,'ebenes Gelände, sanft wellig','östl. Gräberweg','sehr große, aber stark beschädigte Anlage',45,'vorhanden','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(325,'AHa022','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',22,'sicher',2,'leicht exponiert','westl. Gräberweg','gut erhalten',90,'ohne Umfassung','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(326,'AHa023','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',23,'sicher',2,'leicht exponiert','westl. Gräberweg',NULL,45,'vorhanden','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(327,'AHa024','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',24,'sicher',2,'leichte Hanglage nach NW exponiert',' östl. Gräberweg',NULL,45,'rechteckig','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(328,'AHa025','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',25,'sicher',2,'nicht exponiert','östl. Gräberweg',NULL,67,'vorhanden','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(329,'AHa026','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',26,'sicher',5,'leichte Hanglage','östl. Gräberweg',NULL,0,'vorhanden','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(330,'AHa027','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',27,'sicher',2,'leicht exponiert','westl. Gräberweg','Kleine Tragsteine, Kammer im Osten, 2 Bauphasen?',247,'leicht trapezförmig','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(331,'AHa028','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',28,'sicher',5,'ebenes Gelände, sanft wellig','gegenüber Teufelsküche','nordöstliche Abschluss durch Baumwurf (Windbruch) gestört, keine Funde',45,'vorhanden','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(332,'AHa029','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',29,'wahrscheinlich',6,'ebenes Gelände, sanft wellig',NULL,'alt zerstört, Wegener 1896/97, keine Unterlagen in den Ortsakten',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(333,'Hun006','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',6,'unsicher',6,'ebenes Gelände','heute Feldflur','vor 1897 untersucht von Wegener, heute zerstört',315,'vorhanden','Dolmen',422000);
INSERT INTO "T_MegalitheDaten" VALUES(335,'Hun014','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',14,'sicher',2,'leicht exponiert','Küsterberg','Ausgrabung 2010, 2012, 2013',90,'vorhanden','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(336,'Hun015','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',15,'sicher',3,'leichte Anhöhe','Beberberg östl. des Ortseingangs','Grabhügel neuzeitl. mit Findlingen umgebaut',-1,'k. A.',NULL,421000);
INSERT INTO "T_MegalitheDaten" VALUES(337,'Hun016','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',16,'sicher',4,'exponiert','östl. Gräberweg','Raubgrabungen; Kammer ohne Umfassung',22,'Umfassung fraglich','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(338,'Hun017','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',17,'sicher',3,'nicht exponiert','östl. Gräberweg','Raubgrabungen, Kammer nach Hügel etwa zur Hälfte erhalten',45,'ohne Umfassung','Dolmen',422000);
INSERT INTO "T_MegalitheDaten" VALUES(339,'Hun018','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',18,'sicher',5,'ebenes Gelände, sanft wellig','östlich des Gräberweges, langgestreckter flacher Sporninmitten des Forsts','kyrillische Ritzung',0,'ohne Umfassung','Dolmen',422000);
INSERT INTO "T_MegalitheDaten" VALUES(340,'Hun019','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',19,'sicher',5,'sehr exponiert','westl. Gräberweg','Raubgrabungen; Kammer zerstört',67,'vorhanden','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(341,'Hun020','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',20,'unsicher',6,NULL,NULL,'"Reststeine am Wegerand" (Rahmlow 1960, 32)',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(342,'Hun021','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',21,'sicher',6,'leichte Hanglage','Alt Emdener Weg Kreuzung Hundisburg','zerstört, von Blasius noch mit 23 Blöcken beschrieben',225,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(344,'Süp002','Haldensleben','BK','Süplingen','Süplingen','Süp',2,'sicher',5,NULL,'unmittelbar nördlich der L42',NULL,45,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(345,'Süp003','Haldensleben','BK','Süplingen','Süplingen','Süp',3,'unsicher',6,'exponiert','Sandberg','zerstört nach 1918; evtl. 2 Kammern',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(346,'Süp004','Haldensleben','BK','Süplingen','Süplingen','Süp',4,'sicher',5,'exponiert','Sandberg, Streuobstgebüsch am Feldweg','Zerstört nach 1918, zwei Findlinge und Lesesteine unter einer Eiche',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(347,'Süp006','Haldensleben','BK','Süplingen','Süplingen','Süp',6,'sicher',5,'Spornlage, nach NW exponiert','am Rand eines Wendehammers neben der Schrebergartenkolonie','Teils mit Gartenabfall und Müll verdeckt, sehr schlecht erhalten',22,'ohne Umfassung','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(418,'AHa033','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',33,'sicher',5,'ebenes Gelände','Hünerheide','sehr schlecht erhalten, Steine auf bis zu 16 m Länge',90,'vorhanden','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(419,'AHa031','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',31,'sicher',5,'ebenes Gelände','Gebüsch am Feldrand im Wegezwickel, teils vermüllt und kaum zu sehen','zerstört, 2 Steine in situ als Rest, dazu viele Lesesteine?',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(420,'AHa034','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',34,'sicher',5,'leichte Spornlage','Hünerheide','zerstört, 2 Steine als Rest, dazu Standspuren, mind. 2 Joche',90,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(421,'AHa032','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',32,'unsicher',5,'leichte Anhöhe','Hünerheide','Hügel auf Kuppe, getrichtert, 2 Findlinge "in situ", mehrere Trümmer',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(422,'Emd012','Haldensleben','BK','Emden','Emden','Emd',12,'sicher',2,NULL,'Holzschäferei',NULL,90,'vorhanden','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(423,'Hun022','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',22,'sicher',5,'leicht exponiert','Alt Emdener Weg','Hügel mit Steinkammer, keine Umfasung',90,'vorhanden','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(424,'AHa042','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',42,'sicher',0,NULL,NULL,'Burg Wichmannsdorf, Teil der Mauerfundamente',-1,'k. A.',NULL,110800);
INSERT INTO "T_MegalitheDaten" VALUES(426,'Süp001','Haldensleben','BK','Süplingen','Süplingen','Süp',1,'sicher',3,'exponiert','Auf der Kuppe des Sachsenberges nördlich der L42','Ausgrabung durch Wegener 1896 mit Funden (Blasius 1901, 105)',45,'vorhanden','Ganggrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(427,'AHa002','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',2,'unsicher',6,NULL,NULL,'Deutung als Megalithgrab fraglich.',-1,'k. A.',NULL,500000);
INSERT INTO "T_MegalitheDaten" VALUES(428,'AHa001','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',1,'sicher',-1,'ebenes Gelände, sanft wellig',NULL,'Teil der Templerburg Burg Wichmannsdorf',-1,'ohne Umfassung',NULL,130250);
INSERT INTO "T_MegalitheDaten" VALUES(430,'Dön016','Haldensleben','BK','Bebertal II','Bebertal','Dön',16,'unsicher',6,'ebenes Gelände, sanft wellig','Pieperberg, 3 Graber im Wegedreieck Chaussee Haldensleben - Dönstedt und Hundisburg - Dönstedt, It. LM Halle',NULL,-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(431,'Dön017','Haldensleben','BK','Bebertal II','Bebertal','Dön',17,'unsicher',6,'ebenes Gelände, sanft wellig','Pieperberg, 3 Graber im Wegedreieck Chaussee Haldensleben - Dönstedt und Hundisburg - Dönstedt, It. LM Halle',NULL,-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(432,'Dön018','Haldensleben','BK','Bebertal II','Bebertal','Dön',18,'unsicher',6,'ebenes Gelände, sanft wellig','Pieperberg, 3 Graber im Wegedreieck Chaussee Haldensleben - Dönstedt und Hundisburg - Dönstedt, It. LM Halle',NULL,-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(433,'Dön019','Haldensleben','BK','Bebertal II','Bebertal','Dön',19,'unsicher',5,NULL,'Kuckucksberg','nach Lageskizze und Skizze OA LDA LSA M-6-10-1#38 bis 39',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(434,'Dön020','Haldensleben','BK','Bebertal II','Bebertal','Dön',20,'unsicher',6,NULL,'Kuckucksberg',NULL,-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(435,'Dön021','Haldensleben','BK','Bebertal II','Bebertal','Dön',21,'unsicher',6,'leichte Anhöhe',NULL,'nach Rahmlow 1957zerstört, Skizzen in den OA',67,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(436,'Hun025','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',25,'unsicher',6,NULL,'Forsthaus Hundisburg; Feldweg','zerstört; Reststeine als Einfassung Feldweg',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(437,'Hun024','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',24,'unsicher',6,'ebenes Gelände','heute Einfassung des Feldweges Forsthaus Hundisburg-Gasthaus Ziegelei',NULL,-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(438,'Emd015','Haldensleben','BK','Emden','Emden','Emd',15,'sicher',0,NULL,'Holzschäferei',' ',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(439,'Emd016','Haldensleben','BK','Emden','Emden','Emd',16,'unsicher',0,NULL,'Haltepunkt Emden',' ',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(440,'Emd017','Haldensleben','BK','Emden','Emden','Emd',17,'unsicher',0,NULL,'Weg nach Kuhlager nördl. Rummelsberg',' ',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(441,'AHa030','Haldensleben','BK','Haldensleben II (Alt)','Haldensleben, Stadt','AHa',30,'wahrscheinlich',6,'ebenes Gelände','Steinbettbreite,','zerstört, Mühlenweg zwischen Mittellandkanal und Eisenbahn',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(445,'Hun028','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',28,'unsicher',6,NULL,'Ostseite des Pieperberges, westlich Ruine Nordhusen, It. LM Halle',NULL,-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(446,'Hun029','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',29,'unsicher',6,NULL,'Ostseite des Pieperberges, westlich Ruine Nordhusen, It. LM Halle',NULL,-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(449,'Alv052','Haldensleben','BK','Bebertal I','Bebertal','Alv',52,NULL,0,NULL,NULL,'nicht bei Saal',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(450,'Emd044','Haldensleben','BK','Emden','Emden','Emd',44,NULL,1,NULL,NULL,'erhalten nach Beier???',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(451,'Emd045','Haldensleben','BK','Emden','Emden','Emd',45,NULL,1,NULL,NULL,'erhalten nach Beier???',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(453,'Hun023','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',23,'unsicher',6,'ebenes Gelände',NULL,'zerstört (OA)',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(454,'Hun030','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',30,'unsicher',6,NULL,'heute Einfassung des Feldweges Forsthaus Hundisburg—Gasthaus Ziegelei',NULL,-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(455,'Hun035','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',35,'unsicher',6,'ebenes Gelände',NULL,'zerstört (OA), 20 große Findlinge südlich der Feldgrenze am Bachlauf',-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(456,'Hun037','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',37,'sicher',-1,'ebenes Gelände','Der Haufen liegt parallel zu einem, durch den Bewuchs noch erkennbaren Weg  vom östl. anschließenden Feldrand zu Hundisburg Fpl. 35.','Länglicher 40 cm hoher Lesesteinhaufen ca. 1,5  x 6 m.',-1,'k. A.',NULL,500000);
INSERT INTO "T_MegalitheDaten" VALUES(507,'Hun026','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',26,'unsicher',6,NULL,'nordwestlich Ortslage Hundisburg, am Waldwege nach Haldensleben',NULL,-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(508,'Hun027','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',27,'unsicher',6,NULL,'nordwestlich Ortslage Hundisburg, am Waldwege nach Haldensleben',NULL,-1,'k. A.','Megalithgrab',422000);
INSERT INTO "T_MegalitheDaten" VALUES(523,'Hun013','Haldensleben','BK','Hundisburg','Haldensleben, Stadt','Hun',13,'sicher',6,'ebenes Gelände, sanft wellig','Am Alt-Emdener Weg, in der Westecke des vom Walde eingeschlossenen Ackers',NULL,-1,NULL,'Megalithgrab',422000);


/* Comment 
------------------------
 Table for the activities at each site (megalith).
"AktivitaetID" INTEGER PRIMARY KEY AUTOINCREMENT,  
"MegaID": 
"Aktivitaet":  description of the activity
"Akteur":  name of the person
"Datum" text): Date as text in reverse order yyyy/mm/dd depending on information depth
 */
DROP TABLE IF EXISTS "T_Aktivitaeten";
CREATE TABLE "T_Aktivitaeten" (
"AktivitaetID" INTEGER PRIMARY KEY AUTOINCREMENT,  
"MegaID" integer, 
"Aktivitaet" text, 
"Akteur" text, 
"Datum" text,
FOREIGN KEY (MegaID) REFERENCES T_MegalitheDaten(MegaID)
);
INSERT INTO "T_Aktivitaeten" VALUES(1,'219','Untersuchung','Herms/Engel','1928');
INSERT INTO "T_Aktivitaeten" VALUES(2,'242','Aufmaß','Worschech','2004');
INSERT INTO "T_Aktivitaeten" VALUES(3,'243','Aufmaß','Worschech','2004');
INSERT INTO "T_Aktivitaeten" VALUES(4,'244','Aufmaß','Worschech','2004');
INSERT INTO "T_Aktivitaeten" VALUES(5,'246','Aufmaß','Worschech','2004');
INSERT INTO "T_Aktivitaeten" VALUES(6,'251','Untersuchung','Preuß','1968');
INSERT INTO "T_Aktivitaeten" VALUES(7,'254','Aufmaß','Worschech','2004');
INSERT INTO "T_Aktivitaeten" VALUES(8,'255','Aufmaß','Worschech','2004');
INSERT INTO "T_Aktivitaeten" VALUES(9,'256','Aufmaß','Worschech','2004');
INSERT INTO "T_Aktivitaeten" VALUES(10,'259','Untersuchung','Wegener?','1896-1898');
INSERT INTO "T_Aktivitaeten" VALUES(11,'270','Untersuchung','Preuß','1968-69');
INSERT INTO "T_Aktivitaeten" VALUES(12,'276','Untersuchung','Preuß','1967');
INSERT INTO "T_Aktivitaeten" VALUES(13,'277','Untersuchung','Preuß','1967');
INSERT INTO "T_Aktivitaeten" VALUES(14,'279','zerstört',NULL,'1787');
INSERT INTO "T_Aktivitaeten" VALUES(15,'280','zerstört',NULL,'1733-1820');
INSERT INTO "T_Aktivitaeten" VALUES(16,'282','Untersuchung','Leibrock','1864');
INSERT INTO "T_Aktivitaeten" VALUES(17,'283','Untersuchung','Schmidt','1885/1886');
INSERT INTO "T_Aktivitaeten" VALUES(18,'285','Untersuchung','Preuß','1966/67');
INSERT INTO "T_Aktivitaeten" VALUES(19,'293','Untersuchung','Niquet, Grimm','1935');
INSERT INTO "T_Aktivitaeten" VALUES(20,'295','Untersuchung','Schlette, Preuß','1958');
INSERT INTO "T_Aktivitaeten" VALUES(21,'296','Untersuchung','Preuß, Häusler','1958/59');
INSERT INTO "T_Aktivitaeten" VALUES(22,'297','Aufmaß','Muche','2009');
INSERT INTO "T_Aktivitaeten" VALUES(24,'309','Untersuchung','Wegener','1896');
INSERT INTO "T_Aktivitaeten" VALUES(25,'313','Aufmaß','Worschech','2004');
INSERT INTO "T_Aktivitaeten" VALUES(26,'321','Aufmaß','Worschech','2004');
INSERT INTO "T_Aktivitaeten" VALUES(27,'326','Untersuchung','Wegener?','1896/1897');
INSERT INTO "T_Aktivitaeten" VALUES(28,'327','Aufmaß','Worschech','2004');
INSERT INTO "T_Aktivitaeten" VALUES(29,'328','Aufmaß','Worschech','2004');
INSERT INTO "T_Aktivitaeten" VALUES(30,'329','Aufmaß','Worschech','2004');
INSERT INTO "T_Aktivitaeten" VALUES(31,'330','Aufmaß','Worschech','2000');
INSERT INTO "T_Aktivitaeten" VALUES(32,'332','Untersuchung','Wegener','1896/1897');
INSERT INTO "T_Aktivitaeten" VALUES(33,'345','Untersuchung','Wegener','1896/1897');
INSERT INTO "T_Aktivitaeten" VALUES(34,'348','zerstört',NULL,'1970');
INSERT INTO "T_Aktivitaeten" VALUES(35,'370','Untersuchung','Wanckel','1943');
INSERT INTO "T_Aktivitaeten" VALUES(36,'371','zerstört',NULL,'1835/1836');
INSERT INTO "T_Aktivitaeten" VALUES(37,'372','Untersuchung','Dietze, Klopfleisch','1881');
INSERT INTO "T_Aktivitaeten" VALUES(38,'375','Untersuchung','Leopold','1836/1837');
INSERT INTO "T_Aktivitaeten" VALUES(39,'392','zerstört',NULL,'1890');
INSERT INTO "T_Aktivitaeten" VALUES(40,'393','Untersuchung','Höfer','1901');
INSERT INTO "T_Aktivitaeten" VALUES(41,'394','Hügel abgetragen',NULL,'1729');
INSERT INTO "T_Aktivitaeten" VALUES(42,'395','geöffnet',NULL,'1815');
INSERT INTO "T_Aktivitaeten" VALUES(43,'398','zerstört',NULL,'1800');
INSERT INTO "T_Aktivitaeten" VALUES(44,'399','zerstört',NULL,'1800');
INSERT INTO "T_Aktivitaeten" VALUES(45,'402','Untersuchung','Zacher','1858 vor');
INSERT INTO "T_Aktivitaeten" VALUES(46,'403','Untersuchung','Geschichtsverein','1835');
INSERT INTO "T_Aktivitaeten" VALUES(47,'405','Untersuchung','Gorges','1904');
INSERT INTO "T_Aktivitaeten" VALUES(48,'407','zerstört',NULL,'1890');
INSERT INTO "T_Aktivitaeten" VALUES(49,'409','Untersuchung','Götze, Eichhorn','1913');
INSERT INTO "T_Aktivitaeten" VALUES(50,'410','Untersuchung','Götze, Eichhorn','1912');
INSERT INTO "T_Aktivitaeten" VALUES(51,'411','geöffnet',NULL,'1784');
INSERT INTO "T_Aktivitaeten" VALUES(52,'413','Untersuchung','Hagemann','1909');
INSERT INTO "T_Aktivitaeten" VALUES(53,'414','zerstört',NULL,'1733-1820');
INSERT INTO "T_Aktivitaeten" VALUES(54,'415','zerstört',NULL,'1733-1820');
INSERT INTO "T_Aktivitaeten" VALUES(55,'435','zerstört',NULL,'1957');
INSERT INTO "T_Aktivitaeten" VALUES(56,'251','Aufmaß','Worschech','2004');
INSERT INTO "T_Aktivitaeten" VALUES(57,'259','Aufmaß','Worschech','2004');
INSERT INTO "T_Aktivitaeten" VALUES(58,'411','Untersuchung','Götze','1912');
INSERT INTO "T_Aktivitaeten" VALUES(59,'12','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(60,'29','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(61,'34','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(62,'35','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(63,'37','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(64,'38','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(65,'40','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(66,'44','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(67,'50','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(68,'55','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(69,'56','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(70,'62','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(71,'76','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(72,'80','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(73,'82','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(74,'97','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(75,'98','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(76,'99','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(77,'100','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(78,'101','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(79,'102','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(80,'103','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(81,'104','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(82,'112','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(83,'113','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(84,'115','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(85,'116','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(86,'117','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(87,'118','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(88,'119','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(89,'120','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(90,'121','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(91,'151','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(92,'152','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(93,'174','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(94,'175','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(95,'178','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(96,'185','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(97,'188','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(98,'189','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(99,'192','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(100,'193','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(101,'194','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(102,'195','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(103,'209','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(105,'507','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(106,'508','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(107,'515','Begehung','Fritsch','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(108,'242','Aufmaß','Lindemann','2010/03/22');
INSERT INTO "T_Aktivitaeten" VALUES(109,'243','Aufmaß','Lindemann','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(110,'244','Aufmaß','Lindemann','2010/03/23');
INSERT INTO "T_Aktivitaeten" VALUES(111,'246','Aufmaß','Lindemann','2010/03/22');
INSERT INTO "T_Aktivitaeten" VALUES(112,'247','Begehung','Lindemann','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(113,'248','Begehung','Lindemann','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(114,'249','Begehung','Lindemann','2010/04/22');
INSERT INTO "T_Aktivitaeten" VALUES(115,'250','Begehung','Lindemann','2010/04/22');
INSERT INTO "T_Aktivitaeten" VALUES(116,'251','Begehung','Lindemann','2010/03/25');
INSERT INTO "T_Aktivitaeten" VALUES(117,'252','Begehung','Lindemann','2010/03/25');
INSERT INTO "T_Aktivitaeten" VALUES(118,'254','Begehung','Lindemann','2010/04/22');
INSERT INTO "T_Aktivitaeten" VALUES(119,'255','Begehung','Lindemann','2010/03/23');
INSERT INTO "T_Aktivitaeten" VALUES(120,'256','Begehung','Lindemann','2010/03/25');
INSERT INTO "T_Aktivitaeten" VALUES(121,'257','Begehung','Lindemann','2010/03/23');
INSERT INTO "T_Aktivitaeten" VALUES(122,'258','Begehung','Lindemann','2010/03/25');
INSERT INTO "T_Aktivitaeten" VALUES(123,'259','Begehung','Lindemann','2010/03/25');
INSERT INTO "T_Aktivitaeten" VALUES(124,'260','Begehung','Lindemann','2010/03/25');
INSERT INTO "T_Aktivitaeten" VALUES(125,'262','Begehung','Lindemann','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(126,'263','Begehung','Lindemann','2010/03/24');
INSERT INTO "T_Aktivitaeten" VALUES(127,'264','Begehung','Lindemann','2010/03/24');
INSERT INTO "T_Aktivitaeten" VALUES(128,'265','Begehung','Lindemann','2010/03/24');
INSERT INTO "T_Aktivitaeten" VALUES(129,'266','Begehung','Lindemann','2010/03/25');
INSERT INTO "T_Aktivitaeten" VALUES(130,'267','Begehung','Lindemann','2010/03/25');
INSERT INTO "T_Aktivitaeten" VALUES(131,'268','Aufmaß','Lindemann','2010/03/25');
INSERT INTO "T_Aktivitaeten" VALUES(132,'269','Begehung','Lindemann','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(133,'270','Begehung','Lindemann','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(134,'271','Begehung','Lindemann','2010/03/23');
INSERT INTO "T_Aktivitaeten" VALUES(135,'272','Begehung','Lindemann','2010/03/23');
INSERT INTO "T_Aktivitaeten" VALUES(136,'274','Begehung','Lindemann','2010/04/21');
INSERT INTO "T_Aktivitaeten" VALUES(137,'276','Begehung','Lindemann','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(138,'277','Begehung','Lindemann','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(139,'297','Begehung','Lindemann','2010/04/21');
INSERT INTO "T_Aktivitaeten" VALUES(140,'298','Begehung','Lindemann','2010/04/21');
INSERT INTO "T_Aktivitaeten" VALUES(141,'312','Begehung','Lindemann','2010/03/24');
INSERT INTO "T_Aktivitaeten" VALUES(142,'313','Begehung','Lindemann','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(143,'316','Begehung','Lindemann','2010/03/26');
INSERT INTO "T_Aktivitaeten" VALUES(144,'317','Begehung','Lindemann','2010/03/26');
INSERT INTO "T_Aktivitaeten" VALUES(145,'318','Begehung','Lindemann','2010/03/25');
INSERT INTO "T_Aktivitaeten" VALUES(146,'319','Begehung','Lindemann','2010/03/25');
INSERT INTO "T_Aktivitaeten" VALUES(147,'320','Begehung','Lindemann','2010/03/25');
INSERT INTO "T_Aktivitaeten" VALUES(148,'321','Begehung','Lindemann','2010/03/25');
INSERT INTO "T_Aktivitaeten" VALUES(149,'322','Begehung','Lindemann','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(150,'323','Begehung','Lindemann','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(152,'325','Begehung','Lindemann','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(153,'326','Begehung','Lindemann','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(154,'327','Begehung','Lindemann','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(155,'328','Begehung','Lindemann','2010/04/21');
INSERT INTO "T_Aktivitaeten" VALUES(156,'329','Begehung','Lindemann','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(157,'330','Aufmaß','Lindemann','2010/04/21');
INSERT INTO "T_Aktivitaeten" VALUES(158,'331','Begehung','Lindemann','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(159,'335','Begehung','Lindemann','2009/12/09');
INSERT INTO "T_Aktivitaeten" VALUES(160,'337','Begehung','Lindemann','2010/03/25');
INSERT INTO "T_Aktivitaeten" VALUES(161,'338','Begehung','Lindemann','2010/03/25');
INSERT INTO "T_Aktivitaeten" VALUES(162,'339','Begehung','Lindemann','2010/03/23');
INSERT INTO "T_Aktivitaeten" VALUES(163,'340','Begehung','Lindemann','2010/03/23');
INSERT INTO "T_Aktivitaeten" VALUES(164,'419','Begehung','Lindemann','2009/10');
INSERT INTO "T_Aktivitaeten" VALUES(165,'420','Begehung','Lindemann','2010/03/24');
INSERT INTO "T_Aktivitaeten" VALUES(166,'422','Begehung','Lindemann','2009/11/09');
INSERT INTO "T_Aktivitaeten" VALUES(167,'423','Begehung','Lindemann','2010/03/26');
INSERT INTO "T_Aktivitaeten" VALUES(168,'428','Begehung','Lindemann','2010/03/16');
INSERT INTO "T_Aktivitaeten" VALUES(169,'298','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(170,'297','Untersuchung','Fritsch','2011/08');
INSERT INTO "T_Aktivitaeten" VALUES(171,'265','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(172,'262','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(173,'260','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(174,'259','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(175,'257','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(176,'258','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(177,'255','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(178,'254','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(179,'248','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(180,'253','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(181,'252','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(182,'251','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(183,'242','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(184,'243','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(185,'244','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(186,'270','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(187,'246','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(188,'266','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(189,'268','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(190,'336','Begehung','Fritsch','2008/04/25');
INSERT INTO "T_Aktivitaeten" VALUES(191,'369','Begehung','FRitsch','2013/02/09');
INSERT INTO "T_Aktivitaeten" VALUES(192,'365','Begehung','Fritsch','2013/02/09');
INSERT INTO "T_Aktivitaeten" VALUES(193,'314','Aufmaß','Rinne','2013/03/14');
INSERT INTO "T_Aktivitaeten" VALUES(194,'317','Aufmaß','Rinne','2010/03/10');
INSERT INTO "T_Aktivitaeten" VALUES(195,'312','Aufmaß','Rinne','2013/03/26');
INSERT INTO "T_Aktivitaeten" VALUES(196,'315','Aufmaß','Reuter','2011/08');
INSERT INTO "T_Aktivitaeten" VALUES(197,'316','Aufmaß','Reuter','2011/08');
INSERT INTO "T_Aktivitaeten" VALUES(198,'316','Begehung','Rinne','2013/03/12');
INSERT INTO "T_Aktivitaeten" VALUES(199,'319','Aufmaß','Rinne','2010/03');
INSERT INTO "T_Aktivitaeten" VALUES(200,'263','Aufmaß','Rinne','2013/03/26');
INSERT INTO "T_Aktivitaeten" VALUES(201,'265','Aufmaß','Rinne','2013/03/26');
INSERT INTO "T_Aktivitaeten" VALUES(202,'272','Aufmaß','Rinne','2013/03/26');
INSERT INTO "T_Aktivitaeten" VALUES(203,'333','Untersuchung','Wegener, Ph.','1898');
INSERT INTO "T_Aktivitaeten" VALUES(204,'338','Aufmaß','Rinne','2013/03/26');
INSERT INTO "T_Aktivitaeten" VALUES(205,'339','Aufmaß','Rinne','2013/03/26');
INSERT INTO "T_Aktivitaeten" VALUES(206,'347','Aufmaß','Rinne','2013/03/26');
INSERT INTO "T_Aktivitaeten" VALUES(207,'420','Untersuchung','Rinne','2013/02');
INSERT INTO "T_Aktivitaeten" VALUES(208,'418','Aufmaß','Rinne','2012/02');
INSERT INTO "T_Aktivitaeten" VALUES(209,'313','Aufmaß','Rinne','2009/04/19');
INSERT INTO "T_Aktivitaeten" VALUES(211,'320','Aufmaß','Rinne','2010/03');
INSERT INTO "T_Aktivitaeten" VALUES(212,'321','Aufmaß','Rinne','2010/03');
INSERT INTO "T_Aktivitaeten" VALUES(213,'323','Aufmaß','Rinne','2009/03');
INSERT INTO "T_Aktivitaeten" VALUES(214,'324','Aufmaß','Lindemann','2010/03/16');
INSERT INTO "T_Aktivitaeten" VALUES(215,'324','Aufmaß','Rinne','2010/03');
INSERT INTO "T_Aktivitaeten" VALUES(216,'325','Aufmaß','Rinne','2010/03');
INSERT INTO "T_Aktivitaeten" VALUES(217,'326','Aufmaß','Worschech','2004');
INSERT INTO "T_Aktivitaeten" VALUES(218,'326','Aufmaß','Rinne','2010/03');
INSERT INTO "T_Aktivitaeten" VALUES(219,'327','Aufmaß','Rinne','2010/03');
INSERT INTO "T_Aktivitaeten" VALUES(220,'328','Aufmaß','Rinne','2009/04/19');
INSERT INTO "T_Aktivitaeten" VALUES(221,'329','Aufmaß','Rinne','2010/03');
INSERT INTO "T_Aktivitaeten" VALUES(222,'419','Begehung','Rinne','2012/02');
INSERT INTO "T_Aktivitaeten" VALUES(223,'421','Begehung','Lindemann','2010/03/14');
INSERT INTO "T_Aktivitaeten" VALUES(224,'421','Begehung','Rinne','2012/02');
INSERT INTO "T_Aktivitaeten" VALUES(226,'271','Aufmaß','Rinne','2010/03');
INSERT INTO "T_Aktivitaeten" VALUES(228,'336','Untersuchung','Lindemann','2009');
INSERT INTO "T_Aktivitaeten" VALUES(229,'337','Aufmaß','Rinne','2010/03');
INSERT INTO "T_Aktivitaeten" VALUES(230,'340','Aufmaß','Rinne','2010/03');
INSERT INTO "T_Aktivitaeten" VALUES(231,'423','Aufmaß','Rinne','2010/03');
INSERT INTO "T_Aktivitaeten" VALUES(233,'455','Begehung','Rinne','2010/03');
INSERT INTO "T_Aktivitaeten" VALUES(234,'308','Begehung','Lindemann','2010/03');
INSERT INTO "T_Aktivitaeten" VALUES(235,'344','Begehung','Rinne','2010/03/26');
INSERT INTO "T_Aktivitaeten" VALUES(236,'346','Begehung','Rinne','2010/03/26');
INSERT INTO "T_Aktivitaeten" VALUES(237,'281','Begehung','Lindemann','2010/04/21');
INSERT INTO "T_Aktivitaeten" VALUES(238,'274','Begehung','Rinne','2013/05/24');
INSERT INTO "T_Aktivitaeten" VALUES(239,'273','Aufmaß','Rinne','2013/05/24');
INSERT INTO "T_Aktivitaeten" VALUES(240,'273','Begehung','Lindemann','2010/04/13');
INSERT INTO "T_Aktivitaeten" VALUES(241,'284','Aufmaß','Rinne','2013/05/24');
INSERT INTO "T_Aktivitaeten" VALUES(242,'287','Aufmaß','Rinne','2013/05/24');
INSERT INTO "T_Aktivitaeten" VALUES(243,'288','Aufmaß','Rinne','2013/05/24');
INSERT INTO "T_Aktivitaeten" VALUES(244,'267','Aufmaß','Rinne','2013/05/25');
INSERT INTO "T_Aktivitaeten" VALUES(245,'266','Aufmaß','Rinne','2013/05/25');
INSERT INTO "T_Aktivitaeten" VALUES(246,'259','Aufmaß','Rinne','2013/05/25');
INSERT INTO "T_Aktivitaeten" VALUES(247,'257','Aufmaß','Rinne','2013/05/25');
INSERT INTO "T_Aktivitaeten" VALUES(248,'253','Begehung','Lindemann','2011/04/07');
INSERT INTO "T_Aktivitaeten" VALUES(249,'262','Begehung','Rinne','2009/04');
INSERT INTO "T_Aktivitaeten" VALUES(250,'269','Begehung','Rinne','2009/03');
INSERT INTO "T_Aktivitaeten" VALUES(251,'275','Begehung','Rinne','2013/05');
INSERT INTO "T_Aktivitaeten" VALUES(252,'322','Aufmaß','Worschech','2004');
INSERT INTO "T_Aktivitaeten" VALUES(253,'331','Aufmaß','Rinne','2010/04');
INSERT INTO "T_Aktivitaeten" VALUES(254,'250','Aufmaß','Rinne','2013/05/26');
INSERT INTO "T_Aktivitaeten" VALUES(255,'298','Aufmaß','Rinne','2010/04');
INSERT INTO "T_Aktivitaeten" VALUES(256,'307','Aufmaß','Stuhlmann','1934/12/1');
INSERT INTO "T_Aktivitaeten" VALUES(257,'253','Aufmaß','Rinne','2013/07/29');
INSERT INTO "T_Aktivitaeten" VALUES(258,'423','Aufmaß','Rinne','2013/07/27');
INSERT INTO "T_Aktivitaeten" VALUES(259,'311','Begehung','Piltz','1950/05');
INSERT INTO "T_Aktivitaeten" VALUES(260,'311','Begehung','Runkel','1950/05/15');
INSERT INTO "T_Aktivitaeten" VALUES(261,'311','Begehung','Matthias','1952/04/10');
INSERT INTO "T_Aktivitaeten" VALUES(262,'313','Rekonstruktion','Hauer','1992/10/07');
INSERT INTO "T_Aktivitaeten" VALUES(263,'318','Aufmaß','Stuhlmann','1934/11/15');
INSERT INTO "T_Aktivitaeten" VALUES(264,'318','Aufmaß','Rinne','2010/03/11');
INSERT INTO "T_Aktivitaeten" VALUES(265,'322','Aufmaß','Rinne','2010/04');
INSERT INTO "T_Aktivitaeten" VALUES(267,'248','Aufmaß','Lindemann','2010/03');
INSERT INTO "T_Aktivitaeten" VALUES(268,'256','Aufmaß','Rinne','2010/03');
INSERT INTO "T_Aktivitaeten" VALUES(269,'260','Begehung','Rinne','2010/03');
INSERT INTO "T_Aktivitaeten" VALUES(270,'264','Begehung','Rinne','2009/03');
INSERT INTO "T_Aktivitaeten" VALUES(271,'268','Aufmaß','Stuhlmann','1934/12/4');
INSERT INTO "T_Aktivitaeten" VALUES(272,'271','Aufmaß','Stuhlmann','1934/10/4');
INSERT INTO "T_Aktivitaeten" VALUES(273,'272','Aufmaß','Stuhlmann','1935/05/10');
INSERT INTO "T_Aktivitaeten" VALUES(274,'289','Aufmaß','Stuhlmann','1934/11/27');
INSERT INTO "T_Aktivitaeten" VALUES(275,'292','Aufmaß','Stuhlmann','1934/10/08');
INSERT INTO "T_Aktivitaeten" VALUES(277,'294','Aufmaß','Stuhlmann','1934/10/12');
INSERT INTO "T_Aktivitaeten" VALUES(279,'297','Untersuchung','Fritsch','2012/08');
INSERT INTO "T_Aktivitaeten" VALUES(280,'298','Untersuchung','Schwertfeger','2015/05');
INSERT INTO "T_Aktivitaeten" VALUES(281,'301','Aufmaß','Stuhlmann','1934/11/29');
INSERT INTO "T_Aktivitaeten" VALUES(282,'335','Aufmaß','Stuhlmann','1934/08/25');
INSERT INTO "T_Aktivitaeten" VALUES(283,'335','Untersuchung','Schmutz','2012/08');
INSERT INTO "T_Aktivitaeten" VALUES(284,'337','Aufmaß','Stuhlmann','1934/11/15');
INSERT INTO "T_Aktivitaeten" VALUES(285,'426','Begehung','Lindemann','2010/04/21');
INSERT INTO "T_Aktivitaeten" VALUES(286,'426','Aufmaß','Stuhlmann','1934/10/18');
INSERT INTO "T_Aktivitaeten" VALUES(287,'426','Untersuchung','Wegener','1896');
INSERT INTO "T_Aktivitaeten" VALUES(288,'344','Aufmaß','Stuhlmann','1934/10/22');
INSERT INTO "T_Aktivitaeten" VALUES(289,'346','Untersuchung','Wegener','1896');
INSERT INTO "T_Aktivitaeten" VALUES(290,'242','Aufmaß','Stuhlmann','1934/10/24');
INSERT INTO "T_Aktivitaeten" VALUES(291,'243','Aufmaß','Stuhlmann','1934/10/25');
INSERT INTO "T_Aktivitaeten" VALUES(292,'244','Aufmaß','Stuhlmann','1934/10/25');
INSERT INTO "T_Aktivitaeten" VALUES(293,'246','Aufmaß','Stuhlmann','1934/10/25');
INSERT INTO "T_Aktivitaeten" VALUES(294,'247','Aufmaß','Stuhlmann','1934/11/27');
INSERT INTO "T_Aktivitaeten" VALUES(295,'248','Aufmaß','Stuhlmann','1934/11/27');
INSERT INTO "T_Aktivitaeten" VALUES(296,'249','Aufmaß','Stuhlmann','1934/11/27');
INSERT INTO "T_Aktivitaeten" VALUES(297,'250','Aufmaß','Stuhlmann','1934/11/27');
INSERT INTO "T_Aktivitaeten" VALUES(298,'251','Aufmaß','Stuhlmann','1934/10/25');
INSERT INTO "T_Aktivitaeten" VALUES(299,'252','Aufmaß','Stuhlmann','1934/11/27');
INSERT INTO "T_Aktivitaeten" VALUES(300,'253','Aufmaß','Stuhlmann','1935/05/03');
INSERT INTO "T_Aktivitaeten" VALUES(301,'254','Aufmaß','Stuhlmann','1934/11/05');
INSERT INTO "T_Aktivitaeten" VALUES(302,'255','Aufmaß','Stuhlmann','1934/11/30');
INSERT INTO "T_Aktivitaeten" VALUES(303,'256','Aufmaß','Stuhlmann','1934/11/30');
INSERT INTO "T_Aktivitaeten" VALUES(304,'257','Aufmaß','Stuhlmann','1934/11/30');
INSERT INTO "T_Aktivitaeten" VALUES(305,'258','Aufmaß','Stuhlmann','1934/11/30');
INSERT INTO "T_Aktivitaeten" VALUES(306,'259','Aufmaß','Stuhlmann','1934/11/30');
INSERT INTO "T_Aktivitaeten" VALUES(307,'260','Aufmaß','Stuhlmann','1934/11/30');
INSERT INTO "T_Aktivitaeten" VALUES(308,'262','Aufmaß','Stuhlmann','1934/11/30');
INSERT INTO "T_Aktivitaeten" VALUES(309,'263','Aufmaß','Stuhlmann','1934/12/04');
INSERT INTO "T_Aktivitaeten" VALUES(310,'264','Aufmaß','Stuhlmann','1934/12/04');
INSERT INTO "T_Aktivitaeten" VALUES(311,'265','Aufmaß','Stuhlmann','1934/12/04');
INSERT INTO "T_Aktivitaeten" VALUES(312,'266','Aufmaß','Stuhlmann','1934/12/04');
INSERT INTO "T_Aktivitaeten" VALUES(313,'267','Aufmaß','Stuhlmann','1934/12/04');
INSERT INTO "T_Aktivitaeten" VALUES(314,'268','Aufmaß','Stuhlmann','1934/11/29');
INSERT INTO "T_Aktivitaeten" VALUES(315,'269','Aufmaß','Stuhlmann','1934/11/28');
INSERT INTO "T_Aktivitaeten" VALUES(316,'270','Aufmaß','Stuhlmann','1934');
INSERT INTO "T_Aktivitaeten" VALUES(317,'273','Aufmaß','Stuhlmann','1934/11/28');
INSERT INTO "T_Aktivitaeten" VALUES(318,'274','Aufmaß','Stuhlmann','1935/05/03');
INSERT INTO "T_Aktivitaeten" VALUES(319,'275','Aufmaß','Stuhlmann','1935/05/03');
INSERT INTO "T_Aktivitaeten" VALUES(320,'276','Aufmaß','Stuhlmann','1934');
INSERT INTO "T_Aktivitaeten" VALUES(321,'277','Aufmaß','Stuhlmann','1934');
INSERT INTO "T_Aktivitaeten" VALUES(322,'285','Aufmaß','Stuhlmann','1934');
INSERT INTO "T_Aktivitaeten" VALUES(323,'295','Aufmaß','Stuhlmann','1934');
INSERT INTO "T_Aktivitaeten" VALUES(324,'296','Aufmaß','Stuhlmann','1934');
INSERT INTO "T_Aktivitaeten" VALUES(325,'297','Aufmaß','Stuhlmann','1934/12/07');
INSERT INTO "T_Aktivitaeten" VALUES(326,'298','Aufmaß','Stuhlmann','1934/11/29');
INSERT INTO "T_Aktivitaeten" VALUES(328,'308','Aufmaß','Stuhlmann','1934/10/22');
INSERT INTO "T_Aktivitaeten" VALUES(329,'309','Aufmaß','Stuhlmann','1934');
INSERT INTO "T_Aktivitaeten" VALUES(330,'313','Aufmaß','Stuhlmann','1934/10/05');
INSERT INTO "T_Aktivitaeten" VALUES(331,'314','Aufmaß','Stuhlmann','1934/10/05');
INSERT INTO "T_Aktivitaeten" VALUES(332,'315','Aufmaß','Stuhlmann','1934/10/05');
INSERT INTO "T_Aktivitaeten" VALUES(333,'316','Aufmaß','Stuhlmann','1934/10/05');
INSERT INTO "T_Aktivitaeten" VALUES(334,'317','Aufmaß','Stuhlmann','1934/10/30');
INSERT INTO "T_Aktivitaeten" VALUES(335,'319','Aufmaß','Stuhlmann','1934/10/13');
INSERT INTO "T_Aktivitaeten" VALUES(336,'320','Aufmaß','Stuhlmann','1934/11/13');
INSERT INTO "T_Aktivitaeten" VALUES(337,'321','Aufmaß','Stuhlmann','1934/10/12');
INSERT INTO "T_Aktivitaeten" VALUES(338,'322','Aufmaß','Stuhlmann','1934/10/01');
INSERT INTO "T_Aktivitaeten" VALUES(339,'323','Aufmaß','Stuhlmann','1934/10/01');
INSERT INTO "T_Aktivitaeten" VALUES(340,'324','Aufmaß','Stuhlmann','1934/10/03');
INSERT INTO "T_Aktivitaeten" VALUES(341,'325','Aufmaß','Stuhlmann','1934/10/05');
INSERT INTO "T_Aktivitaeten" VALUES(342,'326','Aufmaß','Stuhlmann','1934/10/34');
INSERT INTO "T_Aktivitaeten" VALUES(343,'327','Aufmaß','Stuhlmann','1934/11/12');
INSERT INTO "T_Aktivitaeten" VALUES(344,'328','Aufmaß','Stuhlmann','1934/11/12');
INSERT INTO "T_Aktivitaeten" VALUES(345,'329','Aufmaß','Stuhlmann','1934/11/13');
INSERT INTO "T_Aktivitaeten" VALUES(346,'330','Aufmaß','Stuhlmann','1934/10/22');
INSERT INTO "T_Aktivitaeten" VALUES(347,'331','Aufmaß','Stuhlmann','1934/10/30');
INSERT INTO "T_Aktivitaeten" VALUES(348,'336','Aufmaß','Stuhlmann','1934/11/06');
INSERT INTO "T_Aktivitaeten" VALUES(350,'338','Aufmaß','Stuhlmann','1934/12/06');
INSERT INTO "T_Aktivitaeten" VALUES(351,'339','Aufmaß','Stuhlmann','1934/12/06');
INSERT INTO "T_Aktivitaeten" VALUES(352,'340','Aufmaß','Stuhlmann','1934/11/27');
INSERT INTO "T_Aktivitaeten" VALUES(353,'345','Aufmaß','Stuhlmann','1934');
INSERT INTO "T_Aktivitaeten" VALUES(354,'346','Aufmaß','Stuhlmann','1934');
INSERT INTO "T_Aktivitaeten" VALUES(355,'423','Aufmaß','Stuhlmann','1934');
INSERT INTO "T_Aktivitaeten" VALUES(356,'428','Aufmaß','Stuhlmann','1934/10/05');
INSERT INTO "T_Aktivitaeten" VALUES(360,'426','Aufmaß','Rinne','2014/08/20');
INSERT INTO "T_Aktivitaeten" VALUES(361,'318','Aufmaß CAD','Rinne','2016/03/10');
INSERT INTO "T_Aktivitaeten" VALUES(362,'327','Aufmaß CAD','Rinne','2016/03/10');
INSERT INTO "T_Aktivitaeten" VALUES(363,'330','Aufmaß CAD','Rinne','2016/03/09');
INSERT INTO "T_Aktivitaeten" VALUES(364,'456','Begehung','Rinne','2017/03/11');

/* Comment 
------------------------
 Table for the relation between the oficial identification of the LSA 
 based on local subdistrict (Gemarkung) and consecutive numbering
 and the GDB LSA (Grabungsdatenbank Land Sachsen-Anhalt) based on activity sites and features
 and the MegaID of the project.
 "OA": Ortsakten, full identifier with abbrev. local subdivision and numbering
"OAGem": Ortsakten Gemarkung, abbrev. local subdivision 
"OANr": Ortsakten Nummer, consecutive numbering of sites in the local subdivision 
"Bef_Nr": Befund Nummer, feature numbering
"FundstelleID": Fundstelle ID, site ID in the GDB LSA (Grabungsdatenbank Land Sachsen-Anhalt)
"MegaID": 
*/
DROP TABLE IF EXISTS "T_Bef2OA";
CREATE TABLE "T_Bef2OA" (
"OA" text, 
"OAGem" text, 
"OANr" integer, 
"Bef_Nr" integer, 
"FundstelleID" integer, 
"MegaID" integer,
FOREIGN KEY (MegaID) REFERENCES T_MegalitheDaten(MegaID)
FOREIGN KEY (FundstelleID) REFERENCES T_Befundbeschreibung(FundstelleID)
FOREIGN KEY (Bef_Nr) REFERENCES T_Befundbeschreibung(Bef_Nr)
);
INSERT INTO "T_Bef2OA" VALUES('Alv003','Alv',3,3,11,242);
INSERT INTO "T_Bef2OA" VALUES('Alv004','Alv',4,4,11,243);
INSERT INTO "T_Bef2OA" VALUES('Alv005','Alv',5,5,11,244);
INSERT INTO "T_Bef2OA" VALUES('Alv006','Alv',6,6,11,246);
INSERT INTO "T_Bef2OA" VALUES('Alv010','Alv',10,10,11,247);
INSERT INTO "T_Bef2OA" VALUES('Alv011','Alv',11,11,11,248);
INSERT INTO "T_Bef2OA" VALUES('Alv012','Alv',12,12,11,249);
INSERT INTO "T_Bef2OA" VALUES('Alv013','Alv',13,13,11,250);
INSERT INTO "T_Bef2OA" VALUES('Alv014','Alv',14,14,11,251);
INSERT INTO "T_Bef2OA" VALUES('Alv015','Alv',15,15,11,252);
INSERT INTO "T_Bef2OA" VALUES('Alv016','Alv',16,16,11,253);
INSERT INTO "T_Bef2OA" VALUES('Alv017','Alv',17,17,11,254);
INSERT INTO "T_Bef2OA" VALUES('Alv018','Alv',18,18,11,255);
INSERT INTO "T_Bef2OA" VALUES('Alv021','Alv',21,21,11,256);
INSERT INTO "T_Bef2OA" VALUES('Alv020','Alv',20,20,11,257);
INSERT INTO "T_Bef2OA" VALUES('Alv019','Alv',19,19,11,258);
INSERT INTO "T_Bef2OA" VALUES('Alv022','Alv',22,22,11,259);
INSERT INTO "T_Bef2OA" VALUES('Alv023','Alv',23,23,11,260);
INSERT INTO "T_Bef2OA" VALUES('Alv024','Alv',24,24,11,261);
INSERT INTO "T_Bef2OA" VALUES('Alv025','Alv',25,25,11,262);
INSERT INTO "T_Bef2OA" VALUES('Alv026','Alv',26,26,11,263);
INSERT INTO "T_Bef2OA" VALUES('Alv027','Alv',27,27,11,264);
INSERT INTO "T_Bef2OA" VALUES('Alv028','Alv',28,28,11,265);
INSERT INTO "T_Bef2OA" VALUES('Alv029','Alv',29,29,11,266);
INSERT INTO "T_Bef2OA" VALUES('Alv030','Alv',30,30,11,267);
INSERT INTO "T_Bef2OA" VALUES('Alv031','Alv',31,31,11,268);
INSERT INTO "T_Bef2OA" VALUES('Alv032','Alv',32,32,11,269);
INSERT INTO "T_Bef2OA" VALUES('Alv033','Alv',33,33,11,270);
INSERT INTO "T_Bef2OA" VALUES('Alv034','Alv',34,34,11,271);
INSERT INTO "T_Bef2OA" VALUES('Alv035','Alv',35,35,11,272);
INSERT INTO "T_Bef2OA" VALUES('Alv036','Alv',36,36,11,273);
INSERT INTO "T_Bef2OA" VALUES('Alv037','Alv',37,37,11,274);
INSERT INTO "T_Bef2OA" VALUES('Alv038','Alv',38,38,11,275);
INSERT INTO "T_Bef2OA" VALUES('Alv039','Alv',39,39,11,276);
INSERT INTO "T_Bef2OA" VALUES('Alv040','Alv',40,40,11,277);
INSERT INTO "T_Bef2OA" VALUES('Süp005','Süp',5,5,17,281);
INSERT INTO "T_Bef2OA" VALUES('Alv041','Alv',41,41,11,284);
INSERT INTO "T_Bef2OA" VALUES('Alv042','Alv',42,42,11,285);
INSERT INTO "T_Bef2OA" VALUES('Alv043','Alv',43,43,11,286);
INSERT INTO "T_Bef2OA" VALUES('Alv044','Alv',44,44,11,287);
INSERT INTO "T_Bef2OA" VALUES('Alv045','Alv',45,45,11,288);
INSERT INTO "T_Bef2OA" VALUES('Alv046','Alv',46,46,11,289);
INSERT INTO "T_Bef2OA" VALUES('Alv047','Alv',47,47,11,290);
INSERT INTO "T_Bef2OA" VALUES('Alv048','Alv',48,48,11,291);
INSERT INTO "T_Bef2OA" VALUES('Dön004','Dön',4,4,12,292);
INSERT INTO "T_Bef2OA" VALUES('Dön005','Dön',5,5,12,293);
INSERT INTO "T_Bef2OA" VALUES('Dön007','Dön',7,7,12,294);
INSERT INTO "T_Bef2OA" VALUES('Dön008','Dön',8,8,12,295);
INSERT INTO "T_Bef2OA" VALUES('Dön009','Dön',9,9,12,296);
INSERT INTO "T_Bef2OA" VALUES('Dön010','Dön',10,10,12,297);
INSERT INTO "T_Bef2OA" VALUES('Dön011','Dön',11,11,12,298);
INSERT INTO "T_Bef2OA" VALUES('Dön012','Dön',12,12,12,299);
INSERT INTO "T_Bef2OA" VALUES('Dön013','Dön',13,13,12,300);
INSERT INTO "T_Bef2OA" VALUES('Dön014','Dön',14,14,12,301);
INSERT INTO "T_Bef2OA" VALUES('Dön015','Dön',15,15,12,302);
INSERT INTO "T_Bef2OA" VALUES('Bod001','Bod',1,1,18,303);
INSERT INTO "T_Bef2OA" VALUES('NHa09','NHa',9,9,16,307);
INSERT INTO "T_Bef2OA" VALUES('NHa010','NHa',10,10,16,308);
INSERT INTO "T_Bef2OA" VALUES('NHa011','NHa',11,11,16,309);
INSERT INTO "T_Bef2OA" VALUES('NHa012','NHa',12,12,16,310);
INSERT INTO "T_Bef2OA" VALUES('AHa009','AHa',9,9,10,312);
INSERT INTO "T_Bef2OA" VALUES('AHa010','AHa',10,10,10,313);
INSERT INTO "T_Bef2OA" VALUES('AHa011','AHa',11,11,10,314);
INSERT INTO "T_Bef2OA" VALUES('AHa012','AHa',12,12,10,315);
INSERT INTO "T_Bef2OA" VALUES('AHa013','AHa',13,13,10,316);
INSERT INTO "T_Bef2OA" VALUES('AHa014','AHa',14,14,10,317);
INSERT INTO "T_Bef2OA" VALUES('AHa015','AHa',15,15,10,318);
INSERT INTO "T_Bef2OA" VALUES('AHa016','AHa',16,16,10,319);
INSERT INTO "T_Bef2OA" VALUES('AHa017','AHa',17,17,10,320);
INSERT INTO "T_Bef2OA" VALUES('AHa018','AHa',18,18,10,321);
INSERT INTO "T_Bef2OA" VALUES('AHa019','AHa',19,19,10,322);
INSERT INTO "T_Bef2OA" VALUES('AHa020','AHa',20,20,10,323);
INSERT INTO "T_Bef2OA" VALUES('AHa021','AHa',21,21,10,324);
INSERT INTO "T_Bef2OA" VALUES('AHa022','AHa',22,22,10,325);
INSERT INTO "T_Bef2OA" VALUES('AHa023','AHa',23,23,10,326);
INSERT INTO "T_Bef2OA" VALUES('AHa024','AHa',24,24,10,327);
INSERT INTO "T_Bef2OA" VALUES('AHa025','AHa',25,25,10,328);
INSERT INTO "T_Bef2OA" VALUES('AHa026','AHa',26,26,10,329);
INSERT INTO "T_Bef2OA" VALUES('AHa027','AHa',27,27,10,330);
INSERT INTO "T_Bef2OA" VALUES('AHa028','AHa',28,28,10,331);
INSERT INTO "T_Bef2OA" VALUES('AHa029','AHa',29,29,10,332);
INSERT INTO "T_Bef2OA" VALUES('Hun006','Hun',6,6,15,333);
INSERT INTO "T_Bef2OA" VALUES('Hun013','Hun',13,13,15,334);
INSERT INTO "T_Bef2OA" VALUES('Hun014','Hun',14,14,15,335);
INSERT INTO "T_Bef2OA" VALUES('Hun015','Hun',15,15,15,336);
INSERT INTO "T_Bef2OA" VALUES('Hun016','Hun',16,16,15,337);
INSERT INTO "T_Bef2OA" VALUES('Hun017','Hun',17,17,15,338);
INSERT INTO "T_Bef2OA" VALUES('Hun018','Hun',18,18,15,339);
INSERT INTO "T_Bef2OA" VALUES('Hun019','Hun',19,19,15,340);
INSERT INTO "T_Bef2OA" VALUES('Hun020','Hun',20,20,15,341);
INSERT INTO "T_Bef2OA" VALUES('Hun021','Hun',21,21,15,342);
INSERT INTO "T_Bef2OA" VALUES('Süp001','Süp',1,1,17,426);
INSERT INTO "T_Bef2OA" VALUES('Süp002','Süp',2,2,17,344);
INSERT INTO "T_Bef2OA" VALUES('Süp003','Süp',3,3,17,345);
INSERT INTO "T_Bef2OA" VALUES('Süp004','Süp',4,4,17,346);
INSERT INTO "T_Bef2OA" VALUES('Süp006','Süp',6,6,17,347);
INSERT INTO "T_Bef2OA" VALUES('AHa033','AHa',33,33,10,418);
INSERT INTO "T_Bef2OA" VALUES('AHa031','AHa',31,31,10,419);
INSERT INTO "T_Bef2OA" VALUES('AHa034','AHa',34,34,10,420);
INSERT INTO "T_Bef2OA" VALUES('AHa032','AHa',32,32,10,421);
INSERT INTO "T_Bef2OA" VALUES('Emd012','Emd',12,12,13,422);
INSERT INTO "T_Bef2OA" VALUES('Hun022','Hun',22,22,15,423);
INSERT INTO "T_Bef2OA" VALUES('AHa042','AHa',42,42,10,424);
INSERT INTO "T_Bef2OA" VALUES('Alv002','Alv',2,2,11,425);
INSERT INTO "T_Bef2OA" VALUES('AHa002','AHa',2,2,10,427);
INSERT INTO "T_Bef2OA" VALUES('AHa001','AHa',1,1,10,428);
INSERT INTO "T_Bef2OA" VALUES('Alv001','Alv',1,1,11,429);
INSERT INTO "T_Bef2OA" VALUES('Dön016','Dön',16,16,12,430);
INSERT INTO "T_Bef2OA" VALUES('Dön017','Dön',17,17,12,431);
INSERT INTO "T_Bef2OA" VALUES('Dön018','Dön',18,18,12,432);
INSERT INTO "T_Bef2OA" VALUES('Dön019','Dön',19,19,12,433);
INSERT INTO "T_Bef2OA" VALUES('Dön020','Dön',20,20,12,434);
INSERT INTO "T_Bef2OA" VALUES('Dön021','Dön',21,21,12,435);
INSERT INTO "T_Bef2OA" VALUES('Hun025','Hun',25,25,15,436);
INSERT INTO "T_Bef2OA" VALUES('Hun024','Hun',24,24,15,437);
INSERT INTO "T_Bef2OA" VALUES('Emd015','Emd',15,15,13,438);
INSERT INTO "T_Bef2OA" VALUES('Emd016','Emd',16,16,13,439);
INSERT INTO "T_Bef2OA" VALUES('Emd017','Emd',17,17,13,440);
INSERT INTO "T_Bef2OA" VALUES('AHa030','AHa',30,30,10,441);
INSERT INTO "T_Bef2OA" VALUES('NHa030','NHa',30,30,16,442);
INSERT INTO "T_Bef2OA" VALUES('Hun028','Hun',28,28,15,445);
INSERT INTO "T_Bef2OA" VALUES('Hun029','Hun',29,29,15,446);
INSERT INTO "T_Bef2OA" VALUES('AHa035','AHa',35,35,10,447);
INSERT INTO "T_Bef2OA" VALUES('Alv052','Alv',52,52,11,449);
INSERT INTO "T_Bef2OA" VALUES('Emd044','Emd',44,44,13,450);
INSERT INTO "T_Bef2OA" VALUES('Emd045','Emd',45,45,13,451);
INSERT INTO "T_Bef2OA" VALUES('Hun023','Hun',23,23,15,453);
INSERT INTO "T_Bef2OA" VALUES('Hun030','Hun',30,30,15,454);
INSERT INTO "T_Bef2OA" VALUES('Hun035','Hun',35,35,15,455);
INSERT INTO "T_Bef2OA" VALUES('Hun037','Hun',37,37,15,456);
INSERT INTO "T_Bef2OA" VALUES('NHa05','NHa',5,5,16,506);
INSERT INTO "T_Bef2OA" VALUES('Hun026','Hun',26,26,15,507);
INSERT INTO "T_Bef2OA" VALUES('Hun027','Hun',27,27,15,508);
INSERT INTO "T_Bef2OA" VALUES('AHa008','AHa',8,8,10,311);

/* Comment 
------------------------
 Table for the dating opinions for the site/megalith.
 "Einordnung": typological denomination (archäologische Kultur)
"ZeitstellungID": dating ID of the GDB LSA (Grabungsdatenbank Land Sachsen-Anhalt) foreign key on wt_zeitstellung
"Methode":  method of the dating (typological, radiocarbon, etc)
"Kontext": what ist dated / the feature dated
"Grundlage": dating based on which material
"Autor": name of the person dating
"Datum": time of the dating
*/
DROP TABLE IF EXISTS "T_Datierung";
CREATE TABLE "T_Datierung" (
"KulturID" INTEGER PRIMARY KEY AUTOINCREMENT,  
"MegaID" integer, 
"Einordnung" text, 
"ZeitstellungID" integer, 
"Methode" text, 
"Kontext" text, 
"Grundlage" text, 
"Autor" text, 
"Datum" datetime,
FOREIGN KEY (MegaID) REFERENCES T_MegalitheDaten(MegaID)
);
INSERT INTO "T_Datierung" VALUES(1,29,'Kugelamphorenkultur',32110,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(2,38,'Altm. Tiefstich',32080,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(3,40,'Altm. Tiefstich',32080,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(4,68,'Kugelamphorenkultur',32110,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(5,97,'Altm. Tiefstich, Düsedau',32080,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(6,102,'Altm. Tiefstich, Haldensleben',32080,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(7,115,'Altm. Tiefstich',32080,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(8,118,'Altm. Tiefstich',32080,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(9,179,'Altm. Tiefstich, Düsedau',32080,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(10,186,'Altm. Tiefstich',32080,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(11,194,'Kugelamphorenkultur',32110,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(12,219,'Walternienburg',32090,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(13,251,'Altm. Tiefstich, Düsedau',32080,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(14,270,'Altm. Tiefstich, Haldensleben',32080,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(15,279,'Bernburg',32100,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(16,282,'Bernburg',32100,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(17,283,'Kugelamphorenkultur',32110,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(18,285,'Altm. Tiefstich, Haldensleben',32080,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(19,293,'Altm. Tiefstich',32080,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(20,295,'Walternienburg',32090,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(21,296,'Altm. Tiefstich',32080,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(23,370,'Kugelamphorenkultur',32110,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(24,371,'Bernburg',32100,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(25,375,'Bernburg',32100,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(26,393,'Walternienburg',32090,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(27,403,'Walternienburg',32090,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(28,405,'Walternienburg',32090,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(29,409,'SZM',32070,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(30,410,'Walternienburg',32090,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(31,411,'Bernburg',32100,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(32,416,'Bernburg',32100,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(33,102,'Kugelamphorenkultur',32110,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(34,115,'Kugelamphorenkultur',32110,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(35,219,'Kugelamphorenkultur',32110,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(36,293,'Walternienburg',32090,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(37,296,'Walternienburg',32090,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(38,370,'Bernburg',32100,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(39,393,'Kugelamphorenkultur',32110,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(40,405,'Bernburg',32100,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(41,409,'Bernburg',32100,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(42,30,'Einzegrabkultur?',33030,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(43,40,'Schönfeld',33020,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(44,74,'Schönfeld',33020,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(45,97,'Einzegrabkultur',33030,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(46,173,'Einzegrabkultur',33030,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(47,194,'Schönfeld',33020,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(48,219,'Einzegrabkultur',33030,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(49,293,'Schönfeld',33020,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(50,393,'Schnurkeramik',33010,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(51,402,'Schnurkeramik',33010,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(52,403,'Schnurkeramik',33010,'Typologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(83,38,'TRB III/IV',32042,'relative Chronologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(84,40,'TRB III/IV',32042,'relative Chronologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(85,97,'TRB III/IV',32042,'relative Chronologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(86,102,'TRB IV',32042,'relative Chronologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(87,179,'TRB III',32042,'relative Chronologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(88,235,'TRB V',32042,'relative Chronologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(89,251,'TRB III',32042,'relative Chronologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(90,270,'TRB IV',32042,'relative Chronologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(92,282,'TRB V',32042,'relative Chronologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(93,285,'TRB IV',32042,'relative Chronologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(94,293,'TRB IV',32042,'relative Chronologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(95,295,'TRB IV',32042,'relative Chronologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(96,296,'TRB IV',32042,'relative Chronologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(97,375,'TRB V',32042,'relative Chronologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(98,405,'TRB IV',32042,'relative Chronologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(99,409,'TRB III/IV',32042,'relative Chronologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(100,411,'TRB V',32042,'relative Chronologie','Grab','Funde','Fritsch',NULL);
INSERT INTO "T_Datierung" VALUES(102,420,'Altm. Tiefstich',32080,'Typologie','Grab','Funde','Rinne','5.3.2012 00:00:00');
INSERT INTO "T_Datierung" VALUES(103,335,'Altm. Tiefstich',32080,'Typologie','Grab','Funde','Rinne','19.4.2013 00:00:00');
INSERT INTO "T_Datierung" VALUES(104,420,'Altm. Tiefstich, Düsedau',32080,'Typologie','Grab','Funde','Rinne','5.3.2012 00:00:00');
INSERT INTO "T_Datierung" VALUES(105,420,'Altm. Tiefstich, Haldensleben',32080,'Typologie','Grab','Funde','Rinne','5.3.2012 00:00:00');
INSERT INTO "T_Datierung" VALUES(106,298,'Altm. Tiefstich',32080,'Typologie','Hügel','Funde','Schwertfeger','12.6.2014 00:00:00');

/* Comment 
------------------------
 Table for the entrance documentation.
 "MegaID": 
"Lage": position in relation to the tomb
"EingangBeschr": description
"GradNord": direction of the entrance in degrees from North
 */
DROP TABLE IF EXISTS "T_Eingang";
CREATE TABLE "T_Eingang" (
"EingangID" INTEGER PRIMARY KEY AUTOINCREMENT, 
"MegaID" integer, 
"Lage" text, 
"EingangBeschr" text, 
"GradNord" integer,
FOREIGN KEY (MegaID) REFERENCES T_MegalitheDaten(MegaID)
);
INSERT INTO "T_Eingang" VALUES(1,55,'Langseite, mittig','Zugang mittig an Langseite',270);
INSERT INTO "T_Eingang" VALUES(3,97,'Schmalseite','Zugang an Schmalseite',0);
INSERT INTO "T_Eingang" VALUES(4,102,'Langseite, mittig','Gang mittig an Längsseite',90);
INSERT INTO "T_Eingang" VALUES(5,103,'Ecke','Gang an Ecke',135);
INSERT INTO "T_Eingang" VALUES(6,104,'Ecke','Gang an Ecke',135);
INSERT INTO "T_Eingang" VALUES(7,106,'Langseite, mittig','Gang mittig an Längsseite',NULL);
INSERT INTO "T_Eingang" VALUES(8,118,'Langseite, mittig','Gang mittig an Längsseite',180);
INSERT INTO "T_Eingang" VALUES(9,188,'Langseite, mittig','Gang mittig an Längsseite',270);
INSERT INTO "T_Eingang" VALUES(10,209,'Langseite,dezentral','Gang verschoben an Längsseite',135);
INSERT INTO "T_Eingang" VALUES(12,244,'Langseite, dezentral','zwei Gangsteine, in die östliche Hälfte verschoben',157);
INSERT INTO "T_Eingang" VALUES(13,251,'Langseite, dezentral','leicht nach Osten verschoben',180);
INSERT INTO "T_Eingang" VALUES(14,270,'Langseite, dezentral','langrechteckiger Gang, nach Osten verschoben',180);
INSERT INTO "T_Eingang" VALUES(15,296,'Langseite, mittig','aus einer Lücke zwischen den Standspuren auf der südlichen Langseite zu erschließen',180);
INSERT INTO "T_Eingang" VALUES(17,318,'Langseite, dezentral','nach Osten verschoben an der südlicher Längsseite',180);
INSERT INTO "T_Eingang" VALUES(19,327,'Langseite, dezentral','nur ein sicherer und ein vermuteter Gangstein, leicht dezentral nach Osten verschoben',135);
INSERT INTO "T_Eingang" VALUES(20,328,'Langseite, dezentral','leicht nach Osten versetz an der südlichen Längsseite',157);
INSERT INTO "T_Eingang" VALUES(21,330,'Langseite, dezentral','zwei große Gangsteine, leicht nach Osten verschoben',135);
INSERT INTO "T_Eingang" VALUES(23,375,'Langseite','Eingang an Langseite, schräg',180);
INSERT INTO "T_Eingang" VALUES(24,394,NULL,'Gang',225);
INSERT INTO "T_Eingang" VALUES(25,395,NULL,'Gang',270);
INSERT INTO "T_Eingang" VALUES(26,405,'Langseite','Eingang an Langseite',203);
INSERT INTO "T_Eingang" VALUES(28,411,'Langseite','Gang an Langseite',203);
INSERT INTO "T_Eingang" VALUES(29,413,'Schmalseite','Gang an Schmalseite',NULL);
INSERT INTO "T_Eingang" VALUES(32,326,'Langseite, mittig','aus einem Stein zu erschließen',135);
INSERT INTO "T_Eingang" VALUES(33,335,'Langseite, dezentral','leicht nach Westen verschoben auf der südlichen Langseite',180);
INSERT INTO "T_Eingang" VALUES(34,243,'Langseite','aus fehlenden Wandsteinen zu erschließen',157);
INSERT INTO "T_Eingang" VALUES(36,246,'Langseite, dezentral','muss dezentral liegen, da zentrale Kammersteine in situ',135);
INSERT INTO "T_Eingang" VALUES(37,265,'Südost Ecke','nur aus einer Lücke zu einem verkippten Wandstein zu erschließen',180);
INSERT INTO "T_Eingang" VALUES(38,295,'Schmalseite','offene Schmalseite, keine Standspur dokumentiert',90);
INSERT INTO "T_Eingang" VALUES(39,321,'Schmalseite','mit Schwelle und Verschlussstein',45);
INSERT INTO "T_Eingang" VALUES(41,313,'Südost Ecke','nur ein liegender Gangstein erhalten',135);
INSERT INTO "T_Eingang" VALUES(42,319,'Langseite, mittig','nur aus einer Lücke zwischen den Kammersteinen zu erschließen',135);
INSERT INTO "T_Eingang" VALUES(43,323,'zwischen Lang- und Schmalseite','nur aus fehlenden Steinen zu erschließen',225);
INSERT INTO "T_Eingang" VALUES(44,325,'Langseite, mittig','nur aus fehlende Kammersteine im mittleren Abschnitt zu erschließen',180);
INSERT INTO "T_Eingang" VALUES(45,256,'Südost Ecke','nur vermutet aufgrund einer deutlichen Lücke',135);
INSERT INTO "T_Eingang" VALUES(46,259,'Südost oder -west Ecke','schmaler Abschlussstein mit seitlichen Lücken',180);
INSERT INTO "T_Eingang" VALUES(47,262,'Südost Ecke','nur aus fehlenden Kammersteinen zu erschließen',135);
INSERT INTO "T_Eingang" VALUES(48,298,NULL,'fehlende Kammersteine und Keramik der Ausgrabung machen dies plausibel',180);
INSERT INTO "T_Eingang" VALUES(49,423,'Langseite, dezentral','vermutet anhand des einzigen erhaltenen Kammersteins mit auffällig planer Seite',180);
INSERT INTO "T_Eingang" VALUES(50,426,'Langseite','nur zu erschließen, da die nordwestliche Langseite fast vollständig und die Schmalseiten vollständig geschlossen sind',112);

/* Comment 
------------------------
 Table with estimated values for each megalith.
 "LDANR": Full identifier from the official numbering
"OANR":  Ortsakten Nummer, consecutive numbering in the local subdivision
"OAGEM": Ortsakten Gemarkung, local subdivision
"GRABGRUPPE": Number of the grave group in the text
"MASS": Dimension used for the estimation
"WERT": measured value for the Dimension
"GEWICHT": estimated weight based on the dimension value
"AZ": estimated work load in hours 
*/
DROP TABLE IF EXISTS "T_Graeber_Gewicht";
CREATE TABLE "T_Graeber_Gewicht" (
"MegaID" INTEGER, 
"LDANR" TEXT, 
"OANR" INTEGER, 
"OAGEM" TEXT, 
"GRABGRUPPE" INTEGER, 
"MASS" TEXT, 
"WERT" REAL, 
"GEWICHT" REAL, 
"AZ" INTEGER,
FOREIGN KEY (MegaID) REFERENCES T_MegalitheDaten(MegaID)
);
INSERT INTO "T_Graeber_Gewicht" VALUES(242,'Alv003',3,'Alv',3,'Länge Kammer innen',6.5,57.07,9100);
INSERT INTO "T_Graeber_Gewicht" VALUES(243,'Alv004',4,'Alv',3,'Länge Kammer innen',7.8,68.48,10920);
INSERT INTO "T_Graeber_Gewicht" VALUES(244,'Alv005',5,'Alv',3,'Länge Kammer innen',5.9,51.8,8260);
INSERT INTO "T_Graeber_Gewicht" VALUES(246,'Alv006',6,'Alv',3,'Länge Kammer innen',7.8,68.48,10920);
INSERT INTO "T_Graeber_Gewicht" VALUES(251,'Alv014',14,'Alv',3,'Länge Kammer innen',8.7,76.38,12180);
INSERT INTO "T_Graeber_Gewicht" VALUES(253,'Alv016',16,'Alv',3,'Länge Kammer innen',6.6,57.94,9240);
INSERT INTO "T_Graeber_Gewicht" VALUES(254,'Alv017',17,'Alv',3,'Länge Kammer innen',8.4,73.75,11760);
INSERT INTO "T_Graeber_Gewicht" VALUES(255,'Alv018',18,'Alv',2,'Länge Kammer innen',6,52.68,8400);
INSERT INTO "T_Graeber_Gewicht" VALUES(256,'Alv021',21,'Alv',2,'Länge Kammer innen',3.5,30.73,4900);
INSERT INTO "T_Graeber_Gewicht" VALUES(257,'Alv020',20,'Alv',2,'Länge Kammer innen',5.6,49.16,7840);
INSERT INTO "T_Graeber_Gewicht" VALUES(259,'Alv022',22,'Alv',2,'Länge Kammer innen',5.3,46.53,7420);
INSERT INTO "T_Graeber_Gewicht" VALUES(262,'Alv025',25,'Alv',2,'Länge Kammer innen',2.8,24.58,3920);
INSERT INTO "T_Graeber_Gewicht" VALUES(265,'Alv028',28,'Alv',2,'Länge Kammer innen',1.8,15.8,2520);
INSERT INTO "T_Graeber_Gewicht" VALUES(268,'Alv031',31,'Alv',2,'Länge Kammer innen',7.6,66.72,10640);
INSERT INTO "T_Graeber_Gewicht" VALUES(270,'Alv033',33,'Alv',3,'Länge Kammer innen',7.6,66.72,10640);
INSERT INTO "T_Graeber_Gewicht" VALUES(272,'Alv035',35,'Alv',3,'Länge Kammer innen',4.8,42.14,6720);
INSERT INTO "T_Graeber_Gewicht" VALUES(277,'Alv040',40,'Alv',1,'Länge Kammer innen',5,43.9,7000);
INSERT INTO "T_Graeber_Gewicht" VALUES(288,'Alv045',45,'Alv',1,'Länge Kammer innen',1.2,10.53,1680);
INSERT INTO "T_Graeber_Gewicht" VALUES(292,'Dön004',4,'Dön',1,'Länge Kammer innen',10.8,94.82,15120);
INSERT INTO "T_Graeber_Gewicht" VALUES(293,'Dön005',5,'Dön',1,'Länge Kammer innen',4,35.12,5600);
INSERT INTO "T_Graeber_Gewicht" VALUES(295,'Dön008',8,'Dön',1,'Länge Kammer innen',3.2,28.09,4480);
INSERT INTO "T_Graeber_Gewicht" VALUES(296,'Dön009',9,'Dön',1,'Länge Kammer innen',9.6,84.28,13440);
INSERT INTO "T_Graeber_Gewicht" VALUES(297,'Dön010',10,'Dön',1,'Länge Kammer innen',9.8,86.04,13720);
INSERT INTO "T_Graeber_Gewicht" VALUES(298,'Dön011',11,'Dön',1,'Länge Kammer innen',2.6,22.82,3640);
INSERT INTO "T_Graeber_Gewicht" VALUES(312,'AHa009',9,'AHa',0,'Länge Kammer innen',6.6,57.94,9240);
INSERT INTO "T_Graeber_Gewicht" VALUES(313,'AHa010',10,'AHa',0,'Länge Kammer innen',3.7,32.48,5180);
INSERT INTO "T_Graeber_Gewicht" VALUES(314,'AHa011',11,'AHa',4,'Länge Kammer innen',7,61.46,9800);
INSERT INTO "T_Graeber_Gewicht" VALUES(316,'AHa013',13,'AHa',4,'Länge Kammer innen',4.6,40.38,6440);
INSERT INTO "T_Graeber_Gewicht" VALUES(318,'AHa015',15,'AHa',4,'Länge Kammer innen',8.4,73.75,11760);
INSERT INTO "T_Graeber_Gewicht" VALUES(319,'AHa016',16,'AHa',4,'Länge Kammer innen',4.3,37.75,6020);
INSERT INTO "T_Graeber_Gewicht" VALUES(320,'AHa017',17,'AHa',4,'Länge Kammer innen',4.6,40.38,6440);
INSERT INTO "T_Graeber_Gewicht" VALUES(321,'AHa018',18,'AHa',4,'Länge Kammer innen',4.2,36.87,5880);
INSERT INTO "T_Graeber_Gewicht" VALUES(323,'AHa020',20,'AHa',4,'Länge Kammer innen',3.2,28.09,4480);
INSERT INTO "T_Graeber_Gewicht" VALUES(324,'AHa021',21,'AHa',4,'Länge Kammer innen',5,43.9,7000);
INSERT INTO "T_Graeber_Gewicht" VALUES(325,'AHa022',22,'AHa',4,'Länge Kammer innen',8.5,74.63,11900);
INSERT INTO "T_Graeber_Gewicht" VALUES(326,'AHa023',23,'AHa',4,'Länge Kammer innen',6.6,57.94,9240);
INSERT INTO "T_Graeber_Gewicht" VALUES(327,'AHa024',24,'AHa',4,'Länge Kammer innen',7.6,66.72,10640);
INSERT INTO "T_Graeber_Gewicht" VALUES(328,'AHa025',25,'AHa',4,'Länge Kammer innen',8.6,75.5,12040);
INSERT INTO "T_Graeber_Gewicht" VALUES(330,'AHa027',27,'AHa',4,'Länge Kammer innen',9.8,86.04,13720);
INSERT INTO "T_Graeber_Gewicht" VALUES(333,'Hun006',6,'Hun',0,'Länge Kammer innen',12,105.36,16800);
INSERT INTO "T_Graeber_Gewicht" VALUES(335,'Hun014',14,'Hun',5,'Länge Kammer innen',9.3,81.65,13020);
INSERT INTO "T_Graeber_Gewicht" VALUES(337,'Hun016',16,'Hun',4,'Länge Kammer innen',8.8,77.26,12320);
INSERT INTO "T_Graeber_Gewicht" VALUES(340,'Hun019',19,'Hun',3,'Länge Kammer innen',5,43.9,7000);
INSERT INTO "T_Graeber_Gewicht" VALUES(422,'Emd012',12,'Emd',0,'Länge Kammer innen',6,52.68,8400);
INSERT INTO "T_Graeber_Gewicht" VALUES(426,'Süp001',1,'Süp',4,'Länge Kammer innen',8.1,71.11,11340);

/* Comment 
------------------------
 Table for the orientation of the megaliths.
 Data partly created in a gis based on a DEM (s. text).
 "LDANR": Full identifier from the official numbering
"OANR":  Ortsakten Nummer, consecutive numbering in the local subdivision
"OAGEM": Ortsakten Gemarkung, local subdivision
"GRABGRUPPE": Number of the grave group in the text
"GRADNORD": Orientation of the tomb in degrees from North
"UMFASSUNG": form of the surrounding
"GRABTYP": type of the tomb
"TOPOASPECT": aspect of the topografy at the site
"TOPOSLOPE": slope a the site 
"EINGANGHYP": (hypothetical) orientation of the entrance 
 */
DROP TABLE IF EXISTS "T_Graeber_Orient";
CREATE TABLE "T_Graeber_Orient" (
"MegaID" INTEGER,
 "LDANR" TEXT,
 "OANR" INTEGER,
 "OAGEM" TEXT,
 "GRABGRUPPE" INTEGER,
 "GRADNORD" INTEGER,
 "UMFASSUNG" TEXT,
 "GRABTYP" TEXT,
 "TOPOASPECT" INTEGER,
 "TOPOSLOPE" REAL,
 "EINGANGHYP" INTEGER,
 FOREIGN KEY (MegaID) REFERENCES T_MegalitheDaten(MegaID)
);
INSERT INTO "T_Graeber_Orient" VALUES(242,'Alv003',3,'Alv',3,90,'rechteckig','Ganggrab',294,2.24,180);
INSERT INTO "T_Graeber_Orient" VALUES(243,'Alv004',4,'Alv',3,67,'trapezförmig','Ganggrab',291,1.76,157);
INSERT INTO "T_Graeber_Orient" VALUES(244,'Alv005',5,'Alv',3,67,'rechteckig','Ganggrab',-1,0.83,157);
INSERT INTO "T_Graeber_Orient" VALUES(246,'Alv006',6,'Alv',3,45,'rechteckig','Ganggrab',178,1.14,135);
INSERT INTO "T_Graeber_Orient" VALUES(247,'Alv010',10,'Alv',3,90,NULL,'Megalithgrab',181,1.88,180);
INSERT INTO "T_Graeber_Orient" VALUES(248,'Alv011',11,'Alv',3,0,'k. A.','Megalithgrab',190,1.63,90);
INSERT INTO "T_Graeber_Orient" VALUES(249,'Alv012',12,'Alv',0,-1,'ohne Umfassung','Grabhügel',100,1.45,-1);
INSERT INTO "T_Graeber_Orient" VALUES(250,'Alv013',13,'Alv',3,0,'ohne Umfassung','Megalithgrab',221,1.94,90);
INSERT INTO "T_Graeber_Orient" VALUES(251,'Alv014',14,'Alv',3,90,'trapezförmig','Ganggrab',201,1.76,180);
INSERT INTO "T_Graeber_Orient" VALUES(252,'Alv015',15,'Alv',3,45,'vorhanden','Megalithgrab',188,1.6,135);
INSERT INTO "T_Graeber_Orient" VALUES(253,'Alv016',16,'Alv',3,135,'vorhanden','Ganggrab',220,1.29,225);
INSERT INTO "T_Graeber_Orient" VALUES(254,'Alv017',17,'Alv',3,45,'vorhanden','Ganggrab',217,2.22,135);
INSERT INTO "T_Graeber_Orient" VALUES(255,'Alv018',18,'Alv',2,0,'vorhanden','Ganggrab',-1,0.59,90);
INSERT INTO "T_Graeber_Orient" VALUES(256,'Alv021',21,'Alv',2,0,NULL,'Dolmen',-1,0.62,135);
INSERT INTO "T_Graeber_Orient" VALUES(257,'Alv020',20,'Alv',2,67,'vorhanden','Ganggrab',308,1.01,157);
INSERT INTO "T_Graeber_Orient" VALUES(258,'Alv019',19,'Alv',2,45,'ohne Umfassung','Dolmen',-1,0.92,-1);
INSERT INTO "T_Graeber_Orient" VALUES(259,'Alv022',22,'Alv',2,0,'ohne Umfassung','Dolmen',298,1.05,180);
INSERT INTO "T_Graeber_Orient" VALUES(260,'Alv023',23,'Alv',2,292,'vorhanden','Ganggrab',285,1.33,382);
INSERT INTO "T_Graeber_Orient" VALUES(261,'Alv024',24,'Alv',1,90,'vorhanden','Megalithgrab',71,9.12,180);
INSERT INTO "T_Graeber_Orient" VALUES(262,'Alv025',25,'Alv',2,45,'k. A.','Dolmen',251,1.28,135);
INSERT INTO "T_Graeber_Orient" VALUES(263,'Alv026',26,'Alv',2,-1,'k. A.','Megalithgrab',283,3.74,-1);
INSERT INTO "T_Graeber_Orient" VALUES(264,'Alv027',27,'Alv',2,315,'k. A.','Megalithgrab',231,3.4,405);
INSERT INTO "T_Graeber_Orient" VALUES(265,'Alv028',28,'Alv',2,-1,'k. A.','erweiterter Dolmen',215,2.91,-1);
INSERT INTO "T_Graeber_Orient" VALUES(266,'Alv029',29,'Alv',2,-1,'k. A.','Dolmen',115,1.28,-1);
INSERT INTO "T_Graeber_Orient" VALUES(267,'Alv030',30,'Alv',2,-1,'k. A.','Dolmen',222,1.72,-1);
INSERT INTO "T_Graeber_Orient" VALUES(268,'Alv031',31,'Alv',2,45,'vorhanden','Ganggrab',150,3.93,135);
INSERT INTO "T_Graeber_Orient" VALUES(269,'Alv032',32,'Alv',0,-1,'k. A.','Megalithgrab',-1,0.62,-1);
INSERT INTO "T_Graeber_Orient" VALUES(270,'Alv033',33,'Alv',3,90,'trapezförmig','Ganggrab',-1,0.78,180);
INSERT INTO "T_Graeber_Orient" VALUES(271,'Alv034',34,'Alv',3,67,'vorhanden','Megalithgrab',174,1.57,157);
INSERT INTO "T_Graeber_Orient" VALUES(272,'Alv035',35,'Alv',3,22,NULL,'Ganggrab',97,3.45,112);
INSERT INTO "T_Graeber_Orient" VALUES(273,'Alv036',36,'Alv',0,-1,'k. A.',NULL,117,2.11,-1);
INSERT INTO "T_Graeber_Orient" VALUES(274,'Alv037',37,'Alv',0,-1,'k. A.',NULL,205,1.66,-1);
INSERT INTO "T_Graeber_Orient" VALUES(275,'Alv038',38,'Alv',0,-1,'k. A.','sonstige Steine',188,4.5,-1);
INSERT INTO "T_Graeber_Orient" VALUES(276,'Alv039',39,'Alv',1,90,'k. A.','Megalithgrab',247,4.46,180);
INSERT INTO "T_Graeber_Orient" VALUES(277,'Alv040',40,'Alv',1,270,'ja','Ganggrab',266,7.06,360);
INSERT INTO "T_Graeber_Orient" VALUES(284,'Alv041',41,'Alv',1,22,'k. A.','Ganggrab',160,3.32,112);
INSERT INTO "T_Graeber_Orient" VALUES(285,'Alv042',42,'Alv',1,292,'k. A.','Ganggrab',68,13.96,382);
INSERT INTO "T_Graeber_Orient" VALUES(286,'Alv043',43,'Alv',1,-1,'k. A.','Megalithgrab',82,16.1,-1);
INSERT INTO "T_Graeber_Orient" VALUES(287,'Alv044',44,'Alv',1,315,'k. A.','Ganggrab',134,3.03,405);
INSERT INTO "T_Graeber_Orient" VALUES(288,'Alv045',45,'Alv',1,-1,'k. A.','Dolmen',152,2.12,-1);
INSERT INTO "T_Graeber_Orient" VALUES(289,'Alv046',46,'Alv',3,90,'k. A.','Megalithgrab',163,2.29,180);
INSERT INTO "T_Graeber_Orient" VALUES(290,'Alv047',47,'Alv',1,-1,'k. A.','Megalithgrab',192,5.12,-1);
INSERT INTO "T_Graeber_Orient" VALUES(291,'Alv048',48,'Alv',1,-1,'k. A.','Megalithgrab',271,4.84,-1);
INSERT INTO "T_Graeber_Orient" VALUES(292,'Dön004',4,'Dön',1,292,'trapezförmig','Ganggrab',275,1.3,382);
INSERT INTO "T_Graeber_Orient" VALUES(293,'Dön005',5,'Dön',1,90,'rechteckig','Ganggrab',329,17.19,180);
INSERT INTO "T_Graeber_Orient" VALUES(294,'Dön007',7,'Dön',1,-1,'k. A.','Megalithgrab',276,7.28,-1);
INSERT INTO "T_Graeber_Orient" VALUES(295,'Dön008',8,'Dön',1,90,'keine','Dolmen',92,15.22,90);
INSERT INTO "T_Graeber_Orient" VALUES(296,'Dön009',9,'Dön',1,90,'vorhanden','Ganggrab',77,10.56,180);
INSERT INTO "T_Graeber_Orient" VALUES(297,'Dön010',10,'Dön',1,90,'ohne Umfassung','Ganggrab',61,1.51,180);
INSERT INTO "T_Graeber_Orient" VALUES(298,'Dön011',11,'Dön',1,45,'ja','Dolmen',254,3,180);
INSERT INTO "T_Graeber_Orient" VALUES(299,'Dön012',12,'Dön',1,-1,'k. A.','Megalithgrab',137,11.66,-1);
INSERT INTO "T_Graeber_Orient" VALUES(300,'Dön013',13,'Dön',1,247,'k. A.','Megalithgrab',168,10.49,337);
INSERT INTO "T_Graeber_Orient" VALUES(301,'Dön014',14,'Dön',1,-1,'k. A.','Megalithgrab',125,1.3,-1);
INSERT INTO "T_Graeber_Orient" VALUES(302,'Dön015',15,'Dön',0,-1,'k. A.','Megalithgrab',130,1.5,-1);
INSERT INTO "T_Graeber_Orient" VALUES(303,'Bod001',1,'Bod',0,-1,'k. A.','Megalithgrab',-1,0.88,-1);
INSERT INTO "T_Graeber_Orient" VALUES(307,'NHa009',9,'NHa',0,-1,'k. A.','Megalithgrab',-1,0.95,-1);
INSERT INTO "T_Graeber_Orient" VALUES(308,'NHa010',10,'NHa',0,-1,'k. A.',NULL,86,2.53,-1);
INSERT INTO "T_Graeber_Orient" VALUES(309,'NHa011',11,'NHa',4,-1,'k. A.','Megalithgrab',168,1.19,-1);
INSERT INTO "T_Graeber_Orient" VALUES(310,'NHa012',12,'NHa',4,-1,'k. A.','Megalithgrab',-1,0.85,-1);
INSERT INTO "T_Graeber_Orient" VALUES(311,'AHa008',8,'AHa',0,-1,'k. A.','Flachgrab?',97,1.2,-1);
INSERT INTO "T_Graeber_Orient" VALUES(312,'AHa009',9,'AHa',0,90,'k. A.','Megalithgrab',156,1.17,180);
INSERT INTO "T_Graeber_Orient" VALUES(313,'AHa010',10,'AHa',0,90,'k. A.','erweiterter Dolmen',126,1.59,135);
INSERT INTO "T_Graeber_Orient" VALUES(314,'AHa011',11,'AHa',4,337,'zerstört. wahrscheinlich','Megalithgrab',63,2.72,427);
INSERT INTO "T_Graeber_Orient" VALUES(315,'AHa012',12,'AHa',0,-1,'k. A.',NULL,67,1.04,-1);
INSERT INTO "T_Graeber_Orient" VALUES(316,'AHa013',13,'AHa',4,45,'vorhanden','Ganggrab',-1,0.94,135);
INSERT INTO "T_Graeber_Orient" VALUES(317,'AHa014',14,'AHa',4,45,'vorhanden','Megalithgrab',41,1.81,135);
INSERT INTO "T_Graeber_Orient" VALUES(318,'AHa015',15,'AHa',4,90,'vorhanden','Ganggrab',107,1,180);
INSERT INTO "T_Graeber_Orient" VALUES(319,'AHa016',16,'AHa',4,45,'vorhanden','Ganggrab',-1,0.37,135);
INSERT INTO "T_Graeber_Orient" VALUES(320,'AHa017',17,'AHa',4,45,'k. A.','Megalithgrab',165,2.18,135);
INSERT INTO "T_Graeber_Orient" VALUES(321,'AHa018',18,'AHa',4,45,'keine','Großdolmen',212,1.66,45);
INSERT INTO "T_Graeber_Orient" VALUES(322,'AHa019',19,'AHa',4,90,'rechteckig','Ganggrab',242,2.04,180);
INSERT INTO "T_Graeber_Orient" VALUES(323,'AHa020',20,'AHa',4,112,'Steineinfassung möglich','Großdolmen',218,1.02,225);
INSERT INTO "T_Graeber_Orient" VALUES(324,'AHa021',21,'AHa',4,45,'vorhanden','Ganggrab',-1,0.78,135);
INSERT INTO "T_Graeber_Orient" VALUES(325,'AHa022',22,'AHa',4,90,'ohne Umfassung','Ganggrab',232,2.29,180);
INSERT INTO "T_Graeber_Orient" VALUES(326,'AHa023',23,'AHa',4,45,'vorhanden','Ganggrab',190,1.14,135);
INSERT INTO "T_Graeber_Orient" VALUES(327,'AHa024',24,'AHa',4,45,'rechteckig','Ganggrab',-1,0.92,135);
INSERT INTO "T_Graeber_Orient" VALUES(328,'AHa025',25,'AHa',4,67,'vorhanden','Ganggrab',-1,0.55,157);
INSERT INTO "T_Graeber_Orient" VALUES(329,'AHa026',26,'AHa',4,0,'vorhanden','Megalithgrab',-1,0.76,90);
INSERT INTO "T_Graeber_Orient" VALUES(330,'AHa027',27,'AHa',4,247,'leicht trapezförmig','Ganggrab',308,2.1,135);
INSERT INTO "T_Graeber_Orient" VALUES(331,'AHa028',28,'AHa',0,45,'vorhanden','Megalithgrab',116,1.91,135);
INSERT INTO "T_Graeber_Orient" VALUES(332,'AHa029',29,'AHa',0,-1,'k. A.','Megalithgrab',121,1.63,-1);
INSERT INTO "T_Graeber_Orient" VALUES(333,'Hun006',6,'Hun',0,315,'vorhanden','Dolmen',-1,0.65,-1);
INSERT INTO "T_Graeber_Orient" VALUES(335,'Hun014',14,'Hun',5,90,'vorhanden','Ganggrab',165,2,180);
INSERT INTO "T_Graeber_Orient" VALUES(337,'Hun016',16,'Hun',4,22,'Umfassung fraglich','Ganggrab',286,2.18,112);
INSERT INTO "T_Graeber_Orient" VALUES(338,'Hun017',17,'Hun',3,45,'ohne Umfassung','Dolmen',172,1.37,-1);
INSERT INTO "T_Graeber_Orient" VALUES(339,'Hun018',18,'Hun',3,0,'ohne Umfassung','Dolmen',283,1.31,-1);
INSERT INTO "T_Graeber_Orient" VALUES(340,'Hun019',19,'Hun',3,67,'vorhanden','Megalithgrab',310,3.44,157);
INSERT INTO "T_Graeber_Orient" VALUES(341,'Hun020',20,'Hun',2,-1,'k. A.','Megalithgrab',87,1.54,-1);
INSERT INTO "T_Graeber_Orient" VALUES(342,'Hun021',21,'Hun',2,225,'k. A.','Megalithgrab',38,1.22,315);
INSERT INTO "T_Graeber_Orient" VALUES(344,'Süp002',2,'Süp',4,45,'k. A.','Megalithgrab',268,4.99,135);
INSERT INTO "T_Graeber_Orient" VALUES(345,'Süp003',3,'Süp',0,-1,'k. A.','Megalithgrab',43,1.05,-1);
INSERT INTO "T_Graeber_Orient" VALUES(346,'Süp004',4,'Süp',0,-1,'k. A.','Megalithgrab',75,2.52,-1);
INSERT INTO "T_Graeber_Orient" VALUES(347,'Süp006',6,'Süp',4,22,'ohne Umfassung','Megalithgrab',275,6.7,112);
INSERT INTO "T_Graeber_Orient" VALUES(418,'AHa033',33,'AHa',5,90,'vorhanden','Megalithgrab',319,3.53,180);
INSERT INTO "T_Graeber_Orient" VALUES(419,'AHa031',31,'AHa',5,-1,'k. A.','Megalithgrab',281,2.96,-1);
INSERT INTO "T_Graeber_Orient" VALUES(420,'AHa034',34,'AHa',5,90,'k. A.','Megalithgrab',119,3.95,180);
INSERT INTO "T_Graeber_Orient" VALUES(421,'AHa032',32,'AHa',5,-1,'k. A.','Megalithgrab',262,1.53,-1);
INSERT INTO "T_Graeber_Orient" VALUES(422,'Emd012',12,'Emd',0,90,'vorhanden','Ganggrab',4,2.44,180);
INSERT INTO "T_Graeber_Orient" VALUES(423,'Hun022',22,'Hun',2,90,'vorhanden','Ganggrab',138,4.58,180);
INSERT INTO "T_Graeber_Orient" VALUES(426,'Süp001',1,'Süp',4,45,'vorhanden','Ganggrab',325,1.86,112);
INSERT INTO "T_Graeber_Orient" VALUES(427,'AHa002',2,'AHa',0,-1,'k. A.',NULL,-1,0.88,-1);
INSERT INTO "T_Graeber_Orient" VALUES(428,'AHa001',1,'AHa',0,-1,'ohne Umfassung','Menhir',216,2.33,-1);
INSERT INTO "T_Graeber_Orient" VALUES(430,'Dön016',16,'Dön',0,-1,'k. A.','Megalithgrab',136,1.1,-1);
INSERT INTO "T_Graeber_Orient" VALUES(431,'Dön017',17,'Dön',0,-1,'k. A.','Megalithgrab',115,1.03,-1);
INSERT INTO "T_Graeber_Orient" VALUES(432,'Dön018',18,'Dön',0,-1,'k. A.','Megalithgrab',-1,0.41,-1);
INSERT INTO "T_Graeber_Orient" VALUES(433,'Dön019',19,'Dön',1,-1,'k. A.','Megalithgrab',94,2.46,-1);
INSERT INTO "T_Graeber_Orient" VALUES(434,'Dön020',20,'Dön',1,-1,'k. A.','Megalithgrab',-1,0.86,-1);
INSERT INTO "T_Graeber_Orient" VALUES(435,'Dön021',21,'Dön',1,67,'k. A.','Megalithgrab',187,13.29,157);
INSERT INTO "T_Graeber_Orient" VALUES(436,'Hun025',25,'Hun',5,-1,'k. A.','Megalithgrab',143,1.1,-1);
INSERT INTO "T_Graeber_Orient" VALUES(437,'Hun024',24,'Hun',5,-1,'k. A.','Megalithgrab',165,2.55,-1);
INSERT INTO "T_Graeber_Orient" VALUES(438,'Emd015',15,'Emd',0,-1,'k. A.','Megalithgrab',272,1.87,-1);
INSERT INTO "T_Graeber_Orient" VALUES(439,'Emd016',16,'Emd',0,-1,'k. A.','Megalithgrab',85,1.94,-1);
INSERT INTO "T_Graeber_Orient" VALUES(440,'Emd017',17,'Emd',0,-1,'k. A.','Megalithgrab',-1,0.99,-1);
INSERT INTO "T_Graeber_Orient" VALUES(441,'AHa030',30,'AHa',0,-1,'k. A.','Megalithgrab',-1,0.63,-1);
INSERT INTO "T_Graeber_Orient" VALUES(445,'Hun028',28,'Hun',0,-1,'k. A.','Megalithgrab',107,1.07,-1);
INSERT INTO "T_Graeber_Orient" VALUES(446,'Hun029',29,'Hun',0,-1,'k. A.','Megalithgrab',190,2.31,-1);
INSERT INTO "T_Graeber_Orient" VALUES(449,'Alv052',52,'Alv',1,-1,'k. A.','Megalithgrab',118,6.37,-1);
INSERT INTO "T_Graeber_Orient" VALUES(450,'Emd044',44,'Emd',0,-1,'k. A.','Megalithgrab',254,1.63,-1);
INSERT INTO "T_Graeber_Orient" VALUES(451,'Emd045',45,'Emd',0,-1,'k. A.','Megalithgrab',332,3.51,-1);
INSERT INTO "T_Graeber_Orient" VALUES(453,'Hun023',23,'Hun',2,-1,'k. A.','Megalithgrab',213,1.87,-1);
INSERT INTO "T_Graeber_Orient" VALUES(454,'Hun030',30,'Hun',5,-1,'k. A.','Megalithgrab',-1,0.28,-1);
INSERT INTO "T_Graeber_Orient" VALUES(455,'Hun035',35,'Hun',0,-1,'k. A.','Megalithgrab',11,1.1,-1);
INSERT INTO "T_Graeber_Orient" VALUES(456,'Hun037',37,'Hun',0,-1,'k. A.','Megalithgrab',261,1.06,-1);
INSERT INTO "T_Graeber_Orient" VALUES(507,'Hun026',26,'Hun',0,-1,'k. A.','Megalithgrab',132,1.54,-1);
INSERT INTO "T_Graeber_Orient" VALUES(508,'Hun027',27,'Hun',0,-1,'k. A.','Megalithgrab',239,1.14,-1);

/* Comment 
------------------------
Table with coordinates for each site. 
"LDANR": Full identifier from the official numbering
"OANR":  Ortsakten Nummer, consecutive numbering in the local subdivision
"OAGEM": Ortsakten Gemarkung, local subdivision
"x": x DHDN GK zone 4, EPSG 31468
"y": y DHDN GK zone 4, EPSG 31468 
"lat": latitude, decimal degree WGS 84
"lng": longitude, decimal degree WGS 84
"GRABGRUPPE": Number of the grave group in the text
 */
DROP TABLE IF EXISTS "T_Graeber_pt";
CREATE TABLE "T_Graeber_pt" (
"ID" INTEGER PRIMARY KEY  NOT NULL  UNIQUE , 
"MegaID" INTEGER, 
"LDANr" TEXT, 
"OANr" INTEGER, 
"OAGem" TEXT, 
"x" INTEGER, 
"y" INTEGER, 
"lat" REAL, 
"lng" REAL, 
"Grabgruppe" INTEGER,
FOREIGN KEY (MegaID) REFERENCES T_MegalitheDaten(MegaID)
);
INSERT INTO "T_Graeber_pt" VALUES(94,242,'Alv003',3,'Alv',4455460,5793391,52.27219,11.34598,3);
INSERT INTO "T_Graeber_pt" VALUES(95,243,'Alv004',4,'Alv',4455511,5793399,52.27227,11.34672,3);
INSERT INTO "T_Graeber_pt" VALUES(96,244,'Alv005',5,'Alv',4455592,5793414,52.27241,11.3479,3);
INSERT INTO "T_Graeber_pt" VALUES(98,246,'Alv006',6,'Alv',4455599,5793306,52.27144,11.34802,3);
INSERT INTO "T_Graeber_pt" VALUES(99,247,'Alv010',10,'Alv',4455505,5793222,52.27068,11.34665,3);
INSERT INTO "T_Graeber_pt" VALUES(100,248,'Alv011',11,'Alv',4455488,5793230,52.27075,11.3464,3);
INSERT INTO "T_Graeber_pt" VALUES(101,249,'Alv012',12,'Alv',4455930,5793360,52.27195,11.35286,NULL);
INSERT INTO "T_Graeber_pt" VALUES(102,250,'Alv013',13,'Alv',4455975,5793240,52.27088,11.35353,3);
INSERT INTO "T_Graeber_pt" VALUES(135,335,'Hun014',14,'Hun',4458240,5792579,52.26511,11.38679,5);
INSERT INTO "T_Graeber_pt" VALUES(136,337,'Hun016',16,'Hun',4456584,5793370,52.27209,11.36244,4);
INSERT INTO "T_Graeber_pt" VALUES(137,338,'Hun017',17,'Hun',4456186,5793501,52.27324,11.35659,3);
INSERT INTO "T_Graeber_pt" VALUES(138,339,'Hun018',18,'Hun',4456090,5793360,52.27196,11.3552,3);
INSERT INTO "T_Graeber_pt" VALUES(139,340,'Hun019',19,'Hun',4455830,5793627,52.27434,11.35136,3);
INSERT INTO "T_Graeber_pt" VALUES(140,341,'Hun020',20,'Hun',4456595,5792870,52.2676,11.36266,2);
INSERT INTO "T_Graeber_pt" VALUES(141,342,'Hun021',21,'Hun',4456795,5792818,52.26715,11.3656,2);
INSERT INTO "T_Graeber_pt" VALUES(142,344,'Süp002',2,'Süp',4456045,5794859,52.28543,11.35435,4);
INSERT INTO "T_Graeber_pt" VALUES(143,345,'Süp003',3,'Süp',4455493,5795303,52.28938,11.3462,NULL);
INSERT INTO "T_Graeber_pt" VALUES(144,346,'Süp004',4,'Süp',4455618,5795327,52.2896,11.34803,NULL);
INSERT INTO "T_Graeber_pt" VALUES(145,347,'Süp006',6,'Süp',4456114,5794973,52.28646,11.35535,4);
INSERT INTO "T_Graeber_pt" VALUES(166,373,'Blä001',1,'Blä',4478140,5805190,52.3796,11.67745,NULL);
INSERT INTO "T_Graeber_pt" VALUES(167,374,'Crö001',1,'Crö',4476680,5806280,52.38933,11.65594,NULL);
INSERT INTO "T_Graeber_pt" VALUES(169,376,'Mos004',4,'Mos',4473600,5793160,52.27129,11.61173,NULL);
INSERT INTO "T_Graeber_pt" VALUES(170,377,'Mos003',3,'Mos',4475200,5793560,52.27495,11.63514,NULL);
INSERT INTO "T_Graeber_pt" VALUES(171,378,'Mos002',2,'Mos',4473560,5793730,52.27641,11.6111,NULL);
INSERT INTO "T_Graeber_pt" VALUES(175,251,'Alv014',14,'Alv',4455280,5793330,52.27163,11.34334,3);
INSERT INTO "T_Graeber_pt" VALUES(176,252,'Alv015',15,'Alv',4455200,5793305,52.2714,11.34217,3);
INSERT INTO "T_Graeber_pt" VALUES(177,253,'Alv016',16,'Alv',4455305,5793245,52.27087,11.34372,3);
INSERT INTO "T_Graeber_pt" VALUES(178,254,'Alv017',17,'Alv',4455350,5793060,52.26921,11.3444,3);
INSERT INTO "T_Graeber_pt" VALUES(179,255,'Alv018',18,'Alv',4455536,5792657,52.2656,11.34718,2);
INSERT INTO "T_Graeber_pt" VALUES(180,256,'Alv021',21,'Alv',4455480,5792618,52.26525,11.34637,2);
INSERT INTO "T_Graeber_pt" VALUES(181,257,'Alv020',20,'Alv',4455505,5792527,52.26443,11.34674,2);
INSERT INTO "T_Graeber_pt" VALUES(182,258,'Alv019',19,'Alv',4455530,5792592,52.26502,11.3471,2);
INSERT INTO "T_Graeber_pt" VALUES(183,259,'Alv022',22,'Alv',4455460,5792480,52.264,11.34609,2);
INSERT INTO "T_Graeber_pt" VALUES(184,260,'Alv023',23,'Alv',4455492,5792391,52.26321,11.34657,2);
INSERT INTO "T_Graeber_pt" VALUES(185,261,'Alv024',24,'Alv',4454406,5791288,52.25321,11.33081,1);
INSERT INTO "T_Graeber_pt" VALUES(186,262,'Alv025',25,'Alv',4455455,5792225,52.26171,11.34605,2);
INSERT INTO "T_Graeber_pt" VALUES(279,263,'Alv026',26,'Alv',4455310,5791910,52.25887,11.34397,2);
INSERT INTO "T_Graeber_pt" VALUES(280,264,'Alv027',27,'Alv',4455370,5791844,52.25828,11.34486,2);
INSERT INTO "T_Graeber_pt" VALUES(281,265,'Alv028',28,'Alv',4455426,5791835,52.25821,11.34568,2);
INSERT INTO "T_Graeber_pt" VALUES(282,266,'Alv029',29,'Alv',4455892,5791884,52.25868,11.3525,2);
INSERT INTO "T_Graeber_pt" VALUES(283,267,'Alv030',30,'Alv',4455578,5791710,52.25709,11.34792,2);
INSERT INTO "T_Graeber_pt" VALUES(284,268,'Alv031',31,'Alv',4456084,5791774,52.25771,11.35532,2);
INSERT INTO "T_Graeber_pt" VALUES(285,269,'Alv032',32,'Alv',4455705,5791035,52.25104,11.34987,NULL);
INSERT INTO "T_Graeber_pt" VALUES(286,270,'Alv033',33,'Alv',4455428,5793679,52.27478,11.34546,3);
INSERT INTO "T_Graeber_pt" VALUES(287,271,'Alv034',34,'Alv',4455355,5793915,52.27689,11.34436,3);
INSERT INTO "T_Graeber_pt" VALUES(288,272,'Alv035',35,'Alv',4455077,5794274,52.2801,11.34024,3);
INSERT INTO "T_Graeber_pt" VALUES(289,273,'Alv036',36,'Alv',4454575,5793040,52.26896,11.33305,NULL);
INSERT INTO "T_Graeber_pt" VALUES(290,274,'Alv037',37,'Alv',4454610,5793015,52.26874,11.33357,NULL);
INSERT INTO "T_Graeber_pt" VALUES(291,275,'Alv038',38,'Alv',4454555,5792790,52.26672,11.33279,NULL);
INSERT INTO "T_Graeber_pt" VALUES(292,276,'Alv039',39,'Alv',4454516,5792361,52.26286,11.33228,1);
INSERT INTO "T_Graeber_pt" VALUES(293,277,'Alv040',40,'Alv',4454591,5792386,52.26309,11.33338,1);
INSERT INTO "T_Graeber_pt" VALUES(299,284,'Alv041',41,'Alv',4454095,5791925,52.25891,11.32617,1);
INSERT INTO "T_Graeber_pt" VALUES(300,285,'Alv042',42,'Alv',4454510,5791736,52.25724,11.33228,1);
INSERT INTO "T_Graeber_pt" VALUES(301,286,'Alv043',43,'Alv',4454436,5791863,52.25838,11.33118,1);
INSERT INTO "T_Graeber_pt" VALUES(302,287,'Alv044',44,'Alv',4453410,5792000,52.25952,11.31613,1);
INSERT INTO "T_Graeber_pt" VALUES(303,288,'Alv045',45,'Alv',4453555,5792125,52.26066,11.31824,1);
INSERT INTO "T_Graeber_pt" VALUES(304,289,'Alv046',46,'Alv',4455535,5793165,52.27017,11.3471,3);
INSERT INTO "T_Graeber_pt" VALUES(305,290,'Alv047',47,'Alv',4454395,5792838,52.26713,11.33044,1);
INSERT INTO "T_Graeber_pt" VALUES(306,291,'Alv048',48,'Alv',4454617,5792510,52.26421,11.33374,1);
INSERT INTO "T_Graeber_pt" VALUES(307,292,'Dön004',4,'Dön',4454855,5792205,52.26148,11.33727,1);
INSERT INTO "T_Graeber_pt" VALUES(308,293,'Dön005',5,'Dön',4454680,5791260,52.25298,11.33483,1);
INSERT INTO "T_Graeber_pt" VALUES(309,294,'Dön007',7,'Dön',4454691,5792410,52.26331,11.33484,1);
INSERT INTO "T_Graeber_pt" VALUES(310,295,'Dön008',8,'Dön',4454531,5791336,52.25365,11.33264,1);
INSERT INTO "T_Graeber_pt" VALUES(311,296,'Dön009',9,'Dön',4454581,5791311,52.25343,11.33337,1);
INSERT INTO "T_Graeber_pt" VALUES(312,297,'Dön010',10,'Dön',4455267,5791372,52.25403,11.34341,1);
INSERT INTO "T_Graeber_pt" VALUES(313,298,'Dön011',11,'Dön',4454685,5790985,52.25051,11.33494,1);
INSERT INTO "T_Graeber_pt" VALUES(314,299,'Dön012',12,'Dön',4454557,5791411,52.25432,11.33301,1);
INSERT INTO "T_Graeber_pt" VALUES(315,300,'Dön013',13,'Dön',4454607,5791385,52.2541,11.33374,1);
INSERT INTO "T_Graeber_pt" VALUES(316,301,'Dön014',14,'Dön',4454265,5790525,52.24634,11.32885,1);
INSERT INTO "T_Graeber_pt" VALUES(317,302,'Dön015',15,'Dön',4455949,5790574,52.24692,11.3535,NULL);
INSERT INTO "T_Graeber_pt" VALUES(318,303,'Bod001',1,'Bod',4452940,5795078,52.28714,11.30882,NULL);
INSERT INTO "T_Graeber_pt" VALUES(321,307,'NHa009',9,'NHa',4457040,5795610,52.29226,11.36883,NULL);
INSERT INTO "T_Graeber_pt" VALUES(322,308,'NHa010',10,'NHa',4457330,5795675,52.29286,11.37307,NULL);
INSERT INTO "T_Graeber_pt" VALUES(323,309,'NHa011',11,'NHa',4456850,5794815,52.2851,11.36615,4);
INSERT INTO "T_Graeber_pt" VALUES(324,310,'NHa012',12,'NHa',4456962,5794742,52.28445,11.3678,4);
INSERT INTO "T_Graeber_pt" VALUES(325,311,'AHa008',8,'AHa',4457219,5792752,52.26659,11.37182,NULL);
INSERT INTO "T_Graeber_pt" VALUES(326,312,'AHa009',9,'AHa',4458755,5793469,52.27315,11.39423,NULL);
INSERT INTO "T_Graeber_pt" VALUES(327,313,'AHa010',10,'AHa',4458030,5793700,52.27517,11.38358,NULL);
INSERT INTO "T_Graeber_pt" VALUES(328,314,'AHa011',11,'AHa',4457470,5793548,52.27376,11.37539,4);
INSERT INTO "T_Graeber_pt" VALUES(329,315,'AHa012',12,'AHa',4457433,5793533,52.27362,11.37486,NULL);
INSERT INTO "T_Graeber_pt" VALUES(330,316,'AHa013',13,'AHa',4457428,5793530,52.2736,11.37479,4);
INSERT INTO "T_Graeber_pt" VALUES(331,317,'AHa014',14,'AHa',4457254,5793574,52.27398,11.37223,4);
INSERT INTO "T_Graeber_pt" VALUES(332,318,'AHa015',15,'AHa',4456901,5793453,52.27286,11.36708,4);
INSERT INTO "T_Graeber_pt" VALUES(333,319,'AHa016',16,'AHa',4456706,5793348,52.2719,11.36423,4);
INSERT INTO "T_Graeber_pt" VALUES(334,320,'AHa017',17,'AHa',4456809,5793120,52.26986,11.36577,4);
INSERT INTO "T_Graeber_pt" VALUES(335,321,'AHa018',18,'AHa',4456393,5793729,52.2753,11.35959,4);
INSERT INTO "T_Graeber_pt" VALUES(336,322,'AHa019',19,'AHa',4456480,5793958,52.27737,11.36084,4);
INSERT INTO "T_Graeber_pt" VALUES(337,323,'AHa020',20,'AHa',4456541,5793956,52.27736,11.36173,4);
INSERT INTO "T_Graeber_pt" VALUES(338,324,'AHa021',21,'AHa',4456503,5794069,52.27837,11.36116,4);
INSERT INTO "T_Graeber_pt" VALUES(339,325,'AHa022',22,'AHa',4456372,5794082,52.27847,11.35924,4);
INSERT INTO "T_Graeber_pt" VALUES(340,326,'AHa023',23,'AHa',4456446,5794127,52.27889,11.36032,4);
INSERT INTO "T_Graeber_pt" VALUES(341,327,'AHa024',24,'AHa',4456680,5794175,52.27933,11.36374,4);
INSERT INTO "T_Graeber_pt" VALUES(342,328,'AHa025',25,'AHa',4456720,5794265,52.28015,11.36432,4);
INSERT INTO "T_Graeber_pt" VALUES(343,329,'AHa026',26,'AHa',4456770,5794210,52.27966,11.36506,4);
INSERT INTO "T_Graeber_pt" VALUES(344,330,'AHa027',27,'AHa',4456583,5794501,52.28225,11.36228,4);
INSERT INTO "T_Graeber_pt" VALUES(345,331,'AHa028',28,'AHa',4458135,5793630,52.27455,11.38513,NULL);
INSERT INTO "T_Graeber_pt" VALUES(346,332,'AHa029',29,'AHa',4457217,5792540,52.26468,11.37182,NULL);
INSERT INTO "T_Graeber_pt" VALUES(347,333,'Hun006',6,'Hun',4456894,5791638,52.25655,11.3672,NULL);
INSERT INTO "T_Graeber_pt" VALUES(348,379,'Mos001',1,'Mos',4474300,5793650,52.27572,11.62194,NULL);
INSERT INTO "T_Graeber_pt" VALUES(385,418,'AHa033',33,'AHa',4459516,5792292,52.26263,11.40552,5);
INSERT INTO "T_Graeber_pt" VALUES(386,419,'AHa031',31,'AHa',4459341,5792239,52.26214,11.40296,5);
INSERT INTO "T_Graeber_pt" VALUES(387,420,'AHa034',34,'AHa',4459776,5792269,52.26245,11.40934,5);
INSERT INTO "T_Graeber_pt" VALUES(388,421,'AHa032',32,'AHa',4459440,5792200,52.2618,11.40442,5);
INSERT INTO "T_Graeber_pt" VALUES(389,422,'Emd012',12,'Emd',4451070,5792529,52.26407,11.28179,NULL);
INSERT INTO "T_Graeber_pt" VALUES(390,423,'Hun022',22,'Hun',4456685,5792496,52.26425,11.36403,2);
INSERT INTO "T_Graeber_pt" VALUES(391,426,'Süp001',1,'Süp',4456281,5795051,52.28718,11.35779,4);
INSERT INTO "T_Graeber_pt" VALUES(392,427,'AHa002',2,'AHa',4456570,5794125,52.27888,11.36214,NULL);
INSERT INTO "T_Graeber_pt" VALUES(393,428,'AHa001',1,'AHa',4456409,5793994,52.27769,11.35979,NULL);
INSERT INTO "T_Graeber_pt" VALUES(394,430,'Dön016',16,'Dön',4456906,5791267,52.25322,11.36742,NULL);
INSERT INTO "T_Graeber_pt" VALUES(395,431,'Dön017',17,'Dön',4456929,5791067,52.25142,11.36779,NULL);
INSERT INTO "T_Graeber_pt" VALUES(396,432,'Dön018',18,'Dön',4457003,5790966,52.25052,11.36888,NULL);
INSERT INTO "T_Graeber_pt" VALUES(397,433,'Dön019',19,'Dön',4455082,5791432,52.25456,11.34069,1);
INSERT INTO "T_Graeber_pt" VALUES(398,434,'Dön020',20,'Dön',4455183,5791531,52.25545,11.34216,1);
INSERT INTO "T_Graeber_pt" VALUES(399,435,'Dön021',21,'Dön',4454607,5791460,52.25477,11.33373,1);
INSERT INTO "T_Graeber_pt" VALUES(400,436,'Hun025',25,'Hun',4459016,5792400,52.26356,11.39818,5);
INSERT INTO "T_Graeber_pt" VALUES(401,437,'Hun024',24,'Hun',4458443,5792580,52.26514,11.38977,5);
INSERT INTO "T_Graeber_pt" VALUES(402,438,'Emd015',15,'Emd',4451192,5792546,52.26424,11.28357,NULL);
INSERT INTO "T_Graeber_pt" VALUES(403,439,'Emd016',16,'Emd',4451079,5793873,52.27615,11.28173,NULL);
INSERT INTO "T_Graeber_pt" VALUES(404,440,'Emd017',17,'Emd',4452058,5791612,52.25592,11.29639,NULL);
INSERT INTO "T_Graeber_pt" VALUES(405,441,'AHa030',30,'AHa',4460728,5793861,52.27682,11.42309,NULL);
INSERT INTO "T_Graeber_pt" VALUES(406,445,'Hun028',28,'Hun',4457600,5790661,52.24783,11.37766,NULL);
INSERT INTO "T_Graeber_pt" VALUES(407,446,'Hun029',29,'Hun',4457799,5790559,52.24693,11.38059,NULL);
INSERT INTO "T_Graeber_pt" VALUES(409,449,'Alv052',52,'Alv',4454168,5792666,52.26557,11.32714,1);
INSERT INTO "T_Graeber_pt" VALUES(410,450,'Emd044',44,'Emd',4450836,5791875,52.25817,11.27846,NULL);
INSERT INTO "T_Graeber_pt" VALUES(411,451,'Emd045',45,'Emd',4450885,5791799,52.2575,11.27918,NULL);
INSERT INTO "T_Graeber_pt" VALUES(412,453,'Hun023',23,'Hun',4456241,5792422,52.26355,11.35754,2);
INSERT INTO "T_Graeber_pt" VALUES(413,454,'Hun030',30,'Hun',4458467,5792505,52.26446,11.39013,5);
INSERT INTO "T_Graeber_pt" VALUES(414,455,'Hun035',35,'Hun',4457478,5792362,52.2631,11.37566,NULL);
INSERT INTO "T_Graeber_pt" VALUES(415,456,'Hun037',37,'Hun',4457899,5792361,52.26313,11.38182,NULL);
INSERT INTO "T_Graeber_pt" VALUES(416,506,'NHa005',5,'NHa',4461473,5796731,52.30266,11.43367,NULL);
INSERT INTO "T_Graeber_pt" VALUES(417,507,'Hun026',26,'Hun',4458806,5791327,52.2539,11.39524,NULL);
INSERT INTO "T_Graeber_pt" VALUES(418,508,'Hun027',27,'Hun',4458804,5791152,52.25233,11.39523,NULL);

/* Comment 
------------------------
"Huegel": if existent
"Huegelform": description
"Datum": date of the description
 */
DROP TABLE IF EXISTS "T_Huegel";
CREATE TABLE "T_Huegel" (
"HuegelID" INTEGER PRIMARY KEY AUTOINCREMENT, 
"MegaID" integer, 
"Huegel" bool, 
"Huegelform" text, 
"Datum" datetime,
FOREIGN KEY (MegaID) REFERENCES T_MegalitheDaten(MegaID)
);
INSERT INTO "T_Huegel" VALUES(1,12,1,'keine Angabe',NULL);
INSERT INTO "T_Huegel" VALUES(2,14,1,'keine Angabe',NULL);
INSERT INTO "T_Huegel" VALUES(3,29,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(4,34,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(5,35,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(6,37,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(7,38,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(8,40,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(9,44,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(10,50,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(11,55,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(12,56,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(13,62,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(14,71,1,'keine Angabe',NULL);
INSERT INTO "T_Huegel" VALUES(15,72,1,'keine Angabe',NULL);
INSERT INTO "T_Huegel" VALUES(16,76,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(17,80,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(18,82,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(19,97,1,'rund',NULL);
INSERT INTO "T_Huegel" VALUES(20,98,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(21,99,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(22,100,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(23,101,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(24,102,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(25,103,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(26,104,1,'rund',NULL);
INSERT INTO "T_Huegel" VALUES(27,112,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(28,113,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(29,115,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(30,116,1,'nicht erkennbar',NULL);
INSERT INTO "T_Huegel" VALUES(31,117,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(32,118,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(33,119,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(34,120,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(35,121,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(36,122,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(37,124,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(38,132,1,'keine Angabe',NULL);
INSERT INTO "T_Huegel" VALUES(39,133,1,'keine Angabe',NULL);
INSERT INTO "T_Huegel" VALUES(40,134,1,'keine Angabe',NULL);
INSERT INTO "T_Huegel" VALUES(41,151,1,'rund',NULL);
INSERT INTO "T_Huegel" VALUES(42,152,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(43,153,1,'rund',NULL);
INSERT INTO "T_Huegel" VALUES(44,154,1,'rund',NULL);
INSERT INTO "T_Huegel" VALUES(45,155,1,'rund',NULL);
INSERT INTO "T_Huegel" VALUES(46,174,1,'nicht erkennbar',NULL);
INSERT INTO "T_Huegel" VALUES(47,175,1,'nicht erkennbar',NULL);
INSERT INTO "T_Huegel" VALUES(48,178,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(49,185,1,'keine Angabe',NULL);
INSERT INTO "T_Huegel" VALUES(50,186,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(51,188,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(52,189,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(53,191,1,'keine Angabe',NULL);
INSERT INTO "T_Huegel" VALUES(54,192,1,'rund',NULL);
INSERT INTO "T_Huegel" VALUES(55,193,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(56,194,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(57,195,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(58,209,1,'keine Angabe',NULL);
INSERT INTO "T_Huegel" VALUES(59,210,1,'keine Angabe',NULL);
INSERT INTO "T_Huegel" VALUES(60,242,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(61,243,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(62,244,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(63,246,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(64,247,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(65,248,1,'nicht erkennbar',NULL);
INSERT INTO "T_Huegel" VALUES(66,249,1,'rund',NULL);
INSERT INTO "T_Huegel" VALUES(68,251,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(71,255,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(72,256,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(74,258,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(75,259,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(76,260,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(77,262,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(78,263,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(79,264,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(80,265,1,'rund',NULL);
INSERT INTO "T_Huegel" VALUES(81,266,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(83,268,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(84,269,1,'rund',NULL);
INSERT INTO "T_Huegel" VALUES(85,270,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(86,271,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(87,272,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(88,274,1,'nicht erkennbar',NULL);
INSERT INTO "T_Huegel" VALUES(89,282,1,'keine Angabe',NULL);
INSERT INTO "T_Huegel" VALUES(91,292,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(92,293,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(93,297,1,'rund',NULL);
INSERT INTO "T_Huegel" VALUES(94,298,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(95,312,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(96,316,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(97,317,1,'nicht erkennbar',NULL);
INSERT INTO "T_Huegel" VALUES(99,319,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(100,320,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(101,321,1,'rund',NULL);
INSERT INTO "T_Huegel" VALUES(102,322,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(103,323,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(104,324,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(105,326,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(106,327,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(107,328,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(108,329,1,'nicht erkennbar',NULL);
INSERT INTO "T_Huegel" VALUES(109,330,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(110,331,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(111,335,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(112,337,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(113,338,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(114,339,1,'rund',NULL);
INSERT INTO "T_Huegel" VALUES(115,340,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(116,394,1,'keine Angabe',NULL);
INSERT INTO "T_Huegel" VALUES(117,395,1,'keine Angabe',NULL);
INSERT INTO "T_Huegel" VALUES(118,405,1,'rund',NULL);
INSERT INTO "T_Huegel" VALUES(119,409,1,'rund',NULL);
INSERT INTO "T_Huegel" VALUES(120,411,1,'keine Angabe',NULL);
INSERT INTO "T_Huegel" VALUES(121,416,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(122,422,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(123,423,1,'oval',NULL);
INSERT INTO "T_Huegel" VALUES(124,367,1,'länglich','9.2.2013 00:00:00');
INSERT INTO "T_Huegel" VALUES(125,314,0,'keine Angabe','14.3.2013 00:00:00');
INSERT INTO "T_Huegel" VALUES(126,318,1,'länglich','10.3.2010 00:00:00');
INSERT INTO "T_Huegel" VALUES(127,267,1,'rund','25.5.2013 00:00:00');
INSERT INTO "T_Huegel" VALUES(128,266,0,'rund','25.5.2013 00:00:00');
INSERT INTO "T_Huegel" VALUES(129,257,0,'länglich','25.5.2013 00:00:00');
INSERT INTO "T_Huegel" VALUES(130,250,0,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(131,295,1,'rund',NULL);
INSERT INTO "T_Huegel" VALUES(132,423,0,'länglich','27.7.2013 00:00:00');
INSERT INTO "T_Huegel" VALUES(133,323,1,'rund',NULL);
INSERT INTO "T_Huegel" VALUES(134,250,1,'länglich',NULL);
INSERT INTO "T_Huegel" VALUES(135,258,1,'rund',NULL);
INSERT INTO "T_Huegel" VALUES(136,423,1,'länglich','27.7.2013 00:00:00');

/* Comment 
------------------------
 Table for the description of the tomb chamber.
"Kammertyp": type of the tomb chamber 
"KammForm": form of the chamber
"KammBeschr": general description
 */
DROP TABLE IF EXISTS "T_Kammern";
CREATE TABLE "T_Kammern" (
"KammerID" INTEGER PRIMARY KEY AUTOINCREMENT, 
"MegaID" integer, 
"Kammertyp" text, 
"KammForm" text, 
"KammBeschr" text,
FOREIGN KEY (MegaID) REFERENCES T_MegalitheDaten(MegaID)
);
INSERT INTO "T_Kammern" VALUES(1,1,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(2,2,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(3,3,'Urdolmen?',NULL,'1-2 Joche/1 Deckstein');
INSERT INTO "T_Kammern" VALUES(4,4,'Urdolmen?',NULL,'1-2 Joche/1 Deckstein');
INSERT INTO "T_Kammern" VALUES(5,5,'Großdolmen',NULL,'mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(6,12,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(7,18,'Urdolmen?','viereckig','1-2 Joche/1 Deckstein');
INSERT INTO "T_Kammern" VALUES(8,19,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(9,20,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(10,21,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(11,22,'erweiterter Dolmen','viereckig','2 Joche/2 Decksteine');
INSERT INTO "T_Kammern" VALUES(12,24,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(13,25,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(14,29,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(15,30,'Urdolmen?',NULL,'1-2 Joche/1 Deckstein');
INSERT INTO "T_Kammern" VALUES(16,32,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(17,34,'Großdolmen','trapezförmig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(18,35,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(19,37,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(20,38,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(21,40,'Großdolmen','trapezförmig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(22,44,'Großdolmen','trapezförmig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(23,48,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(24,50,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(25,51,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(26,52,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(27,55,NULL,'rechteckig','eventuell Ganggrab');
INSERT INTO "T_Kammern" VALUES(28,56,'Großdolmen','trapezförmig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(29,57,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(30,58,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(31,60,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(32,62,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(33,64,'Urdolmen?','viereckig','1-2 Joche/1 Deckstein');
INSERT INTO "T_Kammern" VALUES(34,65,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(35,66,'Großdolmen',NULL,'mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(36,68,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(37,70,'Urdolmen?','viereckig','1-2 Joche/1 Deckstein');
INSERT INTO "T_Kammern" VALUES(38,71,'Großdolmen',NULL,'mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(39,73,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(40,76,'Großdolmen','trapezförmig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(41,77,'Großdolmen',NULL,'mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(42,78,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(43,80,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(44,82,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(45,84,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(46,85,'nicht erkennbar','viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(47,88,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(48,89,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(49,90,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(50,91,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(51,93,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(52,94,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(53,95,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(54,97,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(55,98,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(56,99,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(57,100,'Großdolmen','birnenförmig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(58,101,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(59,102,'Ganggrab','trapezförmig','Ganggrab');
INSERT INTO "T_Kammern" VALUES(60,103,'Ganggrab','rechteckig','wahrscheinlich Ganggrab');
INSERT INTO "T_Kammern" VALUES(61,104,'Ganggrab','polygonal','wahrscheinlich Ganggrab');
INSERT INTO "T_Kammern" VALUES(62,105,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(63,106,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(64,107,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(65,108,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(66,109,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(67,112,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(68,113,NULL,'polygonal','eventuell Polygonaldolmen');
INSERT INTO "T_Kammern" VALUES(69,115,'Ganggrab','nicht erkennbar','Ganggrab; mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(70,116,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(71,117,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(72,118,'Ganggrab','rechteckig','wahrscheinlich Ganggrab');
INSERT INTO "T_Kammern" VALUES(73,119,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(74,120,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(75,121,NULL,'nicht erkennbar',NULL);
INSERT INTO "T_Kammern" VALUES(76,122,'erweiterter Dolmen','rechteckig','2 Joche/2 Decksteine');
INSERT INTO "T_Kammern" VALUES(77,123,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(78,124,'erweiterter Dolmen','rechteckig','2 Joche/2 Decksteine');
INSERT INTO "T_Kammern" VALUES(79,125,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(80,126,'Urdolmen?','viereckig','1-2 Joche/1 Deckstein');
INSERT INTO "T_Kammern" VALUES(81,127,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(82,128,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(83,129,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(84,130,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(85,131,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(86,151,'Großdolmen','nicht erkennbar','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(87,152,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(88,156,'Großdolmen',NULL,'mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(89,159,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(90,160,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(91,161,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(92,162,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(93,163,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(94,165,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(95,166,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(96,167,'Urdolmen?',NULL,'1-2 Joche/1 Deckstein');
INSERT INTO "T_Kammern" VALUES(97,168,'Großdolmen',NULL,'mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(98,173,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(99,174,'Großdolmen','trapezförmig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(100,175,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(101,178,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(102,185,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(103,187,'Großdolmen',NULL,'mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(104,188,'Ganggrab','trapezförmig','Ganggrab');
INSERT INTO "T_Kammern" VALUES(105,189,NULL,'rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(106,191,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(107,192,NULL,'nicht erkennbar',NULL);
INSERT INTO "T_Kammern" VALUES(108,193,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(109,194,'Großdolmen','rechteckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(110,195,'erweiterter Dolmen','rechteckig','2 Joche/2 Decksteine');
INSERT INTO "T_Kammern" VALUES(111,197,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(112,202,'Großdolmen','viereckig','mehr als 2 Joche');
INSERT INTO "T_Kammern" VALUES(113,203,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(114,204,NULL,'viereckig',NULL);
INSERT INTO "T_Kammern" VALUES(115,205,'Urdolmen?','polygonal','1-2 Joche/1 Deckstein');
INSERT INTO "T_Kammern" VALUES(116,206,'Urdolmen?','polygonal','1-2 Joche/1 Deckstein');
INSERT INTO "T_Kammern" VALUES(117,209,'Ganggrab','rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(118,219,NULL,'rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(119,235,'Steinkammer','rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(125,251,'Ganggrab','trapezförmig','Ganggrab');
INSERT INTO "T_Kammern" VALUES(130,256,'erweiterter Dolmen','polygonal','2 Joche');
INSERT INTO "T_Kammern" VALUES(131,257,'Ganggrab','rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(134,260,'Ganggrab','rechteckig','ein Gang wird aus den Umfassungssteinen erschlossen');
INSERT INTO "T_Kammern" VALUES(136,265,'erweiterter Dolmen','rechteckig','Länge ca. 2,3 m, Breite nach Deckstein 1,1 m');
INSERT INTO "T_Kammern" VALUES(139,268,'Ganggrab','rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(140,270,'Ganggrab','rechteckig','Ganggrab');
INSERT INTO "T_Kammern" VALUES(141,272,'Ganggrab','rechteckig','Abmessung der Kammer aus der Steinlage gut zu schätzen');
INSERT INTO "T_Kammern" VALUES(142,279,'Rampenkiste',NULL,'Rampenkiste');
INSERT INTO "T_Kammern" VALUES(143,280,NULL,'rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(144,282,'Steinkammer','rechteckig','Steinkammer; große Steinkammer??');
INSERT INTO "T_Kammern" VALUES(145,283,NULL,'rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(146,292,'Ganggrab','rechteckig','Ganggrab');
INSERT INTO "T_Kammern" VALUES(147,293,'Ganggrab','rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(149,296,'Ganggrab','rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(150,297,'Ganggrab','rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(153,313,'erweiterter Dolmen','rechteckig','Lücke zwischen Lang und Schmalseite');
INSERT INTO "T_Kammern" VALUES(157,319,'Ganggrab','rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(158,321,'Großdolmen','rechteckig','Großdolmen');
INSERT INTO "T_Kammern" VALUES(159,323,'Großdolmen','rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(160,325,'Ganggrab','rechteckig','aus den verschlossenen Schmalseiten zu schließen');
INSERT INTO "T_Kammern" VALUES(161,326,'Ganggrab','rechteckig','mind 6 Joche');
INSERT INTO "T_Kammern" VALUES(162,327,'Ganggrab','rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(166,335,'Ganggrab','rechteckig','Ganggrab');
INSERT INTO "T_Kammern" VALUES(170,339,'erweiterter Dolmen','rechteckig','vermutet aufgrund des rundlichen Hügels');
INSERT INTO "T_Kammern" VALUES(171,370,'Rampenkiste','rechteckig','Rampenkiste');
INSERT INTO "T_Kammern" VALUES(172,371,'Großdolmen',NULL,'Großdolmen');
INSERT INTO "T_Kammern" VALUES(173,372,'Großdolmen','rechteckig','Großdolmen');
INSERT INTO "T_Kammern" VALUES(174,375,'Ganggrab','viereckig','Ganggrab');
INSERT INTO "T_Kammern" VALUES(175,393,'Urdolmen?','rechteckig','Urdolmen/Kiste');
INSERT INTO "T_Kammern" VALUES(176,394,'Ganggrab','trapezförmig','Ganggrab');
INSERT INTO "T_Kammern" VALUES(177,395,'Ganggrab','trapezförmig','Ganggrab');
INSERT INTO "T_Kammern" VALUES(178,397,'Großdolmen','trapezförmig','Großdolmen');
INSERT INTO "T_Kammern" VALUES(179,398,'Großdolmen',NULL,'Großdolmen');
INSERT INTO "T_Kammern" VALUES(180,399,'Steinkammer',NULL,'Steinkammer');
INSERT INTO "T_Kammern" VALUES(181,402,'Urdolmen?',NULL,'Urdolmen?');
INSERT INTO "T_Kammern" VALUES(182,403,'Urdolmen?',NULL,'Urdolmen?');
INSERT INTO "T_Kammern" VALUES(183,405,'Ganggrab','trapezförmig','Ganggrab');
INSERT INTO "T_Kammern" VALUES(184,409,'Großdolmen','rechteckig','Großdolmen');
INSERT INTO "T_Kammern" VALUES(185,410,'Rampenkiste','rechteckig','Rampenkiste');
INSERT INTO "T_Kammern" VALUES(186,411,'Ganggrab','trapezförmig','Ganggrab');
INSERT INTO "T_Kammern" VALUES(187,413,'Rampenkiste','trapezförmig','Rampenkiste');
INSERT INTO "T_Kammern" VALUES(188,414,NULL,'rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(189,415,NULL,'rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(190,416,NULL,'rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(191,422,'Ganggrab','rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(192,318,'Ganggrab','rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(198,333,'Großdolmen','trapezförmig','langgestreckt trapezförmig');
INSERT INTO "T_Kammern" VALUES(200,337,'Ganggrab','rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(201,284,'Ganggrab','trapezförmig','anhand der Decksteinlänge zu vermuten');
INSERT INTO "T_Kammern" VALUES(202,287,'Ganggrab','rechteckig','vermutlich, nur 1 Deckstein');
INSERT INTO "T_Kammern" VALUES(203,288,'Dolmen','viereckig','zwei Wandsteine in situ oder ± in situ');
INSERT INTO "T_Kammern" VALUES(205,267,'Dolmen','nicht erkennbar',NULL);
INSERT INTO "T_Kammern" VALUES(207,266,'Dolmen','polygonal','aus der Zahl der Kammersteine zu schließen');
INSERT INTO "T_Kammern" VALUES(208,259,'Großdolmen','trapezförmig','im Zentrum etwas breiter');
INSERT INTO "T_Kammern" VALUES(213,255,'Ganggrab','rechteckig','vermutlich rechteckig');
INSERT INTO "T_Kammern" VALUES(214,258,'erweiterter Dolmen','polygonal','vermutlich');
INSERT INTO "T_Kammern" VALUES(216,262,'erweiterter Dolmen','rechteckig','Form nicht sicher');
INSERT INTO "T_Kammern" VALUES(218,277,'Ganggrab','rechteckig','nur zu erschließen');
INSERT INTO "T_Kammern" VALUES(219,285,'Ganggrab','rechteckig','aus Anzahl der Steine zu erschließen');
INSERT INTO "T_Kammern" VALUES(221,324,'Ganggrab','rechteckig','vermutlich, stark zerstört');
INSERT INTO "T_Kammern" VALUES(222,328,'Ganggrab','rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(226,242,'Ganggrab','rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(228,243,'Ganggrab','rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(229,244,'Ganggrab','rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(230,246,'Ganggrab','rechteckig','Schmalseiten sind geschlossen');
INSERT INTO "T_Kammern" VALUES(233,426,'Ganggrab','rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(235,295,'erweiterter Dolmen','trapezförmig','schwach trapezförmig');
INSERT INTO "T_Kammern" VALUES(239,330,'Ganggrab','rechteckig',NULL);
INSERT INTO "T_Kammern" VALUES(242,316,'Ganggrab','nicht erkennbar','Gang aus den verschlossenen Schmalseiten zu erschließen');
INSERT INTO "T_Kammern" VALUES(243,253,'Ganggrab','rechteckig','Gang nicht erhalten, aus der Umfassung zu erschließen');
INSERT INTO "T_Kammern" VALUES(244,254,'Ganggrab','nicht erkennbar','Gang aus der Umfassung zu erschließen');
INSERT INTO "T_Kammern" VALUES(246,298,'erweiterter Dolmen','polygonal',NULL);
INSERT INTO "T_Kammern" VALUES(248,338,'Dolmen','trapezförmig','aus Hügel und Form erschlossen');
INSERT INTO "T_Kammern" VALUES(249,322,'Ganggrab','nicht erkennbar',NULL);
INSERT INTO "T_Kammern" VALUES(250,423,'Ganggrab','nicht erkennbar',NULL);

/* Comment 
------------------------
Table of concordance with other lists and publications.
"Katalog": Name of the list owner or citation (name, year) of the publication (s. text). 
"KatNr": Number in the list.
"Eintrag": Page in the publication
"publiziert": published
 */
DROP TABLE IF EXISTS "T_Konkordanzen";
CREATE TABLE "T_Konkordanzen" (
"Konkorda" INTEGER PRIMARY KEY AUTOINCREMENT, 
"MegaID" integer, 
"Katalog" text, 
"KatNr" text, 
"Eintrag" text, 
"publiziert" bool,
FOREIGN KEY (MegaID) REFERENCES T_MegalitheDaten(MegaID)
);
INSERT INTO "T_Konkordanzen" VALUES(1,242,'Stuhlmann','28',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(2,243,'Stuhlmann','27',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(3,244,'Stuhlmann','25',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(4,246,'Stuhlmann','26',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(5,247,'Stuhlmann','73',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(6,248,'Stuhlmann','74',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(7,249,'Stuhlmann','24',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(8,250,'Stuhlmann','23',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(9,251,'Stuhlmann','29',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(10,252,'Stuhlmann','30',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(11,253,'Stuhlmann','91',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(12,254,'Stuhlmann','19',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(13,255,'Stuhlmann','18',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(14,256,'Stuhlmann','17',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(15,257,'Stuhlmann','70',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(16,258,'Stuhlmann','16',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(17,259,'Stuhlmann','15',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(18,260,'Stuhlmann','14',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(19,261,'Stuhlmann','5',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(20,262,'Stuhlmann','13',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(21,263,'Stuhlmann','61',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(22,264,'Stuhlmann','62',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(23,265,'Stuhlmann','63',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(24,266,'Stuhlmann','65',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(25,267,'Stuhlmann','64',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(26,268,'Stuhlmann','12',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(27,269,'Stuhlmann','11',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(28,270,'Stuhlmann','31',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(29,271,'Stuhlmann','32',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(30,272,'Stuhlmann','22',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(31,273,'Stuhlmann','95',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(32,274,'Stuhlmann','94',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(33,275,'Stuhlmann','93',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(34,276,'Stuhlmann','54',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(35,277,'Stuhlmann','53',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(36,285,'Stuhlmann','71',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(37,289,'Stuhlmann','72',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(38,290,'Stuhlmann','51',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(39,291,'Stuhlmann','52',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(40,294,'Stuhlmann','80',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(42,296,'Stuhlmann','4 u. 7',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(43,297,'Stuhlmann','58',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(44,298,'Stuhlmann','9',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(46,301,'Stuhlmann','10',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(47,304,'Stuhlmann','96',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(48,308,'Stuhlmann','82',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(49,309,'Stuhlmann','34',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(50,313,'Stuhlmann','1',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(51,314,'Stuhlmann','68',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(52,315,'Stuhlmann','67',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(53,316,'Stuhlmann','66','66+67',0);
INSERT INTO "T_Konkordanzen" VALUES(54,317,'Stuhlmann','69',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(55,318,'Stuhlmann','43',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(56,319,'Stuhlmann','45',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(57,320,'Stuhlmann','46',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(58,321,'Stuhlmann','59',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(59,322,'Stuhlmann','77',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(60,323,'Stuhlmann','42',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(61,324,'Stuhlmann','40',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(62,325,'Stuhlmann','41',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(63,326,'Stuhlmann','39',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(64,327,'Stuhlmann','37',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(65,328,'Stuhlmann','36',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(66,329,'Stuhlmann','38',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(67,330,'Stuhlmann','35',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(68,331,'Stuhlmann','50',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(69,335,'Stuhlmann','101',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(70,336,'Stuhlmann','75',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(71,337,'Stuhlmann','44',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(72,338,'Stuhlmann','55',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(73,339,'Stuhlmann','89',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(74,340,'Stuhlmann','33',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(75,341,'Stuhlmann','85',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(76,342,'Stuhlmann','47',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(77,344,'Stuhlmann','83',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(78,345,'Stuhlmann','21',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(79,346,'Stuhlmann','81',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(80,423,'Stuhlmann','48',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(81,426,'Stuhlmann','20',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(82,428,'Stuhlmann','78',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(83,433,'Stuhlmann','56',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(84,434,'Stuhlmann','57',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(85,435,'Stuhlmann','6',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(86,436,'Stuhlmann','76',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(87,437,'Stuhlmann','86',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(88,455,'Stuhlmann','76',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(89,242,'Saal','33',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(90,243,'Saal','32',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(91,244,'Saal','31',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(92,246,'Saal','39',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(93,247,'Saal','44',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(94,248,'Saal','43',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(95,249,'Saal','35',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(96,250,'Saal','42',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(97,251,'Saal','85',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(98,252,'Saal','38',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(99,253,'Saal','41',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(100,254,'Saal','48',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(101,255,'Saal','54',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(102,256,'Saal','55',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(103,257,'Saal','58',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(104,258,'Saal','56',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(105,259,'Saal','61',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(106,260,'Saal','63',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(107,261,'Saal','92',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(108,262,'Saal','67',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(109,263,'Saal','74',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(110,264,'Saal','76',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(111,265,'Saal','77',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(112,266,'Saal','75',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(113,267,'Saal','79',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(114,268,'Saal','78',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(115,269,'Saal','81',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(116,270,'Saal','86',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(117,271,'Saal','20',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(118,272,'Saal','9',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(119,273,'Saal','49',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(120,274,'Saal','50',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(121,275,'Saal','51',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(122,276,'Saal','88',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(123,277,'Saal','89',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(124,281,'Saal','5',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(125,284,'Saal','73',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(126,285,'Saal','90',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(127,286,'Saal','91',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(128,287,'Saal','72',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(129,288,'Saal','71',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(130,289,'Saal','45',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(131,290,'Blasius 1901','X',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(132,291,'Rahmlow 1960','4','31',1);
INSERT INTO "T_Konkordanzen" VALUES(133,292,'Saal','69',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(134,293,'Saal','96',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(135,294,'Saal','62',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(136,295,'Saal','97',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(137,296,'Saal','98',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(138,297,'Saal','80',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(139,298,'Saal','83',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(141,301,'Saal','84',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(142,302,'Saal','100',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(143,304,'Saal','87',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(144,308,'Saal','1',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(145,309,'Saal','7',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(146,310,'Saal','123',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(147,312,'Saal','29',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(148,313,'Saal','22',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(151,316,'Saal','27',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(152,317,'Saal','25',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(153,318,'Saal','30',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(154,319,'Saal','37',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(155,320,'Saal','46',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(156,321,'Saal','21',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(157,322,'Saal','18',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(158,323,'Saal','19',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(159,324,'Saal','16',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(160,325,'Saal','15',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(161,326,'Saal','14',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(162,327,'Saal','12',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(163,328,'Saal','10',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(164,329,'Saal','11',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(165,330,'Saal','8',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(166,331,'Saal','24',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(167,332,'Saal','116',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(168,333,'Saal','105',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(169,335,'Saal','57',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(170,336,'Saal','82',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(171,337,'Saal','34',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(172,338,'Saal','28',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(173,339,'Saal','36',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(174,340,'Saal','23',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(175,341,'Saal','107',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(176,342,'Saal','108',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(177,344,'Saal','6',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(178,345,'Saal','111',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(179,346,'Saal','112',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(180,418,'Saal','65',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(181,419,'Saal','66',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(182,420,'Saal','68',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(183,421,'Saal','70',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(184,422,'Saal','59',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(185,423,'Saal','60',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(187,426,'Saal','4',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(188,427,'Saal','13',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(189,428,'Saal','17',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(191,430,'Saal','101',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(192,431,'Saal','101',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(193,432,'Saal','101',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(194,433,'Saal','102',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(195,434,'Saal','103',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(196,435,'Saal','104',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(197,436,'Saal','109',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(198,437,'Saal','110',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(199,438,'Saal','113',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(200,439,'Saal','114',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(201,440,'Saal','115',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(202,441,'Saal','117',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(203,445,'Saal','121',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(204,446,'Saal','121',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(205,455,'Saal','109',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(207,507,'Saal','120',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(208,508,'Saal','120',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(209,242,'Rahmlow 1960','1','29',1);
INSERT INTO "T_Konkordanzen" VALUES(210,243,'Rahmlow 1960','2','29',1);
INSERT INTO "T_Konkordanzen" VALUES(211,244,'Rahmlow 1960','3','29',1);
INSERT INTO "T_Konkordanzen" VALUES(212,246,'Rahmlow 1960','4','29',1);
INSERT INTO "T_Konkordanzen" VALUES(213,247,'Rahmlow 1960','5','29',1);
INSERT INTO "T_Konkordanzen" VALUES(214,248,'Rahmlow 1960','6','29',1);
INSERT INTO "T_Konkordanzen" VALUES(215,249,'Rahmlow 1960','7','29',1);
INSERT INTO "T_Konkordanzen" VALUES(216,250,'Rahmlow 1960','8','29',1);
INSERT INTO "T_Konkordanzen" VALUES(217,251,'Rahmlow 1960','9','29',1);
INSERT INTO "T_Konkordanzen" VALUES(218,252,'Rahmlow 1960','10','29',1);
INSERT INTO "T_Konkordanzen" VALUES(219,253,'Rahmlow 1960','11','29',1);
INSERT INTO "T_Konkordanzen" VALUES(220,254,'Rahmlow 1960','12','29',1);
INSERT INTO "T_Konkordanzen" VALUES(221,255,'Rahmlow 1960','13','29',1);
INSERT INTO "T_Konkordanzen" VALUES(222,256,'Rahmlow 1960','14','29',1);
INSERT INTO "T_Konkordanzen" VALUES(223,257,'Rahmlow 1960','15','29',1);
INSERT INTO "T_Konkordanzen" VALUES(224,258,'Rahmlow 1960','16','29',1);
INSERT INTO "T_Konkordanzen" VALUES(225,259,'Rahmlow 1960','17','29',1);
INSERT INTO "T_Konkordanzen" VALUES(226,260,'Rahmlow 1960','18','29',1);
INSERT INTO "T_Konkordanzen" VALUES(227,261,'Rahmlow 1960','1','31',1);
INSERT INTO "T_Konkordanzen" VALUES(228,262,'Rahmlow 1960','19','29',1);
INSERT INTO "T_Konkordanzen" VALUES(229,263,'Rahmlow 1960','20','29',1);
INSERT INTO "T_Konkordanzen" VALUES(230,264,'Rahmlow 1960','21','29',1);
INSERT INTO "T_Konkordanzen" VALUES(231,265,'Rahmlow 1960','22','29',1);
INSERT INTO "T_Konkordanzen" VALUES(232,266,'Rahmlow 1960','23','29',1);
INSERT INTO "T_Konkordanzen" VALUES(233,267,'Rahmlow 1960','24','29',1);
INSERT INTO "T_Konkordanzen" VALUES(234,268,'Rahmlow 1960','25','29',1);
INSERT INTO "T_Konkordanzen" VALUES(235,269,'Rahmlow 1960','26','29',1);
INSERT INTO "T_Konkordanzen" VALUES(236,270,'Rahmlow 1960','27','29',1);
INSERT INTO "T_Konkordanzen" VALUES(237,271,'Rahmlow 1960','28','29',1);
INSERT INTO "T_Konkordanzen" VALUES(238,272,'Rahmlow 1960','29','29',1);
INSERT INTO "T_Konkordanzen" VALUES(239,273,'Rahmlow 1960','30','29',1);
INSERT INTO "T_Konkordanzen" VALUES(240,274,'Rahmlow 1960','31','29',1);
INSERT INTO "T_Konkordanzen" VALUES(241,275,'Rahmlow 1960','32','29',1);
INSERT INTO "T_Konkordanzen" VALUES(242,276,'Rahmlow 1971','46','7',1);
INSERT INTO "T_Konkordanzen" VALUES(243,277,'Rahmlow 1971','47','7',1);
INSERT INTO "T_Konkordanzen" VALUES(244,284,'Rahmlow 1960','35','29',1);
INSERT INTO "T_Konkordanzen" VALUES(245,285,'Rahmlow 1971','45','7',1);
INSERT INTO "T_Konkordanzen" VALUES(246,286,'Rahmlow 1960','2','31',1);
INSERT INTO "T_Konkordanzen" VALUES(247,287,'Rahmlow 1961','70','99',1);
INSERT INTO "T_Konkordanzen" VALUES(248,288,'Rahmlow 1961','71','99',1);
INSERT INTO "T_Konkordanzen" VALUES(249,289,'Rahmlow 1961','72','99',1);
INSERT INTO "T_Konkordanzen" VALUES(250,290,'Rahmlow 1960','3','31',1);
INSERT INTO "T_Konkordanzen" VALUES(251,291,'Blasius 1901','XIVa',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(252,293,'Rahmlow 1960','6','31',1);
INSERT INTO "T_Konkordanzen" VALUES(253,294,'Rahmlow 1960','38','29',1);
INSERT INTO "T_Konkordanzen" VALUES(254,295,'Rahmlow 1960','7','31',1);
INSERT INTO "T_Konkordanzen" VALUES(255,296,'Rahmlow 1960','8','31',1);
INSERT INTO "T_Konkordanzen" VALUES(256,297,'Rahmlow 1960','39','29',1);
INSERT INTO "T_Konkordanzen" VALUES(257,298,'Rahmlow 1960','40','29',1);
INSERT INTO "T_Konkordanzen" VALUES(259,301,'Rahmlow 1960','10','31',1);
INSERT INTO "T_Konkordanzen" VALUES(260,302,'Rahmlow 1960','11','31',1);
INSERT INTO "T_Konkordanzen" VALUES(261,304,'Rahmlow 1961','73','99',1);
INSERT INTO "T_Konkordanzen" VALUES(262,309,'Rahmlow 1961','80','99',1);
INSERT INTO "T_Konkordanzen" VALUES(263,310,'Rahmlow 1960','24','32',1);
INSERT INTO "T_Konkordanzen" VALUES(264,312,'Rahmlow 1960','42','29',1);
INSERT INTO "T_Konkordanzen" VALUES(265,313,'Rahmlow 1960','43','29',1);
INSERT INTO "T_Konkordanzen" VALUES(268,316,'Rahmlow 1960','46','29',1);
INSERT INTO "T_Konkordanzen" VALUES(269,317,'Rahmlow 1960','47','29',1);
INSERT INTO "T_Konkordanzen" VALUES(270,318,'Rahmlow 1960','48','30',1);
INSERT INTO "T_Konkordanzen" VALUES(271,319,'Rahmlow 1960','49','30',1);
INSERT INTO "T_Konkordanzen" VALUES(272,320,'Rahmlow 1960','50','30',1);
INSERT INTO "T_Konkordanzen" VALUES(273,321,'Rahmlow 1960','51','30',1);
INSERT INTO "T_Konkordanzen" VALUES(274,322,'Rahmlow 1960','52','30',1);
INSERT INTO "T_Konkordanzen" VALUES(275,323,'Rahmlow 1960','53','30',1);
INSERT INTO "T_Konkordanzen" VALUES(276,324,'Rahmlow 1960','54','30',1);
INSERT INTO "T_Konkordanzen" VALUES(277,325,'Rahmlow 1960','55','30',1);
INSERT INTO "T_Konkordanzen" VALUES(278,326,'Rahmlow 1960','56','30',1);
INSERT INTO "T_Konkordanzen" VALUES(279,327,'Rahmlow 1960','57','30',1);
INSERT INTO "T_Konkordanzen" VALUES(280,328,'Rahmlow 1960','58','30',1);
INSERT INTO "T_Konkordanzen" VALUES(281,329,'Rahmlow 1960','59','30',1);
INSERT INTO "T_Konkordanzen" VALUES(282,330,'Rahmlow 1960','60','30',1);
INSERT INTO "T_Konkordanzen" VALUES(283,331,'Rahmlow 1961','74','99',1);
INSERT INTO "T_Konkordanzen" VALUES(284,332,'Rahmlow 1960','21','32',1);
INSERT INTO "T_Konkordanzen" VALUES(285,333,'Rahmlow 1960','31','32',1);
INSERT INTO "T_Konkordanzen" VALUES(286,335,'Rahmlow 1961','61','30',1);
INSERT INTO "T_Konkordanzen" VALUES(287,336,'Rahmlow 1961','62','30',1);
INSERT INTO "T_Konkordanzen" VALUES(288,337,'Rahmlow 1961','63','30',1);
INSERT INTO "T_Konkordanzen" VALUES(289,338,'Rahmlow 1961','64','30',1);
INSERT INTO "T_Konkordanzen" VALUES(290,339,'Rahmlow 1961','65','30',1);
INSERT INTO "T_Konkordanzen" VALUES(291,340,'Rahmlow 1961','66','30',1);
INSERT INTO "T_Konkordanzen" VALUES(292,341,'Rahmlow 1960','33','32',1);
INSERT INTO "T_Konkordanzen" VALUES(293,342,'Rahmlow 1960','34','32',1);
INSERT INTO "T_Konkordanzen" VALUES(294,344,'Rahmlow 1960','69','30',1);
INSERT INTO "T_Konkordanzen" VALUES(295,345,'Rahmlow 1960','43','32',1);
INSERT INTO "T_Konkordanzen" VALUES(296,346,'Rahmlow 1960','44','32',1);
INSERT INTO "T_Konkordanzen" VALUES(297,418,'Rahmlow 1961','78','99',1);
INSERT INTO "T_Konkordanzen" VALUES(298,419,'Rahmlow 1961','76','99',1);
INSERT INTO "T_Konkordanzen" VALUES(299,420,'Rahmlow 1961','79','99',1);
INSERT INTO "T_Konkordanzen" VALUES(300,421,'Rahmlow 1961','77','99',1);
INSERT INTO "T_Konkordanzen" VALUES(301,422,'Rahmlow 1960','41','',1);
INSERT INTO "T_Konkordanzen" VALUES(302,423,'Rahmlow 1961','81','99',1);
INSERT INTO "T_Konkordanzen" VALUES(303,426,'Rahmlow 1960','68','30',1);
INSERT INTO "T_Konkordanzen" VALUES(304,430,'Rahmlow 1960','12-14','31',1);
INSERT INTO "T_Konkordanzen" VALUES(305,431,'Rahmlow 1960','12-14','31',1);
INSERT INTO "T_Konkordanzen" VALUES(306,432,'Rahmlow 1960','12-14','31',1);
INSERT INTO "T_Konkordanzen" VALUES(307,433,'Rahmlow 1960','15','31',1);
INSERT INTO "T_Konkordanzen" VALUES(308,434,'Rahmlow 1960','16','31',1);
INSERT INTO "T_Konkordanzen" VALUES(309,435,'Rahmlow 1960','17','31',1);
INSERT INTO "T_Konkordanzen" VALUES(310,436,'Rahmlow 1960','35','32',1);
INSERT INTO "T_Konkordanzen" VALUES(311,437,'Rahmlow 1960','36','32',1);
INSERT INTO "T_Konkordanzen" VALUES(312,438,'Rahmlow 1960','18','31',1);
INSERT INTO "T_Konkordanzen" VALUES(313,439,'Rahmlow 1960','19','31',1);
INSERT INTO "T_Konkordanzen" VALUES(314,440,'Rahmlow 1960','20','31',1);
INSERT INTO "T_Konkordanzen" VALUES(315,441,'Rahmlow 1960','22','32',1);
INSERT INTO "T_Konkordanzen" VALUES(316,445,'Rahmlow 1960','40','32',1);
INSERT INTO "T_Konkordanzen" VALUES(317,446,'Rahmlow 1960','41','32',1);
INSERT INTO "T_Konkordanzen" VALUES(318,455,'Rahmlow 1960','35','',1);
INSERT INTO "T_Konkordanzen" VALUES(319,242,'Worschech','3',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(320,243,'Worschech','4',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(321,244,'Worschech','5',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(322,253,'Worschech','1',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(323,254,'Worschech','16',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(324,255,'Worschech','17',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(325,258,'Worschech','19',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(326,313,'Worschech','25',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(327,321,'Worschech','23',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(328,323,'Worschech','9',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(329,326,'Worschech','11',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(330,328,'Worschech','13',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(331,330,'Worschech','15',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(333,235,'Beier 1984','47','100f.',1);
INSERT INTO "T_Konkordanzen" VALUES(334,393,'Beier 1984','51','102',1);
INSERT INTO "T_Konkordanzen" VALUES(335,399,'Beier 1984','52','102',1);
INSERT INTO "T_Konkordanzen" VALUES(336,397,'Beier 1984','57','105',1);
INSERT INTO "T_Konkordanzen" VALUES(337,398,'Beier 1984','58','105',1);
INSERT INTO "T_Konkordanzen" VALUES(338,394,'Beier 1984','59','106',1);
INSERT INTO "T_Konkordanzen" VALUES(339,395,'Beier 1984','60','106',1);
INSERT INTO "T_Konkordanzen" VALUES(340,405,'Beier 1984','62','107',1);
INSERT INTO "T_Konkordanzen" VALUES(341,407,'Beier 1984','65','108',1);
INSERT INTO "T_Konkordanzen" VALUES(342,408,'Beier 1984','70','110',1);
INSERT INTO "T_Konkordanzen" VALUES(343,409,'Beier 1984','71','110',1);
INSERT INTO "T_Konkordanzen" VALUES(344,410,'Beier 1984','72','111',1);
INSERT INTO "T_Konkordanzen" VALUES(345,411,'Beier 1984','73','111',1);
INSERT INTO "T_Konkordanzen" VALUES(346,392,'Beier 1984','76','113',1);
INSERT INTO "T_Konkordanzen" VALUES(348,282,'Beier 1984','88','117',1);
INSERT INTO "T_Konkordanzen" VALUES(349,283,'Beier 1984','101','121',1);
INSERT INTO "T_Konkordanzen" VALUES(350,403,'Beier 1984','117','128',1);
INSERT INTO "T_Konkordanzen" VALUES(351,402,'Beier 1984','118','128',1);
INSERT INTO "T_Konkordanzen" VALUES(352,280,'Beier 1984','123','132',1);
INSERT INTO "T_Konkordanzen" VALUES(353,414,'Beier 1984','123','132',1);
INSERT INTO "T_Konkordanzen" VALUES(354,415,'Beier 1984','123','132',1);
INSERT INTO "T_Konkordanzen" VALUES(355,416,'Beier 1984','127','134',1);
INSERT INTO "T_Konkordanzen" VALUES(356,413,'Beier 1984','154','145',1);
INSERT INTO "T_Konkordanzen" VALUES(357,305,'Beier 1991',NULL,'49',1);
INSERT INTO "T_Konkordanzen" VALUES(358,293,'Beier 1984','24a','90',1);
INSERT INTO "T_Konkordanzen" VALUES(359,295,'Beier 1984','24b','90',1);
INSERT INTO "T_Konkordanzen" VALUES(360,296,'Beier 1984','24c','91',1);
INSERT INTO "T_Konkordanzen" VALUES(361,375,'Beier 1984','26','92f.',1);
INSERT INTO "T_Konkordanzen" VALUES(362,348,'Beier 1984','28','93',1);
INSERT INTO "T_Konkordanzen" VALUES(363,279,'Beier 1984','32','95',1);
INSERT INTO "T_Konkordanzen" VALUES(364,372,'Beier 1984','35','94',1);
INSERT INTO "T_Konkordanzen" VALUES(365,371,'Beier 1984','33','95',1);
INSERT INTO "T_Konkordanzen" VALUES(366,370,'Beier 1984','34','95f.',1);
INSERT INTO "T_Konkordanzen" VALUES(367,404,'Beier 1984',NULL,NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(368,400,'Beier 1984',NULL,'121',1);
INSERT INTO "T_Konkordanzen" VALUES(369,401,'Beier 1984',NULL,'121',1);
INSERT INTO "T_Konkordanzen" VALUES(370,219,'Beier 1984',NULL,'89',1);
INSERT INTO "T_Konkordanzen" VALUES(371,383,'Beier 1991',NULL,'132',1);
INSERT INTO "T_Konkordanzen" VALUES(372,406,'Beier 1991',NULL,'66',1);
INSERT INTO "T_Konkordanzen" VALUES(373,412,'Beier 1991',NULL,'66',1);
INSERT INTO "T_Konkordanzen" VALUES(374,389,'Beier 1991',NULL,'63',1);
INSERT INTO "T_Konkordanzen" VALUES(375,390,'Beier 1991',NULL,'63',1);
INSERT INTO "T_Konkordanzen" VALUES(376,376,'Beier 1991',NULL,'62',1);
INSERT INTO "T_Konkordanzen" VALUES(377,377,'Beier 1991',NULL,'62',1);
INSERT INTO "T_Konkordanzen" VALUES(378,378,'Beier 1991',NULL,'62',1);
INSERT INTO "T_Konkordanzen" VALUES(379,379,'Beier 1991',NULL,'62',1);
INSERT INTO "T_Konkordanzen" VALUES(380,380,'Beier 1991',NULL,'62',1);
INSERT INTO "T_Konkordanzen" VALUES(382,381,'Beier 1991',NULL,'62',1);
INSERT INTO "T_Konkordanzen" VALUES(383,384,'Beier 1991',NULL,'62',1);
INSERT INTO "T_Konkordanzen" VALUES(384,385,'Beier 1991',NULL,'62',1);
INSERT INTO "T_Konkordanzen" VALUES(385,373,'Beier 1991',NULL,'61',1);
INSERT INTO "T_Konkordanzen" VALUES(386,374,'Beier 1991',NULL,'61',1);
INSERT INTO "T_Konkordanzen" VALUES(387,350,'Beier 1991',NULL,'54',1);
INSERT INTO "T_Konkordanzen" VALUES(389,354,'Beier 1991',NULL,'54',1);
INSERT INTO "T_Konkordanzen" VALUES(390,356,'Beier 1991',NULL,'54',1);
INSERT INTO "T_Konkordanzen" VALUES(392,359,'Beier 1991',NULL,'54',1);
INSERT INTO "T_Konkordanzen" VALUES(393,360,'Beier 1991',NULL,'54',1);
INSERT INTO "T_Konkordanzen" VALUES(395,361,'Beier 1991',NULL,'54',1);
INSERT INTO "T_Konkordanzen" VALUES(397,362,'Beier 1991',NULL,'54',1);
INSERT INTO "T_Konkordanzen" VALUES(398,364,'Beier 1991',NULL,'54',1);
INSERT INTO "T_Konkordanzen" VALUES(399,369,'Beier 1991',NULL,'54',1);
INSERT INTO "T_Konkordanzen" VALUES(400,349,'Beier 1991',NULL,'53',1);
INSERT INTO "T_Konkordanzen" VALUES(401,281,'Beier 1991',NULL,'51',1);
INSERT INTO "T_Konkordanzen" VALUES(402,303,'Beier 1991',NULL,'49',1);
INSERT INTO "T_Konkordanzen" VALUES(404,224,'Beier 1991',NULL,'46',1);
INSERT INTO "T_Konkordanzen" VALUES(405,225,'Beier 1991',NULL,'46',1);
INSERT INTO "T_Konkordanzen" VALUES(406,226,'Beier 1991',NULL,'46',1);
INSERT INTO "T_Konkordanzen" VALUES(407,227,'Beier 1991',NULL,'46',1);
INSERT INTO "T_Konkordanzen" VALUES(408,228,'Beier 1991',NULL,'46',1);
INSERT INTO "T_Konkordanzen" VALUES(409,229,'Beier 1991',NULL,'46',1);
INSERT INTO "T_Konkordanzen" VALUES(410,230,'Beier 1991',NULL,'46',1);
INSERT INTO "T_Konkordanzen" VALUES(411,231,'Beier 1991',NULL,'46',1);
INSERT INTO "T_Konkordanzen" VALUES(412,232,'Beier 1991',NULL,'46',1);
INSERT INTO "T_Konkordanzen" VALUES(413,233,'Beier 1991',NULL,'46',1);
INSERT INTO "T_Konkordanzen" VALUES(414,234,'Beier 1991',NULL,'46',1);
INSERT INTO "T_Konkordanzen" VALUES(415,236,'Beier 1991',NULL,'46',1);
INSERT INTO "T_Konkordanzen" VALUES(416,237,'Beier 1991',NULL,'46',1);
INSERT INTO "T_Konkordanzen" VALUES(417,238,'Beier 1991',NULL,'46',1);
INSERT INTO "T_Konkordanzen" VALUES(418,239,'Beier 1991',NULL,'46',1);
INSERT INTO "T_Konkordanzen" VALUES(419,240,'Beier 1991',NULL,'46',1);
INSERT INTO "T_Konkordanzen" VALUES(420,241,'Beier 1991',NULL,'46',1);
INSERT INTO "T_Konkordanzen" VALUES(421,515,'Beier 1991',NULL,'46',1);
INSERT INTO "T_Konkordanzen" VALUES(422,516,'Beier 1991',NULL,'46',1);
INSERT INTO "T_Konkordanzen" VALUES(423,212,'Beier 1991',NULL,'45',1);
INSERT INTO "T_Konkordanzen" VALUES(424,213,'Beier 1991',NULL,'45',1);
INSERT INTO "T_Konkordanzen" VALUES(425,214,'Beier 1991',NULL,'45',1);
INSERT INTO "T_Konkordanzen" VALUES(426,217,'Beier 1991',NULL,'45',1);
INSERT INTO "T_Konkordanzen" VALUES(427,218,'Beier 1991',NULL,'45',1);
INSERT INTO "T_Konkordanzen" VALUES(428,219,'Beier 1991',NULL,'45',1);
INSERT INTO "T_Konkordanzen" VALUES(430,220,'Beier 1991',NULL,'45',1);
INSERT INTO "T_Konkordanzen" VALUES(431,221,'Beier 1991',NULL,'45',1);
INSERT INTO "T_Konkordanzen" VALUES(432,222,'Beier 1991',NULL,'45',1);
INSERT INTO "T_Konkordanzen" VALUES(433,223,'Beier 1991',NULL,'45',1);
INSERT INTO "T_Konkordanzen" VALUES(434,509,'Beier 1991',NULL,'45',1);
INSERT INTO "T_Konkordanzen" VALUES(435,510,'Beier 1991',NULL,'45',1);
INSERT INTO "T_Konkordanzen" VALUES(436,511,'Beier 1991',NULL,'45',1);
INSERT INTO "T_Konkordanzen" VALUES(437,513,'Beier 1991',NULL,'45',1);
INSERT INTO "T_Konkordanzen" VALUES(438,304,'Beier',NULL,NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(440,301,'Bericht Mewes',NULL,NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(441,362,'Blasius 1901',NULL,'10',1);
INSERT INTO "T_Konkordanzen" VALUES(442,360,'Blasius 1901',NULL,'9',1);
INSERT INTO "T_Konkordanzen" VALUES(443,356,'Blasius 1901',NULL,'8',1);
INSERT INTO "T_Konkordanzen" VALUES(444,359,'Blasius 1901',NULL,'8',1);
INSERT INTO "T_Konkordanzen" VALUES(446,356,'Blasius 1901',NULL,'6',1);
INSERT INTO "T_Konkordanzen" VALUES(447,354,'Blasius 1901',NULL,'5',1);
INSERT INTO "T_Konkordanzen" VALUES(449,362,'Blasius 1901',NULL,'4',1);
INSERT INTO "T_Konkordanzen" VALUES(450,350,'Blasius 1901',NULL,'3',1);
INSERT INTO "T_Konkordanzen" VALUES(451,349,'Böttcher 1987',NULL,'80',1);
INSERT INTO "T_Konkordanzen" VALUES(452,390,'Brunn 1958',NULL,'56',1);
INSERT INTO "T_Konkordanzen" VALUES(453,389,'Brunn 1958',NULL,'45',1);
INSERT INTO "T_Konkordanzen" VALUES(455,375,'Fischer 1956',NULL,NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(456,216,'Fischer 1956',NULL,'270',1);
INSERT INTO "T_Konkordanzen" VALUES(457,270,'Maas 1900',NULL,NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(458,384,'Götze 1921',NULL,'99',1);
INSERT INTO "T_Konkordanzen" VALUES(459,214,'Herms 1928',NULL,'261',1);
INSERT INTO "T_Konkordanzen" VALUES(460,509,'Herms 1928',NULL,'259',1);
INSERT INTO "T_Konkordanzen" VALUES(461,510,'Herms 1928',NULL,'259',1);
INSERT INTO "T_Konkordanzen" VALUES(462,511,'Herms 1928',NULL,'259',1);
INSERT INTO "T_Konkordanzen" VALUES(463,224,'Herms 1928',NULL,'258',1);
INSERT INTO "T_Konkordanzen" VALUES(464,225,'Herms 1928',NULL,'258',1);
INSERT INTO "T_Konkordanzen" VALUES(465,226,'Herms 1928',NULL,'258',1);
INSERT INTO "T_Konkordanzen" VALUES(466,227,'Herms 1928',NULL,'258',1);
INSERT INTO "T_Konkordanzen" VALUES(467,230,'Herms 1928',NULL,'258',1);
INSERT INTO "T_Konkordanzen" VALUES(468,231,'Herms 1928',NULL,'258',1);
INSERT INTO "T_Konkordanzen" VALUES(469,232,'Herms 1928',NULL,'258',1);
INSERT INTO "T_Konkordanzen" VALUES(470,233,'Herms 1928',NULL,'258',1);
INSERT INTO "T_Konkordanzen" VALUES(471,234,'Herms 1928',NULL,'258',1);
INSERT INTO "T_Konkordanzen" VALUES(472,236,'Herms 1928',NULL,'258',1);
INSERT INTO "T_Konkordanzen" VALUES(473,220,'Herms 1928',NULL,'257',1);
INSERT INTO "T_Konkordanzen" VALUES(474,228,'Herms 1928',NULL,'257',1);
INSERT INTO "T_Konkordanzen" VALUES(475,229,'Herms 1928',NULL,'257',1);
INSERT INTO "T_Konkordanzen" VALUES(476,515,'Herms 1928',NULL,'257',1);
INSERT INTO "T_Konkordanzen" VALUES(477,217,'Herms 1928',NULL,'256',1);
INSERT INTO "T_Konkordanzen" VALUES(478,218,'Herms 1928',NULL,'256',1);
INSERT INTO "T_Konkordanzen" VALUES(479,237,'Herms 1928',NULL,'255',1);
INSERT INTO "T_Konkordanzen" VALUES(480,238,'Herms 1928',NULL,'255',1);
INSERT INTO "T_Konkordanzen" VALUES(481,222,'Herms 1928',NULL,'254',1);
INSERT INTO "T_Konkordanzen" VALUES(482,223,'Herms 1928',NULL,'254',1);
INSERT INTO "T_Konkordanzen" VALUES(483,239,'Herms 1928',NULL,'254',1);
INSERT INTO "T_Konkordanzen" VALUES(484,240,'Herms 1928',NULL,'254',1);
INSERT INTO "T_Konkordanzen" VALUES(485,241,'Herms 1928',NULL,'253',1);
INSERT INTO "T_Konkordanzen" VALUES(486,383,'Herms 1928',NULL,'253',1);
INSERT INTO "T_Konkordanzen" VALUES(487,516,'Herms 1928',NULL,'253',1);
INSERT INTO "T_Konkordanzen" VALUES(488,381,'Herms 1928',NULL,'252',1);
INSERT INTO "T_Konkordanzen" VALUES(491,219,'Herms 1928',NULL,'246',1);
INSERT INTO "T_Konkordanzen" VALUES(492,385,'Herms 1928',NULL,'245',1);
INSERT INTO "T_Konkordanzen" VALUES(493,213,'Herms 1928',NULL,'244',1);
INSERT INTO "T_Konkordanzen" VALUES(494,380,'Herms 1928',NULL,'244',1);
INSERT INTO "T_Konkordanzen" VALUES(495,251,'Preuß 1973',NULL,NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(496,270,'Preuß 1973',NULL,NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(497,276,'Preuß 1973',NULL,NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(498,277,'Preuß 1973',NULL,NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(499,285,'Preuß 1973',NULL,NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(500,97,'Preuß 1980',NULL,'101',1);
INSERT INTO "T_Konkordanzen" VALUES(501,100,'Preuß 1980',NULL,'101',1);
INSERT INTO "T_Konkordanzen" VALUES(502,102,'Preuß 1980',NULL,'101',1);
INSERT INTO "T_Konkordanzen" VALUES(504,293,'Schlette 1962',NULL,NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(505,295,'Schlette 1962',NULL,'148-158',1);
INSERT INTO "T_Konkordanzen" VALUES(506,296,'Schlette 1962',NULL,NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(508,376,'Schultheiß 1875',NULL,'26',1);
INSERT INTO "T_Konkordanzen" VALUES(509,377,'Schultheiß 1875',NULL,'26',1);
INSERT INTO "T_Konkordanzen" VALUES(510,378,'Schultheiß 1875',NULL,'26',1);
INSERT INTO "T_Konkordanzen" VALUES(511,379,'Schultheiß 1875',NULL,'26',1);
INSERT INTO "T_Konkordanzen" VALUES(512,373,'Schultheiß 1875',NULL,'22',1);
INSERT INTO "T_Konkordanzen" VALUES(513,374,'Schultheiß 1875',NULL,'22',1);
INSERT INTO "T_Konkordanzen" VALUES(514,221,'Voss 1887',NULL,NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(515,256,'Wegener 1896',NULL,NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(516,309,'Wegener 1896',NULL,NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(517,313,'Wegener 1896',NULL,NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(518,324,'Wegener 1896',NULL,NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(519,332,'Wegener 1896',NULL,NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(520,345,'Wegener 1896',NULL,NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(521,346,'Wegener 1896',NULL,NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(522,426,'Wegener 1896',NULL,'332, 334',1);
INSERT INTO "T_Konkordanzen" VALUES(523,216,'LDA SEFundstelleID','824',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(524,219,'LDA SEFundstelleID','7787',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(525,235,'LDA SEFundstelleID','253156',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(526,242,'LDA SEFundstelleID','14586',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(527,243,'LDA SEFundstelleID','14587',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(528,244,'LDA SEFundstelleID','14588',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(529,246,'LDA SEFundstelleID','14589',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(530,247,'LDA SEFundstelleID','14594',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(531,248,'LDA SEFundstelleID','14595',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(532,249,'LDA SEFundstelleID','14596',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(533,250,'LDA SEFundstelleID','14597',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(534,251,'LDA SEFundstelleID','14598',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(535,252,'LDA SEFundstelleID','14599',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(536,253,'LDA SEFundstelleID','1460',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(537,254,'LDA SEFundstelleID','14569',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(538,255,'LDA SEFundstelleID','1462',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(539,256,'LDA SEFundstelleID','1463',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(540,257,'LDA SEFundstelleID','1464',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(541,258,'LDA SEFundstelleID','1465',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(542,259,'LDA SEFundstelleID','1466',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(543,260,'LDA SEFundstelleID','1467',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(544,261,'LDA SEFundstelleID','14568',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(545,262,'LDA SEFundstelleID','1468',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(546,263,'LDA SEFundstelleID','1469',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(547,264,'LDA SEFundstelleID','1461',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(548,265,'LDA SEFundstelleID','14611',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(549,266,'LDA SEFundstelleID','14612',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(550,267,'LDA SEFundstelleID','14613',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(551,268,'LDA SEFundstelleID','14614',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(552,269,'LDA SEFundstelleID','14615',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(553,270,'LDA SEFundstelleID','14616',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(554,271,'LDA SEFundstelleID','14617',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(555,272,'LDA SEFundstelleID','14618',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(556,273,'LDA SEFundstelleID','14619',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(557,274,'LDA SEFundstelleID','1462',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(558,275,'LDA SEFundstelleID','14621',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(559,276,'LDA SEFundstelleID','14567',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(560,277,'LDA SEFundstelleID','14566',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(561,278,'LDA SEFundstelleID','432248',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(562,284,'LDA SEFundstelleID','14622',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(563,285,'LDA SEFundstelleID','14565',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(564,286,'LDA SEFundstelleID','14564',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(565,287,'LDA SEFundstelleID','14623',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(566,288,'LDA SEFundstelleID','14624',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(567,289,'LDA SEFundstelleID','14625',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(568,290,'LDA SEFundstelleID','14563',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(569,291,'LDA SEFundstelleID','14562',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(570,292,'LDA SEFundstelleID','14645',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(571,293,'LDA SEFundstelleID','14583',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(572,294,'LDA SEFundstelleID','14582',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(573,295,'LDA SEFundstelleID','14581',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(574,296,'LDA SEFundstelleID','1458',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(575,297,'LDA SEFundstelleID','14647',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(576,298,'LDA SEFundstelleID','14648',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(577,299,'LDA SEFundstelleID','14579',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(579,301,'LDA SEFundstelleID','14577',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(580,302,'LDA SEFundstelleID','14576',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(581,304,'LDA SEFundstelleID','1508',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(582,308,'LDA SEFundstelleID','15313',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(583,309,'LDA SEFundstelleID','15315',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(584,310,'LDA SEFundstelleID','15316',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(585,312,'LDA SEFundstelleID','15141',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(586,313,'LDA SEFundstelleID','15142',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(589,316,'LDA SEFundstelleID','15145',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(590,317,'LDA SEFundstelleID','15146',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(591,318,'LDA SEFundstelleID','15147',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(592,319,'LDA SEFundstelleID','15148',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(593,320,'LDA SEFundstelleID','15149',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(594,321,'LDA SEFundstelleID','1515',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(595,322,'LDA SEFundstelleID','15151',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(596,323,'LDA SEFundstelleID','15152',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(597,324,'LDA SEFundstelleID','15153',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(598,325,'LDA SEFundstelleID','15154',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(599,326,'LDA SEFundstelleID','15155',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(600,327,'LDA SEFundstelleID','15156',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(601,328,'LDA SEFundstelleID','15157',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(602,329,'LDA SEFundstelleID','15158',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(603,330,'LDA SEFundstelleID','15159',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(604,331,'LDA SEFundstelleID','1516',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(605,332,'LDA SEFundstelleID','1512',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(606,333,'LDA SEFundstelleID','15363',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(607,335,'LDA SEFundstelleID','15371',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(608,336,'LDA SEFundstelleID','15372',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(609,337,'LDA SEFundstelleID','15373',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(610,338,'LDA SEFundstelleID','15374',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(611,339,'LDA SEFundstelleID','15375',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(612,340,'LDA SEFundstelleID','15376',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(613,341,'LDA SEFundstelleID','1513',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(614,342,'LDA SEFundstelleID','15129',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(615,344,'LDA SEFundstelleID','15996',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(616,345,'LDA SEFundstelleID','15994',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(617,346,'LDA SEFundstelleID','15993',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(618,347,'LDA SEFundstelleID','15998',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(619,348,'LDA SEFundstelleID','9628',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(620,350,'LDA SEFundstelleID','1366',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(621,351,'LDA SEFundstelleID','3431',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(622,363,'LDA SEFundstelleID','1359',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(623,365,'LDA SEFundstelleID','13592',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(624,366,'LDA SEFundstelleID','13593',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(625,367,'LDA SEFundstelleID','13594',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(626,368,'LDA SEFundstelleID','13595',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(627,375,'LDA SEFundstelleID','14697',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(628,386,'LDA SEFundstelleID','432251',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(629,387,'LDA SEFundstelleID','432250',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(630,388,'LDA SEFundstelleID','432252',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(631,394,'LDA SEFundstelleID','2888',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(632,395,'LDA SEFundstelleID','289',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(633,396,'LDA SEFundstelleID','2786',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(634,397,'LDA SEFundstelleID','2666',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(635,405,'LDA SEFundstelleID','8657',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(636,409,'LDA SEFundstelleID','9293',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(637,410,'LDA SEFundstelleID','9294',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(638,411,'LDA SEFundstelleID','9482',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(639,417,'LDA SEFundstelleID','2546',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(640,418,'LDA SEFundstelleID','15163',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(641,419,'LDA SEFundstelleID','15161',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(642,420,'LDA SEFundstelleID','15164',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(643,421,'LDA SEFundstelleID','15162',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(644,422,'LDA SEFundstelleID','1476',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(645,423,'LDA SEFundstelleID','15377',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(646,430,'LDA SEFundstelleID','14575',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(647,431,'LDA SEFundstelleID','14574',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(648,432,'LDA SEFundstelleID','14573',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(649,433,'LDA SEFundstelleID','14572',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(650,434,'LDA SEFundstelleID','14571',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(651,435,'LDA SEFundstelleID','1457',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(652,436,'LDA SEFundstelleID','15126',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(653,437,'LDA SEFundstelleID','15127',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(654,438,'LDA SEFundstelleID','14763',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(655,439,'LDA SEFundstelleID','14764',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(656,440,'LDA SEFundstelleID','14765',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(657,441,'LDA SEFundstelleID','15119',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(658,445,'LDA SEFundstelleID','15123',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(659,446,'LDA SEFundstelleID','15122',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(660,448,'LDA SEFundstelleID','3726',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(661,449,'LDA SEFundstelleID','1463',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(662,450,'LDA SEFundstelleID','14996',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(663,451,'LDA SEFundstelleID','14997',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(664,453,'LDA SEFundstelleID','15128',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(665,454,'LDA SEFundstelleID','15121',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(666,455,'LDA SEFundstelleID','15383',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(667,456,'LDA SEFundstelleID','15386',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(668,507,'LDA SEFundstelleID','15123',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(669,508,'LDA SEFundstelleID','15123',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(671,307,'Saal','3',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(672,307,'Rahmlow 1960','67','30',1);
INSERT INTO "T_Konkordanzen" VALUES(673,307,'Stuhlmann','88',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(676,296,'Blasius 1901','XXc, XXd',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(677,295,'Blasius 1901','XXc',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(678,333,'Blasius 1901','Ixa','116-117',1);
INSERT INTO "T_Konkordanzen" VALUES(680,261,'Schlette 1962',NULL,'138',1);
INSERT INTO "T_Konkordanzen" VALUES(681,292,'Stuhlmann','2',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(682,292,'Blasius 1901','XXe',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(683,292,'Rahmlow 1960','5','31',1);
INSERT INTO "T_Konkordanzen" VALUES(684,293,'Niquet 1934/35',NULL,'123-124',1);
INSERT INTO "T_Konkordanzen" VALUES(685,293,'Niquet 1934/35',NULL,'123-124',1);
INSERT INTO "T_Konkordanzen" VALUES(686,295,'Stuhlmann','4',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(687,299,'Schlette 1962',NULL,'138',1);
INSERT INTO "T_Konkordanzen" VALUES(688,299,'Stuhlmann','3',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(689,434,'Blasius 1901','XIXd',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(690,435,'Blasius 1901','XXb',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(691,333,'Wegener 1898',NULL,'100-103',1);
INSERT INTO "T_Konkordanzen" VALUES(693,342,'Blasius 1901','VIIIa','115f.',1);
INSERT INTO "T_Konkordanzen" VALUES(694,426,'Blasius 1901','Ic','105',1);
INSERT INTO "T_Konkordanzen" VALUES(695,294,'Blasius 1901','XIVa',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(696,297,'Blasius 1901','XIXb',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(697,298,'Blasius 1901','XXf',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(699,242,'Blasius 1901','XIh',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(700,243,'Blasius 1901','XIg',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(701,244,'Blasius 1901','XIf',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(702,246,'Blasius 1901','XIe',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(703,247,'Blasius 1901','XId',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(704,248,'Blasius 1901','XIc',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(705,249,'Blasius 1901','Xb',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(706,250,'Blasius 1901','Xa',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(707,251,'Blasius 1901','XIl',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(708,252,'Blasius 1901','XIk',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(709,253,'Blasius 1901','XIb',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(710,254,'Blasius 1901','XIa',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(711,255,'Blasius 1901','XVIa',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(712,258,'Blasius 1901','XVIb',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(713,257,'Blasius 1901','XVId',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(714,256,'Blasius 1901','XVIc',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(715,259,'Blasius 1901','XVIe',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(716,260,'Blasius 1901','XVIf',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(717,262,'Blasius 1901','XVIg',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(718,263,'Blasius 1901','XVIIa',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(719,264,'Blasius 1901','XVIIb',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(720,265,'Blasius 1901','XVIIc',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(721,266,'Blasius 1901','XVIId',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(722,267,'Blasius 1901','XVIIf',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(723,268,'Blasius 1901','XVIIe',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(724,269,'Blasius 1901','XVIIIa',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(725,270,'Blasius 1901','XIIa',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(726,271,'Blasius 1901','XIIb',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(727,272,'Blasius 1901','XIIIa',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(728,273,'Blasius 1901','XIIIb',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(729,276,'Blasius 1901','XIVc',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(730,277,'Blasius 1901','XIVb',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(731,284,'Blasius 1901','XXIc',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(732,285,'Blasius 1901','XXIa',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(734,313,'Blasius 1901','Ve',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(735,314,'Blasius 1901','Vd',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(736,315,'Blasius 1901','Vc',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(737,316,'Blasius 1901','Vb',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(738,317,'Blasius 1901','Va',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(739,318,'Blasius 1901','VIa',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(740,319,'Blasius 1901','VIc',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(741,320,'Blasius 1901','VIb',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(742,321,'Blasius 1901','VIIb',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(743,322,'Blasius 1901','IVe',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(744,323,'Blasius 1901','IVd',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(745,324,'Blasius 1901','IVc',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(746,325,'Blasius 1901','IVb',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(747,326,'Blasius 1901','IVa',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(748,327,'Blasius 1901','IVe',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(749,328,'Blasius 1901','IIIc',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(750,329,'Blasius 1901','IIId',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(751,330,'Blasius 1901','IIIb',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(752,335,'Blasius 1901','IXb',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(753,337,'Blasius 1901','VIIa',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(754,338,'Blasius 1901','VIId',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(755,339,'Blasius 1901','VIIe',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(756,340,'Blasius 1901','VIIc',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(758,286,'Blasius 1901','XXIb',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(759,300,'Blasius 1901','XXa',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(760,300,'Rahmlow 1960','9','31',1);
INSERT INTO "T_Konkordanzen" VALUES(761,300,'Stuhlmann','8',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(762,301,'Blasius 1901','XIXa',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(763,433,'Blasius 1901','XIXc',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(764,332,'Blasius 1901','IXa',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(765,308,'Rahmlow 1960','23','32',1);
INSERT INTO "T_Konkordanzen" VALUES(766,310,'Blasius 1901','IIIa',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(767,341,'Blasius 1901','VIIIb',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(768,345,'Blasius 1901','Ia',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(769,346,'Blasius 1901','Ib',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(770,331,'Blasius 1901','Vf',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(771,309,'Blasius 1901','IIa',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(772,423,'Blasius 1901','VIIIc',NULL,1);
INSERT INTO "T_Konkordanzen" VALUES(773,311,'Rahmlow 1971','48','7',1);
INSERT INTO "T_Konkordanzen" VALUES(774,314,'Rahmlow 1961','44','29',1);
INSERT INTO "T_Konkordanzen" VALUES(775,315,'Rahmlow 1960','45','29',1);
INSERT INTO "T_Konkordanzen" VALUES(776,523,'Rahmlow 1960','32','32',1);
INSERT INTO "T_Konkordanzen" VALUES(777,523,'Stuhlmann','60',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(778,454,'Rahmlow 1960','37','32',1);
INSERT INTO "T_Konkordanzen" VALUES(779,454,'Stuhlmann','87',NULL,0);
INSERT INTO "T_Konkordanzen" VALUES(780,507,'Rahmlow 1960','38','32',1);
INSERT INTO "T_Konkordanzen" VALUES(781,508,'Rahmlow 1960','39','32',1);
INSERT INTO "T_Konkordanzen" VALUES(782,303,'Rahmlow 1960','42','32',1);

/* Comment 
------------------------
 Table with measurment or counting of different dimensions.
"Mass": dimension 
"Wert": value of the dimension
"dezimale": precision of the value (decimals)
"Einheit": entity (gezählt=counted, m, etc. )
"datum": date of the measurement
 */
DROP TABLE IF EXISTS "T_Masse";
CREATE TABLE "T_Masse" (
"masseID" INTEGER PRIMARY KEY AUTOINCREMENT, 
"MegaID" integer, 
"Mass" text, 
"Wert" real, 
"dezimale" integer, 
"Einheit" text, 
"datum" datetime,
FOREIGN KEY (MegaID) REFERENCES T_MegalitheDaten(MegaID)
);
INSERT INTO "T_Masse" VALUES(1,29,'Steine erhalten',7,0,'gezählt','1.1.2010 00:00:00');
INSERT INTO "T_Masse" VALUES(2,34,'Steine erhalten',24,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(3,35,'Steine erhalten',13,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(4,37,'Steine erhalten',35,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(5,38,'Steine erhalten',49,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(6,40,'Steine erhalten',54,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(7,44,'Steine erhalten',19,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(8,50,'Steine erhalten',21,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(9,55,'Steine erhalten',21,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(10,56,'Steine erhalten',16,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(11,62,'Steine erhalten',71,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(12,76,'Steine erhalten',24,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(13,80,'Steine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(14,82,'Steine erhalten',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(15,93,'Steine erhalten',45,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(16,97,'Steine erhalten',10,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(17,98,'Steine erhalten',26,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(18,99,'Steine erhalten',49,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(19,100,'Steine erhalten',16,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(20,101,'Steine erhalten',48,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(21,102,'Steine erhalten',74,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(22,103,'Steine erhalten',12,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(23,104,'Steine erhalten',14,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(24,112,'Steine erhalten',19,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(25,113,'Steine erhalten',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(26,116,'Steine erhalten',8,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(27,117,'Steine erhalten',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(28,118,'Steine erhalten',70,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(29,119,'Steine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(30,120,'Steine erhalten',21,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(31,121,'Steine erhalten',14,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(32,126,'Steine erhalten',49,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(33,151,'Steine erhalten',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(34,152,'Steine erhalten',17,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(35,174,'Steine erhalten',14,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(36,175,'Steine erhalten',11,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(37,178,'Steine erhalten',9,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(38,185,'Steine erhalten',76,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(39,188,'Steine erhalten',21,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(40,189,'Steine erhalten',11,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(41,192,'Steine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(42,193,'Steine erhalten',25,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(43,194,'Steine erhalten',46,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(44,195,'Steine erhalten',19,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(45,209,'Steine erhalten',40,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(46,242,'Steine erhalten',43,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(47,243,'Steine erhalten',38,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(48,244,'Steine erhalten',36,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(49,246,'Steine erhalten',28,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(50,247,'Steine erhalten',22,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(51,248,'Steine erhalten',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(52,249,'Steine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(53,250,'Steine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(54,251,'Steine erhalten',47,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(55,252,'Steine erhalten',12,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(56,254,'Steine erhalten',32,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(57,255,'Steine erhalten',27,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(58,256,'Steine erhalten',12,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(59,257,'Steine erhalten',16,0,'gezählt','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(60,258,'Steine erhalten',8,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(61,259,'Steine erhalten',17,0,'gezählt','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(62,260,'Steine erhalten',10,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(63,262,'Steine erhalten',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(64,263,'Steine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(65,264,'Steine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(66,265,'Steine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(68,267,'Steine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(69,268,'Steine erhalten',28,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(70,270,'Steine erhalten',69,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(71,271,'Steine erhalten',17,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(72,272,'Steine erhalten',13,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(73,274,'Steine erhalten',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(75,277,'Steine erhalten',11,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(76,285,'Steine erhalten',14,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(77,297,'Steine erhalten',10,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(78,298,'Steine erhalten',11,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(79,312,'Steine erhalten',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(80,313,'Steine erhalten',12,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(81,316,'Steine erhalten',14,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(82,317,'Steine erhalten',11,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(83,318,'Steine erhalten',56,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(84,319,'Steine erhalten',19,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(85,320,'Steine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(86,321,'Steine erhalten',14,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(87,322,'Steine erhalten',41,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(88,323,'Steine erhalten',12,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(89,324,'Steine erhalten',61,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(90,325,'Steine erhalten',16,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(91,326,'Steine erhalten',24,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(92,327,'Steine erhalten',32,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(93,328,'Steine erhalten',40,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(94,329,'Steine erhalten',13,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(95,330,'Steine erhalten',56,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(96,331,'Steine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(98,335,'Steine erhalten',35,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(99,337,'Steine erhalten',20,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(100,338,'Steine erhalten',9,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(101,339,'Steine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(102,340,'Steine erhalten',15,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(103,419,'Steine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(104,420,'Steine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(105,422,'Steine erhalten',18,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(106,423,'Steine erhalten',11,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(108,428,'Steine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(109,3,'Länge Umfassung',10.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(110,4,'Länge Umfassung',6.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(111,5,'Länge Umfassung',34,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(112,10,'Länge Umfassung',11,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(114,17,'Länge Umfassung',25.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(116,26,'Länge Umfassung',13.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(117,29,'Länge Umfassung',23,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(119,37,'Länge Umfassung',13.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(120,38,'Länge Umfassung',25,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(121,40,'Länge Umfassung',32,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(122,42,'Länge Umfassung',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(123,44,'Länge Umfassung',26.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(125,48,'Länge Umfassung',42,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(126,50,'Länge Umfassung',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(127,51,'Länge Umfassung',8.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(131,57,'Länge Umfassung',30,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(132,60,'Länge Umfassung',10,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(133,62,'Länge Umfassung',43.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(135,63,'Länge Umfassung',10.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(136,64,'Länge Umfassung',10.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(138,67,'Länge Umfassung',13.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(140,70,'Länge Umfassung',25,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(143,78,'Länge Umfassung',11.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(144,80,'Länge Umfassung',9.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(146,85,'Länge Umfassung',21.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(147,88,'Länge Umfassung',12,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(150,93,'Länge Umfassung',18,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(153,98,'Länge Umfassung',12.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(154,99,'Länge Umfassung',28.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(155,100,'Länge Umfassung',11,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(156,101,'Länge Umfassung',24,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(157,102,'Länge Umfassung',37.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(158,105,'Länge Umfassung',32,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(159,106,'Länge Umfassung',10,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(160,107,'Länge Umfassung',18.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(163,110,'Länge Umfassung',6.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(164,118,'Länge Umfassung',35.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(165,119,'Länge Umfassung',24,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(166,120,'Länge Umfassung',19.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(167,122,'Länge Umfassung',15.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(169,126,'Länge Umfassung',28.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(170,126,'Länge Umfassung',15.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(172,130,'Länge Umfassung',13.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(174,151,'Länge Umfassung',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(176,159,'Länge Umfassung',12,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(178,167,'Länge Umfassung',9.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(179,173,'Länge Umfassung',30,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(181,174,'Länge Umfassung',8.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(186,194,'Länge Umfassung',23.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(190,207,'Länge Umfassung',8.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(194,242,'Länge Umfassung',17.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(195,243,'Länge Umfassung',22.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(197,246,'Länge Umfassung',15,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(208,268,'Länge Umfassung',14.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(220,292,'Länge Umfassung',33,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(221,293,'Länge Umfassung',22,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(230,310,'Länge Umfassung',24,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(251,340,'Länge Umfassung',15,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(255,398,'Länge Umfassung',25,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(264,507,'Länge Umfassung',28,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(265,508,'Länge Umfassung',28,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(270,12,'Länge Umfassung',39,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(272,19,'Länge Umfassung',25.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(275,35,'Länge Umfassung',17.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(281,46,'Länge Umfassung',7.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(285,55,'Länge Umfassung',24.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(286,55,'Länge Umfassung',12,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(287,56,'Länge Umfassung',11.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(291,62,'Länge Umfassung',6.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(294,65,'Länge Umfassung',10.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(295,67,'Länge Umfassung',13.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(296,68,'Länge Umfassung',15.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(298,76,'Länge Umfassung',13.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(299,76,'Länge Umfassung',13.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(302,84,'Länge Umfassung',17,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(305,89,'Länge Umfassung',37.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(306,91,'Länge Umfassung',13.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(308,94,'Länge Umfassung',9.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(309,95,'Länge Umfassung',7.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(315,105,'Länge Umfassung',32,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(318,108,'Länge Umfassung',13.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(319,109,'Länge Umfassung',6.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(325,125,'Länge Umfassung',13.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(328,127,'Länge Umfassung',20.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(330,131,'Länge Umfassung',26.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(332,156,'Länge Umfassung',12,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(334,165,'Länge Umfassung',12.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(339,185,'Länge Umfassung',46.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(340,186,'Länge Umfassung',47,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(341,189,'Länge Umfassung',20,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(342,191,'Länge Umfassung',12.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(344,195,'Länge Umfassung',7.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(345,202,'Länge Umfassung',10,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(346,203,'Länge Umfassung',31.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(348,209,'Länge Umfassung',54,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(349,223,'Länge Umfassung',105,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(350,225,'Länge Umfassung',30,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(353,244,'Länge Umfassung',21,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(356,251,'Länge Umfassung',17,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(358,253,'Länge Umfassung',16,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(366,270,'Länge Umfassung',19,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(367,271,'Länge Umfassung',16,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(375,287,'Länge Hügel',16,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(383,303,'Länge Umfassung',42,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(391,317,'Länge Umfassung',13.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(392,318,'Länge Umfassung',20,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(393,319,'Länge Umfassung',14,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(394,322,'Länge Umfassung',20.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(395,324,'Länge Umfassung',23,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(397,326,'Länge Umfassung',11,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(398,327,'Länge Umfassung',13.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(401,330,'Länge Umfassung',20,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(411,381,'Länge Umfassung',51,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(413,422,'Länge Umfassung',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(418,445,'Länge Umfassung',28,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(423,12,'Breite Umfassung',8.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(424,29,'Breite Umfassung',6.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(425,37,'Breite Umfassung',7,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(426,38,'Breite Umfassung',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(427,40,'Breite Umfassung',7,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(428,44,'Breite Umfassung',8.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(429,50,'Breite Umfassung',7.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(430,55,'Breite Umfassung',10,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(431,62,'Breite Umfassung',6,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(432,93,'Breite Umfassung',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(433,98,'Breite Umfassung',7,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(434,99,'Breite Umfassung',8.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(435,101,'Breite Umfassung',5,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(436,102,'Breite Umfassung',4.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(437,118,'Breite Umfassung',5.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(438,120,'Breite Umfassung',5.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(439,126,'Breite Umfassung',7,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(440,151,'Breite Umfassung',3.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(441,185,'Breite Umfassung',4.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(442,189,'Breite Umfassung',8.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(443,194,'Breite Umfassung',5.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(444,209,'Breite Umfassung',5.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(445,242,'Breite Umfassung',9,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(446,243,'Breite Umfassung',7.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(447,244,'Breite Umfassung',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(448,246,'Breite Umfassung',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(450,251,'Breite Umfassung',5,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(451,252,'Breite Umfassung',5,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(453,255,'Breite Umfassung',6,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(456,270,'Breite Umfassung',6,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(459,318,'Breite Umfassung',6.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(460,319,'Breite Umfassung',6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(461,322,'Breite Umfassung',6,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(462,324,'Breite Umfassung',8.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(464,326,'Breite Umfassung',5.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(465,327,'Breite Umfassung',5.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(466,328,'Breite Umfassung',6,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(467,330,'Breite Umfassung',5,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(470,335,'Breite Umfassung',5,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(471,340,'Breite Umfassung',6,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(473,12,'Breite Umfassung',12.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(474,44,'Breite Umfassung',10,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(475,62,'Breite Umfassung',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(476,93,'Breite Umfassung',8.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(477,99,'Breite Umfassung',8.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(478,101,'Breite Umfassung',6.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(479,102,'Breite Umfassung',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(480,112,'Breite Umfassung',8.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(481,118,'Breite Umfassung',8.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(482,126,'Breite Umfassung',8.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(483,185,'Breite Umfassung',6.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(484,194,'Breite Umfassung',6.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(485,209,'Breite Umfassung',7.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(486,244,'Breite Umfassung',6.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(487,246,'Breite Umfassung',8,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(488,251,'Breite Umfassung',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(490,270,'Breite Umfassung',8,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(491,324,'Breite Umfassung',9.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(492,330,'Breite Umfassung',6.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(493,335,'Breite Umfassung',6,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(496,242,'Steine Umfassung',14,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(497,243,'Steine Umfassung',19,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(498,244,'Steine Umfassung',12,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(499,246,'Steine Umfassung',11,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(500,254,'Steine Umfassung',12,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(501,255,'Steine Umfassung',9,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(502,256,'Kammersteine erhalten',9,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(503,270,'Steine Umfassung',30,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(505,327,'Steine Umfassung',16,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(506,328,'Steine Umfassung',8,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(508,251,'Steine Umfassung rekonstr.',26,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(509,270,'Steine Umfassung rekonstr.',40,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(510,12,'Länge Kammer innen',8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(511,29,'Länge Kammer innen',4.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(512,34,'Länge Kammer innen',10.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(513,35,'Länge Kammer innen',4.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(514,37,'Länge Kammer innen',5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(515,38,'Länge Kammer innen',6.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(516,40,'Länge Kammer innen',6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(517,44,'Länge Kammer innen',5.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(518,50,'Länge Kammer innen',6.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(519,55,'Länge Kammer innen',9.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(520,56,'Länge Kammer innen',8.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(521,62,'Länge Kammer innen',8.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(522,76,'Länge Kammer innen',7.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(523,80,'Länge Kammer innen',6.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(524,82,'Länge Kammer innen',3.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(525,97,'Länge Kammer innen',3.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(526,98,'Länge Kammer innen',5.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(527,99,'Länge Kammer innen',6.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(528,100,'Länge Kammer innen',6.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(529,101,'Länge Kammer innen',7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(530,102,'Länge Kammer innen',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(531,103,'Länge Kammer innen',4.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(532,104,'Länge Kammer innen',4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(533,112,'Länge Kammer innen',3.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(534,113,'Länge Kammer innen',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(535,115,'Länge Kammer innen',2.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(536,116,'Länge Kammer innen',3.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(537,117,'Länge Kammer innen',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(538,118,'Länge Kammer innen',7.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(539,119,'Länge Kammer innen',3.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(540,120,'Länge Kammer innen',4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(541,151,'Länge Kammer innen',4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(542,152,'Länge Kammer innen',5.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(543,174,'Länge Kammer innen',8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(544,175,'Länge Kammer innen',5.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(545,178,'Länge Kammer innen',4.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(546,185,'Länge Kammer innen',8.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(547,188,'Länge Kammer innen',9.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(548,193,'Länge Kammer innen',11.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(549,194,'Länge Kammer innen',5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(550,195,'Länge Kammer innen',3.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(551,209,'Länge Kammer innen',7.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(552,219,'Länge Kammer innen',3.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(553,251,'Länge Kammer innen',8.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(554,270,'Länge Kammer innen',7.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(555,283,'Länge Kammer innen',5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(556,293,'Länge Kammer innen',4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(557,295,'Länge Kammer innen',3.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(558,296,'Länge Kammer innen',9.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(559,370,'Länge Kammer innen',3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(560,372,'Länge Kammer innen',4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(561,375,'Länge Kammer innen',7.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(562,393,'Länge Kammer innen',2.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(563,397,'Länge Kammer innen',7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(564,405,'Länge Kammer innen',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(565,409,'Länge Kammer innen',5.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(566,410,'Länge Kammer innen',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(567,411,'Länge Kammer innen',5.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(569,1,'Länge Kammer außen',10,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(570,2,'Länge Kammer außen',10,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(571,12,'Länge Kammer außen',9.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(572,20,'Länge Kammer außen',6.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(573,21,'Länge Kammer außen',13.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(574,22,'Länge Kammer außen',5.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(575,24,'Länge Kammer außen',10,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(576,25,'Länge Kammer außen',6.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(577,29,'Länge Kammer außen',6.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(578,32,'Länge Kammer außen',10.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(579,34,'Länge Kammer außen',11.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(580,35,'Länge Kammer außen',5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(581,37,'Länge Kammer außen',5.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(582,38,'Länge Kammer außen',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(583,40,'Länge Kammer außen',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(584,41,'Länge Kammer außen',4.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(585,44,'Länge Kammer außen',7.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(586,45,'Länge Kammer außen',8.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(587,50,'Länge Kammer außen',8.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(588,52,'Länge Kammer außen',5.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(589,55,'Länge Kammer außen',10.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(590,56,'Länge Kammer außen',9.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(591,58,'Länge Kammer außen',10,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(592,62,'Länge Kammer außen',11,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(593,76,'Länge Kammer außen',8.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(594,80,'Länge Kammer außen',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(595,82,'Länge Kammer außen',5.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(596,93,'Länge Kammer außen',6.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(597,97,'Länge Kammer außen',5.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(598,98,'Länge Kammer außen',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(599,99,'Länge Kammer außen',8.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(600,100,'Länge Kammer außen',8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(601,101,'Länge Kammer außen',8.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(602,102,'Länge Kammer außen',11.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(603,103,'Länge Kammer außen',5.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(604,104,'Länge Kammer außen',5.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(605,112,'Länge Kammer außen',5.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(606,113,'Länge Kammer außen',4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(607,115,'Länge Kammer außen',3.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(608,116,'Länge Kammer außen',5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(609,117,'Länge Kammer außen',3.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(610,118,'Länge Kammer außen',9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(611,119,'Länge Kammer außen',5.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(612,120,'Länge Kammer außen',5.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(613,122,'Länge Kammer außen',4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(614,123,'Länge Kammer außen',10,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(615,128,'Länge Kammer außen',10,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(616,129,'Länge Kammer außen',9.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(617,130,'Länge Kammer außen',3.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(618,131,'Länge Kammer außen',5.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(619,151,'Länge Kammer außen',5.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(620,152,'Länge Kammer außen',6.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(621,160,'Länge Kammer außen',10,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(622,161,'Länge Kammer außen',9.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(623,162,'Länge Kammer außen',5.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(624,163,'Länge Kammer außen',6.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(625,166,'Länge Kammer außen',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(626,173,'Länge Kammer außen',7.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(627,174,'Länge Kammer außen',9.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(628,175,'Länge Kammer außen',6.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(629,178,'Länge Kammer außen',7.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(630,185,'Länge Kammer außen',10.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(631,188,'Länge Kammer außen',10.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(632,191,'Länge Kammer außen',8.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(633,193,'Länge Kammer außen',13,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(634,194,'Länge Kammer außen',6.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(635,195,'Länge Kammer außen',4.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(636,197,'Länge Kammer außen',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(637,204,'Länge Kammer außen',6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(638,205,'Länge Kammer außen',3.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(639,206,'Länge Kammer außen',3.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(640,209,'Länge Kammer außen',8.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(641,219,'Länge Kammer außen',6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(642,235,'Länge Kammer außen',11.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(643,242,'Länge Kammer außen',9.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(644,243,'Länge Kammer außen',9.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(645,244,'Länge Kammer außen',8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(647,251,'Länge Kammer außen',9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(648,253,'Länge Kammer innen',6.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(653,268,'Länge Kammer außen',9.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(654,270,'Länge Kammer außen',9.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(655,282,'Länge Kammer außen',5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(656,283,'Länge Kammer außen',6.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(657,292,'Länge Kammer außen',13.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(658,293,'Länge Kammer außen',5.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(662,313,'Länge Kammer außen',6.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(665,327,'Länge Kammer außen',8.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(666,328,'Länge Kammer außen',10,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(667,330,'Länge Kammer außen',11.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(670,370,'Länge Kammer außen',4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(671,372,'Länge Kammer außen',4.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(672,375,'Länge Kammer außen',8.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(673,393,'Länge Kammer außen',3.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(674,394,'Länge Kammer außen',6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(675,395,'Länge Kammer außen',6.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(676,397,'Länge Kammer außen',8.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(677,402,'Länge Kammer außen',5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(678,405,'Länge Kammer außen',9.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(679,409,'Länge Kammer außen',6.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(680,410,'Länge Kammer außen',2.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(681,411,'Länge Kammer außen',6.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(682,413,'Länge Kammer außen',2.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(683,416,'Länge Kammer außen',5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(685,242,'Länge Kammer innen',6.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(686,243,'Länge Kammer innen',7.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(687,244,'Länge Kammer innen',5.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(688,246,'Länge Kammer innen',7.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(690,254,'Länge Kammer innen',8.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(691,255,'Länge Kammer innen',6,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(692,256,'Länge Kammer innen',3.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(697,262,'Länge Kammer innen',2.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(700,265,'Länge Kammer innen',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(703,268,'Länge Kammer innen',7.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(704,272,'Länge Kammer innen',4.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(705,277,'Länge Kammer innen',5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(708,297,'Länge Kammer innen',9.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(709,298,'Länge Kammer innen',2.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(710,312,'Länge Kammer innen',6.6,1,'m','26.3.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(711,313,'Länge Kammer innen',3.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(714,316,'Länge Kammer innen',4.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(715,318,'Länge Kammer innen',8.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(716,319,'Länge Kammer innen',4.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(717,320,'Länge Kammer innen',4.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(718,321,'Länge Kammer innen',4.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(720,323,'Länge Kammer innen',3.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(721,324,'Länge Kammer innen',5,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(722,325,'Länge Kammer innen',8.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(723,326,'Länge Kammer innen',6.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(724,327,'Länge Kammer innen',7.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(725,328,'Länge Kammer innen',8.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(727,330,'Länge Kammer innen',9.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(729,335,'Länge Kammer innen',9.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(730,337,'Länge Kammer innen',8.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(732,339,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(733,340,'Länge Kammer innen',5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(734,422,'Länge Kammer innen',6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(736,12,'Breite Kammer innen',3.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(738,34,'Breite Kammer innen',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(739,35,'Breite Kammer innen',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(740,37,'Breite Kammer innen',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(741,38,'Breite Kammer innen',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(742,40,'Breite Kammer innen',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(743,44,'Breite Kammer innen',2.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(745,55,'Breite Kammer innen',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(746,56,'Breite Kammer innen',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(748,76,'Breite Kammer innen',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(749,80,'Breite Kammer innen',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(750,82,'Breite Kammer innen',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(752,98,'Breite Kammer innen',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(753,99,'Breite Kammer innen',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(754,100,'Breite Kammer innen',2.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(755,101,'Breite Kammer innen',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(756,102,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(758,104,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(760,113,'Breite Kammer innen',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(761,115,'Breite Kammer innen',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(762,116,'Breite Kammer innen',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(765,119,'Breite Kammer innen',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(767,151,'Breite Kammer innen',1.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(768,152,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(769,174,'Breite Kammer innen',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(770,175,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(771,178,'Breite Kammer innen',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(772,185,'Breite Kammer innen',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(773,188,'Breite Kammer innen',2.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(775,193,'Breite Kammer innen',4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(776,194,'Breite Kammer innen',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(777,195,'Breite Kammer innen',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(778,209,'Breite Kammer innen',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(779,219,'Breite Kammer innen',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(780,251,'Breite Kammer innen',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(781,270,'Breite Kammer innen',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(782,283,'Breite Kammer innen',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(783,285,'Breite Kammer innen',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(784,293,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(785,295,'Breite Kammer innen',1,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(786,296,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(787,370,'Breite Kammer innen',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(788,372,'Breite Kammer innen',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(789,375,'Breite Kammer innen',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(790,393,'Breite Kammer innen',0.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(791,397,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(792,405,'Breite Kammer innen',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(793,409,'Breite Kammer innen',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(794,410,'Breite Kammer innen',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(795,411,'Breite Kammer innen',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(796,1,'Breite Kammer außen',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(797,2,'Breite Kammer außen',1.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(798,12,'Breite Kammer außen',4.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(799,20,'Breite Kammer außen',2.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(800,21,'Breite Kammer außen',2.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(801,22,'Breite Kammer außen',1.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(802,24,'Breite Kammer außen',4.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(803,25,'Breite Kammer außen',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(804,29,'Breite Kammer außen',2.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(805,32,'Breite Kammer außen',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(806,34,'Breite Kammer außen',3.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(807,35,'Breite Kammer außen',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(808,37,'Breite Kammer außen',2.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(809,38,'Breite Kammer außen',2.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(810,40,'Breite Kammer außen',3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(811,41,'Breite Kammer außen',4.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(812,44,'Breite Kammer außen',3.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(813,45,'Breite Kammer außen',3.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(814,50,'Breite Kammer außen',4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(815,52,'Breite Kammer außen',2.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(816,55,'Breite Kammer außen',3.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(817,56,'Breite Kammer außen',3.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(818,58,'Breite Kammer außen',3.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(819,62,'Breite Kammer außen',2.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(820,76,'Breite Kammer außen',3.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(821,80,'Breite Kammer außen',3.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(822,82,'Breite Kammer außen',3.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(823,93,'Breite Kammer außen',1.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(824,97,'Breite Kammer außen',3.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(825,98,'Breite Kammer außen',3.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(826,99,'Breite Kammer außen',4.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(827,100,'Breite Kammer außen',4.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(828,101,'Breite Kammer außen',2.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(829,102,'Breite Kammer außen',3.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(830,103,'Breite Kammer außen',2.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(831,104,'Breite Kammer außen',2.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(832,112,'Breite Kammer außen',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(833,113,'Breite Kammer außen',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(834,115,'Breite Kammer außen',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(835,116,'Breite Kammer außen',3.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(836,117,'Breite Kammer außen',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(837,118,'Breite Kammer außen',3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(838,119,'Breite Kammer außen',2.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(839,120,'Breite Kammer außen',2.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(840,122,'Breite Kammer außen',2.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(841,123,'Breite Kammer außen',3.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(842,128,'Breite Kammer außen',2.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(843,129,'Breite Kammer außen',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(844,131,'Breite Kammer außen',1.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(845,151,'Breite Kammer außen',3.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(846,152,'Breite Kammer außen',3.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(847,160,'Breite Kammer außen',3.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(848,161,'Breite Kammer außen',3.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(849,162,'Breite Kammer außen',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(850,163,'Breite Kammer außen',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(851,166,'Breite Kammer außen',3.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(852,173,'Breite Kammer außen',1.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(853,174,'Breite Kammer außen',3.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(854,175,'Breite Kammer außen',3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(855,178,'Breite Kammer außen',6.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(856,185,'Breite Kammer außen',3.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(857,188,'Breite Kammer außen',3.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(858,189,'Breite Kammer außen',2.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(859,191,'Breite Kammer außen',4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(860,193,'Breite Kammer außen',5.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(861,194,'Breite Kammer außen',3.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(862,195,'Breite Kammer außen',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(863,197,'Breite Kammer außen',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(864,204,'Breite Kammer außen',3.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(865,205,'Breite Kammer außen',3.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(866,206,'Breite Kammer außen',3.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(867,209,'Breite Kammer außen',3.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(868,219,'Breite Kammer außen',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(869,235,'Breite Kammer außen',5.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(870,242,'Breite Kammer außen',3.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(871,243,'Breite Kammer außen',3.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(873,246,'Breite Kammer außen',3.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(874,251,'Breite Kammer außen',3,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(880,268,'Breite Kammer außen',3.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(881,270,'Breite Kammer außen',3.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(882,282,'Breite Kammer außen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(883,283,'Breite Kammer außen',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(884,285,'Breite Kammer außen',2.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(885,292,'Breite Kammer innen',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(886,293,'Breite Kammer außen',2.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(889,313,'Breite Kammer außen',3.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(891,325,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(892,327,'Breite Kammer außen',2.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(893,328,'Breite Kammer außen',4.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(894,330,'Breite Kammer außen',3.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(897,370,'Breite Kammer außen',2.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(898,372,'Breite Kammer außen',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(899,375,'Breite Kammer außen',1.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(900,393,'Breite Kammer außen',2.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(901,394,'Breite Kammer außen',3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(902,395,'Breite Kammer außen',3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(903,397,'Breite Kammer außen',2.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(904,402,'Breite Kammer außen',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(905,405,'Breite Kammer außen',2.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(906,409,'Breite Kammer außen',2.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(907,410,'Breite Kammer außen',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(908,411,'Breite Kammer außen',3.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(909,413,'Breite Kammer außen',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(910,416,'Breite Kammer außen',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(911,242,'Breite Kammer innen',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(912,243,'Breite Kammer innen',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(913,244,'Breite Kammer innen',1.55,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(914,246,'Breite Kammer innen',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(916,254,'Breite Kammer innen',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(917,256,'Breite Kammer innen',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(918,257,'Breite Kammer innen',1.6,1,'m','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(919,258,'Breite Kammer innen',2,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(920,259,'Breite Kammer innen',1.3,1,'m','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(921,260,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(923,264,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(928,272,'Breite Kammer innen',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(929,277,'Breite Kammer innen',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(930,297,'Breite Kammer innen',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(931,298,'Breite Kammer innen',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(932,313,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(933,316,'Breite Kammer innen',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(934,318,'Breite Kammer innen',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(935,319,'Breite Kammer innen',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(936,320,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(937,321,'Breite Kammer innen',1.25,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(941,325,'Breite Kammer innen',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(942,326,'Breite Kammer innen',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(943,327,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(944,328,'Breite Kammer innen',1.55,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(948,335,'Breite Kammer innen',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(949,337,'Breite Kammer innen',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(950,338,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(952,422,'Breite Kammer innen',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(953,423,'Breite Kammer innen',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(955,243,'Breite Kammer innen',2.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(956,244,'Breite Kammer innen',1.75,2,'m',NULL);
INSERT INTO "T_Masse" VALUES(957,254,'Breite Kammer innen',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(958,259,'Breite Kammer innen',1.9,1,'m','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(959,266,'Breite Kammer innen',1.3,1,'m','26.3.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(960,268,'Breite Kammer innen',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(961,313,'Breite Kammer innen',1.42,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(962,316,'Breite Kammer innen',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(963,318,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(964,319,'Breite Kammer innen',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(965,321,'Breite Kammer innen',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(966,323,'Breite Kammer innen',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(967,328,'Breite Kammer innen',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(968,329,'Breite Kammer innen',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(969,330,'Breite Kammer innen',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(970,335,'Breite Kammer innen',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(973,29,'Breite Kammer innen',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(974,34,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(975,35,'Breite Kammer innen',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(978,40,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(979,44,'Breite Kammer innen',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(980,50,'Breite Kammer innen',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(981,55,'Breite Kammer innen',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(982,56,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(983,62,'Breite Kammer innen',1.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(984,76,'Breite Kammer innen',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(987,97,'Breite Kammer innen',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(989,99,'Breite Kammer innen',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(990,100,'Breite Kammer innen',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(992,102,'Breite Kammer innen',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(993,103,'Breite Kammer innen',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(994,104,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(995,112,'Breite Kammer innen',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(998,117,'Breite Kammer innen',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(999,118,'Breite Kammer innen',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1000,120,'Breite Kammer innen',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1003,174,'Breite Kammer innen',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1007,188,'Breite Kammer innen',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1008,189,'Breite Kammer innen',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1010,194,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1011,195,'Breite Kammer innen',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1012,209,'Breite Kammer innen',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1013,251,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1014,270,'Breite Kammer innen',0.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1016,29,'Kammersteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1017,34,'Kammersteine erhalten',17,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1018,35,'Kammersteine erhalten',10,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1019,37,'Kammersteine erhalten',8,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1020,38,'Kammersteine erhalten',11,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1021,40,'Kammersteine erhalten',12,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1022,44,'Kammersteine erhalten',12,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1023,50,'Kammersteine erhalten',9,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1024,55,'Kammersteine erhalten',13,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1025,56,'Kammersteine erhalten',10,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1026,62,'Kammersteine erhalten',16,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1027,76,'Kammersteine erhalten',14,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1028,80,'Kammersteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1029,82,'Kammersteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1030,97,'Kammersteine erhalten',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1031,98,'Kammersteine erhalten',8,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1032,99,'Kammersteine erhalten',10,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1033,100,'Kammersteine erhalten',12,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1034,101,'Kammersteine erhalten',12,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1035,102,'Kammersteine erhalten',14,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1036,103,'Kammersteine erhalten',10,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1037,104,'Kammersteine erhalten',9,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1038,112,'Kammersteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1039,113,'Kammersteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1040,116,'Kammersteine erhalten',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1041,117,'Kammersteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1042,118,'Kammersteine erhalten',15,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1043,119,'Kammersteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1044,120,'Kammersteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1045,151,'Kammersteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1046,152,'Kammersteine erhalten',11,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1047,174,'Kammersteine erhalten',10,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1048,175,'Kammersteine erhalten',9,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1049,178,'Kammersteine erhalten',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1050,185,'Kammersteine erhalten',17,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1051,188,'Kammersteine erhalten',14,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1052,189,'Kammersteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1053,192,'Kammersteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1054,193,'Kammersteine erhalten',16,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1055,194,'Kammersteine erhalten',10,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1056,195,'Kammersteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1057,209,'Kammersteine erhalten',14,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1058,242,'Kammersteine erhalten',12,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1059,243,'Kammersteine erhalten',11,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1060,244,'Kammersteine erhalten',12,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1061,246,'Kammersteine erhalten',13,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1063,250,'Kammersteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1064,251,'Kammersteine erhalten',12,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1066,254,'Kammersteine erhalten',15,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1067,255,'Kammersteine erhalten',14,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1069,257,'Kammersteine erhalten',9,0,'gezählt','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(1070,258,'Kammersteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1072,260,'Kammersteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1073,262,'Kammersteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1074,263,'Kammersteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1075,264,'Kammersteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1076,265,'Kammersteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1077,266,'Kammersteine erhalten',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1078,268,'Kammersteine erhalten',10,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1079,270,'Kammersteine erhalten',18,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1080,272,'Kammersteine erhalten',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1081,285,'Kammersteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1082,297,'Kammersteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1083,298,'Kammersteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1084,312,'Kammersteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1085,313,'Kammersteine erhalten',10,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1086,316,'Kammersteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1087,318,'Kammersteine erhalten',14,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1088,319,'Kammersteine erhalten',8,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1089,320,'Kammersteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1090,321,'Kammersteine erhalten',11,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1092,323,'Kammersteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1093,324,'Kammersteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1094,325,'Kammersteine erhalten',11,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1095,326,'Kammersteine erhalten',15,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1096,327,'Kammersteine erhalten',17,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1097,328,'Kammersteine erhalten',16,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1098,329,'Kammersteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1099,330,'Kammersteine erhalten',24,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1101,335,'Kammersteine erhalten',11,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1102,337,'Kammersteine erhalten',12,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1103,338,'Kammersteine erhalten',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1104,339,'Kammersteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1106,422,'Kammersteine erhalten',9,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1108,219,'Kammersteine rekonstruiert',9,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1109,242,'Kammersteine rekonstruiert',15,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1110,243,'Kammersteine rekonstruiert',17,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1111,251,'Kammersteine rekonstruiert',16,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1113,293,'Kammersteine rekonstruiert',12,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1114,295,'Kammersteine rekonstruiert',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1115,296,'Kammersteine rekonstruiert',15,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1116,313,'Kammersteine rekonstruiert',9,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1117,321,'Kammersteine rekonstruiert',13,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1118,372,'Kammersteine rekonstruiert',8,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1119,375,'Kammersteine rekonstruiert',17,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1120,395,'Kammersteine rekonstruiert',15,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1121,397,'Kammersteine rekonstruiert',10,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1122,405,'Kammersteine rekonstruiert',17,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1123,409,'Kammersteine rekonstruiert',11,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1124,219,'Kammersteine erhalten',8,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1125,293,'Kammersteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1126,295,'Kammersteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1127,296,'Kammersteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1128,348,'Kammersteine erhalten',18,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1129,372,'Kammersteine erhalten',8,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1130,375,'Kammersteine erhalten',17,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1131,395,'Kammersteine erhalten',12,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1132,397,'Kammersteine erhalten',10,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1133,405,'Kammersteine erhalten',16,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1134,409,'Kammersteine erhalten',11,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1135,413,'Kammersteine erhalten',11,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1136,12,'Joche nach Tragsteinen',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1137,29,'Joche nach Tragsteinen',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1138,34,'Joche nach Tragsteinen',7.5,1,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1139,35,'Joche nach Tragsteinen',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1140,37,'Joche nach Tragsteinen',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1141,38,'Joche nach Tragsteinen',4.5,1,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1142,40,'Joche nach Tragsteinen',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1143,44,'Joche nach Tragsteinen',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1144,50,'Joche nach Tragsteinen',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1145,55,'Joche nach Tragsteinen',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1146,56,'Joche nach Tragsteinen',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1147,62,'Joche nach Tragsteinen',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1148,76,'Joche nach Tragsteinen',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1149,80,'Joche nach Tragsteinen',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1150,82,'Joche nach Tragsteinen',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1151,97,'Joche nach Tragsteinen',3.5,1,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1152,98,'Joche nach Tragsteinen',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1153,99,'Joche nach Tragsteinen',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1154,100,'Joche nach Tragsteinen',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1155,101,'Joche nach Tragsteinen',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1156,102,'Joche nach Tragsteinen',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1157,103,'Joche nach Tragsteinen',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1158,104,'Joche nach Tragsteinen',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1159,112,'Joche nach Tragsteinen',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1160,113,'Joche nach Tragsteinen',2.5,1,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1161,116,'Joche nach Tragsteinen',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1162,117,'Joche nach Tragsteinen',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1163,118,'Joche nach Tragsteinen',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1164,119,'Joche nach Tragsteinen',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1165,120,'Joche nach Tragsteinen',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1166,122,'Joche nach Tragsteinen',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1167,152,'Joche nach Tragsteinen',4.5,1,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1168,174,'Joche nach Tragsteinen',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1169,175,'Joche nach Tragsteinen',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1170,178,'Joche nach Tragsteinen',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1171,185,'Joche nach Tragsteinen',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1172,188,'Joche nach Tragsteinen',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1173,191,'Joche nach Tragsteinen',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1174,193,'Joche nach Tragsteinen',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1175,194,'Joche nach Tragsteinen',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1176,195,'Joche nach Tragsteinen',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1177,209,'Joche nach Tragsteinen',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1178,219,'Joche nach Tragsteinen',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1179,242,'Joche nach Tragsteinen',6.5,1,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1180,243,'Joche nach Tragsteinen',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1181,244,'Joche nach Tragsteinen',6.5,1,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1182,246,'Joche nach Tragsteinen',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1183,251,'Joche nach Tragsteinen',9,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1184,254,'Joche nach Tragsteinen',8,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1187,270,'Joche nach Tragsteinen',7.5,1,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1189,293,'Joche nach Tragsteinen',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1190,295,'Joche nach Tragsteinen',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1191,296,'Joche nach Tragsteinen',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1192,313,'Joche nach Tragsteinen',3.5,1,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1194,327,'Joche nach Tragsteinen',10,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1195,328,'Joche nach Tragsteinen',9.5,1,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1196,330,'Joche nach Tragsteinen',9,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1197,372,'Joche nach Tragsteinen',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1198,375,'Joche nach Tragsteinen',8,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1199,395,'Joche nach Tragsteinen',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1200,397,'Joche nach Tragsteinen',4.5,1,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1201,405,'Joche nach Tragsteinen',7.5,1,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1202,409,'Joche nach Tragsteinen',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1203,410,'Joche nach Tragsteinen',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1204,413,'Joche nach Tragsteinen',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1205,255,'Joche nach Tragsteinen',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1210,292,'Joche nach Tragsteinen',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1211,297,'Joche nach Tragsteinen',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1212,316,'Joche nach Tragsteinen',8,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1216,335,'Joche nach Tragsteinen',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1218,422,'Joche nach Tragsteinen',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1327,1,'Joche nach Tragsteinen rekonstr.',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1328,2,'Joche nach Tragsteinen rekonstr.',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1329,3,'Joche nach Tragsteinen rekonstr.',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1330,4,'Joche nach Tragsteinen rekonstr.',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1331,5,'Joche nach Tragsteinen rekonstr.',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1332,10,'Joche nach Tragsteinen rekonstr.',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1333,12,'Joche nach Tragsteinen rekonstr.',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1334,18,'Joche nach Tragsteinen rekonstr.',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1335,19,'Joche nach Tragsteinen rekonstr.',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1336,20,'Joche nach Tragsteinen rekonstr.',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1337,21,'Joche nach Tragsteinen rekonstr.',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1338,22,'Joche nach Tragsteinen rekonstr.',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1339,29,'Joche nach Tragsteinen rekonstr.',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1340,30,'Joche nach Tragsteinen rekonstr.',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1341,32,'Joche nach Tragsteinen rekonstr.',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1342,34,'Joche nach Tragsteinen rekonstr.',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1343,35,'Joche nach Tragsteinen rekonstr.',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1344,37,'Joche nach Tragsteinen rekonstr.',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1345,38,'Joche nach Tragsteinen rekonstr.',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1346,40,'Joche nach Tragsteinen rekonstr.',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1347,44,'Joche nach Tragsteinen rekonstr.',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1348,48,'Joche nach Tragsteinen rekonstr.',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1349,50,'Joche nach Tragsteinen rekonstr.',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1350,51,'Joche nach Tragsteinen rekonstr.',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1351,55,'Joche nach Tragsteinen rekonstr.',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1352,56,'Joche nach Tragsteinen rekonstr.',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1353,58,'Joche nach Tragsteinen rekonstr.',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1354,62,'Joche nach Tragsteinen rekonstr.',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1355,64,'Joche nach Tragsteinen rekonstr.',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1356,70,'Joche nach Tragsteinen rekonstr.',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1357,73,'Joche nach Tragsteinen rekonstr.',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1358,76,'Joche nach Tragsteinen rekonstr.',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1359,77,'Joche nach Tragsteinen rekonstr.',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1360,78,'Joche nach Tragsteinen rekonstr.',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1361,80,'Joche nach Tragsteinen rekonstr.',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1362,82,'Joche nach Tragsteinen rekonstr.',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1363,84,'Joche nach Tragsteinen rekonstr.',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1364,97,'Joche nach Tragsteinen rekonstr.',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1365,98,'Joche nach Tragsteinen rekonstr.',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1366,99,'Joche nach Tragsteinen rekonstr.',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1367,100,'Joche nach Tragsteinen rekonstr.',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1368,101,'Joche nach Tragsteinen rekonstr.',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1369,102,'Joche nach Tragsteinen rekonstr.',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1370,103,'Joche nach Tragsteinen rekonstr.',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1371,107,'Joche nach Tragsteinen rekonstr.',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1372,109,'Joche nach Tragsteinen rekonstr.',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1373,113,'Joche nach Tragsteinen rekonstr.',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1374,115,'Joche nach Tragsteinen rekonstr.',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1375,116,'Joche nach Tragsteinen rekonstr.',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1376,117,'Joche nach Tragsteinen rekonstr.',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1377,118,'Joche nach Tragsteinen rekonstr.',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1378,120,'Joche nach Tragsteinen rekonstr.',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1379,122,'Joche nach Tragsteinen rekonstr.',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1380,124,'Joche nach Tragsteinen rekonstr.',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1381,126,'Joche nach Tragsteinen rekonstr.',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1382,127,'Joche nach Tragsteinen rekonstr.',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1383,152,'Joche nach Tragsteinen rekonstr.',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1384,156,'Joche nach Tragsteinen rekonstr.',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1385,160,'Joche nach Tragsteinen rekonstr.',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1386,163,'Joche nach Tragsteinen rekonstr.',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1387,165,'Joche nach Tragsteinen rekonstr.',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1388,167,'Joche nach Tragsteinen rekonstr.',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1389,168,'Joche nach Tragsteinen rekonstr.',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1390,174,'Joche nach Tragsteinen rekonstr.',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1391,175,'Joche nach Tragsteinen rekonstr.',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1392,178,'Joche nach Tragsteinen rekonstr.',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1393,185,'Joche nach Tragsteinen rekonstr.',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1394,188,'Joche nach Tragsteinen rekonstr.',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1395,194,'Joche nach Tragsteinen rekonstr.',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1396,195,'Joche nach Tragsteinen rekonstr.',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1397,205,'Joche nach Tragsteinen rekonstr.',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1398,206,'Joche nach Tragsteinen rekonstr.',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1400,243,'Joche nach Tragsteinen rekonstr.',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1401,244,'Joche nach Tragsteinen rekonstr.',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1402,246,'Joche nach Tragsteinen rekonstr.',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1403,251,'Joche nach Tragsteinen rekonstr.',9,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1404,254,'Joche nach Tragsteinen rekonstr.',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1408,264,'Joche nach Tragsteinen rekonstr.',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1409,265,'Joche nach Tragsteinen rekonstr.',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1411,268,'Joche nach Tragsteinen rekonstr.',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1412,270,'Joche nach Tragsteinen rekonstr.',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1413,292,'Joche nach Tragsteinen rekonstr.',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1416,312,'Joche nach Tragsteinen rekonstr.',6,0,'geschätzt',NULL);
INSERT INTO "T_Masse" VALUES(1417,313,'Joche nach Tragsteinen rekonstr.',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1419,318,'Joche nach Tragsteinen rekonstr.',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1420,319,'Joche nach Tragsteinen rekonstr.',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1421,321,'Joche nach Tragsteinen rekonstr.',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1423,325,'Joche nach Tragsteinen rekonstr.',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1424,326,'Joche nach Tragsteinen rekonstr.',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1427,329,'Joche nach Tragsteinen',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1428,330,'Joche nach Tragsteinen rekonstr.',10,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1430,335,'Joche nach Tragsteinen rekonstr.',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1431,337,'Joche nach Tragsteinen rekonstr.',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1434,422,'Joche nach Tragsteinen rekonstr.',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1435,1,'Decksteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1436,2,'Decksteine erhalten',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1437,3,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1438,4,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1439,5,'Decksteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1440,10,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1441,17,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1442,18,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1443,19,'Decksteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1444,20,'Decksteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1445,21,'Decksteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1446,22,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1447,24,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1448,29,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1449,32,'Decksteine erhalten',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1450,34,'Decksteine erhalten',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1451,35,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1452,37,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1453,38,'Decksteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1454,40,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1455,41,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1456,44,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1457,45,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1458,48,'Decksteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1459,50,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1460,51,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1461,52,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1462,56,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1463,57,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1464,58,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1465,62,'Decksteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1466,64,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1467,66,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1468,68,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1469,70,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1470,73,'Decksteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1471,76,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1472,77,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1473,78,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1474,80,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1475,82,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1476,84,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1477,86,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1478,87,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1479,93,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1480,94,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1481,97,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1482,98,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1483,99,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1484,100,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1485,101,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1486,102,'Decksteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1487,103,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1488,104,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1489,105,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1490,106,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1491,107,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1492,109,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1493,110,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1494,112,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1495,113,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1496,115,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1497,116,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1498,117,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1499,118,'Decksteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1500,120,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1501,122,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1502,123,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1503,125,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1504,127,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1505,128,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1506,129,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1507,131,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1508,151,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1509,152,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1510,156,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1511,160,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1512,161,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1513,162,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1514,163,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1515,165,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1516,166,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1517,167,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1518,168,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1519,173,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1520,174,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1521,175,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1522,178,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1523,185,'Decksteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1524,187,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1525,188,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1526,190,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1527,191,'Decksteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1528,192,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1529,193,'Decksteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1530,194,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1531,202,'Decksteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1532,205,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1533,206,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1534,207,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1535,209,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1536,219,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1537,242,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1538,243,'Decksteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1539,244,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1540,246,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1541,251,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1542,254,'Decksteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1543,255,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1544,256,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1545,259,'Decksteine erhalten',4,0,'gezählt','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(1546,270,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1547,293,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1548,297,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1549,313,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1550,321,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1551,327,'Decksteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1552,328,'Decksteine erhalten',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1553,330,'Decksteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1554,372,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1555,395,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1556,397,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1557,405,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1558,409,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1559,413,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1560,1,'Decksteine rekostruiert',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1561,2,'Decksteine rekostruiert',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1562,3,'Decksteine rekostruiert',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1563,4,'Decksteine rekostruiert',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1564,5,'Decksteine rekostruiert',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1565,10,'Decksteine rekostruiert',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1566,12,'Decksteine rekostruiert',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1567,18,'Decksteine rekostruiert',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1568,19,'Decksteine rekostruiert',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1569,20,'Decksteine rekostruiert',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1570,21,'Decksteine rekostruiert',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1571,22,'Decksteine rekostruiert',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1572,29,'Decksteine rekostruiert',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1573,30,'Decksteine rekostruiert',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1574,32,'Decksteine rekostruiert',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1575,34,'Decksteine rekostruiert',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1576,35,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1577,37,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1578,38,'Decksteine rekostruiert',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1579,40,'Decksteine rekostruiert',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1580,44,'Decksteine rekostruiert',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1581,48,'Decksteine rekostruiert',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1582,50,'Decksteine rekostruiert',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1583,51,'Decksteine rekostruiert',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1584,55,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1585,56,'Decksteine rekostruiert',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1586,58,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1587,62,'Decksteine rekostruiert',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1588,64,'Decksteine rekostruiert',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1589,70,'Decksteine rekostruiert',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1590,73,'Decksteine rekostruiert',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1591,76,'Decksteine rekostruiert',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1592,77,'Decksteine rekostruiert',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1593,78,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1594,80,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1595,82,'Decksteine rekostruiert',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1596,84,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1597,97,'Decksteine rekostruiert',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1598,98,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1599,99,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1600,100,'Decksteine rekostruiert',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1601,101,'Decksteine rekostruiert',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1602,102,'Decksteine rekostruiert',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1603,107,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1604,109,'Decksteine rekostruiert',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1605,113,'Decksteine rekostruiert',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1606,115,'Decksteine rekostruiert',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1607,116,'Decksteine rekostruiert',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1608,117,'Decksteine rekostruiert',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1609,118,'Decksteine rekostruiert',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1610,120,'Decksteine rekostruiert',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1611,122,'Decksteine rekostruiert',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1612,124,'Decksteine rekostruiert',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1613,126,'Decksteine rekostruiert',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1614,127,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1615,152,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1616,156,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1617,160,'Decksteine rekostruiert',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1618,163,'Decksteine rekostruiert',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1619,165,'Decksteine rekostruiert',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1620,167,'Decksteine rekostruiert',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1621,168,'Decksteine rekostruiert',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1622,174,'Decksteine rekostruiert',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1623,175,'Decksteine rekostruiert',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1624,178,'Decksteine rekostruiert',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1625,185,'Decksteine rekostruiert',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1626,188,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1627,194,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1628,195,'Decksteine rekostruiert',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1629,205,'Decksteine rekostruiert',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1630,206,'Decksteine rekostruiert',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1631,219,'Decksteine rekostruiert',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1632,242,'Decksteine rekostruiert',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1633,243,'Decksteine rekostruiert',6,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1634,244,'Decksteine rekostruiert',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1635,246,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1636,251,'Decksteine rekostruiert',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1637,254,'Decksteine rekostruiert',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1638,255,'Decksteine rekostruiert',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1639,256,'Decksteine rekostruiert',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1641,270,'Decksteine rekostruiert',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1642,293,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1643,295,'Decksteine rekostruiert',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1644,297,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1645,313,'Decksteine rekostruiert',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1646,321,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1647,327,'Decksteine rekostruiert',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1648,328,'Decksteine rekostruiert',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1649,330,'Decksteine rekostruiert',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1650,372,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1651,395,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1652,397,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1653,405,'Decksteine rekostruiert',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1654,409,'Decksteine rekostruiert',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1655,415,'Decksteine rekostruiert',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1656,12,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1657,55,'Decksteine erhalten',0,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1658,195,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1659,257,'Decksteine erhalten',4,0,'gezählt','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(1663,264,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1664,265,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1666,267,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1667,268,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1669,292,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1671,312,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1672,316,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1673,317,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1674,318,'Decksteine erhalten',0,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1675,319,'Decksteine erhalten',0,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1676,322,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1678,324,'Decksteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1679,325,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1680,326,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1681,329,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1683,335,'Decksteine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1684,337,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1685,338,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1686,339,'Decksteine erhalten',0,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1687,340,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1688,422,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(1689,12,'Länge Deckstein',3.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1690,29,'Länge Deckstein',2.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1691,34,'Länge Deckstein',3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1692,35,'Länge Deckstein',2.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1693,37,'Länge Deckstein',1.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1694,38,'Länge Deckstein',2.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1695,40,'Länge Deckstein',2.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1696,44,'Länge Deckstein',3.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1697,50,'Länge Deckstein',3.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1698,56,'Länge Deckstein',2.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1699,62,'Länge Deckstein',2.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1700,76,'Länge Deckstein',2.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1701,80,'Länge Deckstein',2.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1702,82,'Länge Deckstein',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1703,97,'Länge Deckstein',2.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1704,98,'Länge Deckstein',2.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1705,99,'Länge Deckstein',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1706,100,'Länge Deckstein',2.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1707,101,'Länge Deckstein',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1708,102,'Länge Deckstein',2.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1709,103,'Länge Deckstein',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1710,104,'Länge Deckstein',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1711,112,'Länge Deckstein',2.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1712,113,'Länge Deckstein',2.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1713,116,'Länge Deckstein',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1714,117,'Länge Deckstein',2.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1715,118,'Länge Deckstein',2.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1716,120,'Länge Deckstein',1.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1717,152,'Länge Deckstein',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1718,174,'Länge Deckstein',2.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1719,175,'Länge Deckstein',3.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1720,178,'Länge Deckstein',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1721,185,'Länge Deckstein',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1722,188,'Länge Deckstein',4.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1723,194,'Länge Deckstein',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1724,209,'Länge Deckstein',2.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1725,242,'Länge Deckstein',1.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1727,254,'Länge Deckstein',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1729,264,'Länge Deckstein',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1730,267,'Länge Deckstein',2,1,'m','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(1731,270,'Länge Deckstein',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1732,297,'Länge Deckstein',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1735,313,'Länge Deckstein',2.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1736,316,'Länge Deckstein',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1737,321,'Länge Deckstein',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1738,324,'Länge Deckstein',1.32,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1739,328,'Länge Deckstein',1.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1740,329,'Länge Deckstein',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1741,330,'Länge Deckstein',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1743,335,'Länge Deckstein',1.25,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1744,338,'Länge Deckstein',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1745,34,'Länge Deckstein',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1746,37,'Länge Deckstein',1.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1747,38,'Länge Deckstein',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1748,62,'Länge Deckstein',2.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1749,99,'Länge Deckstein',1.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1750,100,'Länge Deckstein',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1751,178,'Länge Deckstein',2.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1752,185,'Länge Deckstein',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1753,242,'Länge Deckstein',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1754,254,'Länge Deckstein',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1755,264,'Länge Deckstein',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1756,268,'Länge Deckstein',2.15,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1757,270,'Länge Deckstein',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1758,297,'Länge Deckstein',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1760,312,'Länge Deckstein',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1761,313,'Länge Deckstein',2.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1762,316,'Länge Deckstein',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1763,324,'Länge Deckstein',1.24,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1764,328,'Länge Deckstein',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1765,330,'Länge Deckstein',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1767,335,'Länge Deckstein',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1768,338,'Länge Deckstein',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1769,185,'Länge Deckstein',2.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1770,242,'Länge Deckstein',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1771,254,'Länge Deckstein',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1772,268,'Länge Deckstein',2.05,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1773,270,'Länge Deckstein',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1774,297,'Länge Deckstein',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1776,312,'Länge Deckstein',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1777,328,'Länge Deckstein',2.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1778,330,'Länge Deckstein',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1780,335,'Länge Deckstein',1.55,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1781,254,'Länge Deckstein',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1782,268,'Länge Deckstein',1.85,2,'m',NULL);
INSERT INTO "T_Masse" VALUES(1783,270,'Länge Deckstein',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1784,312,'Länge Deckstein',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1785,328,'Länge Deckstein',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1786,330,'Länge Deckstein',1.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1788,335,'Länge Deckstein',1.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1789,270,'Länge Deckstein',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1790,328,'Länge Deckstein',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1791,330,'Länge Deckstein',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1792,335,'Länge Deckstein',1.25,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1793,97,'Durchmesser Hügel',11,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1794,104,'Durchmesser Hügel',14,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1795,192,'Durchmesser Hügel',14,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1796,249,'Durchmesser Hügel',12,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1798,265,'Durchmesser Hügel',5,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(1801,297,'Durchmesser Hügel',10,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1802,321,'Durchmesser Hügel',11,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(1804,405,'Durchmesser Hügel',20,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1805,409,'Durchmesser Hügel',20,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1806,29,'Länge Hügel',19,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1807,37,'Länge Hügel',25,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1808,38,'Länge Hügel',37,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1809,40,'Länge Hügel',37,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1810,62,'Länge Hügel',47,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1811,76,'Länge Hügel',22,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1812,82,'Länge Hügel',6.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1813,97,'Länge Hügel',11,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1814,100,'Länge Hügel',11,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1815,103,'Länge Hügel',15,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1816,104,'Länge Hügel',14,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1817,113,'Länge Hügel',20,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1818,120,'Länge Hügel',21,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1819,121,'Länge Hügel',12.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1820,186,'Länge Hügel',53,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1821,189,'Länge Hügel',20.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1822,192,'Länge Hügel',14,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1823,195,'Länge Hügel',17.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1829,250,'Länge Hügel',15,0,'m','26.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(1833,258,'Durchmesser Hügel',8,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(1837,263,'Länge Hügel',8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1838,264,'Länge Hügel',7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1841,267,'Länge Hügel',7,0,'m','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(1848,297,'Länge Hügel',10,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1849,298,'Länge Hügel',8,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(1850,312,'Länge Hügel',8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1851,316,'Länge Hügel',17,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1852,318,'Länge Hügel',25,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(1853,319,'Länge Hügel',14,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(1855,322,'Länge Hügel',21,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1857,324,'Länge Hügel',24,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(1858,326,'Länge Hügel',14,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1859,328,'Länge Hügel',11,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1862,335,'Länge Hügel',30,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1863,337,'Länge Hügel',19,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(1864,338,'Länge Hügel',18,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(1865,339,'Durchmesser Hügel',12,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(1866,340,'Länge Hügel',15,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(1867,405,'Länge Hügel',20,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1868,409,'Länge Hügel',20,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1869,422,'Länge Hügel',20,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1871,29,'Breite Hügel',18.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1872,37,'Breite Hügel',16,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1873,38,'Breite Hügel',14.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1874,40,'Breite Hügel',13,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1875,62,'Breite Hügel',10,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1876,76,'Breite Hügel',15,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1877,100,'Breite Hügel',8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1878,103,'Breite Hügel',11.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1879,113,'Breite Hügel',8.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1880,120,'Breite Hügel',11,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1881,121,'Breite Hügel',7.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1882,186,'Breite Hügel',15,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1883,189,'Breite Hügel',11.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1884,195,'Breite Hügel',11,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1889,250,'Breite Hügel',9,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(1890,251,'Breite Hügel',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1895,262,'Durchmesser Hügel',5,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(1897,264,'Breite Hügel',5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1899,268,'Breite Hügel',8.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1901,271,'Breite Umfassung',6,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(1902,272,'Breite Hügel',3.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1904,298,'Breite Hügel',6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1905,312,'Breite Hügel',4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1906,316,'Breite Hügel',8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1907,318,'Breite Hügel',18,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(1908,319,'Breite Hügel',8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1909,323,'Durchmesser Hügel',11,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(1910,324,'Breite Hügel',8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1911,326,'Breite Hügel',5.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1912,328,'Breite Hügel',5.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1915,335,'Breite Hügel',8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1916,337,'Breite Hügel',10,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(1917,338,'Breite Hügel',14,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(1919,422,'Breite Hügel',7.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1920,29,'Resthöhe Hügel',0.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1921,34,'Resthöhe Hügel',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1922,37,'Resthöhe Hügel',0.36,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1923,38,'Resthöhe Hügel',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1924,40,'Resthöhe Hügel',0.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1925,44,'Resthöhe Hügel',0.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1926,50,'Resthöhe Hügel',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1927,56,'Resthöhe Hügel',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1928,62,'Resthöhe Hügel',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1929,76,'Resthöhe Hügel',0.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1930,82,'Resthöhe Hügel',0.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1931,97,'Resthöhe Hügel',0.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1932,98,'Resthöhe Hügel',0.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1933,99,'Resthöhe Hügel',0.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1934,100,'Resthöhe Hügel',0.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1935,101,'Resthöhe Hügel',0.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1936,102,'Resthöhe Hügel',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1937,103,'Resthöhe Hügel',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1938,113,'Resthöhe Hügel',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1939,117,'Resthöhe Hügel',0.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1940,118,'Resthöhe Hügel',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1941,120,'Resthöhe Hügel',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1942,121,'Resthöhe Hügel',0.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1943,151,'Resthöhe Hügel',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1944,189,'Resthöhe Hügel',0.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1945,192,'Resthöhe Hügel',0.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1946,194,'Resthöhe Hügel',0.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1947,195,'Resthöhe Hügel',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1948,209,'Resthöhe Hügel',0.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1949,242,'Resthöhe Hügel',0.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1950,243,'Resthöhe Hügel',0.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1951,244,'Resthöhe Hügel',0.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1952,246,'Resthöhe Hügel',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1953,248,'Resthöhe Hügel',0.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1954,249,'Resthöhe Hügel',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1955,250,'Resthöhe Hügel',0.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1957,255,'Resthöhe Hügel',0.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1958,256,'Resthöhe Hügel',0.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1959,257,'Resthöhe Hügel',0.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1960,258,'Resthöhe Hügel',0.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1962,260,'Resthöhe Hügel',0.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1963,262,'Resthöhe Hügel',0.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1964,263,'Resthöhe Hügel',0.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1965,264,'Resthöhe Hügel',0.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1966,265,'Resthöhe Hügel',0.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1967,266,'Resthöhe Hügel',0.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1968,267,'Resthöhe Hügel',0.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1969,268,'Resthöhe Hügel',0.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1970,269,'Resthöhe Hügel',0.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1971,271,'Resthöhe Hügel',0.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1972,272,'Resthöhe Hügel',0.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1973,293,'Resthöhe Hügel',0.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1974,297,'Resthöhe Hügel',0.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1975,298,'Resthöhe Hügel',0.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1976,312,'Resthöhe Hügel',0.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1977,316,'Resthöhe Hügel',0.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1978,317,'Resthöhe Hügel',0,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1979,318,'Resthöhe Hügel',0.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1980,319,'Resthöhe Hügel',0.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1981,320,'Resthöhe Hügel',0.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1982,321,'Resthöhe Hügel',0.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1983,322,'Resthöhe Hügel',0.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1984,323,'Resthöhe Hügel',0.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1985,324,'Resthöhe Hügel',0.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1986,326,'Resthöhe Hügel',0.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1987,327,'Resthöhe Hügel',0.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1988,328,'Resthöhe Hügel',0.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1989,329,'Resthöhe Hügel',0.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1990,330,'Resthöhe Hügel',0.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1993,337,'Resthöhe Hügel',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1994,338,'Resthöhe Hügel',0.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1995,339,'Resthöhe Hügel',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1996,340,'Resthöhe Hügel',0.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1997,422,'Resthöhe Hügel',0.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(1999,365,'Länge Kammer außen',9.2,1,'m','9.2.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2000,365,'Breite Kammer außen',1.8,1,'m','9.2.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2001,365,'Breite Kammer außen',2,1,'m','9.2.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2002,365,'Länge Deckstein',2.8,1,'m','9.2.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2003,365,'Breite Deckstein',2,1,'m','9.2.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2004,365,'Länge Deckstein',2.7,1,'m','9.2.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2005,365,'Breite Deckstein',1.6,1,'m','9.2.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2006,365,'Länge Deckstein',1.8,1,'m','9.2.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2007,365,'Breite Deckstein',1.8,1,'m','9.2.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2008,367,'Resthöhe Hügel',0.5,1,'m','9.2.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2009,367,'Decksteine erhalten',3,0,'gezählt','9.2.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2010,367,'Kammersteine erhalten',2,0,'gezählt','9.2.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2011,365,'Decksteine erhalten',3,0,'gezählt','9.2.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2012,314,'Höhe Tragstein',0.8,1,'m','14.3.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2015,314,'Steine erhalten',9,0,'gezählt','8.4.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2016,314,'Länge Kammer innen',7,0,'m','8.4.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2020,263,'Länge Deckstein',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2021,263,'Länge Deckstein',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2022,265,'Länge Deckstein',1.2,1,'m','13.3.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2023,272,'Joche nach Tragsteinen rekonstr.',7,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2025,347,'Steine erhalten',7,0,'gezählt','26.3.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2026,347,'Breite Kammer innen',1,1,'m','26.3.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2027,420,'Breite Kammer innen',1.1,1,'m','26.3.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2028,317,'Länge Deckstein',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2029,322,'Länge Deckstein',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2030,322,'Länge Deckstein',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2031,322,'Länge Deckstein',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2032,322,'Länge Deckstein',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2033,324,'Länge Deckstein',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2034,324,'Länge Deckstein',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2035,324,'Länge Deckstein',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2036,325,'Länge Deckstein',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2037,325,'Länge Deckstein',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2038,325,'Länge Deckstein',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2039,325,'Länge Deckstein',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2040,326,'Länge Deckstein',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2041,330,'Steine Umfassung',27,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2042,330,'Breite Kammer innen',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2044,418,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2045,418,'Länge Deckstein',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2047,418,'Steine erhalten',8,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2048,333,'Breite Kammer innen',2,1,'m','19.4.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2049,333,'Breite Kammer innen',1.4,1,'m','19.4.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2050,333,'Länge Kammer innen',10,0,'m','19.4.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2051,333,'Breite Kammer außen',4.6,1,'m','19.4.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2052,333,'Breite Kammer außen',2.8,1,'m','19.4.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2053,333,'Länge Deckstein',3.2,1,'m','19.4.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2054,333,'Länge Deckstein',2.7,1,'m','19.4.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2055,333,'Länge Deckstein',2.2,1,'m','19.4.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2056,333,'Länge Deckstein',2.3,1,'m','19.4.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2057,333,'Breite Umfassung',12,0,'m','19.4.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2058,284,'Decksteine erhalten',2,0,'gezählt','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2059,284,'Steine erhalten',5,0,'gezählt','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2060,284,'Kammersteine erhalten',2,0,'gezählt','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2061,284,'Länge Deckstein',1.6,1,'m','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2062,284,'Breite Deckstein',1.4,1,'m','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2063,284,'Länge Deckstein',1.2,1,'m','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2064,284,'Breite Deckstein',1,1,'m','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2065,287,'Steine erhalten',3,0,'gezählt','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2066,287,'Decksteine erhalten',1,0,'gezählt','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2067,287,'Kammersteine erhalten',2,0,'gezählt','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2068,287,'Länge Deckstein',1.8,1,'m','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2069,287,'Breite Deckstein',1.2,1,'m','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2070,288,'Steine erhalten',4,0,'gezählt','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2071,288,'Decksteine erhalten',1,0,'gezählt','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2072,288,'Länge Deckstein',1.8,1,'m','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2073,288,'Breite Deckstein',1.4,1,'m','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2074,288,'Länge Kammer innen',1.2,1,'m','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2075,288,'Breite Kammer innen',1,1,'m','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2076,267,'Breite Deckstein',1.7,1,'m','24.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2078,266,'Durchmesser Hügel',10,0,'m','26.3.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2079,259,'Länge Kammer innen',5.3,1,'m','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2080,259,'Joche nach Tragsteinen',3,0,'gezählt','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2081,259,'Joche nach Tragsteinen rekonstr.',5,0,'gezählt','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2082,259,'Decksteine rekostruiert',4,0,'','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2083,259,'Länge Deckstein',1.9,1,'m','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2084,259,'Breite Deckstein',1.2,1,'m','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2085,259,'Länge Deckstein',1.8,1,'m','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2086,259,'Breite Deckstein',1,1,'m','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2087,257,'Joche nach Tragsteinen rekonstr.',4,0,'gezählt','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2088,257,'Länge Kammer innen',5.6,1,'m','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2089,257,'Breite Umfassung',4.9,1,'m','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2090,257,'Länge Umfassung',9.4,1,'m','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2091,257,'Steine Umfassung',3,0,'gezählt','25.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2092,250,'Decksteine erhalten',2,0,'gezählt','26.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2093,250,'Länge Deckstein',1.4,1,'m','26.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2094,250,'Breite Deckstein',1,1,'m','26.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2095,423,'Decksteine erhalten',2,0,'gezählt','26.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2096,423,'Länge Deckstein',1.1,1,'m','26.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2097,423,'Breite Deckstein',0.8,1,'m','26.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2098,423,'Länge Deckstein',1.4,1,'m','26.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2099,423,'Breite Deckstein',0.8,1,'m','26.5.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2100,243,'Länge Deckstein',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2101,243,'Breite Deckstein',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2102,243,'Länge Deckstein',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2103,243,'Breite Deckstein',0.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2104,243,'Länge Deckstein',2.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2105,243,'Breite Deckstein',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2106,243,'Länge Deckstein',2.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2107,243,'Breite Deckstein',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2108,243,'Länge Deckstein',2.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2109,243,'Breite Deckstein',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2110,244,'Länge Deckstein',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2111,244,'Breite Deckstein',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2113,244,'Länge Deckstein',1.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2114,244,'Breite Deckstein',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2115,244,'Länge Deckstein',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2116,244,'Breite Deckstein',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2117,247,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2118,247,'Länge Deckstein',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2119,247,'Breite Deckstein',0.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2121,247,'Länge Deckstein',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2122,247,'Breite Deckstein',0.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2131,253,'Länge Deckstein',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2132,253,'Breite Deckstein',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2133,253,'Länge Deckstein',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2135,253,'Breite Deckstein',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2136,253,'Länge Deckstein',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2137,253,'Breite Deckstein',0.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2138,253,'Steine erhalten',24,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2139,253,'Decksteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2140,253,'Kammersteine erhalten',12,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2141,254,'Breite Deckstein',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2142,254,'Breite Deckstein',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2143,254,'Breite Deckstein',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2144,254,'Breite Deckstein',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2146,255,'Länge Deckstein',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2148,255,'Breite Deckstein',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2149,262,'Breite Kammer innen',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2150,265,'Breite Deckstein',1.1,1,'m','13.3.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2151,269,'Länge Deckstein',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2152,269,'Breite Deckstein',0.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2153,276,'Steine erhalten',5,0,'gezählt','1.1.1967 00:00:00');
INSERT INTO "T_Masse" VALUES(2162,294,'Länge Deckstein',2.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2163,294,'Breite Deckstein',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2165,321,'Breite Deckstein',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2176,326,'Breite Deckstein',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2177,327,'Länge Deckstein',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2178,327,'Breite Deckstein',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2179,327,'Länge Deckstein',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2180,327,'Breite Deckstein',0.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2181,327,'Länge Deckstein',2.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2182,327,'Breite Deckstein',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2183,327,'Länge Deckstein',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2184,327,'Breite Deckstein',0.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2186,328,'Breite Deckstein',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2187,328,'Breite Deckstein',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2188,328,'Breite Deckstein',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2189,328,'Breite Deckstein',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2190,328,'Breite Deckstein',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2191,328,'Breite Deckstein',0.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2192,330,'Breite Deckstein',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2193,330,'Breite Deckstein',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2194,330,'Breite Deckstein',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2195,330,'Breite Deckstein',0.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2196,331,'Länge Umfassung',27,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(2198,418,'Breite Deckstein',0.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2199,242,'Breite Deckstein',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2200,242,'Breite Deckstein',0.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2201,242,'Breite Deckstein',0.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2202,251,'Länge Deckstein',2.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2203,251,'Breite Deckstein',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2204,251,'Länge Deckstein',1.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2205,251,'Breite Deckstein',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2206,251,'Länge Deckstein',2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2207,251,'Breite Deckstein',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2208,251,'Länge Deckstein',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2209,251,'Breite Deckstein',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2210,251,'Länge Deckstein',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2211,251,'Breite Deckstein',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2212,252,'Länge Deckstein',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2213,252,'Länge Deckstein',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2214,252,'Decksteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2217,256,'Länge Deckstein',2.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2218,256,'Breite Deckstein',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2219,256,'Breite Deckstein',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2220,256,'Länge Deckstein',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2221,263,'Decksteine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2222,264,'Breite Deckstein',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2223,264,'Breite Deckstein',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2224,269,'Decksteine erhalten',1,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2225,269,'Steine erhalten',8,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2226,270,'Breite Deckstein',2.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2227,270,'Breite Deckstein',0.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2228,270,'Breite Deckstein',0.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2229,270,'Breite Deckstein',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2230,270,'Breite Deckstein',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2232,292,'Breite Kammer innen',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2233,292,'Länge Kammer innen',10.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2234,292,'Länge Deckstein',3.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2235,292,'Breite Deckstein',2.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2237,292,'Länge Deckstein',3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2238,292,'Breite Deckstein',1.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2239,292,'Länge Deckstein',2.6,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2240,292,'Breite Deckstein',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2241,292,'Breite Umfassung',8.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2242,292,'Breite Umfassung',6.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2243,293,'Breite Umfassung',4.7,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2244,293,'Breite Umfassung',5.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2245,293,'Länge Deckstein',1.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2246,293,'Breite Deckstein',1.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2247,293,'Länge Deckstein',2.2,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2248,293,'Breite Deckstein',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2254,295,'Durchmesser Hügel',10,0,'m',NULL);
INSERT INTO "T_Masse" VALUES(2255,297,'Breite Deckstein',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2256,297,'Breite Deckstein',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2257,297,'Breite Deckstein',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2261,335,'Länge Umfassung',18.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2262,337,'Länge Deckstein',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2263,337,'Breite Deckstein',1.3,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2264,337,'Länge Deckstein',1.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2265,337,'Breite Deckstein',1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2266,340,'Länge Deckstein',1.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2267,340,'Breite Deckstein',0.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2268,340,'Länge Deckstein',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2269,340,'Breite Deckstein',0.8,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2270,307,'Steine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2271,344,'Steine erhalten',5,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2272,346,'Steine erhalten',2,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2273,423,'Länge Hügel',13,0,'m','27.7.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2274,423,'Breite Hügel',6,0,'m','27.7.2013 00:00:00');
INSERT INTO "T_Masse" VALUES(2279,295,'Breite Kammer außen',2.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2280,295,'Länge Kammer außen',4.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2281,333,'Länge Hügel',18.5,1,'m','1.10.1897 00:00:00');
INSERT INTO "T_Masse" VALUES(2282,333,'Breite Hügel',13,1,'','1.10.1897 00:00:00');
INSERT INTO "T_Masse" VALUES(2283,317,'Kammersteine erhalten',3,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2284,253,'Breite Kammer innen',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2285,253,'Breite Umfassung',6.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2292,296,'Breite Umfassung',5.5,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2295,433,'Steine erhalten',7,NULL,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2296,426,'Steine erhalten',28,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2297,426,'Länge Umfassung',15.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2298,426,'Breite Umfassung',5.9,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2299,426,'Länge Kammer außen',9.4,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2300,426,'Länge Kammer innen',8.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2301,426,'Kammersteine erhalten',10,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2302,426,'Steine Umfassung',12,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2303,435,'Breite Kammer innen',1.1,1,'m',NULL);
INSERT INTO "T_Masse" VALUES(2304,435,'Kammersteine erhalten',4,0,'gezählt',NULL);
INSERT INTO "T_Masse" VALUES(2305,426,'Breite Kammer innen',1.5,1,'m',NULL);

/* Comment 
------------------------
Table for settlement sites and single finds of stone axes.
"Region": region
"Gemarkung": local Subdivision
"OANr": Ortsakten Nr., consecutive number relatet to the local subdivision
"OAGem": Ortsakten Gemarkung, abbrev. of the local subdivision
"LDANr": identifier of the avvrev. local subdivision and the consecutive number
"Fundart": site type
"FundartID": site ID, corresponding to the GDB LSA (Grabungsdatenbank Land Sachsen-Anhalt)
"Denkmal": Denkmaltyp, alternative site type, related to the site ID from the GDB LSA (Grabungsdatenbank Land Sachsen-Anhalt)
"Datier": Datierung, datings for the the site and artefakts of the site
"x": coordinate, DHDN GK zone 4, EPSG 31468
"y": coordinate, DHDN GK zone 4, EPSG 31468
 */
DROP TABLE IF EXISTS "T_SiedlungDaten";
CREATE TABLE "T_SiedlungDaten" (
"SiedID" INTEGER PRIMARY KEY  NOT NULL  UNIQUE , 
"Region" TEXT, 
"Gemarkung" TEXT, 
"OANr" INTEGER, 
"OAGem" TEXT, 
"LDANr" TEXT, 
"Fundart" TEXT, 
"FundartID" INTEGER, 
"Denkmal" INTEGER, 
"Datier" TEXT, 
"x" INTEGER, 
"y" INTEGER);
INSERT INTO "T_SiedlungDaten" VALUES(5,'Ohrekreis/Börde/Magdeburg','Hundisburg',3,'Hun','Hun003','Siedlung',110000,110000,'Spätneolithikum',4458161,5791300);
INSERT INTO "T_SiedlungDaten" VALUES(7,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)',7,'NHa','NHa007','Siedlung',110000,110000,'Spätneolithikum',4458461,5794629);
INSERT INTO "T_SiedlungDaten" VALUES(8,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)',22,'NHa','NHa022','Siedlung, Fuchsberg',110000,110000,'Spätneolithikum',4462234,5796362);
INSERT INTO "T_SiedlungDaten" VALUES(9,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)',49,'AHa','AHa049','Grab KAK?',0,0,'Spätneolithikum',4461117,5792333);
INSERT INTO "T_SiedlungDaten" VALUES(10,'Ohrekreis/Börde/Magdeburg','Hundisburg',10,'Hun','Hun010','Siedlung',110000,110000,'Spätneolithikum',4458345,5789996);
INSERT INTO "T_SiedlungDaten" VALUES(11,'Ohrekreis/Börde/Magdeburg','Hundisburg',2,'Hun','Hun002','Siedlung',110000,110000,'Spätneolithikum',4458346,5791367);
INSERT INTO "T_SiedlungDaten" VALUES(12,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)',7,'AHa','AHa007','Siedlung',110000,110000,'Spätneolithikum',4459974,5792407);
INSERT INTO "T_SiedlungDaten" VALUES(13,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)',5,'AHa','AHa005','Einzelfund, Kupferbeil',0,0,'Spätneolithikum',4461357,5794456);
INSERT INTO "T_SiedlungDaten" VALUES(14,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)',8,'AHa','AHa008','Einzelfund, dicknackige Felsgesteinbeil',0,0,'Spätneolithikum',4457219,5792752);
INSERT INTO "T_SiedlungDaten" VALUES(15,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)',10,'AHa','AHa010','Einzelfund, Steinaxt',0,0,'Spätneolithikum/Endneolithikum',4458017,5793704);
INSERT INTO "T_SiedlungDaten" VALUES(16,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)',38,'AHa','AHa038','Einzelfund, Feuersteinbeil',0,0,'Spätneolithikum/Endneolithikum',4456136,5794573);
INSERT INTO "T_SiedlungDaten" VALUES(17,'Ohrekreis/Börde/Magdeburg','Hundisburg',56,'Hun','Hun056','Einzelfund, Dechsel',0,0,'Frühneolithikum',4458492,5790101);
INSERT INTO "T_SiedlungDaten" VALUES(18,'Ohrekreis/Börde/Magdeburg','Hundisburg',57,'Hun','Hun057','Einzelfund, Flintrechteckbeil',0,0,'Spätneolithikum',4459438,5791122);
INSERT INTO "T_SiedlungDaten" VALUES(19,'Ohrekreis/Börde/Magdeburg','Hundisburg',58,'Hun','Hun058','Einzelfund, Schuhleistenkeil',0,0,'Frühneolithikum',4457859,5791684);
INSERT INTO "T_SiedlungDaten" VALUES(20,'Ohrekreis/Börde/Magdeburg','Hundisburg',9,'Hun','Hun009','Einzelfund, Steinbeil',0,0,'Neolithikum',4458929,5791101);
INSERT INTO "T_SiedlungDaten" VALUES(22,'Ohrekreis/Börde/Magdeburg','Hundisburg',63,'Hun','Hun063','Einzelfund, Felsgesteinaxt, Dechsel',0,0,'Frühneolithikum, Spätneolithikum',4457727,5790936);
INSERT INTO "T_SiedlungDaten" VALUES(23,'Ohrekreis/Börde/Magdeburg','Hundisburg',64,'Hun','Hun064','Einzelfund, 1 dünnackiges Felsgesteinbeil',0,0,'Spätneolithikum',4458097,5790357);
INSERT INTO "T_SiedlungDaten" VALUES(24,'Ohrekreis/Börde/Magdeburg','Hundisburg',65,'Hun','Hun065','Einzelfund, 1 Steinaxtfrg.',0,0,'Spätneolithikum/Endneolithikum',4458768,5790325);
INSERT INTO "T_SiedlungDaten" VALUES(25,'Ohrekreis/Börde/Magdeburg','Hundisburg',36,'Hun','Hun036','Einzelfund, Steinaxt',0,0,'Spätneolithikum/Endneolithikum',4457836,5789184);
INSERT INTO "T_SiedlungDaten" VALUES(26,'Ohrekreis/Börde/Magdeburg','Hundisburg',13,'Hun','Hun013','Einzelfund, Bronzebeil',0,0,'Bronzezeit',4458242,5792531);
INSERT INTO "T_SiedlungDaten" VALUES(27,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)',5,'NHa','NHa005','Siedlung, Rosmarienbreite',110000,110000,'Spätneolithikum',4461473,5796731);
INSERT INTO "T_SiedlungDaten" VALUES(28,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)',21,'NHa','NHa021','Erdgrab, Kugelamphorenkultur',0,0,'Spätneolithikum',4460935,5797272);
INSERT INTO "T_SiedlungDaten" VALUES(29,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)',15,'NHa','NHa015','Einzelfund, Felsgesteinbeil',0,0,'Neolithikum',4458825,5796077);
INSERT INTO "T_SiedlungDaten" VALUES(30,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)',28,'NHa','NHa028','Einzelfund, kleines Feuersteinbeil',0,0,'Spätneolithikum/Endneolithikum',4461404,5795909);
INSERT INTO "T_SiedlungDaten" VALUES(32,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)',3,'NHa','NHa003','Einzelfund, dicknackiges Felsgesteinbeil',0,0,'Spätneolithikum',4458798,5795902);
INSERT INTO "T_SiedlungDaten" VALUES(33,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)',6,'NHa','NHa006','Einzelfund, dünnackiges Flintbeil',0,0,'Spätneolithikum',4458385,5794430);
INSERT INTO "T_SiedlungDaten" VALUES(34,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)',8,'NHa','NHa008','Einzelfund, großes Felsgesteinbeil',0,0,'Neolithikum',4459251,5796248);
INSERT INTO "T_SiedlungDaten" VALUES(35,'Ohrekreis/Börde/Magdeburg','Hundisburg',53,'Hun','Hun053','Einzelfund, Dechsel, Steinbeil',0,0,'Frühneolithikum/Mittelneolithikum',4457841,5789684);
INSERT INTO "T_SiedlungDaten" VALUES(36,'Ohrekreis/Börde/Magdeburg','Hundisburg',1,'Hun','Hun001','Einzelfund, Axt, Datierung unsicher',0,0,'Spätneolithikum/Endneolithikum',4459581,5791296);
INSERT INTO "T_SiedlungDaten" VALUES(37,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)',501,'Alv','Alv501','Einzelfund, dünnackiges Feuersteinbeil',0,0,'Spätneolithikum',4453481,5790868);
INSERT INTO "T_SiedlungDaten" VALUES(38,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)',502,'Alv','Alv502','Einzelfund, dünnackiges Beil',0,0,'Spätneolithikum/Endneolithikum',4455798,5788836);
INSERT INTO "T_SiedlungDaten" VALUES(39,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)',503,'Alv','Alv503','Einzelfund, dünnackiges Feuersteinbeil',0,0,'Spätneolithikum/Endneolithikum',4453413,5790950);
INSERT INTO "T_SiedlungDaten" VALUES(40,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)',504,'Alv','Alv504','Einzelfund aus Steinbruch Siebert, "Hacke aus Felsgestein"',0,0,'Frühneolithikum/Mittelneolithikum',4454518,5791977);
INSERT INTO "T_SiedlungDaten" VALUES(41,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)',505,'Alv','Alv505','Einzelfund, Druschplatz am Bever, "Beil aus grauem Felsgestein"',0,0,'Neolithikum',4454721,5789481);
INSERT INTO "T_SiedlungDaten" VALUES(43,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)',506,'Alv','Alv506','Einzelfund, Breite Dönstedter Weg-Nordh. u. Straße nach Rottmersleben, Beil aus grauem Felsgestein',0,0,'Neolithikum',4456377,5788349);
INSERT INTO "T_SiedlungDaten" VALUES(44,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)',507,'Alv','Alv507','Einzelfund, "Esse" Acker bei der Markgrafenmühle, Feuersteinbeil',0,0,'Spätneolithikum/Endneolithikum',4453163,5789058);
INSERT INTO "T_SiedlungDaten" VALUES(45,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)',508,'Alv','Alv508','Einzelfund, "angeblich im Bauernholz", Steinaxt',0,0,'Spätneolithikum/Endneolithikum',4454082,5792818);
INSERT INTO "T_SiedlungDaten" VALUES(46,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)',509,'Alv','Alv509','Einzelfund, "Richtung Emden am Steinbruch Schwentesius", Steinaxt',0,0,'Spätneolithikum/Endneolithikum',4452726,5789690);
INSERT INTO "T_SiedlungDaten" VALUES(47,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)',510,'Alv','Alv510','Einzelfund, Bauernholz, Felsgesteinbeil',0,0,'Neolithikum',4453968,5792770);
INSERT INTO "T_SiedlungDaten" VALUES(48,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)',511,'Alv','Alv511','Einzelfund, Bauernholz, Feuersteinbeil',0,0,'Spätneolithikum/Endneolithikum',4454032,5792776);
INSERT INTO "T_SiedlungDaten" VALUES(49,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)',51,'Alv','Alv051','Einzelfund, Steinaxt aus Nephrit',0,0,'Spätneolithikum/Endneolithikum',4452783,5788779);
INSERT INTO "T_SiedlungDaten" VALUES(50,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)',65,'Alv','Alv065','Einzelfund, Feuersteinbeil',0,0,'Spätneolithikum/Endneolithikum',4453601,5788070);
INSERT INTO "T_SiedlungDaten" VALUES(51,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)',501,'Dön','Dön501','Einzelfund, Rüsterberg, dünnackiges Feuersteinbeil',0,0,'Spätneolithikum',4455690,5789673);
INSERT INTO "T_SiedlungDaten" VALUES(52,'Ohrekreis/Börde/Magdeburg','Hundisburg',10,'Hun','Hun010','Einzelfund, Steinaxt',0,0,'Spätneolithikum/Endneolithikum',4458488,5790020);
INSERT INTO "T_SiedlungDaten" VALUES(55,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)',2,'Dön','Dön002','Einzelfund, Steinaxt, Nackenfragment mit nicht vollständiger Durchbohrung',0,0,'Spätneolithikum/Endneolithikum',4456936,5790435);
INSERT INTO "T_SiedlungDaten" VALUES(56,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)',2,'Dön','Dön002','Einzelfund, Bruchstück Felsgesteinbeil von ursprünglich dreieckiger Form aus einer zerbrochenen Axt gearbeitet (Reste vom Schaftloch)',0,0,'Spätneolithikum',4456943,5790430);
INSERT INTO "T_SiedlungDaten" VALUES(57,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)',23,'Dön','Dön023','Einzelfund, Nacken eines Steinbeiles',0,0,'Neolithikum',4455949,5789700);
INSERT INTO "T_SiedlungDaten" VALUES(58,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)',23,'Dön','Dön023','Einzelfunde, 2 Fragmente von Steinbeilen',0,0,'Neolithikum',4456023,5789689);
INSERT INTO "T_SiedlungDaten" VALUES(60,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)',512,'Alv','Alv512','Einzelfund, Steinaxt',0,0,'Spätneolithikum/Endneolithikum',4452676,5790175);
INSERT INTO "T_SiedlungDaten" VALUES(65,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)',2,'Doe','Doe002','Einzelfund, Felsgesteinbeil, grau, beschädigt',0,0,'Neolithikum',4456959,5790411);
INSERT INTO "T_SiedlungDaten" VALUES(66,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)',501,'AHa','AHa501','Einzelfund, Dünnackiges beil mit spitzovalem Querschnitt, Gräberweg',0,0,'Spätneolithikum',4456550,5794168);
INSERT INTO "T_SiedlungDaten" VALUES(68,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)',46,'AHa','AHa046','Einzelfund, Feuersteinbeil, grau, Schneide geschliffen',0,0,'Spätneolithikum/Endneolithikum',4457372,5793063);
INSERT INTO "T_SiedlungDaten" VALUES(69,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)',3,'AHa','AHa003','Einzelfund, Schneide eines Felsgesteinbeils, L p cm, Br. 6,3 cm, grau',0,0,'Spätneolithikum/Endneolithikum',4462314,5794368);
INSERT INTO "T_SiedlungDaten" VALUES(70,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)',3,'AHa','AHa003','Einzelfund, Bruchstück einer Felsgesteinaxt L 10,2 cm, Br. 5 cm',0,0,'Spätneolithikum/Endneolithikum',4462326,5794355);
INSERT INTO "T_SiedlungDaten" VALUES(71,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)',503,'AHa','AHa503','Einzelfund, Fragment eines Ovalbeiles aus Grünstein, Acker bei der Ziegelei',0,0,'Spätneolithikum',4457861,5793396);
INSERT INTO "T_SiedlungDaten" VALUES(72,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)',502,'AHa','AHa502','Einzelfund, schmales dickblattiges Flintrechteckbeil, Bereich der Mühle',0,0,'Spätneolithikum',4461026,5791877);
INSERT INTO "T_SiedlungDaten" VALUES(73,'Ohrekreis/Börde/Magdeburg','Hundisburg',47,'Hun','Hun047','Einzelfund, donauländische Steinaxt',0,0,'Neolithikum',4458410,5791755);
INSERT INTO "T_SiedlungDaten" VALUES(74,'Ohrekreis/Börde/Magdeburg','Hundisburg',50,'Hun','Hun050','Einzelfund, Ovalbeil aus Felsgestein, Schneidenfragment',0,0,'Spätneolithikum',4457909,5790605);
INSERT INTO "T_SiedlungDaten" VALUES(75,'Ohrekreis/Börde/Magdeburg','Hundisburg',59,'Hun','Hun059','Siedlung, zahlr. Scherben u.a. 1 Trichterrand mit Pech-Reparatur',110000,110000,'Frühneolithikum, Linienbandkeramik',4458983,5790300);
INSERT INTO "T_SiedlungDaten" VALUES(77,'Ohrekreis/Börde/Magdeburg','Hundisburg',2,'Hun','Hun002','Einzelfund, Axthammer aus Felsgestein, an einer Seite nachgeschliffen',0,0,'Urgeschichte',4458362,5791360);
INSERT INTO "T_SiedlungDaten" VALUES(78,'Ohrekreis/Börde/Magdeburg','Hundisburg',42,'Hun','Hun042','Einzelfund, Felsgesteinbeil, längs gespalten',0,0,'Neolithikum',4458212,5789243);
INSERT INTO "T_SiedlungDaten" VALUES(79,'Ohrekreis/Börde/Magdeburg','Hundisburg',15,'Hun','Hun015','Einzelfund, geschliffenes Beil aus Felsgestein, dicknackig',0,0,'Spätneolithikum',4458753,5791015);
INSERT INTO "T_SiedlungDaten" VALUES(80,'Ohrekreis/Börde/Magdeburg','Hundisburg',5,'Hun','Hun005','Einzelfund, Schaftrillenaxt aus Felsgestein',0,0,'Urgeschichte',4458177,5790932);
INSERT INTO "T_SiedlungDaten" VALUES(81,'Ohrekreis/Börde/Magdeburg','Hundisburg',3,'Hun','Hun003','Einzelfund, hellgraues Felsbeil',0,0,'Neolithikum',4458190,5791325);
INSERT INTO "T_SiedlungDaten" VALUES(82,'Ohrekreis/Börde/Magdeburg','Hundisburg',3,'Hun','Hun003','Einzelfund, Axthammer mit Randbildung',0,0,'Urgeschichte',4458190,5791307);
INSERT INTO "T_SiedlungDaten" VALUES(83,'Ohrekreis/Börde/Magdeburg','Hundisburg',65,'Hun','Hun065','Einzelfund, 1 Steinaxtfrg.',0,0,'Spätneolithikum/Endneolithikum',4458730,5790321);
INSERT INTO "T_SiedlungDaten" VALUES(84,'Ohrekreis/Börde/Magdeburg','Hundisburg',65,'Hun','Hun065','Einzelfund, 1 Steinaxtfrg.',0,0,'Spätneolithikum/Endneolithikum',4458691,5790316);
INSERT INTO "T_SiedlungDaten" VALUES(85,'Ohrekreis/Börde/Magdeburg','Hundisburg',65,'Hun','Hun065','Einzelfund, 1 Steinaxtfrg.',0,0,'Spätneolithikum/Endneolithikum',4458820,5790319);
INSERT INTO "T_SiedlungDaten" VALUES(86,'Ohrekreis/Börde/Magdeburg','Hundisburg',64,'Hun','Hun064','Einzelfund, 1 Steinaxt',0,0,'Spätneolithikum/Endneolithikum',4458136,5790342);
INSERT INTO "T_SiedlungDaten" VALUES(87,'Ohrekreis/Börde/Magdeburg','Hundisburg',64,'Hun','Hun064','Einzelfund, 1 Steinaxt',0,0,'Spätneolithikum/Endneolithikum',4458060,5790375);
INSERT INTO "T_SiedlungDaten" VALUES(88,'Ohrekreis/Börde/Magdeburg','Hundisburg',11,'Hun','Hun011','Einzelfund, Beil aus schwarz melliertem Felsgestein, Nacken sehr beschädigt',0,0,'Neolithikum',4457330,5790956);
INSERT INTO "T_SiedlungDaten" VALUES(89,'Ohrekreis/Börde/Magdeburg','Hundisburg',50,'Hun','Hun050','Einzelfund, Steinbeil',0,0,'Neolithikum',4457875,5790633);
INSERT INTO "T_SiedlungDaten" VALUES(90,'Ohrekreis/Börde/Magdeburg','Süpplingen',5,'Süp','Sup005','Einzelfund, 1 Steinbeil, vorzeitliche Keramik',0,0,'Spätneolithikum',4456725,5794962);
INSERT INTO "T_SiedlungDaten" VALUES(91,'Ohrekreis/Börde/Magdeburg','Bodendorf',1,'Bod','Bod001','Einzelfund, 1 Beil aus Felsgestein, helles grau-grünes Gestein',0,0,'Spätneolithikum',4452940,5795087);
INSERT INTO "T_SiedlungDaten" VALUES(92,'Ohrekreis/Börde/Magdeburg','Süpplingen',1,'Süp','Sup001','Einzelfund, 1 Steinbeil',0,0,'Spätneolithikum',4452314,5797540);
INSERT INTO "T_SiedlungDaten" VALUES(93,'Ohrekreis/Börde/Magdeburg','Bebertal I (Alvensleben)',0,'Alv',NULL,'Siedlungsgruben, AktNr. 6657, 6748',110000,110000,'Spätneolithikum, Frühneol, Mittelneol., BZ, EZ',4453188,5789497);
INSERT INTO "T_SiedlungDaten" VALUES(94,'Ohrekreis/Börde/Magdeburg',NULL,1,'TSd','TSd001','fiktive Testsiedlung abstand 3,6 km',0,110000,'Spätneolithikum',0,0);
INSERT INTO "T_SiedlungDaten" VALUES(95,'Ohrekreis/Börde/Magdeburg',NULL,2,'TSd','TSd002','fiktive Testsiedlung abstand 3,6 km',0,110000,'Spätneolithikum',0,0);
INSERT INTO "T_SiedlungDaten" VALUES(96,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)',5,'Dön','Dön005','Fund aus Megalithgrab, Feuersteinbeil',422000,0,'Spätneolithikum',4454638,5791272);
INSERT INTO "T_SiedlungDaten" VALUES(97,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)',5,'Dön','Dön005','Fund aus Megalithgrab, Feuersteinbeil',422000,0,'Spätneolithikum',4454696,5791271);
INSERT INTO "T_SiedlungDaten" VALUES(98,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)',5,'Dön','Dön005','Fund aus Megalithgrab, Felsgesteinbeil',422000,0,'Spätneolithikum',4454658,5791184);
INSERT INTO "T_SiedlungDaten" VALUES(99,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)',5,'Dön','Dön005','Fund aus Megalithgrab, Felsgesteinbeil',422000,0,'Spätneolithikum',4454718,5791183);
INSERT INTO "T_SiedlungDaten" VALUES(100,'Ohrekreis/Börde/Magdeburg','Bebertal II (Dönstedt)',8,'Dön','Dön008','Fund aus Megalithgrab, Felsovalbeil',422000,0,'Spätneolithikum',4454605,5791378);
INSERT INTO "T_SiedlungDaten" VALUES(101,'Ohrekreis/Börde/Magdeburg','Hundisburg',14,'Hun','Hun014','Fund aus Megalithgrab, Feuersteinbeil',422000,0,'Spätneolithikum',4458273,5792573);
INSERT INTO "T_SiedlungDaten" VALUES(102,'Ohrekreis/Börde/Magdeburg','Hundisburg',14,'Hun','Hun014','Fund aus Megalithgrab, Felsgesteinbeil',422000,0,'Spätneolithikum',4458206,5792586);
INSERT INTO "T_SiedlungDaten" VALUES(103,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)',7,'NHa','NHa007','Fund aus Hausgrube, Feuersteinovalbeil',110000,0,'Spätneolithikum',4458392,5794646);
INSERT INTO "T_SiedlungDaten" VALUES(104,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)',7,'NHa','NHa007','Fund aus Hausgrube, Nackenfragment Felsgesteinaxt (Schneide?)',110000,0,'Spätneolithikum',4458532,5794645);
INSERT INTO "T_SiedlungDaten" VALUES(105,'Ohrekreis/Börde/Magdeburg','Haldensleben I (Neu)',7,'NHa','NHa007','Lesefund in der Nähe, dünnblattiges Ovalbeil',0,0,'Spätneolithikum',4458462,5794542);
INSERT INTO "T_SiedlungDaten" VALUES(106,'Ohrekreis/Börde/Magdeburg',NULL,32,'NHa','NHa32','Einzelfund bei Ausschachtung, 1 Feuersteinbei,geschliffen',0,0,'Spätneolithikum',4460616,5795330);
INSERT INTO "T_SiedlungDaten" VALUES(107,'Ohrekreis/Börde/Magdeburg','Haldensleben II (Alt)',7,'AHa','AHa007','dünnblattiges Ovalbeil aus Feuerstein mit angeschliffener Schneide',110000,0,'Spätneolithikum',4459974,4459974);

/* Comment 
------------------------
 Table for the preservation of the sites (megaliths).
"objekt": object that is evaluated
"note": value. foreign key on wt_erhaltung (parameters)
"wertung": range of evaluation
"wer": name of the person evaluating
"datum": date of the evaluation
  */
DROP TABLE IF EXISTS "T_Wertung";
CREATE TABLE "T_Wertung" (
"wertungID" INTEGER PRIMARY KEY AUTOINCREMENT, 
"MegaID" integer, 
"objekt" TEXT, 
"note" INTEGER, 
"wertung" TEXT, 
"wer" TEXT, 
"datum" DATETIME,
FOREIGN KEY (MegaID) REFERENCES T_MegalitheDaten(MegaID)
);
INSERT INTO "T_Wertung" VALUES(1,12,'gesamtes Grab',6,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(2,29,'gesamtes Grab',4,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(3,34,'gesamtes Grab',2,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(4,35,'gesamtes Grab',2,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(5,37,'gesamtes Grab',2,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(6,38,'gesamtes Grab',3,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(7,40,'gesamtes Grab',2,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(8,44,'gesamtes Grab',2,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(9,50,'gesamtes Grab',4,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(10,55,'gesamtes Grab',4,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(11,56,'gesamtes Grab',3,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(12,62,'gesamtes Grab',2,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(13,76,'gesamtes Grab',4,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(14,80,'gesamtes Grab',5,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(15,82,'gesamtes Grab',5,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(16,93,'gesamtes Grab',3,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(17,97,'gesamtes Grab',2,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(18,98,'gesamtes Grab',4,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(19,99,'gesamtes Grab',2,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(20,100,'gesamtes Grab',3,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(21,101,'gesamtes Grab',3,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(22,102,'gesamtes Grab',2,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(23,103,'gesamtes Grab',4,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(24,104,'gesamtes Grab',4,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(25,112,'gesamtes Grab',4,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(26,113,'gesamtes Grab',2,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(27,115,'gesamtes Grab',2,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(28,116,'gesamtes Grab',4,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(29,117,'gesamtes Grab',4,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(30,118,'gesamtes Grab',2,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(31,119,'gesamtes Grab',6,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(32,120,'gesamtes Grab',4,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(33,121,'gesamtes Grab',6,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(34,126,'gesamtes Grab',2,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(35,151,'gesamtes Grab',4,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(36,152,'gesamtes Grab',2,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(37,174,'gesamtes Grab',4,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(38,175,'gesamtes Grab',2,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(39,178,'gesamtes Grab',3,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(40,185,'gesamtes Grab',2,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(41,188,'gesamtes Grab',2,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(42,189,'gesamtes Grab',4,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(43,192,'gesamtes Grab',6,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(44,193,'gesamtes Grab',4,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(45,194,'gesamtes Grab',2,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(46,195,'gesamtes Grab',3,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(47,209,'gesamtes Grab',2,'bei 1 bis 6','B. Fritsch',NULL);
INSERT INTO "T_Wertung" VALUES(296,242,'gesamtes Grab',14,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(297,243,'gesamtes Grab',14,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(298,244,'gesamtes Grab',14,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(299,246,'gesamtes Grab',10,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(300,247,'gesamtes Grab',6,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(301,248,'gesamtes Grab',4,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(302,249,'gesamtes Grab',3,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(303,250,'gesamtes Grab',6,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(304,251,'gesamtes Grab',14,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(305,252,'gesamtes Grab',6,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(306,254,'gesamtes Grab',13,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(307,255,'gesamtes Grab',10,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(308,256,'gesamtes Grab',5,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(309,257,'gesamtes Grab',7,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(310,258,'gesamtes Grab',12,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(311,259,'gesamtes Grab',8,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(312,260,'gesamtes Grab',8,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(313,262,'gesamtes Grab',7,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(314,263,'gesamtes Grab',4,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(315,264,'gesamtes Grab',5,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(316,265,'gesamtes Grab',5,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(317,266,'gesamtes Grab',5,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(318,267,'gesamtes Grab',3,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(319,268,'gesamtes Grab',13,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(320,269,'gesamtes Grab',6,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(321,270,'gesamtes Grab',14,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(322,271,'gesamtes Grab',6,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(323,272,'gesamtes Grab',4,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(324,274,'gesamtes Grab',3,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(325,276,'gesamtes Grab',2,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(326,277,'gesamtes Grab',3,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(327,297,'gesamtes Grab',10,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(328,298,'gesamtes Grab',9,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(329,312,'gesamtes Grab',9,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(330,313,'gesamtes Grab',10,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(331,316,'gesamtes Grab',8,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(332,317,'gesamtes Grab',4,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(333,318,'gesamtes Grab',12,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(334,319,'gesamtes Grab',9,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(335,320,'gesamtes Grab',4,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(336,321,'gesamtes Grab',12,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(337,322,'gesamtes Grab',7,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(338,323,'gesamtes Grab',10,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(339,324,'gesamtes Grab',9,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(340,325,'gesamtes Grab',10,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(341,326,'gesamtes Grab',10,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(342,327,'gesamtes Grab',12,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(343,328,'gesamtes Grab',14,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(344,329,'gesamtes Grab',5,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(345,330,'gesamtes Grab',14,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(346,331,'gesamtes Grab',3,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(347,335,'gesamtes Grab',12,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(348,337,'gesamtes Grab',9,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(349,338,'gesamtes Grab',12,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(350,339,'gesamtes Grab',7,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(351,340,'gesamtes Grab',6,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(352,419,'gesamtes Grab',4,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(353,420,'gesamtes Grab',2,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(354,422,'gesamtes Grab',11,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(355,423,'gesamtes Grab',7,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(356,426,'gesamtes Grab',10,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(357,428,'gesamtes Grab',1,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(358,242,'Kammer',14,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(359,243,'Kammer',14,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(360,244,'Kammer',14,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(361,246,'Kammer',8,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(362,247,'Kammer',2,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(363,249,'Kammer',3,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(364,250,'Kammer',4,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(365,251,'Kammer',14,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(366,252,'Kammer',1,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(367,254,'Kammer',11,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(368,255,'Kammer',8,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(369,256,'Kammer',6,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(370,257,'Kammer',6,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(371,258,'Kammer',12,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(372,259,'Kammer',7,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(373,260,'Kammer',7,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(374,262,'Kammer',6,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(375,263,'Kammer',2,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(376,264,'Kammer',5,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(377,265,'Kammer',5,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(378,266,'Kammer',6,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(379,267,'Kammer',3,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(380,268,'Kammer',12,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(381,269,'Kammer',5,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(382,271,'Kammer',2,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(383,272,'Kammer',5,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(384,277,'Kammer',2,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(385,285,'Kammer',3,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(386,292,'Kammer',14,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(387,312,'Kammer',10,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(388,313,'Kammer',13,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(389,316,'Kammer',12,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(390,317,'Kammer',0,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(391,318,'Kammer',14,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(392,319,'Kammer',9,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(393,320,'Kammer',2,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(394,321,'Kammer',14,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(395,322,'Kammer',7,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(396,323,'Kammer',11,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(397,324,'Kammer',6,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(398,325,'Kammer',10,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(399,326,'Kammer',9,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(400,327,'Kammer',13,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(401,328,'Kammer',13,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(402,329,'Kammer',4,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(403,330,'Kammer',14,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(404,331,'Kammer',3,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(405,335,'Kammer',12,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(406,337,'Kammer',9,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(407,338,'Kammer',12,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(408,339,'Kammer',7,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(409,340,'Kammer',1,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(410,422,'Kammer',11,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(411,423,'Kammer',7,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(412,426,'Kammer',11,'bei 1 bis 14','M. Lindemann',NULL);
INSERT INTO "T_Wertung" VALUES(413,365,'Kammer',3,'bei 1 bis 6','Fritsch','9.2.2013 00:00:00');
INSERT INTO "T_Wertung" VALUES(414,314,'Kammer',5,'bei 1 bis 6','Rinne','14.3.2013 00:00:00');
INSERT INTO "T_Wertung" VALUES(418,318,'Kammer',2,'bei 1 bis 6','Rinne','10.3.2010 00:00:00');
INSERT INTO "T_Wertung" VALUES(419,347,'Kammer',5,'bei 1 bis 6','Rinne','26.3.2013 00:00:00');
INSERT INTO "T_Wertung" VALUES(420,312,'gesamtes Grab',4,'bei 1 bis 6','Rinne',NULL);
INSERT INTO "T_Wertung" VALUES(421,317,'gesamtes Grab',5,'bei 1 bis 6','Rinne',NULL);
INSERT INTO "T_Wertung" VALUES(422,320,'gesamtes Grab',4,'bei 1 bis 6','Rinne',NULL);
INSERT INTO "T_Wertung" VALUES(423,321,'gesamtes Grab',3,'bei 1 bis 6','Rinne',NULL);
PRAGMA foreign_keys = ON;
commit;