.censorEt0 = function(data,threshold=0,...){
	data$et[data$et<threshold] = threshold
	data
}
#Enable a simpler call to ggplot2
fortify.SingleCellAssay = function(model, data, ...){
	data = MAST:::melt.SingleCellAssay(model)
	data$wellKey = factor(data$wellKey)
	data = .censorEt0(data,...)
	data
}

# Function to make a heatmap
ggplotHmap = function(data=NULL,type = c("continuous","discrete","singlecell","combined"),...){
	type = match.arg(type ,c("continuous","discrete","singlecell","combined"))
	M = exprs(data)
	cd = cData(data)
	rownames(cd) = rownames(data)
	dt = data.table(MAST:::melt.SingleCellAssay(data))
	discrete = dcast(dt[,.(pEt = mean(et>0)),.(primerid,`Groups`,AnimalID)],`Groups`+AnimalID ~ primerid,value.var = "pEt")
	continuous = dcast(dt[et>0,.(cEt = log2(mean(2^et-1))+1),.(primerid,Groups,AnimalID)],Groups +AnimalID~ primerid, value.var = "cEt")
	setDF(continuous)
	setDF(discrete)
	rownames(continuous) = apply(continuous[,c("Groups","AnimalID")],1,function(x)paste0(x,collapse=":"))
	rownames(discrete) =apply(discrete[,c("Groups","AnimalID")],1,function(x)paste0(x,collapse=":"))
	continuous[,"Groups"] = NULL
	discrete[,"Groups"] = NULL
	continuous[,"AnimalID"] = NULL
	discrete[,"AnimalID"] = NULL
	combined = continuous*discrete
	if(type == "continuous")
		d3heatmap(t(continuous),color="Reds",anim_duration = 0.5,Colv = TRUE,...)
	else if(type == "discrete")
		d3heatmap(t(discrete),color="Blues",anim_duration = 0.5,Colv = TRUE,...)
	else if (type == "combined")
		d3heatmap(t(combined),anim_duration = 0.5,Colv = TRUE,...)
	else if (type == "singlecell")
		COMPASS::pheatmap(t(M)[,order(factor(factor(cd$Groups):factor(cd$AnimalID)))],annotation=cd[,c("Groups","AnimalID"),drop=FALSE],cluster_rows=TRUE,show_colnames=FALSE,color=colorRampPalette(brewer.pal(n=3,"Blues"))(10),...)
}

formatDT = function(x,nm) {
	if (length(dimnames(x)) == 4) {
		x_tbl = adply(x,c(1:2,4))
		colnames(x_tbl) = c("gene","test.type","coefficient","lambda","dof","Pvalue")
		setDT(x_tbl)
		#x_tbl[,coefficient:=factor(coefficient,levels= c("Groupsg1","Groupsg3a","Groupsg3b"),labels=c("g1","g3a","g3b"))]
		x_tbl = x_tbl[,fdr := p.adjust(Pvalue,"fdr"),.(test.type)]
		x_tbl[,4:7 := lapply(.SD,function(x)
			signif(x,3)),.SDcols = 4:7]
		
	}else{
		x_tbl = adply(x,.margins = c(1,2))
		colnames(x_tbl) = c("gene","test.type","lambda","dof","Pvalue")
		setDT(x_tbl)
		x_tbl = x_tbl[,fdr := p.adjust(Pvalue,"fdr"),.(test.type)]
		x_tbl[,3:6 := lapply(.SD,function(x)
			signif(x,3)),.SDcols = 3:6]
		
	}
	write.csv(x_tbl,file=nm,row.names = FALSE)
	
	if (ncol(x_tbl) == 6) {
		datatable(x_tbl,options = list(
			"search" = list(search = ""),"order" = list(6,"asc")
			,tableTools = list(sSwfPath = copySWF())),filter = "top")
	}else{
		datatable(x_tbl,options = list(
			"search" = list(search = ""),"order" = list(7,"asc")
			, tableTools = list(sSwfPath = copySWF())),filter = "top")
	}
}