---
title: "Single-cell analysis of SIV viral life cycle."
author: "Greg Finak"
date: "May 18, 2016"
output: 
  html_document: 
    fig_caption: yes
    keep_md: yes
    number_sections: no
---


# Single-cell analysis of infected and uninfected cells from  AY69, 8116, 08D227 and 08D108 




<!-- ### Read in the follow up data -->



<!-- ### Read in the first data set -->





### Plots of single-cells

tSNE is run on the single-cell data and cells are colored by Animal ID, Group, or cluster in the 2D projection. 
Neither Group nor Animal ID explain the clustering of cells.
The cluster label is included as a covariate in a MAST linear model to identify genes differentially expressed between clusters.

![](/Users/gfinak/Dropbox (Gottardo Lab)/GoTeam/Projects/Mario_SIV_Fluidigm/DataSubmission/BoltonSIV/inst/extdata/Logfiles/Combined_files/figure-html/unnamed-chunk-6-1.png)<!-- -->

### Fit to 3 animals

The following linear model is fit to the data:

`~ AnimalID*Groups+CDR+cluster:Groups`

We identify genes differentially expressed between clusters in each group.



Violin plots of the genes differentially expressed between clusters are shown. 

Cells don’t express CD3e or CD40LG, and have increased expression of NLRP3 and RORA. These are likely monocytes. 
Additionally, they are only found in group 0 (uninfected). 

![](/Users/gfinak/Dropbox (Gottardo Lab)/GoTeam/Projects/Mario_SIV_Fluidigm/DataSubmission/BoltonSIV/inst/extdata/Logfiles/Combined_files/figure-html/unnamed-chunk-8-1.png)<!-- -->

### Filter monocytes
We filter out cells that are CD3e negative or NLRP3 positive or NOD2 positive and if they belong to the outlier cluster.
This removes 60 cells.


```
## 
## FALSE  TRUE 
##    34   670
```

### Refit model to filtered data

After filtering we re-fit the model, omitting the cluster variable.


```
##  CD28 GABPA  ICOS  NKG7  TCF7 
##    15    38    41    66    85
```

We show genes differentially expressed in each animal, when compared to uninfected cells. 
Significance is called at the 10% FDR level, adjusted across all genes.

<!-- #DATA FOR POWER ANALYSIS FOR HUMAN STUDY -->


<!-- ### Violin plots from 3 animals -->

![](/Users/gfinak/Dropbox (Gottardo Lab)/GoTeam/Projects/Mario_SIV_Fluidigm/DataSubmission/BoltonSIV/inst/extdata/Logfiles/Combined_files/figure-html/unnamed-chunk-12-1.png)<!-- -->

<!-- ### Fit model to AY69 -->
A similar model is fit to animal AY69, which has three tissues (LN, PBMC, and Jejunum). 
Indepdent tests are performed for each tissue.
Genes reported as DE are at the 10% FDR level, adjusted across all genes.



<!-- ### Separate tests for AY69 -->



### Violin plots Jejunum in AY69

![](/Users/gfinak/Dropbox (Gottardo Lab)/GoTeam/Projects/Mario_SIV_Fluidigm/DataSubmission/BoltonSIV/inst/extdata/Logfiles/Combined_files/figure-html/unnamed-chunk-15-1.png)<!-- -->

#### plots of predicted effects and bivariate intervals for jejunum

We can look at the bivariate confidence ellipse (for the continuous and discrete components of expression) of each gene's point estimate in each group, for each animal, based on the model estimates. 
If two ellipses don't overlap, this, approximately, indicates a significant difference.


```
##        primer Animal cellgroup      muC       seC          muD       seD
##   1: APOBEC3F   AY69        g0 17.28588 0.1200693  0.009417651 0.1468569
##   2: APOBEC3F   AY69        g1 17.44209 0.1820942 -0.570155755 0.1969813
##   3: APOBEC3F   Ay69        g2 15.81411 0.5150401  0.208818526 0.6475096
##   4: APOBEC3F   AY69       g3a 18.23677 0.5150401 -0.559554688 0.5423907
##   5: APOBEC3F   AY69       g3b 17.69310 0.3324569  0.520564093 0.4661673
##  ---                                                                    
## 445:     XPO1   AY69        g0 19.54257 0.1169881  0.769784915 0.1577187
## 446:     XPO1   AY69        g1 19.48299 0.1490566  0.817009136 0.2051955
## 447:     XPO1   Ay69        g2 20.02417 0.5339750  0.698726660 0.6811013
## 448:     XPO1   AY69       g3a 20.14398 0.4943647  0.033560986 0.5228229
## 449:     XPO1   AY69       g3b 19.78847 0.3172284  2.031702300 0.6890027
```

![](/Users/gfinak/Dropbox (Gottardo Lab)/GoTeam/Projects/Mario_SIV_Fluidigm/DataSubmission/BoltonSIV/inst/extdata/Logfiles/Combined_files/figure-html/unnamed-chunk-16-1.png)<!-- -->


<!-- #### ECDF plots of jejunum -->
<!-- These plots show another way to visualize differentially the differentially expressed genes. On the y-axis we have the proportion of cells that express a gene at or below the level given on the x-axis. Separation of the curves (different groups) indicates differences in the distribution of expression. Here I've set the lowest level to be 12 et again.  -->



### Violin plots LN in AY69
 Here we show violin plots of the differentially expressed genes in lymph node in animal AY69.
 
![](/Users/gfinak/Dropbox (Gottardo Lab)/GoTeam/Projects/Mario_SIV_Fluidigm/DataSubmission/BoltonSIV/inst/extdata/Logfiles/Combined_files/figure-html/unnamed-chunk-18-1.png)<!-- -->

#### plots of predicted effects and bivariate intervals for LN

Here we show the bivariate point estimates and confidence ellipses for the DE genes in Lymph node.


```
##      primer Animal cellgroup      muC        seC         muD       seD
##   1:   AIM2   AY69        g0 18.68581 0.17592577  0.08615153 0.1657271
##   2:   AIM2   AY69        g1 18.82026 0.11082282  0.40476892 0.1148796
##   3:   AIM2   AY69       g3a 18.56737 0.34067879  0.16119125 0.3270434
##   4:   AIM2   AY69       g3b 18.91347 0.24089628  0.31934310 0.2426997
##   5:    BAX   AY69        g0 17.19384 0.19171122 -1.32182917 0.2024096
##  ---                                                                  
## 376:   XAF1   AY69       g3b 18.21434 0.15263943  0.97315930 0.2682921
## 377:   XPO1   AY69        g0 19.06652 0.11356562  1.71612260 0.2289976
## 378:   XPO1   AY69        g1 19.22005 0.07523231  2.01491009 0.1744466
## 379:   XPO1   AY69       g3a 19.31751 0.24140426  1.00864480 0.3675022
## 380:   XPO1   AY69       g3b 19.61301 0.15679666  2.52148699 0.4513648
```

![](/Users/gfinak/Dropbox (Gottardo Lab)/GoTeam/Projects/Mario_SIV_Fluidigm/DataSubmission/BoltonSIV/inst/extdata/Logfiles/Combined_files/figure-html/unnamed-chunk-19-1.png)<!-- -->

<!-- #### ECDF plots of lymph node -->
<!-- These plots show another way to visualize differentially the differentially expressed genes. On the y-axis we have the proportion of cells that express a gene at or below the level given on the x-axis. Separation of the curves (different groups) indicates differences in the distribution of expression. Here I've set the lowest level to be 12 et again.  -->



<!-- ### Combined Violin plots PBMC  -->



<!-- #### Collect the set of significant genes , animals, and timepoints -->



![](/Users/gfinak/Dropbox (Gottardo Lab)/GoTeam/Projects/Mario_SIV_Fluidigm/DataSubmission/BoltonSIV/inst/extdata/Logfiles/Combined_files/figure-html/figure1-1.png)<!-- -->

Differentially expressed genes (again same criteria as above) in PBMCs, for each animal.

#### plots of predicted effects and bivariate intervals for combined PBMC

Discrete and continuous point estimates and confidence ellipses, PBMCs, all animals. 


```
##       primer Animal cellgroup      muC       seC        muD       seD
##    1:   AIM2 08D108        g0 17.82768 0.7556256 -2.4110923 0.3569520
##    2:   AIM2 08D108        g1 17.96586 1.0097187 -2.2443356 0.5050283
##    3:   AIM2 08D108       g3a 19.37373 2.0091234 -2.4206055 0.9851951
##    4:   AIM2 08D108       g3b 17.16683 1.5150681 -2.7222757 0.7711352
##    5:   AIM2 08D227        g0 17.99225 0.5450073 -2.4394749 0.2807331
##   ---                                                                
## 1424:   XAF1   AY69       g3b 18.78957 0.2928639  1.7527596 0.5972963
## 1425:   XPO1   AY69        g0 18.60990 0.1701326  0.2922432 0.1372454
## 1426:   XPO1   AY69        g1 19.04123 0.3101983  0.1159890 0.2383570
## 1427:   XPO1   AY69       g3a 18.72624 0.6289541  0.2528756 0.4940894
## 1428:   XPO1   AY69       g3b 19.14357 0.4717156  1.1283013 0.4976164
```

![](/Users/gfinak/Dropbox (Gottardo Lab)/GoTeam/Projects/Mario_SIV_Fluidigm/DataSubmission/BoltonSIV/inst/extdata/Logfiles/Combined_files/figure-html/unnamed-chunk-23-1.png)<!-- -->


<!-- #### ECDF plots of DE genes for combined PBMC samples -->
<!-- These plots show another way to visualize differentially the differentially expressed genes. On the y-axis we have the proportion of cells that express a gene at or below the level given on the x-axis. Separation of the curves (different groups) indicates differences in the distribution of expression. Here I've set the lowest level to be 12 et again.  -->


### Overlap between three animals.

The Venn diagram shows the number of overlapping DE genes in PBMCs across the three animals.

![](/Users/gfinak/Dropbox (Gottardo Lab)/GoTeam/Projects/Mario_SIV_Fluidigm/DataSubmission/BoltonSIV/inst/extdata/Logfiles/Combined_files/figure-html/unnamed-chunk-25-1.png)<!-- -->

### Overlap betwen LN, PBMC, and Jejunum in AY69

Here, we show the overlapping DE genes in AY69 across the three tissues.

![](/Users/gfinak/Dropbox (Gottardo Lab)/GoTeam/Projects/Mario_SIV_Fluidigm/DataSubmission/BoltonSIV/inst/extdata/Logfiles/Combined_files/figure-html/unnamed-chunk-26-1.png)<!-- -->

### Heatmap of PBMCs from 3 animal experiment

The heatmap shows the average expression of each DE gene in each animal x  infection group.

![](/Users/gfinak/Dropbox (Gottardo Lab)/GoTeam/Projects/Mario_SIV_Fluidigm/DataSubmission/BoltonSIV/inst/extdata/Logfiles/Combined_files/figure-html/zstatistics-1.png)<!-- -->

The bar plots recapitulate what the heatmap shows. The y-axis is the Et, and the 95% confidence itnervals show the error about the estimates.

![](/Users/gfinak/Dropbox (Gottardo Lab)/GoTeam/Projects/Mario_SIV_Fluidigm/DataSubmission/BoltonSIV/inst/extdata/Logfiles/Combined_files/figure-html/unnamed-chunk-27-1.png)<!-- -->![](/Users/gfinak/Dropbox (Gottardo Lab)/GoTeam/Projects/Mario_SIV_Fluidigm/DataSubmission/BoltonSIV/inst/extdata/Logfiles/Combined_files/figure-html/unnamed-chunk-27-2.png)<!-- -->

#### PBMC

Here we show the same heatmaps and barplots for the PBMCs , Jejunum, and Lymph nodes in animal AY69.

![](/Users/gfinak/Dropbox (Gottardo Lab)/GoTeam/Projects/Mario_SIV_Fluidigm/DataSubmission/BoltonSIV/inst/extdata/Logfiles/Combined_files/figure-html/unnamed-chunk-28-1.png)<!-- -->

#### Jejunum

![](/Users/gfinak/Dropbox (Gottardo Lab)/GoTeam/Projects/Mario_SIV_Fluidigm/DataSubmission/BoltonSIV/inst/extdata/Logfiles/Combined_files/figure-html/unnamed-chunk-29-1.png)<!-- -->

#### Lymph node

![](/Users/gfinak/Dropbox (Gottardo Lab)/GoTeam/Projects/Mario_SIV_Fluidigm/DataSubmission/BoltonSIV/inst/extdata/Logfiles/Combined_files/figure-html/unnamed-chunk-30-1.png)<!-- -->

![](/Users/gfinak/Dropbox (Gottardo Lab)/GoTeam/Projects/Mario_SIV_Fluidigm/DataSubmission/BoltonSIV/inst/extdata/Logfiles/Combined_files/figure-html/unnamed-chunk-31-1.png)<!-- -->![](/Users/gfinak/Dropbox (Gottardo Lab)/GoTeam/Projects/Mario_SIV_Fluidigm/DataSubmission/BoltonSIV/inst/extdata/Logfiles/Combined_files/figure-html/unnamed-chunk-31-2.png)<!-- -->




