#' BoltonSIV
#' A data package for Bolton et al. "Single-cell quantitiation of host and SIV genes and proteins ex vivo reveals host-pathogen interactions in individual cells."
#' @docType package
#' @aliases BoltonSIV-package
#' @title Data and analysis for "Combined single-cell quantitation of host and SIV genes and proteins ex vivo reveals host-pathogen interactions in individual cells"
#' @name BoltonSIV
#' @description Analysis-ready processed data and vignettes.
#' @details Use \code{data(package='BoltonSIV')$results[, 3]} to see a list of available data sets in this data package
#'     and/or DataPackageR::load_all_datasets() to load them.
#' @seealso
#' \link{sca}
#' \link{SCA}
NULL



#' Healthy and SIV infected single-cell data from three tissues, one animal.
#' @name sca
#' @docType data
#' @title A SingleCellAssay for use with the MAST package
#' @format a \code{SingleCellAssay} containing the following fields:
#' \describe{
#' Healthy and SIV infected single-cell data from three tissues, one animal.
#' Data is processed into a SingleCellAssay for MAST (Finak et al.)
#' }
#' @source The data comes from the Bolton lab at the VRC.
#' @seealso
#' \link{BoltonSIV}
#' \link{SCA}
NULL



#'  Healthy and SIV infected single-cell data from PBMCs, three animals.
#' @name SCA
#' @docType data
#' @title Healthy and SIV infected single-cell data from PBMCs, three animals.
#' @format a \code{FluidigmAssay} containing the following fields:
#' \describe{
#' Healthy and SIV infected single-cell data from PBMCs, three animals.
#' Data is processed into a SingleCellAssay for MAST (Finak et al.)
#' }
#' @source The data comes from the Bolton lab at the VRC.
#' @seealso
#' \link{BoltonSIV}
#' \link{sca}
NULL



