# Why are biting flies attracted to blue objects?
---

This dataset accompanies the manuscript of the same name. 
The work built artificial neural network models (ANNs) to classify natural stimuli (leaves and animal pelage, in light and shade) based upon photoreceptor signals available to a fly.
The aim was to understand how a fly's photoreceptor signals could optimally be used to classify those stimuli.
After training, ANNs were challenged with photoreceptor signals caused by blue control devices, to see whether those devices were misclassified as animals, or shaded places.


## Description of the data and file structure

Here we provide raw spectra for animal reflectance, reflectance of some control devices, and irradiance. Where we used spectra from other sources, we provide directions to those sources.
Spectra were sourced from the literature cited below.
We also provide fly photoreceptor excitation values calculated based upon that information.
The latter are provided within the spreadsheet in tabs named as they are referred to in the accompanying .R file.


## Sharing/Access information

Data in the spreadsheet originate from the following sources:
  * Endler J.A. (1993) The color of light in forests and its implications. Ecological Monographs 63: 1-27.
  * Galván I. & Wakamatsu, K. (2016) Color measurement of the animal integument predicts the content of specific melanin forms. RSC Advances 6: 79135-79142. 
  * Santer R.D. et al. (2019) Optimising targets for tsetse control: taking a fly's eye view to improve the colour of synthetic fabrics. PLoS Negl. Trop. Dis. 13: e0007905.

Additional data were obtained from:
  * Arnold S.E.J. et al. (2010) FReD: The Floral reflectance database - A web portal for analyses of flower colour. PLoS ONE 5: e14287.
  * Green C.H. (1988) The effect of colour on trap- and screen-oriented responses in Glossina palpalis palpalis (Robineau-Desvoidy) (Diptera: Glossinidae). Bull. Ent. Res. 78: 591-604.
  * Green C.H. & Flint S. (1986) An analysis of colour effects in the performance of the F2 trap against Glossina pallidipes Austen and G. morsitans morsitans Westwood (Diptera: Glossididae). Bull. Ent. Res. 76: 409-418.
  * Lindh J.M. et al. (2012) Optimizing the colour and fabric of targets for the control of the tsetse fly Glossina fuscipes fuscipes. PLoS Negl. Trop. Dis. 6: e1661.
  * Santer R.D. (2017) Developing photoreceptor-based models of visual attraction in riverine tsetse, for use in the engineering of more-attractive polyester fabrics for control devices. PLoS Negl. Trop. Dis. 11: e0005448.

Links to other publicly accessible locations of the data:
  * FReD: http://www.reflectance.co.uk/
  * Santer (2017): https://journals.plos.org/plosntds/article?id=10.1371/journal.pntd.0005448
  * Lindh et al. (2012): https://journals.plos.org/plosntds/article?id=10.1371/journal.pntd.0001661


## Code/Software

Annotated R code is provide that will train and test ANNs as in the published work.
The code calls on input files that are present as tabs in the accompanying Excel sheet.
To run the code, save those tabs as individual .csv files with the same name.