function [k_rand, sigma_rand, mu_rand] = parameterBestimmen_rand(days, times, data)
%Funktion zum ermitteln einer zuflligen ber den Parametern liegenden
%berlagerung. Bei k sind die ermittelten Werte zu den "festen" Teilen zu
%addieren, bei sigma und mu sind die "festen" Teile mit den ermittelten
%Werten zu multiplizieren!

%bergebene Daten anders ablegen
k_verteilung_abw = data.k_verteilung_abw;
sigma_verteilung_abw_rel = data.sigma_verteilung_abw_rel;
mu_verteilung_abw_rel = data.mu_verteilung_abw_rel2;

%Achtung: ist auf Verteilungsfunktionen mit 3
%Parametern angepasst (gen. Extremwertfkt.). Bei abweichender 
%Parameteranzahl Funktion entsprechend anpassen!
%Zur Sicherheit Anzahl der Parameter berprfen
if length(k_verteilung_abw.Params)~=3 || length(sigma_verteilung_abw_rel.Params)~=3 || length(mu_verteilung_abw_rel.Params)~=3
    error('Anzahl der Parameter passt nicht. parameterBestimmen_rand.m anpassen oder Verteilungsfunktion berprfen')
end
%Zufallswerte erzeugen und sortieren
k_vals = random(k_verteilung_abw.DistName, k_verteilung_abw.Params(1), ...
    k_verteilung_abw.Params(2), k_verteilung_abw.Params(3), ...
    [length(days)*length(times),1]);
k_vals = sort(k_vals);
sigma_vals = random(sigma_verteilung_abw_rel.DistName, ...
    sigma_verteilung_abw_rel.Params(1), sigma_verteilung_abw_rel.Params(2), ...
    sigma_verteilung_abw_rel.Params(3), [length(days)*length(times),1]);
sigma_vals = sort(sigma_vals);
mu_vals = random(mu_verteilung_abw_rel.DistName, ...
    mu_verteilung_abw_rel.Params(1), mu_verteilung_abw_rel.Params(2), ...
    mu_verteilung_abw_rel.Params(3), [length(days)*length(times),1]);
mu_vals = sort(mu_vals);

%zufllige Teile der Parameter jeweils sinnvoll einander zuordnen
%(Korrelationen vorhanden und Wechsel nicht rein zufllig!)
%Modellierung ber Markovkette mit hinterlegter (kumulierter und 
%komprimierter) bergangsmatrix (und den zugehrigen Spalten der
%unkomprimierten Version. Siehe "UebergangsmatrParamErzeugen.m"
uebergangsmatr_kompr_kum = data.parameter_rand_uebergaenge_kompr_kum;
uebergangsmatr_kompr_pos = data.parameter_rand_uebergaenge_kompr_pos;

%Zufallswerte erstellen
zufallsmatrix = rand(length(days),length(times));
%Anzahl der verwendeten Gruppen feststellen (Einzelne Werte werden ihrer 
%Gre nach in Gruppen eingeteilt)
nGroups = nthroot(length(uebergangsmatr_kompr_kum), 3);
%Hinweis:
%jeder mglichen Kombination von Parametergruppen wird eine Zeile/Spalte in
%der bergangsmatrix zugewiesen. Die Zeile entspricht dem Ausgangswert, die
%Spalte dem Endwert (bzw. der Wahrscheinlichkeit, dahin zu gelangen)
%In der komprimierten Form sind die ursprnglichen Spalten in
%uebergangsmatr_kompr_pos hinterlegt
%Zuordnung der Zeilen Spalten: k-Gruppe + (sigma-Gruppe-1)*Gruppenanzahl +
%(mu-Gruppe-1)*Gruppenanzahl^2

%Startwert so bestimmen, dass entsprechende Zeile in bergangsmatrix nicht
%Null ist (sonst knnte kein nachfolgender Wert bestimmt werden)
while 1
    val = ceil(rand*nGroups) + floor(rand*nGroups)*nGroups + ...
        floor(rand*nGroups)*nGroups^2;
    if sum(uebergangsmatr_kompr_kum(val,:))~=0 %wenn Zeile nicht 0
        break
    end
end

%Gruppen fr alle Zeitpunkte bestimmen
groups_all = nan(length(days),length(times));
for z=1:length(days)
    for s=1:length(times)
       groups_all(z,s) = val; %letzen ermittelten Wert Eintragen
       %nachfolgenden Wert ermitteln (in der Zufallsmatrix sind Werte
       %zwischen 0 und 1 enthalten. Die kumulierte Wahrscheinlichkeit fr
       %den jeweiligen bergangs zum nchsten Wert muss grer sein als
       %der jeweilige Zufallswert.
       dmy = zufallsmatrix(z,s);
       %dmy_line = uebergangsmatr_kum(val,:);
       idx = find(uebergangsmatr_kompr_kum(val,:)>dmy, 1, 'first');
       val = uebergangsmatr_kompr_pos(val,idx);
     end
end

%aus "Gesamtgruppe" die Gruppen der einzelnen Parameter berechnen
groups_k = nan(length(days),length(times));
groups_sigma = nan(length(days),length(times));
groups_mu = nan(length(days),length(times));
for z=1:length(days)
    for s=1:length(times)
        temp_rest = groups_all(z,s);
        temp_mu = ceil(temp_rest/nGroups^2);
        temp_rest = temp_rest - (temp_mu-1)*nGroups^2;
        temp_sigma = ceil(temp_rest/nGroups);
        groups_k(z,s) = temp_rest - (temp_sigma-1)*nGroups;
        groups_sigma(z,s) = temp_sigma;
        groups_mu(z,s) = temp_mu;
    end
end

%Indizes der jeweiligen Gruppen finden und (nach Gruppen) aufsteigend ordnen
ind_k = zeros(0,1);
ind_sigma = zeros(0,1);
ind_mu = zeros(0,1);
for n=1:nGroups
    %Indizes der aktuellen Gruppe bestimmen
    temp_ind_k = find(groups_k==n);
    temp_ind_sigma = find(groups_sigma==n);
    temp_ind_mu = find(groups_mu==n);
    %In zweiter Spalte zufllige Permutation von 1 bis length(temp_ind_..)
    %einfgen
    temp_ind_k(:,2) = randperm(length(temp_ind_k))';
    temp_ind_sigma(:,2) = randperm(length(temp_ind_sigma))';
    temp_ind_mu(:,2) = randperm(length(temp_ind_mu))';
    %Nach zweiter Spalte aufsteigend sortieren (also insgesamt: gefundene
    %Indizes zufllig sortieren, damit nicht im Zeitverlauf monoton
    %ansteigende Werte fr gleiche Gruppen)
    temp_ind_k = sortrows(temp_ind_k,2);
    temp_ind_sigma = sortrows(temp_ind_sigma,2);
    temp_ind_mu = sortrows(temp_ind_mu,2);
    %Indizes der aktuellen Gruppe an bisherige anhngen
    ind_k = [ind_k; temp_ind_k(:,1)]; %Hinweis ist egal, schnell genug
    ind_sigma = [ind_sigma; temp_ind_sigma(:,1)];
    ind_mu = [ind_mu; temp_ind_mu(:,1)];       
end
%Lnge von ind_.. ist insgesamt length(times)*length(days)
k_rand = nan(length(days),length(times));
sigma_rand = nan(length(days),length(times));
mu_rand = nan(length(days),length(times));
%anfangs ermittelte und sortierte Parameterwerte gem ermittelten Indizes
%zuordnen
for n=1:length(times)*length(days)
    k_rand(ind_k(n)) = k_vals(n);
    sigma_rand(ind_sigma(n)) = sigma_vals(n);
    mu_rand(ind_mu(n)) = mu_vals(n);
end
      
end

