function [k_base, sigma_base, mu_base] = parameterBestimmen_base(days,times,data,tagtyp,Pmean)
%Bestimmt den festen Anteil an den Parametern der Verteilungsfunktionen der
%Leistungen. (Also den Teil ohne berlagerte statistische Verteilungen.)

k_base = nan(length(days),length(times));
sigma_base = nan(length(days),length(times));
mu_base = nan(length(days),length(times));

%Anzahl der jeweiligen Tage bestimmen
n_werktage = 0;
n_samstage = 0;
n_sonntage = 0;
for i=days
    switch tagtyp(i)
        case 1 %Werktag
            n_werktage = n_werktage + 1;
        case 2 %Samstag
            n_samstage = n_samstage + 1;
        case 3 %Sonntag
            n_sonntage = n_sonntage + 1;
    end
end
%Dimensionen der Wertetabellen erfassen
[xwe,ywe] = size(data.k_werktage_wertetabelle);
[xsa,ysa] = size(data.k_samstage_wertetabelle);
[xso,yso] = size(data.k_sonntage_wertetabelle);

%Prfen, ob 96 Werte pro Tag in Wertetabellen hinterlegt
if ~(ywe==96 && ysa==96 && yso==96)
    error('Falsche Anzahl an Zeitpunkte pro Tag in Wertetabellen (~=96).')
end

%Counter, mit denen der aktuelle Tag im Verhltnis zu anderen Tagen
%gleichen Typs im Jahr eingeordnet werden kann
ctr_werktage = 0;
ctr_samstage = 0;
ctr_sonntage = 0;
%Fr jeden Tag entsprechende Parameter bestimmen. Der entsprechende Tag in
%der Wertetabelle wird bestimmt, indem die relative Position des aktuellen
%Tags im Verhltnis zu allen Tagen bestimmt wird. Der entsprechende Wert
%aus der Tabelle wird dann ber neighbour-Interpolation bestimmt.
%Dabei kommt es zwangslufig zu Abweichungen, welche jedoch aufgrund der
%verhltnismig kleinen jahreszeitlichen nderungen in Kauf genommen
%werden.
ctr_day = 0;
for z=days
    ctr_day = ctr_day + 1;
    %je nach Tagtyp Funktion zum Bestimmen der Parameter fr alle
    %gewnschten Zeitpunkte des Tages aufrufen und jeweils passende Daten
    %bergeben
    switch tagtyp(z)
        case 1 %Werktag
            ctr_werktage = ctr_werktage + 1;
            line = ceil(ctr_werktage / n_werktage * xwe);%TODO:nochmal berlegen
            [k_base(ctr_day,:), sigma_base(ctr_day,:), mu_base(ctr_day,:)] = ...
                parameterBestimmen_baseTag(data.k_werktage_wertetabelle(line,:), ...
                data.sigma_werktage_wertetabelle(line,:), data.mu_const_werktage(line,:), ...
                data.mu_var_werktage,times,Pmean(ctr_day,:));
        case 2 %Samstag
            ctr_samstage = ctr_samstage + 1;
            line = ceil(ctr_samstage / n_samstage * xsa);
            [k_base(ctr_day,:), sigma_base(ctr_day,:), mu_base(ctr_day,:)] = ...
                parameterBestimmen_baseTag(data.k_samstage_wertetabelle(line,:), ...
                data.sigma_samstage_wertetabelle(line,:), data.mu_const_samstage(line,:), ...
                data.mu_var_samstage,times,Pmean(ctr_day,:));
        case 3 %Sonntag
            ctr_sonntage = ctr_sonntage + 1;
            line = ceil(ctr_sonntage / n_sonntage * xso);
            [k_base(ctr_day,:), sigma_base(ctr_day,:), mu_base(ctr_day,:)] = ...
                parameterBestimmen_baseTag(data.k_sonntage_wertetabelle(line,:), ...
                data.sigma_sonntage_wertetabelle(line,:), data.mu_const_sonntage(line,:), ...
                data.mu_var_sonntage,times,Pmean(ctr_day,:)); %Hinweis zeit_umger: zum jeweiligen Zeitpunkt passende Zeile wird bergeben, siehe Readme
    end
end
    
end

function [ks_base_line, sigma_base_line, mu_base_line] = ...
    parameterBestimmen_baseTag(k_line, sigma_line, mu_const_line, mu_var, times, Pmean_line)
%Fr k-Werte ist die Leistung egal, sie knnen direkt aus der Tabelle
%bernommen werden
ks_base_line = interp1(k_line, times);
%sigma-Werte mssen mit der jeweiligen Leistung multipliziert werden
sigma_base_line = interp1(sigma_line, times) .* Pmean_line;
%mu-Werte setzen sich aus festem und Leistungsabh Teil zusammen
mu_base_line = interp1(mu_const_line, times) + interp1(mu_var, times) .* Pmean_line;
end